<div class="github-widget" data-repo="Zheaoli/awesome-coins"></div>
## ₿ Awesome Crypto Currency Tools & Algorithms

[![GitHub stars](https://img.shields.io/github/stars/kennethreitz/awesome-coins.svg?style=social&label=Star)](https://github.com/kennethreitz/awesome-coins)
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Say Thanks!](https://img.shields.io/badge/SayThanks-!-1EAEDB.svg)](https://saythanks.io/to/kennethreitz)

维基百科，自由的百科全书
&gt; 一个 [cryptocurrency](https://en.m.wikipedia.org/wiki/Cryptocurrency) 是一种数字资产，旨在用作交换媒介，使用密码学来保护交易并控制额外货币单位的创建.

许多算法用于不同的加密货币. 本文档参考了加密货币中使用的算法，并提供了一个很好的用于管理硬币的有用服务和实用程序列表.

## So, Before We Begin…

如果您不熟悉算法和数据结构，这些“硬币”的东西可能会让人感到困惑. 让我解释一下我目前所知道的——

有很多很多 [coins](http://coinbin.org/coins) . 人们喜欢 [trade](https://www.cryptopia.co.nz/Register?referrer=kennethreitz) 它们，与股票或神奇宝贝卡不同. 人也 [mine](https://www.nicehash.com/?refby=386829) 他们，使用他们的家用电脑或专用硬件.

硬币存储在钱包中，这些钱包可以在线、本地计算机或一张纸上托管.

自己挖币很难，就像赌博一样，所以人们通常选择加入矿池（通常使用 stratum 协议来协调）——这会奖励你的工作，即使你没有找到任何东西，因为你帮助成千上万的其他人做出了贡献，其中一些人确实找到了障碍. 然后根据池的规则拆分这些块.

Some people [rent hashing power](https://www.nicehash.com/?refby=386829) 来自农场，或者玩“区块链彩票”，试图自己找到硬币块，或者他们将农场指向一个池，就像一个典型的家庭矿工——除了他们拥有非常高的可用计算能力，如果他们愿意为此付出代价.

希望这有助于解决问题.

## ☤ Support Causes You Care About

- [Wikileaks](https://wikileaks.org) **比特币**：`1HB5XMLmzFVj8ALj6mfBsbifRoD4miY36v`
- [Internet Archive](https://archive.org) **比特币**：`1Archive1n2C579dMsAu3iC6tWzuQJz8dN`
- [The Pirate Bay](https://thepiratebay.org) **比特币**：`129TQVAroeehD9fZpzK51NdZGQT4TqifbG`
- [xkcd](https://xkcd.com) **比特币**：`14Tr4HaKkKuC1Lmpr2YMAuYVZRWqAdRTcr`
- [this repo](https://github.com/kennethreitz/awesome-coins) **比特币**：`1Me2iXTJ91FYZhrGvaGaRDCBtnZ4KdxCug`

## ☤ Coin Market Tools & Utilities

- **[Coinbin.org](http://coinbin.org)** — 用于快速获取代币数据（汇率、预测等）的人性化 API
    * [List of All Known Coins](http://coinbin.org/coins) `/硬币`
    * [BTC Current Value](http://coinbin.org/btc) `/比特币`
    * [BTC Daily Historical Value](http://coinbin.org/btc/history) `/比特币/历史`
    * [BTC / ETH Exchange Rate](http://coinbin.org/btc/to/eth) `/btc/to/eth`
    * [20.01 BTC Value](http://coinbin.org/btc/20.01) `/btc/20.01`
    * [42 ETH Value in BTC](http://coinbin.org/eth/42/to/btc) `/eth/42/to/btc`
    * 支持所有加密货币.
- [CoinMarketCap](https://coinmarketcap.com) — 在实时仪表板上显示所有货币.
- ~~[CoinScanner.co](https://coinscanner.co/) — 为您提供从一种加密货币到另一种加密货币的多条贸易路线.~~
- [The Coin Perspective](https://thecoinperspective.com) — 帮助您正确看待不同的硬币，比较市值、供应和价格.

## ☤ Reading Material

- [Overview of Cryptocurrencies](https://github.com/kilimchoi/cryptocurrency) ——GitHub 回购.
- [Map of Coins](http://mapofcoins.com) – 探索加密货币的可视化历史，从它们的白皮书到现在.
- [A massive collection of white papers](http://diyhpl.us/~bryan/papers2/bitcoin/)
- [Mastering Bitcoin](https://github.com/bitcoinbook/bitcoinbook) （电子书）
- [Binance Academy](https://www.binance.vision) — 币安提供的开放获取教育.
- [Bitcoin Developer Reference](https://bitcoin.org/en/developer-reference)
- [Blockchain for humans](https://github.com/anderson-joyle/blockchain-for-humans) — 超简化的区块链解释（建设中）.
- [r/CryptoCurrency](https://www.reddit.com/r/CryptoCurrency/) — 关于加密货币和加密资产的官方 subreddit.
- [Golden Cryptocurrency and Blockchain Cluster](https://golden.com/wiki/Cluster%3A_Blockchain_%26_cryptocurrency) - 一组关于加密货币和区块链的主题页面.
- 出版物
    * [Cryptoeconomics](https://medium.com/@cryptoeconomics) / cryptoeconomics.com.au 的团队
    * [Minessence](https://vinnylingham.com/) / Civic.com 联合创始人兼首席执行官 Vinny Lingham
    * [CryptoOracle](https://medium.com/crypto-oracle) /卢克纳
    * [CryptoCurrencyHub](https://cryptocurrencyhub.io/)
    * [Build Blockchain](https://www.buildblockchain.tech/newsletter/issues/)
    *哈克农
      * [Blockchain](https://hackernoon.com/blockchain/home)
      * [Bitcoin](https://hackernoon.com/bitcoin/home)
      * [Coin & Crypto](https://medium.com/@coinandcrypto) 
      * [Daniel Jeffries](https://hackernoon.com/@dan.jeffries)

## ☤ Coin Mining Pools

这是一个清单 [WhatToMine](https://whattomine.com).

- **#**: [https://www.nicehash.com/](https://www.nicehash.com/?refby=386829) — 挖掘任何算法（针对您的 GPU 进行优化）并以 **BTC** 获得报酬.
- **比特币**：https://pool.bitcoin.com/
- **ETH**：https://eth.nanopool.org/
- **SC**：https://sia.nanopool.org/
- **PASC**：https://pasc.nanopool.org/
- **XMR**：https://xmr.nanopool.org/
- **ZEC**：https://zec.nanopool.org/
- **ETC**：https://etc.nanopool.org/
- **ZCL**：https://2miners.com/zcl-mining-pool
- **ZEN**：https://2miners.com/zen-mining-pool
- **ZEC**：https://2miners.com/zec-mining-pool

## ☤ Hashing Power for Rent

- [NiceHash](https://www.nicehash.com/?refby=386829) — 支持所有流行的算法，以 **BTC** 支付原始吞吐量.
- [Bitcoin.com Pool](https://pool.bitcoin.com/index_en.html) ——我听说过好事.
- [BitMain Hosted](https://bitmainwarranty.com/product-category/hosting/) — 看起来复杂而粗略，但他们提供托管 ASIC 解决方案.

## ☤ Coin Wallets

### Hosted Coin Wallets

**注意：** 硬币社区不赞成使用这些服务，因为你不能直接控制你的硬币——事实上，你根本不拥有它们——这项服务确实如此——很像标准银行的方式运作.

- [Coinbase **BTC**](https://www.coinbase.com/join/516f7e9a929bda3e06000001)
- [Coinbase **ETH**](https://www.coinbase.com/join/516f7e9a929bda3e06000001)
- [Coinbase **LTC**](https://www.coinbase.com/join/516f7e9a929bda3e06000001)

实际托管的硬币钱包：

- [MyEtherWallet **ETH**](https://www.myetherwallet.com/)
- [Tokenary **ETH&ERC20 Tokens**](https://www.tokenary.io/)
- [Dogechain **DOGE**](https://my.dogechain.info/#/wallet)
- [Gamecredits **GAME**](https://wallet.gamecredits.com/dashboard/myWallet)
- [Glif **FIL**](https://github.com/openworklabs/filecoin-web-wallet)

### Coin Debit Cards

- [Cryptopay **BTC** Debit Card](https://cryptopay.me/join/03db9c17)

### Physical Coin Wallets

- [**Sia** Paper Wallet](https://siapaperwallet.co)
- [WalletGenerator.net](https://walletgenerator.net)
- [Cryptosteel](https://cryptosteel.com) — 钢制！

## ☤ Coin Exchanges

- [Binance](https://www.binance.com) ——交换世界. 
- [Cryptopia](https://www.cryptopia.co.nz/Register?referrer=kennethreitz) — 所有货币的钱包，与所有货币交易.
- [Shapeshift](https://shapeshift.io/#/coins) — 地球上最快的交换.
- [Bittrex](https://bittrex.com) — 所有货币的钱包，与所有货币交易.
- [Qvolta](https://qvolta.com) — 使用本地支付方式在世界各地买卖加密资产.
- [InstaEx](https://instaex.io) - 即时加密货币兑换.
- [ExchangeRates.Pro](https://exchangerates.pro) — 全球交易所的价格比较，包括 P2P 市场.


## ☤ Universal GUI Apps

- [**Sia** UI](http://sia.tech/apps/) — SC 钱包、文件托管、存储.
- [**LBRY**](https://lbry.io) — LBRY 钱包，媒体消费和发布平台.
- [**DeBank**](https://debank.com/) - DeFi 钱包，查看以太坊 DeFi 项目中的资产和债务.

## ☤ Windows GUI Apps

- [NiceHash Miner](https://miner.nicehash.com/?refby=386829)  — 将您的 GPU/CPU 转售给矿工以获取利润！ 针对您的硬件对所有算法进行基准测试，并自动选择最有利可图的配置（可调整）.

[![](https://miner.nicehash.com/images/landing-pages/nhm/nhm2.svg)](https://miner.nicehash.com/?refby=386829)
- [MinerGate](https://minergate.com) - 开采最赚钱的加密货币.

## ☤ MacOS GUI Apps

- [MacMiner](http://macminer.fabulouspanda.com/macminer/) — 在 GUI 中包装 bfgminer、cgminer 和 sgminer.

## ☤ MacOS CLI Apps

- [bfgminer](http://macminer.fabulouspanda.com/commandline/) — 用 C 编写的模块化 ASIC/FPGA 矿工，具有超频、监控、风扇速度控制和远程接口功能.
- [cgminer](http://macminer.fabulouspanda.com/commandline/) — 用于比特币的 C 语言 ASIC 和 FPGA 矿工.
- [sgminer](http://macminer.fabulouspanda.com/commandline/) — Scrypt GPU 矿工.
- [nheqminer](https://github.com/kozyilmaz/nheqminer-macos) — Equihash CPU 和 GPU 矿工.

## ☤ Recommended Hardware

- [NVidia GTX 1080 TI OC](http://amzn.to/2wl1c9j) — 世界上最强大的消费类显卡.
- [Asrock H110 Pro BTC+ Mining Motherboard](http://amzn.to/2xadkYk) — 显然可以托管 12 个 PCI-E GPU.

## ☤ Cool Coin/Blockchain Stuff

- [Bit](https://github.com/ofek/bit) — Python 最快的比特币库，带有允许交易的 API
  只需 3 行代码即可完成.
- [bcoin](http://bcoin.io) — 完全用 Node.js 编写的比特币全节点实现，您甚至可以在浏览器中运行，包括钱包、内存池、链和挖矿. 
- [**BTC** Mempol and Fee Explorer](https://core.jochen-hoenicke.de/queue/#4d)
- [Tezos](https://www.tezos.com) — 自我修复的区块链.
- [Tendermint](https://tendermint.com) — 任何编程语言的拜占庭容错复制状态机.
- [Cosmos](https://cosmos.network) — 网络和区块链之间互操作性的框架.
- [URI scheme for Blockchain exploration](https://lists.linuxfoundation.org/pipermail/bitcoin-dev/2015-August/010712.html)
- [Blockply](https://blockply.com/) — 最有趣最优秀的区块链项目合集
- [Blockchain demo](https://github.com/anders94/blockchain-demo) — 基于 Web 的区块链概念演示.

## ☤ Algos supported by [NiceHash Stratum Proxy](https://www.nicehash.com/?refby=386829)

-`Scrypt`（莱特币 / **[LTC](http://coinbin.org/ltc)**)
-`SHA256`（比特币/**[BTC](http://coinbin.org/btc)**)
- `ScryptNF` (Scrypt-Adaptive-Nfactor)（GPU 硬币，**GPUC**）
- `X11`（Dash / Darkcoin，Dashcoin，ASIC-Resistant）
- `X13` (MaruCoin / **MARU**) (CPU/GPU)
- `Keccak` (MaxCoin / **MAX**)
- `X15`（HTML5 硬币，**HTML5**）
- `Nist5`（Talkcoin，**TAC**）
-`NeoScrypt`（Phoenixcoin (**PXC**)、Imperialcoin (**IPC**)、Feathercoin (**FTC**)、UFOcoin (**UFO**)、Guncoin (**GUN**)、宝莱坞币 (**BDC**)、轨道币 (**ORB**)、Halcyon (**HAL**))
- `Lyra2RE` (VertCoin / **VTC**, CryptoCoin)
- `WhirlpoolX`（香草币 / **VNL**）
- `Qubit` (QubitCoin / **Q2C**)
- `夸克` (**QRK**)
- `Axiom` (Axiom Coin / **AXIOM**)
- `Lyra2REv2` (VertCoin / **VTC**)
- `ScryptJaneNf16`（钻石/**DMD**）
- `Blake256r8`（布雷克币 / **BLC**）
- `Blake256r14`（布雷克币 / **BLC**）
- `Blake256r8vnl`（布雷克币 / **BLC**）
- `Hodl` (HodlCoin / **HODL**)
- `DaggerHashimoto`（以太坊 / **ETH**）
- `Decred` (**DCR**)
- `CryptoNight`（**XCN**，仅限 CPU）
- `Lbry` (**LBC**)
- `Equihash`（Zcash / **XEC**、ZClassic、**HUSH**、Komodo）
- `帕斯卡&#39; (**PASC**)
- `X11Gost` (SIBCoin / **SIB**)
- `两者` (**SC**)
-`Blake2`s（NevaCoin、Netko Coin、Verge、TajCoin）
- `臭鼬`（Signatum Coin / **SIGT**）

[(others)](https://github.com/kennethreitz/awesome-coins/blob/master/other.md)

## ☤ Every Active Coin, Ranked

截至 2017-08-23：

[btc](https://coinbin.org/btc)
[eth](https://coinbin.org/eth)
[xrp](https://coinbin.org/xrp)
[ltc](https://coinbin.org/ltc)
[etc](https://coinbin.org/etc)
[xem](https://coinbin.org/xem)
[miota](https://coinbin.org/miota)
[dash](https://coinbin.org/dash)
[bts](https://coinbin.org/bts)
[strat](https://coinbin.org/strat)
[xmr](https://coinbin.org/xmr)
[zec](https://coinbin.org/zec)
[gnt](https://coinbin.org/gnt)
[bcn](https://coinbin.org/bcn)
[waves](https://coinbin.org/waves)
[steem](https://coinbin.org/steem)
[sc](https://coinbin.org/sc)
[icn](https://coinbin.org/icn)
[xlm](https://coinbin.org/xlm)
[bcc](https://coinbin.org/bcc)
[lsk](https://coinbin.org/lsk)
[doge](https://coinbin.org/doge)
[rep](https://coinbin.org/rep)
[ans](https://coinbin.org/ans)
[fct](https://coinbin.org/fct)
[game](https://coinbin.org/game)
[ardr](https://coinbin.org/ardr)
[gno](https://coinbin.org/gno)
[maid](https://coinbin.org/maid)
[dgb](https://coinbin.org/dgb)
[dcr](https://coinbin.org/dcr)
[kmd](https://coinbin.org/kmd)
[gbyte](https://coinbin.org/gbyte)
[bat](https://coinbin.org/bat)
[nxt](https://coinbin.org/nxt)
[dgd](https://coinbin.org/dgd)
[1st](https://coinbin.org/1st)
[veri](https://coinbin.org/veri)
[mgo](https://coinbin.org/mgo)
[usdt](https://coinbin.org/usdt)
[sngls](https://coinbin.org/sngls)
[nmr](https://coinbin.org/nmr)
[sys](https://coinbin.org/sys)
[btcd](https://coinbin.org/btcd)
[pivx](https://coinbin.org/pivx)
[ant](https://coinbin.org/ant)
[ubq](https://coinbin.org/ubq)
[mcap](https://coinbin.org/mcap)
[emc](https://coinbin.org/emc)
[ppc](https://coinbin.org/ppc)
[ppy](https://coinbin.org/ppy)
[ark](https://coinbin.org/ark)
[round](https://coinbin.org/round)
[lkk](https://coinbin.org/lkk)
[rlc](https://coinbin.org/rlc)
[rdd](https://coinbin.org/rdd)
[sjcx](https://coinbin.org/sjcx)
[qrl](https://coinbin.org/qrl)
[mln](https://coinbin.org/mln)
[xas](https://coinbin.org/xas)
[lbc](https://coinbin.org/lbc)
[amp](https://coinbin.org/amp)
[wings](https://coinbin.org/wings)
[nxs](https://coinbin.org/nxs)
[leo](https://coinbin.org/leo)
[nmc](https://coinbin.org/nmc)
[xcp](https://coinbin.org/xcp)
[xvg](https://coinbin.org/xvg)
[bay](https://coinbin.org/bay)
[edg](https://coinbin.org/edg)
[blk](https://coinbin.org/blk)
[omni](https://coinbin.org/omni)
[myst](https://coinbin.org/myst)
[xzc](https://coinbin.org/xzc)
[nlg](https://coinbin.org/nlg)
[via](https://coinbin.org/via)
[burst](https://coinbin.org/burst)
[cfi](https://coinbin.org/cfi)
[vtc](https://coinbin.org/vtc)
[cloak](https://coinbin.org/cloak)
[mona](https://coinbin.org/mona)
[xaur](https://coinbin.org/xaur)
[eac](https://coinbin.org/eac)
[dice](https://coinbin.org/dice)
[grc](https://coinbin.org/grc)
[ybc](https://coinbin.org/ybc)
[block](https://coinbin.org/block)
[obits](https://coinbin.org/obits)
[nav](https://coinbin.org/nav)
[vsl](https://coinbin.org/vsl)
[trst](https://coinbin.org/trst)
[pot](https://coinbin.org/pot)
[hmq](https://coinbin.org/hmq)
[exp](https://coinbin.org/exp)
[gup](https://coinbin.org/gup)
[tkn](https://coinbin.org/tkn)
[bash](https://coinbin.org/bash)
[xdn](https://coinbin.org/xdn)
[edr](https://coinbin.org/edr)
[ioc](https://coinbin.org/ioc)
[enrg](https://coinbin.org/enrg)
[rads](https://coinbin.org/rads)
[note](https://coinbin.org/note)
[nxc](https://coinbin.org/nxc)
[shift](https://coinbin.org/shift)
[moon](https://coinbin.org/moon)
[wdc](https://coinbin.org/wdc)
[unity](https://coinbin.org/unity)
[xel](https://coinbin.org/xel)
[qau](https://coinbin.org/qau)
[taas](https://coinbin.org/taas)
[bnt](https://coinbin.org/bnt)
[xbc](https://coinbin.org/xbc)
[sky](https://coinbin.org/sky)
[ion](https://coinbin.org/ion)
[snt](https://coinbin.org/snt)
[agrs](https://coinbin.org/agrs)
[neos](https://coinbin.org/neos)
[qrk](https://coinbin.org/qrk)
[zrc](https://coinbin.org/zrc)
[vrc](https://coinbin.org/vrc)
[dbix](https://coinbin.org/dbix)
[storj](https://coinbin.org/storj)
[fun](https://coinbin.org/fun)
[eos](https://coinbin.org/eos)
[sls](https://coinbin.org/sls)
[mco](https://coinbin.org/mco)
[soar](https://coinbin.org/soar)
[swt](https://coinbin.org/swt)
[dbic](https://coinbin.org/dbic)
[dct](https://coinbin.org/dct)
[adt](https://coinbin.org/adt)
[sib](https://coinbin.org/sib)
[pay](https://coinbin.org/pay)
[draco](https://coinbin.org/draco)
[chc](https://coinbin.org/chc)
[mtl](https://coinbin.org/mtl)
[fair](https://coinbin.org/fair)
[uny](https://coinbin.org/uny)
[plu](https://coinbin.org/plu)
[daxx](https://coinbin.org/daxx)
[qtum](https://coinbin.org/qtum)
[san](https://coinbin.org/san)
[grs](https://coinbin.org/grs)
[ppt](https://coinbin.org/ppt)
[crw](https://coinbin.org/crw)
[wbb](https://coinbin.org/wbb)
[mue](https://coinbin.org/mue)
[safex](https://coinbin.org/safex)
[ter](https://coinbin.org/ter)
[omg](https://coinbin.org/omg)
[plbt](https://coinbin.org/plbt)
[net](https://coinbin.org/net)
[cvc](https://coinbin.org/cvc)
[xrl](https://coinbin.org/xrl)
[bdl](https://coinbin.org/bdl)
[b@](https://coinbin.org/b@)
[part](https://coinbin.org/part)
[coe](https://coinbin.org/coe)
[skin](https://coinbin.org/skin)
[plr](https://coinbin.org/plr)
[nvc](https://coinbin.org/nvc)
[etp](https://coinbin.org/etp)
[anc](https://coinbin.org/anc)
[bch](https://coinbin.org/bch)
[cmp](https://coinbin.org/cmp)
[mny](https://coinbin.org/mny)
[stx](https://coinbin.org/stx)
[ico](https://coinbin.org/ico)
[neo](https://coinbin.org/neo)
[dtb](https://coinbin.org/dtb)
[nlc2](https://coinbin.org/nlc2)
[gas](https://coinbin.org/gas)
[btm](https://coinbin.org/btm)
[bnb](https://coinbin.org/bnb)
[dnt](https://coinbin.org/dnt)
[bqx](https://coinbin.org/bqx)
[adx](https://coinbin.org/adx)
[lun](https://coinbin.org/lun)
[frst](https://coinbin.org/frst)
[tix](https://coinbin.org/tix)
[dent](https://coinbin.org/dent)
[snm](https://coinbin.org/snm)
[eb3](https://coinbin.org/eb3)
[zrx](https://coinbin.org/zrx)
[oax](https://coinbin.org/oax)
[ixt](https://coinbin.org/ixt)
[tcc](https://coinbin.org/tcc)
[cat](https://coinbin.org/cat)

----------------------------------


## Find this useful?

如果您想为我在开源世界的努力捐款，您可以使用以下钱包地址，我们将不胜感激任何贡献（无论多小）.

- **[BTC](http://coinbin.org/btc)**：`1Me2iXTJ91FYZhrGvaGaRDCBtnZ4KdxCug`
- **[ETH](http://coinbin.org/eth)**：`0x1321Ec9c7550a7c44ef3e583930556c6557411d1`
- **[LTC](http://coinbin.org/ltc)**:`Lbyje2eiSMPfE1Ux6BYJuzN9CS7Nj78Hpu`
- **[LBC](http://coinbin.org/lbc)**:`bYDCRLb2Pcp1V25sRZs1LJkVnaddsNVCAQ`
- **[SC](http://coinbin.org/sc)**：`f23294ad70d2315f68a3265331508a44cd5363b8365f4ece91efd2365548b8f0760d34a8f884`

Or, [Say Thanks!](http://saythanks.io/to/kennethreitz)

✨🍰✨
