<div class="github-widget" data-repo="hantuzun/awesome-clojurescript"></div>

<img src="https://avatars2.githubusercontent.com/u/12118456?v=3&s=75"
     对齐=“右”/&gt;

## Awesome ClojureScript

##### A community driven list of ClojureScript books, frameworks, libraries and wrappers.

* * *



* * *


## Resources


### Books
- [ClojureScript Unraveled](https://leanpub.com/clojurescript-unraveled) – 一本关于 ClojureScript 语言的开源书籍，涵盖了所有语言特性、如何使用编译器以及构建应用程序和库的工具.
- [ClojureScript Unraveled (2nd edition)](https://funcool.github.io/clojurescript-unraveled/) – 一本关于 ClojureScript 语言的开源书籍，涵盖了所有语言特性、如何使用编译器以及构建应用程序和库的工具.
- [ClojureScript: Up and Running](https://shop.oreilly.com/product/0636920025139.do) – 由 Clojure Stuart Sierra 和 Luke VanderHart 的大佬编写的 ClojureScript 简介.
- [Clojure, The Essential Reference](https://www.manning.com/books/clojure-the-essential-reference) – 关于 Clojure 语言和标准库的参考书.
- [Etudes for ClojureScript](https://shop.oreilly.com/product/0636920043584.do) – 一本包含 30 个介绍 ClojureScript 的配套练习或练习的实践书.
- [Learning ClojureScript](https://www.packtpub.com/web-development/learning-clojurescript) – 掌握使用 ClojureScript 进行敏捷单页 Web 应用程序开发的艺术.
- [Transforming Data with ClojureScript](https://langintro.com/cljsbook) – 带有交互式示例和练习的 ClojureScript 初学者指南，“专注于编程的主要任务——转换数据”.



### Courses
- [ClojureScript Koans](http://clojurescriptkoans.com/) – 通过交互式挑战在 Web 上开始学习 Clojure 和 ClojureScript 的好方法.
- [Lambda Island](https://lambdaisland.com/) – 全栈网络开发课程，包括 ClojureScript 前端、Clojure 后端、语言基础、安全性、互联网标准和系统管理.
- [Learn Reagent](https://www.learnreagent.com/)  – 为开发人员介绍带有 Reagent 的 ClojureScript. 提供 1 小时的免费内容. [learn re-frame](https://www.learnreframe.com/) 是它的后续行动.
- [Learning ClojureScript](https://purelyfunctional.tv/)  – O&#39;Really Online Learning 对 Clojurescript 的 2 小时 11 米长介绍. 也可在 [Udemy](https://www.udemy.com/course/learning-clojurescript/).


### Videos
- [ClojureScript for Skeptics](https://www.youtube.com/watch?v=gsffg5xxFQI) – Derek Slager 在 Clojure Conj 2015 上的演讲 讨论了为什么 ClojureScript 实际上是一种非常实用的 Web 开发语言的原因.
- [Interactive programming Flappy Bird in ClojureScript](https://www.youtube.com/watch?v=KZjFVdU8VLI) – 2014 年的 5 分钟视频，展示了 ClojureScript 开发人员体验的强大功能.


## Awesome ClojureScript


### Canvas
- [Monet](https://github.com/rm-hull/monet) – 一个小型 ClojureScript 库，可以更轻松地处理画布和视觉效果.
- [Quamolit](https://github.com/Quamolit/quamolit) – 受 React 启发的小型声明式动画库.


### Client/Server Communication
- [cljs-ajax](https://github.com/JulianBirch/cljs-ajax) – 用于 ClojureScript 和 Clojure 的简单 Ajax 客户端.
- [Fetch](https://github.com/LightTable/fetch) – 使客户端/服务器交互变得轻松的 ClojureScript 库.


### Code Analysis
- [kibit](https://github.com/jonase/kibit) – 静态代码分析器，用于查找可以用更惯用的函数或宏重写的代码模式.


### Data Serialization
- [Cljson](https://github.com/tailrecursion/cljson) – 用于加速浏览器数据反序列化的 Clojure/ClojureScript 库.
- [Transit](https://github.com/cognitect/transit-cljs) – 一种数据交换格式和一组库，用于在用不同编程语言编写的应用程序之间传递值.


### Data Visualization
- [C2](https://keminglabs.com/c2) – 它允许您基于数据以声明方式创建 HTML 和 SVG 标记.


### Database
- [Datascript](https://github.com/tonsky/datascript) – ClojureScript 中的不可变内存数据库和 Datalog 查询引擎.
- [Jaki](https://github.com/pandeiro/jaki) – 一个简单的 ClojureScript CouchDB 客户端.
- [Konserve](https://github.com/replikativ/konserve) – 具有 core.async 的 clojuresque 键值/文档存储协议.
- [specql](https://github.com/tatut/specql) – 用于使用命名空间键进行简单 PostgreSQL 查询的库.


### Development
- [Ambly](https://github.com/omcljs/ambly) – A ClojureScript REPL into iOS JavaScriptCore.
- [cljs-devtools](https://github.com/binaryage/cljs-devtools) – 在 Chrome Devtools 中更好地呈现 ClojureScript 值.
- [Devcards](https://github.com/bhauman/devcards) – Devcards 旨在为 ClojureScript 提供可视化的 REPL 体验.
- [Instaparse](https://github.com/lbradstreet/instaparse-cljs) – 它旨在成为在 ClojureScript 中构建解析器的最简单方法.
- [lein-cljsbuild](https://github.com/emezeske/lein-cljsbuild) – 使 ClojureScript 开发变得简单的 Leiningen 插件.
- [lein-figwheel](https://github.com/bhauman/lein-figwheel) – 将 ClojureScript 代码更改推送到客户端的 Leiningen 插件.
- [Lumo](https://github.com/anmonteiro/lumo) – 快速、跨平台、独立的 ClojureScript 环境.
- [Planck](https://github.com/mfikes/planck) – 基于 JavaScriptCore 的适用于 macOS 和 Linux 的独立 ClojureScript REPL.
- [Ribol](http://docs.caudate.me/ribol/) – clojure/clojurescript 的条件重启.
- [shadow-cljs](https://github.com/thheller/shadow-cljs) – ClojureScript 编译变得简单
- [Truss](https://github.com/ptaoussanis/truss) – 用于 Clojure/ClojureScript 的自以为是的断言 API.


### Document Object Model
- [cljs-binding](https://github.com/fluentsoftware/cljs-binding) – 它将 html 元素绑定到 ClojureScript 函数.
- [Crate](https://github.com/ibdknox/crate) – 打嗝的 ClojureScript 实现.
- [Dominator](https://github.com/dubiousdavid/dominator) – ClojureScript 中的虚拟 Dom.
- [Dommy](https://github.com/plumatic/dommy) – 一个严肃的 ClojureScript 模板和 DOM 操作库.
- [Enfocus](http://ckirkendall.github.io/enfocus-site/) – 受 Enlive 启发的 ClojureScript 的 DOM 操作和模板库.
- [Freactive](https://github.com/aaronc/freactive) – 一个高性能、纯 Clojurescript、声明式 DOM 库，其灵感来自 reagent、om、reflex 和 hiccup.
- [Hiccups](https://github.com/teropa/hiccups) – 打嗝的 ClojureScript 端口.
- [Hickory](https://github.com/davidsantiago/hickory) – 它将 HTML 解析为 Clojure 数据结构，因此您可以分析、转换并输出回 HTML.
- [json-html](https://github.com/yogthos/json-html) – 提供 JSON 并获取具有该 JSON 的人工表示的 DOM 节点.
- [Kioo](https://github.com/ckirkendall/kioo) – ClojureScript 中用于 Facebook React 和 Om 的 DOM 操作和模板库.
- [Respo](https://github.com/mvc-works/respo) – 受 React 启发的响应式 DOM 库.
- [Sablono](https://github.com/r0man/sablono) – ClojureScript 中 Facebook 的 React 的 Lisp/Hiccup 风格模板.


### Documentation
- [codox](https://github.com/weavejester/codox) – 用于从 Clojure 或 ClojureScript 源代码生成 API 文档的工具.


### Graphics
- [geom](https://github.com/thi-ng/geom) – 用于 Clojure/Clojurescript 的 2D/3D 几何工具包.
- [Quil](https://github.com/quil/quil) – 处理和图形编程库.


### HTTP Handler
- [Castra](https://github.com/hoplon/castra) – Clojure 的 HTTP 远程过程调用处理程序.


### Internationalization
- [Tempura](https://github.com/ptaoussanis/tempura) – Clojure(Script) i18n 库，接替 Tower
- [Tower](https://github.com/ptaoussanis/tower) – Clojure(Script) i18n 和 L10n 库.


### JavaScript Interoperability
- [CLJSJS](http://cljsjs.github.io/) – Clojurescript 开发人员依赖 Javascript 库的一种简单方法.
- [Jayq](https://github.com/ibdknox/jayq) – jQuery 的 ClojureScript 包装器.
- [Purnam](https://github.com/zcaudate/purnam) – 一个 ClojureScript 库，旨在提供更好的 clojurescript/javascript 互操作、测试和文档工具.
- [Pylon](https://github.com/bodil/pylon) – 100% Clojurescript 中的 Javascript 类系统.


### CSS tools
- [Garden](https://github.com/noprompt/garden) – 用于在 Clojure 和 ClojureScript 中呈现 CSS 的库.
- [stylefy](https://github.com/jarzka/stylefy) – stylefy 可以将 UI 组件样式定义为 Clojure 数据并将它们轻松附加到组件中，而无需编写 CSS 选择器


### Miscellaneous
- [Automat](https://github.com/ztellman/automat) – 受 Ragel 启发，用于定义和使用有限状态自动机的 Clojure(Script) 库.
- [Bardo](https://github.com/pleasetrythisathome/bardo) – 用于功能插值和转换的 Clojure(Script) 库.
- [core.async](https://github.com/clojure/core.async/) – 一个 Clojure(Script) 库，旨在为异步编程和通信提供便利.
- [Entanglement](https://github.com/Frozenlock/entanglement) – 它从其他原子创建原子并将数据链接在一起.
- [inflections-clj](https://github.com/r0man/inflections-clj) – 用于 Clojure 和 ClojureScript 的类 Rails 变形库.
- [Keybind](https://github.com/piranha/keybind) – 用于处理浏览器中的键绑定（快捷方式）的库.
- [markdown-clj](https://github.com/yogthos/markdown-clj) – Clojure/ClojureScript 中的 Markdown 解析器.
- [namespacefy](https://github.com/Jarzka/namespacefy) – 一个简单的 Clojure(Script) 库，旨在使映射键的命名空间变得容易，无论您的数据来自何处.
- [om-tools](https://github.com/plumatic/om-tools) – 它旨在提供在使用 Om 的 API 构建组件时经常有用的高阶抽象和实用程序.
- [reforms](https://github.com/bilus/reforms) – 用于 Om 和 Reagent 的漂亮的 Bootstrap 3 形式.
- [reagent-forms](https://github.com/reagent-project/reagent-forms/) – 试剂的 Bootstrap 表单组件.
- [Sepal.clj](https://github.com/Cirru/sepal.clj) – 一个从字符串向量和带有宏系统的向量生成 Clojure 代码的库.

### [React.js](https://facebook.github.io/react/) Interface
- [Brutha](https://github.com/weavejester/brutha) – React 的简单实用的 ClojureScript 接口.
- [cljsx](https://github.com/peterhudec/cljsx) – [JSX](https://reactjs.org/docs/introducing-jsx.html) 对于 Clojure 和 ClojureScript，也适用于 [Inferno](https://infernojs.org), [Nerv](https://nerv.aotu.io/), [Preact](https://preactjs.com/), [Snabbdome](https://github.com/snabbdom/snabbdom) 和别的.
- [Helix](https://github.com/lilactown/helix) – 一个简单易用的库，用于在 ClojureScript 中进行 React 开发，在 React 之上只有很少的语义. 
- [hx](https://github.com/Lokeh/hx) – 另一个简单易用的库，用于 ClojureScript 中的 React 开发. 
- [Om](https://github.com/omcljs/om) – 强大的 React 接口，利用其面向对象的结构.
- [Quiescent](https://github.com/levand/quiescent) – 它支持函数式风格，完全无状态.
- [re-com](https://github.com/Day8/re-com) – Reagent 的可重用组件的 ClojureScript 库.
- [Reagent](http://reagent-project.github.io/) – 简约，功能齐全.
- [Rum](https://github.com/tonsky/rum) – 分解、可扩展、简单.


### Reactive Programming
- [Javelin](https://github.com/hoplon/javelin) – ClojureScript 的函数式响应式编程库.
- [Manifold-cljs](https://github.com/dm3/manifold-cljs) – 一个端口 [Manifold](https://github.com/ztellman/manifold) 到 ClojureScript.
- [Reagi](https://github.com/weavejester/reagi) – 用于 Clojure 和 ClojureScript 的 FRP 库，构建在 core.async 之上.
- [rx-cljs](https://github.com/leonardoborges/rx-cljs) – 用于 Javascript 的 Reactive Extensions (Rx) 的 ClojureScript 包装器.
- [Yolk](https://github.com/Cicayda/yolk) – 围绕 bacon.js 的薄 ClojureScript 包装器.


### Routing
- [Bidi](https://github.com/juxt/bidi) – Clojure(script) 数据驱动的路由库.
- [Router](https://github.com/darkleaf/router)  – Clojure/Script 的双向环形路由器. 面向休息.
- [Secretary](https://github.com/gf3/secretary) – ClojureScript 的客户端路由器.
- [Silk](https://github.com/DomKM/silk) – Clojure 和 ClojureScript 的同构路由库.


### State Management
- [component](https://github.com/stuartsierra/component) – Clojure(Script) 中有状态对象的托管生命周期.
- [hodgepodge](http://funcool.github.io/hodgepodge/) – HTML5 存储的惯用 ClojureScript 接口.
- [mount](https://github.com/tolitius/mount) – 一个漂亮的惯用状态管理库.
- [plato](https://github.com/eneroth/plato) – 在 ClojureScript 中将原子状态增量保存到本地存储.
- [storage-atom](https://github.com/alandipert/storage-atom) – 由 HTML5 网络存储支持的 ClojureScript 原子.
- [Tuck](https://github.com/tatut/tuck) – 用于构建 Reagent 应用程序的微框架，这些应用程序将视图代码和事件处理代码完全分开. 
- [Waltz](https://github.com/ibdknox/waltz) – 一个 ClojureScript 库，可帮助使用非确定性有限状态机管理客户端应用程序中的状态.


### Testing
- [cljs.test](https://github.com/clojure/clojurescript/wiki/Testing) – ClojureScript 的集成测试框架（合并自 [clojurescript.test](https://github.com/cemerick/clojurescript.test))
- [Expectations](http://jayfields.com/expectations/) – 极简主义的单元测试框架.
- [Speclj](https://github.com/slagyr/speclj) – Clojure 和 ClojureScript 的 TDD/BDD 框架.
- [test.check](https://github.com/clojure/test.check) – 受 QuickCheck 启发的基于生成属性的测试工具.


### Validation
- [Bouncer](https://github.com/leonardoborges/bouncer) – 用于 Clojure 和 Clojurescript 应用程序的验证 DSL.
- [form-validator-cljs](https://github.com/kwladyka/form-validator-cljs) – 使用 spec 和 fn 验证表单.
- [Validateur](http://clojurevalidations.info/) – 受 Ruby 的 ActiveModel 启发的 Clojure 验证库.


### Web Framework & Template
- [atw-om](https://github.com/zaiste/atw-om) – 带有 Clojure/Compojure、ClojureScript/Om 和 core.async 的 Web 应用程序模板.
- [Chestnut](https://github.com/plexus/chestnut) – 用于 ClojureScript/Om 的应用程序模板，具有实时重新加载功能.
- [Clops](https://github.com/sveri/closp) – 一个固执己见、全栈且易于使用的 Web 框架.
- [descjop](https://github.com/karad/lein_template_descjop) – 基于 Web 的电子桌面应用程序模板.
- [electron-template](https://github.com/ducky427/electron-template) – 使用 Electron、ClojureScript 和 Reagent 创建基于 Web 的桌面应用程序的模板.
- [Fulcro](http://fulcrologic.github.io/fulcro) – 用于在 clj/cljs 中开发单页全栈 Web 应用程序的库.
- [Hoplon](http://hoplon.io) – 在客户端和服务器端用 Clojure 和 ClojureScript 编写所有内容.
- [Keechma](http://keechma.com) – ClojureScript 和 Reagent 的微前端框架.
- [Luminus](http://www.luminusweb.net/) – 它旨在提供一个健壮、可扩展且易于使用的平台.
- [Macchiato](https://github.com/macchiato-framework/macchiato-core) – 它旨在为 Node.js 提供一个易于使用的平台.
- [Mies](https://github.com/swannodette/mies) – 一个最小的 ClojureScript 项目模板.
- [Mr-Clean](https://bitbucket.org/sonwh98/mr-clean) – 没有 react.js 依赖的试剂兼容库.
- [Precept](https://github.com/CoNarrative/precept) – 声明式编程框架.
- [re-frame](https://github.com/Day8/re-frame) – 用 Clojurescript 编写 SPA 的试剂框架.
- [Tenzing](http://martinklepsch.github.io/tenzing/) – 没有使用 Boot 后端的 ClojureScript 模板.
- [WebFUI](https://github.com/drcode/webfui) – ClojureScript 的客户端 Web 框架.


### WebSockets
- [Chord](https://github.com/jarohen/chord) – 旨在弥合 CLJ/CLJS、web-sockets 和 core.async 这三者之间的差距.
- [Sente](https://github.com/ptaoussanis/sente) – Clojure（脚本）+ core.async + WebSockets/Ajax.


* * *


## Contributing
欢迎所有贡献. 请阅读 [Contributing](https://github.com/hantuzun/awesome-clojurescript/blob/master/CONTRIBUTING.md) 在打开拉取请求之前.  tl;dr `-` 用于项目符号，`–` 用于链接和描述之间的分隔符，列表应按字母顺序排列.


## License
[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

[Han Tuzun](http://hantuzun.com) 根据版权法，在法律允许的范围内放弃其在全球范围内对作品的所有权利，包括所有相关和邻接权利，从而将作品献给公共领域.

您可以复制、修改、分发和执行作品，甚至可以用于商业目的，所有这些都无需征得许可.
