<div class="github-widget" data-repo="agarrharr/awesome-cli-apps"></div>
<p align="center">
	<img width="763" src="https://cdn.rawgit.com/aharris88/awesome-cli-apps/master/media/banner.png" alt="awesome cli apps">
</p>

---

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

> A curated list of command line apps.

Inspired by the [awesome](https://github.com/sindresorhus/awesome) list thing.


<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->



<!-- END doctoc generated TOC please keep comment here to allow auto update -->

---

## Entertainment

- [newsboat](https://github.com/newsboat/newsboat) - An extendable RSS feed reader for text terminals.

### Music

- [cmus](https://github.com/cmus/cmus) - Small, fast and powerful console music player.
- [Instant-Music-Downloader](https://github.com/yask123/Instant-Music-Downloader) - Instant music downloader.
- [itunes-remote](https://github.com/mischah/itunes-remote) - Control iTunes via CLI.
- [pianobar](https://6xq.net/pianobar/) - Pandora client.
- [somafm-cli](https://github.com/rockymadden/somafm-cli) - Listen to SomaFM in your terminal.
- [mpd](https://github.com/MusicPlayerDaemon/MPD) - Music Player Daemon.
- [ncmpcpp](https://github.com/arybczak/ncmpcpp) - mpd client.
- [moc](http://moc.daper.net/) - Console audio player for Linux/UNIX.
- [musikcube](https://github.com/clangen/musikcube) - Cross-platform, terminal-based music player, audio engine, metadata indexer, and server.
- [beets](https://github.com/beetbox/beets) - Music library manager and tagger.
- [spotify-tui](https://github.com/Rigellute/spotify-tui) - Spotify client.
- [swaglyrics-for-spotify](https://github.com/SwagLyrics/SwagLyrics-For-Spotify) - Spotify lyrics.
- [dzr](https://github.com/yne/dzr) - deezer.com player.
- [radio-active](https://github.com/deep5050/radio-active) - Internet radio player with 40k+ stations.
- [mpvc](https://github.com/gmt4/mpvc) - Music player interfacing mpv.

### Video

- [youtube-dl](https://github.com/ytdl-org/youtube-dl) - Download videos from YouTube.com and many other video sites.
- [streamlink](https://github.com/streamlink/streamlink) - Extract streams from various websites to a video player of your choosing.
- [mps-youtube](https://github.com/mps-youtube/mps-youtube) - Youtube player.
- [mpv](https://mpv.io) - Superior video player.
- [editly](https://github.com/mifi/editly) - Declarative video editing.
- [yt-dlp](https://github.com/yt-dlp/yt-dlp) - A `youtube-dl` fork with additional features and fixes.

### Movies

- [moviemon](https://github.com/iCHAIT/moviemon) - Everything about your movies.
- [movie](https://github.com/mayankchd/movie) - Get movie info or compare movies.

### Games

- [Dwarf Fortress](http://www.bay12games.com/dwarves/) - Roguelike construction and management simulation.
- [Cataclysm-DDA](https://cataclysmdda.org) - Turn-based survival game set in a post-apocalyptic world.
- [Pokete](https://github.com/lxgr-linux/Pokete) - Pokemon-like.

### Books

- [epr](https://github.com/wustho/epr) - epub reader.
- [Bible.Js CLI](https://github.com/BibleJS/BibleApp) - Bible.
- [SpeedRead](https://github.com/sunsations/speed_read) - Spritz-alike speedreader.
- [medium-cli](https://github.com/djadmin/medium-cli) - Read [medium.com](https://medium.com/) stories.

### Chat

- [WeeChat](https://weechat.org/) - Fast, light and extensible chat client.
- [irssi](https://github.com/irssi/irssi) - IRC chat client.
- [kirc](https://github.com/mcpcpc/kirc) - Tiny IRC client.

## Development

- [legit](https://github.com/captainsafia/legit) - Generate Open Source licences as files or file headers.
- [mklicense](https://github.com/cezaraugusto/mklicense) - Create a custom LICENSE file painlessly with customized info.
- [rebound](https://github.com/shobrook/rebound) - Fetch Stack Overflow results on compiler error.
- [foy](https://github.com/zaaack/foy) - Lightweight general purpose task runner/build tool.
- [just](https://github.com/casey/just) - Modern `make`-like command runner.
- [bcal](https://github.com/jarun/bcal) - Byte CALculator for storage conversions and calculations.
- [bitwise](https://github.com/mellowcandle/bitwise) - Base conversion and bit manipulation.
- [cgasm](https://github.com/bnagy/cgasm) - x86 assembly documentation.
- [grex](https://github.com/pemistahl/grex) - Generate regular expressions from user-provided test cases.
- [gdb-dashboard](https://github.com/cyrus-and/gdb-dashboard) - Modular visual interface for GDB.
- [iola](https://github.com/pvarentsov/iola) - Socket client with REST API.
- [add-gitignore](https://github.com/TejasQ/add-gitignore) - Interactively generate a .gitignore for your project based on your needs.
- [is-up-cli](https://github.com/sindresorhus/is-up-cli) - Check if a domain is up.
- [reachable](https://github.com/italolelis/reachable) - Check if a domain is up.
- [loadtest](https://github.com/alexfernandez/loadtest) - Run load tests.
- [diff2html-cli](https://github.com/rtfpessoa/diff2html-cli) - Create pretty HTML from diffs.

### Text Editors

- [emacs](https://github.com/emacs-mirror/emacs) - An extensible, customizable, free/libre text editor — and more.
- [vim](https://github.com/vim/vim) - Vim - the ubiquitous text editor.
- [neovim](https://github.com/neovim/neovim) - Modern vim.
- [kakoune](https://github.com/mawww/kakoune) - Modal editor inspired by vim.
- [micro](https://github.com/zyedidia/micro) - A simple and intuitive editor.
- [o](https://github.com/xyproto/o) - Configuration-free text editor and IDE.
- [helix](https://github.com/helix-editor/helix) -  Modal editor inspired by kakoune.

### Frontend Development

- [caniuse-cmd](https://github.com/sgentle/caniuse-cmd) - Search [caniuse.com](https://caniuse.com) about browser support of features.
- [strip-css-comments-cli](https://github.com/sindresorhus/strip-css-comments-cli) - Strip comments from CSS.
- [viewport-list-cli](https://github.com/kevva/viewport-list-cli) - Return a list of devices and their viewports.
- [surge](https://surge.sh) - Publish static websites for free.

### Mobile Development

- [mobicon-cli](https://github.com/SamVerschueren/mobicon-cli) - Mobile app icon generator.
- [mobisplash-cli](https://github.com/SamVerschueren/mobisplash-cli) - Mobile app splash screen generator.
- [deviceframe](https://github.com/c0bra/deviceframe) - Put device frames around your mobile/web/progressive app screenshots.

### Database

- [mycli](https://github.com/dbcli/mycli) - MySQL client with autocompletion and syntax highlighting.
- [pgcli](https://github.com/dbcli/pgcli) - Postgres client with autocompletion and syntax highlighting.
- [sqlline](https://github.com/julianhyde/sqlline) -  Shell for issuing SQL via JDBC.
- [iredis](https://github.com/laixintao/iredis) - Redis client with autocompletion and syntax highlighting.
- [usql](https://github.com/xo/usql) - Universal SQL client with autocompletion and syntax highlighting.

### Devops

- [htconvert](https://github.com/lukechilds/htconvert) - Convert .htaccess redirects to nginx.conf redirects.
- [SAWS](https://github.com/donnemartin/saws) - Supercharged AWS CLI.
- [s3cmd](https://github.com/s3tools/s3cmd) - Fully-Featured S3 client.
- [pm2](https://github.com/Unitech/pm2) - Production Process Manager for Node.js.
- [ops](https://github.com/nanovms/ops) - Unikernel compilation and orchestration tool.
- [flog](https://github.com/mingrammer/flog) - A fake log generator for log formats such as apache-common, apache error and RFC3164 syslog.
- [k9s](https://github.com/derailed/k9s) - Manage Kubernetes Clusters.
- [PingMe](https://github.com/kha7iq/pingme) - Send messages/alerts to multiple messaging platforms & email.
- [ipfs-deploy](https://github.com/agentofuser/ipfs-deploy) - Deploy static websites to [IPFS](https://github.com/ipfs/ipfs#overviewhttps://github.com/ipfs/ipfs#overview).
- [Discharge](https://github.com/brandonweiss/discharge) - Deploy static websites to Amazon S3.
- [updatecli](https://github.com/updatecli/updatecli) - A declarative dependency management tool.

### Docker

- [lstags](https://github.com/ivanilves/lstags) - Synchronize images across registries.
- [dockly](https://github.com/lirantal/dockly) - Interactively manage containers.
- [lazydocker](https://github.com/jesseduffield/lazydocker) - Simple docker/docker-compose interface.
- [docker-pushrm](https://github.com/christian-korneck/docker-pushrm) - Push a readme to container registries.

### Release

- [release-it](https://github.com/webpro/release-it) - Automate releases for Git repositories and/or npm packages. Changelog generation, GitHub/GitLab releases, etc.
- [clog](https://github.com/clog-tool/clog-cli) - A conventional changelog for the rest of us.
- [np](https://github.com/sindresorhus/np) - A better `npm publish`.
- [release](https://github.com/vercel/release) - Generate changelogs with a single command.
- [semantic-release](https://github.com/semantic-release/semantic-release) - Fully automated version management and package publishing.

### Npm

- [npm-name-cli](https://github.com/sindresorhus/npm-name-cli) - Check whether a package name is available on npm.
- [npm-user-cli](https://github.com/sindresorhus/npm-user-cli) - Get user info of a npm user.
- [npm-home](https://github.com/sindresorhus/npm-home) - Open the npm page of the package in the current directory.
- [pkg-dir-cli](https://github.com/sindresorhus/pkg-dir-cli) - Find the root directory of a npm package.
- [npm-check-updates](https://github.com/tjunnone/npm-check-updates) - Find newer versions of package dependencies than what your package.json allows.
- [updates](https://github.com/silverwind/updates) - Flexible npm dependency update tool.
- [wipe-modules](https://github.com/bntzio/wipe-modules) - Remove `node_modules` of inactive projects.

### Boilerplate

- [yo](https://github.com/yeoman/yo) - Scaffolding tool for running Yeoman generators.
- [boilr](https://github.com/tmrts/boilr) - Create projects from boilerplate templates.
- [cookiecutter](https://github.com/audreyr/cookiecutter) - Create projects from templates.
- [mevn-cli](https://github.com/madlabsinc/mevn-cli) - Light speed setup for MEVN (Mongo Express Vue Node) Apps.
- [scaffold-static](https://github.com/jamesgeorge007/scaffold-static) - Scaffolding utility for vanilla JS.

### HTTP Server

- [serve](https://github.com/vercel/serve) - Serve static files (https, CORS, GZIP compression, etc).
- [simplehttp](https://github.com/snwfdhmp/simplehttp) - Easily serve a local directory over HTTP.
- [shell2http](https://github.com/msoap/shell2http) - Shell script based HTTP server.

### HTTP Client

- [HTTPie](https://github.com/httpie/httpie) - A user-friendly HTTP client.
- [HTTP Prompt](https://github.com/eliangcs/http-prompt) - Interactive HTTP client featuring autocomplete and syntax highlighting.
- [ain](https://github.com/jonaslu/ain) - HTTP client with a simple format to organize API endpoints.
- [curlie](https://github.com/rs/curlie) - A curl frontend with the ease of use of HTTPie.

## Productivity

- [doing](https://github.com/ttscoff/doing/) - Keep track of what you’re doing and track what you’ve done.
- [ffscreencast](https://github.com/cytopia/ffscreencast) - A ffmpeg screencast with video overlay and multi monitor support.
- [meetup-cli](https://github.com/specious/meetup-cli) - Meetup.com client.
- [NeoMutt](https://neomutt.org) - Email client.
- [terjira](https://github.com/keepcosmos/terjira) - Jira client.
- [ipt](https://github.com/drselump14/ipt) - Pivotal Tracker client.
- [uber-cli](https://github.com/jaebradley/uber-cli) - Uber client.
- [Buku](https://github.com/jarun/Buku) - Browser-independent bookmark manager.
- [papis](https://github.com/papis/papis) - Extensible document and bibliography manager.
- [pubs](https://github.com/pubs/pubs) - Scientific bibliography manager.
- [fjira](https://github.com/mk-5/fjira) - Fuzzy finder and TUI application for Jira.

### Time Tracking

- [Timetrap](https://github.com/samg/timetrap) - Simple timetracker.
- [moro](https://github.com/omidfi/moro) - Simple tool for tracking work hours.
- [Timewarrior](https://github.com/GothenburgBitFactory/timewarrior) - Utility with simple stopwatch, calendar-based backfill and flexible reporting.
- [Watson](https://github.com/TailorDev/Watson) - Generate reports for clients and manage your time.
- [utt](https://github.com/larose/utt) - Simple time tracking tool.
- [Bartib](https://github.com/nikolassv/bartib) - Easy to use time tracking tool.
- [arttime](https://github.com/reportaman/arttime) - Featureful timer with native desktop notifications and curated ASCII art.

### Note Taking and Lists

- [idea](https://github.com/IonicaBizau/idea) - A lightweight tool for keeping ideas in a safe place quick and easy.
- [geeknote](https://github.com/vitaly-zdanevich/geeknote) - Evernote client.
- [Taskwarrior](https://taskwarrior.org/) - Manage your TODO list.
- [Terminal velocity](https://vhp.github.io/terminal_velocity/) - A fast note-taking app.
- [eureka](https://github.com/simeg/eureka) - Input and store your ideas.
- [sncli](https://github.com/insanum/sncli) - Simplenote client.
- [td-cli](https://github.com/darrikonn/td-cli) - A TODO manager to organize and manage your TODO's across multiple projects.
- [taskbook](https://github.com/klaussinani/taskbook) - Tasks, boards & notes for the command-line habitat.
- [dnote](https://github.com/dnote/dnote) - A interactive, multi-device notebook.
- [nb](https://github.com/xwmx/nb) - A note‑taking, bookmarking, archiving, and knowledge base application.
- [obs](https://github.com/Yakitrak/obsidian-cli) - Interact with your Obsidian vault.

### Finance

See [plaintextaccounting.org](https://plaintextaccounting.org) for a great overview of relevant tools.

- [ledger](https://ledger-cli.org/) - Powerful, double-entry accounting system.
- [hledger](https://hledger.org/) - Robust, fast, intuitive plain text accounting tool with CLI, TUI and web interfaces.
- [moeda](https://github.com/thompsonemerson/moeda) - Foreign exchange rates and currency conversion.
- [cash-cli](https://github.com/xxczaki/cash-cli) - Convert Currency Rates.
- [cointop](https://github.com/miguelmota/cointop) - Track cryptocurrencies.
- [ticker](https://github.com/achannarasappa/ticker) - Stock ticker.

### Presentations

- [WOPR](https://github.com/yaronn/wopr) - A simple markup language for creating rich terminal reports, presentations and infographics.
- [decktape](https://github.com/astefanutti/decktape) - PDF exporter for HTML presentations.
- [mdp](https://github.com/visit1985/mdp) - A markdown presentation tool.
- [sent](https://tools.suckless.org/sent/) - Simple plaintext presentation tool.
- [slides](https://github.com/maaslalani/slides) - A markdown presentation tool.

### Calendars

- [calcurse](https://calcurse.org/) - Calendar and scheduling.
- [gcalcli](https://github.com/insanum/gcalcli) - Google calendar client.
- [khal](https://github.com/pimutils/khal) - CalDAV ready CLI and TUI calendar.
- [vdirsyncer](https://github.com/pimutils/vdirsyncer) - CalDAV sync.
- [remind](https://dianne.skoll.ca/projects/remind/) - A sophisticated calendar and alarm program.
- [birthday](https://github.com/IonicaBizau/birthday) - Know when a friend's birthday is coming.

## Utilities

- [aria2](https://github.com/tatsuhiro-t/aria2) - HTTP, FTP, SFTP, BitTorrent and Metalink download utility.
- [bitly-client](https://github.com/specious/bitly-client) - Bitly client.
- [deadlink](https://github.com/nschloe/deadlink) - Find dead links in files.
- [crawley](https://github.com/s0rg/crawley) - Unix-way web crawler.
- [kill-tabs](https://github.com/sindresorhus/kill-tabs) - Kill all Chrome tabs.
- [alex](https://github.com/get-alex/alex) - Catch insensitive, inconsiderate writing.
- [clevercli](https://github.com/clevercli/clevercli) - Collection of ChatGPT powered utilities.

### macOS

- [open-pip-cli](https://github.com/albinekb/open-pip-cli) - Watch videos in picture-in-picture player.
- [osx-wifi-cli](https://github.com/danyshaanan/osx-wifi-cli) - Manage wifi connections.
- [active-win-cli](https://github.com/sindresorhus/active-win-cli) - Get the title/id/etc of the active window.
- [stronghold](https://github.com/alichtman/stronghold) - Configure security settings from the terminal.
- [dark-mode](https://github.com/sindresorhus/dark-mode) - Toggle dark mode.

### Terminal Sharing Utilities

- [gotty](https://github.com/yudai/gotty) - Share your terminal as a web application.
- [localtunnel](https://github.com/localtunnel/localtunnel) - Expose your localhost to the world for easy testing and sharing.
- [mosh](https://mosh.org/) - Remote SSH client that allows roaming with intermittent connectivity.
- [ngrok](https://ngrok.com/) - Secure introspectable tunnels to localhost.
- [tmate](https://tmate.io/) - Instant terminal (tmux) sharing.
- [warp](https://github.com/spolu/warp) - Secure and simple terminal sharing.
- [OverTime](https://github.com/diit/overtime-cli) - Time-overlap tables for remote teams.

### Network Utilities

- [get-port-cli](https://github.com/sindresorhus/get-port-cli) - Get an available port.
- [is-reachable-cli](https://github.com/beatfreaker/is-reachable-cli) - Check if hostnames are reachable or not.
- [acmetool](https://github.com/hlandau/acmetool) - Automatic certificate acquisition for ACME (Let's Encrypt).
- [certificate-ripper](https://github.com/Hakky54/certificate-ripper) - Extract server certificates.
- [neoss](https://github.com/PabloLec/neoss) - User-friendly and detailed socket statistics.

### Theming and Customization

- [splash-cli](https://github.com/splash-cli/splash-cli) - Beautiful wallpapers from Unsplash.
- [wallpaper-cli](https://github.com/sindresorhus/wallpaper-cli) - Get or set the desktop wallpaper.
- [themer](https://github.com/mjswensen/themer) - Generate personalized themes for your editor, terminal, wallpaper, Slack, and more.
- [JackPaper](https://github.com/jackel27/jackpaper) - Set images from Unsplash as wallpaper.
- [QuickWall](https://github.com/deepjyoti30/QuickWall) - Directly set wallpapers from Unsplash.
- [oh-my-posh](https://ohmyposh.dev) - Prompt theme engine.

### Shell Utilities

- [has](https://github.com/kdabir/has) - Checks for the presence of various commands and their versions on the path.
- [Ultimate Plumber](https://github.com/akavel/up) - Write Linux pipes with live previews.
- [fkill-cli](https://github.com/sindresorhus/fkill-cli) - Simple cross-platform process killer.
- [task-spooler](https://tracker.debian.org/pkg/task-spooler) - Queue jobs for linear execution.
- [undollar](https://github.com/ImFeelingDucky/undollar) - Strip the '$' preceding copy-pasted terminal commands.
- [pipe_exec](https://github.com/koraa/pipe_exec) - Run executables from stdin, pipes and ttys without creating a temporary file.

### System Interaction Utilities

- [fastfetch](https://github.com/fastfetch-cli/fastfetch) - System information tool.
- [battery-level-cli](https://github.com/gillstrom/battery-level-cli) - Get current battery level.
- [brightness-cli](https://github.com/kevva/brightness-cli) - Change screen brightness ([windows](https://github.com/sondreb/win-brightness)).
- [yank](https://github.com/mptre/yank) - Yank terminal output to clipboard.
- [screensaver](https://github.com/gillstrom/screensaver) - Start the screensaver.
- [google-font-installer](https://github.com/lordgiotto/google-font-installer) - Download and install Google Web Fonts on your local machine.
- [glances](https://nicolargo.github.io/glances/) - System monitoring tool.
- [tiptop](https://github.com/nschloe/tiptop) - System monitor.
- [gzip-size-cli](https://github.com/sindresorhus/gzip-size-cli) - Get the gzipped size of a file.

### Markdown

- [DocToc](https://github.com/thlorenz/doctoc) - Generates table of contents for markdown files.
- [grip](https://github.com/joeyespo/grip) - Preview markdown files as GitHub would render them.
- [mdv](https://github.com/axiros/terminal_markdown_viewer) - Styled terminal markdown viewer.
- [glow](https://github.com/charmbracelet/glow) - Styled markdown rendering.
- [gtree](https://github.com/ddddddO/gtree) - Use markdown to generate directory trees and the directories itself.

### Security

- [pass](https://www.passwordstore.org) - Password manager.
- [gopass](https://github.com/gopasspw/gopass) - Fully-featured password manager.
- [xiringuito](https://github.com/ivanilves/xiringuito) - SSH-based VPN.
- [hasha-cli](https://github.com/sindresorhus/hasha-cli) - Get the hash of text or stdin.
- [ots](https://github.com/sniptt-official/ots) - Share secrets with others via a one-time URL.

### Math

- [mdlt](https://github.com/metadelta/mdlt) - Do quick math right from the command line.
- [Qalculate](https://github.com/Qalculate/libqalculate) - Calculate non-trivial math expressions. Unit conversions, symbolic calculations and more.

### Weather

- [wttr.in](https://github.com/chubin/wttr.in)
- [wego](https://github.com/schachmat/wego)
- [weather-cli](https://github.com/riyadhalnur/weather-cli)

### Browser Replacement

- [s](https://github.com/zquestz/s) - Open a web search in your terminal.
- [hget](https://github.com/bevacqua/hget) - Render websites in plain text from your terminal.
- [mapscii](https://github.com/rastapasta/mapscii) - Terminal Map Viewer.
- [nasa-cli](https://github.com/xxczaki/nasa-cli) - Download NASA Picture of the Day.
- [getnews.tech](https://github.com/omgimanerd/getnews.tech) - Fetch news headlines from various news outlets.
- [trino](https://github.com/eneserdogan/trino) - Translation of words and phrases.
- [translate-shell](https://github.com/soimort/translate-shell) - Google Translate interface.

### Internet Speedtest

- [speedtest-net](https://github.com/ddsol/speedtest.net) - Test internet connection speed and ping using speedtest.net.
- [speed-test](https://github.com/sindresorhus/speed-test) - `speedtest-net` wrapper with different UI.
- [speedtest-cli](https://github.com/sivel/speedtest-cli) - Test internet bandwidth using speedtest.net.
- [bandwhich](https://github.com/imsnif/bandwhich) - Track bandwidth utilization by process.

## Command Line Learning

- [cmdchallenge](https://cmdchallenge.com) - Presents small shell challenge with user submitted solutions.
- [explainshell](https://www.explainshell.com/) - Type a snippet to see the help text for each argument.
- [howdoi](https://github.com/gleitz/howdoi) - Instant coding answers.
- [how2](https://github.com/santinic/how2) - Node.js implementation of howdoi.
- [The Fuck](https://github.com/nvbn/thefuck) - Magnificent app which corrects your previous console command.
- [tldr](https://github.com/tldr-pages/tldr) - Simplified and community-driven man pages.
- [Wat](https://github.com/dthree/wat) - Instant, central, community-built docs.
- [teachcode](https://github.com/madlabsinc/teachcode) - Guide for the earliest lessons of coding.
- [navi](https://github.com/denisidoro/navi) - Interactive cheatsheet tool.
- [yai](https://github.com/ekkinox/yai) - AI powered terminal assistant.

## Data Manipulation

- [visidata](https://github.com/saulpw/visidata) - Spreadsheet multitool for data discovery and arrangement.

### Processors

- [jq](https://github.com/stedolan/jq) - JSON processor.
- [yq](https://github.com/kislyuk/yq) - YAML processor.
- [dasel](https://github.com/tomwright/dasel) - JSON/YAML/TOML/XML processor (like jq/yq).
- [yaml-cli](https://github.com/pandastrike/yaml-cli) - Query/update YAML.
- [ramda-cli](https://github.com/raine/ramda-cli) - Process data with functional pipelines.
- [xq](https://github.com/sibprogrammer/xq) - XML and HTML beautifier and content extractor.

### JSON

- [jp](https://github.com/therealklanni/jp) - JSON parser.
- [fx](https://github.com/antonmedv/fx) - Command-line JSON viewer.
- [vj](https://github.com/busyloop/vj) - Makes JSON human readable.
- [underscore-cli](https://github.com/ddopson/underscore-cli) - Utility-belt for hacking JSON and Javascript.
- [strip-json-comments-cli](https://github.com/sindresorhus/strip-json-comments-cli) - Strip comments from JSON.
- [GROQ](https://github.com/sanity-io/groq-cli) – JSON processor with queries and projections.
- [gron](https://github.com/tomnomnom/gron) - Make JSON greppable.

### YAML

- [dyff](https://github.com/homeport/dyff) - YAML diff tool.

### Columns

- [parse-columns-cli](https://github.com/sindresorhus/parse-columns-cli) - Parse text columns to JSON.
- [q](http://harelba.github.io/q/) - Execution of SQL-like queries on CSV/TSV/tabular text file.

### Text

- [figlet](http://www.figlet.org/) - Creates large text out of ASCII characters.
- [stegcloak](https://github.com/kurolabs/stegcloak) - Hide secrets with invisible characters in plain text securely.

## Files and Directories

### File Managers

- [ranger](https://github.com/ranger/ranger) - A console file manager with VI key bindings.
- [midnight-commander](https://github.com/MidnightCommander/mc) - A feature rich visual file manager.
- [Vifm](https://vifm.info/) - VI influenced file manager.
- [nnn](https://github.com/jarun/nnn) - File browser and disk usage analyzer with excellent desktop integration.
- [lf](https://github.com/gokcehan/lf) - Fast, extensively customizable file manager.
- [clifm](https://github.com/leo-arch/clifm) - The command line file manager.
- [far2l](https://github.com/elfmz/far2l) - Orthodox file manager.
- [yazi](https://github.com/sxyazi/yazi) - Blazing fast file manager.

### Deleting, Copying, and Renaming

- [trash-cli](https://github.com/sindresorhus/trash-cli) - Move files and directories to the trash.
- [empty-trash-cli](https://github.com/sindresorhus/empty-trash-cli) - Empty the trash.
- [del-cli](https://github.com/sindresorhus/del-cli) - Delete files and folders.
- [cpy-cli](https://github.com/sindresorhus/cpy-cli) - Copies files.
- [rename-cli](https://github.com/jhotmann/node-rename-cli) - Rename files quickly.
- [renameutils](https://www.nongnu.org/renameutils/) - Mass renaming in your editor.
- [diskonaut](https://github.com/imsnif/diskonaut) - Disk space navigator.

### Files

- [chokidar-cli](https://github.com/open-cli-tools/chokidar-cli) - CLI to watch file system changes.
- [file-type-cli](https://github.com/sindresorhus/file-type-cli) - Detect the file type of a file or stdin.
- [bat](https://github.com/sharkdp/bat) - A cat clone with syntax highlighting.
- [NCDu](https://dev.yorhel.nl/ncdu) - A disk usage analyzer with an ncurses interface.
- [unix-permissions](https://github.com/ehmicky/unix-permissions) - Swiss Army knife for Unix permissions.
- [transmission-cli](https://transmissionbt.com) - Torrent client for your command line.
- [webtorrent-cli](https://github.com/feross/webtorrent-cli) – Streaming torrent client.
- [entr](https://github.com/eradman/entr) - Run an arbitrary command when files change.
- [organize-cli](https://github.com/ManrajGrover/organize-cli) - Organize your files automatically.
- [organize-rt](https://gitlab.com/foxido/organize-rt) - organize-cli in Rust with more customization.
- [RecoverPy](https://github.com/PabloLec/RecoverPy) - Recover overwritten or deleted files.

### File Sync/Sharing

- [rclone](https://github.com/ncw/rclone) - Sync files with various cloud providers.
- [ffsend](https://github.com/timvisee/ffsend) - Quick file share.
- [share-cli](https://github.com/marionebl/share-cli) - Share files with your local network.
- [google-drive-upload](https://github.com/labbots/google-drive-upload) - Upload/sync with Google Drive.
- [gdrive-downloader](https://github.com/Akianonymus/gdrive-downloader) - Download files/folders from Google Drive.
- [portal](https://github.com/ZinoKader/portal) - Send files between computers.
- [shbin](https://github.com/Shiphero/shbin/) - Turn a Github repo into a pastebin.
- [sharing](https://github.com/parvardegr/sharing) - Send and receive files on your mobile device.
- [ncp](https://github.com/kha7iq/ncp) - Transfer files and folders, to and from NFS servers.

### Directory Listing

- [alder](https://github.com/aweary/alder) - Minimal `tree` with colors.
- [eza](https://github.com/eza-community/eza) - Improved version of `ls`.
- [tre](https://github.com/dduan/tre) - `tree` with git awareness, editor aliasing, and more.
- [ll](https://github.com/antonmedv/ll) - `ls` with git status.
- [lsd](https://github.com/Peltoche/lsd) - `ls` with many extra features.

### Directory Navigation

- [autojump](https://github.com/wting/autojump) - A cd command that learns - easily navigate directories from the command line.
- [pm](https://github.com/Angelmmiguel/pm) - The easy way to switch to your projects on the shell.
- [z](https://github.com/rupa/z) - z is the new j, yo.
- [PathPicker](https://github.com/facebook/pathpicker/) - After parsing the output from a command, PathPicker presents you with a nice UI to select which files you're interested in.
- [fz](https://github.com/changyuheng/fz.sh) - Seamless fuzzy tab completion for z.
- [goto](https://github.com/iridakos/goto) - Directory aliases for the shell with autocomplete.
- [z.lua](https://github.com/skywind3000/z.lua) - `cd` command that learns your habits.
- [zoxide](https://github.com/ajeetdsouza/zoxide) - Fast directory jumper in Rust.
- [tere](https://github.com/mgunyho/tere) - A faster alternative to using cd and ls.

### Search

- [happyfinder](https://github.com/hugows/hf) - (another) Fuzzy file finder for the command line.
- [find-up-cli](https://github.com/sindresorhus/find-up-cli) - Find a file by walking up parent directories.
- [ripgrep](https://github.com/BurntSushi/ripgrep) - A line-oriented search tool that recursively searches your current directory for a regex pattern.
- [fzf](https://github.com/junegunn/fzf) - A general purpose command-line fuzzy finder, can be used with any list: files/directories, command history, processes, hostnames, bookmarks, git commits, etc.
- [fselect](https://github.com/jhspetersson/fselect) - Find files with SQL-like queries.
- [fd](https://github.com/sharkdp/fd) - A simple, fast and user-friendly alternative to `find`.
- [broot](https://github.com/Canop/broot) - Fuzzy finder similar to fzf, but with space usage visualization.
- [rare](https://github.com/zix99/rare) - Real-time regex aggregation and analysis.
- [skim](https://github.com/lotabout/skim) - A general fuzzy finder written in rust, similar to fzf.
- [ast-grep](https://github.com/ast-grep/ast-grep) - A tool for code structural search, linting and rewriting.

## Version Control

- [SnowFS](https://github.com/snowtrack/snowfs) - A fast, scalable version control system for binaries.

### Git

- [git commander](https://github.com/golbin/git-commander) - Interactive git tool.
- [git-stats](https://github.com/IonicaBizau/git-stats) - A local GitHub-like contributions calendar.
- [dev-time](https://github.com/samverschueren/dev-time-cli) - Get the current local time of a GitHub user.
- [tig](https://github.com/jonas/tig) - Text-mode interface for git.
- [grv](https://github.com/rgburke/grv) - Text-mode interface for git with customisable vi bindings.
- [git-standup](https://github.com/kamranahmedse/git-standup) - Recall what you did on the last working day.
- [git-secret](https://github.com/sobolevn/git-secret) - Store your private data inside a git repository.
- [gitlab-cli](https://github.com/vishwanatharondekar/gitlab-cli) - Create GitLab merge requests.
- [git-extras](https://github.com/tj/git-extras) - Git utilities.
- [gita](https://github.com/nosarthur/gita) - Manage multiple git repos side by side.
- [readme-md-generator](https://github.com/kefranabg/readme-md-generator) - Interactively generate README.md files.
- [semantic-git-commit-cli](https://github.com/JPeer264/node-semantic-git-commit-cli) - Ensure semantic commits messages.
- [import-github-labels-cli](https://github.com/abhijithvijayan/import-github-labels-cli) - Sync labels between Github repos.
- [git-all-branches](https://github.com/zacanger/git-all-branches) - Improved `git branch -a`.
- [czg](https://github.com/Zhengqbbb/cz-git/tree/main/packages/cli) - Interactively generate standardized commit messages.
- [shallow-backup](https://github.com/alichtman/shallow-backup) - Git integrated backup tool.
- [Lazygit](https://github.com/jesseduffield/lazygit) - Simple TUI for git commands.

### GitHub

- [CLI GitHub](https://github.com/IonicaBizau/cli-github) - Fancy GitHub client.
- [hub](https://github.com/github/hub) - Make git easier to use with GitHub.
- [git-labelmaker](https://github.com/himynameisdave/git-labelmaker) - Edit GitHub labels.

### Emoji

- [gitmoji-cli](https://github.com/carloscuesta/gitmoji-cli) - Use emoji in commit messages.
- [gitmoji-changelog](https://github.com/frinyvonnick/gitmoji-changelog) - Generate gitmoji changelogs.

## Images

- [SVGO](https://github.com/svg/svgo) - Optimize SVG files.
- [carbon-now-cli](https://github.com/mixn/carbon-now-cli) - Generate beautiful images of your code.
- [imgur-uploader-cli](https://github.com/kevva/imgur-uploader-cli) - Upload images to imgur.
- [pageres-cli](https://github.com/sindresorhus/pageres-cli) - Capture website screenshots.

### Gif Creation

- [gifgen](https://github.com/lukechilds/gifgen) - Simple high quality GIF encoding.
- [gifsicle](https://github.com/kohler/gifsicle) - Create, manipulate, and optimize GIF images and animations.
- [ttygif](https://github.com/icholy/ttygif) - Convert terminal recordings to animated gifs.
- [ttygif](https://github.com/sugyan/ttygif) - ttyrec to gif.
- [ttystudio](https://github.com/chjj/ttystudio) - A terminal-to-gif recorder minus the headaches.
- [asciinema](https://github.com/asciinema/asciinema) - Terminal session recorder and companion app for asciinema.org.
- [givegif](https://github.com/passy/givegif) - GIFs on the command line.

### Image Conversion

- [imagemagick](https://imagemagick.org) - Gold standard for anything images.
- [imgp](https://github.com/jarun/imgp) - Blazing fast batch image resizer and rotator.
- [korkut](https://github.com/oguzhaninan/korkut) - Quick and simple image processing.

## Screensavers

- [cmatrix](https://github.com/Treri/cmatrix) - Scrolling 'Matrix'-like screen.
- [pipes.sh](https://github.com/pipeseroni/pipes.sh) - Random pipes that grow across the screen.
- [YuleLog](https://github.com/Duroktar/YuleLog) - Christmas Yule Log fireplace.
- [cli-fireplace](https://github.com/dolsup/cli-fireplace) - Digital fireplace.

## Graphics

- [cli-mandelbrot](https://github.com/danyshaanan/cli-mandelbrot) - Traverse the Mandelbrot fractal.
- [sparkly-cli](https://github.com/sindresorhus/sparkly-cli) - Generate sparklines ▁▂▃▅▂▇..
- [pastel](https://github.com/sharkdp/pastel) - Generate, analyze, convert and manipulate colors.
- [lowcharts](https://github.com/juan-leon/lowcharts) - Draw low-resolution graphs.

## Just for Fun

- [quote-cli](https://github.com/riyadhalnur/quote-cli) - Get a random quote or the quote of the day in your CLI.
- [fortune](https://github.com/shlomif/fortune-mod) - Shows a random fortune.
- [ponysay](https://github.com/erkin/ponysay) - Pony rewrite of cowsay.
- [yosay](https://github.com/yeoman/yosay) - Like cowsay, but for yeoman.
- [lolcat](https://github.com/busyloop/lolcat) - Outputs text in rainbow colors.
- [text-meme](https://github.com/beatfreaker/text-meme-cli) - Generate text memes.
- [dankcli](https://github.com/sggts04/dankcli) - Add text to meme image templates.
- [ricksay](https://github.com/roma-guru/ricksay) - Quotes from Rick and Morty.

### Emoji

- [emoj](https://github.com/sindresorhus/emoj) - Find relevant emoji from text on the command-line.
- [emoji-finder](https://github.com/dematerializer/emoji-finder) - Quickly find and copy emoji to the clipboard via the command-line.
- [oji](https://github.com/xxczaki/oji) - Interactive text emoji maker.

## Other Awesome Lists

- [awesome-git-addons](https://github.com/stevemao/awesome-git-addons#readme) - Addons that extend git cli.
- [awesome-shell](https://github.com/alebcay/awesome-shell#readme) – Command-line utilities and frameworks.
- [terminals-are-sexy](https://github.com/k4m4/terminals-are-sexy#readme) – Terminal frameworks, plugins & resources.
- [awesome-zsh-plugins](https://github.com/unixorn/awesome-zsh-plugins#readme) – ZSH frameworks, plugins, tutorials & themes.
- [awesome-nodejs clis](https://github.com/sindresorhus/awesome-nodejs#command-line-apps) – Node.js modules and resources.

## License

[![CC0](https://licensebuttons.net/p/zero/1.0/88x31.png)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Adam Garrett-Harris](https://twitter.com/agarrharr) has waived all copyright and related or neighboring rights to this work.
