<div class="github-widget" data-repo="nglgzz/awesome-clean-tech"></div>
## Awesome Clean Tech [![Awesome](https://awesome.re/badge.svg)](https://awesome.re) [![License: CC0-1.0](https://img.shields.io/badge/License-CC0%201.0-lightgrey.svg)](http://creativecommons.org/publicdomain/zero/1.0/)

&gt; 清洁技术是指通过显着提高能源效率、可持续利用资源或环境保护活动来减少负面环境影响的任何过程、产品或服务.

这份名单的目的是收集一份应对气候变化的优秀公司名单，并收集有关与之相关的问题和解决方案的研究.

 _欢迎对此列表做出贡献！ 只需编辑 [README.md](https://github.com/nglgzz/awesome-clean-tech/blob/master/README.md)  （本文档）并将更改作为拉取请求发送. 请阅读 [guidelines](https://github.com/nglgzz/awesome-clean-tech/blob/master/./CONTRIBUTING.md) 在贡献之前._



## Companies

公司格式如下：

```
- [Company Name](https://github.com/nglgzz/awesome-clean-tech/blob/master/URL)  | 总部设在 | 成立年份

简短的介绍.
```

### Vegetation & Agriculture

- [AquaAgro](https://aquaagro.smartcube.pk/)  , 巴基斯坦卡拉奇 |  2018

  为精准农业提供解决方案，使农民能够监控他们的作物并做出更好的决策. 他们的设备和平台可以预测灌溉调度、肥料需求、害虫侵袭预测和植物病害检测.

- [Bowery Farming](https://boweryfarming.com)  | 美国纽约 |  2015年

  他们的室内垂直农场在城市内种植农产品，用水量减少 95%，无需使用杀虫剂，与传统农业相比，在相同占地面积的土地上生产率提高 100 倍.

- [Droneseed](https://www.droneseed.com/)  | 美国西雅图 |  2015年

  一个包括林务员、生态学家和工程师在内的团队专注于野火再造林. 他们使用为提高存活率而开发的无人机群和播种容器种植本地树木和植被. 截至 2020 年，他们一天可以繁殖 40 英亩土地.

- [Kheyti](https://kheyti.com/)  | 印度 |  2015年

  他们实施低成本的农业解决方案，例如“盒中温室”，以帮助小农提高产量和农产品的可预测性.

- [Land Life Company](https://landlifecompany.com/)  | 阿姆斯特丹 |  2013

  他们的使命是在全球 20 亿公顷的退化土地上重新造林.

- [Peckas Tomater](http://www.peckas.com)  | 瑞典 |  2015年

  西红柿和养鱼的综合农场在一个系统中种植，鱼盆废水滋养西红柿，而番茄床反过来又净化了返回鱼盆的水. 他们的鱼是在没有抗生素的情况下生长的，西红柿不需要肥料.

- [Phytoponics](https://phytoponics.com/)  | 英国 |  2016年

  生产商业规模的水培种植系统，该系统比传统水培系统更便宜且更易于安装和维护. 目标是以较低的前期投资带来水培法的好处（更少的水和土地，更稳定的产量）.

- [Solar Foods](https://solarfoods.fi/)  | 芬兰 |  2017年

  从水、二氧化碳和电力中产生 Solein——一种单细胞蛋白质. 它不需要耕地或灌溉，也不受气候条件的限制.  Solein 的最初概念诞生于 NASA 太空计划，并在芬兰技术研究中心有限公司和拉彭兰塔科技大学 (LUT) 的研究项目中得到进一步发展.

- [Vultus](https://www.vultus.io/)  | 瑞典 |  2016年

  使用卫星成像可节省高达 30% 的肥料用量，并跟踪作物健康状况. 这使农民能够减少一氧化二氮的排放，这是一种比二氧化碳强 298 倍的温室气体.

### Food

- [Foods for Tomorrow / Heura](https://www.heurafoods.com/en-GB/home)  | 西班牙巴塞罗那 |  2017年

  创建了一种名为 Heura 的成分，它代表了新一代植物蛋白，使用创新的生产技术获得植物领域从未见过的质地. 与生产相同数量的小牛肉蛋白相比，Heura 需要的水少 94%，而且每生产 1 公斤大豆仅需 0.5 公斤大豆.

- [Impossible Foods](https://impossiblefoods.com/)  | 美国加利福尼亚 |  2011年

  与传统汉堡相比，他们的植物基汉堡需要的土地减少 96%，水减少 87%，温室气体排放减少 89%. 他们的使命是生产植物性肉类，以减少肉类行业对环境的影响.

- [HappyCow](https://www.happycow.net/)  | 美国加利福尼亚 |  1999

  通过在世界各地寻找美味的素食或素食来减少或完全避免吃肉.

- [Karma](https://new.karma.life/)  | 瑞典 |  2016年

  帮助餐馆、咖啡馆和杂货店以折扣价出售多余的食物. 结果，用户以更少的成本获得食物，企业获得额外的收入来源——同时减少食物浪费.

- [Olio](https://olioex.com/)  | 英国 |  2015年

  用于食物共享的移动应用程序，旨在减少食物浪费. 它通过将那些有剩余食物的人与那些需要或希望食用这些食物的人联系起来来做到这一点. 食物必须是可食用的； 它可以是生的或煮熟的，密封的或打开的.

- [Too Good To Go](https://toogoodtogo.com/en)  | 法国 |  2016年

  让餐馆、商店、面包店和咖啡馆有可能在一天结束时出售未售出的食品. 由于无法提前知道当天的未售出情况，用户会得到一个约 500 克食物的“惊喜篮子”. 与 Karma 非常相似，但更多地出现在法国.

### Materials

- [Boston Metal](https://www.bostonmetal.com/)  | 美国波士顿 |  2012

  开发了一种以可扩展且具有成本效益的方式生产无排放钢的新技术. 截至 2020 年，自第一座反应堆投入使用以来，他们生产了超过 1000 公斤的金属合金.

- [Cellugy](https://cellugy.com/)  | 丹麦 |  2018

  提供一种由食物和蔬菜废料制成的生物材料，可用于包装以替代塑料. 这种材料是半透明的、坚固的，并且可以在家庭堆肥.

- [Organicbasics](https://organicbasics.com)  | 丹麦 |  2015年

  提供在欧洲有意识地制造的内衣、必需品和运动服. 用于生产的材料仅是天然、可再生、可回收、可生物降解和/或低影响的纺织品.

- [SkyCool Systems](http://skycoolsystems.com)  | 美国加利福尼亚 |  2016年

  为基于蒸汽压缩的冷却系统制造附件，减少用电量，同时自身实现二氧化碳中和.

### Water

- [The great bubble barrier](https://thegreatbubblebarrier.com)  | 荷兰 |  2016年

  开发了一个系统，该系统使用放置在河底的带孔管. 通过管子泵送空气会产生气泡屏障或气幕. 气泡迫使水中的塑料浮出水面，便于清除.

- [The Ocean Cleanup](https://theoceancleanup.com/)  | 荷兰 |  2013

  开发了一种被动收集海洋垃圾的技术，目标是到 2040 年清洁海洋中 90% 的塑料垃圾.2018 年，他们在大太平洋垃圾带部署了他们的解决方案.

- [Ocean Voyages Institute](https://www.oceanvoyagesinstitute.org/)  | 美国檀香山 |  1979

  由国际水手、教育家和环保主义者创立的非营利组织，其使命是教授海洋艺术和科学并保护世界海洋. 他们在太平洋完成了多次清理探险，最近一次是在 2020 年 6 月，他们从大太平洋垃圾带中清除了 103 吨渔网和消费塑料.

- [Orbital Systems](https://orbital-systems.com/)  | 瑞典 |  2012

  与 NASA 合作开发了一种用水量减少 90% 的淋浴系统. 淋浴有一个净化系统，可以重复使用同一批水. 该公司现在希望将这项最初为太空开发的技术提供给消费者.

- [Refill App](https://refill.org.uk/)  | 英国 |  2015年

  这是一款应用程序，可让您找到英国各地的免费加水站. 目前全国有超过20,000个免费站. 该应用程序还会跟踪节省的瓶子、节省的碳，并在您每次为保护地球的露营活动重新装满瓶子时捐赠 13 便士.

- [Seabin Project](https://seabinproject.com/)  | 澳大利亚 |  2016年

  Their mission is to reduce plastic in the oceans through a floating rubbish bin that collect pollutants on the water surface. As of October 2019 they have deployed 719 Seabins and are capturing almost 3 tonnes of rubbish per day.

- [Solar Water Solutions](https://solarwatersolutions.fi/en/)  | 芬兰 |  2015年

  开发用于生产饮用水的反渗透技术，运营费用低且无二氧化碳排放. 海水淡化系统完全采用太阳能，不依赖外部能源，易于使用和维护.

- [Zero Mass Water](https://www.zeromasswater.com/)  | 美国斯科茨代尔 |  2014

  生产 Hydropanels，这是一种独立系统，依靠太阳能将空气湿度转化为清洁的饮用水.

### Energy

- [Bulb](https://bulb.co.uk/)  | 英国 |  2013

  英国最大的绿色供应商. 他们为会员提供 100% 来自太阳能、风能和水力的可再生电力. 另外，该气体是 100% 碳中和的.  10% 是从食物或农场废弃物等可再生资源中产生的绿色气体.

- [Carbon Engineering](https://carbonengineering.com/)  | 加拿大 |  2009

   Carbon Engineering 旨在使用直接空气捕获技术直接从空气中提取现有的 CO <sub>2</sub> ，​​然后使用该气体为飞机、卡车和轮船制造碳中性合成燃料.  Carbon Engineering 由多个政府和可持续发展机构以及私人投资者资助，包括比尔盖茨和油砂巨头诺曼默里爱德华兹.

- [ChargePoint](https://www.chargepoint.com/)  | 美国加利福尼亚 |  2007年

  ChargePoint 运营着一个开放式电动汽车 (EV) 充电网络，并在其中使用技术.

- [ElectricityMap.org](https://www.electricitymap.org/)  | 丹麦/法国 |  2017年

  一家软件公司，基于开源贡献，提供对 90 多个国家/地区电力来源及其相关碳排放的实时和历史数据的访问权限.

- [Gogoro](https://www.gogoro.com/)  | 台湾 |  2011年

  开发和销售电动滑板车和电池更换基础设施.

- [Hydrostor](https://www.hydrostor.ca/)  | 加拿大 |  2010

  将电能转换为压缩空气，储存在水下蓄能器中. 一旦进入蓄能器，能量就可以储存起来，直到电网需要为止. 当需要能量时，水的重量将空气推回表面，在那里使用发电机将其转化为电能.

- [Inspire](https://www.helloinspire.com/)  | 美国费城 |  2014

  通过向与智能家居技术相结合的房主提供一系列负担得起的清洁能源计划，简化消费者对清洁能源的采用.

- [Marcel](https://www.marcel.cab/engagements-rse/)  | 法国 |  2011年

  像优步这样的在线出租车应用程序提供了使用电动汽车的可能性，并与 GoodPlanet 基金会合作，以充分补偿其乘车产生的碳. 自 2019 年以来，它仅在法国有售.

- [Momentum Dynamics](https://www.momentumdynamics.com/)  | 美国宾夕法尼亚 |  2009

  为汽车和运输行业开发无线充电技术. 允许任何类型的车辆或设备在不使用电缆或电线的情况下连接到电网.

- [Nel ASA](https://nelhydrogen.com/)  | 挪威 |  1927年

  提供用于从可再生能源中生产、储存和分配氢气的解决方案.

- [Open Climate Fix](https://openclimatefix.github.io)  | 英国伦敦 |  2019

  非营利性研发实验室，专注于通过解决机器学习问题来减少温室气体排放. 截至 2019 年，他们正在开发一个预测系统，以减少使用太阳能的电网上的燃气轮机备用.

- [Redflow](https://redflow.com/)  | 澳大利亚布里斯班 |  2001年

  制造可在恶劣条件下承受日常艰苦工作且容量随时间降低最小的锌溴液流电池，适用于住宅和工业装置的解决方案.

- [Rocky Mountain Institute](https://rmi.org/)  | 美国科罗拉多 |  1982年

  有影响力的研究机构，其使命宣言是“……改变全球能源使用方式，创造一个清洁、繁荣和安全的低碳未来”. 由 Amory Lovins 共同创立，他是物理学家和《软能量路径》的作者.

- [Siemens](https://new.siemens.com/in/en.html)  | 德国 |  1847年

  跨国制造公司. 在他们的众多项目中，他们生产风力涡轮机并提供陆上和海上风力服务. 截至 2018 年，它是世界第三大风力涡轮机制造商.

- [Solar City](https://www.tesla.com/solarpanels)  | 美国加利福尼亚 |  2006年

  目前的产品包括太阳能电池板屋顶，它可以收集尽可能多的电力，而不像太阳能电池板，以及家庭储能解决方案 Powerwall.

- [Sonnen](https://sonnenusa.com)  | 德国 |  2010

  为家庭生产储能解决方案. 此外，他们目前提供在德国运营的最大的可再生能源电力共享网络.

- [Suzlon Energy Ltd.](https://www.suzlon.com/) | India | 1995

  风力涡轮机制造商遍布各大洲的 18 个国家/地区.

- [Tesla](https://www.tesla.com/solarpanels)  | 美国加利福尼亚 |  2003年

  专门从事电动汽车制造，并通过其子公司 SolarCity 从事太阳能电池板制造.

- [Ushva Clean Technology](http://www.ushva.com/)  | 印度孟买 |  2015年

  他们相信在不影响便利性的情况下优化能源消耗，然后中和剩余的能源需求. 他们的愿景是提供可负担得起的可再生资源电力，不受地理和传输限制.

- [Vestas](https://www.vestas.com/)  | 丹麦 |  1945年

  风力涡轮机的制造商、销售商、安装商和服务商. 截至 2019 年，维斯塔斯已在五大洲的 80 多个国家/地区安装了 66,000 多台风力涡轮机，装机容量达 100 吉瓦.

- [WindCORES](https://www.windcores.de/en/homepage/)  | 德国 |  2018

  德国风能开发商 Westfalenwind 的子公司. 他们是一家数据中心提供商，在风力涡轮机内托管服务器，拉近电力消费者与生产商的距离.

### Social Impact

- [Billions in Change](https://billionsinchange.com/)  | 美国 |  2015年

   Billions in Change 开发并提供发明，帮助世界上不幸的一半人获得基本需求，如清洁水、可靠的电力和充足的食物. 这些基本要素为教育、健康和生计奠定了基础，使人们能够改善自己和家人的生活.

- [Doconomy](https://doconomy.com/)  | 瑞典 |  2018

  金融科技公司通过提供使用二氧化碳排放量作为支出限额的信用卡来促进消费减少.

- [Ducky](https://www.ducky.eco/en/)  | 挪威 |  2014

  提供一系列基于气候和环境研究数据的产品，您可以在他们的气候计算器中监控您的个人足迹，了解气候心理学，并通过友好的团队竞赛减少碳排放.

- [Ecosia](https://ecosia.org/)  | 德国 |  2009

  将其盈余收入捐赠给专注于重新造林的非营利组织的互联网搜索引擎. 根据他们的网站，截至 2019 年 7 月，他们已负责种植 6000 万棵树.

- [Ewally](https://ewally.com.mx/)  | 墨西哥 |  2017年

  系统和应用程序，提供完整和环保的垃圾收集服务，促进回收文化. 海洋和垃圾之间的墙.

- [Tomorrow](https://tmrow.com/)  | 丹麦/法国 |  2018

  通过连接到您已经使用的应用程序和服务来计算您日常选择的气候影响的应用程序：您的个人和自动碳追踪器.

- [Triodos Bank](https://www.triodos.com)  | 荷兰 |  1980

  面向消费者和企业的欧洲银行，只向做出积极的环境和社会变革的组织提供贷款. 他们对可再生能源系统进行了大量投资，并在其网站上公布了他们资助的每个组织的详细信息.

- [Unmade](https://unmade.com/)  | 英格兰 |  2013

  通过按需大规模生产服装，减少时尚行业的浪费.  Unmade 的诞生源于对时尚行业设计和制造流程的重新构想，因此品牌只生产实际销售的产品，从而将浪费降至最低.

## More Resources

- [ClimateTechList](https://www.climatetechlist.com/) - 约 50 家气候技术公司的精选名单，专门针对软件工程师，包括每家公司的描述、它们的软件影响和气候影响.
- [Breakthrough Energy Ventures](https://www.b-t.energy/) - 由比尔盖茨和一群私人投资者支持的风险基金，承诺资本超过 10 亿美元，用于建立有助于阻止气候变化的公司.
- [Clean Tech Finland](http://www.cleantechfinland.com/web/cleantech) - 芬兰清洁技术公司的中心.
- [Clean Tech Sweden](https://swedishcleantech.com/) - 瑞典清洁技术公司的中心.
- [r/ClimateActionPlan](https://www.reddit.com/r/ClimateActionPlan/) - 在面对气候变化时给予人们希望的 subreddit.
- [Climate Choice](https://climatechoice.co/) - 一个非营利项目，其中包含有关减少气候变化的可操作指南以及有关气候变化的教育信息.
- [Mattermore.io](https://www.mattermore.io/)  - 通讯强调使用人工智能和数据科学扭转气候变化的公司； 有助于发现每周交付的新计划/工作机会.
- [Norrsken Foundation](https://www.norrsken.org/) - 支持和投资对社会有积极影响的组织的瑞典基金会.

## Research

- [Environmental Protection Agency](https://www.epa.gov/climate-research) - 研究气候变化的影响和解决方案.
- [Intergovernmental Panel on Climate Change](https://www.ipcc.ch/library/) - 联合国气候变化相关科学评估机构.
- [Mercator Research Institute on Global Commons and Climate Change](https://www.mcc-berlin.net/en.html) - 为治理全球公域提供以解决方案为导向的政策路径，以加强可持续发展和人类福祉.
- [NASA climate](http://climate.nasa.gov/) - 地球的生命体征、事实和解决方案.
- [U.N Climate Change National Inventory Submissions](https://unfccc.int/process-and-meetings/transparency-and-reporting/reporting-and-review-under-the-convention/greenhouse-gas-inventories-annex-i-parties/national-inventory-submissions-2019)  - 这包含来自几个联合国国家的国家特定气候报告. 它具有从 2003 年开始的数据.

## License

本作品及其所有贡献均根据以下条款发布到公共领域 [CC0 1.0](https://github.com/nglgzz/awesome-clean-tech/blob/master/./LICENSE).
