<div class="github-widget" data-repo="hkirat/awesome-chess"></div>
## Awesome Chess [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

互联网上可用的与国际象棋相关的精选资产列表.

*灵感来自 [awesome](https://github.com/sindresorhus/awesome) 列出事情. 你可能想阅读完整 [awesome](https://github.com/sindresorhus/awesome) 列表.*

### Contributing
请通过 [Contribution Guidelines](https://github.com/hkirat/awesome-chess/blob/master/CONTRIBUTING.md#contribution-guidelines) 第一的.

Content
---

Books
---
*有关国际象棋的书籍.*

 - [Chess Problems](https://kairavacademydotcom.files.wordpress.com/2013/06/john-thursby-75-chess-problems.pdf) - 国际象棋谜题的集合.
 - [Chess strategy](http://www.gutenberg.org/cache/epub/5614/pg5614-images.html) - 爱德华·拉斯克 (Edward Lasker) 的 HTML 版国际象棋策略.
 - [Sicilian Dragon](http://www.chesscity.com/PDF/Sicilian_Dragon_Black_Attacks_ssd.pdf) - 黑色的攻击计划.

FEN 解析器
---
*Forsyth–Edwards 符号 (FEN) 是描述国际象棋游戏特定棋盘位置的标准符号.*

 - [fenparser by tlehman](https://github.com/tlehman/fenparser) - 用 Python 编写的 Forsyth-Edwards Notation 解析器.
 - [fen by ucarion](https://github.com/ucarion/fen) - 具有适当错误处理的 Rust Forsyth-Edwards 符号解析器.
 - [fen-diagram by andyherbert](https://github.com/andyherbert/fen-diagram) - 使用 Forsyth-Edwards 符号生成国际象棋图的 JavaScript.

Bots
---
*机器人是涉及人工智能的算法，可以与用户对战.*

 - [latrunculorum](https://github.com/benwr/latrunculorum) - 一个简单的 Python 国际象棋机器人.
 - [Chessbot](https://github.com/jfabeel/Chessbot) - 用 Ja​​va 编写的机器人.

移动验证器
---
*验证器是检查移动真实性的工具.*

 - [chess.js](https://github.com/jhlywa/chess.js) - chess.js，用于国际象棋身份验证的结构化代码.
 - [npm chess package](https://www.npmjs.com/package/chess) - 一个代数符号驱动的国际象棋引擎，可以验证棋盘位置并生成可行动作列表.
 - [Chessnut](https://github.com/cgearhart/Chessnut.git)  - Chessnut 是一个用 Python 编写的简单棋盘模型. 它提供解析 FEN 并为每个 FEN 表示生成合法移动列表的功能.

Websites
---
*网站包括供人们下棋的平台.*

 - [multiplayerchess.com](http://multiplayerchess.com) - 一个简单的单页国际象棋下棋应用程序，有助于下棋.
 - [lichess.org](http://en.lichess.org/)  - 最成熟的互联网下棋平台之一. 它也是开源的. 它配有日常拼图和一台电视，可以观看其他比赛.
 - [chess24.com](https://chess24.com/en/play/chess) - 通过最好的教程从 chess24 下棋和学棋.
 - [chessbase.com](http://play.chessbase.com/js/apps/playchess/) - 利润丰厚的单页下棋应用程序. 
 - [chess.com](http://www.chess.com/) - 与超过 500 万其他用户一起学习和下棋.
 - [chesscademy.com](https://www.chesscademy.com/)  - 观看视频、解谜和玩游戏. 全部免费.  （类似于可汗学院.）
 - [chesstempo.com](http://chesstempo.com) - 在线国际象棋战术培训网站.
 - [chessprogramming.wikispaces.com](https://chessprogramming.wikispaces.com/) - 有关编程计算机下棋的信息存储库.
 - [freechess.org](http://freechess.org/)  - “免费互联网国际象棋服务器”(FICS) 是最古老的互联网国际象棋服务器之一. 几乎所有可用的设备、操作系统或网络浏览器都有大量客户端应用程序.

Boards
---
*Boards是封装渲染board的过程的工具*

 - [Chessboard.js](https://github.com/oakmac/chessboardjs/) - chessboard.js 是一个独立的 JavaScript 棋盘.
 - [chess-board](https://github.com/laat/chess-board)  - 用于显示国际象棋位置的网络组件. 它以 FEN 字符串作为输入，并将电路板作为输出.
 - [jchess](https://github.com/bmarini/jchess)  - 基于 jQuery 的 JavaScript 库，用于解析和显示国际象棋游戏. 目前以 FEN 和 PGN 作为输入.
 - [Chessboard-js](https://github.com/caustique/chessboard-js) - 响应式移动优先 JavaScript 棋盘库.

董事会符号
---
*符号是一种以文本格式表达棋盘属性的方式. [Tutorial on Chess Notations](http://chess.eusa.ed.ac.uk/Chess/Rules/notation.html).*

 - [FEN](https://en.wikipedia.org/wiki/Forsyth%E2%80%93Edwards_Notation) - FEN“记录”定义了一个特定的游戏位置，全部在一个文本行中并且仅使用 ASCII 字符集.
 - [PNG](http://www6.chessclub.com/help/PGN-spec) - PGN 的结构“便于人类用户阅读和编写，也便于计算机程序解析和生成”. 
 - 其他符号
 	- [Algebraic Chess Notation](https://en.wikipedia.org/wiki/Algebraic_notation_(chess))
 	- [ICCF numeric notation](https://en.wikipedia.org/wiki/ICCF_numeric_notation) - 所有国际通信国际象棋联合会游戏的官方国际象棋游戏符号.
 	- [Smith Chess Notation](http://www6.chessclub.com/chessviewer/smith.html)
 	- [Descriptive Notation](https://en.wikipedia.org/wiki/Descriptive_notation)

Pieces
---
*这包括用于获取各种国际象棋作品的工具.*

 - [Spiral Pieces in 3-D](https://www.thingiverse.com/thing:470700)
 - [Pieces on Wikipedia](https://commons.wikimedia.org/wiki/Category:PNG_chess_pieces/Standard_transparent)
 - [Chess Pieces in Unicode](https://en.wikipedia.org/wiki/Chess_symbols_in_Unicode)
 - [Icons on flaticons](http://www.flaticon.com/search/chess)
 - [Icons on thenounproject](https://thenounproject.com/search/?q=chess)

Talks
---
*关于国际象棋的谈话.*
 
 - [Understanding Chess Mastery](https://www.youtube.com/watch?v=fPopQaY7Og4) - 詹妮弗·沙哈德 (Jennifer Shahade) 关于理解国际象棋精通的谈话.
 - [How Chess Can Revolutionize Learning](https://www.youtube.com/watch?v=A3yDvM8aplY) - 谈论国际象棋如何彻底改变 Cody Pomeranz 的学习方式.
 - [Working backward to solve problems](https://www.youtube.com/watch?v=v34NqCbAA1c) - Maurice Ashley 谈逆向解决问题
 - [Chess Life](https://www.youtube.com/watch?v=lgCSo1Txw3c)
 - [Why Chess is Boring ](https://www.youtube.com/watch?v=7EuxVOgrEig) - Bobby Fischer 谈国际象棋为什么无聊
 - [Chess Peeps](https://www.youtube.com/watch?v=p027ysBt0_M)
