<div class="github-widget" data-repo="exAspArk/awesome-chatops"></div>
## Awesome ChatOps [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

一系列令人敬畏的事情 [ChatOps](https://www.pagerduty.com/blog/what-is-chatops/).

ChatOps 是一种协作模型，有助于将人员、流程、工具和自动化连接到一个透明的工作流（对话驱动的开发）中.
因此，它允许自动化任务和协作，鼓励团队变得透明，工作得更好、成本更低、速度更快.

如果你想贡献，请阅读 [CONTRIBUTING.md](https://github.com/exAspArk/awesome-chatops/blob/master/./CONTRIBUTING.md).



## Articles

* [So, What is ChatOps? And How do I Get Started?](https://www.pagerduty.com/blog/what-is-chatops/) – ChatOps 概念和工具.
* [What is ChatOps? A guide to its evolution, adoption, and significance](http://blogs.atlassian.com/2016/01/what-is-chatops-adoption-guide/) – ChatOps 及其被 HipChat Evangelist 采用.
* [How ChatOps can revolutionize your business](http://www.infoworld.com/article/3062703/devops/how-chatops-can-revolutionize-your-business.html) – 使用 ChatOps、工具、当前趋势和未来的好处.
* [8 Reasons Why ChatOps Isn't Working At Your Company](https://orangematter.solarwinds.com/2015/12/16/8-reasons-why-chatops-isnt-working-at-your-company/) – 关于为什么 ChatOps 可能未在您的公司进行优化的见解，以及如何使其发挥作用的一些建议.
* [When ChatOps Goes From Cool to Critical](https://web.archive.org/web/20180323063754/http://blog.librato.com/posts/chatops-critical) – Librato 对 ChatOps 的一些考虑.
* [Better Living Through ChatOps](https://medium.com/ibm-garage/better-living-through-chatops-df66872893e7) - ChatOps 在管理虚拟作战室方面的优势.
* [Making a Virtual War Room — the Journey to ChatOps](https://medium.com/ibm-garage/making-a-virtual-war-room-the-journey-to-chatops-eaaecd83873c) - 逐步创建虚拟作战室.

## Videos

* [ChatOps at GitHub](https://www.youtube.com/watch?v=NST3u-GjjFw) + [slides](https://speakerdeck.com/jnewland/chatops-at-github) – 杰西·纽兰 (Jesse Newland) 就此主题的首次公开演讲.
* [ChatOps: Technology and Philosophy](https://www.youtube.com/watch?v=IhzxnY7FIvg) – Stackstorm 的 James Fryman 关于实施和维护 ChatOps 的理念、最佳实践.
* [The Rise of ChatOps](https://www.youtube.com/watch?v=6D5HgI4IH10) + [slides](https://speakerdeck.com/jimmycuadra/the-rise-of-chatops) – 来自 Jimmy Cuadra 的第一次 ChatOps 旧金山聚会.
* [ChatOps: Augmented Reality for Ops](https://www.youtube.com/watch?v=pCVvYCjvoZI) – Github 如何使用聊天来提高事件期间的态势感知、共享知识、协调活动等等.
* [Living in the Future with ChatOps](https://www.youtube.com/watch?v=Heo5YtRikds) + [slides](https://speakerdeck.com/esigler/living-in-the-future-with-chatops) – Eric Sigler 对 PagerDuty 的 ChatOps 旅程的快速总结.
* [Incident Management from the Future](https://www.youtube.com/watch?v=vFkfMn2P8ysA) + [slides](https://cloud.app.box.com/s/xm8ni5b61iyuk0nclq7jcvtkhkzcepdx) – Michael Ansel 如何通过 Box 聊天来管理事件.
* [ChatOps San Francisco YouTube Channel](https://www.youtube.com/channel/UCAvvR4g9fodNAS61Ep_XnMg) – 来自每次聚会的更多视频.
* [Installing Hubot on Windows with PowerShell DSC](https://www.youtube.com/watch?v=Gh-vYprIo7c) - 使用 Hubot PowerShell Desired State Configuration (DSC) 资源在 Windows 上安装 Hubot.
* [Embrace ChatOps, stop installing deployment software](https://www.youtube.com/watch?v=SZ3UfwBACIo) + [slides](http://www.slideshare.net/geshan/embrace-chatops-stop-installing-deployment-software-larcon-eu-2016) - 来自 Laracon EU 2016 的关于如何利用 ChatOps 使用 Hubot 进行自动化部署的演讲.
* [ChatOps with PowerShell and Errbot](https://www.youtube.com/watch?v=XIMOFnfdOx0) - 2017 年欧洲 PowerShell 大会上关于如何使用 PowerShell 在 Windows 上开始使用 Errbot 的演讲.
* [ChatOps with PoshBot and PowerShell](https://www.youtube.com/watch?v=36fkyKYq43c) - PoshBot 概述，PoshBot 是波特兰 PowerShell 用户组中基于 PowerShell 的机器人框架.

## Books

* [ChatOps For Dummies](https://victorops.com/chatops-for-dummies/) – 了解实践起源、好处和入门所需工具的高级指南.
* [ChatOps – Managing Operations in Group Chat](https://victorops.com/knowledge-drop/devops-docs/chatops-managing-operations-group-chat/) – Jason Hand 的关键 ChatOps 概念和技术.
* [Automation and Monitoring with Hubot](https://leanpub.com/automation-and-monitoring-with-hubot) - 一本电子书，引导您构建 Hubot 驱动的 ChatOps 实施.

## Events

* [ChatOps San Francisco](http://www.meetup.com/ChatOps-San-Francisco/) – 关于 ChatOps 各个方面的讨论和协作，包括工具、安全性和方法论.

## Podcasts

* [ChatOps Extravaganza With Jason Hand, Sasha Rosenbaum, And Peter Burkholder](https://www.arresteddevops.com/chatops/) – 关于 ChatOps 最佳实践的一集.
* [ChatOps with Jason Hand](http://softwareengineeringdaily.com/2016/11/02/chatops-with-jason-hand/) - 关于 ChatOps 的一集.

## Resources

* [/r/chatops](https://www.reddit.com/r/chatops/) – 带有文章和讨论的 Subreddit.

## Services

* [Abbot](https://ab.bot) – a hosted bot, extendible in C#, Python, and JavaScript. Integrates with Slack and Discord.
* [AWS ChatBot](https://aws.amazon.com/chatbot/) - 一个交互式代理，用于监控 Slack 中的 AWS 资源并与之交互.
* [marbot](https://marbot.io/) - 配置 AWS 监控、接收警报并解决 Slack 或 Microsoft Teams 中的事件.

## Frameworks and libraries

这些开源项目将帮助您构建一个机器人，根据平台自动进行公司聊天.


### AIM

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/shaundubuque/hubot-aim) （咖啡脚本，Node.js）

### Campfire

* [Errbot](http://errbot.io/) + [adapter](https://github.com/errbotio/err-backend-campfire) （Python）
* [Hal](https://hal.readthedocs.io/) + [adapter](https://hal.readthedocs.io/en/latest/adapters/campfire.html) （去）
* [Hubot](https://hubot.github.com/) + [adapter](https://hubot.github.com/docs/adapters/campfire/) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/josacar/lita-campfire) （红宝石）

### ChatWork

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/akiomik/hubot-chatwork) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/tokada/lita-chatwork) （红宝石）

### Dasher

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/nebulist/hubot-dasher) （咖啡脚本，Node.js）

### Discord

* [Discordrb](https://github.com/meew0/discordrb) （红宝石）
* [Errbot](http://errbot.io/) + [adapter](https://github.com/gbin/err-backend-discord) （Python）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/kyleboe/lita-discord) （红宝石）

### Facebook Messenger

* [Botkit](https://github.com/howdyai/botkit) （JavaScript，Node.js）
* [FacebookMessenger](https://github.com/hyperoslo/facebook-messenger) （红宝石）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/ClaudeBot/hubot-messenger-bot) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/ASoftCo/lita-facebook) （红宝石）
* [Opsdroid](https://opsdroid.github.io/) + [connector](https://github.com/opsdroid/connector-facebook) （Python）

### Fleep

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/anroots/hubot-fleep) （咖啡脚本，Node.js）

### Flowdock

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/flowdock/hubot-flowdock) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/bhouse/lita-flowdock) （红宝石）

### Gitter

* [Errbot](http://errbot.io/) + [adapter](https://github.com/errbotio/err-backend-gitter) （Python）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/huafu/hubot-gitter2) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/braiden-vasco/lita-gitter) （红宝石）

### HipChat

* [Cog](https://operable.io/) （任何语言）
* [Errbot](http://errbot.io/) （Python）
* [Hal](https://hal.readthedocs.io/) + [adapter](https://hal.readthedocs.io/en/latest/adapters/hipchat.html) （去）
* [Hipbot](https://github.com/pewniak747/hipbot) （红宝石）
* [Hipchat](https://github.com/daneharrigan/hipchat) 通过 XMPP (Go)
* [Hipchat-go](https://github.com/tbruyelle/hipchat-go) 通过 HipChat API v2 (Go)
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/hipchat/hubot-hipchat) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/litaio/lita-hipchat) （红宝石）
* [Will](https://skoczen.github.io/will/) （Python）

### Idobata

* [Lita](https://www.lita.io/) + [adapter](https://github.com/fukayatsu/lita-idobata) （红宝石）

### iMessage

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/lazerwalker/hubot-imessage) （咖啡脚本，Node.js）

### IRC

* [Cinch](https://github.com/cinchrb/cinch) （红宝石）
* [Errbot](http://errbot.io/) （Python）
* [Hal](https://hal.readthedocs.io/) + [adapter](https://hal.readthedocs.io/en/latest/adapters/irc.html) （去）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/nandub/hubot-irc) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/litaio/lita-irc) （红宝石）
* [PagerBot](https://github.com/stripe-contrib/pagerbot) （红宝石）
* [Yetibot](https://github.com/yetibot/yetibot) (Clojure)

### Jabbr

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/smoak/hubot-jabbr) （咖啡脚本，Node.js）

### Let's chat

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/sdelements/hubot-lets-chat) （咖啡脚本，Node.js）

### Lingr

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/miyagawa/hubot-lingr) （咖啡脚本，Node.js）

### Matrix

* [Opsdroid](https://opsdroid.github.io/) + [connector](https://github.com/opsdroid/connector-matrix) （Python）

### Mattermost

* [Errbot](http://errbot.io) + [adapter](https://github.com/Vaelor/errbot-mattermost-backend) （Python）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/renanvicente/hubot-mattermost) （咖啡脚本，Node.js）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/loafoe/hubot-matteruser) 通过 Websockets（CoffeeScript、Node.js）

### Partychat

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/iangreenleaf/hubot-partychat-hooks) （咖啡脚本，Node.js）

### QQ

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/xhan/qqbot) （咖啡脚本，Node.js）

### Rocket.Chat

* [Errbot](http://errbot.io) + [adapter](https://github.com/AoiKuiyuyou/AoikRocketChatErrbot) （Python）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/RocketChat/hubot-rocketchat) （咖啡脚本，Node.js）
* [Opsdroid](https://opsdroid.github.io/) + [connector](https://docs.opsdroid.dev/en/stable/connectors/rocketchat.html) （Python）

### Skype

* [Errbot](http://errbot.io/) + [adapter](https://github.com/errbotio/errbot-backend-skype) （Python）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/netpro2k/hubot-skype) （咖啡脚本，Node.js）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/sdimkov/hubot-skype-web) 通过网络（CoffeeScript、Node.js）

### Skyweb

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/EllisV/hubot-skyweb) （咖啡脚本，Node.js）

### Slack

* [Botkit](https://github.com/howdyai/botkit) （JavaScript，Node.js）
* [Bolt](https://slack.dev/bolt/concepts) （JavaScript，Node.js）
* [Cog](https://operable.io/) （任何语言）
* [Elixir-Slack](https://github.com/BlakeWilliams/Elixir-Slack) (长生不老药)
* [Errbot](http://errbot.io/) （Python）
* [Gort](https://guide.getgort.io/) （任何语言）
* [Hal](https://hal.readthedocs.io/) + [adapter](https://hal.readthedocs.io/en/latest/adapters/slack.html) （去）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/slackhq/hubot-slack) （咖啡脚本，Node.js）
* [Jubot](https://github.com/liquidz/jubot) (Clojure)
* [Lita](https://www.lita.io/) + [adapter](https://github.com/litaio/lita-slack) （红宝石）
* [Multivac](https://github.com/vektorlab/multivac) （蟒蛇，码头工人）
* [Opsdroid](https://opsdroid.github.io/) + [connector](https://github.com/opsdroid/connector-slack) （Python）
* [PagerBot](https://github.com/stripe-contrib/pagerbot) （红宝石）
* [PoshBot](https://github.com/poshbotio/PoshBot) （电源外壳）
* [Slack-Ruby-Bot](https://github.com/dblock/slack-ruby-bot) （红宝石）
* [Slackbotsy](https://github.com/rlister/slackbotsy) （红宝石）
* [Slacker](https://github.com/koudelka/slacker) (长生不老药)
* [Yetibot](https://github.com/yetibot/yetibot) (Clojure)

### Spark

* [Opsdroid](https://opsdroid.github.io/) + [connector](https://github.com/opsdroid/connector-ciscospark) （Python）

### Talker

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/unixcharles/hubot-talker) （咖啡脚本，Node.js）

### Telegram

* [Errbot](http://errbot.io/) （Python）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/lukefx/hubot-telegram) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/wonderbread/lita-telegram) （红宝石）
* [Opsdroid](https://opsdroid.github.io/) + [connector](https://github.com/opsdroid/connector-telegram) （Python）
* [Telegram-bot-ruby](https://github.com/atipugin/telegram-bot-ruby) （红宝石）
* [TelegramBot](https://github.com/hangyas/TelegramBot) （水晶）
* [TelegramBot](https://github.com/eljojo/telegram_bot) （红宝石）

### Tox

* [Errbot](http://errbot.io/) + [adapter](https://github.com/errbotio/err-backend-tox) （Python）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/braiden-vasco/lita-tox) （红宝石）

### Twilio

* [Botkit](https://github.com/howdyai/botkit) 通过 IP 消息传递（JavaScript、Node.js）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/philnash/hubot-twilio-ip-messaging) 通过 IP 消息传递（CoffeeScript、Node.js）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/jkarmel/hubot-twilio) 通过短信（CoffeeScript、Node.js）

### Twitter

* [Chatterbot](https://muffinista.github.io/chatterbot/) （红宝石）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/MathildeLemee/hubot-twitter) （咖啡脚本，Node.js）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/fukayatsu/lita-twitter) （红宝石）
* [Opsdroid](https://opsdroid.github.io/) + [connector](https://github.com/opsdroid/connector-twitter) （Python）

### Typetalk

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/nulab/hubot-typetalk) （咖啡脚本，Node.js）

### VictorOps

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/victorops/hubot-victorops) （咖啡脚本，Node.js）

### Visual Studio Online

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/scrumdod/hubot-VSOnline) （咖啡脚本，Node.js）

### Vkontakte

* [Errbot](http://errbot.io) + [adapter](https://github.com/Ax3Effect/errbot-vk) （Python）
* [Lita](https://www.lita.io/) + [adapter](https://github.com/braiden-vasco/lita-vkontakte) （红宝石）

### WeChat

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/KasperDeng/Hubot-WeChat) （咖啡脚本，Node.js）

### XMPP / Jabber

* [Errbot](http://errbot.io/) （Python）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/markstory/hubot-xmpp) （咖啡脚本，Node.js）
* [Jabberjay](https://github.com/vbauer/jabberjay) (Clojure)

### Yammer

* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/athieriot/hubot-yammer) （咖啡脚本，Node.js）

### Zulip

* [Errbot](http://errbot.io/) + [adapter](https://github.com/zulip/errbot-backend-zulip) （Python）
* [Hubot](https://hubot.github.com/) + [adapter](https://github.com/zulip/hubot-zulip) （咖啡脚本，Node.js）

---

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)
