<div class="github-widget" data-repo="zingchart/awesome-charting"></div>

<img src="https://cdn.rawgit.com/zingchart/awesome-charting/media/assets/awesome-charting.svg" alt="awesome">

开发人员可能会觉得有用的图表和数据可视化资源的精选列表. 专注于针对不同用例的相关且当前活跃的 JavaScript 图表库. 在每个类别中按字母顺序排列.

*灵感来自<a href="https://github.com/sindresorhus/awesome">Awesome</a>事物.*


带给你 

[![ZingChart](https://github.com/zingchart/awesome-charting/blob/assets/assets/zingchart-logo-full-color.svg?raw=true)](https://www.zingchart.com)

用于构建响应式图表的声明式、高效且简单的 JavaScript 库

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Build Status](https://travis-ci.org/zingchart/awesome-charting.svg?branch=master)](https://travis-ci.org/zingchart/awesome-charting)


## Commercial Libraries
* [amCharts](https://www.amcharts.com/)  - 传统图表、股票和地图的三个库. 具有手绘风格主题选项.
* [AnyChart](http://www.anychart.com/)  - 用于绘制不同类型数据图表的产品集. 具有特殊的 Oracle Apex 集成选项.
* [CanvasJS](http://canvasjs.com/)  - 库中一组紧凑的图表类型，文件大小很小. 与其他商业图书馆不同的默认主题.
* [FusionCharts](http://www.fusioncharts.com/) - 具有强大地图组件的图表库.
* [Highcharts](http://www.highcharts.com/)  - 一系列用于各种用途的图表库. 可以兼容回IE6.
* [JSCharting](https://JSCharting.com/) - 一套集成的图表库，在一个包中包含传统图表类型以及地图、股票、甘特图、网格和组织图表.
* [Kendo UI](https://www.telerik.com/kendo-ui) - 具有适用于 Angular、React 和 Vue 的本机 UI 组件的高级图表库.
* [ZingChart](http://www.zingchart.com)  - 用于呈现其他库无法处理的大型数据集. 超级可定制的样式和经常添加的新功能. 一切都在一个模块化库中.

## Free and Open Source Libraries
* [apexcharts.js](https://github.com/apexcharts/apexcharts.js) - 具有简单 API 的 JavaScript 图表库.
* [Billboard.js](https://naver.github.io/billboard.js/) - 更紧密地跟踪 D3 发布的 C3 分支.
* [C3.js](http://c3js.org/) - 基于 D3 的可重用图表库.
* [Chart.js](http://www.chartjs.org/) - 包含核心图表类型的微型库（11kb！）.
* [Charts.css](https://chartscss.org/) - CSS 数据可视化框架.
* [Chartist](https://gionkunz.github.io/chartist-js/) - 简单、轻量级的图表库，使用 SVG 呈现图表，并使用 CSS 设置样式.
* [Chartkick](https://github.com/ankane/chartkick) - 一行 Ruby 代码的 JavaScript 图表.
* [D3.js](https://d3js.org/) - 允许用户根据数据操作文档以在 SVG 中呈现图表.
* [dc.js](https://dc-js.github.io/dc.js/) - D3库与 [crossfilter](http://square.github.io/crossfilter/) 支持
* [dygraphs](https://github.com/danvk/dygraphs) - 交互式可缩放时间序列图表.
* [ECharts](https://github.com/ecomfe/echarts) - 一个强大的浏览器图表和可视化库.
* [EJSChart](https://github.com/EmpriseCorporation/EJSCharts) - 企业就绪图表库.
* [Graphosaurus](https://github.com/frewsxcv/graphosaurus) - 由 WebGL (three.js) 提供支持的 3D 图形查看器
* [lightweight-charts](https://github.com/tradingview/lightweight-charts) - 使用 HTML5 canvas 构建的金融轻量级图表
* [Morris.js](http://morrisjs.github.io/morris.js) - 用于呈现折线图、条形图、面积图和圆环图的简单 API
* [Plotly](https://github.com/plotly/plotly.js) - 建立在 d3 和 stack.gl 之上，允许用户创建基本图表和 SVG 地图.
* [Plottable](https://github.com/palantir/plottable) - 具有 OOP 样式语法的库来构建图表.
* [QuickChart](https://github.com/typpo/quickchart) - 呈现静态图表图像的 Web API.
* [rgraph](http://www.rgraph.net/) - 具有谷歌表格导入功能的 2D/3D javascript 图表.
* [sigma.js](https://github.com/jacomyal/sigma.js) - 用画布构建的图形/网络图表库.
* [Smoothie Charts](https://github.com/joewalnes/smoothie) - 用于实时流数据的 JavaScript 图表.
* [TauCharts](https://www.taucharts.com/)  - 允许开发人员使用 DSL 描述数据的独特语法. 具有创建面的能力.
* [μPlot](https://github.com/leeoniya/uPlot) - 时间序列、线条、区域、ohlc 和条形图的小型（&lt; 25 KB 分钟）快速图表.
* [uvCharts](https://github.com/imaginea/uvCharts) - 使用 d3.js 构建的 JavaScript 图表库
* [vis.js](http://visjs.org/) - 网络图、带标签的描述性时间线和 3D 图形.
* [reaviz](https://reaviz.io) - React 的模块化图表组件库.
* [reaflow](https://reaflow.dev) - 用于构建静态或交互式编辑器的模块化图表引擎. 

## Free Libraries
* [Google Charts](https://developers.google.com/chart/)  - 拨入地图（当然）和一些很酷的动画选项. 广泛的文档和使用社区（论坛）.

## Framework-Specific Libraries
### Angular
* [Angular-Chart](http://jtblin.github.io/angular-chart.js)- 用于呈现折线图、条形图、面积图和圆环图的简单 API
* [n3-charts](https://github.com/n3-charts/line-chart) - 使用 AngularJS 编写的易于使用的库，使用 D3 呈现图表.
* [Angular-scale](https://github.com/kirillstepkin/scale) - 用于创建折线图的简单轻量级库

### Ember
* [Ember Charts](http://addepar.github.io/ember-charts/#/overview) - 准备好在 Ember.js 项目中使用的五种基本图表类型.

### jQuery
* [Flot](http://www.flotcharts.org/)  - 用于 jQuery 的 JavaScript 图表库. 包含有用的图表类型，但看起来它可能不再处于积极开发中.
* [jqPlot](http://www.jqplot.com)  - 用于绘制图表的开源 jQuery 插件. 包含许多常用功能，但可能对这些项目使用不同的命名约定.
* [jqxChart](http://www.jqwidgets.com/jquery-widgets-documentation/documentation/jqxchart/jquery-chart-getting-started.htm) - 在 SVG、Canvas 和 VML 中呈现大量图表类型.
* [JQuery-linechart](https://github.com/kirillstepkin/jquery-linechart) - 用于创建折线图的简单轻量级库

### Lit-html
* [lit-line](https://github.com/apinet/lit-line) - {快速、小型、交互式、完全响应} 折线图 Web 组件构建在 lit-html 之上.

### React
* [nivo](https://github.com/plouc/nivo) - React components to easily build dataviz apps, built on top of D3.
* [react-vis](https://github.com/uber/react-vis) - Uber 的可组合可视化系统
* [vx](https://vx-demo.now.sh/) 在 d3 之上收集可重用的低级可视化组件
* [Potion](http://numberpicture.com/build) - 用于使用 React 和 D3 构建动画可视化的低级构建块.
* [react-chart-js](https://github.com/jerairrest/react-chartjs-2) - 用于 Chart.js 的 React 包装器
* [react-d3](https://github.com/esbullington/react-d3) - 依赖 React 生成 SVG 标记和 d3 计算路径值的图表库.
* [react-muze](https://github.com/chartshq/react-muze) - 反应包装器 [muze](https://muzejs.org/) （使用 WebAssembly 在浏览器中创建探索性数据可视化的免费数据可视化库）
* [react-vis](https://github.com/uber-common/react-vis) - 一组React组件，用于渲染常见的数据可视化图表
* [recharts](http://recharts.org) - 重新定义了用 React 和 D3 构建的图表库
* [Victory](https://github.com/FormidableLabs/victory) - 一组可组合的 React 组件，用于构建交互式数据可视化

## Data Visualization Resources
* [Dataviz Catalogue](http://datavizcatalogue.com)  - 想知道哪种图表类型最好时的去处.  Severino Ribecca 的一个项目.
* [Evergreen Data](http://stephanieevergreen.com) - 有关更有效地呈现数据的信息和意见.
* [Flowing Data](http://flowingdata.com) - 关于地图、可视化、统计和设计的资源，作者是前纽约时报的 Nathan Yau.
* [Junk Charts](http://junkcharts.typepad.com) - Dataviz 评论家（和哥伦比亚大学教授）Kaiser Fung 分解数据可视化以找出问题所在并推荐改进方法.
* [The Functional Art](http://www.thefunctionalart.com) - 著名的数据可视化作者兼教授 Aberto Cairo 关于数据可视化趋势和最佳实践的博客.
* [Visualizing Data](http://www.visualisingdata.com) - Dataviz 顾问 Andy Kirk 汇编了关于图表和可视化主题的示例、资源和参考资料.
* [Well Formed Data](http://well-formed-data.net/archives/1210/little-boxes) - 世界经济论坛前成员 Moritz Stefaner 关于信息可视化和设计的思想文章.
