<div class="github-widget" data-repo="ZYSzys/awesome-captcha"></div>
## Awesome Captcha [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> Curated list of awesome captcha libraries and captcha crack tools.

[CAPTCHA](https://en.wikipedia.org/wiki/CAPTCHA) is a type of challenge–response test used in computing to determine whether or not the user is human.


[English](https://github.com/ZYSzys/awesome-captcha/blob/master/README.md) | [中文](https://github.com/ZYSzys/awesome-captcha/blob/master/README-zh.md) | [Polish](https://github.com/ZYSzys/awesome-captcha/blob/master/README-pl.md)




## Libraries

- [mewebstudio/captcha](https://github.com/mewebstudio/captcha) - Captcha for Laravel 5.
- [CGregwar/Captcha](https://github.com/Gregwar/Captcha) - PHP Captcha library.
- [trekjs/captcha](https://github.com/trekjs/captcha) - A Lightweight Pure JavaScript Captcha for Node.js. No C/C++, No ImageMagick, No Canvas.
- [patchca](https://code.google.com/archive/p/patchca) - Simple yet powerful CAPTCHA library written in Java.
- [google/recaptcha](https://github.com/google/recaptcha) - PHP client library for reCAPTCHA, a free service to protect your website from spam and abuse.
- [ambethia/recaptcha](https://github.com/ambethia/recaptcha) - ReCaptcha helpers for ruby apps.
- [anhskohbo/no-captcha](https://github.com/anhskohbo/no-captcha) - No CAPTCHA reCAPTCHA For Laravel.
- [lorien/captcha_solver](https://github.com/lorien/captcha_solver) - Universal python API to different captcha solving services.


## Generation
- [captcha-api](https://captcha-api.akshit.me) - Free, fast and reliable Captcha API POWERED BY AI
- [dchest/captcha](https://github.com/dchest/captcha) - Go package captcha implements generation and verification of image and audio CAPTCHAs.
- [lepture/captcha](https://github.com/lepture/captcha) - A captcha library that generates audio and image CAPTCHAs.
- [lemonce/svg-captcha](https://github.com/lemonce/svg-captcha) - Generate svg captcha in Node.js.
- [DoubleSpout/ccap](https://github.com/DoubleSpout/ccap) - Node.js generate captcha using c++ library CImg without install any other lib or software.
- [contra/captchagen](https://github.com/contra/captchagen) - Captcha generation for Node.js.
- [jineshfrancs/CaptchaImageView](https://github.com/jineshfrancs/CaptchaImageView) - Custom ImageView to generate captcha image.
- [mcxtzhang/SwipeCaptcha](https://github.com/mcxtzhang/SwipeCaptcha) - Swipe captcha of Android platform.
- [mojocn/base64Captcha](https://github.com/mojocn/base64Captcha) - Golang base64-captcha supports digits, numbers,alphabet, arithmetic, audio and digit-alphabet captcha.
- [koto-bank/kocaptcha](https://github.com/koto-bank/kocaptcha) - A simple captcha service with a single API endpoint, written in Rust.
- [Captcheck](https://captcheck.netsyms.com) - Lightweight, self-hostable CAPTCHA service written in PHP 7 and MySQL. Uses a selection of icons from Font-Awesome. Text-only accessibility mode and support for keyboard-only operation.
- [Securimage](https://www.phpcaptcha.org) - Open-source free PHP Captcha script.
- [Lokno/click-captcha](https://github.com/Lokno/click-captcha) - A visual, click-based CAPTCHA for human authentication.
- [ArgoZhang/SliderCaptcha](https://github.com/ArgoZhang/SliderCaptcha) - Slider captcha supporting mobile.


## Crack

### General
- [arunpatala/captcha](https://github.com/arunpatala/captcha) - Breaking captchas using torch.
- [zakizhou/CAPTCHA](https://github.com/zakizhou/CAPTCHA) - Implement classification for CAPTCHA in TensorFlow.
- [nladuo/captcha-break](https://github.com/nladuo/captcha-break) - Captcha break based on opencv2, tesseract-ocr and some machine learning algorithm.
- [ypwhs/captcha_break](https://github.com/ypwhs/captcha_break) - Captcha break using CNN with Keras.
- [ptigas/simple-captcha-solver](https://github.com/ptigas/simple-captcha-solver) - Simple CAPTCHA solver in python 🐍.
- [rickyhan/SimGAN-Captcha](https://github.com/rickyhan/SimGAN-Captcha) - Solve captcha without manually labeling a training set.
- [arunpatala/captcha.irctc](https://github.com/arunpatala/captcha.irctc) - Reading irctc captchas with 98% accuracy using deep learning.
- [JackonYang/captcha-tensorflow](https://github.com/JackonYang/captcha-tensorflow) - Image Captcha Solving Using TensorFlow and CNN Model.
- [skyduy/CNN_keras](https://github.com/skyduy/CNN_keras) - CNN | Keras | CAPTCHA recognition（卷积神经网络、Keras框架、验证码识别）.
- [PatrickLib/captcha_recognize](https://github.com/PatrickLib/captcha_recognize) - Image Recognition captcha without image segmentation.
- [zhengwh/captcha-svm](https://github.com/zhengwh/captcha-svm) - Use svm to hack simple captcha.
- [chxj1992/captcha_cracker](https://github.com/chxj1992/captcha_cracker) - Crack captcha with CNN.
- [chxj1992/slide_captcha_cracker](https://github.com/chxj1992/slide_captcha_cracker) - Crack solution for slide captcha with Canny algorithm.
- [JasonLiTW/simple-railway-captcha-solver#english-version](https://github.com/JasonLiTW/simple-railway-captcha-solver#english-version) - Simple captcha solver based on CNN and a training set generator by imitating the style of captcha.
- [lllcho/CAPTCHA-breaking](https://github.com/lllcho/CAPTCHA-breaking) - Breaking the captcha.
- [ecthros/uncaptcha](https://github.com/ecthros/uncaptcha) - Defeating Google's audio reCaptcha with 85% accuracy.
- [dessant/buster](https://github.com/dessant/buster) - Captcha solver extension for humans and monsters.
- [kerlomz/captcha_trainer](https://github.com/kerlomz/captcha_trainer) - Based on CNN5/DenseNet+BLSTM/LSTM+CTC to realize verification code identification. Only for training the model.

### Chinese
- [burness/chinese_hand_write_rec](https://github.com/burness/tensorflow-101/tree/master/chinese_hand_write_rec/src) - Handwritten chinese recognition.
- [taosir/cnn_handwritten_chinese_recognition](https://github.com/taosir/cnn_handwritten_chinese_recognition) - As the name shows, handwritten_chinese_recognition with cnn.
- [soloice/Chinese-Character-Recognition](https://github.com/soloice/Chinese-Character-Recognition) - This project shows how to use CNN to perform Chinese character recognition, a much more complicated task compared to MNIST digit recognition.
- [muchrooms/zheye](https://github.com/muchrooms/zheye) - Chinese captcha recognition program for handstand character of zhihu.
- [aaronshan/12306-captcha](https://github.com/aaronshan/12306-captcha) - Recognize 12306 captcha with deep learning.
- [nickliqian/cnn_captcha](https://github.com/nickliqian/cnn_captcha) - Use cnn recognize captcha by tensorflow.


## Tools

- [Tesseract](https://github.com/tesseract-ocr/tesseract) - Tesseract Open Source OCR Engine.
- [MotionCAPTCHA](https://github.com/wjcrowcroft/MotionCAPTCHA) - MotionCAPTCHA jQuery Plugin - Stop Spam, Draw Shapes.
- [Negative-captcha](https://github.com/subwindow/negative-captcha) - A plugin to make the process of creating a negative captcha in Rails much less painful.
- [Django-simple-captcha](https://github.com/mbi/django-simple-captcha) - An extremely simple, yet highly customizable Django application to add captcha images to any Django form.
- [Securimage](https://github.com/dapphp/securimage) - PHP CAPTCHA Script.
- [Captcha_solver](https://github.com/lorien/captcha_solver) - Univeral API to captcha solving services.


## Other

- [VisualCaptcha](https://github.com/emotionLoop/visualCaptcha) - A collection of all the different versions/repos of visualCaptcha.
- [Hashcash for PHP/JavaScript forms](https://github.com/007/hashcash-js) - An alternative to captcha to fight spam, based on proof-of-work.


## Maintainers

- [@ZYSzys](https://github.com/ZYSzys)


## Contribute

Please do! Check out the [https://github.com/ZYSzys/awesome-captcha/blob/master/contributing.md](https://github.com/ZYSzys/awesome-captcha/blob/master/contributing.md) file, or [open an issue](https://github.com/ZYSzys/awesome-captcha/issues/new)!


## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [ZYSzys](https://github.com/ZYSzys) has waived all copyright and related or neighboring rights to this work.
