<div class="github-widget" data-repo="riderx/awesome-capacitor"></div>
## Awesome Capacitor [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)

<div align="center">
	<img width="100%" src="https://raw.githubusercontent.com/riderx/awesome-capacitor/main/awesome_capacitor.png" alt="Awesome">
	<br>
</div>
<br/>
<div align="center">
⚡ A curated list of awesome resources related to the <a href='https://www.capacitorjs.com/'>Capacitor</a> Platform.
<br />
Capacitor is an open-source native runtime for building Web Native apps. Create cross-platform iOS, Android, and Progressive Web Apps with JavaScript, HTML, and CSS.
<br/>
<a href="https://hits.seeyoufarm.com"><img src="https://hits.seeyoufarm.com/api/count/incr/badge.svg?url=https%3A%2F%2Fraw.githubusercontent.com%2Friderx%2Fawesome-capacitor&count_bg=%2379C83D&title_bg=%23555555&icon=&icon_color=%23E7E7E7&title=Visitors&edge_flat=false"/></a>
</div>
<div align="center">
  <h2><a href="https://capgo.app/?ref=awesomelist"> ➡️ Get Instant updates for your App with Capgo 🚀</a></h2>
  <h2><a href="https://capgo.app/consulting/?ref=awesomelist"> Fix your annoying bug now, Hire a Capacitor expert 💪</a></h2>
</div>
<br>

<br>


- [Cordova plugins](#cordova-plugins) 


## Official plugins

Official plugins for [Capacitor](https://github.com/ionic-team/capacitor-plugins) and maintained by ionic are listed here.

- [Action Sheet](https://github.com/ionic-team/capacitor-plugins/tree/main/action-sheet) - Provides access to native Action Sheets.
- [App](https://github.com/ionic-team/capacitor-plugins/tree/main/app) - Handles high-level App state and events. 
- [App Launcher](https://github.com/ionic-team/capacitor-plugins/tree/main/app-launcher) - Allows to check if an app can be opened and open it.
- [Browser](https://github.com/ionic-team/capacitor-plugins/tree/main/browser) - Provides the ability to open an in-app browser and subscribe to browser events.
- [Camera](https://github.com/ionic-team/capacitor-plugins/tree/main/camera) - Provides the ability to take a photo with the camera or choose an existing one from the photo album.
- [Clipboard](https://github.com/ionic-team/capacitor-plugins/tree/main/clipboard) - Enables copy and pasting to/from the system clipboard.
- [Device](https://github.com/ionic-team/capacitor-plugins/tree/main/device) - Exposes internal information about the device, such as the model and operating system version, along with user information such as unique IDs.
- [Dialog](https://github.com/ionic-team/capacitor-plugins/tree/main/dialog) - Provides methods for triggering native dialog windows for alerts, confirmations, and input prompts.
- [File system](https://github.com/ionic-team/capacitor-plugins/tree/main/filesystem) - Provides a NodeJS-like API for working with files on the device.
- [Geolocation](https://github.com/ionic-team/capacitor-plugins/tree/main/geolocation) - Provides simple methods for getting and tracking the current position of the device using GPS, along with altitude, heading, and speed information if available.
- [Haptics](https://github.com/ionic-team/capacitor-plugins/tree/main/haptics) - Provides physical feedback to the user through touch or vibration.
- [Keyboard](https://github.com/ionic-team/capacitor-plugins/tree/main/keyboard) - Provides keyboard display and visibility control, along with event tracking when the keyboard shows and hides.
- [Local Notifications](https://github.com/ionic-team/capacitor-plugins/tree/main/local-notifications) - Provides a way to schedule device notifications locally (i.e. without a server sending push notifications).
- [Motion](https://github.com/ionic-team/capacitor-plugins/tree/main/motion) - Tracks accelerometer and device orientation (compass heading, etc.).
- [Network](https://github.com/ionic-team/capacitor-plugins/tree/main/network) - Provides network and connectivity information.
- [Preferences](https://github.com/ionic-team/capacitor-plugins/tree/main/preferences) - Provides a simple key/value persistent store for lightweight data, ex Storage.
- [Push Notifications](https://github.com/ionic-team/capacitor-plugins/tree/main/push-notifications) - Provides access to native push notifications.
- [Screen Reader](https://github.com/ionic-team/capacitor-plugins/tree/main/screen-reader) - Provides access to TalkBack/VoiceOver/etc. and provides simple text-to-speech capabilities for visual accessibility.
- [Share](https://github.com/ionic-team/capacitor-plugins/tree/main/share) - Provides methods for sharing content in any sharing-enabled apps the user may have installed.
- [Splash Screen](https://github.com/ionic-team/capacitor-plugins/tree/main/splash-screen) - Provides methods for showing or hiding a Splash image.
- [Status Bar](https://github.com/ionic-team/capacitor-plugins/tree/main/status-bar) - Provides methods for configuring the style of the Status Bar, along with showing or hiding it.
- [Text Zoom](https://github.com/ionic-team/capacitor-plugins/tree/main/text-zoom) - Provides the ability to change Web View text size for visual accessibility.
- [Toast](https://github.com/ionic-team/capacitor-plugins/tree/main/toast) - Provides a native notification pop up for displaying important information to a user.

## Community plugins

Community plugins owned by [Capacitor organisation](https://github.com/capacitor-community) and maintained by selected community member are listed here.

- [Admob](https://github.com/capacitor-community/admob) - A native plugin for AdMob.
- [App-icon](https://github.com/capacitor-community/app-icon) - Capacitor community plugin for changing an app's icon.
- [Apple sign in](https://github.com/capacitor-community/apple-sign-in) - Capacitor Sign in with Apple.
- [Background geolocation](https://github.com/capacitor-community/background-geolocation) - Receive geolocation updates even while app is backgrounded.
- [Barcode scanner](https://github.com/capacitor-community/barcode-scanner) - A fast and efficient QR / barcode scanner for Capacitor.
- [Bluetooth-le](https://github.com/capacitor-community/bluetooth-le) - Bluetooth Low Energy.
- [Camera preview](https://github.com/capacitor-community/camera-preview) - Camera preview.
- [Googlemaps](https://github.com/capacitor-community/capacitor-googlemaps-native) - Plugin using native Maps API for Android and iOS.
- [Contacts](https://github.com/capacitor-community/contacts) - Contacts Plugin for Capacitor.
- [Date picker](https://github.com/capacitor-community/date-picker) - Native DateTime Picker Plugin for Capacitor Apps.
- [Electron](https://github.com/capacitor-community/electron) - Support for the Electron platform.
- [Facebook Login](https://github.com/capacitor-community/facebook-login) - A native plugin for Facebook Login.
- [File opener](https://github.com/capacitor-community/file-opener) - The plugin is able to open a file given the mimeType and the file uri.
- Firebase
    - [Analytics](https://github.com/capacitor-community/firebase-analytics) - A native plugin for Firebase analytics.
    - [Crashlytics](https://github.com/capacitor-community/firebase-crashlytics) - Firebase Crashlytics.
    - [Fcm](https://github.com/capacitor-community/fcm) - Enable Firebase Cloud Messaging features for Capacitor apps.
    - [Remote config](https://github.com/capacitor-community/firebase-remote-config) - A native plugin for Firebase remote config.
- [Flipper](https://github.com/capacitor-community/flipper) - A native plugin for flipper debugger.
- [Http](https://github.com/capacitor-community/http) - A native HTTP plugin for CORS-free requests and file transfers.
- [Intercom](https://github.com/capacitor-community/intercom) - Enable Intercom features for Capacitor apps.
- [Keep awake](https://github.com/capacitor-community/keep-awake) - Prevent your screen from getting some sleep.
- [Media](https://github.com/capacitor-community/media) - Enable some media features for Capacitor such as create albums, save videos, gifs and more.
- Microsoft
    - [Appcenter](https://github.com/capacitor-community/appcenter-sdk-capacitor/tree/master/appcenter) - AppCenter SDK.
    - [Analytics](https://github.com/capacitor-community/appcenter-sdk-capacitor/tree/master/appcenter-analytics) - AppCenter Analytics.
    - [Crashes](https://github.com/capacitor-community/appcenter-sdk-capacitor/tree/master/appcenter-crashes) - AppCenter Crashes.
- [MQTT v5](https://github.com/antonymarion/capacitorjs-mqtt-native-plugin) - A native plugin for using MQTT v5 with correlation data and Request/Response Pattern.
- [Native audio](https://github.com/capacitor-community/native-audio) - A native plugin for native audio engine.
- [Native market](https://github.com/capacitor-community/native-market) - A native market plugin for linking to google play or app store.
- [Photoviewer](https://github.com/capacitor-community/photoviewer) - PhotoViewer table images with full-screen and sharing capabilities.
- [Privacy screen](https://github.com/capacitor-community/privacy-screen) - Protects your app from displaying a screenshot in recents screen/App Switcher.
- [React hooks](https://github.com/capacitor-community/react-hooks) - React Hooks for Capacitor apps.
- [Realm](https://github.com/capacitor-community/realm) - A native plugin for MongoDB Realm.
- [Screen brightness](https://github.com/capacitor-community/screen-brightness) - Control screen brightness on iOS and android.
- [Speech recognition](https://github.com/capacitor-community/speech-recognition) - A native plugin for speech recognition.
- [Sqlite](https://github.com/capacitor-community/sqlite) - Native & electron SQLite databases.
- [Stripe](https://github.com/capacitor-community/stripe) - Stripe SDK bindings for Capacitor Applications.
- [Tauri](https://github.com/capacitor-community/tauri) - Support for the Tauri platform.
- [Text to speech](https://github.com/capacitor-community/text-to-speech) - Synthesizing speech from text.
- [Twitter](https://github.com/capacitor-community/twitter) - Enable TwitterKit features for Capacitor.
- [Uxcam](https://github.com/capacitor-community/uxcam) - UXCam and FullStory analytics. It uses UXCam for Android and iOS platforms and FullStory for Web/PWA.
- [Websocket](https://github.com/mia-z/capacitor-websocket) - Plugin providing native Websocket implementations for each platform.

## [Capgo plugins](https://capgo.app/)
Plugins owned by [Capgo organisation](https://github.com/Cap-go) and maintained by [@riderx](https://github.com/riderx) and community member with Open collective .

- [Live Update](https://github.com/Cap-go/capacitor-updater) - Live update for capacitor app.
- [Crisp](https://github.com/Cap-go/capacitor-crisp) - Crisp chat SDK for your app.
- [Flash](https://github.com/Cap-go/capacitor-flash) - Switch the Flashlight / Torch of your device.
- [Mute](https://github.com/Cap-go/capacitor-mute) - Detect silent mode and mute audio.
- [Native audio](https://github.com/Cap-go/native-audio) - Capacitor plugin for native audio engine (fork).
- [Native Geocoder](https://github.com/Cap-go/capacitor-nativegeocoder) - Native forward and reverse geocoding.
- [Native market](https://github.com/Cap-go/native-market) - Capacitor community plugin for native market for Play Store/App Store.
- [Screen recorder](https://github.com/Cap-go/capacitor-screen-recorder) - Record screen and save to pelicule.
- [In app Browser](https://github.com/Cap-go/capacitor-inappbrowser) - Browser In app browser with urlChangeEvent and ability to clear cookie.
- [Camera preview](https://github.com/Cap-go/camera-preview) - Capacitor plugin that allows camera interaction from HTML code (fork).
- [Shake](https://github.com/Cap-go/capacitor-shake) - Detect shake gesture in device.
- [Navigation bar](https://github.com/Cap-go/capacitor-navigation-bar) - Set navigation bar color for android lolipop and higher.
- [Video Player IVS](https://github.com/Cap-go/ivs-player) - Native Ivs player for Capacitor app Android and IOS.
- [Home indicator](https://github.com/Cap-go/home-indicator) - Hide and show home button indicator in Capacitor app.
- [Native Purchases](https://github.com/Cap-go/native-purchases) - Manage IAP on capacitor with latest libs Android and IOS.


## [Capawesome plugins](https://capawesome.io/)
Plugins owned by [Capawesome organisation](https://github.com/capawesome-team) and maintained by [@robingenz](https://github.com/robingenz).

- [Background tasks](https://github.com/capawesome-team/capacitor-background-task) - A native plugin for running background tasks.
- [Badge](https://github.com/capawesome-team/capacitor-badge) - Access and update the badge number of the app icon.
- Firebase
    - [Analytics](https://github.com/capawesome-team/capacitor-firebase/blob/main/packages/analytics/README.md) - Firebase plugins for Capacitor. Supports Android, iOS and the web.
    - [App](https://github.com/capawesome-team/capacitor-firebase/blob/main/packages/app/README.md) - Capacitor plugin for Firebase App.
    - [Auth](https://github.com/capawesome-team/capacitor-firebase/blob/main/packages/authentication/README.md) - Handle the authentication on Native layer and propagate the token to the web view layer.
    - [Performance](https://github.com/capawesome-team/capacitor-firebase/blob/main/packages/performance/README.md) - Capacitor plugin for Firebase Performance Monitoring.
    - [Crashlytics](https://github.com/capawesome-team/capacitor-firebase/blob/main/packages/crashlytics/README.md) - Capacitor plugin for Firebase Crashlytics.
- [Screen orientation](https://github.com/capawesome-team/capacitor-screen-orientation) - Lock/unlock the screen orientation.
- [Native updates](https://github.com/capawesome-team/capacitor-app-update) - Capacitor plugin that assists with app updates.
- [File picker](https://github.com/capawesome-team/capacitor-file-picker) - Capacitor plugin that allows the user to select a file.
- [Managed configuration](https://github.com/capawesome-team/capacitor-managed-configurations) - Capacitor plugin to access managed configuration settings.
- [Photo editor](https://github.com/capawesome-team/capacitor-photo-editor) - Capacitor plugin that allows the user to edit a photo.

## [Transistor Software plugins](https://www.transistorsoft.com//)
Plugins owned by [Transistor Software plugins](https://github.com/transistorsoft) and maintained by [@christocracy](https://github.com/christocracy).

- [Background Geolocation](https://github.com/transistorsoft/capacitor-background-geolocation) - The most sophisticated background location-tracking & geofencing module with battery-conscious motion-detection intelligence for iOS and Android.
- [Background Fetch](https://github.com/transistorsoft/capacitor-background-fetch) - Periodic callbacks in the background for both IOS and Android.
- [Background Geolocation Firebase](https://github.com/transistorsoft/capacitor-background-geolocation-firebase) - Firebase adapter for Capacitor Background Geolocation.


## [Aparajita plugins](https://github.com/aparajita?tab=repositories&q=capacitor)
Plugins written and maintained by [@aparajita](https://github.com/aparajita).

- [Biometric Auth](https://github.com/aparajita/capacitor-biometric-auth) - Easy access to native biometric auth APIs on iOS and Android.
- [Dark Mode](https://github.com/aparajita/capacitor-dark-mode) - Universal, reliable dark mode support on the web, iOS and Android.
- [Logger](https://github.com/aparajita/capacitor-logger) - Better logging for the web and native Ionic/Capacitor apps.
- [Secure Storage](https://github.com/aparajita/capacitor-secure-storage) - Secure, flexible storage for Capacitor apps using iOS Keychain and Android Keystore. Supports Keychain sync across devices on iOS.

## Other plugins

Independents plugins are listed here.

- [Apple Pay](https://github.com/fresha/capacitor-plugin-applepay) - Get Apple Pay payments in your app.
- [App Tracking Transparency](https://github.com/mahnuh/capacitor-plugin-app-tracking-transparency) - Request user authorization to access app-related data for tracking the user or the device. iOS only.

- [Brother Print](https://github.com/rdlabo-team/capacitor-brotherprint) - A native Brother Print SDK implementation for iOS & Android. 
- [Biometric](https://github.com/epicshaggy/capacitor-native-biometric) - Use biometrics confirm device owner presence or authenticate users.
- [capacitor-plugin-camera](https://github.com/xulihang/capacitor-plugin-camera) - A camera plugin that is designed to make it easy to perform image processing tasks like barcode reading and OCR. We can use reflection to get the camera frames in another plugin so that it can enjoy native performance.
- [Dark mode](https://github.com/micahlt/ionicCapacitorDarkMode) - Monitor the changes made to system's dark mode.
- [Data Storage SQlite](https://github.com/jepiqueau/capacitor-data-storage-sqlite) - Providing a key-value permanent store for simple data of type string only to SQLite on IOS, Android and Electron platforms and to IndexedDB for the Web platform.
- [Document Scanner](https://github.com/websitebeaver/capacitor-document-scanner) - Scan documents (notes, homework, business cards, receipts, or anything with a rectangular shape).
- Dynamsoft
	- [Barcode Reader](https://github.com/xulihang/capacitor-plugin-dynamsoft-barcode-reader) - Scan barcodes and QR codes using Dynamsoft Barcode Reader.
	- [Camera Preview](https://github.com/tony-xlh/capacitor-plugin-camera-preview) - Access camera using Dynamsoft Camera Enhancer.
	- [Document Normalizer](https://github.com/tony-xlh/capacitor-plugin-dynamsoft-document-normalizer) - Scan documents using Dynamsoft Document Normalizer.
	- [Label Recognizer](https://github.com/tony-xlh/capacitor-plugin-dynamsoft-label-recognizer) - Recognize text on labels like MRZ on passports using Dynamsoft Label Recognizer.
- [Purchases](https://github.com/RevenueCat/purchases-capacitor) - Capacitor in-app purchases and subscriptions made easy with RevenueCat.
- [Email composer](https://github.com/EinfachHans/capacitor-email-composer) - Open a native E-Mail Composer within your Capacitor App.
- [Facebook Analytics](https://github.com/SpellChucker/capacitor-plugin-facebook-analytics) - Facebook Analytics Plugin for Capacitor.
- Firebase
    - [AppCheck](https://github.com/mattmilan-dev/capacitor-firebase-appcheck) - Allows usage of native AppCheck tokens.
    - [Dynamic Links](https://github.com/Pantrist-dev/capacitor-firebase-dynamic-links) - Firebase Dynamic Links.
    - [Push](https://github.com/EinfachHans/capacitor-firebase-push) - This Plugin it used for Firebase Push Messages. It support Data.
- [File selector](https://github.com/hinddeep/capacitor-file-selector) - Select files form Android/iOS devices and the web.
- Google
    - [Auth](https://github.com/CodetrixStudio/CapacitorGoogleAuth) - Google auth plugin for Capacitor.
    - [Availability](https://github.com/cartona/capacitor-google-play-availability) - Verifies that Google Play services is installed and enabled, and request enabling Google Play services on device.
    - [Fit](https://github.com/Ad-Scientiam/capacitor-google-fit) - Retrieve data from Google Fit.
    - [MlKit Language](https://github.com/hemangsk/capacitor-mlkit-language) - Identify the language of a string of text.
    - [MlKit Vision](https://github.com/trancee/capacitor-google-mlkit-vision/) - Detect faces in an image, identify key facial features, and get the contours of detected faces.
- [Healthkit](https://github.com/Ad-Scientiam/capacitor-healthkit) - Retrieve data from HealthKit.
- [Intent](https://github.com/IT-MikeS/capacitor-intents) - Supports multiple broadcast receiving of intents, and sending out BroadcastIntents in Android.
- [Jitsi](https://github.com/calvinckho/capacitor-jitsi-meet) - Make video calls through the free, open-sourced Jitsi video platform.
- [Lightsensor](https://github.com/Elvincth/capacitor-plugin-lightsensor) - Get the illuminance level on the device.
- [Native settings](https://github.com/RaphaelWoude/capacitor-native-settings) - Open native settings screens.
- NativeScript
    - [NativeScript Capacitor](https://github.com/NativeScript/capacitor) - Empower Capacitor with native APIs.
    - [Augmented Reality](https://github.com/EddyVerbruggen/nativescript-ar) - Add AR experiences.
- [Navigation bar](https://github.com/hugotomazi/navigation-bar) - Navigation Bar manipulation, hide/show.
- [Oauth2](https://github.com/moberwasserlechner/capacitor-oauth2) - Generic OAuth 2 client plugin. It let you configure the OAuth parameters yourself instead of using SDKs.
- [Playlist](https://github.com/phiamo/capacitor-plugin-playlist) - Native support for audio playlists, background support, and lock screen controls.
- [Print](https://github.com/leoruhland/capacitor-print) - Print the WebView.
- [Rate app](https://github.com/Nodonisko/capacitor-rate-app) - Let users rate your app using native rate app dialog for both Android and iOS.
- [Read sms](https://github.com/Ayush-Rajniwal/cap-read-sms) - Read the user's SMS with their permission.
- [Safe Area](https://github.com/AlwaysLoveme/capacitor-plugin-safe-area) - Get SafeArea info on Android and IOS.
- [Screenshot](https://github.com/ludufre/capacitor-screenshot) - Take a screenshot of the current view.
- [Send intent](https://github.com/tavosansal/capacitor-plugin-send-intent) - Expose a listener in your JavaScript application for when another application sends data to your Capacitor application via the Android share menu or share sheet.
- [Sentry](https://github.com/getsentry/sentry-capacitor) - Add Sentry error tracking and performance monitoring for Capacitor apps.
- [Stripe terminal](https://github.com/eventOneHQ/capacitor-stripe-terminal) - Stripe Terminal Plugin for Capacitor.
- [Sprig](https://github.com/crabbydavis/sprig) - All-in-one  product research platform.
- [Square Payments](https://github.com/jbrown0824/capacitor-square-payments) - Enable Square Payments for Capacitor.
- [Sumup](https://github.com/rbedemann/capacitor-sumup-plugin) - SumUp Mobile SDK.
- [UDP](https://github.com/brugsel/capacitor-udp) - Support both IPv6 and IPv4, multicast and broadcast.
- [Video player](https://github.com/jepiqueau/capacitor-video-player) - Play a video full-screen on IOS, Android, Web and Electron platforms.
- [Zalo login](https://github.com/kmasterycsl/capacitor-zalo-login) - Zalo login plugin for Capacitor.
- [Photo library](https://github.com/diiiary/capacitor-plugin-photo-library) - Get all the images from system album.
- [Websocket Client](https://github.com/OrdinarySF/capacitor-websocket-client) - Capacitor WebSocket Client Plugin.
- [Bing Translator](https://github.com/sabereen/capacitor-bing-translator) - A simple and **free** API for using [Bing Translator](https://bing.com/translator).
- [Capacitor Calendar](https://github.com/ebarooni/capacitor-calendar) - A plugin for interacting with calendar and reminders.


## Cordova plugins

### Compatible
This list will be upgraded soon

- [NPM search](https://www.npmjs.com/search?q=cordova-plugin%20capacitor)

### Incompatible

- [`cordova-plugin-add-swift-support`](https://github.com/akofman/cordova-plugin-add-swift-support) (not needed, Capacitor has built in Swift support)
- [`cordova-plugin-admobpro`](https://github.com/floatinghotpot/cordova-admob-pro) ([see details](https://github.com/ionic-team/capacitor/issues/1101))
- [`cordova-plugin-braintree`](https://github.com/Taracque/cordova-plugin-braintree) ([see details](https://github.com/ionic-team/capacitor/issues/1415))
- [`cordova-plugin-code-push`](https://github.com/microsoft/code-push) ([see details](https://github.com/microsoft/code-push/issues/615))
- [`cordova-plugin-compat`](https://github.com/apache/cordova-plugin-compat) (not needed)
- [`cordova-plugin-console`](https://github.com/apache/cordova-plugin-console) (not needed, Capacitor has its own)
- [`cordova-plugin-crosswalk-webview`](https://github.com/crosswalk-project/cordova-plugin-crosswalk-webview) (Capacitor doesn't allow to change the webview)
- [`cordova-plugin-fcm`](https://github.com/fechanique/cordova-plugin-fcm) ([see details](https://github.com/ionic-team/capacitor/issues/584))
- [`cordova-plugin-firebase`](https://github.com/arnesson/cordova-plugin-firebase) ([see details](https://github.com/ionic-team/capacitor/issues/815))
- [`cordova-plugin-ionic-keyboard`](https://github.com/ionic-team/cordova-plugin-ionic-keyboard) (not needed, Capacitor has it's own)
- [`cordova-plugin-ionic-webview`](https://github.com/ionic-team/cordova-plugin-ionic-webview) (not needed, Capacitor uses WKWebView)
- [`cordova-plugin-music-controls`](https://github.com/homerours/cordova-music-controls-plugin) (causes build failures, skipped)
- [`cordova-plugin-qrscanner`](https://github.com/bitpay/cordova-plugin-qrscanner) ([see details](https://github.com/ionic-team/capacitor/issues/1213))
- [`cordova-plugin-splashscreen`](https://github.com/apache/cordova-plugin-splashscreen) (not needed, Capacitor has its own)
- [`cordova-plugin-statusbar`](https://github.com/apache/cordova-plugin-statusbar) (not needed, Capacitor has its own)
- [`cordova-plugin-wkwebview-engine`](https://github.com/apache/cordova-plugin-wkwebview-engine) (not needed, Capacitor uses WKWebView)
- [`cordova-plugin-googlemaps`](https://github.com/mapsplugin/cordova-plugin-googlemaps) (causes build failures on iOS, skipped for iOS only)


## Tools

- [Docgen](https://github.com/ionic-team/capacitor-docgen) - Docs Readme Markdown and JSON Generator for Capacitor Plugins.
- [Plugin generator](https://github.com/ionic-team/create-capacitor-plugin) - Create a new Capacitor plugin.
- [Assets](https://github.com/ionic-team/capacitor-assets) - Local Capacitor icon/splash screen resource generation tool.
- [Tailwind Capacitor](https://github.com/Cap-go/tailwind-capacitor) - Collection of helper plugin for Tailwind, it add safe area class and others utlitilies.
- [Capacitor safe area simulator](https://chromewebstore.google.com/detail/capacitor-safe-area-simul/ddaaodgcccedhjbjeollookhompnlfhi) - Chrome extension to simulate safe area in the browser, it support Ionic, Knsta UI and Tailwind Capacitor.

## Learning

Places to learn about Capacitor

### Offical guides 

- [How Capacitor Works](https://capacitorjs.com/blog/how-capacitor-works) - Capacitor takes a modern web app, and then packages it up to run on iOS, Android, and PWA.
- [Creating Plugins](https://capacitorjs.com/docs/plugins/creating-plugins) - This guide will help you get started creating a shareable Capacitor plugin which will be published on npm.
- [Creating Splash Screens and Icons](https://capacitorjs.com/docs/guides/splash-screens-and-icons) - Use cordova-res to generate resource images for native projects.
- [App Deployment and Realtime Updates](https://capacitorjs.com/docs/guides/deploying-updates) - Update your Capacitor app remotely through the app stores.
- [CI/CD for Capacitor Apps](https://capacitorjs.com/docs/guides/ci-cd) - Adding Mobile CI/CD to your Capacitor App development process.
- [Data Storage in Capacitor](https://capacitorjs.com/docs/guides/storage) - Storing small to large amounts of data in Capacitor.
- [Security Best Practices for Capacitor](https://capacitorjs.com/docs/guides/security) - Security best practices for your Capacitor apps.
- [Using Push Notifications with Firebase](https://capacitorjs.com/docs/guides/push-notifications-firebase) - Learn how to get Firebase Cloud Messaging working on iOS and Android.
- [Saving Plugin Calls](https://capacitorjs.com/docs/core-apis/saving-calls) - How to save plugin calls in Capacitor.
- [Mocking Capacitor Plugins](https://capacitorjs.com/docs/guides/mocking-plugins) - How to create mock objects for Capacitor plugins.
- [Build Mobile Apps with Tailwind CSS, Next.js, Ionic Framework, and Capacitor](https://capacitorjs.com/blog/mobile-apps-with-tailwind-css-nextjs-ionic-and-capacitor) - A very popular stack for building responsive web apps is Tailwind CSS and Next.js by Vercel.

### Crash Courses

- [Capacitor Crash Course](https://www.udemy.com/course/capacitor-crash-course/) - Learn to use Capacitor with Ionic by Simon Grimm.

### Community Tutorials

- [Capacitor Tutorial](https://ionicthemes.com/tutorials/native-cross-platform-web-apps-with-ionic-capacitor) - Getting Started with Capacitor.
- [Adding Icons & Splash Screens to Capacitor](https://www.joshmorony.com/adding-icons-splash-screens-launch-images-to-capacitor-projects/) - Generating the Icon and Splash Screen Asset.
- [Capacitor Workflow in an Ionic Application](https://www.youtube.com/watch?v=oXbRcpsytGQ) - Cover the basic workflow when using Capacitor in an Ionic application.
- [Creating a Local Plugin](https://www.joshmorony.com/running-custom-native-ios-code-in-ionic-with-capacitor/) - Running Custom Native iOS Code with Capacitor.
- [Publishing Capacitor Plugin on NPM](https://www.joshmorony.com/publishing-a-custom-ios-capacitor-plugin-on-npm/) - Build and publish a standalone Capacitor plugin using the Capacitor CLI.
- [Do Capacitor applications are native ?](https://www.joshmorony.com/is-an-ionic-application-native/) - Demonstrate why referring to Capacitor applications as "not native" is inaccurate and confusing terminology.
- [Appcenter migration](https://capgo.app/blog/appcenter-migration) - Migrating from Microsoft App Center to Capgo in just a few simple steps.
- [Update app seamlessly](https://capgo.app/blog/update-your-capacitor-apps-seamlessly-using-capacitor-updater) - Set up Capacitor-updater into your app to seamless releases update to your users.
- [Automatic build and release](https://capgo.app/blog/automatic-build-and-release-with-github-actions) - Create your own CI/CD pipeline with GitHub actions for free, to deploy your app every time you push to main.
- [The Push Notifications Guide for Capacitor](https://capawesome.io/blog/the-push-notifications-guide-for-capacitor/)

### Books

- [Building cross platform app with Capacitor](https://go.ionic.io/capacitor) - A New Approach to Cross-Platform Development.

### Case study

- [Burger King](https://ionic.io/resources/articles/burger-king-design-system) - How Burger King Brought Their Design System to Mobile.
- [Capacitor vs Cordova](https://ionic.io/resources/articles/capacitor-vs-cordova-modern-hybrid-app-development) - This guide provides an overview of Capacitor and how it stacks up against Cordova.
- [Native React Apps Without React Native](https://capacitorjs.com/blog/native-react-apps-without-react-native) - React Native is not a web environment, so it's not possible for teams to take their web-based React to deploy native apps, with Capacitor they can.

## Demo apps

- [capacitor-testapp](https://github.com/ionic-team/capacitor-testapp) - The Capacitor TestApp is used to develop new features and verify bug fixes in Capacitor and the official plugins.
- [capacitor-plugin-demo](https://github.com/robingenz/capacitor-plugin-demo) - Simple Ionic Angular app to demonstrate the use of certain Capacitor plugins.
- [capacitor-firebase-plugin-demo](https://github.com/robingenz/capacitor-firebase-plugin-demo) - Simple Ionic Angular app to demonstrate the use of certain Capacitor Firebase plugins.
- [capacitor-updater-plugin-demo](https://github.com/Cap-go/demo-app) - Simple Ionic Vue app to demonstrate the use of OTA updates.

## Community

Places to discuss about Capacitor

- [Discord](https://discord.com/invite/UPYYRhtyzp) - Official Discord community.
- [Forum](https://forum.ionicframework.com/c/capacitor) - Official Forum community.
- [Reddit](https://www.reddit.com/r/capacitor) - Official Reddit community.
- [Stack Overflow](https://stackoverflow.com/tags/capacitor) - Official Stack Overflow community.
- [Proposal](https://github.com/capacitor-community/proposals) - Official repo for plugin and platform requests.

## Freelancers

- [Martin Donadieu](https://cal.com/martindonadieu/get-your-custom-capacitor-plugin?duration=30) - Creator of this list and of Capgo live update system + 10 plugins.
- [Christophe Surbier](https://www.malt.fr/profile/christophesurbier) - Expert developer mobile since 2009 and Capacitor since 2017.
- [Timothee Porcq](https://www.malt.fr/profile/timotheeporcq) - Expert developer Mobile Ionic/Angular & Capacitor +7 years.
- [Nicolas Izac](https://www.malt.fr/profile/nicolasizac) - Developper Fullstack | Vue-Angular-Ionic-Laravel +7 years.

## Contributing

Contributions welcome! Read the [contribution guidelines](https://github.com/riderx/awesome-capacitor/blob/master/contributing.md) - first.

## Author

<a href="https://capgo.app/">Capgo — Live updates for capacitor</a>
