<div class="github-widget" data-repo="componently-com/awesome-building-blocks-for-web-apps"></div>
## Awesome Building Blocks for Web Apps [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re) [![Tweet](https://img.shields.io/twitter/url/http/shields.io.svg?style=social)](https://twitter.com/intent/tweet?text=Here%27s%20a%20list%20of%20standalone%20features%20you%20can%20integrate%20into%20your%20web%20app&url=https://github.com/componently-com/awesome-building-blocks-for-web-apps&via=componently&hashtags=webdev,componently,react,blocks,developers)

**要集成到 Web 应用程序中的独立功能的精选列表：获得其他人构建的完整功能，而不必自己编写所有内容.**

<hr>

如果您喜欢这些积木，请查看 [componently.com](https://www.componently.com/?utm_source=github-awesome-components&utm_medium=referral&utm_campaign=awesome-list)，开发人员可以在其中搜索、比较和集成 Web 应用程序构建块的市场.

<hr>

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## UI Elements

- [Tailwind UI](https://tailwindui.com/) - UI 组件，由 Tailwind CSS 的创建者提供.
- [Webix](https://webix.com/) - 以不同方式显示数据的 JavaScript UI 库和框架.
- [Highcharts](https://www.highcharts.com/) - 网络交互式图表.
- [Webatoms](https://www.webatoms.in) - Xamarin.Forms 的 JavaScript 桥.
- [Creative Tim](https://www.creative-tim.com/) - React、Angular、Vue、Lavarel 和 HTML5 的主题.
- [Syncfusion](https://www.syncfusion.com/) - 数据可视化组件和 PDF 查看器.
- [CoreUI](https://coreui.io/pro/vue) - Vue admin template.
- [UIfort](https://uifort.com/) - 适用于所有主要前端框架的 UI 设计系统.
- [Semantic UI](https://semantic-ui.com/) - 用于 React、Meteor、Ember 和 Angular 的开源 UI 组件库.
- [Design Revision's Shards Pro](https://designrevision.com/downloads/shards-pro) - 为网络或移动应用程序设计块.
- [Themesberg](https://themesberg.com) - Bootstrap 模板、主题和 UI 工具包.
- [Treact](https://treact.owaiskhan.me/) - 登陆页面的 React 模板，基于 Tailwind CSS 构建.
- [Creative Designs Guru](https://creativedesignsguru.com) - React、Nextjs 和 Eleventy 的主题，使用 Tailwind CSS 构建.

## Exit Intent Popup
- [Wisepops](https://wisepops.com/) - 适用于移动和桌面访问者的上下文弹出窗口、横幅和栏.
- [Listagram](https://www.listagram.com) - 用于收集电子邮件地址的交互式选择加入表格.
- [Poptin](https://www.poptin.com) - 可以集成在网站任何地方的弹出窗口和表单.
- [Embedery](https://www.embedery.com) - 弹出窗口以吸引访客.

## Auth
- [Auth0](https://auth0.com/) - 身份验证管理，原生支持 Angular、React 和 VueJS.
- [Clerk](https://clerk.com) – 完整的用户管理 UI 和 API，专为 React、Next.js 和现代网络而构建.
- [Firebase](https://firebase.google.com) - 来自 Google 的 PaaS，包括身份验证管理.
- [Okta](https://www.okta.com/) - 支持 Angular、React 和 VueJS 的身份验证和授权解决方案.
- [Onelogin](https://www.onelogin.com/) - 认证侧重于公司内部应用.
- [Microsoft Azure Active Directory](https://azure.microsoft.com/en-us/services/active-directory/#security) - Azure 中的身份验证管理，基于 Microsoft 帐户.
- [AWS Cognito](https://aws.amazon.com/cognito/)  - AWS 身份验证管理. 前端集成是 [AWS Amplify](https://aws.amazon.com/de/amplify/).

## Booking
- [Calendly](https://calendly.com/) - 独立的预订解决方案.
- [Zoho Bookings](https://www.zoho.com/bookings/) - 集成到 Zoho Suite 中的在线调度程序.
- [Acuity Scheduling](https://acuityscheduling.com/) - 具有广泛 API 的预约安排.
- [10to8](https://10to8.com/) - 免费套餐中具有许多功能的预订工具.
- [SuperSaaS](https://www.supersaas.com/) - 以组调度为重点的预约调度.
- [SimplyBook.Me](https://simplybook.me/) - 带有自己预订目录的预订工具.
- [OnceHub](https://www.oncehub.com/) - 通过 ScheduleOnce 进行日程安排，通过 InviteOnce 进行会议管理.
- [YouCanBookMe](https://youcanbook.me/) - 团队在线调度.
- [OnSched](https://www.onsched.com/) - 为市场和应用程序安排 API.
- [AppointmentPlus](https://www.appointmentplus.com/) - 使用优惠券的预约安排.
- [Booxi](https://www.booxi.com/) - 预订和在线目录组件.
- [Cogsworth Scheduler](https://get.cogsworth.com/) - 具有强大 API 的业务在线调度程序.

## Notification
- [OneSignal](https://onesignal.com/) - 移动和网络通知.
- [Notific](https://notific.io/) - 包括 PHP SDK 在内的通知.
- [WonderPush](https://www.wonderpush.com/) - 通知专注于速度.
- [VWO Engage](https://vwo.com/engage/push-notifications/) - 通知作为更大的营销套件的一部分.
- [Signalize](https://signalize.com/) - 附加付费分析的免费通知.

## Social
- [Stream](https://getstream.io/) - 活动提要和聊天 API.
- [EmbedSocial's embedfeed](https://embedsocial.com/products/embedfeed/) - 社交媒体聚合器.

## Chat Bot
- [Fresh chat](https://www.freshworks.com/live-chat-software/) - Freshworks 支持套件中的聊天机器人.
- [Tiledesh](https://www.tiledesk.com/) - 人工智能支持的实时聊天.

## Chat
- [Daily.co](https://www.daily.co/) - 视频聊天.

## Monitoring
- [Sentry](https://sentry.io/) - 包含发布管理的全栈错误监控.
- [Raygun Crash Reporting](https://raygun.com/platform/crash-reporting) - 错误监控作为 Raygun 套件的一部分.
- [Honeybadger](https://www.honeybadger.io/) - 错误、正常运行时间和签入监控.
- [Rollbar](https://rollbar.com/) - 错误监控，能够重放导致错误的 HTTP 请求.

- [Contentful](https://www.contentful.com) - 无头内容管理系统.

## Consent Management
- [Cookiefirst](https://cookiefirst.com/) - Cookie 同意管理器.
- [usercentrics](https://usercentrics.com/) - 可以作为现有页面的一部分实施的合规性管理器.
- [Sourcepoint](https://www.sourcepoint.com/) - 合规管理作为套件的一部分，包括广告拦截器恢复.
- [PiwikPro](https://piwik.pro/gdpr-consent-manager/) - 合规管理作为分析工具的一部分.
- [Consent Management Provider](https://www.consentmanager.de/) - 用于 Cookie 同意的德国管理工具.
- [UniConsent](https://www.uniconsent.com/) - 符合 GDPR、CCPA、COPPA 合规性的同意管理平台.
- [TrustArc](https://trustarc.com/) - CCPA、GDPR、LGPD 和 900 多项其他全球法规的隐私管理.
- [Cookiebot](https://www.cookiebot.com/) - Cookie 跟踪管理器.
- [iubenda](https://www.iubenda.com/) - 同意管理和条款和条件生成器.
- [Civic Cookie Control](https://www.civicuk.com/cookie-control/) - 更小的 Cookie 和 GDPR 合规产品.
- [CCM19](https://www.ccm19.de/) - 德国 cookie 许可管理器.
- [CookieInformation](https://cookieinformation.com/) - 通过仪表板关注合规性报告.
- [CookiePro](https://www.cookiepro.com/) - Cookie 管理作为隐私管理解决方案的一部分.
- [React Cookie Consent](https://github.com/Mastermindzh/react-cookie-consent) - 用于 React 应用程序的小型且可自定义的 cookie 同意栏.
- [React Cookie Banner](https://github.com/buildo/react-cookie-banner) - 可以通过滚动自动关闭的 React cookie 横幅.

## Media
- [Mux](https://mux.com/) - 流式传输托管和直播视频.
- [Spotify web playback SDK](https://developer.spotify.com/documentation/web-playback-sdk/) - 客户端 JavaScript 库，它允许您在 Spotify Connect 中创建一个新播放器，并通过加密媒体扩展在浏览器中播放来自 Spotify 的任何音轨.

## Form
- [Static Forms](https://www.staticforms.xyz/) - 将结果发送到您的电子邮件的表格.
- [FlyingForms](https://flyingforms.io/?utm_source=github-awesome-components&utm_medium=referral&utm_campaign=awesome-list) - 构建、版本控制和管理表单.

## Marketing
- [TrustPulse](https://trustpulse.com/) - 在您的网站上显示最近的买家.

## Changelog
- [Beamer](https://www.getbeamer.com) - 推送通知和变更日志管理的结合.
- [Changelogfy](https://changelogfy.com/) - 产品发布说明工具.
- [Changefeed](https://changefeed.app/) - 变更日志作为独立页面或可嵌入的小部件.
- [Canny's Changelog](https://canny.io/features/changelog) - 将变更日志与产品路线图相结合.
- [ProductFlare's Changelog](https://www.productflare.com/changelog) - 围绕产品团队任务管理系统的变更日志小部件.
- [Changes](https://changes.blue) - 变更日志构建工具包.

## Telecommunication
- [Vonage](https://www.vonage.com/) - 跨统一通信、联络中心和通信 API 的语音、消息、视频和数据功能.

## Social Media
- [AddThis](https://www.addthis.com/) - 社交分享按钮，可在 AMP 上使用.
- [ShareThis](https://sharethis.com/) - 社交分享按钮.
- [AddToAny](https://www.addtoany.com/) - 许多不同目标服务的共享按钮.

## Search
- [Algolia](https://www.algolia.com/) - 搜索您的应用程序.
- [Search UI](https://github.com/elastic/search-ui) - ElastiSearch 的 UI 集成.

## Feature flags
- [Optimizely's Rollouts](https://www.optimizely.com/rollouts) - 功能标志与 A/B 测试相结合.
- [LaunchDarkly](https://launchdarkly.com/) - 在 CI 服务器和票务系统中进行多种集成的功能管理.
- [Split](https://www.split.io/) - 另一个功能管理与 CI 服务器和票务系统的多个集成.
- [Rollout](https://rollout.io/) - 功能管理侧重于功能的分段推出.

## Reviews
- [JustReview](https://justreview.co/) - 从电子商务、社交媒体和评论服务提供商收集评论并嵌入网站.
- [ReviewsOnMyWebsite](https://reviewsonmywebsite.com/) - 收集、监控和显示客户评论.

## Related awesome-lists
- [Web Components](https://github.com/mateusortiz/webcomponents-the-right-way)
- [Microservices](https://github.com/mfornos/awesome-microservices)
- [Micro Frontends](https://github.com/ChristianUlbrich/awesome-microfrontends)
