<div class="github-widget" data-repo="dotintent/awesome-ble"></div>
## Awesome BLE [![Awesome](https://awesome.re/badge-flat.svg)](https://awesome.re)

![](https://raw.githubusercontent.com/dotintent/awesome-ble/master/.github/awesome-ble.png)

**Bluetooth Low Energy (BLE)**: Low-power wireless communication protocol enabling efficient data exchange between devices, ideal for IoT, wearables, and other battery-powered applications.

A collaborative list of Awesome Bluetooth Low Energy resources by [🔴 intent](https://withintent.com).

![](https://img.shields.io/github/last-commit/dotintent/awesome-ble/main)


### Hardware

### Mobile


## Documentation

_Official specifications, standards, and technical documentation about the Bluetooth Low Energy (BLE) protocol._

- [Android Bluetooth Low Energy](https://developer.android.com/guide/topics/connectivity/bluetooth/ble-overview) - Overview about BLE in Android.
- [Developing a Bluetooth Low Energy Application by TI](https://software-dl.ti.com/lprf/simplelink_cc2640r2_sdk/1.35.00.33/exports/docs/ble5stack/ble_user_guide/html/ble-stack/index.html) - A guide by TI about how to develop a BLE app.
- [Getting Started with Bluetooth Low Energy (BLE)](https://learn.adafruit.com/introduction-to-bluetooth-low-energy) - A comprehensive guide to getting started with Bluetooth Low Energy development.
- [Intro to Bluetooth Generic Attribute Profile (GATT)](https://www.bluetooth.com/bluetooth-resources/intro-to-bluetooth-gap-gatt/) - Intro about GATT.
- [Intro to Bluetooth Low Energy](https://www.bluetooth.com/bluetooth-resources/intro-to-bluetooth-low-energy/) - Intro about the basics of BLE.
- [IoT for Beginners](https://microsoft.github.io/IoT-For-Beginners/#/) - Azure Cloud Advocates at Microsoft are pleased to offer a 12-week, 24-lesson curriculum all about IoT basics.
- [nRF51 SDK](https://www.nordicsemi.com/Software-and-tools/Software/nRF5-SDK) - Software Development Kit (SDK) for developing Bluetooth Low Energy applications on Nordic Semiconductor's nRF51 series of chips.
- [RN4870/71 Bluetooth Low Energy Module User's Guide](https://www.microchip.com/wwwproducts/en/RN4870) - User's guide for the RN4870/71 Bluetooth Low Energy module by Microchip.
- [Wikipedia Bluetooth Low Energy](https://en.wikipedia.org/wiki/Bluetooth_Low_Energy) - The wiki page for Bluetooth Low Energy (BLE).

## Framework

_Framework useful to develop your BLE peripherals._

- [Matter](https://github.com/project-chip/connectedhomeip) - Matter
- [Zephyr](https://github.com/zephyrproject-rtos/zephyr) - Zephyr

## Library

_Software libraries and frameworks for integrating Bluetooth Low Energy (BLE) functionality into various platforms, including mobile, embedded systems, and IoT devices._

- [bluepy](https://github.com/IanHarvey/bluepy) - A Python interface for Bluetooth LE on Linux.
- [bluez](http://www.bluez.org/) - The official Linux Bluetooth protocol stack.
- [bumble](https://github.com/google/bumble) - Bumble is a full-featured Bluetooth stack written entirely in Python.
- [pygatt](https://github.com/peplin/pygatt) - A Python library for interacting with BLE devices.
- [SimpleBLE](https://github.com/OpenBluetoothToolbox/SimpleBLE) - The all-in-one C/C++/Python/Rust Bluetooth LE library for MacOS, iOS, Windows, and Linux.

## iOS

_iOS libraries, tools, and resources for developing Bluetooth Low Energy (BLE) applications on Apple devices._

- [AsyncBluetooth](https://github.com/manolofdez/AsyncBluetooth) - A small library that adds concurrency to CoreBluetooth APIs.
- [CombineCoreBluetooth](https://github.com/StarryInternet/CombineCoreBluetooth) - CombineCoreBluetooth is a library that bridges Apple's CoreBluetooth framework and Apple's Combine framework.
- [iOS DFU Library](https://github.com/NordicSemiconductor/IOS-DFU-Library) - DFU application allows to flash new firmware on the DK.
- [Rx Bluetooth Kit](https://github.com/Polidea/RxBluetoothKit) - RxBluetoothKit is a Bluetooth library that makes interaction with BLE devices much more pleasant using RxSwift.
- [Swifty Sensors](https://github.com/codeinversion/sensors-swift) - Bluetooth LE Sensor Manager for iOS and macOS.

## KMM

_Resources and libraries for building Bluetooth Low Energy (BLE) applications using the Kotlin Multiplatform Mobile (KMM) framework._

- [BlueFalcon](https://github.com/Reedyuk/blue-falcon) - A Bluetooth kotlin multiplatform "Cross-Platform" library for iOS and Android.
- [Kable](https://github.com/JuulLabs/kable) - Kotlin Asynchronous Bluetooth Low Energy provides a simple Coroutines-powered API for interacting with Bluetooth Low Energy devices.

## Android

_Android libraries, tools, and resources for integrating Bluetooth Low Energy (BLE) functionality into Android applications._

- [Android BluetoothGatt Sample](https://github.com/android/connectivity-samples/tree/main/BluetoothLeGatt) - An example application demonstrating how to use BluetoothGatt API on Android.
- [android-BluetoothChat](https://github.com/googlesamples/android-BluetoothChat) - An Android Bluetooth chat application.
- [FastBle](https://github.com/Jasonchenlijian/FastBle) - An Android Bluetooth Low Energy (BLE) fast development framework.
- [Nordic Semiconductor BLE SDK for Android](https://github.com/NordicSemiconductor/Android-BLE-Library) - Official Bluetooth Low Energy SDK provided by Nordic Semiconductor for Android development.
- [RxAndroidBle](https://github.com/dariuszseweryn/RxAndroidBle) - An Android Bluetooth Low Energy (BLE) Library with RxJava3 interface.
- [SmartGattLib](https://github.com/movisens/SmartGattLib) - SmartGattLib is a Java library that simplifies the work with Bluetooth SMART devices (a.k.a. Bluetooth Low Energy in Bluetooth 4.0). It provides all UUIDs of the adopted GATT specification and an convenient way to interpret the characteristics (e.g. Heart Rate, BatteryLevel).

## Flutter

_Flutter libraries, tools, and resources for developing Bluetooth Low Energy (BLE) applications using the Flutter framework for both iOS and Android._

- [Flutter Blue Plus](https://github.com/boskokg/flutter_blue_plus) - Flutter Blue Plus is a bluetooth plugin for Flutter, a new app SDK to help developers build modern multi-platform apps.
- [Flutter Reactive BLE](https://github.com/PhilipsHue/flutter_reactive_ble) - Flutter Reactive BLE is a Flutter library that handles BLE operations for multiple devices.
- [Flutter BLELib](https://github.com/dotintent/FlutterBleLib) - Bluetooth Low Energy library for Flutter with support for simulating peripherals.

## Tool

_Development and testing tools for Bluetooth Low Energy (BLE) applications, including analyzers, debuggers, and simulators._

- [Bettercap](https://github.com/bettercap/bettercap) - A easily extensible and portable framework for security researchers to test BLE security.
- [nRF Connect](https://github.com/NordicSemiconductor/pc-nrfconnect-core) - An application framework for developing, testing, and provisioning devices based on Nordic Semiconductor chips.
- [BLE Simulator](https://play.google.com/store/apps/details?id=com.withintent.ble.simulator&hl=en) - A mobile app able to clone BLE devices and script their interaction. Useful to debug and quick prototyping.

## Web

_Web-based resources, frameworks, and tools for building Bluetooth Low Energy (BLE) applications using JavaScript and web technologies._

- [Web Bluetooth Device Info](https://github.com/urish/web-bluetooth-device-info) - Web Bluetooth demo to get information about a connected Bluetooth device.
- [Web Bluetooth Samples](https://github.com/WebBluetoothCG/demos) - A collection of Web Bluetooth API usage examples.

## Security

_Security related resources around BLE._

- [Awesome Bluetooth Security](https://github.com/engn33r/awesome-bluetooth-security) - An awesome repo related to Bluetooth (and also BLE) realted security

## Arduino

_A list of resources dedicated to Arduino hardware_

- [Arduino](https://store.arduino.cc/) - Official website
- [ArduinoBLE](https://github.com/arduino-libraries/ArduinoBLE) - ArduinoBLE library for Arduino

## ESP

_A list of resources dedicated to EspressIf hardware_

- [EspressIf](https://www.espressif.com/) - Official Website
- [ESP-IDF](https://github.com/espressif/esp-idf) - Espressif IoT Development Framework
- [ESP-32-C3 + Rust + BLE](https://dev.to/theembeddedrustacean/series/26733) - ESP32 Bluetooth w/ Rust Series' Articles

## Nordic

_A list of resources dedicated to Arduino hardware_

- [Nordic Semiconductor](https://www.nordicsemi.com/) - Official Website

## RaspberryPi

_A list of resources dedicated to RaspberryPi hardware_

- [Raspberry Pi](https://www.raspberrypi.org/) - Official website

## Articles and Case Studies

_Interesting articles and case studies from BLE development_

- [Scan and connect to BLE in background on iOS](https://medium.com/@cbartel/ios-scan-and-connect-to-a-ble-peripheral-in-the-background-731f960d520d) - Article discussing case study (for both firmware and app) of scanning and connecting to BLE device in background 

## Contributing

Please take a quick look at the [contribution guidelines](https://github.com/dotintent/awesome-ble/blob/master/.github/CONTRIBUTING.md) first.

If you see an entry longer maintained or is not a good fit, please submit a pull request to improve this file.

Thank you to all [contributors](https://github.com/dotintent/awesome-ble/graphs/contributors); you rock!
