<div class="github-widget" data-repo="keller-mark/awesome-biological-visualizations"></div>
## Awesome Biological Visualizations [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

&gt; 网络上生物数据的交互式可视化.

基于 Web 的生物学相关可视化工具通常散布在 Internet 上且难以发现. 它们可以在 GitHub、Twitter 上找到，或者从科学论文中链接. 这些工具对于希望在患病或健康人类或模式生物的背景下可视化生物数据的科学家非常有用.



## Cancer
- [COSMIC Cancer Browser](https://cancer.sanger.ac.uk/cosmic/browse/tissue) - 按组织类型和组织学浏览 COSMIC 数据.
- [UCSC Xena](https://xenabrowser.net/) - 探索功能基因组数据集，了解基因组和/或表型变量之间的相关性.
- [cBioPortal for Cancer Genomics](http://www.cbioportal.org/) - 大规模癌症基因组数据集的可视化、分析和下载.
- [iCoMut Beta for FireBrowse](http://firebrowse.org/iCoMut/) - 突变率、突变特征、临床数据、基因突变的交互式探索.
- [MAGI](http://magi.brown.edu) - 基因组畸变的可视化和协作注释.
- [ExploSig](http://explosig.lrgr.io) - 突变特征和临床数据的交互式可视化.
- [Race, Gender, and Age in TCGA](https://www.enpicom.com/visual-lab/tcga-visual-exploration-gender-race-age/) - 癌症基因组图谱 (TCGA) 数据集中患者性别、种族和年龄的交互式可视化.
- [OASISPRO](http://tinyurl.com/oasispro) - 用于临床表型预测的组学分析工具.
- [Signal](https://signal.mutationalsignatures.com/) - 从癌症样本和基于等基因细胞的实验中提取的突变特征.
- [Oncoscape](https://oncoscape.sttrcancer.org/) - 一套集成的分析工具，供用户探索与分子和临床数据相关的假设.


## Genomics
- [UCSC Genome Browser](https://genome.ucsc.edu/) - 交互式可视化基因组数据.
- [Ensembl](http://www.ensembl.org) - 支持比较基因组学、进化、序列变异和转录调控研究的脊椎动物基因组浏览器.
- [IMP: Integrative Multi-species Prediction](http://imp.princeton.edu/) - 在来自多种生物的基因-基因网络的功能背景下分析您的实验结果.
- [PLACNETw](https://castillo.dicom.unican.es/ex1/?unique=58f731fec480a) - 一种基于图形的工具，用于从下一代序列对端数据集中重建质粒.
- [PhyD3](https://phyd3.bits.vib.be/view.php?id=91162629d258a876ee994e9233b2ad87&f=xml) - 系统发育树查看器.
- [Archaeopteryx](http://www.phyloxml.org/archaeopteryx-js/bcl2_js.html) - 系统发育树的可视化、分析和编辑.
- [GeneMANIA](http://genemania.org/) - 帮助预测基因和基因组的功能.
- [Mutaframe](http://deogen2.mutaframe.com/) - 可视化人类基因组的变体.
- [Coessentiality](http://coessentiality.net) - 共同必需模块的全基因组年鉴将功能分配给未表征的基因.
- [Gosling](https://gosling.js.org) - 用于可扩展和交互式基因组学数据可视化的基于语法的工具包.

## 3D Genomics
- [HiGlass](http://higlass.io/) - 探索基因组接触矩阵和轨迹的工具.
- [HiPiler](http://hipiler.higlass.io/) - 一种用于在 Hi-C 地图中可视化探索和聚合重复出现模式（如循环、TAD 等）的工具.
- [Delta](http://delta.big.ac.cn/) - 3D 基因组的综合分析和可视化平台.
- [Juicebox](http://aidenlab.org/juicebox/) - Hi-C 数据的可视化.
- [TADkit](http://sgt.cnag.cat/3dg/tadkit/demo.h/index.html#!/project/dataset?conf=assets%2Fexamples%2Fconf.json) - 3D 基因组浏览器和 TADbit 前端.

## Metagenomics
- [Metaviz](http://metaviz.cbcb.umd.edu/) - 宏基因组数据的交互式统计和可视化分析.
- [Malaria Cell Atlas](https://www.sanger.ac.uk/science/tools/mca/mca/) - 探索基因如何在 500 多种疟原虫寄生虫中表达.

## Epigenomics
- [Epiviz](http://epiviz.cbcb.umd.edu/4/) - 功能基因组学数据的交互式可视化分析.
- [GIVe](https://mcf7.givengine.org/) - 表观基因组和基因组相互作用.
- [WashU Epigenome Browser](http://epigenomegateway.wustl.edu/) - 显示许多基于测序的数据集，涵盖全部或部分基因组、特定基因集或通路以及元数据的上下文.
- [Clustergrammer CCLE Explorer](https://maayanlab.github.io/CCLE_Clustergrammer/) - 使用 Clustergrammer 按来源组织浏览癌细胞系百科全书 (CCLE) 中癌细胞系的相对 mRNA 表达数据.
- [Peax](https://github.com/Novartis/peax) - 使用无监督深度表示学习在表观基因组数据中进行交互式视觉模式探索.

## Proteomics
- [COSMIC-3D](https://cancer.sanger.ac.uk/cosmic3d/protein/EGFR) - 一个在 3D 蛋白质结构背景下理解癌症突变的平台.
- [EzMol](http://www.sbg.bio.ic.ac.uk/~ezmol/) - 蛋白质和核酸结构的可视化和图像制作.
- [LiteMol](https://webchemdev.ncbr.muni.cz/LiteMol/) - 大规模的可视化 
大分子结构数据.


## Spatial transcriptomics
- [Vitessce](http://vitessce.io) - 用于探索空间单细胞实验数据的可视化集成工具.
- [Brain mRNA Isoform Atlas](https://isoformatlas.com/) - 可视化出生后发育中选择性剪接的细胞类型特征.
- [AlzMap](https://alzmap.org/) - 阿尔茨海默病的空间转录组学.
- [Loom Viewer](http://loom.linnarssonlab.org/dataset/cells/osmFISH/osmFISH_SScortex_mouse_all_cells.loom/NrBEoXQGhYDYoAYLRARigZlRgTDpAtAgFhRnSyg0Wrt1rUVuAHYlCYAOD5AzOo3qNmMAJy8ctaeWAYS0jvNoNqotpO6TSioZgmqmLCTJhNt0ebPCpgAWkQA6RJjgkxYxLkwlMrAKxIjr5wbv7~iKxcaLj~0AIkULhK~DAscpwZxGZJ_LIgigB2AK4ANqVKHIbquqi10LVKsgIl5RxyybFQPIGYGAi4yey4PGjDArjsaAgYaBOJaDy4A3i0C4G4EgbUEmiJmIwYmMnm2E0QQA) - 用于共享、浏览和可视化以 Loom 文件格式存储的单细胞数据的工具.
- [TissUUmaps](https://tissuumaps.research.it.uu.se/) - 大规模空间基因表达和组织形态学数据的交互式可视化.
- [Giotto Viewer](http://spatialgiotto.rc.fas.harvard.edu/giotto.viewer.html) - 基于网络的空间转录组数据可视化包.


## (Non-spatial) Transcriptomics
- [cellxgene](https://www.kidneycellatlas.org/mature-kidney-immune) - 单细胞转录组学数据的交互式浏览器.
- [UCSC Cell Browser](http://cells.ucsc.edu/?ds=cortex-dev) - 用于单细胞表达的交互式查看器.
- [L1000FWD](http://amp.pharm.mssm.edu/L1000FWD/) - 药物诱导的转录组学特征的大规模可视化.
- [ASAP](https://asap.epfl.ch/) - 用于分析单细胞转录组学数据的协作门户.
- [SCope](http://scope.aertslab.org/) - 用于大规模 scRNA-seq 数据集的可视化工具.
- [Mouse Brain Atlas](http://mousebrain.org/) - Linnarsson 实验室的细胞类型图谱.
- [Broad Institute Single Cell Portal](https://singlecell.broadinstitute.org/single_cell) - Reducing barriers and accelerating single-cell research.
- [Allen Brain Map - Transcriptomics Explorer](http://celltypes.brain-map.org/rnaseq/human_m1_10x) - 人类和小鼠转录组细胞类型图谱.
- [Single Cell VR](https://singlecellvr.herokuapp.com/) - 虚拟现实中单细胞数据的交互式可视化.
- [SPRING](https://kleintools.hms.harvard.edu/tools/springViewer_1_6_dev.html?datasets/mouse_HPCs/basal_bone_marrow/full) - 一种揭示单细胞基因表达数据中高维结构的工具.
- [START](https://kcvi.shinyapps.io/START/) - Shiny Transcriptome Analysis Resource Tool 允许用户从计数数据开始可视化 RNA-seq 数据.
- [iSEE](https://marionilab.cruk.cam.ac.uk/iSEE_allen/) - 交互式总结实验资源管理器.
- [TISCH](http://tisch.comp-genomics.org/home/) - 肿瘤免疫单细胞中心 (TISCH) 是一个专注于肿瘤微环境的 scRNA-seq 数据库.

### Gene expression matrices
- [EBI Single Cell Expression Atlas](https://www.ebi.ac.uk/gxa/sc/home) - 跨物种的单细胞基因表达.
- [MORPHEUS](https://software.broadinstitute.org/morpheus/) - 多功能矩阵可视化和分析软件.
- [Clustergrammer](https://maayanlab.cloud/clustergrammer/) - 将高维数据可视化为交互式分层聚类热图.

## Microscopy
- [IONpath MIBItracker](https://www.ionpath.com/mibitracker/) - 幻灯片和图像数据.
- [Avivator](http://avivator.gehlenborglab.org/) - 一个轻量级的“内置电池”WebGL 查看器，用于 Bio-Formats Zarr 或 OME-TIFF 格式的远程成像数据.

## Connectomics
- [neuroglancer](https://hemibrain-dot-neuroglancer-demo.appspot.com/#!gs://neuroglancer-janelia-flyem-hemibrain/v1.0/neuroglancer_demo_states/kc_apl_mpn1.json) - 用于可视化果蝇大脑中高度详细的神经元连接图的工具.
- [Allen Mouse Brain Connectivity Atlas](http://connectivity.brain-map.org/) - 小鼠大脑中神经连接的高分辨率图.
- [FlyWire](https://flywire.ai/) - 人类与 AI 合作绘制果蝇连接组图.


## Metabolomics
- [Metaspace](https://metaspace2020.eu/) - 成像质谱数据代谢物注释平台.


## Mass Spectrometry
- [Cytosplore](https://www.cytosplore.org/) - Cytosplore 是一种用于分析大量细胞计数数据的交互式可视化分析系统.


## Populations
- [Nextstrain](https://nextstrain.org/) - 病毒进化的实时跟踪.
- [Institute for Health Metrics and Evaluation](http://www.healthdata.org/results/data-visualizations) - 全球疾病的可视化.
- [Lifespans](http://www.cotrino.com/lifespan/) - 多个物种寿命的可视化.
- [Life Expectancy](http://projects.flowingdata.com/life-expectancy/) - 世界各地的预期寿命，1960 年至 2009 年.


## Medicine
- [Snake Oil Supplements](http://informationisbeautiful.net/visualizations/snake-oil-scientific-evidence-for-nutritional-supplements-vizsweet/) - 流行保健品的科学证据.
- [SieveSifter](http://sieve.fredhutch.org/viz/index.html?study=VTN503&protein=gag&reference=MRK_B_Ad5) - 可视化 HIV-1 疫苗功效试验筛分分析的工具.
