<div class="github-widget" data-repo="hallvaaw/awesome-biological-image-analysis"></div>
## Awesome Biological Image Analysis [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

<p align="center">
  <br>
    <img width="300" src="https://raw.githubusercontent.com/hallvaaw/awesome-biological-image-analysis/master/awesome-biological-image-analysis.svg?sanitize=true" alt="Awesome Biological Image Analysis">
 <br>
 <br>
</p>

> Tools and resources for biological image analysis.

Biological image analysis aims to increase our understanding of biology through the use of various computational techniques and approaches to obtain valuable information from images.


## General image analysis software
- [3D Slicer](https://github.com/Slicer/Slicer) - Free, open source and multi-platform software package widely used for medical, biomedical, and related imaging research.
- [BiaPy](https://biapyx.github.io/) - Open source ready-to-use all-in-one library that provides deep-learning workflows for a large variety of bioimage analysis tasks.
- [BioImageXD](https://bioimagexd.net) - Free, open source software package for analyzing, processing and visualizing multi-dimensional microscopy images.
- [Cell-ACDC](https://github.com/SchmollerLab/Cell_ACDC) - A GUI-based Python framework for segmentation, tracking, cell cycle annotations and quantification of microscopy data.
- [CellProfiler](https://github.com/CellProfiler/CellProfiler) - Open-source software helping biologists turn images into cell measurements.
- [CellProfiler Analyst](https://github.com/CellProfiler/CellProfiler-Analyst) - Open-source software for exploring and analyzing large, high-dimensional image-derived data.
- [Fiji](https://github.com/fiji/fiji) - A "batteries-included" distribution of ImageJ — a popular, free scientific image processing application.
- [Flika](https://github.com/flika-org/flika) - An interactive image processing program for biologists written in Python.
- [Icy](https://github.com/Icy-imaging) - Open community platform for bioimage informatics, providing software resources to visualize, annotate and quantify bioimaging data.
- [Ilastik](https://github.com/ilastik/ilastik) - Simple, user-friendly tool for interactive image classification, segmentation and analysis.
- [ImageJ](https://github.com/imagej/ImageJ) - Public domain software for processing and analyzing scientific images.
- [ImageJ2](https://github.com/imagej/imagej2) - A Rewrite of ImageJ for multidimensional image data, with a focus on scientific imaging.
- [ImagePy](https://github.com/Image-Py/imagepy) - Open source image processing framework written in Python.
- [Napari](https://github.com/napari/napari) - Fast, interactive, multi-dimensional image viewer for Python.
- [OpenCV](https://github.com/opencv/opencv) - Open source computer vision and machine learning software library.
- [PYME](https://github.com/python-microscopy/python-microscopy) - Open-source application suite for light microscopy acquisition, data storage, visualization, and analysis.
- [Scikit-image](https://github.com/scikit-image/scikit-image) - Collection of algorithms for image processing.

## Image processing and segmentation
- [Ark-Analysis](https://github.com/angelolab/ark-analysis) - A pipeline toolbox for analyzing multiplexed imaging data.
- [AtomAI](https://github.com/pycroscopy/atomai) - PyTorch-based package for deep/machine learning analysis of microscopy data.
- [Cellpose](https://github.com/MouseLand/cellpose) - A generalist algorithm for cell and nucleus segmentation.
- [CellSAM](https://github.com/vanvalenlab/cellSAM) -  A foundation model for cell segmentation trained on a diverse range of cells and data types.
- [Cellshape](https://github.com/Sentinal4D/cellshape) - 3D single-cell shape analysis of cancer cells using geometric deep learning.
- [CLIJ2](https://clij.github.io/) - GPU-accelerated image processing library for ImageJ/Fiji, Icy, MATLAB and Java.
- [DeepCell](https://github.com/vanvalenlab/deepcell-tf) - Deep learning library for single cell analysis.
- [DeepSlide](https://github.com/BMIRDS/deepslide) - A sliding window framework for classification of high resolution microscopy images.
- [EBImage](https://github.com/aoles/EBImage) - Image processing toolbox for R.
- [GPim](https://github.com/ziatdinovmax/GPim) - Gaussian processes and Bayesian optimization for images and hyperspectral data.
- [MAPS](https://github.com/mahmoodlab/MAPS) - MAPS (Machine learning for Analysis of Proteomics in Spatial biology) is a machine learning approach facilitating rapid and precise cell type identification with human-level accuracy from spatial proteomics data.
- [MicroSAM](https://github.com/computational-cell-analytics/micro-sam) - Tools for segmentation and tracking in microscopy build on top of SegmentAnything. Segment and track objects in microscopy images interactively.
- [MorpholibJ](https://github.com/ijpb/MorphoLibJ) - Collection of mathematical morphology methods and plugins for ImageJ.
- [PartSeg](https://github.com/4DNucleome/PartSeg) - A GUI and a library for segmentation algorithms.
- [Proseg](https://github.com/dcjones/proseg) : A cell segmentation method for in situ spatial transcriptomics.
- [PyImSegm](https://github.com/Borda/pyImSegm) - Image segmentation - general superpixel segmentation and center detection and region growing.
- [Salem²](https://github.com/JackieZhai/SALEM2) - Segment Anything in Light and Electron Microscopy via Membrane Guidance.
- [Squidpy](https://github.com/scverse/squidpy) - Python framework that brings together tools from omics and image analysis to enable scalable description of spatial molecular data, such as transcriptome or multivariate proteins.
- [StarDist](https://github.com/stardist/stardist) - Object detection with Star-convex shapes.
- [Suite2p](https://github.com/MouseLand/suite2p) - Pipeline for processing two-photon calcium imaging data.
- [SyMBac](https://github.com/georgeoshardo/SyMBac) - Accurate segmentation of bacterial microscope images using synthetically generated image data.
- [Trainable Weka Segmentation](https://github.com/fiji/Trainable_Segmentation) - Fiji plugin and library that combines a collection of machine learning algorithms with a set of selected image features to produce pixel-based segmentations.

## Ecology
- [PAT-GEOM](http://ianzwchan.com/my-research/pat-geom/) - A software package for the analysis of animal colour pattern.
- [ThermImageJ](https://github.com/gtatters/ThermImageJ) - ImageJ functions and macros for working with thermal image files.


## Neuroscience
- [AxonDeepSeg](https://github.com/axondeepseg/axondeepseg) - Segment axon and myelin from microscopy data using deep learning.
- [BG-atlasAPI](https://github.com/brainglobe/bg-atlasapi) - A lightweight Python module to interact with atlases for systems neuroscience.
- [Brainreg](https://github.com/brainglobe/brainreg) - Automated 3D brain registration with support for multiple species and atlases.
- [Brainreg-napari](https://github.com/brainglobe/brainreg-napari) - Automated 3D brain registration in napari with support for multiple species and atlases.
- [Brainrender](https://github.com/brainglobe/brainrender) - Python package for the visualization of three dimensional neuro-anatomical data.
- [CaImAn](https://github.com/flatironinstitute/CaImAn) - Computational toolbox for large scale Calcium Imaging Analysis.
- [Cellfinder](https://github.com/brainglobe/cellfinder) - Automated 3D cell detection and registration of whole-brain images.
- [Cellfinder-napari](https://github.com/brainglobe/cellfinder-napari) - Efficient cell detection in large images using [cellfinder](https://brainglobe.info/cellfinder) in napari.
- [CloudVolume](https://github.com/seung-lab/cloud-volume) - Read and write Neuroglancer datasets programmatically.
- [NeuroAnatomy Toolbox](https://github.com/natverse/nat) - R package for the (3D) visualisation and analysis of biological image data, especially tracings of single neurons.
- [Neuroglancer](https://github.com/google/neuroglancer/) - WebGL-based viewer for volumetric data.
- [NeuronJ](https://imagescience.org/meijering/software/neuronj/) - An ImageJ plugin for neurite tracing and analysis.
- [Panda](https://www.nitrc.org/projects/panda/) - Pipeline for Analyzing braiN Diffusion imAges: A MATLAB toolbox for pipeline processing of diffusion MRI images.
- [PyTorch Connectomics](https://github.com/zudi-lin/pytorch_connectomics) - Deep learning framework for automatic and semi-automatic annotation of connectomics datasets, powered by PyTorch.
- [RivuletPy](https://github.com/RivuletStudio/rivuletpy) - Robust 3D Neuron Tracing / General 3D tree structure extraction in Python for 3D images powered by the Rivulet2 algorithm.
- [SNT](https://github.com/morphonets/SNT/) - ImageJ framework for semi-automated tracing and analysis of neurons.
- [TrailMap](https://github.com/AlbertPun/TRAILMAP/) - Software package to extract axonal data from cleared brains.
- [Wholebrain](https://github.com/tractatus/wholebrain) - Automated cell detection and registration of whole-brain images with plot of cell counts per region and Hemishpere.
- [ZVQ - Zebrafish Vascular Quantification](https://github.com/ElisabethKugler/ZFVascularQuantification) - Image analysis pipeline to perform 3D quantification of the total or regional zebrafish brain vasculature using the image analysis software Fiji.



## Plant science

- [Aradeepopsis](https://github.com/Gregor-Mendel-Institute/aradeepopsis) - A versatile, fully open-source pipeline to extract phenotypic measurements from plant images.
- [DIRT](https://github.com/Computational-Plant-Science/DIRT) - Digital Imaging of Root Traits: Extract trait measurements from images of monocot and dicot roots.
- [LeafByte](https://zoegp.science/leafbyte) - Free and open source mobile app for measuring herbivory quickly and accurately.
- [PaCeQuant](https://mitobo.informatik.uni-halle.de/index.php/Applications/PaCeQuant) - An ImageJ-based tool which provides a fully automatic image analysis workflow for PC shape quantification.
- [PhenotyperCV](https://github.com/jberry47/ddpsc_phenotypercv) - Header-only C++11 library using OpenCV for high-throughput image-based plant phenotyping.
- [PlantCV](https://github.com/danforthcenter/plantcv) - Open-source image analysis software package targeted for plant phenotyping.
- [PlantSeg](https://github.com/hci-unihd/plant-seg) - Tool for cell instance aware segmentation in densely packed 3D volumetric images.
- [RhizoTrak](https://prbio-hub.github.io/rhizoTrak/) - Open source tool for flexible and efficient manual annotation of complex time-series minirhizotron images.
- [Rhizovision Explorer](https://github.com/rootphenomicslab/RhizoVisionExplorer) - Free and open-source software developed for estimating root traits from images acquired from a flatbed scanner or camera.
- [RootPainter](https://github.com/Abe404/root_painter) - Deep learning segmentation of biological images with corrective annotation.


## Fluoresence in situ hybridization
- [Big-fish](https://github.com/fish-quant/big-fish) - Python package for the analysis of smFISH images.
- [DypFISH](https://github.com/cbib/dypfish) - Python library for spatial analysis of smFISH images.
- [RS-FISH](https://github.com/PreibischLab/RS-FISH) - Fiji plugin to detect FISH spots in 2D/3D images which scales to very large images.
- [Spotiflow](https://github.com/weigertlab/spotiflow) -  A deep learning-based, threshold-agnostic, and subpixel-accurate spot detection method developed for spatial transcriptomics workflows.
- [TissUUmaps](https://tissuumaps.github.io/) - Visualizer of NGS data, plot millions of points and interact, gate, export. ISS rounds and base visualization.



## Electron and super resolution microscopy
- [ASI_MTF](https://github.com/emx77/ASI_MTF) - ImageJ macro to calculate the modulation transfer function (MTF) based on a knife edge (or slanted edge) measurement.
- [DECODE](https://github.com/TuragaLab/DECODE) - Python and PyTorch based deep learning tool for single molecule localization microscopy.
- [Empanada](https://github.com/volume-em/empanada) - Panoptic segmentation algorithms for 2D and 3D electron microscopy images.
- [Em-scalebartools](https://github.com/lukmuk/em-scalebartools) - Fiji/ImageJ macros to quickly add a scale bar to an (electron microscopy) image.
- [Picasso](https://github.com/jungmannlab/picasso) - A collection of tools for painting super-resolution images.
- [SMAP](https://github.com/jries/SMAP) - A modular super-resolution microscopy analysis platform for SMLM data.
- [ThunderSTORM](https://github.com/zitmen/thunderstorm) - A comprehensive ImageJ plugin for SMLM data analysis and super-resolution imaging.


## Image restoration and quality assessment
- [CSBDeep](https://github.com/CSBDeep/CSBDeep) - A deep learning toolbox for microscopy image restoration and analysis.
- [Ijp-color](https://github.com/ij-plugins/ijp-color) - Plugins for ImageJ - color space conversions and color calibration.
- [Image Quality](https://github.com/ocampor/image-quality) - Open source software library for Image Quality Assessment (IQA).
- [LLSpy](https://github.com/tlambert03/LLSpy) - Python library to facilitate lattice light sheet data processing.
- [NCS](https://github.com/HuanglabPurdue/NCS) - Noise correction algorithm for sCMOS cameras.
- [Noise2Void](https://github.com/juglab/n2v) - Learning denoising from single noisy images.


## Cell migration and particle tracking
- [CellMigration](https://github.com/quantixed/CellMigration) - Analysis of 2D cell migration in Igor.
- [TrackMate](https://github.com/fiji/TrackMate) - User-friendly interface that allows for performing tracking, data visualization, editing results and track analysis in a convenient way.
- [TrackMateR](https://github.com/quantixed/TrackMateR) - R package to analyze cell migration and particle tracking experiments using outputs from TrackMate.
- [Trackpy](https://soft-matter.github.io/trackpy) - Fast and Flexible Particle-Tracking Toolkit.
- [TracX](https://gitlab.com/csb.ethz/tracx) - MATLAB generic toolbox for cell tracking from various microscopy image modalities such as Bright-field (BF), phase contrast (PhC) or fluorescence (FL) with an automated track quality assessment in
absence of a ground truth.
- [TraJClassifier](https://imagej.net/plugins/trajclassifier) - Fiji plugin that loads trajectories from TrackMate, characterizes them using TraJ and classifiies them into normal diffusion, subdiffusion, confined diffusion and directed/active motion by a random forest approach (through Renjin).
- [QuimP](https://github.com/CellDynamics/QuimP) - Software for tracking cellular shape changes and dynamic distributions of fluorescent reporters at the cell membrane.
- [Ultrack](https://github.com/royerlab/ultrack) - Versatile cell tracking method for 2D, 3D, and multichannel timelapses, overcoming segmentation challenges in complex tissues.
- [Usiigaci](https://github.com/oist/usiigaci) - Stain-free cell tracking in phase contrast microscopy enabled by supervised machine learning.

## Pathology
- [FastPathology](https://github.com/AICAN-Research/FAST-Pathology) - Open-source software for deep learning-based digital pathology.
- [HistoClean](https://github.com/HistoCleanQUB/HistoClean) - Tool for the preprocessing and augmentation of images used in deep learning models.
- [Minerva](https://github.com/labsyspharm/minerva-story) - Image viewer designed specifically to make it easy for non-expert users to interact with complex tissue images.
- [Orbit](http://www.orbit.bio) - A versatile image analysis software for biological image-based quantification using machine learning, especially for whole slide imaging.
- [PathML](https://github.com/Dana-Farber-AIOS/pathml) - An open-source toolkit for computational pathology and machine learning.
- [PAQUO](https://github.com/bayer-science-for-a-better-life/paquo) - A library for interacting with QuPath from Python.
- [QuPath](https://qupath.github.io/) - Open source software for digital pathology image analysis.

## Mycology
- [DeepMushroom](https://github.com/Olament/DeepMushroom) - Image classification of fungus using ResNet.
- [Fungal Feature Tracker (FFT)](https://github.com/hsueh-lab/FFT) - Tool to quantitatively characterize morphology and growth of filamentous fungi.

## Microbiology
- [BactMap](https://github.com/vrrenske/BactMAP) - A command-line based R package that allows researchers to transform cell segmentation and spot detection data generated by different programs into various plots.
- [BacStalk](https://drescherlab.org/data/bacstalk/docs/index.html) - Interactive and user-friendly image analysis software tool to investigate the cell biology of common used bacterial species.
- [BiofilmQ](https://drescherlab.org/data/biofilmQ/docs/) - Advanced biofilm analysis tool for quantifying the properties of cells inside large 3-dimensional biofilm communities in space and time.

## Yeast imaging
- [BABY](https://git.ecdf.ed.ac.uk/swain-lab/baby/) - An image processing pipeline for accurate single-cell growth estimation of
budding cells from bright-field stacks.
- [htsimaging](https://github.com/rraadd88/htsimaging) - Python package for high-throughput single-cell imaging analysis.
- [YeastMate](https://yeastmate.readthedocs.io/en/latest/) - Neural network-assisted segmentation of mating and budding events in S. cerevisiae.
- [YeaZ](https://github.com/lpbsscientist/YeaZ-GUI) - An interactive tool for segmenting yeast cells using deep learning.


## Other
- [AICSImageIO](https://github.com/AllenCellModeling/aicsimageio) - Image reading, metadata conversion, and image writing for nicroscopy images in Python.
- [Biobeam](https://maweigert.github.io/biobeam) - Open source software package that is designed to provide fast methods for in-silico optical experiments with an emphasize on image formation in biological tissues.
- [BoneJ](https://github.com/bonej-org/BoneJ2) - Collection of Fiji/ImageJ plug-ins for skeletal biology.
- [CaPTk](https://github.com/CBICA/CaPTk) - Cancer Imaging Phenomics Toolkit: A software platform to perform image analysis and predictive modeling tasks.
- [ColiCoords](https://github.com/Jhsmit/ColiCoords) - Python project for analysis of fluorescence microscopy data from rodlike cells.
- [CompactionAnalyzer](https://github.com/davidbhr/CompactionAnalyzer) - Python package to quantify the tissue compaction (as a measure of the contractile strength) generated by cells or multicellular spheroids that are embedded in fiber materials.
- [Cytominer-database](https://github.com/cytomining/cytominer-database) - Command-line tools for organizing measurements extracted from images.
- [DetecDiv](https://github.com/gcharvin/DetecDiv) - Comprehensive set of tools to analyze time microscopy images using deep learning methods.
- [MIA](https://github.com/mianalysis/mia) - Fiji plugin which provides a modular framework for assembling image and object analysis workflows.
- [MorphoGraphX](https://morphographx.org) - Open source application for the visualization and analysis of 4D biological datasets.
- [Napari-aicsimageio](https://github.com/AllenCellModeling/napari-aicsimageio) - Multiple file format reading directly into napari using pure Python.
- [NEFI2](https://github.com/05dirnbe/nefi) - Python tool created to extract networks from images.
- [Neurite](https://github.com/adalca/neurite) - Neural networks toolbox focused on medical image analysis.
- [Nd2reader](https://github.com/Open-Science-Tools/nd2reader) - A pure-Python package that reads images produced by NIS Elements 4.0+.
- [OAD](https://github.com/zeiss-microscopy/OAD) - Collection of tools and scripts useful to automate microscopy workflows in ZEN Blue using Python and Open Application Development tools.
- [Pycytominer](https://github.com/cytomining/pycytominer) - Data processing functions for profiling perturbations.
- [Pyotf](https://github.com/david-hoffman/pyotf) - A simulation software package for modelling optical transfer functions (OTF)/point spread functions (PSF) of optical microscopes written in Python.
- [PyScratch](https://bitbucket.org/vladgaal/pyscratch_public.git/src) - Open source tool that autonomously performs quantitative analysis of in vitro scratch assays.
- [Quanfima](https://github.com/rshkarin/quanfima) - Quantitative Analysis of Fibrous Materials: A collection of useful functions for morphological analysis and visualization of 2D/3D data from various areas of material science.
- [SimpleElastix](https://github.com/SuperElastix/SimpleElastix) - Multi-lingual medical image registration library.
- [Vaa3D](https://alleninstitute.org/what-we-do/brain-science/research/products-tools/vaa3d/) - Open-source software for 3D/4D/5D image visualization and analysis.
- [XitoSBML](https://github.com/spatialsimulator/XitoSBML) - ImageJ plugin which creates a Spatial SBML model from segmented images.
- [Z-stack Depth Color Code](https://github.com/ekatrukha/ZstackDepthColorCode) - ImageJ/Fiji plugin to colorcode Z-stacks/hyperstacks.
- [ZeroCostDL4Mic](https://github.com/HenriquesLab/ZeroCostDL4Mic) - Google Colab to develop a free and open-source toolbox for deep-Learning in microscopy.
- [ZetaStitcher](https://github.com/lens-biophotonics/ZetaStitcher) - Tool designed to stitch large volumetric images such as those produced by light-sheet fluorescence microscopes.



## Publications

- [A Hitchhiker's guide through the bio-image analysis software universe](https://febs.onlinelibrary.wiley.com/doi/10.1002/1873-3468.14451) - An article presenting a curated guide and glossary of bio-image analysis terms and tools.
- [Biological imaging software tools](https://dx.doi.org/10.1038%2Fnmeth.2084) - The steps of biological image analysis and the appropriate tools for each step.
- [Data-analysis strategies for image-based cell profiling](https://doi.org/10.1038/nmeth.4397) - In-detail explanations of image analysis pipelines.
- [Large-scale image-based screening and profiling of cellular phenotypes](https://onlinelibrary.wiley.com/doi/10.1002/cyto.a.22909) - A workflow for phenotype extraction from high throughput imaging experiments.
- [Workflow and metrics for image quality control in large-scale high-content screens](https://linkinghub.elsevier.com/retrieve/pii/S2472555222075943) - Approaches for quality control in high-content imaging screens.

## Footnotes
### Similar lists and repositories

- [BIII](https://biii.eu) - Repository of bioimage analysis tools.
- [Bio-image Analysis Notebooks](https://haesleinhuepf.github.io/BioImageAnalysisNotebooks/intro.html) - Notebooks for bioimage analysis in Python.
- [Bioimaging Guide](https://www.bioimagingguide.org) - Microscopy for beginners reference guide.
- [Cytodata](https://github.com/cytodata/awesome-cytodata) - A curated list of awesome cytodata resources.
- [Napari hub](https://www.napari-hub.org) - Collection of napari plugins.
- [OpenMicroscopy](https://github.com/HohlbeinLab/OpenMicroscopy) - Non-comprehensive list of projects and resources related to open microscopy.
