<div class="github-widget" data-repo="rabschi/awesome-beacon"></div>
## Awesome Bluetooth Beacon [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

很棒的 iBeacon 和 Eddystone 蓝牙信标资源、开源项目、库、工具和教程的精选列表.


## Eddystone by Google

&gt; **Eddystone** 一个标记世界的平台，通过提供及时的上下文信息使您的应用程序和设备更智能地工作.

* [Google Developers Beacons Portal](https://developers.google.com/beacons/)
* [Eddystone Protocol Specification & Tools](https://github.com/google/eddystone)
* 广告框类型
  * [Eddystone-UID](https://github.com/google/eddystone/tree/master/eddystone-uid)
  * [Eddystone-TLM](https://github.com/google/eddystone/tree/master/eddystone-tlm)
  * [Eddystone-URL](https://github.com/google/eddystone/tree/master/eddystone-url)
* [Eddystone Validator](https://github.com/google/eddystone/tree/master/tools/eddystone-validator)
* [Eddystone GATT Configuration Service & Google Nearby API and Proximity API](https://github.com/rabschi/awesome-beacon/blob/master/* [](https://github.com/NordicSemiconductor/Android-nRF-Beacon-for-Eddystone)）（北欧半导体）
* [Web Bluetooth Eddystone Configurator](https://beaufortfrancois.github.io/sandbox/web-bluetooth/eddystone-url-config/)
* [Eddystone Branding Guidelines](https://github.com/google/eddystone/tree/master/branding) & [Logos](https://github.com/google/eddystone/tree/master/branding/assets)

## Physical Web

 &gt; **物理网络** 是一种释放网络核心超能力的方法：按需交互. 人们应该能够走向任何智能设备——自动售货机、海报、玩具、公交车站、租车——而不必先下载应用程序. 一切都应该只需轻按一下即可.

* [Physical Web - Walk up and use anything](http://google.github.io/physical-web/) - 官方 Github 存储库
* [Video: Introduction to the Physical Web](https://www.youtube.com/watch?v=w0XazPrh7r0) - 2016 年 Ubiquity 开发峰会
* [URL Validator 1](https://beaufortfrancois.github.io/sandbox/physical-web/url-validator/), [URL Validator 2](https://url-caster.appspot.com/webui)
* [Physical Web Getting Started Guide for Developers](https://docs.google.com/document/d/1VC9umaw9TItV31WrcX0eJ9xVsfXXQoWvUjuSqWXmH8A)
* [Physical Web Implementation Status](https://github.com/google/physical-web/blob/master/implementation-status.md)
* [Physical Web Branding Guidelines](https://github.com/google/physical-web/blob/master/documentation/branding_guidelines.md) & [Logos](https://github.com/google/physical-web/tree/master/documentation/images/logo)
* [IEEE: Enabling the Internet of Things](https://web.eecs.umich.edu/~prabal/teaching/resources/eecs582/want15iot.pdf) 作者：R. Want、B. Schilit、S. Jenson
* [Exploring the Physical Web (Without Buying Beacons)](https://medium.com/@urish/exploring-the-physical-web-without-buying-beacons-efae51e36c2e)

## Proximity Beacon API by Google

* [Beacons 101-- Getting Started with the Google Beacon Platform](https://www.youtube.com/watch?v=0QeY9FueMow) - 2016 年视频无处不在开发峰会
* [Get Started with Beacons](https://developers.google.com/beacons/get-started) - 本指南介绍了开始使用低功耗蓝牙 (BLE) 信标为您的用户提供基于邻近度的体验所需的步骤.
* [Proximity Beacon API](https://developers.google.com/beacons/proximity/guides) - 一种云服务，允许您使用 REST 接口管理与 BLE 信标相关的数据
* [Nearby](https://developers.google.com/nearby/) - 在附近的设备和人之间建立简单的互动


## iBeacon Resources by Apple

&gt; **iBeacon for Developers** 从欢迎参加体育赛事的人们到提供附近博物馆展览的信息，iBeacon 为位置感知打开了一个新世界，并为 iOS 设备和 iBeacon 硬件之间的交互提供了无数机会.

* [iBeacon for Developers](https://developer.apple.com/ibeacon)
* [Getting Started with iBeacon (PDF) ](https://developer.apple.com/ibeacon/Getting-Started-with-iBeacon.pdf)
* [iBeacon Artwork and Specifications](https://developer.apple.com/ibeacon/)
* [iOS: Understanding iBeacon device compatibility](https://support.apple.com/en-us/HT202880)
* [iOS 7: Understanding Location Services](https://support.apple.com/en-us/HT201357)
* [Apple AirLocate Sample Code](https://developer.apple.com/library/ios/samplecode/AirLocate/Introduction/Intro.html) ([iOS8 fix](http://stackoverflow.com/questions/26079530/apple-airlocation-demo-app-ranging-not-shows-beacons))


## iBeacon for Developers

* [Building Applications with iBeacon](http://shop.oreilly.com/product/0636920033813.do)
* [Cisco iBeacon FAQ](http://www.cisco.com/c/dam/en/us/solutions/collateral/enterprise-networks/connected-mobile-experiences/ibeacon_faq.pdf)
* [5 Minute Overview - What is iBeacon? by ThoughtWorks](https://www.thoughtworks.com/insights/blog/what-is-ibeacon-in-5-minutes)
* [A Semi-Technical Lowdown on Working with iBeacons](https://www.thoughtworks.com/insights/blog/semi-technical-lowdown-working-ibeacons)
* [CapTech Webinar: iBeacon Demystified](https://www.youtube.com/watch?v=0IGeQqEGhx4)
* [5 fundamental misconceptions about Beacon technology by RadiusNetworks](http://developer.radiusnetworks.com/2014/01/10/ibeacon-misconceptions.html)
* [Ask a Dev: What Are the Limitations of Beacons?](http://mashable.com/2014/05/09/beacons-limitations/)
* [What's the Difference Between Beacons and Geofencing?](http://mashable.com/2014/02/24/beacons-geofencing-location/)
* [Guide to iBeacon Hardware by beekn.net](http://beekn.net/guide-to-ibeacons/)
* [Developing an iBeacon App by beekn.net](http://beekn.net/developing-ibeacon-app/)

## Hacks & Cool Apps

* [Empowering vision impaired people to navigate the world independently](https://www.wayfindr.net) （开放标准）
* [Google Glass & Beacons](https://github.com/tmwagency/Glasstimote)
* [10 awesome things you can do today with iBeacons](http://blog.twocanoes.com/post/68861362715/10-awesome-things-you-can-do-today-with-ibeacons) （来自 Twocanoes）
* [PunchClock](https://github.com/panicinc/PunchClock) 适用于 iOS 7+ 的进/出跟踪应用程序，使用 iBeacon 和地理围栏.
* [The Geofancy iOS app](https://github.com/LocativeHQ/ios-app) 帮助您充分利用您手中的自动化家庭、地理围栏和 iBeacon.
* [LaunchHere for iOS - iBeacon based app shortcuts](http://launchhere.awwapps.com/)
* [Traveling with Beacons: Checked Luggage Made Easy](https://medium.com/@urish/traveling-with-beacons-checked-luggage-made-easy-bbd664765ea3)


## Installation & Radio Planning

*布鲁克林博物馆： [Positioning Visitors with iBeacons](https://www.brooklynmuseum.org/community/blogosphere/2014/10/14/positioning-visitors-with-ibeacons/) & [Getting Visibility on the iBeacon Problem](https://www.brooklynmuseum.org/community/blogosphere/2016/02/23/getting-visibility-on-the-ibeacon-problem/)


## Beacon Discovery & Configuration Tools

* [ScanBeacon](https://github.com/RadiusNetworks/scanbeacon-gem) - 一个 ruby​​ gem，允许您使用 IOBluetooth（在 Mac OS X 上）或 BlueGiga BLE112 设备（在 mac 或 linux 上）扫描信标广告


## iOS


## Beacon Scanner Apps

* [Locate Beacon by RadiusNetworks](https://itunes.apple.com/us/app/locate-for-ibeacon/id738709014?mt=8)

## Swift

* [iOS Eddystone Scanner Sample Application ](https://github.com/google/eddystone/tree/master/tools/ios-eddystone-scanner-sample)
* [Swift based iBeacon App Development with CoreLocation on Apple iOS 7/8](http://ibeaconmodules.us/blogs/news/14702963-getting-started-developing-ibeacon-apps-with-swift-on-apple-ios-7-8)
* [Udemy: iBeacon development for iPhone](https://www.udemy.com/ibeacon-development-for-iphone/)
* [HiBeacons](https://github.com/nicktoumpelis/HiBeacons) Swift 中一个不错的 iBeacon 演示应用程序.
* [PubNub.com - Two-Way iBeacon Communication with Swift Programming Language](https://www.pubnub.com/blog/2014-08-19-smart-ibeacon-communication-in-the-swift-programming-language/)
* [iOS & OSX Bluetooth library for RxSwift](https://github.com/Polidea/RxBluetoothKit)
* [JMCiBeaconManager](https://github.com/izotx/JMCBeaconManager) - 一个 iBeacon Manager 类，负责检测附近的信标.
* [BeaconKit](https://github.com/igor-makarov/BeaconKit) - 使用CoreBluetooth的Beacon检测框架，支持Eddystone-UID、Eddystone-URL、AltBeacon.

## Objective-C

* [Generic iBeacon Management and Utilities by KinveyLabs](https://github.com/KinveyLabs/KCSIBeacon/)
* [Replicates detecting and broadcasting iBeacons in the background](https://github.com/Instrument/Vicinity)
* [RABeaconManager](https://github.com/reelyactive/ble-ios-sdk) RABeaconManager 是一个易于使用的库，可让您在前台和后台检测蓝牙信标和 iBeacon.


## Stackoverflow Q&A

* [iBeacon detection time in background](http://stackoverflow.com/questions/25495804/ibeacon-detection-time-in-background-home-automation-use-case/25496669#25496669)
* [iBeacon region monitoring AND proximity for >20 beacons?](http://stackoverflow.com/questions/25387660/ibeacon-region-monitoring-and-proximity-for-20-beacons)
* [How to make iBeacon foreground ranging for CLProximityImmediate faster in iOS?](http://stackoverflow.com/questions/23991733/how-to-make-ibeacon-foreground-ranging-for-clproximityimmediate-faster-in-ios/23992584#23992584)
* [Can we start iBeacon transmitter in background?](http://stackoverflow.com/questions/24164523/can-we-start-ibeacon-transmitter-in-background/24165073#24165073)
* [How does iBeacon wake up our app?](http://stackoverflow.com/questions/24590534/how-does-ibeacon-wake-up-our-app-for-how-long-and-how-to-extend-that-time/24590886#24590886)
* [Use Core Bluetooth instead of iBeacon - Any Downsides?](http://stackoverflow.com/questions/24267421/use-core-bluetooth-instead-of-ibeacon-any-downsides/24268389#24268389)

## Virtual Beacons

* [Beacon Toy - Android App to advertise as Eddystone](https://play.google.com/store/apps/details?id=net.alea.beaconsimulator)
* [Android BLE advertising library](https://github.com/uriio/beacons-android)
* [Locate by Radius Networks - Virtual iBeacon](https://itunes.apple.com/us/app/locate-beacon/id738709014?mt=8)
* [Chrome App to advertise Eddystone packets](https://github.com/google/eddystone/tree/master/tools/eddystone-chrome-app-sample) - 使用 [Eddystone Advertising Library](https://github.com/google/eddystone/tree/master/libraries/javascript/eddystone-advertising)
* [Linux iBeacon broadcaster](https://github.com/dburr/linux-ibeacon)
* [Quick Beacon](https://itunes.apple.com/us/app/quick-beacon/id1303172948?mt=8)


## Android

## Beacon Development

* [Android Lolipop Bluetooth Low Energy Enhancements.](https://developer.android.com/about/versions/android-5.0.html) 支持操作系统级扫描过滤器和外设模式.
* [iBeacon Scanner for Android](https://github.com/inthepocket/ibeacon-scanner-android), [Docs](https://github.com/inthepocket/ibeacon-scanner-android/wiki) & [Blog post](http://developer.inthepocket.mobi/2016/11/24/ibeacon-scanner-android/)
* [Android beacon library based on AltBeacon.](https://github.com/AltBeacon/android-beacon-library) 使用自定义信标解析器来实现 iBeacon 设备兼容性.
* [BeaconKeeper](https://github.com/m039/beacon-keeper) 用于在后台定位 iBeacon 的简单库
* [Android & BLE](https://developer.android.com/guide/topics/connectivity/bluetooth-le.html)
* [DevBytes: Bluetooth Low Energy API in Android 4.3](https://www.youtube.com/watch?v=vUbFB1Qypg8)
* [BLE SDK for Android](https://github.com/RedBearLab/Android)
* [Bluetooth LE Library for Android](https://github.com/alt236/Bluetooth-LE-Library---Android)
* [reelyactive-ble-android-sdk](https://github.com/reelyactive/ble-android-sdk) 此 SDK 允许您扫描信标并作为信标进行广告宣传.

## Beacon Scanner Apps

* [iBeacon Scanner](https://play.google.com/store/apps/details?id=be.createweb.beaconscanner) & [code](https://github.com/eliaslecomte/ibeacon-scanner-app)
* [Beacon Scanner & Logger](https://github.com/justinodwyer/Beacon-Scanner-and-Logger) 扫描 BLE Beacons/iBeacons 并将结果记录到文件中的 Android 应用程序
* [iBeacon Detector](https://play.google.com/store/apps/details?id=youten.redo.ble.ibeacondetector&hl=de)
* [Bluetooth 4.0 Scanner](https://play.google.com/store/apps/details?id=com.bluemotionlabs.bluescan&hl=de)

## Beacon Advertiser Apps

* [Beacon Simulator](https://play.google.com/store/apps/details?id=net.alea.beaconsimulator) - iBeacon、Eddystone、AltBeacon

## Stackoverflow Q&A

* [BLE Distancing](http://stackoverflow.com/questions/20416218/understanding-ibeacon-distancing/20434019#20434019)



## Cordova, Phonegap, Xamarin, Titanium

* [Cordova iBeacon Plugin](https://github.com/petermetz/cordova-plugin-ibeacon)
* [Using iBeacon with Xamarin.iOS and Xamarin.Android](http://de.slideshare.net/glennthomasstephens/ibeacon-support)
* [iBeacon advertising and scanning in a Titanium module](https://github.com/jbeuckm/TiBeacons)



## OS X

* [iBeacon Scanning Utility App for OSX](https://github.com/mlwelles/BeaconScanner)
* [iBeacon Scanner - Scan for nearby iBeacons regardless of their UUID](https://github.com/liamnichols/iBeaconScanner)
* [Beacon OSX](https://github.com/mttrb/BeaconOSX) - 小牛作为 iBeacon
* [Electron Physical Web Scan](https://github.com/dermike/electron-physical-web-scan) - 用于扫描物理网 (Eddystone) 蓝牙信标的 Mac OSX 桌面应用程序
* [Electron Slide Beacon](https://github.com/dermike/electron-slide-beacon) - 使用此应用程序从您的 Mac 共享链接，将它们作为 Eddystone URL（物理 Web）蓝牙信标进行广播.
* [BeaconKit](https://github.com/igor-makarov/BeaconKit) - Beacon 检测框架 ns Swift 使用 CoreBluetooth，支持 Eddystone-UID、Eddystone-URL、AltBeacon、iBeacon.

## Linux

* [Python script for scanning and advertising urls over Eddystone-URL](https://github.com/forksociety/PyBeacon)

## Node.js

* [Node-RED nodes to interact with the Physical Web](http://flows.nodered.org/node/node-red-node-physical-web)
* [A node.js BLE (Bluetooth low energy) central module](https://github.com/sandeepmistry/noble)
* [A node.js module for implementing BLE (Bluetooth low energy) peripherals](https://github.com/sandeepmistry/bleno)

## Windows

* [Universal Bluetooth Beacon Library](https://github.com/andijakl/universal-beacon) - 开源库和应用程序链接以与 Eddystone 和 iBeacon 信标对话

## Bluetooth Low Energy

* [Official Bluetooth Smart Portal](https://www.bluetooth.com/what-is-bluetooth-technology/bluetooth-technology-basics/low-energy)

## Bluetooth Smart & BLE Tools

* [nRF Master Control Panel (BLE)](https://play.google.com/store/apps/details?id=no.nordicsemi.android.mcp) nRF Master Control Panel 是一款功能强大的通用工具，可让您扫描和探索您的蓝牙智能 (BLE) 设备并与它们通信.
* [LightBlue Mac OSX](https://itunes.apple.com/de/app/lightblue/id639944780?mt=12)
[(or iOS)](https://itunes.apple.com/us/app/lightblue-bluetooth-low-energy/id557428110?mt=8) LightBlue 可以测试您所有使用蓝牙 4.0 低功耗（也称为蓝牙智能或蓝牙灯）的设备.
* [BlueSpeed for iOS by Punch Through](https://itunes.apple.com/us/app/bluespeed/id579118786?mt=8) 在 2 个 iOS 设备之间运行蓝牙 LE 速度测试

## Web Bluetooth API

* [Web Bluetooth Intro](https://dev.opera.com/articles/web-bluetooth-intro/) 通过歌剧
* [Web Bluetooth Demos](https://github.com/WebBluetoothCG/demos)

## Beacon Developer Kits & BLE Chips

* [Texas Instruments - BLE Portal](http://www.ti.com/ble)
* [Texas Instruments - SensorTag DeveloperKit](http://makezine.com/2014/04/16/the-ti-sensortag-now-with-added-ibeacon/)
* [TI SensorTag Android Sources](http://git.ti.com/sensortag-android)
* [Broadcom - WICED™ Sense Development Kit](http://www.broadcom.com/application/internet_of_things.php)
* [Dialog Semiconductor](http://www.dialog-semiconductor.com/bluetooth-smart)
* [EMMicroelectronics](http://www.emmicroelectronic.com/products/wireless-rf/beacons/embc01)



## Proximity Trends & Outlook

* [Wired](http://www.wired.com/2013/12/4-use-cases-for-ibeacon-the-most-exciting-tech-you-havent-heard-of/) Apple 的 iBeacon 即将颠覆交互设计的 4 个原因
* [Wi-Fi Aware™](http://www.wi-fi.org/discover-wi-fi/wi-fi-aware) - Wi-Fi Aware™ 是一项新的 Wi-Fi 联盟认证计划，它通过实时和节能的发现机制扩展 Wi-Fi 的功能，提供立即进入丰富的此时此地的体验.


## Vendor-driven Beacon Standardization

* [BeaconCtrl](https://github.com/upnext/BeaconCtrl) 使用 BeaconCtrl 开源平台设置和管理大型信标部署
* [The Open and Interoperable Proximity Beacon Specification](http://altbeacon.org/)

---

Bluetooth、Apple、Google、iBeacon、Eddystone 和其他商标是其各自商标所有者的财产.

## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Square Metrics GmbH](http://www.squaremetrics.com/) 已放弃该作品的所有版权和相关或邻接权.
