<div class="github-widget" data-repo="sadcitizen/awesome-backbone"></div>
## Awesome Backbone.js [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

&gt; backbone.js 的资源列表

## General

- [Backbone.js](http://backbonejs.org/)
- [Github repository](https://github.com/jashkenas/backbone)
- [Annotated source](http://backbonejs.org/docs/backbone.html)
- [Backbone plugins](http://backplug.io/)
- [Backbone Index](https://backboneindex.com/) - 发现新的 Backbone 插件和资源
- [BackboneConf](http://backboneconf.com/) - 关于在网络上构建应用程序的会议，重点是 Backbone.js 库
- [StackOverflow](http://stackoverflow.com/questions/tagged/backbone.js) - 标记问题
- [Yeoman generator for Backbone.js](https://github.com/yeoman/generator-backbone)

## Tutorials and articles

- [A pragmatic guide to Backbone.js apps](http://pragmatic-backbone.com/) 胡里奥·塞萨尔·奥迪 (Julio Cesar Ody)
- [Getting Started with Backbone](http://www.korenlc.com/backbone-js-tutorial-getting-started-with-backbone/) 科伦·莱斯利·科恩 (Koren Leslie Cohen)
- [A Complete Guide for Learning Backbone.js](http://www.codebeerstartups.com/2012/12/a-complete-guide-for-learning-backbone-js/) 通过 Mohit Jain
- [Hello Backbone.js](http://jasongiedymin.github.io/hello-backbonejs/) 阿图尔·阿迪布
- Christophe Coenraets 的 Backbone.js 酒窖教程 - [Part 1](http://coenraets.org/blog/2011/12/backbone-js-wine-cellar-tutorial-part-1-getting-started/), [Part 2](http://coenraets.org/blog/2011/12/backbone-js-wine-cellar-tutorial-part-2-crud/) 和 [Part 3](http://coenraets.org/blog/2011/12/backbone-js-wine-cellar-tutorial-part-3-deep-linking-和-application-states/)
- [Backbone patterns](http://ricostacruz.com/backbone-patterns/) 由 Rico Sta 设计. 克鲁斯
- [Complex Single Page Application Architecture with Backbone.js](http://blog.soom.la/2013/10/complex-single-page-application.html) 通过 Gur Dotan
- [Building large Backbone applications](http://victorsavkin.com/post/59496656297/building-large-backbone-applications) 通过维克多萨夫金
- [A Guide to Writing Backbone Apps at Coursera](http://blog.pamelafox.org/2013/07/a-guide-to-writing-backbone-apps-at.html) 通过帕梅拉·福克斯
- CloudEdit：James Yu 的 Rails Backbone.js 教程 - [Part 1](http://www.jamesyu.org/2011/01/27/cloudedit-a-backbone-js-tutorial-by-example), [Part 2](http://www.jamesyu.org/2011/02/09/backbone.js-tutorial-with-rails-part-2) 和 [Part 3](http://www.jamesyu.org/2012/05/20/converting-cloudedit-from-backbone-to-parse/)
- [Our First Node.js App: Backbone on the Client and Server](http://nerds.airbnb.com/weve-launched-our-first-nodejs-app-to-product/) 通过斯派克布雷姆
- [Using Backbone.js With Require.js](http://gregfranko.com/blog/using-backbone-dot-js-with-require-dot-js/) 通过格雷格佛朗哥
- [Backbone Model Unit Testing with Jasmine](http://blog.katworksgames.com/2013/03/30/bb_model_test_jasmine/) 通过肯塔博尔
- [Backbone.js and Socket.io](http://developer.teradata.com/blog/jasonstrimpel/2011/11/backbone-js-and-socket-io) 通过杰森·斯特林佩尔
- [Presenter First in Backbone.js](http://spin.atomicobject.com/2012/01/03/presenter-first-in-backbone-js/) 通过肖恩安德森
- [Websockets for Backbone](http://www.artandlogic.com/blog/2014/06/websockets-for-backbone/) 通过克里斯托弗基弗
- 有趣的 CoffeeScript 和 Backbone.js - [Part 1](http://www.art和logic.com/blog/2012/06/fun-with-coffeescript-和-backbone-js-part-1/), [Part 2](http://www.art和logic.com/blog/2012/06/fun-with-coffeescript-和-backbone-js-part-2/) 和 [Part 3](http://www.art和logic.com/blog/2012/06/fun-with-coffeescript-和-backbone-js-part-3/)
- [Components with Backbone.js and Marionette.js](http://blog.jeremyfairbank.com/javascript/components-with-backbone-js-and-marionette-js/) 杰里米·费尔班克
- [Boilerplate web app using Backbone.js, Express.js, Node.js, MongoDB](http://kroltech.com/2013/12/boilerplate-web-app-using-backbone-js-expressjs-node-js-mongodb/) 来自 jkat98
- [Backbone.js Tips And Patterns](http://www.smashingmagazine.com/2013/08/09/backbone-js-tips-patterns/) 菲利普·维森亨特
- [Leveraging Deferreds in Backbone.js](http://quickleft.com/blog/leveraging-deferreds-in-backbonejs) 通过山姆品种
- [Backbone.js for large scale applications - UI architecture](http://orizens.com/wp/topics/backbone-js-for-large-scale-applications-ui-architecture/) 通过奥伦法希
- [Decorating A Backbone.Model With Features, For A UI Component](http://derickbailey.com/2014/09/09/decorating-a-backbone-model-with-features-for-a-ui-component/) 通过德里克贝利
- [Backbone.fwd: Forward Events From One Backbone Object, Through Another](http://derickbailey.com/2014/05/13/backbone-fwd-forward-events-from-one-backbone-object-through-another/) 通过德里克贝利
- [Backbone.View Patterns - Rendering A Collection](http://orizens.com/wp/topics/backbone-view-patterns-rendering-a-collection/) 通过奥伦法赫里
- [Backbone.View Patterns - How & Why Use Subviews](http://orizens.com/wp/topics/backbone-view-patterns-how-why-to-use-subviews/) 通过奥伦法赫里
- [Backbone.View Patterns - The "Render" Method](http://orizens.com/wp/topics/backbone-view-patterns-the-render-method/) 通过奥伦法赫里
- [Building progressively enhanced websites using bulletproof Backbone & CSS transforms](http://azumbrunnen.me/blog/building-progressively-enhanced-websites-with-bulletproof-backbone/) 通过阿德里安 Zumbrunnen
- [Decoupling Backbone Apps From WebSockets](http://lostechies.com/derickbailey/2012/04/19/decoupling-backbone-apps-from-websockets/) 通过德里克贝利
- [Backbone.js And JavaScript Garbage Collection](http://lostechies.com/derickbailey/2012/03/19/backbone-js-and-javascript-garbage-collection/) 通过德里克贝利
- [Getting familiar with Backbone.js](https://blog.safaribooksonline.com/2013/11/16/getting-familiar-with-backbone-js/) 通过帕夏克雷登
- [Backbone Antipatterns](http://blog.shinetech.com/2013/11/26/backbone-antipatterns/) 通过本提斯
- Adrian Mejia 的绝对初学者的 Backbone.js - [Part 1](http://adrianmejia.com/blog/2012/09/11/backbone-dot-js-for-absolute-beginners-getting-started/), [Part 2](http://adrianmejia.com/blog/2012/09/13/backbone-js-for-absolute-beginners-getting-started-part-2/), [Part 3](http://adrianmejia.com/blog/2012/09/13/backbonejs-for-absolute-beginners-getting-started-part-3/) 和 [Part 4](http://adrianmejia.com/blog/2012/09/13/backbone-js-for-absolute-beginners-getting-started-part-4/)
- 使用 Express 和 Backbone 构建应用，作者：Jack Franklin - [Part 1](http://javascriptplayground.com/blog/2013/02/express-backbone-application-part1), [Part 2](http://javascriptplayground.com/blog/2013/02/building-an-app-with-express-和-backbone-part-2), [Part 3](http://javascriptplayground.com/blog/2013/04/building-an-app-with-express-和-backbone-part-3), [Part 4](http://javascriptplayground.com/blog/2013/07/building-an-app-with-express-和-backbone-part-4), [Part 5](http://javascriptplayground.com/blog/2013/08/express-backbone-part5), [Part 6](http://javascriptplayground.com/blog/2013/09/express-backbone-part6), [Part 7](http://javascriptplayground.com/blog/2013/09/express-backbone-part7) 和 [Part 8](http://javascriptplayground.com/blog/2013/10/express-backbone-part8)
- [Backbone with ES6](http://mikefowler.me/2014/06/11/backbone-with-es6/) 通过迈克福勒
- [How to share Backbone.js models with Node.js](http://amirmalik.net/2010/11/27/how-to-share-backbonejs-models-with-nodejs)
- [Backbone.js tricks or treats](http://tiagorg.github.io/talk-backbone-tricks-or-treats-html5devconf) 通过蒂亚戈加西亚
- Ben Eddy 的 Backbone.js 组织模式 - [Part 1](http://www.foraker.com/backbone-js-organizational-patterns/), [Part 2](http://www.foraker.com/backbone-js-organizational-patterns-part-ii/)
- [Backbone Cleanup](http://www.webdeveasy.com/backbone-cleanup/) 通过 Naor Yehodaey
- [Lazy loading Backbone collections with Promises](http://tech.adroll.com/blog/web/2013/11/12/lazyloading-backbone-collection-with-promises.html) 蒂莫西·鲍彻 (Timothee Boucher)
- [5 Ways to Level-Up Your Backbone.js Code](https://blog.engineyard.com/2015/5-ways-to-level-up-your-backbone-code) 大卫·阿拉贡
- [Why Backbone.js and ES6 Classes Don't Mix](http://benmccormick.org/2015/04/07/es6-classes-and-backbone-js/) 通过本·麦考密克
- [Top 8 Common Backbone.js Developer Mistakes](http://www.toptal.com/backbone-js/top-8-common-backbone-js-developer-mistakes) 马哈茂德·里德万 (Mahmud Ridwan)
- [8 Great Backbone.js Interview Questions](http://www.toptal.com/backbone-js/interview-questions)
- [Integrating React With Backbone](https://quickleft.com/blog/integrating-react-with-backbone/) 通过本刘易斯
- [Using BackboneJS to improve your JavaScript code organization over a Ruby on Rails app](https://medium.com/@ezekielriva/using-backbonejs-to-improve-your-javascript-code-organization-over-a-ruby-on-rails-app-11784575a4f2) Ezequiel Rivadeneira Lichardi 着
- 不耐烦的 JavaScript：BackboneJS - [Part 1](https://medium.com/@coreyhowell/javascript-for-the-impatient-backbonejs-part-1-7f4dba8fcea), [Part 2](https://medium.com/@coreyhowell/javascript-for-the-impatient-backbonejs-part-2-a139df9bbbf0) 通过科里豪厄尔
- [Building Backbone apps using Flux](https://medium.com/@victordoss/building-backbone-apps-using-flux-f656fd8a873a) 通过维克多多斯
- [Bringing Meteor’s reactive collections to Backbone](https://mixmax.com/blog/meteor-and-backbone) 杰夫·威尔


## Books

- [Developing Backbone.js Applications](http://addyosmani.github.io/backbone-fundamentals/) 通过阿迪奥斯马尼
- [Backbone Tutorials](https://leanpub.com/backbonetutorials) 通过托马斯·戴维斯
- [Building Backbone Plugins](https://leanpub.com/building-backbone-plugins) 德里克·贝利和杰罗姆·格拉维尔-尼奎特
- [Mastering Backbone.js](http://www.amazon.com/dp/1783288493) 通过 Abiee Echamea
- [Backbone.js Testing](http://backbone-testing.com/) 通过瑞安罗默
- [Backbone.js Patterns and Best Practices](http://www.amazon.com/dp/1783283572) 通过 Swarnendu De
- [Backbone.js Cookbook](http://www.amazon.com/dp/1782162720/) 瓦迪姆·米尔戈罗德
- [Instant Backbone.js Application Development](http://www.amazon.com/dp/1782165665) 托马斯·亨特二世
- [Beginning Backbone.js](http://www.amazon.com/dp/1430263342/) 詹姆斯·苏格鲁
- [Backbone.js Blueprints](http://www.amazon.com/dp/1783286997/) 通过安德鲁伯吉斯
- [Recipes with Backbone](http://recipeswithbackbone.com/) 尼克·高捷 (Nick Gauthier) 和克里斯·斯特罗姆 (Chris Strom)
- [Full Stack Web Development with Backbone.js](http://shop.oreilly.com/product/0636920030799.do) 通过帕特里克·穆德
- [Developing Single Page Apps with Backbone.js](https://singlepagebook.supportbee.com/) 作者：Prateek Dayal - 进行中

## Videos

- [BackboneConf 2013](https://www.youtube.com/playlist?list=PLlgxAbM67lYLJm9_Ub3gStXa2vjb51aUX) - YouTube 播放列表
- [BackboneConf 2014](https://www.youtube.com/playlist?list=PLlgxAbM67lYIGw8DnANC7VgREbzJRQged) - YouTube 播放列表
- [Introduction to Backbone.js](https://www.youtube.com/playlist?list=PLCE344BDBD8FAC282) - 约瑟夫齐默尔曼的 Youtube 播放列表
- [Backbone App Walkthrough](https://www.youtube.com/playlist?list=PL0C57F698BD4766B1) - 约瑟夫齐默尔曼的 Youtube 播放列表
- [Backbone.js Tutorial](http://www.youtube.com/playlist?list=PLTjRvDozrdlwn9IsHWEs9IQv3HQob4bH3) - Mosh Hamedani 制作的 Youtube 播放列表
- [Backbone-Require-Boilerplate Explained](http://gregfranko.com/blog/backbone-require-boilerplate-explained/) 通过格雷格佛朗哥
- [BackboneRails Screencasts](http://www.backbonerails.com/) - 学习使用 Backbone + Rails 构建 Web 应用程序
- [Backbone.js with Derick Bailey](https://www.youtube.com/watch?v=VERQEr-bVTs) 通过德里克贝利
- [JavaScript Application Architecture with Backbone.js](http://www.youtube.com/watch?v=PGgZ7qRvoGE) 作者：马蒂亚斯·谢弗
- [An Introduction to Backbone.js](http://www.youtube.com/watch?v=PcTVQyrWSSs) 通过 Sid Maestre
- [Put Some Backbone.js in your Apps](http://www.youtube.com/watch?v=jM8KE_Fa6JI) 通过 Sid Maestre
- [Evolving Your JavaScript with Backbone.js](http://wordpress.tv/2013/09/05/k-adam-white-evolving-your-javascript-with-backbone-js/) 通过 K 亚当怀特

## Examples and boilerplates

- [Backbone Require Boilerplate](https://github.com/BoilerplateMVC/Backbone-Require-Boilerplate) - 一个 Rad Backbone.js 和 Require.js 样板项目
- [Wine Cellar Sample Application](https://github.com/ccoenraets/backbone-cellar) - “Backbone Cellar”是一个使用 Backbone.js 构建的示例应用程序
- [Employee Directory](https://github.com/ccoenraets/directory-backbone-bootstrap) - 使用 Backbone.js 和 Twitter Bootstrap 构建的员工目录示例应用程序
- [Backbone Contact Manager](https://github.com/dmytroyarmak/backbone-contact-manager) - 简单的 Backbone.js 示例应用程序
- [Backbone Boilerplates](https://github.com/addyosmani/backbone-boilerplates) - Backbone.js 堆栈样板演示与 Express、Ruby、PHP、Grails 等的集成
- [Backbone TodoMVC example](http://todomvc.com/examples/backbone/) - 使用 Backbone 和 Backbone.localStorage 构建的简单待办事项应用程序.

## Courses

- [Anatomy of Backbone.js](https://www.codeschool.com/courses/anatomy-of-backbone-js)
- [Advanced Backbone Patterns and Techniques](http://code.tutsplus.com/courses/advanced-backbone-patterns-and-techniques)
- [Connected to the Backbone](http://code.tutsplus.com/courses/connected-to-the-backbone)
- [Structuring Your Web Apps via Backbone.js](https://github.com/hegdeashwin/Backbone)
- [Backbone.JS In-Depth and Introduction to Testing with Mocha and Sinon](https://frontendmasters.com/courses/backbone-js-in-depth-testing-mocha-sinon/)
- [Up and Running with Backbone.js](http://www.lynda.com/Backbonejs-tutorials/Up-Running-Backbonejs/163089-2.html)
- [Application Building Patterns with Backbone.js](http://www.pluralsight.com/courses/playing-with-backbonejs)
- [Backbone.js Fundamentals](http://www.pluralsight.com/courses/backbone-fundamentals)

## Libraries

- [Backbone.Relational](https://github.com/PaulUithol/Backbone-relational)
- [Backbone-forms](https://github.com/powmedia/backbone-forms)
- [Backgrid.js](https://github.com/wyuenho/backgrid)
- [Backbone.localStorage](https://github.com/jeromegn/Backbone.localStorage)
- [Backbone.stickit](https://github.com/NYTimes/backbone.stickit)
- [Backbone.paginator](https://github.com/backbone-paginator/backbone.paginator)
- [Backbone.validation](https://github.com/thedersen/backbone.validation)
- [Exoskeleton](https://github.com/paulmillr/exoskeleton)
- [Backbone.dualstorage](https://github.com/nilbus/Backbone.dualStorage)
- [Backbone.iobind](https://github.com/noveogroup/backbone.iobind)
- [Backbone-associations](https://github.com/dhruvaray/backbone-associations)
- [Backbone-tastypie](https://github.com/PaulUithol/backbone-tastypie)
- [Backbone.Radio](https://github.com/marionettejs/backbone.radio)
- [Backbone.BabySitter](https://github.com/marionettejs/backbone.babysitter)
- [Backbone.History.Polyfill](https://github.com/FidelityInternational/BackboneHistoryPolyfill)
