<div class="github-widget" data-repo="donnemartin/awesome-aws"></div>
<br/>
<p align="center">
  <img src="https://raw.githubusercontent.com/donnemartin/data-science-ipython-notebooks/master/images/aws.png">
</p>
<br/>

## Awesome AWS [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

精选的 AWS 库、开源存储库、指南、博客和其他资源的精选列表.

灵感来自 [awesome](https://github.com/sindresorhus/awesome) 列表.

## The Fiery Meter of AWSome

* 0100+ 星的回购：：火：
* 0200+ 星的回购：：火：：火：
* 0500+ 星的回购：：火：：火：：火：
* 拥有 1000 多个星星的回购协议：:fire::fire::fire::fire:
* 拥有 2000 多个星星的回购协议：:fire::fire::fire::fire::fire:

不在 AWSome 的 Fiery Meter 上的回购仍然很棒，请参阅 [A Note on Repo AWSomeness](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md#a-note-on-repo-awsomeness).

### `awesome-aws` Python Module

[![Build Status](https://travis-ci.org/donnemartin/awesome-aws.svg?branch=master)](https://travis-ci.org/donnemartin/awesome-aws) [![Codecov](https://img.shields.io/codecov/c/github/donnemartin/awesome-aws.svg)](https://codecov.io/github/donnemartin/awesome-aws) [![PyPI version](https://badge.fury.io/py/awesome-aws.svg)](http://badge.fury.io/py/awesome-aws)

Python模块 [`awesome-aws`](https://github.com/donnemartin/awesome-aws/tree/master/awesome) 定期扫描回购 [Awesome AWS](https://github.com/donnemartin/awesome-aws) 保持 AWSome 的“Fiery Meter”的准确性.

## Contributing

欢迎投稿！

回顾 [Contributing Guidelines](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md).

另请查看 [Watch List](https://github.com/donnemartin/awesome-aws/issues/34).

## Index


## SDKs and Samples

*带有示例和文档的 AWS 和社区 SDK，按语言分组.*

<br/>
<p align="center">
  <img src="http://i.imgur.com/TK96G8T.png">
</p>
<br/>

### Android SDK

* [Repo :fire::fire::fire:](https://github.com/aws/aws-sdk-android)
* [Repo with Samples :fire::fire::fire:](https://github.com/awslabs/aws-sdk-android-samples)
* [Install](http://sdk-for-android.amazonwebservices.com/latest/aws-android-sdk.zip)
* [Docs](https://aws.amazon.com/documentation/sdk-for-android/)
* [Learn More](https://aws.amazon.com/mobile/sdk/)

### C++ SDK

* [Repo :fire::fire::fire::fire:](https://github.com/awslabs/aws-sdk-cpp)
* [Blog with Samples](https://aws.amazon.com/blogs/aws/introducing-the-aws-sdk-for-c/)

*C++ SDK 是一个实验室项目，文档和/或样本有限.*

### Clojure SDK

* [Repo :fire::fire::fire:](https://github.com/mcohen01/amazonica)
* [Install](https://github.com/mcohen01/amazonica#installation)
* [Docs](https://github.com/mcohen01/amazonica#documentation)

*Clojure SDK 是一个社区项目，文档和/或示例有限.*）

### Go SDK

* [Repo :fire::fire::fire::fire::fire:](https://github.com/aws/aws-sdk-go)
* [Install](https://github.com/aws/aws-sdk-go/wiki)
* [Docs](http://docs.aws.amazon.com/sdk-for-go/api/)
* [Learn More](https://aws.amazon.com/sdk-for-go/)

相关回购：

* [goamz/goamz :fire::fire:](https://github.com/goamz/goamz)

### iOS SDK

* [Repo :fire::fire::fire::fire:](https://github.com/aws/aws-sdk-ios)
* [Repo with Samples :fire::fire::fire::fire:](https://github.com/awslabs/aws-sdk-ios-samples)
* [Install](http://sdk-for-ios.amazonwebservices.com/latest/aws-ios-sdk.zip)
* [Docs](https://aws.amazon.com/documentation/sdk-for-ios/)
* [Learn More](https://aws.amazon.com/mobile/sdk/)

### IoT SDK

* [Repo for Arduino](https://github.com/awslabs/aws-sdk-arduino)
* [Repo for C :fire::fire::fire:](https://github.com/aws/aws-iot-device-sdk-embedded-C)
* [Repo for JavaScript :fire::fire::fire:](https://github.com/aws/aws-iot-device-sdk-js)
* [Repo for Arduino Yun :fire:](https://github.com/aws/aws-iot-device-sdk-arduino-yun/)
* [Docs](http://docs.aws.amazon.com/iot/latest/developerguide/what-is-aws-iot.html)

*IoT SDK 是一个实验室项目，文档和/或示例有限.*

### Java SDK

* [Repo :fire::fire::fire::fire::fire:](https://github.com/aws/aws-sdk-java)
* [Repo with Samples :fire::fire:](https://github.com/awslabs/aws-java-sample)
* [Install](http://sdk-for-java.amazonwebservices.com/latest/aws-java-sdk.zip)
* [Docs](https://aws.amazon.com/documentation/sdk-for-java/)
* [Learn More](https://aws.amazon.com/sdk-for-java/)

### JavaScript SDK

* [Repo :fire::fire::fire::fire::fire:](https://github.com/aws/aws-sdk-js)
* [Repo with Samples :fire::fire:](https://github.com/awslabs/aws-nodejs-sample)
* [Install](http://docs.aws.amazon.com/AWSJavaScriptSDK/guide/node-intro.html)
* [Docs](https://aws.amazon.com/documentation/sdk-for-javascript/)
* [Learn More](https://aws.amazon.com/sdk-for-node-js/)

相关回购：

* [aws/aws-amplify :fire::fire::fire::fire::fire:](https://github.com/aws/aws-amplify)
* [chilts/awssum :fire::fire:](https://github.com/chilts/awssum)
* [mirkokiefer/aws-lib :fire::fire::fire:](https://github.com/mirkokiefer/aws-lib)
* [SaltwaterC/aws2js :fire::fire:](https://github.com/SaltwaterC/aws2js)

### Haskell SDK

* [Repo :fire::fire::fire:](https://github.com/brendanhay/amazonka)
* [Docs](http://hackage.haskell.org/packages/#cat:AWS)

相关回购：

* [aristidb/aws :fire::fire:](https://github.com/aristidb/aws)

*Haskell SDK 是一个社区项目，文档和/或示例有限.*

### Perl SDK

* [Repo :fire:](https://github.com/pplu/aws-sdk-perl)
* [Repo with Samples :fire:](https://github.com/pplu/aws-sdk-perl/tree/master/examples)
* [Install](https://github.com/pplu/aws-sdk-perl#installation)
* [Docs](https://metacpan.org/pod/Paws)
* [Learn More](https://metacpan.org/pod/Paws)

*Perl SDK 是一个社区项目.*

### PHP SDK

* [Repo :fire::fire::fire::fire::fire:](https://github.com/aws/aws-sdk-php)
* [Repo with Samples](https://github.com/awslabs/aws-php-sample)
* [Install](http://docs.aws.amazon.com/aws-sdk-php/v3/guide/getting-started/installation.html)
* [Docs](https://aws.amazon.com/documentation/sdk-for-php/)
* [Learn More](https://aws.amazon.com/sdk-for-php/)

相关回购：

* [aws-sdk-php-laravel :fire::fire::fire::fire:](https://github.com/aws/aws-sdk-php-laravel)
* [aws-sdk-php-silex](https://github.com/aws/aws-sdk-php-silex)
* [aws-sdk-php-zf2 :fire:](https://github.com/aws/aws-sdk-php-zf2)

### Python SDK

* [Repo :fire::fire::fire::fire::fire:](https://github.com/boto/boto3)
* [Repo with Samples :fire:](https://github.com/awslabs/aws-python-sample)
* [Install](http://github.com/boto/boto#installation)
* [Docs](https://boto3.amazonaws.com/v1/documentation/api/latest/index.html)
* [Learn More](http://github.com/boto/boto/blob/develop/README.rst#boto)

相关回购：

* [boto3 :fire::fire::fire::fire::fire:](https://github.com/boto/boto3)
* [botocore :fire::fire::fire::fire:](https://github.com/boto/botocore)

### Ruby SDK

* [Repo :fire::fire::fire::fire::fire:](https://github.com/aws/aws-sdk-ruby)
* [Repo with S3 Sample](https://github.com/awslabs/aws-ruby-sample)
* [Install](http://docs.aws.amazon.com/sdk-for-ruby/v3/developer-guide/setup-install.html)
* [Docs](https://aws.amazon.com/documentation/sdk-for-ruby/)
* [Samples :fire::fire::fire::fire::fire:](https://github.com/awsdocs/aws-doc-sdk-examples/tree/master/ruby/example_code/)

相关回购：

* [aws-sdk-rails :fire::fire::fire:](https://github.com/aws/aws-sdk-rails)
* [appoxy/aws :fire::fire:](https://github.com/appoxy/aws)
* [rightscale/right_aws :fire::fire:](https://github.com/rightscale/right_aws)

### Rust SDK

* [Repo :fire::fire::fire::fire::fire:](https://github.com/rusoto/rusoto)
* [Install](https://github.com/rusoto/rusoto#installation)
* [Docs](https://docs.rs/rusoto_core/)

*Rust SDK 是一个社区项目，文档和/或样本有限.*

### Scala SDK

* [Repo](https://github.com/awslabs/aws-scala-sdk)

相关回购：

* [atlassian/aws-scala](https://bitbucket.org/atlassian/aws-scala)
* [seratch/AWScala :fire::fire::fire:](https://github.com/seratch/AWScala)

*Scala SDK 是一个实验室项目，文档和/或样本有限.*

### Unity SDK

* [Repo :fire:](https://github.com/aws/aws-sdk-unity)
* [Repo with Samples :fire:](https://github.com/awslabs/aws-sdk-unity-samples)
* [Install](https://s3.amazonaws.com/aws-unity-sdk/latest/aws-unity-sdk.zip)
* [Docs](http://docs.aws.amazon.com/mobile/sdkforunity/developerguide/)

### Xamarin SDK

* [Repo](https://github.com/awslabs/aws-sdk-xamarin)
* [Blog with Samples](https://blog.xamarin.com/amazon-web-services-aws-mobile-sdks-for-xamarin-now-available/)

*Xamarin SDK 是一个实验室项目，文档和/或示例有限.*

### .NET SDK

* [Repo :fire::fire::fire::fire:](https://github.com/aws/aws-sdk-net)
* [Repo with Samples](https://github.com/awslabs/aws-auto-scaling-console-sample)
* [Install](http://sdk-for-net.amazonwebservices.com/latest/AWSToolsAndSDKForNet.msi)
* [Docs](https://aws.amazon.com/documentation/sdk-for-net/)
* [Learn More](https://aws.amazon.com/sdk-for-net/)
* [Samples :fire:](https://github.com/awslabs/aws-sdk-net-samples)

## Command Line Tools

*带有示例和文档的 AWS 和社区命令行工具.*

<br/>
<p align="center">
  <img src="https://raw.githubusercontent.com/donnemartin/data-science-ipython-notebooks/master/images/commands.png">
</p>
<br/>

### Universal Command Line Interface

* [Repo :fire::fire::fire::fire::fire:](https://github.com/aws/aws-cli)
* [Install](http://docs.aws.amazon.com/cli/latest/userguide/cli-chap-getting-set-up.html)
* [Docs](https://aws.amazon.com/documentation/cli/)
* [Learn More](https://aws.amazon.com/cli/)

相关回购：

* [awslabs/aws-shell :fire::fire::fire::fire::fire:](https://github.com/awslabs/aws-shell)
* [donnemartin/saws :fire::fire::fire::fire::fire:](https://github.com/donnemartin/saws)

### Windows PowerShell

* [Install](http://sdk-for-net.amazonwebservices.com/latest/AWSToolsAndSDKForNet.msi)
* [Docs](https://aws.amazon.com/documentation/powershell/)
* [Learn More](https://aws.amazon.com/powershell/)

## IDE Toolkits

*带有示例和文档的官方 IDE 工具包.*

<br/>
<p align="center">
  <img src="http://i.imgur.com/x4nu914.png">
</p>
<br/>

### Eclipse Toolkit

* [Install](http://docs.aws.amazon.com/AWSToolkitEclipse/latest/ug/tke_setup.html)
* [Docs](https://aws.amazon.com/documentation/awstoolkiteclipse/)
* [Learn More](https://aws.amazon.com/eclipse/)

### Visual Studio Toolkit

* [Install](http://sdk-for-net.amazonwebservices.com/latest/AWSToolsAndSDKForNet.msi)
* [Docs](https://aws.amazon.com/documentation/aws-toolkit-visual-studio/)
* [Learn More](https://aws.amazon.com/visualstudio/)

## Open Source Repos

 *AWS 和社区开源项目，按服务分组. 看 [A Note on Repo AWSomeness](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md#a-note-on-repo-awsomeness) 更多细节.*

<br/>
<p align="center">
  <img src="http://i.imgur.com/wbhTgga.png">
</p>
<br/>

### API Gateway

AWS 回购协议：

* [api-gateway-secure-pet-store :fire::fire:](https://github.com/awslabs/api-gateway-secure-pet-store) - 通过 Lambda 的 Cognito 凭据.
* [aws-apigateway-sdk-java](https://github.com/awslabs/aws-apigateway-sdk-java) - Java 开发工具包.
* [aws-apigateway-swagger-importer :fire::fire::fire:](https://github.com/awslabs/aws-apigateway-importer) - 与 Swagger 一起工作的工具.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### CLI

AWS 回购协议：

* [awscli-aliases :fire::fire:](https://github.com/awslabs/awscli-aliases) - AWS CLI 别名的存储库.
* [amazon-ecs-cli :fire::fire::fire::fire:](https://github.com/aws/amazon-ecs-cli) - ECS CLI 使用相同的 Docker Compose 文件格式和熟悉的 Compose 命令.
* [aws-cli :fire::fire::fire::fire::fire:](https://github.com/aws/aws-cli) - 通用命令行界面.
* [aws-shell :fire::fire::fire::fire::fire:](https://github.com/awslabs/aws-shell)
* [awscli-cookbook](https://github.com/awslabs/awscli-cookbook) - 安装 CLI 工具并提供一组 LWRP 以供在厨师食谱中使用.
* [awsmobile-cli :fire:](https://github.com/aws/awsmobile-cli) - JavaScript 生态系统中前端开发人员的 CLI 体验.

社区回购：

* [achiku/jungle :fire::fire::fire:](https://github.com/achiku/jungle) - EC2 和 ELB cli 的操作应该更简单.
* [dbcli/athenacli :fire:](https://github.com/dbcli/athenacli) - AWS Athena 服务的 CLI 工具，可以自动完成和语法突出显示.
* [donnemartin/saws :fire::fire::fire::fire::fire:](https://github.com/donnemartin/saws) - 增强型 AWS 命令​​行界面.
* [timkay/aws :fire::fire:](https://github.com/timkay/aws) - 轻松通过命令行访问 Amazon EC2、S3、SQS、ELB 和 SDB.
* [wallix/awless :fire::fire::fire::fire::fire:](https://github.com/wallix/awless) - Go 中用于 EC2、IAM 和 S3 的强大 CLI.
* [99designs/aws-vault :fire::fire::fire::fire::fire:](https://github.com/99designs/aws-vault) - 用 Go 编写的用于安全存储 AWS 凭证的工具.

### CloudFormation

AWS 回购协议：

* [aws-cdk :fire::fire::fire::fire::fire:](https://github.com/aws/aws-cdk) - 在代码中定义云基础设施的框架.
* [aws-cfn-custom-resource-examples](https://github.com/awslabs/aws-cfn-custom-resource-examples) - 自定义资源示例.
* [aws-cfn-resource-bridge](https://github.com/aws/aws-cfn-resource-bridge) - 自定义资源框架.
* [cfn-python-lint :fire::fire::fire::fire::fire:](https://github.com/awslabs/cfn-python-lint) - 用于检查/验证 CloudFormation 的工具.
* [cfncluster-cookbook](https://github.com/awslabs/cfncluster-cookbook) - 样本食谱.
* [cfncluster :fire::fire::fire:](https://github.com/awslabs/cfncluster) - 部署和维护 HPC 集群的框架.

社区回购：

* [Appliscale/perun](https://github.com/Appliscale/perun) - 用于检查/验证和管理 CloudFormation 模板和堆栈的 CLI 工具.
* [bazaarvoice/cloudformation-ruby-dsl :fire::fire:](https://github.com/bazaarvoice/cloudformation-ruby-dsl) - 用于创建模板的 Ruby DSL.
* [beaknit/cform :fire:](https://github.com/beaknit/cform) - SublimeText 插件.
* [cloudreach/sceptre :fire::fire::fire::fire:](https://github.com/cloudreach/sceptre) - 用于自动化 CloudFormation 的 CLI 工具.
* [cloudtools/troposphere :fire::fire::fire::fire::fire:](https://github.com/cloudtools/troposphere) - 用于创建描述的 Python 库.
* [peterkh/cumulus :fire::fire:](https://github.com/peterkh/cumulus) - 管理堆栈.
* [envato/stack_master :fire::fire:](https://github.com/envato/stack_master) - 用于管理 CloudFormation 堆栈的 CLI 工具.
* [sparkleformation/sfn](https://github.com/sparkleformation/sfn) - 用于堆栈管理的 CLI.
* [sparkleformation/sparkle_formation :fire::fire:](https://github.com/sparkleformation/sparkle_formation) - 用于模板创建的 Ruby DSL.
* [Stelligent/cfn_nag :fire::fire::fire::fire:](https://github.com/stelligent/cfn_nag) - CloudFormation 模板的 Linting 工具

### CloudSearch

AWS 回购协议：

* [cloudsearchable](https://github.com/awslabs/cloudsearchable) - 一个 ActiveRecord 风格的 ORM 查询接口.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### CloudTrail

AWS 回购协议：

* [aws-cloudtrail-processing-library](https://github.com/aws/aws-cloudtrail-processing-library) - 轻松使用和处理日志文件.

社区回购：

* [AppliedTrust/traildash :fire::fire:](https://github.com/AppliedTrust/traildash) - 光滑的仪表板.
* [GorillaStack/auto-tag :fire::fire:](https://github.com/GorillaStack/auto-tag) - 在创建时自动标记 AWS 资源，用于成本分配.

### CloudWatch

AWS 回购协议：

* [cloudwatch-logs-subscription-consumer :fire::fire:](https://github.com/awslabs/cloudwatch-logs-subscription-consumer) - 运动流阅读器.
* [ecs-cloudwatch-logs](https://github.com/awslabs/ecs-cloudwatch-logs) - 关于使用 Amazon ECS 和 Amazon CloudWatch 日志的博客文章中的资产.
* [logstash-output-cloudwatchlogs](https://github.com/awslabs/logstash-output-cloudwatchlogs) - 将日志发送到 CloudWatch 的 logstash 插件.
* [opsworks-cloudwatch-logs-cookbooks](https://github.com/awslabs/opsworks-cloudwatch-logs-cookbooks) - OpsWorks 示例食谱.

社区回购：

* [jorgebastida/awslogs :fire::fire::fire::fire::fire:](https://github.com/jorgebastida/awslogs) - 用于查询组、流和事件的简单 CLI.
* [newrelic-platform/newrelic_aws_cloudwatch_plugin :fire:](https://github.com/newrelic-platform/newrelic_aws_cloudwatch_plugin) - 新遗物插件.

### Code Deploy

AWS 回购协议：

* [aws-codedeploy-agent :fire::fire:](https://github.com/aws/aws-codedeploy-agent) - 样本代理.
* [aws-codedeploy-plugin :fire:](https://github.com/awslabs/aws-codedeploy-plugin) - 詹金斯插件.
* [aws-codedeploy-samples :fire::fire::fire:](https://github.com/awslabs/aws-codedeploy-samples) - 示例和模板场景.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### Code Pipeline

AWS 回购协议：

* [aws-codepipeline-custom-job-worker](https://github.com/awslabs/aws-codepipeline-custom-job-worker) - 在创建自定义操作时开发您自己的工作人员.
* [aws-codepipeline-jenkins-aws-codedeploy_linux](https://github.com/awslabs/aws-codepipeline-jenkins-aws-codedeploy_linux) - Linux 的四级流水线.
* [aws-codepipeline-plugin-for-jenkins](https://github.com/awslabs/aws-codepipeline-plugin-for-jenkins) - 詹金斯插件.
* [aws-codepipeline-s3-aws-codedeploy_linux :fire:](https://github.com/awslabs/aws-codepipeline-s3-aws-codedeploy_linux) - Linux 的简单管道.
* [AWSCodePipeline-Jenkins-AWSCodeDeploy_Windows](https://github.com/awslabs/AWSCodePipeline-Jenkins-AWSCodeDeploy_Windows) - 适用于 Windows 的四级流水线.
* [AWSCodePipeline-S3-AWSCodeDeploy_Windows](https://github.com/awslabs/AWSCodePipeline-S3-AWSCodeDeploy_Windows) - 适用于 Windows 的简单管道.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### Cognito

AWS 回购协议：

* [amazon-cognito-android](https://github.com/aws/amazon-cognito-android) - 适用于 Android 的同步 SDK.
* [amazon-cognito-developer-authentication-sample](https://github.com/awslabs/amazon-cognito-developer-authentication-sample) - 认证样本.
* [amazon-cognito-dotnet](https://github.com/aws/amazon-cognito-dotnet) - .NET 的同步 SDK.
* [amazon-cognito-ios](https://github.com/aws/amazon-cognito-ios) - 适用于 iOS 的同步 SDK.
* [amazon-cognito-js :fire::fire:](https://github.com/aws/amazon-cognito-js) - 用于 JavaScript 的同步 SDK.
* [amazon-cognito-streams-sample](https://github.com/awslabs/amazon-cognito-streams-sample) - 消费流样本.
* [cognito-sample-nodejs :fire:](https://github.com/awslabs/cognito-sample-nodejs) - Node.js 的示例应用程序.

社区回购：

* [capeless/warrant :fire::fire:](https://github.com/capless/warrant) - 用于使用 Cognito 的 Python 库.
* [rahulpsd18/cognito-backup-restore :fire:](https://github.com/rahulpsd18/cognito-backup-restore) - 用于备份和恢复 Cognito 用户池的工具.

### Data Pipeline

AWS 回购协议：

* [data-pipeline-samples :fire::fire:](https://github.com/awslabs/data-pipeline-samples) - 样本管道.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### Device Farm

AWS 回购协议：

* [aws-device-farm-appium-tests-for-sample-app](https://github.com/awslabs/aws-device-farm-appium-tests-for-sample-app) -Appium TestNG Android 测试.
* [aws-device-farm-calabash-tests-for-sample-app](https://github.com/awslabs/aws-device-farm-calabash-tests-for-sample-app) - 葫芦 Android 测试.
* [aws-device-farm-gradle-plugin](https://github.com/awslabs/aws-device-farm-gradle-plugin) -摇篮插件.
* [aws-device-farm-jenkins-plugin](https://github.com/awslabs/aws-device-farm-jenkins-plugin) - 詹金斯插件.
* [aws-device-farm-sample-app-for-android :fire:](https://github.com/awslabs/aws-device-farm-sample-app-for-android) - 示例 Android 应用程序.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### DynamoDB

AWS 回购协议：

* [aws-dotnet-session-provider](https://github.com/aws/aws-dotnet-session-provider) - ASP.NET 应用程序的会话状态提供程序.
* [aws-dotnet-trace-listener](https://github.com/aws/aws-dotnet-trace-listener) - System.Diagnostics 的跟踪侦听器，可用于记录事件.
* [aws-dynamodb-encryption-java :fire:](https://github.com/awslabs/aws-dynamodb-encryption-java) - Java 加密客户端.
* [aws-dynamodb-examples :fire::fire:](https://github.com/awslabs/aws-dynamodb-examples) - 使用 Java SDK 的示例.
* [aws-dynamodb-mars-json-demo](https://github.com/awslabs/aws-dynamodb-mars-json-demo) - 存储和索引 NASA JPL 火星图像.
* [aws-dynamodb-session-tomcat](https://github.com/aws/aws-dynamodb-session-tomcat) - Apache Tomcat 的会话存储.
* [aws-sessionstore-dynamodb-ruby](https://github.com/aws/aws-sessionstore-dynamodb-ruby) - 处理 Ruby 网络应用程序的会话.
* [dynamodb-cross-region-library :fire::fire:](https://github.com/awslabs/dynamodb-cross-region-library) - 跨区域复制.
* [dynamodb-geo :fire::fire:](https://github.com/awslabs/dynamodb-geo) - 用于创建和查询地理空间数据的库.
* [dynamodb-import-export-tool](https://github.com/awslabs/dynamodb-import-export-tool) - 导入和导出示例.
* [dynamodb-online-index-violation-detector](https://github.com/awslabs/dynamodb-online-index-violation-detector) - 查找在线 GSI 的散列键和范围键的违规行为.
* [dynamodb-streams-kinesis-adapter](https://github.com/awslabs/dynamodb-streams-kinesis-adapter) - 用于使用和处理来自 DynamoDB 流的数据的 Kinesis 接口.
* [dynamodb-tictactoe-example-app](https://github.com/awslabs/dynamodb-tictactoe-example-app) - 轻量级 python 应用程序.
* [dynamodb-titan-storage-backend :fire::fire:](https://github.com/awslabs/dynamodb-titan-storage-backend) - Titan 的存储后端.
* [dynamodb-transactions :fire::fire:](https://github.com/awslabs/dynamodb-transactions) - 跨多个项目和表执行原子写入和隔离读取.
* [logstash-input-dynamodb :fire:](https://github.com/awslabs/logstash-input-dynamodb) - Logstash 输入插件.

社区回购：

* [channl/dynamodb-lambda-autoscale :fire::fire:](https://github.com/channl/dynamodb-lambda-autoscale) - 使用 Lambda 自动缩放 DynamoDB 配置的容量.
* [lyft/confidant :fire::fire::fire::fire:](https://github.com/lyft/confidant) - 存储秘密，静态加密.
* [sebdah/dynamic-dynamodb :fire::fire::fire:](https://github.com/sebdah/dynamic-dynamodb) - 提供自动缩放.
* [sensedeep/dynamodb-onetable :fire::fire::fire:](https://github.com/sensedeep/dynamodb-onetable) - 使用 NodeJS 进行单表设计的 DynamoDB 库.

### Elastic Beanstalk

AWS 回购协议：

* [aws-eb-glassfish-dockerfiles](https://github.com/aws/aws-eb-glassfish-dockerfiles) - GlassFish 泊坞窗文件.
* [aws-eb-python-dockerfiles](https://github.com/aws/aws-eb-python-dockerfiles) - Python 泊坞窗文件.
* [eb-demo-php-simple-app :fire:](https://github.com/awslabs/eb-demo-php-simple-app) - 简单的 PHP 应用程序.
* [eb-docker-multiple-ports](https://github.com/awslabs/eb-docker-multiple-ports) - 使用 Docker 图像的简单 Node.js 和 Tomcat 应用程序.
* [eb-docker-nginx-proxy :fire:](https://github.com/awslabs/eb-docker-nginx-proxy) - 使用 PHP-FPM 和 Nginx Docker 图像的简单 PHP 应用程序.
* [eb-docker-virtual-hosting](https://github.com/awslabs/eb-docker-virtual-hosting) - 使用 Docker 映像的简单 PHP、Tomcat 和 Nginx 应用程序.
* [eb-node-express-sample :fire::fire:](https://github.com/awslabs/eb-node-express-sample) - Sample express app.
* [eb-node-express-signup](https://github.com/awslabs/eb-node-express-signup) - Express 框架和 Bootstrap Node.js 示例应用程序.
* [eb-node-express](https://github.com/awslabs/eb-node-express) - 开发人员指南中引用的示例应用程序.
* [eb-py-flask-signup-worker](https://github.com/awslabs/eb-py-flask-signup-worker) - 说明工作者角色的 Python 应用程序.
* [eb-py-flask-signup :fire::fire:](https://github.com/awslabs/eb-py-flask-signup) - 带有 Flask 和 Bootstrap 的 Python 注册表单应用程序.
* [eb-python-flask](https://github.com/awslabs/eb-python-flask) - 简单的 Python 和 Flask 应用程序.
* [eb-wif-sample](https://github.com/awslabs/eb-wif-sample) - 使用 Web 联合身份验证的示例登录应用程序.

社区回购：

* [alienfast/elastic-beanstalk :fire:](https://github.com/alienfast/elastic-beanstalk) - 带有 rake 配置和部署的 Rails 应用程序的 Gem.
* [ThoughtWorksStudios/eb_deployer :fire::fire:](https://github.com/ThoughtWorksStudios/eb_deployer) - 蓝绿部署自动化.

### Elastic Compute Cloud

AWS 回购协议：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

社区回购：

* [alestic/ec2-consistent-snapshot :fire::fire:](https://github.com/alestic/ec2-consistent-snapshot) - 在 EC2 中启动一致的 EBS 快照.
* [ConradIrwin/aws-name-server :fire::fire::fire:](https://github.com/ConradIrwin/aws-name-server) - 允许您按名称查找实例的 DNS 服务器.
* [cristim/autospotting :fire::fire::fire::fire::fire:](https://github.com/autospotting/autospotting) - 使用兼容的 Spot 实例自动滚动替换 AutoScaling 组中的按需 EC2 实例.
* [evannuil/aws-snapshot-tool :fire::fire:](https://github.com/evannuil/aws-snapshot-tool) - 自动化 EBS 快照和旋转.
* [kelseyhightower/kubernetes-the-hard-way :fire::fire::fire::fire::fire:](https://github.com/kelseyhightower/kubernetes-the-hard-way)  - 在 EC2 上以艰难的方式引导 Kubernetes. 没有脚本.
* [mirakui/ec2ssh :fire::fire:](https://github.com/mirakui/ec2ssh) - SSH 配置管理器.
* [openebs/openebs :fire::fire::fire::fire::fire:](https://github.com/openebs/openebs) - 容器化块存储 QoS SLA、跨 AZ 和环境的分层和复制策略，以及可预测和可扩展的性能.
* [skavanagh/EC2Box :fire::fire:](https://github.com/skavanagh/EC2Box) - 基于 Web 的 SSH 控制台，可同时管理多个实例.
* [wbailey/claws :fire:](https://github.com/wbailey/claws) - CLI 驱动的控制台与 capistrano 集成.

### Elastic Container Service

AWS 回购协议：

* [amazon-ecs-agent :fire::fire::fire::fire:](https://github.com/aws/amazon-ecs-agent) - 在容器上运行并启动容器的代理.
* [amazon-ecs-amazon-efs](https://github.com/awslabs/amazon-ecs-amazon-efs) - 保存来自容器的数据.
* [amazon-ecs-init :fire:](https://github.com/aws/amazon-ecs-init) - 为支持 Amazon ECS 容器代理而开发的 RPM.
* [blox :fire::fire::fire:](https://github.com/blox/blox) - 用于在 ECS 上构建自定义调度程序的开源工具.
* [ecs-blue-green-deployment :fire::fire:](https://github.com/awslabs/ecs-blue-green-deployment) - ECS 上的蓝绿部署.
* [ecs-cloudwatch-logs](https://github.com/awslabs/ecs-cloudwatch-logs) - 来自使用 Amazon ECS 和 Amazon CloudWatch 日志的博客的资产.
* [ecs-demo-php-simple-app :fire:](https://github.com/awslabs/ecs-demo-php-simple-app) - 简单的 PHP 应用程序.
* [ecs-mesos-scheduler-driver :fire:](https://github.com/awslabs/ecs-mesos-scheduler-driver) - 集成 Apache Mesos.
* [ecs-refarch-continuous-deployment :fire::fire::fire:](https://github.com/awslabs/ecs-refarch-continuous-deployment) - 使用 CodePipeline 持续部署到 ECS 的参考架构.
* [ecs-task-kite](https://github.com/awslabs/ecs-task-kite) - 用于任务间通信的简单大使容器.
* [lambda-ecs-worker-pattern :fire::fire:](https://github.com/awslabs/lambda-ecs-worker-pattern) - 使用 SQS 和 ECS 扩展 Lambda.
* [py-flask-signup-docker](https://github.com/awslabs/py-flask-signup-docker) - Python 示例应用程序.
* [service-discovery-ecs-consul :fire:](https://github.com/awslabs/service-discovery-ecs-consul) - 来自博客 Service Discovery via Consul with Amazon ECS 的资产.

社区回购：

* [Lumoslabs/broadside](https://github.com/lumoslabs/broadside) - 用于部署容器化应用程序修订版的命令行工具.
* [Stelligent/mu :fire::fire::fire:](https://github.com/stelligent/mu) - 用于通过 CodeBuild 和 CodePipeline 简化 ECS 部署的命令行工具.

### Elastic File System

AWS 回购协议：

* [amazon-ecs-amazon-efs](https://github.com/awslabs/amazon-ecs-amazon-efs) - 保留来自 ECS 的数据.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### Elastic MapReduce

AWS 回购协议：

* [emr-bootstrap-actions :fire::fire::fire:](https://github.com/awslabs/emr-bootstrap-actions) - 样本引导操作.
* [emr-sample-apps](https://github.com/awslabs/emr-sample-apps) - 示例应用程序.

社区回购：

* [Yelp/mrjob :fire::fire::fire::fire::fire:](https://github.com/Yelp/mrjob) - 在 Hadoop 或 EMR 上运行 MapReduce 作业.

### Elastic Search

AWS 回购协议：

* [logstash-output-amazon_es :fire::fire:](https://github.com/awslabs/logstash-output-amazon_es) - 用于签署和导出事件的 Logstash 输出插件.
* [opsworks-elasticsearch-cookbook](https://github.com/awslabs/opsworks-elasticsearch-cookbook) - OpsWorks Elasticsearch 示例食谱.

社区回购：

* [elastic/elasticsearch-cloud-aws :fire::fire::fire:](https://github.com/elastic/elasticsearch-cloud-aws) - 弹性搜索插件.

### Elasticache

AWS 回购协议：

* [aws-elasticache-cluster-client-libmemcached](https://github.com/awslabs/aws-elasticache-cluster-client-libmemcached) - Libmemcached 库支持.
* [aws-elasticache-cluster-client-memcached-for-java](https://github.com/awslabs/aws-elasticache-cluster-client-memcached-for-java) - Java 客户端.
* [aws-elasticache-cluster-client-memcached-for-php](https://github.com/awslabs/aws-elasticache-cluster-client-memcached-for-php) - 增强的 PHP 库连接到 ElastiCache.
* [elasticache-cluster-config-net](https://github.com/awslabs/elasticache-cluster-config-net) - Enyim 的 MemcachedClient 的配置对象以启用自动发现.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### Glacier

社区回购：

* [vsespb/mt-aws-glacier :fire::fire::fire:](https://github.com/vsespb/mt-aws-glacier) - Perl 多线程多部分同步到 Glacier.

### Kinesis

AWS 回购协议：

* [amazon-kinesis-aggregators :fire:](https://github.com/awslabs/amazon-kinesis-aggregators) - 提供了一种创建实时聚合的简单方法.
* [amazon-kinesis-client-net](https://github.com/awslabs/amazon-kinesis-client-net) - .NET 的客户端库.
* [amazon-kinesis-client-nodejs :fire::fire:](https://github.com/awslabs/amazon-kinesis-client-nodejs) - Node.js 的客户端库.
* [amazon-kinesis-client-python :fire::fire:](https://github.com/awslabs/amazon-kinesis-client-python) - Python 客户端库.
* [amazon-kinesis-client-ruby :fire:](https://github.com/awslabs/amazon-kinesis-client-ruby) - Ruby 客户端库.
* [amazon-kinesis-client :fire::fire::fire:](https://github.com/awslabs/amazon-kinesis-client) Amazon Kinesis 的客户端库.
* [amazon-kinesis-connectors :fire::fire:](https://github.com/awslabs/amazon-kinesis-connectors) - 与其他 AWS 和非 AWS 服务集成的库.
* [amazon-kinesis-data-visualization-sample :fire:](https://github.com/awslabs/amazon-kinesis-data-visualization-sample) - 示例数据可视化应用程序.
* [amazon-kinesis-learning](https://github.com/awslabs/amazon-kinesis-learning) - 学习运动发展.
* [amazon-kinesis-producer :fire::fire:](https://github.com/awslabs/amazon-kinesis-producer) - 制作人图书馆.
* [amazon-kinesis-scaling-utils :fire::fire:](https://github.com/awslabs/amazon-kinesis-scaling-utils) - 提供扩展流的能力.
* [aws-fluent-plugin-kinesis :fire::fire:](https://github.com/awslabs/aws-fluent-plugin-kinesis) - 流畅的插件.
* [dynamodb-streams-kinesis-adapter](https://github.com/awslabs/dynamodb-streams-kinesis-adapter) - DynamoDB Streams Adapter.
* [kinesis-log4j-appender](https://github.com/awslabs/kinesis-log4j-appender) - Log4J 附加程序.
* [kinesis-poster-worker](https://github.com/awslabs/kinesis-poster-worker) - 简单的多线程 Python 海报和工人.
* [kinesis-storm-spout :fire:](https://github.com/awslabs/kinesis-storm-spout) - 喷出风暴.
* [mqtt-kinesis-bridge](https://github.com/awslabs/mqtt-kinesis-bridge) - Python 中的简单 MQTT 桥.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### Lambda

AWS 回购协议：

* [amazon-elasticsearch-lambda-samples :fire::fire:](https://github.com/awslabs/amazon-elasticsearch-lambda-samples) - 从 S3 和 Kinesis 为 Elasticsearch 提取数据.
* [awslabs/aws-sam-local :fire::fire::fire::fire::fire:](https://github.com/awslabs/aws-sam-local) - 用于本地开发和测试无服务器应用程序的 CLI 工具.
* [aws-lambda-go :fire::fire::fire::fire::fire:](https://github.com/aws/aws-lambda-go) - 帮助 Go 开发人员开发 Lambda 函数的库、示例和工具.
* [aws-lambda-java-libs :fire::fire:](https://github.com/aws/aws-lambda-java-libs) - 接口定义和辅助类的官方镜像.
* [aws-lambda-redshift-loader :fire::fire::fire:](https://github.com/awslabs/aws-lambda-redshift-loader) - 红移装载机.
* [chalice :fire::fire::fire::fire::fire:](https://github.com/awslabs/chalice) - Python 无服务器微框架.
* [create-thumbnails-lambda](https://github.com/awslabs/create-thumbnails-lambda) - 使用 grunt-aws-lambda 插件来帮助您开发和测试.
* [lambda-ecs-worker-pattern :fire::fire:](https://github.com/awslabs/lambda-ecs-worker-pattern) - 使用 SQS 和 ECS 扩展 Lambda.
* [lambda-refarch-fileprocessing :fire::fire:](https://github.com/awslabs/lambda-refarch-fileprocessing) - 实时文件处理的参考架构.
* [lambda-refarch-iotbackend :fire::fire:](https://github.com/awslabs/lambda-refarch-iotbackend) - 用于创建物联网后端的参考架构.
* [lambda-refarch-mobilebackend :fire::fire::fire:](https://github.com/awslabs/lambda-refarch-mobilebackend) - 用于创建移动后端的参考架构.
* [lambda-refarch-webapp :fire::fire::fire::fire:](https://github.com/awslabs/lambda-refarch-webapp) - 用于创建 Web 应用程序的参考架构.

社区回购：

* [alestic/lambdash :fire::fire::fire:](https://github.com/alestic/lambdash) - Lambda shell - 在 Lambda 环境中运行 sh 命令.
* [Alephbet/gimel :fire::fire:](https://github.com/Alephbet/gimel) - 使用 Lambda 运行您自己的 A/B 测试后端.
* [apex/apex ](https://github.com/apex/apex) - 支持 Go 的最小 AWS Lambda 函数管理器.
* [claudiajs/claudia :fire::fire::fire::fire::fire:](https://github.com/claudiajs/claudia) - 轻松将 Node.js 项目部署到 Lambda 和 API 网关.
* [cloudnative/lambda-chat :fire::fire:](https://github.com/cloudnative/lambda-chat) - 没有服务器的聊天应用程序.
* [danilop/LambdAuth :fire::fire::fire::fire:](https://github.com/danilop/LambdAuth) - 样本认证服务.
* [eawsy/aws-lambda-go :fire::fire::fire:](https://github.com/eawsy/aws-lambda-go) - 一种在 Lambda 上执行 Go 的快速而干净的方法.
* [garnaat/kappa :fire::fire::fire:](https://github.com/garnaat/kappa) - Kappa 是一种 CLI 工具，可以更轻松地部署、更新和测试 AWS Lambda 的功能.
* [goadapp/goad :fire::fire::fire::fire:](https://github.com/goadapp/goad) - Lambda 驱动的、高度分布式的负载测试工具.
* [graphcool/chromeless :fire::fire::fire::fire::fire:](https://github.com/graphcool/chromeless) - 通过 Lambda 自动化 Chrome.
* [grycap/scar :fire::fire::fire:](https://github.com/grycap/scar) - 在 AWS Lambda 中透明地从 Docker 镜像执行容器.
* [jeremydaly/lambda-api :fire::fire::fire::fire:](https://github.com/jeremydaly/lambda-api) - 适用于无服务器应用程序的轻量级 Web 框架.
* [jimpick/lambda-comments :fire::fire::fire:](https://github.com/jimpick/lambda-comments) - 使用 Lambda 构建的博客评论系统.
* [jorgebastida/gordon :fire::fire::fire::fire::fire:](https://github.com/jorgebastida/gordon) - λ Gordon 是一种使用 CloudFormation 创建、连接和部署 AWS Lambdas 的工具.
* [ks888/LambStatus :fire::fire::fire::fire:](https://github.com/ks888/LambStatus) - 受 StatusPage.io 启发的状态页面系统，基于 AWS Lambda 构建.
* [kubek2k/lambdoku :fire::fire::fire:](https://github.com/kubek2k/lambdoku) - 使用 Lambda 时类似 Heroku 的体验.
* [lambci/lambci :fire::fire::fire::fire::fire:](https://github.com/lambci/lambci) - 基于 Lambda 构建的持续集成系统.
* [littlstar/s3-lambda :fire::fire::fire::fire:](https://github.com/littlstar/s3-lambda) - Lambda 在 S3 对象上运行并发控制（each、map、reduce、filter）.
* [mentum/lambdaws :fire::fire::fire::fire:](https://github.com/mentum/lambdaws) - 轻而易举地部署、运行并获得结果.
* [Miserlou/Zappa :fire::fire::fire::fire::fire:](https://github.com/Miserlou/Zappa) - 使用 AWS Lambda + API 网关的无服务器 WSGI Python Web 应用程序.
* [nficano/python-lambda :fire::fire::fire::fire:](https://github.com/nficano/python-lambda) - 用于在 Lambda 中开发和部署无服务器 Python 代码的工具包.
* [serverless/serverless :fire::fire::fire::fire::fire:](https://github.com/serverless/serverless) 无服务器应用程序框架（以前称为 JAWS）.
* [Tim-B/grunt-aws-lambda :fire::fire:](https://github.com/Tim-B/grunt-aws-lambda) - 咕噜插件.
* [trek10inc/aws-lambda-debugger :fire::fire:](https://github.com/trek10inc/aws-lambda-debugger) - 用于在 Node 6.10 上运行的 Lambda 函数的远程调试工具

### Machine Learning

AWS 回购协议：

* [machine-learning-samples :fire::fire::fire:](https://github.com/awslabs/machine-learning-samples) - 示例应用程序.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### Mobile Analytics

AWS 回购协议：

* [aws-sdk-mobile-analytics-js](https://github.com/aws/aws-sdk-mobile-analytics-js) - JavaScript 开发工具包.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### OpsWorks

AWS 回购协议：

* [opsworks-attribute-customization](https://github.com/awslabs/opsworks-attribute-customization) - 属性自定义示例.
* [opsworks-capistrano](https://github.com/awslabs/opsworks-capistrano) - 带实例的 Capistrano.
* [opsworks-cloudwatch-logs-cookbooks](https://github.com/awslabs/opsworks-cloudwatch-logs-cookbooks) - CloudWatch 示例食谱.
* [opsworks-cookbooks :fire::fire::fire::fire:](https://github.com/aws/opsworks-cookbooks) - 厨师食谱.
* [opsworks-demo-php-photo-share-app](https://github.com/awslabs/opsworks-demo-php-photo-share-app) - 简单的 PHP 照片共享应用程序.
* [opsworks-demo-php-simple-app](https://github.com/awslabs/opsworks-demo-php-simple-app) - 简单的 PHP 应用程序.
* [opsworks-demo-rails-photo-share-app](https://github.com/awslabs/opsworks-demo-rails-photo-share-app) - 示例 Rails 应用程序.
* [opsworks-elasticsearch-cookbook](https://github.com/awslabs/opsworks-elasticsearch-cookbook) - Elasticsearch 示例食谱.
* [opsworks-example-cookbooks :fire:](https://github.com/awslabs/opsworks-example-cookbooks) - 与示例应用程序一起使用的食谱.
* [opsworks-first-cookbook](https://github.com/awslabs/opsworks-first-cookbook) - 用于演示简单食谱的食谱.
* [opsworks-windows-demo-](https://github.com/awslabs/opsworks-windows-demo-nodejs) - 一个示例 Node.JS 应用程序.
* [opsworks-windows-demo-cookbooks](https://github.com/awslabs/opsworks-windows-demo-cookbooks) - Cookbooks for Windows.
* [todo-sample-app-cookbooks](https://github.com/awslabs/todo-sample-app-cookbooks) - 与 todo-sample-app 关联的自定义食谱.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### Redshift

AWS 回购协议：

* [aws-lambda-redshift-loader :fire::fire::fire:](https://github.com/awslabs/aws-lambda-redshift-loader) - Lambda 数据库加载器.
* [amazon-redshift-utils :fire::fire::fire::fire::fire:](https://github.com/awslabs/amazon-redshift-utils) - 将最佳列编码应用于现有表.

社区回购：

* [Lumoslabs/aleph](https://github.com/lumoslabs/aleph) - 用于编写和运行 Redshift 的全功能 Web 应用程序
查询. 支持查询的修订跟踪并具有基本的可视化支持.
* [getredash/redash :fire::fire::fire::fire::fire:](https://github.com/getredash/redash/)  - 允许轻松查询现有数据库、共享数据集并以不同方式可视化的 Web 应用程序. 最初是为与 Redshift 一起开发而开发的，并且对它有很好的支持.
* [everythingMe/redshift_console](https://github.com/EverythingMe/redshift_console)  - 一个用于监控和管理 Redshift 集群的简单工具. 第一个版本有基本的工具来监控运行中的查询、WLM 队列和您的表/模式.

### Route 53

AWS 回购协议：

* [route53-infima :fire::fire:](https://github.com/awslabs/route53-infima) - 管理服务级故障隔离.

社区回购：

* [barnybug/cli53 :fire::fire::fire::fire:](https://github.com/barnybug/cli53) - cli53 是 Amazon Route 53 的命令行工具，它提供 BIND 格式的导入和导出以及 Route 53 域的简单命令行管理.
* [winebarrel/roadworker :fire::fire:](https://github.com/winebarrel/roadworker)  - Roadworker 是管理 Route53 的工具. 它使用DSL定义Route53的状态，并根据DSL更新Route53.

### S3

社区回购：

* [anomalizer/ngx_aws_auth :fire::fire:](https://github.com/anomalizer/ngx_aws_auth) - 实现经过身份验证的请求的代理.
* [bloomreach/s4cmd :fire::fire::fire::fire:](https://github.com/bloomreach/s4cmd) - S3 命令行工具，对于大文件比 S3cmd 更快.
* [CulturalMe/meteor-slingshot :fire::fire::fire:](https://github.com/CulturalMe/meteor-slingshot) - 在流星中上传文件.
* [danilop/yas3fs :fire::fire::fire:](https://github.com/danilop/yas3fs) - 受 s3fs 启发的另一个 S3 支持的文件系统.
* [grippy/node-s3](https://github.com/grippy/node-s3) - 用于管理存储桶的 Node.js 应用程序.
* [jubos/fake-s3 :fire::fire::fire::fire::fire:](https://github.com/jubos/fake-s3) - 模拟大多数命令的轻量级 S3 克隆.
* [kahing/goofys :fire::fire::fire::fire::fire:](https://github.com/kahing/goofys) - 用 Go 编写的用于 Amazon S3 的 Filey 系统.
* [littlstar/s3renity :fire::fire::fire::fire:](https://github.com/littlstar/s3renity) - 具有并发控制的批处理函数（each、map、reduce、filter、join）
* [marcel/aws-s3 :fire::fire::fire:](https://github.com/marcel/aws-s3) - Amazon 的 S3 REST API 的 Ruby 实现.
* [mardix/flask-cloudy :fire::fire:](https://github.com/mardix/flask-cloudy) - 烧瓶扩展.
* [MathieuLoutre/grunt-aws-s3 :fire::fire:](https://github.com/MathieuLoutre/grunt-aws-s3) - 咕噜插件.
* [mickael-kerjean/filestash :fire::fire::fire::fire::fire:](https://github.com/mickael-kerjean/filestash) - S3 的现代 Web 客户端.
* [minio/mc :fire::fire::fire::fire::fire:](https://github.com/minio/mc) - 用于文件系统和云存储的 Minio 客户端.
* [minio/minio :fire::fire::fire::fire::fire:](https://github.com/minio/minio) - 与 S3 兼容的对象存储服务器.
* [mumrah/s3-multipart :fire:](https://github.com/mumrah/s3-multipart) - 通过 Python 并行上传/下载到 S3.
* [ncw/rclone :fire::fire::fire::fire::fire:](https://github.com/ncw/rclone) - 用于各种云存储提供商的 Rsync，例如 S3.
* [owocki/s3_disk_util :fire:](https://github.com/owocki/s3_disk_util) - S3 磁盘使用（您）实用程序.
* [peak/s5cmd :fire::fire::fire:](https://github.com/peak/s5cmd) - 具有通配符和批处理命令支持的快速 S3 和本地文件系统执行工具.
* [pgherveou/gulp-awspublish :fire::fire:](https://github.com/pgherveou/gulp-awspublish) - 吞咽插件.
* [rlmcpherson/s3gof3r :fire::fire::fire::fire:](https://github.com/rlmcpherson/s3gof3r) - 快速、并发、流式访问，包括 CLI.
* [s3git/s3git :fire::fire::fire::fire:](https://github.com/s3git/s3git) - CLI 工具，允许您创建分布式、去中心化和版本控制的存储库.
* [s3fs-fuse/s3fs-fuse :fire::fire::fire::fire::fire:](https://github.com/s3fs-fuse/s3fs-fuse) - 允许 Linux 和 Mac OS X 通过 FUSE 安装 S3 存储桶.
* [s3tools/s3cmd :fire::fire::fire::fire::fire:](https://github.com/s3tools/s3cmd) - 用于管理 S3 和 CloudFront 的 CLI.
* [schickling/git-s3 :fire::fire:](https://github.com/schickling/git-s3) - 将您的 git 存储库部署到存储桶.
* [sorentwo/carrierwave-aws :fire::fire:](https://github.com/sorentwo/carrierwave-aws) - CarrierWave 适配器.
* [spring-projects/aws-maven :fire::fire:](https://github.com/spring-projects/aws-maven) - S3 的 Maven Wagon.
* [tongwang/s3fs-c :fire:](https://github.com/tongwang/s3fs-c) - 安装桶以在本地文件系统上使用.
* [mishudark/s3-parallel-put :fire::fire:](https://github.com/mishudark/s3-parallel-put) - 支持并行上传的 CLI.
* [waynehoover/s3_direct_upload :fire::fire::fire:](https://github.com/waynehoover/s3_direct_upload) - 使用 CORS 直接上传到 Amazon S3
* [weavejester/clj-aws-s3 :fire:](https://github.com/weavejester/clj-aws-s3) - Clojure 的客户端库.

### SES

社区回购：

* [drewblas/aws-ses :fire::fire::fire:](https://github.com/drewblas/aws-ses) - 提供简单的 ruby​​ DSL 和接口.
* [microapps/MoonMail :fire::fire::fire::fire:](https://github.com/microapps/MoonMail) - 使用 SES 和 Lambda 发送数十亿封电子邮件.

### Simple Workflow

AWS 回购协议：

* [aws-flow-ruby :fire:](https://github.com/aws/aws-flow-ruby) - 创建后台作业和多步骤工作流程.
* [aws-flow-ruby-samples](https://github.com/awslabs/aws-flow-ruby-samples) - 适用于 Ruby 示例的 AWS Flow Framework.
* [aws-flow-ruby-opsworks-helloworld](https://github.com/awslabs/aws-flow-ruby-opsworks-helloworld) - 你好世界示例.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### SimpleDB

社区回购：

* [rjrodger/simpledb :fire:](https://github.com/rjrodger/simpledb) - Node.js 库.

### SNS

AWS 回购协议：

* [aws-php-sns-message-validator :fire:](https://github.com/aws/aws-php-sns-message-validator) - PHP 的消息验证.

社区回购：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### SQS

AWS 回购协议：

* [amazon-sqs-java-messaging-lib :fire:](https://github.com/awslabs/amazon-sqs-java-messaging-lib) - 持有 Java 消息服务以与 SQS 通信.

社区回购：

* [phstc/shoryuken :fire::fire::fire::fire:](https://github.com/phstc/shoryuken) - 一个超高效的基于 SQS 线程的 Ruby 消息处理器.

### Data

AWS 回购协议：

* [aws-data-wrangler :fire::fire::fire::fire::fire:](https://github.com/awslabs/aws-data-wrangler) - 连接 Pandas DataFrames 和 AWS 数据相关服务.

社区回购：

* [donnemartin/data-science-ipython-notebooks :fire::fire::fire::fire::fire:](https://github.com/donnemartin/data-science-ipython-notebooks) - 大数据/数据科学笔记本.
* [everpeace/vagrant-mesos :fire::fire:](https://github.com/everpeace/vagrant-mesos) - 使用 Vagrant 启动您的 Mesos 集群.
* [jhorey/ferry :fire::fire:](https://github.com/jhorey/ferry) - 使用 Docker 定义、运行和部署大数据应用程序.
* [nathanmarz/storm-deploy :fire::fire::fire:](https://github.com/nathanmarz/storm-deploy) - 一键部署 Storm 集群.

### DevOps

社区回购：

* [cloud-custodian/cloud-custodian :fire::fire::fire::fire::fire:](https://github.com/cloud-custodian/cloud-custodian) - 用于管理的规则引擎，yaml 中的 DSL，用于对资源进行查询、过滤和操作.
* [chef-cookbooks/aws :fire::fire:](https://github.com/chef-cookbooks/aws) - aws Chef 食谱的开发存储库.
* [colinbjohnson/aws-missing-tools :fire::fire::fire::fire:](https://github.com/colinbjohnson/aws-missing-tools) - 用于管理资源的工具，包括 EC2、EBS、RDS 和 Route53.
* [k1LoW/awspec :fire::fire::fire::fire:](https://github.com/k1LoW/awspec) - RSpec 测试您的资源.
* [mitchellh/vagrant-aws :fire::fire::fire::fire::fire:](https://github.com/mitchellh/vagrant-aws) - 使用 Vagrant 管理您的 EC2 和 VPC 实例.
* [NixOS/nixops :fire::fire::fire::fire:](https://github.com/NixOS/nixops) - 使用 NixOS 配置 EC2 实例、S3 存储桶和其他资源.

### Security

AWS 回购协议：

* [aws-sha256-agentcs](https://github.com/awslabs/aws-sha256-agentcs) - SHA256 代理兼容性扫描仪.
* [aws-tvm-anonymous](https://github.com/awslabs/aws-tvm-anonymous) - 用于匿名注册的令牌自动售货机.
* [aws-tvm-identity](https://github.com/awslabs/aws-tvm-identity) - 用于身份注册的令牌自动售货机.
* [s2n :fire::fire::fire::fire::fire:](https://github.com/awslabs/s2n) - TLS/SSL 协议的实现.

社区回购：

* [AdRoll/hologram :fire::fire::fire:](https://github.com/AdRoll/hologram) - 开发人员笔记本电脑上的简单、无痛的凭据.
* [alex/letsencrypt-aws :fire::fire::fire:](https://github.com/alex/letsencrypt-aws) - 自动提供和更新证书.
* [bridgecrewio/checkov :fire::fire::fire::fire::fire:](https://github.com/bridgecrewio/checkov) - Terraform 静态分析，验证安全最佳实践.
* [cloudsploit/scans :fire::fire::fire::fire:](https://github.com/cloudsploit/scans) - 检测安全风险.
* [iSECPartners/Scout2 :fire::fire::fire::fire:](https://github.com/iSECPartners/Scout2) - 安全审计工具.
* [jordanpotti/AWSBucketDump :fire::fire::fire::fire:](https://github.com/jordanpotti/AWSBucketDump) - 用于在 S3 存储桶中查找有趣文件的安全工具.
* [Netflix/bless :fire::fire::fire::fire::fire:](https://github.com/Netflix/bless) - 作为 Lambda 函数运行的 SSH 证书颁发机构.
* [Netflix/security_monkey :fire::fire::fire::fire::fire:](https://github.com/Netflix/security_monkey) - 监控策略更改和不安全配置警报.
* [RiotGames/cloud-inquisitor :fire::fire:](https://github.com/RiotGames/cloud-inquisitor) - 强制所有权和数据安全的工具.
* [salesforce/policy_sentry :fire::fire::fire::fire:](https://github.com/salesforce/policy_sentry/) - IAM 最小特权策略生成器.
* [sebsto/AWSVPN :fire:](https://github.com/sebsto/AWSVPN) - Start a private VPN server in the cloud.
* [trailofbits/algo :fire::fire::fire::fire::fire:](https://github.com/trailofbits/algo) - 在 EC2 和其他云服务上设置个人 IPSEC VPN.
* [ttlequals0/autovpn :fire::fire::fire::fire:](https://github.com/ttlequals0/autovpn) - 创建按需一次性 OpenVPN 端点.

### Accompanying Repos

AWS 回购协议：

*Repos 随附博客、培训活动和会议.*

* [aws-arch-backoff-simulator :fire:](https://github.com/awslabs/aws-arch-backoff-simulator) - AWS 架构博客的抖动和退避模拟器.
* [aws-big-data-blog :fire::fire::fire:](https://github.com/awslabs/aws-big-data-blog) - 来自 AWS 大数据博客的示例.
* [aws-demo-php-simple-app](https://github.com/awslabs/aws-demo-php-simple-app) - 来自 AWS 博客的 PHP 应用程序.
* [aws-mobile-sample-wif](https://github.com/awslabs/aws-mobile-sample-wif) - 来自 AWS Mobile SDK 博客的示例.
* [aws-mobile-self-paced-labs-samples](https://github.com/awslabs/aws-mobile-self-paced-labs-samples) - 来自自定进度实验室的 Android 贪吃蛇游戏.
* [aws-quickstart](https://github.com/aws-quickstart/) - AWS 快速入门的官方存储库.
* [aws-spot-labs :fire::fire::fire:](https://github.com/awslabs/aws-spot-labs) - 使用 AWS Spot 实例的最佳实践.
* [aws-training-demo :fire:](https://github.com/awslabs/aws-training-demo) - 来自技术培训师社区的演示.
* [java-meme-generator-sample](https://github.com/awslabs/java-meme-generator-sample) - 来自 re:Invent 2012 的模因生成应用程序.
* [railsconf2013-tech-demo :fire:](https://github.com/awslabs/railsconf2013-tech-demo) - 来自 RailsConf 2013 的 Seahorse 演示.
* [reinvent2013-js-blog-demo](https://github.com/awslabs/reinvent2013-js-blog-demo) - 来自 re:Invent 2013 的演示博客应用程序.
* [reinvent2013-mobile-photo-share](https://github.com/awslabs/reinvent2013-mobile-photo-share) - 来自 re:Invent 2014 的移动照片共享应用程序.
* [reinvent2014-scalable-site-management](https://github.com/awslabs/reinvent2014-scalable-site-management) - 来自 re:Invent 2014 的可扩展站点管理示例.
* [reinvent2015-dev309](https://github.com/awslabs/reinvent2015-dev309) - 来自 re:Invent 2015 的大规模指标分析.
* [timely-security-analytics](https://github.com/awslabs/timely-security-analytics) - 来自 2015 re:Invent 2015 的安全分析样本.
* [todo-sample-app](https://github.com/awslabs/todo-sample-app) - 来自 RailsConf 2014 的简单“Todo”应用程序.

社区回购：

* [startup-class/setup :fire::fire:](https://github.com/startup-class/setup) - Startup Engineering MOOC 的 EC2 安装文件.

### Miscellaneous Repos

AWS 回购协议：

* [amediamanager](https://github.com/awslabs/amediamanager) - 媒体经理.
* [aws-hal-client-java](https://github.com/awslabs/aws-hal-client-java) - 超文本应用程序语言的 Java 客户端.
* [aws-model-validators](https://github.com/awslabs/aws-model-validators) - 用于验证 AWS 服务 JSON 模型文件的工具.
* [aws-sdk-js-sample-video-transcoder](https://github.com/awslabs/aws-sdk-js-sample-video-transcoder) - 示例跨平台视频转码器应用程序.
* [simplebeerservice :fire::fire:](https://github.com/awslabs/simplebeerservice) - 将实时传感器数据流式传输到 AWS 的云连接 kegerator.

社区回购：

* [bcoe/thumbd :fire::fire:](https://github.com/bcoe/thumbd) - 基于 Node.js/ImageMagick 的图像缩略图服务.
* [cdkpatterns/serverless :fire::fire::fire::fire:](https://github.com/cdk-patterns/serverless) - 在 AWS CDK 中构建的可部署无服务器架构模式.
* [Comcast/cmb :fire::fire:](https://github.com/Comcast/cmb) - 高度可用、可水平扩展的排队和通知服务.
* [convox/rack :fire::fire::fire::fire:](https://github.com/convox/rack) - AWS 上的开源 PaaS.
* [devops-israel/aws-inventory :fire::fire:](https://github.com/devops-israel/aws-inventory) - 在单个网页上显示您的所有 AWS 资源.
* [donnemartin/dev-setup :fire::fire::fire::fire:](https://github.com/donnemartin/dev-setup) - 各种开发人员工具和 AWS 服务的 Mac 设置.
* [dtan4/terraforming :fire::fire::fire::fire::fire:](https://github.com/dtan4/terraforming) - 将现有资源导出为 Terraform 样式（tf、tfstate）.
* [segmentio/stack :fire::fire::fire::fire::fire:](https://github.com/segmentio/stack) - 一组用于配置生产基础设施的 Terraform 模块.
* [j2labs/microarmy ](https://github.com/j2labs/microarmy) - 部署微型实例以发起协调围攻.
* [jpillora/grunt-aws :fire:](https://github.com/jpillora/grunt-aws) - 进入 Node.JS SDK 的 Grunt 接口.
* [jvehent/haproxy-aws :fire::fire:](https://github.com/jvehent/haproxy-aws) - 有关使用 HAProxy 构建 HTTPS 堆栈的文档.
* [localstack/localstack :fire::fire::fire::fire::fire:](https://github.com/localstack/localstack)  - 功能齐全的本地 AWS 云堆栈. 离线开发和测试您的云应用程序！
* [meducation/propono :fire::fire:](https://github.com/meducation/propono) - 易于使用的 Ruby 发布/订阅.
* [mozilla/awsbox :fire::fire::fire:](https://github.com/mozilla/awsbox) - 用于部署节点应用程序的 EC2 之上的轻量级 PaaS.
* [Netflix/aminator :fire::fire::fire:](https://github.com/Netflix/aminator) - 用于创建 EBS AMI 的工具.
* [Netflix/archaius :fire::fire::fire::fire::fire:](https://github.com/Netflix/archaius) - 配置管理 API 库.
* [Netflix/asgard :fire::fire::fire::fire::fire:](https://github.com/Netflix/asgard) - 用于应用程序部署和云管理的 Web 界面.
* [Netflix/aws-autoscaling :fire::fire:](https://github.com/Netflix/aws-autoscaling) - 使用自动缩放和文档最佳实践的工具.
* [Netflix/chaosmonkey :fire::fire::fire::fire::fire:](https://github.com/Netflix/chaosmonkey) - 帮助应用程序容忍随机实例故障的弹性工具.
* [Netflix/eureka :fire::fire::fire::fire::fire:](https://github.com/Netflix/eureka) - 用于弹性中间层负载平衡和故障转移的服务注册表.
* [Netflix/EVCache :fire::fire::fire::fire:](https://github.com/Netflix/EVCache) - 分布式内存数据存储.
* [Netflix/Fenzo :fire::fire::fire:](https://github.com/Netflix/Fenzo) - Mesos 框架的可扩展调度程序.
* [Netflix/ice :fire::fire::fire::fire::fire:](https://github.com/Netflix/ice) - 使用和成本监控工具.
* [Netflix/ribbon :fire::fire::fire::fire::fire:](https://github.com/Netflix/ribbon) - 带有内置软件负载平衡器的远程过程调用库.
* [Netflix/SimianArmy :fire::fire::fire::fire::fire:](https://github.com/Netflix/SimianArmy) - 使您的云保持最佳状态的工具.
* [Netflix/zuul :fire::fire::fire::fire::fire:](https://github.com/Netflix/zuul) - 提供动态路由、监控、弹性、安全性等的边缘服务.
* [niftylettuce/gulp-aws-splash :fire::fire:](https://github.com/niftylettuce/gulp-aws-splash)  - 开源 LaunchRock 替代品. 构建漂亮的初始页面.
* [puppetlabs/puppetlabs-aws :fire:](https://github.com/puppetlabs/puppetlabs-aws) - 用于管理资源以构建基础设施的 Puppet 模块.
* [mhart/react-server-routing-example :fire::fire:](https://github.com/mhart/react-server-routing-example) - React 中的通用客户端/服务器路由和数据示例.
* [Similarweb/finala :fire::fire::fire:](https://github.com/similarweb/finala) - 资源云扫描仪，分析和报告浪费和未使用的资源以减少不必要的开支.
* [snowplow/snowplow :fire::fire::fire::fire::fire:](https://github.com/snowplow/snowplow) - 企业级网络、移动和事件分析，由 Hadoop、Kafka、Kinesis、Redshift 和 Elasticsearch 提供支持.
* [Spinnaker/spinnaker :fire::fire::fire::fire::fire:](https://github.com/Spinnaker/spinnaker) - asgard 支持管道等的继任者.
* [spulec/moto :fire::fire::fire::fire::fire:](https://github.com/spulec/moto) - 允许您的 python 测试轻松模拟 boto 库.

## Guides, Books, Documentation, and Training

*操作方法、培训、白皮书、文档和案例研究.*

<br/>
<p align="center">
  <img src="http://i.imgur.com/LxYDN5K.png">
</p>
<br/>

### Getting Started Guides

AWS 指南：

* [Getting Started with AWS](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-intro.html)
* [Getting Started Tutorials](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html)
    * [Run a Virtual Server](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html#d0e2614)
    * [Store Files](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html#d0e2683)
    * [Share Digital Media](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html#d0e2755)
    * [Deploy a Website](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html#d0e2767)
    * [Host a Website (Linux)](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html#d0e2836)
    * [Host a Website (Windows)](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html#d0e2908)
    * [Run a Database](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html#d0e2980)
    * [Analyze Your Data](http://docs.aws.amazon.com/gettingstarted/latest/awsgsg-intro/gsg-aws-tutorials.html#d0e3065)

社区指南：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### General Guides

AWS 指南：

* [Analyzing Big Data](https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-gs.html)
* [Working with the AWS Management Console](http://docs.aws.amazon.com/awsconsolehelpdocs/latest/gsg/getting-started.html)
* [Deploying a Web App Using Elastic Beanstalk](http://docs.aws.amazon.com/gettingstarted/latest/deploy/overview.html)
* [Hosting a Web App](http://docs.aws.amazon.com/gettingstarted/latest/wah-linux/web-app-hosting-intro.html)
* [Hosting a .NET Web App](http://docs.aws.amazon.com/gettingstarted/latest/wah/web-app-hosting-intro.html)
* [Hosting a Static Website](http://docs.aws.amazon.com/gettingstarted/latest/swh/website-hosting-intro.html)
* [Quick Start Deployment Guides](https://aws.amazon.com/documentation/quickstart/)

社区指南：

* [Open Guide to AWS :fire::fire::fire::fire::fire:](https://github.com/open-guides/og-aws)

### Books

* 亚马逊网络服务实战 [Manning](https://www.manning.com/books/amazon-web-services-in-action) 或者 [Amazon.com](http://amzn.com/1617292885)
* AWS Lambda 实战 [Manning](https://www.manning.com/books/aws-lambda-in-action) 或者 [Amazon.com](http://amzn.com/1617293717) - [Code Repo :fire::fire:](https://github.com/danilop/AWS_Lambda_in_Action)

### Whitepapers

* [AWS Well-Architected Framework](https://d0.awsstatic.com/whitepapers/architecture/AWS_Well-Architected_Framework.pdf)
* [Whitepapers](https://aws.amazon.com/whitepapers/)

### Documentation

* [Documentation](https://aws.amazon.com/documentation/)
* [AWS Billing and Cost Management](https://aws.amazon.com/documentation/account-billing/)
* [AWS Marketplace](https://aws.amazon.com/documentation/marketplace/)
* [AWS Support](https://aws.amazon.com/documentation/aws-support/)
* [AWS General Reference](http://docs.aws.amazon.com/general/latest/gr/)
* [AWS Glossary](http://docs.aws.amazon.com/general/latest/gr/glos-chap.html)

### Training

* [Training and Certification](https://aws.amazon.com/training/)
* [Webinars](https://aws.amazon.com/about-aws/events/)

### Case Studies: Powered by AWS

* [Adobe](https://aws.amazon.com/solutions/case-studies/adobe/)
* [AdRoll](https://aws.amazon.com/solutions/case-studies/adroll/)
* [Airbnb](https://aws.amazon.com/solutions/case-studies/airbnb/)
* [Autodesk](https://aws.amazon.com/solutions/case-studies/autodesk/)
* [Citrix](https://aws.amazon.com/solutions/case-studies/citrix/)
* [Comcast](https://aws.amazon.com/solutions/case-studies/comcast/)
* [Coursera](https://aws.amazon.com/solutions/case-studies/coursera/)
* [Docker](https://aws.amazon.com/solutions/case-studies/docker/)
* [Dow Jones](https://aws.amazon.com/solutions/case-studies/dow-jones/)
* [Dropbox](https://www.dropbox.com/)
* [Dropcam](https://aws.amazon.com/solutions/case-studies/dropcam/)
* [Expedia](https://aws.amazon.com/solutions/case-studies/expedia/)
* [Foursquare](https://aws.amazon.com/solutions/case-studies/foursquare/)
* [IMDb](https://aws.amazon.com/solutions/case-studies/imdb/)
* [Instrumental](https://instrumentalapp.com/blog/aws-kinesis/)
* [Intuit](https://aws.amazon.com/solutions/case-studies/soasta-intuit/)
* [Johnson & Johnson](https://aws.amazon.com/solutions/case-studies/johnson-and-johnson/)
* [Lionsgate](https://aws.amazon.com/solutions/case-studies/lionsgate/)
* [mlbam](https://aws.amazon.com/solutions/case-studies/major-league-baseball-mlbam/)
* [NASA](https://aws.amazon.com/solutions/case-studies/nasa-jpl-curiosity/)
* [Netflix](https://aws.amazon.com/solutions/case-studies/netflix/)
* [Nike](https://web.archive.org/web/20150910200649/http://aws.amazon.com/solutions/case-studies/nike/)
* [Nokia](https://web.archive.org/web/20161210062336/https://aws.amazon.com/solutions/case-studies/nokia/)
* [PBS](https://aws.amazon.com/solutions/case-studies/pbs/)
* [Pfizer](https://web.archive.org/web/20161210034734/https://aws.amazon.com/solutions/case-studies/pfizer/)
* [Philips](https://aws.amazon.com/solutions/case-studies/philips/)
* [Reddit](https://web.archive.org/web/20150905070945/https://aws.amazon.com/solutions/case-studies/reddit/)
* [Samsung](https://aws.amazon.com/solutions/case-studies/samsung/)
* [Siemens](https://aws.amazon.com/solutions/case-studies/siemens/)
* [Slack](https://aws.amazon.com/solutions/case-studies/slack/)
* [Spotify](https://web.archive.org/web/20180608043124/https://aws.amazon.com/solutions/case-studies/spotify/)
* [Swiftkey](https://web.archive.org/web/20160410051253/https://aws.amazon.com/solutions/case-studies/swiftkey/)
* [The Weather Company](https://aws.amazon.com/solutions/case-studies/the-weather-company/)
* [Ticketmaster](https://aws.amazon.com/solutions/case-studies/ticketmaster/)
* [Time Inc](https://aws.amazon.com/solutions/case-studies/time-inc/)
* [Twilio](https://aws.amazon.com/solutions/case-studies/twilio/)
* [U.S. Department of State](https://aws.amazon.com/solutions/case-studies/exchangesconnect/)
* [Ubisoft](https://aws.amazon.com/solutions/case-studies/ubisoft/)
* [Yelp](https://aws.amazon.com/solutions/case-studies/yelp-docker/)
* [Zillow](https://aws.amazon.com/solutions/case-studies/zillow/)

## Social

*Blogs, discussion groups, conferences, and social media.*

<br/>
<p align="center">
  <img src="http://i.imgur.com/kRRBa1e.png">
</p>
<br/>

### Blogs

AWS 博客：

* [Official Blog](https://aws.amazon.com/blogs/aws/)
    * [Brasil](https://aws.amazon.com/pt/blogs/aws-brasil/)
    * [China](https://aws.amazon.com/cn/blogs/china/)
    * [Germany](https://aws.amazon.com/de/blogs/germany/)
    * [Japan](https://aws.amazon.com/jp/blogs/news/)
    * [Korea](http://aws.amazon.com/ko/blogs/korea/)
* [DevOps](https://aws.amazon.com/blogs/devops/)
* [Architecture](https://aws.amazon.com/blogs/architecture/)
* [Big Data](https://aws.amazon.com/blogs/big-data/)
* [Compute](https://aws.amazon.com/blogs/compute/)
* [Mobile](https://aws.amazon.com/blogs/mobile/)
* [Messaging](https://aws.amazon.com/blogs/messaging-and-targeting/)
* [Java](https://aws.amazon.com/blogs/developer/category/programing-language/java/)
* [PHP](https://aws.amazon.com/blogs/developer/category/programing-language/php/)
* [Ruby](https://aws.amazon.com/blogs/developer/category/programing-language/ruby/)
* [.NET](https://aws.amazon.com/blogs/developer/category/programing-language/dot-net/)
* [Security](https://aws.amazon.com/blogs/security/)
* [Startup](https://medium.com/aws-activate-startup-blog)
* [Partner Network](https://aws.amazon.com/blogs/apn/)
* [SAP](https://aws.amazon.com/blogs/awsforsap/)

社区博客：

* [All Things Distributed](http://www.allthingsdistributed.com/) - AWS 首席技术官 Werner Vogels.
* [Things I Like...](http://jeff-barr.com/) - AWS 首席宣传官 Jeff Barr.
* [Netflix Tech Blog](http://techblog.netflix.com/)
* [A Curated List of Engineering Blogs](https://github.com/kilimchoi/engineering-blogs)
* [AWS Geek](https://www.awsgeek.com/)

### Twitter Influencers

AWS 鸣叫：

* [@awscloud](https://twitter.com/awscloud) - 官方推特提要.
* [@AWS_Partners](https://twitter.com/AWS_Partners)
* [@AWSIdentity](https://twitter.com/AWSIdentity)
* [@AWSMarketplace](https://twitter.com/AWSMarketplace)
* [@AWSreInvent](https://twitter.com/AWSreInvent) - re:Invent 的官方 Twitter 帐户.
* [@AWSStartups](https://twitter.com/AWSStartups)
* [@ajassy](https://twitter.com/ajassy) - Andy Jassy：高级副总裁.
* [@Ianmmmm](https://twitter.com/Ianmmmm) - Ian Massingham - 技术传播者.
* [@jeffbarr](https://twitter.com/jeffbarr) - 杰夫巴尔：首席布道者.
* [@mndoci](https://twitter.com/mndoci) - 迪帕克辛格：GM EC2.
* [@mza](https://twitter.com/mza) - 马特伍德：产品战略.
* [@Werner](https://twitter.com/Werner) - Werner Vogels：首席技术官.
* [Community heroes, Evangelists, etc](https://twitter.com/awscloud/lists)

社区推文：

* [@kennwhite](https://twitter.com/kennwhite)
* [@esh](https://twitter.com/esh)
* [@garnaat](https://twitter.com/garnaat)
* [@quinnypig](https://twitter.com/quinnypig)
* [@awsgeek](https://twitter.com/awsgeek)

### Facebook Pages

AWS 页面：

* [amazonwebservices](https://www.facebook.com/amazonwebservices) - 官方 Facebook 页面.
* [awsreinvent](https://www.facebook.com/awsreinvent) - re:Invent 的官方 Facebook 页面.

社区页面：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

### YouTube Channels

AWS 渠道：

* [AmazonWebServices](https://www.youtube.com/user/AmazonWebServices)
* [AWSDeutsch](https://www.youtube.com/user/AWSAktuell)
* [AWSJapan](https://www.youtube.com/user/AmazonWebServicesJP)
* [AWSKorea](https://www.youtube.com/user/AWSKorea)
* [AWSLatinAmerica](https://www.youtube.com/channel/UCvaUAVzIIGsRNlUDWkQFCeA)
* [AWSTutorialSeries](https://www.youtube.com/user/awstutorialseries)
* [AWSWebinars](https://www.youtube.com/user/AWSwebinars)

社区渠道：

* [Backspace Academy](https://www.youtube.com/channel/UCav3fsasRc5VOqvZiT5avgw)
* [Cloud Academy](https://www.youtube.com/channel/UCeRY0LppLWdxWAymRANTb0g/videos)
* [Linux Academy](https://www.youtube.com/user/pineheadtv/playlists)

### LinkedIn Groups

AWS 页面：

* [Amazon Web Services](https://www.linkedin.com/company/amazon-web-services)

社区团体：

* [Amazon AWS Architects](https://www.linkedin.com/grp/home?gid=4387417)
* [Amazon AWS Architects, Engineers, Developers, Consultants, Entrepreneurs Experts](https://www.linkedin.com/grps?gid=3748455)
* [Amazon Web Services (AWS) for Business](https://www.linkedin.com/grps?gid=5122002)
* [Amazon Web Services Architects](https://www.linkedin.com/grps?gid=4233997)
* [Amazon Web Services Community Network](https://www.linkedin.com/grp/home?gid=49531)
* [Amazon Web Services Enthusiasts](https://www.linkedin.com/grps?gid=2485626)
* [Amazon Web Services Users](https://www.linkedin.com/grps?gid=86137)

### Subreddits

* [/r/aws/](https://www.reddit.com/r/aws/)
* [/r/AWS_cloud/](https://www.reddit.com/r/AWS_cloud/)

### Conferences

AWS 会议：

* [re:Invent](https://reinvent.awsevents.com/)  - 年度用户大会. 该活动包括主题演讲、培训和认证机会、超过 250 场技术会议、合作伙伴博览会、下班后活动等.
* [AWSome Day](https://aws.amazon.com/events/awsome-day/awsome-day-online/) - 全球一日活动由 AWS 教育的技术讲师提供，非常适合想要了解如何开始使用 AWS 云的 IT 专业人员、开发人员和技术经理.

社区会议：

* [Contribute](https://github.com/donnemartin/awesome-aws/blob/master/CONTRIBUTING.md)

## Latest KPIs and Stats

*最新的关键绩效指标和其他有趣的统计数据.*

<br/>
<p align="center">
  <img src="http://i.imgur.com/KP2TmJv.png">
</p>
<br/>

* 超过 100 万客户在过去 30 天内活跃.[1](https://www.youtube.com/watch?v=D5-ifl7KJ00)</sup>
* $7B+ 年收入运行率业务.[1](https://www.youtube.com/watch?v=D5-ifl7KJ00)</sup>
    * 收入同比增长 81%.[1](https://www.youtube.com/watch?v=D5-ifl7KJ00)</sup>
* EC2 使用率同比增长 95%.[1](https://www.youtube.com/watch?v=D5-ifl7KJ00)</sup>
* S3 数据传输同比增长 120%.[1](https://www.youtube.com/watch?v=D5-ifl7KJ00)</sup>
    * S3 拥有数万亿个对象，并定期达到每秒 150 万个请求的峰值.[2](http://highscalability.com/blog/2015/1/12/the-stunning-scale-of-aws-and-what-it-means-for-the-future-o.html)</sup>
* 数据库服务使用率同比增长 127%.[1](https://www.youtube.com/watch?v=D5-ifl7KJ00)</sup>
    * 10 亿美元的年收入运行率业务.[1](https://www.youtube.com/watch?v=D5-ifl7KJ00)</sup>
* 每天创建 200 万个新 EBS 卷.[4](https://www.youtube.com/watch?v=OuyUbvtgfDk)</sup>
* 客户已经启动了超过 1500 万个 Hadoop 集群.[3](http://www.forbes.com/sites/benkepes/2014/11/25/scale-beyond-comprehension-some-aws-numbers/)</sup>
* 102Tbps 网络容量进入一个数据中心.[2](http://highscalability.com/blog/2015/1/12/the-stunning-scale-of-aws-and-what-it-means-for-the-future-o.html)</sup>
* 2014 年以来推出的 500 多项主要新功能和服务.[1](https://www.youtube.com/watch?v=D5-ifl7KJ00)</sup>
* 所有 14 家其他云提供商的总容量是 AWS 总容量的 1/5.[2](http://highscalability.com/blog/2015/1/12/the-stunning-scale-of-aws-and-what-it-means-for-the-future-o.html)</sup>
* 每天，AWS 都会增加足够的新服务器容量来支持亚马逊的所有全球基础设施，当时它是一家年收入为 70 亿美元的企业（2004 年）.[2](http://highscalability.com/blog/2015/1/12/the-stunning-scale-of-aws-and-what-it-means-for-the-future-o.html)</sup>

## Appendix of Core Services

*官方服务附录，按服务类别分组.*

### Services in Plain English

* [Amazon Web Services in Plain English](https://www.expeditedssl.com/aws-in-plain-english) - 娱乐和教育，社区贡献.

### Compute Services

* [Auto Scaling](https://aws.amazon.com/autoscaling/) - 根据政策、计划和健康检查启动或终止 EC2 实例.
* [Batch](https://aws.amazon.com/batch/) - 大规模运行批处理作业.
* [Blox](https://blox.github.io/) - 用于在 ECS 上构建自定义调度程序的开源项目.
* [EC2 Container Service (ECS)](https://aws.amazon.com/ecs/) - 支持 EC2 实例上的 Docker 容器.
* [EC2 Systems Manager](https://aws.amazon.com/ec2/systems-manager/) - 轻松配置和管理 EC2 和本地系统.
* [Elastic Beanstalk](https://aws.amazon.com/elasticbeanstalk/) - 提供云中应用程序的快速部署和管理.
* [Elastic Compute Cloud (EC2)](http://aws.amazon.com/ec2/) - 使用 Xen 提供可扩展的虚拟专用服务器.
* [Elastic GPUs](https://aws.amazon.com/ec2/Elastic-GPUs/) - 将低成本 GPU 附加到 EC2 实例以实现图形加速.
* [Elastic Load Balancing (ELB)](https://aws.amazon.com/elasticloadbalancing/) - 跨多个 EC2 实例自动分配传入流量.
* [Lambda](https://aws.amazon.com/lambda/) - 运行代码以响应事件并自动管理 EC2 实例.
* [Lightsail](https://amazonlightsail.com/) - 启动和管理简单的虚拟专用服务器.
* [Virtual Private Cloud (VPC)](https://aws.amazon.com/vpc/) - 创建一组逻辑隔离的 EC2 实例，可以使用 VPN 连接将其连接到现有网络.

### Networking Services

* [Direct Connect](https://aws.amazon.com/directconnect/) - 提供与 AWS 的专用连接，以实现更快、更便宜的数据吞吐量.
* [Elastic Load Balancing (ELB)](https://aws.amazon.com/elasticloadbalancing/) - 跨多个 EC2 实例自动分配传入流量.
* [Route 53](https://aws.amazon.com/route53/) - 提供高度可用和可扩展的域名系统 (DNS) Web 服务.
* [Virtual Private Cloud (VPC)](https://aws.amazon.com/vpc/) - 创建一组逻辑隔离的 EC2 实例，可以使用 VPN 连接将其连接到现有网络.

### Enterprise Applications

* [WorkDocs](https://aws.amazon.com/workdocs/) - 提供完全托管、安全的企业存储和共享服务.
* [WorkMail](https://aws.amazon.com/workmail/) - 提供托管电子邮件和日历服务.
* [WorkSpaces](https://aws.amazon.com/workspaces/) - 为最终用户提供基于云的桌面体验.
* [Workspaces Application Manager (WAM)](http://aws.amazon.com/workspaces/applicationmanager/) - 简化 WorkSpaces 的部署和管理.

### Analytics Services

* [Athena](https://aws.amazon.com/athena/) - 立即查询 S3 上的数据.
* [Data Pipeline](https://aws.amazon.com/datapipeline/) - 通过在服务之间处理和移动数据来提供工作负载管理.
* [Elastic MapReduce (EMR)](http://aws.amazon.com/elasticmapreduce/) - 托管在 EC2 和 S3 上运行的 Hadoop 和 Spark 框架.
* [Elasticsearch Service (ES)](https://aws.amazon.com/elasticsearch-service/) - 托管 Elasticsearch，一种流行的开源搜索和分析引擎.
* [Glue](https://aws.amazon.com/glue/) - 准备数据并将其加载到数据存储中.
* [Kinesis](https://aws.amazon.com/kinesis/) - 提供对大型分布式数据流的实时数据处理.
* [Kinesis Analytics](https://aws.amazon.com/kinesis/analytics/) - 编写关于流数据的标准 SQL 查询，无需学习任何新的编程技能.
* [Kinesis Firehose](https://aws.amazon.com/kinesis/firehose/) - 捕获流数据并将其自动加载到 S3 和 Redshift 中.
* [Quicksight](https://aws.amazon.com/quicksight/) - 以传统 BI 解决方案成本的 1/10 提供基于云的商业智能.
* [Redshift](https://aws.amazon.com/redshift/) - 提供具有列存储和多节点计算的 PB 级数据仓库.

### Artificial Intelligence

* [Lex](https://aws.amazon.com/lex/) - 通过语音或文本构建对话界面.
* [Machine Learning](https://aws.amazon.com/machine-learning/) - 提供托管机器学习技术.
* [Polly](https://aws.amazon.com/polly/) - 将文字变成逼真的语音.
* [Rekognition](https://aws.amazon.com/rekognition/) - 基于深度学习的图像分析.

### Management Tools

* [CloudFormation](https://aws.amazon.com/cloudformation/) - 提供一个基于文件的接口来配置其他资源.
* [CloudTrail](https://aws.amazon.com/cloudtrail/) - 提供所有活动的日志.
* [CloudWatch](https://aws.amazon.com/cloudwatch/) - 提供对 AWS 云资源和应用程序的监控，从 EC2 开始.
* [Command Line Interface (CLI)](https://aws.amazon.com/cli/) - 提供 CLI 来管理所有服务.
* [Config](https://aws.amazon.com/config/) - 提供所有资源的详细视图.
* [Management Console (AWS Console)](https://aws.amazon.com/console/) - 基于网络的界面来管理所有服务.
* [OpsWorks](https://aws.amazon.com/opsworks/) - 使用 Chef 提供 EC2 服务的配置.
* [Personal Health Dashboard](https://aws.amazon.com/premiumsupport/phd/) - 您对服务健康状况的个性化看法.
* [Service Catalog](https://aws.amazon.com/servicecatalog/) - 服务目录允许 IT 管理员创建、管理和分发已批准产品的组合给最终用户，然后他们可以在个性化门户中访问他们需要的产品.

### Security and Identity Services

* [Certificate Manager](https://aws.amazon.com/certificate-manager/) - 让您轻松预置、管理和部署 SSL/TLS 证书以用于 AWS 服务.
* [CloudHSM](https://aws.amazon.com/cloudhsm/) - 通过在 AWS 云中使用专用的硬件安全模块 (HSM) 设备，帮助满足企业、合同和法规对数据安全的合规性要求.
* [Directory Service](https://aws.amazon.com/directoryservice/) - 一种托管服务，允许您将资源与现有的本地 Microsoft Active Directory 连接或在 AWS 云中设置新的独立目录.
* [Identity and Access Management (IAM)](https://aws.amazon.com/iam/) - 隐式服务，用于验证对各种服务的访问的身份验证基础结构.
* [Inspector](https://aws.amazon.com/inspector/) - 一项自动化安全评估服务，有助于提高部署在 AWS 上的应用程序的安全性和合规性.
* [Key Management Service (KMS)](https://aws.amazon.com/kms/) - 一项托管服务，可让您轻松创建和控制用于加密数据的加密密钥.
* [Shield](https://aws.amazon.com/shield/) - 托管 DDoS 保护.
* [WAF](https://aws.amazon.com/waf/) - 监控和管理 CloudFront 分发的 Web 应用程序防火墙服务.

### Internet of Things Service

* [IoT](https://aws.amazon.com/iot/) - 通过 MQTT 和 HTTP 实现联网物件（例如传感器、执行器、嵌入式设备或智能设备）与 AWS 云之间的安全双向通信.

### Mobile Services

* [API Gateway](https://aws.amazon.com/api-gateway/) - 用于发布、维护和保护 Web 服务 API 的服务.
* [Cognito](https://aws.amazon.com/cognito/) - 提供用户身份和数据同步.
* [Device Farm](https://aws.amazon.com/device-farm/) - 适用于物理设备上的 iOS、Android 和 Fire OS 应用程序的应用程序测试服务.
* [Mobile Analytics](https://aws.amazon.com/mobileanalytics/) - 用于收集、可视化和理解应用程序使用数据的服务.
* [Mobile Hub](https://aws.amazon.com/mobile/) - 提供一个集成控制台，帮助您构建、测试和监控您的移动应用程序.
* [Pinpoint](https://aws.amazon.com/pinpoint/) - 针对移动应用程序的有针对性的推送通知.
* [Simple Notification Service (SNS)](https://aws.amazon.com/sns/) - 为应用程序提供托管的多协议“推送”消息传递.


* [Elastic Block Store (EBS)](https://aws.amazon.com/ebs/) - 为 EC2 提供持久的块级存储卷.
* [Elastic File System (EFS)](https://aws.amazon.com/efs/) - EC2 实例的文件存储服务.
* [Glacier](https://aws.amazon.com/glacier/) - 提供低成本、长期存储选项，用于归档数据.
* [Import/Export](https://aws.amazon.com/importexport/) - 使用便携式存储设备进行传输，加速将大量数据移入和移出 AWS.
* [Simple Storage Service (S3)](https://aws.amazon.com/s3/) - 提供基于网络服务的存储.
* [Storage Gateway](https://aws.amazon.com/storagegateway/) - 具有基于云的备份的 iSCSI 块存储虚拟设备.

### Databases

* [Aurora](https://aws.amazon.com/rds/aurora/) - 具有改进性能的 MySQL 和 PostgreSQL 兼容关系数据库.
* [DynamoDB](https://aws.amazon.com/dynamodb/) - 提供由 SSD 支持的可扩展、低延迟的 NoSQL 在线数据库服务.
* [ElastiCache](https://aws.amazon.com/elasticache/) - 为网络应用程序（Memcached、Redis）提供内存缓存.
* [Redshift](https://aws.amazon.com/redshift/) - 提供具有列存储和多节点计算的 PB 级数据仓库.
* [Relational Database Service (RDS)](https://aws.amazon.com/rds/) - 提供可扩展的数据库服务器，支持 MySQL、Oracle、SQL Server、PostgreSQL 和 MariaDB.
* [Schema Conversion Tool](https://aws.amazon.com/documentation/SchemaConversionTool/) - 可帮助您将数据库架构从 Oracle 或 Microsoft SQL Server 数据库转换为 RDS MySQL 数据库实例或 Aurora 数据库集群的应用程序.
* [SimpleDB](https://aws.amazon.com/simpledb/) - 允许开发人员对结构化数据运行查询.

### Application Services

* [API Gateway](https://aws.amazon.com/api-gateway/) - 用于发布、维护和保护 Web 服务 API 的服务.
* [AppStream](https://aws.amazon.com/appstream/) - 适用于应用程序和游戏的灵活、低延迟的流媒体服务.
* [DevPay](https://aws.amazon.com/devpay/) - 提供计费和账户管理.
* [Elastic Transcoder (ETS)](https://aws.amazon.com/elastictranscoder/) - 提供 S3 托管视频的视频转码.
* [Flexible Payments Service (FPS)](https://payments.amazon.com/developer) - 提供小额支付接口.
* [Simple Email Service (SES)](https://aws.amazon.com/ses/) - 提供批量和交易电子邮件发送.
* [Simple Notification Service (SNS)](https://aws.amazon.com/sns/) - 为应用程序提供托管的多协议“推送”消息传递.
* [Simple Queue Service (SQS)](https://aws.amazon.com/sqs/) - 为 Web 应用程序提供托管消息队列.
* [Simple Workflow (SWF)](https://aws.amazon.com/swf/) - 用于构建可扩展、有弹性的应用程序的工作流服务.
* [Step Functions](https://aws.amazon.com/step-functions/) - 协调分布式应用程序的组件.

### Developer Tools

* [CodeBuild](https://aws.amazon.com/codebuild/) - 构建和测试代码.
* [CodeCommit](https://aws.amazon.com/documentation/codecommit/) - 托管 Git 版本控制服务.
* [CodeDeploy](https://aws.amazon.com/codedeploy/) - 为 EC2 实例提供自动代码部署.
* [CodePipeline](https://aws.amazon.com/documentation/codepipeline/) - 持续交付服务.
* [Command Line Interface (CLI)](https://aws.amazon.com/cli/) - 提供 CLI 来管理所有服务.
* [X-Ray](https://aws.amazon.com/xray/) - 分析和调试您的应用程序.

### Miscellaneous Services

* [Fulfillment Web Service](https://aws.amazon.com/about-aws/whats-new/2008/03/19/announcing-amazon-fulfillment-web-service/) - 为卖家提供程序化网络服务，以使用亚马逊物流将商品运送至亚马逊或从亚马逊发货.
* [Mechanical Turk](https://www.mturk.com/mturk/welcome) - 管理分配给许多人的小工作单元.
* [Partner Network (APN)](https://aws.amazon.com/partners/) - 为合作伙伴提供技术信息以及销售和营销支持，以增加商机.
* [Product Advertising API](http://docs.aws.amazon.com/AWSECommerceService/latest/GSG/Welcome.html) - 提供对产品数据和电子商务功能的访问.

## Credits

查看 [Credits page](https://github.com/donnemartin/awesome-aws/blob/master/CREDITS.md).

## Other Awesome Lists

其他很棒的列表可以在 [awesome](https://github.com/sindresorhus/awesome) 和 [awesome-awesomeness](https://github.com/bay和in/awesome-awesomeness).

## Contact Info

如有任何问题、疑问或意见，请随时与我联系.

我的联系信息可以在我的网站上找到 [GitHub page](https://github.com/donnemartin).

## License

 *我在开源许可下向您提供此存储库中的代码和资源. 因为这是我的个人存储库，所以您收到的对我的代码和资源的许可来自我，而不是我的雇主 (Facebook).*

    版权所有 2017 唐恩·马丁

    知识共享署名 4.0 国际许可 (CC BY 4.0)

    http://creativecommons.org/licenses/by/4.0/
