<div class="github-widget" data-repo="aurelia-contrib/awesome-aurelia"></div>
<p align="center">
  <a href="https://github.com/behzad888/awesome" target="_blank">
    <img src="https://raw.githubusercontent.com/aurelia-contrib/awesome-aurelia/master/media/aurelia-awesome.png" alt="Awesome Aurelia" />
  </a>
</p>


Aurelia 库、资源和闪亮事物的精选列表.

## Current Aurelia version

[![npm Version](https://img.shields.io/npm/v/aurelia-framework.svg)](https://www.npmjs.com/package/aurelia-framework)


* [Aurelia](#aurelia)
  * [Official Resources](#official-resources)
  * [Community](#community)
  * [Experts on personal blogs](#experts-on-personal-blogs)
  * [Aurelia Tools](#aurelia-tools)
  * [Seed Project](#seed-project)
  * [Aurelia Generators](#aurelia-generators)
  * [Aurelia Cheatsheet](#aurelia-cheatsheet)
  * [Aurelia Tutorials](#aurelia-tutorials)
    * [Aurelia Podcasts](#aurelia-podcasts)
    * [Aurelia Videos](#aurelia-videos)
    * [Aurelia Books](#aurelia-books)
    * [Aurelia Articles](#aurelia-articles)
  * [Material Design](#material-design)
  * [Aurelia Plugins](#aurelia-plugins)
  * [Aurelia Implementation](#aurelia-implementation)
  * [Aurelia Custom Element](#aurelia-custom-element)
  * [Aurelia Auth](#aurelia-auth)
  * [Aurelia Libraries](#aurelia-libraries)
  * [Aurelia Examples](#aurelia-examples)
* [TypeScript](#typescript)
  * [TypeScript General Resources](#typeScript-general-resources)
  * [Seed Projects](#typescript-seed-projects)
  * [Examples](#examples)
* [Aurelia in ES5](#es5)
  * [Seed Projects](#es5-seed-projects)
  * [Examples](#es5-examples)
* [Aurelia and Meteor](#meteor)
  * [Seed Projects](#meteor-seed-projects)
* [Contributing](#contributing-guideline)

### Aurelia

&gt; Aurelia 是用于移动、桌面和 Web 的下一代 JavaScript 客户端框架，它利用简单的约定来增强您的创造力.

#### Official Resources

* [Official Site](http://aurelia.io)
* [Official Blog](http://blog.aurelia.io/)
* [Official Documentation](http://aurelia.io/docs.html)
* [API Documentation](http://aurelia.io/docs.html#/api/home)
* [Official Getting Started Guide](http://aurelia.io/docs.html#/aurelia/framework/latest/doc/article/getting-started)
* [Official GitHub Repo](https://github.com/aurelia/framework)
* [Rob Eisenberg on Twitter](https://twitter.com/eisenbergeffect)

#### Community

* [`#aureliajs`](https://twitter.com/hashtag/aureliajs) 推特上的标签
* [Aurelia Forum](https://discourse.aurelia.io/) 论话语
* [Gitter Channel](https://gitter.im/Aurelia/Discuss)
* [Gitter Channel](https://gitter.im/cmichaelgraham/aurelia-typescript) 对于 Aurelia 打字稿
* [Aurelia StackOverflow](http://stackoverflow.com/questions/tagged/aurelia)
* [Aurelia AMA (Ask Me Anything)](https://hashnode.com/ama/with-aurelia-team-cijv67apt000o535313ewe3qo)
* [/r/Aureliajs Subreddit](http://www.reddit.com/r/aureliajs/)
* [Aurelia on Google+](https://plus.google.com/communities/103785338632993439883)

#### Experts on personal blogs

* [Personal blog of Aurelia developer Matthew James Davis](http://davismj.me/)
* [Personal blog on Aurelia dev / Developer Jeremy Danyow](http://www.danyow.net/)
* [Personal blog on Aurelia dev / Developer Patrick Walters aka 'PWKAD'](http://patrickwalters.net/)
* [Personal blog on Aurelia dev / Developer Ashley Grant](http://blog.ashleygrant.com/)
* [Personal blog of Australian Front End / Aurelia Javascript Developer Dwayne Charrington](http://ilikekillnerds.com/category/javascript/aurelia/)
* [Personal blog on Aurelia dev / Developer Don Wilcox aka 'drdwilcox'](http://drdwilcox.blogspot.com/)
* [Personal blog on Aurelia dev / Developer Michael Lambert](http://hobbit-on-aurelia.net/)
* [Personal blog on Aurelia dev / Developer Sean Hunter](http://sean-hunter.io/)
* [Personal blog on Aurelia dev / Developer Paul van Bladel](http://blog.opinionatedapps.com/)
* [Personal blog on Aurelia dev / Developer Jason Sobell](http://www.sobell.net/category/aurelia/)
* [Rob Eisenberg's other Blog](http://eisenbergeffect.bluespire.com/)
* [Medium posts by Aurelia Core team member Erik Lieben](https://medium.com/@eriklieben)
* [Personal blog of Canadian developer Manuel Guilbault](http://manuelguilbault.com/)
* [Personal blog of Canadian developer Jeremy Gonzalez](http://www.jeremyg.net/)
* [Personal blog of German developer Katharina Bähr](https://kabaehr.de/)
* [Personal blog of American developer Eric L. Anderson](https://elanderson.net/tag/aurelia/)

#### Aurelia Tools

* [Chrome Extension](https://chrome.google.com/webstore/detail/aurelia-inspector/ofemgdknaajmpeoblfdjkenbpcfbdefg) * 这个工具叫做“Aurelia Inspector”
* [vscode-extension](https://github.com/aurelia/vscode-extension) * VS 代码编辑器的 Aurelia 扩展，提供 HTML 语法突出显示、语句完成和 CLI 集成.
* [vscode-aurelia-snippets](https://github.com/behzad888/vscode-aurelia-snippets) * VSCode 的 HTML、JavaScript 和 TypeScript 片段
* [aurelia-update](https://github.com/SpoonX/aurelia-update) * 轻松更新所有 aurelia 依赖项.
* [aurelia-template-lint](https://github.com/MeirionHughes/aurelia-template-lint) * Aurelia 风格模板 HTML 的健全性检查
* [atom-aurelia-snippets](https://atom.io/packages/atom-aurelia-snippets) * atom 的 JavaScript 和 TypeScript 片段
* [aurelia-installer](https://github.com/kristianmandrup/aurelia-installer) * 用于管理 Aurelia 组件和供应商库的 CLI
* [aurelia-debugger](https://github.com/charlespockert/aurelia-debugger) * Aurelia 可视化调试工具

#### Seed Project

* [Beginner kits](https://github.com/aurelia/beginner-kits) * 包含 ES 2016 和 TypeScript 的初学者入门工具包.
* [TypeScript + Webpack Starter Kit](https://github.com/michaelbull/aurelia-typescript-webpack-starter) * 一个用 TypeScript 编写并使用 webpack 构建的最小 Aurelia 入门工具包.
* [**{{** add_your_repo **}}**](https://github.com/behzad888/awesome/edit/master/README.md)

#### Aurelia Generators

* [zewa666/generator-aurelia](https://github.com/zewa666/generator-aurelia) @zewa666 的 JavaScript 框架 Aurelia 的 Yeoman 生成器
* [kristianmandrup/generator-aurelia-ts](https://github.com/kristianmandrup/generator-aurelia-ts) 用于 Aurelia 应用程序的 Turbo Start 生成器 @kristianmandrup

#### Aurelia Cheatsheet

* [Aurelia Getting Started Cheat Sheet by ErikCH](http://www.cheatography.com/erikch/cheat-sheets/aurelia-getting-started/)

#### Aurelia Tutorials

* [Aurelia Value Converters](https://jdanyow.github.io/aurelia-converters-sample/)
* [Aurelia & Framework7 vs. Angular2 & Ionic2](http://www.jujens.eu/posts/en/2016/Mar/15/ionic2-aurelia-f7/)
* [Aurelia-styleguide](https://github.com/behzad888/Aurelia-styleguide) * Aurelia 开发团队通过最佳实践提供一致性的起点.
* [Aurelia Tutorial | TutorialsPoint](https://www.tutorialspoint.com/aurelia/index.htm)

##### Aurelia Podcasts

* 02.22.2016 [No Fluff Just Stuff Podcast: Checking out Aurelia with Peter Pavlovich](http://blog.nofluffjuststuff.com/2016/02/22/podcast-checking-out-aurelia-with-peter-pavlovich/)
* 02.18.2016 [Program With Erik Podcast: The History Behind Aurelia with Rob Eisenberg](http://www.programwitherik.com/the-history-behind-aurelia-with-rob-eisenberg/)
* 02.11.2016 [Adventures in Angular Podcast: Aurelia with Rob Eisenberg](https://devchat.tv/adventures-in-angular/080-aia-aurelia-with-rob-eisenberg)
* 08.04.2015 [Herding Code 203: Rob Eisenberg on Aurelia](http://herdingcode.com/herding-code-203-rob-eisenberg-on-aurelia/)
* 06.02.2015 [The Changelog #140: Aurelia, Durandal, and leaving AngularJS with Rob Eisenberg](http://5by5.tv/changelog/140)
* 02.02.2015 [The Web Platform Podcast : 38: Aurelia.io](http://thewebplatform.libsyn.com/38-aureliaio)

##### Aurelia Videos

* 02.20.2018 [Aurelia For Beginners: The New Age JS Framework | Packt](https://www.packtpub.com/application-development/aurelia-beginners-new-age-js-framework-video)
* 01.04.2018 [Tutorial Series of Aurelia | AureliaCasts](https://aureliacasts.com/)
* 02.28.2017 [Aurelia Web Development - Part 1 | Packt](https://www.packtpub.com/web-development/aurelia-web-development-part-1-video)
* 05.04.2016 [Brian Noyes | Aurelia Fundamentals on Pluralsight.com](https://www.pluralsight.com/courses/aurelia-fundamentals)
* 03.08.2016 [Discover Aurelia with CEO Rob Eisenberg](https://www.youtube.com/watch?v=fi33aDFKvxE)
* 11.01.2016 [Rob Eisenberg | Aurelia: Next Generation Web Apps | NDC {London}](https://vimeo.com/153090562)
* 12.16.2015 [Ashley Grant on Custom Components in Aurelia | Dev Chat](https://www.youtube.com/watch?v=KOCiYJAWXeQ)
* 12.10.2015 [Jeremy Danyow on Binding | Readthesource 12](https://www.youtube.com/watch?v=NyxGZYgOCuo)
* 12.09.2015 [Jakub Jedryszek | Aurelia * The next generation JavaScript framework you will love | SeattleCodeCamp](https://vimeo.com/152733803)
* 11.12.2015 [Rob Eisenberg on Aurelia | DEVIntersection 2015 | Channel 9](https://channel9.msdn.com/Events/Seth-on-the-Road/DevIntersection-2015/Rob-Eisenberg-on-Aurelia)

##### Aurelia Books

* [Aurelia for Real World Applications](https://leanpub.com/aurelia-for-real-world-applications) 作者：Dwayne Charrington（2018 年 12 月，174 页）
* [Mastering Aurelia Store](https://leanpub.com/mastering-aurelia-store) 作者：Dwayne Charrington（最后更新于 2018 年 11 月）
* [Aurelia in Action](https://www.manning.com/books/aurelia-in-action) 作者 Sean Hunter（2018 年 8 月，432 页）
* [Hands-On Full Stack Web Development with Aurelia](https://www.packtpub.com/web-development/hands-full-stack-web-development-aurelia) 作者：Diego Arguelles 和 Erikson Murrugarra（2018 年 6 月，348 页）
* [Practical App Development with Aurelia](https://www.apress.com/gp/book/9781484234013) 作者：Matthew Duffield（2018 年 3 月）
* [Practical Aurelia](https://leanpub.com/practical-aurelia) 作者：Behzad Abbasi (behzad888)（2018 年 3 月，137 页）
* [Learning Aurelia](https://www.packtpub.com/web-development/learning-aurelia) 作者：Manuel Guilbault（2016 年 12 月，292 页）
* [Beginning Aurelia](https://leanpub.com/beginning-of-aurelia) 作者：Behzad Abbasi (behzad888)（2016 年 7 月，218 页）
* [Aurelia App Amazement](https://www.gitbook.com/book/kristianmandrup/aurelia-app-amazement/details) 克里斯蒂安·曼德鲁普 (2016)

##### Aurelia Articles

* [Authorization in Aurelia using CASL](https://medium.com/@sergiy.stotskiy/casl-based-authorization-in-aurelia-app-3e44c0fe1703) *Sergii Stotskyi (stalniy)

#### Material Design

* [Official Aurelia Material Design (Github)](https://github.com/joelcoxokc/aurelia-interface)
* [aurelia-mdl](https://github.com/genadis/aurelia-mdl)
* [aurelia-material](https://github.com/redpelicans/aurelia-material)
* [aurelia-mdl-plugin](https://github.com/arabsight/aurelia-mdl-plugin) * Aurelia 的 Material Design Lite 插件
* [**{{** add_your_repo **}}**](https://github.com/behzad888/awesome/edit/master/README.md)

#### Aurelia Plugins

* [aurelia-auth](https://github.com/paulvanbladel/aurelia-auth) * aurelia 的基于令牌的身份验证插件
* [aurelia-computed](https://github.com/jdanyow/aurelia-computed) * Aurelia 的插件，无需脏检查即可观察计算属性
* [aurelia-i18n](https://github.com/aurelia/i18n) {official} * 提供 i18n 支持的插件
* [aurelia-ui-virtualization](https://github.com/aurelia/ui-virtualization) {官方} * 提供虚拟中继器和其他虚拟化服务的插件
* [aurelia-bs-grid](https://github.com/charlespockert/aurelia-bs-grid) * Aurelia 和 Bootstrap 驱动的数据网格控制
* [aurelia-polymer](https://github.com/roguePanda/aurelia-polymer) * Aurelia 插件支持 Polymer
* [aurelia-google-maps](https://github.com/Vheissu/aurelia-google-maps) * 一个高度可配置的自定义元素，用于您的 Aurelia 应用程序，用于将 Google 地图插入您的应用程序
* [webpack-plugin](https://github.com/aurelia/webpack-plugin) {官方} * webpack 的插件，可以捆绑 Aurelia 应用程序
* [aurelia-cycle](https://github.com/niieani/aurelia-cycle) * 一个 Aurelia 插件，可以在 Aurelia 中使用 Cycle.js
* [aurelia-kendoui-bridge](https://github.com/aurelia-ui-toolkits/aurelia-kendoui-bridge) * Aurelia 和 KendoUI 集成
* [aurelia-long-click-event](https://github.com/avrahamcool/aurelia-long-click-event) * 为长按添加委托/触发功能.
* [aurelia-react-loader](https://github.com/bryanrsmith/aurelia-react-loader) * 直接从 Aurelia 视图加载 React 组件
* [aurelia-validatejs](https://github.com/aurelia/validatejs) {官方} * 使用装饰器和/或流畅的 API 启用表达验证.
* [aurelia-view-pipeline](https://github.com/behzad888/aurelia-view-pipeline) * 将任何 Markdown 加载到自定义元素中的插件
* [aurelia-api](https://github.com/SpoonX/aurelia-api) {ES6/TS/Webpack} * 用于多个端点的 aurelia-fetch-client 包装器
* [aurelia-authentication](https://github.com/SpoonX/aurelia-authentication) {ES6/TS/Webpack} * aurelia 的身份验证插件，支持 aurelia-api.
* [aurelia-orm](https://github.com/SpoonX/aurelia-orm) {ES6/TS/Webpack} * 使处理实体和调用 Rest API 变得简单.
* [aurelia-notification](https://github.com/SpoonX/aurelia-notification) {ES6/TS/Webpack} * 使用 humane.js 和 i18n 自动翻译通知
* [aurelia-binding-loader](https://github.com/bryanrsmith/aurelia-binding-loader) * 直接从视图模板使用任何模块的 Aurelia 加载器
* [aurelia-dragula](https://github.com/michaelmalonenz/aurelia-dragula) * Dragula 库的 ES2015 端口，针对 Aurelia 框架
* [aurelia-breeze](https://github.com/jdanyow/aurelia-breeze) * 将 Breeze 与 Aurelia 一起使用所需的一切
* [aurelia-bootstrap-datepicker](https://github.com/Itprosolutions/aurelia-bootstrap-datepicker) * bootstrap-datepicker 的 aurelia 端口
* [Aurelia-Configuration](https://github.com/vheissu/aurelia-configuration) * Aurelia 应用程序的智能配置.
* [aurelia-environment](https://github.com/MarcScheib/aurelia-environment) * aurelia-environment 提供简单的.env 解析和加载
* [aurelia-firebase](https://github.com/pulsarblow/aurelia-firebase) * [A Firebase plugin for Aurelia](https://aureliaonfire.azurewebsites.net)
* [aurelia-flux](https://github.com/tfrydrychewicz/aurelia-flux) * Aurelia 的 Flux 调度程序插件
* [aurelia-grid](https://github.com/corneliutusnea/aurelia-grid) * 用基于 charlespockert 的 Aurelia BS Grid 的 TypeScript 编写的全新 Aurelia Grid
* [aurelia-google-analytics](https://github.com/miguelzakharia/aurelia-google-analytics) * 将 Google Analytics 页面跟踪添加到您的项目的 Aurelia.io 插件.
* [aurelia-knockout](https://github.com/code-chris/aurelia-knockout) * Aurelia 的 Knockout 插件
* [aurelia-leaflet](https://github.com/ceoaliongroo/aurelia-leaflet) * Aurelia 的传单插件
* [aurelia-notify](https://github.com/MarcScheib/aurelia-notify) * Aurelia 的通知插件
* [aurelia-rethink-bindtable](https://github.com/kristianmandrup/aurelia-rethink-bindtable) * 通过 Socket.io 为 RethinkDB 集成 Aurelia 绑定表
* [aurelia-sails-socket-client](https://github.com/Mordred/aurelia-sails-socket-client) * 围绕 sails.io 客户端的简单、宁静、基于消息的包装器
* [aurelia-switch](https://github.com/Itprosolutions/aurelia-switch) * aurelia 优化的 switchButton
* [aurelia-yt-player](https://github.com/genadis/aurelia-yt-player) * Youtube 播放器 API 的 Aurelia 插件
* [abalmus/aurelia-ace-editor](https://github.com/abalmus/aurelia-ace-editor) * Aurelia ace 编辑器插件
* [Tseberechts/aurelia-place-picker](https://github.com/Tseberechts/aurelia-place-picker) * 受 Aurelia 自动完成地点启发的地点选择器
* [treacherous-aurelia](https://github.com/grofit/treacherous-aurelia) * 用于危险验证系统的 Aurelia 插件
* [aurelia-filter](https://github.com/SpoonX/aurelia-filter)  * aurelia 的插件，用于填充搜索/过滤条件. 适用于 aurelia-orm
* [aurelia-charts](https://github.com/SpoonX/aurelia-charts)  * aurelia 的图形插件. 支持所有库
* [aurelia-view-manager](https://github.com/SpoonX/aurelia-view-manager)  * aurelia 插件的视图管理器. 添加对覆盖视图和多个框架的支持
* [aurelia-resize](https://github.com/MeirionHughes/aurelia-resize) * 用于观察 DOM 元素调整大小事件的 aurelia 插件
* [aurelia-keyboard-plugin](https://github.com/Novatrox/aurelia-keyboard-plugin) * aurelia 的简单键盘插件
* [aurelia-ui-framework](https://github.com/adarshpastakia/aurelia-ui-framework) * 基于 Aurelia 的定制 UI 框架，用于桌面业务应用程序
* [aurelia-tags-input](https://github.com/TGMorais/aurelia-tags-input) * aurelia 标签输入插件
* [aurelia-formio](https://github.com/formio/aurelia-formio) * 动态 JSON 表单渲染器和表单生成器 - [See Example](https://formio.github.io/aurelia-formio/)
* [aurelia-swipeout](https://github.com/michaelbull/aurelia-swipeout) * iOS 样式刷出操作的自定义元素 - [Demo](https://michaelbull.github.io/aurelia-swipeout/)
* [aurelia-split-pane](https://github.com/michaelbull/aurelia-split-pane) * 可调整大小的拆分窗格的自定义元素 - [Demo](https://michaelbull.github.io/aurelia-split-pane/)
* [aurelia-bootstrap-plugins](https://github.com/ghiscoding/Aurelia-Bootstrap-Plugins) * 一组与第 3 方 Bootstrap 插件桥接的插件 - [Demo](https://ghiscoding.github.io/Aurelia-Bootstrap-Plugins/)
* [aurelia-slickgrid](https://github.com/ghiscoding/aurelia-slickgrid) * Slickgrid 是用于性能和自定义的最佳 javascript 数据网格，现在可在 Aurelia 中使用 - [Demo](https://ghiscoding.github.io/aurelia-slickgrid/)
* [casl-aurelia](https://github.com/stalniy/casl/tree/master/packages/casl-aurelia) * 允许集成 Aurelia 和 CASL 的权限管理插件
* [aurelia-json-schema-form](https://github.com/jbockle/aurelia-json-schema-form) * 一个完全可定制的插件，用于动态生成表单并根据 JSON 模式验证它们
* [aurelia-highlightjs](https://aurelia-highlightjs.r-w-x.net/#/demo) * Aurelia 自定义元素 [highlight.js](https://highlightjs.org/)
* [aurelia-fontawesome](https://github.com/jmzagorski/aurelia-fontawesome) * Aurelia 组件用于 [Font Awesome](https://fontawesome.com/) 5.
* [aurelia-kis-oidc](https://github.com/kisssdev/aurelia-kis-oidc) * 封装的Aurelia插件 [oidc-client-js library](https://github.com/IdentityModel/oidc-client-js).
* [aurelia-telemetry](https://github.com/manuel-guilbault/aurelia-telemetry)
* [**{{** add_your_repo **}}**](https://github.com/behzad888/awesome/edit/master/README.md)

#### Aurelia Implementation

* [aurelia-animator-tinyanimate](https://github.com/gooy/aurelia-animator-tinyanimate) * 使用 TinyAnimate 实现 Aurelia 基础动画师
* [sukobuto/aurelia-tinymce-sample](https://github.com/sukobuto/aurelia-tinymce-sample) * 使用 Aurelia 和 TinyMCE 的示例应用程序
* [stamp-web/stamp-web-aurelia](https://github.com/stamp-web/stamp-web-aurelia) * 使用 Bootstrap 使用 Aurelio 编写的下一代 Stamp Web 编辑器
* [aurelia-flickr-ts-memo-game](https://github.com/kst83/aurelia-flickr-ts-memo-game) * 使用 Flickr 在 TypeScript 中匹配由 Aurelia 编写的成对类型的游戏
* [aurelia-datatable](https://github.com/SpoonX/aurelia-datatable) * 一个 100% 基于 aurelia 的数据表组件 [http://aurelia-datatable.spoonx.org](http://aurelia-datatable.spoonx.org)

#### Aurelia Custom Element

* [aurelia-v-grid](https://github.com/aurelia-ui-toolkits/aurelia-v-grid) * aurelia-v-网格
* [aurelia-leaflet](https://github.com/benib/aurelia-leaflet) * [A Leaflet CustomElement for Aurelia]( http://benib.github.io/aurelia-leaflet/)
* [aurelia-chart](https://github.com/grofit/aurelia-chart) * aurelia 的图表元素，由使用 html5 画布的图表 js 提供支持
* [aurelia-toolbelt](https://github.com/aurelia-toolbelt/aurelia-toolbelt) * 一组用于bootstrap4的组件，它还包括其他组件和值转换器.
* [ag-grid-aurelia](https://github.com/ag-grid/ag-grid/tree/master/packages/ag-grid-aurelia) * 与 ag-Grid 一起使用的 Aurelia 组件，这是一种高级数据网格/数据表 - [Demo](https://www.ag-grid.com/best-aurelia-data-grid/)

#### Aurelia Auth

* [sentry](https://github.com/Foursails/sentry) * 带有内置身份验证外壳的 Aurelia 模板
* [aurelia-authentication-loopback-sample](https://github.com/doktordirk/aurelia-authentication-loopback-sample) * Aurelia 客户端示例，带有 aurelia 身份验证和环回服务器（ES6/TS+jspm、ES6+webpack）
* [aurelia-identityserver-aspnetcore](https://github.com/paulvanbladel/aurelia-identityserver-aspnetcore) * 将 aurelia 与 identityserver 4 和 docker 集成的示例
* [casl-aurelia-example](https://github.com/stalniy/casl-aurelia-example) * 使用 CASL 在 Aurelia 应用程序中应用授权示例.

#### Aurelia Libraries

* [pollyfils](https://github.com/aurelia/polyfills) * 运行 Aurelia 所需的最小 polyfill 集
* [aurelia-sails-socket-client](https://github.com/Mordred/aurelia-sails-socket-client) * 围绕 sails.io 客户端的简单、宁静、基于消息的包装器
* [aurelia-bundler](https://github.com/aurelia/bundler) * 用于捆绑 JavaScript、HTML 和 CSS 以与 SystemJS 一起使用的库
* [**{{** add_your_repo **}}**](https://github.com/behzad888/awesome/edit/master/README.md)

#### Aurelia Examples

* [jdanyow/aurelia-breeze-northwind](https://github.com/jdanyow/aurelia-breeze-northwind) * @jdanyow 使用 Aurelia 和 Breeze 的 Northwind 演示.
* [jdanyow/aurelia-solitaire](https://github.com/jdanyow/aurelia-solitaire) * 克朗代克纸牌是用 Aurelia 和 dragula 制作的.
* [discosultan/aurelia-minesweeper](https://github.com/discosultan/aurelia-minesweeper/) * 由 @discosultan 使用 Aurelia 构建的经典扫雷游戏.
* [aurelia-webapi-example](https://github.com/jimschubert/aurelia-webapi-example) * An example WebAPI written with C# and Aurelia
* [michaelbull/aurelia-hacker-news](https://github.com/michaelbull/aurelia-hacker-news#aurelia-hacker-news-clone) * 用 TypeScript 编写并使用 Aurelia 构建的 Hacker News 网站的再创造，将 webpack 作为模块捆绑器.
* [Built with Aurelia](http://builtwithaurelia.com/) * 展示 Aurelia 社区创建的示例.

##### Aurelia + Electron Examples

* [aurelia-electron-webpack](https://github.com/timfish/aurelia-electron-webpack) * 使用 Aurelia、Typescript 和 Webpack 构建 Electron 应用程序的基本样板.
* [AureliaElectronHappiness](https://github.com/seesharper/AureliaElectronHappiness) * 展示如何组合 TypeScript、VSCode 和 Electron 的示例应用程序.
* [electron-aurelia-example](https://github.com/jimschubert/electron-aurelia-example) * 使用 Electron 和 Aurelia 编写的示例桌面应用程序.

### TypeScript

 &gt; TypeScript 让您可以按照自己真正想要的方式编写 JavaScript.  TypeScript 是 JavaScript 的类型化超集，可编译为纯 JavaScript.

#### TypeScript General Resources

* [TypeScript](http://www.typescriptlang.org/) TypeScript 官方网站
* [REPL](http://www.typescriptlang.org/Playground) 完全在浏览器中运行的官方 TypeScript REPL
* [TypeScript Repository (GitHub)](https://github.com/Microsoft/TypeScript) TypeScript 的官方 GitHub 回购
* [DefinitelyTyped Repository (GitHub)](https://github.com/DefinitelyTyped/DefinitelyTyped) 高质量 TypeScript 类型定义的存储库.
* [TSD](http://definitelytyped.org/tsd) DefinitelyTyped 的 TypeScript 定义管理器

#### Typescript Seed Projects

* [Aurelia Typescript](https://github.com/cmichaelgraham/aurelia-typescript) * 用于使用 @cmichaelgraham 的 Aurelia TypeScript 类型定义的入门工具包
* [aurelia-axel](https://github.com/cmichaelgraham/aurelia-axel) * As a Visual Studio TypeScript and C# developer building web-based, spatial information systems targeting a variety of platforms that leverage ESRI and SQL Server, I want a starter kit so that I can rapidly build implementations
* [aurelia-axel-northwind](https://github.com/cmichaelgraham/aurelia-axel-northwind) * 作为用户，我想了解如何基于熟悉的数据库 (Northwind) 从 `aurelia-axel` 入门工具包创建 Web 应用程序
* [aurelia-skeleton-navigation-gulp-typescript](https://github.com/Enrapt/aurelia-skeleton-navigation-gulp-typescript) * 使用 Gulp 和 Typescript 实现的 Aurelia 导航框架
* [aurelia-chrome-extension-seed](https://github.com/PraveenGandhi/aurelia-chrome-extension-seed) * Aurelia 铬延伸种子

* [**{{** add_your_repo **}}**](https://github.com/behzad888/awesome/edit/master/README.md)

### ES5

&gt; 一种 ECMAScript 语言，包括结构化、动态、函数式和基于原型的特性.

#### ES5 General Resources

* [**{{** help_add_resources **}}**](https://github.com/behzad888/awesome/edit/master/README.md)

#### ES5 Seed Projects

* [ahmedshuhel/nav-app-es5](https://github.com/ahmedshuhel/nav-app-es5) @ahmedshuhel 仅使用 ES5、Bower 和 RequireJS 设置标准 aurelia 导航式应用程序的骨架.

#### ES5 Examples

* [aurelia-observer-patterns](https://github.com/axwalker/aurelia-observer-patterns) * 在 Aurelia 中实现观察者模式的不同方法的简单示例

### Meteor

&gt; Meteor 是一个全栈 JavaScript 平台，可以使用 Aurelia 作为其前端框架.

#### Meteor Seed Projects

* [TsumiNa/meteor-aurelia](https://github.com/TsumiNa/meteor-aurelia) Skeleton that allows Meteor to use Aurelia as the front-end by @TsumiNa.

## Contributing Guideline

请注意，该项目随 [Contributor Code of Conduct](code-of-conduct.md) . 参与此项目即表示您同意遵守其条款.

确保您的拉取请求符合以下准则：

* 在提出新建议之前搜索以前的建议，因为您的建议可能重复.
* 如果您刚刚创建了一些东西，请至少等待几周再提交.
* 您当然应该阅读或使用过您提交的内容.
* 为每个建议提出单独的拉取请求.
* 使用以下格式：`[name](link) * 描述.`
* 保持描述简短，但具有描述性.
* 以大写字母开始描述，以句号/句号结束.
* 检查你的拼写和语法.
* 确保您的文本编辑器设置为删除尾随空格.
* 链接添加应添加到相关部分的底部.
* 欢迎新类别或对现有分类的改进.
* 拉取请求应该有一个有用的标题，并包含指向包的链接以及为什么要包含它.

谢谢你的建议！

## Updating your PR

很多时候，使 PR 遵守上述标准可能很困难. 如果维护者注意到我们想要更改的任何内容，我们会要求您在合并之前编辑您的 PR. 无需打开新的 PR，只需编辑现有的 PR. 如果您不确定该怎么做， [here is a guide](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) 您可以通过不同的方式更新您的 PR，以便我们可以合并它.
