<div class="github-widget" data-repo="stingalleman/awesome-audiovisual"></div>

## Awesome Audiovisual [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

> Curated list of software, libraries and resources for lighting, video and audio professionals and hobbyists.

Want to add something? Just make a pull request, but be sure to follow the [contributing guidelines](https://github.com/stingalleman/awesome-audiovisual/blob/master/./contributing.md)! Question? Ask it in the [General Discussion issue](https://github.com/stingalleman/awesome-audiovisual/issues/2).

<!--lint ignore awesome-toc -->

## Lighting


### Lighting Software

- [Avolites Titan](https://www.avolites.com/software/downloads/titan-pc-suite) - PC version of the Titan software which runs on the Avolites desk. Free to use until version 11.4 although it spits out random data once in a while. Requires a dongle from version 12. `⚠ not free`.
- [Chamsys MagicQ](https://chamsyslighting.com/) - MagiQ is a professional lighting software providing up to 64 Artnet universes for free. It includes powerful features like 2D/3D pixel mapping, effect generator, media server and visualizer.
- [Daslight](https://www.daslight.com/) - DMX lighting software for PC and Mac.
- [Dot2 software](https://www.malighting.com/downloads/products/dot2/) - Free, offline software for the Dot2 consoles. Includes Dot2 onPC and Dot2 3D.
- [EOS Family](https://www.etcconnect.com/Products/Consoles/Eos-Family/) - Software for ETC's EOS-family consoles. `⚠ freemium`.
- [Freestyler](http://www.freestylerdmx.be/) - Free lightning control software
- [GrandMA2 software](https://www.malighting.com/downloads/products/grandma2/) - Free, offline software for the GrandMA2 lighting console. Includes GrandMA2 OnPC and MA3D. Does not output DMX for free. `⚠ freemium`.
- [GrandMA3 software](https://www.malighting.com/downloads/products/grandma3/) - Free, offline software for the **new** GrandMA3 lighting console. Includes GrandMA3 OnPC. Does not output DMX for free. `⚠ freemium`.
- [Hog 4 software](https://www.highend.com/products/consoles/) - Free, offline software for the Hog 4 lighting console. Includes Hog 4 pc. Does not output DMX for free. `⚠ freemium`.
- [LightFactory](https://www.lightfactory.net/) - PC Lighting Control software witch also is the backend of the NEO Console. `⚠ not free`.
- [ONYX](https://obsidiancontrol.com/onyx) - Modern lighting control system with alot of features.
- [QLC+](https://www.qlcplus.org/) - QLC+ is a free and cross-platform software to control DMX or analog lighting systems like moving heads, dimmers, scanners etc. [Source Code](https://github.com/mcallegari/qlcplus) `✓ open-source`.
- [xLights](https://xlights.org/) - Meant for home Christmas light shows but is a great way to sync lights to music on a budget. [Source Code](https://github.com/smeighan/xLights) `✓ open-source`.

### Visualizers

- [Capture](https://www.capture.se/) - Documentation and visualisation software. Capture is a native macOS and Windows application that lets you work with lighting, video, laser, moving scenery and water effects. Does have a free Student Edition. `⚠ freemium`.
- [Depence²](https://www.syncronorm.com/products/depence2/overview/) - Depence² is a unique application, which combines the design and visualization process with the potential to control the real show. `⚠ not free`.
- [Ma3D](https://www.malighting.com/downloads/products/grandma2/) - **Free** lighting visualizer for GrandMA consoles/software.
- [wysiwyg](https://cast-soft.com/wysiwyg-lighting-design/) - wysiwyg is an all-in-one lighting design software with fully integrated CAD, plots, data, visualization and virtual show control. `⚠ not free`.

## Audio


### Audio Software

- [Audacity](https://www.audacityteam.org/) - Audio file editor and analysis tool, great for cropping down sound effects and music tracks. `✓ open-source`.
- [Ardour](https://ardour.org/) - A full realtime audio recording and editing suite. [Source Code](https://github.com/Ardour/ardour) `✓ open-source`.
- [da-Share MultiPlay](https://www.da-share.com/software/multiplay/) - MultiPlay is a Windows based program designed to play audio cues for theatre or corporate use. It is free to use.
- [Linux Show Player](https://www.linux-show-player.org/) - Free cue player designed for stage productions. [Source Code](https://github.com/FrancescoCeruti/linux-show-player) `✓ open-source`.
- [QLab](https://qlab.app/) - QLab is sound, video, and lighting control for macOS. `⚠ freemium`.
- [REAPER](https://www.reaper.fm/) - REAPER is a complete digital audio production application for computers, offering a full multitrack audio and MIDI recording, editing, processing, mixing and mastering toolset. `⚠ freemium`.

### Audio tools

- [ARTA](http://www.artalabs.hr/) - A collection of programs for audio measurements and analysis.
- [REW](https://www.roomeqwizard.com/) - REW is free room acoustics analysis software for measuring and analysing room and loudspeaker responses. Free SMAART alternative.

## Video


See [ebu/awesome-broadcasting](https://github.com/ebu/awesome-broadcasting#readme).

## Tools


- [Livescript](https://github.com/Netlob/livescript) - Insert a musical/theatre-script from Google Docs and use this for a live "autocue" and scroller with everyone on the site. `✓ open-source`.
- [Ontime](https://github.com/cpvalente/ontime) - Browser-based application that manages event rundowns, scheduling, and cueing. Plan, track your schedule, manage automation and cross-department show information in one place. `✓ open-source`.
- [stagetimer.io](https://stagetimer.io) - Browser-based remote-controlled countdown timer.  `⚠ freemium`.

### CADs

- [AutoCAD](https://www.autodesk.com/products/autocad) - AutoCAD® is computer-aided design (CAD) software that architects, engineers, and construction professionals rely on to create precise 2D and 3D drawings. `⚠ not free`.
- [Vectorworks](https://www.vectorworks.net/) - Vectorworks is a versatile, on-premise application that provides extensive 2D drafting, 3D modeling, BIM and rendering capabilities for your architectural and landscape design needs. Also had a special entertainment version: [Vectorworks Spotlight](https://www.vectorworks.net/en-GB/spotlight). `⚠ not free`.

### Timecode

Timecode is a sequence of numeric codes generated at regular intervals by a timing synchronization system. Timecode is used in video production, show control and other applications which require temporal coordination or logging of recording or actions.

- [El-Tee-See](http://elteesee.pehrhovey.net/) - LTC wav file generator.
- [TCgenerator](https://github.com/dimitriCGNL/TCGenerator) - Reaper time marker to GrandMA2 TC Generator. `✓ open-source`.
- [Timecode](https://github.com/MrExplode/Timecode) - ArtNet and LTC timecode generator, made with Java. `✓ open-source`.
- [Time MIDI sender](https://github.com/TheGreyDiamond/Time-MIDI-sender) - A free tool for sending time data to DasLight (via MIDI). `✓ open-source`.
- [TimelordMTC](https://timelord-mtc.com/) - Advanced timecode management tool. `⚠ not free`.
- [M2Q](https://github.com/lorenzofattori/M2Q) - Python application capable to trigger Chamsys Consoles/Software via MIDI for advanced synchronized shows. `✓ open-source`.

### Monitoring

- [AES67 WebMeter](https://github.com/zjstraus/AES67-WebMeter) - Server that receives an AES67 audio stream and presents a webpage with meters. `✓ open-source`.
- [meters.lv2](https://github.com/x42/meters.lv2) - meters.lv2 is a collection of audio-level meters with GUI in LV2 plugin format. `✓ open-source`.
- [Open Sound Meter](https://opensoundmeter.com/) - Clean, open-source sound meter. Supports RTA, magnitude, phase and impulse response, coherence, group delay and more. `✓ open-source`.

## Libraries and frameworks


- [Open Lighting Architecture](https://www.openlighting.org/ola/) - A framework for lighting control information. Supports a range of protocols and over a dozen of USB devices. [Source Code](https://github.com/OpenLightingProject/ola)
- [node-dmx](https://github.com/node-dmx/dmx) - DMX controller library for Node.js. `nodejs` `✓ open-source`.

### ArtNet Libraries

- [artnet](https://github.com/hobbyquaker/artnet) - Node.js module that can be used to send ArtDMX packages to an Art-Net node. `nodejs`.
- [artnet4j](https://github.com/cansik/artnet4j) - Art-Net library for Java and Processing. `java`.

## Hardware


See [HARDWARE.md](https://github.com/stingalleman/awesome-audiovisual/blob/master/./HARDWARE.md).

## Graphics


- [GIMP](https://www.gimp.org/) - GIMP is a cross-platform image editor available for Linux, Windows, and macOS.
- [Inkscape](https://inkscape.org/) - Inkscape is a professional vector graphics editor for Linux, Windows and macOS.

## Management

- [Rentman](https://rentman.io/) - Cloud rental software for AV & Event companies. Resource planning, scheduling and more. `⚠ not free`

## Resources


- [Chamsys Programmers and Users facebook group](https://www.facebook.com/groups/chamsys.users/) - The best place to find information about Chamsys consoles and software.
- [Christian Jackson](https://www.youtube.com/channel/UCdLor-EVzOjOY7OZNXt8eIw) - YouTube channel about concert lighting. Also has great MA tutorials.
- [ESTA Technical Standards Program](https://tsp.esta.org/tsp/documents/published_docs.php) - Collection of technical standards in the entertainment technology industry.
- [Geezers of Gear](https://geezersofgear.libsyn.com/) - Entertainment Production Industry veteran talking about pro-audio, lighting, staging, video + the people and companies who work in this great industry.
- [@limelightwired](https://www.instagram.com/limelightwired/) - Lighting production community on Instagram.
- [awesome-linuxaudio](https://github.com/nodiscc/awesome-linuxaudio) - A Awesome list with all things Linux audio.
- [QLab Cookbook](https://qlab.app/cookbook/) - The cookbook is a collection of projects, examples, and experiments using a broad range of QLab programming techniques including AppleScript, OSC, external control using QLab Remote, third-party MIDI and OSC controllers, and other software.
- [/r/lightingdesign](https://reddit.com/r/lightingdesign/) - The Reddit community for lighting designers worldwide.
- [/r/techtheatre](https://reddit.com/r/techtheatre/) - The reddit community for all production designers and technicians!

### Blogs

- [mikewoodld.com/blog/](https://www.mikewoodld.com/blog/) - Blog of Lighting Designer Mike Wood.
- [notelek.com/blog/](http://notelek.com/blog/) - LXR Stage Technology Blog.

## Tutorials


### GrandMA2 tutorials

- [GMA2 colour picker tutorial](https://www.youtube.com/watch?v=lhYDUzWKz3M) - A tutorial for how to add a colour picker in GrandMA2.

## Misc/other


- [Blender ArtNet](https://github.com/BryanCrotaz/blender-artnet) - Blender script to push ArtNet data to Evee lights. Runs at 30fps with Evee rendering in the viewport. `✓ open-source`.
- [Linux](https://en.wikipedia.org/wiki/Linux) - A free operating system that can run on pretty much every kind of computer and is great for breathing new life into old computers that aren't supported by the newer Windows editions. There's tons of different distributions to choose from,. The most common one for general computer stuff is [Ubuntu](https://ubuntu.com/). `✓ open-source`.
- [MIDI Monster](https://github.com/cbdevnet/midimonster/) - MIDIMonster is a universal control and translation tool. It can translate between many different protocols such as MIDI, Artnet, sACN and OSC. `✓ open-source`.
- [UsedLighting](https://www.usedlighting.com/) - Marketplace for buying/selling used lighting hardware.
