<div class="github-widget" data-repo="willianjusten/awesome-audio-visualization"></div>
<p align="center">
  <img id="awesome-audio-visualization" src="https://raw.githubusercontent.com/willianjusten/awesome-audio-visualization/master/logo-aav.gif" alt="Logo AAV">
</p>

- [What is Audio Visualization?](https://en.wikipedia.org/wiki/Music_visualization)

 &gt; 音乐可视化是电子音乐可视化工具和媒体播放器软件中的一项功能，可根据一段音乐生成动画图像. 图像通常是实时生成和渲染的，并且与播放的音乐同步.

- [Check the logo in action](http://www.shiz.co/aav/)
- [Contributing Guide](https://github.com/willianjusten/awesome-audio-visualization/blob/master/Contributing.md)

[![Travis Build](https://travis-ci.org/willianjusten/awesome-audio-visualization.svg?branch=master)](https://travis-ci.org/willianjusten/awesome-audio-visualization) [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)



## Books

- [Web Audio API by Boris Smus](https://webaudioapi.com/book/)

## Downloads

- [Soundwhich](http://soundwhich.com/)
- [Beeple's resource (inspirational C4D "open source" files)](http://www.beeple-crap.com/resources.php)
- [Freesound](http://freesound.org/)
- [Audio Jungle](http://audiojungle.net/)
- [Six Bit Deep](http://www.sixbitdeep.com/shop/)
- [Samplephonics - Free Stuff](http://store.samplephonics.com/collections/free-stuff-1)
- [Wave Alchemy](http://www.wavealchemy.co.uk/free-samples/)
- [Audio Animals](http://www.audioanimals.co.uk/shop-categories/sample-shop)
- [Bed Room Producers Blog](http://bedroomproducersblog.com/free-samples/)
- [Free Music Archive](http://freemusicarchive.org/)
- [Music Radar](http://www.musicradar.com/news/tech/free-music-samples-download-loops-hits-and-multis-627820)
- [How to Make Electronic Music Freebies](http://howtomakeelectronicmusic.com/category/freebies)
- [Motion Sound](http://motionsound.io/)
- [Cava](https://github.com/karlstav/cava#latency-notes) - 跨平台终端可视化工具. 


## Experiments

- [Audible Visuals](https://soniaboller.github.io/audible-visuals/) - 从 Sonia Boller 的阿基米德螺线导出的可视化工具集.
- [React Player](https://dazzling-jang-471a34.netlify.com/) - 带有 ReactJS 的完整音频可视化播放器.
- [Moire](http://hughsk.io/moire-1/) - 网络音频/WebGL 可视化.
- [Finding Love](https://findinglove.activetheory.net/) - 完全互动的虚拟现实故事，将情感转化为艺术.
- [Tangled](http://netlabelday2016.yarnaudio.com/) - 由总部位于柏林的 netlabel Yarn Audio 发行的视听作品，视觉效果制作于 [cables](https://cables.gl/) . 拖动旋转，滚动缩放.
- [Luis Henrique Bizarro Portfolio](https://lhbzr.com/) - 使用 Three.JS 和 GSLS 进行实验的作品集.
- [Adventure Machine](http://www.madeon.fr/adventuremachine/) - Madeon 的“Adventure”专辑宣传活动.
- [BBNG](https://uberviz.io/viz/bbng/) - BADBADNOTGOOD 的“Confessions”（feat. Leland Whitty）的 WebGL Visualizer.
- [Chrome Music Lab](https://musiclab.chromeexperiments.com/) - 进行简单的实验并探索音乐的工作原理.
- [DENNIS](http://www.dennis.video/) - popcorn_10&#39;s 为“Dennis”制作的交互式音频响应音乐视频.
- [Fluctus](http://jojo.ninja/fluctus/) - Jordan Machado 的实验性 3D 音频可视化工具.
- [George & Jonathan III](http://www.georgeandjonathan.com/) - George &amp; Jonathan 的“III”专辑宣传活动.
- [Lantern](https://www.uberviz.io/viz/lantern/) - SBTRKT 的“灯笼”WebGL 可视化工具.
- [Lines](http://labs.fluuu.id/lines/) - 将 Joy Division 专辑封面可视化为 Silvio Paganini 的音乐谱.
- [Nero](https://www.uberviz.io/viz/nero/) - Nero 的“In The Way”的 WebGL Visualizer.
- [Pareidolia](https://www.uberviz.io/viz/pareidolia/) - Venetian Snares 的“不幸”WebGL 可视化工具.
- [Splice](https://www.uberviz.io/viz/splice/) - 使用来自 Splice 即将推出的可视化工具 API 的时间码数据的实时交互式音乐可视化工具.
- [Typatone](http://www.typatone.com/) - 一边写作一边创作音乐.
- [Yume](http://unseen-music.com/yume/) - Helios 的“Yume”专辑宣传活动.
- [Silk](http://mattdesl.github.io/codevember/21.html) - Matt DesLauriers 的 3D 音频可视化工具.
- [Wave](http://mattdesl.github.io/codevember/3.html) - Matt DesLauriers 的 3D 音频可视化工具.
- [Binaural](http://mattdesl.github.io/codevember/6.html) - 尝试使用 Matt DesLauriers 的双耳和混响音频效果.
- [Word Problems](https://www.uberviz.io/viz/word-problems/) - Harmonic 313 针对“单词问题”的 WebGL 可视化工具.
- [Glitch](http://naivesound.com/glitch/) - 从数学中制作音乐的算法合成器.
- [105 Birthday Clara Rockmore](http://www.google.com/doodles/clara-rockmores-105th-birthday) - Clara Rockmore 生日涂鸦.
- [Fireworks with WebGL](http://ondras.github.io/fireworks-webgl/) - Ondřej Žara 的声控烟花.
- [Glowsynth - just amazing!](http://outputchannel.com/glowsynth/) - 使用您的鼠标、Qwerty 键盘或 MIDI 键盘进行演奏，观看灯光随着您的音乐翩翩起舞.
- [Mmorph](http://mmorph.massivemusic.com/) - 探索在浏览器及其他环境中提供交互式音乐的新方法.
- [Loop Waveform Visualizer](https://airtightinteractive.com/demos/js/reactive/) - Beytah 的螺旋底座 WebGL 可视化工具.
- [Scrollsound](http://zya.github.io/scrollsound/) - Ehsan Ziya 将滚动作为一种与网络音频交互的方法.
- [Experiment #8](http://brunoimbrizi.com/experiments/#/08) - Bruno Imbrizi 的音乐实验.
- [Music Cube](http://www.808cube.com/) - 将 Roland TR-808 鼓机与 Rubik&#39;s Cube 相结合的 Chrome Experiment.
- [Music Game - ECHO](http://tonenotone.com/ECHO/) - 具有挑战性的音乐益智游戏.
- [Patatap](http://www.patatap.com/) - 便携式动画和声音套件.
- [Plink - Awesome Multiplayer Game](http://www.dinahmoelabs.com/plink) - 多人音乐体验.
- [Soundcloud Visualizer](http://www.michaelbromley.co.uk/experiments/soundcloud-vis/#muse/undisclosed-desires) - 画布和网络音频实验.
- [CSS Visualizer](http://likethemammal.github.io/css-visualizer/) - 完全使用 DOM 元素和 CSS3 制作的音乐可视化工具.
- [Kandinski Experiment](http://jasonsigal.cc/kandinskify/) - 受康定斯基启发的音乐可视化.
- [Visual Music Trailer](https://vimeo.com/160470393) - 现场视听表演创意.
- [Draw and Music](http://rugs.grindselect.com/) - Sam Greens 的 Rugs 新专辑宣传活动.
- [Moogfest Substrate](http://www.moogfest.com/_substrate) - Moogfest 的实验站点.
- [3D Grid](http://rickycodes.github.io/audio-visualizer/three/) - 由 rickycodes 使用 HTML5 网络音频 API 构建的音频可视化工具.
- [obsidian](http://mrdoob.com/files/temp/xplsv_obsidian/) - 由 Three.js 的创建者制作的 3D 音频可视化.
- [TRIF](http://trif.it/) - 使用 webaudio API 和原始 CSS 的基于 GIF 的在线广播可视化
- [Audiograph](http://audiograph.xyz/) - 由 Matt DesLauriers 制作的惊人音频可视化.
- [Scribble Audio](http://scribble.audio/) - 使用此网络合成器绘制声音循环.
- [Touchpianist](http://touchpianist.com/) - 弹奏钢琴并沿着屏幕观看所有动画.
- [PartyMode](https://preziotte.com/partymode/) - 使用 d3.js 和网络音频 api 的实验性音乐可视化工具.
- [DJi](http://jieverson.com/DJi/) - 从 SoundCloud 或自行上传的清理音乐可视化工具.
- [VR Ondes Martenot](https://github.com/elifer5000/vr-ondes-martenot) - 在虚拟现实中可播放的 Ondes Martenot.
- [Popcorn](http://hughsk.io/popcorn/) - Hugh Kennedy 的小音频反应草图.
- [Musical Interactions](https://tympanus.net/Development/MusicalInteractions/) - 有趣的音乐互动的一些实验性想法.
- [ClubberToy](https://wizgrav.github.io/clubber/) 几个 shadertoys，与 clubber 重新连接，捆绑为一个 vj 应用程序.
- [Andantino](https://alpcanaydin.github.io/andantino/) 听一些音符并尝试在键盘上找到相同的音符.
- [Vissonance](https://tariqksoliman.github.io/Vissonance/) 在 THREE.js 中构建的音频可视化工具集合.
- [ShowCQTBar](https://mfcc64.github.io/html5-showcqtbar/) - 具有音阶的音频频谱可视化.
- [Weekly Music Visualizations](https://github.com/surayashivji/WeeklyGraphics) Suraya Shivji 使用 Three.js 和 p5.js 构建的每周音乐可视化实验.
- [Audio Visualizer](https://github.com/Teoxoy/audio-visualizer) - 使用 Pixi.js 构建的有趣的网络音频可视化工具.
- [YouTube Musical Spectrum](https://github.com/mfcc64/youtube-musical-spectrum) - 一个浏览器扩展程序，可在您的 YouTube 页面上提供带有优美音符的音频可视化.
- [Just Dance](http://hiteshsahu.com/AudioAnalysis) - 制作的 3D 音频可视化 [BabylonJS](http://babylonjs.com/) &amp; 2D柏林噪声.
- [audioMotion](https://audiomotion.me)  - 高分辨率实时音频频谱分析仪和用 JavaScript 编写的全功能音乐播放器. 包括适用于 Windows、Linux 和 macOS 的二进制文件.
- [p5.js Audio Visualizer](https://amandayehh.github.io/audio-visualizer/) - 一个强大的、节拍和振幅响应的音频可视化工具 [p5.sound](https://github.com/processing/p5.js-sound), 在 Amanda Yeh 的 HTML5 Canvas 上.


## Experiments on Codepen

- [SVG Animated Drum Kit](http://codepen.io/iamjoshellis/full/KVdQqm/) - 播放由@iamjoshellis 制作的由 SVG 和逼真的声音制作的精彩鼓.
- [SVG Animated Guitar](http://codepen.io/iamjoshellis/full/qbBKZB/) - 弹奏用 SVG 和@iamjoshellis 制作的逼真的声音制作的神奇吉他.
- [Audio Visualizer](http://codepen.io/Francext/full/yIogq/) - Francesco Trillini 使用 Three.js 的抽象音频可视化器
- [Awesome Audio Player](http://codepen.io/alexpierre/full/RNELPV/) - 径向音频播放器由 Alex Permyakov 的频率和振幅线构建
- [Wireframes](http://codepen.io/pat_hg/full/gamQwr/) - 使用 Three.js 的线框 WebGL 动画，作者：Patrick Heng
- [Soundcloud Vinyl Search](http://codepen.io/chrisgannon/full/GpwqgG/) - Chris Gannon 使用 DrawSVG 和 GSAP 创建逼真的 Vinyl 播放器的惊人实验.
- [Gooey Effect Audio](http://codepen.io/enjikaka/full/QbJmRJ/) - 上传您的 mp3 并使用 Jeremy Karlsson 的这种疯狂效果可视化歌曲.
- [CSS Audio Visualizer](http://codepen.io/njmcode/full/WbWyWz/) - 使用来自隐藏视频的音频数据来应用 Neil McCallion 的 CSS 缩放.
- [Storytelling with Html5 + CSS3](http://codepen.io/rachelnabors/full/rCost/) - 一个很好的例子，说明如何使用音乐来创作 Rachel Nabors 的讲故事.
- [Step sequencer](http://codepen.io/woodwork/full/rxrLqa/) - 使用 Joe Harry 的音序器创作音乐.
- [WebGL Soundcloud Visualizer using Three.js](http://codepen.io/luigimannoni/full/xbLgqB) - ThreeJS/WebGL Soundcloud 播放器/可视化器，基于 Luigi Mannoni 的 HTML5 AudioContext API.
- [Oscilator](http://codepen.io/easwee/pen/sFpmo) - 通过 Anej Gorkič 从 HTML5 音频 API 测试振荡器节点.
- [Cubes Audio Visualizer](http://codepen.io/pat_hg/pen/zvMrRJ) - Patrick Heng 为 codevember 2015 做出的第 10 次贡献.
- [P5 Audio Tests 33](http://codepen.io/laurent-thevenet/pen/JGeXNr) - 使用 p5.js 3D 元素和 Soundcloud API 的音频可视化
- [P5 Audio Tests 27](http://codepen.io/laurent-thevenet/pen/MKJwVd) - 使用 p5.js 3D 元素和 Soundcloud API 的音频可视化
- [CircleLineNERDDISCO](http://codepen.io/TimPietrusky/full/jrPRZR) - 音频可视化与惊人的分析器，由 Tim Pietrusky 提供.
- [Clubberize yin yang example](http://codepen.io/wizgrav/pen/PWKNmg) - 使用 clubberize 助手轻松将 clubber.js 集成到 javascript 应用程序中的示例.

## Libraries Audio

- [web-audio-analyser](https://github.com/hughsk/web-audio-analyser)  - 一个围绕 Web Audio API 的薄包装器<audio>元素并返回给你它的波形/频率数据.
- [web-audio-player](https://github.com/Jam3/web-audio-player) - 跨浏览器网络音频播放器.
- [web-media-playback](https://github.com/hughsk/web-media-playback) - 检索有关在浏览器中播放的音频或视频的播放和缓冲信息.
- [Pizzicato.js](https://alemangui.github.io/pizzicato/) - 简化您通过网络音频 API 创建和操作声音的方式.
- [ThreeAudio.js](https://github.com/unconed/ThreeAudio.js) - 帮助您在 Three.js 或 tQuery 中创建音乐可视化.
- [Beeplay.js](https://watilde.github.io/beeplay/) - 用 Ja​​vaScript 写一首歌.
- [MIDI.js](https://github.com/mudcube/MIDI.js/) - 让生活更轻松地在网络上创建 MIDI 应用程序.
- [Beep.js](https://github.com/stewdio/beep.js) - 用于构建基于浏览器的合成器的 JavaScript 工具包.
- [p5.sound](https://github.com/processing/p5.js-sound) - 将处理方法引入网络音频和 p5.js.
- [Audiolet](https://www.jhtrnr.com/Audiolet/) - 用于实时音频合成和合成的 JavaScript 库.
- [coffee-collider](https://www.npmjs.com/package/coffee-collider) - 一种用于 HTML5 中实时音频合成和算法组合的语言.
- [audio-render](https://github.com/audio-lab/render) - 一个直通音频流，提供渲染流音频数据的结构.
- [Octavian](https://github.com/stevekinney/octavian) - 推理音符、频率和音程的实用程序
- [waveform-data](https://www.npmjs.com/package/waveform-data) - 音频波形数据操作 API – 在 JavaScript 中重新采样、偏移和分段波形数据.
- [audiowaveform](https://github.com/bbc/audiowaveform) - C++ 程序，用于从音频文件生成波形数据和渲染波形图像.
- [Aubio](https://aubio.org) - 用于实时音频标记的 C 库，具有 Python 和 PD 的绑定，支持 ofx 和 Vamp.
- [audio](https://github.com/go-audio/audio) - 通用 Go 包旨在定义一个通用接口来分析和/或处理音频数据
- [wav](https://github.com/go-audio/wav) - 经过实战测试的 Wav 解码器/编码器
- [standardized-audio-context](https://github.com/chrisguttandin/standardized-audio-context) - 旨在严格遵循标准的 AudioContext 的跨浏览器实现.
- [web-audio-beat-detector](https://github.com/chrisguttandin/web-audio-beat-detector) - 使用 Web Audio API 的节拍检测实用程序.
- [meyda](https://github.com/meyda/meyda) - JavaScript 的音频特征提取.


## Libraries Visualization

- [p5.js](http://p5js.org/) - 基于 Processing 的核心原则，用于创建图形和交互体验的 JavaScript 库.
- [Pixi.js](https://github.com/pixijs/pixi.js/)  - 适用于所有设备的快速轻量级 2D 库.  Pixi 渲染器让每个人都可以在不了解 WebGL 的情况下享受硬件加速的强大功能.
- [sketch.js](http://soulwire.github.io/sketch.js/) - 让您直接进入创意编码的有趣部分，而无需担心垫片或样板代码.
- [three.js](http://threejs.org/) - Three.js 是一个使 WebGL 易于使用的库.
- [Two.js](https://jonobr1.github.io/two.js/)  - 面向现代网络浏览器的二维绘图 API. 它与渲染器无关，使相同的 API 可以在多个上下文中绘制：SVG、Canvas 和 WebGL.
- [BabylonJS](http://babylonjs.com/) - 一个完整的 JavaScript 框架，用于使用 HTML5、WebGL 和 Web Audio 构建 3D 游戏.
- [Web Audio Extension](https://github.com/spite/WebAudioExtension) - 用于播放网络音频的 Chrome 扩展.
- [Cinder](https://libcinder.org/) - 社区开发的免费开源库，用于使用 C++ 进行专业品质的创意编码.
- [Processing](https://www.processing.org/) - 为电子艺术、新媒体艺术和视觉设计社区构建的开源编程语言和集成开发环境.
- [HYPE_processing](http://www.hypeframework.org/) - 使用最少量的代码编写执行繁重任务的处理类集合.
- [The Force](https://github.com/shawnlawson/The_Force) - Live coded shader editing with audio input.
- [Hylogen](https://github.com/sleexyz/hylogen) - 嵌入 Haskell 的纯功能语言，用于片段着色器（带音频输入）的表达性实时编码.
- [Peaks.js](https://www.npmjs.com/package/peaks.js) - 模块化客户端 JavaScript 组件，设计用于在浏览器中显示音频波形材料并与之交互.
- [Clubber.js](https://github.com/wizgrav/clubber) - 音乐理论在音频反应可视化中的应用.
- [Vuo](https://vuo.org) — 用于交互式媒体的实时可视化编程语言.
- [wavesurfer.js](https://wavesurfer-js.org/) - 可自定义的音频波形可视化，建立在 Web Audio API 和 HTML5 Canvas 之上
- [wavebell](https://github.com/skylerlee/wavebell) - 带有实时波形的javascript录音机，使用网络麦克风
- [Circular Audio Wave](https://github.com/kelvinau/circular-audio-wave) - 一个使用 Web Audio API 和 ECharts 实现圆波音频可视化的 JS 库
- [Slang](https://github.com/kylestetz/slang) - 一种内置在 JS 中的音频编程语言
- [audioMotion-analyzer](https://www.npmjs.com/package/audiomotion-analyzer) - 无依赖的高分辨率实时音频频谱分析仪JS模块.
- [Cava](https://github.com/karlstav/cava#latency-notes) - 跨平台终端可视化工具. 
- [Muser](https://jonshamir.github.io/muser/) - 使用机器学习增强浏览器中的音乐可视化. 

## People to Follow
- [Aaron Koblin](http://www.aaronkoblin.com/) - 专注于数据和数字技术的艺术家、设计师、程序员和企业家.
- [Joshua Davis](http://www.joshuadavis.com/) - 美国新媒体设计师、技术专家、作家和艺术家.
- [Robert Hodgin](http://roberthodgin.com/)  - 居住在布鲁克林的创意程序员.  Cinder C++ 的联合创始人.
- [Seb Lee-Delisle](http://seb.ly/) - 屡获殊荣的数字艺术家和演讲者.
- [Raven Kwok](http://ravenkwok.com/) - 视觉艺术家、动画师和创意程序员.
- [Chris Wilson](https://github.com/cwilso/) - Open Web Guy，以前在微软工作，现在在谷歌担任开发者倡导者.
- [Jason Sigal](https://github.com/therewasaguy) - 纽约大学常驻创意编码员和 p5.js 网络音频库的创建者.
- [Shawn Lawson](http://shawnlawson.com/) - 创造计算崇高的体验媒体艺术家.
- [Matt DesLauriers](https://github.com/mattdesl) - Jam 3 的创意编码器.
- [Patrick Heng](http://hengpatrick.fr/)  - 富有创意的前端开发人员. 曾就读于 Hetic 和 Gobelins，并在 Grouek 工作.
- [Mat Preziotte](https://preziotte.com/) - 荒谬的音乐可视化和生成艺术.
- [Yannis Gravezas](https://github.com/wizgrav) - 一个创意编码员，在 chrome experiments、fwa 和其他地方有几个项目.

## Tutorials

- [Kadenze - Courses about Sound and Creative Process](https://www.kadenze.com/courses)
- [MDN - Basic concepts behind Web Audio API](https://developer.mozilla.org/en-US/docs/Web/API/Web_Audio_API/Basic_concepts_behind_Web_Audio_API)
- [Understanding AudioParams: Precision control of web audio nodes](http://www.soundesign.info/2016/02/07/understanding-audioparams-precision-control-web-audio-nodes/)
- [Making An Interactive Music Video With WebGL](https://medium.com/@superhighfives/making-a-music-video-f60757ceb4cf#.j72rbcxgk)
- [Exploring the web audio api with d3](http://blog.scottlogic.com/2016/01/06/audio-api-with-d3.html)
- [Getting Started with Web Audio API](http://www.html5rocks.com/en/tutorials/webaudio/intro/)
- [14 essential JavaScript audio libraries for web developers](http://codecall.net/2014/01/29/14-essential-javascript-audio-libraries-for-web-developers/)
- [Learning Web Audio API](http://blog.sonoport.com/post/120993888887/learningwebaudioapi)
- [Fun with Web Audio API](http://codepen.io/DonKarlssonSan/post/fun-with-web-audio-api)
- [The Audio Processing Dog House](https://www.objc.io/issues/24-audio/audio-dog-house/)
- [Web Audio School](http://mmckegg.github.io/web-audio-school/)
- [Audio visualisation with the web audio api](http://fourthof5.com/audio-visualisation-with-the-web-audio-api)
- [Make Your Browser Dance](https://24ways.org/2013/make-your-browser-dance/)
- [Audio Visualization with Web Audio and Three.js](http://raathigesh.com/Audio-Visualization-with-Web-Audio-and-ThreeJS/)
- [Applying Web Audio API with the HTML5 Canvas Element - Part I](https://sonoport.github.io/web-audio-and-canva-partI.html)
- [Applying Web Audio API with the HTML5 Canvas Element - Part II](https://sonoport.github.io/web-audio-and-canva-partII.html)
- [Real-time analysis of streaming audio data with Web Audio API](http://ianreah.com/2013/02/28/Real-time-analysis-of-streaming-audio-data-with-Web-Audio-API.html)
- [Syncing CSS Animations with HTML5 Audio](http://www.sitepoint.com/syncing-css-animations-with-html5-audio/)
- [Javascript Systems Music - Learning Web Audio by Recreating The Works of Steve Reich and Brian Eno](http://teropa.info/blog/2016/07/28/javascript-systems-music.html)
- [Creative Audio Visualizers](https://tympanus.net/codrops/2018/03/06/creative-audio-visualizers/?utm_source=feedburner&utm_medium=feed&utm_campaign=Feed%3A+tympanus+%28Codrops%29)
- [Recreating legendary 8-bit games music with Web Audio API](https://codepen.io/gregh/post/recreating-legendary-8-bit-games-music-with-web-audio-api)
- [Visualizing sound in Go with SDL](https://mlesniak.com/post/2018/09/13/go-guitar-/-visualize-sound/)

## Videos

- [Matt McKegg: I Play The JavaScript - JSConf.Asia 2015](https://www.youtube.com/watch?v=NL0nb8A8FDM)
- [Chris Lowis: A Brief History of Synthesis with the Web Audio API](https://www.youtube.com/watch?v=d8TCq0xLnV4)
- [Introducing the Web Audio API](https://www.youtube.com/watch?v=_ZUhicr-R-g)
- [CorkDev.IO - HTML 5 Web Audio API](https://www.youtube.com/watch?v=vIKijPAW9Js)
- [Steve Kinney: Building a musical instrument with the Web Audio API | JSConf US 2015](https://www.youtube.com/watch?v=56spBAgOYfg)
- [Making the Web Rock: The Web Audio API](https://www.youtube.com/watch?v=wZrNI-86zYI)
- [Jordan Santell: Signal Processing with the Web Audio API - JSConf2014](https://www.youtube.com/watch?v=YBQ5pzvgbOE)
- [Making waves using the Web Audio API](https://www.youtube.com/watch?v=oHBx_kMmsRE)
- [Stuart Memo: JavaScript is the new Punk Rock](https://www.youtube.com/watch?v=PN8Eg1K9xjE)
- [Jan Krutisch: JavaScript Patterns For Contemporary Dance Music -- JSConf EU 2013](https://www.youtube.com/watch?v=X41IwSyU-BM)
- [Charlie Roberts: Gibbering at Algoraves - JS in Live Audiovisual Performances - JSConf.Asia 2014](https://www.youtube.com/watch?v=2BIOINFSbMg)
- [Lauren McCarthy: Learning while making p5js](https://www.youtube.com/watch?v=1k3X4DLDHdc)
- [Interactive Music with Tone.js](http://medias.ircam.fr/x9d4352)
- [Web Audio API vs Native: Closing the Gap](http://medias.ircam.fr/x2af2f6)
- [BRAID: A Web Audio Instrument Builder with Embedded Code Blocks](http://medias.ircam.fr/xa87b09)
- [Web Audio Tools](http://medias.ircam.fr/x32ba00)
- [HTML5DevConf: Jordan Santell, "Browser Dance Party: Visualizing Audio with the Web Audio API"](https://www.youtube.com/watch?v=TdgBAhGmoH4)
- [Praveen Kumar - MIDI.js](https://www.youtube.com/watch?v=xw86fXq2cKM)
- [Mathieu 'p01' Henri: Making Realtime Audio-Visuals - JSConf.Asia 2015](https://www.youtube.com/watch?v=16oLi1kvLHs)
- [Paul Adenot: Elements of Dance Music - JSConf.Asia 2015](https://www.youtube.com/watch?v=Ww0jTafmd_w)
- [8-bit Music Theory](https://www.youtube.com/channel/UCeZLO2VgbZHeDcongKzzfOw)

## Contributing

随时欢迎您的贡献！ [Click here to read the guidelines](https://github.com/willianjusten/awesome-audio-visualization/blob/master/Contributing.md).

## Authors

| ![Willian Justen](https://avatars2.githubusercontent.com/u/3991845?v=3&s=150)                | ![Luis Henrique](https://avatars2.githubusercontent.com/u/12835911?v=3&s=150) | ![Márcio Ribeiro](https://avatars3.githubusercontent.com/u/13159727?v=3&s=150)
|:---------------------:|:-------------------:|:-------------------:|
|  [Willian Justen](https://github.com/willianjusten/)   |     [Luis Henrique](https://github.com/lhbzr)    |    [Márcio Ribeiro](https://github.com/marcioshiz)

## License

[![CC0](https://i.creativecommons.org/l/by/4.0/88x31.png)](http://creativecommons.org/licenses/by/4.0/)

在法律允许的范围内， [Willian Justen](http://github.com/willianjusten) 已放弃该作品的所有版权和相关或邻接权.
