<div class="github-widget" data-repo="paragonie/awesome-appsec"></div>
## Awesome AppSec [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

用于了解应用程序安全性的精选资源列表. 包含书籍，
网站、博客文章和自我评估测验.

维护者 [Paragon Initiative Enterprises](https://paragonie.com) 和
来自应用程序安全和开发人员社区的贡献. 我们也
have [other community projects](https://paragonie.com/projects) 这可能是
对未来的应用程序安全专家很有用.

如果您是软件安全主题的绝对初学者，您可能会受益
从阅读 [A Gentle Introduction to Application Security](https://paragonie.com/blog/2015/08/gentle-introduction-application-security).

## Contributing

[Please refer to the contributing guide for details](https://github.com/paragonie/awesome-appsec/blob/master/CONTRIBUTING.md).

## Application Security Learning Resources


      * [How to Safely Generate a Random Number](#how-to-safely-generate-a-random-number-2014) (2014)
      * [Salted Password Hashing - Doing it Right](#salted-password-hashing-doing-it-right-2014) (2014)
      * [A good idea with bad usage: /dev/urandom](#a-good-idea-with-bad-usage-devurandom-2014) (2014)
      * [Why Invest in Application Security?](#why-invest-in-application-security-2015) (2015)
      * [Be wary of one-time pads and other crypto unicorns](#be-wary-of-one-time-pads-and-other-crypto-unicorns-2015) (2015)
      * [Web Application Hacker's Handbook](https://github.com/paragonie/awesome-appsec/blob/master/#-web-application-hackers-handbook-2011) (2011) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Cryptography Engineering](https://github.com/paragonie/awesome-appsec/blob/master/#-cryptography-engineering-2010) (2010) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Securing DevOps](https://github.com/paragonie/awesome-appsec/blob/master/#-securing-devops-2018) (2018) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Gray Hat Python: Programming for Hackers and Reverse Engineers](https://github.com/paragonie/awesome-appsec/blob/master/#-gray-hat-python-programming-for-hackers-and-reverse-engineers-2009) (2009) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [The Art of Software Security Assessment: Identifying and Preventing Software Vulnerabilities](https://github.com/paragonie/awesome-appsec/blob/master/#-the-art-of-software-security-assessment-identifying-and-preventing-software-vulnerabilities-2006) (2006) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [C Interfaces and Implementations: Techniques for Creating Reusable Software](https://github.com/paragonie/awesome-appsec/blob/master/#-c-interfaces-and-implementations-techniques-for-creating-reusable-software-1996) (1996) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Reversing: Secrets of Reverse Engineering](https://github.com/paragonie/awesome-appsec/blob/master/#-reversing-secrets-of-reverse-engineering-2005) (2005) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [JavaScript: The Good parts](https://github.com/paragonie/awesome-appsec/blob/master/#-javascript-the-good-parts-2008) (2008) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Windows Internals: Including Windows Server 2008 and Windows Vista, Fifth Edition ](https://github.com/paragonie/awesome-appsec/blob/master/#-windows-internals-including-windows-server-2008-and-windows-vista-fifth-edition-2007) (2007) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [The Mac Hacker's Handbook](https://github.com/paragonie/awesome-appsec/blob/master/#-the-mac-hackers-handbook-2009) (2009) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [The IDA Pro Book: The Unofficial Guide to the World's Most Popular Disassembler](https://github.com/paragonie/awesome-appsec/blob/master/#-the-ida-pro-book-the-unofficial-guide-to-the-worlds-most-popular-disassembler-2008) (2008) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Internetworking with TCP/IP Vol. II: ANSI C Version: Design, Implementation, and Internals (3rd Edition)](https://github.com/paragonie/awesome-appsec/blob/master/#-internetworking-with-tcpip-vol-ii-ansi-c-version-design-implementation-and-internals-3rd-edition-1998) (1998) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Network Algorithmics,: An Interdisciplinary Approach to Designing Fast Networked Devices](https://github.com/paragonie/awesome-appsec/blob/master/#-network-algorithmics-an-interdisciplinary-approach-to-designing-fast-networked-devices-2004) (2004) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Computation Structures (MIT Electrical Engineering and Computer Science)](https://github.com/paragonie/awesome-appsec/blob/master/#-computation-structures-mit-electrical-engineering-and-computer-science-1989) (1989) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Surreptitious Software: Obfuscation, Watermarking, and Tamperproofing for Software Protection](https://github.com/paragonie/awesome-appsec/blob/master/#-surreptitious-software-obfuscation-watermarking-and-tamperproofing-for-software-protection-2009) (2009) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Secure Programming HOWTO](#secure-programming-howto-2015) (2015)
      * [Security Engineering - Second Edition](#security-engineering-second-edition-2008) (2008)
      * [Bulletproof SSL and TLS](https://github.com/paragonie/awesome-appsec/blob/master/#-bulletproof-ssl-and-tls-2014) (2014) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Holistic Info-Sec for Web Developers (Fascicle 0)](#holistic-info-sec-for-web-developers-fascicle-0-2016) (2016)
        * [Cossack Labs blog](#cossack-labs-blog-2018) (2018)
      * [SEI CERT Android Secure Coding Standard](#sei-cert-android-secure-coding-standard-2015) (2015)
      * [SEI CERT C Coding Standard](#sei-cert-c-coding-standard-2006) (2006)
      * [Defensive Coding: A Guide to Improving Software Security by the Fedora Security Team](#defensive-coding-a-guide-to-improving-software-security-by-the-fedora-security-team-2022) (2022)
      * [SEI CERT C++ Coding Standard](#sei-cert-c-coding-standard-2006-1) (2006)
      * [Security Driven .NET](https://github.com/paragonie/awesome-appsec/blob/master/#-security-driven-net-2015) (2015) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Clojure OWASP](#clojure-owasp-2020) (2020)
      * [Memory Security in Go - spacetime.dev](#memory-security-in-go-spacetime-dev-2017) (2017)
      * [SEI CERT Java Coding Standard](#sei-cert-java-coding-standard-2007) (2007)
      * [Secure Coding Guidelines for Java SE](#secure-coding-guidelines-for-java-se-2014) (2014)
      * [Node.js Security Checklist - Rising Stack Blog](#node-js-security-checklist-rising-stack-blog-2015) (2015)
      * [Awesome Electron.js hacking & pentesting resources](#awesome-electron-js-hacking-pentesting-resources-2020) (2020)
      * [Essential Node.js Security](https://github.com/paragonie/awesome-appsec/blob/master/#-essential-node-js-security-2017) (2017) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Security Training by ^Lift Security](https://github.com/paragonie/awesome-appsec/blob/master/#-security-training-by-lift-security) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Security Training from BinaryMist](https://github.com/paragonie/awesome-appsec/blob/master/#-security-training-from-binarymist) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [It's All About Time](#its-all-about-time-2014) (2014)
      * [Secure Authentication in PHP with Long-Term Persistence](#secure-authentication-in-php-with-long-term-persistence-2015) (2015)
      * [20 Point List For Preventing Cross-Site Scripting In PHP](#20-point-list-for-preventing-cross-site-scripting-in-php-2013) (2013)
      * [25 PHP Security Best Practices For Sys Admins](#25-php-security-best-practices-for-sys-admins-2011) (2011)
      * [PHP data encryption primer](#php-data-encryption-primer-2014) (2014)
      * [Preventing SQL Injection in PHP Applications - the Easy and Definitive Guide](#preventing-sql-injection-in-php-applications-the-easy-and-definitive-guide-2014) (2014)
      * [You Wouldn't Base64 a Password - Cryptography Decoded](#you-wouldnt-base64-a-password-cryptography-decoded-2015) (2015)
      * [A Guide to Secure Data Encryption in PHP Applications](#a-guide-to-secure-data-encryption-in-php-applications-2015) (2015)
      * [The 2018 Guide to Building Secure PHP Software](#the-2018-guide-to-building-secure-php-software-2017) (2017)
      * [Securing PHP: Core Concepts](https://github.com/paragonie/awesome-appsec/blob/master/#-securing-php-core-concepts) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [SEI CERT Perl Coding Standard](#sei-cert-perl-coding-standard-2011) (2011)
      * [Black Hat Python: Python Programming for Hackers and Pentesters](https://github.com/paragonie/awesome-appsec/blob/master/#-black-hat-python-python-programming-for-hackers-and-pentesters) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [Violent Python](https://github.com/paragonie/awesome-appsec/blob/master/#-violent-python) ![nonfree](https://raw.githubusercontent.com/paragonie/awesome-appsec/master/img/nonfree.png)
      * [OWASP Python Security Wiki](#owasp-python-security-wiki-2014) (2014)
      * [Secure Ruby Development Guide](#secure-ruby-development-guide-2014) (2014)


## General

## Articles

### [How to Safely Generate a Random Number](http://sockpuppet.org/blog/2014/02/25/safely-generate-random-numbers/) (2014)

**发布**：2014 年 2 月 25 日

关于加密安全伪随机数生成器的建议.

### [Salted Password Hashing - Doing it Right](https://crackstation.net/hashing-security.htm) (2014)

**发布**：2014 年 8 月 6 日

上的一个帖子 [Crackstation](https://crackstation.net), 一个项目 [Defuse Security](https://defuse.ca)

### [A good idea with bad usage: /dev/urandom](http://insanecoding.blogspot.co.uk/2014/05/a-good-idea-with-bad-usage-devurandom.html) (2014)

**发布**：2014 年 5 月 3 日

提到了许多使 Linux/BSD 上的 `/dev/urandom` 失败的方法.

### [Why Invest in Application Security?](https://paragonie.com/white-paper/2015-why-invest-application-security) (2015)

**发布**：2015 年 6 月 21 日

经营企业需要有成本意识并尽量减少不必要的支出. 大多数公司都看不到确保应用程序安全的好处，因此他们常常忽视投资安全软件开发作为一种节省成本的措施. 这些公司没有意识到可预防的数据泄露可能导致的潜在成本（财务和品牌声誉）.

**平均数据泄露造成数百万美元的损失.**

对于大多数公司来说，投入更多的时间和人员来开发安全软件是值得的，可以将这种不必要的风险降至最低.

### [Be wary of one-time pads and other crypto unicorns](https://freedom-to-tinker.com/blog/jbonneau/be-wary-of-one-time-pads-and-other-crypto-unicorns/) (2015)

**发布**：2015 年 3 月 25 日

对于希望构建自己的密码学功能的任何人来说都是**必读**.

## Books


**发布**：2011 年 9 月 27 日

 Web 应用程序安全性的精彩介绍； 虽然有点过时了.


**发布**：2010 年 3 月 15 日

在展示密码设计技术时培养职业偏执感.


**发布**：2018 年 3 月 1 日

保护 DevOps 探讨了如何将 DevOps 和安全技术结合起来使云服务更安全. 这本介绍性书籍回顾了用于保护 Web 应用程序及其基础架构的最先进实践，并教您将安全性直接集成到您的产品中的技术.


**发布**：2009 年 5 月 3 日




**发布**：2006 年 11 月 30 日




**发布**：1996 年 8 月 30 日




**发布**：2005 年 4 月 15 日




**发布**：2008 年 5 月 1 日




**发布**：2007 年 6 月 17 日




**发布**：2009 年 3 月 3 日




**发布**：2008 年 8 月 22 日




**发布**：1998 年 6 月 25 日




**发布**：2004 年 12 月 29 日




**发布**：1989 年 12 月 13 日




**发布**：2009 年 8 月 3 日



### [Secure Programming HOWTO](http://www.dwheeler.com/secure-programs/) (2015)

**发布**：2015 年 3 月 1 日



### [Security Engineering - Second Edition](https://www.cl.cam.ac.uk/~rja14/book.html) (2008)

**发布**：2008 年 4 月 14 日




**Released**: August 1, 2014



### [Holistic Info-Sec for Web Developers (Fascicle 0)](https://leanpub.com/holistic-infosec-for-web-developers) (2016)

**发布**：2016 年 9 月 17 日

系列丛书分为三部分，第一部分广泛而深入地介绍了 Web 开发人员和架构师需要了解的内容，以便创建稳健、可靠、可维护和安全的软件、网络和其他，这些软件、网络和其他软件、网络和其他软件、网络和其他软件、网络和其他软件、网络和其他软件、网络和其他软件、网络和其他软件、网络和其他软件、网络和其他软件、没有令人讨厌的惊喜.

### [Holistic Info-Sec for Web Developers (Fascicle 1)](https://leanpub.com/holistic-infosec-for-web-developers-fascicle1-vps-network-cloud-webapplications)

由三部分组成的系列丛书的第二部分广泛而深入地介绍了 Web 开发人员和架构师需要了解的内容，以便创建健壮、可靠、可维护和安全的软件、VPS、网络、云和 Web 应用程序，交付连续，准时，没有令人讨厌的惊喜.

## Classes

### [Offensive Computer Security (CIS 4930) FSU](https://www.cs.fsu.edu/~redwood/OffensiveComputerSecurity/)

佛罗里达州立大学的欧文·雷德伍德 (Owen Redwood) 开设的漏洞研究和利用开发课程. 

**一定要检查 [lectures](https://www.cs.fsu.edu/~redwood/OffensiveComputerSecurity/lectures.html)!**

### [Hack Night](https://github.com/isislab/Hack-Night)

 Hack Night 是根据 NYU Poly 的旧渗透测试和漏洞分析课程的材料开发的，是对攻击性安全的清醒介绍. 在 13 周内向学生介绍各种复杂和身临其境的主题时，很快就会涵盖许多复杂的技术内容.

## Websites

### [Hack This Site!](http://www.hackthissite.org)

通过尝试破解此网站来了解应用程序安全性.

### [Enigma Group](http://www.enigmagroup.org)

黑客和安全专家前来培训的地方.

### [Web App Sec Quiz](https://timoh6.github.io/WebAppSecQuiz/)

Web 应用程序安全性自我评估测验

### [SecurePasswords.info](https://securepasswords.info)

多种语言/框架的安全密码.

### [Security News Feeds Cheat-Sheet](http://lzone.de/cheat-sheet/Security-News-Feeds)

安全新闻来源列表.

### [Open Security Training](http://opensecuritytraining.info/)

有关低级 x86 编程、黑客攻击和取证的视频课程.

### [MicroCorruption](https://microcorruption.com/login)

夺旗 - 学习组装和嵌入式设备安全

### [The Matasano Crypto Challenges](http://cryptopals.com)

自学密码学的一系列编程练习 [Matasano Security](http://matasano.com). [The introduction](https://blog.pinboard.in/2013/04/the_matasano_crypto_challenges) 由 Maciej Ceglowski 解释得很好.

### [PentesterLab](https://pentesterlab.com)

PentesterLab 提供 [free Hands-On exercises](https://pentesterlab.com/exercises/) 和一个 [bootcamp](https://pentesterlab.com/bootcamp/) 开始.

### [Juice Shop](https://bkimminich.github.io/juice-shop)

故意不安全的 Javascript Web 应用程序.

### [Supercar Showdown](http://hackyourselffirst.troyhunt.com/)

如何抢在网络攻击者之前进攻.

### [OWASP NodeGoat](https://github.com/owasp/nodegoat)

故意容易受到 OWASP Top 10 Node.JS Web 应用程序的攻击， [tutorials](https://nodegoat.herokuapp.com/tutorial), [security regression testing with the OWASP Zap API](https://github.com/OWASP/NodeGoat/wiki/NodeGoat-Security-Regression-tests-with-ZAP-API), [docker image](https://github.com/owasp/nodegoat#option-3---run-nodegoat-on-docker) . 有几个选项可以快速启动和运行.

### [Securing The Stack](https://securingthestack.com)

双周 Appsec 教程

### [OWASP ServerlessGoat](https://www.owasp.org/index.php/OWASP_Serverless_Goat)

OWASP ServerlessGoat 是一个故意不安全的现实 AWS Lambda 无服务器应用程序，由 OWASP 维护并由 [PureSec](https://www.puresec.io/) . 您可以安装 WebGoat，了解漏洞、如何利用它们以及如何修复每个问题. 该项目还包括解释问题以及如何使用最佳实践解决问题的文档.

### Blogs

#### [Crypto Fails](http://cryptofails.com)

展示糟糕的密码学

#### [NCC Group - Blog](https://www.nccgroup.trust/us/about-us/newsroom-and-events/blog/)

NCC Group（前身为 Matasano、iSEC Partners 和 NGS Secure）的博客.

#### [Scott Helme](https://scotthelme.co.uk)

了解安全性和性能.

#### [Cossack Labs blog](https://www.cossacklabs.com/blog-archive/) (2018)

**发布**：2018 年 7 月 30 日

制作开源库和工具并描述应用程序和基础架构的实用数据安全方法的加密公司的博客.

### Wiki pages

#### [OWASP Top Ten Project](https://www.owasp.org/index.php/Category:OWASP_Top_Ten_Project)

Web 应用程序中发现的十大最常见和最严重的安全漏洞.

### Tools

#### [Qualys SSL Labs](https://www.ssllabs.com/)

臭名昭著的 SSL 和 TLS 工具套件.

#### [securityheaders.io](https://securityheaders.io/)

快速轻松地评估 HTTP 响应标头的安全性.

#### [report-uri.io](https://report-uri.io)

免费的 CSP 和 HPKP 报告服务.

#### [clickjacker.io](https://clickjacker.io)

测试并学习点击劫持. 制作点击劫持 PoC，截图并分享链接. 您可以测试 HTTPS、HTTP、内联网和内部站点.

## AWS Lambda

## Tools

### [PureSec FunctionShield](https://www.puresec.io/function-shield)

FunctionShield 是一个 100% 免费的 AWS Lambda 安全和 Google Cloud Functions 安全库，它使开发人员能够轻松地对无服务器运行时实施严格的安全控制.

## Android

## Books and ebooks

### [SEI CERT Android Secure Coding Standard](https://www.securecoding.cert.org/confluence/display/android/Android+Secure+Coding+Standard) (2015)

**发布**：2015 年 2 月 24 日

一个由社区维护的 Wiki，详细介绍了 Android 开发的安全编码标准.

## C

## Books and ebooks

### [SEI CERT C Coding Standard](https://www.securecoding.cert.org/confluence/display/c/SEI+CERT+C+Coding+Standard) (2006)

**发布**：2006 年 5 月 24 日

社区维护的 Wiki，详细介绍了 C 编程的安全编码标准.

### [Defensive Coding: A Guide to Improving Software Security by the Fedora Security Team](https://docs.fedoraproject.org/en-US/Fedora_Security_Team/1/html/Defensive_Coding/index.html) (2022)

**发布**：2022 年 5 月 23 日

提供通过安全编码提高软件安全性的指南. 涵盖常见的编程语言和库，并侧重于具体建议.

## C++

## Books and ebooks

### [SEI CERT C++ Coding Standard](https://www.securecoding.cert.org/confluence/pages/viewpage.action?pageId=637) (2006)

**发布**：2006 年 7 月 18 日

社区维护的 Wiki，详细介绍了 C++ 编程的安全编码标准.

## C Sharp

## Books and ebooks


**发布**：2015 年 7 月 14 日

介绍针对 .NET Framework 4.5 版开发安全应用程序，特别涵盖密码学和安全工程主题.

## Clojure

## Repositories

### [Clojure OWASP](https://github.com/nubank/clj-owasp) (2020)

**发布**：2020 年 5 月 5 日

包含 OWASP 前 10 个漏洞的 Clojure 示例的存储库.

## Go

## Articles

### [Memory Security in Go - spacetime.dev](https://spacetime.dev/memory-security-go) (2017)

**发布**：2017 年 8 月 3 日

管理内存中敏感数据的指南.

## Java

## Books and ebooks

### [SEI CERT Java Coding Standard](https://www.securecoding.cert.org/confluence/display/java/SEI+CERT+Oracle+Coding+Standard+for+Java) (2007)

**发布**：2007 年 1 月 12 日

一个由社区维护的 Wiki，详细介绍了 Java 编程的安全编码标准.

### [Secure Coding Guidelines for Java SE](http://www.oracle.com/technetwork/java/seccodeguide-139067.html) (2014)

**发布**：2014 年 4 月 2 日

直接来自 Oracle 的安全 Java 编程指南.

## Node.js

## Articles

### [Node.js Security Checklist - Rising Stack Blog](https://blog.risingstack.com/node-js-security-checklist/) (2015)

**发布**：2015 年 10 月 13 日

涵盖了许多用于开发安全的 Node.js 应用程序的有用信息.

### [Awesome Electron.js hacking & pentesting resources](https://github.com/doyensec/awesome-electronjs-hacking) (2020)

**发布**：2020 年 6 月 17 日

用于保护基于 Electron.js 的应用程序的精选资源列表.

## Books and ebooks


**发布**：2017 年 7 月 19 日

动手实践并提供丰富的源代码，是保护 Node.js Web 应用程序的实用指南.

## Training


向带头的团队学习 [Node Security Project](https://nodesecurity.io)


我们运行多种类型的信息安全培训，涵盖物理、人员、VPS、网络、云、Web 应用程序. 大部分内容来源于 [book series](https://leanpub.com/b/holisticinfosecforwebdevelopers) 金已经工作了几年. 可以找到更多信息 [here](https://binarymist.io/#services)

## PHP

## Articles

### [It's All About Time](http://blog.ircmaxell.com/2014/11/its-all-about-time.html) (2014)

**发布**：2014 年 11 月 28 日

对 PHP 应用程序中的定时攻击的简单介绍

### [Secure Authentication in PHP with Long-Term Persistence](https://paragonie.com/blog/2015/04/secure-authentication-php-with-long-term-persistence) (2015)

**发布**：2015 年 4 月 21 日

讨论密码策略、密码存储、“记住我”cookie 和帐户恢复.

### [20 Point List For Preventing Cross-Site Scripting In PHP](http://blog.astrumfutura.com/2013/04/20-point-list-for-preventing-cross-site-scripting-in-php) (2013)

**发布**：2013 年 4 月 22 日

Padriac Brady 关于构建不易受 XSS 攻击的软件的建议

### [25 PHP Security Best Practices For Sys Admins](http://www.cyberciti.biz/tips/php-security-best-practices-tutorial.html) (2011)

**发布**：2011 年 11 月 23 日

尽管这篇文章已经有几年的历史了，但随着我们即将转向 PHP 7，它的大部分建议仍然适用.

### [PHP data encryption primer](https://timoh6.github.io/2014/06/16/PHP-data-encryption-cheatsheet.html) (2014)

**发布**：2014 年 6 月 16 日

@timoh6 explains implementing data encryption in PHP

### [Preventing SQL Injection in PHP Applications - the Easy and Definitive Guide](https://paragonie.com/blog/2015/05/preventing-sql-injection-in-php-applications-easy-and-definitive-guide) (2014)

**发布**：2014 年 5 月 26 日

**TL;DR** - 不要转义，而是使用准备好的语句！

### [You Wouldn't Base64 a Password - Cryptography Decoded](https://paragonie.com/blog/2015/08/you-wouldnt-base64-a-password-cryptography-decoded) (2015)

**发布**：2015 年 8 月 7 日

对常用的误用密码学术语和基本概念的人类可读概述，以及 PHP 示例代码.

如果您对密码学术语感到困惑，请从这里开始.

### [A Guide to Secure Data Encryption in PHP Applications](https://paragonie.com/white-paper/2015-secure-php-data-encryption) (2015)

**发布**：2015 年 8 月 2 日

讨论端到端网络层加密 (HTTPS) 以及静态数据安全加密的重要性，然后介绍开发人员针对特定用例应使用的特定加密工具，无论他们使用 [libsodium](https://pecl.php.net/package/libsodium), [Defuse Security's secure PHP encryption library](https://github.com/defuse/php-encryption), 或 OpenSSL.

### [The 2018 Guide to Building Secure PHP Software](https://paragonie.com/blog/2017/12/2018-guide-building-secure-php-software) (2017)

**发布**：2017 年 12 月 12 日

本指南应作为电子书的补充， [PHP: The Right Way](http://www.phptherightway.com)，非常强调安全性，而不是一般的 PHP 程序员主题（例如代码风格）.

## Books and ebooks


*保护 PHP：核心概念* 作为一些最常见的安全术语的指南，并在日常 PHP 中提供了一些示例.

### [Using Libsodium in PHP Projects](https://paragonie.com/book/pecl-libsodium)

您不需要应用密码学博士学位就可以构建安全的 Web 应用程序. 输入 libsodium，它允许开发人员开发快速、安全和可靠的应用程序，而无需知道什么是流密码.

## Useful libraries

### [defuse/php-encryption](https://github.com/defuse/php-encryption)

 PHP 应用程序的对称密钥加密库.  （**推荐**不要自己滚动！）

### [ircmaxell/password_compat](https://github.com/ircmaxell/password_compat)

如果您使用的是 PHP 5.3.7+ 或 5.4，请使用它来散列密码

### [ircmaxell/RandomLib](https://github.com/ircmaxell/RandomLib)

用于生成随机字符串或数字

### [thephpleague/oauth2-server](https://github.com/thephpleague/oauth2-server)

安全的 OAuth2 服务器实现

### [paragonie/random_compat](https://github.com/paragonie/random_compat)

 PHP 7 提供了一组新的 CSPRNG 函数：`random_bytes()` 和 `random_int()`. 这是社区在 PHP 5 项目（向前兼容层）中公开相同 API 的努力. 获得麻省理工学院许可.

### [psecio/gatekeeper](https://github.com/psecio/gatekeeper)

一个安全的身份验证和授权库，实现基于角色的访问控制和 Paragon Initiative Enterprises 的推荐 [secure "remember me" checkboxes](https://paragonie.com/blog/2015/04/secure-authentication-php-with-long-term-persistence#title.2).

### [openwall/phpass](http://www.openwall.com/phpass/)

用于 PHP 应用程序的便携式公共域密码哈希框架.

## Websites

### [websec.io](http://websec.io)

**websec.io** 致力于通过与一般安全基础知识、新兴技术和 PHP 特定信息相关的主题对开发人员进行安全教育

### Blogs

#### [Paragon Initiative Enterprises Blog](https://paragonie.com/blog/)

我们位于佛罗里达州奥兰多的技术和安全咨询公司的博客

#### [ircmaxell's blog](http://blog.ircmaxell.com)

关于 PHP、安全、性能和一般 Web 应用程序开发的博客.

#### [Pádraic Brady's Blog](http://blog.astrumfutura.com)

Pádraic Brady 是 Zend Framework 安全专家

### Mailing lists

#### [Securing PHP Weekly](http://securingphp.com)

关于 PHP、安全和社区的每周时事通讯.

## Perl

## Books and ebooks

### [SEI CERT Perl Coding Standard](https://www.securecoding.cert.org/confluence/display/perl/SEI+CERT+Perl+Coding+Standard) (2011)

**发布**：2011 年 1 月 10 日

一个由社区维护的 Wiki，详细介绍了 Perl 编程的安全编码标准.

## Python

## Books and ebooks

### [Python chapter of Fedora Defensive Coding Guide](https://docs.fedoraproject.org/en-US/Fedora_Security_Team/1/html/Defensive_Coding/chap-Defensive_Coding-Python.html)

列出了应该避免的标准库特性，并引用了其他章节中特定于 Python 的部分.


来自 NoStarch Press 的 Justin Seitz 的 Black Hat Python 是一本适合攻击性安全思想的好书


Violent Python 向您展示了如何从对攻击性计算概念的理论理解转变为实际实施.

## Websites

### [OWASP Python Security Wiki](https://github.com/ebranca/owasp-pysec/wiki) (2014)

**发布**：2014 年 6 月 21 日

由 OWASP Python 安全项目维护的 wiki.

## Ruby

## Books and ebooks

### [Secure Ruby Development Guide](https://docs.fedoraproject.org/en-US/Fedora_Security_Team/1/html/Secure_Ruby_Development_Guide/index.html) (2014)

**发布**：2014 年 3 月 10 日

 Fedora 安全团队编写的保护 Ruby 开发的指南. 也可在 [Github](https://github.com/jrusnack/secure-ruby-development-guide).
