<div class="github-widget" data-repo="SrinivasanTarget/awesome-appium"></div>
## Awesome Appium [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Build Status](https://travis-ci.org/SrinivasanTarget/awesome-appium.svg?branch=master)](https://travis-ci.org/SrinivasanTarget/awesome-appium)

[<img src="https://avatars3.githubusercontent.com/u/3221291?v=3&s=200" align="right" width="100">](http://appium.io)

&gt; 令人愉快的精选清单 [Appium](http://appium.io/) [resources](#contents).

随时通过 PR 和文件问题添加链接以开始讨论.

灵感来自 [awesome](https://github.com/sindresorhus/awesome) 列出事情.



## Server
- [Appium](https://github.com/appium/appium/blob/master/docs/en/about-appium/intro.md) - Appium 是一种开源、跨平台的测试自动化工具，适用于本机、混合和移动 Web 和桌面应用程序，在模拟器 (iOS)、模拟器 (Android) 和真实设备（iOS、Android、Windows、Mac）上进行了测试.

## Clients
- [Ruby](https://github.com/appium/ruby_lib)
- [Python](https://github.com/appium/python-client)
- [Java](https://github.com/appium/java-client)
- [JavaScript](http://webdriver.io/)
- [Objective C](https://github.com/appium/selenium-objective-c)
- [PHP](https://github.com/appium/php-client)
- [C# (.NET)](https://github.com/appium/appium-dotnet-driver)
- [RobotFramework](https://github.com/jollychang/robotframework-appiumlibrary)

## Inspectors
- [Appium Desktop](https://github.com/appium/appium-desktop) - 适用于 Mac、Windows 和 Linux 的桌面 GUI 中的 Appium 服务器和检查器.
- [WebDriverAgent Inspector](https://github.com/facebook/WebDriverAgent/wiki/Starting-WebDriverAgent) - 在模拟器内运行的 iOS WebDriver 服务器.
- [Selendroid Inspector](http://selendroid.io/inspector.html) - 嵌入在您的 selendroid 测试服务器中的网络应用程序.
- [Appium iOS Inspector](https://github.com/mykola-mokhnach/Appium-iOS-Inspector) - 基于原Selendroid Inspector源码的iOS元素定位工具.
- [app-inspector](https://github.com/macacajs/app-inspector) - Macacajs 应用程序检查器.

## Become an Appium Pro
- [Seeding the iOS simulator with test photos](https://appiumpro.com/editions/1)
- [Seeding an Android device with test photos](https://appiumpro.com/editions/2)
- [Running arbitrary ADB commands via Appium](https://appiumpro.com/editions/3)
- [Using Appium for Testing Mobile Web Apps](https://appiumpro.com/editions/4)
- [Performance Testing of Android Apps](https://appiumpro.com/editions/5)
- [Testing iOS App Upgrades](https://appiumpro.com/editions/6)
- [Speeding Up Tests With Deep Links](https://appiumpro.com/editions/7)
- [How to Find Elements in iOS (Not) By XPath](https://appiumpro.com/editions/8)
- [Testing Android App Upgrades](https://appiumpro.com/editions/9)
- [Anatomy of Logging in Appium](https://appiumpro.com/editions/10)
- [Simulating SMS Messages on Android](https://appiumpro.com/editions/11)
- [Capturing Performance Data for Native iOS Apps](https://appiumpro.com/editions/12)
- [Switching Between iOS Apps During a Test](https://appiumpro.com/editions/13)
- [How to Automate a Pop Rock Band](https://appiumpro.com/editions/14)
- [Testing iOS Push Notifications](https://appiumpro.com/editions/15)
- [Automating the Clipboard on iOS and Android](https://appiumpro.com/editions/16)
- [Automating Cross-Platform Hybrid Apps](https://appiumpro.com/editions/17)
- [Using Espresso With Appium](https://appiumpro.com/editions/18)
- [Making Your Appium Tests Fast and Reliable, Part 1: Test Flakiness](https://appiumpro.com/editions/19)
- [Making Your Appium Tests Fast and Reliable, Part 2: Finding Elements](https://appiumpro.com/editions/20)
- [Making Your Appium Tests Fast and Reliable, Part 3: Waiting for App States](https://appiumpro.com/editions/21)
- [Making Your Appium Tests Fast and Reliable, Part 4: Dealing With Unfindable Elements](https://appiumpro.com/editions/22)
- [Making Your Appium Tests Fast and Reliable, Part 5: Setting Up App State](https://appiumpro.com/editions/23)
- [Making Your Appium Tests Fast and Reliable, Part 6: Tuning Your Capabilities](https://appiumpro.com/editions/24)
- [Making Your Appium Tests Fast and Reliable, Part 7: Disabling Animations](https://appiumpro.com/editions/25)
- [Making Your Appium Tests Fast and Reliable, Part 8: Mocking External Services](https://appiumpro.com/editions/26)
- [Making Your Appium Tests Fast and Reliable, Part 9: When Things Go Wrong](https://appiumpro.com/editions/27)
- [Running Multiple Appium Tests in Parallel](https://appiumpro.com/editions/28)
- [Automating Complex Gestures with the W3C Actions API](https://appiumpro.com/editions/29)
- [iOS-Specific Touch Action Methods](https://appiumpro.com/editions/30)
- [Automating Custom Alert Buttons on iOS](https://appiumpro.com/editions/31)
- [Finding Elements By Image, Part 1](https://appiumpro.com/editions/32)
- [Finding Elements By Image, Part 2](https://appiumpro.com/editions/33)
- [Simulating Hardware Keys And Key Events On Android](https://appiumpro.com/editions/34)
- [Writing XPath Queries That Work](https://appiumpro.com/editions/35)
- [Using The 'nativeWebTap' Capability](https://appiumpro.com/editions/36)
- [Capturing Browser Errors and Logs in iOS Web/Hybrid Apps](https://appiumpro.com/editions/37)
- [Capturing Browser Errors and Logs in Android Web/Hybrid Apps](https://appiumpro.com/editions/38)
- [Early-Stage AI for Appium Test Automation](https://appiumpro.com/editions/39)
- [How To Test On Real iOS Devices With Appium, Part 1](https://appiumpro.com/editions/40)
- [How To Test Real iOS Devices With Appium, Part 2](https://appiumpro.com/editions/41)
- [Simulating Incoming Phone Calls On Android](https://appiumpro.com/editions/42)
- [How To Automatically Grant iOS App Permissions Using Appium](https://appiumpro.com/editions/43)
- [Working With Web Components (Shadow DOM)](https://appiumpro.com/editions/44)
- [How to Automate Siri Voice Commands Using Appium](https://appiumpro.com/editions/45)
- [Sending Arbitrary Keystrokes With The Actions API](https://appiumpro.com/editions/46)
- [Running Appium From Source (Or The Latest Beta)](https://appiumpro.com/editions/47)
- [How To Flash Elements On Screen While Debugging Appium Tests](https://appiumpro.com/editions/48)
- [How To Spread Some Holiday Cheer Using Appium](https://appiumpro.com/editions/49)
- [Special Capabilities for Speeding up Android Test Initialization](https://appiumpro.com/editions/50)
- [Calling Methods Inside Your App From Appium](https://appiumpro.com/editions/51)
- [Automating Mac Apps with Appium](https://appiumpro.com/editions/52)
- [Accessing Android Logcat Logs with Appium](https://appiumpro.com/editions/53)
- [Using Appium With Selenium Grid](https://appiumpro.com/editions/54)
- [Using Mobile Execution Commands to Continuously Stream Device Logs with Appium](https://appiumpro.com/editions/55)
- [What Appium Users Need to Know about Android Activities and Intents](https://appiumpro.com/editions/56)
- [How to Determine Element Locators For Mobile Web and Hybrid Apps](https://appiumpro.com/editions/57)
- [How to Test on Headless Emulators and Simulators with Appium](https://appiumpro.com/editions/58)
- [How to Automate Picker Wheel Controls](https://appiumpro.com/editions/59)
- [How to Pick the Right Locator Strategy](https://appiumpro.com/editions/60)
- [How to Accurately Select Webviews Using the fullContextList Capability](https://appiumpro.com/editions/61)
- [Capturing iOS Simulator Network Traffic with Appium](https://appiumpro.com/editions/62)
- [Capturing Android Emulator Network Traffic with Appium](https://appiumpro.com/editions/63)
- [Validating Android Toast Messages](https://appiumpro.com/editions/64)
- [Capturing Network Traffic in Java with Appium](https://appiumpro.com/editions/65)
- [Automating System Apps with Appium](https://appiumpro.com/editions/66)
- [Generating Touch Gestures to Zoom In and Out on Google Maps](https://appiumpro.com/editions/67)
- [Automating Physical Buttons on iOS Devices](https://appiumpro.com/editions/68)
- [Capturing Audio Output During Testing: Part 1](https://appiumpro.com/editions/69)
- [Capturing Audio Output During Testing: Part 2](https://appiumpro.com/editions/70)
- [Starting an Appium Server Programmatically Using AppiumServiceBuilder](https://appiumpro.com/editions/71)
- [Simulating Slow Internet Connections on Android Emulators with Appium](https://appiumpro.com/editions/72)
- [Working with Multile Webviews in Android Hybrid Apps](https://appiumpro.com/editions/73)
- [Automating Custom IoT Devices With Appium, Part 1](https://appiumpro.com/editions/74)
- [Automating Custom IoT Devices With Appium, Part 2](https://appiumpro.com/editions/75)
- [Testing React Native Apps with Appium](https://appiumpro.com/editions/76)
- [Optimizing WebDriverAgent Startup Performance](https://appiumpro.com/editions/77)
- [Attaching Appium Clients to Existing Sessions](https://appiumpro.com/editions/78)
- [Converting Java Tests to Kotlin](https://appiumpro.com/editions/79)
- [Testing iOS Face ID with Appium](https://appiumpro.com/editions/80)
- [Testing Windows Desktop Apps With Appium](https://appiumpro.com/editions/81)
- [Streaming Video from iOS Devices](https://appiumpro.com/editions/82)
- [Speeding Up Android Screenshots With MJPEG Servers](https://appiumpro.com/editions/83)
- [Reliably Opening Deep Links Across Platforms and Devices](https://appiumpro.com/editions/84)
- [Batching Appium Commands Using Execute Driver Script to Speed Up Tests](https://appiumpro.com/editions/85)
- [Connecting Directly to Appium Hosts in Distributed Environments](https://appiumpro.com/editions/86)
- [Working With Android 10](https://appiumpro.com/editions/87)
- [Saving Test Data To Make Debugging Easier Java](https://appiumpro.com/editions/88)
- [Understanding Appium Drivers (And How To Choose Which One To Use)](https://appiumpro.com/editions/89)
- [Optimizing Image Element Thresholds](https://appiumpro.com/editions/90)
- [Getting Started With Appium For Android On Windows](https://appiumpro.com/editions/91)
- [Using AI-based Object Detection For Finding Elements](https://appiumpro.com/editions/92)
- [Managing Chromedriver for Android Chrome and Webview Testing](https://appiumpro.com/editions/93)
- [Using the Appium Events API](https://appiumpro.com/editions/94)
- [The 'Android Data Matcher' Locator Strategy](https://appiumpro.com/editions/95)
- [Working With Cookies](https://appiumpro.com/editions/96)
- [Capturing App Launch Metrics On Android](https://appiumpro.com/editions/97)
- [Visual Testing With Appium, Part 1](https://appiumpro.com/editions/98)
- [Visual Testing With Appium, Part 2](https://appiumpro.com/editions/99)
- [Visual Testing With Appium, Part 3](https://appiumpro.com/editions/100)
- [AI for Appium--and Selenium!](https://appiumpro.com/editions/101)
- [Mobile App Performance Testing](https://appiumpro.com/editions/102)
- [Free Tools For Mobile App Performance Testing With Appium](https://appiumpro.com/editions/103)
- [Simulating Different Network Conditions For Virtual Devices](https://appiumpro.com/editions/104)
- [Paid Tools And Services For Mobile App Performance Testing](https://appiumpro.com/editions/105)

## Tutorials
- [TOOLSQA](http://toolsqa.com/mobile-automation/appium/appium-tutorial/) - 适用于初学者的 Appium 教程（Android 和 iOS）.
- [GURU99](http://www.guru99.com/introduction-to-appium.html) - 初学者的 Appium 教程.
- [QTPSELENIUM](http://qtpselenium.com/home/course/training/mobile-automation-appium-tutorial) - 应用教程.
- [Testing Diaries](http://www.testingdiaries.com/appium-tutorial/) - 完全初学者的 Appium 教程.
- [Appium Bootcamp](https://saucelabs.com/resources/articles/appium-bootcamp-chapter-1) - Sauce 的 Appium 训练营.
- [Appium Mobile Grid Setup](http://www.slideshare.net/justinison75/mobile-selenium-grid-setup) - 移动网格——Android 和 iOS 入门.
- [Selenium Camp 2016](http://www.slideshare.net/justinison75/selenium-camp-2016) - 2016 年硒营.

## Blogs
 - [All about Appium Desired Capabilities](https://caps.cloudgrey.io/) - 关于 Appium 所需的所有功能.
 - [Appium Architecture & Appium Desktop](https://www.zaizi.com/blog/appium-mobile-apps-automation-tool) - Appium 架构、设置等（更新）
 - [Appium Architecture](http://www.3pillarglobal.com/insights/appium-a-cross-browser-mobile-automation-tool) - Appium 的架构.
 - [All about Appium](https://en.wordpress.com/tag/appium/) - 关于 Wordpress 中的 Appium.
 - [Appium with Image Recognition](https://medium.com/@SimonKaz/appium-with-image-recognition-17a92abaa23d#.x19ffxwbk) - 具有图像识别功能的 Appium - Simon Kaz.
 - [Automate Android Actions using Appium](http://testingalert.com/automate-android-actions-using-appium/) - 使用 Appium 自动化 Android 操作 - kkashyap1707.
 - [Network Connection in Appium](https://medium.com/@eliasnogueira/how-to-deal-with-network-connection-in-appium-4-0-0-2134021fac25#.z5dfdv2jg) - 如何处理来自 Appium 4.0.0 的网络连接 - Elias Nogueira.
 - [How to change language in Appium](https://medium.com/@eliasnogueira/appium-tips-changing-the-app-language-f0a1762dd927#.68mvqisri) - Appium 技巧 — 更改应用程序语言 - Elias Nogueira.
 - [Automated UI testing of a UWP app using Appium](https://medium.com/@yostane/automated-ui-testing-of-a-uwp-app-using-appium-dc10d8df6631#.3efp60w1j) - Windows 应用程序驱动程序使用 Appium - Yassine benabbas 使 UWP 应用程序兼容.
 - [Context Switching in Appium](https://medium.com/@kevinmarkvi/switching-to-a-dynamically-named-context-handle-with-appium-and-java-c78d2b972eb6#.2ylda6ul6) 使用 Appium 和 Java 切换到动态命名的上下文句柄 - Kevin Berg.
 - [A Robot Should Be Running Your Appium Tests](https://medium.com/devs-foodit/iphone-automation-with-a-one-fingered-robot-a2936c840285#.l37adndb3)  - 如何使用机器人运行 Appium 测试.  - 丹奎利亚尔.
 - [Appium Tests on Buddybuild](https://medium.com/@stipe.kolovrat/appium-cucumber-tests-up-running-on-buddybuild-8955a88ab589#.wsyazko3g) - 自动构建、部署和收集移动应用程序的反馈 - Stipe Kolovrat.
 - [Android setup Linux](https://www.smashingmagazine.com/2016/04/from-zero-to-appium-guide-configuring-appium-android/) - 从零到 Appium：使用 Android 配置 Appium 的操作指南
 - [实用的Appium系列] (http://bitbar.com/tag/appium/) - Appium技巧系列
 - [Inspect iOS app's with Appium 1.6] (https://medium.com/@chenchaoyi/the-options-of-inspecting-ios-10-app-with-appium-1-6-534ba166b958#.ezq1q0iuo) - The options of inspecting iOS 10 app with Appium 1.6
 - [GraphWalker](http://graphwalker.github.io/appium-example/)  - GraphWalker 是一个开源的基于模型的测试自动化测试工具. 它旨在使使用图形设计测试变得容易
 - [Appium + Mobile Game Testing](http://bitbar.com/mobile-game-testing-part-2-ui-and-functionality-image-recognition/) - MOBILE GAME TESTING – PART #2: UI AND FUNCTIONALITY + IMAGE RECOGNITION
 - [WinAppDriver](http://www.hanselman.com/blog/WinAppDriverTestAnyAppWithAppiumsSeleniumlikeTestsOnWindows.aspx) - WinAppDriver - 在 Windows 上使用 Appium 的类似 Selenium 的测试来测试任何应用程序
 - [IMAGE RECOGNITION WITH APPIUM](http://bitbar.com/appium-tip-27-using-appium-for-mobile-game-testing/) - 使用 APPIUM 进行移动游戏测试
 - [Uncover invisible changes in automated tests](https://sourcediving.com/how-to-uncover-invisible-changes-in-automated-tests-b6a5dbff564e) - 通过 KazuCocoa
  - [Adding AI to Appium](https://medium.com/testdotai/adding-ai-to-appium-f8db38ea4fac) - 通过 test.ai
 

## Workshops
- [Appium Workshop Selnium Conf 2016](https://github.com/isonic1/appium-workshop) - 2016 年 Selenium 会议上的 Appium Workshop 回购 - Justin Ison.

## Cloud and Docker Solutions
- [Appium Tests in AWS Device Farm](https://github.com/awslabs/aws-device-farm-appium-tests-for-sample-app) - 示例 Appium 测试在 AWS Device Farm 上运行.
- [Appium Tests in OpenSTF Device Farm](https://github.com/openstf/stf-appium-example) - 示例 Appium 测试在 STF Device Farm 上运行.
- [Official Appium Docker Images](https://github.com/appium/appium-docker-android) - 适用于 Appium Android 真实设备的 DockerFile.
- [Appium Docker Images](https://github.com/butomo1989/docker-android) - 适用于 Appium Android 的 DockerFile.
- [Appium Docker File](https://github.com/aluedeke/appium-android) - 适用于 Appium Android 的 DockerFile.
- [Appium Docker File](https://github.com/softsam/docker-appium) - 适用于 Appium Android 的 DockerFile.
- [TestingBot](https://testingbot.com) - 基于云的 Device Farm，在物理 Android 和 iOS 设备上运行 Appium 测试.

## Git Books
- [Appium Essentials](https://www.packtpub.com/application-development/appium-essentials/?utm_source=POD&utm_medium=referral&utm_campaign=1784392480) - 使用 Appium 探索移动自动化并发现测试原生、Web 和混合应用程序的新方法 - Manoj Hans.
- [Appium for Android](https://www.gitbook.com/book/nishantverma/appium-for-android) - 关于如何使用 Appium 使用 Java 自动化 Android 应用程序的快速参考书 - Nishant Verma.

## Test Frameworks 
- [Appium Cucumber Test](https://github.com/priyankshah217/AppiumCucumberTest) - 示例黄瓜项目应用程序.
- [Appium-Native-Crawler](https://github.com/isonic1/Appium-Native-Crawler) - Appium Native Crawler CLI - 功能包括：屏幕截图、性能、辅助功能检测、谷歌翻译、Applitools、Monkey Tester.
- [coteafs-appium](https://github.com/WasiqB/coteafs-appium) - 一个建立在 Appium 之上的测试人员友好的移动自动化框架，它支持测试 Android、iOS 和 Windows 真实或模拟器手机和平板电脑的网络和本机应用程序.
- [Optimus](https://github.com/testvagrant/optimusTemplate) - 基于 Cucumber 的移动自动化框架，支持测试并行化.
- [PageObject Pattern Framework](https://github.com/saikrishna321/PageObjectPatternAppium) - 直接使用的示例页面对象模式框架.
- [Parallel Framework Java-Client](https://github.com/saikrishna321/AppiumTestDistribution) - 在 iOS 和 Android 设备上并行运行 appium 测试.

## Community
- [Discuss](https://discuss.appium.io)
- [Stack Overflow](http://stackoverflow.com/questions/tagged/appium)
- [`@appiumdevs` on Twitter](https://twitter.com/AppiumDevs)
- [`#appium` on Slack](http://appium.slack.com)

## Tips

贡献一些；）


## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/SrinivasanTarget/awesome-appium/blob/master/contributing.md) 第一的.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Srinivasan Sekar](https://github.com/SrinivasanTarget) 已放弃该作品的所有版权和相关或邻接权.
