<div class="github-widget" data-repo="websemantics/awesome-ant-design"></div>
```
                                                                       ---.
      ╭───╮╭──╮  ╭──╮   ╭──╮ ╭───╮  ╭──╮  ╭─── ───╮   ╭──╮            -..  \
     /    ││  │──│  │  / ╭─╯/ ╭──╯ /    \ │   │   │  / ╭─╯              _|_|_
    │  o  ││  │  │  │ /  ╰─(   \─╮│      ││ ─   ─ │ /  ╰─╮            /  O    \
    │     ││  │  │  ││   ╭─╯\__  ││   O  ││  \_/  ││   ╭─╯            \_______/
    │  _  ││  `  '  ││   ╰─╮/  \ ││      ││   │   ││   ╰─╮               /   \
    │  │  │ \      / │     │\    │ \    / │   │   ││     │               \/   \
    ╰──┴──╯  ╰──╯─╯  ╰─────╯ ╰───╯  ╰──╯  ╰───╯───╯╰─────╯               /'---'\
                                                                    ____/  |     \_____
      ╭───╮╭───╮  ╭──────╮   ╭──╮      ╭──╮ ╭───╮╭────╮  ╭───╮╭───╮      __/\____/      \_
     /    ││    \ │      │   │   \    / ╭─╯/ ╭──╯╰╮  ╭╯ /    ││    \          |            \
    │  o  ││  _  ││      │   │    \  /  ╰─(   \─╮ │  │ │  ╭──╯│  _  │        / \__  /\      '_
    │     ││  │  │╰─╯  ╰─╯   │  D  ││   ╭─╯\__  │ │  │ │  │╭─╮│  │  │       /     \__ \        \
    │  _  ││  │  │  │  │     │     ││   ╰─╮/  \ │ │  │ │  ╰─ ││  │  │       \        \_\_________\
    │  │  ││  │  │  │  │     │     ││     │\    │╭╯  ╰╮│     ││  │  │        \          \     \
    ╰──┴──╯╰──┴──╯  ╰──╯     ╰─────╯╰─────╯ ╰───╯╰────╯╰─────╯╰──┴──╯         \          \
```

> A curated list of [Ant Design](http://ant.design/) resources and related projects. The main idea is that everyone can contribute here, so we can have a central repository of informations about Ant Design that we keep up-to-date.

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[<img src="https://camo.githubusercontent.com/2f393ed1a4c6d222de314c16e0334301cae3fb7a/68747470733a2f2f67772e616c697061796f626a656374732e636f6d2f7a6f732f726d73706f7274616c2f4b4470677667754d704766716148506a6963524b2e7376673f73616e6974697a653d74727565" align="right" width="160">](https://ant.design/)

Ant Design, a design language for middleware, is refined by Experience Technology Department of Ant Financial, aims to uniform the user interface specs for middleware projects, reduce the unnecessary cost of design differences and implementation and liberate the resources of design and front-end development.



## Resources

Official projects and resources of Ant Design.

- [Ant Design](http://ant.design/) - An Enterprise-class UI design language and React-based implementation.
- [Ant Design Pro](http://pro.ant.design/) - An out-of-box UI solution for enterprise applications :fire::fire::fire:
- [Ant Design Mobile](http://mobile.ant.design/) - Configurable Mobile UI specification and React-based implementation.
- [Ant Design of React](http://react-component.github.io/badgeboard/) - Graceful UI components out of the box, based on React.
- [Ant Design SVG Icons](http://leungwensen.github.io/svg-icon/#ant) - Project to transform regular icon fonts into SVG format, supporting Ant Design icon fonts.

## Articles

- [Styling React Applications with Ant.Design](https://medium.com/@yoniweisbrod/styling-react-applications-with-ant-design-92b742aab0b0)
- [Finding a User Interface library](http://waywardmonkeys.org/2016/03/14/finding-a-user-interface-library/)

## Tools

These are tools and utilities to help build apps using Ant Design,

- [Antd Init](https://github.com/ant-design/antd-init) - Ant Design boilerplate generator (for demo only, use dva-cli).
- [Dva Cli](https://github.com/dvajs/dva-cli) - Create Ant Design projects based on [Dva.js](https://github.com/dvajs/dva), a
  lightweight front-end framework based on Redux and React and inspired by [Elm](http://elm-lang.org) and [Choo](https://github.com/yoshuawuyts/choo).
- [Antd Tools](https://github.com/ant-tool) - Very useful list of tools for Ant Design to create documentation, create new components, build tools and many more.
- [Antd Tools Docs](http://ant-tool.github.io/) - Documentations for Ant Tools.
- [iConfig Ant Design](https://github.com/hutxs/iconfig-antd) - Boilerplate for quickly getting a new project up and running with a few useful transforms.
- [vscode-antd-rush](https://github.com/fi3ework/vscode-antd-rush) - Rush to Ant Design in VS Code
- [Antd Snippets for VS Code](https://marketplace.visualstudio.com/items?itemName=bang.antd-snippets)
- [Generator Antd Pro](https://github.com/codetrial/generator-antd-pro) - An easy way to build your Ant Design Pro application.
- [formik-antd](https://github.com/jannikbuschke/formik-antd) - Declarative bindings for the popular form state management library Formik.
- [Zaku](https://github.com/limichange/zaku) - JSX-based UI editor, easy way to build page and generate antd code.
- [Antd-Pro-Generator for VS Code](https://github.com/garrett12138/antd-pro-generator) Generate Service/Mock/Model from Swagger2.0 or OpenApi3.x docs for Ant Design Pro.
- [Ruyi Design Assistant](https://www.figma.com/community/plugin/1192146318523533547/) Ruyi Design Assistant helps you efficiently use React component libraries(AntDesign) and Design Tokens for design in Figma, and easily get production-level component code.

## Theming

Here are utilities that can help you customize your theme and ability to change it in browser

- [antd-theme-webpack-plugin](https://github.com/mzohaibqc/antd-theme-webpack-plugin) - A webpack plugin to generate your custom theme file.
- [antd-theme-generator](https://github.com/mzohaibqc/antd-theme-generator) - A simple script to generate theme specific less file which can be used in any environment.
- [dynamic-antd-theme](https://github.com/luffyZh/dynamic-antd-theme) - A simple plugin to dynamic change ant-design theme whether less or css.
- [storybook-addon-customize-antd-theme](https://github.com/letshare/storybook-addon-customize-antd-theme) - a Storybook addon help you visually customize an ant design theme.

### Themes

- [ant-design-dark-theme](https://github.com/ant-design/ant-design-dark-theme) - Dark theme variables of Ant Design.
- [ant-design-aliyun-theme](https://github.com/ant-design/ant-design-aliyun-theme) - Aliyun console theme variables of Ant Design.
- [ant-dark-theme](https://github.com/Kuechlin/ant-dark-theme) - Dark theme variables of Ant Design.

## Related Projects

Ant Design family of projects.

- [Ant Design X](https://github.com/ant-design/x) - A React UI library @ant-design/x that Crafting AI-driven interfaces with React, seamlessly integrating smart chat components and API services at your fingertips.
- [Ant Design Web3](https://github.com/ant-design/ant-design-web3) - Efficient react components for building dapps easier | Connect crypto wallets and more Web3 UI components | Web3 icons | Supports Ethereum, Solana, Bitcoin, TON, Sui and others. 
- [Grammar of Graphics](https://g2.alipay.com/) - Pure javascript, powerful semantic graph generation tool for big data which provides a set of graphical syntax that lets users build with simple syntax a myriad of charts and integrates a large number of statistical tools, ([Read more](https://github.com/antvis/feedback)).
- [Ant Visualization](https://antv.alipay.com/) - Professional data visualization specification that aims to put several years of valuable data pattern group work in the process of exploring data visualization to share with all people who need data visualization theory. AntV consists of few parts, data, design specifications and rules for use of the chart, ([Read more](https://github.com/antvis/feedback)).
- [Ant Motion](http://motion.ant.design/) - Efficient motion design solutions that complies with Ant Design Visual specification with React implementation.
- [Ant UX](http://ux.ant.design/) - Make a sitemap template for UX design using [Omnigraffle](https://www.omnigroup.com/omnigraffle), [Sketch](https://www.sketchapp.com/) or [Axure](http://www.axure.com/). This is a library which assists designers to define, refine and finalize the inter-page logic of their products.

## Angular

Projects that are built with Angular and Ant Design.

- [NG-ZORRO](https://github.com/NG-ZORRO/ng-zorro-antd) - Ant Design of Angular.
- [NG-ZORRO-Mobile](https://github.com/NG-ZORRO/ng-zorro-antd-mobile) - Ant Design Mobile of Angular
- [ng-alain](https://ng-alain.com/) - ng-zorro-antd admin panel front-end framework.

## Vue.js

Projects that are built with Vue.js and Ant Design.

- [ant-design-vue](https://github.com/vueComponent/ant-design-vue) - Ant Design of Vue.js 2.5.0+.
- [Vue.js Beauty](https://github.com/FE-Driver/vue-beauty) - Beautiful UI components build with Vue.js and Ant Design.
- [Vue.js Ant UI](https://github.com/kokoroX/vue-ant-ui) - Ant Design UI components built in Vue.js.
- [Ant Design Vue](https://github.com/lileilei/Ant-design-vue) - Vue.js version of Ant Design.
- [antue](https://github.com/zzuu666/antue) - A set of enterprise-class Vue UI components, following the Ant Design specification completely.
- [vue-antd-admin](https://github.com/iczer/vue-antd-admin) - Ant Design Pro's implementation with Vue

## Blazor

Projects that are built with Blazor WebAssembly and Ant Design.

- [ant-design-blazor](https://github.com/ElderJames/ant-design-blazor) - Ant Design of Blazor(both Server-side and WebAssembly).
- [Blazorise](https://github.com/stsrki/Blazorise) - AntDesign support for Blazorise and Blazor [Demo](https://antdesigndemo.blazorise.com/)

## Components

A list of UI components built with Ant Design.

- [antd-group-slider](https://github.com/huyennbl/antd-group-slider) - A group of sliders that help input data with multiple ranges & description. Have data sync between sliders to improve UX, avoid accidental missing range during inputing range data.
- [antd-table-infinity](https://github.com/Leonard-Li777/antd-table-infinity) - An infinite scroll component based on antd table that supports virtual scrolling & high-performance
- [react-lz-editor](https://github.com/leejaen/react-lz-editor) - An open source rich react editor based on draft-Js and ant design.
- [React Grid](https://github.com/kagawagao/react-grid) **[Deprecated]** - Grid React UI Component based on Ant Design.
- [Antd Kit](https://github.com/huhulab/antd-kit) - Advanced Ant Design components.
- [antd-data-table](https://github.com/NewbeeFE/antd-data-table) - A component that combines antd's Table and Form to do the search, display, and operating jobs for data.
- [ngx-recursive-form](https://github.com/hsbalar/ngx-recursive-form) - Angular recursive form based on json input built with Ant Design.
- [antd-amplify-react](https://github.com/mzohaibqc/antd-amplify-react) - A collection of Ant Design component for Aws Amplify for Authentication
- [antd-password-input-strength](https://github.com/Kombustor/antd-password-input-strength) - AntD Input component with password-strength indicator.
- [antd-amiya](https://github.com/viewweiwu/amiya) - Page level components and with table and form.
- [antd-phone-input](https://github.com/ArtyomVancyan/antd-phone-input) - Advanced, highly customizable phone input component for Ant Design.

## React Hooks

- [Sunflower(🌻)](https://github.com/ant-design/sunflower) Collection of React Hooks returning component of antd.

## Applications

A list of mature apps built with Ant Design.

- [Eevee](https://github.com/pizn/eevee) - Based on Github page online editing blog platform. The project is based React, Ant Design and GitHub API.
- [Productivity Application](https://github.com/dhruv-kumar-jha/productivity-frontend) - Kanban style, Trello inspired Productivity application built using React, Ant Design and other fantastic modules.
- [IDURAR ERP/CRM](https://github.com/idurar/idurar-erp-crm) - IDURAR is Open Source ERP/CRM (Invoice / Inventory / Accounting / HR) Based on Mern Stack (Node.js / Express.js / MongoDb / React.js ) with Ant Design (AntD) and Redux

## Boilerplates

A list of starter projects and boilerplates built with Ant Design.

- [Ant Design Pro](http://pro.ant.design/) - An out-of-box UI solution for enterprise applications :fire::fire::fire:
- [Scaffold Market](http://scaffold.ant.design/) - scaffolds and boilerplates using Ant Design
- [Antd Admin](https://github.com/zuiidea/antd-admin) - A admin dashboard application demo built upon Ant Design and Dva.js.
- [Meteor Antd Boilerplate](https://github.com/elmarti/meteor-antd-boilerplate) - A basic social network built using Antd and Meteor. [Example](https://antdmeteor.herokuapp.com/login)
- [React SPA](https://github.com/JasonBai007/reactSPA) - Building SPA with React, Router, ES6, Fetch, Babel, Webpack, Npm, MockJs, FontAwesome, AnimateCSS, Ant Design, LESS and jQuery.
- [React Admin](https://github.com/fireyy/react-antd-admin) - React Admin UI built on Ant Design (username: admin, password: 123456).
- [React Redux](https://github.com/Justin-lu/react-redux-antd) - React Redux for CMS/Enterprise class apps (ERP/Admin) built with Ant Design.
- [React Antd Starter](https://github.com/yuzhouisme/react-antd-redux-router-starter) - This project is designed to develop website/web apps using Ant Design and Redux.
- [Webbf](https://github.com/peterchenhdu/webbf) - Java demo that uses Maven to build the backend with Spring, Spring MVC and Mybatis. React, Reflux, Eebpack, jQuery, React-bootstrap and Ant Design.
- [React Redux Antd Starter](https://github.com/BetaRabbit/react-redux-antd-starter) - Front-end boilerplate built with React, Redux and Ant Design.
- [Koa](https://github.com/yukrain/koa-antd-admin) - Example app to build Admin UI built with React, Ant Design and Koa.
- [Star Admin](https://github.com/pookpal/star-initReact-example) - Demo app built with React, Ant Design, Redux, React-router, Webpack and Babel.
- [React Redux Intro](https://github.com/LeuisKen/react-redux-intro) - Demo app built with Ant Design and can be configured to initialize a Redux dependencies.
- [React Start Kit](https://github.com/jovey-zheng/react-start-kit) - SPA Boilerplate built with React, Webpack, ES6+, Redux, Router, Babel, Express, Ant Design.
- [CL React](https://github.com/chenliang2016/CLReactAntDesign) - Based on Ant Design front-end framework structures for enterprise back-office software.
- [TODO MVC](https://github.com/cupools/todoMVC-react) - Todo list built with React and Ant Design.
- [React Boilerplate](https://github.com/huhulab/react-frontend-boilerplate) - React Admin front-end boilerplate built with Ant Design.
- [Dva Antd Starter](https://github.com/xlsdg/dva-antd-starter) - Get started with Dva.js and Ant Design.
- [Dva Antd Mobile Starter](https://github.com/xlsdg/dva-antd-mobile-starter) - Get started with Dva.js and Ant Design mobile.
- [Dva Ant Admin](https://github.com/jiangbo2015/learn-dva) - A front-end boilerplate built with Dva, Ant-Design
- [Aspnet Core Antd Boilerplate](https://github.com/bang88/aspnet-core-react-antd-boilerplate) - Server Side Rendering with Asp.net core.
- [React Redux Universal](https://github.com/subenksaha/react-redux-universal) - Universal/Isomorphic boilerplate using react router 4 and webpack 2.5+. All latest packages.
- [CRA-TS-Antd](https://github.com/comerc/cra-ts-antd) - Create-React-App + TypeScript + Ant-Design (without Eject).
- [Ng-Alain](https://github.com/cipchk/ng-alain) - Angular Admin UI built on Ant Design (with ng-zorro-antd).
- [Typescript React With Mobx Starter](https://github.com/YDJ-FE/ts-react-webpack) - a starter-template with typescript, react, mobx, antd and webpack).
- [React-PWA, PawJS and AntDesign](https://github.com/Atyantik/example-pawjs-ant-design) - A pluggable boilerplate with SEO, PWA, SSR, Skeleton, Placeholders, etc. as some of its many features.
- [Create React App + Ant Design](https://github.com/ant-design/create-react-app-antd) - Use antd in create-react-app without ejecting
- [ScaffoldHub.io](https://scaffoldhub.io) - Generate fullstack React + Ant Design applications with MongoDB, SQL or Firebase Firestore.
- [The Green Meal](https://github.com/VincentCordobes/the-green-meal) - Next.js, PostgreSQL demo app written in TypeScript.
- [react-vite-admin](https://github.com/ychengcloud/react-vite-admin) - React, Recoil, React Query, React Hooks, Typescript, Axios.

## Non-JavaScript Libraries

A list of libraries that are written for non-JavaScript languages.

- [Antizer](https://github.com/priornix/antizer) - Ant Design library for [ClojureScript](https://clojurescript.org/), an immutable, functional language that cross-compiles to JavaScript.
- [syn-antd](https://gitlab.com/synqrinus/syn-antd) - Ant Design wrapper for [ClojureScript](https://clojurescript.org/) and [Reagent](https://github.com/reagent-project/reagent) using [shadow-cljs](http://shadow-cljs.org/) with tree-shaking support. As with other ClojureScript libraries, it cross-compiles to JavaScript.

## Electron

- [StarCabinet](https://github.com/thundernet8/StarCabinet) - Github Stars-based cross-platform tool based on React, Electronand and Ant Design.
- [Nowa](https://github.com/nowa-webpack/nowa-gui) - A webpack based front-end plug-in scaffolding and development solution.

## Icons

- [Official Ant Design Icons](http://github.com/ant-design/ant-design-icons)
- [Ant Design Icons](https://github.com/fjc0k/ant-design-icons) - The premium icon font from Ant Design and Ant Design Mobile.
- [Material Design Icons](https://github.com/2fd/ant-design-icons) Material Design Icons for Ant Design

## Design Tools and Resources

- [Kitchen](http://kitchen.alipay.com/) - Sketch Plugin with suites of functions to enhance designers
- [Ant Design Library](http://library.ant.design/) - Ant Design Axure Library
- [Ant UX](http://ux.ant.design/) - Sitemap templates for ux design in OG, Sketch, Axure, Affinity, Adobe XD.
- [Ant Design Design Resources](https://ant.design/docs/spec/download) - Sketch Symbols

## Other

- [Ant Design of Ember](http://idcos.github.io/antd-ember/#/home) - Enterprise-class UI framework based on Ant Design and Emberjs.
- [Fable Ant Design](https://github.com/evilz/fable-ant-design) - Ant Design bindings for Fable Elmish.

## Contributing

Your contributions are always welcome! [Click Here to read the guidelines](https://github.com/websemantics/awesome-ant-design/blob/master/contributing.md).

## License

[![Creative Commons License](http://i.creativecommons.org/l/by/4.0/88x31.png)](http://creativecommons.org/licenses/by/4.0/)

This work is licensed under a [Creative Commons Attribution 4.0 International License](http://creativecommons.org/licenses/by/4.0/).
