<div class="github-widget" data-repo="cyberglot/awesome-answers"></div>
很棒的答案 [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
===

在 stackoverflow、quora 等上给出的鼓舞人心和深思熟虑的答案的精选列表.

TOC
---

 - 编程语言

Algorithms
---

 - [Algorithm: Is there a good way of solving a comparison?](http://stackoverflow.com/a/2296538/1766338)
  - 你如何识别算法的边缘情况？  [[1]](http://qr.ae/Loah1) [[2]](http://programmers.stackexchange.com/a/72779)
 - [What all basic data structures and algorithms should one learn before starting competitive programming?](http://qr.ae/LefWv)
 - [How can I be a guru in algorithms?](http://qr.ae/07Px4)
 - [Sorting 1 million 8 digit numbers in 1MB of RAM](http://stackoverflow.com/a/13067807)
 - [Which hashing algorithm is best for uniqueness and speed?](http://programmers.stackexchange.com/a/145633)

Compilers
---

- [Compilers: What is a supercompiler?](http://qr.ae/dVwDk)

数据结构
---

 - [Are new data structures still being invented in computer science?](http://qr.ae/QHYgb)
 - [Why is processing a sorted array faster than an unsorted array?](http://stackoverflow.com/a/11227902)
 - [What are some lesser known but useful data structures?](http://stackoverflow.com/questions/500607/what-are-the-lesser-known-but-useful-data-structures)
 - [What are the underlying data structures used for Redis?](http://stackoverflow.com/a/9626334)

函数式编程
---

- [What is a good beginning text on functional programming?](http://stackoverflow.com/a/23193)
- [In what ways are the major modern functional languages different from each other?](http://qr.ae/QHK6v)
- [What's new in purely functional data structures since Okasaki?](http://cstheory.stackexchange.com/a/1550/32199)
- [Can an operating system be written in a functional language?](http://qr.ae/QHAOS)
- [Why not be dependently typed?](http://stackoverflow.com/a/13241158/1766338)
- [What is a monad?](http://stackoverflow.com/a/194207/1766338)
- [Learning Lambda Calculus](http://math.stackexchange.com/a/30667)
- [Is Category Theory useful for learning functional programming?](http://cs.stackexchange.com/a/3256/29071)
- [When do you choose functional programming over object oriented? What are the typical problem definitions where functional programming is a better choice?](http://stackoverflow.com/questions/2078978/functional-programming-vs-object-oriented-programming)
- [Is there a software-engineering methodology for functional programming?](http://stackoverflow.com/a/4905458/1766338)
- [Why don't monads violate the purely functional nature of languages?](http://qr.ae/dZWCp)
- [What is a sum type?](http://qr.ae/dZ97q)
- [Why do some people not like OOP and prefer functional programming?](http://qr.ae/L5HJB)
- [What do Lisp/Haskell programmers think about Prolog?](http://qr.ae/0HB14)
- [What is (functional) reactive programming?](http://stackoverflow.com/a/1030631/1766338)
- [What are some myths about functional programming and functional programming languages?](http://qr.ae/RsOnL9)
- [How can monads in computer science be viewed as special cases of monads in category theory?](http://qr.ae/RsOAjx)
- [Specification for a Functional Reactive Programming language](http://stackoverflow.com/a/5878525/1766338)
- [What are some myths about functional programming and functional programming languages?](https://www.quora.com/What-are-some-myths-about-functional-programming-and-functional-programming-languages/answer/Tikhon-Jelvis)

学习编程
---

 - [How can I become a world-class coder in under three years?](http://qr.ae/E8UPT)
 - [What should every programmer know about security?](http://stackoverflow.com/q/2794016)
 - [What are some basic concepts that every engineering student should know?](http://qr.ae/k6Ekm)
 - [What technical details should a programmer of a web application consider before making the site public?](http://programmers.stackexchange.com/q/46716)
 - [How does one become a great coder?](http://qr.ae/dQTYn)
 - [We all hear about how simple programming can be, but what are some truly complex concepts that even experienced programmers struggle with?](http://qr.ae/LefKC)

Math
---

 - [Visually stunning math concepts which are easy to explain](http://math.stackexchange.com/questions/733754/visually-stunning-math-concepts-which-are-easy-to-explain)
 - [If floating-point can't represent 0.1, how does parseFloat (".1") equal .1?](http://qr.ae/7PKwoT)

编程语言
---

### Clojure
- [Common programming mistakes for Clojure developers to avoid](http://stackoverflow.com/a/2021343/1766338)
- [Why would someone learn Clojure?](http://qr.ae/7PKRiN)
- [Why are Clojure's `let` and `for` both monads?](http://stackoverflow.com/a/21763329/1766338)

### C/C++
- [The Definitive C++ Book Guide and List](http://stackoverflow.com/a/388282/1766338) 
- [Can a local variable's memory be accessed outside its scope?](http://stackoverflow.com/a/6445794/1104488)
- [Why do many C functions have an extra F?](http://qr.ae/7vBEnF)
- [What are the valid signatures for C's main() function? ](http://stackoverflow.com/questions/2108192/what-are-the-valid-signatures-for-cs-main-function)

### Haskell
- [Getting started with Haskell](http://stackoverflow.com/a/1016986/1766338)
- [Update Map in Haskell](http://codereview.stackexchange.com/a/57850)
- [I am building an investment engine for a startup, and my choice for developer wants to code it in Haskell. Is this the right choice? Do enough people know this so if he leaves I can continue without interruption?](http://qr.ae/d6vcE)
- [What are some crazy things one can do with monads in Haskell?](http://qr.ae/d6rhm)
- [Why do some programmers have difficulty in learning Haskell?](http://qr.ae/Rsgfkx)
- [foldl is tail recursive, so how come foldr runs faster than foldl?](http://stackoverflow.com/a/3429693)
- [Does Haskell have tail-recursive optimization?](http://stackoverflow.com/a/13052612)

### JavaScript
- [How does “this” keyword work within a JavaScript object literal?](http://stackoverflow.com/a/134149/1766338)
- [Use of .apply() with 'new' operator. Is this possible?](http://stackoverflow.com/a/1608546/1766338)
- [Is JavaScript's “new” keyword considered harmful?](http://stackoverflow.com/a/383503/1766338)
- [Is JavaScript 's “new” Keyword Considered Harmful (Part 2)?](http://stackoverflow.com/a/6375254/1766338)
- [JavaScript inheritance and the constructor property](http://stackoverflow.com/a/8096017/1766338)
- [Inheritence of variable properties](http://stackoverflow.com/a/15461601/1766338)
- [How does JavaScript .prototype work?](http://stackoverflow.com/a/572996/1766338)
- [JavaScript closures vs. anonymous functions](http://stackoverflow.com/a/12931785/1766338)
- [Why does JavaScript need a style guide?](https://github.com/airbnb/javascript/issues/102)
- [Avoid Memory Leak / Usage Javascript](http://stackoverflow.com/a/13191289)
- [Perform debounce in React.js](http://stackoverflow.com/a/28046731)
- [Comparing two arrays in Javascript](http://stackoverflow.com/a/14853974/1766338)
- [How does bellard.org/jslinux work?](http://qr.ae/7AymJb)
- [Will WebAssembly make Javascript skills more or less valuable in the future?](http://qr.ae/7PKALb)
- [为什么 ++[[]][+[]]+[+[]] 返回字符串“10”？](http://stackoverflow.com/a/7202287/1766338)
- [Are functions like map(), reduce() and filter() already optimized for traversing array?](http://qr.ae/Rsg6I0)
- [What are the actual uses of ES6 WeakMap?](http://stackoverflow.com/a/29416340)

### PHP
 - [Is PHP a badly designed programming language?](http://qr.ae/QVSuX)

### Python
 - [Why are banks like JP Morgan and Bank of America Merrill Lynch using Python to replace historic legacy systems built in Java/C++?](http://qr.ae/RCkmhJ)
 - [What are killer Python tips which could make our coder lives more productive, easier and happier?](http://qr.ae/RCkmKa)
 - [What are some of the best time-saving tips for Python?](http://qr.ae/RCkmoh)
 - [How can I tell if a string repeats itself in Python?](http://stackoverflow.com/a/29489919)
 - [Python Hidden Features](http://stackoverflow.com/questions/101268/hidden-features-of-python)

### Ruby
 - [Ruby craziness: Class vs Object?](http://stackoverflow.com/a/4969822/1766338)

编程语言理论
---
 - [What makes a good programming language?](http://qr.ae/QHArY)
 - [What is referential transparency?](http://stackoverflow.com/a/9859966/565303)
 - [Research and open challenges in Programming Language Theory](http://cstheory.stackexchange.com/a/17870/32199)
 - [Why are there so many programming languages?](http://cs.stackexchange.com/a/458/29071)
 - [Uses of algebraic structures in theoretical computer science](http://cstheory.stackexchange.com/a/10929/32199)
 - [What is the difference between the statement "Everything is an object" when said about JavaScript and when said about Ruby?](http://qr.ae/Q973e)
 - [Which programming concept do people usually find harder: loops or recursion?](http://qr.ae/QjpjD)
 - [If you would create a new programming language, what would it look like?](http://qr.ae/fgPsq)
 - [What is fascinating about dynamically-typed programming languages?](http://qr.ae/7PKzmF)

版本控制系统
---
- [How to update GitHub forked repository?](http://stackoverflow.com/a/7244456)

Miscellaneous
---
- [Can I parse XHTML with Regex?](http://stackoverflow.com/a/1732454)
- [How does a visually impaired computer programmer do programming?](http://qr.ae/L5FfY)
- [What are the best examples of software bugs that became features (a.k.a. misbugs)?](http://qr.ae/LO834)
- [What do the top 1% of software engineers do that the other 99% do not?](http://qr.ae/0ILWY)
- [Why is processing a sorted array faster than an unsorted array?](http://stackoverflow.com/a/11227902)
- [What are the current fads in computer science, IT and software engineering?](http://qr.ae/7PyLkC)
- [What is your most productive shortcut with Vim?](http://stackoverflow.com/a/1220118)
- [How to become a Hacker?](http://www.catb.org/~esr/faqs/hacker-howto.html)

## License

[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Ju Gonçalves](http://jugoncalv.es) 已放弃该作品的所有版权和相关或邻接权.
