<div class="github-widget" data-repo="jacobdjwilson/awesome-annual-security-reports"></div>
<!-- lint ignore double-link -->
<!--lint ignore definition-case-->
<!--lint disable awesome-toc-->
<!--lint disable no-emphasis-as-heading-->
<!--lint disable awesome-list-item-->

## Awesome Annual Security Reports [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)
> A curated list of annual cyber security reports - Centralized annual cybersecurity analysis and industry surveys

**Definition:** The cybersecurity landscape is constantly evolving, making it hard for CIOs, CISOs, and security leaders to keep up. They're flooded with annual reports from research consultancies, industry working groups, non-profits, and government agencies, and sifting through marketing material to find actionable insights is a major challenge. This list aims to cut through the noise by providing a vendor-neutral resource for the latest security trends, tools, and partnerships. It curates information from trusted sources, making it easier for security leaders to make informed decisions.


**Limitations:** This is **not** a collection of project based information such as white papers, intelligence reports, technical specifications, or standards. I welcome all user submitted uploads or report requests, but we should draw a box around this _awesome_ list. All reports will be sourced from the original author when possible and uploaded to [Hybrid Analysis](https://www.hybrid-analysis.com/) for an additional level of confidence, the result link will be included in the PDF commit notes. All PDF reports will also be converted to Markdown using AI, leveraging the [AI Prompt](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/AI_PROMPT_MARKDOWN_CONVERT.md) found in this repository.

**Acknowledgement:** I would like to give recognition for other works that inspired this collection. [Richard Stiennon](https://it-harvest.com/about/) and his annual analysis of the cybersecurity industry is significantly more comprehensive than this repository and deserves recognition. Additionally, [Rick Howard](https://www.linkedin.com/in/rickhoward/)'s cyber cannon list of must-read books is an invaluable resource, catering to both leadership and practitioner levels within the field.

**Annual Report Counts:** 

![GitHub repo file or directory count (in path)](https://img.shields.io/github/directory-file-count/jacobdjwilson/awesome-annual-security-reports/Annual%20Security%20Reports%2F2020?type=file&style=flat-square&label=2020%20Reports)
![GitHub repo file or directory count (in path)](https://img.shields.io/github/directory-file-count/jacobdjwilson/awesome-annual-security-reports/Annual%20Security%20Reports%2F2021?type=file&style=flat-square&label=2021%20Reports)
![GitHub repo file or directory count (in path)](https://img.shields.io/github/directory-file-count/jacobdjwilson/awesome-annual-security-reports/Annual%20Security%20Reports%2F2022?type=file&style=flat-square&label=2022%20Reports)
![GitHub repo file or directory count (in path)](https://img.shields.io/github/directory-file-count/jacobdjwilson/awesome-annual-security-reports/Annual%20Security%20Reports%2F2023?type=file&style=flat-square&label=2023%20Reports)
![GitHub repo file or directory count (in path)](https://img.shields.io/github/directory-file-count/jacobdjwilson/awesome-annual-security-reports/Annual%20Security%20Reports%2F2024?type=file&style=flat-square&label=2024%20Reports)
![GitHub repo file or directory count (in path)](https://img.shields.io/github/directory-file-count/jacobdjwilson/awesome-annual-security-reports/Annual%20Security%20Reports%2F2025?type=file&style=flat-square&label=2025%20Reports)


<!-- TOC -->
    - [AI and Emerging Technologies](#ai-and-emerging-technologies-1)        
<!-- /TOC -->

## Overview

Reports have been classified into two categories by the source of data:
- **Analysis:** Reports generated from quantifying and qualifying intelligence from sensor networks or services.
- **Survey:** Reports generated from observations and feedback from surveys or consulting engagements.

The reports listed below are the most recent iteration, while past versions are stored in their corresponding yearly folders. After three years, if a source has not updated a report it will no longer be featured in the ReadMe.md file but will still be accessible within the repository directory corresponding to its respective year.

Reports will be classified by a header that describes their primary content or emphasis. While each report may discuss multiple topics, this categorization will help organize them. Under this header they will be sorted alphabetically.

## Analysis Reports

## Threat Intelligence
- [ASD](https://www.cyber.gov.au/about-us/view-all-content/reports-and-statistics/annual-cyber-threat-report-2023-2024) - [Cyber Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/ASD-Cyber-Threat-Report-2024.pdf) (2024) - Insights into Australia’s evolving cyber threat landscape, attack trends, and defense strategies.
- [BD](https://news.bd.com/2024-06-13-BD-Issues-Annual-Product-Security-Report,-Highlighting-Transparency-and-Collaboration) - [Product Security Annual Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/BD-Product-Security-Annual-Report-2023.pdf) (2023) - Highlights cybersecurity threats in healthcare, addressing the growing sophistication and frequency of cyberattacks through transparency, collaboration, and adherence to high security standards.
- [Blackpoint](https://blackpointcyber.com/resources/cybersecurity-annual-threat-report-2024/) - [Annual Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Blackpoint-Cyber-Annual-Threat-Report-2024.pdf) (2024) - Analyzes current cyber threats, attack techniques, and emerging trends, providing actionable intelligence for organizations to enhance their security posture.
- [CheckPoint](https://pages.checkpoint.com/2024-cyber-security-report) - [Cybersecurity Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/CheckPoint-Cybersecurity-Report-2024.pdf) (2024) - Examines global cybersecurity trends, offering insights into attack vectors, threat actor tactics, and strategies for improving organizational cyber resilience.
- [Cisco](https://blog.talosintelligence.com/cisco-talos-2023-year-in-review/) - [Talos Year In Review](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Cisco-Talos-Year-In-Review-2023.pdf) (2023) - Provides a comprehensive analysis of cyber threats and attack trends observed by Cisco's threat intelligence team throughout the year.
- [CrowdStrike](https://www.crowdstrike.com/resources/reports/overwatch-threat-hunting-report/) - [Threat Hunting Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/CrowdStrike-Threat-Hunting-Report-2024.pdf) (2024) - Provides comprehensive insights into over 245 advanced persistent threats (APTs) and adversary tactics through global threat monitoring and analysis.
- [CrowdStrike](https://www.crowdstrike.com/resources/reports/global-threat-report/) - [Global Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Crowdstrike-Global-Threat-Report-2024.pdf) (2024) - Analyzes global cyber threats, offering insights into adversary tactics, emerging attack trends, and strategies for improving cyber defense.
- [DeepInstinct](https://www.deepinstinct.com/blog/2022-cyber-threat-landscape-report) - [Threat Landscape Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Deep-Instinct-Cyber-Threat-Landscape-Report-2023.pdf) (2023) - Examines evolving cyber threats, offering insights into attack techniques, malware trends, and strategies for enhancing organizational cybersecurity.
- [ENISA](https://www.enisa.europa.eu/publications/enisa-threat-landscape-2023) - [Threat Landscape Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/ENISA-Threat-Landscape-2023.pdf) (2023) - An annual summary of key cybersecurity threats, trends, and attack techniques. It examines threat actors, motivations, impacts, and suggests mitigation strategies.
- [Ensign](https://www.ensigninfosecurity.com/resources/threat-insights/cyber-threat-landscape-report-2024) - [Cyber Threat Landscape Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Ensign-Cyber-Threat-Landscape-Report-2024.pdf) (2024) - Analysis of key cyber threats across Asia, focusing on Singapore, Malaysia, Indonesia, South Korea, Australia, and Greater China.
- [Expel](https://expel.com/annual-threat-report/) - [Annual Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Expel-Annual-Threat-Report-2024.pdf) (2024) - Provides an overview of cyber threats and attack trends observed by Expel's security operations team throughout the year.
- [FBI](https://www.ic3.gov/Home/AnnualReports) - [Internet Crime Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/FBI-Internet-Crime-Report-2023.pdf) (2023) - Examines cybercrime complaints to protect the public, track trends, support investigations, and promote awareness of internet-facilitated crimes.
- [Flashpoint](https://flashpoint.io/resources/report/2024-global-threat-intelligence-report/) - [Global Threat Intelligence Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Flashpoint-Threat-Intel-Report-2024.pdf) (2024) - A comprehensive analysis of global cyber threats, providing insights into threat actor motivations, tactics, and emerging attack trends.
- [Flashpoint](https://flashpoint.io/resources/report/2024-cyber-threat-intelligence-index/) - [Midyear Cyber Threat Index](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Flashpoint-Midyear-CTI-Index-2024.pdf) (2024) - Provides a snapshot of current cyber threat trends, offering insights into evolving attack patterns and threat actor activities.
- [Fortinet](https://www.fortinet.com/resources/analyst-reports/threat-report-2h-2023) - [Global Threat Landscape Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Fortinet-Global-Threat-Report-2H-2023.pdf) (2023) - Analyzes global cyber threats and attack trends, offering insights into emerging vulnerabilities, malware variants, and strategies for improving organizational cybersecurity.
- [Google Cloud](https://inthecloud.withgoogle.com/security-threat-intel/subscribe.html) - [Threat Horizons Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Google-Cloud-Threat-Horizons-Report-H12024.pdf) (2024) - Offers insights on cloud security risks and practical advice for businesses using cloud services, based on Google's research and expert knowledge.
- [IBM](https://www.ibm.com/reports/threat-intelligence) - [X-Force Threat Intelligence Index](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/IBM-X-Force-Threat-Intelligence-Index-2024.pdf) (2024) - Provides a comprehensive analysis of global cyber threats, offering insights into attack trends, threat actor tactics, and industry-specific vulnerabilities.
- [Mandiant](https://www.mandiant.com/m-trends) - [MTrends Special Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Mandiant-M-Trends-2024.pdf) (2024) - Offers insights into advanced persistent threats, emerging attack techniques, and strategies for improving organizational cyber defense.
- [Microsoft](https://www.microsoft.com/en-us/security/security-insider/intelligence-reports/microsoft-digital-defense-report-2024) - [Digital Defense Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Microsoft-Digital-Defense-Report-2024.pdf) (2024) - Analyzes global cybersecurity trends, offering insights into threat actor tactics, emerging vulnerabilities, and strategies for improving digital defense.
- [NCC Group](https://www.nccgroup.com/us/threat-monitor-report-2023/) - [Threat Monitor Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/NCCGroup-Threat-Monitor-Report-2023.pdf) (2023) - Provides an analysis of current cyber threats, offering insights into attack trends, vulnerabilities, and strategies for improving organizational cybersecurity.
- [Rapid7](https://www.rapid7.com/info/2023-mid-year-threat-review/) - [Mid-Year Threat Review](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Rapid7-Mid-Year-Threat-Review-2023.pdf) (2023) - Provides a snapshot of current cyber threats and attack trends, offering insights into emerging vulnerabilities and mitigation strategies.
- [Rapid7](https://www.rapid7.com/research/report/2024-attack-intelligence-report/) - [Attack Intelligence Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Rapid7-Attack-Intelligence-Report-2024.pdf) (2024) - Analyzes attack patterns and techniques, offering insights into adversary tactics and strategies for improving organizational cyber defense.
- [RedCanary](https://redcanary.com/threat-detection-report/) - [Threat Detection Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/RedCanary-Threat-Detection-Report-2024.pdf) (2024) - Examines current attack techniques and detection strategies, offering insights into improving organizational threat detection capabilities.
- [Secureworks](https://www.secureworks.com/resources/rp-state-of-the-threat-2024) - [State of the Threat](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Secureworks-State-of-the-Threat-Report-2024.pdf) (2024) - Provides a detailed analysis of the evolving cybersecurity landscape based on global intelligence gathering and incident response data.
- [SonicWall](https://www.sonicwall.com/threat-report/) - [Cyber Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/SonicWall-Cyber-Threat-Report-2024.pdf) (2024) - Examines global cyber threats, offering insights into malware trends, attack vectors, and strategies for improving organizational cybersecurity.
- [Sophos](https://www.sophos.com/en-us/labs/security-threat-report) - [Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Sophos-Threat-Report-2024.pdf) (2024) - Provides an analysis of current cyber threats and attack trends, offering insights into emerging vulnerabilities and strategies for improving cyber defense.
- [Trellix](https://www.trellix.com/advanced-research-center/threat-reports/june-2024/) - [Advanced Threat Research Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Trelllix-Advanced-Threat-Research-Report-2024.pdf) (2024) - Provides highlights insights, intelligence, and guidance gleaned from multiple sources of critical data on cybersecurity threats.
- [TrendMicro](https://www.trendmicro.com/vinfo/us/security/research-and-analysis/threat-reports/roundup/calibrating-expansion-2023-annual-cybersecurity-threat-report) - [Annual Cybersecurity Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Trendmicro-Annual-Cybersecurity-Report-2023.pdf) (2023) - Analysis of global cyber threats, examining attack trends, emerging vulnerabilities, and strategies for enhancing organizational security posture.
- [Upstream](https://upstream.auto/reports/global-automotive-cybersecurity-report/) - [Global Automotive Cybersecurity Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Upstream-Global-Automotive-Cybersecurity-Report-2024.pdf) (2024) - Analysis of over 1,468 automotive cybersecurity incidents, monitoring trends across open, deep, and dark web forums to help safeguard the Smart Mobility ecosystem against emerging threats.
- [US Department of Defense](https://federalnewsnetwork.com/commentary/2024/10/open-source-intelligence-professionalism-distinguishing-osint-from-pro-sint/) - [OSINT Strategy 2024–2028](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/USDoD-OSINT-Strategy-2024.pdf) (2024) - This strategy outlines the Department of Defense's approach to open-source intelligence (OSINT) as a vital resource for decision-makers and warfighters, emphasizing OSINT's role in enhancing situational awareness and operational effectiveness.
- [WatchGuard](https://www.watchguard.com/wgrd-security-hub/internet-security-report) - [Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/WatchGuard-Threat-Report-2024.pdf) (2024) - Provides an analysis of current cyber threats and attack trends, offering insights into network security challenges and strategies for improving organizational cybersecurity.
- [White House](https://www.whitehouse.gov/oncd/briefing-room/2024/05/07/fact-sheet-cybersecurity-posture-report/) - [Cybersecurity Posture of the United States](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Whitehouse-Cybersecurity-Posture-of-the-United-States-2024.pdf) (2024) - Evaluates the U.S. cybersecurity posture, covering federal agency resilience against cyber threats, policy effectiveness, and readiness to counter emerging security risks affecting national interests.

## Application Security
- [Escape](https://escape.tech/the-api-secret-sprawl-2024) - [State of API Exposure](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Escape-State-of-API-Exposure-2024.pdf) (2024)  
  Analyzes API security across Fortune 1000 and CAC 40 companies, uncovering 30,000 exposed APIs and 100,000 API issues, emphasizing risks in large organizations.
- [RunZero](https://www.runzero.com/research-report/) - [RunZero Research Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/RunZero-Research-Report-Vol1-2024.pdf) (2024) - Examines a broad range of organizational and network security issues through an innovative asset-centric approach, with a focus on "dark matter" in networks, segmentation issues, and unusual asset detection.
- [Sonatype](https://www.sonatype.com/resources/whitepapers/2024-open-source-malware-threat-report) - [2024 in Open Source Malware Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Sonatype-2024-in-Open-Source-Malware-Report-2024.pdf) (2024)  
  Reports a 156% year-over-year increase in malicious open source packages, highlighting the growing threat of intentionally crafted malware in software supply chain attacks.
- [Synopsys](https://www.synopsys.com/software-integrity/resources/analyst-reports/open-source-security-risk-analysis.html) - [Open Source Risk Analysis Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Synopsys-Open-Source-Risk-Analysis-Report-2024.pdf) (2024) - Examines security risks associated with open-source software components, offering insights into vulnerability trends and mitigation strategies.
- [Veracode](https://www.veracode.com/state-of-software-security-report) - [State of Software Security](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Veracode-State-of-Software-Security-Report-2024.pdf) (2024) - Examines trends in application security, offering insights into common vulnerabilities, secure development practices, and strategies for improving software security throughout the development lifecycle.

## Vulnerabilities
- [Beyond Trust](https://www.beyondtrust.com/resources/whitepapers/microsoft-vulnerability-report) - [Microsoft Vulnerability Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/BeyondTrust-Microsoft-Vulnerability-Report-2024.pdf) (2024) - Analyzes vulnerabilities in Microsoft products, offering insights into security trends and potential areas of concern for organizations relying on Microsoft technologies.
- [Edgescan](https://www.edgescan.com/stats-report/) - [Vulnerability Statistics Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Edgescan-Vulnerability-Statistics-Report-2024.pdf) (2024) Analyzes data from thousands of security assessments and penetration tests on millions of global assets to provide insights into the current state of full-stack security.
- [Flexera](https://info.flexera.com/SVM-REPORT-Annual-Vulnerability-Review) - [Annual Vulnerability Review](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Flexera-Annual-Vulnerability-Review-2023.pdf) (2023) - Provides a comprehensive analysis of global software vulnerabilities, offering insights into trends, severity, and impact across various software products and vendors.
- [Nucleus](https://nucleussec.com/chapter-one-state-of-vulnerability-management-ebook/) - [State of Vulnerability Management](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Nucleus-State-of-Vuln-Management-2023.pdf) (2023) - Examines the current state of vulnerability management practices, highlighting challenges, trends, and best practices in identifying and addressing security vulnerabilities.
- [Qualys](https://www.qualys.com/forms/tru-research-report/) - [TruRisk Threat Research Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Qualys-Trurisk-Threat-Research-Report-2023.pdf) (2023) - Provides an in-depth analysis of vulnerabilities and threats, offering insights into risk assessment and prioritization strategies.
- [Synack](https://go.synack.com/state-of-vulnerabilities-2024) - [State of Vulnerabilities Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Synack-State-of-Vulnerabilities-Report-2024.pdf) (2024) This report looks at five industries (healthcare, financial services, U.S. federal government, technology and manufacturing) and their most common vulnerabilities to see how they stack up against each other. 
- [Synopsys](https://www.synopsys.com/software-integrity/resources/analyst-reports/software-vulnerability-trends.html) - [Software Vulnerability Snapshot](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Synopsys-Software-Vulnerability-Snapshot-2023.pdf) (2023) - A snapshot of software vulnerability trends, highlighting common weaknesses, emerging threats, and strategies for improving software security.
- [Trustwave](https://www.trustwave.com/en-us/resources/library/documents/2024-trustwave-risk-radar-report-financial-services-sector/) - [Financial Services Risk Radar Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Trustwave-Financial-Services-Risk-Radar-Report-2024.pdf) (2024) Highlights the unique threat landscape facing the financial services sector, focusing on notable trends and the growing risk of insider threats. This report provides key insights into the cybersecurity challenges specific to this industry.

## Ransomware
- [Guidepoint](https://www.guidepointsecurity.com/resources/grit-ransomware-annual-report-2023/) - [GRIT Ransomware Annual Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Guidepoint-Ransomware-Annual_Report-2023.pdf) (2023) - A comprehensive analysis of ransomware trends, attack techniques, and mitigation strategies, providing valuable insights for organizations to enhance their ransomware resilience.
- [PaloAlto](https://start.paloaltonetworks.com/2023-unit42-ransomware-extortion-report) - [Unit 42 Ransomware Extortion Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/PaloAlto-Unit-42-Ransomeware-Extortion-Report-2023.pdf) (2023) - Examines current ransomware and extortion trends, offering insights into attacker tactics, ransom demands, and strategies for improving organizational resilience against ransomware attacks.
- [Veeam](https://www.veeam.com/resources/wp-2024-ransomware-trends-executive-summary-global.html) - [Ransomware Trends Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Veeam-Ransomware-Trends-2024.pdf) (2024) - Provides an overview of current ransomware attack patterns, data recovery challenges, and strategies for improving organizational ransomware preparedness and resilience.
- [Zscaler](https://www.zscaler.com/campaign/threatlabz-ransomware-report) - [ThreatLabz State of Ransomware Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Threatlabz-Ransomware-Report-2024.pdf) (2024) - A comprehensive analysis of global ransomware trends, examining attack techniques, ransom demands, and strategies for preventing and mitigating ransomware attacks.

## Data Breaches
- [IBM](https://www.ibm.com/security/data-breach) - [Cost of a Data Breach Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/IBM-Cost-of-a-Data-Breach-Report-2024.pdf) (2024) - Provides IT, risk management and security leaders with timely, quantifiable evidence to guide them in their strategic decision-making. This research studied 604 organizations impacted by data breaches between March 2023 and February 2024.
- [Verizon](https://www.verizon.com/business/resources/reports/dbir/) - [Data Breach Investigations Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Verizon-Data-Breach-Investigations-Report-2024.pdf) (2024) - Analyzes global data breaches, offering insights into attack patterns, threat actor motivations, and strategies for improving organizational data security and incident response.
- [Identity Theft Resource Center](https://www.idtheftcenter.org/publication/2023-data-breach-report/) - [Annual Data Breach Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/ITRC-Annual-Data-Breach-Report-2023.pdf) (2023) - A review of 18,800+ data breaches since 2005, impacting 12 billion victims and exposing 19.8 billion records, focusing on root causes and compromised data types.

## AI and Emerging Technologies
- [AICD](https://www.aicd.com.au/innovative-technology/digital-business/artificial-intelligence/governance-of-ai.html) - [Directors Introduction to AI](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/AICD-Directors-Introduction-to-AI-2024.pdf) (2024) - Provides an overview of artificial intelligence tailored for directors, highlighting its strategic implications, governance considerations, and best practices for AI implementation in organizations.
- [IBM](https://www.ibm.com/security/data-breach/threat-intelligence/) - [X-Force Cloud Threat Landscape Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/IBM-X-Force-Cloud-Threat-Landscape-Report-2024.pdf) (2024) - Focuses on threats specific to cloud environments, offering insights into cloud security challenges and strategies for securing cloud infrastructure.
- [Okta](https://www.okta.com/resources/whitepaper-the-state-of-secure-identity-report/) - [The State of Secure Identity](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Okta-The-State-of-Secure-Identity-2023.pdf) (2023) - Drawing on billions of authentications, this report explores trends and methods of common identity attacks, the role of AI in identity security, and unique attack patterns across industries, regions, and company sizes.
- [Zimperium](https://www.zimperium.com/global-mobile-threat-report/) - [Global Mobile Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Zimperium-Global-Mobile-Threat-Report-2024.pdf) (2024) Highlights a growing trend of attackers prioritizing mobile devices as a primary target, focusing on threats like phishing and "mishing" (mobile phishing) covering the enterprise mobile footprint, global threat landscape, and specific industries targeted by these attacks.
- [Zscaler](https://info.zscaler.com/resources-industry-reports-public-sector-Insights-threatlabz-ai-security-2024) - [ThreatLabz AI Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Threatlabz-AI-Security-Report-2024.pdf) (2024) - Examines the intersection of artificial intelligence and cybersecurity, offering insights into AI-powered threats, defensive applications of AI, and strategies for securing AI systems and models.

## Survey Reports

## Industry Trends
- [Accenture](https://www.accenture.com/us-en/insights/security/invest-cyber-resilience) - [State of Cybersecurity Resilience](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Accenture-State-of-Cybersecurity-2023.pdf) (2023) - Provides insights into the state of cybersecurity resilience across various industries, highlighting key trends and challenges faced by organizations.
- [Aon](https://www.aon.com/en/insights/reports/2024-intangible-versus-tangible-risks-comparison-report) - [Intangible vs. Tangible Risk Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Aon-Intangible-vs-Tangible-Risk-Report-2024.pdf) (2024) - Analyzes cyber and enterprise risk management trends from a survey of over 2,300 respondents across global regions, providing insights into the evolving landscape of tangible and intangible risks.
- [Deloitte](https://www.deloitte.com/global/en/services/risk-advisory/content/future-of-cyber.html) - [Future of Cyber Survey](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Deloitte-Future-of-Cyber-Survey-2023.pdf) (2023) -Explores the future of cybersecurity, providing insights into emerging trends, technologies, and strategies across different sectors.
- [FERMA](https://www.ferma.eu/publication/global-risk-manager-survey-report-2024/) - [Global Risk Manager Survey Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/FERMA-Global-Risk-Manager-Survey-Report-2024.pdf) (2024) - Analysis of global risk management practices across 77 countries and six regional associations.
- [ISC2](https://www.isc2.org/landing/Cyberthreat-Defense-Report) - [Cyberthreat Defense Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/ISC2-Cyberthreat-Defense-Report-2024.pdf) (2024) - Examines the current state of cyberthreat defense, including emerging threats and defense strategies across various industries.
- [KnowBe4](https://www.knowbe4.com/security-culture-research-report) - [Cybersecurity Culture Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/KnowBe4-Cybersecurity-Culture-Report-2024.pdf) (2024) - Explores the state of cybersecurity culture in organizations, highlighting trends and best practices across different sectors.
- [Kong](https://konghq.com/resources/reports/api-security-ai-threats-it-leader-insights-2025) - [API Security Perspectives](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2025/Kong-API-Security-Perspectives-2025.pdf) (2025) Outlines the growing threat of AI-enhanced attacks on APIs and emphasizes the need for robust API security measures and the rising risks associated with these new types of threats.
- [Norton](https://www.nortonlifelock.com/us/en/newsroom/press-kits/2022-norton-cyber-safety-insights-report-special-release-online-creeping/) - [Cyber Safety Insights Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Norton-Cyber-Safety-Insights-Report-2023.pdf) (2023) - Provides insights into consumer cyber safety trends and challenges across various industries.
- [Proofpoint](https://go.proofpoint.com/Voice-of-the-CISO-Report.html) - [Voice of the CISO Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Proofpoint-Voice-of-the-CISO-Report-2024.pdf) (2024) - Insights into the perspectives and challenges faced by Chief Information Security Officers across different sectors.
- [PwC](https://www.pwc.com/us/en/services/consulting/cybersecurity-risk-regulatory/library/global-digital-trust-insights.html) - [Global Digital Trust Insights](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/PWC-Global-Digital-Trust-Insights-Report-2024.pdf) (2024) - Examines global trends in digital trust and cybersecurity across various industries.
- [SANS](https://www.sans.org/white-papers/2023-cti-survey-keeping-up-changing-threat-landscape/) - [SANS Cyber Threat Intelligence Survey](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/SANS-cyber-threat-intelligence-survey-2023.pdf) (2023) - Provides insights into the current state of cyber threat intelligence across different sectors.
- [Splunk](https://www.splunk.com/en_us/form/state-of-security.html) - [State of Security](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Splunk-State-of-Security-2024.pdf) (2024) - Provides an overview of the current state of security, including trends and challenges across different sectors.
- [USTelecom](https://www.ustelecom.org/research/2023-cybersecurity-culture-report/) - [Cybersecurity Culture](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/USTelecom-Cybersecurity-Culture-2023.pdf) (2023) - Examines the state of cybersecurity culture in the telecommunications industry and related sectors.
- [Vanta](https://www.vanta.com/state-of-trust) - [State of Trust Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Vanta-State-of-Trust-Report-2024.pdf) (2024) - Explores the growing challenges in building and maintaining trust for organizations, focusing on security risks, compliance burdens, and the increasing third-party vendor risks.
- [Verizon](https://www.verizon.com/business/resources/reports/mobile-security-index/) - [Mobile Security Index](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Verizon-Mobile-Security-Index-2024.pdf) (2024) - Provides insights into mobile security trends and challenges across various industries.
- [World Economic Forum](https://www.weforum.org/publications/global-cybersecurity-outlook-2024/) - [Global Cybersecurity Outlook](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/WEF-Global-Cybersecurity-Outlook-2024.pdf) (2024) - A global perspective on cybersecurity trends and challenges across different sectors.

## Application Security
- [ArmorCode](https://www.armorcode.com/state-of-application-security-2023) - [State of Application Security](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master//Annual%20Security%20Reports/2023/Armorcode-State-of-Application-Security-2023.pdf) (2023) - Examines the current landscape of application security, including emerging threats, best practices, and industry-wide trends.
- [BlackDuck](https://www.blackduck.com/resources/analyst-reports/state-of-devsecops.html) - [Global State of DevSecOps](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/BlackDuck-Global-State-of-DevSecOps-2023.pdf) (2024) - Provides insights into the global state of DevSecOps practices and trends across different sectors.
- [Checkmarx](https://info.checkmarx.com/future-of-application-security-2024) - [Future of Application Security](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Checkmarx-Future-of-Application-Security-2024.pdf) (2024) - Reveals how key stakeholders are responding to the challenges in Application Security from a broad range of industries globally.
- [Checkmarx](https://info.checkmarx.com/supply-chain-survey) - [State of Software Supply Chain Security](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Checkmarx-State-of-Software-Supply-Chain-Security-2024.pdf) (2024) - Provides insights into current trends in supply chain threats across industries such as banking and finance, insurance, software, technology, engineering, manufacturing, industrial, and public sector.
- [Cycode](https://cycode.com/state-of-aspm-2025/) - [State of Application Security Posture Management](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2025/Cycode-State-of-Application-Security-Posture-Management-2025.pdf) (2025)  
  Examines application security challenges and strategies from the perspectives of CISOs, AppSec Directors, and DevSecOps managers across the UK, US, and Germany.
- [Synopsys](https://www.synopsys.com/software-integrity/resources/analyst-reports/sans-devsecops-survey.html) - [SANS 2023 DevSecOps Survey](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/SANS-DevSecOps-Survey-2023.pdf) (2023) - Examines the current state of DevSecOps practices across various industries.
- [Snyk](https://go.snyk.io/state-of-open-source-security-report-2023-dwn-typ.html) - [State of Open Source Security](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Snyk-State-of-Open-Source-Security-2023.pdf) (2023) - Examines the current state of open source security, including trends and challenges across various industries.

## Cloud Security
- [Fortinet](https://www.fortinet.com/blog/industry-trends/key-findings-cloud-security-report-2024) - [Cloud Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Fortinet-Cloud-Security-Report-2024.pdf) (2024) - Examines the state of cloud security, highlighting key challenges, trends, and best practices for organizations across various industries.
- [ISC2](https://cloud.connect.isc2.org/cloud-security-report) - [Cloud Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/ISC2-Cloud-Security-Report-2024.pdf) (2024) - Provides insights into cloud security challenges, trends, and strategies across different sectors.
- [Mend](https://www.mend.io/resources/research-reports/the-state-of-supply-chain-threats/) - [State of Supply Chain Threats](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Mend-State-of-Supply-Chain-Threats.pdf) (2023) - Examines the current state of supply chain threats and vulnerabilities across different sectors.
- [PaloAlto](https://www.paloaltonetworks.com/state-of-cloud-native-security) - [State of Cloud Native Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/PaloAlto-State-of-Cloud-Native-Security-2024.pdf) (2024) - Examines the current state of cloud-native security, including trends, challenges, and best practices across different sectors.
- [Sonatype](https://www.sonatype.com/state-of-the-software-supply-chain/introduction) - [State of Cloud Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Sonatype-State-of-Cloud-Security-2024.pdf) (2024) - Provides insights into the state of cloud security and software supply chain management across different sectors.
- [Sophos](https://www.sophos.com/en-us/whitepaper/state-of-cybersecurity) - [State of Cloud Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Sophos-State-of-Cybersecurity-2023.pdf) (2023) - Examines the current state of cybersecurity, including trends and challenges faced by organizations across various industries.
- [Google](https://cloud.google.com/security/resources/cybersecurity-forecast) - [Cybersecurity Forecast 2025](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2025/Google-Cybersecurity-Forecast-2025.pdf) (2025) - Insights from Google Cloud leaders on emerging cybersecurity trends.

## Identity Security
- [Astrix](https://astrix.security/learn/whitepapers/the-state-of-non-human-identity-security/) - [State of Non Human Identity](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Astrix-The-State-of-Non-Human-Identity-Security-2024.pdf) (2024) - Highlights growing concerns over non-human identities as attack vectors, limited automation and visibility into API and third-party connections, and an increasing investment in NHI security.
- [ConductorOne](https://www.conductorone.com/resources/2024-identity-security/) - [Identity Security Outlook Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/ConductorOne-Identity-Security-Outlook-Report-2024.pdf) (2024)  
  Highlights how increasing technological and organizational complexity are driving new identity risks.
- [CyberArk](https://www.cyberark.com/threat-landscape/) - [Identity Security Threat Landscape Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/CyberArk-Identity-Security-Threat-Landscape-2024.pdf) (2024)  
  Examines the impact of cyberattacks on identity, including cyber debt, GenAI, machine identities, and third- and fourth-party risks.
- [IDS Alliance](https://www.idsalliance.org/white-paper/2024-trends-in-securing-digital-identities/) - [2024 Trends in Securing Digital Identities](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/AICD-Directors-Introduction-to-AI-2024.pdf) (2024) - Provides insights into current plans, historical trends, and approaches to cybersecurity and identity management.
- [Omada](https://omadaidentity.com/resources/analyst-reports/state-of-iga/) - [State of Identity Governance](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Omada-State-of-Identity-Governance-2024.pdf) (2024)  
  Highlights the modernization of identity governance driven by digital transformation and hybrid workforces, emphasizing SaaS-based solutions, analytics, and automation for scalable and secure identity management.
- [ManageEngine](https://www.manageengine.com/privileged-access-management/identity-threat-and-security-report-2024.html) - [Identity Security Survey](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/ManageEngine-Identity-Security-Insights-2024.pdf) (2024)  
  Explores global identity security readiness across industries and roles, examining the rising tide of AI-driven phishing, social engineering, and credential theft.

## Penetration Testing
- [Bugcrowd](https://www.bugcrowd.com/resources/report/the-total-economic-impact-of-bugcrowd-managed-bug-bounty/) - [The Total Economic Impact Of Bugcrowd Managed Bug Bounty](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Forrester-The-Total-Economic-Impact-Of-Bugcrowd-Managed-BugBounty-2024.pdf) (2024) - Analyzes the economic benefits and impacts of Bugcrowd's managed bug bounty programs, supported by data-driven insights from Forrester.
- [Cobalt](https://resource.cobalt.io/state-of-pentesting-2024) - [State of Pentesting](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Cobalt-State-of-Pentesting-2024.pdf) (2024) - Offers an overview of the current state of penetration testing, including trends, challenges, and best practices across various industries.
- [Fortra](https://www.fortra.com/services/consulting/cybersecurity/penetration-testing) - [Penetration Testing Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Fortra-Pentesting-Report-2024.pdf) (2024) - Provides insights into the current landscape of penetration testing, including common vulnerabilities and industry-specific challenges.
- [HackerOne](https://www.hackerone.com/resources/reporting/8th-hacker-powered-security-report) - [Hacker Powered Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/HackerOne-Hacker-Powered-Security-Report-2024.pdf) (2024) - Explores the state of hacker-powered security, including trends in bug bounty programs and vulnerability disclosure across industries.

## Privacy and Data Protection
- [Cisco](https://www.cisco.com/c/en/us/about/trust-center/data-privacy-benchmark-study.html) - [Data Privacy Benchmark Study](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Cisco-Privacy-Benchmark-Study-2024.pdf) (2024) - Provides insights into data privacy trends, challenges, and breaches across various industries.
- [Code42](https://www.code42.com/content/2024-data-exposure) - [Annual Data Exposure Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Code42-Annual-Data-Exposure-Report-2024.pdf) (2024)  
  Highlights insider threat risks and trends based on insights from over 700 security professionals.
- [Immuta](https://www.immuta.com/resources/2024-trendbook/) - [State of Data Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Immuta-State-of-Data-Security-Report-2024.pdf) (2024) - Examines the current state of data security, including challenges, trends, and best practices across various industries.
- [Proofpoint](https://www.proofpoint.com/us/resources/threat-reports/data-loss-landscape) - [Data Loss Landscape](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Proofpoint-Data-Loss-Landscape-2024.pdf) (2024) - Provides an overview of the data loss landscape, including trends and challenges faced by organizations across various industries.
- [Proofpoint](https://go.proofpoint.com/2024-Frost-Radar-for-Email-Security.html) - [Global Email Security Market Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Proofpoint-Global-Email-Security-Market-Report-2024.pdf) (2024) - Benchmarks 21 top email security vendors, highlighting growth opportunities and market trends.

## Ransomware
- [Cyberreason](https://www.cybereason.com/ransomware-the-true-cost-to-business-2024) - [Ransomware The True Cost to Business](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Cyberreason-Ransomware-The-True-Cost-to-Business-2024.pdf) (2024) - Examines the true cost of ransomware attacks on businesses across different sectors.
- [Fortinet](https://global.fortinet.com/lp-en-ap-2023ransomwareglobalrr) - [Global Ransomware Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Fortinet-Global-Ransomware-Report-2023.pdf) (2023) - Provides a global overview of ransomware trends and impacts across various industries.
- [Sophos](https://www.sophos.com/en-us/content/state-of-ransomware) - [State of Ransomware](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Sophos-State-of-Ransomware-2024.pdf) (2024) - Examines ransomware attack methods, likelihood, and business impacts based on insights from 5,000 IT and cybersecurity leaders across 14 countries.
- [Spycloud](https://spycloud.com/resource/2024-malware-ransomware-defense-report/) - [Ransomware Defense Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/Spycloud-Ransomware-Defense-Report-2024.pdf) (2024) - Examines malware and ransomware defense strategies and trends across different sectors.

## AI and Emerging Technologies
- [HiddenLayer](https://hiddenlayer.com/threatreport2024/) - [AI Threat Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2024/HiddenLayer-AI-Threat-Landscape-Report-2024.pdf) (2024) - Provides insights into the AI threat landscape across various industries.
- [Snyk](https://snyk.io/reports/ai-code-security/) - [AI Generated Code Security Report](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/Annual%20Security%20Reports/2023/Snyk-AI-Generated-Code-Security-Report-2023.pdf) (2023) - Examines the security implications of AI-generated code across different sectors.

## Resources
Annual reports are the result of a collaborative effort, combining research from both paid and non-profit sources, drawn from within the organization and the broader cybersecurity community. These reports rely on the contributions of various organizations that help shape the field by setting standards, offering certifications, conducting research, and influencing policy.

The categories below highlight the diverse roles these organizations play in building cybersecurity programs and advancing best practices. By exploring these groups, readers can gain insight into the ecosystem that underpins the development of annual reports and drives progress in the industry.

**[Research Consulting](#research-consulting):** These are organizations that offer paid research services, market analysis, and consulting in the field of information technology and cybersecurity.

**[Standards and Certifications](#standards-and-certifications):** Organizations involved in setting cybersecurity standards, providing certifications, and creating frameworks for best practices.

**[Threat Intelligence and Incident Response](#threat-intelligence-and-incident-response):** Organizations focused on sharing threat intelligence, coordinating cyber incident responses, and combating cyber threats.

**[Policy and Advocacy](#policy-and-advocacy):** Institutions shaping cybersecurity policies, regulations, and public awareness on a national or international scale.

**[Working Groups](#working-groups):** These are collaborative organizations or professional associations that conduct research, share information, and develop best practices in cybersecurity.

**[Government and Non-profits](#government-and-non-profits):** This category includes government agencies and non-profit organizations dedicated to cybersecurity research, policy development, and public awareness.

## Research Consulting
- [451 Research](https://www.451research.com/) - A technology research and advisory firm specializing in emerging technology segments including cybersecurity market analysis and trends.
- [ABI Research](https://www.abiresearch.com/) - A technology market intelligence company providing strategic guidance on transformative technologies, including cybersecurity and digital security.
- [Forrester Research](https://www.forrester.com/) - An advisory company that offers paid research, consulting, and event services specialized in market research for information technology.
- [Frost & Sullivan](https://www.frost.com/) - A consulting firm offering market research and analysis in cybersecurity, with particular focus on emerging technologies and market opportunities.
- [Gartner](https://www.gartner.com/) - A technology research and consulting firm which offers private paid consulting as well as executive programs and conferences.
- [GigaOm](https://gigaom.com/) - A research firm offering practical, hands-on, practitioner-driven research for businesses.
- [International Data Corporation (IDC)](https://www.idc.com/) - A global provider of market intelligence and advisory services.
- [KuppingerCole](https://www.kuppingercole.com/) - A global analyst company specializing in information security, identity & access management, and risk management.
- [Omdia](https://omdia.tech.informa.com/) - A global technology research powerhouse focusing on cybersecurity market analysis and digital transformation.

## Standards and Certifications
- [American Institute of CPAs](https://us.aicpa.org/) - The AICPA SOC2 is a framework for managing and safeguarding customer data based on five trust service criteria: Security, Availability, Processing Integrity, Confidentiality, and Privacy.
- [The Information Security Forum (ISF)](https://www.securityforum.org/) - A global, independent organization dedicated to benchmarking and sharing best practices in information security.
- [The International Organization for Standardization (ISO)](https://www.iso.org/) - An international organizational body composed of representatives which conduct closed research for creation of standards.
- [The Information Systems Audit and Control Association (ISACA)](https://www.isaca.org/) - An international professional association focused on IT governance, which conducts research for and on behalf of the members.
- [The International Information System Security Certification Consortium (ISC)²](https://www.isc2.org/) - An American not-for-profit organization which conducts research for consumers of their cybersecurity training and certifications.
- [SANS Institute](https://www.sans.org/) - A private U.S. for-profit company which conducts research for consumers of their cybersecurity training and certifications.
- [Trusted Computing Group (TCG)](https://trustedcomputinggroup.org/) - Develops and promotes open standards for hardware-enabled security.

## Threat Intelligence and Incident Response
- [The Anti-Phishing Working Group (APWG)](https://apwg.org/) - A global coalition focused on unifying the global response to cybercrime.
- [The Cyber Threat Alliance (CTA)](https://www.cyberthreatalliance.org/) - An industry-driven group of cybersecurity organizations that share threat intelligence and conduct collaborative research to combat cyber threats.
- [The Forum of Incident Response and Security Teams (FIRST)](https://www.first.org/) - Provides platforms, means and tools for incident responders to always find the right partner and to collaborate efficiently.
- [The Global Cyber Alliance (GCA)](https://globalcyberalliance.org/) - An international, cross-sector effort dedicated to reducing cyber risk.
- [The Messaging, Malware and Mobile Anti-Abuse Working Group (M3AAWG)](https://www.m3aawg.org/) - Focuses on operational issues of Internet abuse including botnets, malware, spam, viruses, and mobile messaging abuse.
- [Ponemon Institute](https://www.ponemon.org/) - Considered the pre-eminent research center dedicated to privacy, data protection and information security policy.

## Policy and Advocacy
- [The Rand Corporation](https://www.rand.org/) - An American not-for-profit organization which conducts research and analysis on various aspects of cybersecurity and cyber policy focused on national security.
- [Center for Strategic and International Studies (CSIS) - Technology Policy Program](https://www.csis.org/programs/technology-policy-program) - A think tank with a Technology Policy Program that conducts research and provides insights into technology and cybersecurity policies.
- [Electronic Frontier Foundation (EFF)](https://www.eff.org/) - A non-profit organization defending civil liberties in the digital world, including privacy and cybersecurity issues.
- [The Internet Security Alliance (ISA)](https://isalliance.org/) - A multi-sector trade association focused on thought leadership, policy advocacy, and standards development for cybersecurity.
- [World Economic Forum (Centre for Cybersecurity)](https://www.weforum.org/centre-for-cybersecurity) - A global initiative that brings together stakeholders from industry, government, and academia to improve cybersecurity globally and secure the digital economy.

## Working Groups
- [The Cloud Security Alliance (CSA)](https://cloudsecurityalliance.org/) - Promotes best practices for providing security assurance within cloud computing.
- [The Internet Engineering Task Force (IETF)](https://www.ietf.org/) - Develops and promotes internet standards, including those related to security.
- [The Open Web Application Security Project (OWASP)](https://owasp.org/) - A professional community that produces research concerning web application security, made freely available to the online community.
- [Industrial Control Systems Joint Working Group (ICSJWG)](https://www.cisa.gov/icsjwg) - Facilitates information sharing and collaboration for cybersecurity in industrial control systems.
- [The Open Source Security Foundation (OpenSSF)](https://openssf.org/) - A cross-industry collaboration to improve the security of open source software.
- [Web Application Security Consortium (WASC)](http://www.webappsec.org/) - An international group of experts, industry practitioners, and organizational representatives who produce security standards and research.

## Government and Non-profits
- [Australian Cyber Security Centre (ACSC)](https://www.cyber.gov.au/) - Provides cyber security advice and support to Australian businesses and individuals.
- [Canadian Centre for Cyber Security](https://cyber.gc.ca/en/) - Canada's national authority on cybersecurity.
- [Center for Internet Security (CIS)](https://www.cisecurity.org/) - An American non-profit organization that provides cybersecurity solutions and best practices.
- [Cybersecurity and Infrastructure Security Agency (CISA)](https://www.cisa.gov/) - A U.S. government agency responsible for enhancing the security and resilience of the nation's critical infrastructure.
- [Cybersecurity Forum Initiative (CSFI)](https://www.csfi.us/) - An American non-profit organization that promotes cybersecurity awareness and research.
- [Cyber Peace Institute](https://cyberpeaceinstitute.org/) - A non-profit organization focused on reducing the impact of cyberattacks on civilians and promoting peace in cyberspace by supporting international cooperation and collective action.
- [European Union Agency for Cybersecurity (ENISA)](https://www.enisa.europa.eu/) - A European Union agency that contributes to EU cybersecurity policy, enhances trust in digital services, and supports incident response capabilities across Europe.
- [Europol - European Cybercrime Centre (EC3)](https://www.europol.europa.eu/activities-services-main/areas-interest/european-cybercrime-centre-ec3) - A strategic alliance focused on combating cybercrime within the European Union.
- [German Federal Office for Information Security (BSI)](https://www.bsi.bund.de/) - Germany's national cyber security authority providing IT security services and guidance.
- [Internet Security Research Group (ISRG)](https://www.abetterinternet.org/) - A non-profit organization focused on reducing financial, technological, and educational barriers to secure communication over the Internet.
- [Japan National Center of Incident Readiness and Strategy for Cybersecurity (NISC)](https://www.nisc.go.jp/eng/) - Japan's central organization for national cybersecurity strategy and incident response.
- [Korean Internet & Security Agency (KISA)](https://www.kisa.or.kr/eng/) - South Korea's government agency dedicated to promoting cybersecurity and a safer internet environment.
- [MITRE Corporation](https://www.mitre.org/) - An American not-for-profit organization which conducts research and development supporting various U.S. government agencies.
- [National Cyber Security Centre (NCSC)](https://www.ncsc.gov.uk/) - The UK's technical authority for cyber incidents.
- [National Cyber Security Centre - Netherlands (NCSC-NL)](https://www.ncsc.nl/english) - The Dutch national cyber security center providing guidance and incident response.
- [National Institute of Standards and Technology (NIST)](https://www.nist.gov/cybersecurity) - A U.S. agency that develops cybersecurity standards and guidelines.
- [Norwegian National Security Authority (NSM)](https://nsm.no/en/) - Norway's expert body for information and object security, providing guidance and incident response capabilities.
- [Singapore Cyber Security Agency (CSA)](https://www.csa.gov.sg/) - Singapore's national agency overseeing cybersecurity strategy and development.

## Contributing
[Please refer to the guidelines at https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/CONTRIBUTING.md for details](https://github.com/jacobdjwilson/awesome-annual-security-reports/blob/master/CONTRIBUTING.md).
