<div class="github-widget" data-repo="JStumpp/awesome-android"></div>
## Awesome Android
[<img src="https://raw.githubusercontent.com/jstumpp/awesome-android/master/awesome-android.png">](https://raw.githubusercontent.com/jstumpp/awesome-android)

<p align="center">
  <a href="https://raw.githubusercontent.com/sindresorhus/awesome"><img alt="awesome" src="https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg" /></a>
  <a href="https://travis-ci.org/JStumpp/awesome-android"><img alt="Build Status" src="https://api.travis-ci.org/JStumpp/awesome-android.svg?branch=master" /></a>
  <img alt="PRs Welcome" src="https://img.shields.io/badge/PRs-welcome-brightgreen.svg" />
</p>

## About
A curated list of awesome Android [libraries](#libraries) 和 [resources](#resources) . 对于一般的 Java 库，请查看 [awesome-java](https://github.com/akullpp/awesome-java).

### Understand How Your Android App is Doing with Real-Time Contextual Insights From Your Users
[![instabug-github](https://user-images.githubusercontent.com/10850625/65512691-fd45f280-ded9-11e9-8921-3528b98c30a7.png)](https://instabug.com/android/sdk?utm_source=awesomeandroid&utm_medium=spon&utm_content=banner)
 &gt;Instabug 帮助 Android 开发人员和产品团队轻松收集错误和来自 Beta 测试人员和用户的反馈，以更快地迭代并交付高质量的应用程序.  Instabug 会自动附加屏幕截图、设备详细信息、网络日志、重现步骤以及解决问题和确定产品待办事项优先级所需的大量其他重要见解. 
&gt; 移动团队通过与 Github、Jira、Slack、Zendesk 等第三方工具无缝集成来加速他们的工作流程. [Instabug is offering Awesome Android community an exclusive 15% discount on all paid plans. Get Started!](https://instabug.com/android/sdk/?utm_source=awesomeandroid&utm_medium=spon&utm_content=get-started)
[![](https://instabug-ga.appspot.com/UA-41982088-6/github/awesomeandroid?pixel)](https://instabug.com)


## How to Use
Awesome-Android 是一个令人惊叹的列表，适用于需要在其应用程序中添加特定功能的人，因此最好的使用方法是：
 - 只需按 command + F 即可搜索关键字
 - 浏览我们的内容菜单


## Emulators
- [AndY](https://andyroid.net)
- [ARChon](https://archon-runtime.github.io)
- [BlueStacks](https://www.bluestacks.com)
- [Genymotion](https://www.genymotion.com)
- [nox](https://www.bignox.com)

## Libraries

### Charts

- [AChartEngine](https://github.com/ddanny/achartengine) - 图表引擎.
- [EazeGraph](https://github.com/blackfizz/EazeGraph) - 图表和图形库.
- [WilliamChart](https://github.com/diogobernardino/WilliamChart) - 具有良好动态功能的图表库.
- [HelloCharts](https://github.com/lecho/hellocharts-android) - 支持缩放、滚动和动画的图表和图形库.
- [MPAndroidChart](https://github.com/PhilJay/MPAndroidChart) - 支持手势缩放和拖动的 Android 图表和图形库.
- [ArcChartView](https://github.com/imaNNeoFighT/ArcChartView) - 绘制创意统计弧形图.
- [AnyChart](https://github.com/AnyChart/AnyChart-Android) - 数据可视化库，交互式图表.

### Cloud Services

- [CloudRail](https://cloudrail.com) - 统一的 API 库：云存储、社交资料、支付、电子邮件、SMS 和 POI.

### Data binding

- [Anvil](https://github.com/anvil-ui/anvil)  - 受 React 启发，用于创建反应式 UI 组件的小型库. 提供数据绑定和事件监听器绑定，非常适合MVVM.
- [Data Binding Library](https://developer.android.com/topic/libraries/data-binding/) - 官方 Android 数据绑定库，用于编写声明式布局并最大限度地减少绑定应用程序逻辑和布局所需的胶水代码.

### Dependency Injection

- [Dagger 2](https://github.com/google/dagger) - 适用于 Android 和 Java 的快速依赖注入器.
- [Butter Knife](http://jakewharton.github.io/butterknife/) - 查看 Android 的“注入”库.
- [ActivityStarter](https://github.com/MarcinMoskala/ActivityStarter) - Android 库提供更简单的方法来启动具有多个参数的活动.
- [AndroidAnnotations](https://github.com/androidannotations/androidannotations) - 在编译时使用依赖注入的 Java 注释.
- [Toothpick](https://github.com/stephanenicolas/toothpick) - 基于作用域树的 Java 依赖注入 (DI) 库.

### Android Services
- [Remoter](https://github.com/josesamuel/remoter) - 使用纯 Java 接口的 Android 远程 IPC 服务的 Android AIDL 替代方案.
- [Service Connector](https://github.com/josesamuel/serviceconnector) - 将 Android 服务和回调绑定到字段和方法.

### Game Development

- [Libgdx](https://libgdx.badlogicgames.com/) - 跨平台游戏引擎和SDK. [Open Source](https://github.com/libGDX/libGDX)
- [Vuforia](https://www.vuforia.com/) - 增强现实图书馆.
- [Unity](https://unity3d.com/unity/features/multiplatform) - 跨平台游戏创建系统.
- [Rajawali](https://github.com/Rajawali/Rajawali) - Android OpenGL ES 2.0/3.0 引擎
- [Cocos2d-x](https://cocos2d-x.org/) - 跨平台 2d 游戏框架.
- [JustWeEngine](https://github.com/lfkdsk/JustWeEngine) - 一个简单的开源 Android 原生游戏框架.

### Security

- [libsignal-protocol-java](https://github.com/signalapp/libsignal-protocol-java) - 在同步和异步消息传递环境中工作的棘轮前向保密协议.
- [Themis](https://github.com/cossacklabs/themis) - 使典型加密方案易于使用的多语言框架：静态数据、经过身份验证的数据交换、传输保护、身份验证等.

### GUI

- [Pull to refresh](https://developer.android.com/reference/android/support/v4/widget/SwipeRefreshLayout) - v4 支持库中提供了滑动刷新布局.
- [Cardslib](https://github.com/gabrielemariotti/cardslib) - 用于构建 UI 卡的 Android 库.
- [AndroidStaggeredGrid](https://github.com/etsy/AndroidStaggeredGrid) - 网格视图，支持具有不同大小的行的多列.
- [Flow](https://github.com/square/flow) - 有助于将应用程序描述为适度独立屏幕的集合的库.
- [SortableTableView](https://github.com/ISchwarz23/SortableTableView) - 一个包含简单 TableView 和高级 SortableTableView 的 Android 库，提供大量定制可能性以满足所有需求.
- [MaterialProgressBar](https://github.com/zhanghai/MaterialProgressBar) - 具有一致外观的材质设计 ProgressBar.
- [AndroidFillableLoaders](https://github.com/JorgeCastilloPrz/AndroidFillableLoaders)  - 使用 SVG 路径的可填充进度视图. 创建有趣的应用程序徽标也是不错的选择.
- [NexusDialog](https://github.com/dkharrat/NexusDialog) - 允许您使用很少的代码在 Android 中轻松快速地创建表单.
- [Snap RecyclerView Utils](https://github.com/prashantsolanki3/Snap-RecyclerView-Utils) - 在不创建适配器的情况下填充单个或多个布局 RecyclerView.
- [MultiSnapRecyclerView](https://github.com/TakuSemba/MultiSnapRecyclerView) - 用于多次捕捉 RecyclerView 的 Android 库
- [SwipeableCard](https://github.com/michelelacorte/SwipeableCard) - 实现像街景一样的刷卡！！
- [ElasticProgressBar](https://github.com/michelelacorte/ElasticProgressBar) - 漂亮的载入栏.
- [EntryScreenManager](https://github.com/kunall17/EntryScreenManager) -介绍/进入/演练/开始屏幕.
- [EasyIntro](https://github.com/meNESS/EasyIntro) - 适用于您的 Android 项目的灵活、易于使用的多合一应用程序介绍库.
- [Material-Calendar-View](https://github.com/BlackBoxVision/material-calendar-view) - 与 API 8+ 兼容的 Material Design 日历
- [CrunchyCalendar](https://github.com/CleverPumpkin/CrunchyCalendar) - 具有无限滚动、日期范围选择和颜色自定义的材料日历小部件.
- [SmoothOverscrollableScrollView](https://github.com/vovaksenov99/OverscrollableScrollView)  - 具有平滑滚动的小型自定义视图. 您可以添加带有比例背景的标题
- [SectionedRecyclerViewAdapter](https://github.com/luizgrp/SectionedRecyclerViewAdapter) - 允许将 RecyclerView 拆分为带有页眉和/或页脚的部分的适配器.
- [DragListView](https://github.com/woxblom/DragListView) - 拖放以重新排序列表、网格或面板中的项目.
- [Animated Expanding ListView](https://github.com/LeonardoCardoso/Animated-Expanding-ListView) - 动画扩展 ListView 在扩展或折叠列表视图项目的内容时提供精美的动画.
- [TastyToast](https://github.com/yadav-rahul/TastyToast) - 带有图标和颜色的祝酒词.
- [DotLoader](https://github.com/bhargavms/DotLoader) - 带点的可自定义加载动画.
- [PodSlider](https://github.com/bhargavms/PodSLider) - 符合材料设计规范的可定制滑块小部件.
- [TapTargetView](https://github.com/KeepSafe/TapTargetView) - 用于功能发现的 Material Design 指南中的点击目标的实现.
- [ShowCaseView](https://github.com/mreram/ShowCaseView) - ShowcaseView 库旨在通过有吸引力的平面覆盖向用户突出显示和展示应用程序的特定部分.
- [MaterialIntroScreen](https://github.com/TangoAgency/material-intro-screen) - 具有易于扩展的 API 的 Material Intro Screen 实现.
- [FloatingView](https://github.com/UFreedom/FloatingView) - FloatingView 可以让目标视图漂浮在锚点视图上方，动画很酷.
- [Timecon](https://github.com/alxrm/animated-clock-icon) - 易于使用的动画时钟图标
- [Audiogram](https://github.com/alxrm/audiowave-progressbar) - 轻量级音频进度条
- [Bubbles for Android](https://github.com/txusballesteros/bubbles-for-android) - Facebook 喜欢聊天气泡库
- [Litho (By Facebook)](https://github.com/facebook/litho) - 用于在 Android 上构建高效 UI 的声明性框架.
- [MultiViewAdapter](https://github.com/DevAhamed/MultiViewAdapter) - Recyclerview 适配器库，用于创建可组合的视图持有者.
- [LGSnackbar](https://github.com/loregr/LGSnackbar) - 本机 Android Snackbar 的易于使用和可定制的包装器，它在多个活动中保持可见.
- [ShimmerLayout](https://github.com/team-supercharge/ShimmerLayout) - Android 应用程序的内存高效闪烁效果.
- [CircleProgressBar](https://github.com/emre1512/CircleProgressBar) - 一个用于为 Android 创建循环进度条的简单库.
- [Easy-Signature-Android](https://github.com/smalam119/Easy-Signature-Android) - 一个简单的 ui 库，提供可插入的签名视图.
- [Flashbar](https://github.com/aritraroy/Flashbar) - 一个高度可定制、功能强大且易于使用的 Android 警报库.
- [YuanaItemSettingView](https://github.com/andhikayuana/YuanaItemSettingView) - 适用于 Android 的可自定义项目设置视图.
- [Gradients](https://github.com/bakhtiyork/gradients) - 精选的精美渐变系列.
- [OneAdapter](https://github.com/ironSource/OneAdapter) - 具有多个模块和挂钩的 RecyclerView 适配器可简化和增强使用，同时防止常见错误.

#### Paginate
- [NoPaginate](https://github.com/NoNews/NoPaginate) - 简单的安卓分页库

#### ActionBar
- [ActionBarSherlock](http://actionbarsherlock.com) - 适用于旧版 Android 的 ActionBar.
- [FadingActionBar](https://github.com/ManuelPeinado/FadingActionBar) - 在新的 Play Music 应用程序中可以看到渐变操作栏效果.

#### Navigation
- [SlidingMenu](https://github.com/jfeinstein10/SlidingMenu) - 用于创建带有滑入式菜单的应用程序的库.
- [SlidingTutorial](https://github.com/Cleveroad/slidingtutorial-android) - 有助于创建很棒的滑动 android 应用程序教程的简单库.
- [PagerSlidingTabStrip](https://github.com/astuetz/PagerSlidingTabStrip) - 在 ViewPager 的不同页面之间导航的交互式指示器.
- [Page View indicator](https://github.com/JakeWharton/ViewPagerIndicator) - 支持水平滚动 ViewPager.
- [RecyclerTabLayout](https://github.com/nshmura/RecyclerTabLayout) - 使用 RecyclerView 实现的高效 TabLayout 库.
- [MaterialDrawer](https://github.com/mikepenz/MaterialDrawer) - 简单采用材料设计导航抽屉.
- [Debug-Artist](https://github.com/BaristaVentures/android-debug-artist) - 调试菜单可轻松启用 leakcanary、scalpel 和其他工具.
- [Floating-Navigation-View](https://github.com/andremion/Floating-Navigation-View) - 一个简单的浮动操作按钮，显示锚定的导航视图.

#### Animations
- [Rebound](https://github.com/facebook/rebound) - Rebound 是一个模拟弹簧动力学的 Java 库.
- [Android View Animations](https://github.com/daimajia/AndroidViewAnimations) - 可爱的视图动画集合.
- [Android-Transition](https://github.com/kaichunlin/android-transition) - 允许轻松创建对用户输入做出反应的视图转换.
- [Android-View-Actions](https://github.com/dtx12/AndroidAnimationsActions) - 使为视图创建复杂的动画变得容易.
- [Swipper](https://github.com/mdg-iitr/Swipper) - 用于控制音量、亮度和搜索的滑动手势的 Android 库.
- [Spotlight](https://github.com/TakuSemba/Spotlight) - 为教程或演练等点亮项目的 Android 库...

#### Images

- [Crescento](https://github.com/developer-shivam/crescento) - 通过在图像视图下方添加曲线来探索材料设计的新风格.
- [android-crop](https://github.com/jdamcd/android-crop) - 用于裁剪图像的库项目.
- [CircularImageView](https://github.com/Pkmmte/CircularImageView) - 圆形图像的自定义视图，同时保持最佳绘制性能.
- [Android-Image-Filter](https://github.com/ragnraok/android-image-filter) - 用于轻松应用图像过滤器的库项目.
- [Compressor](https://github.com/zetbaitsu/Compressor) - Compressor 是一个轻量级且功能强大的安卓图像压缩库.
- [ShapeImageView](https://github.com/siyamed/android-shape-imageview) - 以不同形状显示图像的库.

#### Inputs

- [FloatingLabel](https://github.com/hardik-trivedi/FloatingLabel)  - FloatingLabel 允许您创建一种打击类型的 EditText.  *没有 Gradle 或 Maven 支持.*
- [MaterialEditText](https://github.com/rengwuxian/MaterialEditText) - 支持浮动标签、单行省略号、最大/最小字符、帮助文本和带有自定义颜色的错误文本.
- [EmojiCompat](https://github.com/googlearchive/android-EmojiCompat) - 将表情符号添加到您的应用程序
- [MaterialSearchBar](https://github.com/mancj/MaterialSearchBar) - 适用于 Android 的 Material Design 搜索栏
- [InputMask](https://github.com/RedMadRobot/input-mask-android) - 基于模式的用户输入格式化程序、解析器和验证器.
- [SweetPassword](https://github.com/jesusmartinoza/Sweet-Password) - 允许自定义切换按钮的密码 EditText
- [VoiceOverlay](https://github.com/algolia/voice-overlay-android) - 一个叠加层，可获得用户的语音许可并在可自定义的 UI 中以文本形式输入.

#### View Pagers
- [Material Dots Indicators](https://github.com/tommybuonomo/dotsindicator) - 用于查看寻呼机的三种材料点指示器样式.

#### Loading Images

- [Picasso](https://github.com/square/picasso) - 一个强大的安卓图像下载和缓存库.
- [Universal Image Loader](https://github.com/nostra13/Android-Universal-Image-Loader) - Asynchronous, out of the box loading and caching of images.
- [Glide](https://github.com/bumptech/glide) - 适用于 Android 的图像加载和缓存库，专注于平滑滚动，由 Google 推荐.
- [Fresco](https://github.com/facebook/fresco) - 用于管理图像及其使用的内存的 Android 库.
- [Glide Bitmap Pool](https://github.com/amitshekhariitbhu/GlideBitmapPool) - Glide Bitmap Pool 是一个内存管理库，用于重用位图内存.
- [Coil](https://github.com/coil-kt/coil) - 由 Kotlin Coroutines 支持的 Android 图像加载.

#### Media Picker

- [MediaPicker](https://github.com/alhazmy13/MediaPicker) - Android 库，可让您为 Android 选择多个图像、视频或语音
- [Android Image Picker](https://github.com/esafirm/android-image-picker)  - 使从图库中选择图像和视频变得容易的库. 它还支持 GIF 和简单的相机动作

#### Video

- [ijkplayer](https://github.com/Bilibili/ijkplayer) - 基于 FFmpeg n3.2 的 Android/iOS 视频播放器，支持 MediaCodec、VideoToolbox.
- [Exoplayer](https://github.com/google/ExoPlayer) - ExoPlayer 是适用于 Android 的应用程序级媒体播放器，允许在本地和通过 Internet 播放音频和视频.
   支持基于 HTTP 的动态自适应流式传输 (DASH)、SmoothStreaming 和 Common Encryption 等功能
- [VideoPlayView](https://github.com/MarcinMoskala/VideoPlayView) - 带有视频播放器、播放/停止、加载器和占位符图像的自定义 Android 视图.

#### Camera

- [MagicalCamera](https://github.com/fabian7593/MagicalCamera) - 拍摄或选择画廊照片的简单方法，以及管理图片的其他功能.
- [Camera](https://github.com/duanhong169/Camera) - 使用安卓相机拍照和录像，基于camera2 api.

#### Field Validation
- [Convalida](https://github.com/WellingtonCosta/convalida) - 一种简单且基于注释的方法来验证您的输入字段.

### JSON

- [Gson](https://github.com/google/gson) - Gson 是一个 Java 库，用于将 Java 对象从 JSON 序列化和反序列化为 JSON.
- [Jackson JSON Processor](https://github.com/FasterXML/jackson) - 高性能 JSON 处理器.
- [Moshi](https://github.com/square/moshi) - 适用于 Android 和 Java 的现代 JSON 库.
### Crash monitoring

- [Fabric Crashlytics](https://get.fabric.io/) - 简单的崩溃报告解决方案.
- [HockeyApp](https://www.hockeyapp.net/) - 分发、崩溃报告、反馈和分析
- [Splunk MINT](https://mint.splunk.com/) - 监控、崩溃报告、实时数据、统计.
- [Bugsnag](https://www.bugsnag.com/)  - 跨平台错误监控. 免费层. 支持 SDK 和 NDK. 错误报告包括有关设备、版本、用户的数据，并允许任意数据.
- [Catcho](https://github.com/alhazmy13/Catcho) - 不再强制关闭.
- [Apteligent](https://www.apteligent.com/)  - 跨平台崩溃报告/分析解决方案. 支持 NDK 日志.
- [Instabug](https://instabug.com/) - 错误报告、崩溃报告、应用内反馈.

### Networking

- [Ion](https://github.com/koush/ion) - 良好的 android 网络库.
- [OkHttp](https://github.com/square/okhttp) - 用于 Android 和 Java 应用程序的 HTTP+SPDY 客户端.
- [RoboSpice](https://github.com/stephanenicolas/robospice) - 使编写异步网络请求变得容易的库.
- [IceNet](https://github.com/anton46/IceNet) - 适用于 Android 的快速、简单和轻松的网络
- [Android Volley](https://developer.android.com/training/volley/) - 官方 Android HTTP 库，使网络更容易和更快.
- [IceSoap](https://github.com/AlexGilleran/IceSoap) - 适用于 Android 的简单、异步、基于注释的 SOAP.
- [node-android](https://github.com/InstantWebP2P/node-android) - 在 Android 上运行 Node.js.
- [HappyDns](https://github.com/qiniu/happy-dns-android)  - 一个 Dns 库，用户可以使用自定义的 dns 服务器，dnspod httpdns. 只支持A记录.
- [RESTMock](https://github.com/andrzejchm/RESTMock) - 用于模拟 Android Instrumentation 测试中的 API 响应的 HTTP Web 服务器.
- [Fast-Android-Networking](https://github.com/amitshekhariitbhu/Fast-Android-Networking) - 一个完整的快速 Android 网络库，也支持 HTTP/2.

### Logger
- [logger](https://github.com/orhanobut/logger) - 简单、漂亮和强大的安卓记录器
- [timber](https://github.com/JakeWharton/timber) - 一个带有小型可扩展 API 的记录器，它在 Android 的普通 Log 类之上提供实用程序.
- [LoggingInterceptor](https://github.com/ihsanbal/LoggingInterceptor) - 一个 OkHttp 拦截器，它可以很好地记录请求和响应数据.
- [Bugfender](https://github.com/bugfender/BugfenderSDK-android-sample) - 上传您的日志并在线查看，专为移动设备打造
- [EzyLogger](https://github.com/afiqiqmal/EzyLogger) - 简单的轻量级记录器
- [Logback Android](https://github.com/tony19/logback-android) - Android 的登录端口，为 Android 应用程序提供高度可配置的日志记录框架.

### Notifications
- [android-remote-notifications](https://github.com/kaiwinter/android-remote-notifications) - 从远程 JSON 文件中提取通知并将其显示在您的应用程序中.
- [Android HeartBeat Fixer](https://github.com/joaopedronardari/AndroidHeartBeatFixer) - 设置心跳间隔和用户从 GCM 接收 PushNotifications 的方法.

### Database
- [Cupboard](https://bitbucket.org/littlerobots/cupboard) - 通过直接数据库访问或通过 ContentProvider 框架轻松访问 sqlite.
- [DbInspector](https://github.com/infinum/android_dbinspector) - 提供一种简单的方法来查看应用程序内数据库的内容以进行调试.
- [SQLite Asset Helper](https://github.com/jgilfelt/android-sqlite-asset-helper) - 使用应用程序的原始资产文件管理数据库创建和版本管理.
- [Realm](https://github.com/realm/realm-java)  - SQLite 和 ORM 的替代品：简单、现代且快速！ 面向对象的 API 和多平台支持.
- [Realm Asset Helper](https://github.com/eggheadgames/android-realm-asset-helper)  - 从 apk 资产文件夹中复制一个领域数据库. 有效地处理只读领域数据库的版本控制.
- [RestorableSQLiteDatabase](https://github.com/yaa110/RestorableSQLiteDatabase) - 一个包装器，用于复制具有恢复功能的 android 的 SQLiteDatabase.
- [Nitrite Database](https://github.com/dizitart/nitrite-database) - 适用于 Android 的 NoSQL 嵌入式文档存储，带有类似 MongoDb 的 API.

#### ORM

- [requery](https://github.com/requery/requery) - 用于 Java 和 Android 的编译时 ORM 和 SQL 查询库.
- [GreenDAO](http://greenrobot.org/greendao/) - 轻便快速的 ORM 解决方案.
- [ORMLite](http://ormlite.com/sqlite_java_android_orm.shtml) - 用于 JDBC 和 Android 的轻量级 ORM Java 包.
- [ActiveAndroid](http://www.activeandroid.com) - 活动记录样式 ORM.
- [Sugar ORM](http://satyan.github.io/sugar/) - 使用 Android 数据库的极其简单的方法.
- [DBFlow](https://github.com/agrosner/DBFlow) - 具有编译时注释处理功能的快速而强大的 ORM.
- [NexusData](https://github.com/dkharrat/NexusData) - 适用于 Android 的对象图和持久性框架.
- [SimpleNoSQL](https://github.com/Jearil/SimpleNoSQL)  - 适用于 Android 的简单 NoSQL 客户端. 意味着使用键/值对和一些基本查询的文档存储. 对于避免 SQL 代码的麻烦很有用.
- [RxSimpleNoSQL](https://github.com/xmartlabs/RxSimpleNoSQL)  - SimpleNoSQL 的响应式扩展. 使用 Observables 操作实体.

### REST

- [Retrofit](https://square.github.io/retrofit/) - Retrofit 将您的 REST API 变成 Java 接口.
- [Spring for Android - Rest Template](https://github.com/spring-projects/spring-android) - 适用于 Android 的 Rest 客户端.

### Testing

- [Robotium](https://github.com/robotiumtech/robotium) - 用于黑盒 UI 测试的测试自动化框架.
- [Roboletric](http://robolectric.org/) - 单元测试框架，用于在您的工作站上的 JVM 内部运行测试，而不是在模拟器中.
- [AssertJ Android](https://github.com/square/assertj-android) - 面向 Android 的 AssertJ 断言.
- [Green Coffee](https://github.com/mauriciotogneri/green-coffee) - 在您的 Android 仪器测试中运行您的 Cucumber 测试.

### Tracking

- [MobileAppTracking](https://www.tune.com/) - Tracking your marketing campaigns across multiple ad networks.
- [Mixpanel](https://mixpanel.com/) - 用于分析用户的分析平台.
- [Countly](https://count.ly) - 基于 Node.js、MongoDB 和 Linux 的开源移动和网络分析、推送通知和崩溃报告平台.
- [CleverTap](https://clevertap.com) - 具有 100 万个免费事件的分析平台和用户参与平台

### Maps

- [Google-Directions-Android](https://github.com/jd-alexander/Google-Directions-Android) - 允许您计算两个位置之间的方向，并使用 Google Directions API 在 Google 地图上显示路线.
- [Android Maps Extensions](https://github.com/mg6maciej/android-maps-extensions) - 扩展 Google Maps Android API v2 的功能，添加标记聚类等
- [MapScaleView](https://github.com/pengrad/MapScaleView) - 谷歌地图 Android API 的比例尺
- [GLMap](https://globus.software)  - 具有 MapCSS 样式的跨平台离线矢量地图. 包括离线搜索和离线导航.

### Utility
- [Conceal SharedPreferences](https://github.com/afiqiqmal/SharedChamber) - 使用名为 Conceal 的 Facebook 安全加密保护首选项.
- [EventBus](http://greenrobot.github.io/EventBus/) - EventBus 是一个库，可简化应用程序不同部分之间的通信.
- [Otto](https://github.com/square/otto) - 安卓事件总线.
- [Weak handler](https://github.com/badoo/android-weak-handler) - 内存更安全的 android.os.Handler 实现.
- [Byte Buddy](http://bytebuddy.net) - 支持 Android 的运行时代码生成库.
- [Secure Preference Manager](https://github.com/prashantsolanki3/Secure-Pref-Manager)  - Android 的安全首选项管理器. 它使用各种加密来保护您的应用程序的共享首选项.
- [LeakCanary](https://github.com/square/leakcanary) - 捕捉发生的内存泄漏.
- [Drekkar](https://github.com/coshx/drekkar) - 用于 WebView 和 JS 的 Android 事件总线.
- [Androl4b](https://github.com/sh4hin/Androl4b) - 用于评估 Android 应用程序的虚拟机.
- [DroidMVP](https://github.com/andrzejchm/DroidMVP) - Android 库可帮助您将 MVP 以及被动视图和演示模型模式整合到您的应用程序中.
- [EasyDeviceInfo](https://github.com/nisrulz/easydeviceinfo) - 以超级简单的方式获取设备信息.
- [Shutter-Android](https://github.com/levibostian/Shutter-Android) - 从设备相机捕获照片/视频或从图库应用程序获取照片/视频，无需运行时权限.
- [Validator](https://github.com/anderscheow/Validator) - 一个实用程序类，用于验证 TextInputLayout 中的文本.
- [Keyboard Visibility Event](https://github.com/viniciusmo/keyboard-visibility-event-android/) - 处理软键盘可见性更改事件的 DSL.
- [TimeIt](https://github.com/yashovardhan99/timeit) - 一个适用于 Android 的秒表库，可以轻松地在应用程序中启动、暂停、显示和维护多个秒表.
- [Reactor](https://github.com/oky2abbas/reactor) - Reactor 是一个快速安全的 Android 键值库.
 
### Debugging Tools

- [Linx](https://github.com/pedrovgs/Lynx) - 在设备内部显示 logcat 以进行调试构建
- [Scalpel](https://github.com/JakeWharton/scalpel) - 在手机中以 3d 形式查看整个层次结构.
- [Stetho](https://github.com/facebook/stetho) - 从 chrome 调试层次结构和网络.
- [Android Debug Database](https://github.com/amitshekhariitbhu/Android-Debug-Database) - Android 调试数据库是一个强大的库，用于调试 Android 应用程序中的数据库和共享首选项.
- [Android Debug Bridge - ADB](https://github.com/mzlogin/awesome-adb/blob/master/README.en.md) - 帮助调试 Android 设备的命令行工具
- [ADB Enhanced](https://github.com/ashishb/adb-enhanced) - 为开发人员提供的 ADB 命令行包装器，这样开发人员就不必记住深奥的依赖于版本的命令
- [Pidcat](https://github.com/JakeWharton/pidcat) - 彩色命令行 ADB 包装器，仅显示特定应用程序包的日志条目
- [AppSpector](https://appspector.com)  - 远程Android和iOS调试和数据收集服务. 您可以调试网络、日志、SQLite 和模拟设备的地理位置.


### Wireless

- [SmartGattLib](https://github.com/movisens/SmartGattLib) - 简化了蓝牙智能设备（又名蓝牙 4.0 中的低功耗蓝牙）的工作.

### Chat & Messaging

- [Applozic Android Chat SDK](https://github.com/AppLozic/Applozic-Android-SDK) - Android 聊天和消息 SDK，用于将实时聊天和应用内消息添加到您的 Android 应用程序中.
- [Qiscus SDK](https://github.com/qiscus/qiscus-sdk-android)  - Qiscus SDK 是一个轻量级且功能强大的安卓聊天库.  Qiscus SDK 将允许您轻松地将 Qiscus 引擎与您的应用程序集成，以制作酷炫的聊天应用程序.
- [Kommunicate Live Chat SDK](https://github.com/Kommunicate-io/Kommunicate-Android-Chat-SDK)  - Kommunicate 在android 中提供开源实时聊天sdk.  Kommunicate 可让您在移动（安卓、iOS）应用程序和网站中添加实时实时聊天和应用程序内消息传递，以获得客户支持.
- [CometChat Voice, Video and Text Chat SDK with UI](https://github.com/cometchat-go/android-chat-sdk-demo)  - 使用 CometChat 在几分钟内将语音、视频和文本聊天添加到您的应用程序（和网站）.  CometChat 的 SDK 包括一个完整的现成 UI，因此您无需花费任何时间来构建一个！ 这还不是全部，CometChat 对实时翻译、白板、屏幕共享、朋友同步、基于角色的访问控制、信用扣除等具有开箱即用的支持.
- [Build a one-on-one Android chat app using Kotlin](https://www.cometchat.com/tutorials/build-one-on-one-chat-in-your-android-app-using-kotlin/)  - 使用 CometChat Pro 在几分钟内在 Kotlin 中构建一个一对一的 Android 聊天应用程序. 本教程讨论了登录、获取联系人列表、用户状态指示器、发送/接收消息等功能.
- [Stream Chat](https://getstream.io/tutorials/android-chat/) - 用于实时聊天的综合 SDK 和组件，由 [Stream](https://getstream.io/chat/).
- [Add Push Notifications to Your Android Chat App Using Kotlin](https://www.cometchat.com/tutorials/android-chat-push-notifications/) - 在 CometChat Pro 和 Firebase Cloud Messaging (FCM) 的帮助下，在 Kotlin 的 Android 聊天应用程序中添加推送通知.

#### Custom Dialog

- [MediaRecorderDialog](https://github.com/alhazmy13/MediaRecorderDialog) - 自定义对话框录制音频，存储它并在您的手机中播放.
- [HijriDatePicker](https://github.com/alhazmy13/HijriDatePicker) - 提供回历（伊斯兰历）日期选择器，该选择器是根据 Google 的 Material Design Principals For Pickers 设计的.
- [Noty](https://github.com/emre1512/Noty) - 用于创建动画警报/对话框/警告的简单库.

### Version Checking

 - [AppUpdater](https://github.com/javiersantos/AppUpdater) - 全面且功能丰富的库，包括对亚马逊和 FDroid 支票的支持.
 - [Gandalf](https://github.com/btkelly/gandalf) - 全面的功能和“伴侣”iOS 解决方案.
 - [Siren](https://github.com/eggheadgames/Siren)  - 模仿流行的同名 iOS 库的重点功能集. 支持 Play 和亚马逊.
 - [Fit](https://github.com/KeithYokoma/Fit) - 没有 UI 的版本检查回调框架.

### Date & Time

- [ThreeTen Android Backport](https://github.com/JakeWharton/ThreeTenABP) - 适用于 Android 的 JSR-310 向后移植的改编版.
- [Joda-Time Android](https://github.com/dlew/joda-time-android) - 具有 Android 专业化的 Joda-Time 库.
- [True Time](https://github.com/instacart/truetime-android)  - Android NTP 时间库. 获取不受设备时钟时间变化影响的真实当前时间.

### Runtime Permissions

- [Permission Dispatcher](https://github.com/permissions-dispatcher/PermissionsDispatcher) - 简单的基于注释的 API 来处理运行时权限.
- [RxPermissions](https://github.com/tbruyelle/RxPermissions) - 由 RxJava 提供支持的 Android 运行时权限.
- [NoPermission](https://github.com/NoNews/NoPermission)  - 用于权限请求的简单 Android 库. 只包含一个类.
- [Ask-Permission](https://github.com/Kishanjvaghela/Ask-Permission) - 简单的运行时权限管理器.
- [Gota](https://github.com/alhazmy13/Gota) - 简化 Android 权限.
- [EasyPermissions](https://github.com/googlesamples/easypermissions) - EasyPermissions 是一个包装库，用于在针对 Android M 或更高版本时简化基本系统权限逻辑.

### Payments

- [Square In-App Payments for Android](https://developer.squareup.com/docs/in-app-payments-sdk/build-on-android) - 通过数字钱包和存储卡支持将 Square 支付集成到您的移动应用程序中，以便快速结账.

### Other

- [Android Support library](https://developer.android.com/topic/libraries/support-library/) - Android 支持库包是一组代码库，提供向后兼容版本的Android 框架API.
- [Google Play Services](https://developers.google.com/android/guides/overview) - 用于访问 Google 服务的库，例如帐户同步、Google+（共享、单点登录）、Google 地图、位置 API、Google Play 游戏、云消息、Android 设备管理器等.
- [Tape](https://github.com/square/tape) - 适用于 Android 和 Java 的闪电般快速、事务性、基于文件的 FIFO.
- [Guava: Google Core Libraries for Java](https://github.com/google/guava) - 集合、缓存、原语支持、并发库、公共注释、字符串处理、I/O 等等.
- [Android Scripting](https://github.com/damonkohler/sl4a) - 允许在 Android 上运行脚本语言.
- [Android Priority Job Queue](https://github.com/yigit/android-priority-jobqueue) - 实施作业队列以轻松安排在后台运行的作业（任务），从而提高用户体验和应用程序稳定性.
- [RateMeMaybe](https://github.com/nspo/RateMeMaybe) - 询问用户是否要打开 Play 商店来评价您的应用程序.
- [Easy Rating Dialog](https://github.com/fernandodev/easy-rating-dialog) - Lib 提供了一种简单的方法来显示评级应用程序的警报对话框.
- [ZXing Android-Integration](https://github.com/zxing/zxing) - 通过 Intent 与 Barcode Scanner 集成.
- [Gradle Retrolambda Plugin](https://github.com/evant/gradle-retrolambda) - Android 上的 Java 8 Lambda！
- [RxJava](https://github.com/ReactiveX/RxJava)- RxJava – JVM 的反应式扩展 – 一个用于使用 Java VM 的可观察序列编写异步和基于事件的程序的库.
- [RxAndroid](https://github.com/ReactiveX/RxAndroid) - 添加最小的 RxJava 绑定，以便轻松编写响应式 Android java 代码.
- [RxBinding](https://github.com/JakeWharton/RxBinding)- RxBinding——用于来自平台和支持库的 Android UI 小部件的 RxJava 绑定 API.
- [Caffeine](https://github.com/percolate/caffeine) - 有助于加快 Android 开发速度的实用程序类集合.
- [AboutLibraries](https://github.com/mikepenz/AboutLibraries) - 自动生成一个关于此应用程序部分，其中包含已用库的列表.
- [AudioPlayerView](https://github.com/HugoMatilla/AudioPlayerView) - 从 url 加载音频并具有基本播放工具的视图.
- [andle](https://github.com/Jintin/andle) - 命令行工具帮助您同步依赖项、sdk 或构建工具版本.
- [Typography](https://github.com/workarounds/typography) - 一个 Android 库，可以轻松地在视图中使用自定义字体.
- [Calligraphy](https://github.com/chrisjenx/Calligraphy) - Android 中的自定义字体是一种不错的方式.
- [transai](https://github.com/Jintin/transai) - 命令行工具帮助您管理本地化字符串文件.
- [Android-Link-Preview](https://github.com/LeonardoCardoso/Android-Link-Preview) - 它从 url 进行预览，抓取所有信息，如标题、相关文本和图像.
- [Sensey](https://github.com/nisrulz/sensey) - 快速检测手势.
- [UserAwareVideoView](https://github.com/kevalpatel2106/UserAwareVideoView) - 自定义视频视图会在用户未注视设备屏幕时自动暂停视频！
- [Flexbox Layout](https://github.com/google/flexbox-layout) - FlexboxLayout 是一个将 CSS Flexible Box Layout Module 的类似功能带到 Android 的库.
- [Agile Boiler Plate](https://github.com/xresco/Android-Agile-Boiler-Plate) - 样板基于 MVP 架构，完全基于使用 Dagger2 的依赖注入设计模式.
- [Gradle buildSrcVersions](https://github.com/jmfayard/buildSrcVersions) - 用于简化依赖项管理的 kotlin dsl
- [Teller](https://github.com/levibostian/Teller-Android/)  - Teller 方便下载、保存和读取您应用程序的缓存数据. 让您的用户数据保持最新并移除那些烦人的加载屏幕！

## Resources

- [Programming Community Curated Resources for Learning Android Development](https://hackr.io/tutorials/learn-android-development) - 由编程社区提交和投票的 Android 教程和课程.
- [Vogella Tutorials](https://www.vogella.com/tutorials/android.html) - Lars Vogel 的非常好的教程.
- [Android Design in Action Video series](https://www.youtube.com/playlist?list=PLWz5rJ2EKKc8j2B95zGMb8muZvrIy-wcF) Google Android 设计团队的视频系列.
- [Android DevBytes Video Series](https://www.youtube.com/playlist?list=PLWz5rJ2EKKc_XOgcRukSoKKjewFJZrKV0) - 它是 Android Design in Action 系列的技术对应物.
- [Developing for Android](https://medium.com/google-developers/developing-for-android-introduction-5345b451567c) - 来自 Google 员工 Chet Hasae 和其他人的一系列文章，回答了最常见的问题：“开发 Android 应用程序时要牢记哪些重要规则？”.
- [Android Hive Tutorials](https://www.androidhive.info) - 非常适合初学者的教程.
- [Android Weekly](https://androidweekly.net) - 包含有关 android 的每周信息的时事通讯.
- [Android Asset Studio](http://romannurik.github.io/AndroidAssetStudio/) - 图标和其他资产的生成器.
- [Android Action Bar Style Generator](http://jgilfelt.github.io/android-actionbarstylegenerator/).
- [Device Art Generator](https://developer.android.com/distribute/marketing-tools/device-art-generator) - 将应用程序屏幕截图包裹在真实设备的插图中.
- [Android UI design resources](https://androiduiux.com/free-design-resources/) - 为您提供来自 UI/UX 方面的 Google 开发者专家的各种设计资源.
- [Pencil Project](https://pencil.evolus.vn/) - 一个开源原型设计软件.
- [How to Make Android Apps](https://www.youtube.com/playlist?list=PLGLfVvz_LVvSPjWpLPFEfOCbezi6vATIh) - Derek Banas 的视频教程.
- [android-blogs](https://github.com/vbauer/android-blogs) - 列出有关 Android 的博客.
- [Future Studio](https://futurestud.io/tutorials/tag/android) - 关于 Retrofit、Picasso、Glide 和 Gson 的广泛 Android 教程.
- [Android Tips & Tricks](https://github.com/nisrulz/android-tips-tricks) - 关于 Android 开发提示和技巧的备忘单.
- [Associate Android Developer Certification Materials](https://github.com/Amejia481/Associate-Android-Developer-Certification) - 准备考试的材料集合.
- [Google Developers Training](https://developer.android.com/courses/) - Google Developers 官方培训页面列出了各种有用的学习资源，供初学者和经验丰富的开发人员使用.
- [Mindorks](https://mindorks.com/) - 成为一个完整而快乐的 Android 开发者.
- [AndroidVille](https://ayusch.com/)  - 成为更好的 Android 工程师. 一个致力于 Android 开发的网站，涵盖高级主题，例如 RxJava、Android Zygote 等等.
- [Android Stack Weekly](https://blog.canopas.com/tagged/canopas-android-weekly) - 关于 Android 世界新开发和更新的每周时事通讯.

### Code examples
- [Android Architecture Blueprints](https://github.com/android/architecture-samples) - Android 架构蓝图项目展示了帮助解决或避免常见 android 问题的策略.
- [Kotlin MVVM example](https://github.com/emedinaa/kotlin-mvvm) - 关于 MVVM（模型视图视图模型）模式的示例.
- [Kotlin VIPER example](https://github.com/OmiSoftNet/AndroidViperTemplate) - 关于 VIPER（View Interactor Presenter Entity Router）模式的示例.
- [Complete-Google-Map-API-Tutorial](https://github.com/mohammadima3oud/Complete-Google-Map-API-Tutorial) - 通过完整示例了解如何使用 Google Map API for Android 从基础到高级.
- [Android Modular Architecture](https://github.com/VMadalin/kotlin-sample-app) - Android 示例应用程序使用 Kotlin 编写的模块化、干净、可扩展、可测试的架构，遵循 Jetpack 的最佳实践.

### Podcasts
- [Fragmented](https://fragmentedpodcast.com/) 是 Android 开发者播客，Donn Felker 和 Kaushik Gopal 在其中谈论构建优秀的软件和成为更好的 Android 开发者.
- [Android Developers Backstage](http://androidbackstage.blogspot.com/) 是 Android 开发者的播客. 该节目由 Android 工程团队的开发人员主持，涵盖了 Android 程序员感兴趣的主题，并与 Google Android 团队的工程师进行了深入讨论和访谈.
- [Android Dialogs](https://www.youtube.com/channel/UCMEmNnHT69aZuaOrE-dF6ug/feed) 是一个基于视频的播客，他们在其中与 Android 社​​区的人们进行简短的对话.
- [The Context](https://github.com/artem-zinnatullin/TheContext-Podcast) 与 Hannes Dorfmann、Artem Zinnatullin 和精彩嘉宾一起制作的关于 Android 开发的播客！
- [Talking Kotlin](https://talkingkotlin.com/) - 关于 Kotlin 等的播客.
- [Android Authority](https://www.androidauthority.com/podcast/) 是每周一次的 Android 播客，由 Android Authority 团队的 Adam Doud、Joe Hindy 和 Jonathan Feist 主持.
- [Android Central](https://www.androidcentral.com/podcast) - 是由 Android Central 团队主持的每周 Android 播客.

### More lists of libraries
- [The Android Arsenal](https://android-arsenal.com/) - 大量的安卓库
- [Square libraries](https://square.github.io/) - 多个高质量的图书馆.
- [Awesome Android @LibHunt](https://android.libhunt.com) - 您的首选 Android 工具箱.
- [Android Store](https://mindorks.com/android/store) - 搜索 Android 库、项目和工具.

## Development Alternatives

我个人的建议是（目前）使用 android api 构建本机应用程序.  Scala 可以帮助使用更清晰的代码构建此原生应用程序，但它增加了许多方法（需要 Multidex）.  Kotlin 是一种现代语言，与 java 项目 100% 互操作性**没有 multidex**. 但也有一些用例，其中跨平台开发等替代方案可能会有用.

### C&#35;

- [Xamarin](https://visualstudio.microsoft.com/xamarin/) - Framework to create native iOS, Android, Mac and Windows apps in C#.

### HTML, CSS and Javascript

- [PhoneGap](https://phonegap.com) - Adob​​e 的开源框架，用于使用 HTML、CSS 和 JavaScript 创建跨平台移动应用程序.
- [Titanium](http://www.appcelerator.com/mobile-app-development-products/) - 使用 JavaScript 创建“本地”跨平台应用程序的开源框架.
- [NativeScript](https://www.nativescript.org/) - 一个开源框架，用于从单个代码库使用 JavaScript 构建本机 iOS 和 Android 应用程序.
- [React Native](https://github.com/facebook/react-native) - 用于使用 Facebook 的 React 构建本机应用程序的框架.
- [Ionic Framework](https://ionicframework.com) - 一个框架，用于使用 AngularJS 使用针对移动设备优化的 HTML、CSS 和 JS 构建混合应用程序.
- [Apache Cordova](https://github.com/apache/cordova-android) - 基于 Cordova 的应用程序的核心是使用 Web 技术编写的应用程序：HTML、CSS 和 JavaScript.
- [Capacitor](https://github.com/ionic-team/capacitor)  - 为 iOS、Android 和网络构建跨平台的原生渐进式 Web 应用程序. 非常有前途的 Cordova 替代品. 

### Lua
- [Corona SDK](https://coronalabs.com/product/) - 创建原生 iOS 和 Android 应用程序（尤其是游戏）的框架.

### Scala
- [Scaloid](https://github.com/pocorall/scaloid) - 使用 Scala 进行不那么痛苦的 Android 开发的库.
- [Macroid](https://github.com/47deg/macroid) - 适用于 Android 的模块化功能 UI 语言.

### Groovy
- [Groovy on Android](http://melix.github.io/blog/2014/06/grooid.html) - Android 上的 Groovy 简介.
- [Groovy Language Support for Android](https://github.com/groovy/groovy-android-gradle-plugin) - 用于为 Android 编译 Groovy 的 Gradle 插件.
- [SwissKnife](https://github.com/Arasthel/SwissKnife) - A multi-purpose Groovy library containing view injection and threading for Android using annotations.

### Kotlin
- [Anko](https://github.com/Kotlin/anko) - 由 JetBrains 用 Kotlin 编写的适用于 Android 的 DSL.
- [Kotterknife](https://github.com/JakeWharton/kotterknife) - 基于 ButterKnife 用 Kotlin 编写的 Android 视图注入
- [Android Kotlin Samples](https://github.com/irontec/android-kotlin-samples) - 一些用 Kotlin 编写的基本 Android 代码示例.
- [Kotlin coding puzzles](https://github.com/igorwojda/kotlin-coding-puzzle) - 一组有助于提高白板编码和解决问题技能的编程挑战.
- [KAndroid](https://github.com/pawegio/KAndroid) - 轻量级库提供有用的扩展以消除 Android SDK 中的样板代码.
- [RxKotlin/Pocket](https://github.com/RxKotlin/Pocket) - 此应用程序帮助用户轻松保存链接，并且可以每周导出到 Evernote.
- [Android Clean Architecture - Kotlin](https://github.com/patrickyin/clean-architecture-android-kotlin) - 使用 Uncle Bob 的干净架构和 Kotlin 语言和最新 Android 技术的基础项目.
- [Koin](https://insert-koin.io/) - Kotlin 的轻量级依赖注入框架

### Flutter
- [Flutter](https://flutter.dev/) - Google 的移动应用程序 SDK，可在非常短的时间内为 Android 和 iOS 提供高质量的本机界面.

## Performance
- [awesome-android-performance](https://github.com/Juude/awesome-android-performance) - 用于性能优化的精彩 Android 教程、视频和工具列表.
- [Booster](https://github.com/didi/booster) - Booster 是 Android 应用程序的优化工具包.

## Other Awesome Lists
其他非常棒的列表可以在 [awesome-awesomeness](https://github.com/bayandin/awesome-awesomeness) 列表.

## Contributing

随时欢迎您的贡献！ 请阅读 [contribution guidelines](https://github.com/JStumpp/awesome-android/blob/master/contributing.md) 第一的.
