<div class="github-widget" data-repo="wasabeef/awesome-android-ui"></div>
Android UI/UX 库列表
==================
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/wasabeef/awesome-android-ui)

很棒的 Android UI/UX 库的精选列表.

## Maintainers
<p>
  <a href="https://github.com/wasabeef">
    <img src="https://avatars1.githubusercontent.com/u/1833474?s=48" />
  </a>
</p>

## Index

Jetpack 撰写
======================
名称 | 执照 | 演示
--- | --- | ---
[Landscapist](https://raw.githubusercontent.com/skydoves/landscapist) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://user-images.githubusercontent.com/24237865/95661452-6abad480-0b6a-11eb-91c4-7cbe40b77927.gif" width="46%"> <img src="https://user-images.githubusercontent.com/24237865/95812167-be3a4780-0d4f-11eb-9360-2a4a66a3fb46.gif" width="46%">
[Flinger](https://raw.githubusercontent.com/iamjosephmj/flinger) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://media.giphy.com/media/rJWauymZ3HTRRTXmta/giphy.gif" width="49%">
[Orchestra](https://raw.githubusercontent.com/skydoves/Orchestra) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://user-images.githubusercontent.com/24237865/61194943-f9d70380-a6ff-11e9-807f-ba1ca8126f8a.gif" width="46%"> <img src="https://user-images.githubusercontent.com/24237865/95007367-d58b7d80-0649-11eb-857b-9e0187be70d1.gif" width="44%">
[compose-backstack](https://raw.githubusercontent.com/zach-klippenstein/compose-backstack) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/zach-klippenstein/compose-backstack/blob/main/.images/inspector.gif" width="49%">
[ComposeClock](https://raw.githubusercontent.com/adibfara/ComposeClock) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/adibfara/ComposeClock/master/demo.gif" width="49%">
[ComposeCookBook](https://raw.githubusercontent.com/Gurupreet/ComposeCookBook) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://media.giphy.com/media/WOlo2cTDdjGkgdAJQK/giphy.gif" width="46%"> <img src="https://media.giphy.com/media/pZfwwwOlKQtiyJFPr2/giphy.gif" width="46%">
[Compose Neumorphism UI](https://raw.githubusercontent.com/CuriousNikhil/neumorphic-compose) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/CuriousNikhil/neumorphic-compose/blob/main/static/complete_screen.png?raw=true" height=400>
[SSComposeCookBook](https://raw.githubusercontent.com/SimformSolutionsPvtLtd/SSComposeCookBook) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/SimformSolutionsPvtLtd/SSComposeCookBook/blob/main/gif/canvas/canvas.gif" width="46%"> <img src="https://raw.githubusercontent.com/SimformSolutionsPvtLtd/SSComposeCookBook/blob/main/gif/Animation/BasicAnim.gif" width="46%">

Layout
======================
名称 | 执照 | 演示
--- | --- | ---
[WaveView](https://github.com/john990/WaveView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/waveview.gif" width="49%">
[ResideLayout](https://github.com/kyze8439690/ResideLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ResideLayout.gif" width="49%">
[AndroidSwipeLayout](https://github.com/daimajia/AndroidSwipeLayout) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidSwipeLayout.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidSwipeLayout2.gif" width="49%">
[SwipeBackLayout](https://github.com/ikew0ng/SwipeBackLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SwipeBackLayout.webp" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SwipeBackLayout2.webp" width="49%">
[Maskable Layout](https://github.com/christophesmet/android_maskable_layout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android_maskable_layout.gif" width="49%">
[ExpandableLayout](https://github.com/traex/ExpandableLayout) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ExpandableLayout.gif" width="49%">
[android-PullRefreshLayout](https://github.com/baoyongzhang/android-PullRefreshLayout) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-PullRefreshLayout.gif" width="49%">
[TileView](https://github.com/moagrius/TileView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TileView.jpeg" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TileView2.jpeg" width="49%">
[ShowcaseView](https://github.com/amlcurran/ShowcaseView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ShowcaseView.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ShowcaseView2.png" width="49%">
[Ultra Pull To Refresh](https://github.com/liaohuqiu/android-Ultra-Pull-To-Refresh) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-Ultra-Pull-To-Refresh.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-Ultra-Pull-To-Refresh2.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-Ultra-Pull-To-Refresh3.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-Ultra-Pull-To-Refresh4.gif" width="49%">
[AndroidViewHover](https://github.com/daimajia/AndroidViewHover)  | 未知 | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidViewHover.gif" width="49%">
[DraggablePanel](https://github.com/pedrovgs/DraggablePanel) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/DraggablePanel.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/DraggablePanel2.gif" width="49%">
[Slidr](https://github.com/r0adkll/Slidr) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Slidr.gif" width="49%">
[Phoenix Pull-to-Refresh](https://github.com/Yalantis/Phoenix) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Phoenix.gif" width="65%">
[Pull-to-Refresh.Tours](https://github.com/Yalantis/Taurus) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Taurus.gif" width="65%">
[InboxLayout](https://github.com/zhaozhentao/InboxLayout) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/InboxLayout.gif" width="49%">
[SwipeBack](https://github.com/liuguangqiang/SwipeBack) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SwipeBack.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SwipeBack2.gif" width="49%">
[ArcLayout](https://github.com/ogaclejapan/ArcLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/arclayout1.gif" width="49%">
[Dragger](https://github.com/ppamorim/Dragger) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Dragger.gif" width="100%">
[PhysicsLayout](https://github.com/Jawnnypoo/PhysicsLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/PhysicsLayout.gif" width="49%">
[BottomSheet](https://github.com/Flipboard/bottomsheet) | [License](https://github.com/Flipboard/bottomsheet/blob/master/LICENSE) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BottomSheet.gif" width="49%">
[Bubbles for Android](https://github.com/txusballesteros/bubbles-for-android) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/bubbles-for-android.gif" width="49%">
[AndroidSlidingUpPanel](https://github.com/umano/AndroidSlidingUpPanel) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidSlidingUpPanel.jpg" width="100%">
[android-transition](https://github.com/kaichunlin/android-transition) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-transition.gif" width="49%">
[CircleRefreshLayout](https://github.com/tuesda/CircleRefreshLayout) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/CircleRefreshLayout.gif" width="49%">
[WaveSwipeRefreshLayout](https://github.com/recruit-lifestyle/WaveSwipeRefreshLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/WaveSwipeRefreshLayout.gif" width="49%">
[FloatingView](https://github.com/recruit-lifestyle/FloatingView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FloatingView.gif" width="49%">
[FrenchToast](https://github.com/pyricau/frenchtoast) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/frenchtoast.gif" width="49%">
[AndroidSweetSheet](https://github.com/zzz40500/AndroidSweetSheet) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidSweetSheet.gif" width="100%">
[FABRevealLayout](https://github.com/truizlop/FABRevealLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FABRevealLayout.gif" width="49%">
[ToggleExpandLayout](https://github.com/fenjuly/ToggleExpandLayout) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ToggleExpandLayout.gif" width="49%">
[FlowingDrawer](https://github.com/mxn21/FlowingDrawer) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FlowingDrawer.gif" width="65%">
[WaveView](https://github.com/gelitenight/WaveView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/gelitenight-WaveView.gif" width="65%">
[FoldableLayout](https://github.com/worldline/FoldableLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FoldableLayout.gif" width="49%">
[TriangleLabelView](https://github.com/shts/TriangleLabelView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TriangleLabelView.jpg" width="49%">
[FlexboxLayout](https://github.com/google/flexbox-layout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FlexboxLayout.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FlexboxLayout2.gif" width="49%">
[Vorolay](https://github.com/Quatja/Vorolay) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Vorolay.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Vorolay2.png" width="49%">
[Hover](https://github.com/google/hover) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/hover.gif" width="49%">
[FerrisWheel](https://github.com/iglaweb/Ferris-Wheel) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FerrisWheelView.gif" width="62%">
[ArcView](https://github.com/amir5121/arcView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/arcView1.gif" width="49%">
[DraggablePanel2](https://github.com/hoanganhtuan95ptit/DraggablePanel) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/DraggablePanel_1.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/DraggablePanel_2.png" width="49%">
[TagSphereView](https://github.com/magic-goop/tag-sphere) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/tagSphereView.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/tagSphereView1.gif" width="49%">
[LDrawer](https://github.com/keklikhasan/LDrawer) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/LDrawer.gif" width="49%">
[MaterialNavigationDrawer](https://github.com/neokree/MaterialNavigationDrawer) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialNavigationDrawer.png" width="49%">
[AndroidMaterialDesignToolbar](https://github.com/tekinarslan/AndroidMaterialDesignToolbar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidMaterialDesignToolbar.gif" width="49%">
[TapTargetView](https://github.com/KeepSafe/TapTargetView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TapTargetView.gif" width="49%">
[Spotlight](https://github.com/TakuSemba/Spotlight) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/spotlight.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/spotlight2.gif" width="49%">
[MaterialTapTargetPrompt](https://github.com/sjwall/MaterialTapTargetPrompt) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialTapTargetPrompt.jpg" width="49%">
[DrawerArrowDrawable](https://github.com/ChrisRenke/DrawerArrowDrawable) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/DrawerArrowDrawable.gif)

Button
======================
名称 | 执照 | 演示
--- | --- | ---
[circular-progress-button](https://github.com/dmytrodanylyk/circular-progress-button) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/circular-progress-button.gif" width="49%">
[android-process-button](https://github.com/dmytrodanylyk/android-process-button) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-process-button.gif" width="75%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-process-button2.gif" width="75%">
[android-circlebutton](https://github.com/markushi/android-circlebutton) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/android-circlebutton.gif)
[android-flat-button](https://github.com/hoang8f/android-flat-button) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-flat-button.gif" width="49%">
[MovingButton](https://github.com/TheFinestArtist/MovingButton) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MovingButton.gif" width="49%">
[LabelView](https://raw.githubusercontent.com/linger1216/labelview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/linger1216/labelview/master/img/img1.png" width="49%">
[transition-button-android](https://github.com/roynx98/transition-button-android) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/transition-button-android.gif" width="49%">
[KTLoadingButton](https://github.com/timonknispel/KTLoadingButton) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/KTLoadingButton_Success.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/KTLoadingButton_Error.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/KTLoadingButton_Progress.gif" width="49%">
[AwesomeSwitch](https://github.com/anoop44/AwesomeSwitch) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/awesome-switch.gif" height="50%">
[FloatingActionButton](https://github.com/makovkastar/FloatingActionButton) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FloatingActionButton.gif" width="49%">
[android-floating-action-button](https://github.com/futuresimple/android-floating-action-button) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-floating-action-button.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-floating-action-button.png" width="49%">
[ReactButton](https://raw.githubusercontent.com/amrdeveloper/ReactButton) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/AmrDeveloper/ReactButton/master/screenshots/facebook_reacts_demo.gif" width="49%"> <img src="https://raw.githubusercontent.com/AmrDeveloper/ReactButton/master/screenshots/dc_reacts_demo.gif" width="49%">

列表/网格
======================
名称 | 执照 | 演示
--- | --- | ---
[SuperRecyclerView](https://github.com/Malinskiy/SuperRecyclerView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0)  | 没有任何
[RecyclerViewSwipeDismiss](https://github.com/CodeFalling/RecyclerViewSwipeDismiss) | [BSD 2 License](https://opensource.org/licenses/BSD-2-Clause) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RecyclerViewSwipeDismiss.gif" width="49%">
[FlabbyListView](https://github.com/jpardogo/FlabbyListView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FlabbyListView.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FlabbyListView2.gif" width="49%">
[recyclerview-stickyheaders](https://github.com/eowise/recyclerview-stickyheaders) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/recyclerview-stickyheaders.gif" width="49%">
[ParallaxListView](https://github.com/Gnod/ParallaxListView)  | 未知 | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ParallaxListView.gif" width="49%">
[PullZoomView](https://github.com/Frank-Zhu/PullZoomView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/PullZoomView.gif" width="49%">
[SwipeMenuListView](https://github.com/baoyongzhang/SwipeMenuListView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SwipeMenuListView.gif" width="49%">
[discrollview](https://github.com/flavienlaurent/discrollview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/discrollview.gif" width="49%">
[StickyListHeaders](https://github.com/emilsjolander/StickyListHeaders) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/StickyListHeaders.gif" width="49%">
[ListBuddies](https://github.com/jpardogo/ListBuddies) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ListBuddies.png" width="49%"/ > <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ListBuddies.gif" width="49%"/ >
[Android-ObservableScrollView](https://github.com/ksoichiro/Android-ObservableScrollView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView2.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView3.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView4.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView5.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView6.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView7.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView8.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView9.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView10.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView11.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView12.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ObservableScrollView13.gif" width="32%">
[AsymmetricGridView](https://github.com/felipecsl/AsymmetricGridView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AsymmetricGridView.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AsymmetricGridView2.png" width="49%">
[DynamicGrid](https://github.com/askerov/DynamicGrid) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/DynamicGrid.gif" width="49%" />
[AndroidStaggeredGrid](https://github.com/etsy/AndroidStaggeredGrid) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidStaggeredGrid.png" width="49%">
[SwipeListView](https://github.com/47deg/android-swipelistview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-swipelistview.png" width="49%">
[android-parallax-recyclerview](https://github.com/kanytu/android-parallax-recyclerview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-parallax-recyclerview.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-parallax-recyclerview2.gif" width="49%">
[BlurStickyHeaderListView](https://github.com/emmano/BlurStickyHeaderListView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BlurStickyHeaderListView.gif" width="49%" />
[RecyclerView Animators](https://github.com/wasabeef/recyclerview-animators) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/recyclerview-animators.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/recyclerview-animators2.gif" width="49%">
[RecyclerView-FlexibleDivider](https://github.com/yqritc/RecyclerView-FlexibleDivider) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RecyclerView-FlexibleDivider.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RecyclerView-FlexibleDivider2.png" width="49%">
[AndroidTreeView](https://github.com/bmelnychuk/AndroidTreeView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidTreeView.webp" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidTreeView2.webp" width="49%">
[RecyclerViewFastScroller](https://github.com/danoz73/RecyclerViewFastScroller) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RecyclerViewFastScroller.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RecyclerViewFastScroller2.png" width="49%">
[RecyclerView-MultipleViewTypesAdapter](https://github.com/yqritc/RecyclerView-MultipleViewTypesAdapter) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RecyclerView-MultipleViewTypesAdapter.gif" width="49%">
[SwipeToAction](https://github.com/vcalvello/SwipeToAction) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SwipeToAction.gif" width="49%">
[Advanced Recyclerview](https://github.com/h6ah4i/android-advancedrecyclerview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AdvancedRecyclerView.gif" width="49%">
[RecyclerItemDecoration](https://github.com/magiepooh/RecyclerItemDecoration) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/recycler-itemdecoration1.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/recycler-itemdecoration2.gif" width="49%">
[MaterialRecents](https://github.com/ZieIony/MaterialRecents) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialRecents.gif" width="49%">
[Dividers](https://github.com/Karumi/Dividers) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Dividers.gif" width="49%">
[Drag Select Recycler View](https://github.com/afollestad/drag-select-recyclerview) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/drag-select-recyclerview.gif" width="49%" />
[sticky-headers-recyclerview](https://github.com/timehop/sticky-headers-recyclerview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/sticky-headers-recyclerview.gif" width="49%">
[Kiel - Declarative RecyclerView Adapters](https://github.com/ibrahimyilmaz/kiel) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/kiel.png">

ViewPager
======================
名称 | 执照 | 演示
--- | --- | ---
[ParallaxPagerTransformer](https://github.com/xgc1986/ParallaxPagerTransformer) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ParallaxPagerTransformer.gif" width="49%">
[ViewPagerTransforms](https://github.com/ToxicBakery/ViewPagerTransforms) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ViewPagerTransforms.gif" width="49%">
[CircleIndicator](https://github.com/ongakuer/CircleIndicator) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/CircleIndicator.gif" width="49%">
[Android ViewPagerIndicator](https://github.com/JakeWharton/ViewPagerIndicator) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ViewPagerIndicator.png" width="100%">
[Android-ParallaxHeaderViewPager](https://github.com/kmshack/Android-ParallaxHeaderViewPager) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ParallaxHeaderViewPager.gif" width="100%">
[freepager](https://github.com/alexzaitsev/freepager) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/freepager.gif" width="49%">
[SpringIndicator](https://github.com/chenupt/SpringIndicator) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SpringIndicator.gif" width="49%">
[SmartTabLayout](https://github.com/ogaclejapan/SmartTabLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/smarttablayout.gif" width="49%">
[FlipViewPager.Draco](https://github.com/Yalantis/FlipViewPager.Draco) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FlipViewPager-Draco.gif" width="100%">
[MaterialViewPager](https://github.com/florent37/MaterialViewPager) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialViewPager.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialViewPager2.gif" width="49%">
[AndroidRubberIndicator](https://github.com/LyndonChin/AndroidRubberIndicator) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidRubberIndicator.gif" width="60%">
[HollyViewPager](https://github.com/florent37/HollyViewPager) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/HollyViewPager.gif" width="49%">
[SCViewPager](https://github.com/sacot41/SCViewPager) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SCViewPager.gif" width="49%">
[SwipeSelector](https://github.com/roughike/SwipeSelector) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SwipeSelector.gif" width="49%" />
[NavigationTabStrip](https://github.com/Devlight/NavigationTabStrip) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) & [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/NavigationTabStrip.gif" width="49%" />
[NavigationTabBar](https://github.com/Devlight/NavigationTabBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) & [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/NavigationTabBar.gif" width="49%" /> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/NavigationTabBar2.gif" width="49%" />
[UltraViewPager](https://github.com/alibaba/UltraViewPager) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/UltraViewPager.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/UltraViewPager2.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/UltraViewPager3.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/UltraViewPager4.gif" width="49%">
[SnapTablayout](https://github.com/nirukk52/SnapTabLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SnapTablayout3.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SnapTablayout5.gif" width="49%">
[MaterialTabs](https://github.com/neokree/MaterialTabs) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialTabs.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialTabs2.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialTabs3.jpeg" width="49%">
[PagerSlidingTabStrip](https://github.com/jpardogo/PagerSlidingTabStrip) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/PagerSlidingTabStrip.gif" width="49%">

标签/表格
======================
名称 | 执照 | 演示
--- | --- | ---
[Shimmer-android](https://github.com/RomainPiel/Shimmer-android) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/Shimmer-android.gif)
[Shimmer for Android](https://github.com/facebook/shimmer-android) | [BSD 2 License](https://opensource.org/licenses/BSD-2-Clause) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/shimmer-android-fb.gif" width="100%">
[Titanic](https://github.com/RomainPiel/Titanic) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Titanic.gif" width="100%">
[MatchView](https://github.com/Rogero0o/MatchView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MatchView.gif" width="49%">
[android-autofittextview](https://github.com/grantland/android-autofittextview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/android-autofittextview.gif)
[SecretTextView](https://github.com/matthewrkula/SecretTextView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/SecretTextView.gif)
[TextJustify-Android](https://github.com/bluejamesbond/TextJustify-Android) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TextJustify-Android.png" width="100%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TextJustify-Android2.jpeg" width="100%">
[RoundedLetterView](https://github.com/pavlospt/RoundedLetterView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RoundedLetterView.png" width="49%">
[TextDrawable](https://github.com/amulyakhare/TextDrawable) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TextDrawable.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TextDrawable2.png" width="49%">
[BabushkaText](https://github.com/quiqueqs/BabushkaText) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BabushkaText.png" width="49%">
[ExpandableTextView](https://github.com/Manabu-GT/ExpandableTextView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ExpandableTextView.gif" width="49%">
[Float Labeled EditText](https://github.com/wrapp-archive/floatlabelededittext) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/floatlabelededittext.gif" width="49%">
[SizeAdjustingTextView](https://github.com/erchenger/SizeAdjustingTextView) | [GNU License](http://www.gnu.org/licenses/gpl-3.0.en.html)  | 没有任何
[ParkedTextView](https://github.com/gotokatsuya/ParkedTextView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ParkedTextView.gif" width="60%">
[Material Code input](https://github.com/glomadrian/material-code-input) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/material-code-input.gif" width="60%"> <br><br> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/material-code-input2.gif" width="60%">
[TextSurface](https://github.com/elevenetc/TextSurface) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TextSurface.gif" width="100%">
[EmailAutoCompleteTextView](https://github.com/tasomaniac/EmailAutoCompleteTextView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/EmailAutoCompleteTextView.gif" width="60%">
[Tab Digit](https://github.com/xenione/tab-digit) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/tab-digit.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/tab-digit2.gif" width="49%">
[RotatingText](https://github.com/sdsmdg/RotatingText) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RotatingText.gif" width="100%">
[MaterialEditText](https://github.com/rengwuxian/MaterialEditText) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/MaterialEditText.png)
[MaterialTextField](https://github.com/florent37/MaterialTextField) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialTextField.gif" width="49%">
[CodeView](https://raw.githubusercontent.com/amrdeveloper/CodeView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/AmrDeveloper/CodeView/master/screenshots/java_demo.gif" width="49%"> <img src="https://raw.githubusercontent.com/AmrDeveloper/CodeView/master/screenshots/python_demo.gif" width="49%">

Image
======================
名称 | 执照 | 演示
--- | --- | ---
[TouchImageView](https://github.com/MikeOrtiz/TouchImageView) | [LICENSE](https://raw.githubusercontent.com/MikeOrtiz/TouchImageView/master/LICENSE)  | 没有任何
[CircleImageView](https://github.com/hdodenhof/CircleImageView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/CircleImageView.png" width="49%">
[android-shape-imageview](https://github.com/siyamed/android-shape-imageview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-shape-imageview.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-shape-imageview2.png" width="49%">
[GifImageView](https://github.com/felipecsl/GifImageView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/GifImageView.gif" width="49%">
[cropper](https://github.com/edmodo/cropper) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/cropper.jpeg" width="49%">
[android-crop](https://github.com/jdamcd/android-crop) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-crop.png" width="49%">
[SelectableRoundedImageView](https://github.com/pungrue26/SelectableRoundedImageView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SelectableRoundedImageView.png" width="100%">
[RoundedImageView](https://github.com/vinc3m1/RoundedImageView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RoundedImageView.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RoundedImageView2.png" width="49%">
[CropImageView](https://github.com/cesards/CropImageView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/CropImageView.png" width="100%">
[BitmapMerger](https://github.com/sharish/BitmapMerger) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BitmapMerger.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BitmapMerger2.gif" width="49%">
[Scrolling Image View](https://github.com/Q42/AndroidScrollingImageView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidScrollingImageView.gif" width="100%">
[SimpleCropView](https://github.com/IsseiAoki/SimpleCropView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SimpleCropView.gif" width="49%">
[android-anyshape](https://github.com/lankton/android-anyshape) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-anyshape.jpg" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-anyshape2.jpg" width="49%">
[PanoramaImageView](https://github.com/gjiazhe/PanoramaImageView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/PanoramaImageView.gif" width="49%">
[ChiliPhotoPicker](https://github.com/ChiliLabs/ChiliPhotoPicker) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ChiliPhotoPicker.gif" width="49%">
[Android Ribbon](https://raw.githubusercontent.com/skydoves/AndroidRibbon) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://user-images.githubusercontent.com/24237865/51105497-7873e680-182c-11e9-954a-1bf767d15312.gif" align="center" width="32%"/>

SeekBar
======================
名称 | 执照 | 演示
--- | --- | ---
[DiscreteSeekBar](https://github.com/AnderWeb/discreteSeekBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/discreteseekbar.gif) ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/discreteseekbar2.gif)
[SeekBarCompat](https://github.com/ahmedrizwan/SeekBarCompat) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/seekbarcompat.gif)
[PreviewSeekBar](https://github.com/rubensousa/PreviewSeekBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/PreviewSeekBar.gif)
[RangeSeekBar](https://github.com/Jay-Goo/RangeSeekBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://github.com/Jay-Goo/RangeSeekBar/blob/master/Gif/screen2.gif)
[material-range-bar](https://github.com/oli107/material-range-bar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/material-range-bar.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/material-range-bar2.png" width="49%">
[MaterialDateRangePicker](https://github.com/borax12/MaterialDateRangePicker) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDateRangePicker.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDateRangePicker2.png" width="49%">

Progress
======================
名称 | 执照 | 演示
--- | --- | ---
[SmoothProgressBar](https://github.com/castorflex/SmoothProgressBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/SmoothProgressBar.gif)
[NumberProgressBar](https://github.com/daimajia/NumberProgressBar) | [MIT](https://opensource.org/licenses/MIT) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/NumberProgressBar.gif)
[CircleProgress](https://github.com/lzyzsd/CircleProgress)  | 未知 | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/CircleProgress.gif" width="49%">
[android-square-progressbar](https://github.com/mrwonderman/android-square-progressbar)  | 未知 | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-square-progressbar.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-square-progressbar2.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-square-progressbar3.png" width="49%">
[GoogleProgressBar](https://github.com/jpardogo/GoogleProgressBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/GoogleProgressBar.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/GoogleProgressBar2.gif" width="32%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/GoogleProgressBar3.gif" width="32%">
[Android-RoundCornerProgressBar](https://github.com/akexorcist/Android-RoundCornerProgressBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-RoundCornerProgressBar.png" width="100%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-RoundCornerProgressBar2.png" width="100%">
[ElasticDownload](https://github.com/Tibolte/ElasticDownload) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ElasticDownload.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ElasticDownload2.gif" width="49%">
[FABProgressCircle](https://github.com/JorgeCastilloPrz/FABProgressCircle) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FABProgressCircle.gif" width="49%">
[Loading](https://github.com/yankai-victor/Loading) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Loading.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Loading2.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Loading3.gif" width="49%">
[Animated Circle Loading View](https://github.com/jlmd/AnimatedCircleLoadingView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AnimatedCircleLoadingView.gif" width="49%">
[AndroidFillableLoaders](https://github.com/JorgeCastilloPrz/AndroidFillableLoaders) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidFillableLoaders.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidFillableLoaders2.gif" width="49%">
[spots-dialog](https://github.com/d-max/spots-dialog) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/spots_dialog.gif" width="49%">
[AVLoadingIndicatorView](https://github.com/81813780/AVLoadingIndicatorView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AVLoadingIndicatorView.gif" width="49%">
[LoadingDots](https://github.com/EyalBira/loading-dots) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/loading-dots.gif" width="49%">
[ColorArcProgerssBar](https://github.com/Shinelw/ColorArcProgressBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-ColorArcProgressBar.gif" width="49%">
[ArcProgressStackView](https://github.com/GIGAMOLE/ArcProgressStackView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ArcProgressStackView.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ArcProgressStackView2.gif" width="49%">
[WaveLoadingView](https://github.com/tangqi92/WaveLoadingView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/WaveLoadingView.jpg" width="49%">
[CatLoadingView](https://github.com/Rogero0o/CatLoadingView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/CatLoadingView.gif" width="49%">
[WaveLoading](https://github.com/race604/WaveLoading) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/race604-WaveLoading.gif" width="60%">
[SqueezeLoader](https://github.com/mecoFarid/squeezeloader) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/squeezeloader.gif" width="60%">
[RoundedProgressBar](https://github.com/MackHartley/RoundedProgressBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/roundedProgressBarDemo.gif" width="60%">
[FAB-Loading](https://github.com/SaeedMasoumi/FAB-Loading) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FAB-Loading.gif" width="100%">
[materialish-progress](https://github.com/pnikosis/materialish-progress) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/materialish-progress.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/materialish-progress2.gif" width="49%">

Menu
======================
名称 | 执照 | 演示
--- | --- | ---
[CircularFloatingActionMenu](https://github.com/oguzbilgener/CircularFloatingActionMenu) | [MIT](https://opensource.org/licenses/MIT) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/CircularFloatingActionMenu.gif)
[AndroidResideMenu](https://github.com/SpecialCyCi/AndroidResideMenu) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidResideMenu.gif" width="49%">
[Folder-ResideMenu](https://github.com/dkmeteor/Folder-ResideMenu) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Folder-ResideMenu.gif" width="49%">
[Side-Menu.Android](https://github.com/Yalantis/Side-Menu.Android) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Side-Menu.Android.gif" width="100%">
[Context-Menu.Android](https://github.com/Yalantis/Context-Menu.Android) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Context-Menu.Android.gif" width="100%">
[GuillotineMenu-Android](https://github.com/Yalantis/GuillotineMenu-Android) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/GuillotineMenu-Android.gif" width="100%">
[android-snake-menu](https://github.com/xmuSistone/android-snake-menu) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-snake-menu.gif" width="49%">
[BoomMenu](https://github.com/Nightonke/BoomMenu) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BoomMenu.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BoomMenu2.gif" width="49%">
[ExpandableBottomBar](https://github.com/st235/ExpandableBottomBar) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/expandable-bottom-bar.gif" width="100%">
[material-menu](https://github.com/balysv/material-menu) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/material-menu.gif) ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/material-menu2.gif)
[MaterialSheetFab](https://github.com/gowong/material-sheet-fab) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialSheetFab.gif" width="49%">
[PowerMenu](https://raw.githubusercontent.com/skydoves/powermenu) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://user-images.githubusercontent.com/24237865/63956079-c0e0cb80-cac0-11e9-82ca-4397ca1f3750.gif" width="49%"> <img src="https://user-images.githubusercontent.com/24237865/63956377-42385e00-cac1-11e9-9639-81eac4b7511f.jpg" width="49%">
[AnimatedBottomBar](https://github.com/Droppers/AnimatedBottomBar) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AnimatedBottomBar-1.gif" width="50%"><img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AnimatedBottomBar-2.gif" width="50%">

ActionBar
======================
名称 | 执照 | 演示
--- | --- | ---
[FadingActionBar](https://github.com/ManuelPeinado/FadingActionBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FadingActionBar.png" width="100%">
[GlassActionBar](https://github.com/ManuelPeinado/GlassActionBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/GlassActionBar.png" width="100%">
[NotBoringActionBar](https://github.com/flavienlaurent/NotBoringActionBar) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/NotBoringActionBar.gif" width="49%">

Dialog
======================
名称 | 执照 | 演示
--- | --- | ---
[DialogPlus](https://github.com/orhanobut/dialogplus) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/DialogPlus.png" width="30%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/DialogPlus2.gif" width="49%">
[Sweet Alert](https://github.com/pedant/sweet-alert-dialog) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/swalert_change_type.gif" width="49%">
[FlycoDialog-Matser](https://github.com/H07000223/FlycoDialog_Master) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FlycoDialog-Matser.gif" width="49%">
[Voice Overlay](https://github.com/algolia/voice-overlay-android) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/VoiceOverlay1.gif" width="200" /> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/VoiceOverlay2.gif" width="200" /> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/VoiceOverlay3.gif" width="200" /> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/VoiceOverlay4.gif" width="200" />
[MaterialDialog](https://github.com/drakeet/MaterialDialog) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDialog.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDialog2.png" width="49%">
[material-dialogs](https://github.com/afollestad/material-dialogs) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://github.com/wasabeef/awesome-android-ui/blob/master//art/material-dialogs.webp) ![](https://github.com/wasabeef/awesome-android-ui/blob/master//art/material-dialogs2.webp) ![](https://github.com/wasabeef/awesome-android-ui/blob/master//art/material-dialogs3.webp)
[AlertDialogPro](https://github.com/fengdai/AlertDialogPro) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AlertDialogPro.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AlertDialogPro2.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AlertDialogPro3.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AlertDialogPro4.png" width="49%">

Calendar
======================
名称 | 执照 | 演示
--- | --- | ---
[Caldroid](https://github.com/roomorama/Caldroid) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Caldroid.png" width="49%">
[android-times-square](https://github.com/square/android-times-square) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-times-square.png" width="49%">
[Android-MonthCalendarWidget](https://github.com/romannurik/Android-MonthCalendarWidget) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/Android-MonthCalendarWidget.png)
[android-betterpickers](https://github.com/code-troopers/android-betterpickers) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/android-betterpickers.png)
[Android-Week-View](https://github.com/alamkanak/Android-Week-View) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/Android-Week-View.png)
[SilkCal](https://github.com/NLMartian/SilkCal) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SilkCat.gif" width="49%">
[SublimePicker](https://github.com/vikramkakkar/SublimePicker) |  [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) |  <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/sublimePicker_date.png" width="49%">  <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/sublimePicker_time.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/sublimePicker_repeat.png" width="49%">
[MaterialDateTimePicker](https://github.com/wdullaer/MaterialDateTimePicker) |  [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) |  <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDateTimePicker_date.png" width="49%">  <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDateTimePicker_time.png" width="49%">
[CompactCalendarView](https://github.com/SundeepK/CompactCalendarView) |  [MIT](https://opensource.org/licenses/MIT) |  <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/compact-calendar-demo.gif" width="49%">
[material-calendarview](https://github.com/prolificinteractive/material-calendarview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/material-calendarview.gif" width="49%">

Graph
======================
名称 | 执照 | 演示
--- | --- | ---
[Android-RatingReviews](https://github.com/Inconnu08/android-ratingreviews) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0)  | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ratingreviews1.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ratingreviews2.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ratingreviews3.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/hellocharts-android4.png" width="49%">
[EazeGraph](https://github.com/blackfizz/EazeGraph) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0)  | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/EazeGraph.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/EazeGraph2.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/EazeGraph3.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/EazeGraph4.png" width="49%">
[GraphView](https://github.com/appsthatmatter/GraphView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0)  | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/graphview-zooming.gif" width="65%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/graphview-anim.gif" width="65%">
[hellocharts-android](https://github.com/lecho/hellocharts-android) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0)  | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/hellocharts-android.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/hellocharts-android2.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/hellocharts-android3.png" width="49%">
[MPAndroidChart](https://github.com/PhilJay/MPAndroidChart) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0)  | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MPAndroidChart.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MPAndroidChart2.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MPAndroidChart3.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MPAndroidChart4.png" width="49%">
[WilliamChart](https://github.com/diogobernardino/WilliamChart) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0)  | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/williamchart_line.png" width="65%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/williamchart_bar.png" width="65%">

Animation
======================
名称 | 执照 | 演示
--- | --- | ---
[AndroidViewAnimations](https://github.com/daimajia/AndroidViewAnimations) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/androidviewanimations.gif" width="49%">
[ListViewAnimations](https://github.com/nhaarman/ListViewAnimations) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ListViewAnimations.gif" width="49%">
[AndroidImageSlider](https://github.com/daimajia/AndroidImageSlider) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AndroidImageSlider.gif" width="49%">
[transitions-everywhere](https://github.com/andkulikov/transitions-everywhere) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/transitions-everywhere.gif)
[Android Ripple Background](https://github.com/skyfishjy/android-ripple-background) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-ripple-background.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-ripple-background2.gif" width="49%">
[android-flip](https://github.com/openaphid/android-flip) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-flip.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-flip2.gif" width="49%">
[FragmentTransactionExtended](https://github.com/DesarrolloAntonio/FragmentTransactionExtended) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FragmentTransactionExtended.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/FragmentTransactionExtended2.gif" width="49%">
[KenBurnsView](https://github.com/flavioarfaria/KenBurnsView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/KenBurnsView.gif" width="49%">
[rebound](https://github.com/facebook/rebound) | [BSD 2 License](https://opensource.org/licenses/BSD-2-Clause) | http://facebook.github.io/rebound/
[Reachability](https://github.com/sakebook/Reachability) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Reachability.gif" width="49%">
[AnimationEasingFunctions](https://github.com/daimajia/AnimationEasingFunctions) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/AnimationEasingFunctions.gif" width="49%">
[EasyAndroidAnimations](https://github.com/2359media/EasyAndroidAnimations) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/EasyAndroidAnimations.gif" width="49%">
[android-pathview](https://github.com/geftimov/android-pathview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-pathview.gif" width="49%">
[ViewRevealAnimator](https://github.com/sephiroth74/ViewRevealAnimator) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ViewRevealAnimator.gif" width="49%">
[ArcAnimator](https://github.com/asyl/ArcAnimator) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ArcAnimator.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ArcAnimator2.gif" width="49%">
[SearchMenuAnim](https://github.com/kongnanlive/SearchMenuAnim)  | 未知 | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SearchMenuAnim.gif" width="100%">
[Cross View](https://github.com/cdflynn/crossview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/crossview.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/crossview2.gif" width="49%">
[WoWoViewPager](https://github.com/Nightonke/WoWoViewPager) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/WoWoAppIntroExample.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/WoWoCVExample.gif" width="49%">
[Lottie for Android](https://github.com/airbnb/lottie-android) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/lottie-android.gif" width="100%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/lottie-android2.gif" width="100%">
[RichPath](https://github.com/tarek360/RichPath) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/RichPath.gif" width="33%">
[RubberPicker](https://raw.githubusercontent.com/Chrisvin/RubberPicker) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/Chrisvin/RubberPicker/raw/master/RubberPicker-Demo.gif" width="33%">
[material-ripple](https://github.com/balysv/material-ripple) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/material-ripple.gif" width="49%">
[RippleEffect](https://github.com/traex/RippleEffect) | [MIT](https://opensource.org/licenses/MIT) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/RippleEffect.gif)
[CircularReveal](https://github.com/ozodrukh/CircularReveal) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/CircularReveal.gif" width="49%">

Parallax
======================
名称 | 执照 | 演示
--- | --- | ---
[ParallaxEverywhere](https://github.com/Narfss/ParallaxEverywhere) | [MIT](https://opensource.org/licenses/MIT) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/parallax-everywhere.gif)

Effect
======================
名称 | 执照 | 演示
--- | --- | ---
[EtsyBlur](https://github.com/Manabu-GT/EtsyBlur) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/EtsyBlur.gif" width="49%">
[BlurDialogFragment](https://github.com/tvbarthel/BlurDialogFragment) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BlurDialogFragment.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BlurDialogFragment2.png" width="49%">
[BlurBehind](https://github.com/faradaj/BlurBehind) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BlurBehind.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BlurBehind2.png" width="49%">
[Android StackBlur](https://github.com/kikoso/android-stackblur) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-stackblur.png" width="100%">
[EdgeEffectOverride](https://github.com/AndroidAlliance/EdgeEffectOverride) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/EdgeEffectOverride.jpeg" width="100%">
[ExplosionField](https://github.com/tyrantgit/ExplosionField) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ExplosionField.gif" width="49%">
[BrokenView](https://github.com/zhanyongsheng/BrokenView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/BrokenView.gif" width="49%">
[Trianglify](https://github.com/manolovn/trianglify) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Trianglify.png" width="49%">
[ExpandableLayout (by skydoves)](https://github.com/skydoves/ExpandableLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ExpandableLayout2_1.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ExpandableLayout2_2.gif" width="49%">[ShineButton](https://github.com/ChadCSong/ShineButton) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/ShineButton.gif" width="100%">
[Elastic Views](https://raw.githubusercontent.com/skydoves/ElasticViews) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://user-images.githubusercontent.com/24237865/72123075-73943500-33a3-11ea-883f-9009de998788.gif" width="32%">
[Transformation Layout](https://github.com/skydoves/TransformationLayout) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/TransformationLayout.gif" width="32%">
[IridescentView](https://raw.githubusercontent.com/alexandrehtrb/IridescentView) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/alexandrehtrb/IridescentView/master/iridescent_star_mini.gif" width="100%">
[DashedView](https://raw.githubusercontent.com/MackHartley/DashedView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://user-images.githubusercontent.com/10659285/119430672-cccde180-bcd6-11eb-8c70-9342ae486944.png" width="50%">

Other
======================
名称 | 执照 | 演示
--- | --- | ---
[Swipecards](https://github.com/Diolor/Swipecards) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Swipecards.gif" width="49%">
[Android-Bootstrap](https://github.com/Bearded-Hen/Android-Bootstrap) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Android-Bootstrap.png" width="49%">
[Android PDFView](https://github.com/JoanZapata/android-pdfview) | [GPL V3](https://opensource.org/licenses/GPL-3.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-pdfview.png" width="100%">
[Dspec](https://github.com/lucasr/dspec) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/dspec.png" width="100%">
[LolliPin](https://github.com/omadahealth/LolliPin) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/LolliPin.gif" width="49%">
[DrawableView](https://github.com/PaNaVTEC/DrawableView) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/DrawableView.gif" width="49%">
[Material Shadow 9-Patch](https://github.com/h6ah4i/android-materialshadowninepatch) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-materialshadowninepatch.png" width="49%">
[SimpleFingerGestures](https://github.com/championswimmer/SimpleFingerGestures_Android_Library) | [Apache License v2](https://github.com/championswimmer/SimpleFingerGestures_Android_Library/blob/master/LICENSE) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SimpleFingerGestures1.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SimpleFingerGestures2.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SimpleFingerGestures3.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/SimpleFingerGestures4.gif" width="49%">
[Decor](https://github.com/chemouna/decor) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/decor.png" width="49%">
[Voice Recording Visualizer](https://github.com/tyorikan/voice-recording-visualizer) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | [![IMAGE demo](http://img.youtube.com/vi/fJTl1bgQ3j4/0.jpg)](https://www.youtube.com/watch?v=fJTl1bgQ3j4)
[iiVisu](https://github.com/ImnIrdst/iiVisu) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/iivisu-play.gif" width="62%">
[EasyFonts](https://github.com/vsvankhede/easyfonts) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) |  <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/easyfonts.png" width="100%">
[Android Sliding Activity Library](https://github.com/klinker41/android-slidingactivity) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-slidingactivity.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/android-slidingactivity2.gif" width="49%">
[Snake View](https://github.com/txusballesteros/snake) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/snake.gif" width="60%">
[Rotatable](https://github.com/yayaa/Rotatable) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Rotatable.gif" width="100%">
[StatusBarUtil](https://github.com/laobie/StatusBarUtil) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/StatusBarUtil.png" width="100%">
[Horizon - Simple visual equaliser for Android](https://github.com/Yalantis/Horizon) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Horizon.png" width="100%">
[Stepper Touch](https://github.com/DanielMartinus/Stepper-Touch) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/StepperTouch.gif" width="49%">
[Konfetti](https://github.com/DanielMartinus/konfetti) | [ISC](https://opensource.org/licenses/ISC) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/konfetti.gif">
[CircleTimer](https://github.com/jaeryo2357/circleTimer) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/CircleTimer.gif" width="49%">
[MaterialDesignLibrary](https://github.com/navasmdc/MaterialDesignLibrary) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) |  <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary.png" width="100%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary2.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary3.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary4.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary5.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary6.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary7.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary8.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary9.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary10.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary11.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary12.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary13.png" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialDesignLibrary14.png" width="49%">
[MaterialShadows](https://github.com/harjot-oberai/MaterialShadows) | [MIT](https://opensource.org/licenses/MIT) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/MaterialShadows.png" width="100%">
[Material](https://github.com/rey5137/material) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material2.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material3.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material4.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material5.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material6.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material7.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material8.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material9.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material10.gif" width="49%"> <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/Material11.png" width="49%">
[material-design-icons](https://github.com/google/material-design-icons) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | ![](https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master//art/material-design-icons.png)
[Material Icon Library](https://github.com/code-mc/material-icon-lib) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/material-icon-lib.gif" width="100%">
[Carbon](https://github.com/ZieIony/Carbon) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0)  | 没有任何
[Lollipop-AppCompat-Widgets-Skeleton](https://github.com/sachin1092/Lollipop-AppCompat-Widgets-Skeleton) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/wasabeef/awesome-android-ui/master/art/LollipopAppCompatWidgetSkeleton.gif" width="49%">
[Balloon(tooltips)](https://raw.githubusercontent.com/skydoves/Balloon) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://user-images.githubusercontent.com/24237865/61194943-f9d70380-a6ff-11e9-807f-ba1ca8126f8a.gif" width="49%"> <img src="https://user-images.githubusercontent.com/24237865/61225579-d346b600-a75b-11e9-84f8-3c06047b5003.gif" width="49%">
[ColorPickerView](https://raw.githubusercontent.com/skydoves/colorpickerview) | [Apache License V2](https://www.apache.org/licenses/LICENSE-2.0) | <img src="https://raw.githubusercontent.com/skydoves/ColorPickerView/master/art/art0.gif" width="49%"> <img src="https://raw.githubusercontent.com/skydoves/ColorPickerView/master/art/art1.gif" width="49%">
