<div class="github-widget" data-repo="miguelmota/awesome-amazon-alexa"></div>

&gt; 为 [Amazon Alexa](https://developer.amazon.com/alexa) 平台.



## SDKs/Tools

- [alexa-skills-kit-js](https://github.com/alexa/alexa-skills-kit-sdk-for-nodejs) - 适用于 Node.js 的 Alexa Skills Kit SDK 可帮助您快速启动和运行技能，让您专注于技能逻辑而不是样板代码.
- [jargon-sdk-nodejs](https://github.com/JargonInc/jargon-sdk-nodejs/tree/master/packages/alexa-skill-sdk) - Jargon SDK 使技能开发人员可以轻松管理他们的运行时内容并从他们的技能中支持多种语言.
- [AVS-server](https://github.com/miguelmota/AVS-server) - 用于与 Alexa 语音服务交互的 Node.js Web 服务器.
- [AVS-client](https://github.com/miguelmota/AVS-client) - 用于与 Alexa 语音服务交互的前端应用程序.
- [SSMLOL](https://github.com/okofish/ssmlol)  - Alexa SSML 的 MP3 文件验证器 \<audio\> 标签.
- [Jovo Framework](https://github.com/jovotech/jovo-framework-nodejs) - 为 Alexa 和 Google Home 构建跨平台应用程序.
- [Alexa Smart Home SDK](https://github.com/thehappydinoa/alexa-smart-home-skill) - 用于物联网的 Alexa 技能生成器.
- [AssistantJS](https://github.com/webcomputing/AssistantJS) - 用于构建跨平台语音应用程序的 TypeScript 框架.
- [alexa-avs-sample-app](https://github.com/alexa/alexa-avs-sample-app) - 此项目提供分步演练，可帮助您在 60 分钟内构建免提 Alexa 语音服务 (AVS) 原型.
- [alexa-skills-kit-sdk-for-java](https://github.com/alexa/alexa-skills-kit-sdk-for-java) - 用于为 Amazon Echo 构建支持语音的技能的 SDK 和示例代码.
- [ask-alexa-pykit](https://github.com/anjishnu/ask-alexa-pykit) - 用于开发 Amazon Echo 的 ASK 技能的极简 SDK.
- [alexa-skill-kit](https://github.com/stojanovic/alexa-skill-kit) - 使用 AWS Lambda 轻松开发 Alexa Skill 的库.
- [alexa-home](https://github.com/zachfeldman/alexa-home) - 使用 Amazon Echo 控制家！
- [go-alexa](https://github.com/mikeflynn/go-alexa) - 用于 Go 开发的 Amazon Echo / Alexa 工具集合.
- [AlexaAndroid](https://github.com/willblaschko/AlexaAndroid) - 一个库和示例应用程序，用于抽象对 Android 应用程序的 Amazon Alexa 服务的访问.
- [arduino-esp8266-alexa-wemo-switch](https://github.com/kakopappa/arduino-esp8266-alexa-wemo-switch) - 使用 Arduino D1 Mini 制作的 Amazon Alexa + WeMos 开关.
- [MacLexa](https://github.com/kunal732/MacLexa) - 将亚马逊的 Alexa 放入 Mac 系统托盘，使用 Alexa 语音服务并使用 Swift 构建.
- [Alexa-Chromecast-Skill-2.0](https://github.com/Pizzaface/Alexa-Chromecast-Skill-2.0) - 允许 Amazon Alexa 控制专为 Raspberry Pi 设计的 Google Chromecast.
- [AlexaSkillsKit.NET](https://github.com/AreYouFreeBusy/AlexaSkillsKit.NET)  - 简化 Alexa 技能开发的 .NET 库； 与亚马逊的 AlexaSkillsKit for Java 相同的对象模型.
- [alexa-rubykit](https://github.com/damianFC/alexa-rubykit) - Amazon Echo Alexa 的 App Kit Ruby 实施.
- [SwiftOnLambda](https://github.com/algal/SwiftOnLambda) - 使用 Swift 定义 Amazon Lambda 函数和 Alexa 自定义技能.
- [alexa-skills-dotnet](https://github.com/timheuer/alexa-skills-dotnet) - 适用于 .NET 的 Amazon Alexa Skills SDK.
- [ralyxa](https://github.com/sjmog/ralyxa) - 用于与 Amazon Alexa 交互的 Ruby 框架.
- [alexacast](https://github.com/erik/alexacast) - 对 Amazon Alexa 的 Chromecast 支持.
- [alexa-assistant](https://github.com/tartanguru/alexa-assistant) - 将 Google Assistant SDK 实施为 Alexa 技能.
- [haaska](https://github.com/auchter/haaska) - 家庭助理 Alexa 技能适配器.
- [Alexa Skills Kit SDK for Java](https://github.com/amzn/alexa-skills-kit-java) - 用于为 Amazon Echo 构建支持语音的技能的 SDK 和示例代码.
 - [Aleksa](https://github.com/phxql/aleksa) - Aleksa 是一个用 Kotlin 编写 Alexa Skills 的小框架.
- [Alexa Skills Kit for Python](https://github.com/johnwheeler/flask-ask) - 用于 Python 的 Alexa 技能套件.
- [python-alexa](https://github.com/nmyster/python-alexa) - 一个简单的 Python 库，用于在 Lambda 中使用时简化 Alexa 技能开发.
- [Java Alexa Skills Kit SDK (Lambda)](https://github.com/amzn/alexa-skills-kit-java) - 用于 Java 的 Amazon Alexa Skills SDK.
- [vsms-skeleton](https://github.com/internetofvoice/vsms-skeleton) - Voice Skill Management System (Skeleton).
- [phoice/phlexa](https://github.com/phoice/phlexa) - 用于 Amazon Alexa 语音应用程序的 PHP 库.
- [amazon-alexa-php](https://github.com/MiniCodeMonkey/amazon-alexa-php) - 亚马逊 Alexa PHP 库.
- [alexa-app](https://github.com/develpr/alexa-app) - 一组类，可让使用 Laravel 和 Lumen 更轻松地创建 Amazon Alexa Skills Kit (ASK) 应用程序.
- [Virtual Alexa](https://github.com/bespoken/virtual-alexa) - 用于单元测试的 Alexa 模拟器.
- [ASK CLI](https://developer.amazon.com/docs/smapi/quick-start-alexa-skills-kit-command-line-interface.html) - ASK 命令行界面 (ASK CLI) 是一种用于管理 Alexa 技能和相关 AWS Lambda 函数的工具.

## NPM Modules

- [intent-utterance-file-parser](https://github.com/miguelmota/intent-utterance-file-parser) - 解析意图话语文件，例如 Alexa Skills Kit 样本话语文件.
- [intent-utterance-expander](https://github.com/miguelmota/intent-utterance-expander) - Expand custom utterance slots of phrases to use with Alexa Skills Utterances.
- [intent-utterance-generator](https://github.com/miguelmota/intent-utterance-generator) - Alexa Skills Kit 示例话语生成器.
- [alexa-utterances](https://github.com/mreinstein/alexa-utterances) - 从模板字符串为 Amazon Alexa 生成扩展话语.
- [alexa-voice-service.js](https://github.com/miguelmota/alexa-voice-service.js) - 用于在浏览器中与 Alexa 语音服务 (AVS) 交互的库.
- [alexa-grammar](https://github.com/scottbea/alexa-grammar) - 用于为亚马逊的 Alexa 语音代理服务构建有效语法和技能包的实用程序和框架代码.
- [hapi-alexa](https://github.com/TheEvilDev/hapi-alexa) - 用于在 Node.js 上构建 Amazon Alexa 应用程序的 Hapi 插件.
- [alexa-app](https://github.com/matt-kruse/alexa-app) - 使用 Node.js 的 Alexa（Amazon Echo）应用程序框架.
- [alexa-nodekit](https://github.com/brutalhonesty/alexa-nodekit) - Amazon Echo Alexa 的 App Kit Node.js 实施.
- [generator-alexa-skill](https://github.com/cameronhunter/generator-alexa-skill) - 用于为 AWS Lambda 构建 Alexa 技能的 Yeoman 生成器.
- [expressive](https://github.com/dhleong/expressive) - 在 Amazon Lambda 上运行的 Alexa Skill Kit 应用程序的极简主义框架.
- [wavelength](https://github.com/pmarkert/wavelength) - 使用 AWS Lambda 构建 Alexa Skills 的框架.
- [alexa-uncensor](https://github.com/atojs/alexa-uncensor) - 绕过 Alexa (Amazon Echo) 文本转语音审查.
- [ssml-builder](https://github.com/mandnyc/ssml-builder) - 轻松创建 SSML，无需字符串连接的所有麻烦.
- [alexa-verifier-middleware](https://github.com/tejashah88/alexa-verifier-middleware) - 一个快速中间件，用于验证发送到 Alexa 技能的 HTTP 请求是从亚马逊发送的.
- [alexia](https://github.com/Accenture/alexia) - 使用 Node.js 创建 Amazon Echo 技能的框架.
- [fluent-ssml](https://github.com/maghis/fluent-ssml) - 适用于 Typescript 或纯 Node.js 的可重用、可测试的 SSML 模板.
- [jovo-framework-nodejs](https://github.com/jovotech/jovo-framework-nodejs) - 为 Amazon Alexa 和 Google Assistant 构建跨平台语音应用程序.
- [chatskills](https://github.com/primaryobjects/chatskills)  - 在命令行上运行和调试 Alexa 技能. 创建机器人. 在 Slack 中运行它们. 在任何地方运行它们！
- [alexa-utterances](https://github.com/alexa-js/alexa-utterances) - 从模板字符串为 Amazon Alexa 生成扩展话语.
- [alexa-mp3-validator](https://github.com/tejashah88/alexa-mp3-validator) - 用于验证要在 Amazon Alexa 技能中使用的 MP3 文件的节点模块.
- [node-alexa-smapi](https://github.com/tejashah88/node-alexa-smapi) - 用于使用 Alexa 技能管理 API 的 node.js 客户端库.
- [jargon-sdk-nodejs](https://github.com/JargonInc/jargon-sdk-nodejs/tree/master/packages/alexa-skill-sdk) - Jargon SDK 使技能开发人员可以轻松管理他们的运行时内容并从他们的技能中支持多种语言.

## Skills

- [ASK-HackerNews](https://github.com/miguelmota/ASK-HackerNews) - 一个 Alexa Skills Kit 应用程序，用于阅读黑客新闻的头条新闻.
- [Alexa-ChromeControl](https://github.com/Nedervino/Alexa-ChromeControl) - 通过您的 Amazon Echo 控制您的 chrome 浏览器.
- [alexa-skill-jenkins](https://github.com/ferdingler/alexa-skill-jenkins) - 告诉谁破坏了 Jenkins 构建的 Alexa 技能.
- [ASK-fortune](https://github.com/miguelmota/ASK-fortune) - 随机阅读一句希望有趣的格言.
- [gmail-on-alexa](https://github.com/s-maheshbabu/gmail-on-alexa) - 亚马逊 Alexa 的 Gmail 技能.
- [alexa-plex](https://github.com/OverloadUT/alexa-plex) - 用于与 Plex 服务器交互并控制客户端播放的 Alexa（Amazon Echo）应用程序.
- [trash-talk](https://github.com/JoshMilo/trash-talk) - 有史以来最伟大的 100 部电影侮辱来激励你.
- [AlexaMakeMeASandwich](https://github.com/timkarnold/AlexaMakeMeASandwich) - 将您的 Amazon Echo 变成三明治工匠的 Chrome 扩展程序.
- [LIFX-Alexa-Skill](https://github.com/Seechay/LIFX-Alexa-Skill) - 为 Amazon Echo 创建的 Alexa 技能，可让您控制 LIFX 灯泡.
- [EarthquakeInfoSkill](https://github.com/ljdelight/EarthquakeInfoSkill) - Amazon Echo (Alexa) 读出世界上最近发生的地震的技能.
- [alexaHomeboy](https://github.com/sirtimbly/alexaHomeboy) - 用于与 IFTTT 制造商频道通信的 Alexa Lambda 功能.
- [RokuAlexaLambdaSkill](https://github.com/julianh2o/RokuAlexaLambdaSkill) - 允许语音控制 Roku 的 Alexa 技能.
- [alexa-sonos](https://github.com/mattwelch/alexa-sonos) - 用于控制 Sonos 的 Alexa 应用程序.
- [RottingTomatoes](https://github.com/Litie-Zhu/RottingTomatoes) - Alexa 技能，告诉您有关电影的各种信息.
- [ktd-piggy-bank](https://github.com/kickthedrawer/ktd-piggy-bank) - 一种 A​​lexa 技能，可以查询 Numerous 中存钱罐的价值.
- [dominos-alexa-skill](https://github.com/kristeaac/dominos-alexa-skill) - 一个 Alexa 技能来跟踪您的 Domino 的订单.
- [bf-helper](https://github.com/JeffEngebretsen/bf-helper) - 一项 Alexa 技能，可帮助 Basic Fantasy RPG 玩家完成涉及设置角色和导航规则的各种任务.
- [EchoMovieDialog](https://github.com/patanoia/EchoMovieDialog) - Amazon Echo 技能：Alexa 使用电影台词进行对话.
- [alexa-coho](https://github.com/amzn/alexa-coho) - 使用 Lighting API 为 Alexa Connected Home 构建技能适配器的示例代码.
- [asana-alexa-skill](https://github.com/dasevilla/asana-alexa-skill) - Asana 的 Alexa 技能.
- [alexa-against-humanity](https://github.com/radiantnode/alexa-against-humanity) - 让 Alexa 从 Cards Against Humanity 中随机挑选白卡或黑卡.
- [echo-venmo](https://github.com/AbhiAgarwal/echo-venmo) - Venmo 的 Amazon Echo 技能.
- [Uber-Alexa-Skill](https://github.com/objectiveSee/Uber-Alexa-Skill) - 用于呼叫 Uber 乘车的 Alexa 技能.
- [npmAlexa](https://github.com/stevengill/npmAlexa) - 用于 ping NPM API 的 Alexa 应用程序.
- [1minuteMindfullnessSkill](https://github.com/unitygirl/1minuteMindfullnessSkill) - Alexa 技能的技能代码：1 分钟正念.
- [codeword-alexa-skill](https://github.com/asimihsan/codeword-alexa-skill) - 使用 Alexa 生成代码字.
- [alexa-league](https://github.com/amphy/alexa-league) - Riot API 的 Alexa 技能.
- [alexa-astro](https://github.com/peap/alexa-astro) - 向您的 Amazon Echo 询问有关夜空的信息.
- [alexa_metar](https://github.com/djacobow/alexa_metar) - 在 Amazon Echo 上大声朗读 ADDS METAR.
- [alexa-qrz](https://github.com/maihde/alexa-qrz) - 用于查找 FCC 许可证信息的 Alexa 技能.
- [alexa-airportinfo](https://github.com/bignerdranch/alexa-airportinfo) - 此技能使用 FAA API 报告给定机场代码的当前天气和任何延误.
- [alexa-ha](https://github.com/unityfire/alexa-ha) - 一项 Amazon Echo 技能，用于通过语音控制您的家庭自动化.
- [alexia-starter-kit](https://github.com/Accenture/alexia-starter-kit)  - 具有使用 Alexia Framework 创建的示例 Amazon Echo 技能的入门套件项目. 包含 eslint 配置、示例意图结构、单元测试等.
- [geemusic](https://github.com/stevenleeg/geemusic) - 谷歌音乐和亚马逊 Alexa 之间的桥梁.
- [alex-robinhood-skill](https://github.com/dvehar/alexa-robinhood-skill) - Robinhood 的非官方 Alexa 技能.

## Boilerplates

- [skill-sample-nodejs-fact](https://github.com/alexa/skill-sample-nodejs-fact) - 此 Alexa 示例技能是基本事实技能的模板.
- [skill-sample-nodejs-audio-player](https://github.com/alexa/skill-sample-nodejs-audio-player) - 展示如何在 3P 技能中播放长格式音频的 Alexa 技能示例.
- [skill-sample-nodejs-petmatch](https://github.com/alexa/skill-sample-nodejs-petmatch) - 此 Alexa Skill Kit 示例展示了如何使用对话管理和实体解析来构建技能.
- [skill-sample-nodejs-team-lookup](https://github.com/alexa/skill-sample-nodejs-team-lookup) - Alexa 技能示例展示了如何构建团队查找技能.
- [skill-sample-nodejs-city-guide](https://github.com/alexa/skill-sample-nodejs-city-guide) - 一个 Alexa 技能示例，展示了如何构建以单个城市的地标和新闻为特色的技能.
- [skill-sample-nodejs-audio-player](https://github.com/alexa/skill-sample-nodejs-audio-player) - 展示如何在 3P 技能中播放长格式音频的 Alexa 技能示例.
- [skill-sample-nodejs-highlowgame](https://github.com/alexa/skill-sample-nodejs-highlowgame) - 此 Alexa 示例技能是基本高低游戏技能的模板.
- [skill-sample-nodejs-howto](https://github.com/alexa/skill-sample-nodejs-howto) - 本教程将引导初次使用 Alexa 技能的开发人员完成使用名为“Minecraft Helper”的模板创建基于参数的技能所涉及的所有必需步骤.
- [skill-sample-nodejs-feed](https://github.com/alexa/skill-sample-nodejs-feed) - 一个 Alexa 技能模板，可帮助创建阅读 RSS/Atom 提要的技能.
- [skill-sample-nodejs-decision-tree](https://github.com/alexa/skill-sample-nodejs-decision-tree) - 一个 Alexa 技能示例，用于构建可以引导用户通过决策树的技能，例如“早餐我应该吃什么？”.
- [skill-sample-nodejs-calendar-reader](https://github.com/alexa/skill-sample-nodejs-calendar-reader) - 显示如何从 .ICS 文件导入日历数据的 Alexa 技能示例.
- [skill-sample-nodejs-trivia](https://github.com/alexa/skill-sample-nodejs-trivia) - 这个 Alexa 示例技能是一个带有记分功能的问答类游戏的模板.
- [skill-sample-nodejs-quiz-game](https://github.com/alexa/skill-sample-nodejs-quiz-game) - Alexa 技能示例展示了如何构建问答游戏技能.
- [skill-sample-nodejs-salesforce](https://github.com/alexa/skill-sample-nodejs-salesforce) - 该项目演示了如何利用帐户链接和个人语音代码构建与您的 Salesforce 数据集成的 Alexa 私人技能.

## Prototyping

- [VoiceX](https://anilkk.github.io/voicex/) - 语音用户界面的原型示例对话框.
- [Sayspring](https://www.sayspring.com) - 为 Amazon Alexa 和 Google Home 创建交互式语音原型.
- [BotSociety](https://botsociety.io) - 预览和原型化您的语音界面.
- [Skillinator](https://skillinator.io/) - 用于 JavaScript / Node.js (Lambda) 的 Alexa Skills Kit SDK 的 Alexa Skills 原型.
- [Storyline](https://thestoryline.io) - 创建和发布 Amazon Alexa 技能，无需使用可视化界面和预构建模板进行编码.
- [Smartly.AI](https://smartly.ai) - 为您的语音和聊天机器人项目提供一个平台.
- [PullString](https://www.pullstring.com) - 为 Amazon Alexa、Google Assistant 和 IoT 设备设计、制作原型和发布语音应用程序.
- [Conversable](http://conversable.com/) - Conversable 是企业对话智能平台，用于在任何消息或语音渠道上创建直观、按需、自动化的体验.
* [kitt.ai](https://kitt.ai) - KITT.AI 通过 ChatFlow 和嵌入式设备上的可定制唤醒词检测提供会话理解即服务.

## Analytics

- [Dashbot](https://www.dashbot.io/alexa) - 亚马逊 Alexa 的可操作分析.
- [Opearlo](http://www.opearlo.com) - Opearlo 是一家语音设计机构，提供 Alexa 技能设计和开发，以及 Opearlo Analytics，这是一个洞察 Alexa 技能使用情况的平台.
- [Alpine.ai](http://alpine.ai) - Alpine 是语音体验分析领域的先驱，也是使用最广泛的 Alexa 技能产品分析服务.
- [WitLingo](http://www.witlingo.com) - Witlingo 是一家 SaaS 产品公司，它使技能开发人员能够访问分析、诊断和发现工具，以帮助他们提高技能.


## Utilities

- [Alexa-Utterance-Generator](https://github.com/tejashah88/Alexa-Utterance-Generator) - 一个允许您使用简单的 GUI 生成大量话语的网站.
- [Alexa Smart Home Payload V3 Generator](http://ec2-52-207-149-121.compute-1.amazonaws.com/) - 生成智能家居 v3 发现有效载荷的网站.
- [Skillinator](https://skillinator.io/)  - 帮助从交互模型 JSON 文件生成 Lambda 模板代码的网站. 亚马逊员工创建的服务.
- [Skill Code Generator](https://s3.amazonaws.com/webappvui/skillcode/v2/index.html) - 一个帮助在 ASK SDK v2 中生成 Lambda 样板代码的工具，带有各种问候选项、显示模板响应
- [Audio converter (Storyline)](https://getstoryline.com/audio-converter)  - 这个简单的工具可以帮助您将 MP3 转换为适用于 Amazon Alexa 技能的正确格式. 它也适用于 Google Actions.
- [Audio converter (Jovo)](https://www.jovo.tech/audio-converter) - 转换 MP3 文件以用于 Amazon Alexa Skills.
- [Tophonetics](https://tophonetics.com) - 用于 Amazon Alexa 技能中 SSML 的免费国际音标 (IPA) 语音生成器.

## Monitoring

- [Bespoken](http://bespoken.io)  - Bespoken 为 Alexa 技能（和 Google Actions）提供监控和测试工具. 我们的平台会跟踪以确保您的技能正常工作，并在不正常时提醒您.
- [VoiceLabs.com - Testing and Monitoring Alexa skills](https://voicelabs.com) - VoiceLabs 是 Alexa 技能和 Google Actions 的免费测试和监控平台.

## Newsletters

- [ASK Dev Weekly](http://askdevweekly.com/) - 每周订阅精选的最佳 Alexa Skills Kit (ASK) 开发链接.
- [Hearing Voices](https://www.getrevue.co/profile/hearingvoices) - 本周有关语音计算应用程序的新闻，直接发送到您的收件箱.
- [Alexa Developer](https://developer.amazon.com/alexa-skills-kit/alexa-developer-newsletter-subscription) - 最新的 Amazon Alexa 新闻以及物联网和语音行业趋势.
- [Love My Echo](http://lovemyecho.us12.list-manage1.com/subscribe?u=a2fd80e8af2452554af237cf4&id=353528c5b3) - Things To Ask Alexa、操作方法、提示、技巧等.
- [VoiceBot](https://www.voicebot.ai/subscribe/) - 关于 Amazon Alexa、Google Home、Google Deep Mind、Apple Siri、Microsoft Cortana、IBM Watson 等的最新消息.
- [Voice Dev Rocks](https://voicedev.rocks/) - 由 Amazon Alexa、Google Assistant 和 Microsoft Cortana Slack 社区为您提供的每周精选出版物，其中包含有趣的相关链接.
- [Talking to Computers](https://talkingtocomputers.substack.com/welcome) - 关于在 Alexa、Google Assistant 和其他地方为开发人员、设计师和对技术感兴趣的人构建语音的每月时事通讯.

## Podcasts

- [Alexa Dev Chat](https://itunes.apple.com/us/podcast/alexa-dev-chat/id1131682069) - 播客包括 Alexa 新闻、开发人员技巧以及对 Alexa 开发人员和 Alexa 员工的采访.
- [VoiceBot Podcasts](https://www.voicebot.ai/voicebot-podcasts/) - 将关于所有语音网络的最重要的新闻和评论集中在一个地方.
- [VoiceFirst.FM](https://www.voicefirst.fm/) - 致力于语音优先技术的播客网络.

## Blogs

- [Love My Echo](http://lovemyecho.com/) - Love My Echo 是第一个专门介绍 Amazon Echo 的面向消费者的网站：它是什么、它能做什么以及如何从中获得最大收益.
- [VoiceBot](https://www.voicebot.ai/) - 关于语音行业和亚马逊 Alexa 的主要新闻来源之一.
- [Jargon Blog](https://jargon.com/blog/) - Jargon Blog 每周发布有关语音 101 和产品新闻的更新

## Books

- [Designing Voice User Interfaces: Principles of Conversational Experiences](https://www.amazon.com/Designing-Voice-User-Interfaces-Conversational/dp/1491955414) - 如何设计语音用户界面.
- [How To Program - Amazon Echo: Design, Development and Testing Alexa Skills](https://www.amazon.com/How-Program-Amazon-Echo-Development-ebook/dp/B011J6AP26) - 如何为 Amazon Alexa 编程.
- [Developing Amazon Alexa Games: A Game Designer’s Handbook](https://www.amazon.com/Developing-Amazon-Alexa-Games-Designers-ebook/dp/B0739N4MJH) - 游戏设计师手册.
- [Voice Applications for Alexa and Google Assistant](https://www.manning.com/books/voice-applications-for-alexa-and-google-assistant) - 这本书教你如何设计、构建和共享语音应用程序.
[Voice-First Development](https://www.manning.com/books/voice-first-development) - 在这本富有洞察力的指南中，您将为现代语音技术打下坚实的基础.


## Tutorials

- [Alexa Voice Service (AVS) with cURL](https://miguelmota.com/blog/alexa-voice-service-with-curl/) - 关于通过 cURL 与 Alexa 语音服务交互的教程.
- [Alexa Voice Service (AVS) Authentication](https://miguelmota.com/blog/alexa-voice-service-authentication/) - Alexa 语音服务认证教程.
- [How to develop an Alexa Skill](https://www.pluralsight.com/guides/alexa-run-this-javascript-app) - 创建 Alexa 技能的教程.
- [How to create an Alexa Skill using Alexia Framework](https://accenture.github.io/blog/2016/11/18/alexia-framework.html) - 使用 Alexia 框架的教程.
- [How to create a cross-platform voice app using Assistant.js](https://github.com/webcomputing/AssistantJS/wiki/Getting-Started) - 使用 Assistant.js 的教程.

## Videos

- [AWS re:Invent 2015 | (MBL301) Creating Voice Experiences Using Amazon Alexa](https://www.youtube.com/watch?v=mOcxd_KcQJI) - 了解如何在 Alexa 上创造良好的用户体验.
- [AWS re:Invent 2015 | (MBL310) Alexa Voice Service Under the Hood](https://www.youtube.com/watch?v=qEYbjCXOU7Q) - 深入了解 Alexa.
- [How to create an Alexa skill without coding?](https://www.youtube.com/watch?v=2nXO-lj72Gc)
- [How to create your own Flash Briefing skill for Amazon Alexa](https://www.youtube.com/watch?v=kfSP1Munn1M) - 创建您自己的快速简报技能.
- [How to Publish Your Alexa Skill to all the English-speaking Regions](https://www.youtube.com/watch?v=_Ph6K_-1_mw) - 发布您的 Alexa 技能.
- [Dabble Lab](https://www.youtube.com/channel/UCfY-LopSxGekh9LruXLjffg/videos) - 关于为 Amazon Alexa 和相关主题构建自定义技能的每周视频.
- [Building Voice Apps Using Amazon Alexa](https://www.udemy.com/building-voice-apps-using-amazon-alexa/?siteID=Fh5UMknfYAU-NFsHPO_AesnmvLmMUzZEqw&LSNPUBID=Fh5UMknfYAU) - 为 Echo 和其他支持 Alexa 的设备构建流畅的声控应用程序.
- [Build for Echo Show](https://www.youtube.com/playlist?list=PL4iXGvrBx4ZMPOMDYsbHwjZdaByEL2W2y) - 学习为 Echo Show 开发多模式技能.

## Courses

- [Introduction to Voice Design with Amazon's Alexa](https://www.udemy.com/amazonalexa/) - Alexa 语音设计简介.
- [Cakewalk - Build an engaging Alexa Skill](https://developer.amazon.com/en-US/alexa/alexa-skills-kit/resources/training-resources/cake-walk) - 从头开始​​构建引人入胜的 Alexa 技能直至获得认证.
## Communities

- [Unofficial Alexa Slack](http://www.alexaslack.com)  - 一组专注于支持 Amazon Alexa 的硬件和软件的聊天频道. 欢迎开发人员、设计师、营销人员、商务人士、业余爱好者、学生和其他涉及技术的专业人士.
- [Alexa Developers Slack-- India Community ](https://github.com/miguelmota/awesome-amazon-alexa/blob/master/Alexa.design/indiaslackinvite)  - 一组专注于印度 Amazon Alexa 技能开发的聊天频道. 从学生开发人员到 Amazon 的 Alexa 福音传道者，所有人都在这里为您提供帮助.
- [Storyline community](https://www.facebook.com/groups/storylinecommunity/) - Alexa 开发人员的 Facebook 社区围绕故事情节构建，无需编码即可创建语音应用程序的工具.
- [Alexa Dev Days](https://developer.amazon.com/alexa/devday)  - Alexa Dev Days 是来自亚马逊并由英特尔赞助的免费互动活动. 参与实践课程，您将在其中学习创建语音体验并聆听有关 UI 设计和行业趋势的最新信息. 各级学习者都可以加入我们，参加培训课程、研讨会、现场演示，并与 Alexa 专家和您的同行交流.

## Influencers

- [Influencers](https://github.com/miguelmota/awesome-amazon-alexa/blob/master/INFLUENCERS.md) - 亚马逊 Alexa 影响者列表.


## Conferences

- [Voice Summit](https://www.voicesummit.ai/)- 由 Amazon Alexa 赞助的 VOICE 峰会是世界上最大的语音技术会议
- [Alexa VoxCon](http://amazonalexavoxcon.com) - 亚马逊 Alexa 的万物语音大会.

## Jobs

- [Find Voice Jobs](https://www.findvoicejobs.com) - 在 VUI 域中查找工作的网站

## Easter Eggs

- [Alexa Easter Eggs](https://github.com/miguelmota/awesome-amazon-alexa/blob/master/EASTER_EGGS.md) - Alexa 复活节彩蛋列表.

## Fundraising

- [Alexa Fund](https://developer.amazon.com/alexa-fund) - Alexa Fund 提供高达 1 亿美元的风险投资资金，以推动语音技术创新.

## Contributing

分叉并提交合并请求！

请阅读 [contribution guidelines](https://github.com/miguelmota/awesome-amazon-alexa/blob/master/CONTRIBUTING.md) . 谢谢！

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)
