<div class="github-widget" data-repo="tayllan/awesome-algorithms"></div>
## Awesome Algorithms

A curated list of awesome places to learn and/or practice algorithms.
Inspired by [awesome-awesomeness](https://github.com/bayandin/awesome-awesomeness) and all the other awesome Awesome libraries.

If you want to contribute, please read the [contribution guidelines](https://github.com/tayllan/awesome-algorithms/blob/master/CONTRIBUTING.md).


## Websites

*Websites you should use to learn classic algorithms*

* [A Visual Guide to Graph Traversal Algorithms](https://workshape.github.io/visual-graph-algorithms/) - Interactive visualizations for learning how graph traversal algorithms work.
* [W3School](https://www.w3schools.in/data-structures-tutorial/intro/) - Data Structures tutorial.
* [CodeChef](https://www.codechef.com/roadmap/algorithms) - Learning DSA by practice on Codechef
* [Algorithm Visualizer](http://algo-visualizer.jasonpark.me/) - Dozens of animated algorithms (with code), and you can also create your own.
* [Algorithms Visualization](http://bost.ocks.org/mike/algorithms/) - A dense article on Algorithms Visualization.
* [Big-O Cheat Sheet](http://bigocheatsheet.com/) - Big-O complexities of common algorithms used in Computer Science.
* [Code-Drills](https://code-drills.com/tools/comparator) - Practice problems recommender (includes Codeforces, Codechef, and Spoj).
* [CP-Algorithms](https://cp-algorithms.com/) - Algorithms and data structures are especially popular in the field of competitive programming.
* [Data Structure Visualizations](http://www.cs.usfca.edu/~galles/visualization/Algorithms.html) - Visualize the behavior of Data Structures and play with its operations.
* [Geeks for Geeks](http://www.geeksforgeeks.org/fundamentals-of-algorithms/) - Lots and lots of well-explained and implemented algorithms.
* [Path Finding](https://qiao.github.io/PathFinding.js/visual/) - A visual representation of how algorithms such as A\*, IDA\*, Breadth-First-Search, Best-First-Search, and others describe a path between two points A and B.
* [Programiz](https://www.programiz.com/dsa) - Easy to follow tutorials on data structures and algorithms along with suitable examples.
* [Rosetta Code](http://rosettacode.org/wiki/Rosetta_Code) - A programming chrestomathy site that aims to present implementations of many algorithms and data structures in different programming languages.
* [Sorting Algorithms](http://www.sorting-algorithms.com/) - Nice and simple animations of sorting algorithms. With short codes and discussions.
* [Stoimen's web log](http://www.stoimen.com/) - Some algorithms nicely explained.
* [The Sound of Sorting](http://panthema.net/2013/sound-of-sorting/) - The Sound of Sorting - "Audibilization" and Visualization of Sorting Algorithms
* [VisuAlgo](http://visualgo.net) - Visualising data structures and algorithms through animation.
* [Wikipedia - Algorithms](https://en.wikipedia.org/wiki/List_of_algorithms) - Of course!!
* [Wikipedia - Data Structures](https://en.wikipedia.org/wiki/List_of_data_structures) - and why not ?!!
* [Learnersbucket](https://learnersbucket.com/) - Tutorials on data structures and algorithms in Javascript.
* [redblobgames](https://www.redblobgames.com/) - interactive visual explanations of math and algorithms, using motivating examples from computer games.

## Youtube Playlists

*High Quality Courses and tutorials on youtube*

* [Tim Roughgarden. Algorithms Illuminated](https://www.algorithmsilluminated.org/) - Tim Roughgarden, a pioneer of computer science, offers a companion to his book, with lecture videos and slides.
* [FreeCodeCamp - Algorithms and Data Structures Tutorial - Full Course for Beginners](https://www.youtube.com/watch?v=8hly31xKli0) - Complete beginner friendly Algorithms and Data Structures Tutorial with mindblowing animation.
* [Abdul Bari - Introduction to Algorithm](https://www.youtube.com/watch?v=0IAPZzGSbME&list=PLDN4rrl48XKpZkf03iYFl-O29szjTrs_O) - This playlist is so much informative and provide simulation with code example. As like as you are in a class.
* [Jenny's Lectures- Algorithm](https://www.youtube.com/watch?v=AT14lCXuMKI&list=PLdo5W4Nhv31bbKJzrsKfMpo_grxuLl8LU) - Another complete algorithm playlist from basic level to intermediate. Easy explanation and simulation.

## Online Courses

*Free and High-Quality Courses Online*

* [Algorithms: Divide and Conquer, Sorting and Searching, and Randomized Algorithms](https://www.coursera.org/learn/algorithms-divide-conquer) - The primary topics are: asymptotic ("Big-oh") notation, sorting and searching, divide and conquer, and randomized algorithms.
* [Algorithms: Graph Search, Shortest Paths, and Data Structures](https://www.coursera.org/learn/algorithms-graphs-data-structures) - The primary topics are: data structures, graph primitives, and their applications.
* [Algorithms: Greedy Algorithms, Minimum Spanning Trees, and Dynamic Programming](https://www.coursera.org/learn/algorithms-greedy) - The primary topics are: greedy algorithms and dynamic programming.
* [Algorithms: Shortest Paths Revisited, NP-Complete Problems and What To Do About Them](https://www.coursera.org/learn/algorithms-npcomplete) - The primary topics are: shortest paths, NP-completeness and what it means for the algorithm designer, and strategies for coping with computationally intractable problems.
* [Algorithms, Part I](https://www.coursera.org/learn/algorithms-part1/home/welcome) - This course covers the essential information that every serious programmer needs to know about algorithms and data structures. Part I covers elementary data structures, sorting, and searching algorithms. 
* [Algorithms, Part II](https://www.coursera.org/learn/algorithms-part2) - Part II focuses on graph- and string-processing algorithms.
* [Khan Academy Algorithms](https://www.khanacademy.org/computing/computer-science/algorithms) - Algorithm course ministered by Tomas Cormen and Devin Balkcom.
* [MIT - 6-006](https://ocw.mit.edu/courses/6-006-introduction-to-algorithms-fall-2011/video_galleries/lecture-videos/) - Well explained algorithms.
* [MIT - 6-046j](https://ocw.mit.edu/courses/6-046j-introduction-to-algorithms-sma-5503-fall-2005/video_galleries/video-lectures/) - Similar to the previous one, but with different algorithms.
* [MIT - 6-00sc](http://ocw.mit.edu/courses/electrical-engineering-and-computer-science/6-00sc-introduction-to-computer-science-and-programming-spring-2011/index.htm) - An easy and well-explained introduction to algorithms.
* [MIT 18-409 - Topics in Theoretical Computer Science: An Algorithmist's Toolkit](https://ocw.mit.edu/courses/18-409-topics-in-theoretical-computer-science-an-algorithmists-toolkit-fall-2009/) - It covers a collection of geometric techniques that apply broadly in modern algorithm design.
* [Udacity Intro to Algorithms](https://www.udacity.com/course/intro-to-algorithms--cs215) - Python-based Algorithms course.
* [Algorithms in Motion](https://www.manning.com/livevideo/algorithms-in-motion) - Beginner's algorithms course with fun illustrations, based on the book Grokking Algorithms
* ~~[YogiBearian YouTube Channel](https://www.youtube.com/channel/UCv3Kd0guxD5KWQtP---9D6g) - Lots of well-explained videos on various computer science subjects.~~ _Account terminated due to violations of Youtube Policies._

## Books

*The most highly regarded books to learn algorithms*

### Algorithms and Data structures
* [Algorithm Design](https://www.pearsonhighered.com/program/Kleinberg-Algorithm-Design/PGM319216.html) - Pretty straightforward.
* [Algorithms](http://algs4.cs.princeton.edu/home/) - Problems explained with Java, OO good practices, visualizations, and free online resources.
* [Algorithms and Data Structures in JavaScript](https://gum.co/dsajs) - Classical algorithms and data structures implemented and explained using JavaScript.
* [Algorithms in a Nutshell](https://www.amazon.com/Algorithms-Nutshell-In-OReilly/dp/059651624X) - by  George T. Heineman.
* [Classic Computer Science Problems in Python](https://www.manning.com/books/classic-computer-science-problems-in-python) -This great book presents dozens of coding challenges, ranging from simple tasks to clustering data using k-means.
* [Data Structures and Algorithms Made Easy](https://www.amazon.in/Data-Structures-Algorithms-Made-Easy/dp/819324527X) - A great way to implement algorithms with their specific programmable tasks.
* [Data Structures Using C](http://www.amazon.com/Data-Structures-Using-Aaron-Tenenbaum/dp/0131997467) - The basic concepts and usages of data structures.
* [Elementary Algorithms](https://github.com/liuxinyu95/AlgoXY) - An awesome book about algorithms and data structures.
* [Grokking Algorithms](http://www.manning.com/bhargava) - An illustrated book on algorithms with practical examples.
* [Introduction to Algorithms](http://mitpress.mit.edu/books/introduction-algorithms) - Essential!
* [Real World Algorithms: A Beginner's Guide](https://mitpress.mit.edu/books/real-world-algorithms) - An introduction to algorithms for readers with no background in advanced mathematics or computer science.
* [Swift Algorithms & Data Structures](http://shop.waynewbishop.com/) - A practical guide to concepts, theory, and code.
* [The Algorithm Design Manual](http://www.algorist.com/) - Easy to read and full of real-world examples.
* [The Art of Computer Programming](http://www-cs-faculty.stanford.edu/~uno/taocp.html) - The Book.
* [Structure and Interpretation of Computer Programs](https://mitpress.mit.edu/books/structure-and-interpretation-computer-programs-second-edition)
* [Advanced Algorithms and Data Structures](https://www.manning.com/books/advanced-algorithms-and-data-structures) - A different and a great way to introduce algorithms and data structures that can be used at work.
* [Algorithmic Puzzles](https://www.amazon.com/Algorithmic-Puzzles-Anany-Levitin/dp/0199740445) - A very accessible illustration of algorithms in the forms of puzzles. No programming experience is required!
* [Standford CS166](https://web.stanford.edu/class/cs166/) - Standford CS166, a course in the design, analysis, and implementation of data structures.
* [Grokking Data Structures](https://www.manning.com/books/grokking-data-structures) - Grokking Data Structures carefully guides you from the most basic data structures like arrays or linked lists all the way to powerful structures like graphs. It’s perfect for beginners.

### Algorithm Analysis
- [Sedgewick & Flajolet. An Introduction to the Analysis of Algorithm](https://www.amazon.com/Introduction-Analysis-Algorithms-Introdu-Algori_p2-ebook/dp/B00B3TB7IQ) - Am advanced complete survey, intended only for the mathematically matured reader.
- [McConnell. Analysis of Algorithms](https://www.amazon.com/Analysis-Algorithms-Jeffrey-McConnell/dp/0763707821) - A very accessible and brief book on algorithms analysis, with implemented code included.
- [Vrajitoru & Knight. Practical Analysis of Algorithms](https://www.amazon.com/Practical-Analysis-Algorithms-Undergraduate-Computer/dp/331909887X) - A very accessible and brief book on algorithms analysis, with implemented code included.

### Randomized Algorithms
- [Motwani & Raghavan. Randomized Algorithms](https://www.amazon.com/Randomized-Algorithms-Rajeev-Motwani/dp/0521474655) - A standard classic book.
- [Mitzenmacher & Upfal. Probability and Computing: Randomization and Probabilistic Techniques in Algorithms and Data Analysis](https://www.amazon.com/Probability-Computing-Randomization-Probabilistic-Techniques-ebook/dp/B06X9YBMFK) - Standard text for probability methods and their applications on randomized algorithms.

## Cheat Sheets
* [Tech Interview Cheat Sheet](https://github.com/TSiege/Tech-Interview-Cheat-Sheet)
* [Princeton DS Cheat Sheet](https://algs4.cs.princeton.edu/cheatsheet/)
* [CLRS in short](https://sinon.org/algorithms//#data-structures)
* [Rice university DS course in short](https://www.clear.rice.edu/comp160/data1.html)
* [Useful Reddit thread](https://www.reddit.com/r/learnprogramming/comments/3gpvyx/algorithms_and_data_structures_cheat_sheets/)
* [Algo Deck](https://github.com/teivah/algodeck/) - An open-source collection of +200 algorithmic cards.

## Github Libraries

*Implementations of the most classic algorithms in a wide variety of programming languages*

* C
    * [by @fragglet](https://github.com/fragglet/c-algorithms)
    * [by @TheAlgorithms](https://github.com/TheAlgorithms/C)
* [CoffeeScript](https://github.com/BrunoRB/algorithms.coffee)
* C#
    * [by @shkolovy](https://github.com/shkolovy/classic-algorithms)
    * [by @aalhour](https://github.com/aalhour/C-Sharp-Algorithms)
    * [by @justcoding121](https://github.com/justcoding121/Advanced-Algorithms)
* C++
    * [by @xtaci](https://github.com/xtaci/algorithms)
    * [by @PetarV-](https://github.com/PetarV-/Algorithms)
    * [by @faheel](https://github.com/faheel/Algos)
    * [by @sslotin](http://github.com/sslotin/algo)
* [Erlang](https://github.com/aggelgian/erlang-algorithms)
* Go
    * [by @arnauddri](https://github.com/arnauddri/algorithms)
    * [by @floyernick](https://github.com/floyernick/Data-Structures-and-Algorithms)
* Java
    * [by @jpa99](https://github.com/jpa99/Algorithms)
    * [by @phishman3579](https://github.com/phishman3579/java-algorithms-implementation)
    * [by @asmolich](https://github.com/asmolich/algorithms)
    * [by @psjava](https://github.com/psjava/psjava)
    * [by @jeandersonbc](https://github.com/jeandersonbc/algorithms-and-ds)
    * [by @pedrovgs](https://github.com/pedrovgs/Algorithms)
    * [by @Erdos-Graph-Framework](https://github.com/Erdos-Graph-Framework/Erdos)
    * [by @deepak-malik](https://github.com/deepak-malik/Data-Structures-In-Java)
    * [by @yusufcakal](https://github.com/yusufcakal/algorithms)
    * [by @FarheenB](https://github.com/FarheenB/Data-Structures-and-Algorithms)
* JavaScript
    * [by @jiayihu](https://github.com/jiayihu/pretty-algorithms)
    * [by @felipernb](https://github.com/felipernb/algorithms.js)
    * [by @nzakas](https://github.com/nzakas/computer-science-in-javascript)
    * [by @duereg](https://github.com/duereg/js-algorithms)
    * [by @mgechev](https://github.com/mgechev/javascript-algorithms)
    * [by @trekhleb](https://github.com/trekhleb/javascript-algorithms)
    * [by @ManrajGrover](https://github.com/ManrajGrover/algorithms-js)
    * [by @amejiarosario](https://github.com/amejiarosario/dsa.js)
    * [by @zonayedpca](https://github.com/zonayedpca/AlgoDS.js)
* Lua
    * [by @evandrolg](https://github.com/EvandroLG/computer_science_in_lua)
* Objective-C
    * [by @ EvgenyKarkan](https://github.com/EvgenyKarkan/EKAlgorithms)
* PHP
    * [by @TheAlgorithms](https://github.com/TheAlgorithms/PHP)
* Python
    * [by @nryoung](https://github.com/nryoung/algorithms)
    * [by @prakhar1989](https://github.com/prakhar1989/Algorithms)
    * [by @laurentluce](https://github.com/laurentluce/python-algorithms)
    * [by @nbro](https://github.com/nbro/ands)
    * [by @keon](https://github.com/keon/algorithms)
    * [by @vinta](https://github.com/vinta/fuck-coding-interviews)
* Ruby
    * [by @kanwei](https://github.com/kanwei/algorithms)
    * [by @sagivo](https://github.com/sagivo/algorithms)
    * [by @kumar91gopi](https://github.com/kumar91gopi/Algorithms-and-Data-Structures-in-Ruby)
* [Scala](https://github.com/vkostyukov/scalacaster)
* Swift
    * [by @kingreza](https://github.com/kingreza/Swift-Algorithms-Strings-)
    * [by @waynewbishop](https://github.com/waynewbishop/SwiftStructures)
    * [by @hollance](https://github.com/hollance/swift-algorithm-club)
* Language agnostic
    * [by @kennyledet](https://github.com/kennyledet/Algorithm-Implementations)
    * [by @indy256](https://github.com/indy256/codelibrary)
    * [by @sagivo](https://github.com/sagivo/algorithms)
    * [by @patmorin](https://github.com/patmorin/ods)
    * [by @btjanaka](https://github.com/btjanaka/algorithm-problems)

## Online Judges

*Online Judges to practice what you learned above*

* [A2 Online Judge](https://a2oj.com/) - Online Judge and problem archive.
* [ACM-ICPC Live Archive](https://icpcarchive.ecs.baylor.edu/) - Hundreds of problems from previous ACM-ICPC Regionals and World Finals.
* [AIZU ONLINE JUDGE](https://onlinejudge.u-aizu.ac.jp/) - A Japanese online judge from the University of Aizu, offering a wide range of algorithmic challenges.
* [Algo Muse](http://www.algomuse.appspot.com) - Research-based algorithmic problems. 
* [AtCoder](https://atcoder.jp/) - Japanese programming contest website.
* [Baekjoon Online Judge](https://www.acmicpc.net/) - Korean Online Judge. 10000+ problems. Supports 60+ languages.
* [Beecrowd](https://judge.beecrowd.com/) - The Largest Competitive Programming and Online Code Judgement Platform in Latin America.
* [CS Academy](https://csacademy.com/) - Holds online contests and IOI practice contests
* [CodeChef](https://www.codechef.com/) - More problems and monthly online contests.
* [Codeforces ](http://codeforces.com/) - The only programming contests Web 2.0 platform
* [Codefights](https://codefights.com/) - Practice programming and tackle your next tech interview
* [CodeMarshal](https://algo.codemarshal.org/) - Real-world contests online!
* [CodeWars](http://www.codewars.com/) - A website that houses support to solve algorithms in many languages in varying difficulty.
* [CoderByte](http://www.coderbyte.com/) - A decent website with algorithm challenges from beginner to advanced levels. Supports most of the popular languages like C++, python, javascript, ruby.
* [Firecode](https://www.firecode.io/) - Firecode.io uses machine learning algorithms along with curated real-world interview questions, solutions & a vibrant social community of learners to get you ready for your next coding interview.
* [Coding Blocks](https://hack.codingblocks.com/app/) - Website that has problems based on Maths, Data Structures, Various Algorithm and also conducts Coding Competition.
* [HackerEarth ](https://www.hackerearth.com/) - Practice algorithmic problems & challenges and participate in hiring challenges.
* [HackerRank](https://www.hackerrank.com/) - Featured algorithm and functional programming online judges
* [HiHoCoder](http://hihocoder.com/) - Chinese and English problem-solving practice and recruitment challenge site.
* [Infoarena](http://www.infoarena.ro/) - Romanian Online Judge. 1500+ algorithmic problems
* [Interviewbit](https://www.interviewbit.com/) - Learn, practice, and prepare for interviews.
* [Kattis](https://open.kattis.com/)- Online judge and problem archive
* [LavidaOnlineJudge](http://judge.lavida.us) - Korean Online Judge(Half English). 1300+ problems.
* [Learneroo Algorithms Tutorials](https://www.learneroo.com/subjects/8) - Learn and practice algorithms by solving challenges online.
* [LeetCode](https://leetcode.com/) - Learn algorithms and prepare for interviews.
* [Paiza](https://paiza.jp/) - A Japanese platform offering coding challenges and career preparation.
* [PKU JudgeOnline](http://poj.org/) - Chinese Online Judge.
* [ProjectEuler](https://projecteuler.net/) - Mathematical problems that can be solved using algorithms (or just a pencil, depending on how much you already know).
* [Rosalind](http://rosalind.info/problems/locations/) - A platform for learning bioinformatics and programming through problem-solving.
* [ShareCode.io ](https://sharecode.io/) - Online Judge and contest host with a lot of algorithmic problems in the archive to practice.
* [Snakify](https://snakify.org/) - An introductory Python course with 100+ algorithmic problems and a step-by-step debugger (from Russia).
* [SPOJ](http://www.spoj.com/) - More problems.
* [TopCoder](https://www.topcoder.com/) - Lots of problems and real-world/money-worthy problems in Graphic Design, Data Science, and Development.
* [Toph](https://toph.co/) - Bangladeshi Online Judge. Holds online contests regularly.
* [URI](https://www.urionlinejudge.com.br/judge/login) - Brazilian Online Judge. Not so many problems, but it's growing and it has online contests.
* [UVA](https://uva.onlinejudge.org/) - Hundreds of problems (from previous ACM-ICPC Regionals, World Finals, and others).
* [Codility](https://app.codility.com/programmers/challenges/) - Compete to land coding jobs at top companies

## Blogs

*Awesome list of blogs, mainly for competitive programming but you can refer to these when learning a new topic/algorithm*

* [An awesome list for competitive programming!](https://codeforces.com/blog/entry/23054) - Awesome blog for all the resources and list of books and algorithms.
* [Algorithms Weekly](https://petr-mitrichev.blogspot.com/) - A good blog by Petr Mitrichev, mainly in Java.
* [Sport of Programming](https://www.hackerearth.com/practice/notes/getting-started-with-the-sport-of-programming/) - Informative blog for starting with the sport of programming.
* [Algorithms and Data Structures](http://www.allisons.org/ll/AlgDS/) - For getting a deeper knowledge of algorithms and how to think in the right direction.
* [Algorithm Tutorials by Tanuj Khattar](https://tanujkhattar.wordpress.com/) - Excellent blog by Tanuj Khattar. Covers tutorials on some interesting data structures along with example problems to solve. 


## Tools

*Some tools that can help you in the learning of algorithms*

* [interactive-coding-challenges](https://github.com/donnemartin/interactive-coding-challenges) - Interactive, test-driven coding challenges (algorithms and data structures).

## Related Awesome Lists
- [Math](https://github.com/rossant/awesome-math#readme) - Freely available lecture notes on mathematics.
- [Theoretical Computer Science](https://github.com/mostafatouny/awesome-theoretical-computer-science/blob/main/README.md) - The interdisciplinary of Mathematics and Computer Science, Distinguished by its emphasis on mathematical technique and rigour.


## License

And for the sake of copyleft, here's our license:

[![Creative Commons License](http://i.creativecommons.org/l/by/4.0/88x31.png)](http://creativecommons.org/licenses/by/4.0/)

This work is licensed under a [Creative Commons Attribution 4.0 International License](http://creativecommons.org/licenses/by/4.0/).
