<div class="github-widget" data-repo="brycejohnston/awesome-agriculture"></div>
## Awesome Agriculture [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

&gt; 农业、耕作和园艺领域出色的开源技术精选列表.

[Agriculture](https://en.wikipedia.org/wiki/Agriculture) 是培育植物和牲畜以获取食物和材料的科学和艺术.

欢迎投稿！ 请遵循 [contributing guidelines](https://github.com/beaorn/awesome-agriculture/blob/master/contributing.md).



## Automation and Robotics

- [Ant Robotics](https://antrobotics.de/) Ecoterra bot 的开发
- [Acorn Rover](https://github.com/Twisted-Fields) 精准农业漫游车、Odrive、Python.
- [Earth Rover](https://github.com/earthrover) Ag AGV ROS1精准农业流动站 
- [EcoTerra Bot](https://ecoterrabot.com/) 达美航空和罗孚
- [FarmBot](https://github.com/farmbot) - 开源精准园艺项目.
- [Fields2Cover](https://github.com/Fields2Cover/Fields2Cover) - 自主农用车辆稳健高效的覆盖路径.
- [Romi project](https://media.romi-project.eu/documents/index.html) 欧洲资助的研究项目 
- [ROS Agriculture](http://rosagriculture.org/) - 开源社区专注于使用机器人操作系统为农民提供机器人工具. 
- [Weedinator](https://hackaday.io/project/53896-weedinator-2019) Line following weeding robot

## Calculators

- [farm-calculators](https://github.com/brycejohnston/farm-calculators) - 用于计算各种农业和农作物相关信息的 WordPress 插件.

## Climate, Environment and Weather

- [agroclimatology](https://github.com/brycejohnston/agroclimatology) - 用于与 NASA (POWER) 农业气候学 Web 资源交互的 Ruby 客户端.
- [evapotranspiration](https://github.com/brycejohnston/evapotranspiration) - 用于计算参考作物蒸散量 (ETo) 的 Ruby 库.
- [frostline](https://github.com/waldoj/frostline) - 美国农业部植物抗寒区的数据集、API 和 python 解析器.
- [GSODR](https://github.com/ropensci/GSODR) - R 中的全球每日天气数据汇总.
- [iem](https://github.com/akrherz/iem) - 使爱荷华州环境 Mesonet 运行的代码.
- [PyETo](https://github.com/woodcrafty/PyETo) - 用于计算参考/潜在蒸散量 (ETo) 的 Python 包.
- [pyTSEB](https://github.com/hectornieto/pyTSEB) - 用于利用遥感数据估计蒸散量的Python两源能量平衡模型.
- [soilDB](https://github.com/ncss-tech/soilDB) - R 库，用于简化对 NCSS 土壤数据库的访问.

## Crop Modeling, Phenotyping, and Pathology

- [Open Plant Pathology](https://www.openplantpathology.org/) - 一个重视开放数据和计算工具以推进流行病学和病原体种群生物学和生态学的社区.

## Datasets
- [Growstuff](https://www.growstuff.org/crops) 记录保存和作物数据库，不错的 API
- [CWFID](https://github.com/cwfid/dataset) - 数据集包括田野图像、植被分割掩模和作物/杂草植物类型注释.
- [TERRA REF](https://terraref.org) - 来自高粱育种试验的 1PB 公共领域高分辨率传感器数据（[data publication](https://doi.org/10.5061/dryad.4b8gtht99) 有大文件可用 [globus.org at ncsa#terra-public](https://app.globus.org/file-manager?origin_id=e8feaff4-96cd-11ea-bf90-0e6cccbb0103&origin_path=%2F))

## Data Standardization, Interoperability and APIs

- [AgGateway’s ADAPT Toolkit](https://adaptframework.org) - 开源项目提供工具来简化种植者、他们的机器和合作伙伴之间的沟通.
- [Agstack](https://github.com/agstack) - 农业生态系统的开源数字基础设施.
- [agx-ruby](https://github.com/brycejohnston/agx-ruby) - Proagrica 的 agX 平台 API 的 Ruby 客户端.
- [API-Code-Samples](https://github.com/aWhereAPI/API-Code-Samples) - 包含aWhere的API平台代码示例.
- [ClearAg-API-Examples](https://github.com/IterisClearAg/ClearAg-API-Examples) - 使用 ClearAg API 的代码示例集合.
- [JDLinkMachineDataAPI-OAuth2-CSharp-Example](https://github.com/JohnDeere/JDLinkMachineDataAPI-OAuth2-CSharp-Example) - CSharp JDLink 机器数据 API 客户端示例.
- [Open Ag Data Alliance](https://github.com/oada) - OADA 是一个开放项目，旨在为农业数据带来互操作性、安全性和隐私性.
- [MyJohnDeereAPI-OAuth2-Java-Example](https://github.com/JohnDeere/MyJohnDeereAPI-OAuth2-Java-Example) - Java MyJohnDeere API 客户端示例.
- [MyJohnDeereAPI-OAuth2-NodeJS-Example](https://github.com/JohnDeere/MyJohnDeereAPI-OAuth2-NodeJS-Example) - Node.js MyJohnDeere API 客户端示例.
- [MyJohnDeereAPI-OAuth2-Python-Example](https://github.com/JohnDeere/MyJohnDeereAPI-OAuth2-Python-Example) - Python MyJohnDeere API 客户端示例.
- [OpenTeam](https://openteam.community/) - 农业管理开放技术生态系统
- [SampleData](https://github.com/JohnDeere/SampleData) - 示例数据卡、shapefile 和其他可用于测试的文件.
- [SencropAPI-JavaScript-Client](https://github.com/sencrop/sencrop-js-api-client)  - Sencrop API Javascript 客户端实现. 阅读和管理 Sencrop 气象站.

## Farm Management Systems and Record Keeping

- [AgroSense](https://bitbucket.org/corizon/agrosense) - 使用 Java 构建的免费开源农场管理套件.
- [farmOS](https://github.com/farmOS/farmOS) - 使用 Drupal 和 PHP 构建的基于 Web 的农场记录保存应用程序.
- [Ekylibre](https://github.com/ekylibre/ekylibre) - 使用 Ruby on Rails 和 PostgreSQL/PostGIS 构建的农民和小型企业农场管理信息系统.
- [Soil Mate](https://github.com/Open-Source-Agriculture/soil_mate) - 旨在协助收集土壤数据的助手应用程序.
- [Tania](https://github.com/Tanibox/tania-core) - 使用 Go 和 Vue.js 构建的免费开源农业管理系统，适合所有人.

## Geospatial and GIS

### GIS Resources

- [Awesome GIS](https://github.com/sshuair/awesome-gis) - Awesome GIS是一个收集丰富GIS相关资源的列表.

### GIS Platforms

- [QGIS](https://qgis.org) - QGIS 是一个免费、开源、跨平台（lin/win/mac）的地理信息系统.

### Shapefiles

- [pyshp](https://github.com/GeospatialPython/pyshp) - 用纯 Python 读取和写入 ESRI Shapefile.
- [rgeo-shapefile](https://github.com/rgeo/rgeo-shapefile) - RGeo Shapefile 是 RGeo 的一个可选模块，用于从 Ruby 中的 ESRI shapefile 读取地理空间数据.

## IoT, Hardware

- [AgOpenGPS](https://github.com/farmerbriantee/AgOpenGPS) - Ag 精密测绘和截面控制软件.
- [DRO-Matic](https://github.com/drolsen/DRO-Matic) - 适用于 DIY DRO-Matic 柜的全自动水培操作系统 - 营养剂量、灌溉、补水、计时器、EC 和 pH 漂移修复.
- [Farm-Data-Relay-System](https://github.com/timmbogner/Farm-Data-Relay-System) - 系统使用 ESP-NOW、LoRa 和其他协议在偏远地区传输传感器数据，无需依赖 WiFi.
- [Farm Hack](https://farmhack.org/tools) - 构建和修改我们自己的工具的全球农民社区.
- [Open Agriculture Foundation](https://github.com/OpenAgricultureFoundation) - 开源技术生态系统，可实现并促进透明度、网络化实验、教育和超本地化生产.
- [OpenMinder](https://github.com/autogrow/openminder) - RaspberryPi 的开源 Rootzone 监控、API 和开源帽子.
- [OpenWeedLocator](https://github.com/geezacoleman/OpenWeedLocator) - 适用于作物和休耕情况的开源、低成本、基于图像的杂草检测设备.

## Knowledgebases and Learning Resources

- [Harvest Helper](https://github.com/damwhit/harvest_helper) - 提供数据库中 45 种植物的生长、收获和配方信息以及 JSON API.
- [OpenFarm](https://github.com/openfarmcc/OpenFarm) - 使用 Ruby on Rails 构建的免费开放的农业和园艺知识数据库.

## Machine Learning and AI
- [AgML](https://github.com/Project-AgML/AgML) - 农业机器学习的集中框架.
- [agridat](https://github.com/kwstat/agridat) - R 包提供了农业实验的广泛数据集.
- [Crop Yield Prediction](https://github.com/JiaxuanYou/crop_yield_prediction) - 基于遥感数据的作物产量预测的深度高斯过程.
- [Deep Learning for Biologists with Keras](https://github.com/totti0223/deep_learning_for_biologists_with_keras) - 基于深度学习的分析（主要）关于生物相关主题的教程.
- [FarmVibes.AI](https://github.com/microsoft/farmvibes-ai) - 用于农业和可持续发展的多模式地理空间机器学习模型.
- [PlantCV](https://github.com/danforthcenter/plantcv) - 使用计算机视觉的植物表型软件.

## Remote Sensing and Imagery

- [Awesome Sentinel](https://github.com/Fernerkundung/awesome-sentinel) - 与哥白尼哨兵卫星数据相关的出色工具、教程和 API 的精选列表.
- [Raster Vision](https://github.com/azavea/raster-vision) - 航空/卫星图像的深度学习.
- [Sen2Agri](https://github.com/Sen2Agri/Sen2Agri-System) - 处理用于农业目的的高分辨率卫星图像的软件系统.
- [Awesome Vegetation Index](https://github.com/px39n/Awesome-Vegetation-Index) - 多光谱、高光谱和无人机图像的常见植被指数的参考列表和应用.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

在法律允许的范围内， [Bryce Johnston](https://github.com/brycejohnston) 已放弃本作品的所有版权以及相关或邻接权.
