<div class="github-widget" data-repo="ravirupareliya/awesome-actions-on-google"></div>
## Awesome Actions on Google  [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)

很棒的 AoG（Action on Google）库、博客、开源项目、视频的精选列表.

With [Actions on Google](https://developers.google.com/actions/) ，您可以轻松覆盖 Google 上的用户并与之互动. 从快速命令到完整对话，Actions 可帮助您通过 Google 智能助理将您的内容和服务与用户联系起来.



## Document

- [Actions on Google](https://developers.google.com/actions/)
- [Template Actions](https://developers.google.com/actions/templates/)
- [Build digital transactions](https://developers.google.com/actions/transactions/digital/dev-guide-digital)
- [Interactive Canvas](https://developers.google.com/actions/interactivecanvas)

## Blogs
- [Chord Assist: Building an accessible smart guitar for the blind, deaf and mute](https://medium.com/google-developer-experts/chord-assist-building-an-accessible-smart-guitar-for-the-mute-deaf-and-blind-4f81669ab663) - 乔·伯奇.
- [The Full-Stack Guide to Actions for Google Assistant](https://medium.com/google-developer-experts/the-full-stack-guide-to-actions-for-google-assistant-e1765edd075b) - 经过 [Uri Shaked](https://twitter.com/UriShaked)
- [Building an Action for Google Assistant: Getting Started](https://www.raywenderlich.com/1217997-building-an-action-for-google-assistant-getting-started) - 经过 [Jenn Bailey](https://www.raywenderlich.com/u/invisigothcodegirl)
- [Build your own Action for Google Assistant](https://www.androidauthority.com/how-to-build-google-assistant-actions-877154/) - 经过 [Jessica Thornsy](https://www.androidauthority.com/author/jessicathornsby/)
- [Create Your First Google Assistant Application](https://android.jlelse.eu/create-your-first-google-assitant-application-9a51cea37728) - 经过 [Ravi Rupareliya](https://twitter.com/ravi_rupareliya)
- [How to automate testing for Google Assistant Apps?](https://xebia.com/blog/how-to-automate-testing-for-google-assistant-apps/) - 鲁本·奥斯廷加 (Ruben Oostinga).
- [Use video loops with Interactive Canvas](https://medium.com/google-developers/use-video-loops-with-interactive-canvas-dc7503e95c6a) - 经过 [Leon Nicholls](https://twitter.com/TheLeonNicholls)

## Videos
- [What are Actions on Google](https://youtu.be/D-lhorsDlUQ) - Luke Davis 和嘉宾 Jessica Dene Early-Cha 介绍了 Actions on Google 的概念，并讨论了常用术语.
- [Smart Home Integrations on Google Assistant](https://youtu.be/cxABjSOa6RY) - Jessica Dene Early-Cha 和嘉宾 Dan Myers 讨论了如何为他们的智能设备启用 Google Assistant 以及语音命令的工作原理.
- [Pathway to creating your own Action](https://youtu.be/Jy4CsxNafeE) - Jessica Dene Earley-Cha 和嘉宾 Brad Abrams 谈论内容、应用操作和体验. 
- [Creating personality for your Actions](https://youtu.be/dh_mixqvrP0) - 在这一期的 Assistant on Air 节目中，主持人 Jessica Dene Early Cha 和嘉宾 Wally Brill 讨论了为什么使用角色进行设计很重要以及如何将其变为现实.
- [Intro to the Google Assistant: Build Your First Action (Google I/O'19)](https://youtu.be/dpNrq_wiqGs) - 此介绍会议将涵盖 Google 智能助理的基础知识以及您可以为未来的辅助构建什么.
- [Reach the Next Billion Users with Your Actions for the Google Assistant (Google I/O'19)](https://youtu.be/ak6Uj02DTjk) - 快来了解新兴市场的用户如何与 Google 智能助理互动，他们对您的 Actions 有什么期望，以及您有哪些机会与他们一起发展您的服务.
- [Smart Home 101: How to Develop for the Connected Home (Google I/O'19)](https://youtu.be/SJ2KYVKfURA) - 本次会议涵盖我们智能家居 API 的最新工具和功能的更新，以及开发人员和设备制造商等如何从与 Google Assistant 生态系统的更深入集成中受益.
- [Create App-like Experiences on Google Search and the Google Assistant (Google I/O'19)](https://youtu.be/0Hyt7gjHYO4) - 了解如何在 Google 搜索结果页面和 Google 智能助理上创建互动的、类似应用程序的体验来吸引用户.
- [Extend Your Android App to the Google Assistant (Google I/O'19)](https://youtu.be/vQALSeGy9aY) - 本课程是关于 App Actions 和 Slices 的，以了解如何让您的应用程序用户通过 Google 智能助理快速完成工作.
- [10 Best Practices for High Quality Actions (Google I/O'19)](https://youtu.be/oo5dFEW0Vk8) - 了解如何减少开发错误、提高 Action 的发现率、扩大用户群以及在构建质量和参与 Actions 的过程中避免错误.
- [Local Technologies for the Smart Home (Google I/O'19)](https://youtu.be/Y6Ue5hQ9meM) - 本次演讲将深入探讨一个新的 SDK，它使开发人员能够在本地与他们的智能设备进行通信和控制，同时提供即将推出的功能的预览.
- [Tools for Building Better Smart Home Actions (Google I/O'19)](https://youtu.be/1I-7lpZu_PA) - 本次会议将讨论帮助开发人员构建智能家居 Actions 的工具，让用户的生活更轻松.
- [Enhance Your Search and Assistant Presence with Structured Data (Google I/O'19)](https://youtu.be/GR1j2ADyGvA) - 了解如何在 Google 搜索和 Google 智能助理上展示您引人入胜的内容.
- [Build Interactive Games for the Google Assistant (Google I/O'19)](https://youtu.be/J8lsvvJ21Ok) - 了解如何为 Google 智能助理设计和开发身临其境的游戏体验.
- [Voice and Visual: How to Build Actions for Smart Displays and More Devices (Google I/O'19)](https://youtu.be/Oh4lCL05XWc) - 在本次演讲中，我们将向您介绍在支持 Google 智能助理的设备上构建多模式体验的设计和开发人员注意事项.
- [How We Built the Google Assistant Sandbox Demos (And How You Can Too) (Google I/O'19)](https://youtu.be/w2wDR8rr0Hk) 
- [Data and Insights to Build for the Digital Assistant Era (Google I/O'19)](https://youtu.be/b3nDCC2K3rY)
- [Designing Quality Conversations for the Google Assistant (Google I/O'19)](https://youtu.be/ZRjkSqVedfY) - 对话设计者和开发者将引导您设置用户期望、处理意外的用户响应，并根据用户洞察力进行改进.

## Codelabs/Courses
- [Build Actions for Google Assistant using Actions Builder (Level 1)](https://codelabs.developers.google.com/codelabs/actions-builder-1/index.html)
- [Build Actions for Google Assistant using Actions Builder (Level 2)](https://codelabs.developers.google.com/codelabs/actions-builder-2/index.html)
- [Build Actions for the Google Assistant (Level 1)](https://codelabs.developers.google.com/codelabs/actions-1/index.html)
- [Build Actions for the Google Assistant (Level 2)](https://codelabs.developers.google.com/codelabs/actions-2/index.html)
- [Build Actions for the Google Assistant (Level 3)](https://codelabs.developers.google.com/codelabs/actions-3/index.html)
- [Engage Users with your Action](https://codelabs.developers.google.com/codelabs/actions-user-engagement/index.html)
- [Extend an Android app to the Google Assistant with App Actions](https://codelabs.developers.google.com/codelabs/appactions/index.html)
- [Connect smart home devices to the Google Assistant](https://codelabs.developers.google.com/codelabs/smarthome-washer/index.html)
- [Smart Home Local Execution](https://codelabs.developers.google.com/codelabs/smarthome-local/index.html)
- [Smart Home Washer](https://codelabs.developers.google.com/codelabs/smarthome-washer/index.html)
- [Build a Conversational Action for Google Assistant](https://codelabs.developers.google.com/codelabs/actions-1)
- [Build a sophisticated Conversational Action for Google Assistant](https://codelabs.developers.google.com/codelabs/actions-2)
- [Build Interactive Apps with Google Assistant](https://www.qwiklabs.com/quests/61) - 带有 6 个实验室的 Qwiklabs 任务.
- [Google Assistant development with Actions on Google](https://www.udemy.com/course/actions-on-google-app-google-assistant/) - 在 Node.js 中为 Google Assistant 和 Google Home 创建应用程序的 Udemy 课程.
- [Build Actions for Google Assistant](https://www.udemy.com/course/buildactionsforgoogleassistant/) - 使用 Dialogflow 构建操作的 Udemy 课程.

## Podcasts
- [Assistant On Air](https://podcasts.google.com/?feed=aHR0cHM6Ly9hY3Rpb25zb25nb29nbGUubGlic3luLmNvbS9yc3M&ved=0CAAQ4aUDahcKEwiQruG2mJTnAhUAAAAAHQAAAAAQAQ) - 谷歌团队

## Open source code
- [Canvas Quiz](https://github.com/googlecreativelab/aog-canvas-quiz) - 这是一个入门工具包，供开发人员为 Google Assistant 制作定制的、支持语音的问答游戏.
- [Interactive Canvas editor](https://github.com/actions-on-google-labs/interactive-canvas-editor-nodejs)  - 为 Interactive Canvas 创建一个 web 应用程序的编辑器，它可以立即加载到智能显示设备上. 这允许为 Interactive Canvas 快速制作 Web 应用程序原型.
- [Virtual Pet](https://github.com/actions-on-google-labs/virtual-pet-game-nodejs)  - 它是用交互式画布构建的. 在此游戏中，您将像在现实生活中一样收养和照顾一只仓鼠，但通过 Google 智能助理除外.
- [Spellcast](https://github.com/actions-on-google-labs/dialogflow-spellcast-nodejs) - 用于 Google 智能助理的实验性交互式画布游戏.
- 愚蠢的名字制造者 [(Node.js)](https://github.com/actions-on-google/dialogflow-silly-name-maker-webhook-nodejs) [(Java)](https://github.com/actions-on-google/dialogflow-silly-name-maker-webhook-java) - 参数示例（使用 Dialogflow）.
- 关于谷歌的事实 [(Node.js)](https://github.com/actions-on-google/dialogflow-facts-about-google-nodejs) [(Java)](https://github.com/actions-on-google/dialogflow-silly-name-maker-webhook-java) - 自定义实体、上下文和深层链接示例（使用 Dialogflow）.
- 名字通灵 [(Node.js)](https://github.com/actions-on-google/dialogflow-name-psychic-nodejs) [(Java)](https://github.com/actions-on-google/dialogflow-name-psychic-java) - 权限和 Google Maps Static API 示例（使用 Dialogflow）.
- 数字精灵 [(Node.js)](https://github.com/actions-on-google/dialogflow-number-genie-nodejs) [(Java)](https://github.com/actions-on-google/dialogflow-number-genie-java) - Localization sample.
- [GDG Action](https://github.com/actions-on-google/dialogflow-gdg-nodejs) - 此示例演示了用于 Google Assistant 的 Actions on Google 功能，包括本地化（i18n 节点）、对话设计、丰富的响应和 API 集成.
- 说号码 [(Node.js)](https://github.com/actions-on-google/actionssdk-say-number-nodejs) [(Java)](https://github.com/actions-on-google/actionssdk-say-number-java) - 说出 Actions on Google 的一些 Actions SDK 示例.
- [Smart Home sample](https://github.com/actions-on-google/smart-home-nodejs) - Actions on Google 中的智能家居设备控制 API 示例.
- [PDPU Scheduler](https://github.com/nish17/scheduler) - 这是 PDPU 的 Google 智能助理操作，可告诉您今天有哪些课程和实验室.
- [karaoke](https://github.com/amdcaruso/karaoke) - [Amanda Cavallaro](https://github.com/amdcaruso) - 使用 GCP、YouTube API 和 Actions on Google 构建您自己的卡拉 OK 的会话应用程序.

## People to follow
- [Actions on Google](https://twitter.com/actionsongoogle) - Google 帐户上的官方操作.
- [Jessica Dene Earley-Cha](https://twitter.com/chatasweetie) - 开发者倡导者@google.
- [Joe Birch](https://twitter.com/hitherejoe)  - Android 负责人@Buffer. 用于@Android、@actionsongoogle、@FlutterIO 和@GooglePay 的 GDE. 导师@caster_io.
- [Allen "Prisoner" Firstenberg](https://twitter.com/afirstenberg) - GDE for Actions on Google.
- [Amanda (Chibi) Cavallaro](https://twitter.com/chibichibibr) - GDE for Actions on Google.
- [Aygul Zagidullina](https://twitter.com/aygul) - GDE for Actions on Google.
- [Mandy Chan](https://twitter.com/MandyChanNYC) - Actions On Google 团队的开发者倡导者.
- [Yoichiro Tanaka](https://twitter.com/yoichiro) - GDE for Actions on Google.
- [Cathy Pearl](https://twitter.com/cpearl42) - 对话设计外联负责人@Google.
- [Sachin Kumar](https://twitter.com/sachin_atk) - GDE for Actions on Google.
- [Nick Felker](https://twitter.com/handnf) - Google 的开发人员计划工程师.
- [Leon Nicholls](https://twitter.com/TheLeonNicholls) - 谷歌开发者关系工程师

## Applications
- [TuneIn](https://assistant.google.com/services/a/uid/000000c9bec03997)  - TuneIn 是您的一切音频应用程序. 拥有超过 100,000 个广播电台和 570 万个播客.
- [Random Number](https://assistant.google.com/services/a/uid/0000003b4796e827) - 它将生成一个随机数.
- [Netflix](https://assistant.google.com/services/a/uid/0000002a8e07d537) - 观看专为您推荐的电视节目和电影，包括屡获殊荣的 Netflix 原创剧集、电影和纪录片.
- [Fun Tricks](https://assistant.google.com/services/a/uid/00000038e95bb789)  - 用笑话和其他有趣的技巧来点亮你的一天. 检查一下，总有新的尝试.
- [Google Podcasts](https://assistant.google.com/services/a/uid/000000e0ea9c992f) - 通过询问您的智能助理来收听您最喜爱的播客.

## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/ravirupareliya/awesome-actions-on-google/blob/master/contributing.md) 第一的.

## License

[![CC0](https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)
