<div class="github-widget" data-repo="ibaaj/awesome-OpenSourcePhotography"></div>
## Awesome-OpenSourcePhotography
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

一系列很棒的免费开源摄影软件和库. 还有视频工具. 更多精彩，请查看 [awesome](https://github.com/sindresorhus/awesome).



## General

- [GIMP](http://www.gimp.org/) - 用于图像处理的瑞士刀.
- [PhotoFlow](https://github.com/aferrero2707/PhotoFlow) - 一个非破坏性的照片修饰程序，包括 RAW 图像显影.
- [ImageMagick](http://www.imagemagick.org/) - 一套用于修改和处理图像的命令行实用程序.
- [GraphicsMagick](http://www.graphicsmagick.org/) - GraphicsMagick 通常比 ImageMagick 快.

## Camera Firmware Mods 

- [CHDK](http://chdk.wikia.com/wiki/CHDK) - Canon Hack Development Kit，用于佳能相机. 
- [Magic Lantern](http://magiclantern.fm/) - 为佳能 DSLR 相机提供更多功能的软件增强功能.
- [Autoexec Hack](https://github.com/KonradIT/autoexechack) - 编译 GoPro 相机的技巧.
- [PTool Firmware Manipulation Tool](http://www.gh1-hack.info/) - 更改松下相机的录像参数.
- [Nikon Hacker](https://nikonhacker.com/wiki/Main_Page) - Nikon Patch 和 Nikon Emulator，2 个用于尼康相机的软件.
- [Xiaomi Yi Autoexec](https://github.com/PJanisio/Xiaomi_Yi_autoexec) - 编译小米易相机的自动执行脚本和模组.

## Libraries

- [LibGphoto2](https://github.com/gphoto/libgphoto2) - C APi for Digital camera access and remote control. Java,python,C#, and much more bindings.

### Canon

- [OfxCanon](https://github.com/roxlu/ofxCanon) - 佳能 EDSK 的 OpenFrameworks 插件.
- [Edsdk4j](https://github.com/kritzikratzi/edsdk4j) - 适用于 Java 的佳能 SDK.

### GoPro
- [GoPro](https://github.com/kschzt/gopro) - 用于从 Node.js 控制 GoPro Hero 3 相机的 API.
- [GoPro](https://github.com/DenisCarriere/gopro) - GoPro Hero 4 - Python API.
- [GoPro](https://github.com/joshvillbrandt/goprohero) - 一个 Python 库和一个 CLI，可以通过 http 连接 GoPro HERO3、HERO3+ 和 HERO4 相机.
- [GoPro.Hero](https://github.com/r1pper/GoPro.Hero) - A lightweight c# library to access and control GoPro HERO.

### Sony

- [SonyPy](https://github.com/storborg/sonypy) - 用于 Sony Camera Remote API 的 Python 模块.

## Utilities

- [Timelapse-sony](https://github.com/ThibaudM/timelapse-sony) - 用于通过“使用智能手机控制”模式或通过 NFC 连接创建游戏中时光倒流的 Android 应用程序.
- [Remoteyourcam-usb](https://github.com/crazymaik/remoteyourcam-usb) - 通过 USB 从您的 Android 设备控制您的佳能或尼康 DSLR 相机.
- [digiCamControl](https://github.com/dukus/digiCamControl) - 数码单反相机远程控制开源软件.

## Analogue photography

- [Digitaltruth](https://www.digitaltruth.com/devchart.php) - 电影发展图.

## RAW image developers

- [Darktable](http://www.darktable.org/) - 开源摄影工作流程应用程序和 RAW 开发人员.
- [RawTherapee](http://rawtherapee.com/) - 一个跨平台的原始图像处理程序.
- [Photivo](http://photivo.org/photivo/start?redirect=1) - 用于 16 位精度的 RAW 和位图图像的多平台照片处理器.
- [Raw Studio](https://github.com/rawstudio/rawstudio) - 读取和处理来自数码相机的 RAW 图像.
- [UFRaw](http://ufraw.sourceforge.net/) - 从数码相机读取和处理原始图像的实用程序.
- [DCRaw](http://www.cybercom.net/~dcoffin/dcraw/) - 在 Linux 中解码原始数码照片.
- [Lightzone](http://lightzoneproject.org/) - 适用于 Windows/Mac/Linux 的开源数字暗房软件.
- [Fotoxx](http://www.kornelix.com/fotoxx.html) - 用于编辑照片和其他图像的 Linux 程序.

## HDR Specific Software
- [Luminance](https://github.com/LuminanceHDR/LuminanceHDR) - 完整的 HDR 成像工作流程.
- [QPSFTMO](http://theplaceofdeadroads.blogspot.com/2006/07/qpfstmo-hdr-tone-mapping-gui-for-linux_04.html) - 适用于 Linux 的 HDR 色调映射 GUI.
- [PFS Tools](http://pfstools.sourceforge.net/) - 一组用于读取、写入和操作 HDR 图像和视频帧的命令行程序.

## Panorama Stitching

- [Hugin](http://hugin.sourceforge.net/) - 易于使用的跨平台全景成像工具链.
- [Panorama Tools](http://www.panoramatools.com/) - 用于将多个源图像重新投影和混合为多种类型的沉浸式全景的框架.

## Photo Organizers

- [Shotwell](http://yorba.org/shotwell/) - GNOME 3 的照片管理器.
- [DigiKam/ShowFoto](http://www.digikam.org/drupal/about?q=about/overview) - KDE/Gnome 桌面的开源照片管理器.
- [GPhoto](http://www.gphoto.org/) - 一个程序和库框架，允许用户从他们的数码相机下载图片.
- [Lychee](http://lychee.electerious.com/) - 一个漂亮且易于使用的照片管理系统，您可以在您的服务器上运行，以管理和共享照片.
- [Simple Gallery](https://github.com/SimpleMobileTools/Simple-Gallery/) - 一个用于查看照片和视频的 Android 图库应用程序，类似于 android stock gallery，支持文件复制/移动/重命名/删除/共享.
- [Leaf Pic](https://github.com/HoraApps/LeafPic/) - 材料设计的安卓画廊替代品.
- [A Photo Manager](https://github.com/k3b/APhotoManager/) - 在 Android 上管理本地照片：图库、使用照片地图进行地理标记、标记、查找、排序、查看、复制、删除、发送...
- [PhotoPrism](https://photoprism.org/) - PhotoPrism™ 是一个基于服务器的应用程序，用于浏览、组织和共享您的个人照片集.

## EXIF Editors
- [ExifTool](http://owl.phy.queensu.ca/~phil/exiftool/) - 用于读取、写入和操作图像、音频和视频元数据的程序.
- [Exiv2](https://github.com/Exiv2/exiv2/)  - Exiv2 是一个 C++ 库和命令行实用程序，用于读取、写入、删除和修改 Exif、IPTC、XMP 和 ICC 图像元数据.

## Photo Downloaders

- [Rapid Photo Downloader](http://www.damonlynch.net/rapid/index.html) - 用于 Linux 桌面的照片和视频下载器.

## Camera Tetherers

- [Entangle](http://entangle-photo.org/) - Entangle 提供了一个 GUI，用于使用完全由计算机控制的数码相机拍照.

## Monitor Color Correction

- [Hughski](http://www.hughski.com/index.html)
- [DisplayCal](http://displaycal.net/) - 开源显示校准和表征.

## 360° Images

- [Open360viewer](https://github.com/TheGreyDiamond/open360viewer) - 开源 360° 媒体查看器.


## Alternative Image Viewers

- [Geeqie](http://geeqie.sourceforge.net/) - 用于类 Unix 操作系统的图像查看器和图像管理器程序.
- [FEH](http://feh.finalrewind.org/) - X11 图像查看器.

## Useful GIMP Mods or Scripts

- [GIMP Plugin Registry](http://registry.gimp.org/)
- [Cinepaint](http://sourceforge.net/projects/cinepaint/files/CinePaint/) - 基于 GIMP 的电影位图帧绘制和修饰程序.

## Communities
- [Flickr Open Source Photography Group](https://www.flickr.com/groups/83823859@N00/)
- [/r/FOSSPhotography](http://reddit.com/r/fossphotography) - 关于 reddit 上摄影的免费​​开源软件的社区.
- [Open Source Photography Community on Google+](https://plus.google.com/u/0/communities/110647644928874455108)
- [Open Source Photography Group on Facebook](https://www.facebook.com/groups/326042310770868/)
- [Open Source Photography Sub on Reddit](https://www.reddit.com/r/opensourcephotography)
- [Open Source Photography Group on 500px](https://500px.com/groups/open-source-photography)
- [PIXLS.US](https://pixls.us) - 致力于使用免费软件工具进行高质量摄影教程、工作流程和展示的社区

## Resources
- [Unsplash.com](https://unsplash.com/) - 免费（随心所欲）高分辨率照片， [licensed](https://medium.com/unsplash/the-unsplash-license-f6fb7de5c95a) 根据 Unsplash 许可证（[changed from CC0](https://medium.com/unsplash/why-we-moved-from-the-creative-commons-zero-license-to-the-unsplash-license-598f76386489))
- [Pexels.com](https://pexels.com/) - 免版税高分辨率库存照片， [licensed](https://www.pexels.com/photo-license/) 根据知识共享零 (CC0)
- [Pixabay.com](https://pixabay.com/) - 免版税库存照片和视频， [licensed](https://pixabay.com/en/service/faq/) 根据知识共享零 (CC0).
- [Shutterography.com](https://www.shutterography.com) - 免费照片.

## Video 

### General tools

- [FFmpeg](https://www.ffmpeg.org/) - 一个完整的跨平台解决方案 
记录、转换和传输音频和视频.
- [Virtualdub](http://www.virtualdub.org/) - 用于基本编辑和编码的免费视频工具.

### Compositing software

- [Natron](https://github.com/MrKepzie/Natron) - 基于节点的合成器基于与电影和电视后期制作中使用的最先进工具相同的原理.
- [ButtleOFX](https://github.com/buttleofx/ButtleOFX) - 一个简单、用户友好的开源合成软件. 
- [Blender](https://www.blender.org/) - 此开源 3D 图形具有用于视频编辑的工具.
- [Shotcut](https://github.com/mltframework/shotcut) - 免费、开源、跨平台的视频编辑器.

### Video Libraries

- [OpenFX](http://openfx.sourceforge.net/) - 用于 2D 视觉效果的开放式插件 API.
- [TuttleOFX](https://github.com/tuttleofx/TuttleOFX) - 基于 OpenFX 插件格式的图像处理框架.
- [Vid.stab](https://github.com/georgmartius/vid.stab) - 可以插入 Ffmpeg 和 Transcode 的视频稳定库.
- [Frei0r](https://github.com/dyne/frei0r) - 大量免费和便携式视频插件.

## Scripts

### Video to Panorama 

Using [FFmpeg](https://www.ffmpeg.org/) 和 [Hugin](http://hugin.sourceforge.net/).

```bash
#!/bin/bash
mkdir -p /tmp/图像
ffmpeg -i video.avi -r 5 -qscale 3 tmp/images/image-%3d.jpg
pto_gen -o tmp/hugin.pto tmp/images/*.jpg
cpfind --multirow -o tmp/hugin.pto tmp/hugin.pto
cpclean -o tmp/hugin.pto tmp/hugin.pto
linefind -o tmp/hugin.pto tmp/hugin.pto 文件
autooptimiser -a -l -s -m -o tmp/hugin.pto tmp/hugin.pto
pano_modify -o tmp/hugin.pto --center --fov=AUTO --canvas=70% tmp/hugin.pto
pto2mk -o tmp/hugin.mk -p tmp/输出 tmp/hugin.pto
make -f tmp/hugin.mk 全部
```

![license](https://i.creativecommons.org/l/by-nc/4.0/88x31.png)
