<div class="github-widget" data-repo="J2TeaM/awesome-AutoIt"></div>
## Awesome AutoIt

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Build Status](https://travis-ci.org/J2TeaM/awesome-AutoIt.svg)](https://travis-ci.org/J2TeaM/awesome-AutoIt)
[![Creator](https://img.shields.io/badge/Creator-Juno__okyo-blue.svg)](https://junookyo.blogspot.com/)
[![Twitter Follow](https://img.shields.io/twitter/follow/juno_okyo.svg?label=Follow&maxAge=2592000)](https://twitter.com/juno_okyo)

&gt; 很棒的 UDF、示例脚本、工具和有用资源的精选列表 [AutoIt](https://www.autoitscript.com/).

由...制作 [Juno_okyo](https://twitter.com/juno_okyo) . 灵感来自 [awesome](https://github.com/sindresorhus/awesome) 列出事情.


<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->



<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## UDF/Libraries

**图书馆清单[user defined functions](https://en.wikipedia.org/wiki/User-defined_function) ** (UDF). 这些库的编写目的是为了方便地集成到您自己的脚本中，对任何程序员来说都是非常宝贵的资源.

### Automation

- [Active Directory (by water)](https://www.autoitscript.com/forum/index.php?showtopic=106163)  - 用于控制和操作 Windows 活动目录的广泛库. 链接到文档页面.
- [GTK+ (by prazetto)](https://www.autoitscript.com/forum/index.php?showtopic=150231)  - GTK+ 框架 | 小部件.
- [IUIAutomation MS framework (by junkew)](https://www.autoitscript.com/forum/index.php?showtopic=153520) - IUIAutomation MS 框架，用于自动化 chrome、FF、IE 等.
- [Java (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=87956)  - 在您的应用程序和 Java 应用程序之间创建访问桥梁. 允许您自动化一些 Java 应用程序.
- [SAP (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=86574) - SAP 业务管理自动化.
- [SAPWizard (by ozmike)](https://www.autoitscript.com/forum/index.php?showtopic=149540) - SAPWizard UDF.
- [Service (by arcker)](https://www.autoitscript.com/forum/index.php?showtopic=80201) - 使用 AutoIt 代码构建您自己的服务.
- [WiFi (by MattyD)](https://www.autoitscript.com/forum/index.php?showtopic=91018) - 对无线局域网的低级控制.
- [AutoItMonkey](https://github.com/ohtejera/AutoItMonkey) - AutoItMonkey 是一个 UDF，它在您的 Android 模拟器或设备上运行，并生成用户事件的伪随机流，例如点击、触摸或手势，以及许多系统级事件.
- [ImperiusAutoIt](https://ohtejera.github.io/ImperiusAutoIt/) - Imperius AutoIt 是一个 [ImperiusGeorge](https://github.com/lookout/ImperiusGeorge) 支持原生 Android 应用程序的移动测试自动化客户端.
- [3270 (by Worlor)](https://github.com/Worlor/AutoIt-3270) - 使用 AutoIT 自动化 3270 终端的库

#### Browsers

- [Chrome (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=154439)  - 与上述 Google Chrome 浏览器相同. 使用 Chrome UDF 自动执行 Chrome 中最常见的任务.
- [Firefox (by Stilgar)](https://www.autoitscript.com/forum/index.php?showtopic=95595) - 对自动化的支持比 IE 少一点，但仍然非常好.
- [FireFox Profile Backup 1.0 (by careca)](https://www.autoitscript.com/forum/files/file/224-firefox-profile-backup/) - 备份或恢复您的 firefox 配置文件，应用程序在主驱动器中搜索配置文件，这将是要备份的配置文件.
- [_FF_AutoLogin (by Stilgar)](https://www.autoitscript.com/forum/index.php?showtopic=124330) - 这是 FireFox 和 FF.au3 的自动登录功能和登录功能生成器.
- [_FF_DM (by Stilgar)](https://www.autoitscript.com/forum/index.php?showtopic=92035) - UDF 控制 FireFox 下载管理器（不是下载窗口）.
- [_FF_FoxBox (by Stilgar)](https://www.autoitscript.com/forum/index.php?showtopic=91650) - 使用 FF.au3 控制 Fox!Box（AVM FRITZ!Box 的 Mozilla Firefox 扩展）的 UDF.
- [_FF_Screengrab (by Stilgar)](https://www.autoitscript.com/forum/index.php?showtopic=91665) - UDF to control Screengrab! (FireFox-AddOn) with FF.au3.
- [_HTML (by Stilgar)](https://www.autoitscript.com/forum/topic/124330-_htmlau3-v101/) - 从任何 HTML (XML) 源获取信息，无需任何浏览器.
- [HTMLDocumentEvents (by SmOke_N)](https://www.autoitscript.com/forum/index.php?showtopic=166542) - 跟踪 IE 文档事件.
- [IEEx (by SmOke_N)](https://www.autoitscript.com/forum/index.php?showtopic=167035) - 带有一些 Javascript 选项的 IE 扩展库.
- [NavInfo (by Nessie)](https://www.autoitscript.com/forum/index.php?showtopic=149203) - 使用此 UDF，您可以检查是否安装了指定的浏览器/软件以及正在使用哪个版本.
- [Opera (by MrCreatoR)](https://www.autoitscript.com/forum/index.php?showtopic=61090)  - 与上面的 Opera 相同. 使用 Opera UDF 自动执行 Opera 中最常见的任务.

#### Microsoft Office

- [Microsoft Office Access (by randallc)](https://www.autoitscript.com/forum/index.php?showtopic=32144) - 自动化 Microsoft Access.
 - Microsoft Office Excel（由 water 等人提供） - 此 UDF 包含在 AutoIt 中. 链接到 [documentation](https://www.autoitscript.com/wiki/Excel_UDF) 页.
- [Microsoft Office Excel Charts (by water, GreenCan)](https://www.autoitscript.com/forum/index.php?showtopic=135312) - 使用 Microsoft Excel 创建图表.
- [Microsoft Office Outlook (by water)](https://www.autoitscript.com/forum/index.php?showtopic=126305)  - 自动化 Microsoft Outlook. 链接到 [documentation](https://www.autoitscript.com/wiki/OutlookEX_UDF_-_General) 页.
- [Microsoft Office PowerPoint (by Toady)](https://www.autoitscript.com/forum/index.php?showtopic=50254) - 自动化 Microsoft PowerPoint.
 - Microsoft Office Word（由 water 等人提供） - 此 UDF 包含在 AutoIt 中. 链接到 [documentation](https://www.autoitscript.com/wiki/Word_UDF) 页.

#### OpenOffice

- [OOo/LibO Calc (by GMK)](https://www.autoitscript.com/forum/index.php?showtopic=151530) - OpenOfficeCalc UDF.

### Databases and web connections

- [ADODB (by spudw2k)](https://www.autoitscript.com/forum/index.php?showtopic=105875) - ADODB 示例.
- [DBF (by funkey)](https://www.autoitscript.com/forum/index.php?showtopic=145142) - 使用 DLL 读写 dBase 数据库.
- [EzMySql (by oriz)](https://www.autoitscript.com/forum/index.php?showtopic=116072) - EzMySql - 将 MySql 数据库与 autoit 一起使用.
- [FireBird (by eltorro)](https://www.autoitscript.com/forum/topic/94920-solved-passing-parameters-using-dllcall-to-a-c-dll/?do=findComment&comment=684751) - FireBird，Interbase dll udf.
- [MS SQL (by TheLuBu)](https://www.autoitscript.com/forum/index.php?showtopic=127101) - MSSQL.au3.
- [MS SQL (by ChrisL)](https://www.autoitscript.com/forum/index.php?showtopic=51952)  - _SQL.au3.  ADODB 连接.
- [MySQL (by cdkid)](https://www.autoitscript.com/forum/index.php?showtopic=20814) - MySQL关系数据库管理系统UDF.
- [MySQL (by ProgAndy)](https://www.autoitscript.com/forum/index.php?showtopic=85617) - MySQL UDF（无 ODBC）.
- [MySQL (by James)](https://www.autoitscript.com/forum/topic/122360-mysql-odbc-connector-udf) - MySQL ODBC 连接器.
- [SQLite (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=17099) - SQLite 是一个实现自包含、可嵌入、零配置 SQL 数据库引擎的库.
- [SQLite Array Functions (by SmOke_N)](https://www.autoitscript.com/forum/index.php?showtopic=142977) - SQLite 数组函数 - 一种用于独特数组和排序方法的更快方法.
- [XML DOM Wrapper (by eltorro)](https://www.autoitscript.com/forum/index.php?showtopic=19848)  - 支持对 XML 的 CRUD 操作. 包括 XSL 和 XPath.
- [AutoIt PHP MySQL (by J2TeaM)](https://www.autoitscript.com/forum/topic/173984-the-combination-of-autoit-php-and-mysql/) - AutoIt、PHP 和 MySQL 的组合.

### Data compression

- [7z, zip, gzip, bzip2, tar (by rasim)](https://www.autoitscript.com/forum/index.php?showtopic=85094) - 使用脚本必须提供的外部 DLL 的扩展库.
- [LZMA (by trancexx)](https://www.autoitscript.com/forum/index.php?showtopic=87441) - LZMA（本机 Windows）.
- [LZMA Compression (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=112273) - LZMA 压缩 UDF.
- [MessagePack (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=166634)  - MessagePack 是一种高效的二进制序列化格式. 它允许您在多种语言（如 JSON）之间交换数据. 但是速度更快，体积更小.
- [Package (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=138838) - 包 UDF.
- [pZip (by asdf8)](https://www.autoitscript.com/forum/index.php?showtopic=129529) - PureZIP_L 库 UDF.
- [UnRAR (by rasim)](https://www.autoitscript.com/forum/index.php?showtopic=76176) - UnRAR.au3.
- [Zip plugin (by eltorro)](https://www.autoitscript.com/forum/index.php?showtopic=44524) - 压缩插件.
- [ZIP (by torels)](https://www.autoitscript.com/forum/index.php?showtopic=73425) - 纯 AutoIt 中的 ZIP.au3 UDF.
- [zip (by wraithdu)](https://www.autoitscript.com/forum/index.php?showtopic=116565) - 创建 ZIP 文件并解压缩 ZIP 文件.
- [ZIP (by joakim)](https://www.autoitscript.com/forum/index.php?showtopic=135565) - ZIP STRUCTS UDF（从头开始）.
- [zLib (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=128962) - zLib（放气/膨胀/GZIP）UDF.
- [XZip (by eltorro)](https://www.autoitscript.com/forum/index.php?showtopic=17727) - “XStandard XZIP 组件”的另一个 UDF.
- [XZip (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=161847) - “XStandard XZIP 组件”的 UDF.

### Encryption and hash

- [AES Rijndael (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=78745)  - 非常快的 AES UDF. 支持ECB/CBC/CFB/OFB分组密码模式.
- [MD5,SHA1,CRC32,RC4,BASE64,XXTEA (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=76976) - 几个加密和散列函数.
- [TrueCrypt (by FuryCell)](https://www.autoitscript.com/forum/index.php?showtopic=107784) - TrueCrypt UDF.

### GUI Additions

- [3D Pie chart (by WideBoyDixon)](https://www.autoitscript.com/forum/index.php?showtopic=97241) - 3D饼图.  
- [Chart_UDF (by Kanashius)](https://www.autoitscript.com/forum/index.php?showtopic=173924) - 此 UDF 可用于在窗口中显示条形图.）.  
- [ContextHelp.au3 (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=96258) - 上下文帮助的管理（[original](https://www.autoitscript.com/forum/index.php?showtopic=72152-contexthelp/)).  
- [Easy Scrollbars (by Melba23)](https://www.autoitscript.com/forum/index.php?showtopic=113723) - 在您的 GUI 中轻松创建可滚动的部分.  
- [ExtMsgBox (by Melba23)](https://www.autoitscript.com/forum/index.php?showtopic=109096) - 一个非常可定制的 MsgBox 替代品.  
- [GUICtrlOnChangeRegister (by Mat)](https://www.autoitscript.com/forum/index.php?showtopic=105582) - 更改编辑内容时调用函数.  
- [GUIExtender (by Melba23)](https://www.autoitscript.com/forum/index.php?showtopic=145149) - 扩展和收缩 GUI 的部分（[original](https://www.autoitscript.com/forum/index.php?showtopic=117909)).  
- [GUIFrame (by Melba23 & Kip)](https://www.autoitscript.com/forum/index.php?showtopic=119505) - Divide a GUI into adjustable frames.  
- [GUI Panel (by FireFox)](https://www.autoitscript.com/forum/index.php?showtopic=144207) - 将子 GUI 作为面板控件进行管理.  
- [Modern tray menu (by Holger)](https://www.autoitscript.com/forum/index.php?showtopic=20967) - 允许创建带有图标和颜色的现代、精美的 GUI 和托盘菜单.  
- [Pie chart (by Andreik)](https://www.autoitscript.com/forum/index.php?showtopic=161750) - 饼形图.  
- [SetOnEvent (by martin)](https://www.autoitscript.com/forum/index.php?showtopic=71811) - 为事件提供一种简单的方法来调用带参数的函数.  
- [Uskin (by JScript)](https://www.autoitscript.com/forum/index.php?showtopic=132864) - 允许用户使用 Windows _.MSstyles_ 文件为其应用程序 GUI 设置皮肤的库.  
- [Toast (by Melba23)](https://www.autoitscript.com/forum/index.php?showtopic=108445) - 从系统托盘弹出的小消息 GUI.  
- [XSkin (by Valuater)](https://www.autoitscript.com/forum/index.php?showtopic=32494) - 一个大型库，允许为您的 GUI 换肤并应用自定义皮肤.  
- [Real Vista Aero Glass (by James)](https://www.autoitscript.com/forum/index.php?showtopic=75429) - Real Vista Aero Glass UDF - 您可以将玻璃效果应用于您的图形用户界面.

### Controls

- [Calendar (by jmon)](https://www.autoitscript.com/forum/index.php?showtopic=146406) - 日历 UDF.
- [Colorpicker (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=96464) - 创建一个按钮供用户选择颜色.
- [GDIPlus Slider UDF (by Kanashius)](https://www.autoitscript.com/forum/index.php?showtopic=173929) - 此 UDF 可用于创建带有图像背景和要移动的图像的滑块.
- [Graph control (by andybiochem)](https://www.autoitscript.com/forum/index.php?showtopic=79412) - 轻松创建和显示条形图和折线图.
- [GraphGDIPlus UDF (by andybiochem)](https://www.autoitscript.com/forum/index.php?showtopic=104399) - 使用 GDI+ 轻松创建和显示条形图和折线图以利用双缓冲.
- [GUICtrlCreateFinder (by Mat)](https://www.autoitscript.com/forum/index.php?showtopic=105682) - 允许您创建一个窗口查找器控件，就像在 AutoIt 窗口信息中看到的那样.
- [GUITreeViewEx (by Melba23)](https://www.autoitscript.com/forum/index.php?showtopic=166594) - 检查/清除 TreeView 中的父项和子项复选框.
- [GUIHotkey (by Mat)](https://www.autoitscript.com/forum/index.php?showtopic=107965) - 使用本机热键控件的 UDF.
- [GUIPager (by Mat)](https://www.autoitscript.com/forum/index.php?showtopic=111438) - 创建和控制本机寻呼机控件.
- [Hotkey input control (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=90598) - 热键输入控制 UDF 库（非本地）.
- [ListView Edit UDF (by Kanashius)](https://www.autoitscript.com/forum/index.php?showtopic=173932) - 此 UDF 可用于简单地编辑列表视图.
- [Marquees (by Melba23)](https://www.autoitscript.com/forum/index.php?showtopic=143711) - 制作纸条信息栏.
- [Progressbar with GDIplus (by ProgAndy)](https://www.autoitscript.com/forum/index.php?showtopic=74649) - 您甚至可以使用全纹理图像.
- [Ribbon (by trancexx)](https://www.autoitscript.com/forum/index.php?showtopic=128242) - Windows 功能区框架的 UDF.
- [Syslink (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=126958) - 提供了一种在窗口中嵌入超文本链接的便捷方式.
- [Table (by andybiochem)](https://www.autoitscript.com/forum/index.php?showtopic=105814) - 表 UDF.

### Hardware

- [CommAPI](https://github.com/J2TeaM/awesome-AutoIt/blob/master//wiki/CommAPI "CommAPI") （由 therealhanuta 提供）- 串行和并行通信（COM 端口、RS-232、LPT 端口）- 无需安装 DLL（使用 Windows API 调用）.
- [Device Management (by weaponx)](https://www.autoitscript.com/forum/index.php?showtopic=77731) - 设备管理 API.
- [DirectShow (by monoceres)](https://www.autoitscript.com/forum/index.php?showtopic=97487) - DirectShow UDF.
- [DirectSound (by eukalyptus)](https://www.autoitscript.com/forum/index.php?showtopic=164700) - DirectSound UDF.
- [Direct2D (by eukalyptus)](https://www.autoitscript.com/forum/index.php?showtopic=164701) - Direct2D UDF.
- [FritzBox (by Allow2010)](https://www.autoitscript.com/forum/index.php?showtopic=138989) - _FB_Tools - 从 Autoit 管理您的 FritzBox.
- [I/O Port Functions (by Ascend4nt)](https://www.autoitscript.com/forum/index.php?showtopic=121084) - 用于与端口交互的输入/输出 UDF（x64 并行端口、键盘等）.
- [Monitor Configuration (by jaberwacky)](https://www.autoitscript.com/forum/index.php?showtopic=154350) - 监控配置 UDF.
- [Mouse (by AlmarM)](https://www.autoitscript.com/forum/index.php?showtopic=155469) - AutoIt 供电的鼠标事件.
- [MouseTrapEvent (by ozmike)](https://www.autoitscript.com/forum/index.php?showtopic=147325) - MouseTrapEvent UDF.
- [NetInfo (by Nessie)](https://www.autoitscript.com/forum/index.php?showtopic=149083) - 用于测试互联网下载速度和上传速度的 UDF.
- [Network configuration (by jguinch)](https://www.autoitscript.com/forum/index.php?showtopic=155539) - 网络配置 UDF.
- [Serial Port/COM (by martin)](https://www.autoitscript.com/forum/index.php?showtopic=128546) - 串行端口/COM 端口 UDF.
- [SMARTDRIVE (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=27755) - 智能驱动分析.
- [SPI Hardware Interface (by Blinky)](https://www.autoitscript.com/forum/topic/158640-spi-hardware-interface) - 通过LPT（打印机）端口使用SPI协议与MAX335芯片通信.
- [Webcam (by LIMITER)](https://www.autoitscript.com/forum/index.php?showtopic=68866) - 网络摄像头 UDF.
- [Webcam (by ludocus)](https://www.autoitscript.com/forum/index.php?showtopic=70857) - 网络摄像头 UDF.

### Information gathering

- [Computer information (by JSThePatriot)](https://www.autoitscript.com/forum/index.php?showtopic=29404) - 一个通用库，用于获取有关 Windows 机器的各种详细信息.
- [WinPcap (by JRSmile)](https://www.autoitscript.com/forum/index.php?showtopic=54039) - Windows 数据包捕获库 WinPcap 的包装器.
- [WinPcap (by Nicolas Ricquemaque)](http://opensource.grisambre.net/pcapau3/) - 用于访问 WinPcap 驱动程序提供的主要功能的库.

### Internet protocol suite

- [cURL (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=137456) - 用于使用 URL 语法传输数据的 UDF.
- [cURL (by Ward)](https://www.autoitscript.com/forum/topic/173067-curl-udf-autoit-binary-code-version-of-libcurl-with-ssl-support/) - 支持 SSL 的 libcurl 的 AutoIt 二进制代码版本.
- [IMAP (by mikeytown2)](https://www.autoitscript.com/forum/index.php?showtopic=40243) -IMAP.
- [IMAP4 (by Tipulatoid)](https://www.autoitscript.com/forum/index.php?showtopic=108422) - IMAP4 UDF.
- [IRC (by McGod)](https://www.autoitscript.com/forum/index.php?showtopic=43515) - 用于与 IRC 服务器通信的轻量级库.
- [IRC (by rcmaehl)](https://www.autoitscript.com/forum/index.php?showtopic=159285) - IRC UDF - Chips 的 IRC UDF 的更新版本.
- [IRC (by TheDcoder)](https://www.autoitscript.com/forum/topic/181940-thedcoders-irc-udf-full-compliance-with-rfc-2812-and-ircv31/) - 完全符合 RFC 2812 和 IRCv3.1，功能丰富，支持 SASL 身份验证.
- [JSON (by Gabriel13)](https://www.autoitscript.com/forum/index.php?showtopic=104150) - 符合 RFC4627 的 JSON 编码/解码.
- [JSON (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=148114) - JSMN - 一个非严格的 JSON UDF.
- [JSON (by ozmike)](https://www.autoitscript.com/forum/index.php?showtopic=156794) - 桥接到本机 Windows JSON 加上 AutoIt 的 OO 扩展.
- [JSONgen: JSON generator (by Jefrey)](https://www.autoitscript.com/forum/index.php?showtopic=173797) - UDF 生成 JSON.
- [POP3 (by Apzo)](https://www.autoitscript.com/forum/index.php?showtopic=22838)  - 用于检索电子邮件的 POP3 库. 与 Gmail 不兼容，因为它使用 SSL.
- [_POP3_Ex (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=167339) - POP3 UDF 根据 1939 RFC，带有引用可打印解码器的修改版本.
- [POP3 SSL (by Fox2)](https://www.autoitscript.com/forum/index.php?showtopic=64051)  - 与 Gmail 兼容的 POP3 库. 它使用必须随脚本一起提供的外部可执行文件.
- [Prowl (by mrflibblehat)](https://www.autoitscript.com/forum/index.php?showtopic=154530) - 使用 Prowl（适用于 iOS 的 Growl 客户端）将通知推送到 iPhone、iPod touch 或 iPad.
- [Request (by Ward)](https://www.autoitscript.com/forum/topic/173129-request-udf-the-simplest-way-to-make-http-request) - 功能强大且易于使用的 AutoIt HTTP 客户端，基于 Curl.au3 和 Json.au3.
- [SFTP (by Lupo73)](https://www.autoitscript.com/forum/index.php?showtopic=138095) - UDF 支持使用 PSFTP 的 SFTP 协议.
- [SMTP (by Jos)](https://www.autoitscript.com/forum/index.php?showtopic=23860) - 支持 Html 和附件的 Smtp 邮件程序.
- [SNMP (by enaiman)](https://www.autoitscript.com/forum/index.php?showtopic=81687) - SNMPv1 和 SNMPv2c 的 SNMP_UDF.
- [SNMP - MIB protocol (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=70759) - 使用 WMI 从 SNMP 设备读取碳粉状态.
- [SSH (by jeanphile)](https://www.autoitscript.com/forum/index.php?showtopic=166579) - 在您的代码中非常轻松地使用 SSH 协议.
- [TCPServer (by Jefrey)](https://www.autoitscript.com/forum/index.php?showtopic=169774) - 多客户端，基于事件，能够将控制台应用程序绑定到套接字.
- [UPnP Protocol (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=57022) - UPnP - 读取和控制您的设备.
- [WinHTTP (by trancexx)](https://www.autoitscript.com/forum/index.php?showtopic=84133) - 访问 HTTP 协议以创建 GET 和 POST 请求并以符合标准的方式提交它们，不支持 cookie.
- [WinInet (by -Ultima-)](https://www.autoitscript.com/forum/index.php?showtopic=77503)  - 访问标准互联网协议（FTP、Gopher 和 HTTP）. 支持 GET/POST 请求和 cookie.

### Maths

- [Advanced Math UDF (by scintilla4evr)](https://www.autoitscript.com/forum/index.php?showtopic=170658)  - 这是一个充满高级数学函数的 UDF. 它允许使用素数、创建数字序列、插值、计算黎曼 zeta 等函数的值.
- [Advanced rounding (by Mat)](https://www.autoitscript.com/forum/index.php?showtopic=102686) - 支持不同的准确度测量和 8 种解决平局的方法.
- [Big number (by eukalyptus)](https://www.autoitscript.com/forum/index.php?showtopic=83529) - 使用 AutoIt 通常无法支持的非常大的数字进行计算.
- [Decimal To fraction (by Malkey)](https://www.autoitscript.com/forum/index.php?showtopic=106551)  - 将任何十进制数转换为分数. 示例：1.2 至 6/5.
- [Number base conversion (by james3mg)](https://www.autoitscript.com/forum/index.php?showtopic=81189) - 小于 63（支持小数）的正基数从、到和之间.
- [NumToWord (by Mat)](https://www.autoitscript.com/forum/index.php?showtopic=117156) - 将数字转换为人类可读的字符串.
- [Polynomials (by Mat)](https://www.autoitscript.com/forum/index.php?showtopic=108803) - 使用多项式的函数.
- [Primes (by jennico)](https://www.autoitscript.com/forum/index.php?showtopic=83091) - 许多处理质数生成和计算的函数.
- [Roman Numerals (by AZJIO)](https://www.autoitscript.com/forum/topic/94770-integer-to-roman-numerals/#entry1043544) - 罗马数字.
- [Root function (by Mat)](https://www.autoitscript.com/forum/index.php?showtopic=98160) - 计算出数字的实根.
- [StringAPL (by minx)](https://www.autoitscript.com/forum/index.php?showtopic=163899) - 内联 APL 解释器.
- [Trigonometry math functions (by trancexx)](https://www.autoitscript.com/forum/index.php?showtopic=82722) - _ATan2()、_Cosh()、_Frexp()、_Hypot()、_Ldexp()、_Logb()、_Sinh()、_Tanh().

### Media

- [FreeImage library (by ProgAndy)](https://www.autoitscript.com/forum/index.php?showtopic=95357) - 对图像的各种操作，例如旋转、调整大小、翻转.
- [HtmlHelp (by Geodetic)](https://www.autoitscript.com/forum/index.php?showtopic=127263) - HTMLHelp UDF.
- [OCR (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=50608) - AU3 中的真实 OCR - 带有 MS Office 2003 的 MODI.
- [OCR (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=89542) - Tesseract（屏幕 OCR）UDF.
- [OCR (by KabueMurage)](https://www.autoitscript.com/forum/topic/206133-ocrspace-udf) - [OCRSpace API](https://ocr.space/) 客户端 UDF.
- [Printer controller (by martin)](https://www.autoitscript.com/forum/index.php?showtopic=51054) - 在页面上的任何位置以任何字体、大小和颜色打印文本，以任何颜色绘制直线、曲线、椭圆、饼图，并打印图像.
- [Printing (by GRS)](https://www.autoitscript.com/forum/index.php?showtopic=73993) - 从 AutoIt 打印.
- [RTF_Printer (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=161831) - RTF_Printer.au3 - 在后台打印 RichEdit.
- [Simple DirectMedia Layer (by AdmiralClaws)](https://www.autoitscript.com/forum/index.php?showtopic=94834)  - 添加对游戏杆、CD、2D 图形、计时器的支持. 看 [SDL website](http://www.libsdl.org/) 了解更多信息.

### Graphics and image

- [Bitmap Library (by evilertoaster)](https://www.autoitscript.com/forum/index.php?showtopic=27362) - 位图库.
- [IrrLicht (by A. Percy)](https://www.autoitscript.com/forum/index.php?showtopic=70506) - 适合创建游戏的 3D 图形引擎.
- [au3Irrlicht2 (by JRowe)](https://www.autoitscript.com/forum/index.php?showtopic=113881)  - 另一个将 Irrlicht 和 au3 结合在一起的 UDF. 从历史上看，它是上述 UDF 的某种追随者，在技术上采用了完全不同的方法.
- [ImageGetInfo (by Lazycat)](https://www.autoitscript.com/forum/index.php?showtopic=13096) - 这是一个 UDF，用于从 JPEG、TIFF、BMP、PNG 和 GIF 中读取信息 - 大小、颜色深度、分辨率.
- [OpenGL (by LarsJ)](https://www.autoitscript.com/forum/index.php?showtopic=151011) - 没有外部库的 OpenGL 等.对于 JPEG 文件，UDF 还检索各种 Exif 信息.
- [OpenGL (2.0) (by minx)](https://www.autoitscript.com/forum/index.php?showtopic=148129) - 用于 OpenGL + AutoIt 的新 UDF 集.
- [Photoshop CS5 (by karime1)](https://www.autoitscript.fr/forum/viewtopic.php?f=21&t=9531) - 使用 AutoIt 控制 Photoshop CS5 Obj 的新 UDF.

### Players

- [VLC (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=114143) - VLC（媒体播放器）UDF.
- [VLC Media Player (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=91316) - VLC 媒体播放器.
- [WMP (by ConsultingJoe)](https://www.autoitscript.com/forum/index.php?showtopic=27352) - Windows 媒体播放器 UDF.

### Sound

- [BASS Function Library (by BrettF)](https://www.autoitscript.com/forum/index.php?showtopic=83481) - 通过 Bass、BassEnc、Bass FX、BassSFX、BassAsio 和 BassCd DLL 的包装器实现声音和音乐.
- [MIDI (by eynstyne)](https://www.autoitscript.com/forum/index.php?showtopic=37072) - MIDI UDF.
- [SAPIListBox (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=114742) - SAPIListBox（语音识别）UDF.
- [TTS (by Beege)](https://www.autoitscript.com/forum/index.php?showtopic=100439) - 文本到语音 UDF.
- [libZPlay (by Danyfirex)](https://www.autoitscript.com/forum/index.php?showtopic=173808) - libZPlay 的 UDF - 用于播放 mp3、mp2、mp1、ogg、flac、ac3、aac、oga、wav 和 pcm 文件和流的多媒体库.

### PDF

- [Acrobat Reader - ActiveX Viewer (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=162195) - 使用 Acrobat Reader ActiveX COM 对象“AcroPDF.PDF.1”制作您自己的 PDF 查看器 GUI
- [Debenu PDF Viewer SDK (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=164469) - 使用 Debenu PDF 查看器 SDK 在您的应用程序中显示 PDF 文件的功能集合.
- [Debenu Quick PDF Library (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=160875) - Debenu 快速 PDF 库的功能集合.
- [FoxIt Reader (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=75832) - AU3 中的 PDF 阅读器.
- [MPDF (by taietel)](https://www.autoitscript.com/forum/index.php?showtopic=118827) - 从您的应用程序创建 PDF.
- [PDFCreator (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=42776) - PDFCreator 的自动化允许您创建和操作 PDF 文件.
- [PDFCreator (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=170550) - 具有工作事件处理程序的 PDFCreator v1.xx 的 UDF.
- [_StringToPDF (by Tam0r)](https://www.autoitscript.com/forum/index.php?showtopic=32261) - 将字符串写入 PDF 文件并指定字体大小、类型等.

### Security

- [VirusTotal (by Danyfirex)](https://www.autoitscript.com/forum/index.php?showtopic=150819) - VirusTotal API 2.0 UDF.

### Social Media and other Website API

- [CrowdinAPI (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=169333) - UDF 使用 [crowdin.net website API](https://crowdin.com/page/api) 对于某些功能（创建项目、添加和更新文件、下载翻译或集成本地化）.
- [Dropbox authenticator (by Gimerly)](https://www.autoitscript.com/forum/files/file/290-dropbox-authenticator/) - Dropbox 验证器.
- [Easypost (by dcat127)](https://www.autoitscript.com/forum/index.php?showtopic=158106) - 打印 USPS 邮资标签.
- [eBay (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=114801) - eBay UDF（来自“购物 API”的函数 GetItemStatus 和 GetSingleItem）.
- [Gmail (by PhoenixXL)](https://www.autoitscript.com/forum/index.php?showtopic=141340) - 远程 Gmail (UDF).
- [Google Functions (by Beege)](https://www.autoitscript.com/forum/index.php?showtopic=98504) - Google 功能（建议、定义、翻译、转换）.
- [Google Maps (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=115437) - 谷歌地图 UDF.
- [Imgur](https://github.com/J2TeaM/AutoIt-Imgur-UDF) - 一个 AutoIt UDF，可帮助您使用 Imgur API 上传图像.
- [iTunes (by torels)](https://www.autoitscript.com/forum/index.php?showtopic=70675) - iTunes UDF.
- [iTunes (by Beege)](https://www.autoitscript.com/forum/index.php?showtopic=101802) - 另一个 iTunes UDF.
- [No-IP (by Nessie)](https://www.autoitscript.com/forum/index.php?showtopic=150985) - 使用此 UDF，您可以简单地更新您的无 IP 主机名并检索无 IP 地址的 IP 地址.
- [PasteBin (by mrflibblehat)](https://www.autoitscript.com/forum/index.php?showtopic=150838) - 巴斯德宾 UDF.
- [Skype (by FireFox)](https://www.autoitscript.com/forum/index.php?showtopic=121767) - Skype4COM 为 Skype API 提供了一个 ActiveX 接口.
- [Teamspeak 3 (by chipDE)](https://www.autoitscript.com/forum/index.php?showtopic=113234) - Teamspeak 3 UDF.
- [TeamViewer API (by mLipok)](https://www.autoitscript.com/forum/index.php?showtopic=166205) - TeamViewer API 的 UDF - 一个适度的开始.
- [TVmaze.com API (by BBs19)](https://www.autoitscript.com/forum/index.php?showtopic=166547) - TVmaze.com API UDF（电视剧）.
- [Twitter (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=116600) - 推特 UDF.
- [Yahoo Weather (by Nessie)](https://www.autoitscript.com/forum/index.php?showtopic=149247) - YWeather UDF - 雅虎天气 API.
- [Youtube Uploader (by BrettF)](https://www.autoitscript.com/forum/index.php?showtopic=112775) - AYTU - AutoIt Youtube 上传器.

### Windows

- [ACL (by ptrex)](https://www.autoitscript.com/forum/index.php?showtopic=50880) - 在 Windows 对象上设置 ACL.
- [FileSystemMonitor (by seangriffin)](https://www.autoitscript.com/forum/index.php?showtopic=113560) - 文件系统监视器 UDF.
- [Firewall (by JLogan3o13)](https://www.autoitscript.com/forum/index.php?showtopic=145158) - Windows 防火墙 UDF.
- [ITaskBarList (by Beege)](https://www.autoitscript.com/forum/index.php?showtopic=111018) - ITaskBarList UDF.
- [Local account (by engine)](https://www.autoitscript.com/forum/index.php?showtopic=74118) - 本地帐户 UDF.
- [Magnifier Functions (by Ascend4nt)](https://www.autoitscript.com/forum/index.php?showtopic=161193) - 此 UDF 公开了自 Windows Vista 以来可用的大部分有用的放大镜 API 函数.
- [Process UDF (by TheDcoder)](https://www.autoitscript.com/forum/topic/174697-process-udf-get-both-the-output-the-exit-code/) - 与 Windows 中的进程交互，运行进程并在单个函数调用中获取输出和退出代码！
- [Registry (by engine)](https://www.autoitscript.com/forum/index.php?showtopic=75250) - Windows 注册表 UDF.
- [Registry (by seanhart)](https://www.autoitscript.com/forum/index.php?showtopic=50551) - RegWriteAllUsers / RegDeleteAllUsers.
- [Startup (by guinness)](https://www.autoitscript.com/forum/index.php?showtopic=124508) - 在启动文件夹或注册表中创建启动项.
- [SCCM (by JLogan3o13)](https://www.autoitscript.com/forum/topic/164756-sccm-udf/) - 系统中心配置管理器库.
- [System restore (by FredAI)](https://www.autoitscript.com/forum/index.php?showtopic=134628) - System restore UDF.
- [Taskplanner/Taskscheduler COM (by Allow2010)](https://www.autoitscript.com/forum/index.php?showtopic=135994) - 使用 Windows Taskplaner / Task Scheduler 的 UDF.
- [Task Scheduler (by dbzfanatic)](https://www.autoitscript.com/forum/index.php?showtopic=83355) - 任务计划程序 UDF.
- [TTS UDF (by Kanashius)](https://www.autoitscript.com/forum/index.php?showtopic=173934) - 与 SAPI 自动化对象一起使用的 UDF - 文本到语音 (TTS) 引擎
- [UAC (by AdamUL)](https://www.autoitscript.com/forum/index.php?showtopic=158377) - 用户帐户控制 (UAC) UDF.
- [WIMGAPI (by Homes32)](https://www.autoitscript.com/forum/index.php?showtopic=127075) - 用于在没有 ImageX.exe 的情况下操作 Windows 图像文件 (.wim) 的 UDF.
- [Windows Events (by Emperor)](https://www.autoitscript.com/forum/index.php?showtopic=28436) - 创建您自己的 Windows 事件.
- [Windows Services (by engine)](https://www.autoitscript.com/forum/index.php?showtopic=81880) - Windows 服务 UDF.
- [WRMF (by Luigi)](https://www.autoitscript.com/forum/index.php?showtopic=163178) - WRMF - Windows 注册表监视器调用函数.

### Misc

- [Android (by Moriba)](https://www.autoitscript.com/forum/index.php?showtopic=160936) - 安卓 UDF.
- [Animated tray icons (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=97826) - 轻松制作动画托盘图标.
- [Atom Table (by Ascend4nt)](https://www.autoitscript.com/forum/index.php?showtopic=163577)  - 使用唯一的数字标识符在本地（在程序级别）或全局（在操作系统级别）存储字符串. 此 UDF 允许您添加、查找、删除和查询这些原子.
- [Barcode generators (by willichan)](https://www.autoitscript.com/forum/index.php?showtopic=170087) - 根据提供的数据创建 Code128A/B/C 或创建 Code39 或 Code39Extended 优化条码.
- [Binary (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=131037) - 二进制 UDF.
- [BinaryCall (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=162366) - BinaryCall UDF - 在 C 中编写子程序，在 AutoIt 中调用.
- [Clipboard History (by wraithdu)](https://www.autoitscript.com/forum/index.php?showtopic=81267)  - 保存和恢复整个剪贴板内容. 灵感来自 AHK 的 ClipboardAll.
- [CmdLine (by Jefrey)](https://www.autoitscript.com/forum/index.php?showtopic=169610) - 用于解析命令行参数的函数集合.
- [Copy (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=121833)  - 在不暂停脚本的情况下复制或移动文件和目录. 复制时检索当前状态（复制的字节、错误代码等）.
- [DDEML (by doudou)](https://www.autoitscript.com/forum/index.php?showtopic=55994) - 通过 DDEML UDF，可以将 AutoIt 脚本用作 DDE 客户端或服务器.
- [_DLLStructDisplay (by Ascend4nt)](https://www.autoitscript.com/forum/index.php?showtopic=99106) - 在 ListView 中显示结构.
- [Experimental Maps UDF (by TheDcoder)](https://github.com/TheDcoder/Experimental-Maps-UDF) - AutoIt 中新地图数据类型的 UDF，类似于标准 UDF 中包含的数组 UDF.
- [FASM (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=111613) - 嵌入式平面汇编程序 (FASM) UDF.
- [_FileGetMimeType (by Wiliat87)](https://www.autoitscript.com/forum/index.php?showtopic=157689) - _FileGetMimeType UDF.
- [File locking with cooperative semaphores (by willichan)](https://www.autoitscript.com/forum/topic/117033-file-locking-with-cooperative-semaphores) - 无需服务器的简单文件锁定.
- [FindMimeFromData (by twbradio)](https://www.autoitscript.com/forum/index.php?showtopic=157241) - 使用 urlmon.dll 查找 MimeFromData.
- [Hotkey.au3 (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=90492) - 热键 UDF 管理，与 HotkeySet() 相比具有多项优势.
- [Inline Assembly (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=86672) - 将代码汇编为二进制机器代码并运行它.
- [LFN (by orbs)](https://www.autoitscript.com/forum/index.php?showtopic=161628) - LFN UDF - 克服 256 个字符的 MAX_PATH 限制.
- [LASM - Light Assembler (by minxomat)](https://www.autoitscript.com/forum/index.php?showtopic=173946) - 这是汇编程序的内联 UDF
- [MemoryDll (by Ward)](https://www.autoitscript.com/forum/index.php?showtopic=77463) - 在脚本中嵌入 DLL 并从内存中调用函数.
- [NoFocusLines (by Melba23)](https://www.autoitscript.com/forum/index.php?showtopic=101733) - 从按钮、滑块、收音机和复选框中删除焦点虚线，这些虚线会破坏 GUI 的外观.
- [NotifyIcon (by FireFox)](https://www.autoitscript.com/forum/index.php?showtopic=149176) - NotifyIcon UDF（以前称为 TrayIconEx）- 创建、删除和管理自我通知图标.
- [PixelGetColor (by Manadar)](https://www.autoitscript.com/forum/index.php?showtopic=63318) - 从内存 UDF 获取或读取像素.
- [RDC (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=167024) - ReadDirectoryChanges 包装器.
- [Resources (by Zedna)](https://www.autoitscript.com/forum/index.php?showtopic=51103) - 资源 UDF.
- [ResourcesEx (by guinness)](https://www.autoitscript.com/forum/index.php?showtopic=162499) - ResourcesEx UDF（最新的 AutoIt 语言语法 v3.3.12.0）.
- [Spell Checker (by iCode)](https://www.autoitscript.com/forum/index.php?showtopic=162033) - 拼写检查器 UDF - Hunspell.
- [StringSize (by Melba23)](https://www.autoitscript.com/forum/index.php?showtopic=114034) - 自动调整控件大小以适合您要放入其中的文本.
- [Synology filestation (by nend)](https://www.autoitscript.com/forum/index.php?showtopic=164444) - 适用于 Synology NAS 服务器用户的 UDF.
- [TVExplorer (by Yashied)](https://www.autoitscript.com/forum/index.php?showtopic=125251) - TVExplorer UDF.
- [SciLexer (by Kip)](https://www.autoitscript.com/forum/index.php?showtopic=51547) - SciLexer UDF.
- [AutoItAppveyor (by KyleChamberlin)](https://github.com/AutoItMicro/AutoItAppveyor) - 该库包含将您的 AutoIt 脚本和程序与 Appveyor CI 集成的功能.
- [Micro Unit Testing Framework (by KyleChamberlin)](https://github.com/AutoItMicro/MicroUnitTestingFramework) - Micro 是与 AutoIt 一起使用的 xUnit 风格测试框架设计.
- [TeenyScript (by tarretarretarre)](http://teenyscript.tarre.nu/documentation)  - TeenyScript 是 AutoIt 的超集，使它更先进.  TeenyScript 代码被解析为原生 AutoiT 代码.
- [Logger (by Worlor)](https://github.com/Worlor/AutoIt-Logger)  - Logger 是一款非常易于使用的一体化日志记录工具！ 它每天启用日志轮换并在 x 天后压缩它

## Tools

- [SciTE4AutoIt3](https://www.autoitscript.com/site/autoit-script-editor/downloads/) 包含 SciTE，包装在一个安装程序中，包含所有需要的配置设置和许多实用程序，例如 [AutoIt3Wrapper](https://www.autoitscript.com/autoit3/scite/docs/SciTE4AutoIt3/AutoIt3Wrapper.html), [SciTEConfig](https://www.autoitscript.com/autoit3/scite/docs/SciTE4AutoIt3/SciTEConfig.html), [Tidy](https://www.autoitscript.com/autoit3/scite/docs/SciTE4AutoIt3/Tidy.html), [Au3Stripper](https://www.autoitscript.com/autoit3/scite/docs/SciTE4AutoIt3/Au3Stripper.html) 等以增强 SciTE 以与 AutoIt3 一起使用.
- [KODA Form Designer](http://koda.darkhost.ru/)  - 一个独立的应用程序，旨在帮助为 AutoIt3 脚本语言创建表单 (GUI). 它包含在 SciTE4AutoIt3 中.
- [ISN AutoIt Studio](http://www.isnetwork.at/index.php?option=com_content&view=article&id=10&Itemid=115) - AutoIt 编程语言的完整 IDE.
- [ISN AutoIT form Studio](http://www.isnetwork.at/index.php?option=com_content&view=article&id=7&Itemid=116) - AutoIt 的图形表单设计器.
- [AutoIt Obfuscator](https://www.pelock.com/products/autoit-obfuscator) - 混淆您的 AutoIt 脚本源代码和算法，以保护它免受逆向工程分析、破解和反编译.

## Useful Resources

### Documents

- [AutoIt Online Document](https://www.autoitscript.com/autoit3/docs/)
- [SciTE4AutoIt3 Online Document](https://www.autoitscript.com/autoit3/scite/docs/SciTE4AutoIt3.html) | [Wiki](https://www.autoitscript.com/wiki/SciTE4AutoIt3)

### Websites

- [Official Website](https://www.autoitscript.com/)
- [Official Forum](https://www.autoitscript.com/forum/)
 + [Vietnamese Forum](http://autoitvn.com/)
 + [French Forum](http://www.autoitscript.fr/)
 + [Brazilian Forum](http://forum.autoitbrasil.com/)
 + [Germany Forum](https://autoit.de/)
 + [Russian Forum](http://autoit-script.ru/)
 + [Spanish Forum](http://www.emesn.com/autoitforum/)
- [AutoIt Wiki](https://www.autoitscript.com/wiki)
- [Programs](https://www.autoitscript.com/wiki/AutoIt_Programs) - 在 AutoIt 中创建的程序列表.
- [AutoIt Group on Facebook](https://www.facebook.com/groups/autoitscript/) （越南语）.

### Guides/Tutorials

- [Tutorials](https://www.autoitscript.com/wiki/Tutorials)  - AutoIt 有许多可用的教程. 此页面是一些已知教程的概述.
- [Best coding practices](https://www.autoitscript.com/wiki/Best_coding_practices)  - 详细解释什么被认为是 AutoIt 中的最佳编码实践. 这些建议基于许多其他编程语言通用的公认编码实践. 您不需要遵循它们，但建议您这样做.
- [Snippets](https://www.autoitscript.com/wiki/AutoIt_Snippets) - 通常可以合并到脚本中以添加额外功能的单个函数或小段代码.

### Videos

- [AutoIt Tutorials](https://www.youtube.com/playlist?list=PL1DCD109B801D0DE6) 通过 403 禁止 403.
- [AutoIt Tutorials](https://www.youtube.com/user/AutoitFrench/videos) 通过 AutoitFrench.
- [AutoIt for Beginner](https://www.youtube.com/playlist?list=PLNeDQQ_ukvRoz5IKgFy1pgfZVqDuZf5X2) 由李赛.
- [AutoIt for Beginner](https://www.youtube.com/playlist?list=PLADZ5XR0fS9B1AL1FmLUCfrXoRu2nYOKu) 由 Hai The Luong 撰写.
- [Advanced AutoIt Tutorials](https://www.youtube.com/playlist?list=PL_-NI9iPtoB741rTw1hjNPirk3jTMKtrQ) 由 Juno\_that [[Subscribe](https://www.youtube.com/channel/UCEETpUrNm5qI-LENbBON2Gw/?sub_confirmation=1)].

### Books

- [AutoIt v3: Your Quick Guide](http://shop.oreilly.com/product/9780596515126.do) 通过安迪弗莱斯纳（[Download PDF](https://www.google.com/search?q=AutoIt+v3%3A+Your+Quick+Guide+filetype%3Apdf)).
- [Instant AutoIt Scripting](https://books.google.com.vn/books?id=TgY2-RSxhDUC) 来自非斯拉索的 Emilio Aristides.
- [AutoIT Scripting For Beginners](https://books.google.com.vn/books?id=ugdeCgAAQBAJ) 拉詹.
- [Learn To Program Using FREE Tools with AutoIt 1.2](https://www.autoitscript.com/forum/files/file/351-learn-to-program-using-free-tools-with-autoit/) 由 Jfish 提供.

### Syntax Highlighter

- [GeSHi - Generic Syntax Highlighter](http://qbnz.com/highlighter/)
- [Highlight.js](https://highlightjs.org/) - 从 8.7 版本开始添加了 AutoIt
- [Crayon Syntax Highlighter](https://wordpress.org/plugins/crayon-syntax-highlighter/) (WordPress 插件) - 自版本 1.8.2 起添加了 AutoIt
- [WP Syntax](https://wordpress.org/plugins/wp-syntax/) (WordPress 插件) - 基于 GeSHi.
- [PrismJS](http://prismjs.com/) - 从 1.1.0 版本开始添加 AutoIt
- [AutoIt - Visual Studio](https://github.com/loganch/AutoIt-VSCode) - Visual Studio 的 AutoIt 扩展.

## License

[![Creative Commons License](http://i.creativecommons.org/l/by/4.0/88x31.png)](https://creativecommons.org/licenses/by/4.0/)

这项工作已获得许可 [Creative Commons Attribution 4.0 International License](https://creativecommons.org/licenses/by/4.0/).

---

## Other Awesome Lists

- [awesome](https://github.com/sindresorhus/awesome) 通过@sindresorhus
- [awesome-all](https://github.com/bradoyler/awesome-all) 通过@bradoyler
- [awesome-awesome](https://github.com/emijrp/awesome-awesome) 通过@emijrp
- [awesome-awesome](https://github.com/erichs/awesome-awesome) 通过@erichs
- [awesome-awesome](https://github.com/oyvindrobertsen/awesome-awesome) 通过@oyvindrobertsen
- [awesome-awesomeness](https://github.com/bayandin/awesome-awesomeness) 通过@bayandin
- [awesome-awesomes](https://github.com/fleveque/awesome-awesomes) 通过@fleveque
- [awesome-collection](https://github.com/flyhigher139/awesome-collection) 通过@flyhigher139
- [lists](https://github.com/jnv/lists) 通过@jnv

[[Back to Top](#awesome-autoit)]
