<div class="github-widget" data-repo="ahkscript/awesome-AutoHotkey"></div>
## Awesome AutoHotkey [![AutoHotkey](https://img.shields.io/badge/Language-AutoHotkey-yellowgreen.svg)](https://autohotkey.com/) [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

精选清单 [AutoHotkey](https://autohotkey.com/) 库、库分布、脚本、工具和资源. 受他人启发 [awesome lists](https://github.com/bayandin/awesome-awesomeness) . 请阅读 [CONTRIBUTING.md](https://github.com/ahkscript/awesome-AutoHotkey/blob/master/.github/CONTRIBUTING.md) 在贡献之前.

过时或停产，但仍然具有历史相关性的项目可以在 [Historical.md](https://github.com/ahkscript/awesome-AutoHotkey/blob/master/Historical.md)

发展状况： 
[![Build Status](https://travis-ci.org/ahkscript/awesome-AutoHotkey.svg)](https://travis-ci.org/ahkscript/awesome-AutoHotkey) [![awesome_bot](https://img.shields.io/badge/PoweredBy-awesome_bot-yellow.svg)](https://github.com/dkhamsing/awesome_bot)

<!-- Note: be sure to use unique anchor tags for each item in the table of contents -->

<hr/>

## Libraries
 *有用的 AutoHotkey 库列表. 库是具有一些可重用功能的代码，可以与您自己的代码结合以创建新功能.*

### Clipboard
* [WinClip](http://www.apathysoftworks.com/ahk/WinClip.zip)  - 由 Deo - WinClip 是一个剪贴板操作类，扩展了 AutoHotkey 的剪贴板功能，包括对 RTF、HTML 和图像的支持. 论坛主题： [link](https://autohotkey.com/board/topic/74670-class-winclip-direct-clipboard-manipulations/).

### Console
* [AHKonsole](https://github.com/G33kDude/Console)  - 由 G33kdude - 基于类的 AutoHotkey 库，用于控制台支持. 该库使您能够创建一个表示要与之交互的控制台的对象，以及多个控制台缓冲区对象以促进双缓冲. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=4955).
* [LibCon](https://github.com/joedf/LibCon.ahk)  - 由 joedf - 用于控制台支持的 AutoHotkey 库. 该库使您能够编写控制台应用程序并与其他控制台实例交互. 基本上，这个库可以促进与编写和与控制台交互有关的任何事情. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?t=17).

### <a name="libraries-data-format"></a>Data format
* [AHK_ctable](https://github.com/hoppfrosch/AHK_cTable) - 由 hoppfrosch - 处理表格格式字符串的库 - 论坛主题： [link](https://autohotkey.com/board/topic/61256-object-table/://autohotkey.com/board/topic/61256-object-table/page-2?&#entry467816).
* [AutoHotkey-JSON](https://github.com/cocobelgica/AutoHotkey-JSON)  - 由 cocobelgica - AutoHotkey 的 JSON 库. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=627).
* [CSV](https://github.com/hi5/CSV)  - 由 trueski/kdoske - 用于处理 CSV 文件和 Listview 函数的库. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=34853).
* [List manipulation functions](http://www.hars.us/SW/List.ahk)  - Laszlo - 操作逗号分隔列表的函数库. 论坛主题： [link](https://autohotkey.com/board/topic/3020-list-manipulation-functions/).
* [ObjCSV](https://github.com/JnLlnd/ObjCSV/)  - 由 JnLlnd - 将 CSV 文件加载/保存到对象和列表视图函数的库. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=41).
* [ObjDump/ObjLoad](https://autohotkey.com/boards/viewtopic.php?f=6&t=3573) - 通过 HotKeyIt - 将对象序列化/反序列化到/从变量/内存.
* [SerDes](https://github.com/cocobelgica/AutoHotkey-SerDes)  - 由 cocobelgica - 序列化/反序列化 AutoHotkey 对象结构. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=4212).
* [Table](https://github.com/Jim-VxE/AHK-Lib-Table)  - 由 VxE - 以表格 (TSV) 格式和 Listview 函数操作字符串的库. 论坛主题： [link](https://autohotkey.com/board/topic/61540-lib-string-based-table-manipulation-v028/).
* [XA](https://github.com/hi5/XA)  - 由 trueski/hi5 - 将数组序列化/反序列化为 XML. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=34849).

### <a name="libraries-data-structs-algorithms"></a>Data Structures and Algorithms
* [Facade](https://github.com/Shambles-Dev/AutoHotkey-Facade)  - 由 Shambles - 一组函数式编程库.  - 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=59253)
* [HashTable](https://github.com/Shambles-Dev/AutoHotkey-HashTable) - 由 Shambles - AutoHotkey 的哈希表实现.
* [LibCrypt](https://github.com/ahkscript/LibCrypt.ahk) - 不同的作者 - 加密和编码函数的集合.
* [Type_Checking](https://github.com/Shambles-Dev/AutoHotkey-Type_Checking) - 由 Shambles - AutoHotkey 的类型检查 - 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=59857)

### Database
* [AHKDb](https://github.com/AHKDb/AHKDb) - 由 AHKDb - 用于制表符分隔数据的数据库库.
* [ahkDBA](https://github.com/IsNull/ahkDBA)  - 由 IsNull - 一个 OOP-SQL 数据库访问框架. 论坛主题： [link](https://autohotkey.com/board/topic/71179).
* [Class_SQLiteDB](https://github.com/AHK-just-me/Class_SQLiteDB)  - 只有我 - AHK SQLite API 包装器类. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?t=1064).
* [Leya - MySQL API](https://github.com/kevgk/Leya) - 由 kevgk - 在 autohotkey 中使用 MySQL 数据库，而不向客户端公开服务器凭据.

### Filesystem
* [FileGetProperties](https://autohotkey.com/boards/viewtopic.php?f=6&t=3806) - by kon - 检索扩展文件属性的函数.

### <a name="libraries-graphics"></a>Graphics
* [GDIp](https://github.com/tariqporter/Gdip/) - 通过 tic - 有助于与 Microsoft 的 gdiplus.dll 交互的全功能库 - 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=6517).
* [ImagePut](https://github.com/iseahound/ImagePut)  - by iseahound - 用于转换为文件、流、窗口、base64、url、光标、屏幕坐标、剪贴板、指针、句柄等的图像库. 支持 AutoHotkey v1 和 v2.  - 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=76301&p=330615)
* [AHKv2-GDIP](https://github.com/mmikeww/AHKv2-Gdip) - 更新与 AHK v1.1 和 AHK v2 兼容的上述 GDI+ 库 - 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=6517).
* [GDIp_ImageSearch](https://autohotkey.com/board/topic/71100-)  - 由 tic - 使用 gdiplus.dll 的库在屏幕上搜索图像实例. 查看 MasterFocus 改进版本的线程末尾，或者查看他 [GitHub repo here](https://github.com/MasterFocus/AutoHotkey/tree/master/Functions/Gdip_ImageSearch)
* [Simple GDI class](https://autohotkey.com/boards/viewtopic.php?f=6&t=5820) - 由 GeekDude - 旨在简化使用低级 GDI 函数的类.
* [Particle System](https://github.com/acorns/Particle-System)  - by tidbit - 一个使用 GDI+ 将粒子添加到 GUI 或屏幕上的简单类. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=26485).

### <a name="libraries-gui"></a>GUI

#### Combobox
* [CbAutoComplete](https://github.com/pulover/cbautocomplete)  - 由 Pulover - 自动完成 AHK ComboBox 中键入的值. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=15002)

#### Custom Controls
* [Rebar](https://github.com/Pulover/Class_Rebar)  - 由 Pulover - AutoHotkey Rebar 自定义控件的 AHK 类. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=139)
* [Toolbar](https://github.com/Pulover/Class_Toolbar)  - 由 Pulover - AutoHotkey 工具栏自定义控件的 AHK 类. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=138)

#### Edit
* [Edit v2.0](https://autohotkey.com/boards/viewtopic.php?f=6&t=5063)  - 由 jballi - 用于显示和编辑文本的轻量级且功能强大的默认编辑控件库. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=5063)

#### General
* [AutoXYWH](https://autohotkey.com/boards/viewtopic.php?f=6&t=1079) - 由 tmplinshi - 在调整 GUI 大小时自动移动和调整控件大小.
* [TaskDialog](https://github.com/AHK-just-me/TaskDialog) - 仅由我 - 为 Win Vista+ 增强的 MsgBox - [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=4635)
* [OnWin](https://github.com/cocobelgica/AutoHotkey-Util/blob/master/OnWin.ahk)  - 由 cocobelgica - 窗口事件调用函数（WinWaitXXX 异步）. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=6463)
* [CGUI](https://github.com/lipkau/CGUI/)  - 作者 ChrisS85 - 面向对象的 AutoHotkey GUI 库. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=26990)
* [Class_ScrollGUI](https://github.com/AHK-just-me/Class_ScrollGUI)  - 只有我 - 创建一个可滚动的 GUI 作为 AHK GUI 窗口的父级. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=6316)

#### ListBox
* [LBEX](https://github.com/AHK-just-me/LBEX) - 经过 [just me](https://github.com/AHK-just-me)  - 列表框实用函数的集合. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=4755)
* [TransparentListBox](https://github.com/AHK-just-me/Class_TransparentListBox)  - 仅由我提供 - 为 AHK GUI 提供透明的列表框控件. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=108)

#### ListView
* [LV_Colors](https://github.com/AHK-just-me/Class_LV_Colors/)  - 仅由我 - GUI ListView 的单元格或行的单独背景和/或文本颜色. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=1081)
* [LV_EX](https://github.com/AHK-just-me/LV_EX)  - 只有我 - AHK GUI ListView 控件的一些附加功能. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=1256)
* [LV_InCellEdit](https://github.com/AHK-just-me/Class_LV_InCellEdit/)  - 仅由我 - ListView 控件的单元内编辑. 论坛主题： [link](http://https://autohotkey.com/boards/viewtopic.php?f=6&t=1076)
* [LV_Rows](https://github.com/Pulover/Class_LV_Rows)  - 由 Pulover - AHK ListView 控件的附加功能. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=137)

#### Menu
 * [[Lib] 菜单](https://autohotkey.com/boards/viewtopic.php?t=3068) - 只有我 - 一些与 AHK 菜单相关的功能. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?t=3068)

#### Web
* [Neutron](https://github.com/G33kDude/Neutron.ahk/)  - 由 G33kDude - 用于使用 AutoHotkey 构建基于 HTML 的用户界面的工具集. 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=76865)

### Hotkeys
* [CHotkeyControl](https://autohotkey.com/boards/viewtopic.php?f=6&t=9087) - 由 evilC - 替换支持鼠标按钮等的 AHK 热键 GuiControl（部分成熟）.
* [HParse](https://autohotkey.com/board/topic/92805-) - 由 Avi - 将有意义的快捷方式 (Ctrl+X) 转换为 AutoHotkey 语法 (^x) 的功能.

### Joystick
* [CvJoyInterface](https://autohotkey.com/boards/viewtopic.php?t=5705) - 通过 evilC - 使用 AHK 控制 vJoy 虚拟操纵杆.
* [JoystickWrapper](https://autohotkey.com/boards/viewtopic.php?f=19&t=28889) - by evilC - Full event-based, 8 axis, 128 button, 4 POV joystick reading (C# DLL, Uses Lexikos' CLR).
* [XInput](https://autohotkey.com/board/topic/35848-xinput-xbox-360-controller-api/) - 由 Lexikos - 使用 XInput 读取 XBOX 游戏手柄（唯一独立读取 L/R 触发器的方法），控制隆隆声电机.

### Maths
* [calc()](https://autohotkey.com/board/topic/59087-func-calc-math-expression-evaluation-incl-brackets/?p=655135) - 数学表达式评估，包括括号.
* [Eval](https://github.com/pulover/eval)  - 由 Pulover - 评估字符串中的表达式. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=13565)
* [Scientific Maths](https://autohotkey.com/board/topic/93516-) - by Avi - 促进高精度数学的图书馆.
* [Time()](https://autohotkey.com/board/topic/42668-time-count-days-hours-minutes-seconds-between-dates/)  - 由 HotkeyIt 提供 - 计算日期之间的天数、小时、分钟、秒数. 论坛主题： [link](https://autohotkey.com/board/topic/42668-time-count-days-hours-minutes-seconds-between-dates/)

### Memory

* [classMemory](https://github.com/Kalamity/classMemory)  - 由 RHCP (Kalamity) - 一个带有模式扫描的 AHK 内存读/写类. 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?t=1177)

### Networking
* [AHKhttp](https://github.com/Skiouros/AHKhttp)  - 基本 HTTP 服务器. 论坛 [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=4890)
* [AHKsock](https://github.com/jleb/AHKsock)  - 由 TheGood - 基于函数的套接字库. 支持TCP. 论坛 [link](https://autohotkey.com/board/topic/53827-ahksock-a-simple-ahk-implementation-of-winsock-tcpip/)
* [Chrome.ahk](https://github.com/G33kDude/Chrome.ahk) - 作者 G33kDude - 使用本机 AutoHotkey 自动化 Google Chrome - 论坛 [link](https://www.autohotkey.com/boards/viewtopic.php?t=42890)
* [FTP](https://github.com/jNizM/Class_FTP) - 由 jNizM - FTP 会话的 AutoHotkey 包装器（类） - 论坛 [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=79142&p=344445#p344445)
* [Rufaydium WebDriver](https://github.com/Xeo786/Rufaydium-Webdriver) - 由 Xeo786 - Webdriver 库支持任何基于 Chromium 的浏览器，只需要 webdriver（无 selenium/websocket） - 论坛 [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&p=457302)
* [Socket Class (überarbeitet)](https://autohotkey.com/board/topic/94376-)  - Bentschi - 基于类的套接字库. 支持TCP和UDP.
* [Socket.ahk](https://github.com/G33kDude/Socket.ahk) - 由 GeekDude - 基于 Bentschi 的套接字库 - 论坛 [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=35120)
* [WebSocket.ahk](https://github.com/G33kDude/WebSocket.ahk) - GeekDude - 基于类的 WebSocket 库 - 论坛 [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=35117)
* [WinSCP.ahk](https://github.com/lipkau/WinSCP.ahk) - Lipkau - Lib 允许在 AHK 中使用 WinSCP

### <a name="libraries-plotting"></a>Plotting (graphs, bars, charts and etc)
* [Excel Charts](https://autohotkey.com/board/topic/88438-excel-charts/) - Xx7 - 用于在 Excel 中创建图形的库，将图形保存为图像并将其显示在 GUI 中.
* [XGraph](https://autohotkey.com/boards/viewtopic.php?t=3492) - 由 SKAN - 用于以图形方式绘制实时数据的函数库.
* [SVGraph](https://github.com/CapnOdin/SVGraph)  - 由 CapnOdin - SVGraph 为 AutoHotkey 带来图形和图表. 论坛 [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=23892)
* [gdiChartLib](https://github.com/nnnik/gdiChartLib)  - 作者 nnnik - 用于 autohotkey 的 gdip 图表库. 论坛 [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=31533)

### <a name="libraries-system"></a>System
* [RunAsTask](https://autohotkey.com/boards/viewtopic.php?t=4334) - 由 SKAN - 在没有 UAC 提示的情况下自动提升脚本.
* [Vista Audio Control Functions](https://github.com/ahkscript/VistaAudio)  - 由 Lexikos - 提供一些 SoundSet/SoundGet 子命令的替代方法，以及 SoundSet/SoundGet 不支持的一些附加功能. 论坛主题： [Link](https://autohotkey.com/board/topic/21984-vista-audio-control-functions/?p=143564)

### Text manipulation
* [String Things](https://autohotkey.com/boards/viewtopic.php?f=6&t=53) - by tidbit - 独立的字符串操作函数.
* [TF](https://github.com/hi5/TF)  - by hi5 - 用于处理*.txt、*.ahk、*.html、*.css 等文本文件和字符串（或变量）的函数. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=576).

## Library Distributions
 *有用的 AutoHotkey 库分发列表.  Library Distribution 是一个用于分发图书馆的系统.*

* [ahk-libs](https://github.com/rshipp/ahk-libs) - Ryan Shipp 的图书馆收藏.
* [ASPDM](https://github.com/ahkscript/ASPDM) - 包/stdlib 分发和管理来自 [ahkscript](https://github.com/ahkscript) 伙计们. 特雷洛 [link](https://trello.com/b/XVP4M76d/package-stdlib-distribution-and-management).
* [pAHKlight](https://github.com/hi5/pAHKlight) - AutoHotkey 库、类、函数和工具的轻量级指南.

## Scripts
 *有用的 AutoHotkey 脚本列表. 脚本是旨在用作独立程序的代码，并不意味着与其他代码集成.*

### <a name="scripts-clipboard"></a>Clipboard
* [CL3](https://github.com/hi5/CL3)  - 带有插件（搜索、预定义插槽、ClipChain、FIFO、编辑器等）的剪贴板管理器（仅文本）. 论坛帖子 [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=814).
* [ClipBoardMonitor](https://github.com/536/my-startup-ahk-scripts/blob/master/startup/ClipBoardMonitor/ClipBoardMonitor.ahk) - 监视剪贴板更改，显示文本字数统计工具提示或图片临时 GUI.
* [Clipjump](http://clipjump.sourceforge.net/)  - 是适用于 Windows 的多剪贴板管理实用程序. 源代码： [GitHub](https://github.com/aviaryan/Clipjump) . 论坛话题： [link 1](https://autohotkey.com/boards/viewtopic.php?f=6&t=401), [link 2](https://autohotkey.com/board/topic/91488-clipjump-the-ultimate-clipboard-manager-updated-0708/).

### <a name="scripts-filesystem"></a>Filesystem
* [Belvedere](https://github.com/adampash/belvedere)  - 根据文件名、扩展名、大小、期限等设置对文件执行操作（移动、复制、删除等）的规则. 更多信息 [link](http://lifehacker.com/341950/belvedere-automates-your-self-cleaning-pc).
* [QuickAccessPopup](https://github.com/JnLlnd/QuickAccessPopup)  - 多用途启动器和文件切换器. 网站 [link](https://www.quickaccesspopup.com/).
* [SpicyKeys](https://spicykeys.github.io/)  - 使用热键在 Windows 资源管理器中打开或移动/复制选定的文件. 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=97171)

### <a name="scripts-graphics"></a>Graphics
* [Fun with GDIPlus](https://autohotkey.com/boards/viewtopic.php?f=6&t=6071) - 有趣的 GDI+ 示例.

### <a name="scripts-gui"></a>GUI
* [Examples of Non-Standard GUIs (ActiveX, GDI, etc.)](https://autohotkey.com/boards/viewtopic.php?f=6&t=3851) - 使用非标准方法生成漂亮用户界面的 GUI 示例.


### <a name="scripts-maths"></a>Maths
* [Monster](https://autohotkey.com/board/topic/15675-monster-evaluate-math-expressions-in-strings/) - 评估字符串中的数学表达式（计算器）.
* [Unit Converter](https://autohotkey.com/board/topic/39359-unit-converter/)  - 具有最常用的英语和科学单位以及从长度到密度再到热导率的最常用量的单位转换器. 还包括物理和数学常数部分.

### Mouse
* [EitherMouse](http://www.EitherMouse.com)  - 多只鼠标、单独设置、在第二只鼠标上自动交换鼠标按钮. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=3648).
* [MouseGestureL](http://www.vector.co.jp/download/file/winnt/util/fh633547.html)  - 通过鼠标手势控制应用程序. 可以通过可定制的界面定义手势和动作. 英文和日文文档 - 日本主页 [link](http://hp.vector.co.jp/authors/VA018351/mglahk.html)
* [Radial Menu](https://autohotkey.com/board/topic/46856-radial-menu-scripts-updated-07122014/) - 强大的热键、启动器、鼠标手势系统等等（可换肤） - 论坛主题： [link](https://autohotkey.com/board/topic/46856-radial-menu-scripts-updated-07122014/)

### Typing
* [AutoComplete](https://github.com/Uberi/Autocomplete)  - 在您键入时建议并完成单词. 论坛主题： [link](https://autohotkey.com/board/topic/60998-autocomplete/).
* [DateHotkey](https://github.com/tiuub/DateHotkey)  - 轻松接收当前、过去或即将到来的日期字符串的热键. 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=89929)
* [Half-QWERTY](https://autohotkey.com/board/topic/1257-half-qwerty-one-handed-typing/page-6#entry216183)  - 单手打字. 使用空格键作为修饰符，用户仅用一只手就可以生成全尺寸键盘任一侧的字符. 通过论坛主题获取更多信息： [link](https://autohotkey.com/board/topic/1257-half-qwerty-one-handed-typing/)
* [KeyPress OSD](https://github.com/marius-sucan/KeyPress-OSD)  - 屏幕显示以清晰可见的文本大小显示每个键或鼠标按钮的按下. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=225)
* [Lintalist](http://lintalist.github.io/)  - 可搜索的交互式列表，用于使用插件复制和粘贴文本. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=3378).
* [Portable Keyboard Layout](http://pkl.sourceforge.net/)  - 帮助人们学习更好、更高效的键盘布局，例如 Dvorak、Colemak 或 Asset. 论坛主题： [link](https://autohotkey.com/board/topic/25991-portable-keyboard-layout/).
* [Static Hands](https://github.com/almogtavor/static-hands)  - 使用 CapsLock 键的超级有用的快捷方式，无需在打字时移动双手. 超级简单. 没有学习曲线.
* [Thumbscript](https://autohotkey.com/board/topic/27198-beta-thumbscript-ahk/)  - 允许您使用数字键盘输入，每个字母只需按 2 次数字键. 文档： [link](http://thumbscript.com/howitworks.html)
* [TypingAid](https://github.com/ManiacDC/TypingAid/releases)  - 在您键入时建议并完成单词. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=5644) GitHub [link](https://github.com/ManiacDC/TypingAid).

### Window Management
* [Automatic Window Manager](https://autohotkey.com/boards/viewtopic.php?f=6&t=17907)  - 保存和恢复每个进程的最后一个窗口位置. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=17907)
* [bug.n](https://github.com/fuhsjr00/bug.n)  - 平铺窗口管理器. 论坛主题： [link](https://autohotkey.com/board/topic/30332-bugn-tiling-window-manager/)
* [Min2Tray](http://junyx.breadfan.de/Min2Tray/)  - 将窗口最小化到托盘等. 论坛主题： [link](https://autohotkey.com/board/topic/4173-min2tray-v179-minimize-window-to-tray-much-more/)
* [Open-Show-Apps](https://github.com/JuanmaMenendez/AutoHotkey-script-Open-Show-Apps)  - 打开、恢复或最小化所需的 Windows 或 Chrome 应用程序. 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=63579&p=272220#p272220)
* [SnapX](https://github.com/benallred/SnapX/releases)  - 通过接管其热键（Win+左/右等）并提供对捕捉位置和大小的更精细控制来增强 Windows/Aero Snap. 适用于多个显示器、分辨率和 DPI 级别.
* [WindowPadX](https://github.com/hoppfrosch/WindowPadX)  - 在多显示器环境中提供一些有用功能的工具.  _WindowPadX 是 WindowPad 的增强版，最初由 Lexikos 发布，请参阅原始论坛主题： [link](https://autohotkey.com/board/topic/19990-windowpad-window-moving-tool/)_ 

### Games
* [Achromatic - ProgressPlatformer](https://github.com/Uberi/ProgressPlatformer/releases)  - 平台游戏. 论坛主题： [link](https://autohotkey.com/board/topic/64529-achromatic-progressplatformer-refined/), 知乎: [link](https://github.com/Uberi/ProgressPlatformer)
* [AHK Mahjong Solitaire](https://autohotkey.com/boards/codeboxplus/download/183219-1)  - 麻将游戏. 论坛主题： [link](https://autohotkey.com//boards/viewtopic.php?f=19&t=40133)
* [F1 Racer](https://www.dropbox.com/sh/01ucst7jeybn9ed/AABCItk8VKlfVp67T0P_DJFia)  - 2 人或 4 人赛车游戏. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=19&t=4307&p=24024&hilit=racing#p24024)
* [Infection](https://autohotkey.com/boards/download/file.php?id=3349&sid=b3444f44c767f7698ede586c81d40fe2)  - 棋盘游戏. 也称为 Ataxx. 论坛主题： [link](https://autohotkey.com/board/topic/35504-game-manytetris-customizable-pocket-tetris/)
* [Ishido](https://github.com/flibioahk/ishido/archive/master.zip)  - 复古益智游戏. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?t=31825https://github.com/flibioahk/ishido), 知乎: [link](https://github.com/flibioahk/ishido)
* [ManyTetris](http://sector-seven.net/assets/stuff/ManyTetris.zip)  - 多个俄罗斯方块变体. 论坛主题： [link](https://autohotkey.com/board/topic/35504-game-manytetris-customizable-pocket-tetris/)
* [Out of the Sea](http://ludumdare.com/compo/ludum-dare-24/?action=preview&uid=14126)  - 尽量避免通过进化被钓鱼.  GitHub: [link](https://github.com/Uberi/Ludum-Dare-24)
* [PABI Logical](https://github.com/bichlepa/PABI-Logical/releases)  - 翻拍 amiga 游戏 Logical. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=33267), 知乎: [link](https://github.com/bichlepa/PABI-Logical)
* [Sudoku](https://autohotkey.com/boards/codeboxplus/download/77645-1)  - 数独游戏和求解器. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?t=15291)

## <a name="tools"></a>Tools
 *有用的 AutoHotkey 工具列表. 为 AutoHotkey* 制作的工具

### Interpreter
* [AutoHotkey](https://autohotkey.com/download/) - AutoHotkey 解释器安装程序和二进制文件.
* [AutoHotkey DLL](https://github.com/HotKeyIt/ahkdll-v1-release/)  - AutoHotkey.dll 为其他编程和脚本语言打开了 AutoHotkey 的世界. 论坛主题： [link](https://autohotkey.com/board/topic/39588-autohotkeydll/) . 文档 [link](http://hotkeyit.ahk4.net/files/AutoHotkey-txt.html).
* [AutoHotkey build for CE](http://www.autohotkey.net/%7EMicha/AutohotkeyCE/AutoHotkeyCEUni.CAB)  - 用于掌上电脑/WinCE/智能手机的 AutoHotkey. 论坛主题： [link](https://autohotkey.com/board/topic/24776-autohotkey-for-pocket-pcs-wince-smartphones/) . 文档 [link](http://www.autohotkey.net/~Micha/AutohotkeyCE/html/index.htm).
* [AHK_X11](https://github.com/phil294/AHK_X11) phil294 对 Linux 的 AutoHotkey v1.0.24 的基本但实用的实现. [Forum](https://www.autohotkey.com/boards/viewtopic.php?f=81&t=106640)
* [IronAHK](https://github.com/polyethene/IronAHK) - 跨平台 .NET 重写 - *未完成*.
* [Keysharp](https://bitbucket.org/mfeemster/keysharp/src/master/) - 由 mfeemster 继续 IronAHK. [Forum](https://www.autohotkey.com/boards/viewtopic.php?f=80&t=77248)

### Debugging
 * [[Class] Console](https://autohotkey.com/boards/viewtopic.php?f=6&amp;t=2116) - 此类旨在简化脚本的调试，从简单的文本处理到输出和记录数据和数组.  GitHub [link](https://github.com/AfterLemon/Class_Console).
* [Yunit](https://github.com/Uberi/Yunit) - 由 Uberi 和 infogulch - AutoHotkey 的简单单元测试框架.

### Decompilers
* [AutoHotkey decompiler](https://gist.github.com/Uberi/3334552#file-decompiler-ahk) - 对于 AHK 1.1+ 论坛主题： [link](https://autohotkey.com/board/topic/82986-ahk-l-decompiler-payload-method/).
* [AutoHotkey decompiler - classic](https://autohotkey.com/docs/Scripts.htm#exe2ahk) - 对于 AHK 1.0，不能使用密码或 /nodecompile 保护的文件.

### Integrated Development Environment
* [AHK Studio](https://autohotkey.com/boards/viewtopic.php?f=6&t=300) - 基于 SciLexer.dll 的 AutoHotkey IDE.
* [Adventure (formerly AutoGUI)](https://www.autohotkey.com/boards/viewtopic.php?f=64&t=89901) - 经过 [Alguimist](https://autohotkey.com/boards/memberlist.php?mode=viewprofile&u=64723) - 具有有用的内置插件和 GUI 设计器的 AHK IDE.
* [AutoHotFlow](https://www.dropbox.com/s/99cwiqpzlx4mtuz/AutoHotFlow%20Installation.exe?dl=1)  - 绘制您的应用程序. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=6399) .  GitHub [link](https://github.com/bichlepa/AutoHotFlow).
* [DRAKON Editor](https://autohotkey.com/boards/viewtopic.php?f=6&t=3108) - AutoHotkey 的可视化编程（使用 DRAKON 图）.
* [Notepad++ for AutoHotkey](https://autohotkey.com/boards/viewtopic.php?f=7&t=50) - 为 AutoHotkey 设置流行的代码编辑器 Notepad++.
* [SciTE4AutoHotkey](http://fincs.ahk4.net/scite4ahk/) - 用于 AutoHotkey 的基于 SciTE 的 IDE.
* [SublimeAutoHotkey](https://github.com/ahkscript/SublimeAutoHotkey) - 用于 SublimeText 的 AutoHotkey AHK 语言包，包括语法高亮、注释切换、自动完成、构建系统定义、ahkrun、ahkcompile、ahkrunpiped 命令.
* [Sublime 4 AutoHotkey](https://autohotkey.com/board/topic/91066-sublime-4-autohotkey-updated-1311/)  - Sublime 4 AutoHotkey 是 Sublime Text 文本编辑器的补丁，增加了对 AutoHotkey 的支持.  -（已停产）
* [vim-AHKcomplete](https://github.com/huleiak47/vim-AHKcomplete)  - 添加自动完成的 Vim 插件.  （全方位完成）
* [Vim autohotkey-ahk](https://github.com/vim-scripts/autohotkey-ahk) - 为 AutoHotkey 添加语法高亮的 Vim 插件.
* [VSCode extension](https://marketplace.visualstudio.com/items?itemName=slevesque.vscode-autohotkey) - Visual Studio Code (VSCode) 插件为 AutoHotkey 添加语法高亮显示.
* [AutoHotkey Plus Plus](https://marketplace.visualstudio.com/items?itemName=mark-wiemer.vscode-autohotkey-plus-plus) AutoHotkey IntelliSense、调试和对 VS Code 的语言支持，由 cweijan 的 AutoHotkey Plus 的 Mark Wiemer 分叉

### GUI WYSIWYG Builders
* [Adventure (formerly AutoGUI)](https://www.autohotkey.com/boards/viewtopic.php?f=64&t=89901) - 经过 [Alguimist](https://autohotkey.com/boards/memberlist.php?mode=viewprofile&u=64723) - 所见即所得的 GUI 设计器和脚本编辑器.
* [GUI Creator (formerly Basic GUI Creator)](https://autohotkey.com/boards/viewtopic.php?f=6&t=303) - AutoHotkey 的所见即所得 GUI 创建器.
* [MagicBox](https://autohotkey.com/boards/viewtopic.php?p=100953#p100953) - 经过 [Alguimist](https://autohotkey.com/boards/memberlist.php?mode=viewprofile&u=64723)  - MagicBox 是一个帮助创建消息框的开发工具. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?p=100953#p100953).

### Script Recorders and Writers
* [Pulover’s Macro Creator](http://www.macrocreator.com/)  - 免费的自动化工具和脚本生成器. 推荐给初学者. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=143) .  GitHub [link](https://github.com/Pulover/PuloversMacroCreator).

### Web Syntax Highlighters
* [highlight.js](https://highlightjs.org/) - 用 Ja​​vaScript 编写的语法荧光笔，支持 130 多种语言（包括 AutoHotkey）.
* [PrismJs](https://autohotkey.com/boards/viewtopic.php?f=22&t=3942) - 轻量级最小 AutoHotkey 语法突出显示.
* [Syntax Highlighter](https://github.com/aviaryan/highlighter-ahk-zenburn) - AutoHotkey 的旧版语法荧光笔，默认支持行号.

### <a name="tools-others"></a>Others
* [GoTo](https://autohotkey.com/board/topic/95009-) - 适用于任何文本编辑器的插件，可帮助您跳转到活动文件中的标签、热键、热字串和函数.
* [GoToTilla](https://gist.github.com/hoppfrosch/4b4943b1311fd6a92f02) - 允许跳转到 AHK 源代码中的标记的插件.
* [Context sensitive help in any editor](https://autohotkey.com/board/topic/94493-) - 任何文本编辑器的插件，通过按 F1 提供上下文相关的帮助.
* [CodeQuickTester](https://autohotkey.com/boards/viewtopic.php?f=6&t=6113) - GeekDude - 轻量级动态代码测试器.
* [iWB2 Learner](https://sourceforge.net/projects/ahkcn/files/Recommended/iWB2%20Learner/)  - by jethrow - iWB2 Learner 是一个用于收集有关 Internet Explorer 网页信息的工具. 论坛主题： [link](https://autohotkey.com/board/topic/84258-iwb2-learner-iwebbrowser2/)
* [AHK-EXE-Swapper](https://autohotkey.com/boards/viewtopic.php?f=6&t=6310)  - by evilC - 快速更换 AHK 版本！ 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=6310).
* [AEI](https://github.com/joedf/AEI.ahk)  - 由 joedf - 显示 AutoHotkey 环境信息和 AHK 支持相关的系统信息，带有一个花哨的更新检查器，可以自动下载进度条. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=5825).
* [WinSpy](https://autohotkey.com/boards/viewtopic.php?f=6&t=28220) - 由 Alguimist - 用 AHK 编写的有用的窗口间谍/信息工具.

### (Use in) other programming languages
* [AutoHotkey.dll](https://hotkeyit.github.io/v2/docs/AutoHotkeyDll.htm) - 的一部分 [AutoHotkey_H](#autohotkey_h) 分配. 从您的其他语言加载 autohotkey.dll，并将正常的 AHK 代码传递给 dll 文件以供执行. 请参阅此处以获取列表 [exported functions](https://hotkeyit.github.io/v2/docs/AHKH_Features.htm) . 一些较旧的链接： [python example](https://autohotkey.com/board/topic/56938-simple-python-intergration-example/), [c/c++ example](https://autohotkey.com/board/topic/39588-autohotkeydll/://autohotkey.com/board/topic/39588-autohotkeydll/page-10?&#entry321945), [forum link](https://autohotkey.com/board/topic/39588-autohotkeydll/)
* [.NET Framework Interop (CLR, C#, VB)](https://dl.dropbox.com/u/20532918/Lib/CLR-1.2.zip) - Forum thread: [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=4633).
* [ActiveScript - Host VBScript and JScript in-process](https://autohotkey.com/boards/viewtopic.php?f=6&t=4555) - 为 VBScript 和 JScript 等活动脚本语言提供接口，而不依赖 Microsoft 的 ScriptControl，它不适用于 64 位程序.
* [Exo-Javascript](https://github.com/Aurelain/Exo) - 用 Ja​​vaScript 编写 AHK - 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=5714), Exo-CLI (Interactive Command-line) [link](https://github.com/joedf/Exo-CLI.ahk).
* [LibLua](https://autohotkey.com/board/topic/40690-ahk-lua-interop-stdlib-proof-of-concept/) - *Note: lua.ahk and lua_ahkfunctions.ahk can be found [here](https://code.google.com/archive/p/wow-vending-machine/source)*.
* [Machine code functions: Bit Wizardry](https://autohotkey.com/board/topic/19483-machine-code-functions-bit-wizardry/) - 教程 [link](https://autohotkey.com/boards/viewtopic.php?f=7&t=32), C/C++ 到 MCode Generator 论坛 [link](https://autohotkey.com/boards/viewtopic.php?f=6&t=4642).
* [Embed Perl](http://thomaslauer.com/comp/Calling_Perl_from_AHK_or_AU3) - Forum thread: [link](https://autohotkey.com/board/topic/11249-embedding-perl/).
* [PAHK](https://code.google.com/archive/p/pahk) - Forum thread: [link](https://autohotkey.com/board/topic/89022-pahk-python-package-to-extend-python-with-autohotkey/).
* [PYAHK](https://bitbucket.org/kitsu/pyahk/downloads) - 文档 [link](https://pyahk.readthedocs.io/en/latest/).
* [ahk](https://github.com/spyoungtech/ahk) - AutoHotkey 的 Python 包装器 - 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=63184)
* [AutoHotkey.py](https://github.com/Perlence/AutoHotkey.py) - 用 Python 编写 AutoHotkey 脚本 - 论坛主题： [link](https://www.autohotkey.com/boards/viewtopic.php?f=6&t=86025)

## Tutorials
*有用的 AutoHotkey 教程列表.*

### <a name="tutorials-classes"></a>Classes
* [Classes in AHK, Basic tutorial](https://autohotkey.com/boards/viewtopic.php?f=7&t=6033) - AutoHotkey 类基础教程.
* [Classes in AHK, a Dissection (Advanced)](https://autohotkey.com/boards/viewtopic.php?f=7&t=6177) - AutoHotkey 类高级教程.

### <a name="tutorials-com"></a>COM
* [MS Office COM Basics](https://autohotkey.com/boards/viewtopic.php?f=7&t=8978) - 在 MS Office 中使用 AutoHotkey.

### <a name="tutorials-gui"></a>GUI
* [Use HTML and CSS for your GUIs!](https://autohotkey.com/boards/viewtopic.php?f=7&t=4588) - 使用 HTML 和 CSS 创建 GUI.

### <a name="tutorials-mcode"></a>MCode (machine code)
* [MCode Tutorial](https://autohotkey.com/boards/viewtopic.php?f=7&t=32) - MCode（机器代码）教程.

## Resources
 *有用的 AutoHotkey 资源列表. 与 AutoHotkey 相关的各种网站、文档、指南、视频和文章.*

### Documentation
* [Official documentation](https://autohotkey.com/docs/AutoHotkey.htm)  - 官方更新的 AutoHotkey 文档.  GitHub [link](https://github.com/Lexikos/AutoHotkey_L-Docs).
 
### Books
* [ahkbook](http://ahkscript.github.io/ahkbook/projectinfo.html)  - 一本关于 AutoHotkey 的书（尚未完成）. 论坛主题： [link](https://autohotkey.com/board/topic/73014-ahkbook-a-free-online-book-for-autohotkey/).

### Quick-start guides
* [Official quick start tutorial](https://autohotkey.com/docs/Tutorial.htm)  - 官方快速入门教程 - 最初由 tidbit 编写. 论坛主题： [link](https://autohotkey.com/boards/viewtopic.php?f=7&t=27).

### Websites
* [autohotkey.com](https://autohotkey.com/) - AutoHotkey 脚本语言的官方网站（下载、论坛、文档）.
* [autohotkey.com/foundation](https://autohotkey.com/foundation) - 的官方网页 [AutoHotkey Foundation LLC](https://autohotkey.com/foundation/) ，一家非营利性的LLC（有限责任公司）为此软件成立. 组织证书 (pdf) [link](https://autohotkey.com/certificate_of_organization.pdf).
* [ahkscript GitHub organization](https://github.com/ahkscript) - 官方 ahkscript GitHub 组织.

## Forks
*为核心语言添加新功能的 AHK 分支*

### AutoHotkey_H
* [AutoHotkey_H](https://hotkeyit.github.io/v2/) - AHK_H 为原始 AutoHotkey 添加功能，并使用 NewThread() 函数或 AutoHotkey.dll 提供真正的多线程. [Full list of v1 changes](https://hotkeyit.github.io/v1/docs/AutoHotkey.htm) + [Full list of v2 changes](https://hotkeyit.github.io/v2/docs/AutoHotkey.htm)

## License

[![Creative Commons License](https://licensebuttons.net/l/by/4.0/88x31.png)](http://creativecommons.org/licenses/by/4.0/)

这项工作已获得许可 [Creative Commons Attribution 4.0 International License](http://creativecommons.org/licenses/by/4.0/).
