<div class="github-widget" data-repo="enjalot/algovis"></div>
algovis [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
=======

这是有关算法可视化的项目和链接的集合.

## Projects

* [Setosa](http://setosa.io) 博客（例如： [Gridlock vs. Bottlenecks](http://setosa.io/blog/2014/09/02/gridlock/index.html))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/setosa.png' width='800px'/>](http://setosa.io/blog/2014/09/02/gridlock/index.html)
* [Mathigon](http://world.mathigon.org/) （例子： [Sieve of Eratosthenes](http://world.mathigon.org/Prime_Numbers)） 和 [beta site](http://beta.mathigon.org/)
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/mathigon.png' width='800px'/>](http://world.mathigon.org/Prime_Numbers)
* [Encinographic](http://encinographic.blogspot.com/) 博客（例如： [2D Wave Equation](http://encinographic.blogspot.com/2014/05/sim-class-wave-equation-in-2d.html))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/encinographic.png' width='800px'/>](http://encinographic.blogspot.com/2014/05/sim-class-wave-equation-in-2d.html)
* [Emergent Mind](http://www.emergentmind.com/) 博客（例如： [Perceptrons](http://www.emergentmind.com/the-perceptron))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/emergent_mind.png' width='800px'/>](http://www.emergentmind.com/the-perceptron)
* [The Nature of Code](http://natureofcode.com/book/) 书（例如： [Oscillation](http://natureofcode.com/book/chapter-3-oscillation/))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/the_nature_of_code.png' width='800px'/>](http://natureofcode.com/book/chapter-3-oscillation/)
* [Game Mechanic Explorer](http://gamemechanicexplorer.com/) （例子： [Homing Missiles](http://gamemechanicexplorer.com/#homingmissiles-1))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/game_mechanic_explorer.png' width='800px'/>](http://gamemechanicexplorer.com/#homingmissiles-1)
* [Pixel Shaders](http://pixelshaders.com/proposal/) 图书提案
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/pixel_shaders.png' width='800px'/>](http://pixelshaders.com/proposal/)
* [Probabilistic Models of Computation](https://probmods.org/) 书（例如： [Generative Models](https://probmods.org/chapters/generative-models.html))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/probabilistic_models_of_computation.png' width='800px'/>](https://probmods.org/chapters/02-generative-models.html)
* [Steven Wittens](http://acko.net/) （例子： [How to fold a Julia Fractal](http://acko.net/blog/how-to-fold-a-julia-fractal/) - 单击幻灯片上的箭头）
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/steve_witten.png' width='800px'/>](http://acko.net/blog/how-to-fold-a-julia-fractal/)
* [Red Blob Games](http://www.redblobgames.com/) （例子： [2D Visibility](http://www.redblobgames.com/articles/visibility/))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/red_blob_games.png' width='800px'/>](http://www.redblobgames.com/articles/visibility/)
* [Khan Academy algorithms course](https://www.khanacademy.org/computing/computer-science/algorithms) （例子： [Breadth First Search](https://www.khanacademy.org/computing/computer-science/algorithms/breadth-first-search/a/the-breadth-first-search-algorithm))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/khan_academy.png' width='800px'/>](https://www.khanacademy.org/computing/computer-science/algorithms/breadth-first-search/a/the-breadth-first-search-algorithm)
* [Christopher Olah](https://colah.github.io/) （例子： [Neural Networks, Manifolds, and Topology](https://colah.github.io/posts/2014-03-NN-Manifolds-Topology/))
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/colah.png' width='800px'/>](https://colah.github.io/posts/2014-03-NN-Manifolds-Topology/)
* [Visualgo](https://visualgo.net/en)
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/visualgo.png' width='800px'/>](https://visualgo.net/en)
* [Melkman's Algorithm interactively explained](http://maxgoldste.in/melkman/)
[<img src='https://raw.githubusercontent.com/enjalot/algovis/master/images/melkman.png' width='800px'/>](http://maxgoldste.in/melkman/)

## Libraries & tools

* [Tailspin](http://will.thimbleby.net/algorithms/doku.php) ：运行算法并让可视化检查局部变量的 JS 中的 JS 解释器. 记录历史也允许倒退.
* [Vamonos](http://rosulek.github.io/vamonos/): 算法可视化，向读者显示伪代码和下面的 JS 版本，加上一些有用的小部件来显示伪代码、调用堆栈、数据结构
* [Algomation](http://www.algomation.com/): 算法可视化，使用 JS 生成器在算法执行和浏览器事件循环之间传递控制
* [Algorithm Visualizations](http://www.cs.usfca.edu/~galles/visualization/Algorithms.html)
* [LaTeX2HTML5](http://latex2html5.com/)：在导出为 HTML 时，用交互性注释 LaTeX 图
* [Tangle](http://worrydream.com/Tangle/)


## References

* [Visualizing Algorithms](http://bost.ocks.org/mike/algorithms/)
* [Active Essays on the Web](http://tinlizzie.org/chalkboard/#ActiveEssaysOnTheWeb)
* [Visualizing sorting algorithms](https://corte.si/posts/code/visualisingsorting/index.html) - 认为静态可视化比算法动画更好


## Examples

* [Garbage Collection](http://spin.atomicobject.com/2014/09/03/visualizing-garbage-collection-algorithms/)
* [Spatial Hashing](http://zufallsgenerator.github.io/2014/01/26/visually-comparing-algorithms/)
* [Fourier Image Filtering](http://david.li/filtering/)
* [Fourier Series Visualization](http://bl.ocks.org/jinroh/7524988)
* [The Skyline Problem](https://briangordon.github.io/2014/08/the-skyline-problem.html)
* [Animated Bézier Curves](http://www.jasondavies.com/animated-bezier/)
* [A Primer on Bezier Curves](http://pomax.github.io/bezierinfo/)
* [Sight And Light](http://ncase.me/sight-and-light/)
* [Newton-Raphson Optimization (1D)](http://bl.ocks.org/dannyko/ffe9653768cb80dfc0da)
* [Newton-Raphson Optimization (2D)](http://bl.ocks.org/dannyko/0956c361a6ce22362867)
* [Fisher-Yates Shuffle](http://bost.ocks.org/mike/shuffle/)
* [Tetris in Clojure](http://shaunlebron.github.io/t3tr0s-slides/#0)
* [HyperLogLog for big data distinct values](http://research.neustar.biz/2012/10/25/sketch-of-the-day-hyperloglog-cornerstone-of-a-big-data-infrastructure/)
* [Cave Culling Algorithm in Minecraft](http://tomcc.github.io/2014/08/31/visibility-1.html)
* [Explanation of X11 Servers](http://magcius.github.io/xplain/article/) 有一个在浏览器中运行的 X11 服务器！
* [Manual for rot.js, a roguelike game library](http://ondras.github.io/rot.js/manual/#intro) 使所有示例可在浏览器中编辑和查看
* [ConvNetJS](http://cs.stanford.edu/people/karpathy/convnetjs/) 浏览器中的神经网络示例（示例： [2-layer neural network](http://cs.stanford.edu/people/karpathy/convnetjs/demo/classify2d.html))
