<div class="github-widget" data-repo="svaksha/Julia.jl"></div>
## Julia.jl

[Julia.jl](http://svaksha.github.io/Julia.jl) 聚合和管理 decibans[?](https://github.com/svaksha/Julia.jl/issues/150#issuecomment-483116981)编程知识资源 [Julia](https://github.com/JuliaLang)，一种通用编程语言，可满足高性能数值分析和计算科学的需求.


----

## §1. INDEX <span id="1-INDEX"><span>

+ [AI](https://github.com/svaksha/Julia.jl/blob/master/AI.md) :: 算法、数据挖掘、数据结构、HMM、ML、NLP、...
+ [Actuarial Science](https://github.com/svaksha/Julia.jl/blob/master/ActuarialScience.md) * 与计量经济学、金融等子类别相关的软件.
+ [API](https://github.com/svaksha/Julia.jl/blob/master/API.md) :: 语言 API - C++、Fortran、Go、Java、JavaScript、MATLAB、Perl、Python、R、...
+ [Biology](https://github.com/svaksha/Julia.jl/blob/master/Biology.md)  :: 生物信息学、基因组学、农业、食品科学、医学、基因工程、神经科学等. 阿尔...
+ [Desktop Applications](https://github.com/svaksha/Julia.jl/blob/master/DesktopApplications.md)  :: 前端客户端应用软件，即. 调试器、文档生成器、文字处理器的桌面用户界面、GUI 电子表格等.
+ [DevOps](https://github.com/svaksha/Julia.jl/blob/master/DevOps.md) :: 用于基础架构管理、持续集成 (CI)、持续交付 (CD)、包管理、发布工程 (RE)、发布管理 (RM)、软件配置管理 (SCM)、测试驱动开发、沙盒、功能/单元测试，...质量相关的工具，等等.
+ [Chemistry](https://github.com/svaksha/Julia.jl/blob/master/Chemistry.md) * 分析化学、化学信息学、晶体学、纳米化学、核化学...
+ [Database](https://github.com/svaksha/Julia.jl/blob/master/Database.md) :: NoSQL、RDBMS 和中间件 API.
+ [Data Science](https://github.com/svaksha/Julia.jl/blob/master/DataScience.md) :: OpenData + OpenScience、免费数据集、可重复研究、RDM、临床研究数据、元数据、图书馆数据、计算可重复性等.
+ [Earth Science](https://github.com/svaksha/Julia.jl/blob/master/Earth-Science.md) :: 与制图学、气候学、地球生物学、地球化学、地理学、地理信息学、地质学 、地球物理学 、地球科学/GIS、地球数学、气象学、海洋学等子类别相关的软件...
+ [FileIO](https://github.com/svaksha/Julia.jl/blob/master/FileIO.md) :: 文件 IO（输入/输出）功能和对各种数据类型和文件格式的支持.
+ [Graphics](https://github.com/svaksha/Julia.jl/blob/master/Graphics.md) :: 绘图、图形和其他可视化工具.
+ [i18n-L10n](https://github.com/svaksha/Julia.jl/blob/master/i18n-L10n.md) :: 音译、国际化 (i18n) 和本地化 (L10n)
+ [Machines](https://github.com/svaksha/Julia.jl/blob/master/Machines.md) :: 跨平台硬件软件、机器人技术和其他机器相关软件的 API 库.
+ [Mathematics](https://github.com/svaksha/Julia.jl/blob/master/Mathematics.md) :: 代数、几何……任何与数学相关的内容.
+ [Optimization](https://github.com/svaksha/Julia.jl/blob/master/Optimization.md) :: 数学优化.
+ [Physics](https://github.com/svaksha/Julia.jl/blob/master/Physics.md) :: 与物理相关的 Julia 软件.
+ [Programming Paradigms](https://github.com/svaksha/Julia.jl/blob/master/Programming-Paradigms.md) :: 类型系统、数据类型等中使用的编程范例和语言概念.
+ [Publications](https://github.com/svaksha/Julia.jl/blob/master/Publications.md) * 研究论文（期刊和会议出版物）.
+ [QA](https://github.com/svaksha/Julia.jl/blob/master/QA.md) :: Julia 的质量保证.
+ [Resources](https://github.com/svaksha/Julia.jl/blob/master/Resources.md) :: 社区资源列表、开发链接，包括活动、（非）会议、论坛/聚会组、新闻、博客、食谱、备忘单、IJulia NoteBooks 和其他有用的资源.
+ [Server](https://github.com/svaksha/Julia.jl/blob/master/Server.md) :: HTTP/Web、网络和其他服务器端实用程序...
+ [Space Science](https://github.com/svaksha/Julia.jl/blob/master/Space-Science.md) :: 天文学、成像、行星和 [space science](https://en.wikipedia.org/wiki/Outline_of_space_science) 相关包.
+ [Probability & Statistics](https://github.com/svaksha/Julia.jl/blob/master/Probability-Statistics.md) :: 精算学、金融、经济学、随机、保险统计、运筹学以及基准和优化工具包....
+ [Super Computing](https://github.com/svaksha/Julia.jl/blob/master/Super-Computing.md) :: HPC、分布式计算、云计算、集群计算、网格计算、内核和架构，如 ARM、MIPS、GPU、CUDA 等...
+ [Utilities](https://github.com/svaksha/Julia.jl/blob/master/Utilities.md) :: 适用于桌面的便捷工具包和其他通用实用程序.

 **免责声明：** 作为科学计算场景中的一种新语言，由于添加了新库，它经常处于不断变化的状态，导致频繁更改和页面重新排序. 由于 **Julia.jl** 存储库仅提供了 Julia 软件包的（链接）列表，因此不应将其视为对任何特定软件包在软件质量、技术特性、编码风格/组织等方面的认可...

----

## §2. LICENSE <span id="2-LICENSE"><span>

+ 版权所有 © 2012-现在 [SVAKSHA](http://svaksha.com/pages/Bio), 特此分别获得数据 (ODbL-v1.0+) 和软件 (AGPLv3+) 的双重许可.

## §2.1. AGPLv3 and ODbL <span id="2-1-AGPLv3-and-ODbL"><span>
此 repo 使用多个数据和代码许可证，即. [ODbL](https://opendatacommons.org/licenses/odbl/1-0/) 和 [AGPLv3](http://www.gnu.org/licenses/agpl-3.0.html)

+ 此存储库 (`Julia.jl`) 中的 __data__（Julia 语言知识资源的汇总和策划 decibans）在以下发布 [Open Database License](https://opendatacommons.org/licenses/odbl/1-0/)  (ODbL-v1.0). 开放数据库许可证 (ODbL) 授予任何人共享、创建和调整数据或数据库的自由，并具有许可证中指定的适当的 __credit attribution__ 和 __offer any new work under the same terms__, 以及 __release a public copy if using the new work出于商业目的__.
+ `Julia.jl` 中使用的 __software__ 发布于 [AGPLv3 License](http://www.gnu.org/licenses/agpl-3.0.html)，以及以上，详见 [LICENSE-AGPLv3.md](https://github.com/svaksha/Julia.jl/blob/master/LICENSE-AGPLv3.md) 文件.
+ ALL copies and forks of this work must retain the Copyright, respective Licence files for program code (AGPLv3) and data (ODbL) along with this permission notice in all copies or substantial portions of the new work.

此更改的动机是让人们更容易将此数据重新用作数据库中的知识资源. 例如， [julia-observer](https://juliaobserver.com) 是一个可视化工具，用于浏览从“Julia.jl”、“General”和各种来源中提取数据的包. 通过发布网站代码 [publicly](https://github.com/djsegal/julia_observer) 是关于如何构建或转换数据以使社区受益的示例.

## §2.2. Mirrors <span id="2-2-Mirrors"><span>

+ [Bitbucket](https://bitbucket.org/svaksha/Julia.jl) :: git clone git@bitbucket.org:svaksha/Julia.jl.git
+ [GitLab](https://gitlab.com/svaksha/Julia.jl) :: git clone git@gitlab.com:svaksha/Julia.jl.git

----

## CONTRIBUTE

[Contributions](https://github.com/svaksha/Julia.jl/graphs/contributors) 欢迎以拉取请求 (PR) 的形式添加到 `Julia.jl`. 以下是有关如何提交错误报告 (BR) 和/或 [PR](https://github.com/svaksha/Julia.jl/pulls):


## Guidelines

1. Julia 社区有 [ethical guidelines](http://julialang.org/community/standards/) 旨在尊重版权、许可和归属标准<sup>{1} 和 {2}</sup> ，您在提交要列出的材料时必须遵守这些标准. 此外，如果您发现任何违反这些道德标准的材料（或代码库），请提交错误报告以将其从 `Julia.jl` 中删除.
   + 参考资料：
        + {1} https://github.com/JuliaLang/julialang.github.com/issues/200
        + {2} https://github.com/JuliaLang/julialang.github.com/issues/194
2. __商业链接__：本仓库中几乎所有资源都是免费/自由软件资源，因此为了继续保持“自由”软件精神，请仅提交那些免费且无付费/商业利益的资源. 


## BugReport-PullRequest

 1. 根据主题子部分中的顶级类别页面添加您的链接，按_字母顺序_，并在降价文件中添加注释（如果有）. 在各种类别中创建新的顶级标签之前，请先查看维基百科或其他资源. 如果您无法决定，请通过 BR（而不是 PR ;-)）进行讨论.
2. 在 CLI 中，键入将运行 [scraper](https://github.com/svaksha/Julia.jl/blob/master/src/scrape.jl) . 也提交 `db.csv` 文件.
 3. 对于损坏的链接或过时的信息，提交错误报告（BR），或进行必要的更改并提交 PR. 两者都受欢迎. 请为添加的每个链接或更改提交单独的 PR.
4.对于Documentation和cookbooks，检查它是否与列出的类别相匹配，否则，将其列在 [Resources.md](https://github.com/svaksha/Julia.jl/blob/master/Resources.md) 页.
 5. 对于那些无法使用 git 的人，创建一个 github 帐户，然后在用户界面上创建 `Julia.jl` 仓库. 然后编辑页面 [clicking on the "pencil" icon on the markdown page](https://help.github.com/articles/editing-files-in-your-repository) ，然后点击保存并提交 PR.  Github 是这样做 [automatically in 8 steps](https://help.github.com/articles/editing-files-in-another-user-s-repository).


## Package Status

请注意，这个 repo 列出了过时的和/或在旧版本的 Julia 上工作的包. 这些继续被列为公开可用的，同时希望有人可能希望继续这项工作作为一个分支，因为它与他们的研究或工作保持一致. 这些 [comments](https://github.com/svaksha/Julia.jl/commit/a884fe9e921d57b87d85e970c2f57b8f21025641#commitcomment-15802037) 导致了 [BR discussing](https://github.com/svaksha/Julia.jl/issues/55) 添加元数据标签，使程序员和包用户能够轻松区分处于不同开发阶段的各种 Julia 包的状态. 目前，METADATA 有一个标签系统，但并非所有包作者都使用它，这使得外行用户更难知道包维护是否处于活动状态.

让我们尝试让包作者和核心提交者根据以下标准标记他们的 Julia 包：

在 1 到 5 的范围内（1 = 最低，..5 = 最高），请为您的包裹排名，

 + `Usability`：这个包是否按照它说的那样做？ 很容易弄清楚吗？ 包是否已做好生产准备并得到积极维护（问题/PR 得到及时响应和解决，维护和测试与 Julia 发布周期保持一致）.
 + `Quality` : 包裹有测试吗？ 有很多错误吗？ 你有好的文档吗？ 它可以用于需要及时安全补丁的生产环境吗？
 + `Activity`：第 3 方用户是否应该费心使用您的库，或者它真的只供包作者使用？ 比方说，一个实验性的“一次性玩具回购”，其开发现已被放弃.
 + `License`：您使用哪种软件许可证？ 如果您没有许可证，请注明“无”.


## Stargazers

[![Stargazers over time](https://starchart.cc/svaksha/Julia.jl.svg)](https://starchart.cc/svaksha/Julia.jl)
      
