<div class="github-widget" data-repo="sger/ElixirBooks"></div>
## Awesome Elixir Books [![Build Status](https://github.com/sger/ElixirBooks/actions/workflows/main.yml/badge.svg?branch=main)](https://github.com/sger/ElixirBooks/actions/workflows/main.yml) [![Awesome](https://cdn.jsdelivr.net/gh/sindresorhus/awesome@d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
Contents
====

**Books**
====

**入门书籍**
----

### [Adopting Elixir](https://pragprog.com/titles/tvmelixir/adopting-elixir/)

<img src="https://covers.oreillystatic.com/images/9781680502527/cat.gif" width="180px" title="Elixir logo" />

采用不仅仅是编程.  Elixir 是一种令人兴奋的新语言，但要从头到尾成功地获得您的应用程序，您需要了解的不仅仅是语言. 您需要本书中的案例研究和策略. 了解应用程序整个生命周期的最佳实践，从设计和团队建设到管理利益相关者，再到部署和监控. 超越语法和工具，学习从概念到生产开发 Elixir 应用程序所需的技术.

### [Elixir Cookbook](https://www.packtpub.com/product/elixir-cookbook/9781784397517)

<img src="https://m.media-amazon.com/images/I/81-ZwJtxOJL._AC_UY436_QL65_ML3_.jpg" width="120px"/>

This book is a set of recipes grouped by topic that acts as a good reference to get ideas from or to quickly search for a solution to a problem. You will begin by launching an IEx session and using it to test some ideas. Next, you will perform various operations like loading and compiling modules, inspecting your system, generating a supervised app, and so on. Furthermore, you will be introduced to immutability, working with data structures, performing pattern matching, and using stream modules to generate infinite data sequences. You will learn about everything from joining strings to determining the word frequency in text. With respect to modules and functions, you will also discover how to load code from other modules and use guards and pattern matching in functions.

### [Elixir in Action](https://www.manning.com/books/elixir-in-action)

<img src="https://images.manning.com/255/340/resize/book/5/2e8efb1-9e6f-462c-9487-04eac07ea623/juric.png" width="120px"/>

 Elixir in Action 教你如何使用 Elixir 解决可伸缩性、并发性、容错性和高可用性等实际问题. 您将从语言开始，学习基本结构和构建块. 然后，您将学习使用 Elixir 的函数式编程思维方式来思考问题. 有了这个坚实的基础，您将自信地探索 Elixir 与 BEAM 和 Erlang 强大的 OTP 框架的无缝集成，这些框架经过实战检验，您可以立即使用. 最后，本书提供了有关如何在多台机器上分发系统并在生产中对其进行控制的指南.

### [Elixir succinctly](https://www.syncfusion.com/succinctly-free-ebooks/elixir-succinctly) *Free* 

<img src="https://cdn.syncfusion.com/content/images/downloads/ebook/ebook-cover/elixir-succinctly.png" width="120px"/>

这是一本关于 Elixir 和 OTP 的入门书，开门见山. 学习语言和平台的近 100 页.

### [Études for Elixir](https://www.oreilly.com/library/view/etudes-for-elixir/9781491917640/) *Free*

<img src="https://learning.oreilly.com/library/cover/9781491917640/250w/" width="120px"/>

在本书中，您将找到可以用 Elixir 编写的程序的描述. 这些程序通常很短，每个程序都旨在为特定的 Elixir 编程概念提供练习材料. 这些程序的设计难度并不大，尽管它们可能会要求您扩展一些内容，超出您在《Elixir 简介》一书中找到的直接材料和示例.

### [Getting Started](https://elixir-lang.org/getting-started/introduction.html) *Free*

<img src="https://elixir-lang.org/images/logo/logo.png" width="180px" title="Elixir logo" />

 Elixir 官方入门指南将带您了解语言基础. 您还将探索如何使用 Mix 和 OTP 构建项目，并将向您介绍更高级的技术，例如元编程.

### [Introducing Elixir](https://www.oreilly.com/library/view/introducing-elixir/9781449369989/)

<img src="https://learning.oreilly.com/library/cover/9781449369989/250w/" width="120px"/>

如果你想学习函数式编程，Elixir 是一门优秀的语言，通过这个动手介绍，你会发现 Elixir 有多么强大和有趣. 这种语言结合了 Erlang 强大的函数式编程和类似于 Ruby 的语法，并包含强大的元编程功能.

### [Learn Functional Programming with Elixir](https://pragprog.com/search/?q=learn-functional-programming-with-elixir)

<img src="http://t3.gstatic.com/images?q=tbn:ANd9GcSKqtSJPiXGRxX140Y-BAXI7Bt7ja9965hL_Xo4CVVBbrVNOlbm" width="120px"/>

 Elixir 的直截了当的语法和这个导览为您提供了一个干净、简单的学习现代函数式编程技术的途径. 不需要以前的函数式编程经验！ 当您探索不可变值和显式数据转换、函数、模块、递归函数、模式匹配、高阶函数、多态性和故障处理时，本书会以正确的速度引导您了解正确的概念，同时避免副作用.

### [Learn You Some Erlang for Great Good](https://learnyousomeerlang.com/)

<img src="https://nostarch.com/sites/default/files/imagecache/product_main_page/erlang_newsmall.png" width="120px"/>

嘿！ 这是给你学习一些 Erlang 的好方法！ 如果您有一些编程经验并且不太熟悉函数式编程，那么本书适合您. 如果你太擅长它，它仍然有用，因为我们会逐步进入越来越高级的主题.

### [Learning Elixir](https://www.packtpub.com/product/learning-elixir/9781785881749)

<img src="https://static.packt-cdn.com/products/9781785881749/cover/smaller" width="120px"/>

 Elixir 基于 Erlang 的虚拟机和生态系统，可以更轻松地实现开发人员使用任何编程语言或编程范式所追求的可扩展性、并发性、容错性和高可用性目标.  Elixir 是一种现代编程语言，它利用了 Erlang VM 提供的优势，而没有真正融入 Erlang 的复杂语法.

### [Programming Elixir ≥ 1.6](https://pragprog.com/titles/elixir16/programming-elixir-1-6/)

<img src="https://pragprog.com/titles/elixir16/programming-elixir-1-6/elixir16_hu6d5b8b63a4954cb696e89b39f929331b_1496817_500x0_resize_q75_box.jpg" width="120px"/>

本书是为经验丰富的程序员介绍 Elixir 的，针对 Elixir 1.6 及更高版本进行了全面更新. 探索没有学术色彩的函数式编程（再给我讲讲 monad）. 创建并发应用程序，但在没有所有锁定和一致性问题的情况下正确处理它们. 认识 Elixir，这是一种现代的、函数式的并发语言，它建立在坚如磐石的 Erlang VM 之上.  Elixir 的实用语法和对元编程的内置支持将使您提高工作效率并让您长期保持兴趣. 也许是下一件大事的时机. 也许是长生不老药.

### [The Little Elixir & OTP Guidebook](https://www.manning.com/books/the-little-elixir-and-otp-guidebook)

<img src="https://images.manning.com/255/340/resize/book/2/cf70537-0068-4d76-b254-3082c3bc12a3/TanWeiHao_final.png" width="120px"/>

 Little Elixir &amp; OTP Guidebook 让您开始使用 Elixir 和 OTP 编写应用程序. 您将从 Elixir 语言语法的快速概述开始，以及足以有效使用它的函数式编程. 然后，您将直接深入了解 OTP，并通过几个有趣的示例了解它如何帮助您构建可扩展、容错和分布式的应用程序. 来重新发现使用 Elixir 编程的乐趣，并记住再次成为初学者的感觉.

### [The Ultimate Guide For Making the Jump To Elixir](https://www.amazon.com/Ultimate-Guide-Making-Jump-Elixir-ebook/dp/B07DH4G7X2)

<img src="https://images-na.ssl-images-amazon.com/images/I/51Ipbs%2BRkOL.jpg" width="120px"/>

想学习一门新兴的函数式编程语言吗？ 查看由 Ruby on Rails 核心团队成员 Jose Valim 设计的 Elixir. 如果您有一份全职工作、一个家庭或其他紧迫的任务，那么每周抽出几个小时来阅读博客文章或花时间为开源做出贡献可能对您来说是一个交易破坏者. 这本书可以帮助您快速了解您需要了解的内容.


**进阶书籍**
---

### [Building Scalable Applications with Erlang](https://www.abebooks.com/9780321636461/Building-Scalable-Applications-Erlang-Developers-0321636465/plp)

<img src="https://pictures.abebooks.com/isbn/9780321636461-us.jpg" width="120px"/>

Erlang is emerging as a leading language for concurrent programming in mission-critical enterprise environments where applications must deliver exceptional reliability, availability, and scalability. It’s already used by organizations ranging from Facebook to Amazon, and many others are adopting or considering it.
As a functional language, however, Erlang is radically different from conventional object-oriented languages like C++ and Java. This book quickly brings experienced object-oriented programmers up to speed with both Erlang and the principles of functional programming. Jerry Jackson thoroughly explains Erlang’s key concepts, principles, and features, bridging the conceptual gaps that often frustrate object developers. Next, he shows how to use Erlang to build massively-scalable real-world systems with up to “nine nines” availability: that is, up to 99.9999999% uptime.

### [Craft GraphQL APIs in Elixir with Absinthe](https://pragprog.com/titles/wwgraphql/craft-graphql-apis-in-elixir-with-absinthe/)

<img src="https://pragprog.com/titles/wwgraphql/craft-graphql-apis-in-elixir-with-absinthe/wwgraphql_hu6d5b8b63a4954cb696e89b39f929331b_360248_500x0_resize_q75_box.jpg" width="120px"/>

您的领域丰富且相互关联，您的 API 也应该如此. 将您的 Web API 升级到 GraphQL，利用其灵活的查询来增强您的用户能力，并利用其声明性结构来简化您的代码.  Absinthe 是 Elixir 的 GraphQL 工具包，Elixir 是一种函数式编程语言，旨在在健壮的应用程序架构上实现大规模并发. 本书由 Absinthe 的创建者编写，将帮助您充分利用这两项突破性技术. 使用其他任何地方都找不到的分步指导和专家建议，构建您自己的灵活、高性能的 API.

### [Designing Elixir Systems with OTP](https://pragprog.com/titles/jgotp/designing-elixir-systems-with-otp/)

<img src="https://pragprog.com/titles/jgotp/designing-elixir-systems-with-otp/jgotp_hu6d5b8b63a4954cb696e89b39f929331b_938959_500x0_resize_q75_box.jpg" width="120px"/>

你知道如何在 Elixir 中编码； 现在学会在其中思考. 学习设计具有智能层的库，形成正确的数据结构，从一个功能流入下一个功能，并提供正确的 API. 采用相同的 OTP，它使我们的电话系统在 30 多年里保持可靠和快速. 超越理解 OTP 功能，了解幕后发生的事情，以及为什么这很重要. 使用这些知识，本能地知道如何设计系统，为您的用户提供快速和有弹性的服务，所有这些都以 Elixir 为重点.

### [Designing for Scalability with Erlang/OTP](https://www.oreilly.com/library/view/designing-for-scalability/9781449361556/)

<img src="https://learning.oreilly.com/library/cover/9781449361556/250w/" width="120px"/>

如果您需要构建具有高可用性要求的可扩展、容错系统，请了解为什么 Erlang/OTP 平台因其功能的广度、深度和一致性而脱颖而出. 本实践指南演示了如何使用 Erlang 编程语言及其可重用库、工具和设计原则的 OTP 框架来开发复杂的商业级系统，这些系统绝对不会失败.

### [Erlang and Elixir for Imperative Programmers](https://www.amazon.com/Erlang-Elixir-Imperative-Programmers-Wolfgang/dp/1484223934)

<img src="https://media.springernature.com/full/springer-static/cover-hires/book/978-1-4842-2394-9?as=webp" width="120px"/>

学习和理解 Erlang 和 Elixir，并掌握支撑它们的函数式编程概念的应用知识. 本书以作者承担一个需要函数式编程和实时系统的项目的经验为基础，对其进行了分解和组织. 您将获得有关您所知道的语言的差异、从哪里开始以及下一步要去哪里的必要知识.

### [Erlang and OTP in Action](https://www.manning.com/books/erlang-and-otp-in-action)

<img src="https://images.manning.com/255/340/resize/book/f/d21069b-7a05-4be7-bcd8-7d38aff03e34/logan.png" width="120px"/>

 Erlang 和 OTP in Action 教您并发编程的概念和 Erlang 的消息传递模型的使用. 它逐步引导您完成更有趣的示例，在 Erlang 中构建系统并将它们与 C/C++、Java 和 .NET 应用程序（包括 SOA 和 Web 架构）集成.

### [Erlang In Anger](http://www.erlang-in-anger.com/)

<img src="https://s3.us-east-2.amazonaws.com/ferd.erlang-in-anger/book-cover.png" width="120px"/>

这本书旨在成为一个关于如何在战争时期成为 Erlang 军医的小指南. 它首先是一个提示和技巧的集合，可帮助理解失败的根源，以及不同代码片段和实践的字典，可帮助开发人员调试使用 Erlang 构建的生产系统.

### [Mastering Elixir](https://www.packtpub.com/product/mastering-elixir/9781788472678)

<img src="https://static.packt-cdn.com/products/9781788472678/cover/smaller" width="120px"/>

在本书中，您将学习如何在 Erlang 的 OTP 和使用 Elixir 自己的抽象之上构建坚如磐石的文件托管服务，从而使您能够构建易于并行化和分发的应用程序. 您将使用 GenStage 处理文件上传，然后通过实施 DSL 来简化它. 您将使用 Phoenix 向全世界公开您的应用程序. 完成实施后，您将学习如何将您的应用程序带到云端，使用 Kubernetes 自动部署、扩展和管理它. 最后但并非最不重要的一点是，您可以通过学习如何彻底测试并在应用程序上线时对其进行监控来保持内心的平静.

### [Metaprogramming Elixir](https://pragprog.com/titles/cmelixir/metaprogramming-elixir/)

<img src="https://pragprog.com/titles/cmelixir/metaprogramming-elixir/cmelixir_hu6d5b8b63a4954cb696e89b39f929331b_1494046_500x0_resize_q75_box.jpg" width="120px"/>

使用 Elixir 宏编写代码. 宏使元编程成为可能，并定义了语言本身. 在本书中，您将学习如何使用宏以快速、可维护的代码扩展语言，并以您从未想过的方式共享功能. 您将发现如何使用您自己的一流功能扩展 Elixir、优化性能并创建特定于领域的语言.

### [Programming Erlang](https://pragprog.com/titles/jaerlang2/programming-erlang-2nd-edition/)

<img src="https://pragprog.com/titles/jaerlang2/programming-erlang-2nd-edition/jaerlang2_hu6d6484fd7d993fffccac9fd34a29e94f_1016144_500x0_resize_q75_box.jpg" width="120px"/>

一个多用户游戏、网站、云应用程序或网络数据库可以有成千上万的用户同时进行交互. 您需要一个强大的、具有工业强度的工具来处理并行、并发环境中固有的真正困难的问题. 你需要二郎. 在畅销书 Programming Erlang 的第二版中，您将学习如何编写可在多核系统上轻松扩展的并行程序.

### [Property-Based Testing with PropEr, Erlang, and Elixir](https://pragprog.com/titles/fhproper/property-based-testing-with-proper-erlang-and-elixir/)

<img src="https://pragprog.com/titles/fhproper/property-based-testing-with-proper-erlang-and-elixir/fhproper_hu6d5b8b63a4954cb696e89b39f929331b_998569_500x0_resize_q75_box.jpg" width="120px"/>

基于属性的测试可以帮助您用很少的代码创建更好、更可靠的测试. 通过在 Erlang 和 Elixir 中使用 PropEr 框架，本书将教您如何自动生成测试用例、测试有状态程序，并改变您设计软件的方式以获得更有原则和更可靠的方法. 您将能够更好地探索问题空间，验证您在提出程序行为时所做的假设，并暴露您设计中意想不到的弱点.  PropEr 甚至会向您展示如何重现它发现的错误. 通过本书，您将很快编写出高效的基于属性的测试.

### [Hands-on Elixir & OTP: Cryptocurrency trading bot](https://elixircryptobot.com/) *Free*

<img src="https://raw.githubusercontent.com/Cinderella-Man/hands-on-elixir-and-otp-cryptocurrency-trading-bot/main/images/cover.png" width="120px"/>

想通过创建真实世界的项目来学习 Elixir 和 OTP？ 借助 Hands-on Elixir &amp; OTP: Cryptocurrency trading bot，您将通过从事有趣的软件项目获得实践经验. 我们将通过迭代实施改进探索所有关键抽象和基本原则.

**Web开发**
---

### [Building Web Applications with Erlang](https://www.oreilly.com/library/view/building-web-applications/9781449320621/)

<img src="https://learning.oreilly.com/library/cover/9781449320621/250w/" width="120px"/>

为什么选择 Erlang 作为 Web 应用程序？ 通过使用本书构建一个简单的 Web 服务来亲身体验答案. 如果您是一位了解基本 Erlang 的经验丰富的 Web 开发人员，您将通过几个示例了解如何使用 REST、动态内容、Web 套接字和并发性. 在此过程中，您将亲眼目睹 Erlang 是构建关键业务服务的理想之选.

### [Elixir and Elm Tutorial](https://leanpub.com/elixir-elm-tutorial)

<img src="https://s3.amazonaws.com/titlepages.leanpub.com/elixir-elm-tutorial/hero?1518079280" width="120px"/>

欢迎来到函数式 Web 编程的世界！ 在本书中，我们将学习如何创建有趣、可扩展且可维护的 Web 应用程序. 我们将使用 Elixir 和 Elm 等新兴语言的最新创意来打造有趣的体验. 与其专注于理论，我们将采用实用的方法并构建一个真实世界的应用程序.

### [Functional Web Development with Elixir, OTP, and Phoenix](https://pragprog.com/titles/lhelph/functional-web-development-with-elixir-otp-and-phoenix/)

<img src="https://pragprog.com/titles/lhelph/functional-web-development-with-elixir-otp-and-phoenix/lhelph_hu6d5b8b63a4954cb696e89b39f929331b_345845_500x0_resize_q75_box.jpg" width="120px"/>

 Elixir 和 Phoenix 作为构建现代 Web 应用程序的无与伦比的平台正在引起极大的兴奋. 在使用 Elixir 和 OTP 构建有状态 Web 应用程序时充分利用它们. 没有 ORM 或数据库的模型域实体. 使用 OTP 行为管理服务器状态并保持代码清洁. 在 Phoenix Web 界面上分层，而不将其与业务逻辑耦合. 打开通向强大新技术的大门，让您以全新的方式思考 Web 开发.

### [Phoenix in Action](https://www.manning.com/books/phoenix-in-action)

<img src="https://images-na.ssl-images-amazon.com/images/I/41V2OUmPO8L._SX397_BO1,204,203,200_.jpg" width="120px"/>

 Phoenix 是为 Elixir 编程语言构建的现代 Web 框架.  Phoenix 优雅、容错且高性能，与 Rails 一样易于使用，与 Elixir 的基于 Erlang 的基础一样坚如磐石.  Phoenix in Action 以您现有的 Web 开发技能为基础，教您 Phoenix 的独特优势以及足够的 Elixir 来完成工作.

### [Programming Ecto](https://pragprog.com/titles/wmecto/programming-ecto/)

<img src="https://m.media-amazon.com/images/I/81U41AFtHeL._AC_UY218_SEARCH213888_ML3_.jpg" width="120px"/>

语言可能会来来去去，但关系数据库会长存. 了解如何使用 Ecto（Elixir 的主要数据库库）将您的 Elixir 和 Phoenix 应用程序连接到数据库. 通过逐个模块地了解 Ecto 的关键部分，牢牢掌握 Ecto 的基础知识. 然后继续学习更高级的主题和最佳实践建议，以及一系列针对应用程序开发人员经常遇到的场景提供清晰、分步说明的秘诀. 该书由 Ecto 的创建者合着，提供了有效使用 Ecto 所需的所有要素.

### [Programming Phoenix](https://pragprog.com/titles/phoenix14/programming-phoenix-1-4/)

<img src="http://ecx.images-amazon.com/images/I/41pPn50VnvL._SX415_BO1,204,203,200_.jpg" width="120px"/>

不要接受快速和美观之间的妥协：你可以拥有一切.  Phoenix 的创建者 Chris McCord、Elixir 的创建者 José Valim 和获奖作家 Bruce Tate 将带您构建快速可靠的应用程序. 在每一步，您不仅会从 Phoenix 的创作者那里学到要做什么，还会学到为什么要这样做. 在您构建下一代 Web 应用程序的过程中，这本权威指南充满了内部人士的见解，将成为您从 Phoenix 新手到专家的旅程中的忠实伴侣.

### [Real-Time Phoenix](https://pragprog.com/titles/sbsockets/real-time-phoenix/)

<img src="https://m.media-amazon.com/images/I/81zoKXoKFbL._AC_UY436_QL65_ML3_.jpg" width="120px"/>

通过使用 Elixir 和 Phoenix Channels 构建可立即对变化做出反应并反映应用程序真实状态的应用程序，为用户提供他们期望的实时体验. 了解 Elixir 和 Phoenix 如何让创建可扩展到大量用户的实时应用程序变得轻松愉快. 应用系统设计和开发最佳实践来创建易于维护的应用程序. 通过学习如何抢在用户之前破坏您的应用程序来获得信心. 以最小化资源使用和最大化性能部署应用程序.

### [Testing Elixir](https://pragprog.com/titles/lmelixir/testing-elixir/)

<img src="https://pragprog.com/titles/lmelixir/testing-elixir/lmelixir-500.jpg" width="120px"/>

 Elixir 提供了新的范例，并挑战您以非常规的方式进行测试. 从 ExUnit 开始：编写测试所需的几乎所有内容，涵盖从单元到集成的所有细节级别，但前提是您知道如何最充分地使用它——我们将向您展示如何使用. 探索测试特定于 Elixir 的挑战，例如基于 OTP 的模块、异步代码、基于 Ecto 的应用程序和 Phoenix 应用程序. 探索新工具，例如用于模拟的 Mox 和用于基于属性的测试的 StreamData. 有了这些知识，您就可以创建测试套件，为您的生产周期增加价值并保护您免受回归.

### [Exploring Graphs with Elixir](https://pragprog.com/titles/thgraphs/exploring-graphs-with-elixir/)

<img src="https://pragprog.com/titles/thgraphs/exploring-graphs-with-elixir/thgraphs-beta-500.jpg" width="120px"/>

数据无处不在——只是没有很好地连接，这使得将数据集与数据集关联起来变得非常困难. 使用图形作为底层粘合剂，您可以轻松地将数据连接在一起并创建跨不同数据集的导航路径. 添加 Elixir，它具有强大的并发能力，您很快就会掌握数据网络. 了解如何从 Elixir 中访问和使用不同的图形模型，以及如何在图形数据结构之上构建强大的语义覆盖. 我们将从基础开始，检查主要的图形范例. 准备好迎接互联数据的世界吧！

### [Genetic Algorithms in Elixir](https://pragprog.com/titles/smgaelixir/genetic-algorithms-in-elixir/)

<img src="https://pragprog.com/titles/smgaelixir/genetic-algorithms-in-elixir/smgaelixir-500.jpg" width="120px"/>

从金融到人工智能，遗传算法是一种具有广泛应用的强大工具. 但是您不需要一种奇特的新语言或框架来开始； 你可以用你已经熟悉的语言学习遗传算法. 加入我们，深入了解编写遗传算法的算法、技术和方法. 从介绍性问题到实际应用，您将学习使用遗传算法解决问题的基本原理.

### [Programmer Passport: Elixir](https://pragprog.com/titles/passelixir/programmer-passport-elixir/)

<img src="https://pragprog.com/titles/passelixir/programmer-passport-elixir/passelixir-500.jpg" width="120px"/>

 Elixir 是一种跨越许多界限的函数式语言.  Elixir 大量借鉴了 Ruby 的语法、Erlang BEAM 上的运行时、类似 Lisp 的宏系统以及您可能在 Haskell 中找到的流式库，Elixir 从许多环境中汲取了最佳特性.  Elixir 借鉴了 Erlang 的“Let It Crash”哲学，并在结构、一流的卫生宏和协议等抽象方面进行了重大改进. 其中许多想法都是从其他社区借来的，它们对语言的采用产生了很大的影响. 本书带您快速浏览 Elixir 的迷人世界！

### [Build a Binary Clock with Elixir and Nerves](https://pragprog.com/titles/thnerves/build-a-binary-clock-with-elixir-and-nerves/)

<img src="https://pragprog.com/titles/thnerves/build-a-binary-clock-with-elixir-and-nerves/thnerves-500.jpg" width="120px"/>

想要更好地编写 Elixir 代码？ 使用 Nerves 编写一个硬件项目. 在构建此二进制时钟时，您将使用 OTP 构建弹性，许多商业电话交换机使用相同的库. 您将使用分层方法，像专家一样解决复杂问题. 您将通过朝着您的目标采取易于验证的小步骤来提高您的调试技能. 完成后，您将拥有一个可用的二进制时钟，并对硬件系统所做的工作有一个很好的认识. 您还可以将这种理解应用到您编写的每一行新的 Elixir 中.

### [Build a Weather Station with Elixir and Nerves](https://pragprog.com/titles/passweather/build-a-weather-station-with-elixir-and-nerves/)

<img src="https://pragprog.com/titles/passweather/build-a-weather-station-with-elixir-and-nerves/passweather-500.jpg" width="120px"/>

 Elixir 编程语言已成为创建可靠、容错且健壮的服务器端应用程序的首选工具. 多亏了 Nerves，这些相同的好处可以在嵌入式应用程序中实现. 本书将教您如何构建、构建生产级 Nerves 应用程序并将其部署到支持网络的设备. 您将要着手的气象站传感器中心项目将向您展示如何在创纪录的时间内创建一个完整的堆栈 IoT 解决方案. 您将构建从嵌入式 Nerves 设备到 Phoenix 后端甚至 Grafana 时间序列数据可视化的所有内容.

### [Concurrent Data Processing in Elixir](https://pragprog.com/titles/sgdpelixir/concurrent-data-processing-in-elixir/)

<img src="https://pragprog.com/titles/sgdpelixir/concurrent-data-processing-in-elixir/sgdpelixir-500.jpg" width="120px"/>

了解在 Elixir 中编写并发代码的不同方法，并在不牺牲可伸缩性或容错性的情况下提高应用程序的性能. 大多数项目受益于同时运行后台任务和处理数据，但 OTP 和各种库的世界可能具有挑战性. 使用哪个 Supervisor 和什么策略？  GenServer 呢？ 也许您需要背压，但 GenStage、Flow 或 Broadway 是更好的选择吗？ 您将学习回答这些问题所需的一切知识，立即开始构建高度并发的应用程序，并编写不仅速度快，而且对错误具有弹性且易于扩展的代码.

### [Programming Phoenix LiveView](https://pragprog.com/titles/liveview/programming-phoenix-liveview/)

<img src="https://pragprog.com/titles/liveview/programming-phoenix-liveview/liveview-beta-500.jpg" width="120px"/>

传统的请求-响应 Web 应用程序的时代已经一去不复返了，但您不必跋涉在 JavaScript 的海洋中来构建当今用户渴望的交互式应用程序. 创新的 Phoenix LiveView 库使您能够构建快速且高度交互的应用程序，而不会牺牲可靠性. 这份 LiveView 权威指南不是参考手册. 学习在 LiveView 中思考. 按照专家的方式逐层编写代码. 与经验丰富的老师一起探索技巧，以获得最佳表现.

**Resources**
====
* [Joe Armstrong - A week with Elixir](https://joearms.github.io/published/2013-05-31-a-week-with-elixir.html)
* [Elixir Sips](http://elixirsips.com)
* [LearnElixir.tv](https://www.learnelixir.tv/)
* [Reddit](https://www.reddit.com/r/elixir/)
* [Stack Overflow](https://stackoverflow.com/questions/tagged/elixir)
* [Exercism.io](https://exercism.org/tracks/elixir)
* [Elixir Radar Newsletter](https://elixir-radar.com)
* [Elixir Koans](http://elixirkoans.io)
* [Awesome Elixir](https://github.com/h4cc/awesome-elixir)
* [Discover Elixir & Phoenix](https://ludu.co/course/discover-elixir-phoenix/)
* [Elixir School](https://elixirschool.com/en)
* [Elixir for Programmers](https://codestool.coding-gnome.com/courses/elixir-for-programmers)

Contributing
====
随时欢迎您的贡献，请关注 [the rules](https://github.com/sger/ElixirBooks/blob/main/CONTRIBUTING.md)!

License
====
本作品根据<a rel="license" href="https://creativecommons.org/licenses/by/4.0/">Creative Commons Attribution 4.0 International License</a>获得许可.
