<div class="github-widget" data-repo="Siddharth11/Colorful"></div>
<p align="center">
	<img src="https://raw.githubusercontent.com/Siddharth11/Colorful/master/color-palette.gif" alt="header image">
</p>

## Colorful [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
__A curated list of awesome resources to choose your next color scheme.__
Inspired by the __[awesome](https://github.com/sindresorhus/awesome)__ list. Please read the __[contribution guidelines](https://github.com/Siddharth11/Colorful/blob/master/contributing.md)__ before contributing.


## Tools

#### Libraries
- [Chroma.js](http://gka.github.io/chroma.js/) - JavaScript library for dealing with colors.
- [pigment](https://github.com/satya164/pigment) - Color information, conversion and manipulation library
- [GradStop.js](https://github.com/Siddharth11/gradStop.js) - Generate gradient color stops.
- [Adaptive Backgrounds](https://briangonzalez.github.io/jquery.adaptive-backgrounds.js/) - Extract dominant colors from images and apply to its parent (jQuery Plugin).
- [Coloor](https://github.com/krasimir/coloor) - Image preloading utility.
- [Color Thief](https://github.com/lokesh/color-thief) - Grab color palette from an image.
- [Colorify.js](https://github.com/LukyVj/Colorify.js) - Simple, customizable, tiny JavaScript color extractor.
- [Colofilter.css](https://github.com/LukyVj/colofilter.css) - Duotone filters made with CSS.
- [Polychrome](https://github.com/cdonohue/polychrome) - A small library for parsing and manipulating colors.
- [Palettable](https://github.com/jiffyclub/palettable) - Palettable (formerly brewer2mpl) is a library of color palettes for Python
- [picocli](http://picocli.info/) - Small library for creating Java command line applications with ANSI colors and styles.
- [granim.js](https://github.com/sarcadass/granim.js) - Create fluid and interactive gradient animations.
- [tinygradient](https://github.com/mistic100/tinygradient) - Fast and small gradients manipulation.
- [TinyColor](https://github.com/bgrins/TinyColor) - Fast, small color manipulation and conversion for JavaScript.
- [Distinct Colors](https://github.com/internalfx/distinct-colors) - Generate a palette of visually distinct colors.
- [color2k](https://github.com/ricokahler/color2k) - A color parsing and manipulation lib.

#### Web App
- [Color Picker for Data](http://tristen.ca/hcl-picker/) - Hold chroma constant and pick your palette with ease.
- [Colorbrewer2](http://colorbrewer2.org/) - Multi-hue and single-hue palettes for heat maps and data visualization.
- [Coolors](https://coolors.co/) - Generate infinite color palettes for your designs and share.
- [Flat UI Colors](http://flatuicolors.com/) - UI color set.
- [Material Design Colors](http://www.materialui.co/) -  Material Design Colors, Flat UI Colors and Material Design Icons.
- [Palettab](http://palettab.com/) - New color palette and font inspiration with every tab (Chrome Extension).
- [Paletton](http://paletton.com) - The Color Scheme Designer.
- [Adobe Color Wheel](https://color.adobe.com/) - Create color schemes with the color wheel.
- [Drag Gradients](http://elrumordelaluz.github.io/draGGradients/) - Generate and customize multiple css3 radial gradients.
- [SassMe](https://github.com/jimniels/sassme) - Visualize SASS color functions in real-time without compiling.
- [Colourco](http://www.colourco.de/) - Easily and intuitively combine colours.
- [HSL Color Picker](http://hslpicker.com/) - HSL Color Picker.
- [SVG Color Filter Playground](http://kazzkiq.github.io/svg-color-filter/) - Understand how feColorMatrix works.
- [Random A11y](http://www.randoma11y.com) - Generates a random palette that is a11y friendly.
- [Save My Palette](http://savemypalette.com/) - Save, share, and export your color palettes.
- [Colordot](https://color.hailpixel.com) - A color picker for humans.
- [Material Palette](http://www.materialpalette.com/) - Material Design color palette generator.
- [0to255](http://www.0to255.com/) - Find variations of any color.
- [147 Colors](http://147colors.com/) - Learn CSS color names.
- [Shutterstock Spectrum](http://www.shutterstock.com/labs/spectrum/) - Search Images by Color with Spectrum.
- [ColRD](http://colrd.com/) - Create and share color inspiration with the world.
- [Palettable](http://www.palettable.io/) - Generate beautiful color palettes with no prior design knowledge.
- [Colorgorical](http://vrl.cs.brown.edu/color) - Generate a palette with n colors.
- [Color Library](http://colorlibrary.ch/) - Automated Color Separation.
- [ColorFavs](http://www.colorfavs.com/) - Create and Discover Beautiful Color Palettes and Colors.
- [Colormind](http://www.colormind.io/) - Colormind is a color scheme generator that uses deep learning.
- [iColorpalette](https://icolorpalette.com) - Create, browse or export (aco, ase, svg, png, pdf) color palettes by color or themes.
- [geenes](https://geenes.app/) - Create a color scale in seconds, then export it to sketch or code.
- [Tints and Shades](https://maketintsandshades.com/) - Display tints and shades of a given hex color in 10% increments.
- [Sorted colors](https://enes.in/sorted-colors/) - Sorted named CSS colors in a way that it shows related colors together.
- [Croma](https://croma.app) - Generate color palettes from image and colors
- [Hexcolorpedia](https://hexcolorpedia.com/) - Hex color information, Color conversion, Shades, tints, tones, Pantone match, color blending and huge Color palettes collection.
- [Atmos](https://atmos.style/) - Everything you need to create color palettes.
- [AI Color Palette Generator](https://www.loopple.com/color-palette-generator) - Effortlessly Create Stunning Color Schemes
with AI-Powered Palette Generator.
- [Colorca](https://colorca.org/) - Design an accessible color palette for digital products in HSLuv color space
- [ColorBeta](https://colorbeta.com/) - Advanced CSS Gradient Generator.
- [Color Wheel](https://colorwheel.co/) - A color wheel based on the drawings by Goethe, Johann Wolfgang von from the year 1810.
- [RGB HEX Code](https://rgbhexcode.com/) - HTML/CSS Color Picker & Converter.

## Color Palettes
- [ColorHunt](http://colorhunt.co/) - Color palettes with quick preview feature.
- [Swiss Style Color Picker](http://www.swisscolors.net/) - Color palettes collection.
- [UI Gradients](http://uigradients.com/) - Handpicked collection of beautiful colour gradients.
- [Color Hex Palettes](http://www.color-hex.com/color-palettes/) - Discover the new color palettes.
- [Color Palettes](http://colorpalettes.net/) - Decorate your house, flat, bedroom, kitchen, living room and wedding with color ideas.
- [Design Seeds](http://www.design-seeds.com/) - Colors found in nature and the aesthetic of purposeful living.
- [Gradients](http://thewebrocks.com/demos/gradientsio/v2.html) - Curated gradients.
- [Colour Names](http://colours.neilorangepeel.com/) - List of colour names in CSS.
- [BrandColors](http://brandcolors.net/) - Official color codes for the world's biggest brands.
- [Branition Colors](https://branition.com/colors) - Hand-curated collection of color pallets best fitted for branding.
- [Color Lisa](http://www.colorlisa.com/) - Color palette masterpieces of the world’s greatest artists.
- [Cohesive Colors](http://javier.xyz/cohesive-colors/) - A tool to create cohesive color schemes.
- [Colordrop](https://colordrop.io/) - A collection of great looking color palettes.
- [ColorsWall](https://colorswall.com/) - Place to store your color Palettes and generate tool.
- [Open Color](https://yeun.github.io/open-color/) - Colors tested on deuteranopia and protanopia mode.
- [ColorClaim](http://www.vanschneider.com/colors) - Subtle color combinations.
- [WebGradients](https://webgradients.com/) - A free collection of 180 linear gradients.
- [Dave Green's 'cubehelix' colour scheme](http://www.mrao.cam.ac.uk/~dag/CUBEHELIX/) - Resources for the cubehelix family of colour schemes.
- [Color Name List](https://github.com/meodai/color-names/) - Huge curated list of unique color names.
- [Realtime Colors](https://www.realtimecolors.com) - Visualize Your Colors & Fonts On a Real Site.
- [InclusiveColors](https://www.inclusivecolors.com/) - Create custom accessible Tailwind-style color palettes, with WCAG/APCA contrast checks and live previews on a mockup.
- [ColorMagic](https://colormagic.app) - Generate color palettes with AI. Enter any keyword and generate a matching color palette.

## Articles
- [Trendy Web Color Palettes and Material Design Color Schemes & Tools](http://www.awwwards.com/trendy-web-color-palettes-and-material-design-color-schemes-tools.html?utm_source=Twitter&utm_medium=Social&utm_campaign=Twitter-Blog-Color&utm_content=Twitter)
- [How I Work with Color](https://medium.com/@JustinMezzell/how-i-work-with-color-8439c98ae5ed#.b99s3au3w)
- [Color Palette Documentation for Living Style Guides](https://medium.com/@jxnblk/color-palette-documentation-for-living-style-guides-d25d65aa20a5#.q0q6fb5qy)
- [How I Learned About Color Mixing](https://medium.com/@julialundman/my-experiences-in-learning-about-color-6de4ec274503#.m0t57e6ws)
- [The Power of Colour in App Design](https://medium.com/@nicknelo/why-use-colour-branding-in-apps-a95deba49dae#.pj3012j9x)
- [Create Emotion With Color In UX Design](https://uxplanet.org/create-emotion-with-color-in-ux-design-446a3766b085#.g6o0xsyfd)
- [The Principles of UX Choreography](https://medium.com/@becca_u/the-principles-of-ux-choreography-69c91c2cbc2a#.henp1zpjb)
- [How to create a color story](https://medium.com/design-story/how-to-create-a-color-story-aa75a62bf953#.pclx97jsf)
- [The Psychology of Color in Marketing](https://www.helpscout.net/blog/psychology-of-color/)
- [Algorithm for automatic harmonious color selection for the image](https://uxplanet.org/algorithm-for-automatic-harmonious-color-selection-for-the-image-fc26dde69ca1#.5luiehaag)
- [Take color inspiration from the masters](https://medium.com/@WebdesignerDepot/take-color-inspiration-from-the-masters-e9c2bcf1c8e2#.bhc22yxap)
- [Build a Color Scheme: The Fundamentals](http://tympanus.net/codrops/2012/09/17/build-a-color-scheme-the-fundamentals/)
- [Principles of Color and the Color Wheel](http://tympanus.net/codrops/2012/02/28/principles-of-color-and-the-color-wheel/)
- [Color and Emotion: What Does Each Hue Mean?](http://tympanus.net/codrops/2012/04/03/color-and-emotion-what-does-each-hue-mean/)
- [Color Theory for Designers, Part 1: The Meaning of Color](https://www.smashingmagazine.com/2010/01/color-theory-for-designers-part-1-the-meaning-of-color/)
- [A Simple Web Developer’s Guide To Color](https://www.smashingmagazine.com/2016/04/web-developer-guide-color/)
- [Design Accessibly, See Differently: Color Contrast Tips And Tools](https://www.smashingmagazine.com/2014/10/color-contrast-tips-and-tools-for-accessibility/)
- [The Code Side Of Color](https://www.smashingmagazine.com/2012/10/the-code-side-of-color/)
- [How to create the right emotions with color in web design](http://thenextweb.com/dd/2015/04/07/how-to-create-the-right-emotions-with-color-in-web-design/)
- [Picking a color for your brand](http://focuslabllc.com/digest/picking-a-color-for-your-brand)
- [Finessing \`feColorMatrix\`](http://alistapart.com/article/finessing-fecolormatrix)
- [Designing in color](https://medium.freecodecamp.com/designing-in-color-abd358660a7b)
- [Color Realism and Color Science](http://web.mit.edu/abyrne/www/ColorRealism.html)
- [The Psychology of Color in Marketing and Branding](https://medium.com/swlh/the-psychology-of-color-in-marketing-and-branding-ebb2320a2b0)
- [A Guide to Color and Conversion Rates](https://uxplanet.org/a-guide-to-color-and-conversion-rates-f3a28e8e32bb)
- [A Nerd’s Guide to Color on the Web](https://css-tricks.com/nerds-guide-color-web/)
- [A colour scheme for the display of astronomical intensity images](http://adsabs.harvard.edu/abs/2011BASI...39..289G)

<br>
<br>

### Image credits
[Aleksandar Savić](https://dribbble.com/almigor) and [Nenad Zivanovic](https://dribbble.com/nenadzivanovic).
