<div class="github-widget" data-repo="sturobson/BEM-resources"></div>
## BEM Resources [![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

每个人都喜欢在他们的开发中使用一点 BEM. 希望这里只是大量资源列表的开始.

## Articles

- [A CSS Guideline Tutorial: BEM with Sass](https://assist-software.net/blog/css-guideline-tutorial-bem-sass)
- [BEMantic - DRY like you mean it](https://medium.com/@stowball/bemantic-dry-like-you-mean-it-133ea3843d98#.a2ivj7ny9)
- [BEM & Atomic Design: A CSS Architecture Worth Loving](https://www.lullabot.com/articles/bem-atomic-design-a-css-architecture-worth-loving)
- [Battling BEM (Extended Edition): 10 Common Problems And How To Avoid Them](https://www.smashingmagazine.com/2016/06/battling-bem-extended-edition-common-problems-and-how-to-avoid-them/)
- [BEM and SMACSS: Advice From Developers Who’ve Been There](http://www.sitepoint.com/bem-smacss-advice-from-developers/)
- [MindBEMding – getting your head ’round BEM syntax - CSS Wizardry](http://csswizardry.com/2013/01/mindbemding-getting-your-head-round-bem-syntax/)
- [A New Front-End Methodology: BEM - Smashing Magazine](https://www.smashingmagazine.com/2012/04/a-new-front-end-methodology-bem/)
- [BEM 101 - CSS Tricks](https://css-tricks.com/bem-101/)
- [An Introduction to the BEM Methodology - Tuts Plus](http://webdesign.tutsplus.com/articles/an-introduction-to-the-bem-methodology--cms-19403)
- [Scaling Down The BEM Methodology For Small Projects - Smashing Magazine](https://www.smashingmagazine.com/2014/07/bem-methodology-for-small-projects/)
- [Fifty Shades of BEM - Kaelig](http://blog.kaelig.fr/post/48196348743/fifty-shades-of-bem)
- [Keeping the Front-End Modular with BEM - Thoughtbot](https://robots.thoughtbot.com/keeping-the-frontend-modular-with-bem)
- [The Evolution Of The BEM Methodology - Smashing Magazine](https://www.smashingmagazine.com/2013/02/the-history-of-the-bem-methodology/)
- [BEM Basics - 8th Light](http://blog.8thlight.com/nelsol-batalla/2014/08/01/bem-basics.html)
- [How To BEM - Roman Kuba](https://medium.com/@Codebryo/how-to-bem-4a55fa3cd429)
- [Expressive BEM with Sass: a different approach - Anders Hansen](http://codepen.io/andersschmidt/post/expressive-bem-with-sass-a-different-approach)
- [Expressive BEM with Sass Part II: A first draft of mixins - Anders Hansen](http://codepen.io/andersschmidt/post/expressive-bem-with-sass-part-ii-a-first-draft-of-mixins)
- [Learning to love BEM](http://mono.company/journal/frontend/learning-to-love-bem//)
- [Working with BEM at Scale — Advice From Top Developers](http://www.sitepoint.com/working-bem-scale-advice-top-developers/)
- [CSS Architecture: BEMCSS — Block, Element & Modifier](https://medium.com/@mjtweaver/css-architecture-bemcss-block-element-modifier-e642bd0f4218)
- [BEM Guidelines for component focused development](http://www.joelambert.co.uk/article/bem-guidelines/)
- [BEMIT: Taking the BEM Naming Convention a Step Further](http://csswizardry.com/2015/08/bemit-taking-the-bem-naming-convention-a-step-further/)
- [CSS BEM Syntax Basics](https://coryrylan.com/blog/css-bem-syntax-basics)
- [BEM official naming convention](https://en.bem.info/method/naming-convention/)
- [BEM for CSS - An Introduction](http://www.gapintelligence.com/blog/2015/bem-for-css-an-introduction)
- [Getting Started With BEM (with a little help from Sass)](https://www.packtpub.com/books/content/getting-started-bem-little-help-sass/)
- [BEM (Block element modifier) - CSS Methodologies Part 3](http://techblog.buyapowa.com/css/frontend/scss/sass/2015/10/07/css-methodologies-part-3.html)
- [How I stopped worrying and learned to love the CSS with BEM](http://www.theodo.fr/blog/2015/10/how-i-stopped-worrying-and-learned-to-love-the-css-with-bem/)
- [BEM CSS Basics for WordPress Themes Developers](https://ahmadawais.com/bem-css-basics-for-wordpress-themes-developers/)
- [Generate responsive BEMIT classes with Sass](http://codepen.io/craigmdennis/post/generate-responsive-bemit-classes-with-sass)
- [The BEMIT naming convention](http://www.jamesturneronline.net/beautifulweb/bemit-naming-convention.html)
- [BEM by example](https://sparkbox.com/foundry/bem_by_example)
- [Introducing BEM: The popular CSS naming convention](https://assortment.io/posts/introducing-bem-css-naming-convention)
- [7 Reasons To Use BEM CSS](https://medium.com/soliddigital/7-reasons-to-use-bem-css-a7c8475318fe)

## Resources

- [BEM Official Website](https://en.bem.info/)
- [Get BEM](http://getbem.com/introduction/)
- [BEM Cheat Sheet](https://gist.github.com/ingdir/0b211b9253c376f9cfa5)

## With Pre-processors

- [Generating BEM selectors with CSS preprocessors - Frontend Babel](http://frontendbabel.info/articles/bem-with-css-preprocessors/)

### Sass

- [Even Easier BEM-ing with Sass 3.3 - alwaystwisted](http://alwaystwisted.com/articles/2014-02-27-even-easier-bem-ing-with-sass-33)
- [BEM Mixins - CSS Tricks](https://css-tricks.com/snippets/sass/bem-mixins/)

### Stylus

- [Stylus and BEM: a quick mixin - Frank M Taylor](http://blog.frankmtaylor.com/2014/07/16/stylus-and-bem-a-quick-mixin/)

### PostCSS

- [PostCSS BEM Linter](https://github.com/postcss/postcss-bem-linter)

## Repos, CodePens and Things

### Repos

- [BEM Constructor](https://github.com/danielguillan/bem-constructor)
- [WordPress BEM Menu](https://github.com/roikles/Wordpress-Bem-Menu)
- [BEM Grid](https://github.com/bem-incubator/bem-grid)
- [Flexible Grid System with BEM](https://github.com/flexiblegs/flexiblegs-bem)
- [BEM.js](https://github.com/maykinmedia/bem.js)

## Slides &amp; Videos

### Slides

- [BEM CSS Workshop - Varya Stepanova](http://varya.me/bem-css-workshop/)
- [BEM - Luciano Battagliero](https://speakerdeck.com/battaglr/bem)

### Videos

- [Writing Modular CSS With Sass and BEM - Tuts Plus](https://www.youtube.com/watch?v=WH4U4K5W8N8)
- [MindBEMding – Rethink Web Development - Kevin Mack](https://www.youtube.com/watch?v=vgg-NsKZaE4)

### Other Awesome Lists

- [A curated list of awesome lists - @sindresorhus](https://github.com/sindresorhus/awesome)
