<div class="github-widget" data-repo="ttumiel/Awesome-Ethereum"></div>
<br/>
<div align="center">
  <img width="250px" src="https://raw.githubusercontent.com/ttumiel/Awesome-Ethereum/master/./project_logo.jpg">
</div>
<br/>
<div align="center">
关于与<a href='https://en.wikipedia.org/wiki/Ethereum'>以太坊</a>平台相关的所有内容的精彩列表.
<br />
以太坊是一个开源、区块链和智能合约计算平台.
<br/>

[![Awesome](https://awesome.re/badge.svg)](https://awesome.re)
</div>
<br/>

欢迎请求请求！ 然而，本着去中心化应用程序的精神，请确保您提交的不是付费产品.





## Documentation

以太坊官方文档.

- [GitHub Wiki](https://github.com/ethereum/wiki/wiki)  - 以太坊 wiki 涵盖了与以太坊相关的所有内容. 一切事物的必去之地.
- [Whitepaper](https://github.com/ethereum/wiki/wiki/White-Paper) - 以太坊的非技术介绍性描述.
- [Yellowpaper](https://ethereum.github.io/yellowpaper/paper.pdf)  - 以太坊的技术描述. 技术上过时，但很有趣.


## Programming

- [OpenZeppelin](https://openzeppelin.org/) - 经过实战检验的安全、可重复使用的智能合约框架.
- [Truffle Framework](https://www.truffleframework.com/) - 区块链应用程序的开发环境.
- [Ganache](https://truffleframework.com/ganache) - 用于运行测试的个人以太坊区块链.
- [Remix Online IDE](https://remix.ethereum.org/)  - 一个有用的浏览器内 IDE，可以编译智能合约并将其发布到各种以太坊网络. 包括棉绒.
- [Embark Framework](https://github.com/embark-framework/embark) - 使用以太坊、IPFS 和其他平台的无服务器分散应用程序框架.
- [Eth Fiddle](https://ethfiddle.com/) - 智能合约的在线编辑器.
- [Hardhat](https://hardhat.org/) - 专业人士的以太坊开发环境.


## Tutorials

使用以太坊的分步指南.

- [CryptoZombies](https://cryptozombies.io/) - 通过构建自己的游戏来学习编写以太坊 DApps.
- [Hitchhikers Guide to Smart Contracts](https://blog.zeppelin.solutions/the-hitchhikers-guide-to-smart-contracts-in-ethereum-848f08001f05) - 使用 Truffle、testrpc 和 Solidity 在以太坊上构建智能合约.
- [A 101 Noob Intro to Programming Smart Contracts on Ethereum](https://medium.com/@ConsenSys/a-101-noob-intro-to-programming-smart-contracts-on-ethereum-695d15c1dab4) - 智能合约教程，重点是在编写代码之前建立理解.
- [Parity DApp Tutorial](https://wiki.parity.io/Dapp-Tutorial) - 关于如何编写 DApp 的 10 部分教程.
- [Start Ethereum DApp Development Career](https://www.reddit.com/r/ethereum/comments/9h0w83/start_ethereum_dapp_development_career_ultimate/) - 开始开发 DApp 的非正式指南.
- [Full Stack DApp Tutorial Series](https://kauri.io/collection/5b8e401ee727370001c942e3/full-stack-dapp-tutorial-series) - 使用各种框架的全栈 DApp.
- [Ethereum Builders Guide](https://ethereumbuilders.gitbooks.io/guide/content/en/index.html) - 用于在以太坊上构建的 Gitbook，可以更深入地理解技术功能.
- [Learning Solidity Tutorial Series](https://karl.tech/learning-solidity-part-1-deploy-a-contract/) - Building smart contracts with Metamask and Remix IDE.
- [End to End DApp Tutorial](https://medium.com/@merunasgrincalaitis/the-ultimate-end-to-end-tutorial-to-create-and-deploy-a-fully-descentralized-dapp-in-ethereum-18f0cf6d7e0e) - 使用 Metamask、Truffle、Remix、React 和 IPFS 创建赌博 DApp.
- [Various Ethereum & Solidity Tutorials](https://www.codementor.io/learn/blockchain/solidity-tutorials) - 如何创建智能合约、部署您自己的 DApp、创建令牌等等 — 从初级到中级主题.


## Code

- [Solidity Documentation](https://solidity.readthedocs.io) - 智能合约的首选编程语言.
- [Vyper Documentation](https://vyper.readthedocs.io/en/latest/index.html) - 旨在取代 Solidity 的实验性智能合约编程语言.
- [Flint Documentation](https://docs.flintlang.org/) - 以太坊的实验性合约导向语言.


## Learning and MOOCs

了解以太坊背后的理论.

- [Ethereum Stack Exchange](https://ethereum.meta.stackexchange.com/questions/431/faq-frequently-asked-questions-and-reference-answers) - 关于以太坊的问答.
- [Smart contract safety](https://github.com/ethereum/wiki/wiki/Safety) - 关于智能合约安全最佳实践的以太坊 wiki.
- [Accounts, Transactions, Gas, and Block Gas Limits in Ethereum](https://hudsonjameson.com/2017-06-27-accounts-transactions-gas-ethereum/) - 以太坊账户、gas 和交易的功能描述.
- [Ethernaut Smart Contract Capture the Flag](https://ethernaut.zeppelin.solutions/) - 练习破解智能合约.
- [Ethereum Syllabus](https://novicedock.com/learn/cryptocurrency/ethereum) - 学习以太坊的教学大纲.
- [Cryptocurrency Security: University of Illinois 2016](http://soc1024.ece.illinois.edu/teaching/ece598am/fall2016/) - 加密货币安全课程.
- [Stanford CS 251(p): Bitcoin and Crypto Currencies](https://crypto.stanford.edu/cs251_fall15/) - 斯坦福比特币和加密货币课程.
- [Introduction to Digital Currencies: University of Nicosia](https://digitalcurrency.unic.ac.cy/free-introductory-mooc/) - 数字货币入门MOOC.
- [Bitcoin and Blockchain Technology: Concordia University](https://users.encs.concordia.ca/~clark/courses/1703-6630/index.html) - 比特币和区块链技术MOOC介绍.
- [Smart Contract Best Practices](https://consensys.github.io/smart-contract-best-practices/) - 智能合约的安全相关最佳实践.
- [Low-Resource Eclipse Attacks on Ethereum’s Peer-to-Peer Network](https://www.cs.bu.edu/~goldbe/projects/eclipseEth.pdf)

## Philosophy

以太坊项目背后的想法.

- [Making Smart Contracts Smarter](https://eprint.iacr.org/2016/633.pdf) - 智能合约安全攻击.
- [Ethereum Wiki Philosophy](https://github.com/ethereum/ethereum.org/wiki/Philosophy) - 以太坊的一些核心哲学.
- [Ethereum Improvement Proposals](https://eips.ethereum.org/) - 以太坊平台标准，包括核心协议规范、客户端 API 和合约标准.


## Videos

- [Ethereum Explained (22:00)](https://www.youtube.com/watch?v=-_Qs0XdPpw8) - 以太坊平台的介绍性解释.
- [A Guide to Building Your First Decentralized Application (37:00)](https://www.youtube.com/watch?v=gSQXq2_j-mw)
- [Ethereum YouTube Channel](https://www.youtube.com/user/ethereumproject) - 主要是 Devcon 1 及之前的旧视频.
- [Ethereum Foundation YouTube Channel](https://www.youtube.com/channel/UCNOfzGXD_C9YMYmnefmPH0g) - 最新的事件和流，包括以太坊 Devcon 会议和开发会议.

## Wallets

- [MetaMask](https://metamask.io/) - 可以与 Remix IDE 交互并将交易发送到不同测试网的浏览器扩展.
- [MyEtherWallet](https://www.myetherwallet.com/) - 与区块链交互并执行其他几个有用功能的在线钱包服务.
- [Mist](https://github.com/ethereum/mist) - 官方以太坊钱包 - 在以太坊网络上浏览和使用 Ðapps.
- [MyCrypto](https://www.mycrypto.com) - 与区块链交互并执行其他几个有用功能的在线钱包服务.

## Blockchain Utilities

- [ETH Gas Station](https://ethgasstation.info/) - 检查当前交易 gas 价格的工具.
- [Etherscan](https://etherscan.io/) - 以太坊区块浏览器与其他有用的区块实用程序.
- [Ethplorer](https://ethplorer.io/) - 以太坊区块浏览器.
- [Etherchain](https://www.etherchain.org/) - 以太坊区块浏览器.
- [Enjinx](https://enjinx.io/) - 以太坊区块浏览器，它也很好地可视化资产和代币.
- [Blockchair](https://blockchair.com/ethereum/) - 带有精美图表的多块资源管理器.

## Protocols

以太坊相关协议的描述和实现.

- [Swarm](https://swarm.ethereum.org/) - Swarm 是一个分布式存储平台和内容分发服务.
- [Whisper](https://github.com/ethereum/wiki/wiki/Whisper-pages) - DApps 相互通信的通信协议.
- [Casper](https://github.com/ethereum/wiki/wiki/Casper-Proof-of-Stake-compendium) - 股权实施证明.
  - Casper CBC - 通过构建纠正完整的股权证明.
    - [Code Repository](https://github.com/ethereum/cbc-casper) - 一类构造正确的共识协议的 python 实现.
    - [CBC Wiki](https://github.com/ethereum/cbc-casper/wiki)
    - [CBC Research Paper](https://github.com/ethereum/research/blob/master/papers/cbc-consensus/AbstractCBC.pdf)
  - Casper FFG - 友好的 Finality Gadget，用于使用工作量证明进行 PoS 验证.
    - [Code Repository](https://github.com/ethereum/casper) - FFG 合同、相关软件和测试.
    - [Casper the Friendly Finality Gadget Paper](https://arxiv.org/abs/1710.09437) - 详细介绍 FFG 的研究论文.
  - [PoS FAQs](https://github.com/ethereum/wiki/wiki/Proof-of-Stake-FAQs)
  - [FFG vs CBC Comparison](https://ethereum.stackexchange.com/questions/31797/casper-ffg-vs-casper-ghost-cbc/31814#31814) - FFG 和 CBC 的 Stack Exchange 比较.
- [Sharding](https://github.com/ethereum/wiki/wiki/Sharding-introduction-R&D-compendium) - 对计算资源进行分区，以便节点不必处理整个区块链.
- [Web3.js](https://github.com/ethereum/web3.js) - 以太坊的 JavaScript API.
- [Ethash Proof of Work](https://github.com/ethereum/wiki/wiki/Ethash) - 以太坊的工作证明算法.
- zk-SNARKS - 在不泄露秘密的情况下验证对秘密的了解.
  - [Introduction to zk-SNARKS with examples](https://media.consensys.net/introduction-to-zksnarks-with-examples-3283b554fc3b) - zk-SNARKS 的实用概述.
  - [A practical beginner's guide to creating, proving, and verifying zkSNARKs](https://github.com/jstoxrocky/zksnarks_example) - zk-SNARKS 简介和作为智能合约的实施.
  - [zk-SNARKS: Under the Hood](https://medium.com/@VitalikButerin/zk-snarks-under-the-hood-b33151a013f6) - zk-SNARKS 的技术解释.
  - [zk-SNARKs in a nutshell](https://blog.ethereum.org/2016/12/05/zksnarks-in-a-nutshell/) - zk-SNARKS 的技术解释.
  - [Practical zk-SNARKs for Ethereum](http://coders-errand.com/practical-zk-snarks-for-ethereum/) - 使用 zk-SNARKs 的简短实用介绍.
- 代币联合曲线 (TBC) - 数学上合理的价格供应关系曲线.
  - [Bonding Curves Explained](https://yos.io/2018/11/10/bonding-curves/) - 通过代码全面介绍 TBC.
  - [Token Bonding Curves in Practice](https://tokeneconomy.co/token-bonding-curves-in-practice-3eb904720cb8) - 通过不可替代的代币和管理市场探索 IP 的普遍分配.
  - [Bonding Curve Playground](https://bondingplayground.netlify.com/) - 交互式结合曲线网络应用程序.


## Books

- [Mastering Ethereum](https://github.com/ethereumbook/ethereumbook) - 以太坊操作和使用的开发者指南.
- [Introduction to Ethereum and Solidity](https://the-eye.eu/public/Books/qt.vidyagam.es/library/humble-bitcoin-bundle/Introducing%20Ethereum%20and%20Solidity_%20Foud%20Blockchain%20Programming%20for%20Beginners/Introducing%20Ethereum%20and%20Solidity_%20Foundatiin%20Programming%20for%20Beginners%20-%20Chris%20Dannen.pdf) - 学习从概念到部署的 Solidity 开发.
- [Ethereum: Blockchains, Digital Assets, Smart Contracts, Decentralized Autonomous Organizations](https://www.goodreads.com/book/show/32762240-ethereum) - 从 IBM 区块链联络员那里了解以太坊（和区块链）.


## Misc

- [r/Ethereum](https://www.reddit.com/r/ethereum/) - 以太坊 subreddit.
- [State of the DApps](https://www.stateofthedapps.com/) - 以太坊上去中心化应用程序 (DApps) 的完整列表.
- [ETH Gas Station](https://ethgasstation.info/) - 检查当前交易 gas 价格的工具.
- [Week in Ethereum](http://www.weekinethereum.com/) - 每周在以太坊发生的一切的总结.
- [Ethereum Worldwide Meetups](https://www.meetup.com/find/?allMeetups=false&keywords=ethereum) - 通过 meetup.com 与当地的以太坊社区会面.
- [Ethereum Wiki Page](https://eth.wiki/en/home)


## Official

- [Ethereum Website](https://www.ethereum.org/)
- [Ethereum Foundation](https://ethereum.foundation/)
- [Ethereum GitHub](https://github.com/ethereum/)



## Contribute

欢迎投稿！ 阅读 [contribution guidelines](https://github.com/ttumiel/Awesome-Ethereum/blob/master/contributing.md) 第一的.
灵感来自 [Awesome Python](https://github.com/vinta/awesome-python) 和 [Awesome Machine Learning](https://github.com/josephmisiti/awesome-machine-learning)

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](http://creativecommons.org/publicdomain/zero/1.0)

在法律允许的范围内，@ttumiel 已放弃所有版权和
本作品的相关或邻接权利. 有关完整许可证，请参阅“license.md”.
