<div class="github-widget" data-repo="PandaFoss/Awesome-Arch"></div>
## Awesome Arch [![Awesome](https://awesome.re/badge-flat.svg)](https://github.com/sindresorhus/awesome) [![Build Status](https://travis-ci.com/PandaFoss/Awesome-Arch.svg?branch=master)](https://travis-ci.com/PandaFoss/Awesome-Arch)

> An awesome list for an awesome project.</i></p>

[<img src="https://www.archlinux.org/static/logos/archlinux-logo-dark-90dpi.ebdee92a15b3.png" align="right" width="250">](https://www.archlinux.org/)

[Arch Linux](https://www.archlinux.org/) is an independently developed, x86-64 general purpose GNU/Linux distribution versatile enough to suit any role. Development focuses on simplicity, minimalism, and code elegance. Arch is installed as a minimal base system, configured by the user upon which their own ideal environment is assembled by installing only what is required or desired for their unique purposes.



## Arch-based projects

### Linux

> Linux distributions strongly inspired by Arch Linux.

- [Arch Linux 32](https://www.archlinux32.org/) - The community maintained continuation of 32-bit support for Arch Linux.
- [Arch Linux ARM](https://archlinuxarm.org/) - A distribution of Linux for ARM computers.

### Not Linux

> Non-Linux projects based on Arch Linux.

- [PacBSD](https://github.com/pacbsd) - A lightweight and flexible BSD distribution that provides a base system for use of `pacman` package manager.
- [Arch Hurd](https://archhurd.org/) - A derivative work of Arch Linux porting it to the GNU Hurd system with packages optimised for the i686 architecture.
- [ArchWSL](https://git.io/archwsl) - ArchLinux as a WSL Instance.

## Arch-based distros

### Desktop

> Linux distributions based on Arch Linux for general use.

- [Manjaro](https://manjaro.org/) - A professionally made Linux based operating system that is a suitable replacement for Windows or macOS.
- [ArcoLinux](https://arcolinux.com/) - A full-featured distribution.
- [ArchBang Linux](http://archbang.org/) - A lightweight distribution based on Arch Linux.
- [Archcraft OS](https://archcraft-os.github.io/) - A Minimalistic Linux Distribution, Focused On Aesthetics & Based On Arch Linux.
- [Archman](http://archman.org/) - An Arch Linux-based distribution which features the Calamares system installer and a pre-configured desktop environment.
- [Bluestar Linux](https://sourceforge.net/projects/bluestarlinux/) - A GNU/Linux distribution that is based on Arch Linux.
- [Crystal Linux](https://github.com/PandaFoss/Awesome-Arch/blob/master/Https://getcryst.al) -  Crystal Linux is a brand new Arch Linux based distribution. Completely beginner friendly, easy to use, and powerful.
- [CachyOS](https://cachyos.org) - A GNU/Linux distribution built on Arch Linux, it features the optimized linux-cachyos kernel utilizing the advanced BORE Scheduler for unparalleled performance.
- [EndeavourOS](https://endeavouros.com/) - A rolling release Linux distribution based on Arch Linux.
- [ArchLabs Linux](https://archlabslinux.com/) - A distribution based on Arch Linux and featuring the Openbox window manager as the primary desktop interface.
- [Namib GNU/Linux](https://www.namiblinux.org/) - A desktop operating system based on (and compatible with) the Arch Linux distribution.
- [ArchEX](http://archex.exton.net/) - A new (190612) Linux live DVD based on Arch Linux. Arch motto is KISS (Keep It Simple Stupid.
- [Ctlos Linux](https://ctlos.github.io/) - Arch Linux based distro.
- [MagpieOS](https://github.com/magpie-linux) - Get a fresh experience of Arch.
- [Netrunner Rolling](https://www.netrunner.com/netrunner-rolling-release/) - Manjaro/Arch Linux based distro.
- [PuppyRus-A](https://sourceforge.net/projects/puppyrusa/) - Lightweight, portable and flexible Linux based on Arch, Puppy, Porteus.
- [TeLiSc OS](https://sourceforge.net/projects/telisc-os/) - A simple GNU/Linux distribution based on Arch Linux which provides you a stable Arch Linux with i3 window manager.
- [Qubes OS (Archlinux Template)](https://www.qubes-os.org/doc/building-archlinux-template/) - A security-focused desktop operating system that aims to provide security through isolation (Unofficial Archlinux Template).
- [XeroLinux](https://xerolinux.xyz/) - A well-maintained hobbyist Arch based distro, built using ArcoLinux's ALCI scripts that is meant to provide you with a stable base, making it simpler to install ArchLinux (using Calamares) with a well optimized & customized KDE Plasma.

### Specific purpose

> Linux distributions based on Arch Linux with a specific purpose.

- [BioArchLinux](https://bioarchlinux.org/) - _(Bioinformatics/Biology)_ Arch Community for Biologists & Arch Repository for Biological Software.
- [BlackArch Linux](https://blackarch.org/) - _(Security/Forensics)_ - An Arch Linux-based distribution designed for penetration testers and security researchers.
- [ArchStrike](https://archstrike.org/) - _(Security)_ - A distribution for security professionals and researchers based on Arch Linux.
- [SystemRescueCd](http://www.system-rescue-cd.org/) - _(Data Rescue)_ - An Arch-based Linux system on a bootable CD-ROM or USB drive, designed for repairing a system and data after a crash.
- [MorpheusArch Linux](https://sourceforge.net/projects/morpheusarch-lxqt/files/) - _(Data Rescue)_ - A distribution based on Arch Linux. 
- [LinHES](http://www.linhes.org/) - _(MythTV)_ - An attempt to make the installation of GNU/Linux and MythTV as trivial as possible.
- [UBOS](https://ubos.net/) - _(Server)_ - A Linux distribution designed to greatly reduce the amount of time required to set up and maintain common network services.
- [TalkingArch](https://talkingarch.tk/) - _(Assistive)_ - A re-spin of the Arch Linux live ISO image, modified to include speech and Braille output for blind and visually-impaired users.
- [BBQLinux](http://bbqlinux.org/) - _(Android Developers)_ - A user-friendly Linux distribution made for Android developers.
It has everything on board to build AOSP or AOSP-based distributions like LineageOS or OmniROM.
- [RaspArch](https://sourceforge.net/projects/rasparch/) - _(Raspberry Pi/ARM)_ - A “remaster” of Arch Linux ARM.

## Pacman-based Linux distros

 > Linux distributions that use `pacman` as a package manager.

- [KaOS](https://kaosx.us/) - KaOS is an independent distribution focused on Qt and KDE.

## SystemD-free Arch-based distros

> Linux distributions based on Arch Linux that implement alternative inits to SystemD.

- [Obarun](https://web.obarun.org/) - An Arch Linux based distribution featuring the S6 init software in place of systemd.
- [Artix Linux](https://artixlinux.org/) - A fork (or continuation as an autonomous project) of the Arch-OpenRC and Manjaro-OpenRC projects.
- [Hyperbola GNU/Linux-libre](https://www.hyperbola.info/) - A community driven effort to provide a fully free (as in freedom) operating system that is stable, secure, simple, lightweight that tries to Keep It Simple Stupid (KISS) with Long Term Support (LTS).
- [Parabola GNU/Linux-libre](https://www.parabola.nu/) - An unofficial "libre" variant of Arch Linux.
- [Alfheim Linux](https://alfheimlinux.wixsite.com/alfheimlinux) - Systemd free Arch based Linux.

## Arch Linux Installers

> Installers created specifically to facilitate the installation of Linux Arch.

- [Archfi](https://github.com/MatMoul/archfi) - Just a simple bash script wizard to install Arch Linux after you have booted on the official Arch Linux install media.
- [aui](https://github.com/helmuthdu/aui) - The Archlinux Ultimate Install comprises of two primary scripts, Lilo and Fifo, which streamline the installation process of Archlinux Base, as well as additional packages, tools, and graphical user interfaces.

## AUR Helpers

### Search and download

- [Auracle](https://github.com/falconindy/auracle) (C++) - A flexible command line client for Arch Linux's User Repository.
- [pbget](https://xyne.archlinux.ca/projects/pbget/) (Python) - Retrieve PKGBUILDs and local source files from Git, ABS and the AUR for makepkg.
- [repoctl](https://github.com/cassava/repoctl) (Go) - Make it easy to manage your local Arch Linux repository.
- [yaah](https://projects.metalgamer.eu/yaah) (Bash) - A helper for the Archlinux User Repository (AUR).

### Search and build

- [Aurutils](https://github.com/AladW/aurutils) (Bash) - Helper tools for the AUR.
- [Bauerbill](https://xyne.archlinux.ca/projects/bauerbill/) (Python) - An extension of Powerpill with AUR and ABS support.
- [PKGBUILDer](https://github.com/Kwpolska/pkgbuilder) (Python) - An AUR helper (and library) in Python 3.
- [repofish](https://git.seppia.net/repofish.git) (Bash) - Simple shell script used to manage a local archlinux repository.
- [RUA](https://github.com/vn971/rua) (Rust) - Build tool for Arch Linux providing control, review and jailed build options.

### Pacman wrappers

- [amethyst](https://github.com/crystal-linux/amethyst) (Rust) - A fast, efficient and lightweight AUR helper and Pacman wrapper made for Crystal, compatible with any Arch-based Linux distribution.
- [Aura](https://github.com/fosskers/aura) (Haskell) - A secure, multilingual package manager for Arch Linux and the AUR.
- [Pacaur](https://github.com/E5ten/pacaur) (Bash) - An AUR helper that minimizes user interaction.
- [Pakku](https://github.com/kitsunyan/pakku) (Nim) - `pacman` wrapper with AUR support.
- [Paru](https://github.com/Morganamilo/paru) (Rust) - AUR helper with all needed modern wrapper features, created by a former developer of yay.
- [pikaur](https://github.com/actionless/pikaur) (Python) - AUR helper with minimal dependencies. Review PKGBUILDs all in once, next build them all without user interaction.
- [Trizen](https://github.com/trizen/trizen) (Perl) - Lightweight AUR Package Manager.
- [Yay](https://github.com/Jguer/yay) (Go) - Yet another Yogurt, an AUR Helper written in Go.

### Graphical

- [Argon](https://github.com/14mRh4X0r/arch-argon) (Python | GTK3) - lightweight GUI package manager for Arch Linux.
- [Cylon](https://github.com/gavinlyonsrepo/cylon) (Bash | TUI) - A CLI TUI menu driven bash shell script supporting updates, maintenance, backups and system checks for an Arch based Linux distro.
- [Pamac](https://gitlab.manjaro.org/applications/pamac) (Vala | GTK3) - Graphical Package Manager for Manjaro Linux with Alpm, AUR, Appstream, Flatpak and Snap support.
- [Pakku GUI](https://gitlab.com/mrvik/pakku-gui) (Python | GTK3) - Basic GTK interface to (install|remove|upgrade) packages with `pakku`.
- [PkgBrowser](https://osdn.net/projects/pkgbrowser) (Python | Qt5) - A utility for browsing `pacman` databases and the AUR.
- [Octopi](https://tintaescura.com/projects/octopi) (C++ | Qt5) - A graphical user interface for the Arch Linux package management tool `pacman`. 
- [Yup](https://github.com/ericm/yup) (Go | TUI) - Arch Linux AUR Helper with ncurses functionality and better searching and sorting.

### Maintenance

- [aur-out-of-date](https://github.com/simon04/aur-out-of-date) - Determines out-of-date AUR packages w.r.t. upstream version.
- [aurpublish](https://github.com/eli-schwartz/aurpublish) - PKGBUILD management framework for the Arch User Repository.
- [devtools](https://git.archlinux.org/devtools.git/) - Tools for the Arch Linux distribution for building and maintaining official repository packages.
- [pkgbuild-watch](http://kmkeen.com/pkgbuild-watch/) - Alerts you to upstream activity.
- [pkgoutofdate](https://github.com/anatol/pkgoutofdate) - Checks whether Arch packages are out-of-date.

### Other

- [arch-audit](https://gitlab.com/ilpianista/arch-audit) - A utility like pkg-audit based on Arch Security Team data.
- [aur-talk](https://github.com/GermainZ/aur-talk) - A script to fetch and display AUR package comments.
- [aurvote-utils](https://github.com/jadenPete/aurvote-utils) - A set of utilities for managing AUR votes.
- [haskell-aur](https://hackage.haskell.org/package/aur) - Haskell library for accessing Aurweb RPC interface.
- [package-query](https://github.com/archlinuxfr/package-query) - Tool for querying `libalpm` and the AUR.
- [python3-aur](https://xyne.archlinux.ca/projects/python3-aur) - AUR-related modules and helper utilities (aurploader, aurquery, aurtomatic).
- [raur](https://gitlab.com/davidbittner/raur) - Rust library for accessing Aurweb RPC interface.

## Other projects

> Projects linked to or inspired by Arch Linux that do not belong to any previous category.

- [Dotfiles Generator](https://github.com/ulises-jeremias/dotfiles) - Dotfiles generator that allows quick configuration of different Window Managers and tools in multiple operating systems, including any Arch Linux-based distribution.
- [Termux Arch](https://termuxarch.github.io/TermuxArch/) - Run Arch Linux ARM on your mobile phone with Termux.
- [archlinux/base](https://hub.docker.com/r/archlinux/base/) - A docker image based on Arch Linux.
- [Arch Linux on EC2](https://www.uplinklabs.net/projects/arch-linux-on-ec2/) - Amazon EC2 AMIs based on Arch Linux
- [JuNest](https://github.com/fsquillace/junest) - A lightweight Arch Linux-based distro that runs, without root privileges, upon any Linux distro.
- [makepkg-optimize](https://github.com/ptr1337/makepkg-optimize) - A collection of supplemental tidy, buildenv, and executable scripts for pacman which provide macros for several kinds of optimization in the build() and package() stages.

## Inactive projects

> Projects that were part of the listing but were discontinued or did not receive updates for a long time.

- **Arch XFerience** - A modern OS based on Arch Linux, built for day-to-day operations with tons of packages & features. (inactive)
- **Chakra GNU/Linux** - A user-friendly and powerful distribution and live CD originally forked from Arch Linux. ([discontinued](https://twitter.com/chakralinux/status/1475111596640727045))
- **Archphile** - _(Raspberry Pi/ARM/Audio)_ - Yet another linux audio distribution for embedded boards. (inactive)
- **Anarchy** - A simple and intuitive Arch Linux installer. ([discontinued](https://gitlab.com/anarchyinstaller/installer#deprecated-project))

## Contribute

Contributions welcome! Read the [contribution guidelines](https://github.com/PandaFoss/Awesome-Arch/blob/master/contributing.md) first.

You can also contribute to the maintenance of the list by making a small donation (psst, buy me a coffee... ☕️ ):

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/K3K179HAS)

I need your support! ❤️

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="12.5%"><a href="https://raw.githubusercontent.com/klorophatu"><img src="https://avatars.githubusercontent.com/u/52282861?v=4?s=100" width="100px;" alt="klorophatu"/><br /><sub><b>klorophatu</b></sub></a><br /><a href="#content-klorophatu" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="https://telesto.ai"><img src="https://avatars.githubusercontent.com/u/28736871?v=4?s=100" width="100px;" alt="Nandor Magyar"/><br /><sub><b>Nandor Magyar</b></sub></a><br /><a href="#content-nandor-magyar" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="https://pandafoss.github.io/"><img src="https://avatars.githubusercontent.com/u/6508835?v=4?s=100" width="100px;" alt="Max Ferrer"/><br /><sub><b>Max Ferrer</b></sub></a><br /><a href="https://raw.githubusercontent.com/PandaFoss/Awesome-Arch/commits?author=PandaFoss" title="Code">💻</a> <a href="#ideas-PandaFoss" title="Ideas, Planning, & Feedback">🤔</a> <a href="#maintenance-PandaFoss" title="Maintenance">🚧</a> <a href="#design-PandaFoss" title="Design">🎨</a> <a href="#content-PandaFoss" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="https://raw.githubusercontent.com/JackNapier151"><img src="https://avatars.githubusercontent.com/u/23581810?v=4?s=100" width="100px;" alt="Jack Napier"/><br /><sub><b>Jack Napier</b></sub></a><br /><a href="#ideas-JackNapier151" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="12.5%"><a href="http://sheepdev.xyz"><img src="https://avatars.githubusercontent.com/u/68562536?v=4?s=100" width="100px;" alt="sheepdev"/><br /><sub><b>sheepdev</b></sub></a><br /><a href="#content-sheeepdev" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="https://ar.linkedin.com/in/ulisesjcf"><img src="https://avatars.githubusercontent.com/u/17727170?v=4?s=100" width="100px;" alt="Ulises Jeremias Cornejo Fandos"/><br /><sub><b>Ulises Jeremias Cornejo Fandos</b></sub></a><br /><a href="#content-ulises-jeremias" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="https://raw.githubusercontent.com/andryandrew"><img src="https://avatars.githubusercontent.com/u/29781022?v=4?s=100" width="100px;" alt="Andrea"/><br /><sub><b>Andrea</b></sub></a><br /><a href="#content-andryandrew" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="https://raw.githubusercontent.com/codecrap"><img src="https://avatars.githubusercontent.com/u/5834554?v=4?s=100" width="100px;" alt="Olexiy"/><br /><sub><b>Olexiy</b></sub></a><br /><a href="#content-codecrap" title="Content">🖋</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="12.5%"><a href="https://raw.githubusercontent.com/0xMRTT"><img src="https://avatars.githubusercontent.com/u/105598867?v=4?s=100" width="100px;" alt="0xMRTT"/><br /><sub><b>0xMRTT</b></sub></a><br /><a href="#content-0xMRTT" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="http://malacology.net"><img src="https://avatars.githubusercontent.com/u/37733075?v=4?s=100" width="100px;" alt="Kuoi"/><br /><sub><b>Kuoi</b></sub></a><br /><a href="#content-starsareintherose" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="https://raw.githubusercontent.com/sogreatandpowerfull"><img src="https://avatars.githubusercontent.com/u/114095654?v=4?s=100" width="100px;" alt="SoGreatAndPowerful"/><br /><sub><b>SoGreatAndPowerful</b></sub></a><br /><a href="#content-sogreatandpowerfull" title="Content">🖋</a></td>
      <td align="center" valign="top" width="12.5%"><a href="https://raw.githubusercontent.com/ghost"><img src="https://avatars.githubusercontent.com/u/10137?v=4?s=100" width="100px;" alt="Deleted user"/><br /><sub><b>Deleted user</b></sub></a><br /><a href="#maintenance-ghost" title="Maintenance">🚧</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!

## License

[![CC0](https://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0)

To the extent possible under law, Panda Foss has waived all copyright and related or neighboring rights to this work.
