# File Size Converter

## Overview

File Size Converter is a web application that allows users to easily convert file sizes between different units of measurement. It provides a simple, intuitive interface for converting file sizes from bytes to larger units like kilobytes, megabytes, gigabytes, and beyond.

![File Size Converter Screenshot](https://source.unsplash.com/random/800x400?computer+file)

## Features

- Convert file sizes between multiple units (B, KB, MB, GB, TB, PB, EB, ZB, YB)
- User-friendly interface with a clean, responsive design
- Real-time conversion as you type
- Error handling for invalid inputs
- Supports a wide range of file sizes from bytes to yottabytes

## Live Demo

You can try out the live version of the File Size Converter here: [https://curious-kashata-5b2219.netlify.app](https://curious-kashata-5b2219.netlify.app)

## Technologies Used

- React
- TypeScript
- Tailwind CSS
- Vite (for build and development)
- Lucide React (for icons)

## Getting Started

### Prerequisites

- Node.js (v14 or later)
- npm (v6 or later)

### Installation

1. Clone the repository:
   ```
   git clone https://github.com/ianshulx/React-projects-for-beginners/tree/main/file-size-converter.git
   ```

2. Navigate to the project directory:
   ```
   cd file-size-converter
   ```

3. Install the dependencies:
   ```
   npm install
   ```

### Running the Application

To start the development server:

```
npm run dev
```

This will start the application on `http://localhost:5173` (or another port if 5173 is in use).

### Building for Production

To create a production build:

```
npm run build
```

This will generate optimized files in the `dist` directory.

## Usage

1. Enter the file size in the input field.
2. Select the unit you're converting from in the "from" dropdown.
3. Select the unit you want to convert to in the "to" dropdown.
4. Click the "Convert" button or press Enter.
5. The converted file size will be displayed below the form.

## Contributing

Contributions to the File Size Converter project are welcome! Here's how you can contribute:

1. Fork the repository
2. Create a new branch (`git checkout -b feature/AmazingFeature`)
3. Make your changes
4. Commit your changes (`git commit -m 'Add some AmazingFeature'`)
5. Push to the branch (`git push origin feature/AmazingFeature`)
6. Open a Pull Request

Please make sure to update tests as appropriate and adhere to the existing coding style.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Acknowledgments

- Icons provided by [Lucide](https://lucide.dev/)
- Deployed using [Netlify](https://www.netlify.com/)

## Contact

If you have any questions, feel free to reach out or open an issue in the GitHub repository.

Happy converting!
