// Please add your project details in the below array.
const projects = [
  {
    title: "Mood Tracker App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/mood-tracker",
    description: "Start your coding journey with a beginner-friendly React Mood Tracker App, a simple and easy way for users to keep a weekly track of their mood and understand themselves better.",
    imgSrc: "assets/mood.png"
  },
  {
    title: "Personalised Greeing Generator App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/persolanised-greeting-generator",
    description: "Start your coding journey with a beginner-friendly React Personalised Greeting Generator App, a simple and sweet way for users to generate personalised greetings with just one click.",
    imgSrc: "assets/greeting.png"
  },
  {
    title: "Curreny Converter App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Currency-Converter",
    description: "Start your coding journey with a beginner-friendly React Currency-Converter App, a simple and efficient way for users to convert between different currencies in real-time ",
    imgSrc: "assets/currency.png"
  },
  {
    title: "Tip Calculator App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Tip-Calculator",
    description: "Start your coding journey with a beginner-friendly React Tip-Calculator App, A simple and efficient way for users to calculate tips accurately and effortlessly. ",
    imgSrc: "assets/tip.png"
  },
  {
    title: "Fun-Fact Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Fun-Fact%20Generator",
    description: "Start your coding journey with a beginner-friendly React Fun-Fact Generator App, An easy and engaging way for users to discover interesting and surprising facts with just a click! ",
    imgSrc: "assets/funfact.png"
  },
  {
    title: "HEX-RGB Converter",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/HEX-RGB%20Converter",
    description: "Start your coding journey with a beginner-friendly React HEX/RGB Converter App, An intuitive tool for seamlessly converting colors between RGB and HEX formats with precision. ",
    imgSrc: "assets/hex_rgb.png"
  },
  {
    title: "Daily-Workout Randomizer",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Daily-Workout-Randomizer",
    description: "Start your coding journey with a beginner-friendly React Daily-Workout-Randomizer App, An engaging tool for effortlessly generating daily workout routines, tailored to keep fitness fun and varied every day.",
    imgSrc: "assets/workout.png"
  },
  {
    title: "Recipe Finder",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Recipe-Finder",
    description: "Start your coding journey with a beginner-friendly React Recipe Finder, An interactive tool for discovering new and exciting recipes based on your ingredient preferences, making meal planning simple and inspiring.",
    imgSrc: "assets/recipe.png"
  },
  {
    title: "Positive News",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Positive-News",
    description: "Start your coding journey with a beginner-friendly React Positive News, A uplifting platform that curates and displays positive news stories, bringing joy and optimism to your daily reading experience.",
    imgSrc: "assets/news.png"
  },
  {
    title: "InterestRate Calculator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/InterestRate-Calculator",
    description: "Start your coding journey with a beginner-friendly React InterestRate Calculator, An efficient tool for easily calculating simple and compound interest, helping users make informed financial decisions.",
    imgSrc: "assets/interestrate.png"
  },
  {
    title: "CryptoPrice Checker",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/CryptoPrice-Checker",
    description: "Start your coding journey with a beginner-friendly React CryptoPrice Checker, A user-friendly tool for quickly checking real-time cryptocurrency prices, empowering users to stay informed about the crypto market.",
    imgSrc: "assets/cryptoprice.png"
  },
  {
    title: "TokenConversion-Calculator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/TokenConversion-Calculator",
    description: "Start your coding journey with a beginner-friendly React TokenConversion-Calculator, A convenient tool for effortlessly converting amounts between different cryptocurrency tokens using real-time exchange rates.",
    imgSrc: "assets/token.png"
  },
  {
    title: "RGB Color Guesser Game ",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/RGB-Color-Guesser",
    description: "Start your coding journey with a beginner-friendly RGB Color Guesser Game , A fun and interactive game where users guess the correct color based on a given RGB code, testing their color-matching skills.",
    imgSrc: "assets/rgbguess.png"
  },
  {
    title: "BMI Calculator ",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/BMI-Calculator",
    description: "Start your coding journey with a beginner-friendly React BMI-Calculator, An easy-to-use tool that calculates Body Mass Index (BMI) based on user-provided height and weight, helping users monitor their health.",
    imgSrc: "assets/bmi.png"
  },
  {
    title: "Emoji-Search-App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Emoji-Search-App",
    description: "Start your coding journey with a beginner-friendly React Emoji-Search-App, A handy app that lets users quickly find the perfect emoji by filtering results based on a search query.",
    imgSrc: "assets/emojisearch.png"
  },
  {
    title: "Simple-Horoscope-Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Simple-Horoscope-Generator",
    description: "Start your coding journey with a beginner-friendly React Simple-Horoscope-Generator, A straightforward tool that provides daily horoscope insights for each zodiac sign, adding a touch of guidance to users' day.",
    imgSrc: "assets/horo.png"
  },
  {
    title: "Fruit-Matcher-Game",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Fruit-Matcher-Game",
    description: "Start your coding journey with a beginner-friendly React Fruit-Matcher-Game, An engaging matching game where users pair up different fruit icons, enhancing memory and concentration skills in a fun way.",
    imgSrc: "assets/fruits.png"
  },
  {
    title: "Weight-Converter",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Weight-Converter",
    description: "Start your coding journey with a beginner-friendly React Weight-Converter, A quick and easy tool for converting weight between units like pounds and kilograms, simplifying weight measurements for users.",
    imgSrc: "assets/weight.png"
  },
  {
    title: "Countdown-To-Birthday",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Countdown-To-Birthday",
    description: "Start your coding journey with a beginner-friendly React Countdown-To-Birthday, A simple app that counts down the days remaining until a specified birthday, helping users anticipate and celebrate special occasions.",
    imgSrc: "assets/birthday.png"
  },
  {
    title: "ProfileAPI",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/ProfileAPI",
    description: "Start your coding journey with a beginner-friendly React Water-Intake-Tracker, A convenient tool for users to log and track their daily water intake, promoting hydration and healthy drinking habits.",
    imgSrc: "assets/water.png"
  },
  {
    title: "Water-Intake-Tracker",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Water-Intake-Tracker",
    description: "Start your coding journey with a beginner-friendly React Water-Intake-Tracker, A convenient tool for users to log and track their daily water intake, promoting hydration and healthy drinking habits.",
    imgSrc: "assets/profile.png"
  },
  {
    title: "Random-Travel-Destination-Suggester",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Random-Travel-Destination-Suggester",
    description: "Start your coding journey with a beginner-friendly React Random-Travel-Destination-Suggester, An exciting tool that randomly suggests travel destinations, inspiring users to explore new places and plan their next adventure.",
    imgSrc: "assets/travel.png"
  },
  {
    title: "Frequency-Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Frequency-Generator",
    description: "Start your coding journey with a beginner-friendly React Frequency-Generator, A versatile frequency generator that allows users to create and play various sound frequencies, providing a practical tool for audio experimentation and sound design.",
    imgSrc: "assets/frequency.png"
  },
  {
    title: "React Todo App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/react-todo-app",
    description: "Start your coding journey with a beginner-friendly React Todo App, perfect for learning task management and basic web development",
    imgSrc: "assets/todo.png"
  },
  {
    title: "React Weather app",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/React-Weather-app",
    description: "Explore weather effortlessly with a beginner-friendly React Weather App, providing real-time forecasts and an intuitive user experience.",
    imgSrc: "assets/weather.png"
  },
  {
    title: "React Stopwatch app",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/react-stopwatch",
    description: "Solidify your javascript concepts by making a React Stopwatch. You will learn how to manage javascript objects as state in React.",
    imgSrc: "assets/stopwatch.png"
  },
  {
    title: "React Bank UI",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/React-Bank-UI",
    description: "Create an attractive landing page of your choice that will improve your designing skills.",
    imgSrc: "assets/bank.png"
  },
  {
    title: "Movie Database App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/simple-movie-search-app",
    description: "Create a simple movie database app where you can search about movies. In this project you will learn about Card Components & how to manage dynamic data on page.",
    imgSrc: "assets/movie.png"
  },
  {
    title: "React Expense Tracker",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/expense-tracker-react",
    description: "Learn more about state management by creating an Expense Tracker.",
    imgSrc: "assets/expense.png"
  },
  {
    title: "E-commerce Website React",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/E-commerce%20Website",
    description: "React-based e-commerce site: Sleek design, vast product range, and secure checkout redefine online shopping.",
    imgSrc: "assets/ecom.png"
  },
  {
    title: "GIF Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/GIF%20Generator",
    description: "Experience the fun of GIF creation with our React-based GIF Generator. Easily create, customize, and share animated GIFs, adding excitement to your online conversations.",
    imgSrc: "assets/gif.png"
  },
  {
    title: "Calculator App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/calculator-react",
    description: "Experience the power of React with our intuitive Calculator app. Perform quick and accurate calculations with a sleek and user-friendly interface.",
    imgSrc: "assets/calculator.png"
  },
  {
    title: "Meme App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/meme-app-react",
    description: "Unleash your creativity with our React-powered Meme App. Craft and share hilarious memes effortlessly, adding humor to your social media.",
    imgSrc: "assets/meme.png"
  },
  {
    title: "React Music App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/react-music-player",
    description: "Immerse yourself in the world of music with our React-based Music Player. Enjoy seamless playback, playlist management, and a dynamic audio experience.",
    imgSrc: "assets/music.png"
  },
  {
    title: "Quote Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/quotesgenerator",
    description: "Get inspired with our React-based Quote Generator. Discover wisdom, motivation, and creativity at your fingertips, one quote at a time.",
    imgSrc: "assets/quote.png"
  },
  {
    title: "Password Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/react_password_generator",
    description: "Boost your online security with our React Password Generator. Create strong, randomized passwords effortlessly to safeguard your digital life.",
    imgSrc: "assets/password.png"
  },
  {
    title: "Score Game",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/React-Score",
    description: "ScoreKeeper app is applicable to any points-based game. It helps in accurately managing and keeping track of the score board, and displays the winner as well.",
    imgSrc: "assets/score.png"
  },
  {
    title: "Riot Games Clone UI",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Riot-Games-Landing-Page-Clone",
    description: "Riot Games Clone: A React project replicating the essence of Riot Games' popular gaming platform, offering a diverse gaming experience.",
    imgSrc: "assets/riot.png"
  },
  {
    title: "Stock Dashboard",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Stock_Dashboard",
    description: "This project gives the stock results for the unique company details and uses charts to display their historical and future predictions.",
    imgSrc: "assets/stock.png"
  },
  {
    title: "QR Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/QR_Generator",
    description: "A dynamic QR Code Generator that generates new QR codes for every input text or URL.",
    imgSrc: "assets/qr.png"
  },
  {
    title: "Color Palette Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Color-Palette-Generator",
    description: "A beautiful Color Palette Generator that generates harmonious color schemes with a click and easily copies hex codes. A useful tool for designers and developers.",
    imgSrc: "assets/color.png"
  },
  {
    title: "Blob Generator",
    url: "https://github.com/ojasggg/React-projects-for-beginners/tree/main/Blob_Generator",
    description: "Simple Application useful for creators and designers who require unique Blob CSS code.",
    imgSrc: "assets/blob.png"
  },
  {
    title: "Sorting Algorithm Visualizer",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/soritng_algorithm_visualizer",
    description: "This application has most of the sorting algorithms used in DSA and has a visual representation of how these sorting algorithms work in the background using clean UI in React.",
    imgSrc: "assets/algorithm.png"
  },
  {
    title: "Web3 Theme Landing Page",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/web3_landing_page",
    description: "Landing Page for Web3 applications. Used TailwindCSS for design and aos for minor animations.",
    imgSrc: "assets/web3.png"
  },
  {
    title: "Text to Speech Converter",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/text_to_speech",
    description: "Simple Website helpful to convert text written in the text area into voices. Controller of voice, sound, pitch and speed options are also provided.",
    imgSrc: "assets/text2speech.png"
  },
  {
    title: "YouTube Clone",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/youtube-clone",
    description: "Explore this YouTube clone project where I've recreated the core functionalities of YouTube using React, HTML, CSS, and JavaScript. Experience seamless video playback, user authentication, and video upload functionalities in this beginner-friendly project.",
    imgSrc: "assets/youtube.png"
  },
  {
    title: "Photoshop Clone",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Photoshop-Clone",
    description: "A photoshop like image editing application where you can edit brightness, saturation, hue, contrast etc. properties of the provided image",
    imgSrc: "assets/photoshop.png"
  },
  {
    title: "Tic-Tac-Toe Game",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Tic-Tac-toe",
    description: "Tic-Tac-Toe Game is a classic two-player game where opponents strategically place Xs and Os on a 3x3 grid, aiming to achieve a winning pattern of three in a row, column, or diagonal.",
    imgSrc: "assets/tic.png"
  },
  {
    title: "Credit-Card Validator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Credit-Card-Validator",
    description: "The program prompts the user to enter a number and determines whether it is a valid credit card number.",
    imgSrc: "assets/cc-validator.png"
  },
  {
    title: "Taskify Project",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Taskify-Project",
    description: "Taskify-Project is an organizational tool designed to streamline project management, enabling users to create, assign, and track tasks efficiently within a collaborative environment.",
    imgSrc: "assets/task.png"
  },
  {
    title: "Simple Movie Search",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/simple-movie-search-app",
    description: "Simple Movie Search is a straightforward tool allowing users to search for movies by title, providing basic information such as release year, genre, and synopsis.",
    imgSrc: "assets/smovie.png"
  },
  {
    title: "Shopapp Redux",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/shopapp%20redux",
    description: "Shop App Redux is a streamlined shopping experience powered by Redux, enhancing state management for seamless user interactions and efficient data handling.",
    imgSrc: "assets/shop.png"
  },
  {
    title: "React Tenzies App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/react-tenzies-game",
    description: "React Tenzies App is a web application built using the React JavaScript library, simulating the dice game Tenzi where players race to roll their dice to match a specific pattern, showcasing React's dynamic user interface capabilities.",
    imgSrc: "assets/teniz.png"
  },
  {
    title: "Quiz Game",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Quiz-Game",
    description: "Quiz Game is an interactive application that challenges players with questions on various topics, providing entertainment and opportunities for learning and testing knowledge.",
    imgSrc: "assets/quiz.png"
  },
  {
    title: "Personal Portfolio",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Personal%20Portfolio",
    description: "Personal Portfolio is a digital showcase of an individual's work, skills, and achievements, serving as a professional portfolio to highlight expertise and attract potential clients or employers.",
    imgSrc: "assets/portfolio.png"
  },
  {
    title: "Dice App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Dice-App",
    description: "A virtual dice-rolling application that simulates the randomness of traditional dice, offering convenience for various tabletop games and decision-making scenarios.",
    imgSrc: "assets/dice.png"
  },
  {
    title: "Covid-19 Tracker",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Covid-19_Tracker",
    description: "A tool for monitoring and visualizing real-time data on coronavirus cases, including infections, recoveries, and fatalities globally or regionally.",
    imgSrc: "assets/covid.png"
  },
  {
    title: "Bank-KYC Form",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Bank-KYC-Form",
    description: "A document where customers provide personal information and identification documents to comply with Know Your Customer regulations, ensuring legal and security compliance for banking services.",
    imgSrc: "assets/kyc.png"
  },
  {
    title: "Guess the Number Game",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Guess-the-number-react-app-main",
    description: "In the React Guess the Number Game, you try to figure out a secret number by making guesses.",
    imgSrc: "assets/guess.png"
  },
  {
    title: "Myth Weaver - Ai Story Generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Myth-Weaver",
    description: "Myth Weaver is a story-creating AI model. Just give a few prompts, and it will provide you with 5 short stories, each 60 words long.",
    imgSrc: "assets/story.png"
  },
  {
    title: "Twitter Clone",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/twitter_clone/Twitter-Final-main",
    description: "This is a simple Twitter Clone implementing the core features of Twitter.",
    imgSrc: "assets/twitter.png"
  },
  {
    title: "Spotify Clone",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Spotify-Clone",
    description: "This is a simple Spotify Clone implementing the core features of Spotify. All the important functionalities of Spotify are implemented and the backend part is there for those who need it.",
    imgSrc: "assets/spotify.png"
  },
  {
    title: "Markdown Previewer",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Markdown-Previewer",
    description: "Text to show on Hover",
    imgSrc: "assets/mark.png"
  },
  {
    title: "Kanban: Drag & Drop Board",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/draganddrop-board",
    description: "Its a simple drag and drop kanban style board to manage tasks",
    imgSrc: "assets/drag-and-drop.png"
  },
  {
    title: "ChatGram - Real Time Chat Application",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/chatgram",
    description: "Real Time Chatting Application",
    imgSrc: "assets/ChatGram.png"
  },
  {
    title: "Farmer - Landing Page",
    url: "https://landing.glitchastra.com/",
    description: "Common Landing Page for farmers",
    imgSrc: "assets/Farmer-landing.png"
  },
  {

    title: "React-password-Manager",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/React-password-manager",
    description: "A secure React-based password manager built with the MERN stack for storing and managing credentials.",
    imgSrc: "assets/Manager.png"
  },
  
  {
    title: "iNoteBook - A Platform for Notes",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/inotebook",
    description: "iNoteBook - Your notes, organized and accessible.",
    imgSrc: "assets/iNoteBook.png"
  },
  {
    title: "Typing Speed Tester",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Typing-test",
    description: "An everday app for those who aspire to have a fast typing speed.",
    imgSrc: "assets/typing.png"
  },
  {
    title: "Blood Donation",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Blood_Donation_Website/client",
    description: "A website to find nearest place to donate Blood",
    imgSrc: "assets/blood_bank.png"
  },
  {
    title: "IP Info",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/ip-info",
    description: "A website to know about your IP related information",
    imgSrc: "assets/ip_info.png"
  },
  {
    title: "MediSwift",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Medicine-Delivery-app",
    description: "MediSwift- Get your medicines at your doorstep",
    imgSrc: "assets/medicine_delivery.png"
  },
  {
    title: "MEME-generator",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/MEME-generator",
    description: "Generates meme on one click",
    imgSrc: "assets/memeG.png"
  },
  {
    title: "Personal Prtfolio",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Personal%20Portfolio",
    description: "A responsive personal website to showcase skills and projects",
    imgSrc: "assets/Bportfolio.png"
  },
  {
    title: "React-file-size-converter",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/react-file-size-converter",
    description: "A website to perform conversion of file size",
    imgSrc: "assets/file_size.png"
  },
  {
    title: "React Prtfolio",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/reactPortfolio",
    description: "A responsive personal website to showcase skills and projects",
    imgSrc: "assets/reactPortfolio.png"
  },
  {
    title: "Resume Builder",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Resume%20builder",
    description: "Input your information to get your Resume",
    imgSrc: "assets/resumeBuilder.png"
  },
  {
    title: "Submission Form",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/SubmissionForm-React",
    description: "A form to submit details",
    imgSrc: "assets/form.png"
  },
  {
    title: "Task-Manager-App",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/Task-Manager-App",
    description: "A React-based task manager web application built using the browser's localStorage API.",
    imgSrc: "assets/Taskmanager.png"
  },
  {
    title: "Wallet",
    url: "https://github.com/ianshulx/React-projects-for-beginners/tree/main/wallet",
    description: "A full-stack web app built using the MERN stack where you can send money, accept money and perform transaction",
    imgSrc: "assets/wallet.png"
  },
  {
    title:"Patreon clone",
    url:"https://github.com/ianshulx/React-projects-for-beginners/tree/main/patreon",
    description:"A Patreon clone is a platform that enables creators to earn recurring income by offering exclusive content and rewards to supporters",
    imgSrc:"assets/patreon.png"
  },
  {
    title:"Flash light toggle",
    url:"https://github.com/ianshulx/React-projects-for-beginners/tree/main-616/Flashlight-Toggle-App",
    description:"This app changes the background color to simulate a flashlight turning on and off.",
    imgSrc:"assets/flashlight.png"
  },
  {
    title:"Reaction-time tester",
    url:"https://github.com/ianshulx/React-projects-for-beginners/tree/main-616/Reaction-Time-Tester",
    description:"A React app that tests your reaction speed by measuring the time taken to respond to prompts",
    imgSrc:"assets/response.png"
  },
  {
    title:"Learning Streak Tracker",
    url:"https://github.com/ianshulx/React-projects-for-beginners/tree/main-616/Learning%20Streak%20Tracker",
    description:"A React app that tracks and motivates your daily learning streaks to build consistent study habits.",
    imgSrc:"assets/streak.png"
  },
 
];

const container = document.getElementById('projects-container');

projects.forEach(project => {
  const projectDiv = document.createElement('div');
  projectDiv.className = 'col-md-2 mb-4 d-md-inline-block';
  projectDiv.innerHTML = `
      <div class="custom-card text-center" data-bs-toggle="tooltip" data-bs-placement="top" title="${project.description}">
        <div class="card-body">
          <a href="${project.url}" target="_blank">
            <img src="${project.imgSrc}" class="card-img-top rounded-circle mx-auto d-block" alt="React App" style="width: 85px; height:85px">
            <h5 class="card-title">${project.title}</h5>
          </a>
        </div>
      </div>
    `;
  container.appendChild(projectDiv);
});