import React, { useState } from "react";
import "./App.css";

function App() {
  const [meme, setMeme] = useState({ url: "", title: "", author: "" });

  const updateDetails = (url, title, author) => {
    setMeme({ url, title, author });
  };

  const generateMeme = () => {
    fetch("https://meme-api.com/gimme/wholesomememes")
      .then((response) => response.json())
      .then((data) => {
        updateDetails(data.url, data.title, data.author);
      });
  };

  return (
    <div className="flex flex-col items-center justify-center min-h-screen bg-slate-500">
      <div className="bg-white rounded-lg shadow-lg w-80 overflow-hidden">
        {meme.url && (
          <img
            src={meme.url}
            alt="meme"
            className="object-contain w-full h-[50vh]"
          />
        )}

        <div className="p-4">
          <h5 className="text-xl font-semibold text-gray-800">{meme.title}</h5>
          {meme.author && (
            <p className="text-gray-600 mt-1">
              Generated by: {meme.author || "Unknown"}
            </p>
          )}
          {!meme.url && (
            <p className="text-slate-900 mt-2">
              Generate random memes by using APIs..!
            </p>
          )}
        </div>
      </div>

      <button
        type="button"
        className="flex justify-center items-center mx-auto shadow-xl text-lg bg-blue-700 text-white font-semibold rounded-full px-4 py-2 mt-4 transition duration-300  hover:text-white"
        onClick={generateMeme}
      >
        Generate Meme
      </button>
    </div>
  );
}

export default App;
