var declared_services;
var compiled;
var go_first_output;
var recording = false;
var intercept = false;
var theme = "material";
var global_used_refs = [];
var cfn_spacing = "    ";

setTimeout(function(){
    chrome.storage.local.get('blocking', function (isBlocking) {
        if (isBlocking.blocking !== undefined) {
            blocking = isBlocking.blocking;
        }
    });
    
    chrome.storage.local.get('intercept', function (isIntercepting) {
        if (isIntercepting.intercept !== undefined) {
            intercept = isIntercepting.intercept;
        }
    });
    
    chrome.storage.local.get('theme', function (whichTheme) {
        if (whichTheme.theme !== undefined) {
            theme = whichTheme.theme;
        }
    });
    
    chrome.storage.local.get('cfnspacing', function (cfnspacing) {
        if (cfnspacing.cfnspacing !== undefined) {
            if (cfnspacing.cfnspacing == 4) {
                cfn_spacing = "    ";
            } else if (cfnspacing.cfnspacing == 2) {
                cfn_spacing = "  ";
            }
        }
    });
}, 1);

function b64tonumber(str) {
    var alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789$_'.split('')
    var result = 0;
    var input_tokens = str.split('');
    var e;
    for (var e in input_tokens) {
        result = ( result * 64 ) + alphabet.indexOf( input_tokens[e] );
    }
    return result;
}

function interpretGwtArg(tracker, expected_type) {
    var index = parseInt(tracker.pipesplit[tracker.cursor]);

    if (index == 0) {
        tracker.cursor += 1;
        return {
            'value': null,
            'type': null
        }
    } else if (index < 0) {
        tracker.cursor += 1;
        return tracker.resolvedObjects[Math.abs(index)];
    }

    if (expected_type == "java.lang.String/2004016611") {
        arg_type = "java.lang.String/2004016611";
    } else if (expected_type == "java.lang.Boolean/476441737") {
        arg_type = "java.lang.Boolean/476441737";
    } else {
        var arg_type = tracker.params[index];
        tracker.cursor += 1;
    }

    if (arg_type == "amazonaws.console.common.dtos.Regions$Region/2677748408") {
        var ret = {
            'type': arg_type
        };
        tracker.resolvedObjects.push(ret);

        while (!tracker.params[parseInt(tracker.pipesplit[tracker.cursor])].endsWith(".amazonaws.com")) {
            tracker.cursor += 1;
        }
        tracker.cursor += 6;

        var region = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 7;

        ret['value'] = region;

        return ret;
    } else if (arg_type == "java.lang.Integer/3438268394") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var val = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        ret['value'] = val;

        return ret;
    } else if (arg_type == "java.lang.String/2004016611") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var val = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['value'] = val;

        return ret;
    } else if (arg_type == "java.lang.Long/4227064769") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var val = b64tonumber(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        ret['value'] = val;

        return ret;
    } else if (arg_type == "java.lang.Boolean/476441737") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var val = Boolean(parseInt(tracker.pipesplit[tracker.cursor]));
        tracker.cursor += 1;

        ret['value'] = val;

        return ret;
    } else if (arg_type == "java.util.ArrayList/4159755760") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var arr = [];
        var array_length = tracker.pipesplit[tracker.cursor];
        tracker.cursor += 1;

        for (var i=0; i<array_length; i++) {
            arr.push(interpretGwtArg(tracker));
        }

        ret['value'] = arr;

        return ret;
    } else if (arg_type == "com.amazonaws.internal.ListWithAutoConstructFlag/2962671489") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var arr = [];
        var auto_construct_flag = tracker.pipesplit[tracker.cursor];
        tracker.cursor += 1;
        var array_length = tracker.pipesplit[tracker.cursor];
        tracker.cursor += 1;

        for (var i=0; i<array_length; i++) {
            arr.push(interpretGwtArg(tracker));
        }

        ret['auto_construct_flag'] = auto_construct_flag;
        ret['value'] = arr;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.configurationSet.EventDestination/1743070390") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var cloudwatchdestination = interpretGwtArg(tracker);
        var enabled = (parseInt(tracker.pipesplit[tracker.cursor]) == 1);
        tracker.cursor += 1;
        var eventtypes = interpretGwtArg(tracker);
        var kinesisdestination = interpretGwtArg(tracker);
        var eventname = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        interpretGwtArg(tracker); // probably SNSDestination?
        var eventdestinationstatus = interpretGwtArg(tracker);

        ret['enabled'] = enabled;
        ret['eventtypes'] = eventtypes;
        ret['cloudwatchdestination'] = cloudwatchdestination;
        ret['kinesisdestination'] = kinesisdestination;
        ret['eventname'] = eventname;
        ret['eventdestinationstatus'] = eventdestinationstatus;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.configurationSet.EventType/3840887836") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var eventtypes_enum = ['send','reject','bounce','complaint','delivery','open','click','renderingFailure'];

        var eventtype = eventtypes_enum[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['eventtype'] = eventtype;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.configurationSet.KinesisFirehoseDestination/2935040581") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var arn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var role = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        tracker.cursor += 1; // verified domain ?

        ret['arn'] = arn;
        ret['role'] = role;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.configurationSet.CloudWatchDestination/2780889431") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var dimensions = interpretGwtArg(tracker);

        ret['dimensions'] = dimensions;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.configurationSet.CloudWatchDimensionConfigurations/1770148543") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var value = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var name = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var source = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['value'] = value;
        ret['name'] = name;
        ret['source'] = source;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.configurationSet.SNSDestination/60332510") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var arn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['arn'] = arn;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.InboundFilter/855140093") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var cidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var name = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 2;
        var allow_boolean = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        ret['cidr'] = cidr;
        ret['name'] = name;
        if (allow_boolean) {
            ret['action'] = 'Allow';
        } else {
            ret['action'] = 'Block';
        }

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.configurationSet.EventDestinationStatus/111633783") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var status = (parseInt(tracker.pipesplit[tracker.cursor]) == 1); // cast boolean
        tracker.cursor += 1;

        ret['status'] = status;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.AddHeaderAction/467599610") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var headername = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var headervalue = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var val3 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var val4 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['headername'] = headername;
        ret['headervalue'] = headervalue;
        ret['val3'] = val3;
        ret['val4'] = val4;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.BounceAction/1812843977") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var message = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var sender = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var smtpreplycode = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var statuscode = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var val5 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var topicarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['message'] = message;
        ret['sender'] = sender;
        ret['smtpreplycode'] = smtpreplycode;
        ret['statuscode'] = statuscode;
        ret['val5'] = val5;
        ret['topicarn'] = topicarn;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.LambdaAction/1097769813") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var functionarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var invocationtype = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var val3 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var topicarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['functionarn'] = functionarn;
        ret['invocationtype'] = invocationtype;
        ret['val3'] = val3;
        ret['topicarn'] = topicarn;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.S3Action/3998072397") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var bucketname = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var val2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var kmskeyarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var objectkeyprefix = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var val5 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var topicarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['bucketname'] = bucketname;
        ret['val2'] = val2;
        ret['kmskeyarn'] = kmskeyarn;
        ret['objectkeyprefix'] = objectkeyprefix;
        ret['val5'] = val5;
        ret['topicarn'] = topicarn;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.SNSAction/1093049066") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var encoding = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var val2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var topicarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['encoding'] = encoding;
        ret['val2'] = val2;
        ret['topicarn'] = topicarn;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.WorkMailAction/4106534622") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var organizationarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var val2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var topicarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['organizationarn'] = organizationarn;
        ret['val2'] = val2;
        ret['topicarn'] = topicarn;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.StopAction/708585167") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var val1 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var topicarn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['val1'] = val1;
        ret['topicarn'] = topicarn;

        return ret;
    } else if (arg_type == "com.amazon.bacon.console.shared.types.inbound.ReceiptRule/4059515547") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var actions = interpretGwtArg(tracker);

        var enabled = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        var recipients = interpretGwtArg(tracker);

        var name = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        var spamvirusscanning = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var tls = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        ret['actions'] = actions;
        ret['recipients'] = recipients;
        ret['name'] = name;
        ret['enabled'] = enabled;
        ret['spamvirusscanning'] = spamvirusscanning;
        ret['tls'] = tls;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.FirewallRule/883972025") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var ruleId = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var protocol = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var portStart = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var portEnd = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var cidr = interpretGwtArg(tracker);
        interpretGwtArg(tracker);
        interpretGwtArg(tracker);
        var action = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var ruleDirection = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['value'] = ruleId;
        ret['ruleId'] = ruleId;
        ret['protocol'] = protocol;
        ret['portStart'] = portStart;
        ret['portEnd'] = portEnd;
        ret['cidr'] = cidr;
        ret['action'] = action;
        ret['ruleDirection'] = ruleDirection;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.Route/2658103323") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var cidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var destination = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 5;
        var action = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var status = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 4;
        var ipv6cidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 2;

        ret['cidr'] = cidr;
        ret['destination'] = destination;
        ret['action'] = action;
        ret['status'] = status;
        ret['ipv6cidr'] = ipv6cidr;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.RouteTable/2977847614") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var unknownarray1 = interpretGwtArg(tracker);
        var cidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknownboolean1 = interpretGwtArg(tracker);
        var unknown2 = interpretGwtArg(tracker);
        var unknownarray2 = interpretGwtArg(tracker);
        var routetableid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var routes = interpretGwtArg(tracker);
        var unknownarray3 = interpretGwtArg(tracker);
        var vpcid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown3 = interpretGwtArg(tracker);

        ret['unknownarray1'] = unknownarray1;
        ret['cidr'] = vpccidr;
        ret['unknownboolean1'] = unknownboolean1;
        ret['unknown2'] = unknown2;
        ret['unknownarray2'] = unknownarray2;
        ret['routetableid'] = routetableid;
        ret['routes'] = routes;
        ret['unknownarray3'] = unknownarray3;
        ret['vpcid'] = vpcid;
        ret['unknown3'] = unknown3;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.IGW/344372469") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var igwid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown1 = interpretGwtArg(tracker);
        var unknown2 = interpretGwtArg(tracker);
        var unknown3 = interpretGwtArg(tracker);
        var unknownarray1 = interpretGwtArg(tracker);
        var unknownarray2 = interpretGwtArg(tracker);

        ret['igwid'] = igwid;
        ret['unknown1'] = unknown1;
        ret['unknown2'] = unknown2;
        ret['unknown3'] = unknown3;
        ret['unknownarray1'] = unknownarray1;
        ret['unknownarray2'] = unknownarray2;

        return ret;
    } else if (arg_type == "com.amazonaws.services.route53.model.Change/107219911") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var action = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var recordset = interpretGwtArg(tracker);

        ret['action'] = action;
        ret['recordset'] = recordset;

        return ret;
    } else if (arg_type == "com.amazonaws.services.route53.model.ResourceRecordSet/2237386177") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        tracker.cursor += 5;
        var recordname = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 2;
        var records = interpretGwtArg(tracker);

        ret['recordname'] = recordname;
        ret['records'] = records;

        return ret;
    } else if (arg_type == "com.amazonaws.services.route53.model.ResourceRecord/3609806506") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var value = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 2;
        var ttl = interpretGwtArg(tracker); // oh my god!
        tracker.cursor += 1;
        var recordtype = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];

        ret['value'] = value;
        ret['ttl'] = ttl;
        ret['recordtype'] = recordtype;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.CloudFrontOriginAccessIdentityConfig/902378263") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var timestamp = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var comment = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['timestamp'] = timestamp;
        ret['comment'] = comment;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.StreamingDistributionConfig/2353713719") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        tracker.resolvedObjects.push(null); // TODO: Why this?

        var aliases = interpretGwtArg(tracker);
        var timestamp = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var comment = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var enabled = interpretGwtArg(tracker);
        var logging = interpretGwtArg(tracker);
        var priceclass = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var s3origin = interpretGwtArg(tracker);
        var trustedsigners = interpretGwtArg(tracker);

        ret['aliases'] = aliases;
        ret['timestamp'] = timestamp;
        ret['comment'] = comment;
        ret['enabled'] = enabled;
        ret['logging'] = logging;
        ret['priceclass'] = priceclass;
        ret['s3origin'] = s3origin;
        ret['trustedsigners'] = trustedsigners;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.Aliases/4239770237") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push("###TEMP"); // TODO: Fix
        tracker.resolvedObjects.push(ret);

        var items = interpretGwtArg(tracker);
        var quantity = interpretGwtArg(tracker);

        ret['items'] = items;
        ret['quantity'] = quantity;

        return ret;
    } else if (arg_type == "com.amazonaws.swf.console.gwtcoral.client.com.amazonaws.swf.service.model.RegisterDomainInput/54427647") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var description = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var name = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var days = parseInt(tracker.params[parseInt(tracker.pipesplit[tracker.cursor])]);
        tracker.cursor += 1;

        ret['description'] = description;
        ret['name'] = name;
        ret['days'] = days;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.StreamingLoggingConfig/2911843366") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var bucket = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var enabled = interpretGwtArg(tracker);
        var prefix = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['bucket'] = bucket;
        ret['enabled'] = enabled;
        ret['prefix'] = prefix;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.S3Origin/2254162173") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var domainname = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var identity = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['domainname'] = domainname;
        ret['identity'] = identity;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.TrustedSigners/178143467") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var enabled = interpretGwtArg(tracker);
        var items = interpretGwtArg(tracker);
        var quantity = interpretGwtArg(tracker);

        ret['enabled'] = enabled;
        ret['items'] = items;
        ret['quantity'] = quantity;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.wizard.CreateVPCWithPublicSubnet/3792845633") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var amazonprovidedipv6 = interpretGwtArg(tracker);
        var publicsubnetlocation = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var igw = interpretGwtArg(tracker);
        var stepnumber = interpretGwtArg(tracker);
        var subnetcustomipv6 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var routetable = interpretGwtArg(tracker);
        var routetableassociationid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var subnet = interpretGwtArg(tracker);
        var subnetcidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var subnetname = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown5 = interpretGwtArg(tracker);
        var unknown6 = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var unknown7 = interpretGwtArg(tracker);
        var enablednshostnames = (parseInt(tracker.pipesplit[tracker.cursor]) == 1);
        tracker.cursor += 1;
        var unknown9 = interpretGwtArg(tracker);
        var unknown10 = interpretGwtArg(tracker);
        var tenancy = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var vpcobject = interpretGwtArg(tracker);
        var vpccidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var vpcname = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];

        ret['amazonprovidedipv6'] = amazonprovidedipv6;
        ret['publicsubnetlocation'] = publicsubnetlocation;
        ret['igw'] = igw;
        ret['stepnumber'] = stepnumber;
        ret['subnetcustomipv6'] = subnetcustomipv6;
        ret['routetable'] = routetable;
        ret['routetableassociationid'] = routetableassociationid;
        ret['subnet'] = subnet;
        ret['subnetcidr'] = subnetcidr;
        ret['subnetname'] = subnetname;
        ret['unknown5'] = unknown5;
        ret['unknown6'] = unknown6;
        ret['unknown7'] = unknown7;
        ret['enablednshostnames'] = enablednshostnames;
        ret['unknown9'] = unknown9;
        ret['unknown10'] = unknown10;
        ret['tenancy'] = tenancy;
        ret['vpcobject'] = vpcobject;
        ret['vpccidr'] = vpccidr;
        ret['vpcname'] = vpcname;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.wizard.CreateVPCWithPublicSubnet$PublicOnlySteps/3843543372") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var stepnumber = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        ret['stepnumber'] = stepnumber;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.Vpc/3236476168") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var vpcid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var vpcstatus = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var vpccidrblock = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var dhcpoptionsid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var dhcpoptionsid2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var routetableid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var routetableid2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var aclid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var aclid2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var tenancy = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown1 = interpretGwtArg(tracker);
        var tags = interpretGwtArg(tracker);
        var unknown2 = interpretGwtArg(tracker);
        var unknown3 = interpretGwtArg(tracker);
        var cidrblockassociations = interpretGwtArg(tracker);
        var ipv6cidrblockassociations = interpretGwtArg(tracker);
        var unknownstring1 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['vpcid'] = vpcid;
        ret['vpcstatus'] = vpcstatus;
        ret['vpccidrblock'] = vpccidrblock;
        ret['dhcpoptionsid'] = dhcpoptionsid;
        ret['dhcpoptionsid2'] = dhcpoptionsid2;
        ret['routetableid'] = routetableid;
        ret['routetableid2'] = routetableid2;
        ret['aclid'] = aclid;
        ret['aclid2'] = aclid2;
        ret['tenancy'] = tenancy;
        ret['unknown1'] = unknown1;
        ret['tags'] = tags;
        ret['unknown2'] = unknown2;
        ret['unknown3'] = unknown3;
        ret['cidrblockassociations'] = cidrblockassociations;
        ret['ipv6cidrblockassociations'] = ipv6cidrblockassociations;
        ret['unknownstring1'] = unknownstring1;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.Subnet/3680019525") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var subnetid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var status = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var vpcid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown1 = interpretGwtArg(tracker);
        var subnetcidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var ipv6cidrassociations = interpretGwtArg(tracker);
        var unknownint = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var availabilityzone = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown3 = interpretGwtArg(tracker);
        var unknown4 = interpretGwtArg(tracker);
        var unknown5 = interpretGwtArg(tracker);
        var tags = interpretGwtArg(tracker);
        var unknown6 = interpretGwtArg(tracker);
        var unknown7 = interpretGwtArg(tracker);
        var unknown8 = interpretGwtArg(tracker);
        var unknown9 = interpretGwtArg(tracker);

        ret['subnetid'] = subnetid;
        ret['status'] = status;
        ret['vpcid'] = vpcid;
        ret['unknown1'] = unknown1;
        ret['subnetcidr'] = subnetcidr;
        ret['ipv6cidrassociations'] = ipv6cidrassociations;
        ret['unknownint'] = unknownint;
        ret['availabilityzone'] = availabilityzone;
        ret['unknown3'] = unknown3;
        ret['unknown4'] = unknown4;
        ret['unknown5'] = unknown5;
        ret['tags'] = tags;
        ret['unknown6'] = unknown6;
        ret['unknown7'] = unknown7;
        ret['unknown8'] = unknown8;
        ret['unknown9'] = unknown9;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.Tag/2711077645") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var key = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var value = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['key'] = key;
        ret['value'] = value;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.CidrBlockAssociation/2848919076") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var associationid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var cidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var status = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown1 = interpretGwtArg(tracker);

        ret['associationid'] = associationid;
        ret['cidr'] = cidr;
        ret['status'] = status;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.IPv6SubnetCidrBlockAssociation/3374664153") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var associationid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var cidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var status = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown1 = interpretGwtArg(tracker);

        ret['associationid'] = associationid;
        ret['cidr'] = cidr;
        ret['status'] = status;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "amazonaws.console.vpc.dtos.IPv6VpcCidrBlockAssociation/1461627452") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var associationid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var cidr = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var status = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknown1 = interpretGwtArg(tracker);

        ret['associationid'] = associationid;
        ret['cidr'] = cidr;
        ret['status'] = status;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.CustomErrorResponses/1121464496") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push("###TEMP"); // TODO: Fix
        tracker.resolvedObjects.push("###TEMP"); // TODO: Fix
        tracker.resolvedObjects.push(ret);

        var unknown1 = interpretGwtArg(tracker);

        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.CacheBehaviors/2829792424") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var unknown1 = interpretGwtArg(tracker);

        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.CookiePreference/3547444623") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var preference = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['preference'] = preference;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.CookieNames/65691594") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var cookienames = interpretGwtArg(tracker);
        var unknown1 = interpretGwtArg(tracker);

        ret['cookienames'] = cookienames;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.Headers/1360842881") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var headers = interpretGwtArg(tracker);
        var unknown1 = interpretGwtArg(tracker);

        ret['headers'] = headers;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.QueryStringCacheKeys/3357483778") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var keys = interpretGwtArg(tracker);
        var unknown1 = interpretGwtArg(tracker);

        ret['keys'] = keys;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.LambdaFunctionAssociations/968553882") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var associations = interpretGwtArg(tracker);
        var unknown1 = interpretGwtArg(tracker);

        ret['associations'] = associations;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.Origins/2653494639") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var origins = interpretGwtArg(tracker);
        var unknown1 = interpretGwtArg(tracker);

        ret['origins'] = origins;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.CustomHeaders/706640089") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var headers = interpretGwtArg(tracker);
        var unknown1 = interpretGwtArg(tracker);

        ret['headers'] = headers;
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.S3OriginConfig/3065886742") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var originaccessid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['originaccessid'] = originaccessid;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.OriginCustomHeader/4282815861") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var key = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var value = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['key'] = key;
        ret['value'] = value;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.Origin/1619145402") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var customheaders = interpretGwtArg(tracker);
        var unknown1 = interpretGwtArg(tracker);
        var domainname = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var originid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var path = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var s3originconfig = interpretGwtArg(tracker);

        ret['customheaders'] = customheaders;
        ret['unknown1'] = unknown1;
        ret['domainname'] = domainname;
        ret['originid'] = originid;
        ret['path'] = path;
        ret['s3originconfig'] = s3originconfig;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.LoggingConfig/2208632355") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var bucket = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var enabled = interpretGwtArg(tracker);
        var includecookies = interpretGwtArg(tracker);
        var prefix = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['bucket'] = bucket;
        ret['enabled'] = enabled;
        ret['includecookies'] = includecookies;
        ret['prefix'] = prefix;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.ForwardedValues/1684831373") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var cookiepreference = interpretGwtArg(tracker);
        var cookienames = interpretGwtArg(tracker);
        var headers = interpretGwtArg(tracker);
        var querystring = interpretGwtArg(tracker);
        var querystringcachekeys = interpretGwtArg(tracker);

        ret['cookiepreference'] = cookiepreference;
        ret['cookienames'] = cookienames;
        ret['headers'] = headers;
        ret['querystring'] = querystring;
        ret['querystringcachekeys'] = querystringcachekeys;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.Restrictions/923540952") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var geo = interpretGwtArg(tracker);
        
        ret['geo'] = geo;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.GeoRestriction/1846888439") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var unknown1 = interpretGwtArg(tracker);
        
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.ViewerCertificate/2542029139") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var unknown1 = interpretGwtArg(tracker);
        
        ret['unknown1'] = unknown1;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.DefaultCacheBehavior/3349440463") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var type1 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var type2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var listtype1 = interpretGwtArg(tracker);
        var counttype1 = interpretGwtArg(tracker);
        var listtype2 = interpretGwtArg(tracker);
        var counttype2 = interpretGwtArg(tracker);
        var compress = interpretGwtArg(tracker);
        var defaultttl = interpretGwtArg(tracker);
        var unknownstring1 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var forwardvalues = interpretGwtArg(tracker);
        var lambdafunctionassociations = interpretGwtArg(tracker);
        var maxttl = interpretGwtArg(tracker);
        var minttl = interpretGwtArg(tracker);
        var smooth = interpretGwtArg(tracker);
        var targetoriginid = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var trustedsigners = interpretGwtArg(tracker);
        
        ret['type1'] = type1;
        ret['type2'] = type2;
        ret['listtype1'] = listtype1;
        ret['counttype1'] = counttype1;
        ret['listtype2'] = listtype2;
        ret['counttype2'] = counttype2;
        ret['compress'] = compress;
        ret['defaultttl'] = defaultttl;
        ret['unknownstring1'] = unknownstring1;
        ret['forwardvalues'] = forwardvalues;
        ret['lambdafunctionassociations'] = lambdafunctionassociations;
        ret['maxttl'] = maxttl;
        ret['minttl'] = minttl;
        ret['smooth'] = smooth;
        ret['targetoriginid'] = targetoriginid;
        ret['trustedsigners'] = trustedsigners;

        return ret;
    } else if (arg_type == "com.amazonaws.services.cloudfront.model.DistributionConfig/1312485537") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var aliases = interpretGwtArg(tracker);
        var cachebehaviours = interpretGwtArg(tracker);
        var unknownint1 = interpretGwtArg(tracker);
        var timestamp = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var comment = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var customerrorresponses = interpretGwtArg(tracker);
        var unknown1 = interpretGwtArg(tracker);
        var defaultcachebehaviour = interpretGwtArg(tracker);
        var viewerprotocolpolicy = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var rootobject = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var enabled = interpretGwtArg(tracker);
        var supportedhttpversion = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var ipv6support = interpretGwtArg(tracker);
        var loggingconfig = interpretGwtArg(tracker);
        var unknown4 = interpretGwtArg(tracker);
        var origins = interpretGwtArg(tracker);
        var priceclass = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var restrictions = interpretGwtArg(tracker);
        var unknown5 = interpretGwtArg(tracker);
        var unknownstring1 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var viewercertificate = interpretGwtArg(tracker);
        var unknown6 = interpretGwtArg(tracker);
        var unknown7 = interpretGwtArg(tracker);
        var unknown8 = interpretGwtArg(tracker);
        var unknown9 = interpretGwtArg(tracker);
        var tlsversion = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknownstring2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknownstring3 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;

        ret['aliases'] = aliases;
        ret['cachebehaviours'] = cachebehaviours;
        ret['unknownint1'] = unknownint1;
        ret['timestamp'] = timestamp;
        ret['comment'] = comment;
        ret['customerrorresponses'] = customerrorresponses;
        ret['unknown1'] = unknown1;
        ret['defaultcachebehaviour'] = defaultcachebehaviour;
        ret['viewerprotocolpolicy'] = viewerprotocolpolicy;
        ret['rootobject'] = rootobject;
        ret['enabled'] = enabled;
        ret['supportedhttpversion'] = supportedhttpversion;
        ret['ipv6support'] = ipv6support;
        ret['loggingconfig'] = loggingconfig;
        ret['unknown4'] = unknown4;
        ret['origins'] = origins;
        ret['priceclass'] = priceclass;
        ret['restrictions'] = restrictions;
        ret['unknown5'] = unknown5;
        ret['unknownstring1'] = unknownstring1;
        ret['viewercertificate'] = viewercertificate;
        ret['unknown6'] = unknown6;
        ret['unknown7'] = unknown7;
        ret['unknown8'] = unknown8;
        ret['unknown9'] = unknown9;
        ret['tlsversion'] = tlsversion;
        ret['unknownstring2'] = unknownstring2;
        ret['unknownstring3'] = unknownstring3;

        return ret;
    } else if (arg_type == "edp.console.client.model.Role/1394926005") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var arn = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknownarray1 = interpretGwtArg(tracker);
        var name = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var unknownstring1 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var name2 = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        
        ret['arn'] = arn;
        ret['unknownarray1'] = unknownarray1;
        ret['name'] = name;
        ret['unknownstring1'] = unknownstring1;
        ret['name2'] = name2;

        return ret;
    } else if (arg_type == "edp.console.client.model.DefaultObjectProperties/1857086444") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var pipelinerole = interpretGwtArg(tracker);
        
        ret['pipelinerole'] = pipelinerole;

        return ret;
    } else if (arg_type == "edp.console.client.model.Ending/1349908719") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var endingtype = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var unknownbool1 = interpretGwtArg(tracker);
        var occurancecount = interpretGwtArg(tracker);
        
        ret['endingtype'] = endingtype;
        ret['unknownbool1'] = unknownbool1;
        ret['occurancecount'] = occurancecount;

        return ret;
    } else if (arg_type == "edp.console.client.model.typeDef.StandardScheduleType/3790816381") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var scheduletype = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        
        ret['scheduletype'] = scheduletype;

        return ret;
    } else if (arg_type == "edp.console.client.model.Starting/360569834") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var timestamp = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var startingtype = interpretGwtArg(tracker);
        
        ret['timestamp'] = timestamp;
        ret['startingtype'] = startingtype;

        return ret;
    } else if (arg_type == "edp.console.client.model.Starting$Type/1371883812") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var startingtype = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        
        ret['startingtype'] = startingtype;

        return ret;
    } else if (arg_type == "edp.console.client.model.ScheduleInfo/2346623989") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var ending = interpretGwtArg(tracker);
        var runeverynumber = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;
        var runeverymetric = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var scheduletype = interpretGwtArg(tracker);
        var starting = interpretGwtArg(tracker);
        
        ret['ending'] = ending;
        ret['runeverynumber'] = runeverynumber;
        ret['runeverymetric'] = runeverymetric;
        ret['scheduletype'] = scheduletype;
        ret['starting'] = starting;

        return ret;
    } else if (arg_type == "edp.console.client.model.PipelineDefinition/1154738008") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var objects = interpretGwtArg(tracker);
        
        ret['objects'] = objects;

        return ret;
    } else if (arg_type == "edp.console.client.model.ObjectId/1185543638") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var id = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        
        ret['id'] = id;

        return ret;
    } else if (arg_type == "edp.console.client.model.PipelineId/2380834385") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var id = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        
        ret['id'] = id;

        return ret;
    } else if (arg_type == "edp.console.client.model.EdpValues/3097304520") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var values = interpretGwtArg(tracker);
        
        ret['values'] = values;

        return ret;
    } else if (arg_type == "edp.console.client.model.EdpValue/3514483194") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var unknown1 = interpretGwtArg(tracker);
        var value = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        
        ret['unknown1'] = unknown1;
        ret['value'] = value;

        return ret;
    } else if (arg_type == "edp.console.client.model.EdpObject/4062271627") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var unknown1 = interpretGwtArg(tracker);
        var unknown2 = interpretGwtArg(tracker);
        var unknown3 = interpretGwtArg(tracker);
        var pipelineid = interpretGwtArg(tracker);
        var values = interpretGwtArg(tracker);
        
        ret['unknown1'] = unknown1;
        ret['unknown2'] = unknown2;
        ret['unknown3'] = unknown3;
        ret['pipelineid'] = pipelineid;
        ret['values'] = values;

        return ret;
    } else if (arg_type == "java.util.HashMap/1797211028") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var items = [];

        var itemcount = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        for (var i=0; i<itemcount; i++) {
            items.push({
                'key': interpretGwtArg(tracker),
                'value': interpretGwtArg(tracker)
            });
        }
        
        ret['items'] = items;

        return ret;
    } else if (arg_type == "edp.console.client.model.PipelineParameterValues/461930119") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var values = interpretGwtArg(tracker);
        
        ret['values'] = values;

        return ret;
    } else if (arg_type == "com.google.common.collect.LinkedListMultimap/1729837690") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var items = [];

        var itemcount = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        for (var i=0; i<itemcount; i++) {
            items.push({
                'key': interpretGwtArg(tracker),
                'value': interpretGwtArg(tracker)
            });
        }
        
        ret['items'] = items;

        return ret;
    } else if (arg_type == "edp.console.client.model.PipelineParametersObjects/3330658573") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var objects = interpretGwtArg(tracker);
        
        ret['objects'] = objects;

        return ret;
    } else if (arg_type == "edp.console.client.model.PipelineParameterObject/4140314217") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var values = interpretGwtArg(tracker);
        
        ret['values'] = values;

        return ret;
    } else if (arg_type == "com.google.common.collect.ArrayListMultimap/3900168773") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var items = [];

        var itemcount = parseInt(tracker.pipesplit[tracker.cursor]);
        tracker.cursor += 1;

        for (var i=0; i<itemcount; i++) {
            var key = interpretGwtArg(tracker);
            var valuecount = parseInt(tracker.pipesplit[tracker.cursor]);
            tracker.cursor += 1;
            var values = [];
            for (var j=0; j<valuecount; j++) {
                values.push(interpretGwtArg(tracker));
            }
            items.push({
                'key': key,
                'value': values
            });
        }
        
        ret['items'] = items;

        return ret;
    } else if (arg_type == "edp.console.client.model.PipelineTag/4209464192") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push(ret);

        var tagkey = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var tagvalue = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        
        ret['tagkey'] = tagkey;
        ret['tagvalue'] = tagvalue;

        return ret;
    } else if (arg_type == "edp.console.client.commands.CreatePipelineAction/2605870699") {
        var ret = {
            'type': arg_type
        }
        tracker.resolvedObjects.push("###TEMP");
        tracker.resolvedObjects.push(ret);

        var defaultobjectproperties = interpretGwtArg(tracker);
        var logginglocation = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var ec2instancerole = interpretGwtArg(tracker);
        var scheduleinfo = interpretGwtArg(tracker);
        var pipelinedefinition = interpretGwtArg(tracker);
        var pipelineid = interpretGwtArg(tracker);
        var description = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var name = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        var pipelineparametervalues = interpretGwtArg(tracker);
        var pipelineparameterobjects = interpretGwtArg(tracker);
        var tags = interpretGwtArg(tracker);
        var pipelinedefinitionjson = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
        tracker.cursor += 1;
        
        ret['defaultobjectproperties'] = defaultobjectproperties;
        ret['logginglocation'] = logginglocation;
        ret['ec2instancerole'] = ec2instancerole;
        ret['scheduleinfo'] = scheduleinfo;
        ret['pipelinedefinition'] = pipelinedefinition;
        ret['pipelineid'] = pipelineid;
        ret['description'] = description;
        ret['name'] = name;
        ret['pipelineparametervalues'] = pipelineparametervalues;
        ret['pipelineparameterobjects'] = pipelineparameterobjects;
        ret['tags'] = tags;
        ret['pipelinedefinitionjson'] = pipelinedefinitionjson;

        return ret;
    } else {
        var ret = {
            'type': 'unknown'
        };
        tracker.resolvedObjects.push(ret);

        console.log("Unknown GWT type: " + arg_type);
        console.log(tracker.cursor);
        console.dir(tracker);

        var val = tracker.pipesplit[tracker.cursor];
        tracker.cursor += 1;

        ret['value'] = val;

        return ret;
    }
}

function interpretGwtWireRequest(str) {
    var xsrfRequested = false;
    var args = [];
    var arg_types = [];

    if (!str) return {};
    if (str.split("|").length < 5) return {};

    var tracker = {
        'params': [null], // 1-indexed
        'cursor': 0,
        'args': [],
        'resolvedObjects': [null], // 1-indexed
        'pipesplit': str.split("|")
    }

    if (parseInt(tracker.pipesplit[tracker.cursor]) != 7) {
        return {};
    }
    tracker.cursor += 1;

    if (parseInt(tracker.pipesplit[tracker.cursor]) == 2) {
        xsrfRequested = true;
    }
    tracker.cursor += 1;

    var param_count = parseInt(tracker.pipesplit[tracker.cursor]);

    for (var i=0; i<param_count; i++) {
        tracker.cursor += 1;
        tracker.params.push(tracker.pipesplit[tracker.cursor]);
    }
    tracker.cursor += 1;

    var endpoint = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
    tracker.cursor += 1;
    var policy_file = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
    tracker.cursor += 1;
    if (xsrfRequested) {
        tracker.cursor += 2;
    }
    var service = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
    tracker.cursor += 1;
    var method = tracker.params[parseInt(tracker.pipesplit[tracker.cursor])];
    tracker.cursor += 1;
    var num_args = parseInt(tracker.pipesplit[tracker.cursor]);
    tracker.cursor += 1;

    for (var i=0; i<num_args; i++) {
        arg_types.push(tracker.params[parseInt(tracker.pipesplit[tracker.cursor])]);
        tracker.cursor += 1;
    }

    if (service == "amazonaws.console.vpc.client.VpcConsoleService" && method == "modifyIngressRulesForNetworkACL") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'region'
        });

        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'aclId'
        });
        tracker.cursor += 1;

        args.push({
            'value': interpretGwtArg(tracker, arg_types[2]),
            'name': 'rules'
        });
    } else if (service == "amazonaws.console.vpc.client.VpcConsoleService" && method == "createVpcWithPublicSubnet") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'region'
        });

        args.push({
            'value': interpretGwtArg(tracker, arg_types[1]),
            'name': 'createvpcwithpublicsubnetargs'
        });
    } else if (service == "amazonaws.console.vpc.client.VpcConsoleService" && method == "getVpcs") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'region'
        });

        args.push({
            'value': tracker.pipesplit[tracker.cursor],
            'name': 'null'
        });
        tracker.cursor += 1;
    } else if (service == "com.amazonaws.console.sqs.shared.services.AmazonSQSService" && method == "createQueue") {
        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'queueName'
        });
    } else if (service == "amazonaws.console.vpc.client.VpcConsoleService" && method == "createVpc") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'region'
        });

        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'cidr'
        });
        tracker.cursor += 1;

        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'tenancy'
        });
        tracker.cursor += 1;

        args.push({
            'value': interpretGwtArg(tracker, arg_types[3]),
            'name': 'ipv6ProvidedBlock'
        });
    } else if (service == "amazonaws.console.vpc.client.VpcConsoleService" && method == "updateRoutesForARouteTable") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'region'
        });

        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'routeTableId'
        });
        tracker.cursor += 1;

        args.push({
            'value': interpretGwtArg(tracker, arg_types[2]),
            'name': 'routes'
        });
    } else if (service == "com.amazon.bacon.console.shared.services.SESService" && method == "createConfigurationSet") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'configurationSetName'
        });
    } else if (service == "com.amazon.bacon.console.shared.services.SESService" && method == "saveConfigurationSetEventDestination") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'configurationSetName'
        });
        args.push({
            'value': interpretGwtArg(tracker, arg_types[1]),
            'name': 'configurationDestination'
        });
    } else if (service == "com.amazon.bacon.console.shared.services.SESService" && method == "deleteConfigurationSet") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'configurationSetName'
        });
    } else if (service == "com.amazon.bacon.console.shared.services.SESService" && method == "createReceiptFilter") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'inboundFilter'
        });
    } else if (service == "com.amazon.bacon.console.shared.services.SESService" && method == "createReceiptRule") {
        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'ruleset'
        });
        tracker.cursor += 1;

        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'afterrule'
        });
        tracker.cursor += 1;

        args.push({
            'value': interpretGwtArg(tracker, arg_types[2]),
            'name': 'rule'
        });
    } else if (service == "com.amazonaws.cloudfront.console.gwt.CloudFrontService" && method == "createOai") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'identityConfig'
        });
    } else if (service == "com.amazonaws.cloudfront.console.gwt.CloudFrontService" && method == "createStreamingDistribution") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'streamingDistributionConfig'
        });
    } else if (service == "com.amazonaws.swf.console.gwtcoral.client.com.amazonaws.swf.service.model.SimpleWorkflowService" && method == "RegisterDomain") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'registerdomaininput'
        });
        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'region'
        });
    } else if (service == "com.amazonaws.route53.console.gwt.Route53Service" && method == "changeResourceRecordSets") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'zoneid'
        });
        args.push({
            'value': interpretGwtArg(tracker, arg_types[1]),
            'name': 'change'
        });
    } else if (service == "com.amazonaws.cloudfront.console.shared.service.DistributionService" && method == "createDistribution") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'distributionconfigs'
        });
    } else if (service == "edp.console.client.dispatch.DispatchService" && method == "dispatch") {
        args.push({
            'value': interpretGwtArg(tracker, arg_types[0]),
            'name': 'dispatchaction'
        });
        args.push({
            'value': tracker.params[parseInt(tracker.pipesplit[tracker.cursor])],
            'name': 'uniqueid'
        });
    }

    return {
        'endpoint': endpoint,
        'service': service,
        'method': method,
        'params': tracker.params,
        'resolved_objects': tracker.resolvedObjects,
        'num_args': num_args,
        'args': args
    };
}

function MD5(e) {
    function h(a, b) {
        var c, d, e, f, g;
        e = a & 2147483648;
        f = b & 2147483648;
        c = a & 1073741824;
        d = b & 1073741824;
        g = (a & 1073741823) + (b & 1073741823);
        return c & d ? g ^ 2147483648 ^ e ^ f : c | d ? g & 1073741824 ? g ^ 3221225472 ^ e ^ f : g ^ 1073741824 ^ e ^ f : g ^ e ^ f
    }

    function k(a, b, c, d, e, f, g) {
        a = h(a, h(h(b & c | ~b & d, e), g));
        return h(a << f | a >>> 32 - f, b)
    }

    function l(a, b, c, d, e, f, g) {
        a = h(a, h(h(b & d | c & ~d, e), g));
        return h(a << f | a >>> 32 - f, b)
    }

    function m(a, b, d, c, e, f, g) {
        a = h(a, h(h(b ^ d ^ c, e), g));
        return h(a << f | a >>> 32 - f, b)
    }

    function n(a, b, d, c, e, f, g) {
        a = h(a, h(h(d ^ (b | ~c), e), g));
        return h(a << f | a >>> 32 - f, b)
    }

    function p(a) {
        var b = "",
            d = "",
            c;
        for (c = 0; 3 >= c; c++) d = a >>> 8 * c & 255, d = "0" + d.toString(16), b += d.substr(d.length - 2, 2);
        return b
    }
    var f = [],
        q, r, s, t, a, b, c, d;
    e = function(a) {
        a = a.replace(/\r\n/g, "\n");
        for (var b = "", d = 0; d < a.length; d++) {
            var c = a.charCodeAt(d);
            128 > c ? b += String.fromCharCode(c) : (127 < c && 2048 > c ? b += String.fromCharCode(c >> 6 | 192) : (b += String.fromCharCode(c >> 12 | 224), b += String.fromCharCode(c >> 6 & 63 | 128)), b += String.fromCharCode(c & 63 | 128))
        }
        return b
    }(e);
    f = function(b) {
        var a, c = b.length;
        a = c + 8;
        for (var d = 16 * ((a - a % 64) / 64 + 1), e = Array(d - 1), f = 0, g = 0; g < c;) a = (g - g % 4) / 4, f = g % 4 * 8, e[a] |= b.charCodeAt(g) << f, g++;
        a = (g - g % 4) / 4;
        e[a] |= 128 << g % 4 * 8;
        e[d - 2] = c << 3;
        e[d - 1] = c >>> 29;
        return e
    }(e);
    a = 1732584193;
    b = 4023233417;
    c = 2562383102;
    d = 271733878;
    for (e = 0; e < f.length; e += 16) q = a, r = b, s = c, t = d, a = k(a, b, c, d, f[e + 0], 7, 3614090360), d = k(d, a, b, c, f[e + 1], 12, 3905402710), c = k(c, d, a, b, f[e + 2], 17, 606105819), b = k(b, c, d, a, f[e + 3], 22, 3250441966), a = k(a, b, c, d, f[e + 4], 7, 4118548399), d = k(d, a, b, c, f[e + 5], 12, 1200080426), c = k(c, d, a, b, f[e + 6], 17, 2821735955), b = k(b, c, d, a, f[e + 7], 22, 4249261313), a = k(a, b, c, d, f[e + 8], 7, 1770035416), d = k(d, a, b, c, f[e + 9], 12, 2336552879), c = k(c, d, a, b, f[e + 10], 17, 4294925233), b = k(b, c, d, a, f[e + 11], 22, 2304563134), a = k(a, b, c, d, f[e + 12], 7, 1804603682), d = k(d, a, b, c, f[e + 13], 12, 4254626195), c = k(c, d, a, b, f[e + 14], 17, 2792965006), b = k(b, c, d, a, f[e + 15], 22, 1236535329), a = l(a, b, c, d, f[e + 1], 5, 4129170786), d = l(d, a, b, c, f[e + 6], 9, 3225465664), c = l(c, d, a, b, f[e + 11], 14, 643717713), b = l(b, c, d, a, f[e + 0], 20, 3921069994), a = l(a, b, c, d, f[e + 5], 5, 3593408605), d = l(d, a, b, c, f[e + 10], 9, 38016083), c = l(c, d, a, b, f[e + 15], 14, 3634488961), b = l(b, c, d, a, f[e + 4], 20, 3889429448), a = l(a, b, c, d, f[e + 9], 5, 568446438), d = l(d, a, b, c, f[e + 14], 9, 3275163606), c = l(c, d, a, b, f[e + 3], 14, 4107603335), b = l(b, c, d, a, f[e + 8], 20, 1163531501), a = l(a, b, c, d, f[e + 13], 5, 2850285829), d = l(d, a, b, c, f[e + 2], 9, 4243563512), c = l(c, d, a, b, f[e + 7], 14, 1735328473), b = l(b, c, d, a, f[e + 12], 20, 2368359562), a = m(a, b, c, d, f[e + 5], 4, 4294588738), d = m(d, a, b, c, f[e + 8], 11, 2272392833), c = m(c, d, a, b, f[e + 11], 16, 1839030562), b = m(b, c, d, a, f[e + 14], 23, 4259657740), a = m(a, b, c, d, f[e + 1], 4, 2763975236), d = m(d, a, b, c, f[e + 4], 11, 1272893353), c = m(c, d, a, b, f[e + 7], 16, 4139469664), b = m(b, c, d, a, f[e + 10], 23, 3200236656), a = m(a, b, c, d, f[e + 13], 4, 681279174), d = m(d, a, b, c, f[e + 0], 11, 3936430074), c = m(c, d, a, b, f[e + 3], 16, 3572445317), b = m(b, c, d, a, f[e + 6], 23, 76029189), a = m(a, b, c, d, f[e + 9], 4, 3654602809), d = m(d, a, b, c, f[e + 12], 11, 3873151461), c = m(c, d, a, b, f[e + 15], 16, 530742520), b = m(b, c, d, a, f[e + 2], 23, 3299628645), a = n(a, b, c, d, f[e + 0], 6, 4096336452), d = n(d, a, b, c, f[e + 7], 10, 1126891415), c = n(c, d, a, b, f[e + 14], 15, 2878612391), b = n(b, c, d, a, f[e + 5], 21, 4237533241), a = n(a, b, c, d, f[e + 12], 6, 1700485571), d = n(d, a, b, c, f[e + 3], 10, 2399980690), c = n(c, d, a, b, f[e + 10], 15, 4293915773), b = n(b, c, d, a, f[e + 1], 21, 2240044497), a = n(a, b, c, d, f[e + 8], 6, 1873313359), d = n(d, a, b, c, f[e + 15], 10, 4264355552), c = n(c, d, a, b, f[e + 6], 15, 2734768916), b = n(b, c, d, a, f[e + 13], 21, 1309151649), a = n(a, b, c, d, f[e + 4], 6, 4149444226), d = n(d, a, b, c, f[e + 11], 10, 3174756917), c = n(c, d, a, b, f[e + 2], 15, 718787259), b = n(b, c, d, a, f[e + 9], 21, 3951481745), a = h(a, q), b = h(b, r), c = h(c, s), d = h(d, t);
    return (p(a) + p(b) + p(c) + p(d)).toLowerCase()
};

function notifyBlocked() {
    console.log("Calling notify");
    chrome.notifications.create(null, {
        type: "basic",
        title: "Console Recorder",
        message: "An AWS console request was blocked.",
        iconUrl: "icon-128.png",
        buttons: [
            {
                'title': 'View Outputs'
            }
        ]
    });
}

function ensureInitDeclaredJs(service, region) {
    if (!declared_services['js'].includes(service)) {
        var mappedservice = mapServiceJs(service);
        declared_services['js'].push(service);
        return `

var ${service} = new AWS.${mappedservice}({region: '${region}'});
`;
    }
    return '';
}

function ensureInitDeclaredBoto3(service, region) {
    if (!declared_services['boto3'].includes(service)) {
        declared_services['boto3'].push(service);
        return `
${service}_client = boto3.client('${service}', region_name='${region}')

`;
    }
    return '';
}

function ensureInitDeclaredGo(service, region) {
    if (!declared_services['go'].includes(service)) {
        var mappedservice = mapServiceJs(service).toLowerCase().replace(/\-/g,'');
        declared_services['go'].push(service);
        return `
    ${service}svc := ${mappedservice}.New(session.New(&aws.Config{Region: aws.String("${region}")}))

`;
    }
    return '';
}

function processTfParameter(param, spacing, index) {
    var paramitems = [];

    if (param === undefined || param === null)
        return undefined;
    if (typeof param == "boolean") {
        if (param)
            return 'true';
        return 'false';
    }
    if (typeof param == "number") {
        for (var i=0; i<index; i++) { // correlate
            if (tracked_resources[i].returnValues && tracked_resources[i].returnValues.Terraform) {
                for (var attr_name in tracked_resources[i].returnValues.Terraform) {
                    if (tracked_resources[i].returnValues.Terraform[attr_name] == param) {
                        return "\"${" + tracked_resources[i].terraformType + "." + tracked_resources[i].logicalId + "." + attr_name + "}\""
                    }
                }
            }
        }

        return `${param}`;
    }
    if (typeof param == "string") {
        if (param.startsWith("!Ref ") || param.startsWith("!GetAtt ")) {
            return undefined;
        }

        for (var i=0; i<index; i++) { // correlate
            if (tracked_resources[i].returnValues && tracked_resources[i].returnValues.Terraform) {
                for (var attr_name in tracked_resources[i].returnValues.Terraform) {
                    if (tracked_resources[i].returnValues.Terraform[attr_name] == param) {
                        return "\"${" + tracked_resources[i].terraformType + "." + tracked_resources[i].logicalId + "." + attr_name + "}\""
                    }
                }
            }
        }

        var string_return = param;

        if (string_return.includes("\n")) {
            string_return = "<<EOF\n" + string_return + "\nEOF";
            return string_return;
        }
        
        string_return = param.replace(/\"/g,`\\"`);

        return `"${string_return}"`;
    }
    if (Array.isArray(param)) {
        if (param.length == 0) {
            return '[]';
        }

        param.forEach(paramitem => {
            paramitems.push(processTfParameter(paramitem, spacing + 4, index));
        });

        return `[
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + `]`;
    }
    if (typeof param == "object") {
        if (Object.keys(param).length === 0 && param.constructor === Object) {
            return "{}";
        }

        Object.keys(param).forEach(function (key) {
            var subvalue = processTfParameter(param[key], spacing + 4, index);
            if (subvalue !== undefined) {
                if (subvalue[0] == '{') {
                    paramitems.push(key + " " + subvalue);
                } else {
                    paramitems.push(key + " = " + subvalue);
                }
            }
        });

        return `{
` + ' '.repeat(spacing + 4) + paramitems.join(`
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + `}`;
    }
    
    return undefined;
}

function processCfnParameter(param, spacing, index) {
    var paramitems = [];

    if (param === undefined || param === null)
        return undefined;
    if (typeof param == "boolean") {
        if (param)
            return 'true';
        return 'false';
    }
    if (typeof param == "number") {
        for (var i=0; i<index; i++) { // correlate
            if (tracked_resources[i].returnValues) {
                if (tracked_resources[i].returnValues.Ref == param) {
                    return "!Ref " + tracked_resources[i].logicalId;
                }
                if (tracked_resources[i].returnValues.GetAtt) {
                    for (var attr_name in tracked_resources[i].returnValues.GetAtt) {
                        if (tracked_resources[i].returnValues.GetAtt[attr_name] === param) {
                            return "!GetAtt " + tracked_resources[i].logicalId + "." + attr_name;
                        }
                    }
                }
            }
        }

        return `${param}`;
    }
    if (typeof param == "string") {
        if (param.startsWith("!Ref ") || param.startsWith("!GetAtt ")) {
            return `${param}`;
        }

        var pre_return_str = "";
        for (var i=0; i<index; i++) { // correlate
            if (tracked_resources[i].returnValues && param != "") {
                if (
                    tracked_resources[i].returnValues.Ref == param &&
                    tracked_resources[i].returnValues.Ref != "" &&
                    tracked_resources[i].returnValues.Ref != []
                ) {
                    return "!Ref " + tracked_resources[i].logicalId;
                }
                if (tracked_resources[i].returnValues.GetAtt) {
                    for (var attr_name in tracked_resources[i].returnValues.GetAtt) {
                        if (
                            tracked_resources[i].returnValues.GetAtt[attr_name] === param &&
                            tracked_resources[i].returnValues.GetAtt[attr_name] != "" &&
                            tracked_resources[i].returnValues.GetAtt[attr_name] != []
                        ) {
                            return "!GetAtt " + tracked_resources[i].logicalId + "." + attr_name;
                        }
                    }
                }
                if (
                    param.includes(tracked_resources[i].returnValues.Ref) &&
                    tracked_resources[i].returnValues.Ref != "" &&
                    tracked_resources[i].returnValues.Ref != []
                ) {
                    for (var j=0; j<10 && param.includes(tracked_resources[i].returnValues.Ref); j++) { // replace many
                        pre_return_str = "!Sub ";
                        param = param.replace(tracked_resources[i].returnValues.Ref, "${" + tracked_resources[i].logicalId + "}");
                    }
                }
                if (tracked_resources[i].returnValues.GetAtt) {
                    for (var attr_name in tracked_resources[i].returnValues.GetAtt) {
                        if (
                            param.includes(tracked_resources[i].returnValues.GetAtt[attr_name]) &&
                            tracked_resources[i].returnValues.GetAtt[attr_name] != "" &&
                            tracked_resources[i].returnValues.GetAtt[attr_name] != []
                        ) {
                            for (var j=0; j<10; j++) { // replace many
                                pre_return_str = "!Sub ";
                                param = param.replace(tracked_resources[i].returnValues.GetAtt[attr_name], "${" + tracked_resources[i].logicalId + "." + attr_name + "}");
                            }
                        }
                    }
                }
            }
        }
        
        var string_return = param;

        if (string_return.includes("\n")) {
            string_return = "|\n" + ' '.repeat(spacing + 4) + string_return.replace(/\n/g, `\n` + ' '.repeat(spacing + 4));
            return pre_return_str + string_return;
        }
        
        string_return = param.replace(/\"/g,`\\"`);

        return pre_return_str + `"${string_return}"`;
    }
    if (Array.isArray(param)) {
        if (param.length == 0) {
            return '[]';
        }

        param.forEach(paramitem => {
            paramitems.push(processCfnParameter(paramitem, spacing, index));
        });

        if (cfn_spacing.length == 4) {
            return `
` + ' '.repeat(spacing + 2) + "- " + paramitems.join(`
` + ' '.repeat(spacing + 2) + "- ");
        }
        
        return `
` + ' '.repeat(spacing) + "- " + paramitems.join(`
` + ' '.repeat(spacing) + "- ");
    }
    if (typeof param == "object") {
        if (Object.keys(param).length === 0 && param.constructor === Object) {
            return "!Ref \"AWS::NoValue\"";
        }

        Object.keys(param).forEach(function (key) {
            var subvalue = processCfnParameter(param[key], spacing + cfn_spacing.length, index);
            if (subvalue !== undefined) {
                paramitems.push(key + ": " + subvalue);
            }
        });

        if (paramitems.length < 1) {
            return "!Ref \"AWS::NoValue\"";
        }

        return `
` + ' '.repeat(spacing + cfn_spacing.length) + paramitems.join(`
` + ' '.repeat(spacing + cfn_spacing.length))
    }
    
    return undefined;
}

function processCdktsParameter(param, spacing, index) {
    var paramitems = [];

    if (param === undefined || param === null)
        return undefined;
    if (typeof param == "boolean") {
        if (param)
            return "true";
        return "false";
    }
    if (typeof param == "number")
        return `${param}`;
    if (typeof param == "string") {
        if (param.startsWith("!Ref ") || param.startsWith("!GetAtt ")) {
            return undefined; // TODO: Fix this
        }

        for (var i=0; i<index; i++) { // correlate
            if (tracked_resources[i].returnValues && param != "") {
                if (tracked_resources[i].returnValues.Ref == param) {
                    return tracked_resources[i].logicalId + ".ref";
                }
                if (tracked_resources[i].returnValues.GetAtt) {
                    for (var attr_name in tracked_resources[i].returnValues.GetAtt) {
                        if (tracked_resources[i].returnValues.GetAtt[attr_name] === param) {
                            return tracked_resources[i].logicalId + ".getAtt('" + attr_name + "')"
                        }
                    }
                }
            }
        }

        var string_return = param;

        if (string_return.includes("\n")) {
            string_return = "`" + string_return + "`";
            return string_return;
        }
        
        string_return = param.replace(/\"/g,`\\"`);

        return `"${string_return}"`;
    }
    if (Array.isArray(param)) {
        if (param.length == 0) {
            return '[]';
        }

        param.forEach(paramitem => {
            var item = processCdktsParameter(paramitem, spacing + 4, index);
            if (item !== undefined) {
                paramitems.push(item);
            }
        });

        return `[
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + ']';
    }
    if (typeof param == "object") {
        Object.keys(param).forEach(function (key) {
            var item = processCdktsParameter(param[key], spacing + 4, index);
            if (item !== undefined) {
                paramitems.push(lcfirststr(key) + ": " + item);
            }
        });

        return `{
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + '}';
    }
    
    return undefined;
}

function processTroposphereParameter(param, spacing, keyname, index) {
    var paramitems = [];

    if (param === undefined || param === null)
        return undefined;
    if (typeof param == "boolean") {
        if (param)
            return `True`;
        return `False`;
    }
    if (typeof param == "number") {
        for (var i=0; i<index; i++) { // correlate
            if (tracked_resources[i].returnValues && param != "") {
                if (tracked_resources[i].returnValues.Ref == param) {
                    return "Ref(" + tracked_resources[i].logicalId + ")";
                }
                if (tracked_resources[i].returnValues.GetAtt) {
                    for (var attr_name in tracked_resources[i].returnValues.GetAtt) {
                        if (tracked_resources[i].returnValues.GetAtt[attr_name] === param) {
                            return "GetAtt(" + tracked_resources[i].logicalId + ", '" + attr_name + "')";
                        }
                    }
                }
            }
        }

        return `${param}`;
    }
    if (typeof param == "string") {
        if (param.startsWith("!Ref ")) {
            return `Ref(${param.substring(5)})`;
        }
        if (param.startsWith("!GetAtt ")) {
            return undefined;
        }

        for (var i=0; i<index; i++) { // correlate
            if (tracked_resources[i].returnValues && param != "") {
                if (tracked_resources[i].returnValues.Ref == param) {
                    return "Ref(" + tracked_resources[i].logicalId + ")";
                }
                if (tracked_resources[i].returnValues.GetAtt) {
                    for (var attr_name in tracked_resources[i].returnValues.GetAtt) {
                        if (tracked_resources[i].returnValues.GetAtt[attr_name] === param) {
                            return "GetAtt(" + tracked_resources[i].logicalId + ", '" + attr_name + "')";
                        }
                    }
                }
            }
        }

        var string_return = param;

        if (string_return.includes("\n")) {
            string_return = "\"\"\"" + ' '.repeat(spacing + 4) + string_return.replace(/\n/g, `\n` + ' '.repeat(spacing + 4)) + "\n\"\"\"";
            return string_return;
        }
        
        string_return = param.replace(/'/g,`\\'`);

        return `'${string_return}'`;
    }
    if (Array.isArray(param)) {
        if (param.length == 0) {
            return '[]';
        }

        param.forEach(paramitem => {
            var item = processTroposphereParameter(paramitem, spacing + 4, keyname, index);
            if (item !== undefined) {
                paramitems.push(item);
            }
        });

        return `[
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + ']';
    }
    if (typeof param == "object") {
        var propertyname = getTropospherePropertyName(keyname);

        if (!propertyname) {
            Object.keys(param).forEach(function (key) {
                var item = processBoto3Parameter(param[key], spacing + 4); // intentional, to do raw array stuff
                if (item !== undefined) {
                    paramitems.push("\"" + key + "\": " + item);
                }
            });

            return `{
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + '}';
        }

        Object.keys(param).forEach(function (key) {
            var item = processTroposphereParameter(param[key], spacing + 4, keyname + "." + key, index);
            if (item !== undefined) {
                paramitems.push(key + "=" + item);
            }
        });

        return `${propertyname}(
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + ')';
    }
    
    return undefined;
}

function parseDynamoItem(obj) {
    var ret = {};
    
    for (var key in obj) {
        if (obj[key].type == "String") {
            ret[obj[key].name] = {
                "S": obj[key].stringValue
            };
        } else if (obj[key].type == "Map") {
            ret[obj[key].name] = {
                "M": parseDynamoItem(obj[key].mapValues)
            };
        } else if (obj[key].type == "Binary") {
            ret[obj[key].name] = {
                "B": obj[key].binaryValue
            };
        } else if (obj[key].type == "BinarySet") {
            ret[obj[key].name] = {
                "BS": obj[key].binarySetValues
            };
        } else if (obj[key].type == "Boolean") {
            ret[obj[key].name] = {
                "BOOL": obj[key].booleanValue
            };
        } else if (obj[key].type == "List") {
            ret[obj[key].name] = {
                "L": []
            };
            for (var j=0; j<obj[key].listValues.length; j++) {
                ret[obj[key].name]["L"].push(parseDynamoItem(obj[key].listValues[j]));
            }
        } else if (obj[key].type == "Null") {
            ret[obj[key].name] = {
                "NULL": true
            };
        } else if (obj[key].type == "Number") {
            ret[obj[key].name] = {
                "N": Number(obj[key].numberValue)
            };
        } else if (obj[key].type == "NumberSet") {
            ret[obj[key].name] = {
                "NS": []
            };
            for (var j=0; j<obj[key].numberSetValues.length; j++) {
                ret[obj[key].name]["NS"].push(Number(obj[key].numberSetValues[j]));
            }
        } else if (obj[key].type == "StringSet") {
            ret[obj[key].name] = {
                "SS": []
            };
            for (var j=0; j<obj[key].stringSetValues.length; j++) {
                ret[obj[key].name]["SS"].push(obj[key].stringSetValues[j]);
            }
        }
    }

    return ret;
}

function getTropospherePropertyName(keyname) {
    auto_generated_property_mapping = {
        "BaseRecordSet.AliasTarget": "AliasTarget",
        "BaseRecordSet.GeoLocation": "GeoLocation",
        "CreationPolicy.AutoScalingCreationPolicy": "AutoScalingCreationPolicy",
        "CreationPolicy.ResourceSignal": "ResourceSignal",
        "InitFile.context": "InitFileContext",
        "LambdaConfigurations.Filter.S3Key.Rules": "Rules",
        "RoleMapping.RulesConfiguration": "RulesConfiguration",
        "RoleMapping.RulesConfiguration.Rules": "MappingRule",
        "UpdatePolicy.AutoScalingReplacingUpdate": "AutoScalingReplacingUpdate",
        "UpdatePolicy.AutoScalingRollingUpdate": "AutoScalingRollingUpdate",
        "UpdatePolicy.AutoScalingScheduledAction": "AutoScalingScheduledAction",
        "UpdatePolicy.CodeDeployLambdaAliasUpdate": "CodeDeployLambdaAliasUpdate",
        "amazonmq.Configuration": "ConfigurationId",
        "amazonmq.Logs": "LogsConfiguration",
        "amazonmq.MaintenanceWindowStartTime": "MaintenanceWindow",
        "amazonmq.Users": "User",
        "analytics.Inputs": "Input",
        "analytics.Inputs.InputParallelism": "InputParallelism",
        "analytics.Inputs.InputProcessingConfiguration": "InputProcessingConfiguration",
        "analytics.Inputs.InputProcessingConfiguration.InputLambdaProcessor": "InputLambdaProcessor",
        "analytics.Inputs.InputSchema": "InputSchema",
        "analytics.Inputs.InputSchema.RecordColumns": "RecordColumn",
        "analytics.Inputs.InputSchema.RecordFormat": "RecordFormat",
        "analytics.Inputs.InputSchema.RecordFormat.MappingParameters": "JSONMappingParameters",
        "analytics.Inputs.KinesisFirehoseInput": "KinesisFirehoseInput",
        "analytics.Inputs.KinesisStreamsInput": "KinesisStreamsInput",
        "analytics.Output": "Output",
        "analytics.Output.DestinationSchema": "DestinationSchema",
        "analytics.Output.KinesisFirehoseOutput": "KinesisFirehoseOutput",
        "analytics.Output.KinesisStreamsOutput": "KinesisStreamsOutput",
        "analytics.Output.LambdaOutput": "LambdaOutput",
        "analytics.ReferenceDataSource": "ReferenceDataSource",
        "analytics.ReferenceDataSource.ReferenceSchema": "ReferenceSchema",
        "analytics.ReferenceDataSource.ReferenceSchema.RecordColumns": "RecordColumn",
        "analytics.ReferenceDataSource.ReferenceSchema.RecordFormat": "MappingParameters",
        "analytics.ReferenceDataSource.S3ReferenceDataSource": "S3ReferenceDataSource",
        "apigateway.AccesLogSetting": "AccessLogSetting",
        "apigateway.ApiStages": "ApiStage",
        "apigateway.ApiStages.Throttle": "ThrottleSettings",
        "apigateway.BodyS3Location": "S3Location",
        "apigateway.CanarySetting": "CanarySetting",
        "apigateway.DeploymentCanarySettings": "DeploymentCanarySettings",
        "apigateway.EndpointConfiguration": "EndpointConfiguration",
        "apigateway.Integration": "Integration",
        "apigateway.Integration.IntegrationResponses": "IntegrationResponse",
        "apigateway.Location": "Location",
        "apigateway.MethodResponses": "MethodResponse",
        "apigateway.MethodSettings": "MethodSetting",
        "apigateway.Quota": "QuotaSettings",
        "apigateway.StageDescription": "StageDescription",
        "apigateway.StageDescription.AccessLogSetting": "AccessLogSetting",
        "apigateway.StageDescription.CanarySetting": "DeploymentCanarySettings",
        "apigateway.StageDescription.MethodSettings": "MethodSetting",
        "apigateway.StageKeys": "StageKey",
        "apigateway.Throttle": "ThrottleSettings",
        "applicationautoscaling.ScheduledActions": "ScheduledAction",
        "applicationautoscaling.ScheduledActions.ScalableTargetAction": "ScalableTargetAction",
        "applicationautoscaling.StepScalingPolicyConfiguration": "StepScalingPolicyConfiguration",
        "applicationautoscaling.StepScalingPolicyConfiguration.StepAdjustments": "StepAdjustment",
        "applicationautoscaling.TargetTrackingScalingPolicyConfiguration": "TargetTrackingScalingPolicyConfiguration",
        "applicationautoscaling.TargetTrackingScalingPolicyConfiguration.CustomizedMetricSpecification": "MetricDimension",
        "applicationautoscaling.TargetTrackingScalingPolicyConfiguration.PredefinedMetricSpecification": "PredefinedMetricSpecification",
        "appsync.DynamoDBConfig": "DynamoDBConfig",
        "appsync.ElasticsearchConfig": "ElasticsearchConfig",
        "appsync.HttpConfig": "HttpConfig",
        "appsync.LambdaConfig": "LambdaConfig",
        "appsync.LogConfig": "LogConfig",
        "appsync.OpenIDConnectConfig": "OpenIDConnectConfig",
        "appsync.UserPoolConfig": "UserPoolConfig",
        "autoscaling.BlockDeviceMappings": "BlockDeviceMapping",
        "autoscaling.BlockDeviceMappings.Ebs": "EBSBlockDevice",
        "autoscaling.LaunchTemplate": "LaunchTemplateSpecification",
        "autoscaling.LifecycleHookSpecificationList": "LifecycleHookSpecification",
        "autoscaling.Metadata": "Metadata",
        "autoscaling.MetricsCollection": "MetricsCollection",
        "autoscaling.NotificationConfigurations": "NotificationConfigurations",
        "autoscaling.StepAdjustments": "StepAdjustments",
        "autoscaling.TargetTrackingConfiguration": "TargetTrackingConfiguration",
        "autoscaling.TargetTrackingConfiguration.CustomizedMetricSpecification": "MetricDimension",
        "autoscaling.TargetTrackingConfiguration.PredefinedMetricSpecification": "PredefinedMetricSpecification",
        "awslambda.Code": "Code",
        "awslambda.DeadLetterConfig": "DeadLetterConfig",
        "awslambda.Environment": "Environment",
        "awslambda.RoutingConfig": "AliasRoutingConfiguration",
        "awslambda.RoutingConfig.AdditionalVersionWeights": "VersionWeight",
        "awslambda.TracingConfig": "TracingConfig",
        "awslambda.VpcConfig": "VPCConfig",
        "batch.ComputeEnvironmentOrder": "ComputeEnvironmentOrder",
        "batch.ComputeResources": "ComputeResources",
        "batch.ContainerProperties": "ContainerProperties",
        "batch.ContainerProperties.Environment": "Environment",
        "batch.ContainerProperties.MountPoints": "MountPoints",
        "batch.ContainerProperties.Ulimits": "Ulimit",
        "batch.ContainerProperties.Volumes": "Volumes",
        "batch.ContainerProperties.Volumes.Host": "VolumesHost",
        "batch.RetryStrategy": "RetryStrategy",
        "batch.Timeout": "Timeout",
        "budgets.Budget": "BudgetData",
        "budgets.Budget.BudgetLimit": "Spend",
        "budgets.Budget.CostTypes": "CostTypes",
        "budgets.Budget.TimePeriod": "TimePeriod",
        "budgets.NotificationsWithSubscribers": "NotificationWithSubscribers",
        "budgets.NotificationsWithSubscribers.Notification": "Notification",
        "budgets.NotificationsWithSubscribers.Subscribers": "Subscriber",
        "certificatemanager.DomainValidationOptions": "DomainValidationOption",
        "cloud9.Repositories": "Repository",
        "cloudfront.CloudFrontOriginAccessIdentityConfig": "CloudFrontOriginAccessIdentityConfig",
        "cloudfront.DistributionConfig": "DistributionConfig",
        "cloudfront.DistributionConfig.CacheBehaviors": "Cookies",
        "cloudfront.DistributionConfig.CustomErrorResponses": "CustomErrorResponse",
        "cloudfront.DistributionConfig.DefaultCacheBehavior": "LambdaFunctionAssociation",
        "cloudfront.DistributionConfig.Logging": "Logging",
        "cloudfront.DistributionConfig.Restrictions": "Restrictions",
        "cloudfront.DistributionConfig.Restrictions.GeoRestriction": "GeoRestriction",
        "cloudfront.DistributionConfig.ViewerCertificate": "ViewerCertificate",
        "cloudfront.Origins": "Origin",
        "cloudfront.Origins.CustomOriginConfig": "CustomOrigin",
        "cloudfront.Origins.OriginCustomHeaders": "OriginCustomHeader",
        "cloudfront.Origins.S3OriginConfig": "S3Origin",
        "cloudfront.StreamingDistributionConfig": "StreamingDistributionConfig",
        "cloudfront.StreamingDistributionConfig.Logging": "Logging",
        "cloudfront.StreamingDistributionConfig.S3Origin": "S3Origin",
        "cloudfront.StreamingDistributionConfig.TrustedSigners": "TrustedSigners",
        "cloudtrail.EventSelectors": "EventSelector",
        "cloudtrail.EventSelectors.DataResources": "DataResource",
        "cloudwatch.Dimensions": "MetricDimension",
        "codebuild.Artifacts": "Artifacts",
        "codebuild.Cache": "ProjectCache",
        "codebuild.Environment": "Environment",
        "codebuild.LogsConfig": "LogsConfig",
        "codebuild.LogsConfig.CloudWatchLogs": "CloudWatchLogs",
        "codebuild.LogsConfig.S3Logs": "S3Logs",
        "codebuild.SecondaryArtifacts": "Artifacts",
        "codebuild.SecondarySources": "Source",
        "codebuild.SecondarySources.Auth": "SourceAuth",
        "codebuild.Source": "Source",
        "codebuild.Triggers": "ProjectTriggers",
        "codebuild.VpcConfig": "VpcConfig",
        "codecommit.Triggers": "Trigger",
        "codedeploy.AlarmConfiguration": "AlarmConfiguration",
        "codedeploy.AlarmConfiguration.Alarms": "Alarm",
        "codedeploy.AutoRollbackConfiguration": "AutoRollbackConfiguration",
        "codedeploy.Deployment": "Deployment",
        "codedeploy.Deployment.Revision": "Revision",
        "codedeploy.Deployment.Revision.GitHubLocation": "GitHubLocation",
        "codedeploy.Deployment.Revision.S3Location": "S3Location",
        "codedeploy.DeploymentStyle": "DeploymentStyle",
        "codedeploy.Ec2TagFilters": "Ec2TagFilters",
        "codedeploy.Ec2TagSet": "Ec2TagSet",
        "codedeploy.Ec2TagSet.Ec2TagSet": "Ec2TagSetList",
        "codedeploy.Ec2TagSet.Ec2TagSet.Ec2TagSetList": "Ec2TagSetListObject",
        "codedeploy.Ec2TagSet.Ec2TagSet.Ec2TagSetList.Ec2TagGroup": "Ec2TagFilters",
        "codedeploy.LoadBalancerInfo": "LoadBalancerInfo",
        "codedeploy.LoadBalancerInfo.ElbInfoList": "ElbInfoList",
        "codedeploy.LoadBalancerInfo.TargetGroupInfoList": "TargetGroupInfoList",
        "codedeploy.MinimumHealthyHosts": "MinimumHealthyHosts",
        "codedeploy.OnPremisesInstanceTagFilters": "OnPremisesInstanceTagFilters",
        "codedeploy.OnPremisesInstanceTagSet": "OnPremisesTagSet",
        "codedeploy.OnPremisesInstanceTagSet.OnPremisesTagSetList": "OnPremisesTagSetList",
        "codedeploy.OnPremisesInstanceTagSet.OnPremisesTagSetList.OnPremisesTagSetList": "OnPremisesTagSetObject",
        "codedeploy.OnPremisesInstanceTagSet.OnPremisesTagSetList.OnPremisesTagSetList.OnPremisesTagGroup": "TagFilters",
        "codedeploy.TriggerConfigurations": "TriggerConfig",
        "codepipeline.ArtifactStore": "ArtifactStore",
        "codepipeline.ArtifactStore.EncryptionKey": "EncryptionKey",
        "codepipeline.AuthenticationConfiguration": "WebhookAuthConfiguration",
        "codepipeline.ConfigurationProperties": "ConfigurationProperties",
        "codepipeline.DisableInboundStageTransitions": "DisableInboundStageTransitions",
        "codepipeline.Filters": "WebhookFilterRule",
        "codepipeline.InputArtifactDetails": "ArtifactDetails",
        "codepipeline.OutputArtifactDetails": "ArtifactDetails",
        "codepipeline.Settings": "Settings",
        "codepipeline.Stages": "Stages",
        "codepipeline.Stages.Actions": "OutputArtifacts",
        "codepipeline.Stages.Blockers": "Blockers",
        "cognito.AdminCreateUserConfig": "AdminCreateUserConfig",
        "cognito.AdminCreateUserConfig.InviteMessageTemplate": "InviteMessageTemplate",
        "cognito.CognitoIdentityProviders": "CognitoIdentityProvider",
        "cognito.CognitoStreams": "CognitoStreams",
        "cognito.DeviceConfiguration": "DeviceConfiguration",
        "cognito.EmailConfiguration": "EmailConfiguration",
        "cognito.LambdaConfig": "LambdaConfig",
        "cognito.Policies": "Policies",
        "cognito.Policies.PasswordPolicy": "PasswordPolicy",
        "cognito.PushSync": "PushSync",
        "cognito.Schema": "SchemaAttribute",
        "cognito.Schema.NumberAttributeConstraints": "NumberAttributeConstraints",
        "cognito.Schema.StringAttributeConstraints": "StringAttributeConstraints",
        "cognito.SmsConfiguration": "SmsConfiguration",
        "cognito.UserAttributes": "AttributeType",
        "cognito.ValidationData": "AttributeType",
        "config.AccountAggregationSources": "AccountAggregationSources",
        "config.ConfigSnapshotDeliveryProperties": "ConfigSnapshotDeliveryProperties",
        "config.OrganizationAggregationSource": "OrganizationAggregationSource",
        "config.RecordingGroup": "RecordingGroup",
        "config.Scope": "Scope",
        "config.Source": "Source",
        "config.Source.SourceDetails": "SourceDetails",
        "datapipeline.ParameterObjects": "ParameterObject",
        "datapipeline.ParameterObjects.Attributes": "ParameterObjectAttribute",
        "datapipeline.ParameterValues": "ParameterValue",
        "datapipeline.PipelineObjects": "PipelineObject",
        "datapipeline.PipelineObjects.Fields": "ObjectField",
        "datapipeline.PipelineTags": "PipelineTag",
        "dax.SSESpecification": "SSESpecification",
        "directoryservice.VpcSettings": "VpcSettings",
        "dms.DynamoDbSettings": "DynamoDBSettings",
        "dms.MongoDbSettings": "MongoDbSettings",
        "dms.S3Settings": "S3Settings",
        "dynamodb.AttributeDefinitions": "AttributeDefinition",
        "dynamodb.GlobalSecondaryIndexes": "GlobalSecondaryIndex",
        "dynamodb.GlobalSecondaryIndexes.KeySchema": "KeySchema",
        "dynamodb.GlobalSecondaryIndexes.Projection": "Projection",
        "dynamodb.GlobalSecondaryIndexes.ProvisionedThroughput": "ProvisionedThroughput",
        "dynamodb.KeySchema": "KeySchema",
        "dynamodb.LocalSecondaryIndexes": "LocalSecondaryIndex",
        "dynamodb.LocalSecondaryIndexes.KeySchema": "KeySchema",
        "dynamodb.LocalSecondaryIndexes.Projection": "Projection",
        "dynamodb.PointInTimeRecoverySpecification": "PointInTimeRecoverySpecification",
        "dynamodb.ProvisionedThroughput": "ProvisionedThroughput",
        "dynamodb.SSESpecification": "SSESpecification",
        "dynamodb.StreamSpecification": "StreamSpecification",
        "dynamodb.TimeToLiveSpecification": "TimeToLiveSpecification",
        "ec2.BlockDeviceMappings": "BlockDeviceMapping",
        "ec2.BlockDeviceMappings.Ebs": "EBSBlockDevice",
        "ec2.CreditSpecification": "CreditSpecification",
        "ec2.ElasticGpuSpecifications": "ElasticGpuSpecification",
        "ec2.Icmp": "ICMP",
        "ec2.Ipv6Addresses": "Ipv6Addresses",
        "ec2.LaunchTemplate": "LaunchTemplateSpecification",
        "ec2.LaunchTemplateData": "LaunchTemplateData",
        "ec2.LaunchTemplateData.BlockDeviceMappings": "BlockDeviceMapping",
        "ec2.LaunchTemplateData.CreditSpecification": "LaunchTemplateCreditSpecification",
        "ec2.LaunchTemplateData.ElasticGpuSpecifications": "ElasticGpuSpecification",
        "ec2.LaunchTemplateData.IamInstanceProfile": "IamInstanceProfile",
        "ec2.LaunchTemplateData.InstanceMarketOptions": "SpotOptions",
        "ec2.LaunchTemplateData.Monitoring": "Monitoring",
        "ec2.LaunchTemplateData.NetworkInterfaces": "NetworkInterfaces",
        "ec2.LaunchTemplateData.Placement": "Placement",
        "ec2.LaunchTemplateData.TagSpecifications": "TagSpecifications",
        "ec2.NetworkInterfaces": "NetworkInterfaceProperty",
        "ec2.NetworkInterfaces.Ipv6Addresses": "Ipv6Addresses",
        "ec2.NetworkInterfaces.PrivateIpAddresses": "PrivateIpAddressSpecification",
        "ec2.PortRange": "PortRange",
        "ec2.PrivateIpAddresses": "PrivateIpAddressSpecification",
        "ec2.SecurityGroupEgress": "SecurityGroupRule",
        "ec2.SecurityGroupIngress": "SecurityGroupRule",
        "ec2.SpotFleetRequestConfigData": "SpotFleetRequestConfigData",
        "ec2.SpotFleetRequestConfigData.LaunchSpecifications": "PrivateIpAddressSpecification",
        "ec2.SpotFleetRequestConfigData.LaunchTemplateConfigs": "LaunchTemplateOverrides",
        "ec2.SpotFleetRequestConfigData.LoadBalancersConfig": "TargetGroup",
        "ec2.SsmAssociations": "SsmAssociations",
        "ec2.SsmAssociations.AssociationParameters": "AssociationParameters",
        "ec2.Volumes": "MountPoint",
        "ec2.VpnTunnelOptionsSpecifications": "VpnTunnelOptionsSpecification",
        "ecr.LifecyclePolicy": "LifecyclePolicy",
        "ecs.ContainerDefinitions": "ContainerDefinition",
        "ecs.ContainerDefinitions.Environment": "Environment",
        "ecs.ContainerDefinitions.ExtraHosts": "HostEntry",
        "ecs.ContainerDefinitions.HealthCheck": "HealthCheck",
        "ecs.ContainerDefinitions.LinuxParameters": "LinuxParameters",
        "ecs.ContainerDefinitions.LinuxParameters.Capabilities": "KernelCapabilities",
        "ecs.ContainerDefinitions.LinuxParameters.Devices": "Device",
        "ecs.ContainerDefinitions.LogConfiguration": "LogConfiguration",
        "ecs.ContainerDefinitions.MountPoints": "MountPoint",
        "ecs.ContainerDefinitions.PortMappings": "PortMapping",
        "ecs.ContainerDefinitions.RepositoryCredentials": "RepositoryCredentials",
        "ecs.ContainerDefinitions.Ulimits": "Ulimit",
        "ecs.ContainerDefinitions.VolumesFrom": "VolumesFrom",
        "ecs.DeploymentConfiguration": "DeploymentConfiguration",
        "ecs.LoadBalancers": "LoadBalancer",
        "ecs.NetworkConfiguration": "NetworkConfiguration",
        "ecs.NetworkConfiguration.AwsvpcConfiguration": "AwsvpcConfiguration",
        "ecs.PlacementConstraints": "PlacementConstraint",
        "ecs.PlacementStrategies": "PlacementStrategy",
        "ecs.ServiceRegistries": "ServiceRegistry",
        "ecs.Volumes": "Volume",
        "ecs.Volumes.DockerVolumeConfiguration": "DockerVolumeConfiguration",
        "ecs.Volumes.Host": "Host",
        "eks.ResourcesVpcConfig": "ResourcesVpcConfig",
        "elasticache.NodeGroupConfiguration": "NodeGroupConfiguration",
        "elasticbeanstalk.OptionSettings": "OptionSettings",
        "elasticbeanstalk.ResourceLifecycleConfig": "ApplicationResourceLifecycleConfig",
        "elasticbeanstalk.ResourceLifecycleConfig.VersionLifecycleConfig": "ApplicationVersionLifecycleConfig",
        "elasticbeanstalk.ResourceLifecycleConfig.VersionLifecycleConfig.MaxAgeRule": "MaxAgeRule",
        "elasticbeanstalk.ResourceLifecycleConfig.VersionLifecycleConfig.MaxCountRule": "MaxCountRule",
        "elasticbeanstalk.SourceBundle": "SourceBundle",
        "elasticbeanstalk.SourceConfiguration": "SourceConfiguration",
        "elasticbeanstalk.Tier": "Tier",
        "elasticloadbalancing.AccessLoggingPolicy": "AccessLoggingPolicy",
        "elasticloadbalancing.AppCookieStickinessPolicy": "AppCookieStickinessPolicy",
        "elasticloadbalancing.ConnectionDrainingPolicy": "ConnectionDrainingPolicy",
        "elasticloadbalancing.ConnectionSettings": "ConnectionSettings",
        "elasticloadbalancing.HealthCheck": "HealthCheck",
        "elasticloadbalancing.LBCookieStickinessPolicy": "LBCookieStickinessPolicy",
        "elasticloadbalancing.Listeners": "Listener",
        "elasticloadbalancing.Policies": "Policy",
        "elasticloadbalancingv2.Actions": "Action",
        "elasticloadbalancingv2.Certificates": "Certificate",
        "elasticloadbalancingv2.Conditions": "Condition",
        "elasticloadbalancingv2.DefaultActions": "Action",
        "elasticloadbalancingv2.LoadBalancerAttributes": "LoadBalancerAttributes",
        "elasticloadbalancingv2.Matcher": "Matcher",
        "elasticloadbalancingv2.SubnetMappings": "SubnetMapping",
        "elasticloadbalancingv2.TargetGroupAttributes": "TargetGroupAttribute",
        "elasticloadbalancingv2.Targets": "TargetDescription",
        "elasticsearch.EBSOptions": "EBSOptions",
        "elasticsearch.ElasticsearchClusterConfig": "ElasticsearchClusterConfig",
        "elasticsearch.EncryptionAtRestOptions": "EncryptionAtRestOptions",
        "elasticsearch.SnapshotOptions": "SnapshotOptions",
        "elasticsearch.VPCOptions": "VPCOptions",
        "emr.Applications": "Application",
        "emr.AutoScalingPolicy": "AutoScalingPolicy",
        "emr.AutoScalingPolicy.Constraints": "ScalingConstraints",
        "emr.AutoScalingPolicy.Rules": "ScalingRule",
        "emr.AutoScalingPolicy.Rules.Action": "SimpleScalingPolicyConfiguration",
        "emr.AutoScalingPolicy.Rules.Trigger": "ScalingTrigger",
        "emr.AutoScalingPolicy.Rules.Trigger.CloudWatchAlarmDefinition": "KeyValue",
        "emr.BootstrapActions": "BootstrapActionConfig",
        "emr.BootstrapActions.ScriptBootstrapAction": "ScriptBootstrapActionConfig",
        "emr.Configurations": "Configuration",
        "emr.Configurations.Configurations": "Configuration",
        "emr.EbsConfiguration": "EbsConfiguration",
        "emr.EbsConfiguration.EbsBlockDeviceConfigs": "VolumeSpecification",
        "emr.HadoopJarStep": "HadoopJarStepConfig",
        "emr.HadoopJarStep.StepProperties": "KeyValue",
        "emr.InstanceTypeConfigs": "InstanceTypeConfig",
        "emr.InstanceTypeConfigs.Configurations": "Configuration",
        "emr.InstanceTypeConfigs.EbsConfiguration": "EbsConfiguration",
        "emr.Instances": "JobFlowInstancesConfig",
        "emr.Instances.CoreInstanceFleet": "InstanceFleetProvisioningSpecifications",
        "emr.Instances.CoreInstanceGroup": "EbsConfiguration",
        "emr.Instances.MasterInstanceFleet": "InstanceFleetConfigProperty",
        "emr.Instances.MasterInstanceGroup": "InstanceGroupConfigProperty",
        "emr.Instances.Placement": "PlacementType",
        "emr.KerberosAttributes": "KerberosAttributes",
        "emr.LaunchSpecifications": "InstanceFleetProvisioningSpecifications",
        "emr.LaunchSpecifications.SpotSpecification": "SpotProvisioningSpecification",
        "events.Targets": "Target",
        "events.Targets.EcsParameters": "EcsParameters",
        "events.Targets.InputTransformer": "InputTransformer",
        "events.Targets.KinesisParameters": "KinesisParameters",
        "events.Targets.RunCommandParameters": "RunCommandTarget",
        "firehose.ElasticsearchDestinationConfiguration": "ElasticsearchDestinationConfiguration",
        "firehose.ElasticsearchDestinationConfiguration.BufferingHints": "BufferingHints",
        "firehose.ElasticsearchDestinationConfiguration.CloudWatchLoggingOptions": "CloudWatchLoggingOptions",
        "firehose.ElasticsearchDestinationConfiguration.ProcessingConfiguration": "ProcessingConfiguration",
        "firehose.ElasticsearchDestinationConfiguration.RetryOptions": "RetryOptions",
        "firehose.ElasticsearchDestinationConfiguration.S3Configuration": "S3Configuration",
        "firehose.ElasticsearchDestinationConfiguration.S3Configuration.BufferingHints": "BufferingHints",
        "firehose.ElasticsearchDestinationConfiguration.S3Configuration.CloudWatchLoggingOptions": "CloudWatchLoggingOptions",
        "firehose.ElasticsearchDestinationConfiguration.S3Configuration.EncryptionConfiguration": "EncryptionConfiguration",
        "firehose.ExtendedS3DestinationConfiguration": "ExtendedS3DestinationConfiguration",
        "firehose.ExtendedS3DestinationConfiguration.BufferingHints": "BufferingHints",
        "firehose.ExtendedS3DestinationConfiguration.CloudWatchLoggingOptions": "CloudWatchLoggingOptions",
        "firehose.ExtendedS3DestinationConfiguration.EncryptionConfiguration": "KMSEncryptionConfig",
        "firehose.ExtendedS3DestinationConfiguration.ProcessingConfiguration": "ProcessingConfiguration",
        "firehose.ExtendedS3DestinationConfiguration.S3BackupConfiguration": "S3DestinationConfiguration",
        "firehose.KinesisStreamSourceConfiguration": "KinesisStreamSourceConfiguration",
        "firehose.RedshiftDestinationConfiguration": "RedshiftDestinationConfiguration",
        "firehose.RedshiftDestinationConfiguration.CloudWatchLoggingOptions": "CloudWatchLoggingOptions",
        "firehose.RedshiftDestinationConfiguration.CopyCommand": "CopyCommand",
        "firehose.RedshiftDestinationConfiguration.ProcessingConfiguration": "ProcessorParameter",
        "firehose.RedshiftDestinationConfiguration.S3Configuration": "S3Configuration",
        "firehose.S3DestinationConfiguration": "S3DestinationConfiguration",
        "firehose.S3DestinationConfiguration.BufferingHints": "BufferingHints",
        "firehose.S3DestinationConfiguration.CloudWatchLoggingOptions": "CloudWatchLoggingOptions",
        "firehose.S3DestinationConfiguration.EncryptionConfiguration": "EncryptionConfiguration",
        "firehose.SplunkDestinationConfiguration": "SplunkDestinationConfiguration",
        "firehose.SplunkDestinationConfiguration.CloudWatchLoggingOptions": "CloudWatchLoggingOptions",
        "firehose.SplunkDestinationConfiguration.ProcessingConfiguration": "ProcessingConfiguration",
        "firehose.SplunkDestinationConfiguration.RetryOptions": "SplunkRetryOptions",
        "firehose.SplunkDestinationConfiguration.S3Configuration": "S3DestinationConfiguration",
        "glue.Actions": "Action",
        "glue.Command": "JobCommand",
        "glue.ConnectionInput": "ConnectionInput",
        "glue.ConnectionInput.PhysicalConnectionRequirements": "PhysicalConnectionRequirements",
        "glue.Connections": "ConnectionsList",
        "glue.DatabaseInput": "DatabaseInput",
        "glue.ExecutionProperty": "ExecutionProperty",
        "glue.GrokClassifier": "GrokClassifier",
        "glue.JsonClassifier": "JsonClassifier",
        "glue.PartitionInput": "PartitionInput",
        "glue.PartitionInput.StorageDescriptor": "StorageDescriptor",
        "glue.Predicate": "Predicate",
        "glue.Predicate.Conditions": "Condition",
        "glue.Schedule": "Schedule",
        "glue.SchemaChangePolicy": "SchemaChangePolicy",
        "glue.TableInput": "TableInput",
        "glue.TableInput.PartitionKeys": "Column",
        "glue.TableInput.StorageDescriptor": "Order",
        "glue.Targets": "Targets",
        "glue.Targets.JdbcTargets": "JdbcTarget",
        "glue.Targets.S3Targets": "S3Target",
        "glue.XMLClassifier": "XMLClassifier",
        "guardduty.FindingCriteria": "FindingCriteria",
        "guardduty.FindingCriteria.ItemType": "Condition",
        "iam.LoginProfile": "LoginProfile",
        "iam.Policies": "Policy",
        "iot.TopicRulePayload": "TopicRulePayload",
        "iot.TopicRulePayload.Actions": "PutItemInput",
        "kinesis.StreamEncryption": "StreamEncryption",
        "logs.MetricTransformations": "MetricTransformation",
        "opsworks.AppSource": "Source",
        "opsworks.BlockDeviceMappings": "BlockDeviceMapping",
        "opsworks.BlockDeviceMappings.Ebs": "EbsBlockDevice",
        "opsworks.ChefConfiguration": "ChefConfiguration",
        "opsworks.ConfigurationManager": "StackConfigurationManager",
        "opsworks.CustomCookbooksSource": "Source",
        "opsworks.CustomRecipes": "Recipes",
        "opsworks.DataSources": "DataSource",
        "opsworks.ElasticIps": "ElasticIp",
        "opsworks.Environment": "Environment",
        "opsworks.LifecycleEventConfiguration": "LifeCycleConfiguration",
        "opsworks.LifecycleEventConfiguration.ShutdownEventConfiguration": "ShutdownEventConfiguration",
        "opsworks.LoadBasedAutoScaling": "LoadBasedAutoScaling",
        "opsworks.LoadBasedAutoScaling.DownScaling": "AutoScalingThresholds",
        "opsworks.LoadBasedAutoScaling.UpScaling": "AutoScalingThresholds",
        "opsworks.RdsDbInstances": "RdsDbInstance",
        "opsworks.SslConfiguration": "SslConfiguration",
        "opsworks.TimeBasedAutoScaling": "TimeBasedAutoScaling",
        "opsworks.VolumeConfigurations": "VolumeConfiguration",
        "rds.DBSecurityGroupIngress": "RDSSecurityGroup",
        "rds.OptionConfigurations": "OptionConfiguration",
        "rds.OptionConfigurations.OptionSettings": "OptionSetting",
        "rds.ScalingConfiguration": "ScalingConfiguration",
        "redshift.LoggingProperties": "LoggingProperties",
        "redshift.Parameters": "AmazonRedshiftParameter",
        "route53.AliasTarget": "AliasTarget",
        "route53.GeoLocation": "GeoLocation",
        "route53.HealthCheckConfig": "HealthCheckConfiguration",
        "route53.HealthCheckConfig.AlarmIdentifier": "AlarmIdentifier",
        "route53.HostedZoneConfig": "HostedZoneConfiguration",
        "route53.QueryLoggingConfig": "QueryLoggingConfig",
        "route53.RecordSets": "RecordSet",
        "route53.RecordSets.AliasTarget": "AliasTarget",
        "route53.RecordSets.GeoLocation": "GeoLocation",
        "route53.VPCs": "HostedZoneVPCs",
        "s3.AccelerateConfiguration": "AccelerateConfiguration",
        "s3.AnalyticsConfigurations": "AnalyticsConfiguration",
        "s3.AnalyticsConfigurations.StorageClassAnalysis": "StorageClassAnalysis",
        "s3.AnalyticsConfigurations.StorageClassAnalysis.DataExport": "Destination",
        "s3.AnalyticsConfigurations.TagFilters": "TagFilter",
        "s3.BucketEncryption": "BucketEncryption",
        "s3.BucketEncryption.ServerSideEncryptionConfiguration": "ServerSideEncryptionRule",
        "s3.BucketEncryption.ServerSideEncryptionConfiguration.ServerSideEncryptionByDefault": "ServerSideEncryptionByDefault",
        "s3.CorsConfiguration": "CorsConfiguration",
        "s3.CorsConfiguration.CorsRules": "CorsRules",
        "s3.InventoryConfigurations": "InventoryConfiguration",
        "s3.InventoryConfigurations.Destination": "Destination",
        "s3.LifecycleConfiguration": "LifecycleConfiguration",
        "s3.LifecycleConfiguration.Rules": "LifecycleRule",
        "s3.LifecycleConfiguration.Rules.AbortIncompleteMultipartUpload": "AbortIncompleteMultipartUpload",
        "s3.LifecycleConfiguration.Rules.NoncurrentVersionTransition": "NoncurrentVersionTransition",
        "s3.LifecycleConfiguration.Rules.NoncurrentVersionTransitions": "NoncurrentVersionTransition",
        "s3.LifecycleConfiguration.Rules.TagFilters": "TagFilter",
        "s3.LifecycleConfiguration.Rules.Transition": "LifecycleRuleTransition",
        "s3.LifecycleConfiguration.Rules.Transitions": "LifecycleRuleTransition",
        "s3.LoggingConfiguration": "LoggingConfiguration",
        "s3.MetricsConfigurations": "MetricsConfiguration",
        "s3.MetricsConfigurations.TagFilters": "TagFilter",
        "s3.NotificationConfiguration": "NotificationConfiguration",
        "s3.NotificationConfiguration.LambdaConfigurations": "Filter",
        "s3.NotificationConfiguration.LambdaConfigurations.Filter": "S3Key",
        "s3.NotificationConfiguration.QueueConfigurations": "QueueConfigurations",
        "s3.NotificationConfiguration.QueueConfigurations.Filter": "Filter",
        "s3.NotificationConfiguration.TopicConfigurations": "TopicConfigurations",
        "s3.NotificationConfiguration.TopicConfigurations.Filter": "Filter",
        "s3.ReplicationConfiguration": "ReplicationConfiguration",
        "s3.ReplicationConfiguration.Rules": "ReplicationConfigurationRules",
        "s3.ReplicationConfiguration.Rules.Destination": "ReplicationConfigurationRulesDestination",
        "s3.ReplicationConfiguration.Rules.Destination.AccessControlTranslation": "AccessControlTranslation",
        "s3.ReplicationConfiguration.Rules.Destination.EncryptionConfiguration": "EncryptionConfiguration",
        "s3.ReplicationConfiguration.Rules.SourceSelectionCriteria": "SourceSelectionCriteria",
        "s3.ReplicationConfiguration.Rules.SourceSelectionCriteria.SseKmsEncryptedObjects": "SseKmsEncryptedObjects",
        "s3.VersioningConfiguration": "VersioningConfiguration",
        "s3.WebsiteConfiguration": "WebsiteConfiguration",
        "s3.WebsiteConfiguration.RedirectAllRequestsTo": "RedirectAllRequestsTo",
        "s3.WebsiteConfiguration.RoutingRules": "RoutingRuleCondition",
        "sagemaker.OnCreate": "NotebookInstanceLifecycleConfig",
        "sagemaker.OnStart": "NotebookInstanceLifecycleConfig",
        "sagemaker.PrimaryContainer": "ContainerDefinition",
        "sagemaker.ProductionVariants": "ProductionVariant",
        "serverless.DeadLetterQueue": "DeadLetterQueue",
        "serverless.PrimaryKey": "PrimaryKey",
        "servicecatalog.ProvisioningArtifactParameters": "ProvisioningArtifactProperties",
        "servicecatalog.ProvisioningParameters": "ProvisioningParameter",
        "servicediscovery.DnsConfig": "DnsConfig",
        "servicediscovery.DnsConfig.DnsRecords": "DnsRecord",
        "servicediscovery.HealthCheckConfig": "HealthCheckConfig",
        "servicediscovery.HealthCheckCustomConfig": "HealthCheckCustomConfig",
        "ses.EventDestination": "EventDestination",
        "ses.EventDestination.CloudWatchDestination": "DimensionConfiguration",
        "ses.EventDestination.KinesisFirehoseDestination": "KinesisFirehoseDestination",
        "ses.Filter": "Filter",
        "ses.Filter.IpFilter": "IpFilter",
        "ses.Rule": "Rule",
        "ses.Rule.Actions": "WorkmailAction",
        "ses.Template": "EmailTemplate",
        "sns.Subscription": "Subscription",
        "sqs.RedrivePolicy": "RedrivePolicy",
        "ssm.ApprovalRules": "RuleGroup",
        "ssm.ApprovalRules.PatchRules": "PatchFilterGroup",
        "ssm.GlobalFilters": "PatchFilterGroup",
        "ssm.GlobalFilters.PatchFilters": "PatchFilter",
        "ssm.LoggingInfo": "LoggingInfo",
        "ssm.OutputLocation": "InstanceAssociationOutputLocation",
        "ssm.OutputLocation.S3Location": "S3OutputLocation",
        "ssm.Targets": "Targets",
        "ssm.TaskInvocationParameters": "TaskInvocationParameters",
        "ssm.TaskInvocationParameters.MaintenanceWindowAutomationParameters": "MaintenanceWindowAutomationParameters",
        "ssm.TaskInvocationParameters.MaintenanceWindowLambdaParameters": "MaintenanceWindowLambdaParameters",
        "ssm.TaskInvocationParameters.MaintenanceWindowRunCommandParameters": "NotificationConfig",
        "ssm.TaskInvocationParameters.MaintenanceWindowStepFunctionsParameters": "MaintenanceWindowStepFunctionsParameters",
        "waf.ByteMatchTuples": "ByteMatchTuples",
        "waf.ByteMatchTuples.FieldToMatch": "FieldToMatch",
        "waf.DefaultAction": "Action",
        "waf.IPSetDescriptors": "IPSetDescriptors",
        "waf.Predicates": "Predicates",
        "waf.Rules": "Rules",
        "waf.Rules.Action": "Action",
        "waf.SizeConstraints": "SizeConstraint",
        "waf.SizeConstraints.FieldToMatch": "FieldToMatch",
        "waf.SqlInjectionMatchTuples": "SqlInjectionMatchTuples",
        "waf.SqlInjectionMatchTuples.FieldToMatch": "FieldToMatch",
        "waf.XssMatchTuples": "XssMatchTuple",
        "waf.XssMatchTuples.FieldToMatch": "FieldToMatch",
        "wafregional.ByteMatchTuples": "ByteMatchTuples",
        "wafregional.ByteMatchTuples.FieldToMatch": "FieldToMatch",
        "wafregional.DefaultAction": "Action",
        "wafregional.IPSetDescriptors": "IPSetDescriptors",
        "wafregional.Predicates": "Predicates",
        "wafregional.Rules": "Rules",
        "wafregional.Rules.Action": "Action",
        "wafregional.SizeConstraints": "SizeConstraint",
        "wafregional.SizeConstraints.FieldToMatch": "FieldToMatch",
        "wafregional.SqlInjectionMatchTuples": "SqlInjectionMatchTuples",
        "wafregional.SqlInjectionMatchTuples.FieldToMatch": "FieldToMatch",
        "wafregional.XssMatchTuples": "XssMatchTuple",
        "wafregional.XssMatchTuples.FieldToMatch": "FieldToMatch"
    };

    if (keyname in auto_generated_property_mapping) {
        return keyname.split(".")[0] + "." + auto_generated_property_mapping[keyname];
    } else {
        var partial = keyname.split(".");
        while (partial.length > 1) {
            partial.splice(0, 1);
            if (partial.join(".") in auto_generated_property_mapping) {
                return keyname.split(".")[0] + "." + auto_generated_property_mapping[partial.join(".")]
            }
        }
    }

    console.log("Unknown Troposphere mapping: " + keyname);

    return null;
}

function processJsParameter(param, spacing) {
    var paramitems = [];

    if (param === undefined || param === null)
        return undefined;
    if (typeof param == "boolean") {
        if (param)
            return "true";
        return "false";
    }
    if (typeof param == "number")
        return `${param}`;
    if (typeof param == "string") {
        var string_return = param;

        if (string_return.includes("\n")) {
            string_return = "`" + string_return + "`";
            return string_return;
        }
        
        string_return = param.replace(/\"/g,`\\"`);

        return `"${string_return}"`;
    }
    if (Array.isArray(param)) {
        if (param.length == 0) {
            return '[]';
        }

        param.forEach(paramitem => {
            var item = processJsParameter(paramitem, spacing + 4);
            if (item !== undefined) {
                paramitems.push(item);
            }
        });

        return `[
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + ']';
    }
    if (typeof param == "object") {
        Object.keys(param).forEach(function (key) {
            var item = processJsParameter(param[key], spacing + 4);
            if (item !== undefined) {
                paramitems.push(key + ": " + processJsParameter(param[key], spacing + 4));
            }
        });

        return `{
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + '}';
    }
    
    return undefined;
}

function processBoto3Parameter(param, spacing) {
    var paramitems = [];

    if (param === undefined || param === null)
        return undefined;
    if (typeof param == "boolean") {
        if (param)
            return "True";
        return "False";
    }
    if (typeof param == "number")
        return `${param}`;
    if (typeof param == "string") {
        var string_return = param;

        if (string_return.includes("\n")) {
            string_return = "\"\"\"" + string_return.replace(/\n/g, `\n` + ' '.repeat(spacing + 4)) + "\n\"\"\"";
            return string_return;
        }
        
        string_return = param.replace(/'/g,`\\'`);

        return `'${string_return}'`;
    }
    if (Array.isArray(param)) {
        if (param.length == 0) {
            return '[]';
        }

        param.forEach(paramitem => {
            var item = processBoto3Parameter(paramitem, spacing + 4);
            if (item !== undefined) {
                paramitems.push(item);
            }
        });

        return `[
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + ']';
    }
    if (typeof param == "object") {
        Object.keys(param).forEach(function (key) {
            var item = processBoto3Parameter(param[key], spacing + 4);
            if (item !== undefined) {
                paramitems.push("'" + key + "': " + processBoto3Parameter(param[key], spacing + 4));
            }
        });

        return `{
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `
` + ' '.repeat(spacing) + '}';
    }
    
    return undefined;
}

function deplural(str) {
    if (typeof str != "string") {
        return str;
    }

    if (str.endsWith("ies")) { // TODO: Fix very primitive checks
        str = str.substring(0,str.length-3) + "y";
    } else if (str.endsWith("ses")) {
        str = str.substring(0,str.length-2);
    } else if (str.endsWith("s") && !str.endsWith("ss")) {
        str = str.substring(0,str.length-1);
    }

    return str;
}

function processGoParameter(service, paramkey, param, spacing) {
    var paramitems = [];

    paramkey = deplural(paramkey);

    if (param === undefined || param === null)
        return undefined;
    if (typeof param == "boolean") {
        if (param)
            return "aws.Bool(true)";
        return "aws.Bool(false)";
    }
    if (typeof param == "number")
        return `aws.Int64(${param})`;
    if (typeof param == "string") {
        var string_return = param;

        if (string_return.includes("\n")) {
            string_return = "aws.String(`" + string_return + "`)";
            return string_return;
        }
        
        string_return = param.replace(/\"/g,`\\"`);

        return `aws.String("${string_return}")`;
    }
    if (Array.isArray(param)) {
        if (param.length == 0) {
            return `[]*${service}.${paramkey}{}`;
        }

        param.forEach(paramitem => {
            var item = processGoParameter(service, paramkey, paramitem, spacing + 4);
            if (item !== undefined) {
                paramitems.push(item);
            }
        });

        if (paramitems.length == 0) {
            return `[]*${service}.${paramkey}{}`;
        }

        slicetype = `*${service}.${paramkey}`;
        if (paramitems[0].startsWith("aws.String(")) {
            slicetype = "*string";
        } else if (paramitems[0].startsWith("aws.Bool(")) {
            slicetype = "*bool";
        } else if (paramitems[0].startsWith("aws.Int64(")) {
            slicetype = "*int64";
        }

        return `[]${slicetype}{
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `,
` + ' '.repeat(spacing) + '}';
    }
    if (typeof param == "object") {
        Object.keys(param).forEach(function (key) {
            var item = processGoParameter(service, key, param[key], spacing + 4);
            if (item !== undefined) {
                paramitems.push(key + ": " + processGoParameter(service, key, param[key], spacing + 4));
            }
        });

        return `&${service}.${paramkey}{
` + ' '.repeat(spacing + 4) + paramitems.join(`,
` + ' '.repeat(spacing + 4)) + `,
` + ' '.repeat(spacing) + '}';
    }
    
    return undefined;
}

function outputMapBoto3(service, method, options, region, was_blocked) {
    var output = ensureInitDeclaredBoto3(service, region);
    var params = '';

    if (Object.keys(options).length) {
        for (option in options) {
            if (options[option] !== undefined && options[option] !== null) {
                var optionvalue = processBoto3Parameter(options[option], 4);
                params += `
    ${option}=${optionvalue},`;
            }
        }
        params = params.substring(0, params.length - 1) + `
`; // remove last comma
    }

    output += `response = ${service}_client.${method}(${params})${was_blocked ? ' # blocked' : ''}
`

    return output;
}

function outputMapGo(service, method, options, region, was_blocked) {
    var output = ensureInitDeclaredGo(service, region);
    var params = '';
    var mappedservice = mapServiceJs(service).toLowerCase().replace(/\-/g,'');

    if (Object.keys(options).length) {
        for (option in options) {
            if (options[option] !== undefined && options[option] !== null) {
                var optionvalue = processGoParameter(mappedservice, option, options[option], 8);
                params += `
        ${option}: ${optionvalue},`;
            }
        }
        params += `
    `;
    }

    output += `    _, err ${go_first_output ? ':' : ''}= ${service}svc.${method}(&${mappedservice}.${method}Input{${params}})${was_blocked ? ' // blocked' : ''}
`

    go_first_output = false;

    return output;
}

function outputMapJs(service, method, options, region, was_blocked) {
    var output = ensureInitDeclaredJs(service, region);
    var params = '';

    if (Object.keys(options).length) {
        for (option in options) {
            if (options[option] !== undefined && options[option] !== null) {
                var optionvalue = processJsParameter(options[option], 4);
                params += `
    ${option}: ${optionvalue},`;
            }
        }
        params = "{" + params.substring(0, params.length - 1) + `
}`; // remove last comma
    }



    output += `
${service}.${method}(${params});${was_blocked ? ' // blocked' : ''}`;

    return output;
}

function getResourceName(service, requestId) {
    var i = 1; // on purpose, 2 means second usage
    var proposed = service.replace(/\-/g, "") + MD5(requestId).substring(0,7);

    while (global_used_refs.includes(proposed)) {
        proposed = service.replace(/\-/g, "") + MD5(requestId + i).substring(0,7);
        i += 1;
    }

    global_used_refs.push(proposed);

    return proposed;
}

function lcfirststr(str) {
    if (str.toUpperCase() == str) {
        return str.toLowerCase();
    }

    var ret = str.charAt(0).toLowerCase();

    if (str.length > 1 && str[1].toUpperCase() == str[1]) {
        var i = 1;
        while (str.length > i && str[i].toUpperCase() == str[i]) {
            ret += str[i].toLowerCase();
            i++;
        }
        ret = ret.substring(0, ret.length-1) + ret.charAt(ret.length-1).toUpperCase() + str.substring(ret.length);
    } else {
        ret += str.substring(1);
    }

    return ret;
}

function outputMapTroposphere(index, service, type, options, region, was_blocked, logicalId) {
    var output = '';
    var params = '';

    troposervice = type.split("::")[1].toLowerCase();

    if (troposervice == "kinesisanalytics") {
        troposervice = "analytics";
    } else if (troposervice == "lambda") {
        troposervice = "awslambda";
    } else if (troposervice == "kinesisfirehose") {
        troposervice = "firehose";
    }

    tropotype = type.split("::")[2];

    if (troposervice == "elasticsearch" && tropotype == "Domain") {
        tropotype = "ElasticsearchDomain";
    } else if (troposervice == "iam" && tropotype == "Policy") {
        tropotype = "PolicyType";
    } else if (troposervice == "route53" && tropotype == "RecordSet") {
        tropotype = "RecordSetType";
    } else if (troposervice == "sns" && tropotype == "Subscription") {
        tropotype = "SubscriptionResource";
    }

    if (Object.keys(options).length) {
        for (option in options) {
            if (options[option] !== undefined && options[option] !== null) {
                var optionvalue = processTroposphereParameter(options[option], 4, troposervice + "." + option, index);
                params += `,
    ${option}=${optionvalue}`;
            }
        }
    }

    output += `${logicalId} = template.add_resource(${troposervice}.${tropotype}(
    "${logicalId}"${params}
))${was_blocked ? ' # blocked' : ''}

`;

    return output;
}

function outputMapCdkts(index, service, type, options, region, was_blocked, logicalId) {
    var output = '';
    var params = '';

    if (Object.keys(options).length) {
        for (option in options) {
            if (options[option] !== undefined && options[option] !== null) {
                var optionvalue = processCdktsParameter(options[option], 12, index);
                params += `
            ${lcfirststr(option)}: ${optionvalue},`;
            }
        }
        params = "{" + params.substring(0, params.length - 1) + `
        }`; // remove last comma
    }

    cdkservice = type.split("::")[1].toLowerCase();
    cdktype = type.split("::")[2];

    output += `        const ${logicalId} = new ${cdkservice}.Cfn${cdktype}(this, '${logicalId}', ${params});${was_blocked ? ' // blocked' : ''}

`;

    return output;
}

function outputMapIam(compiled_iam_outputs) {
    var output = `{
    "Version": "2012-10-17",
    "Statement": [
`;

    for (var i=0; i<compiled_iam_outputs.length; i++) {
        if (compiled_iam_outputs[i].mapped) {
            compiled_iam_outputs[i].action = [...new Set(compiled_iam_outputs[i].action)]; // dedup
            if (compiled_iam_outputs[i].action.length == 1) {
                compiled_iam_outputs[i].action = compiled_iam_outputs[i].action[0];
            }
            compiled_iam_outputs[i].resource = [...new Set(compiled_iam_outputs[i].resource)]; // dedup
            if (compiled_iam_outputs[i].resource.length == 1) {
                compiled_iam_outputs[i].resource = compiled_iam_outputs[i].resource[0];
            }

            var sid = "mapped" + MD5(Math.random().toString()).substring(0,7);

            output += `        {
            "Sid": "${sid}",
            "Action": ${JSON.stringify(compiled_iam_outputs[i].action).replace(/\,/g,",\n                ").replace(/\[/g,"[\n                ").replace(/\]/g,"\n            ]")},
            "Resource": ${JSON.stringify(compiled_iam_outputs[i].resource).replace(/\,/g,",\n                ").replace(/\[/g,"[\n                ").replace(/\]/g,"\n            ]")},
            "Effect": ${JSON.stringify(compiled_iam_outputs[i].effect)}
        },
`;
        }
    }

    for (var i=0; i<compiled_iam_outputs.length; i++) {
        if (!compiled_iam_outputs[i].mapped) {
            compiled_iam_outputs[i].action = [...new Set(compiled_iam_outputs[i].action)]; // dedup
            if (compiled_iam_outputs[i].action.length == 1) {
                compiled_iam_outputs[i].action = compiled_iam_outputs[i].action[0];
            }
            compiled_iam_outputs[i].resource = [...new Set(compiled_iam_outputs[i].resource)]; // dedup
            if (compiled_iam_outputs[i].resource.length == 1) {
                compiled_iam_outputs[i].resource = compiled_iam_outputs[i].resource[0];
            }

            var sid = "unmappedactions";

            output += `        {
            "Sid": "${sid}",
            "Action": ${JSON.stringify(compiled_iam_outputs[i].action).replace(/\,/g,",\n                ").replace(/\[/g,"[\n                ").replace(/\]/g,"\n            ]")},
            "Resource": ${JSON.stringify(compiled_iam_outputs[i].resource).replace(/\,/g,",\n                ").replace(/\[/g,"[\n                ").replace(/\]/g,"\n            ]")},
            "Effect": ${JSON.stringify(compiled_iam_outputs[i].effect)}
        },
`;
        }
    }

    output = output.substring(0, output.length - 2); // strip last comma

    output += `
    ]
}
`;

    return output;
}

function compileMapIam(compiled_iam_outputs, service, method, options, region, was_blocked) {
    var action = [
        service + ":" + method
    ];

    if (options.Action) {
        action = options.Action;
    }

    if (options.Resource) {
        compiled_iam_outputs.push({
            'mapped': true,
            'action': action,
            'resource': options.Resource,
            'effect': 'Allow'
        });
    } else {
        for (var i=0; i<compiled_iam_outputs.length; i++) {
            if (compiled_iam_outputs[i].mapped == false) {
                compiled_iam_outputs[i].action.push(service + ":" + method);

                return compiled_iam_outputs;
            }
        }
        compiled_iam_outputs.push({
            'mapped': false,
            'action': action,
            'resource': [
                '*'
            ],
            'effect': 'Allow'
        });
    }

    if (options.secondary) { // can be single object or array of objects
        if (Array.isArray(options.secondary)) {
            for (var i=0; i<options.secondary.length; i++) {
                compiled_iam_outputs = compileMapIam(compiled_iam_outputs, service, method, options.secondary[i], region, was_blocked);
            }
        } else {
            compiled_iam_outputs = compileMapIam(compiled_iam_outputs, service, method, options.secondary, region, was_blocked);
        }
    }

    return compiled_iam_outputs;
}

function outputMapCfn(index, service, type, options, region, was_blocked, logicalId) {
    var output = '';
    var params = '';

    if (Object.keys(options).length) {
        for (option in options) {
            if (options[option] !== undefined && options[option] !== null) {
                var optionvalue = processCfnParameter(options[option], (cfn_spacing.length * 3), index);

                if (optionvalue !== undefined) {
                    params += `
${cfn_spacing}${cfn_spacing}${cfn_spacing}${option}: ${optionvalue}`;
                }
            }
        }
        params += `
`;
    }

    if (params.trim() == "") {
        output += `${cfn_spacing}${logicalId}:${was_blocked ? ' # blocked' : ''}
        ${cfn_spacing}${cfn_spacing}Type: "${type}"

`;
    } else {
        output += `${cfn_spacing}${logicalId}:${was_blocked ? ' # blocked' : ''}
${cfn_spacing}${cfn_spacing}Type: "${type}"
${cfn_spacing}${cfn_spacing}Properties:${params}
`;
    }



    return output;
}

function outputMapTf(index, service, type, options, region, was_blocked, logicalId) {
    var output = '';
    var params = '';

    if (Object.keys(options).length) {
        for (option in options) {
            if (options[option] !== undefined && options[option] !== null) {
                if (Array.isArray(options[option]) && typeof options[option][0] === 'object') {
                    for (var i=0; i<options[option].length; i++) {
                        var optionvalue = processTfParameter(options[option][i], 4, index);
                        if (optionvalue[0] == '{') {
                            params += `
    ${option} ${optionvalue}
`;
                        } else {
                            params += `
    ${option} = ${optionvalue}`;
                        }

                    }
                } else {
                    var optionvalue = processTfParameter(options[option], 4, index);
                    if (optionvalue[0] == '{') {
                        params += `
    ${option} ${optionvalue}
`;
                    } else {
                        params += `
    ${option} = ${optionvalue}`;
                    }
                }
            }
        }
        params += `
`;
    }

    output += `
resource "${type}" "${logicalId}" {${params}}
`;

    return output;
}

function outputMapCli(service, method, options, region, was_blocked) {
    var params = '';

    if (Object.keys(options).length) {
        if ('_' in options) {
            options['_'].forEach(arg => {
                params += ` ${arg}`
            });
            delete options['_'];
        }
        if ('_cli_service' in options) {
            service = options['_cli_service'];
            delete options['_cli_service'];
        }
        for (option in options) {
            if (options[option] !== undefined) {
                if (options[option] === null) {
                    params += ` ${option}`
                } else if (typeof options[option] == "boolean") {
                    if (options[option])
                        params += ` ${option}`
                    else
                        params += ` --no-${option.substr(2)}`
                } else {
                    var optionvalue = JSON.stringify(options[option]);
                    if (typeof options[option] == "object") {
                        if (navigator.appVersion.indexOf("Win")!=-1) {
                            optionvalue = "\"" + optionvalue.replace(/\"/g, "\\\"") + "\"";
                        } else {
                            optionvalue = "'" + optionvalue + "'";
                        }
                    }
                    params += ` ${option} ${optionvalue}`
                }
            }
        }
    }

    output = `aws ${service} ${method}${params} --region ${region}${was_blocked ? ' # blocked' : ''}
`;

    return output;
}

function compileOutputs() {
    if (!outputs.length) {
        return {
            'boto3': '# No recorded actions yet',
            'go': '// No recorded actions yet',
            'cfn': '# No recorded actions yet',
            'tf': '# No recorded actions yet',
            'cli': '# No recorded actions yet',
            'js': '// No recorded actions yet',
            'cdkts': '// No recorded actions yet',
            'iam': '// No recorded actions yet',
            'troposphere': '# No recorded actions yet'
        };
    }

    var services = {
        'go': [],
        'cdkts': [],
        'troposphere': []
    };
    for (var i=0; i<outputs.length; i++) {
        if (!services['go'].includes(outputs[i].service)) {
            services['go'].push(outputs[i].service);
        }
    }
    for (var i=0; i<tracked_resources.length; i++) {
        if (tracked_resources[i].type && !services['cdkts'].includes(tracked_resources[i].type.split("::")[1].toLowerCase())) {
            var troposervice = tracked_resources[i].type.split("::")[1].toLowerCase();

            if (troposervice == "kinesisanalytics") {
                troposervice = "analytics";
            } else if (troposervice == "lambda") {
                troposervice = "awslambda";
            } else if (troposervice == "kinesisfirehose") {
                troposervice = "firehose";
            }

            services['cdkts'].push(tracked_resources[i].type.split("::")[1].toLowerCase());
            services['troposphere'].push(troposervice);
        }
    }

    var has_cfn = false;
    var has_tf = false;
    for (var i=0; i<tracked_resources.length; i++) {
        if (tracked_resources[i].type) {
            has_cfn = true;
        }
        if (tracked_resources[i].terraformType) {
            has_tf = true;
        }
    }

    var region = outputs[0].region;

    compiled = {
        'boto3': `# pip install boto3

import boto3
`,
        'go': `// go get -u github.com/aws/aws-sdk-go/...

package main

import (
    "github.com/aws/aws-sdk-go/aws"
    "github.com/aws/aws-sdk-go/aws/session"
${services.go.map(service => `    "github.com/aws/aws-sdk-go/service/${mapServiceJs(service).toLowerCase().replace(/\-/g,'')}"`).join(`
`)}
)

func main() {
`,
        'cfn': `${!has_cfn ? '# No resources created in recording' : `AWSTemplateFormatVersion: "2010-09-09"
Metadata:
${cfn_spacing}Generator: "console-recorder"
Description: ""
Resources:
`}`,
        'tf': `${!has_tf ? '# No resources created in recording' : `# https://www.terraform.io/downloads.html

provider "aws" {
    region = "${tracked_resources[0].region}"
}
`}`,
        'cli': `# pip install awscli --upgrade --user

`,
        'js': `// npm install aws-sdk

var AWS = require('aws-sdk');`,
        'cdkts': `${!has_cfn ? '// No resources created in recording' : `// npm i -g aws-cdk

${services.cdkts.map(service => `import ${service} = require('@aws-cdk/aws-${service}');`).join(`
`)}
import cdk = require('@aws-cdk/cdk');

class MyStack extends cdk.Stack {
    constructor(parent: cdk.App, name: string, props?: cdk.StackProps) {
        super(parent, name, props);

`}`,
        'iam': null,
        'troposphere': `${!has_cfn ? '# No resources created in recording' : `# pip install troposphere

from troposphere import ${services.troposphere.map(service => `${service}`).join(', ')}
from troposphere import Ref, GetAtt, Template

template = Template()

template.add_version("2010-09-09")

`}`
    }

    declared_services = {
        'boto3': [],
        'go': [],
        'js': []
    }
    go_first_output = true;

    var compiled_iam_outputs = [];
    for (var i=0; i<outputs.length; i++) {
        compiled['boto3'] += outputMapBoto3(outputs[i].service, outputs[i].method.boto3, outputs[i].options.boto3, outputs[i].region, outputs[i].was_blocked);
        compiled['go'] += outputMapGo(outputs[i].service, outputs[i].method.api, outputs[i].options.boto3, outputs[i].region, outputs[i].was_blocked);
        compiled['cli'] += outputMapCli(outputs[i].service, outputs[i].method.cli, outputs[i].options.cli, outputs[i].region, outputs[i].was_blocked);
        compiled['js'] += outputMapJs(outputs[i].service, lowerFirstChar(outputs[i].method.api), outputs[i].options.boto3, outputs[i].region, outputs[i].was_blocked);
        compiled_iam_outputs = compileMapIam(compiled_iam_outputs, outputs[i].service, outputs[i].method.api, outputs[i].options.iam, outputs[i].region, outputs[i].was_blocked);
    }
    compiled['iam'] = outputMapIam(compiled_iam_outputs);
    compiled['js'] += `\n`;
    compiled['go'] += `
    if err != nil {
        panic(err);
    }
}
`;

    for (var i=0; i<tracked_resources.length; i++) {
        if (tracked_resources[i].type) {
            compiled['cfn'] += outputMapCfn(i, tracked_resources[i].service, tracked_resources[i].type, tracked_resources[i].options.cfn, tracked_resources[i].region, tracked_resources[i].was_blocked, tracked_resources[i].logicalId);
            compiled['cdkts'] += outputMapCdkts(i, tracked_resources[i].service, tracked_resources[i].type, tracked_resources[i].options.cfn, tracked_resources[i].region, tracked_resources[i].was_blocked, tracked_resources[i].logicalId);
            compiled['troposphere'] += outputMapTroposphere(i, tracked_resources[i].service, tracked_resources[i].type, tracked_resources[i].options.cfn, tracked_resources[i].region, tracked_resources[i].was_blocked, tracked_resources[i].logicalId);
        }
        if (tracked_resources[i].terraformType) {
            compiled['tf'] += outputMapTf(i, tracked_resources[i].service, tracked_resources[i].terraformType, tracked_resources[i].options.tf, tracked_resources[i].region, tracked_resources[i].was_blocked, tracked_resources[i].logicalId);
        }
    }
    for (var i=0; i<tracked_resources.length; i++) {
        if (tracked_resources[i].type) {
            compiled['cdkts'] = compiled['cdkts'].substring(0, compiled['cdkts'].length-1); // trim a newline
            compiled['cdkts'] += `
        new cdk.Output(this, '${tracked_resources[i].logicalId}Ref', { value: ${tracked_resources[i].logicalId}.ref, disableExport: true });`;
        }
    }

    if (tracked_resources.length) {
        compiled['cdkts'] += `
    }
}

const app = new cdk.App();

new MyStack(app, 'my-stack-name', { env: { region: '${tracked_resources[0].region}' } });

app.run();
`;
        compiled['troposphere'] += `print(template.to_yaml())
`;
    }

    return compiled;
}

function mapServiceJs(service) {
    var service_mapping = {
        "acm": "ACM",
        "acm-pca": "ACMPCA",
        "apigateway": "APIGateway",
        "alexaforbusiness": "AlexaForBusiness",
        "appstream": "AppStream",
        "appsync": "AppSync",
        "application-autoscaling": "ApplicationAutoScaling",
        "athena": "Athena",
        "autoscaling": "AutoScaling",
        "autoscaling-plans": "AutoScalingPlans",
        "batch": "Batch",
        "budgets": "Budgets",
        "cur": "CUR",
        "cloud9": "Cloud9",
        "clouddirectory": "CloudDirectory",
        "cloudformation": "CloudFormation",
        "cloudfront": "CloudFront",
        "cloudhsm": "CloudHSM",
        "cloudhsmv2": "CloudHSMV2",
        "cloudsearch": "CloudSearch",
        "cloudsearchdomain": "CloudSearchDomain",
        "cloudtrail": "CloudTrail",
        "cloudwatch": "CloudWatch",
        "cloudwatchevents": "CloudWatchEvents",
        "cloudwatchlogs": "CloudWatchLogs",
        "codebuild": "CodeBuild",
        "codecommit": "CodeCommit",
        "codedeploy": "CodeDeploy",
        "codepipeline": "CodePipeline",
        "codestar": "CodeStar",
        "cognito-identity": "CognitoIdentity",
        "cognito-idp": "CognitoIdentityServiceProvider",
        "cognito-sync": "CognitoSync",
        "comprehend": "Comprehend",
        "config": "ConfigService",
        "connect": "Connect",
        "costexplorer": "CostExplorer",
        "dax": "DAX",
        "dlm": "DLM",
        "dms": "DMS",
        "datapipeline": "DataPipeline",
        "devicefarm": "DeviceFarm",
        "directconnect": "DirectConnect",
        "ds": "DirectoryService",
        "discovery": "Discovery",
        "dynamodb": "DynamoDB",
        "dynamodbstreams": "DynamoDBStreams",
        "ec2": "EC2",
        "ecr": "ECR",
        "ecs": "ECS",
        "efs": "EFS",
        "eks": "EKS",
        "elb": "ELB",
        "elbv2": "ELBv2",
        "emr": "EMR",
        "es": "ES",
        "elasticache": "ElastiCache",
        "elasticbeanstalk": "ElasticBeanstalk",
        "elastictranscoder": "ElasticTranscoder",
        "fms": "FMS",
        "firehose": "Firehose",
        "gamelift": "GameLift",
        "glacier": "Glacier",
        "glue": "Glue",
        "greengrass": "Greengrass",
        "guardduty": "GuardDuty",
        "health": "Health",
        "iam": "IAM",
        "importexport": "ImportExport",
        "inspector": "Inspector",
        "iot1click-devices": "IoT1ClickDevicesService",
        "iot1click-projects": "IoT1ClickProjects",
        "iotanalytics": "IoTAnalytics",
        "iot-jobs-data": "IoTJobsDataPlane",
        "iot": "Iot",
        "iot-data": "IotData",
        "kms": "KMS",
        "kinesis": "Kinesis",
        "kinesisanalytics": "KinesisAnalytics",
        "kinesisvideo": "KinesisVideo",
        "kinesis-video-archived-media": "KinesisVideoArchivedMedia",
        "kinesis-video-media": "KinesisVideoMedia",
        "lambda": "Lambda",
        "lex-models": "LexModelBuildingService",
        "lex-runtime": "LexRuntime",
        "lightsail": "Lightsail",
        "mq": "MQ",
        "mturk": "MTurk",
        "machinelearning": "MachineLearning",
        "macie": "Macie",
        "marketplacecommerceanalytics": "MarketplaceCommerceAnalytics",
        "marketplace-entitlement": "MarketplaceEntitlementService",
        "meteringmarketplace": "MarketplaceMetering",
        "mediaconvert": "MediaConvert",
        "medialive": "MediaLive",
        "mediapackage": "MediaPackage",
        "mediastore": "MediaStore",
        "mediastore-data": "MediaStoreData",
        "mediatailor": "MediaTailor",
        "metadataservice": "MetadataService",
        "mgh": "MigrationHub",
        "mobile": "Mobile",
        "mobileanalytics": "MobileAnalytics",
        "neptune": "Neptune",
        "opsworks": "OpsWorks",
        "opsworkscm": "OpsWorksCM",
        "organizations": "Organizations",
        "pi": "PI",
        "pinpoint": "Pinpoint",
        "polly": "Polly",
        "pricing": "Pricing",
        "rds": "RDS",
        "redshift": "Redshift",
        "rekognition": "Rekognition",
        "resource-groups": "ResourceGroups",
        "resourcegroupstaggingapi": "ResourceGroupsTaggingAPI",
        "route53": "Route53",
        "route53domains": "Route53Domains",
        "route53resolver": "Route53Resolver",
        "s3": "S3",
        "ses": "SES",
        "sms": "SMS",
        "sns": "SNS",
        "sqs": "SQS",
        "ssm": "SSM",
        "sts": "STS",
        "swf": "SWF",
        "sagemaker": "SageMaker",
        "sagemaker-runtime": "SageMakerRuntime",
        "secretsmanager": "SecretsManager",
        "serverlessrepo": "ServerlessApplicationRepository",
        "servicecatalog": "ServiceCatalog",
        "servicediscovery": "ServiceDiscovery",
        "shield": "Shield",
        "simpledb": "SimpleDB",
        "snowball": "Snowball",
        "stepfunctions": "StepFunctions",
        "storagegateway": "StorageGateway",
        "support": "Support",
        "temporarycredentials": "TemporaryCredentials",
        "transcribeservice": "TranscribeService",
        "translate": "Translate",
        "waf": "WAF",
        "waf-regional": "WAFRegional",
        "workdocs": "WorkDocs",
        "workmail": "WorkMail",
        "workspaces": "WorkSpaces",
        "xray": "XRay"
    };

    return service_mapping[service] || "";
}

function lowerFirstChar(str) {
    return str.substring(0,1).toLowerCase() + str.substring(1);
}

function convertApiToCli(str) {
    var i = 1;
    var character = '';
    var next_char = '';
    var prev_char = '';
    var outputstr = str.substring(0,1).toLowerCase();
    
    while (i <= str.length) {
        character = str.charAt(i);
        next_char = str.charAt(i+1);
        prev_char = str.charAt(i-1);
        if (character == character.toUpperCase() && character != "" && (next_char != next_char.toUpperCase() || prev_char != prev_char.toUpperCase())) {
            outputstr += "-";
        }
        outputstr += character.toLowerCase();
        i++;
    }

    return outputstr;
}

function recursiveParamsFromXml(node) {
    var ret = {};

    for (var child in node.children) {
        if (node.children[child].tagName) {
            if (node.children[child].children && node.children[child].children.length > 0) {
                ret[node.children[child].tagName] = recursiveParamsFromXml(node.children[child]);
            } else {
                ret[node.children[child].tagName] = node.children[child].textContent;
            }
        }
    }

    return ret;
}

function addToParamsFromXml(params, xml) {
    var xmlobj = new DOMParser().parseFromString(xml, "text/xml");
    var root = xmlobj.firstChild;
    var tagname = root.tagName;
    var value = recursiveParamsFromXml(xmlobj);

    params.boto3[tagname] = value[tagname];
    params.cli['--' + convertApiToCli(tagname)] = JSON.stringify(value[tagname]);

    return params;
}

function onAttach(tabId) {
    chrome.debugger.sendCommand({ //first enable the Network
        tabId: tabId
    }, "Network.enable");

    chrome.debugger.onEvent.addListener(allEventHandler);
}

function allEventHandler(debuggeeId, message, params) {
    if (message == "Network.requestWillBeSent") { // TODO: Fix race condition and bad potential breakage here
        for (var i=tracked_resources.length-1; i>=0; i--) {
            if (params.request.url == tracked_resources[i].requestDetails.url && Math.abs(params.wallTime-(tracked_resources[i].requestDetails.timeStamp/1000)) < 0.5) { // max 500ms between webRequest and debugger
                tracked_resources[i].debuggerRequestId = params.requestId;
                // dont break here, potentially many tracked resources to one call
            }
        }
    } else if (message == "Network.responseReceived") { // response return 
        chrome.debugger.sendCommand({
            tabId: debuggeeId.tabId
        }, "Network.getResponseBody", {
            "requestId": params.requestId
        }, function(response) {
            try {
                var body = response.body;

                if (response.base64Encoded) {
                    body = window.atob(response.body);
                }
                
                for (var i=tracked_resources.length-1; i>=0; i--) {
                    if (params.requestId == tracked_resources[i].debuggerRequestId) {
                        tracked_resources[i]["response"] = {
                            'timestamp': params.timestamp,
                            'properties': params.response,
                            'body': body
                        };
                        setOutputsForTrackedResource(i);
                    }
                }

                for (var i=0; i<outputs.length; i++) { // TODO
                    ;
                }
            } catch(err) { ; }
        });
    }
}

chrome.runtime.onMessage.addListener(
    function(message, sender, sendResponse) {
        if (message.action == "getCompiledOutputs") {
            sendResponse(compileOutputs());
        } else if (message.action == "setBlockingOn") {
            blocking = true;
            chrome.storage.local.set({blocking: true});
            sendResponse(true);
        } else if (message.action == "setBlockingOff") {
            blocking = false;
            chrome.storage.local.set({blocking: false});
            sendResponse(true);
        } else if (message.action == "getBlockingStatus") {
            sendResponse(blocking);
        } else if (message.action == "getCfnSpacing") {
            sendResponse(cfn_spacing.length);
        } else if (message.action == "setCfnSpacing") {
            if (message.cfnspacing == 4) {
                cfn_spacing = "    ";
            } else if (message.cfnspacing == 2) {
                cfn_spacing = "  ";
            }
            chrome.storage.local.set({cfnspacing: message.cfnspacing});
            sendResponse(true);
        } else if (message.action == "getTheme") {
            sendResponse(theme);
        } else if (message.action == "setTheme") {
            theme = message.theme;
            chrome.storage.local.set({theme: theme});
            sendResponse(true);
        } else if (message.action == "setInterceptOn") {
            intercept = true;
            chrome.storage.local.set({intercept: true});

            /* TODO: Check if required
            chrome.tabs.query(
                {
                    url: [
                        "*://*.console.aws.amazon.com/*",
                        "*://console.aws.amazon.com/*",
                        "*://*.amazonaws.com/*"
                    ]
                },
                function(tabArray) {
                    for (var i=0; i<tabArray.length; i++) {
                        var tab = tabArray[i];
                        chrome.debugger.attach({
                            tabId: tab.id
                        }, "1.2", onAttach.bind(null, tab.id));
                    }
                }
            );
            */

            sendResponse(true);
        } else if (message.action == "setInterceptOff") {
            intercept = false;
            chrome.storage.local.set({intercept: false});

            /* TODO: Check if required
            chrome.debugger.onEvent.removeListener(allEventHandler);
            chrome.debugger.getTargets(function(targets) {
                for (var i=0; i<targets.length; i++) {
                    chrome.debugger.detach({ // have to construct the object?!?
                        'tabId': targets[i].tabId,
                        'extensionId': targets[i].extensionId,
                        'targetId': targets[i].id
                    });
                }
            });
            */

            sendResponse(true);
        } else if (message.action == "getInterceptStatus") {
            sendResponse(intercept);
        } else if (message.action == "setRecordingOn") {
            recording = true;

            chrome.webRequest.onBeforeRequest.addListener(
                analyseRequest,
                {urls: [
                    "*://*.aws.amazon.com/*",
                    "*://*.amazonaws.com/*",
                    "*://*.amazonaws-us-gov.com/*"
                ]},
                ["requestBody","blocking"]
            );

            if (intercept && navigator.userAgent.search("Firefox") == -1) {
                chrome.tabs.query(
                    {
                        url: [
                            "*://*.aws.amazon.com/*",
                            "*://*.amazonaws.com/*",
                            "*://*.amazonaws-us-gov.com/*"
                        ]
                    },
                    function(tabArray) {
                        for (var i=0; i<tabArray.length; i++) {
                            var tab = tabArray[i];
                            try {
                                chrome.debugger.attach({
                                    tabId: tab.id
                                }, "1.2", onAttach.bind(null, tab.id));
                            } catch(e) {
                                ;
                            }
                        }
                    }
                );
            }

            chrome.browserAction.setBadgeText({ text: "REC" });
			chrome.browserAction.setBadgeBackgroundColor({ color: "#FF2222" });

            sendResponse(true);
        } else if (message.action == "setRecordingOff") {
            recording = false;

            chrome.webRequest.onBeforeRequest.removeListener(analyseRequest);

            if (intercept && navigator.userAgent.search("Firefox") == -1) {
                try {
                    chrome.debugger.onEvent.removeListener(allEventHandler);
                    chrome.debugger.getTargets(function(targets) {
                        for (var i=0; i<targets.length; i++) {
                            chrome.debugger.detach({ // have to construct the object?!?
                                'tabId': targets[i].tabId,
                                'extensionId': targets[i].extensionId,
                                'targetId': targets[i].id
                            }, function(){
                                void chrome.runtime.lastError; // don't care
                            });
                        }
                    });
                } catch(e) {
                    ;
                }
            }

            chrome.browserAction.setBadgeText({ text: "" });

            sendResponse(true);
        } else if (message.action == "getRecordingStatus") {
            sendResponse(recording);
        } else if (message.action == "clearData") {
            outputs = [];
            tracked_resources = [];
            sendResponse(true);
        }
    }
);

function getUrlValue(url, key) {
    var url = new URL(url);

    return url.searchParams.get(key);
}

function getPipeSplitField(str, index) { // DEPRECATED, use interpretGwtWireRequest instead
    if (!str) return null;
    
    var pipesplit = str.split("|");

    var result = pipesplit[parseInt(index)];

    if (result == "") return null;

    if (isNaN(parseInt(result))) {
        return result;
    }

    return parseInt(result);
}

function setOutputsForTrackedResource(index) {
    var jsonResponseBody = {};
    var xmlResponseBody = {};

    try {
        if (tracked_resources[index].response.body.startsWith("<")) {
            xmlResponseBody = new DOMParser().parseFromString(tracked_resources[index].response.body, "text/xml");
        } else {
            jsonResponseBody = JSON.parse(tracked_resources[index].response.body);
        }

        if (tracked_resources[index].type == "AWS::AmazonMQ::Broker") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.brokerId,
                'GetAtt': {
                    'Arn': jsonResponseBody.brokerArn
                },
                'Terraform': {
                    'id': jsonResponseBody.brokerId,
                    'arn': jsonResponseBody.brokerArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::AmazonMQ::Configuration") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.id,
                'GetAtt': {
                    'Arn': jsonResponseBody.arn,
                    'Revision': jsonResponseBody.latestRevision.revision
                },
                'Terraform': {
                    'id': jsonResponseBody.brokerId,
                    'arn': jsonResponseBody.brokerArn,
                    'latest_revision': jsonResponseBody.latestRevision.revision
                }
            };
        } else if (tracked_resources[index].type == "AWS::ApiGateway::Account") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::ApiGateway::Authorizer") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.id,
                'Terraform': {
                    'id': jsonResponseBody.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::ApiGatewayV2::Authorizer") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.id,
                'Terraform': {
                    'id': jsonResponseBody.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::ApiGateway::DocumentationPart") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.id,
                'Terraform': {
                    'id': jsonResponseBody.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::ApiGateway::DomainName") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::ApiGateway::GatewayResponse") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::ApiGateway::Method") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::ApiGateway::Model") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.id,
                'Terraform': {
                    'id': jsonResponseBody.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::ApiGatewayV2::Model") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.id,
                'Terraform': {
                    'id': jsonResponseBody.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::ApiGateway::UsagePlan") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.id,
                'Terraform': {
                    'id': jsonResponseBody.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::AppSync::ApiKey") {
            tracked_resources[index].returnValues = {
                'Ref': null,
                'GetAtt': {
                    'ApiKey': jsonResponseBody.apiKey.id
                },
                'Terraform': {
                    'id': jsonResponseBody.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::AppSync::DataSource") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.dataSource.dataSourceArn,
                'GetAtt': {
                    'DataSourceArn': jsonResponseBody.dataSource.dataSourceArn,
                    'Name': jsonResponseBody.dataSource.name
                },
                'Terraform': {
                    'arn': jsonResponseBody.dataSource.dataSourceArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::AppSync::GraphQLApi") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.graphqlApi.arn,
                'GetAtt': {
                    'GraphQLUrl': jsonResponseBody.graphqlApi.uris.GRAPHQL,
                    'Arn': jsonResponseBody.graphqlApi.arn,
                    'ApiId': jsonResponseBody.graphqlApi.apiId
                },
                'Terraform': {
                    'id': jsonResponseBody.graphqlApi.apiId,
                    'arn': jsonResponseBody.graphqlApi.arn,
                    'uris': jsonResponseBody.graphqlApi.uris
                }
            };
        } else if (tracked_resources[index].type == "AWS::AppSync::GraphQLSchema") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.ApiId + "GraphQLSchema"
            };
        } else if (tracked_resources[index].type == "AWS::AppSync::Resolver") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.resolver.resolverArn,
                'GetAtt': {
                    'TypeName': jsonResponseBody.resolver.typeName,
                    'ResolverArn': jsonResponseBody.resolver.resolverArn,
                    'FieldName': jsonResponseBody.resolver.fieldName
                }
            };
        } else if (tracked_resources[index].type == "AWS::Athena::NamedQuery") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.Name
            };
        } else if (tracked_resources[index].type == "AWS::AutoScaling::AutoScalingGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.AutoScalingGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.AutoScalingGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::AutoScaling::LaunchConfiguration") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.LaunchConfigurationName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.LaunchConfigurationName
                }
            };
        } else if (tracked_resources[index].type == "AWS::AutoScaling::LifecycleHook") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.LifecycleHookName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.LifecycleHookName
                }
            };
        } else if (tracked_resources[index].type == "AWS::AutoScaling::ScalingPolicy") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.PolicyARN,
                'Terraform': {
                    'arn': jsonResponseBody.PolicyARN
                }
            };
        } else if (tracked_resources[index].type == "AWS::AutoScaling::ScheduledAction") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.ScheduledActionName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.ScheduledActionName
                }
            };
        } else if (tracked_resources[index].type == "AWS::Batch::ComputeEnvironment") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.computeEnvironmentArn,
                'Terraform': {
                    'arn': jsonResponseBody.computeEnvironmentArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Batch::JobDefinition") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.jobDefinitionArn,
                'Terraform': {
                    'arn': jsonResponseBody.jobDefinitionArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Batch::JobQueue") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.jobQueueArn,
                'Terraform': {
                    'arn': jsonResponseBody.jobQueueArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Budgets::Budget") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::CertificateManager::Certificate") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.certificateArn,
                'Terraform': {
                    'arn': jsonResponseBody.certificateArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::CloudTrail::Trail") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.TrailName,
                'GetAtt': {
                    'Arn': jsonResponseBody.data.trailArn,
                    'SnsTopicArn': jsonResponseBody.data.snsTopicArn
                },
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.TrailName,
                    'arn': jsonResponseBody.data.trailArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::CodeDeploy::Application") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.ApplicationName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.ApplicationName
                }
            };
        } else if (tracked_resources[index].type == "AWS::CodeDeploy::DeploymentConfig") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.DeploymentConfigName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.DeploymentConfigName
                }
            };
        } else if (tracked_resources[index].type == "AWS::CodeDeploy::DeploymentGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.DeploymentGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.DeploymentGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::CodePipeline::Pipeline") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.Name,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.Name
                }
            };
        } else if (tracked_resources[index].type == "AWS::Cognito::IdentityPool") {
            tracked_resources[index].returnValues = {
                'Ref': null,
                'GetAtt': {
                    'Name': tracked_resources[index].options.cfn.IdentityPoolName
                },
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.IdentityPoolName
                }
            };
        } else if (tracked_resources[index].type == "AWS::Cognito::UserPool") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.success.data.id,
                'GetAtt': {
                    //'ProviderName': jsonResponseBody.success.data.,
                    //'ProviderURL': jsonResponseBody.success.data.,
                    'Arn': jsonResponseBody.success.data.arn
                },
                'Terraform': {
                    'id': jsonResponseBody.success.data.id,
                    'arn': jsonResponseBody.success.data.arn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Cognito::UserPoolClient") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.success.data.id,
                'Terraform': {
                    'id': jsonResponseBody.success.data.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::Cognito::UserPoolGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.GroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.GroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::Cognito::UserPoolUser") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.Username
            };
        } else if (tracked_resources[index].type == "AWS::Cognito::UserPoolUserToGroupAttachment") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::Config::ConfigurationAggregator") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.ConfigurationAggregatorName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.ConfigurationAggregatorName
                }
            };
        } else if (tracked_resources[index].type == "AWS::Config::ConfigRule") {
            ; // TODO
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.ConfigRuleName,
                'GetAtt': {
                    //'Arn': jsonResponseBody.,
                    //'ConfigRuleId': jsonResponseBody.,
                    //'Compliance.Type': jsonResponseBody.
                },
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.ConfigRuleName
                }
            };
        } else if (tracked_resources[index].type == "AWS::DirectoryService::MicrosoftAD") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.DirectoryId,
                'Terraform': {
                    'id': jsonResponseBody.DirectoryId
                }
            };
        } else if (tracked_resources[index].type == "AWS::DirectoryService::SimpleAD") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.DirectoryId,
                'Terraform': {
                    'id': jsonResponseBody.DirectoryId
                }
            };
        } else if (tracked_resources[index].type == "AWS::DocDB::DBCluster") {
            tracked_resources[index].returnValues = {
                'Ref': xmlResponseBody.getElementsByTagName("DBClusterIdentifier")[0].textContent,
                'GetAtt': {
                    'ClusterResourceId': xmlResponseBody.getElementsByTagName("DbClusterResourceId")[0].textContent,
                    'Endpoint': xmlResponseBody.getElementsByTagName("Endpoint")[0].textContent,
                    'Port': xmlResponseBody.getElementsByTagName("Port")[0].textContent,
                    'ReadEndpoint': xmlResponseBody.getElementsByTagName("ReaderEndpoint")[0].textContent
                }
            };
        } else if (tracked_resources[index].type == "AWS::DocDB::DBClusterParameterGroup") {
            tracked_resources[index].returnValues = {
                'Ref': xmlResponseBody.getElementsByTagName("DBClusterParameterGroupName")[0].textContent
            };
        } else if (tracked_resources[index].type == "AWS::DocDB::DBInstance") {
            tracked_resources[index].returnValues = {
                'Ref': xmlResponseBody.getElementsByTagName("DBInstanceIdentifier")[0].textContent
            };
        } else if (tracked_resources[index].type == "AWS::DocDB::DBSubnetGroup") {
            tracked_resources[index].returnValues = {
                'Ref': xmlResponseBody.getElementsByTagName("DBSubnetGroupName")[0].textContent
            };
        } else if (tracked_resources[index].type == "AWS::EC2::CustomerGateway") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.CustomerGateway.CustomerGatewayId,
                'Terraform': {
                    'id': jsonResponseBody.CustomerGateway.CustomerGatewayId
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::EIP") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.PublicIp,
                'GetAtt': {
                    'AllocationId': jsonResponseBody.allocationId
                },
                'Terraform': {
                    'id': jsonResponseBody.allocationId,
                    'public_ip': jsonResponseBody.PublicIp
                }
            };
        }  else if (tracked_resources[index].type == "AWS::EC2::EIPAssociation") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.associationId,
                'Terraform': {
                    'id': jsonResponseBody.allocationId
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::EgressOnlyInternetGateway") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.egressOnlyInternetGateway.egressOnlyInternetGatewayId,
                'Terraform': {
                    'id': jsonResponseBody.egressOnlyInternetGateway.egressOnlyInternetGatewayId
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::FlowLog") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.flowLogIds[0],
                'Terraform': {
                    'id': jsonResponseBody.flowLogIds[0]
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::Host") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::EC2::Instance") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.Instances[0].InstanceId,
                'GetAtt': {
                    'AvailabilityZone': jsonResponseBody.Instances[0].Placement.AvailabilityZone,
                    'PrivateDnsName': jsonResponseBody.Instances[0].PrivateDnsName,
                    'PublicDnsName': jsonResponseBody.Instances[0].PublicDnsName,
                    'PrivateIp': jsonResponseBody.Instances[0].PrivateIpAddress
                },
                'Terraform': {
                    'id': jsonResponseBody.Instances[0].InstanceId,
                    'availability_zone': jsonResponseBody.Instances[0].Placement.AvailabilityZone,
                    'private_dns': jsonResponseBody.Instances[0].PrivateDnsName,
                    'public_dns': jsonResponseBody.Instances[0].PublicDnsName,
                    'private_ip': jsonResponseBody.Instances[0].PrivateIpAddress
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::InternetGateway") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.internetGateway.internetGatewayId,
                'Terraform': {
                    'id': jsonResponseBody.internetGateway.internetGatewayId
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::LaunchTemplate") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.launchTemplate.launchTemplateId,
                'GetAtt': {
                    'LatestVersionNumber': jsonResponseBody.launchTemplate.latestVersionNumber,
                    'DefaultVersionNumber': jsonResponseBody.launchTemplate.defaultVersionNumber
                },
                'Terraform': {
                    'id': jsonResponseBody.launchTemplate.launchTemplateId,
                    'latest_version': jsonResponseBody.launchTemplate.latestVersionNumber,
                    'default_version': jsonResponseBody.launchTemplate.defaultVersionNumber
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::NatGateway") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.natGateway.natGatewayId,
                'Terraform': {
                    'id': jsonResponseBody.natGateway.natGatewayId
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::NetworkAcl") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::EC2::NetworkAclEntry") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::EC2::NetworkInterface") {
            var private_ips = [jsonResponseBody.networkInterface.privateIpAddress];
            var secondaryIpAddresses = [];
            for (var i=0; i<jsonResponseBody.networkInterface.privateIpAddresses.length; i++) {
                if (!jsonResponseBody.networkInterface.privateIpAddresses[i].primary) {
                    private_ips.push(jsonResponseBody.networkInterface.privateIpAddresses[i].privateIpAddress);
                    secondaryIpAddresses.push(jsonResponseBody.networkInterface.privateIpAddresses[i].privateIpAddress);
                }
            }

            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.networkInterface.networkInterfaceId,
                'GetAtt': {
                    'PrimaryPrivateIpAddress': jsonResponseBody.networkInterface.privateIpAddress,
                    'SecondaryPrivateIpAddresses': secondaryIpAddresses
                },
                'Terraform': {
                    'id': jsonResponseBody.networkInterface.networkInterfaceId,
                    'private_ips': private_ips
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::RouteTable") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::EC2::SecurityGroup") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.securityGroupId,
                'GetAtt': {
                    'GroupId': jsonResponseBody.securityGroupId
                },
                'Terraform': {
                    'id': jsonResponseBody.securityGroupId,
                    'description': tracked_resources[index].options.tf.description,
                    'vpc_id': tracked_resources[index].options.tf.vpc_id,
                    'name': tracked_resources[index].options.tf.name
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::Subnet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.Subnet.SubnetId,
                'GetAtt': {
                    'AvailabilityZone': jsonResponseBody.Subnet.AvailabilityZone,
                    'Ipv6CidrBlocks': jsonResponseBody.Subnet.ipv6CidrBlockAssociationSet,
                    //'NetworkAclAssociationId': jsonResponseBody.Subnet.,
                    'VpcId': jsonResponseBody.Subnet.VpcId
                },
                'Terraform': {
                    'id': jsonResponseBody.Subnet.SubnetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::VPC") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.Vpc.VpcId,
                'GetAtt': {
                    'CidrBlock': jsonResponseBody.Vpc.CidrBlock
                    // TODO: More
                },
                'Terraform': {
                    'id': jsonResponseBody.Vpc.VpcId,
                    'cidr_block': jsonResponseBody.Vpc.CidrBlock
                }
            };
        } else if (tracked_resources[index].type == "AWS::EC2::VPCCidrBlock") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::EC2::VPCDHCPOptionsAssociation") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::EC2::VPNGateway") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.VpnGateway.VpnGatewayId,
                'Terraform': {
                    'id': jsonResponseBody.VpnGateway.VpnGatewayId
                }
            };
        } else if (tracked_resources[index].type == "AWS::EFS::FileSystem") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.fileSystemId,
                'Terraform': {
                    'id': jsonResponseBody.fileSystemId
                }
            };
        } else if (tracked_resources[index].type == "AWS::EFS::MountTarget") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.mountTargetId,
                'Terraform': {
                    'id': jsonResponseBody.mountTargetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::ElastiCache::CacheCluster") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.actionResponses[0].data.replicationGroupId,
                'GetAtt': {
                    //'ConfigurationEndpoint.Address': jsonResponseBody.actionResponses[0].data.,
                    //'ConfigurationEndpoint.Port': jsonResponseBody.actionResponses[0].data.,
                    //'RedisEndpoint.Address': jsonResponseBody.actionResponses[0].data.,
                    //'RedisEndpoint.Port': jsonResponseBody.actionResponses[0].data.
                },
                'Terraform': {
                    'id': jsonResponseBody.actionResponses[0].data.replicationGroupId
                }
            };
        } else if (tracked_resources[index].type == "AWS::ElastiCache::ParameterGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.boto3.CacheParameterGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.boto3.CacheParameterGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::ElastiCache::SubnetGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.boto3.CacheSubnetGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.boto3.CacheSubnetGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::ElasticLoadBalancing::LoadBalancer") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.LoadBalancerName,
                'GetAtt': {
                    //'CanonicalHostedZoneName': jsonResponseBody.securityGroupId,
                    //'CanonicalHostedZoneNameID': jsonResponseBody.securityGroupId,
                    'DNSName': jsonResponseBody.dnsName
                    //'SourceSecurityGroup.GroupName': jsonResponseBody.securityGroupId,
                    //'SourceSecurityGroup.OwnerAlias': jsonResponseBody.securityGroupId
                },
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.LoadBalancerName,
                    'dns_name': jsonResponseBody.dnsName
                }
            };
        } else if (tracked_resources[index].type == "AWS::ElasticLoadBalancingV2::Listener") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.listeners[0].listenerArn,
                'Terraform': {
                    'arn': jsonResponseBody.listeners[0].listenerArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::ElasticLoadBalancingV2::ListenerRule") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.rules[0].ruleArn,
                'Terraform': {
                    'arn': jsonResponseBody.rules[0].ruleArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::ElasticLoadBalancingV2::LoadBalancer") {
            var lb_name_parts = jsonResponseBody.loadBalancers[0].loadBalancerArn.split("/").shift();
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.loadBalancers[0].loadBalancerArn,
                'GetAtt': {
                    'CanonicalHostedZoneID': jsonResponseBody.loadBalancers[0].hostedZoneId,
                    'DNSName': jsonResponseBody.loadBalancers[0].dnsName,
                    'LoadBalancerFullName': lb_name_parts.join("/"),
                    'LoadBalancerName': jsonResponseBody.loadBalancers[0].loadBalancerName,
                    'SecurityGroups': tracked_resources[index].options.cfn.SecurityGroups
                },
                'Terraform': {
                    'arn': jsonResponseBody.loadBalancers[0].loadBalancerArn,
                    'zone_id': jsonResponseBody.loadBalancers[0].hostedZoneId,
                    'dns_name': jsonResponseBody.loadBalancers[0].dnsName
                }
            };
        } else if (tracked_resources[index].type == "AWS::ElasticLoadBalancingV2::TargetGroup") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.targetGroups[0].arn,
                'GetAtt': {
                    'LoadBalancerArns': jsonResponseBody.targetGroups[0].loadBalancerArn,
                    'TargetGroupFullName': jsonResponseBody.targetGroups[0].loadBalancerArn.split(":").pop(),
                    'TargetGroupName': jsonResponseBody.targetGroups[0].name
                },
                'Terraform': {
                    'arn': jsonResponseBody.targetGroups[0].arn,
                    'name': jsonResponseBody.targetGroups[0].name
                }
            };
        } else if (tracked_resources[index].type == "AWS::Elasticsearch::Domain") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.DomainStatus.DomainId,
                'GetAtt': {
                    'DomainArn': jsonResponseBody.DomainStatus.ARN,
                    'DomainEndpoint': jsonResponseBody.DomainStatus.Endpoint
                },
                'Terraform': {
                    'id': jsonResponseBody.DomainStatus.DomainId,
                    'arn': jsonResponseBody.DomainStatus.ARN,
                    'endpoint': jsonResponseBody.DomainStatus.Endpoint
                }
            };
        } else if (tracked_resources[index].type == "AWS::Events::Rule") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::GameLift::Alias") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::GameLift::Build") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::GameLift::Fleet") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::Glue::Classifier") {
            var ref = null;
            if (tracked_resources[index].options.cfn.GrokClassifier) {
                ref = tracked_resources[index].options.cfn.GrokClassifier.Name;
            }
            if (tracked_resources[index].options.cfn.JsonClassifier) {
                ref = tracked_resources[index].options.cfn.JsonClassifier.Name;
            }
            if (tracked_resources[index].options.cfn.XMLClassifier) {
                ref = tracked_resources[index].options.cfn.XMLClassifier.Name;
            }

            tracked_resources[index].returnValues = {
                'Ref': ref,
                'Terraform': {
                    'id': ref
                }
            };
        } else if (tracked_resources[index].type == "AWS::Glue::Connection") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.ConnectionInput
            };
        } else if (tracked_resources[index].type == "AWS::Glue::Table") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.TableInput
            };
        } else if (tracked_resources[index].type == "AWS::GuardDuty::Detector") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.detectorId,
                'Terraform': {
                    'id': jsonResponseBody.detectorId
                }
            };
        } else if (tracked_resources[index].type == "AWS::GuardDuty::IPSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.ipSetId,
                'Terraform': {
                    'id': jsonResponseBody.ipSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::GuardDuty::Member") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.MemberId,
                'Terraform': {
                    'id': tracked_resources[index].options.cfn.MemberId
                }
            };
        } else if (tracked_resources[index].type == "AWS::IAM::User") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.name,
                'GetAtt': {
                    //'Arn': jsonResponseBody.
                },
                'Terraform': {
                    'id': jsonResponseBody.name
                }
            };
        } else if (tracked_resources[index].type == "AWS::IAM::UserToGroupAddition") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::Inspector::AssessmentTarget") {
            tracked_resources[index].returnValues = {
                'Ref': null,
                'GetAtt': {
                    'Arn': jsonResponseBody.assessmentTargetArn
                },
                'Terraform': {
                    'arn': jsonResponseBody.assessmentTargetArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Inspector::AssessmentTemplate") {
            tracked_resources[index].returnValues = {
                'Ref': null,
                'GetAtt': {
                    'Arn': jsonResponseBody.assessmentTemplateArn
                },
                'Terraform': {
                    'arn': jsonResponseBody.assessmentTemplateArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Inspector::ResourceGroup") {
            tracked_resources[index].returnValues = {
                'Ref': null,
                'GetAtt': {
                    'Arn': jsonResponseBody.resourceGroupArn
                },
                'Terraform': {
                    'arn': jsonResponseBody.resourceGroupArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Kinesis::Stream") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::KinesisFirehose::DeliveryStream") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::Lambda::Alias") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.arn,
                'Terraform': {
                    'arn': jsonResponseBody.arn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Lambda::Function") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.FunctionName,
                'GetAtt': {
                    'Arn': jsonResponseBody.FunctionArn
                },
                'Terraform': {
                    'name': jsonResponseBody.FunctionName,
                    'arn': jsonResponseBody.arn
                }
            };
        } else if (tracked_resources[index].type == "AWS::Lambda::Version") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.functionArn,
                'GetAtt': {
                    'Version': jsonResponseBody.version
                },
                'Terraform': {
                    'arn': jsonResponseBody.functionArn,
                    'version': jsonResponseBody.version
                }
            };
        } else if (tracked_resources[index].type == "AWS::Logs::LogGroup") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::Logs::LogStream") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::Logs::MetricFilter") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::Logs::SubscriptionFilter") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::OpsWorks::App") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.AppId,
                'Terraform': {
                    'id': jsonResponseBody.AppId
                }
            };
        } else if (tracked_resources[index].type == "AWS::OpsWorks::ElasticLoadBalancerAttachment") {
            tracked_resources[index].returnValues = null
        } else if (tracked_resources[index].type == "AWS::OpsWorks::Instance") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.InstanceId,
                'Terraform': {
                    'id': jsonResponseBody.InstanceId
                }
            };
        } else if (tracked_resources[index].type == "AWS::OpsWorks::Layer") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.LayerId,
                'Terraform': {
                    'id': jsonResponseBody.LayerId
                }
            };
        } else if (tracked_resources[index].type == "AWS::OpsWorks::Stack") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.StackId,
                'Terraform': {
                    'id': jsonResponseBody.StackId
                }
            };
        } else if (tracked_resources[index].type == "AWS::OpsWorks::UserProfile") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.IamUserArn,
                'GetAtt': {
                    //'SshUsername': jsonResponseBody.
                },
                'Terraform': {
                    'id': jsonResponseBody.IamUserArn
                }
            };
        } else if (tracked_resources[index].type == "AWS::OpsWorks::Volume") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.VolumeId,
                'Terraform': {
                    'id': jsonResponseBody.VolumeId
                }
            };
        } else if (tracked_resources[index].type == "AWS::RDS::DBClusterParameterGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.boto3.DBClusterParameterGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.boto3.DBClusterParameterGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::RDS::DBInstance") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.actionResponses[0].data.DBInstanceIdentifier,
                'GetAtt': {
                    //'Endpoint.Address': jsonResponseBody.,
                    //'Endpoint.Port': jsonResponseBody.
                },
                'Terraform': {
                    'id': jsonResponseBody.actionResponses[0].data.DBInstanceIdentifier
                }
            };
        } else if (tracked_resources[index].type == "AWS::RDS::DBParameterGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.boto3.DBParameterGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.boto3.DBParameterGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::RDS::DBSubnetGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.DBSubnetGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.DBSubnetGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::RDS::EventSubscription") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.boto3.SubscriptionName,
                'Terraform': {
                    'name': tracked_resources[index].options.boto3.SubscriptionName
                }
            };
        } else if (tracked_resources[index].type == "AWS::RDS::OptionGroup") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.actionResponses[0].data.optionGroupName,
                'Terraform': {
                    'name': jsonResponseBody.actionResponses[0].data.optionGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::Redshift::Cluster") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.ClusterIdentifier,
                'GetAtt': {
                    //'Endpoint.Address': jsonResponseBody.
                    //'Endpoint.Port': jsonResponseBody.
                },
                'Terraform': {
                    'id': tracked_resources[index].options.cfn.ClusterIdentifier
                }
            };
        } else if (tracked_resources[index].type == "AWS::Redshift::ClusterParameterGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.boto3.ParameterGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.boto3.ParameterGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::Redshift::ClusterSubnetGroup") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.boto3.ClusterSubnetGroupName,
                'Terraform': {
                    'name': tracked_resources[index].options.boto3.ClusterSubnetGroupName
                }
            };
        } else if (tracked_resources[index].type == "AWS::Route53::HostedZone") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::S3::Bucket") {
            tracked_resources[index].returnValues = {
                'Ref': tracked_resources[index].options.cfn.BucketName,
                'GetAtt': {
                    'Arn': "arn:aws:s3:::" + tracked_resources[index].options.cfn.BucketName
                    //'DomainName': jsonResponseBody.,
                    //'DualStackDomainName': jsonResponseBody.,
                    //'WebsiteURL': jsonResponseBody.
                },
                'Terraform': {
                    'id': tracked_resources[index].options.cfn.BucketName,
                    'arn': "arn:aws:s3:::" + tracked_resources[index].options.cfn.BucketName
                }
            };
        } else if (tracked_resources[index].type == "AWS::SNS::Subscription") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::SNS::Topic") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.CreateTopicResponse.topicArn,
                'GetAtt': {
                    'TopicName': tracked_resources[index].options.cfn.TopicName
                },
                'Terraform': {
                    'name': tracked_resources[index].options.cfn.TopicName
                }
            };
        } else if (tracked_resources[index].type == "AWS::SNS::TopicPolicy") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::SQS::Queue") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SQS::QueuePolicy") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SSM::Association") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SSM::Document") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SSM::MaintenanceWindow") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SSM::MaintenanceWindowTarget") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SSM::MaintenanceWindowTask") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SSM::Parameter") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SSM::PatchBaseline") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::SSM::ResourceDataSync") {
            ; // TODO
        } else if (tracked_resources[index].type == "AWS::ServiceCatalog::CloudFormationProduct") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.provisioningArtifactDetail.id,
                'GetAtt': {
                    'ProductName': jsonResponseBody.provisioningArtifactDetail.name,
                    'ProvisioningArtifactIds': [jsonResponseBody.provisioningArtifactDetail.id],
                    'ProvisioningArtifactNames': [jsonResponseBody.provisioningArtifactDetail.name]
                }
            };
        } else if (tracked_resources[index].type == "AWS::ServiceCatalog::Portfolio") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.portfolioDetail.id,
                'GetAtt': {
                    'PortfolioName': jsonResponseBody.portfolioDetail.displayName
                },
                'Terraform': {
                    'id': jsonResponseBody.portfolioDetail.id
                }
            };
        } else if (tracked_resources[index].type == "AWS::ServiceCatalog::PortfolioPrincipalAssociation") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::ServiceCatalog::PortfolioProductAssociation") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::ServiceCatalog::PortfolioShare") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::ServiceCatalog::TagOption") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.tagOptionDetail.id,
                'Terraform': {
                    'id': jsonResponseBody.tagOptionDetail.id,
                }
            };
        } else if (tracked_resources[index].type == "AWS::ServiceCatalog::TagOptionAssociation") {
            tracked_resources[index].returnValues = null;
        } else if (tracked_resources[index].type == "AWS::WAF::ByteMatchSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.ByteMatchSet.ByteMatchSetId,
                'Terraform': {
                    'id': jsonResponseBody.ByteMatchSet.ByteMatchSetId,
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAF::IPSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.IPSet.IPSetId,
                'Terraform': {
                    'id': jsonResponseBody.IPSet.IPSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAF::Rule") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.Rule.RuleId,
                'Terraform': {
                    'id': jsonResponseBody.Rule.RuleId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAF::SizeConstraintSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.SizeConstraintSet.SizeConstraintSetId,
                'Terraform': {
                    'id': jsonResponseBody.SizeConstraintSet.SizeConstraintSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAF::SqlInjectionMatchSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.SqlInjectionMatchSet.SqlInjectionMatchSetId,
                'Terraform': {
                    'id': jsonResponseBody.SqlInjectionMatchSet.SqlInjectionMatchSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAF::WebACL") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.WebACL.WebACLId,
                'Terraform': {
                    'id': jsonResponseBody.WebACL.WebACLId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAF::XssMatchSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.XssMatchSet.XssMatchSetId,
                'Terraform': {
                    'id': jsonResponseBody.XssMatchSet.XssMatchSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAFRegional::ByteMatchSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.ByteMatchSet.ByteMatchSetId,
                'Terraform': {
                    'id': jsonResponseBody.ByteMatchSet.ByteMatchSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAFRegional::IPSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.IPSet.IPSetId,
                'Terraform': {
                    'id': jsonResponseBody.IPSet.IPSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAFRegional::Rule") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.Rule.RuleId,
                'Terraform': {
                    'id': jsonResponseBody.Rule.RuleId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAFRegional::SizeConstraintSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.SizeConstraintSet.SizeConstraintSetId,
                'Terraform': {
                    'id': jsonResponseBody.SizeConstraintSet.SizeConstraintSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAFRegional::SqlInjectionMatchSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.SqlInjectionMatchSet.SqlInjectionMatchSetId,
                'Terraform': {
                    'id': jsonResponseBody.SqlInjectionMatchSet.SqlInjectionMatchSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAFRegional::WebACL") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.WebACL.WebACLId,
                'Terraform': {
                    'id': jsonResponseBody.WebACL.WebACLId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WAFRegional::XssMatchSet") {
            tracked_resources[index].returnValues = {
                'Ref': jsonResponseBody.XssMatchSet.XssMatchSetId,
                'Terraform': {
                    'id': jsonResponseBody.XssMatchSet.XssMatchSetId
                }
            };
        } else if (tracked_resources[index].type == "AWS::WorkSpaces::Workspace") {
            ; // TODO
        }
    } catch(err) {;}
}

/******/

var outputs = [];
var tracked_resources = [];
var blocking = false;

function analyseRequest(details) {
    var reqParams = {
        'boto3': {},
        'go': {},
        'cfn': {},
        'cli': {},
        'tf': {},
        'iam': {}
    };
    var requestBody = "";
    var jsonRequestBody = {};
    var region = 'us-east-1';
    var gwtRequest = {};

    // Firefox
    if (intercept && navigator.userAgent.search("Firefox") > -1) {
        let filter = browser.webRequest.filterResponseData(details.requestId);
        let decoder = new TextDecoder("utf-8");
        let encoder = new TextEncoder();
        var responseBody = "";

        filter.ondata = event => {
            filter.write(event.data);
           
            responseBody += decoder.decode(event.data, {stream: true});
        }

        filter.onstop = event => {
            filter.disconnect();

            console.log(responseBody);

            for (var i=tracked_resources.length-1; i>=0; i--) {
                if (details.requestId == tracked_resources[i].requestDetails.requestId) {
                    tracked_resources[i]["response"] = {
                        'timestamp': null,
                        'properties': null,
                        'body': responseBody
                    };
                    setOutputsForTrackedResource(i);
                }
            }

            for (var i=0; i<outputs.length; i++) { // TODO
                ;
            }
        }
    }

    if (details.url.indexOf("amazonaws-us-gov.com") !== -1) {
        region = "us-gov-west-1";
    }
    var region_check = /.+\/\/([a-zA-Z-]+\-[0-9]+)\.(?:console|lightsail)\.(?:aws\.amazon|amazonaws-us-gov)\.com/g.exec(details.url);
    if (region_check && region_check[1]) {
        region = region_check[1];
    } else {
        region_check = /.+\/\/[a-z0-9-]+.([a-zA-Z-]+\-[0-9]+)\.amazonaws\.com/g.exec(details.url);
        if (region_check && region_check[1]) {
            region = region_check[1];
        }
    }

    try {
        try {
            requestBody = decodeURIComponent(String.fromCharCode.apply(null, new Uint8Array(details.requestBody.raw[0].bytes)).replace(/\%/g,"%25"));
            requestBody = requestBody.replace(/\"X-CSRF-TOKEN\"\:\"\[\{[a-zA-Z0-9-_",=+:/]+\}\]\"\,/g,""); // double-quote bug, remove CSRF token
        } catch(e) {
            try {
                requestBody = JSON.stringify(details.requestBody.formData);
            } catch(e) {;}
        }
    
        try {
            jsonRequestBody = JSON.parse(requestBody);
        } catch(e) {
            gwtRequest = interpretGwtWireRequest(requestBody);
        }

        // check for string objects
        for (var prop in jsonRequestBody) {
            if (typeof jsonRequestBody[prop] == "string") {
                try {
                    var parsed = JSON.parse(jsonRequestBody[prop]);
                    jsonRequestBody[prop] = parsed;
                } catch(e) {;}
            }
        }
    } catch(e) {;}
    
    
    // manual:ec2:ec2.DescribeInstances
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getMergedInstanceList\?/g)) {
        if ('filters' in jsonRequestBody) {
            reqParams.cli['--filters'] = jsonRequestBody.filters;
            reqParams.boto3['Filter'] = [];
            jsonRequestBody['filters'].forEach(filter => {
                reqParams.boto3['Filter'].push({
                    'Name': filter['name'],
                    'Values': filter['values']
                });
            });
        }
        reqParams.boto3['MaxResults'] = jsonRequestBody.count;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeInstances',
                'boto3': 'describe_instances',
                'cli': 'describe-instances'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeImages
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getPrivateImageList\?/g)) {
        if (jsonRequestBody['publicAndPrivate'] != true) {
            reqParams.boto3['Owner'] = ['self'];
            reqParams.cli['--owners'] = "self";
        }

        if ('imageType' in jsonRequestBody) {
            if (jsonRequestBody['filters'] === undefined)
                jsonRequestBody['filters'] = [];
            jsonRequestBody.filters['imageType'] = jsonRequestBody.imageType;
        }
        
        if ('filters' in jsonRequestBody) {
            reqParams.cli['--filters'] = jsonRequestBody.filters;
            reqParams.boto3['Filter'] = [];
            jsonRequestBody['filters'].forEach(filter => {
                reqParams.boto3['Filter'].push({
                    'Name': filter['name'],
                    'Values': filter['values']
                });
            });
        }
        reqParams.boto3['MaxResults'] = jsonRequestBody.count;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeImages',
                'boto3': 'describe_images',
                'cli': 'describe-images'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeImages
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=searchAmis\?/g)) {
        reqParams.boto3['MaxResults'] = jsonRequestBody.count;
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeImages',
                'boto3': 'describe_images',
                'cli': 'describe-images'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getVpcs\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getSubnets\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeHosts
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getSdkResources_Hosts\?/g)) {
        if ('filters' in jsonRequestBody) {
            reqParams.cli['--filters'] = jsonRequestBody.filters;
            reqParams.boto3['Filter'] = [];
            jsonRequestBody['filters'].forEach(filter => {
                reqParams.boto3['Filter'].push({
                    'Name': filter['name'],
                    'Values': filter['values']
                });
            });
        }

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeHosts',
                'boto3': 'describe_hosts',
                'cli': 'describe-hosts'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:iam.ListInstanceProfiles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getInstanceProfileList\?/g)) {
        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListInstanceProfiles',
                'boto3': 'list_instance_profiles',
                'cli': 'list-instance-profiles'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeNetworkInterfaces
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getNetworkInterfaces\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeNetworkInterfaces',
                'boto3': 'describe_network_interfaces',
                'cli': 'describe-network-interfaces'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeAvailabilityZones
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getAvailabilityZones\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeAvailabilityZones',
                'boto3': 'describe_availability_zones',
                'cli': 'describe-availability-zones'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getSecurityGroups\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSecurityGroups',
                'boto3': 'describe_security_groups',
                'cli': 'describe-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeKeyPairs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getKeyPairList\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeKeyPairs',
                'boto3': 'describe_key_pairs',
                'cli': 'describe-key-pairs'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.CreateSecurityGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=createSecurityGroup\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['GroupDescription'] = jsonRequestBody.groupDescription;
        reqParams.boto3['GroupName'] = jsonRequestBody.groupName;
        reqParams.cli['--description'] = jsonRequestBody.groupDescription;
        reqParams.cli['--group-name'] = jsonRequestBody.groupName;
        if (jsonRequestBody.vpcId && jsonRequestBody.vpcId.length) {
            reqParams.boto3['VpcId'] = jsonRequestBody.vpcId;
            reqParams.cli['--vpc-id'] = jsonRequestBody.vpcId;
        }

        reqParams.cfn['GroupDescription'] = jsonRequestBody.groupDescription;
        reqParams.cfn['GroupName'] = jsonRequestBody.groupName;
        reqParams.cfn['VpcId'] = jsonRequestBody.vpcId;

        reqParams.tf['description'] = jsonRequestBody.groupDescription;
        reqParams.tf['name'] = jsonRequestBody.groupName;
        if (jsonRequestBody.vpcId && jsonRequestBody.vpcId.length) {
            reqParams.tf['vpc_id'] = jsonRequestBody.vpcId;
        }

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateSecurityGroup',
                'boto3': 'create_security_group',
                'cli': 'create-security-group'
            },
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::SecurityGroup',
            'terraformType': 'aws_security_group',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }

    // manual:ec2:ec2.AuthorizeSecurityGroupIngress
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=authorizeIngress\?/g)) {
        if ('groupId' in jsonRequestBody) {
            reqParams.boto3['GroupId'] = jsonRequestBody.groupId;
            reqParams.cli['--group-id'] = jsonRequestBody.groupId;
            reqParams.iam['Resource'] = [
                "arn:aws:ec2:*:*:security-group/" + jsonRequestBody.groupId
            ];
        }
        reqParams.boto3['IpPermissions'] = [];
        reqParams.cli['--ip-permissions'] = [];
        if (jsonRequestBody['ipPermissions']) {
            jsonRequestBody['ipPermissions'].forEach(ipPermission => {
                var ipRangeObjects = [];
                if (ipPermission['ipRangeObjects']) {
                    ipPermission['ipRangeObjects'].forEach(ipRangeObject => {
                        ipRangeObjects.push({
                            'Description': ipRangeObject['description'],
                            'CidrIp': ipRangeObject['cidrIp']
                        });
                    });
                }
                var ipv6RangeObjects = [];
                if (ipPermission['ipv6RangeObjects']) {
                    ipPermission['ipv6RangeObjects'].forEach(ipv6RangeObject => {
                        ipv6RangeObjects.push({
                            'Description': ipv6RangeObject['description'],
                            'CidrIpv6': ipv6RangeObject['CidrIpv6']
                        });
                    });
                }
                reqParams.boto3['IpPermissions'].push({
                    'IpProtocol': ipPermission['ipProtocol'],
                    'FromPort': ipPermission['fromPort'],
                    'ToPort': ipPermission['toPort'],
                    'IpRanges': ipRangeObjects,
                    'Ipv6Ranges': ipv6RangeObjects
                });
                reqParams.cli['--ip-permissions'].push({
                    'IpProtocol': ipPermission['ipProtocol'],
                    'FromPort': ipPermission['fromPort'],
                    'ToPort': ipPermission['toPort'],
                    'IpRanges': ipRangeObjects,
                    'Ipv6Ranges': ipv6RangeObjects
                });
            });
        }

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'AuthorizeSecurityGroupIngress',
                'boto3': 'authorize_security_group_ingress',
                'cli': 'authorize-security-group-ingress'
            },
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }

    // manual:ec2:ec2.RunInstances
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call\=com.amazonaws.ec2.AmazonEC2.RunInstances\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:ec2:*:*:instance/*",
            "arn:aws:ec2:*:*:volume/*",
            "arn:aws:ec2:*::image/" + jsonRequestBody.ImageId,
            "arn:aws:ec2:*:*:key-pair/" + jsonRequestBody.KeyName
        ];

        reqParams.boto3['ImageId'] = jsonRequestBody.ImageId;
        reqParams.boto3['MaxCount'] = jsonRequestBody.MaxCount;
        reqParams.boto3['MinCount'] = jsonRequestBody.MinCount;
        reqParams.boto3['KeyName'] = jsonRequestBody.KeyName;
        if (jsonRequestBody.SecurityGroupIds) {
            reqParams.boto3['SecurityGroupIds'] = jsonRequestBody.SecurityGroupIds;
            for (var i=0; i<jsonRequestBody.SecurityGroupIds.length; i++) {
                reqParams.iam['Resource'].push("arn:aws:ec2:*:*:security-group/" + jsonRequestBody.SecurityGroupIds[i]);
            }
        }
        reqParams.boto3['InstanceType'] = jsonRequestBody.InstanceType;
        reqParams.boto3['Placement'] = jsonRequestBody.Placement;
        reqParams.boto3['Monitoring'] = jsonRequestBody.Monitoring;
        reqParams.boto3['DisableApiTermination'] = jsonRequestBody.DisableApiTermination;
        reqParams.boto3['InstanceInitiatedShutdownBehavior'] = jsonRequestBody.InstanceInitiatedShutdownBehavior;
        reqParams.boto3['CreditSpecification'] = jsonRequestBody.CreditSpecification;
        reqParams.boto3['TagSpecification'] = jsonRequestBody.TagSpecifications;
        reqParams.boto3['EbsOptimized'] = jsonRequestBody.EbsOptimized;
        reqParams.boto3['CapacityReservationSpecification'] = jsonRequestBody.CapacityReservationSpecification;
        reqParams.boto3['ElasticInferenceAccelerators'] = jsonRequestBody.ElasticInferenceAccelerator;
        if (jsonRequestBody.UserData) {
            reqParams.boto3['UserData'] = atob(jsonRequestBody.UserData);
        }
        reqParams.boto3['NetworkInterfaces'] = jsonRequestBody.NetworkInterface;
        if (jsonRequestBody.IamInstanceProfile) {
            reqParams.boto3['IamInstanceProfile'] = {
                'Arn': jsonRequestBody.IamInstanceProfile.Arn
            };
        }
        reqParams.cfn['ImageId'] = jsonRequestBody.ImageId;
        reqParams.cfn['KeyName'] = jsonRequestBody.KeyName;
        reqParams.cfn['SecurityGroupIds'] = jsonRequestBody.SecurityGroupIds;
        reqParams.cfn['InstanceType'] = jsonRequestBody.InstanceType;
        if (jsonRequestBody.Placement && jsonRequestBody.Placement.Tenancy) {
            reqParams.cfn['Tenancy'] = jsonRequestBody.Placement.Tenancy;
        }
        reqParams.cfn['Monitoring'] = jsonRequestBody.Monitoring.Enabled;
        reqParams.cfn['DisableApiTermination'] = jsonRequestBody.DisableApiTermination;
        reqParams.cfn['InstanceInitiatedShutdownBehavior'] = jsonRequestBody.InstanceInitiatedShutdownBehavior;
        if (jsonRequestBody.CreditSpecification) {
            reqParams.cfn['CreditSpecification'] = {
                'CPUCredits': jsonRequestBody.CreditSpecification.CpuCredits
            }
        }
        reqParams.cfn['EbsOptimized'] = jsonRequestBody.EbsOptimized;
        reqParams.cfn['ElasticInferenceAccelerators'] = jsonRequestBody.ElasticInferenceAccelerator;
        reqParams.cfn['UserData'] = jsonRequestBody.UserData;
        if (jsonRequestBody.IamInstanceProfile) {
            reqParams.cfn['IamInstanceProfile'] = jsonRequestBody.IamInstanceProfile.Arn;
        }
        if (jsonRequestBody.Placement) {
            if (jsonRequestBody.Placement.GroupName) {
                reqParams.iam['Resource'].push("arn:aws:ec2:*:*:placement-group/" + jsonRequestBody.Placement.GroupName);

                reqParams.cfn['PlacementGroupName'] = jsonRequestBody.Placement.GroupName;
            }
            reqParams.cfn['Tenancy'] = jsonRequestBody.Placement.Tenancy;
        }

        reqParams.cli['--image-id'] = jsonRequestBody.ImageId;
        if (jsonRequestBody.MaxCount == jsonRequestBody.MinCount) {
            reqParams.cli['--count'] = jsonRequestBody.MinCount;
        } else {
            reqParams.cli['--count'] = jsonRequestBody.MinCount + ":" + jsonRequestBody.MaxCount;
        }
        reqParams.cli['--key-name'] = jsonRequestBody.KeyName;
        reqParams.cli['--security-group-ids'] = jsonRequestBody.SecurityGroupIds;
        reqParams.cli['--instance-type'] = jsonRequestBody.InstanceType;
        reqParams.cli['--placement'] = jsonRequestBody.Placement;
        reqParams.cli['--monitoring'] = jsonRequestBody.Monitoring;
        if (jsonRequestBody.DisableApiTermination === true)
            reqParams.cli['--disable-api-termination'] = null;
        else if (jsonRequestBody.DisableApiTermination === false)
            reqParams.cli['--enable-api-termination'] = null;
        reqParams.cli['--instance-initiated-shutdown-behavior'] = jsonRequestBody.InstanceInitiatedShutdownBehavior;
        reqParams.cli['--credit-specification'] = jsonRequestBody.CreditSpecification;
        reqParams.cli['--tag-specifications'] = jsonRequestBody.TagSpecifications;
        reqParams.cli['--ebs-optimized'] = jsonRequestBody.EbsOptimized;
        reqParams.cli['--elastic-inference-accelerators'] = jsonRequestBody.ElasticInferenceAccelerator;
        if (jsonRequestBody.UserData) {
            reqParams.cli['--user-data'] = atob(jsonRequestBody.UserData);
        }
        reqParams.cli['--network-interfaces'] = jsonRequestBody.NetworkInterface;
        if (jsonRequestBody.IamInstanceProfile) {
            reqParams.cli['--iam-instance-profile'] = {
                'Arn': jsonRequestBody.IamInstanceProfile.Arn
            };
        }

        reqParams.tf['ami'] = jsonRequestBody.ImageId;
        reqParams.tf['key_name'] = jsonRequestBody.KeyName;
        reqParams.tf['vpc_security_group_ids'] = jsonRequestBody.SecurityGroupIds;
        reqParams.tf['instance_type'] = jsonRequestBody.InstanceType;
        if (jsonRequestBody.Placement && jsonRequestBody.Placement.Tenancy) {
            reqParams.tf['tenancy'] = jsonRequestBody.Placement.Tenancy;
        }
        if (jsonRequestBody.Monitoring) {
            reqParams.tf['monitoring'] = jsonRequestBody.Monitoring.Enabled;
        }
        reqParams.tf['disable_api_termination'] = jsonRequestBody.DisableApiTermination;
        reqParams.tf['instance_initiated_shutdown_behavior'] = jsonRequestBody.InstanceInitiatedShutdownBehavior;
        if (jsonRequestBody.CreditSpecification) {
            reqParams.tf['credit_specification'] = {
                'cpu_credits': jsonRequestBody.CreditSpecification.CpuCredits
            }
        }

        if (jsonRequestBody.TagSpecifications) {
            reqParams.tf['tags'] = {};
            for (var i=0; i<jsonRequestBody.TagSpecifications.length; i++) {
                if (jsonRequestBody.TagSpecifications[i].ResourceType == "instance") {
                    reqParams.cfn['Tags'] = [];
                    for (var j=0; j<jsonRequestBody.TagSpecifications[i].Tag.length; j++) {
                        reqParams.tf['tags'][jsonRequestBody.TagSpecifications[i].Tag[j].Key] = jsonRequestBody.TagSpecifications[i].Tag[j].Value;
                        reqParams.cfn['Tags'].push({
                            'Key': jsonRequestBody.TagSpecifications[i].Tag[j].Key,
                            'Value': jsonRequestBody.TagSpecifications[i].Tag[j].Value
                        });
                    }
                }
            }
        }
        reqParams.tf['ebs_optimized'] = jsonRequestBody.EbsOptimized;
        if (jsonRequestBody.IamInstanceProfile) {
            reqParams.tf['iam_instance_profile'] = jsonRequestBody.IamInstanceProfile.Arn;
        }

        reqParams.boto3['BlockDeviceMappings'] = [];
        reqParams.cli['--block-device-mappings'] = [];
        reqParams.cfn['BlockDeviceMappings'] = [];

        var used_device_names = [];
        var instance_type_instance_store_count = { // i cried a little
            'm5d.large': 1,
            'm5d.xlarge': 1,
            'm5d.2xlarge': 1,
            'm5d.4xlarge': 2,
            'm5d.12xlarge': 2,
            'm5d.24xlarge': 4,
            'c5d.large': 1,
            'c5d.xlarge': 1,
            'c5d.2xlarge': 1,
            'c5d.4xlarge': 1,
            'c5d.9xlarge': 1,
            'c5d.18xlarge': 2,
            'p3dn.24xlarge': 2,
            'x1.16xlarge': 1,
            'x1.32xlarge': 2,
            'x1e.xlarge': 1,
            'x1e.2xlarge': 1,
            'x1e.4xlarge': 1,
            'x1e.8xlarge': 1,
            'x1e.16xlarge': 1,
            'x1e.32xlarge': 2,
            'r5d.large': 1,
            'r5d.xlarge': 1,
            'r5d.2xlarge': 1,
            'r5d.4xlarge': 2,
            'r5d.12xlarge': 2,
            'r5d.24xlarge': 4,
            'z1d.large': 1,
            'z1d.xlarge': 1,
            'z1d.2xlarge': 1,
            'z1d.3xlarge': 1,
            'z1d.6xlarge': 1,
            'z1d.12xlarge': 2,
            'i3.large': 1,
            'i3.xlarge': 1,
            'i3.2xlarge': 1,
            'i3.4xlarge': 2,
            'i3.8xlarge': 4,
            'i3.16xlarge': 8,
            'i3.metal': 8,
            'h1.2xlarge': 1,
            'h1.4xlarge': 2,
            'h1.8xlarge': 4,
            'h1.16xlarge': 8,
            'd2.xlarge': 3,
            'd2.2xlarge': 6,
            'd2.4xlarge': 12,
            'd2.8xlarge': 24,
            'f1.4xlarge': 1
        };

        for (var i=0; i<jsonRequestBody.BlockDeviceMappings.length; i++) {
            if (
                !jsonRequestBody.BlockDeviceMappings[i].DeviceName.startsWith("xvdc") ||
                jsonRequestBody.BlockDeviceMappings[i].DeviceName.length != 5 ||
                jsonRequestBody.BlockDeviceMappings[i].VirtualName ||
                jsonRequestBody.BlockDeviceMappings[i].Ebs
            ) {
                reqParams.boto3['BlockDeviceMappings'].push({
                    'DeviceName': jsonRequestBody.BlockDeviceMappings[i].DeviceName,
                    'Ebs': jsonRequestBody.BlockDeviceMappings[i].Ebs,
                    'VirtualName': jsonRequestBody.BlockDeviceMappings[i].VirtualName
                });
                reqParams.cli['--block-device-mappings'].push({
                    'DeviceName': jsonRequestBody.BlockDeviceMappings[i].DeviceName,
                    'Ebs': jsonRequestBody.BlockDeviceMappings[i].Ebs,
                    'VirtualName': jsonRequestBody.BlockDeviceMappings[i].VirtualName
                });
                reqParams.cfn['BlockDeviceMappings'].push({
                    'DeviceName': jsonRequestBody.BlockDeviceMappings[i].DeviceName,
                    'Ebs': jsonRequestBody.BlockDeviceMappings[i].Ebs,
                    'VirtualName': jsonRequestBody.BlockDeviceMappings[i].VirtualName
                });
                used_device_names.push(jsonRequestBody.BlockDeviceMappings[i].DeviceName);
            }

            if (jsonRequestBody.BlockDeviceMappings[i].DeviceName == "/dev/sda1" || jsonRequestBody.BlockDeviceMappings[i].DeviceName == "/dev/xvda") {
                if (jsonRequestBody.BlockDeviceMappings[i].Ebs) {
                    reqParams.tf['root_block_device'] = {
                        'volume_type': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeType,
                        'volume_size': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeSize
                    };
                }
            } else if (jsonRequestBody.BlockDeviceMappings[i].Ebs) {
                if (!reqParams.tf['ebs_block_device']) {
                    reqParams.tf['ebs_block_device'] = [];
                }
                reqParams.tf['ebs_block_device'].push({
                    'device_name': jsonRequestBody.BlockDeviceMappings[i].DeviceName,
                    'volume_type': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeType,
                    'volume_size': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeSize,
                    'delete_on_termination': jsonRequestBody.BlockDeviceMappings[i].Ebs.DeleteOnTermination,
                    'iops': jsonRequestBody.BlockDeviceMappings[i].Ebs.Iops,
                    'snapshot_id': jsonRequestBody.BlockDeviceMappings[i].Ebs.SnapshotId
                });

                if (jsonRequestBody.BlockDeviceMappings[i].Ebs.SnapshotId) {
                    reqParams.iam['Resource'].push("arn:aws:ec2:*::snapshot/" + jsonRequestBody.BlockDeviceMappings[i].Ebs.SnapshotId);
                }
            }
        }
        instance_store_count = 0;
        if (instance_type_instance_store_count[jsonRequestBody.InstanceType]) {
            instance_store_count = instance_type_instance_store_count[jsonRequestBody.InstanceType];
        }
        for (var i=0; i<instance_store_count; i++) { // unused instance store volumes
            var device_name = "xvdc" + String.fromCharCode(97 + i);
            if (!used_device_names.includes(device_name)) {
                reqParams.boto3['BlockDeviceMappings'].push({
                    'DeviceName': device_name,
                    'NoDevice': ''
                });
                reqParams.cli['--block-device-mappings'].push({
                    'DeviceName': device_name,
                    'NoDevice': ''
                });
                reqParams.cfn['BlockDeviceMappings'].push({
                    'DeviceName': device_name,
                    'NoDevice': ''
                });
            }
        }

        if (jsonRequestBody.UserData) {
            reqParams.tf['user_data'] = atob(jsonRequestBody.UserData);
        }

        if (jsonRequestBody.NetworkInterface) {
            reqParams.tf['network_interface'] = [];
            reqParams.cfn['NetworkInterfaces'] = [];
            for (var i=0; i<jsonRequestBody.NetworkInterface.length; i++) {
                if (jsonRequestBody.NetworkInterface[i].NetworkInterfaceId) {
                    reqParams.iam['Resource'].push("arn:aws:ec2:*:*:network-interface/" + jsonRequestBody.NetworkInterface[i].NetworkInterfaceId);
                } else {
                    reqParams.iam['Resource'].push("arn:aws:ec2:*:*:network-interface/*");
                }

                if (!jsonRequestBody.NetworkInterface[i].NetworkInterfaceId && jsonRequestBody.NetworkInterface[i].SubnetId) {
                    reqParams.iam['Resource'].push("arn:aws:ec2:*:*:subnet/" + jsonRequestBody.NetworkInterface[i].SubnetId);

                    tracked_resources.push({
                        'logicalId': getResourceName('ec2', details.requestId + "_NetworkInterface" + i),
                        'region': region,
                        'service': 'ec2',
                        'terraformType': 'aws_network_interface',
                        'options': {
                            'tf': {
                                'subnet_id': jsonRequestBody.NetworkInterface[i].SubnetId,
                                'description': jsonRequestBody.NetworkInterface[i].Description,
                                'security_groups': jsonRequestBody.NetworkInterface[i].Groups,
                                'private_ips': jsonRequestBody.NetworkInterface[i].PrivateIpAddresses
                            }
                        },
                        'requestDetails': details,
                        'was_blocked': blocking
                    });

                    for (var j=0; j<jsonRequestBody.NetworkInterface[i].Groups.length; j++) {
                        reqParams.iam['Resource'].push("arn:aws:ec2:*:*:security-group/" + jsonRequestBody.NetworkInterface[i].Groups[j]);
                    }

                    reqParams.tf['network_interface'].push({
                        'device_index': jsonRequestBody.NetworkInterface[i].DeviceIndex,
                        'network_interface_id': "${aws_network_interface." + getResourceName('ec2', details.requestId + "_NetworkInterface" + i) + ".id}",
                        'delete_on_termination': jsonRequestBody.NetworkInterface[i].DeleteOnTermination
                    });
                } else {
                    reqParams.tf['network_interface'].push({
                        'device_index': jsonRequestBody.NetworkInterface[i].DeviceIndex,
                        'network_interface_id': jsonRequestBody.NetworkInterface[i].NetworkInterfaceId,
                        'delete_on_termination': jsonRequestBody.NetworkInterface[i].DeleteOnTermination
                    });
                }
            
                cfn_network_interface = jsonRequestBody.NetworkInterface[i];
                cfn_network_interface['GroupSet'] = cfn_network_interface['Groups'];
                delete cfn_network_interface['Groups'];
                reqParams.cfn['NetworkInterfaces'].push(cfn_network_interface);
            }
        } else {
            reqParams.iam['Resource'].push("arn:aws:ec2:*:*:network-interface/*");
            reqParams.iam['Resource'].push("arn:aws:ec2:*:*:subnet/*");
        }

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'RunInstances',
                'boto3': 'run_instances',
                'cli': 'run-instances'
            },
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::Instance',
            'terraformType': 'aws_instance',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }

    // manual:ec2:ec2.TerminateInstances
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=terminateInstances\?/g)) {
        reqParams.iam['Resource'] = [];
        
        reqParams.boto3['InstanceIds'] = jsonRequestBody.instanceIds;
        reqParams.cli['--instance-ids'] = jsonRequestBody.instanceIds;

        for (var i=0; i<jsonRequestBody.instanceIds.length; i++) {
            reqParams.iam['Resource'].push("arn:aws:ec2:*:*:instance/" + jsonRequestBody.instanceIds[i]);
        }

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'TerminateInstances',
                'boto3': 'terminate_instances',
                'cli': 'terminate-instances'
            },
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }

    // manual:ec2:ec2.DescribeLaunchTemplates
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call\=com.amazonaws.ec2.AmazonEC2.DescribeLaunchTemplates\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeLaunchTemplates',
                'boto3': 'describe_launch_templates',
                'cli': 'describe-launch-templates'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ds.DescribeDirectories
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call\=com.amazonaws.directoryservice.+.DescribeDirectories\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ds',
            'method': {
                'api': 'DescribeDirectories',
                'boto3': 'describe_directories',
                'cli': 'describe-directories'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribePlacementGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call\=com.amazonaws.ec2.AmazonEC2.DescribePlacementGroups\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribePlacementGroups',
                'boto3': 'describe_placement_groups',
                'cli': 'describe-placement-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeSpotPriceHistory
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getCurrentSpotPrice\?/g)) {
        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSpotPriceHistory',
                'boto3': 'describe_spot_price_history',
                'cli': 'describe-spot-price-history'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeTags
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getTags\?/g)) {
        reqParams.boto3['Filter'] = [];
        reqParams.cli['--filter'] = [];

        if (jsonRequestBody['key']) {
            if (jsonRequestBody['key'].length > 0) {
                reqParams.boto3['Filter'].push({
                    'Name': 'key',
                    'Values': [jsonRequestBody['key']]
                });
                reqParams.cli['--filter'].push({
                    'Name': 'key',
                    'Values': [jsonRequestBody['key']]
                });
            }
        }
        if (jsonRequestBody['value']) {
            if (jsonRequestBody['value'].length > 0) {
                reqParams.boto3['Filter'].push({
                    'Name': 'value',
                    'Values': [jsonRequestBody['value']]
                });
                reqParams.cli['--filter'].push({
                    'Name': 'value',
                    'Values': [jsonRequestBody['value']]
                });
            }
        }
        if (reqParams.boto3['Filter'].length == 0) {
            delete reqParams.boto3['Filter'];
            delete reqParams.cli['--filter'];
        }

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeTags',
                'boto3': 'describe_tags',
                'cli': 'describe-tags'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:ec2:ec2.DescribeInstanceAttribute
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call\=getTerminationProtection\?/g)) {
        reqParams.boto3['InstanceId'] = jsonRequestBody.instanceId;
        reqParams.boto3['Attribute'] = "disableApiTermination";
        reqParams.cli['--instance-id'] = jsonRequestBody.instanceId;
        reqParams.cli['--attribute'] = "disableApiTermination";

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeInstanceAttribute',
                'boto3': 'describe_instance_attribute',
                'cli': 'describe-instance-attribute'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:s3:s3.CreateBucket
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "CreateBucket") {
        reqParams.iam['Resource'] = [
            "arn:aws:s3:::" + jsonRequestBody.path
        ];

        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        reqParams.cfn['BucketName'] = jsonRequestBody.path;

        reqParams.tf['bucket'] = jsonRequestBody.path;

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'CreateBucket',
                'boto3': 'create_bucket',
                'cli': 'create-bucket'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('s3', details.requestId),
            'region': region,
            'service': 's3',
            'type': 'AWS::S3::Bucket',
            'terraformType': 'aws_s3_bucket',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }
    
    // manual:s3:s3.PutBucketVersioning
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "PutBucketVersioning") {
        reqParams.iam['Resource'] = [
            "arn:aws:s3:::" + jsonRequestBody.path
        ];

        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";
        reqParams = addToParamsFromXml(reqParams, jsonRequestBody.contentString);

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'PutBucketVersioning',
                'boto3': 'put_bucket_versioning',
                'cli': 'put-bucket-versioning'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }
    
    // manual:s3:s3.PutBucketMetricsConfiguration
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "PutBucketMetrics") {
        reqParams.iam['Action'] = [
            's3:PutMetricsConfiguration'
        ];
        reqParams.iam['Resource'] = [
            "arn:aws:s3:::" + jsonRequestBody.path
        ];

        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";
        reqParams = addToParamsFromXml(reqParams, jsonRequestBody.contentString);

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'PutBucketMetricsConfiguration',
                'boto3': 'put_bucket_metrics_configuration',
                'cli': 'put-bucket-metrics-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }
    
    // manual:s3:s3.PutBucketTagging
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "PutBucketTagging") {
        reqParams.iam['Resource'] = [
            "arn:aws:s3:::" + jsonRequestBody.path
        ];

        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";
        reqParams = addToParamsFromXml(reqParams, jsonRequestBody.contentString);

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'PutBucketTagging',
                'boto3': 'put_bucket_tagging',
                'cli': 'put-bucket-tagging'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }
    
    // manual:s3:s3.PutBucketAcl
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "PutBucketAcl") {
        reqParams.iam['Resource'] = [
            "arn:aws:s3:::" + jsonRequestBody.path
        ];

        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";
        reqParams = addToParamsFromXml(reqParams, jsonRequestBody.contentString);

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'PutBucketAcl',
                'boto3': 'put_bucket_acl',
                'cli': 'put-bucket-acl'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }
    
    // manual:s3:s3.PutBucketLogging
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "PutBucketLogging") {
        reqParams.iam['Resource'] = [
            "arn:aws:s3:::" + jsonRequestBody.path
        ];

        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";
        reqParams = addToParamsFromXml(reqParams, jsonRequestBody.contentString);

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'PutBucketLogging',
                'boto3': 'put_bucket_logging',
                'cli': 'put-bucket-logging'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }
    
    // manual:s3:s3.DeleteBucket
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "DeleteBucket") {
        reqParams.iam['Resource'] = [
            "arn:aws:s3:::" + jsonRequestBody.path
        ];

        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'DeleteBucket',
                'boto3': 'delete_bucket',
                'cli': 'delete-bucket'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }

        return {};
    }
    
    // manual:s3:s3.ListObjects
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "ListObjects") {
        reqParams.boto3['BucketName'] = jsonRequestBody.path;
        reqParams.boto3['Prefix'] = jsonRequestBody.params.prefix;
        reqParams.cli['_'] = [
            `s3://${jsonRequestBody.path}/${jsonRequestBody.params.prefix}`
        ]

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'ListObjects',
                'boto3': 'list_objects',
                'cli': 'ls'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketVersioning
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketVersioning") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketVersioning',
                'boto3': 'get_bucket_versioning',
                'cli': 'get-bucket-versioning'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketLogging
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketLogging") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketLogging',
                'boto3': 'get_bucket_logging',
                'cli': 'get-bucket-logging'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketTagging
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketTagging") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketTagging',
                'boto3': 'get_bucket_tagging',
                'cli': 'get-bucket-tagging'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketNotificationConfiguration
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketNotification") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketNotificationConfiguration',
                'boto3': 'get_bucket_notification_configuration',
                'cli': 'get-bucket-notification-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketWebsite
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketWebsite") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketWebsite',
                'boto3': 'get_bucket_website',
                'cli': 'get-bucket-website'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketRequestPayment
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketRequestPayment") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketRequestPayment',
                'boto3': 'get_bucket_request_payment',
                'cli': 'get-bucket-request-payment'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketAccelerateConfiguration
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketAccelerate") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketAccelerateConfiguration',
                'boto3': 'get_bucket_accelerate_configuration',
                'cli': 'get-bucket-accelerate-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketEncryption
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketDefaultEncryption") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketEncryption',
                'boto3': 'get_bucket_encryption',
                'cli': 'get-bucket-encryption'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketReplication
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketReplication") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketReplication',
                'boto3': 'get_bucket_replication',
                'cli': 'get-bucket-replication'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketMetricsConfiguration
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketMetrics") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketMetricsConfiguration',
                'boto3': 'get_bucket_metrics_configuration',
                'cli': 'get-bucket-metrics-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketAnalyticsConfiguration
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketAnalytics") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketAnalyticsConfiguration',
                'boto3': 'get_bucket_analytics_configuration',
                'cli': 'get-bucket-analytics-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketLifecycleConfiguration
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetLifecycleConfiguration") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketLifecycleConfiguration',
                'boto3': 'get_bucket_lifecycle_configuration',
                'cli': 'get-bucket-lifecycle-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:s3:s3.GetBucketCORS
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketCORS") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketCORS',
                'boto3': 'get_bucket_cors',
                'cli': 'get-bucket-cors'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketPolicy
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketPolicy") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketPolicy',
                'boto3': 'get_bucket_policy',
                'cli': 'get-bucket-policy'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.GetBucketAcl
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "GetBucketAcl") {
        reqParams.boto3['Bucket'] = jsonRequestBody.path;
        reqParams.cli['--bucket'] = jsonRequestBody.path;
        reqParams.cli['_cli_service'] = "s3api";

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'GetBucketAcl',
                'boto3': 'get_bucket_acl',
                'cli': 'get-bucket-acl'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }
    
    // manual:s3:s3.ListBuckets
    if (details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/proxy$/g) && jsonRequestBody.operation == "ListAllMyBuckets") {
        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'ListBuckets',
                'boto3': 'list_buckets',
                'cli': 'ls'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // manual:s3:cloudtrail.DescribeTrails
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/s3\/cloudtrail-proxy$/g) && jsonRequestBody.operation == "DescribeTrails") {
        reqParams.boto3['includeShadowTrails'] = jsonRequestBody.content.includeShadowTrails;
        reqParams.boto3['trailNameList'] = jsonRequestBody.content.trailNameList;
        if (jsonRequestBody.content.includeShadowTrails === true)
            reqParams.cli['--include-shadow-trails'] = null;
        else if (jsonRequestBody.content.includeShadowTrails === true)
            reqParams.cli['--no-include-shadow-trails'] = null;
        reqParams.cli['--trail-name-list'] = jsonRequestBody.content.trailNameList;
        

        outputs.push({
            'region': region,
            'service': 'cloudtrail',
            'method': {
                'api': 'DescribeTrails',
                'boto3': 'describe_trails',
                'cli': 'describe-trails'
            },
            'options': reqParams,
            'requestDetails': details
        });

        return {};
    }

    // autogen:cloud9:cloud9.DescribeEnvironmentMemberships
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloud9\/api\/cloud9$/g) && jsonRequestBody.operation == "describeEnvironmentMemberships" && jsonRequestBody.method == "POST") {
        reqParams.boto3['permissions'] = jsonRequestBody.contentString.permissions;
        reqParams.cli['--permissions'] = jsonRequestBody.contentString.permissions;
        reqParams.boto3['maxResults'] = jsonRequestBody.contentString.maxResults;
        reqParams.cli['--max-results'] = jsonRequestBody.contentString.maxResults;

        outputs.push({
            'region': region,
            'service': 'cloud9',
            'method': {
                'api': 'DescribeEnvironmentMemberships',
                'boto3': 'describe_environment_memberships',
                'cli': 'describe-environment-memberships'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloud9:cloud9.DescribeEnvironments
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloud9\/api\/cloud9$/g) && jsonRequestBody.operation == "describeEnvironments" && jsonRequestBody.method == "POST") {
        reqParams.boto3['environmentIds'] = jsonRequestBody.contentString.environmentIds;
        reqParams.cli['--environment-ids'] = jsonRequestBody.contentString.environmentIds;

        outputs.push({
            'region': region,
            'service': 'cloud9',
            'method': {
                'api': 'DescribeEnvironments',
                'boto3': 'describe_environments',
                'cli': 'describe-environments'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloud9:cloud9.ListEnvironments
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloud9\/api\/cloud9$/g) && jsonRequestBody.operation == "listEnvironments" && jsonRequestBody.method == "POST") {
        reqParams.boto3['MaxResults'] = jsonRequestBody.contentString.maxResults;
        reqParams.cli['--max-results'] = jsonRequestBody.contentString.maxResults;

        outputs.push({
            'region': region,
            'service': 'cloud9',
            'method': {
                'api': 'ListEnvironments',
                'boto3': 'list_environments',
                'cli': 'list-environments'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloud9:cloud9.UpdateEnvironment
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloud9\/api\/cloud9$/g) && jsonRequestBody.operation == "describeEC2Remote" && jsonRequestBody.method == "POST" && jsonRequestBody.operation == "updateEnvironment" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:cloud9:*:*:environment:" + jsonRequestBody.contentString.environmentId
        ];

        reqParams.boto3['environmentId'] = jsonRequestBody.contentString.environmentId;
        reqParams.cli['--environment-id'] = jsonRequestBody.contentString.environmentId;
        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['description'] = jsonRequestBody.contentString.description;
        reqParams.cli['--description'] = jsonRequestBody.contentString.description;

        outputs.push({
            'region': region,
            'service': 'cloud9',
            'method': {
                'api': 'UpdateEnvironment',
                'boto3': 'update_environment',
                'cli': 'update-environment'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:cloud9:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloud9\/api\/ec2$/g) && jsonRequestBody.operation == "describeVpcs" && jsonRequestBody.method == "POST") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloud9:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloud9\/api\/ec2$/g) && jsonRequestBody.operation == "describeSubnets" && jsonRequestBody.method == "POST") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloud9:cloud9.CreateEnvironmentEC2
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloud9\/api\/cloud9$/g) && jsonRequestBody.operation == "createEnvironmentEC2" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['description'] = jsonRequestBody.contentString.description;
        reqParams.cli['--description'] = jsonRequestBody.contentString.description;
        reqParams.boto3['instanceType'] = jsonRequestBody.contentString.instanceType;
        reqParams.cli['--instance-type'] = jsonRequestBody.contentString.instanceType;
        reqParams.boto3['automaticStopTimeMinutes'] = jsonRequestBody.contentString.automaticStopTimeMinutes;
        reqParams.cli['--automatic-stop-time-minutes'] = jsonRequestBody.contentString.automaticStopTimeMinutes;
        reqParams.boto3['subnetId'] = jsonRequestBody.contentString.subnetId;
        reqParams.cli['--subnet-id'] = jsonRequestBody.contentString.subnetId;
        reqParams.boto3['clientRequestToken'] = jsonRequestBody.contentString.clientRequestToken;
        reqParams.cli['--client-request-token'] = jsonRequestBody.contentString.clientRequestToken;

        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;
        reqParams.cfn['Description'] = jsonRequestBody.contentString.description;
        reqParams.cfn['InstanceType'] = jsonRequestBody.contentString.instanceType;
        reqParams.cfn['AutomaticStopTimeMinutes'] = jsonRequestBody.contentString.automaticStopTimeMinutes;
        reqParams.cfn['SubnetId'] = jsonRequestBody.contentString.subnetId;

        reqParams.tf['name'] = jsonRequestBody.contentString.name;
        reqParams.tf['description'] = jsonRequestBody.contentString.description;
        reqParams.tf['instance_type'] = jsonRequestBody.contentString.instanceType;
        reqParams.tf['automatic_stop_time_minutes'] = jsonRequestBody.contentString.automaticStopTimeMinutes;
        reqParams.tf['subnet_id'] = jsonRequestBody.contentString.subnetId;

        outputs.push({
            'region': region,
            'service': 'cloud9',
            'method': {
                'api': 'CreateEnvironmentEC2',
                'boto3': 'create_environment_ec2',
                'cli': 'create-environment-ec2'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('cloud9', details.requestId),
            'region': region,
            'service': 'cloud9',
            'type': 'AWS::Cloud9::EnvironmentEC2',
            'terraformType': 'aws_cloud9_environment_ec2',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:cloud9:cloud9.DeleteEnvironment
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloud9\/api\/cloud9$/g) && jsonRequestBody.operation == "deleteEnvironment" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:cloud9:*:*:environment:" + jsonRequestBody.contentString.environmentId
        ];

        reqParams.boto3['environmentId'] = jsonRequestBody.contentString.environmentId;
        reqParams.cli['--environment-id'] = jsonRequestBody.contentString.environmentId;

        outputs.push({
            'region': region,
            'service': 'cloud9',
            'method': {
                'api': 'DeleteEnvironment',
                'boto3': 'delete_environment',
                'cli': 'delete-environment'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:medialive:medialive.ListInputSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/medialive\/api\/inputSecurityGroups$/g) && jsonRequestBody.method == "GET") {

        outputs.push({
            'region': region,
            'service': 'medialive',
            'method': {
                'api': 'ListInputSecurityGroups',
                'boto3': 'list_input_security_groups',
                'cli': 'list-input-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:medialive:medialive.ListChannels
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/medialive\/api\/channels$/g) && jsonRequestBody.method == "GET") {

        outputs.push({
            'region': region,
            'service': 'medialive',
            'method': {
                'api': 'ListChannels',
                'boto3': 'list_channels',
                'cli': 'list-channels'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:medialive:medialive.CreateInputSecurityGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/medialive\/api\/inputSecurityGroups$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['WhitelistRules'] = jsonRequestBody.contentString.whitelistRules;
        reqParams.cli['--whitelist-rules'] = jsonRequestBody.contentString.whitelistRules;

        outputs.push({
            'region': region,
            'service': 'medialive',
            'method': {
                'api': 'CreateInputSecurityGroup',
                'boto3': 'create_input_security_group',
                'cli': 'create-input-security-group'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:medialive:ssm.GetParametersByPath
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/medialive\/api\/ssm$/g) && jsonRequestBody.operation == "getParametersByPath" && jsonRequestBody.method == "POST") {
        reqParams.boto3['Path'] = jsonRequestBody.contentString.Path;
        reqParams.cli['--path'] = jsonRequestBody.contentString.Path;

        outputs.push({
            'region': region,
            'service': 'ssm',
            'method': {
                'api': 'GetParametersByPath',
                'boto3': 'get_parameters_by_path',
                'cli': 'get-parameters-by-path'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:medialive:iam.ListRoles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/medialive\/api\/iam$/g) && jsonRequestBody.operation == "listRoles") {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListRoles',
                'boto3': 'list_roles',
                'cli': 'list-roles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:medialive:iam.GetRolePolicy
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/medialive\/api\/iam$/g) && jsonRequestBody.operation == "getRolePolicy") {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'GetRolePolicy',
                'boto3': 'get_role_policy',
                'cli': 'get-role-policy'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:medialive:medialive.CreateChannel
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/medialive\/api\/channels$/g) && jsonRequestBody.operation == "createChannels" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['InputAttachments'] = jsonRequestBody.contentString.inputAttachments;
        reqParams.cli['--input-attachments'] = jsonRequestBody.contentString.inputAttachments;
        reqParams.boto3['InputSpecification'] = jsonRequestBody.contentString.inputSpecification;
        reqParams.cli['--input-specification'] = jsonRequestBody.contentString.inputSpecification;
        reqParams.boto3['Destinations'] = jsonRequestBody.contentString.destinations;
        reqParams.cli['--destinations'] = jsonRequestBody.contentString.destinations;
        reqParams.boto3['EncoderSettings'] = jsonRequestBody.contentString.encoderSettings;
        reqParams.cli['--encoder-settings'] = jsonRequestBody.contentString.encoderSettings;
        reqParams.boto3['RequestId'] = jsonRequestBody.contentString.requestId;
        reqParams.cli['--request-id'] = jsonRequestBody.contentString.requestId;
        reqParams.boto3['LogLevel'] = jsonRequestBody.contentString.logLevel;
        reqParams.cli['--log-level'] = jsonRequestBody.contentString.logLevel;
        reqParams.boto3['RoleArn'] = jsonRequestBody.contentString.roleArn;
        reqParams.cli['--role-arn'] = jsonRequestBody.contentString.roleArn;

        outputs.push({
            'region': region,
            'service': 'medialive',
            'method': {
                'api': 'CreateChannel',
                'boto3': 'create_channel',
                'cli': 'create-channel'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:efs:efs.DescribeFileSystems
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=describeFileSystems$/g)) {

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'DescribeFileSystems',
                'boto3': 'describe_file_systems',
                'cli': 'describe-file-systems'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:efs:kms.ListKeys
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=listKeys$/g)) {

        outputs.push({
            'region': region,
            'service': 'kms',
            'method': {
                'api': 'ListKeys',
                'boto3': 'list_keys',
                'cli': 'list-keys'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:efs:kms.DescribeKey
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=describeKey$/g)) {
        reqParams.boto3['KeyId'] = jsonRequestBody.kmsKeyId;
        reqParams.cli['--key-id'] = jsonRequestBody.kmsKeyId;

        outputs.push({
            'region': region,
            'service': 'kms',
            'method': {
                'api': 'DescribeKey',
                'boto3': 'describe_key',
                'cli': 'describe-key'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:efs:efs.CreateFileSystem
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=createFileSystem$/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['PerformanceMode'] = jsonRequestBody.performanceMode;
        reqParams.cli['--performance-mode'] = jsonRequestBody.performanceMode;
        reqParams.boto3['Encrypted'] = jsonRequestBody.encrypted;
        reqParams.cli['--encrypted'] = jsonRequestBody.encrypted;
        reqParams.boto3['KmsKeyId'] = jsonRequestBody.kmsKeyId;
        reqParams.cli['--kms-key-id'] = jsonRequestBody.kmsKeyId;
        reqParams.boto3['ThroughputMode'] = jsonRequestBody.throughputMode;
        reqParams.cli['--throughput-mode'] = jsonRequestBody.throughputMode;
        reqParams.boto3['ProvisionedThroughputInMibps'] = jsonRequestBody.provisionedThroughputInMibps;
        reqParams.cli['--provisioned-throughput-in-mibps'] = jsonRequestBody.provisionedThroughputInMibps;

        reqParams.cfn['PerformanceMode'] = jsonRequestBody.performanceMode;
        reqParams.cfn['Encrypted'] = jsonRequestBody.encrypted;
        reqParams.cfn['KmsKeyId'] = jsonRequestBody.kmsKeyId;
        reqParams.cfn['ThroughputMode'] = jsonRequestBody.throughputMode;
        reqParams.cfn['ProvisionedThroughputInMibps'] = jsonRequestBody.provisionedThroughputInMibps;

        reqParams.tf['performance_mode'] = jsonRequestBody.performanceMode;
        reqParams.tf['encrypted'] = jsonRequestBody.encrypted;
        reqParams.tf['kms_key_id'] = jsonRequestBody.kmsKeyId;
        reqParams.tf['throughput_mode'] = jsonRequestBody.throughputMode;
        reqParams.tf['provisioned_throughput_in_mibps'] = jsonRequestBody.provisionedThroughputInMibps;

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'CreateFileSystem',
                'boto3': 'create_file_system',
                'cli': 'create-file-system'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('efs', details.requestId),
            'region': region,
            'service': 'efs',
            'type': 'AWS::EFS::FileSystem',
            'terraformType': 'aws_efs_file_system',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:efs:efs.CreateMountTarget
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=createMountTarget$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticfilesystem:*:*:file-system/" + jsonRequestBody.fileSystemId
        ];

        reqParams.boto3['FileSystemId'] = jsonRequestBody.fileSystemId;
        reqParams.cli['--file-system-id'] = jsonRequestBody.fileSystemId;
        reqParams.boto3['SubnetId'] = jsonRequestBody.mountTargetConfig.subnetId;
        reqParams.cli['--subnet-id'] = jsonRequestBody.mountTargetConfig.subnetId;
        reqParams.boto3['SecurityGroups'] = jsonRequestBody.mountTargetConfig.securityGroups;
        reqParams.cli['--security-groups'] = jsonRequestBody.mountTargetConfig.securityGroups;

        reqParams.cfn['FileSystemId'] = jsonRequestBody.fileSystemId;
        reqParams.cfn['SubnetId'] = jsonRequestBody.mountTargetConfig.subnetId;
        reqParams.cfn['SecurityGroups'] = jsonRequestBody.mountTargetConfig.securityGroups;

        reqParams.tf['file_system_id'] = jsonRequestBody.fileSystemId;
        reqParams.tf['subnet_id'] = jsonRequestBody.mountTargetConfig.subnetId;
        reqParams.tf['security_groups'] = jsonRequestBody.mountTargetConfig.securityGroups;

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'CreateMountTarget',
                'boto3': 'create_mount_target',
                'cli': 'create-mount-target'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('efs', details.requestId),
            'region': region,
            'service': 'efs',
            'type': 'AWS::EFS::MountTarget',
            'terraformType': 'aws_efs_mount_target',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:efs:efs.DescribeMountTargets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=describeMountTargets$/g)) {
        reqParams.boto3['FileSystemId'] = jsonRequestBody.fileSystemId;
        reqParams.cli['--file-system-id'] = jsonRequestBody.fileSystemId;

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'DescribeMountTargets',
                'boto3': 'describe_mount_targets',
                'cli': 'describe-mount-targets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:efs:efs.DescribeTags
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=describeTags$/g)) {
        reqParams.boto3['FileSystemId'] = jsonRequestBody.fileSystemId;
        reqParams.cli['--file-system-id'] = jsonRequestBody.fileSystemId;

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'DescribeTags',
                'boto3': 'describe_tags',
                'cli': 'describe-tags'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:efs:efs.UpdateFileSystem
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=modifyThroughputMode$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticfilesystem:*:*:file-system/" + jsonRequestBody.fileSystemId
        ];

        reqParams.boto3['FileSystemId'] = jsonRequestBody.fileSystemId;
        reqParams.cli['--file-system-id'] = jsonRequestBody.fileSystemId;
        reqParams.boto3['ThroughputMode'] = jsonRequestBody.throughputMode;
        reqParams.cli['--throughput-mode'] = jsonRequestBody.throughputMode;
        reqParams.boto3['ProvisionedThroughputInMibps'] = jsonRequestBody.provisionedThroughputInMibps;
        reqParams.cli['--provisioned-throughput-in-mibps'] = jsonRequestBody.provisionedThroughputInMibps;

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'UpdateFileSystem',
                'boto3': 'update_file_system',
                'cli': 'update-file-system'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:efs:efs.DeleteMountTarget
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=deleteMountTarget$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticfilesystem:*:*:file-system/*"
        ];

        reqParams.boto3['MountTargetId'] = jsonRequestBody.mountTargetId;
        reqParams.cli['--mount-target-id'] = jsonRequestBody.mountTargetId;

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'DeleteMountTarget',
                'boto3': 'delete_mount_target',
                'cli': 'delete-mount-target'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:efs:efs.DeleteFileSystem
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?region=.+&type=deleteFileSystem$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticfilesystem:*:*:file-system/" + jsonRequestBody.fileSystemId
        ];

        reqParams.boto3['FileSystemId'] = jsonRequestBody.fileSystemId;
        reqParams.cli['--file-system-id'] = jsonRequestBody.fileSystemId;

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'DeleteFileSystem',
                'boto3': 'delete_file_system',
                'cli': 'delete-file-system'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:cloudtrail:cloudtrail.GetEventSelectors
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudtrail\/service\/getEventSelectors\?/g)) {
        reqParams.boto3['TrailName'] = getUrlValue(details.url, 'trailArn');
        reqParams.cli['--trail-name'] = getUrlValue(details.url, 'trailArn');

        outputs.push({
            'region': region,
            'service': 'cloudtrail',
            'method': {
                'api': 'GetEventSelectors',
                'boto3': 'get_event_selectors',
                'cli': 'get-event-selectors'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudtrail:cloudtrail.DescribeTrails
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudtrail\/service\/resources\/trails\?/g)) {
        reqParams.boto3['IncludeShadowTrails'] = getUrlValue(details.url, 'includeShadowTrails');
        reqParams.cli['--include-shadow-trails'] = getUrlValue(details.url, 'includeShadowTrails');

        outputs.push({
            'region': region,
            'service': 'cloudtrail',
            'method': {
                'api': 'DescribeTrails',
                'boto3': 'describe_trails',
                'cli': 'describe-trails'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudtrail:cloudtrail.LookupEvents
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudtrail\/service\/lookupEvents\?/g)) {
        reqParams.boto3['EndTime'] = getUrlValue(details.url, 'endTime');
        reqParams.cli['--end-time'] = getUrlValue(details.url, 'endTime');
        reqParams.boto3['StartTime'] = getUrlValue(details.url, 'startTime');
        reqParams.cli['--start-time'] = getUrlValue(details.url, 'startTime');

        outputs.push({
            'region': region,
            'service': 'cloudtrail',
            'method': {
                'api': 'LookupEvents',
                'boto3': 'lookup_events',
                'cli': 'lookup-events'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudtrail:sns.ListTopics
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudtrail\/service\/getSnsTopicNameToArnMapByRegion\?/g)) {

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'ListTopics',
                'boto3': 'list_topics',
                'cli': 'list-topics'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudtrail:lambda.ListFunctions
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudtrail\/service\/listLambdaFunctions\?/g)) {

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'ListFunctions',
                'boto3': 'list_functions',
                'cli': 'list-functions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudtrail:cloudtrail.CreateTrail
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudtrail\/service\/subscribe\?/g)) {
        var prefix = getUrlValue(details.url, 's3KeyPrefix');
        if (!prefix) {
            prefix = "";
        }

        reqParams.iam['Resource'] = [
            "arn:aws:cloudtrail:*:*:trail/" + getUrlValue(details.url, 'configName')
        ];

        reqParams.iam['secondary'] = [
            {
                'Action': [
                    's3:PutObject'
                ],
                'Resource': [
                    'arn:aws:s3:::' + getUrlValue(details.url, 's3BucketName') + '/' + prefix + '/*'
                ]
            }
        ];

        reqParams.boto3['Name'] = getUrlValue(details.url, 'configName');
        reqParams.cli['--name'] = getUrlValue(details.url, 'configName');
        reqParams.boto3['IncludeGlobalServiceEvents'] = getUrlValue(details.url, 'isIncludeGlobalServiceEvents');
        reqParams.cli['--include-global-service-events'] = getUrlValue(details.url, 'isIncludeGlobalServiceEvents');
        reqParams.boto3['IsMultiRegionTrail'] = getUrlValue(details.url, 'isMultiRegionTrail');
        reqParams.cli['--is-multi-region-trail'] = getUrlValue(details.url, 'isMultiRegionTrail');
        reqParams.boto3['KmsKeyId'] = getUrlValue(details.url, 'kmsKeyId');
        reqParams.cli['--kms-key-id'] = getUrlValue(details.url, 'kmsKeyId');
        reqParams.boto3['EnableLogFileValidation'] = getUrlValue(details.url, 'logFileValidation');
        reqParams.cli['--enable-log-file-validation'] = getUrlValue(details.url, 'logFileValidation');
        reqParams.boto3['S3BucketName'] = getUrlValue(details.url, 's3BucketName');
        reqParams.cli['--s3-bucket-name'] = getUrlValue(details.url, 's3BucketName');
        reqParams.boto3['S3KeyPrefix'] = getUrlValue(details.url, 's3KeyPrefix');
        reqParams.cli['--s3-key-prefix'] = getUrlValue(details.url, 's3KeyPrefix');
        reqParams.boto3['SnsTopicName'] = getUrlValue(details.url, 'snsTopicArn');
        reqParams.cli['--sns-topic-name'] = getUrlValue(details.url, 'snsTopicArn');

        reqParams.cfn['TrailName'] = getUrlValue(details.url, 'configName');
        reqParams.cfn['IncludeGlobalServiceEvents'] = getUrlValue(details.url, 'isIncludeGlobalServiceEvents');
        reqParams.cfn['IsMultiRegionTrail'] = getUrlValue(details.url, 'isMultiRegionTrail');
        reqParams.cfn['KMSKeyId'] = getUrlValue(details.url, 'kmsKeyId');
        reqParams.cfn['EnableLogFileValidation'] = getUrlValue(details.url, 'logFileValidation');
        reqParams.cfn['S3BucketName'] = getUrlValue(details.url, 's3BucketName');
        reqParams.cfn['S3KeyPrefix'] = getUrlValue(details.url, 's3KeyPrefix');
        reqParams.cfn['SnsTopicName'] = getUrlValue(details.url, 'snsTopicArn');

        reqParams.tf['name'] = getUrlValue(details.url, 'configName');
        reqParams.tf['include_global_service_events'] = getUrlValue(details.url, 'isIncludeGlobalServiceEvents');
        reqParams.tf['is_multi_region_trail'] = getUrlValue(details.url, 'isMultiRegionTrail');
        reqParams.tf['kms_key_id'] = getUrlValue(details.url, 'kmsKeyId');
        reqParams.tf['enable_log_file_validation'] = getUrlValue(details.url, 'logFileValidation');
        reqParams.tf['s3_bucket_name'] = getUrlValue(details.url, 's3BucketName');
        reqParams.tf['s3_key_prefix'] = getUrlValue(details.url, 's3KeyPrefix');
        reqParams.tf['sns_topic_name'] = getUrlValue(details.url, 'snsTopicArn');

        outputs.push({
            'region': region,
            'service': 'cloudtrail',
            'method': {
                'api': 'CreateTrail',
                'boto3': 'create_trail',
                'cli': 'create-trail'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('cloudtrail', details.requestId),
            'region': region,
            'service': 'cloudtrail',
            'type': 'AWS::CloudTrail::Trail',
            'terraformType': 'aws_cloudtrail',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:cloudtrail:cloudtrail.GetTrailStatus
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudtrail\/service\/resources\/status\?/g)) {
        reqParams.boto3['Name'] = getUrlValue(details.url, 'trailArn');
        reqParams.cli['--name'] = getUrlValue(details.url, 'trailArn');

        outputs.push({
            'region': region,
            'service': 'cloudtrail',
            'method': {
                'api': 'GetTrailStatus',
                'boto3': 'get_trail_status',
                'cli': 'get-trail-status'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudtrail:cloudtrail.ListTags
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudtrail\/service\/listTags\?/g)) {
        reqParams.boto3['ResourceIdList'] = [getUrlValue(details.url, 'trailArn')];
        reqParams.cli['--resource-id-list'] = [getUrlValue(details.url, 'trailArn')];

        outputs.push({
            'region': region,
            'service': 'cloudtrail',
            'method': {
                'api': 'ListTags',
                'boto3': 'list_tags',
                'cli': 'list-tags'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:config:config.DescribePendingAggregationRequests
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/config\/service\/aggregationAuthorization\/describePendingAggregationRequests\?/g)) {

        outputs.push({
            'region': region,
            'service': 'config',
            'method': {
                'api': 'DescribePendingAggregationRequests',
                'boto3': 'describe_pending_aggregation_requests',
                'cli': 'describe-pending-aggregation-requests'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:config:config.DescribeConfigurationRecorders
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/config\/service\/listConfigurationRecorders\?/g)) {

        outputs.push({
            'region': region,
            'service': 'config',
            'method': {
                'api': 'DescribeConfigurationRecorders',
                'boto3': 'describe_configuration_recorders',
                'cli': 'describe-configuration-recorders'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:config:config.DescribeDeliveryChannels
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/config\/service\/listDeliveryChannels\?/g)) {

        outputs.push({
            'region': region,
            'service': 'config',
            'method': {
                'api': 'DescribeDeliveryChannels',
                'boto3': 'describe_delivery_channels',
                'cli': 'describe-delivery-channels'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:config:iam.ListRoles
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/config\/service\/iam\/listRoles\?/g)) {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListRoles',
                'boto3': 'list_roles',
                'cli': 'list-roles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:config:s3.ListBuckets
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/config\/service\/listS3Buckets\?/g)) {

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'ListBuckets',
                'boto3': 'list_buckets',
                'cli': 'list-buckets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:config:sns.ListTopics
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/config\/service\/listSnsTopics\?/g)) {

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'ListTopics',
                'boto3': 'list_topics',
                'cli': 'list-topics'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:config:iam.CreateServiceLinkedRole
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/config\/service\/createServiceLinkedRole\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:role/*"
        ];

        reqParams.boto3['AWSServiceName'] = 'elasticbeanstalk.amazonaws.com';
        reqParams.cli['--aws-service-name'] = 'elasticbeanstalk.amazonaws.com';

        reqParams.cfn['AWSServiceName'] = 'elasticbeanstalk.amazonaws.com';

        reqParams.tf['aws_service_name'] = 'elasticbeanstalk.amazonaws.com';

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'CreateServiceLinkedRole',
                'boto3': 'create_service_linked_role',
                'cli': 'create-service-linked-role'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('iam', details.requestId),
            'region': region,
            'service': 'iam',
            'type': 'AWS::IAM::ServiceLinkedRole',
            'terraformType': 'aws_iam_service_linked_role',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:config:s3.CreateBucket
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/config\/service\/createS3BucketForConfiguration\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:s3:::" + jsonRequestBody.s3BucketName
        ];

        reqParams.boto3['Bucket'] = jsonRequestBody.s3BucketName;
        reqParams.cli['--bucket'] = jsonRequestBody.s3BucketName;

        reqParams.cfn['BucketName'] = jsonRequestBody.s3BucketName;

        reqParams.tf['bucket'] = jsonRequestBody.s3BucketName;

        outputs.push({
            'region': region,
            'service': 's3',
            'method': {
                'api': 'CreateBucket',
                'boto3': 'create_bucket',
                'cli': 'create-bucket'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('s3', details.requestId),
            'region': region,
            'service': 's3',
            'type': 'AWS::S3::Bucket',
            'terraformType': 'aws_s3_bucket',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.ListDetectors
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && (jsonRequestBody.operation == "ListDetectors" || jsonRequestBody.operation == "listDetectors") && jsonRequestBody.method == "GET") {

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'ListDetectors',
                'boto3': 'list_detectors',
                'cli': 'list-detectors'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.GetInvitationsCount
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "GetInvitationsCount" && jsonRequestBody.method == "GET") {

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'GetInvitationsCount',
                'boto3': 'get_invitations_count',
                'cli': 'get-invitations-count'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.CreateDetector
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && (jsonRequestBody.operation == "CreateDetector" || jsonRequestBody.operation == "createDetector") && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Enable'] = jsonRequestBody.contentString.enable;
        reqParams.cli['--enable'] = jsonRequestBody.contentString.enable;

        reqParams.cfn['Enable'] = jsonRequestBody.contentString.enable;

        reqParams.tf['enable'] = jsonRequestBody.contentString.enable;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'CreateDetector',
                'boto3': 'create_detector',
                'cli': 'create-detector'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('guardduty', details.requestId),
            'region': region,
            'service': 'guardduty',
            'type': 'AWS::GuardDuty::Detector',
            'terraformType': 'aws_guardduty_detector',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.ListFindings
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "ListFindings" && jsonRequestBody.method == "POST") {
        reqParams.boto3['FindingCriteria'] = jsonRequestBody.contentString.findingCriteria;
        reqParams.cli['--finding-criteria'] = jsonRequestBody.contentString.findingCriteria;
        reqParams.boto3['SortCriteria'] = jsonRequestBody.contentString.sortCriteria;
        reqParams.cli['--sort-criteria'] = jsonRequestBody.contentString.sortCriteria;
        reqParams.boto3['MaxResults'] = jsonRequestBody.contentString.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.contentString.maxResults;
        reqParams.boto3['NextToken'] = jsonRequestBody.contentString.nextToken;
        reqParams.cli['--next-token'] = jsonRequestBody.contentString.nextToken;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'ListFindings',
                'boto3': 'list_findings',
                'cli': 'list-findings'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.GetMasterAccount
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "GetMasterAccount" && jsonRequestBody.method == "GET") {

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'GetMasterAccount',
                'boto3': 'get_master_account',
                'cli': 'get-master-account'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.ListMembers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "ListMembers" && jsonRequestBody.method == "GET") {
        reqParams.boto3['MaxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.params.maxResults;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'ListMembers',
                'boto3': 'list_members',
                'cli': 'list-members'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.GetDetector
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "GetDetector" && jsonRequestBody.method == "GET") {
        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'GetDetector',
                'boto3': 'get_detector',
                'cli': 'get-detector'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.GetFindingsStatistics
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "GetFindingsStatistics" && jsonRequestBody.method == "POST") {
        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['FindingCriteria'] = jsonRequestBody.contentString.findingCriteria;
        reqParams.cli['--finding-criteria'] = jsonRequestBody.contentString.findingCriteria;
        reqParams.boto3['FindingStatisticTypes'] = jsonRequestBody.contentString.findingStatisticTypes;
        reqParams.cli['--finding-statistic-types'] = jsonRequestBody.contentString.findingStatisticTypes;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'GetFindingsStatistics',
                'boto3': 'get_findings_statistics',
                'cli': 'get-findings-statistics'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.ListFilters
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "ListFilters" && jsonRequestBody.method == "GET") {
        reqParams.boto3['MaxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.params.maxResults;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'ListFilters',
                'boto3': 'list_filters',
                'cli': 'list-filters'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.CreateMembers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "CreateMembers" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:guardduty:*:*:detector/" + jsonRequestBody.path.split("/")[2]
        ];

        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['AccountDetails'] = jsonRequestBody.contentString.accountDetails;
        reqParams.cli['--account-details'] = jsonRequestBody.contentString.accountDetails;

        reqParams.cfn['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cfn['MemberId'] = jsonRequestBody.contentString.accountDetails.AccountId;
        reqParams.cfn['Email'] = jsonRequestBody.contentString.accountDetails.Email;

        reqParams.tf['detector_id'] = jsonRequestBody.path.split("/")[2];
        reqParams.tf['account_id'] = jsonRequestBody.contentString.accountDetails.AccountId;
        reqParams.tf['email'] = jsonRequestBody.contentString.accountDetails.Email;
        
        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'CreateMembers',
                'boto3': 'create_members',
                'cli': 'create-members'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('guardduty', details.requestId),
            'region': region,
            'service': 'guardduty',
            'type': 'AWS::GuardDuty::Member',
            'terraformType': 'aws_guardduty_member',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.DeleteMembers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "DeleteMembers" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:guardduty:*:*:detector/" + jsonRequestBody.path.split("/")[2]
        ];

        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['AccountIds'] = jsonRequestBody.contentString.accountIds;
        reqParams.cli['--account-ids'] = jsonRequestBody.contentString.accountIds;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'DeleteMembers',
                'boto3': 'delete_members',
                'cli': 'delete-members'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.ListIPSets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "ListIPSets" && jsonRequestBody.method == "GET") {
        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['MaxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.params.maxResults;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'ListIPSets',
                'boto3': 'list_ip_sets',
                'cli': 'list-ip-sets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.ListThreatIntelSets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "ListThreatIntelSets" && jsonRequestBody.method == "GET") {
        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['MaxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.params.maxResults;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'ListThreatIntelSets',
                'boto3': 'list_threat_intel_sets',
                'cli': 'list-threat-intel-sets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:iam.ListPolicyVersions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/iam$/g) && jsonRequestBody.operation == "ListPolicyVersions" && jsonRequestBody.method == "POST") {
        reqParams.boto3['PolicyArn'] = jsonRequestBody.contentString.match(/PolicyArn\=(.+)\&Version/g)[1];
        reqParams.cli['--policy-arn'] = jsonRequestBody.contentString.match(/PolicyArn\=(.+)\&Version/g)[1]; // "Action=ListPolicyVersions&PolicyArn=arn:aws:iam::aws:policy/aws-service-role/AmazonGuardDutyServiceRolePolicy&Version=2010-05-08"

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListPolicyVersions',
                'boto3': 'list_policy_versions',
                'cli': 'list-policy-versions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.CreateIPSet
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "CreateIPSet" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:guardduty:*:*:detector/" + jsonRequestBody.path.split("/")[2]
        ];

        reqParams.boto3['DetectorId'] = jsonRequestBody.path;
        reqParams.cli['--detector-id'] = jsonRequestBody.path;
        reqParams.boto3['Name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['Location'] = jsonRequestBody.contentString.location;
        reqParams.cli['--location'] = jsonRequestBody.contentString.location;
        reqParams.boto3['Format'] = jsonRequestBody.contentString.format;
        reqParams.cli['--format'] = jsonRequestBody.contentString.format;
        reqParams.boto3['Activate'] = jsonRequestBody.contentString.activate;
        reqParams.cli['--activate'] = jsonRequestBody.contentString.activate;

        reqParams.cfn['DetectorId'] = jsonRequestBody.path;
        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;
        reqParams.cfn['Location'] = jsonRequestBody.contentString.location;
        reqParams.cfn['Format'] = jsonRequestBody.contentString.format;
        reqParams.cfn['Activate'] = jsonRequestBody.contentString.activate;

        reqParams.tf['detector_id'] = jsonRequestBody.path;
        reqParams.tf['name'] = jsonRequestBody.contentString.name;
        reqParams.tf['location'] = jsonRequestBody.contentString.location;
        reqParams.tf['format'] = jsonRequestBody.contentString.format;
        reqParams.tf['activate'] = jsonRequestBody.contentString.activate;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'CreateIPSet',
                'boto3': 'create_ip_set',
                'cli': 'create-ip-set'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('guardduty', details.requestId),
            'region': region,
            'service': 'guardduty',
            'type': 'AWS::GuardDuty::IPSet',
            'terraformType': 'aws_guardduty_ipset',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.ListIPSets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "ListIPSets" && jsonRequestBody.method == "GET") {
        reqParams.boto3['DetectorId'] =jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['MaxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.params.maxResults;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'ListIPSets',
                'boto3': 'list_ip_sets',
                'cli': 'list-ip-sets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.GetIPSet
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "GetIPSet" && jsonRequestBody.method == "GET") {
        reqParams.boto3['IpSetId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--ip-set-id'] = jsonRequestBody.path.split("/")[4];
        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'GetIPSet',
                'boto3': 'get_ip_set',
                'cli': 'get-ip-set'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.UpdateIPSet
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "UpdateIPSet" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:guardduty:*:*:detector/" + jsonRequestBody.path.split("/")[2] + "/ipset/" + jsonRequestBody.path.split("/")[4]
        ];

        reqParams.boto3['IpSetId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--ip-set-id'] = jsonRequestBody.path.split("/")[4];
        reqParams.boto3['DetectorId'] =jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['Activate'] = jsonRequestBody.contentString.activate;
        reqParams.cli['--activate'] = jsonRequestBody.contentString.activate;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'UpdateIPSet',
                'boto3': 'update_ip_set',
                'cli': 'update-ip-set'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.ArchiveFindings
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "ArchiveFindings" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:guardduty:*:*:detector/" + jsonRequestBody.path.split("/")[2]
        ];

        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['FindingIds'] = jsonRequestBody.contentString.findingIds;
        reqParams.cli['--finding-ids'] = jsonRequestBody.contentString.findingIds;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'ArchiveFindings',
                'boto3': 'archive_findings',
                'cli': 'archive-findings'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.UnarchiveFindings
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "UnarchiveFindings" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:guardduty:*:*:detector/" + jsonRequestBody.path.split("/")[2]
        ];

        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['FindingIds'] = jsonRequestBody.contentString.findingIds;
        reqParams.cli['--finding-ids'] = jsonRequestBody.contentString.findingIds;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'UnarchiveFindings',
                'boto3': 'unarchive_findings',
                'cli': 'unarchive-findings'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.GetFindings
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "GetFindings" && jsonRequestBody.method == "POST") {
        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['FindingIds'] = jsonRequestBody.contentString.findingIds;
        reqParams.cli['--finding-ids'] = jsonRequestBody.contentString.findingIds;
        reqParams.boto3['SortCriteria'] = jsonRequestBody.contentString.sortCriteria;
        reqParams.cli['--sort-criteria'] = jsonRequestBody.contentString.sortCriteria;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'GetFindings',
                'boto3': 'get_findings',
                'cli': 'get-findings'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:iam.ListAttachedRolePolicies
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/iam$/g) && jsonRequestBody.operation == "ListAttachedRolePolicies" && jsonRequestBody.method == "POST") {
        reqParams.boto3['RoleName'] = jsonRequestBody.contentString.match(/RoleName\=(.+)\&Version/g)[1];;
        reqParams.cli['--role-name'] = jsonRequestBody.contentString.match(/RoleName\=(.+)\&Version/g)[1];;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListAttachedRolePolicies',
                'boto3': 'list_attached_role_policies',
                'cli': 'list-attached-role-policies'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:guardduty:guardduty.CreateSampleFindings
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "CreateSampleFindings" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:guardduty:*:*:detector/" + jsonRequestBody.path.split("/")[2]
        ];

        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'CreateSampleFindings',
                'boto3': 'create_sample_findings',
                'cli': 'create-sample-findings'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:guardduty:guardduty.UpdateDetector
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/guardduty\/api\/guardduty$/g) && jsonRequestBody.operation == "UpdateDetector" && jsonRequestBody.method == "POST") {
        reqParams.iam['Resource'] = [
            "arn:aws:guardduty:*:*:detector/" + jsonRequestBody.path.split("/")[2]
        ];

        reqParams.boto3['DetectorId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--detector-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['Enable'] = jsonRequestBody.contentString.enable;
        reqParams.cli['--enable'] = jsonRequestBody.contentString.enable;
        reqParams.boto3['FindingPublishingFrequency'] = jsonRequestBody.contentString.findingPublishingFrequency;
        reqParams.cli['--finding-publishing-frequency'] = jsonRequestBody.contentString.findingPublishingFrequency;

        outputs.push({
            'region': region,
            'service': 'guardduty',
            'method': {
                'api': 'UpdateDetector',
                'boto3': 'update_detector',
                'cli': 'update-detector'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:efs:efs.CreateTags
    // autogen:efs:efs.DeleteTags
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?/g) && getUrlValue(details.url, 'type') == "modifyTags") {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticfilesystem:*:*:file-system/" + jsonRequestBody.fileSystemId
        ];

        reqParams.boto3['FileSystemId'] = jsonRequestBody.fileSystemId;
        reqParams.cli['--file-system-id'] = jsonRequestBody.fileSystemId;
        if (jsonRequestBody.addTags) {
            reqParams.boto3['Tags'] = jsonRequestBody.addTags;
            reqParams.cli['--tags'] = jsonRequestBody.addTags;

            outputs.push({
                'region': region,
                'service': 'efs',
                'method': {
                    'api': 'CreateTags',
                    'boto3': 'create_tags',
                    'cli': 'create-tags'
                },
                'options': reqParams,
            'requestDetails': details
            });
        }
        if (jsonRequestBody.removeKeys) {
            reqParams.boto3['TagKeys'] = jsonRequestBody.removeKeys;
            reqParams.cli['--tag-keys'] = jsonRequestBody.removeKeys;

            outputs.push({
                'region': region,
                'service': 'efs',
                'method': {
                    'api': 'DeleteTags',
                    'boto3': 'delete_tags',
                    'cli': 'delete-tags'
                },
                'options': reqParams,
            'requestDetails': details
            });
        }

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:efs:efs.ModifyMountTargetSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/efs\/ajax\/api\?/g) && getUrlValue(details.url, 'type') == "modifySecurityGroups") {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticfilesystem:*:*:file-system/" + jsonRequestBody.fileSystemId
        ];

        reqParams.boto3['MountTargetId'] = jsonRequestBody.mountTargetId;
        reqParams.cli['--mount-target-id'] = jsonRequestBody.mountTargetId;
        reqParams.boto3['SecurityGroups'] = jsonRequestBody.securityGroups;
        reqParams.cli['--security-groups'] = jsonRequestBody.securityGroups;

        outputs.push({
            'region': region,
            'service': 'efs',
            'method': {
                'api': 'ModifyMountTargetSecurityGroups',
                'boto3': 'modify_mount_target_security_groups',
                'cli': 'modify-mount-target-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:mq:mq.ListBrokers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/mq$/g) && jsonRequestBody.path == "/brokers" && jsonRequestBody.method == "GET") {
        reqParams.boto3['MaxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.params.maxResults;

        outputs.push({
            'region': region,
            'service': 'mq',
            'method': {
                'api': 'ListBrokers',
                'boto3': 'list_brokers',
                'cli': 'list-brokers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:mq:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/ec2$/g) && jsonRequestBody.params.Action == "DescribeVpcs") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:mq:mq.ListConfigurations
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/mq$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path == "/configurations") {
        reqParams.boto3['MaxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.params.maxResults;
        reqParams.boto3['NextToken'] = jsonRequestBody.params.nextToken;
        reqParams.cli['--next-token'] = jsonRequestBody.params.nextToken;

        outputs.push({
            'region': region,
            'service': 'mq',
            'method': {
                'api': 'ListConfigurations',
                'boto3': 'list_configurations',
                'cli': 'list-configurations'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:mq:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/ec2$/g) && jsonRequestBody.params.Action == "DescribeSubnets") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:mq:ec2.DescribeSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/ec2$/g) && jsonRequestBody.params.Action == "DescribeSecurityGroups") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSecurityGroups',
                'boto3': 'describe_security_groups',
                'cli': 'describe-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:mq:mq.CreateBroker
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/mq$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path == "/brokers") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['BrokerName'] = jsonRequestBody.contentString.brokerName;
        reqParams.cli['--broker-name'] = jsonRequestBody.contentString.brokerName;
        reqParams.boto3['EngineType'] = jsonRequestBody.contentString.engineType;
        reqParams.cli['--engine-type'] = jsonRequestBody.contentString.engineType;
        reqParams.boto3['EngineVersion'] = jsonRequestBody.contentString.engineVersion;
        reqParams.cli['--engine-version'] = jsonRequestBody.contentString.engineVersion;
        reqParams.boto3['HostInstanceType'] = jsonRequestBody.contentString.hostInstanceType;
        reqParams.cli['--host-instance-type'] = jsonRequestBody.contentString.hostInstanceType;
        reqParams.boto3['DeploymentMode'] = jsonRequestBody.contentString.deploymentMode;
        reqParams.cli['--deployment-mode'] = jsonRequestBody.contentString.deploymentMode;
        reqParams.boto3['SecurityGroups'] = jsonRequestBody.contentString.securityGroups;
        reqParams.cli['--security-groups'] = jsonRequestBody.contentString.securityGroups;
        reqParams.boto3['SubnetIds'] = jsonRequestBody.contentString.subnetIds;
        reqParams.cli['--subnet-ids'] = jsonRequestBody.contentString.subnetIds;
        reqParams.boto3['PubliclyAccessible'] = jsonRequestBody.contentString.publiclyAccessible;
        reqParams.cli['--publicly-accessible'] = jsonRequestBody.contentString.publiclyAccessible;
        reqParams.boto3['AutoMinorVersionUpgrade'] = jsonRequestBody.contentString.autoMinorVersionUpgrade;
        reqParams.cli['--auto-minor-version-upgrade'] = jsonRequestBody.contentString.autoMinorVersionUpgrade;
        reqParams.boto3['Users'] = jsonRequestBody.contentString.users;
        reqParams.cli['--users'] = jsonRequestBody.contentString.users;
        reqParams.boto3['Configuration'] = jsonRequestBody.contentString.configuration;
        reqParams.cli['--configuration'] = jsonRequestBody.contentString.configuration;
        reqParams.boto3['Logs'] = jsonRequestBody.contentString.logs;
        reqParams.cli['--logs'] = jsonRequestBody.contentString.logs;

        reqParams.cfn['BrokerName'] = jsonRequestBody.contentString.brokerName;
        reqParams.cfn['EngineType'] = jsonRequestBody.contentString.engineType;
        reqParams.cfn['EngineVersion'] = jsonRequestBody.contentString.engineVersion;
        reqParams.cfn['HostInstanceType'] = jsonRequestBody.contentString.hostInstanceType;
        reqParams.cfn['DeploymentMode'] = jsonRequestBody.contentString.deploymentMode;
        reqParams.cfn['SecurityGroups'] = jsonRequestBody.contentString.securityGroups;
        reqParams.cfn['SubnetIds'] = jsonRequestBody.contentString.subnetIds;
        reqParams.cfn['PubliclyAccessible'] = jsonRequestBody.contentString.publiclyAccessible;
        reqParams.cfn['AutoMinorVersionUpgrade'] = jsonRequestBody.contentString.autoMinorVersionUpgrade;
        reqParams.cfn['Configuration'] = jsonRequestBody.contentString.configuration;
        reqParams.cfn['Logs'] = jsonRequestBody.contentString.logs;

        reqParams.tf['broker_name'] = jsonRequestBody.contentString.brokerName;
        reqParams.tf['engine_type'] = jsonRequestBody.contentString.engineType;
        reqParams.tf['engine_version'] = jsonRequestBody.contentString.engineVersion;
        reqParams.tf['host_instance_type'] = jsonRequestBody.contentString.hostInstanceType;
        reqParams.tf['deployment_mode'] = jsonRequestBody.contentString.deploymentMode;
        reqParams.tf['security_groups'] = jsonRequestBody.contentString.securityGroups;
        reqParams.tf['subnet_ids'] = jsonRequestBody.contentString.subnetIds;
        reqParams.tf['publicly_accessible'] = jsonRequestBody.contentString.publiclyAccessible;
        reqParams.tf['auto_minor_version_upgrade'] = jsonRequestBody.contentString.autoMinorVersionUpgrade;
        reqParams.tf['configuration'] = jsonRequestBody.contentString.configuration;

        if (jsonRequestBody.contentString.users) {
            reqParams.cfn['Users'] = [];
            reqParams.tf['users'] = [];
            for (var i=0; i<jsonRequestBody.contentString.users.length; i++) {
                reqParams.cfn['Users'].push({
                    'ConsoleAccess': jsonRequestBody.contentString.users[i].consoleAccess,
                    'Groups': jsonRequestBody.contentString.users[i].groups,
                    'Password': jsonRequestBody.contentString.users[i].password,
                    'Username': jsonRequestBody.contentString.users[i].username
                });
                reqParams.tf['users'].push({
                    'console_access': jsonRequestBody.contentString.users[i].consoleAccess,
                    'groups': jsonRequestBody.contentString.users[i].groups,
                    'password': jsonRequestBody.contentString.users[i].password,
                    'username': jsonRequestBody.contentString.users[i].username
                });
            }
        }
        if (jsonRequestBody.contentString.logs) {
            reqParams.cfn['Logs'] = {
                'General': jsonRequestBody.contentString.logs.general,
                'Audit': jsonRequestBody.contentString.logs.audit
            };
            reqParams.tf['logs'] = jsonRequestBody.contentString.logs;
        }
        if (jsonRequestBody.contentString.maintenanceWindowStartTime) {
            reqParams.tf['maintenance_window_start_time'] = {
                'day_of_week': jsonRequestBody.contentString.maintenanceWindowStartTime.dayOfWeek,
                'time_of_day': jsonRequestBody.contentString.maintenanceWindowStartTime.timeOfDay,
                'time_zone': jsonRequestBody.contentString.maintenanceWindowStartTime.timeZone
            };
            reqParams.cfn['MaintenanceWindowStartTime'] = {
                'DayOfWeek': jsonRequestBody.contentString.maintenanceWindowStartTime.dayOfWeek,
                'TimeOfDay': jsonRequestBody.contentString.maintenanceWindowStartTime.timeOfDay,
                'TimeZone': jsonRequestBody.contentString.maintenanceWindowStartTime.timeZone
            };
            reqParams.boto3['MaintenanceWindowStartTime'] = {
                'DayOfWeek': jsonRequestBody.contentString.maintenanceWindowStartTime.dayOfWeek,
                'TimeOfDay': jsonRequestBody.contentString.maintenanceWindowStartTime.timeOfDay,
                'TimeZone': jsonRequestBody.contentString.maintenanceWindowStartTime.timeZone
            };
            reqParams.cli['--maintenance-window-start-time'] = {
                'DayOfWeek': jsonRequestBody.contentString.maintenanceWindowStartTime.dayOfWeek,
                'TimeOfDay': jsonRequestBody.contentString.maintenanceWindowStartTime.timeOfDay,
                'TimeZone': jsonRequestBody.contentString.maintenanceWindowStartTime.timeZone
            };
        }

        outputs.push({
            'region': region,
            'service': 'mq',
            'method': {
                'api': 'CreateBroker',
                'boto3': 'create_broker',
                'cli': 'create-broker'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('mq', details.requestId),
            'region': region,
            'service': 'mq',
            'type': 'AWS::AmazonMQ::Broker',
            'terraformType': 'aws_mq_broker',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:mq:mq.CreateConfiguration
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/mq$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path == "/configurations") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['EngineType'] = jsonRequestBody.contentString.engineType;
        reqParams.cli['--engine-type'] = jsonRequestBody.contentString.engineType;
        reqParams.boto3['EngineVersion'] = jsonRequestBody.contentString.engineVersion;
        reqParams.cli['--engine-version'] = jsonRequestBody.contentString.engineVersion;

        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;
        reqParams.cfn['EngineType'] = jsonRequestBody.contentString.engineType;
        reqParams.cfn['EngineVersion'] = jsonRequestBody.contentString.engineVersion;

        reqParams.tf['name'] = jsonRequestBody.contentString.name;
        reqParams.tf['engine_type'] = jsonRequestBody.contentString.engineType;
        reqParams.tf['engine_version'] = jsonRequestBody.contentString.engineVersion;

        outputs.push({
            'region': region,
            'service': 'mq',
            'method': {
                'api': 'CreateConfiguration',
                'boto3': 'create_configuration',
                'cli': 'create-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('mq', details.requestId),
            'region': region,
            'service': 'mq',
            'type': 'AWS::AmazonMQ::Configuration',
            'terraformType': 'aws_mq_configuration',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:mq:mq.DescribeConfiguration
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/mq$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path.match(/\/configurations\/.+/g)) {
        reqParams.boto3['ConfigurationId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--configuration-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'mq',
            'method': {
                'api': 'DescribeConfiguration',
                'boto3': 'describe_configuration',
                'cli': 'describe-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:mq:mq.DescribeConfigurationRevision
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/amazon-mq\/api\/mq$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path.match(/\/configurations\/.+\/revisions\/.+/g)) {
        reqParams.boto3['ConfigurationId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--configuration-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['ConfigurationRevision'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--configuration-revision'] = jsonRequestBody.path.split("/")[4];

        outputs.push({
            'region': region,
            'service': 'mq',
            'method': {
                'api': 'DescribeConfigurationRevision',
                'boto3': 'describe_configuration_revision',
                'cli': 'describe-configuration-revision'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeLaunchTemplateVersions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeLaunchTemplateVersions\?/g)) {
        reqParams.boto3['LaunchTemplateId'] = jsonRequestBody.LaunchTemplateId;
        reqParams.cli['--launch-template-id'] = jsonRequestBody.LaunchTemplateId;
        reqParams.boto3['MaxResults'] = jsonRequestBody.MaxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxResults;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeLaunchTemplateVersions',
                'boto3': 'describe_launch_template_versions',
                'cli': 'describe-launch-template-versions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeKeyPairs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeKeyPairs\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeKeyPairs',
                'boto3': 'describe_key_pairs',
                'cli': 'describe-key-pairs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeAvailabilityZones
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeAvailabilityZones\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeAvailabilityZones',
                'boto3': 'describe_availability_zones',
                'cli': 'describe-availability-zones'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeHosts
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeHosts\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeHosts',
                'boto3': 'describe_hosts',
                'cli': 'describe-hosts'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeSecurityGroups\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSecurityGroups',
                'boto3': 'describe_security_groups',
                'cli': 'describe-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeSnapshots
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getSnapshotsAutoUpdate\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSnapshots',
                'boto3': 'describe_snapshots',
                'cli': 'describe-snapshots'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVolumes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getMergedVolumesAutoUpdate\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVolumes',
                'boto3': 'describe_volumes',
                'cli': 'describe-volumes'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeTags
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getTagsAutoUpdate\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeTags',
                'boto3': 'describe_tags',
                'cli': 'describe-tags'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.CreateLaunchTemplate
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateLaunchTemplate\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['LaunchTemplateName'] = jsonRequestBody.LaunchTemplateName;
        reqParams.cli['--launch-template-name'] = jsonRequestBody.LaunchTemplateName;
        reqParams.boto3['VersionDescription'] = jsonRequestBody.VersionDescription;
        reqParams.cli['--version-description'] = jsonRequestBody.VersionDescription;
        reqParams.boto3['LaunchTemplateData'] = jsonRequestBody.LaunchTemplateData;
        reqParams.cli['--launch-template-data'] = jsonRequestBody.LaunchTemplateData;
        reqParams.boto3['ClientToken'] = jsonRequestBody.ClientToken;
        reqParams.cli['--client-token'] = jsonRequestBody.ClientToken;

        reqParams.cfn['LaunchTemplateName'] = jsonRequestBody.LaunchTemplateName;
        reqParams.cfn['LaunchTemplateData'] = jsonRequestBody.LaunchTemplateData;

        reqParams.tf['name'] = jsonRequestBody.LaunchTemplateName;
        reqParams.tf['description'] = jsonRequestBody.VersionDescription;
        reqParams.tf['arn'] = jsonRequestBody.LaunchTemplateData.ImageId;
        reqParams.tf['instance_type'] = jsonRequestBody.LaunchTemplateData.InstanceType;
        reqParams.tf['key_name'] = jsonRequestBody.LaunchTemplateData.KeyName;
        reqParams.tf['vpc_security_group_ids'] = jsonRequestBody.LaunchTemplateData.SecurityGroupIds;
        reqParams.tf['security_group_names'] = jsonRequestBody.LaunchTemplateData.SecurityGroups;
        reqParams.tf['instance_initiated_shutdown_behavior'] = jsonRequestBody.LaunchTemplateData.InstanceInitiatedShutdownBehavior;
        reqParams.tf['disable_api_termination'] = jsonRequestBody.LaunchTemplateData.DisableApiTermination;

        if (jsonRequestBody.Placement && jsonRequestBody.Placement.Tenancy) {
            reqParams.tf['tenancy'] = jsonRequestBody.Placement.Tenancy;
        }

        if (jsonRequestBody.Monitoring) {
            reqParams.tf['monitoring'] = {
                'enabled': jsonRequestBody.Monitoring.Enabled
            };
        }

        if (jsonRequestBody.LaunchTemplateData.NetworkInterfaces) {
            reqParams.tf['network_interfaces'] = [];
            for (var i=0; i<jsonRequestBody.LaunchTemplateData.NetworkInterfaces.length; i++) {
                reqParams.tf['network_interfaces'].push({
                    'device_index': jsonRequestBody.LaunchTemplateData.NetworkInterfaces[i].DeviceIndex,
                    'description': jsonRequestBody.LaunchTemplateData.NetworkInterfaces[i].Description,
                    'private_ip_address': jsonRequestBody.LaunchTemplateData.NetworkInterfaces[i].PrivateIpAddresses,
                    'associate_public_ip_address': jsonRequestBody.LaunchTemplateData.NetworkInterfaces[i].AssociatePublicIpAddress
                });
            }
        }
        if (jsonRequestBody.LaunchTemplateData.BlockDeviceMappings) {
            reqParams.tf['block_device_mappings'] = [];
            for (var i=0; i<jsonRequestBody.LaunchTemplateData.BlockDeviceMappings.length; i++) {
                reqParams.tf['block_device_mappings'].push({
                    'device_index': jsonRequestBody.LaunchTemplateData.BlockDeviceMappings[i].DeviceIndex,
                    'description': jsonRequestBody.LaunchTemplateData.BlockDeviceMappings[i].Description,
                    'private_ip_address': jsonRequestBody.LaunchTemplateData.BlockDeviceMappings[i].PrivateIpAddresses,
                    'associate_public_ip_address': jsonRequestBody.LaunchTemplateData.BlockDeviceMappings[i].AssociatePublicIpAddress
                });
            }
        }
        if (jsonRequestBody.LaunchTemplateData.ElasticGpuSpecifications) {
            reqParams.tf['elastic_gpu_specifications'] = [];
            for (var i=0; i<jsonRequestBody.LaunchTemplateData.ElasticGpuSpecifications.length; i++) {
                reqParams.tf['elastic_gpu_specifications'].push({
                    'type': jsonRequestBody.LaunchTemplateData.ElasticGpuSpecifications[i].Type
                });
            }
        }

        if (jsonRequestBody.CreditSpecification) {
            reqParams.tf['credit_specification'] = {
                'cpu_credits': jsonRequestBody.CreditSpecification.CpuCredits
            }
        }

        if (jsonRequestBody.TagSpecifications) {
            reqParams.tf['tags'] = {};
            for (var i=0; i<jsonRequestBody.TagSpecifications.length; i++) {
                if (jsonRequestBody.TagSpecifications[i].ResourceType == "instance") {
                    for (var j=0; j<jsonRequestBody.TagSpecifications[i].Tag.length; j++) {
                        reqParams.tf['tags'][jsonRequestBody.TagSpecifications[i].Tag[j].Key] = jsonRequestBody.TagSpecifications[i].Tag[j].Value;
                    }
                }
            }
        }
        reqParams.tf['ebs_optimized'] = jsonRequestBody.EbsOptimized;

        for (var i=0; i<jsonRequestBody.BlockDeviceMappings.length; i++) {
            if (jsonRequestBody.BlockDeviceMappings[i].DeviceName == "/dev/sda1" || jsonRequestBody.BlockDeviceMappings[i].DeviceName == "/dev/xvda") {
                if (jsonRequestBody.BlockDeviceMappings[i].Ebs) {
                    reqParams.tf['root_block_device'] = {
                        'volume_type': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeType,
                        'volume_size': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeSize,
                        'delete_on_termination': jsonRequestBody.BlockDeviceMappings[i].Ebs.DeleteOnTermination
                    };
                }
            } else if (jsonRequestBody.BlockDeviceMappings[i].Ebs) {
                reqParams.tf['ebs_block_device'] = {
                    'device_name': jsonRequestBody.BlockDeviceMappings[i].DeviceName,
                    'volume_type': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeType,
                    'volume_size': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeSize,
                    'delete_on_termination': jsonRequestBody.BlockDeviceMappings[i].Ebs.DeleteOnTermination,
                    'iops': jsonRequestBody.BlockDeviceMappings[i].Ebs.Iops,
                    'snapshot_id': jsonRequestBody.BlockDeviceMappings[i].Ebs.SnapshotId
                };
            }
        }

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateLaunchTemplate',
                'boto3': 'create_launch_template',
                'cli': 'create-launch-template'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::LaunchTemplate',
            'terraformType': 'aws_launch_template',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateTags
    // autogen:ec2:ec2.DeleteTags
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=updateTags\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        if (jsonRequestBody.addTags) {
            reqParams.boto3['Tags'] = jsonRequestBody.addTags;
            reqParams.cli['--tags'] = jsonRequestBody.addTags;

            outputs.push({
                'region': region,
                'service': 'ec2',
                'method': {
                    'api': 'CreateTags',
                    'boto3': 'create_tags',
                    'cli': 'create-tags'
                },
                'options': reqParams,
            'requestDetails': details
            });
        }
        if (jsonRequestBody.removeKeys) {
            reqParams.boto3['TagKeys'] = jsonRequestBody.removeKeys;
            reqParams.cli['--tag-keys'] = jsonRequestBody.removeKeys;

            outputs.push({
                'region': region,
                'service': 'ec2',
                'method': {
                    'api': 'DeleteTags',
                    'boto3': 'delete_tags',
                    'cli': 'delete-tags'
                },
                'options': reqParams,
            'requestDetails': details
            });
        }

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateKeyPair
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=createKeyPair\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['KeyName'] = jsonRequestBody.keyName;
        reqParams.cli['--key-name'] = jsonRequestBody.keyName;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateKeyPair',
                'boto3': 'create_key_pair',
                'cli': 'create-key-pair'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteKeyPair
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=deleteKeyPair\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['KeyName'] = jsonRequestBody.keyName;
        reqParams.cli['--key-name'] = jsonRequestBody.keyName;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteKeyPair',
                'boto3': 'delete_key_pair',
                'cli': 'delete-key-pair'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.ImportKeyPair
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=importKeyPair\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['KeyName'] = jsonRequestBody.keyName;
        reqParams.cli['--key-name'] = jsonRequestBody.keyName;
        reqParams.boto3['PublicKeyMaterial'] = jsonRequestBody.publicKeyMaterial;
        reqParams.cli['--public-key-material'] = jsonRequestBody.publicKeyMaterial;

        reqParams.tf['key_name'] = jsonRequestBody.keyName;
        reqParams.tf['public_key'] = jsonRequestBody.publicKeyMaterial;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'ImportKeyPair',
                'boto3': 'import_key_pair',
                'cli': 'import-key-pair'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'terraformType': 'aws_key_pair',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateNetworkInterface
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateNetworkInterface\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Description'] = jsonRequestBody.description;
        reqParams.cli['--description'] = jsonRequestBody.description;
        reqParams.boto3['Groups'] = jsonRequestBody.groups;
        reqParams.cli['--groups'] = jsonRequestBody.groups;
        reqParams.boto3['SubnetId'] = jsonRequestBody.subnetId;
        reqParams.cli['--subnet-id'] = jsonRequestBody.subnetId;

        reqParams.boto3['Description'] = jsonRequestBody.description;
        reqParams.boto3['GroupSet'] = jsonRequestBody.groups;
        reqParams.boto3['SubnetId'] = jsonRequestBody.subnetId;

        reqParams.tf['description'] = jsonRequestBody.description;
        reqParams.tf['security_groups'] = jsonRequestBody.groups;
        reqParams.tf['subnet_id'] = jsonRequestBody.subnetId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateNetworkInterface',
                'boto3': 'create_network_interface',
                'cli': 'create-network-interface'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::NetworkInterface',
            'terraformType': 'aws_network_interface',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeFlowLogs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getSdkResources_FlowLog\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeFlowLogs',
                'boto3': 'describe_flow_logs',
                'cli': 'describe-flow-logs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DeleteNetworkInterface
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=deleteNetworkInterface\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['NetworkInterfaceId'] = jsonRequestBody.networkInterfaceId;
        reqParams.cli['--network-interface-id'] = jsonRequestBody.networkInterfaceId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteNetworkInterface',
                'boto3': 'delete_network_interface',
                'cli': 'delete-network-interface'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeAddresses
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeAddresses\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeAddresses',
                'boto3': 'describe_addresses',
                'cli': 'describe-addresses'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.AllocateAddress
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.AllocateAddress\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Domain'] = jsonRequestBody.Domain;
        reqParams.cli['--domain'] = jsonRequestBody.Domain;

        reqParams.cfn['Domain'] = jsonRequestBody.Domain;

        reqParams.tf['vpc'] = true;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'AllocateAddress',
                'boto3': 'allocate_address',
                'cli': 'allocate-address'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::EIP',
            'terraformType': 'aws_eip',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.AllocateAddress
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.AllocateAddress\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Domain'] = jsonRequestBody.Domain;
        reqParams.cli['--domain'] = jsonRequestBody.Domain;

        reqParams.cfn['Domain'] = jsonRequestBody.Domain;

        reqParams.tf['vpc'] = true;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'AllocateAddress',
                'boto3': 'allocate_address',
                'cli': 'allocate-address'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::EIP',
            'terraformType': 'aws_eip',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeInstances
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeInstances\?/g)) {
        reqParams.boto3['Filters'] = jsonRequestBody.filters;
        reqParams.cli['--filters'] = jsonRequestBody.filters;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeInstances',
                'boto3': 'describe_instances',
                'cli': 'describe-instances'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeNetworkInterfaces
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeNetworkInterfaces\?/g)) {
        reqParams.boto3['Filters'] = jsonRequestBody.filters;
        reqParams.cli['--filters'] = jsonRequestBody.filters;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeNetworkInterfaces',
                'boto3': 'describe_network_interfaces',
                'cli': 'describe-network-interfaces'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.AssociateAddress
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.AssociateAddress\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['AllocationId'] = jsonRequestBody.AllocationId;
        reqParams.cli['--allocation-id'] = jsonRequestBody.AllocationId;
        reqParams.boto3['InstanceId'] = jsonRequestBody.InstanceId;
        reqParams.cli['--instance-id'] = jsonRequestBody.InstanceId;
        reqParams.boto3['AllowReassociation'] = jsonRequestBody.allowReassociation;
        reqParams.cli['--allow-reassociation'] = jsonRequestBody.allowReassociation;
        reqParams.boto3['PrivateIpAddress'] = jsonRequestBody.PrivateIpAddress;
        reqParams.cli['--private-ip-address'] = jsonRequestBody.PrivateIpAddress;

        reqParams.cfn['AllocationId'] = jsonRequestBody.AllocationId;
        reqParams.cfn['InstanceId'] = jsonRequestBody.InstanceId;
        reqParams.cfn['PrivateIpAddress'] = jsonRequestBody.PrivateIpAddress;

        reqParams.tf['allocation_id'] = jsonRequestBody.AllocationId;
        reqParams.tf['instance_id'] = jsonRequestBody.InstanceId;
        reqParams.tf['private_ip_address'] = jsonRequestBody.PrivateIpAddress;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'AssociateAddress',
                'boto3': 'associate_address',
                'cli': 'associate-address'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::EIPAssociation',
            'terraformType': 'aws_eip_association',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DisassociateAddress
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DisassociateAddress\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['AssociationId'] = jsonRequestBody.AssociationId;
        reqParams.cli['--association-id'] = jsonRequestBody.AssociationId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DisassociateAddress',
                'boto3': 'disassociate_address',
                'cli': 'disassociate-address'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.ReleaseAddress
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.ReleaseAddress\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['AllocationId'] = jsonRequestBody.AllocationId;
        reqParams.cli['--allocation-id'] = jsonRequestBody.AllocationId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'ReleaseAddress',
                'boto3': 'release_address',
                'cli': 'release-address'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:config.DescribeConfigurationRecorders
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.config\.AmazonConfig\.DescribeConfigurationRecorders\?/g)) {

        outputs.push({
            'region': region,
            'service': 'config',
            'method': {
                'api': 'DescribeConfigurationRecorders',
                'boto3': 'describe_configuration_recorders',
                'cli': 'describe-configuration-recorders'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.AllocateHosts
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.AllocateHosts\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['InstanceType'] = jsonRequestBody.instanceType;
        reqParams.cli['--instance-type'] = jsonRequestBody.instanceType;
        reqParams.boto3['AvailabilityZone'] = jsonRequestBody.availabilityZone;
        reqParams.cli['--availability-zone'] = jsonRequestBody.availabilityZone;
        reqParams.boto3['AutoPlacement'] = jsonRequestBody.autoPlacement;
        reqParams.cli['--auto-placement'] = jsonRequestBody.autoPlacement;
        reqParams.boto3['Quantity'] = jsonRequestBody.quantity;
        reqParams.cli['--quantity'] = jsonRequestBody.quantity;
        reqParams.boto3['TagSpecifications'] = jsonRequestBody.TagSpecification;
        reqParams.cli['--tag-specifications'] = jsonRequestBody.TagSpecification;

        reqParams.cfn['InstanceType'] = jsonRequestBody.instanceType;
        reqParams.cfn['AvailabilityZone'] = jsonRequestBody.availabilityZone;
        reqParams.cfn['AutoPlacement'] = jsonRequestBody.autoPlacement;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'AllocateHosts',
                'boto3': 'allocate_hosts',
                'cli': 'allocate-hosts'
            },
            'options': reqParams,
            'requestDetails': details
        });

        for (var i=0; i<jsonRequestBody.quantity; i++) {
            tracked_resources.push({
                'logicalId': getResourceName('ec2', details.requestId),
                'region': region,
                'service': 'ec2',
                'type': 'AWS::EC2::Host',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });
        }

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeRegions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService" && gwtRequest['method'] == "getRegions") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeRegions',
                'boto3': 'describe_regions',
                'cli': 'describe-regions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeAccountAttributes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeAccountAttributes\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeAccountAttributes',
                'boto3': 'describe_account_attributes',
                'cli': 'describe-account-attributes'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeDhcpOptions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getDHCPOptions" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeDhcpOptions',
                'boto3': 'describe_dhcp_options',
                'cli': 'describe-dhcp-options'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcAttribute
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService" && gwtRequest['method'] == "getVpcAttributes") {
        reqParams.boto3['VpcId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--vpc-id'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcAttribute',
                'boto3': 'describe_vpc_attribute',
                'cli': 'describe-vpc-attribute'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeFlowLogs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=getSdkResources_FlowLog\?/g) && jsonRequestBody.methodName == "describeFlowLogs" && jsonRequestBody.clientType == "com.amazonaws.services.ec2.AmazonEC2Client") {
        reqParams.boto3['Filter'] = jsonRequestBody.filters;
        reqParams.cli['--filter'] = jsonRequestBody.filters;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeFlowLogs',
                'boto3': 'describe_flow_logs',
                'cli': 'describe-flow-logs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2ux\.elasticconsole\.generated\.ElasticConsoleBackendGenerated\.MergedDescribeSubnets\?/g) && gwtRequest['method'] == "getVpcs") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeRouteTables
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService" && gwtRequest['method'] == "getRouteTables") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeRouteTables',
                'boto3': 'describe_route_tables',
                'cli': 'describe-route-tables'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeInternetGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.elasticconsole\.backend\.master\.ElasticConsoleBackendService\.GetMergedResources\?/g) && jsonRequestBody.operation == "DescribeInternetGateways" && jsonRequestBody.service == "com.amazonaws.ec2.AmazonEC2") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeInternetGateways',
                'boto3': 'describe_internet_gateways',
                'cli': 'describe-internet-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeEgressOnlyInternetGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.elasticconsole\.backend\.master\.ElasticConsoleBackendService\.GetMergedResources\?/g) && jsonRequestBody.service == "com.amazonaws.ec2.AmazonEC2" && jsonRequestBody.operation == "DescribeEgressOnlyInternetGateways") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeEgressOnlyInternetGateways',
                'boto3': 'describe_egress_only_internet_gateways',
                'cli': 'describe-egress-only-internet-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeDhcpOptions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getDHCPOptions" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeDhcpOptions',
                'boto3': 'describe_dhcp_options',
                'cli': 'describe-dhcp-options'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeAddresses
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeAddresses\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeAddresses',
                'boto3': 'describe_addresses',
                'cli': 'describe-addresses'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcEndpoints
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2ux\.elasticconsole\.generated\.ElasticConsoleBackendGenerated\.MergedDescribeVpcEndpoints\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcEndpoints',
                'boto3': 'describe_vpc_endpoints',
                'cli': 'describe-vpc-endpoints'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcEndpointServiceConfigurations
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeVpcEndpointServiceConfigurations\?/g)) {
        reqParams.boto3['MaxResults'] = jsonRequestBody.MaxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxResults;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcEndpointServiceConfigurations',
                'boto3': 'describe_vpc_endpoint_service_configurations',
                'cli': 'describe-vpc-endpoint-service-configurations'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeNatGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2ux\.elasticconsole\.generated\.ElasticConsoleBackendGenerated\.MergedDescribeNatGateways\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeNatGateways',
                'boto3': 'describe_nat_gateways',
                'cli': 'describe-nat-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeAccountAttributes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeAccountAttributes\?/g)) {
        reqParams.boto3['AttributeNames'] = jsonRequestBody.attributeNames;
        reqParams.cli['--attribute-names'] = jsonRequestBody.attributeNames;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeAccountAttributes',
                'boto3': 'describe_account_attributes',
                'cli': 'describe-account-attributes'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcPeeringConnections
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.elasticconsole\.backend\.master\.ElasticConsoleBackendService\.GetMergedResources\?/g) && jsonRequestBody.operation == "DescribeVpcPeeringConnections" && jsonRequestBody.service == "com.amazonaws.ec2.AmazonEC2") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcPeeringConnections',
                'boto3': 'describe_vpc_peering_connections',
                'cli': 'describe-vpc-peering-connections'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeNetworkAcls
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getNetworkACLs" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeNetworkAcls',
                'boto3': 'describe_network_acls',
                'cli': 'describe-network-acls'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeStaleSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=callSdk_com\.amazonaws\.services\.ec2\.AmazonEC2Client_describeStaleSecurityGroups\?/g) && jsonRequestBody.clientType == "com.amazonaws.services.ec2.AmazonEC2Client" && jsonRequestBody.methodName == "describeStaleSecurityGroups") {
        reqParams.boto3['VpcId'] = jsonRequestBody.request.vpcId;
        reqParams.cli['--vpc-id'] = jsonRequestBody.request.vpcId;
        reqParams.boto3['MaxResults'] = jsonRequestBody.request.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.request.maxResults;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeStaleSecurityGroups',
                'boto3': 'describe_stale_security_groups',
                'cli': 'describe-stale-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeCustomerGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2ux\.elasticconsole\.generated\.ElasticConsoleBackendGenerated\.MergedDescribeCustomerGateways\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeCustomerGateways',
                'boto3': 'describe_customer_gateways',
                'cli': 'describe-customer-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpnGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2ux\.elasticconsole\.generated\.ElasticConsoleBackendGenerated\.MergedDescribeVpnGateways\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpnGateways',
                'boto3': 'describe_vpn_gateways',
                'cli': 'describe-vpn-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpnConnections
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2ux\.elasticconsole\.generated\.ElasticConsoleBackendGenerated\.MergedDescribeVpnConnections\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpnConnections',
                'boto3': 'describe_vpn_connections',
                'cli': 'describe-vpn-connections'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.CreateVpc
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "createVpc" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['CidrBlock'] = getPipeSplitField(requestBody, 18);
        reqParams.cli['--cidr-block'] = getPipeSplitField(requestBody, 18);
        reqParams.boto3['InstanceTenancy'] = getPipeSplitField(requestBody, 19);
        reqParams.cli['--instance-tenancy'] = getPipeSplitField(requestBody, 19);

        reqParams.cfn['CidrBlock'] = getPipeSplitField(requestBody, 18);
        reqParams.cfn['InstanceTenancy'] = getPipeSplitField(requestBody, 19);

        reqParams.tf['cidr_block'] = getPipeSplitField(requestBody, 18);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateVpc',
                'boto3': 'create_vpc',
                'cli': 'create-vpc'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::VPC',
            'terraformType': 'aws_vpc',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:logs.DescribeLogGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.logs\.v20140328\.Logs_20140328\.DescribeLogGroups\?/g)) {

        outputs.push({
            'region': region,
            'service': 'logs',
            'method': {
                'api': 'DescribeLogGroups',
                'boto3': 'describe_log_groups',
                'cli': 'describe-log-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:iam.ListRoles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazon\.webservices\.auth\.identity\.v20100508\.AWSIdentityManagementV20100508\.ListRoles\?/g)) {
        reqParams.boto3['MaxItems'] = jsonRequestBody.MaxItems;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxItems;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListRoles',
                'boto3': 'list_roles',
                'cli': 'list-roles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.CreateFlowLogs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateFlowLogs\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['ResourceIds'] = jsonRequestBody.ResourceIds;
        reqParams.cli['--resource-ids'] = jsonRequestBody.ResourceIds;
        reqParams.boto3['TrafficType'] = jsonRequestBody.TrafficType;
        reqParams.cli['--traffic-type'] = jsonRequestBody.TrafficType;
        reqParams.boto3['ResourceType'] = jsonRequestBody.ResourceType;
        reqParams.cli['--resource-type'] = jsonRequestBody.ResourceType;
        reqParams.boto3['LogDestinationType'] = jsonRequestBody.LogDestinationType;
        reqParams.cli['--log-destination-type'] = jsonRequestBody.LogDestinationType;
        reqParams.boto3['LogDestination'] = jsonRequestBody.LogDestination;
        reqParams.cli['--log-destination'] = jsonRequestBody.LogDestination;
        reqParams.boto3['DeliverLogsPermissionArn'] = jsonRequestBody.DeliverLogsPermissionArn;
        reqParams.cli['--deliver-logs-permission-arn'] = jsonRequestBody.DeliverLogsPermissionArn;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateFlowLogs',
                'boto3': 'create_flow_logs',
                'cli': 'create-flow-logs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        for (var resource_id in jsonRequestBody.ResourceIds) {
            reqParams.cfn['ResourceId'] = resource_id;
            reqParams.cfn['TrafficType'] = jsonRequestBody.TrafficType;
            reqParams.cfn['ResourceType'] = jsonRequestBody.ResourceType;
            reqParams.cfn['LogDestinationType'] = jsonRequestBody.LogDestinationType;
            reqParams.cfn['LogDestination'] = jsonRequestBody.LogDestination;
            reqParams.cfn['DeliverLogsPermissionArn'] = jsonRequestBody.DeliverLogsPermissionArn;

            if (jsonRequestBody.ResourceType == "VPC") {
                reqParams.tf['vpc_id'] = resource_id;
            } else if (jsonRequestBody.ResourceType == "Subnet") {
                reqParams.tf['subnet_id'] = resource_id;
            } else if (jsonRequestBody.ResourceType == "NetworkInterfaces") {
                reqParams.tf['eni_id'] = resource_id;
            }
            reqParams.tf['traffic_type'] = jsonRequestBody.TrafficType;
            reqParams.tf['log_destination_type'] = jsonRequestBody.LogDestinationType;
            reqParams.tf['log_destination'] = jsonRequestBody.LogDestination;
            reqParams.tf['iam_role_arn'] = jsonRequestBody.DeliverLogsPermissionArn;

            tracked_resources.push({
                'logicalId': getResourceName('ec2', details.requestId),
                'region': region,
                'service': 'ec2',
                'type': 'AWS::EC2::FlowLog',
                'terraformType': 'aws_flow_log',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });
        }

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteFlowLogs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=callSdk_com\.amazonaws\.services\.ec2\.AmazonEC2Client_deleteFlowLogs\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['FlowLogIds'] = jsonRequestBody.request.flowLogIds;
        reqParams.cli['--flow-log-ids'] = jsonRequestBody.request.flowLogIds;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteFlowLogs',
                'boto3': 'delete_flow_logs',
                'cli': 'delete-flow-logs'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DisassociateVpcCidrBlock
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DisassociateVpcCidrBlock\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['AssociationId'] = jsonRequestBody.associationId;
        reqParams.cli['--association-id'] = jsonRequestBody.associationId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DisassociateVpcCidrBlock',
                'boto3': 'disassociate_vpc_cidr_block',
                'cli': 'disassociate-vpc-cidr-block'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeInstances
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "modifyDHCPOptions" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService" && gwtRequest['method'] == "getInstancesForVPC" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeInstances',
                'boto3': 'describe_instances',
                'cli': 'describe-instances'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DeleteVpc
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "deleteVpc" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = getPipeSplitField(requestBody, 18);
        reqParams.cli['--vpc-id'] = getPipeSplitField(requestBody, 18);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteVpc',
                'boto3': 'delete_vpc',
                'cli': 'delete-vpc'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateRouteTable
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "createRouteTable" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--vpc-id'] = getPipeSplitField(requestBody, 17);

        reqParams.cfn['VpcId'] = getPipeSplitField(requestBody, 17);

        reqParams.tf['vpc_id'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateRouteTable',
                'boto3': 'create_route_table',
                'cli': 'create-route-table'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::RouteTable',
            'terraformType': 'aws_route_table',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }


    // autogen:ec2:ec2.CreateRouteTable
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateRouteTable\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = jsonRequestBody.vpcId;
        reqParams.cli['--vpc-id'] = jsonRequestBody.vpcId;

        reqParams.cfn['VpcId'] = jsonRequestBody.vpcId;

        reqParams.tf['vpc_id'] = jsonRequestBody.vpcId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateRouteTable',
                'boto3': 'create_route_table',
                'cli': 'create-route-table'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::RouteTable',
            'terraformType': 'aws_route_table',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });
        
        return {};
    }

    // autogen:ec2:ec2.DeleteRouteTable
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DeleteRouteTable\?/g)) {
        reqParams.boto3['RouteTableId'] = jsonRequestBody.routeTableId;
        reqParams.cli['--route-table-id'] = jsonRequestBody.routeTableId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteRouteTable',
                'boto3': 'delete_route_table',
                'cli': 'delete-route-table'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeRouteTables
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getRouteTables" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeRouteTables',
                'boto3': 'describe_route_tables',
                'cli': 'describe-route-tables'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DeleteEgressOnlyInternetGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DeleteEgressOnlyInternetGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['EgressOnlyInternetGatewayId'] = jsonRequestBody.EgressOnlyInternetGatewayId;
        reqParams.cli['--egress-only-internet-gateway-id'] = jsonRequestBody.EgressOnlyInternetGatewayId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteEgressOnlyInternetGateway',
                'boto3': 'delete_egress_only_internet_gateway',
                'cli': 'delete-egress-only-internet-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateEgressOnlyInternetGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateEgressOnlyInternetGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = jsonRequestBody.VpcId;
        reqParams.cli['--vpc-id'] = jsonRequestBody.VpcId;

        reqParams.cfn['VpcId'] = jsonRequestBody.VpcId;

        reqParams.tf['vpc_id'] = jsonRequestBody.VpcId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateEgressOnlyInternetGateway',
                'boto3': 'create_egress_only_internet_gateway',
                'cli': 'create-egress-only-internet-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::EgressOnlyInternetGateway',
            'terraformType': 'aws_egress_only_internet_gateway',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteInternetGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DeleteInternetGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:ec2:*:*:internet-gateway/" + jsonRequestBody.internetGatewayId
        ];

        reqParams.boto3['InternetGatewayId'] = jsonRequestBody.internetGatewayId;
        reqParams.cli['--internet-gateway-id'] = jsonRequestBody.internetGatewayId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteInternetGateway',
                'boto3': 'delete_internet_gateway',
                'cli': 'delete-internet-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateTags
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=createTags\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Resources'] = jsonRequestBody.resources;
        reqParams.cli['--resources'] = jsonRequestBody.resources;
        reqParams.boto3['Tags'] = jsonRequestBody.tags;
        reqParams.cli['--tags'] = jsonRequestBody.tags;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateTags',
                'boto3': 'create_tags',
                'cli': 'create-tags'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateInternetGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateInternetGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = jsonRequestBody.VpcId;
        reqParams.cli['--vpc-id'] = jsonRequestBody.VpcId;

        reqParams.cfn['VpcId'] = jsonRequestBody.VpcId;

        reqParams.tf['vpc_id'] = jsonRequestBody.VpcId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateInternetGateway',
                'boto3': 'create_internet_gateway',
                'cli': 'create-internet-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::InternetGateway',
            'terraformType': 'aws_internet_gateway',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteRouteTable
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "deleteRouteTable" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {
        reqParams.iam['Resource'] = [
            "arn:aws:ec2:*:*:route-table/" + getPipeSplitField(requestBody, 17)
        ];

        reqParams.boto3['RouteTableId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--route-table-id'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteRouteTable',
                'boto3': 'delete_route_table',
                'cli': 'delete-route-table'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteDhcpOptions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=callSdk_com\.amazonaws\.services\.ec2\.AmazonEC2Client_deleteDhcpOptions\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:ec2:*:*:dhcp-options/" + jsonRequestBody.request.dhcpOptionsId
        ];

        reqParams.boto3['DhcpOptionsId'] = jsonRequestBody.request.dhcpOptionsId;
        reqParams.cli['--dhcp-options-id'] = jsonRequestBody.request.dhcpOptionsId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteDhcpOptions',
                'boto3': 'delete_dhcp_options',
                'cli': 'delete-dhcp-options'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateNatGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateNatGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['SubnetId'] = jsonRequestBody.SubnetId;
        reqParams.cli['--subnet-id'] = jsonRequestBody.SubnetId;
        reqParams.boto3['AllocationId'] = jsonRequestBody.AllocationId;
        reqParams.cli['--allocation-id'] = jsonRequestBody.AllocationId;

        reqParams.cfn['SubnetId'] = jsonRequestBody.SubnetId;
        reqParams.cfn['AllocationId'] = jsonRequestBody.AllocationId;

        reqParams.tf['subnet_id'] = jsonRequestBody.SubnetId;
        reqParams.tf['allocation_id'] = jsonRequestBody.AllocationId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateNatGateway',
                'boto3': 'create_nat_gateway',
                'cli': 'create-nat-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::NatGateway',
            'terraformType': 'aws_nat_gateway',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteNatGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DeleteNatGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['NatGatewayId'] = jsonRequestBody.NatGatewayId;
        reqParams.cli['--nat-gateway-id'] = jsonRequestBody.NatGatewayId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteNatGateway',
                'boto3': 'delete_nat_gateway',
                'cli': 'delete-nat-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateNetworkAcl
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "createNetworkACL" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--vpc-id'] = getPipeSplitField(requestBody, 17);

        reqParams.cfn['VpcId'] = getPipeSplitField(requestBody, 17);

        reqParams.tf['vpc_id'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateNetworkAcl',
                'boto3': 'create_network_acl',
                'cli': 'create-network-acl'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::NetworkAcl',
            'terraformType': 'aws_network_acl',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteNetworkAcl
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "deleteNetworkACL" && gwtRequest['service'] == "amazonaws.console.vpc.client.VpcConsoleService") {
        reqParams.iam['Resource'] = [
            "arn:aws:ec2:*:*:network-acl/" + getPipeSplitField(requestBody, 17)
        ];

        reqParams.boto3['NetworkAclId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--network-acl-id'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteNetworkAcl',
                'boto3': 'delete_network_acl',
                'cli': 'delete-network-acl'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateCustomerGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateCustomerGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['PublicIp'] = jsonRequestBody.PublicIp;
        reqParams.cli['--public-ip'] = jsonRequestBody.PublicIp;
        reqParams.boto3['Type'] = jsonRequestBody.Type;
        reqParams.cli['--type'] = jsonRequestBody.Type;

        reqParams.cfn['IpAddress'] = jsonRequestBody.PublicIp;
        reqParams.cfn['Type'] = jsonRequestBody.Type;

        reqParams.tf['ip_address'] = jsonRequestBody.PublicIp;
        reqParams.tf['type'] = jsonRequestBody.Type;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateCustomerGateway',
                'boto3': 'create_customer_gateway',
                'cli': 'create-customer-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::CustomerGateway',
            'terraformType': 'aws_customer_gateway',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteCustomerGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DeleteCustomerGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:ec2:*:*:customer-gateway/" + jsonRequestBody.CustomerGatewayId
        ];

        reqParams.boto3['CustomerGatewayId'] = jsonRequestBody.CustomerGatewayId;
        reqParams.cli['--customer-gateway-id'] = jsonRequestBody.CustomerGatewayId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteCustomerGateway',
                'boto3': 'delete_customer_gateway',
                'cli': 'delete-customer-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateVpnGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateVpnGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Type'] = jsonRequestBody.Type;
        reqParams.cli['--type'] = jsonRequestBody.Type;

        reqParams.cfn['Type'] = jsonRequestBody.Type;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateVpnGateway',
                'boto3': 'create_vpn_gateway',
                'cli': 'create-vpn-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::VPNGateway',
            'terraformType': 'aws_vpn_gateway',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteVpnGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DeleteVpnGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpnGatewayId'] = jsonRequestBody.VpnGatewayId;
        reqParams.cli['--vpn-gateway-id'] = jsonRequestBody.VpnGatewayId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteVpnGateway',
                'boto3': 'delete_vpn_gateway',
                'cli': 'delete-vpn-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:sqs:sqs.ListQueues
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sqs\/sqsconsole\/AmazonSQS$/g) && gwtRequest['service'] == "com.amazonaws.console.sqs.shared.services.AmazonSQSService" && gwtRequest['method'] == "listQueues") {

        outputs.push({
            'region': region,
            'service': 'sqs',
            'method': {
                'api': 'ListQueues',
                'boto3': 'list_queues',
                'cli': 'list-queues'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:sqs:kms.ListKeys
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sqs\/sqsconsole\/AmazonKMS$/g) && gwtRequest['method'] == "listKeys" && gwtRequest['service'] == "com.amazonaws.console.sqs.shared.services.AmazonKMSService") {

        outputs.push({
            'region': region,
            'service': 'kms',
            'method': {
                'api': 'ListKeys',
                'boto3': 'list_keys',
                'cli': 'list-keys'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:sqs:sqs.DeleteQueue
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sqs\/sqsconsole\/AmazonSQS$/g) && gwtRequest['service'] == "com.amazonaws.console.sqs.shared.services.AmazonSQSService" && gwtRequest['method'] == "deleteQueue") {
        reqParams.iam['Resource'] = [
            "arn:aws:sqs:*:*:" + getPipeSplitField(requestBody, 10).split("/").pop()
        ];

        reqParams.boto3['QueueUrl'] = getPipeSplitField(requestBody, 10);
        reqParams.cli['--queue-url'] = getPipeSplitField(requestBody, 10);

        outputs.push({
            'region': region,
            'service': 'sqs',
            'method': {
                'api': 'DeleteQueue',
                'boto3': 'delete_queue',
                'cli': 'delete-queue'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:iam:iam.ListGroups
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/groups$/g)) {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListGroups',
                'boto3': 'list_groups',
                'cli': 'list-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:iam:iam.ListUsers
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users$/g)) {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListUsers',
                'boto3': 'list_users',
                'cli': 'list-users'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:iam:iam.ListPolicies
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/policies$/g)) {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListPolicies',
                'boto3': 'list_policies',
                'cli': 'list-policies'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:iam:iam.CreateUser
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:user/" + jsonRequestBody.name
        ];

        reqParams.boto3['UserName'] = jsonRequestBody.name;
        reqParams.cli['--user-name'] = jsonRequestBody.name;
        reqParams.boto3['Path'] = '/'; // path can't be set in console
        reqParams.cli['--path'] = '/';

        reqParams.cfn['UserName'] = jsonRequestBody.name;
        reqParams.cfn['Path'] = '/';

        reqParams.tf['name'] = jsonRequestBody.name;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'CreateUser',
                'boto3': 'create_user',
                'cli': 'create-user'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::IAM::User',
            'terraformType': 'aws_iam_user',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:iam:iam.AttachUserPolicy
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/.+\/attachments$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:user/" + /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1]
        ];

        reqParams.boto3['PolicyArn'] = jsonRequestBody.policyArn;
        reqParams.cli['--policy-arn'] = jsonRequestBody.policyArn;
        reqParams.boto3['UserName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];
        reqParams.cli['--user-name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'AttachUserPolicy',
                'boto3': 'attach_user_policy',
                'cli': 'attach-user-policy'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:iam:iam.AddUserToGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/groups\/.+\/members$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:group/" + /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/groups\/(.+)\//g.exec(details.url)[1]
        ];

        reqParams.boto3['UserName'] = jsonRequestBody.userName;
        reqParams.cli['--user-name'] = jsonRequestBody.userName;
        reqParams.boto3['GroupName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/groups\/(.+)\//g.exec(details.url)[1];
        reqParams.cli['--group-name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/groups\/(.+)\//g.exec(details.url)[1];

        reqParams.cfn['Users'] = [jsonRequestBody.userName];
        reqParams.cfn['GroupName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/groups\/(.+)\//g.exec(details.url)[1];

        reqParams.tf['user'] = jsonRequestBody.userName;
        reqParams.tf['groups'] = [
            /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/groups\/(.+)\//g.exec(details.url)[1]
        ];

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'AddUserToGroup',
                'boto3': 'add_user_to_group',
                'cli': 'add-user-to-group'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::IAM::UserToGroupAddition',
            'terraformType': 'aws_iam_user_group_membership',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:iam:iam.ListGroupsForUser
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/.+\/groups$/g)) {
        reqParams.boto3['UserName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];
        reqParams.cli['--user-name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListGroupsForUser',
                'boto3': 'list_groups_for_user',
                'cli': 'list-groups-for-user'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:iam:iam.ListAccessKeys
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/.+\/accessKeys$/g)) {
        reqParams.boto3['UserName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];
        reqParams.cli['--user-name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListAccessKeys',
                'boto3': 'list_access_keys',
                'cli': 'list-access-keys'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:iam:iam.GetLoginProfile
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/.+\/loginProfile$/g)) {
        reqParams.boto3['UserName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];
        reqParams.cli['--user-name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'GetLoginProfile',
                'boto3': 'get_login_profile',
                'cli': 'get-login-profile'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:iam:iam.CreateLoginProfile
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/.+\/loginProfile$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:user/" + /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1]
        ];

        reqParams.boto3['UserName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];
        reqParams.cli['--user-name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];
        reqParams.boto3['Password'] = jsonRequestBody.password;
        reqParams.cli['--password'] = jsonRequestBody.password;
        reqParams.boto3['PasswordResetRequired'] = jsonRequestBody.resetRequired;
        reqParams.cli['--password-reset-required'] = jsonRequestBody.resetRequired;

        reqParams.tf['name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1];
        reqParams.tf['pgp_key'] = "REPLACEME"
        reqParams.tf['password_reset_required'] = jsonRequestBody.resetRequired;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'CreateLoginProfile',
                'boto3': 'create_login_profile',
                'cli': 'create-login-profile'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'terraformType': 'aws_iam_user_login_profile',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:iam:iam.ListAccountAliases
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/aliases$/g)) {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListAccountAliases',
                'boto3': 'list_account_aliases',
                'cli': 'list-account-aliases'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:iam:iam.GetUser
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/[^/]+$/g)) {
        reqParams.boto3['UserName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)$/g.exec(details.url)[1];
        reqParams.cli['--user-name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)$/g.exec(details.url)[1];

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'GetUser',
                'boto3': 'get_user',
                'cli': 'get-user'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:iam:iam.DeleteUser
    if (details.method == "DELETE" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/[^/]+$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:user/" + /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)\//g.exec(details.url)[1]
        ];

        reqParams.boto3['UserName'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)$/g.exec(details.url)[1];
        reqParams.cli['--user-name'] = /.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/iam\/api\/users\/(.+)$/g.exec(details.url)[1];

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'DeleteUser',
                'boto3': 'delete_user',
                'cli': 'delete-user'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.GetAccount
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.operation == "getAccount" && jsonRequestBody.method == "GET" && jsonRequestBody.path == "/account") {

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetAccount',
                'boto3': 'get_account',
                'cli': 'get-account'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetRestApis
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path == "/restapis") {
        reqParams.boto3['limit'] = jsonRequestBody.params.limit;
        reqParams.cli['--limit'] = jsonRequestBody.params.limit;

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetRestApis',
                'boto3': 'get_rest_apis',
                'cli': 'get-rest-apis'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetRestApi
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+$/g)) {
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetRestApi',
                'boto3': 'get_rest_api',
                'cli': 'get-rest-api'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetAuthorizers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/authorizers$/g) && jsonRequestBody.method == "GET") {
        reqParams.boto3['Limit'] = jsonRequestBody.params.limit;
        reqParams.cli['--limit'] = jsonRequestBody.params.limit;
        reqParams.boto3['RestApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetAuthorizers',
                'boto3': 'get_authorizers',
                'cli': 'get-authorizers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetRequestValidators
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/requestvalidators$/g) && jsonRequestBody.method == "GET") {
        reqParams.boto3['limit'] = jsonRequestBody.params.limit;
        reqParams.cli['--limit'] = jsonRequestBody.params.limit;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetRequestValidators',
                'boto3': 'get_request_validators',
                'cli': 'get-request-validators'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetDocumentationParts
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/documentation\/parts$/g)) {
        reqParams.boto3['limit'] = jsonRequestBody.params.limit;
        reqParams.cli['--limit'] = jsonRequestBody.params.limit;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetDocumentationParts',
                'boto3': 'get_documentation_parts',
                'cli': 'get-documentation-parts'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetResources
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/resources$/g) && jsonRequestBody.method == "GET") {
        reqParams.boto3['embed'] = jsonRequestBody.params.embed;
        reqParams.cli['--embed'] = jsonRequestBody.params.embed;
        reqParams.boto3['limit'] = jsonRequestBody.params.limit;
        reqParams.cli['--limit'] = jsonRequestBody.params.limit;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetResources',
                'boto3': 'get_resources',
                'cli': 'get-resources'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetStages
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/stages$/g)) {
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetStages',
                'boto3': 'get_stages',
                'cli': 'get-stages'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetUsagePlans
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path == "/usageplans" && jsonRequestBody.method == "GET") {
        reqParams.boto3['Limit'] = jsonRequestBody.params.limit;
        reqParams.cli['--limit'] = jsonRequestBody.params.limit;

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetUsagePlans',
                'boto3': 'get_usage_plans',
                'cli': 'get-usage-plans'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.PutMethod
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/resources\/[a-zA-Z0-9]+\/methods\/[A-Z]+$/g) && jsonRequestBody.method == "PUT") {
        reqParams.boto3['authorizationType'] = jsonRequestBody.contentString.authorizationType;
        reqParams.cli['--authorization-type'] = jsonRequestBody.contentString.authorizationType;
        reqParams.boto3['requestParameters'] = jsonRequestBody.contentString.requestParameters;
        reqParams.cli['--request-parameters'] = jsonRequestBody.contentString.requestParameters;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['resourceId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--resource-id'] = jsonRequestBody.path.split("/")[4];
        reqParams.boto3['httpMethod'] = jsonRequestBody.path.split("/")[6];
        reqParams.cli['--http-method'] = jsonRequestBody.path.split("/")[6];

        reqParams.cfn['AuthorizationType'] = jsonRequestBody.contentString.authorizationType;
        reqParams.cfn['RequestParameters'] = jsonRequestBody.contentString.requestParameters;
        reqParams.cfn['RestApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cfn['ResourceId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cfn['HttpMethod'] = jsonRequestBody.path.split("/")[6];

        reqParams.tf['authorization'] = jsonRequestBody.contentString.authorizationType;
        reqParams.tf['request_parameters'] = jsonRequestBody.contentString.requestParameters;
        reqParams.tf['rest_api_id'] = jsonRequestBody.path.split("/")[2];
        reqParams.tf['resource_id'] = jsonRequestBody.path.split("/")[4];
        reqParams.tf['http_method'] = jsonRequestBody.path.split("/")[6];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'PutMethod',
                'boto3': 'put_method',
                'cli': 'put-method'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'type': 'AWS::ApiGateway::Method',
            'terraformType': 'aws_api_gateway_method',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.PutMethodResponse
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/resources\/[a-zA-Z0-9]+\/methods\/[A-Z]+\/responses\/[0-9]+$/g) && jsonRequestBody.method == "PUT") {
        reqParams.boto3['responseModels'] = jsonRequestBody.contentString.responseModels;
        reqParams.cli['--response-models'] = jsonRequestBody.contentString.responseModels;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['resourceId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--resource-id'] = jsonRequestBody.path.split("/")[4];
        reqParams.boto3['httpMethod'] = jsonRequestBody.path.split("/")[6];
        reqParams.cli['--http-method'] = jsonRequestBody.path.split("/")[6];
        reqParams.boto3['statusCode'] = jsonRequestBody.path.split("/")[8];
        reqParams.cli['--status-code'] = jsonRequestBody.path.split("/")[8];

        reqParams.tf['response_models'] = jsonRequestBody.contentString.responseModels;
        reqParams.tf['rest_api_id'] = jsonRequestBody.path.split("/")[2];
        reqParams.tf['resource_id'] = jsonRequestBody.path.split("/")[4];
        reqParams.tf['http_method'] = jsonRequestBody.path.split("/")[6];
        reqParams.tf['status_code'] = jsonRequestBody.path.split("/")[8];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'PutMethodResponse',
                'boto3': 'put_method_response',
                'cli': 'put-method-response'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'terraformType': 'aws_api_gateway_method_response',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:lambda.ListFunctions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/lambda$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path == "/2015-03-31/functions/") {

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'ListFunctions',
                'boto3': 'list_functions',
                'cli': 'list-functions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.PutIntegration
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "PUT" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/resources\/[a-zA-Z0-9]+\/methods\/[A-Z]+\/integration$/g)) {
        reqParams.boto3['type'] = jsonRequestBody.contentString.type;
        reqParams.cli['--type'] = jsonRequestBody.contentString.type;
        reqParams.boto3['requestTemplates'] = jsonRequestBody.contentString.requestTemplates;
        reqParams.cli['--request-templates'] = jsonRequestBody.contentString.requestTemplates;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['resourceId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--resource-id'] = jsonRequestBody.path.split("/")[4];
        reqParams.boto3['httpMethod'] = jsonRequestBody.path.split("/")[6];
        reqParams.cli['--http-method'] = jsonRequestBody.path.split("/")[6];

        reqParams.tf['type'] = jsonRequestBody.contentString.type;
        reqParams.tf['request_templates'] = jsonRequestBody.contentString.requestTemplates;
        reqParams.tf['rest_api_id'] = jsonRequestBody.path.split("/")[2];
        reqParams.tf['resource_id'] = jsonRequestBody.path.split("/")[4];
        reqParams.tf['http_method'] = jsonRequestBody.path.split("/")[6];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'PutIntegration',
                'boto3': 'put_integration',
                'cli': 'put-integration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'terraformType': 'aws_api_gateway_integration',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.PutIntegrationResponse
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "PUT" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/resources\/[a-zA-Z0-9]+\/methods\/[A-Z]+\/integration\/responses\/[0-9]+$/g)) {
        reqParams.boto3['responseTemplates'] = jsonRequestBody.contentString.responseTemplates;
        reqParams.cli['--response-templates'] = jsonRequestBody.contentString.responseTemplates;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['resourceId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--resource-id'] = jsonRequestBody.path.split("/")[4];
        reqParams.boto3['httpMethod'] = jsonRequestBody.path.split("/")[6];
        reqParams.cli['--http-method'] = jsonRequestBody.path.split("/")[6];
        reqParams.boto3['statusCode'] = jsonRequestBody.path.split("/")[9];
        reqParams.cli['--status-code'] = jsonRequestBody.path.split("/")[9];

        reqParams.tf['response_templates'] = jsonRequestBody.contentString.responseTemplates;
        reqParams.tf['rest_api_id'] = jsonRequestBody.path.split("/")[2];
        reqParams.tf['resource_id'] = jsonRequestBody.path.split("/")[4];
        reqParams.tf['http_method'] = jsonRequestBody.path.split("/")[6];
        reqParams.tf['status_code'] = jsonRequestBody.path.split("/")[9];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'PutIntegrationResponse',
                'boto3': 'put_integration_response',
                'cli': 'put-integration-response'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'terraformType': 'aws_api_gateway_integration_response',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.CreateDocumentationPart
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/documentation\/parts$/g) && jsonRequestBody.method == "POST") {
        reqParams.boto3['properties'] = jsonRequestBody.contentString.properties;
        reqParams.cli['--properties'] = jsonRequestBody.contentString.properties;
        reqParams.boto3['location'] = jsonRequestBody.contentString.location;
        reqParams.cli['--location'] = jsonRequestBody.contentString.location;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        reqParams.cfn['Properties'] = jsonRequestBody.contentString.properties;
        reqParams.cfn['Location'] = jsonRequestBody.contentString.location;
        reqParams.cfn['RestApiId'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'CreateDocumentationPart',
                'boto3': 'create_documentation_part',
                'cli': 'create-documentation-part'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'type': 'AWS::ApiGateway::DocumentationPart',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.DeleteDocumentationPart
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "DELETE" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/documentation\/parts\/[a-zA-Z0-9]+$/g)) {
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['documentationPartId'] = jsonRequestBody.path.split("/")[5];
        reqParams.cli['--documentation-part-id'] = jsonRequestBody.path.split("/")[5];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'DeleteDocumentationPart',
                'boto3': 'delete_documentation_part',
                'cli': 'delete-documentation-part'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.DeleteMethod
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "DELETE" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/resources\/[a-zA-Z0-9]+\/methods\/[A-Z]+$/g)) {
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['resourceId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--resource-id'] = jsonRequestBody.path.split("/")[4];
        reqParams.boto3['httpMethod'] = jsonRequestBody.path.split("/")[6];
        reqParams.cli['--http-method'] = jsonRequestBody.path.split("/")[6];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'DeleteMethod',
                'boto3': 'delete_method',
                'cli': 'delete-method'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:cognito-idp.ListUserPools
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/cognito-idp$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path == "/" && jsonRequestBody.headers.X-Amz-Target == "AWSCognitoIdentityProviderService.ListUserPools") {
        reqParams.boto3['MaxResults'] = jsonRequestBody.contentString.MaxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.contentString.MaxResults;

        outputs.push({
            'region': region,
            'service': 'cognito-idp',
            'method': {
                'api': 'ListUserPools',
                'boto3': 'list_user_pools',
                'cli': 'list-user-pools'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.CreateAuthorizer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/authorizers$/g)) {
        reqParams.boto3['type'] = jsonRequestBody.contentString.type;
        reqParams.cli['--type'] = jsonRequestBody.contentString.type;
        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['authorizerUri'] = jsonRequestBody.contentString.authorizerUri;
        reqParams.cli['--authorizer-uri'] = jsonRequestBody.contentString.authorizerUri;
        reqParams.boto3['authorizerCredentials'] = jsonRequestBody.contentString.authorizerCredentials;
        reqParams.cli['--authorizer-credentials'] = jsonRequestBody.contentString.authorizerCredentials;
        reqParams.boto3['identityValidationExpression'] = jsonRequestBody.contentString.identityValidationExpression;
        reqParams.cli['--identity-validation-expression'] = jsonRequestBody.contentString.identityValidationExpression;
        reqParams.boto3['authorizerResultTtlInSeconds'] = jsonRequestBody.contentString.authorizerResultTtlInSeconds;
        reqParams.cli['--authorizer-result-ttl-in-seconds'] = jsonRequestBody.contentString.authorizerResultTtlInSeconds;
        reqParams.boto3['identitySource'] = jsonRequestBody.contentString.identitySource;
        reqParams.cli['--identity-source'] = jsonRequestBody.contentString.identitySource;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        reqParams.cfn['ApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cfn['AuthorizerCredentialsArn'] = jsonRequestBody.contentString.authorizerCredentials;
        reqParams.cfn['AuthorizerResultTtlInSeconds'] = jsonRequestBody.contentString.authorizerResultTtlInSeconds;
        reqParams.cfn['AuthorizerType'] = jsonRequestBody.contentString.type;
        reqParams.cfn['AuthorizerUri'] = jsonRequestBody.contentString.authorizerUri;
        reqParams.cfn['IdentitySource'] = jsonRequestBody.contentString.identitySource;
        reqParams.cfn['IdentityValidationExpression'] = jsonRequestBody.contentString.identityValidationExpression;
        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'CreateAuthorizer',
                'boto3': 'create_authorizer',
                'cli': 'create-authorizer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            //'type': 'AWS::ApiGateway::Authorizer',
            'type': 'AWS::ApiGatewayV2::Authorizer',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.PutGatewayResponse
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "PUT" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/gatewayresponses\/[a-zA-Z0-9_]+$/g)) {
        reqParams.boto3['statusCode'] = jsonRequestBody.contentString.statusCode;
        reqParams.cli['--status-code'] = jsonRequestBody.contentString.statusCode;
        reqParams.boto3['responseParameters'] = jsonRequestBody.contentString.responseParameters;
        reqParams.cli['--response-parameters'] = jsonRequestBody.contentString.responseParameters;
        reqParams.boto3['responseTemplates'] = jsonRequestBody.contentString.responseTemplates;
        reqParams.cli['--response-templates'] = jsonRequestBody.contentString.responseTemplates;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['responseType'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--response-type'] = jsonRequestBody.path.split("/")[4];

        reqParams.cfn['StatusCode'] = jsonRequestBody.contentString.statusCode;
        reqParams.cfn['ResponseParameters'] = jsonRequestBody.contentString.responseParameters;
        reqParams.cfn['ResponseTemplates'] = jsonRequestBody.contentString.responseTemplates;
        reqParams.cfn['RestApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cfn['ResponseType'] = jsonRequestBody.path.split("/")[4];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'PutGatewayResponse',
                'boto3': 'put_gateway_response',
                'cli': 'put-gateway-response'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'type': 'AWS::ApiGateway::GatewayResponse',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.CreateModel
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/models$/g)) {
        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['contentType'] = jsonRequestBody.contentString.contentType;
        reqParams.cli['--content-type'] = jsonRequestBody.contentString.contentType;
        reqParams.boto3['schema'] = jsonRequestBody.contentString.schema;
        reqParams.cli['--schema'] = jsonRequestBody.contentString.schema;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];

        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;
        reqParams.cfn['ContentType'] = jsonRequestBody.contentString.contentType;
        reqParams.cfn['Schema'] = jsonRequestBody.contentString.schema;
        reqParams.cfn['ApiId'] = jsonRequestBody.path.split("/")[2];

        reqParams.tf['name'] = jsonRequestBody.contentString.name;
        reqParams.tf['content_type'] = jsonRequestBody.contentString.contentType;
        reqParams.tf['schema'] = jsonRequestBody.contentString.schema;
        reqParams.tf['rest_api_id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'CreateModel',
                'boto3': 'create_model',
                'cli': 'create-model'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            //'type': 'AWS::ApiGateway::Model',
            'type': 'AWS::ApiGatewayV2::Model',
            'terraformType': 'aws_api_gateway_model',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.DeleteModel
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "DELETE" && jsonRequestBody.path.match(/^\/restapis\/[a-zA-Z0-9]+\/models\/[a-zA-Z0-9]+$/g)) {
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['modelName'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--model-name'] = jsonRequestBody.path.split("/")[4];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'DeleteModel',
                'boto3': 'delete_model',
                'cli': 'delete-model'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:cloudwatch.GetMetricStatistics
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/monitoring$/g) && jsonRequestBody.params.Action == "GetMetricStatistics") {
        reqParams.boto3['Namespace'] = jsonRequestBody.params.Namespace;
        reqParams.cli['--namespace'] = jsonRequestBody.params.Namespace;
        reqParams.boto3['StartTime'] = jsonRequestBody.params.StartTime;
        reqParams.cli['--start-time'] = jsonRequestBody.params.StartTime;
        reqParams.boto3['EndTime'] = jsonRequestBody.params.EndTime;
        reqParams.cli['--end-time'] = jsonRequestBody.params.EndTime;
        reqParams.boto3['Period'] = jsonRequestBody.params.Period;
        reqParams.cli['--period'] = jsonRequestBody.params.Period;
        reqParams.boto3['Unit'] = jsonRequestBody.params.Unit;
        reqParams.cli['--unit'] = jsonRequestBody.params.Unit;
        reqParams.boto3['MetricName'] = jsonRequestBody.params.MetricName;
        reqParams.cli['--metric-name'] = jsonRequestBody.params.MetricName;

        outputs.push({
            'region': region,
            'service': 'cloudwatch',
            'method': {
                'api': 'GetMetricStatistics',
                'boto3': 'get_metric_statistics',
                'cli': 'get-metric-statistics'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.CreateUsagePlan
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path == "/usageplans") {
        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['description'] = jsonRequestBody.contentString.description;
        reqParams.cli['--description'] = jsonRequestBody.contentString.description;
        reqParams.boto3['throttle'] = jsonRequestBody.contentString.throttle;
        reqParams.cli['--throttle'] = jsonRequestBody.contentString.throttle;
        reqParams.boto3['quota'] = jsonRequestBody.contentString.quota;
        reqParams.cli['--quota'] = jsonRequestBody.contentString.quota;

        reqParams.cfn['UsagePlanName'] = jsonRequestBody.contentString.name;
        reqParams.cfn['Description'] = jsonRequestBody.contentString.description;
        reqParams.cfn['Throttle'] = {
            'RateLimit': jsonRequestBody.contentString.throttle.rateLimit,
            'BurstLimit': jsonRequestBody.contentString.throttle.burstLimit
        };
        reqParams.cfn['Quota'] = {
            'Limit': jsonRequestBody.contentString.quota.limit,
            'Period': jsonRequestBody.contentString.quota.period
        };

        reqParams.tf['name'] = jsonRequestBody.contentString.name;
        reqParams.tf['description'] = jsonRequestBody.contentString.description;
        reqParams.tf['throttle_settings'] = {
            'rate_limit': jsonRequestBody.contentString.throttle.rateLimit,
            'burst_limit': jsonRequestBody.contentString.throttle.burstLimit
        };
        reqParams.tf['quota_settings'] = {
            'limit': jsonRequestBody.contentString.quota.limit,
            'period': jsonRequestBody.contentString.quota.period
        };

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'CreateUsagePlan',
                'boto3': 'create_usage_plan',
                'cli': 'create-usage-plan'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'type': 'AWS::ApiGateway::UsagePlan',
            'terraformType': 'aws_api_gateway_usage_plan',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.GetStage
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.operation == "getStage") {
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['stageName'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--stage-name'] = jsonRequestBody.path.split("/")[4];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetStage',
                'boto3': 'get_stage',
                'cli': 'get-stage'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetDeployment
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.operation == "getDeployment") {
        reqParams.boto3['embed'] = jsonRequestBody.params.embed;
        reqParams.cli['--embed'] = jsonRequestBody.params.embed;
        reqParams.boto3['restApiId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--rest-api-id'] = jsonRequestBody.path.split("/")[2];
        reqParams.boto3['deploymentId'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--deployment-id'] = jsonRequestBody.path.split("/")[4];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetDeployment',
                'boto3': 'get_deployment',
                'cli': 'get-deployment'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.CreateApiKey
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path == "/apikeys" && jsonRequestBody.method == "POST") {
        reqParams.boto3['enabled'] = jsonRequestBody.contentString.enabled;
        reqParams.cli['--enabled'] = jsonRequestBody.contentString.enabled;
        reqParams.boto3['generateDistinctId'] = jsonRequestBody.contentString.generateDistinctId;
        reqParams.cli['--generate-distinct-id'] = jsonRequestBody.contentString.generateDistinctId;
        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['value'] = jsonRequestBody.contentString.value;
        reqParams.cli['--value'] = jsonRequestBody.contentString.value;
        reqParams.boto3['description'] = jsonRequestBody.contentString.description;
        reqParams.cli['--description'] = jsonRequestBody.contentString.description;

        reqParams.cfn['Enabled'] = jsonRequestBody.contentString.enabled;
        reqParams.cfn['GenerateDistinctId'] = jsonRequestBody.contentString.generateDistinctId;
        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;
        reqParams.cfn['Description'] = jsonRequestBody.contentString.description;

        reqParams.tf['enabled'] = jsonRequestBody.contentString.enabled;
        reqParams.tf['name'] = jsonRequestBody.contentString.name;
        reqParams.tf['description'] = jsonRequestBody.contentString.description;

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'CreateApiKey',
                'boto3': 'create_api_key',
                'cli': 'create-api-key'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'type': 'AWS::ApiGateway::ApiKey',
            'terraformType': 'aws_api_gateway_api_key',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.DeleteUsagePlan
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path.match(/^\/usageplans\/[a-zA-Z0-9]+$/g)) {
        reqParams.boto3['usagePlanId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--usage-plan-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'DeleteUsagePlan',
                'boto3': 'delete_usage_plan',
                'cli': 'delete-usage-plan'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.GetApiKey
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path.match(/^\/apikeys\/[a-zA-Z0-9]+$/g)) {
        reqParams.boto3['includeValue'] = jsonRequestBody.params.includeValue;
        reqParams.cli['--include-value'] = jsonRequestBody.params.includeValue;
        reqParams.boto3['apiKey'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--api-key'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetApiKey',
                'boto3': 'get_api_key',
                'cli': 'get-api-key'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.UpdateApiKey
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "PATCH" && jsonRequestBody.path.match(/^\/apikeys\/[a-zA-Z0-9]+$/g)) {
        reqParams.boto3['patchOperations'] = jsonRequestBody.contentString.patchOperations;
        reqParams.cli['--patch-operations'] = jsonRequestBody.contentString.patchOperations;
        reqParams.boto3['apiKey'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--api-key'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'UpdateApiKey',
                'boto3': 'update_api_key',
                'cli': 'update-api-key'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:acm.ListCertificates
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/acm$/g) && jsonRequestBody.headers.X-Amz-Target == "CertificateManager.ListCertificates") {

        outputs.push({
            'region': region,
            'service': 'acm',
            'method': {
                'api': 'ListCertificates',
                'boto3': 'list_certificates',
                'cli': 'list-certificates'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.GetDomainNames
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path == "/domainnames") {
        reqParams.boto3['limit'] = jsonRequestBody.params.limit;
        reqParams.cli['--limit'] = jsonRequestBody.params.limit;

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'GetDomainNames',
                'boto3': 'get_domain_names',
                'cli': 'get-domain-names'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.CreateDomainName
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path == "/domainnames") {
        reqParams.boto3['DomainName'] = jsonRequestBody.contentString.domainName;
        reqParams.cli['--domain-name'] = jsonRequestBody.contentString.domainName;
        reqParams.boto3['CertificateArn'] = jsonRequestBody.contentString.certificateArn;
        reqParams.cli['--certificate-arn'] = jsonRequestBody.contentString.certificateArn;
        reqParams.boto3['EndpointConfiguration'] = jsonRequestBody.contentString.endpointConfiguration;
        reqParams.cli['--endpoint-configuration'] = jsonRequestBody.contentString.endpointConfiguration;

        reqParams.cfn['DomainName'] = jsonRequestBody.contentString.domainName;
        reqParams.cfn['CertificateArn'] = jsonRequestBody.contentString.certificateArn;
        reqParams.cfn['EndpointConfiguration'] = jsonRequestBody.contentString.endpointConfiguration;

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'CreateDomainName',
                'boto3': 'create_domain_name',
                'cli': 'create-domain-name'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'type': 'AWS::ApiGateway::DomainName',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:apigateway.DeleteClientCertificate
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.method == "POST" && jsonRequestBody.path == "/clientcertificates" && jsonRequestBody.path == "/clientcertificates/oty57y" && jsonRequestBody.method == "DELETE") {
        reqParams.boto3['clientCertificateId'] = jsonRequestBody.path.split("/")[2];
        reqParams.cli['--client-certificate-id'] = jsonRequestBody.path.split("/")[2];

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'DeleteClientCertificate',
                'boto3': 'delete_client_certificate',
                'cli': 'delete-client-certificate'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:apigateway:elbv2.DescribeLoadBalancers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/elbv2$/g) && jsonRequestBody.method == "GET" && jsonRequestBody.path == "/vpclinks" && jsonRequestBody.params.Action == "DescribeLoadBalancers") {

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeLoadBalancers',
                'boto3': 'describe_load_balancers',
                'cli': 'describe-load-balancers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:apigateway:apigateway.UpdateAccount
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/apigateway\/api\/apigateway$/g) && jsonRequestBody.path == "/account" && jsonRequestBody.method == "PATCH") {
        reqParams.boto3['patchOperations'] = jsonRequestBody.contentString.patchOperations;
        reqParams.cli['--patch-operations'] = jsonRequestBody.contentString.patchOperations;

        outputs.push({
            'region': region,
            'service': 'apigateway',
            'method': {
                'api': 'UpdateAccount',
                'boto3': 'update_account',
                'cli': 'update-account'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('apigateway', details.requestId),
            'region': region,
            'service': 'apigateway',
            'type': 'AWS::ApiGateway::Account',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:cloudwatch:lambda.ListFunctions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListLambdaFunctions\//g)) {
        reqParams.boto3['MaxItems'] = jsonRequestBody.MaxItems;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxItems;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'ListFunctions',
                'boto3': 'list_functions',
                'cli': 'list-functions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:kinesis.ListStreams
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListKinesisStreams\//g)) {
        reqParams.boto3['Limit'] = jsonRequestBody.Limit;
        reqParams.cli['--limit'] = jsonRequestBody.Limit;

        outputs.push({
            'region': region,
            'service': 'kinesis',
            'method': {
                'api': 'ListStreams',
                'boto3': 'list_streams',
                'cli': 'list-streams'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:sns.ListTopics
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListSNSTopics\//g)) {

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'ListTopics',
                'boto3': 'list_topics',
                'cli': 'list-topics'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:autoscaling.DescribeAutoScalingGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.DescribeAutoScalingGroups\//g)) {

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribeAutoScalingGroups',
                'boto3': 'describe_auto_scaling_groups',
                'cli': 'describe-auto-scaling-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:sqs.ListQueues
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListSQSQueues\//g)) {

        outputs.push({
            'region': region,
            'service': 'sqs',
            'method': {
                'api': 'ListQueues',
                'boto3': 'list_queues',
                'cli': 'list-queues'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:ecs.ListTaskDefinitionFamilies
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListTaskDefinitionFamilies\//g)) {

        outputs.push({
            'region': region,
            'service': 'ecs',
            'method': {
                'api': 'ListTaskDefinitionFamilies',
                'boto3': 'list_task_definition_families',
                'cli': 'list-task-definition-families'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:stepfunctions.ListStateMachines
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListStepFunctionsStateMachines\//g)) {
        reqParams.boto3['maxResults'] = jsonRequestBody.MaxResults;
        reqParams.cli['--max-results'] = jsonRequestBody.MaxResults;

        outputs.push({
            'region': region,
            'service': 'stepfunctions',
            'method': {
                'api': 'ListStateMachines',
                'boto3': 'list_state_machines',
                'cli': 'list-state-machines'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:ssm.ListDocuments
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListDocuments\//g)) {
        reqParams.boto3['MaxResults'] = jsonRequestBody.MaxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxResults;
        reqParams.boto3['DocumentFilterList'] = jsonRequestBody.DocumentFilterList;
        reqParams.cli['--document-filter-list'] = jsonRequestBody.DocumentFilterList;

        outputs.push({
            'region': region,
            'service': 'ssm',
            'method': {
                'api': 'ListDocuments',
                'boto3': 'list_documents',
                'cli': 'list-documents'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:firehose.ListDeliveryStreams
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListFirehoseDeliveryStreams\//g)) {
        reqParams.boto3['Limit'] = jsonRequestBody.Limit;
        reqParams.cli['--limit'] = jsonRequestBody.Limit;

        outputs.push({
            'region': region,
            'service': 'firehose',
            'method': {
                'api': 'ListDeliveryStreams',
                'boto3': 'list_delivery_streams',
                'cli': 'list-delivery-streams'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:iam.ListRoles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListRoles\//g)) {
        reqParams.boto3['MaxItems'] = jsonRequestBody.MaxItems;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxItems;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListRoles',
                'boto3': 'list_roles',
                'cli': 'list-roles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:cloudtrail.DescribeTrails
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.DescribeTrails\//g)) {

        outputs.push({
            'region': region,
            'service': 'cloudtrail',
            'method': {
                'api': 'DescribeTrails',
                'boto3': 'describe_trails',
                'cli': 'describe-trails'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:lambda.ListVersionsByFunction
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListLambdaFunctionVersions\//g)) {
        reqParams.boto3['FunctionName'] = jsonRequestBody.FunctionName;
        reqParams.cli['--function-name'] = jsonRequestBody.FunctionName;
        reqParams.boto3['MaxItems'] = jsonRequestBody.MaxItems;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxItems;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'ListVersionsByFunction',
                'boto3': 'list_versions_by_function',
                'cli': 'list-versions-by-function'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:lambda.ListAliases
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListLambdaFunctionAliases\//g)) {
        reqParams.boto3['FunctionName'] = jsonRequestBody.FunctionName;
        reqParams.cli['--function-name'] = jsonRequestBody.FunctionName;
        reqParams.boto3['MaxItems'] = jsonRequestBody.MaxItems;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxItems;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'ListAliases',
                'boto3': 'list_aliases',
                'cli': 'list-aliases'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:events.PutRule
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.SaveRule\//g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Name'] = jsonRequestBody.Rule.Name;
        reqParams.cli['--name'] = jsonRequestBody.Rule.Name;
        reqParams.boto3['State'] = jsonRequestBody.Rule.State;
        reqParams.cli['--state'] = jsonRequestBody.Rule.State;
        reqParams.boto3['Description'] = jsonRequestBody.Rule.Description;
        reqParams.cli['--description'] = jsonRequestBody.Rule.Description;
        reqParams.boto3['ScheduleExpression'] = jsonRequestBody.Rule.ScheduleExpression;
        reqParams.cli['--schedule-expression'] = jsonRequestBody.Rule.ScheduleExpression;
        reqParams.boto3['EventPattern'] = jsonRequestBody.Rule.EventPattern;
        reqParams.cli['--event-pattern'] = jsonRequestBody.Rule.EventPattern;

        reqParams.cfn['Name'] = jsonRequestBody.Rule.Name;
        reqParams.cfn['State'] = jsonRequestBody.Rule.State;
        reqParams.cfn['Description'] = jsonRequestBody.Rule.Description;
        reqParams.cfn['ScheduleExpression'] = jsonRequestBody.Rule.ScheduleExpression;
        reqParams.cfn['EventPattern'] = jsonRequestBody.Rule.EventPattern;

        reqParams.tf['name'] = jsonRequestBody.Rule.Name;
        reqParams.tf['is_enabled'] = (jsonRequestBody.Rule.State == "ENABLED");
        reqParams.tf['description'] = jsonRequestBody.Rule.Description;
        reqParams.tf['schedule_expression'] = jsonRequestBody.Rule.ScheduleExpression;
        reqParams.tf['event_pattern'] = jsonRequestBody.Rule.EventPattern;

        if (jsonRequestBody.Targets && jsonRequestBody.Targets.length) {
            reqParams.cfn['Targets'] = [];
            for (var i=0; i<jsonRequestBody.Targets.length; i++) {
                reqParams.cfn['Targets'].push({
                    'Arn': jsonRequestBody.Targets[i].Arn,
                    'Id': jsonRequestBody.Targets[i].Id
                })
            }
        }

        outputs.push({
            'region': region,
            'service': 'events',
            'method': {
                'api': 'PutRule',
                'boto3': 'put_rule',
                'cli': 'put-rule'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('events', details.requestId),
            'region': region,
            'service': 'events',
            'type': 'AWS::Events::Rule',
            'terraformType': 'aws_cloudwatch_event_rule',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:cloudwatch:events.ListRules
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.ListRules\//g)) {
        reqParams.boto3['NextToken'] = jsonRequestBody.NextToken;
        reqParams.cli['--next-token'] = jsonRequestBody.NextToken;
        reqParams.boto3['NamePrefix'] = jsonRequestBody.NamePrefix;
        reqParams.cli['--name-prefix'] = jsonRequestBody.NamePrefix;

        outputs.push({
            'region': region,
            'service': 'events',
            'method': {
                'api': 'ListRules',
                'boto3': 'list_rules',
                'cli': 'list-rules'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:cloudwatch:events.DisableRule
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.DisableRule\//g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:events:*:*:rule/" + jsonRequestBody.Name
        ];

        reqParams.boto3['Name'] = jsonRequestBody.Name;
        reqParams.cli['--name'] = jsonRequestBody.Name;

        outputs.push({
            'region': region,
            'service': 'events',
            'method': {
                'api': 'DisableRule',
                'boto3': 'disable_rule',
                'cli': 'disable-rule'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:cloudwatch:events.EnableRule
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.EnableRule\//g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:events:*:*:rule/" + jsonRequestBody.Name
        ];

        reqParams.boto3['Name'] = jsonRequestBody.Name;
        reqParams.cli['--name'] = jsonRequestBody.Name;

        outputs.push({
            'region': region,
            'service': 'events',
            'method': {
                'api': 'EnableRule',
                'boto3': 'enable_rule',
                'cli': 'enable-rule'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:cloudwatch:events.DeleteRule
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\/data\/jetstream\.DeleteRule\//g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:events:*:*:rule/" + jsonRequestBody.Name
        ];

        reqParams.boto3['Name'] = jsonRequestBody.Name;
        reqParams.cli['--name'] = jsonRequestBody.Name;

        outputs.push({
            'region': region,
            'service': 'events',
            'method': {
                'api': 'DeleteRule',
                'boto3': 'delete_rule',
                'cli': 'delete-rule'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:workspaces:ds.DescribeDirectories
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/workspaces\/workspaces\/SkyLightService$/g) && gwtRequest['method'] == "describeDirectories") {

        outputs.push({
            'region': region,
            'service': 'ds',
            'method': {
                'api': 'DescribeDirectories',
                'boto3': 'describe_directories',
                'cli': 'describe-directories'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:workspaces:workspaces.DescribeWorkspaceBundles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/workspaces\/workspaces\/SkyLightService$/g) && gwtRequest['method'] == "describeWorkspaceBundles") {

        outputs.push({
            'region': region,
            'service': 'workspaces',
            'method': {
                'api': 'DescribeWorkspaceBundles',
                'boto3': 'describe_workspace_bundles',
                'cli': 'describe-workspace-bundles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:workspaces:kms.ListKeys
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/workspaces\/workspaces\/SkyLightService$/g) && gwtRequest['method'] == "listKeys") {

        outputs.push({
            'region': region,
            'service': 'kms',
            'method': {
                'api': 'ListKeys',
                'boto3': 'list_keys',
                'cli': 'list-keys'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:workspaces:workspaces.DescribeWorkspaces
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/workspaces\/workspaces\/SkyLightService$/g) && gwtRequest['method'] == "describeWorkspaceImages") {

        outputs.push({
            'region': region,
            'service': 'workspaces',
            'method': {
                'api': 'DescribeWorkspaces',
                'boto3': 'describe_workspaces',
                'cli': 'describe-workspaces'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:workspaces:workspaces.CreateWorkspaces
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/workspaces\/workspaces\/SkyLightService$/g) && gwtRequest['method'] == "createRegistration") {
        reqParams.iam['Resource'] = [
            "arn:aws:sky:*:*:workspace/*",
            "arn:aws:sky:*:*:workspacebundle/" + getPipeSplitField(requestBody, 18)
        ];
 
        // TODO: create directory here
        // getPipeSplitField(requestBody, 15) // email
        // getPipeSplitField(requestBody, 16) // first
        // getPipeSplitField(requestBody, 17) // last

        reqParams.boto3['Workspaces'] = {
            "Workspaces": [ 
                { 
                    "BundleId": getPipeSplitField(requestBody, 18),
                    "DirectoryId": "directoryid",
                    "UserName": getPipeSplitField(requestBody, 15)
                }
            ]
        }
        reqParams.cli['--workspaces'] = {
            "Workspaces": [ 
                { 
                    "BundleId": getPipeSplitField(requestBody, 18),
                    "DirectoryId": "directoryid",
                    "UserName": getPipeSplitField(requestBody, 15)
                }
            ]
        }

        reqParams.cfn['BundleId'] = getPipeSplitField(requestBody, 18);
        reqParams.cfn['UserName'] = getPipeSplitField(requestBody, 15);
        reqParams.cfn['DirectoryId'] = 'directoryid';

        outputs.push({
            'region': region,
            'service': 'workspaces',
            'method': {
                'api': 'CreateWorkspaces',
                'boto3': 'create_workspaces',
                'cli': 'create-workspaces'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('workspaces', details.requestId),
            'region': region,
            'service': 'workspaces',
            'type': 'AWS::WorkSpaces::Workspace',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:workspaces:workspaces.TerminateWorkspaces
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/workspaces\/workspaces\/SkyLightService$/g) && gwtRequest['method'] == "terminateWorkspaces") {
        reqParams.iam['Resource'] = [
            "arn:aws:sky:*:*:workspace/" + getPipeSplitField(requestBody, 12)
        ];

        reqParams.boto3['TerminateWorkspaceRequests'] = {
            'WorkspaceId': getPipeSplitField(requestBody, 12)
        };
        reqParams.cli['--terminate-workspace-requests'] = {
            'WorkspaceId': getPipeSplitField(requestBody, 12)
        };

        outputs.push({
            'region': region,
            'service': 'workspaces',
            'method': {
                'api': 'TerminateWorkspaces',
                'boto3': 'terminate_workspaces',
                'cli': 'terminate-workspaces'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:athena:athena.CreateNamedQuery
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/athena\/rpc\/query\/save$/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Database'] = jsonRequestBody['query-database'];
        reqParams.cli['--database'] = jsonRequestBody['query-database'];
        reqParams.boto3['QueryString'] = jsonRequestBody['query-query'];
        reqParams.cli['--query-string'] = jsonRequestBody['query-query'];
        reqParams.boto3['Description'] = jsonRequestBody['saveform-desc'];
        reqParams.cli['--description'] = jsonRequestBody['saveform-desc'];
        reqParams.boto3['Name'] = jsonRequestBody['saveform-name'];
        reqParams.cli['--name'] = jsonRequestBody['saveform-name'];

        reqParams.cfn['Database'] = jsonRequestBody['query-database'];
        reqParams.cfn['QueryString'] = jsonRequestBody['query-query'];
        reqParams.cfn['Description'] = jsonRequestBody['saveform-desc'];
        reqParams.cfn['Name'] = jsonRequestBody['saveform-name'];

        reqParams.tf['database'] = jsonRequestBody['query-database'];
        reqParams.tf['query'] = jsonRequestBody['query-query'];
        reqParams.tf['description'] = jsonRequestBody['saveform-desc'];
        reqParams.tf['name'] = jsonRequestBody['saveform-name'];

        outputs.push({
            'region': region,
            'service': 'athena',
            'method': {
                'api': 'CreateNamedQuery',
                'boto3': 'create_named_query',
                'cli': 'create-named-query'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('athena', details.requestId),
            'region': region,
            'service': 'athena',
            'type': 'AWS::Athena::NamedQuery',
            'terraformType': 'aws_athena_named_query',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:appsync:appsync.CreateGraphqlApi
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "createGraphqlApi") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['authenticationType'] = jsonRequestBody.contentString.authenticationType;
        reqParams.cli['--authentication-type'] = jsonRequestBody.contentString.authenticationType;

        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;
        reqParams.cfn['AuthenticationType'] = jsonRequestBody.contentString.authenticationType;

        reqParams.tf['name'] = jsonRequestBody.contentString.name;
        reqParams.tf['authentication_type'] = jsonRequestBody.contentString.authenticationType;

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'CreateGraphqlApi',
                'boto3': 'create_graphql_api',
                'cli': 'create-graphql-api'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('appsync', details.requestId),
            'region': region,
            'service': 'appsync',
            'type': 'AWS::AppSync::GraphQLApi',
            'terraformType': 'aws_appsync_graphql_api',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:appsync:appsync.CreateApiKey
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "createApiKey") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['description'] = jsonRequestBody.contentString.description;
        reqParams.cli['--description'] = jsonRequestBody.contentString.description;
        reqParams.boto3['apiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--api-id'] = jsonRequestBody.path.split("/")[3];

        reqParams.cfn['Description'] = jsonRequestBody.contentString.description;
        reqParams.cfn['ApiId'] = jsonRequestBody.path.split("/")[3];

        reqParams.tf['description'] = jsonRequestBody.contentString.description;
        reqParams.tf['api_id'] = jsonRequestBody.path.split("/")[3];

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'CreateApiKey',
                'boto3': 'create_api_key',
                'cli': 'create-api-key'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('appsync', details.requestId),
            'region': region,
            'service': 'appsync',
            'type': 'AWS::AppSync::ApiKey',
            'terraformType': 'aws_appsync_api_key',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:appsync:dynamodb.CreateTable
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/dynamodb$/g) && jsonRequestBody.operation == "createTable") {
        reqParams.iam['Resource'] = [
            "arn:aws:dynamodb:*:*:table/" + jsonRequestBody.contentString.TableName
        ];

        reqParams.boto3['TableName'] = jsonRequestBody.contentString.TableName;
        reqParams.cli['--table-name'] = jsonRequestBody.contentString.TableName;
        reqParams.boto3['KeySchema'] = jsonRequestBody.contentString.KeySchema;
        reqParams.cli['--key-schema'] = jsonRequestBody.contentString.KeySchema;
        reqParams.boto3['LocalSecondaryIndexes'] = jsonRequestBody.contentString.LocalSecondaryIndexes;
        reqParams.cli['--local-secondary-indexes'] = jsonRequestBody.contentString.LocalSecondaryIndexes;
        reqParams.boto3['AttributeDefinitions'] = jsonRequestBody.contentString.AttributeDefinitions;
        reqParams.cli['--attribute-definitions'] = jsonRequestBody.contentString.AttributeDefinitions;
        reqParams.boto3['ProvisionedThroughput'] = jsonRequestBody.contentString.ProvisionedThroughput;
        reqParams.cli['--provisioned-throughput'] = jsonRequestBody.contentString.ProvisionedThroughput;

        reqParams.cfn['TableName'] = jsonRequestBody.contentString.TableName;
        reqParams.cfn['KeySchema'] = jsonRequestBody.contentString.KeySchema;
        reqParams.cfn['LocalSecondaryIndexes'] = jsonRequestBody.contentString.LocalSecondaryIndexes;
        reqParams.cfn['AttributeDefinitions'] = jsonRequestBody.contentString.AttributeDefinitions;
        reqParams.cfn['ProvisionedThroughput'] = jsonRequestBody.contentString.ProvisionedThroughput;

        outputs.push({
            'region': region,
            'service': 'dynamodb',
            'method': {
                'api': 'CreateTable',
                'boto3': 'create_table',
                'cli': 'create-table'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('dynamodb', details.requestId),
            'region': region,
            'service': 'dynamodb',
            'type': 'AWS::DynamoDB::Table',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:appsync:dynamodb.DescribeTable
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/dynamodb$/g) && jsonRequestBody.operation == "describeTable") {
        reqParams.boto3['TableName'] = jsonRequestBody.contentString.TableName;
        reqParams.cli['--table-name'] = jsonRequestBody.contentString.TableName;

        outputs.push({
            'region': region,
            'service': 'dynamodb',
            'method': {
                'api': 'DescribeTable',
                'boto3': 'describe_table',
                'cli': 'describe-table'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:appsync:appsync.StartSchemaCreation
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "startSchemaCreation") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['definition'] = jsonRequestBody.contentString.definition;
        reqParams.cli['--definition'] = jsonRequestBody.contentString.definition;
        reqParams.boto3['apiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--api-id'] = jsonRequestBody.path.split("/")[3];

        reqParams.cfn['Definition'] = jsonRequestBody.contentString.definition;
        reqParams.cfn['ApiId'] = jsonRequestBody.path.split("/")[3];

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'StartSchemaCreation',
                'boto3': 'start_schema_creation',
                'cli': 'start-schema-creation'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('appsync', details.requestId),
            'region': region,
            'service': 'appsync',
            'type': 'AWS::AppSync::GraphQLSchema',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:appsync:appsync.GetSchemaCreationStatus
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "getSchemaCreationStatus") {
        reqParams.boto3['apiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--api-id'] = jsonRequestBody.path.split("/")[3];

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'GetSchemaCreationStatus',
                'boto3': 'get_schema_creation_status',
                'cli': 'get-schema-creation-status'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:appsync:appsync.CreateDataSource
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "createDataSource") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['Type'] = jsonRequestBody.contentString.type;
        reqParams.cli['--type'] = jsonRequestBody.contentString.type;
        reqParams.boto3['ServiceRoleArn'] = jsonRequestBody.contentString.serviceRoleArn;
        reqParams.cli['--service-role-arn'] = jsonRequestBody.contentString.serviceRoleArn;
        reqParams.boto3['DynamodbConfig'] = jsonRequestBody.contentString.dynamodbConfig;
        reqParams.cli['--dynamodb-config'] = jsonRequestBody.contentString.dynamodbConfig;
        reqParams.boto3['ApiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--api-id'] = jsonRequestBody.path.split("/")[3];

        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;
        reqParams.cfn['Type'] = jsonRequestBody.contentString.type;
        reqParams.cfn['ServiceRoleArn'] = jsonRequestBody.contentString.serviceRoleArn;
        reqParams.cfn['DynamoDBConfig'] = {
            'TableName': jsonRequestBody.contentString.dynamodbConfig.tableName,
            'AwsRegion': jsonRequestBody.contentString.dynamodbConfig.awsRegion,
            'UseCallerCredentials': jsonRequestBody.contentString.dynamodbConfig.useCallerCredentials
        };
        reqParams.cfn['ApiId'] = jsonRequestBody.path.split("/")[3];

        reqParams.tf['name'] = jsonRequestBody.contentString.name;
        reqParams.tf['type'] = jsonRequestBody.contentString.type;
        reqParams.tf['service_role_arn'] = jsonRequestBody.contentString.serviceRoleArn;
        reqParams.tf['dynamodb_config'] = {
            'table_name': jsonRequestBody.contentString.dynamodbConfig.tableName,
            'region': jsonRequestBody.contentString.dynamodbConfig.awsRegion,
            'use_caller_credentials': jsonRequestBody.contentString.dynamodbConfig.useCallerCredentials
        };
        reqParams.tf['api_id'] = jsonRequestBody.path.split("/")[3];

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'CreateDataSource',
                'boto3': 'create_data_source',
                'cli': 'create-data-source'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('appsync', details.requestId),
            'region': region,
            'service': 'appsync',
            'type': 'AWS::AppSync::DataSource',
            'terraformType': 'aws_appsync_datasource',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:appsync:appsync.CreateResolver
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "createResolver") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['dieldName'] = jsonRequestBody.contentString.fieldName;
        reqParams.cli['--field-name'] = jsonRequestBody.contentString.fieldName;
        reqParams.boto3['dataSourceName'] = jsonRequestBody.contentString.dataSourceName;
        reqParams.cli['--data-source-name'] = jsonRequestBody.contentString.dataSourceName;
        reqParams.boto3['requestMappingTemplate'] = jsonRequestBody.contentString.requestMappingTemplate;
        reqParams.cli['--request-mapping-template'] = jsonRequestBody.contentString.requestMappingTemplate;
        reqParams.boto3['responseMappingTemplate'] = jsonRequestBody.contentString.responseMappingTemplate;
        reqParams.cli['--response-mapping-template'] = jsonRequestBody.contentString.responseMappingTemplate;
        reqParams.boto3['apiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--api-id'] = jsonRequestBody.path.split("/")[3];
        reqParams.boto3['typeName'] = jsonRequestBody.path.split("/")[5];
        reqParams.cli['--type-name'] = jsonRequestBody.path.split("/")[5];

        reqParams.cfn['FieldName'] = jsonRequestBody.contentString.fieldName;
        reqParams.cfn['DataSourceName'] = jsonRequestBody.contentString.dataSourceName;
        reqParams.cfn['RequestMappingTemplate'] = jsonRequestBody.contentString.requestMappingTemplate;
        reqParams.cfn['ResponseMappingTemplate'] = jsonRequestBody.contentString.responseMappingTemplate;
        reqParams.cfn['ApiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cfn['TypeName'] = jsonRequestBody.path.split("/")[5];

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'CreateResolver',
                'boto3': 'create_resolver',
                'cli': 'create-resolver'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('appsync', details.requestId),
            'region': region,
            'service': 'appsync',
            'type': 'AWS::AppSync::Resolver',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:appsync:appsync.ListResolvers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "listResolvers") {
        reqParams.boto3['maxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-results'] = jsonRequestBody.params.maxResults;
        reqParams.boto3['apiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--api-id'] = jsonRequestBody.path.split("/")[3];
        reqParams.boto3['typeName'] = jsonRequestBody.path.split("/")[5];
        reqParams.cli['--type-name'] = jsonRequestBody.path.split("/")[5];

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'ListResolvers',
                'boto3': 'list_resolvers',
                'cli': 'list-resolvers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:appsync:appsync.UpdateGraphqlApi
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "updateGraphqlApi") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['authenticationType'] = jsonRequestBody.contentString.authenticationType;
        reqParams.cli['--authentication-type'] = jsonRequestBody.contentString.authenticationType;
        reqParams.boto3['apiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--api-id'] = jsonRequestBody.path.split("/")[3];

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'UpdateGraphqlApi',
                'boto3': 'update_graphql_api',
                'cli': 'update-graphql-api'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:appsync:appsync.DeleteGraphqlApi
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/appsync\/api\/appsync$/g) && jsonRequestBody.operation == "deleteGraphqlApi") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['apiId'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--api-id'] = jsonRequestBody.path.split("/")[3];

        outputs.push({
            'region': region,
            'service': 'appsync',
            'method': {
                'api': 'DeleteGraphqlApi',
                'boto3': 'delete_graphql_api',
                'cli': 'delete-graphql-api'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeLaunchTemplates
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DescribeLaunchTemplates\?/g)) {
        reqParams.boto3['LaunchTemplateNames'] = jsonRequestBody.LaunchTemplateNames;
        reqParams.cli['--launch-template-names'] = jsonRequestBody.LaunchTemplateNames;
        reqParams.boto3['MaxResults'] = jsonRequestBody.MaxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.MaxResults;
        reqParams.boto3['NextToken'] = jsonRequestBody.NextToken;
        reqParams.cli['--next-token'] = jsonRequestBody.NextToken;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeLaunchTemplates',
                'boto3': 'describe_launch_templates',
                'cli': 'describe-launch-templates'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.DescribeLoadBalancers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getLoadBalancersAutoUpdate\?/g)) {

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribeLoadBalancers',
                'boto3': 'describe_load_balancers',
                'cli': 'describe-load-balancers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.CreateLaunchConfiguration
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=CreateLaunchConfiguration\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/" + jsonRequestBody.LaunchConfigurationName
        ];

        reqParams.boto3['UserData'] = jsonRequestBody.UserData;
        reqParams.cli['--user-data'] = jsonRequestBody.UserData;
        reqParams.boto3['ImageId'] = jsonRequestBody.ImageId;
        reqParams.cli['--image-id'] = jsonRequestBody.ImageId;
        reqParams.boto3['BlockDeviceMappings'] = jsonRequestBody.AutoScalingBlockDeviceMappings;
        reqParams.cli['--block-device-mappings'] = jsonRequestBody.AutoScalingBlockDeviceMappings;
        reqParams.boto3['EbsOptimized'] = jsonRequestBody.EbsOptimized;
        reqParams.cli['--ebs-optimized'] = jsonRequestBody.EbsOptimized;
        reqParams.boto3['IamInstanceProfile'] = jsonRequestBody.IamInstanceProfile;
        reqParams.cli['--iam-instance-profile'] = jsonRequestBody.IamInstanceProfile;
        reqParams.boto3['InstanceMonitoring'] = jsonRequestBody.InstanceMonitoring;
        reqParams.cli['--instance-monitoring'] = jsonRequestBody.InstanceMonitoring;
        reqParams.boto3['InstanceType'] = jsonRequestBody.InstanceType;
        reqParams.cli['--instance-type'] = jsonRequestBody.InstanceType;
        reqParams.boto3['KeyName'] = jsonRequestBody.KeyName;
        reqParams.cli['--key-name'] = jsonRequestBody.KeyName;
        reqParams.boto3['LaunchConfigurationName'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.cli['--launch-configuration-name'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.boto3['SecurityGroups'] = jsonRequestBody.SecurityGroups;
        reqParams.cli['--security-groups'] = jsonRequestBody.SecurityGroups;
        reqParams.boto3['AssociatePublicIpAddress'] = jsonRequestBody.AssociatePublicIpAddress;
        reqParams.cli['--associate-public-ip-address'] = jsonRequestBody.AssociatePublicIpAddress;

        reqParams.cfn['UserData'] = jsonRequestBody.UserData;
        reqParams.cfn['ImageId'] = jsonRequestBody.ImageId;
        if (jsonRequestBody.AutoScalingBlockDeviceMappings) {
            reqParams.cfn['BlockDeviceMappings'] = [];
            for (var i=0; i<jsonRequestBody.AutoScalingBlockDeviceMappings.length; i++) {
                reqParams.cfn['BlockDeviceMappings'].push({
                    'DeviceName': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingDeviceName,
                    'Ebs': {
                        'VolumeSize': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingVolumeSize,
                        'DeleteOnTermination': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingDeleteOnTermination,
                        'SnapshotId': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingSnapshotId,
                        'VolumeType': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingVolumeType,
                        'Encrypted': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingEncrypted,
                        'Iops': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingIops
                    }
                });
            }
        }
        reqParams.cfn['EbsOptimized'] = jsonRequestBody.EbsOptimized;
        reqParams.cfn['IamInstanceProfile'] = jsonRequestBody.IamInstanceProfile;
        reqParams.cfn['InstanceMonitoring'] = jsonRequestBody.InstanceMonitoring.Enabled;
        reqParams.cfn['InstanceType'] = jsonRequestBody.InstanceType;
        reqParams.cfn['KeyName'] = jsonRequestBody.KeyName;
        reqParams.cfn['LaunchConfigurationName'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.cfn['SecurityGroups'] = jsonRequestBody.SecurityGroups;
        reqParams.cfn['AssociatePublicIpAddress'] = jsonRequestBody.AssociatePublicIpAddress;

        reqParams.tf['user_data_base64'] = jsonRequestBody.UserData;
        reqParams.tf['image_id'] = jsonRequestBody.ImageId;
        for (var i=0; i<jsonRequestBody.AutoScalingBlockDeviceMappings.length; i++) {
            if (jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingDeviceName == "/dev/sda1" || jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingDeviceName == "/dev/xvda") {
                if (jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs) {
                    reqParams.tf['root_block_device'] = {
                        'volume_type': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingVolumeType,
                        'volume_size': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingVolumeSize
                    };
                }
            } else if (jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs) {
                reqParams.tf['ebs_block_device'] = {
                    'device_name': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingDeviceName,
                    'volume_type': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingVolumeType,
                    'volume_size': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingVolumeSize,
                    'delete_on_termination': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingDeleteOnTermination,
                    'iops': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingIops,
                    'snapshot_id': jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingSnapshotId
                };

                if (jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingSnapshotId) {
                    reqParams.iam['Resource'].push("arn:aws:ec2:*::snapshot/" + jsonRequestBody.AutoScalingBlockDeviceMappings[i].AutoScalingEbs.AutoScalingSnapshotId);
                }
            }
        }
        reqParams.tf['ebs_optimized'] = jsonRequestBody.EbsOptimized;
        reqParams.tf['iam_instance_profile'] = jsonRequestBody.IamInstanceProfile;
        reqParams.tf['enable_monitoring'] = jsonRequestBody.InstanceMonitoring.Enabled;
        reqParams.tf['instance_type'] = jsonRequestBody.InstanceType;
        reqParams.tf['key_name'] = jsonRequestBody.KeyName;
        reqParams.tf['name'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.tf['security_groups'] = jsonRequestBody.SecurityGroups;
        reqParams.tf['associate_public_ip_address'] = jsonRequestBody.AssociatePublicIpAddress;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'CreateLaunchConfiguration',
                'boto3': 'create_launch_configuration',
                'cli': 'create-launch-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('autoscaling', details.requestId),
            'region': region,
            'service': 'autoscaling',
            'type': 'AWS::AutoScaling::LaunchConfiguration',
            'terraformType': 'aws_launch_configuration',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.DescribeLaunchConfigurations
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DescribeLaunchConfigurations\?/g)) {
        reqParams.boto3['LaunchConfigurationNames'] = jsonRequestBody.LaunchConfigurationNames;
        reqParams.cli['--launch-configuration-names'] = jsonRequestBody.LaunchConfigurationNames;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribeLaunchConfigurations',
                'boto3': 'describe_launch_configurations',
                'cli': 'describe-launch-configurations'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:elbv2.DescribeTargetGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DescribeTargetGroups\?/g)) {

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeTargetGroups',
                'boto3': 'describe_target_groups',
                'cli': 'describe-target-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.CreateAutoScalingGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=CreateAutoScalingGroup\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/" + jsonRequestBody.AutoScalingGroupName
        ];

        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.boto3['LaunchConfigurationName'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.cli['--launch-configuration-name'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.boto3['DesiredCapacity'] = jsonRequestBody.DesiredCapacity;
        reqParams.cli['--desired-capacity'] = jsonRequestBody.DesiredCapacity;
        reqParams.boto3['MinSize'] = jsonRequestBody.MinSize;
        reqParams.cli['--min-size'] = jsonRequestBody.MinSize;
        reqParams.boto3['MaxSize'] = jsonRequestBody.MaxSize;
        reqParams.cli['--max-size'] = jsonRequestBody.MaxSize;
        reqParams.boto3['HealthCheckGracePeriod'] = jsonRequestBody.HealthCheckGracePeriod;
        reqParams.cli['--health-check-grace-period'] = jsonRequestBody.HealthCheckGracePeriod;
        reqParams.boto3['Tags'] = jsonRequestBody.Tags;
        reqParams.cli['--tags'] = jsonRequestBody.Tags;
        reqParams.boto3['NewInstancesProtectedFromScaleIn'] = jsonRequestBody.NewInstancesProtectedFromScaleIn;
        reqParams.cli['--new-instances-protected-from-scale-in'] = jsonRequestBody.NewInstancesProtectedFromScaleIn;
        reqParams.boto3['ServiceLinkedRoleARN'] = jsonRequestBody.ServiceLinkedRoleARN;
        reqParams.cli['--service-linked-role-arn'] = jsonRequestBody.ServiceLinkedRoleARN;
        reqParams.boto3['VPCZoneIdentifier'] = jsonRequestBody.VPCZoneIdentifier.split(",");
        reqParams.cli['--vpc-zone-identifier'] = jsonRequestBody.VPCZoneIdentifier.split(",");

        reqParams.cfn['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cfn['LaunchConfigurationName'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.cfn['DesiredCapacity'] = jsonRequestBody.DesiredCapacity;
        reqParams.cfn['MinSize'] = jsonRequestBody.MinSize;
        reqParams.cfn['MaxSize'] = jsonRequestBody.MaxSize;
        reqParams.cfn['HealthCheckGracePeriod'] = jsonRequestBody.HealthCheckGracePeriod;
        reqParams.cfn['Tags'] = jsonRequestBody.Tags;
        reqParams.cfn['ServiceLinkedRoleARN'] = jsonRequestBody.ServiceLinkedRoleARN;
        reqParams.cfn['VPCZoneIdentifier'] = jsonRequestBody.VPCZoneIdentifier.split(",");

        reqParams.tf['name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.tf['launch_configuration'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.tf['desired_capacity'] = jsonRequestBody.DesiredCapacity;
        reqParams.tf['min_size'] = jsonRequestBody.MinSize;
        reqParams.tf['max_size'] = jsonRequestBody.MaxSize;
        reqParams.tf['health_check_grace_period'] = jsonRequestBody.HealthCheckGracePeriod;
        if (jsonRequestBody.Tags && jsonRequestBody.Tags.length) {
            reqParams.tf['tag'] = [];
            for (var i=0; i<jsonRequestBody.Tags.length; i++) {
                reqParams.tf['tag'].push({
                    'key': jsonRequestBody.Tags[i].Key,
                    'value': jsonRequestBody.Tags[i].Value,
                    'propagate_at_launch': jsonRequestBody.Tags[i].PropagateAtLaunch
                });
            }
        }
        reqParams.tf['service_linked_role_arn'] = jsonRequestBody.ServiceLinkedRoleARN;
        reqParams.tf['vpc_zone_identifier'] = jsonRequestBody.VPCZoneIdentifier.split(",");

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'CreateAutoScalingGroup',
                'boto3': 'create_auto_scaling_group',
                'cli': 'create-auto-scaling-group'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('autoscaling', details.requestId),
            'region': region,
            'service': 'autoscaling',
            'type': 'AWS::AutoScaling::AutoScalingGroup',
            'terraformType': 'aws_autoscaling_group',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.PutScalingPolicy
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=PutScalingPolicy\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/" + jsonRequestBody.AutoScalingGroupName
        ];

        reqParams.boto3['PolicyName'] = jsonRequestBody.PolicyName;
        reqParams.cli['--policy-name'] = jsonRequestBody.PolicyName;
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.boto3['PolicyType'] = jsonRequestBody.PolicyType;
        reqParams.cli['--policy-type'] = jsonRequestBody.PolicyType;
        reqParams.boto3['TargetTrackingConfiguration'] = jsonRequestBody.TargetTrackingConfiguration;
        reqParams.cli['--target-tracking-configuration'] = jsonRequestBody.TargetTrackingConfiguration;
        reqParams.boto3['EstimatedInstanceWarmup'] = jsonRequestBody.EstimatedInstanceWarmup;
        reqParams.cli['--estimated-instance-warmup'] = jsonRequestBody.EstimatedInstanceWarmup;

        reqParams.cfn['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cfn['PolicyType'] = jsonRequestBody.PolicyType;
        reqParams.cfn['TargetTrackingConfiguration'] = jsonRequestBody.TargetTrackingConfiguration;
        reqParams.cfn['EstimatedInstanceWarmup'] = jsonRequestBody.EstimatedInstanceWarmup;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'PutScalingPolicy',
                'boto3': 'put_scaling_policy',
                'cli': 'put-scaling-policy'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('autoscaling', details.requestId),
            'region': region,
            'service': 'autoscaling',
            'type': 'AWS::AutoScaling::ScalingPolicy',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.PutNotificationConfiguration
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=PutNotificationConfiguration\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/" + jsonRequestBody.AutoScalingGroupName
        ];

        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.boto3['TopicARN'] = jsonRequestBody.TopicARN;
        reqParams.cli['--topic-arn'] = jsonRequestBody.TopicARN;
        reqParams.boto3['NotificationTypes'] = jsonRequestBody.NotificationTypes;
        reqParams.cli['--notification-types'] = jsonRequestBody.NotificationTypes;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'PutNotificationConfiguration',
                'boto3': 'put_notification_configuration',
                'cli': 'put-notification-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.DescribeScalingActivities
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DescribeScalingActivities\?/g)) {
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.boto3['NextToken'] = jsonRequestBody.NextToken;
        reqParams.cli['--next-token'] = jsonRequestBody.NextToken;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribeScalingActivities',
                'boto3': 'describe_scaling_activities',
                'cli': 'describe-scaling-activities'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.DescribePolicies
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DescribePolicies\?/g)) {
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribePolicies',
                'boto3': 'describe_policies',
                'cli': 'describe-policies'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.DescribeTags
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DescribeTags\?/g)) {
        reqParams.boto3['Filters'] = jsonRequestBody.Filters;
        reqParams.cli['--filters'] = jsonRequestBody.Filters;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribeTags',
                'boto3': 'describe_tags',
                'cli': 'describe-tags'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.DescribeScheduledActions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DescribeScheduledActions\?/g)) {
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribeScheduledActions',
                'boto3': 'describe_scheduled_actions',
                'cli': 'describe-scheduled-actions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.DescribeLifecycleHooks
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DescribeLifecycleHooks\?/g)) {
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribeLifecycleHooks',
                'boto3': 'describe_lifecycle_hooks',
                'cli': 'describe-lifecycle-hooks'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.DescribeNotificationConfigurations
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DescribeNotificationConfigurations\?/g)) {
        reqParams.boto3['AutoScalingGroupNames'] = jsonRequestBody.AutoScalingGroupNames;
        reqParams.cli['--auto-scaling-group-names'] = jsonRequestBody.AutoScalingGroupNames;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DescribeNotificationConfigurations',
                'boto3': 'describe_notification_configurations',
                'cli': 'describe-notification-configurations'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:autoscaling.DeleteLaunchConfiguration
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DeleteLaunchConfiguration\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:launchConfiguration:*:launchConfigurationName/" + jsonRequestBody.LaunchConfigurationName
        ];

        reqParams.boto3['LaunchConfigurationName'] = jsonRequestBody.LaunchConfigurationName;
        reqParams.cli['--launch-configuration-name'] = jsonRequestBody.LaunchConfigurationName;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DeleteLaunchConfiguration',
                'boto3': 'delete_launch_configuration',
                'cli': 'delete-launch-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.DeleteAutoScalingGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DeleteAutoScalingGroup\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/" + jsonRequestBody.AutoScalingGroupName
        ];

        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.boto3['ForceDelete'] = jsonRequestBody.ForceDelete;
        reqParams.cli['--force-delete'] = jsonRequestBody.ForceDelete;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DeleteAutoScalingGroup',
                'boto3': 'delete_auto_scaling_group',
                'cli': 'delete-auto-scaling-group'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.PutScheduledUpdateGroupAction
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=PutScheduledUpdateGroupAction\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/" + jsonRequestBody.AutoScalingGroupName
        ];
        
        reqParams.boto3['ScheduledActionName'] = jsonRequestBody.ScheduledActionName;
        reqParams.cli['--scheduled-action-name'] = jsonRequestBody.ScheduledActionName;
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.boto3['MinSize'] = jsonRequestBody.MinSize;
        reqParams.cli['--min-size'] = jsonRequestBody.MinSize;
        reqParams.boto3['MaxSize'] = jsonRequestBody.MaxSize;
        reqParams.cli['--max-size'] = jsonRequestBody.MaxSize;
        reqParams.boto3['DesiredCapacity'] = jsonRequestBody.DesiredCapacity;
        reqParams.cli['--desired-capacity'] = jsonRequestBody.DesiredCapacity;
        reqParams.boto3['StartTime'] = jsonRequestBody.StartTime;
        reqParams.cli['--start-time'] = jsonRequestBody.StartTime;

        reqParams.cfn['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cfn['MinSize'] = jsonRequestBody.MinSize;
        reqParams.cfn['MaxSize'] = jsonRequestBody.MaxSize;
        reqParams.cfn['DesiredCapacity'] = jsonRequestBody.DesiredCapacity;
        reqParams.cfn['StartTime'] = jsonRequestBody.StartTime;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'PutScheduledUpdateGroupAction',
                'boto3': 'put_scheduled_update_group_action',
                'cli': 'put-scheduled-update-group-action'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('autoscaling', details.requestId),
            'region': region,
            'service': 'autoscaling',
            'type': 'AWS::AutoScaling::ScheduledAction',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.DeleteScheduledAction
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DeleteScheduledAction\?&/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/" + jsonRequestBody.AutoScalingGroupName
        ];

        reqParams.boto3['ScheduledActionName'] = jsonRequestBody.ScheduledActionName;
        reqParams.cli['--scheduled-action-name'] = jsonRequestBody.ScheduledActionName;
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DeleteScheduledAction',
                'boto3': 'delete_scheduled_action',
                'cli': 'delete-scheduled-action'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.PutLifecycleHook
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=PutLifecycleHook\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/" + jsonRequestBody.AutoScalingGroupName
        ];

        reqParams.boto3['LifecycleHookName'] = jsonRequestBody.LifecycleHookName;
        reqParams.cli['--lifecycle-hook-name'] = jsonRequestBody.LifecycleHookName;
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.boto3['HeartbeatTimeout'] = jsonRequestBody.HeartbeatTimeout;
        reqParams.cli['--heartbeat-timeout'] = jsonRequestBody.HeartbeatTimeout;
        reqParams.boto3['NotificationMetadata'] = jsonRequestBody.NotificationMetadata;
        reqParams.cli['--notification-metadata'] = jsonRequestBody.NotificationMetadata;
        reqParams.boto3['DefaultResult'] = jsonRequestBody.DefaultResult;
        reqParams.cli['--default-result'] = jsonRequestBody.DefaultResult;
        reqParams.boto3['LifecycleTransition'] = jsonRequestBody.LifecycleTransition;
        reqParams.cli['--lifecycle-transition'] = jsonRequestBody.LifecycleTransition;

        reqParams.cfn['LifecycleHookName'] = jsonRequestBody.LifecycleHookName;
        reqParams.cfn['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cfn['HeartbeatTimeout'] = jsonRequestBody.HeartbeatTimeout;
        reqParams.cfn['NotificationMetadata'] = jsonRequestBody.NotificationMetadata;
        reqParams.cfn['DefaultResult'] = jsonRequestBody.DefaultResult;
        reqParams.cfn['LifecycleTransition'] = jsonRequestBody.LifecycleTransition;

        reqParams.tf['name'] = jsonRequestBody.LifecycleHookName;
        reqParams.tf['autoscaling_group_name'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.tf['heartbeat_timeout'] = jsonRequestBody.HeartbeatTimeout;
        reqParams.tf['notification_metadata'] = jsonRequestBody.NotificationMetadata;
        reqParams.tf['default_result'] = jsonRequestBody.DefaultResult;
        reqParams.tf['lifecycle_transition'] = jsonRequestBody.LifecycleTransition;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'PutLifecycleHook',
                'boto3': 'put_lifecycle_hook',
                'cli': 'put-lifecycle-hook'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('autoscaling', details.requestId),
            'region': region,
            'service': 'autoscaling',
            'type': 'AWS::AutoScaling::LifecycleHook',
            'terraformType': 'aws_autoscaling_lifecycle_hook',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:autoscaling.DeleteLifecycleHook
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/autoscaling\/acb\?call=DeleteLifecycleHook\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:autoscaling:*:*:autoScalingGroup:*:autoScalingGroupName/" + jsonRequestBody.AutoScalingGroupName
        ];

        reqParams.boto3['LifecycleHookName'] = jsonRequestBody.LifecycleHookName;
        reqParams.cli['--lifecycle-hook-name'] = jsonRequestBody.LifecycleHookName;
        reqParams.boto3['AutoScalingGroupName'] = jsonRequestBody.AutoScalingGroupName;
        reqParams.cli['--auto-scaling-group-name'] = jsonRequestBody.AutoScalingGroupName;

        outputs.push({
            'region': region,
            'service': 'autoscaling',
            'method': {
                'api': 'DeleteLifecycleHook',
                'boto3': 'delete_lifecycle_hook',
                'cli': 'delete-lifecycle-hook'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.DescribeComputeEnvironments
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "describecomputeenvironments") {

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'DescribeComputeEnvironments',
                'boto3': 'describe_compute_environments',
                'cli': 'describe-compute-environments'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:iam.ListRoles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/iam$/g) && jsonRequestBody.operation == "listRoles") {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListRoles',
                'boto3': 'list_roles',
                'cli': 'list-roles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:batch.DescribeJobDefinitions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "describeJobDefinitions") {

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'DescribeJobDefinitions',
                'boto3': 'describe_job_definitions',
                'cli': 'describe-job-definitions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:iam.ListInstanceProfiles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/iam$/g) && jsonRequestBody.operation == "ListInstanceProfiles") {
        reqParams.boto3['MaxItems'] = jsonRequestBody.params.MaxItems;
        reqParams.cli['--max-items'] = jsonRequestBody.params.MaxItems;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListInstanceProfiles',
                'boto3': 'list_instance_profiles',
                'cli': 'list-instance-profiles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/ec2$/g) && jsonRequestBody.operation == "DescribeVpcs") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:iam.ListInstanceProfiles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/iam$/g) && jsonRequestBody.operation == "ListInstanceProfiles") {
        reqParams.boto3['MaxItems'] = jsonRequestBody.params.MaxItems;
        reqParams.cli['--max-items'] = jsonRequestBody.params.MaxItems;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListInstanceProfiles',
                'boto3': 'list_instance_profiles',
                'cli': 'list-instance-profiles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/ec2$/g) && jsonRequestBody.operation == "DescribeSubnets") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:ec2.DescribeSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/ec2$/g) && jsonRequestBody.operation == "DescribeSecurityGroups") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSecurityGroups',
                'boto3': 'describe_security_groups',
                'cli': 'describe-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:iam.AttachRolePolicy
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/iam$/g) && jsonRequestBody.operation == "AttachRolePolicy") {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:role/" + jsonRequestBody.params.RoleName
        ];

        reqParams.boto3['PolicyArn'] = jsonRequestBody.params.PolicyArn;
        reqParams.cli['--policy-arn'] = jsonRequestBody.params.PolicyArn;
        reqParams.boto3['RoleName'] = jsonRequestBody.params.RoleName;
        reqParams.cli['--role-name'] = jsonRequestBody.params.RoleName;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'AttachRolePolicy',
                'boto3': 'attach_role_policy',
                'cli': 'attach-role-policy'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:iam.CreateInstanceProfile
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/iam$/g) && jsonRequestBody.operation == "CreateInstanceProfile") {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:instance-profile/" + jsonRequestBody.params.InstanceProfileName
        ];

        reqParams.boto3['InstanceProfileName'] = jsonRequestBody.params.InstanceProfileName;
        reqParams.cli['--instance-profile-name'] = jsonRequestBody.params.InstanceProfileName;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'CreateInstanceProfile',
                'boto3': 'create_instance_profile',
                'cli': 'create-instance-profile'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:iam.AddRoleToInstanceProfile
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/iam$/g) && jsonRequestBody.operation == "AddRoleToInstanceProfile") {
        reqParams.iam['Resource'] = [
            "arn:aws:iam::*:instance-profile/" + jsonRequestBody.params.InstanceProfileName
        ];
        reqParams.boto3['InstanceProfileName'] = jsonRequestBody.params.InstanceProfileName;
        reqParams.cli['--instance-profile-name'] = jsonRequestBody.params.InstanceProfileName;
        reqParams.boto3['RoleName'] = jsonRequestBody.params.RoleName;
        reqParams.cli['--role-name'] = jsonRequestBody.params.RoleName;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'AddRoleToInstanceProfile',
                'boto3': 'add_role_to_instance_profile',
                'cli': 'add-role-to-instance-profile'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.CreateComputeEnvironment
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "createcomputeenvironment") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['computeEnvironmentName'] = jsonRequestBody.contentString.computeEnvironmentName;
        reqParams.cli['--compute-environment-name'] = jsonRequestBody.contentString.computeEnvironmentName;
        reqParams.boto3['computeResources'] = jsonRequestBody.contentString.computeResources;
        reqParams.cli['--compute-resources'] = jsonRequestBody.contentString.computeResources;
        reqParams.boto3['serviceRole'] = jsonRequestBody.contentString.serviceRole;
        reqParams.cli['--service-role'] = jsonRequestBody.contentString.serviceRole;
        reqParams.boto3['state'] = jsonRequestBody.contentString.state;
        reqParams.cli['--state'] = jsonRequestBody.contentString.state;
        reqParams.boto3['type'] = jsonRequestBody.contentString.type;
        reqParams.cli['--type'] = jsonRequestBody.contentString.type;

        reqParams.cfn['ComputeEnvironmentName'] = jsonRequestBody.contentString.computeEnvironmentName;
        reqParams.cfn['ComputeResources'] = jsonRequestBody.contentString.computeResources;
        reqParams.cfn['ServiceRole'] = jsonRequestBody.contentString.serviceRole;
        reqParams.cfn['State'] = jsonRequestBody.contentString.state;
        reqParams.cfn['Type'] = jsonRequestBody.contentString.type;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'CreateComputeEnvironment',
                'boto3': 'create_compute_environment',
                'cli': 'create-compute-environment'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('batch', details.requestId),
            'region': region,
            'service': 'batch',
            'type': 'AWS::Batch::ComputeEnvironment',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.DescribeComputeEnvironments
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "describecomputeenvironments") {
        reqParams.boto3['computeEnvironments'] = jsonRequestBody.contentString.computeEnvironments;
        reqParams.cli['--compute-environments'] = jsonRequestBody.contentString.computeEnvironments;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'DescribeComputeEnvironments',
                'boto3': 'describe_compute_environments',
                'cli': 'describe-compute-environments'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:batch.CreateJobQueue
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "createjobqueue") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['ComputeEnvironmentOrder'] = jsonRequestBody.contentString.computeEnvironmentOrder;
        reqParams.cli['--compute-environment-order'] = jsonRequestBody.contentString.computeEnvironmentOrder;
        reqParams.boto3['JobQueueName'] = jsonRequestBody.contentString.jobQueueName;
        reqParams.cli['--job-queue-name'] = jsonRequestBody.contentString.jobQueueName;
        reqParams.boto3['Priority'] = jsonRequestBody.contentString.priority;
        reqParams.cli['--priority'] = jsonRequestBody.contentString.priority;
        reqParams.boto3['State'] = jsonRequestBody.contentString.state;
        reqParams.cli['--state'] = jsonRequestBody.contentString.state;

        reqParams.cfn['ComputeEnvironmentOrder'] = jsonRequestBody.contentString.computeEnvironmentOrder;
        reqParams.cfn['JobQueueName'] = jsonRequestBody.contentString.jobQueueName;
        reqParams.cfn['Priority'] = jsonRequestBody.contentString.priority;
        reqParams.cfn['State'] = jsonRequestBody.contentString.state;

        reqParams.tf['compute_environments'] = jsonRequestBody.contentString.computeEnvironmentOrder;
        reqParams.tf['name'] = jsonRequestBody.contentString.jobQueueName;
        reqParams.tf['priority'] = jsonRequestBody.contentString.priority;
        reqParams.tf['state'] = jsonRequestBody.contentString.state;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'CreateJobQueue',
                'boto3': 'create_job_queue',
                'cli': 'create-job-queue'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('batch', details.requestId),
            'region': region,
            'service': 'batch',
            'type': 'AWS::Batch::JobQueue',
            'terraformType': 'aws_batch_job_queue',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.RegisterJobDefinition
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "registerjobdefinition") {
        reqParams.iam['Resource'] = [
            "arn:aws:batch:*:*:job-definition/" + jsonRequestBody.contentString.jobDefinitionName + ":*"
        ];

        reqParams.boto3['containerProperties'] = jsonRequestBody.contentString.containerProperties;
        reqParams.cli['--container-properties'] = jsonRequestBody.contentString.containerProperties;
        reqParams.boto3['jobDefinitionName'] = jsonRequestBody.contentString.jobDefinitionName;
        reqParams.cli['--job-definition-name'] = jsonRequestBody.contentString.jobDefinitionName;
        reqParams.boto3['parameters'] = jsonRequestBody.contentString.parameters;
        reqParams.cli['--parameters'] = jsonRequestBody.contentString.parameters;
        reqParams.boto3['type'] = jsonRequestBody.contentString.type;
        reqParams.cli['--type'] = jsonRequestBody.contentString.type;

        reqParams.cfn['ContainerProperties'] = jsonRequestBody.contentString.containerProperties;
        reqParams.cfn['JobDefinitionName'] = jsonRequestBody.contentString.jobDefinitionName;
        reqParams.cfn['Parameters'] = jsonRequestBody.contentString.parameters;
        reqParams.cfn['Type'] = jsonRequestBody.contentString.type;

        reqParams.tf['container_properties'] = jsonRequestBody.contentString.containerProperties;
        reqParams.tf['name'] = jsonRequestBody.contentString.jobDefinitionName;
        reqParams.tf['parameters'] = jsonRequestBody.contentString.parameters;
        reqParams.tf['type'] = jsonRequestBody.contentString.type;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'RegisterJobDefinition',
                'boto3': 'register_job_definition',
                'cli': 'register-job-definition'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('batch', details.requestId),
            'region': region,
            'service': 'batch',
            'type': 'AWS::Batch::JobDefinition',
            'terraformType': 'aws_batch_job_definition',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.SubmitJob
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "submitjob") {
        reqParams.iam['Resource'] = [
            "arn:aws:batch:*:*:job-definition/" + jsonRequestBody.contentString.jobDefinitionName + ":*",
            "arn:aws:batch:*:*:job-queue/" + jsonRequestBody.contentString.jobQueue
        ];

        reqParams.boto3['jobDefinition'] = jsonRequestBody.contentString.jobDefinition;
        reqParams.cli['--job-definition'] = jsonRequestBody.contentString.jobDefinition;
        reqParams.boto3['jobName'] = jsonRequestBody.contentString.jobName;
        reqParams.cli['--job-name'] = jsonRequestBody.contentString.jobName;
        reqParams.boto3['jobQueue'] = jsonRequestBody.contentString.jobQueue;
        reqParams.cli['--job-queue'] = jsonRequestBody.contentString.jobQueue;
        reqParams.boto3['parameters'] = jsonRequestBody.contentString.parameters;
        reqParams.cli['--parameters'] = jsonRequestBody.contentString.parameters;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'SubmitJob',
                'boto3': 'submit_job',
                'cli': 'submit-job'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.ListJobs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "listjobs") {
        reqParams.boto3['jobQueue'] = jsonRequestBody.contentString.jobQueue;
        reqParams.cli['--job-queue'] = jsonRequestBody.contentString.jobQueue;
        reqParams.boto3['jobStatus'] = jsonRequestBody.contentString.jobStatus;
        reqParams.cli['--job-status'] = jsonRequestBody.contentString.jobStatus;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'ListJobs',
                'boto3': 'list_jobs',
                'cli': 'list-jobs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:batch:batch.CancelJob
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "cancelJob") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['jobId'] = jsonRequestBody.contentString.jobId;
        reqParams.cli['--job-id'] = jsonRequestBody.contentString.jobId;
        reqParams.boto3['reason'] = jsonRequestBody.contentString.reason;
        reqParams.cli['--reason'] = jsonRequestBody.contentString.reason;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'CancelJob',
                'boto3': 'cancel_job',
                'cli': 'cancel-job'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.DeleteComputeEnvironment
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "deletecomputeenvironment") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['computeEnvironment'] = jsonRequestBody.contentString.computeEnvironment;
        reqParams.cli['--compute-environment'] = jsonRequestBody.contentString.computeEnvironment;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'DeleteComputeEnvironment',
                'boto3': 'delete_compute_environment',
                'cli': 'delete-compute-environment'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.UpdateComputeEnvironment
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "updatecomputeenvironment") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['computeEnvironment'] = jsonRequestBody.contentString.computeEnvironment;
        reqParams.cli['--compute-environment'] = jsonRequestBody.contentString.computeEnvironment;
        reqParams.boto3['state'] = jsonRequestBody.contentString.state;
        reqParams.cli['--state'] = jsonRequestBody.contentString.state;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'UpdateComputeEnvironment',
                'boto3': 'update_compute_environment',
                'cli': 'update-compute-environment'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:batch:batch.DeregisterJobDefinition
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/batch\/api\/batch$/g) && jsonRequestBody.operation == "deregisterjobdefinition") {
        reqParams.iam['Resource'] = [
            "arn:aws:batch:*:*:job-definition/" + jsonRequestBody.contentString.jobDefinitionName + ":*"
        ];

        reqParams.boto3['jobDefinition'] = jsonRequestBody.contentString.jobDefinition;
        reqParams.cli['--job-definition'] = jsonRequestBody.contentString.jobDefinition;

        outputs.push({
            'region': region,
            'service': 'batch',
            'method': {
                'api': 'DeregisterJobDefinition',
                'boto3': 'deregister_job_definition',
                'cli': 'deregister-job-definition'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codedeploy:codedeploy.CreateApplication
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "createApplication") {
        reqParams.iam['Resource'] = [
            "arn:aws:codedeploy:*:*:application:" + jsonRequestBody.contentString.applicationName
        ];
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['applicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;
        reqParams.boto3['computePlatform'] = jsonRequestBody.contentString.computePlatform;
        reqParams.cli['--compute-platform'] = jsonRequestBody.contentString.computePlatform;

        reqParams.cfn['ApplicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cfn['ComputePlatform'] = jsonRequestBody.contentString.computePlatform;

        reqParams.tf['name'] = jsonRequestBody.contentString.applicationName;
        reqParams.tf['compute_platform'] = jsonRequestBody.contentString.computePlatform;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'CreateApplication',
                'boto3': 'create_application',
                'cli': 'create-application'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('codedeploy', details.requestId),
            'region': region,
            'service': 'codedeploy',
            'type': 'AWS::CodeDeploy::Application',
            'terraformType': 'aws_codedeploy_app',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codedeploy:codedeploy.GetApplication
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "getApplication") {
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['applicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'GetApplication',
                'boto3': 'get_application',
                'cli': 'get-application'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.ListApplicationRevisions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "listApplicationRevisions") {
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['ApplicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;
        reqParams.boto3['SortBy'] = jsonRequestBody.contentString.sortBy;
        reqParams.cli['--sort-by'] = jsonRequestBody.contentString.sortBy;
        reqParams.boto3['SortOrder'] = jsonRequestBody.contentString.sortOrder;
        reqParams.cli['--sort-order'] = jsonRequestBody.contentString.sortOrder;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'ListApplicationRevisions',
                'boto3': 'list_application_revisions',
                'cli': 'list-application-revisions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.ListDeploymentGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "listDeploymentGroups") {
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['applicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'ListDeploymentGroups',
                'boto3': 'list_deployment_groups',
                'cli': 'list-deployment-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.ListDeploymentConfigs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "listDeploymentConfigs") {
        reqParams.cli['_cli_service'] = "deploy";

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'ListDeploymentConfigs',
                'boto3': 'list_deployment_configs',
                'cli': 'list-deployment-configs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.CreateDeploymentGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "createDeploymentGroup") {
        reqParams.iam['Resource'] = [
            "arn:aws:codedeploy:*:*:deploymentgroup:" + jsonRequestBody.contentString.applicationName + "/" + jsonRequestBody.contentString.deploymentGroupName
        ];
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['deploymentConfigName'] = jsonRequestBody.contentString.deploymentConfigName;
        reqParams.cli['--deployment-config-name'] = jsonRequestBody.contentString.deploymentConfigName;
        reqParams.boto3['deploymentStyle'] = jsonRequestBody.contentString.deploymentStyle;
        reqParams.cli['--deployment-style'] = jsonRequestBody.contentString.deploymentStyle;
        reqParams.boto3['autoScalingGroups'] = jsonRequestBody.contentString.autoScalingGroups;
        reqParams.cli['--auto-scaling-groups'] = jsonRequestBody.contentString.autoScalingGroups;
        reqParams.boto3['ec2TagSet'] = jsonRequestBody.contentString.ec2TagSet;
        reqParams.cli['--ec-2-tag-set'] = jsonRequestBody.contentString.ec2TagSet;
        reqParams.boto3['onPremisesTagSet'] = jsonRequestBody.contentString.onPremisesTagSet;
        reqParams.cli['--on-premises-tag-set'] = jsonRequestBody.contentString.onPremisesTagSet;
        reqParams.boto3['applicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;
        reqParams.boto3['triggerConfigurations'] = jsonRequestBody.contentString.triggerConfigurations;
        reqParams.cli['--trigger-configurations'] = jsonRequestBody.contentString.triggerConfigurations;
        reqParams.boto3['serviceRoleArn'] = jsonRequestBody.contentString.serviceRoleArn;
        reqParams.cli['--service-role-arn'] = jsonRequestBody.contentString.serviceRoleArn;
        reqParams.boto3['autoRollbackConfiguration'] = jsonRequestBody.contentString.autoRollbackConfiguration;
        reqParams.cli['--auto-rollback-configuration'] = jsonRequestBody.contentString.autoRollbackConfiguration;
        reqParams.boto3['deploymentGroupName'] = jsonRequestBody.contentString.deploymentGroupName;
        reqParams.cli['--deployment-group-name'] = jsonRequestBody.contentString.deploymentGroupName;

        reqParams.cfn['DeploymentConfigName'] = jsonRequestBody.contentString.deploymentConfigName;
        reqParams.cfn['DeploymentStyle'] = jsonRequestBody.contentString.deploymentStyle;
        reqParams.cfn['AutoScalingGroups'] = jsonRequestBody.contentString.autoScalingGroups;
        reqParams.cfn['Ec2TagSet'] = jsonRequestBody.contentString.ec2TagSet;
        reqParams.cfn['OnPremisesInstanceTagSet'] = jsonRequestBody.contentString.onPremisesTagSet;
        reqParams.cfn['ApplicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cfn['TriggerConfigurations'] = jsonRequestBody.contentString.triggerConfigurations;
        reqParams.cfn['ServiceRoleArn'] = jsonRequestBody.contentString.serviceRoleArn;
        reqParams.cfn['AutoRollbackConfiguration'] = jsonRequestBody.contentString.autoRollbackConfiguration;
        reqParams.cfn['DeploymentGroupName'] = jsonRequestBody.contentString.deploymentGroupName;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'CreateDeploymentGroup',
                'boto3': 'create_deployment_group',
                'cli': 'create-deployment-group'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('codedeploy', details.requestId),
            'region': region,
            'service': 'codedeploy',
            'type': 'AWS::CodeDeploy::DeploymentGroup',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codedeploy:codedeploy.GetDeploymentGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "getDeploymentGroup") {
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['applicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;
        reqParams.boto3['deploymentGroupName'] = jsonRequestBody.contentString.deploymentGroupName;
        reqParams.cli['--deployment-group-name'] = jsonRequestBody.contentString.deploymentGroupName;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'GetDeploymentGroup',
                'boto3': 'get_deployment_group',
                'cli': 'get-deployment-group'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.ListDeployments
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "listDeployments") {
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['applicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;
        reqParams.boto3['deploymentGroupName'] = jsonRequestBody.contentString.deploymentGroupName;
        reqParams.cli['--deployment-group-name'] = jsonRequestBody.contentString.deploymentGroupName;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'ListDeployments',
                'boto3': 'list_deployments',
                'cli': 'list-deployments'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.ListDeploymentConfigs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "listDeploymentConfigs") {
        reqParams.cli['_cli_service'] = "deploy";

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'ListDeploymentConfigs',
                'boto3': 'list_deployment_configs',
                'cli': 'list-deployment-configs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.BatchGetDeploymentGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "batchGetDeploymentGroups") {
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['applicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;
        reqParams.boto3['deploymentGroupNames'] = jsonRequestBody.contentString.deploymentGroupNames;
        reqParams.cli['--deployment-group-names'] = jsonRequestBody.contentString.deploymentGroupNames;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'BatchGetDeploymentGroups',
                'boto3': 'batch_get_deployment_groups',
                'cli': 'batch-get-deployment-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.CreateDeployment
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "createDeployment") {
        reqParams.iam['Resource'] = [
            "arn:aws:codedeploy:*:*:deploymentgroup:" + jsonRequestBody.contentString.applicationName + "/" + jsonRequestBody.contentString.deploymentGroupName
        ];
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['applicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;
        reqParams.boto3['deploymentGroupName'] = jsonRequestBody.contentString.deploymentGroupName;
        reqParams.cli['--deployment-group-name'] = jsonRequestBody.contentString.deploymentGroupName;
        reqParams.boto3['description'] = jsonRequestBody.contentString.description;
        reqParams.cli['--description'] = jsonRequestBody.contentString.description;
        reqParams.boto3['autoRollbackConfiguration'] = jsonRequestBody.contentString.autoRollbackConfiguration;
        reqParams.cli['--auto-rollback-configuration'] = jsonRequestBody.contentString.autoRollbackConfiguration;
        reqParams.boto3['revision'] = jsonRequestBody.contentString.revision;
        reqParams.cli['--revision'] = jsonRequestBody.contentString.revision;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'CreateDeployment',
                'boto3': 'create_deployment',
                'cli': 'create-deployment'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codedeploy:codedeploy.StopDeployment
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "stopDeployment") {
        reqParams.iam['Resource'] = [
            "*"
        ];
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['autoRollbackEnabled'] = jsonRequestBody.contentString.autoRollbackEnabled;
        reqParams.cli['--auto-rollback-enabled'] = jsonRequestBody.contentString.autoRollbackEnabled;
        reqParams.boto3['deploymentId'] = jsonRequestBody.contentString.deploymentId;
        reqParams.cli['--deployment-id'] = jsonRequestBody.contentString.deploymentId;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'StopDeployment',
                'boto3': 'stop_deployment',
                'cli': 'stop-deployment'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codedeploy:codedeploy.CreateDeploymentConfig
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "createDeploymentConfig") {
        reqParams.iam['Resource'] = [
            "arn:aws:codedeploy:*:*:deploymentconfig:" + jsonRequestBody.contentString.deploymentConfigName
        ];
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['computePlatform'] = jsonRequestBody.contentString.computePlatform;
        reqParams.cli['--compute-platform'] = jsonRequestBody.contentString.computePlatform;
        reqParams.boto3['deploymentConfigName'] = jsonRequestBody.contentString.deploymentConfigName;
        reqParams.cli['--deployment-config-name'] = jsonRequestBody.contentString.deploymentConfigName;
        reqParams.boto3['minimumHealthyHosts'] = jsonRequestBody.contentString.minimumHealthyHosts;
        reqParams.cli['--minimum-healthy-hosts'] = jsonRequestBody.contentString.minimumHealthyHosts;

        reqParams.cfn['DeploymentConfigName'] = jsonRequestBody.contentString.deploymentConfigName;
        reqParams.cfn['MinimumHealthyHosts'] = jsonRequestBody.contentString.minimumHealthyHosts;

        reqParams.tf['deployment_config_name'] = jsonRequestBody.contentString.deploymentConfigName;
        reqParams.tf['minimum_healthy_hosts'] = jsonRequestBody.contentString.minimumHealthyHosts;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'CreateDeploymentConfig',
                'boto3': 'create_deployment_config',
                'cli': 'create-deployment-config'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('codedeploy', details.requestId),
            'region': region,
            'service': 'codedeploy',
            'type': 'AWS::CodeDeploy::DeploymentConfig',
            'terraformType': 'aws_codedeploy_deployment_config',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.DeleteDeploymentConfig
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "deleteDeploymentConfig") {
        reqParams.iam['Resource'] = [
            "arn:aws:codedeploy:*:*:deploymentconfig:" + jsonRequestBody.contentString.deploymentConfigName
        ];
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['deploymentConfigName'] = jsonRequestBody.contentString.deploymentConfigName;
        reqParams.cli['--deployment-config-name'] = jsonRequestBody.contentString.deploymentConfigName;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'DeleteDeploymentConfig',
                'boto3': 'delete_deployment_config',
                'cli': 'delete-deployment-config'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codedeploy:codedeploy.BatchGetDeployments
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "batchGetDeployments") {
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['deploymentIds'] = jsonRequestBody.contentString.deploymentIds;
        reqParams.cli['--deployment-ids'] = jsonRequestBody.contentString.deploymentIds;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'BatchGetDeployments',
                'boto3': 'batch_get_deployments',
                'cli': 'batch-get-deployments'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codedeploy:codedeploy.DeleteApplication
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codedeploy$/g) && jsonRequestBody.operation == "deleteApplication") {
        reqParams.iam['Resource'] = [
            "arn:aws:codedeploy:*:*:application:" + jsonRequestBody.contentString.applicationName
        ];
        reqParams.cli['_cli_service'] = "deploy";

        reqParams.boto3['ApplicationName'] = jsonRequestBody.contentString.applicationName;
        reqParams.cli['--application-name'] = jsonRequestBody.contentString.applicationName;

        outputs.push({
            'region': region,
            'service': 'codedeploy',
            'method': {
                'api': 'DeleteApplication',
                'boto3': 'delete_application',
                'cli': 'delete-application'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codepipeline:codepipeline.ListActionTypes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codepipeline$/g) && jsonRequestBody.operation == "listActionTypes") {

        outputs.push({
            'region': region,
            'service': 'codepipeline',
            'method': {
                'api': 'ListActionTypes',
                'boto3': 'list_action_types',
                'cli': 'list-action-types'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codepipeline:codepipeline.ListPipelines
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codepipeline$/g) && jsonRequestBody.operation == "listPipelines") {

        outputs.push({
            'region': region,
            'service': 'codepipeline',
            'method': {
                'api': 'ListPipelines',
                'boto3': 'list_pipelines',
                'cli': 'list-pipelines'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codebuild:codebuild.ListProjects
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codebuild$/g) && jsonRequestBody.operation == "listProjects") {

        outputs.push({
            'region': region,
            'service': 'codebuild',
            'method': {
                'api': 'ListProjects',
                'boto3': 'list_projects',
                'cli': 'list-projects'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codecommit:codecommit.ListRepositories
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codecommit$/g) && jsonRequestBody.operation == "listRepositories") {

        outputs.push({
            'region': region,
            'service': 'codecommit',
            'method': {
                'api': 'ListRepositories',
                'boto3': 'list_repositories',
                'cli': 'list-repositories'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codebuild:codebuild.ListCuratedEnvironmentImages
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codebuild$/g) && jsonRequestBody.operation == "listCuratedEnvironmentImages") {

        outputs.push({
            'region': region,
            'service': 'codebuild',
            'method': {
                'api': 'ListCuratedEnvironmentImages',
                'boto3': 'list_curated_environment_images',
                'cli': 'list-curated-environment-images'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codebuild:codebuild.CreateProject
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codebuild$/g) && jsonRequestBody.operation == "createProject") {
        reqParams.iam['Resource'] = [
            "arn:aws:codebuild:*:*:project/" + jsonRequestBody.contentString.name
        ];

        reqParams.boto3['timeoutInMinutes'] = jsonRequestBody.contentString.timeoutInMinutes;
        reqParams.cli['--timeout-in-minutes'] = jsonRequestBody.contentString.timeoutInMinutes;
        reqParams.boto3['artifacts'] = jsonRequestBody.contentString.artifacts;
        reqParams.cli['--artifacts'] = jsonRequestBody.contentString.artifacts;
        reqParams.boto3['cache'] = jsonRequestBody.contentString.cache;
        reqParams.cli['--cache'] = jsonRequestBody.contentString.cache;
        reqParams.boto3['description'] = jsonRequestBody.contentString.description;
        reqParams.cli['--description'] = jsonRequestBody.contentString.description;
        reqParams.boto3['environment'] = jsonRequestBody.contentString.environment;
        reqParams.cli['--environment'] = jsonRequestBody.contentString.environment;
        reqParams.boto3['serviceRole'] = jsonRequestBody.contentString.serviceRole;
        reqParams.cli['--service-role'] = jsonRequestBody.contentString.serviceRole;
        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;
        reqParams.boto3['source'] = jsonRequestBody.contentString.source;
        reqParams.cli['--source'] = jsonRequestBody.contentString.source;

        reqParams.cfn['TimeoutInMinutes'] = jsonRequestBody.contentString.timeoutInMinutes;
        reqParams.cfn['Artifacts'] = jsonRequestBody.contentString.artifacts;
        reqParams.cfn['Cache'] = jsonRequestBody.contentString.cache;
        reqParams.cfn['Description'] = jsonRequestBody.contentString.description;
        reqParams.cfn['Environment'] = jsonRequestBody.contentString.environment;
        reqParams.cfn['ServiceRole'] = jsonRequestBody.contentString.serviceRole;
        reqParams.cfn['Name'] = jsonRequestBody.contentString.name;
        reqParams.cfn['Source'] = jsonRequestBody.contentString.source;

        outputs.push({
            'region': region,
            'service': 'codebuild',
            'method': {
                'api': 'CreateProject',
                'boto3': 'create_project',
                'cli': 'create-project'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('codebuild', details.requestId),
            'region': region,
            'service': 'codebuild',
            'type': 'AWS::CodeBuild::Project',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codebuild:codebuild.BatchGetProjects
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codebuild$/g) && jsonRequestBody.operation == "batchGetProjects") {
        reqParams.boto3['names'] = jsonRequestBody.contentString.names;
        reqParams.cli['--names'] = jsonRequestBody.contentString.names;

        outputs.push({
            'region': region,
            'service': 'codebuild',
            'method': {
                'api': 'BatchGetProjects',
                'boto3': 'batch_get_projects',
                'cli': 'batch-get-projects'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codepipeline:codepipeline.CreatePipeline
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codepipeline$/g) && jsonRequestBody.operation == "createPipeline") {
        reqParams.iam['Resource'] = [
            "arn:aws:codepipeline:*:*:" + jsonRequestBody.contentString.pipeline.name
        ];

        reqParams.boto3['pipeline'] = jsonRequestBody.contentString.pipeline;
        reqParams.cli['--pipeline'] = jsonRequestBody.contentString.pipeline;

        reqParams.cfn['ArtifactStore'] = {
            'Location': jsonRequestBody.contentString.pipeline.artifactStore.location,
            'Type': jsonRequestBody.contentString.pipeline.artifactStore.type
        };
        reqParams.cfn['RoleArn'] = jsonRequestBody.contentString.pipeline.roleArn;
        reqParams.cfn['Name'] = jsonRequestBody.contentString.pipeline.name;
        reqParams.cfn['Stages'] = [];
        for (var i=0; i<jsonRequestBody.contentString.pipeline.stages.length; i++) {
            var actions = [];
            for (var j=0; j<jsonRequestBody.contentString.pipeline.stages[i].actions.length; j++) {
                var input_artifacts = null;
                if (jsonRequestBody.contentString.pipeline.stages[i].actions[j].inputArtifacts.length) {
                    input_artifacts = [];
                    for (var k=0; k<jsonRequestBody.contentString.pipeline.stages[i].actions[j].inputArtifacts.length; k++) {
                        input_artifacts.push({
                            'Name': jsonRequestBody.contentString.pipeline.stages[i].actions[j].inputArtifacts[k].name
                        });
                    }
                }
                var output_artifacts = null;
                if (jsonRequestBody.contentString.pipeline.stages[i].actions[j].outputArtifacts.length) {
                    output_artifacts = [];
                    for (var k=0; k<jsonRequestBody.contentString.pipeline.stages[i].actions[j].outputArtifacts.length; k++) {
                        output_artifacts.push({
                            'Name': jsonRequestBody.contentString.pipeline.stages[i].actions[j].outputArtifacts[k].name
                        });
                    }
                }
                actions.push({
                    'Name': jsonRequestBody.contentString.pipeline.stages[i].actions[j].name,
                    'ActionTypeId': {
                        'Category': jsonRequestBody.contentString.pipeline.stages[i].actions[j].actionTypeId.category,
                        'Owner': jsonRequestBody.contentString.pipeline.stages[i].actions[j].actionTypeId.owner,
                        'Provider': jsonRequestBody.contentString.pipeline.stages[i].actions[j].actionTypeId.provider,
                        'Version': jsonRequestBody.contentString.pipeline.stages[i].actions[j].actionTypeId.version
                    },
                    'Configuration': jsonRequestBody.contentString.pipeline.stages[i].actions[j].configuration,
                    'Region': jsonRequestBody.contentString.pipeline.stages[i].actions[j].region,
                    'InputArtifacts': input_artifacts,
                    'OutputArtifacts': output_artifacts
                });
            }
            reqParams.cfn['Stages'].push({
                'Name': jsonRequestBody.contentString.pipeline.stages[i].name,
                'Actions': actions
            });
        }

        reqParams.tf['artifact_store'] = jsonRequestBody.contentString.pipeline.artifactStore;
        reqParams.tf['role_arn'] = jsonRequestBody.contentString.pipeline.roleArn;
        reqParams.tf['name'] = jsonRequestBody.contentString.pipeline.name;
        reqParams.tf['stages'] = jsonRequestBody.contentString.pipeline.stages;

        outputs.push({
            'region': region,
            'service': 'codepipeline',
            'method': {
                'api': 'CreatePipeline',
                'boto3': 'create_pipeline',
                'cli': 'create-pipeline'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('codepipeline', details.requestId),
            'region': region,
            'service': 'codepipeline',
            'type': 'AWS::CodePipeline::Pipeline',
            'terraformType': 'aws_codepipeline',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codepipeline:codepipeline.GetPipeline
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codepipeline$/g) && jsonRequestBody.operation == "getPipeline") {
        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;

        outputs.push({
            'region': region,
            'service': 'codepipeline',
            'method': {
                'api': 'GetPipeline',
                'boto3': 'get_pipeline',
                'cli': 'get-pipeline'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codepipeline:codepipeline.GetPipelineState
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codepipeline$/g) && jsonRequestBody.operation == "getPipelineState") {
        reqParams.boto3['Name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;

        outputs.push({
            'region': region,
            'service': 'codepipeline',
            'method': {
                'api': 'GetPipelineState',
                'boto3': 'get_pipeline_state',
                'cli': 'get-pipeline-state'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codepipeline:codepipeline.GetPipelineExecution
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codepipeline$/g) && jsonRequestBody.operation == "getPipelineExecution") {
        reqParams.boto3['pipelineExecutionId'] = jsonRequestBody.contentString.pipelineExecutionId;
        reqParams.cli['--pipeline-execution-id'] = jsonRequestBody.contentString.pipelineExecutionId;
        reqParams.boto3['pipelineName'] = jsonRequestBody.contentString.pipelineName;
        reqParams.cli['--pipeline-name'] = jsonRequestBody.contentString.pipelineName;

        outputs.push({
            'region': region,
            'service': 'codepipeline',
            'method': {
                'api': 'GetPipelineExecution',
                'boto3': 'get_pipeline_execution',
                'cli': 'get-pipeline-execution'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codepipeline:codepipeline.UpdatePipeline
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codepipeline$/g) && jsonRequestBody.operation == "updatePipeline") {
        reqParams.iam['Resource'] = [
            "arn:aws:codepipeline:*:*:" + jsonRequestBody.contentString.pipeline.name
        ];

        reqParams.boto3['pipeline'] = jsonRequestBody.contentString.pipeline;
        reqParams.cli['--pipeline'] = jsonRequestBody.contentString.pipeline;

        outputs.push({
            'region': region,
            'service': 'codepipeline',
            'method': {
                'api': 'UpdatePipeline',
                'boto3': 'update_pipeline',
                'cli': 'update-pipeline'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codepipeline:codepipeline.DeletePipeline
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codepipeline$/g) && jsonRequestBody.operation == "deletePipeline") {
        reqParams.iam['Resource'] = [
            "arn:aws:codepipeline:*:*:" + jsonRequestBody.contentString.name
        ];

        reqParams.boto3['name'] = jsonRequestBody.contentString.name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.name;

        outputs.push({
            'region': region,
            'service': 'codepipeline',
            'method': {
                'api': 'DeletePipeline',
                'boto3': 'delete_pipeline',
                'cli': 'delete-pipeline'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codecommit:codecommit.CreateRepository
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codecommit$/g) && jsonRequestBody.operation == "createRepository") {
        reqParams.iam['Resource'] = [
            "arn:aws:codecommit:*:*:" + jsonRequestBody.contentString.repositoryName
        ];

        reqParams.boto3['repositoryName'] = jsonRequestBody.contentString.repositoryName;
        reqParams.cli['--repository-name'] = jsonRequestBody.contentString.repositoryName;
        reqParams.boto3['repositoryDescription'] = jsonRequestBody.contentString.repositoryDescription;
        reqParams.cli['--repository-description'] = jsonRequestBody.contentString.repositoryDescription;

        reqParams.cfn['RepositoryName'] = jsonRequestBody.contentString.repositoryName;
        reqParams.cfn['RepositoryDescription'] = jsonRequestBody.contentString.repositoryDescription;

        reqParams.tf['repository_name'] = jsonRequestBody.contentString.repositoryName;
        reqParams.tf['description'] = jsonRequestBody.contentString.repositoryDescription;

        outputs.push({
            'region': region,
            'service': 'codecommit',
            'method': {
                'api': 'CreateRepository',
                'boto3': 'create_repository',
                'cli': 'create-repository'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('codecommit', details.requestId),
            'region': region,
            'service': 'codecommit',
            'type': 'AWS::CodeCommit::Repository',
            'terraformType': 'aws_codecommit_repository',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:codecommit:codecommit.GetRepository
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codecommit$/g) && jsonRequestBody.operation == "getRepository") {
        reqParams.boto3['repositoryName'] = jsonRequestBody.contentString.repositoryName;
        reqParams.cli['--repository-name'] = jsonRequestBody.contentString.repositoryName;

        outputs.push({
            'region': region,
            'service': 'codecommit',
            'method': {
                'api': 'GetRepository',
                'boto3': 'get_repository',
                'cli': 'get-repository'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codecommit:codecommit.ListRepositories
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codecommit$/g) && jsonRequestBody.operation == "listRepositories") {
        reqParams.boto3['SortBy'] = jsonRequestBody.contentString.sortBy;
        reqParams.cli['--sort-by'] = jsonRequestBody.contentString.sortBy;
        reqParams.boto3['Order'] = jsonRequestBody.contentString.order;
        reqParams.cli['--order'] = jsonRequestBody.contentString.order;

        outputs.push({
            'region': region,
            'service': 'codecommit',
            'method': {
                'api': 'ListRepositories',
                'boto3': 'list_repositories',
                'cli': 'list-repositories'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codecommit:codecommit.ListPullRequests
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codecommit$/g) && jsonRequestBody.operation == "listPullRequests") {
        reqParams.boto3['maxResults'] = jsonRequestBody.contentString.maxResults;
        reqParams.cli['--max-results'] = jsonRequestBody.contentString.maxResults;
        reqParams.boto3['repositoryName'] = jsonRequestBody.contentString.repositoryName;
        reqParams.cli['--repository-name'] = jsonRequestBody.contentString.repositoryName;
        reqParams.boto3['pullRequestStatus'] = jsonRequestBody.contentString.pullRequestStatus;
        reqParams.cli['--pull-request-status'] = jsonRequestBody.contentString.pullRequestStatus;

        outputs.push({
            'region': region,
            'service': 'codecommit',
            'method': {
                'api': 'ListPullRequests',
                'boto3': 'list_pull_requests',
                'cli': 'list-pull-requests'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:codecommit:codecommit.DeleteRepository
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/codesuite\/api\/codecommit$/g) && jsonRequestBody.operation == "deleteRepository") {
        reqParams.iam['Resource'] = [
            "arn:aws:codecommit:*:*:" + jsonRequestBody.contentString.repositoryName
        ];

        reqParams.boto3['repositoryName'] = jsonRequestBody.contentString.repositoryName;
        reqParams.cli['--repository-name'] = jsonRequestBody.contentString.repositoryName;

        outputs.push({
            'region': region,
            'service': 'codecommit',
            'method': {
                'api': 'DeleteRepository',
                'boto3': 'delete_repository',
                'cli': 'delete-repository'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.ProvisionProduct
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/stack\/launch\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Tags'] = jsonRequestBody.tags;
        reqParams.cli['--tags'] = jsonRequestBody.tags;
        reqParams.boto3['NotificationArns'] = jsonRequestBody.notificationArns;
        reqParams.cli['--notification-arns'] = jsonRequestBody.notificationArns;
        reqParams.boto3['ProvisioningParameters'] = jsonRequestBody.provisioningParameters;
        reqParams.cli['--provisioning-parameters'] = jsonRequestBody.provisioningParameters;
        reqParams.boto3['ProvisionedProductName'] = jsonRequestBody.provisionedProductName;
        reqParams.cli['--provisioned-product-name'] = jsonRequestBody.provisionedProductName;
        reqParams.boto3['ProductId'] = jsonRequestBody.productId;
        reqParams.cli['--product-id'] = jsonRequestBody.productId;
        reqParams.boto3['ProvisioningArtifactId'] = jsonRequestBody.provisioningArtifactId;
        reqParams.cli['--provisioning-artifact-id'] = jsonRequestBody.provisioningArtifactId;
        reqParams.boto3['PathId'] = jsonRequestBody.pathId;
        reqParams.cli['--path-id'] = jsonRequestBody.pathId;
        reqParams.boto3['ProvisionToken'] = jsonRequestBody.provisionToken;
        reqParams.cli['--provision-token'] = jsonRequestBody.provisionToken;

        reqParams.cfn['Tags'] = jsonRequestBody.tags;
        reqParams.cfn['NotificationArns'] = jsonRequestBody.notificationArns;
        reqParams.cfn['ProvisioningParameters'] = jsonRequestBody.provisioningParameters;
        reqParams.cfn['ProductName'] = jsonRequestBody.provisionedProductName;
        reqParams.cfn['ProductId'] = jsonRequestBody.productId;
        reqParams.cfn['ProvisioningArtifactId'] = jsonRequestBody.provisioningArtifactId;
        reqParams.cfn['PathId'] = jsonRequestBody.pathId;

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'ProvisionProduct',
                'boto3': 'provision_product',
                'cli': 'provision-product'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        tracked_resources.push({
            'logicalId': getResourceName('servicecatalog', details.requestId),
            'region': region,
            'service': 'servicecatalog',
            'type': 'AWS::ServiceCatalog::CloudFormationProvisionedProduct',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.CreateProduct
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/product\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Name'] = jsonRequestBody.name;
        reqParams.cli['--name'] = jsonRequestBody.name;
        reqParams.boto3['Description'] = jsonRequestBody.description;
        reqParams.cli['--description'] = jsonRequestBody.description;
        reqParams.boto3['Owner'] = jsonRequestBody.owner;
        reqParams.cli['--owner'] = jsonRequestBody.owner;
        reqParams.boto3['Distributor'] = jsonRequestBody.distributor;
        reqParams.cli['--distributor'] = jsonRequestBody.distributor;
        reqParams.boto3['SupportEmail'] = jsonRequestBody.supportEmail;
        reqParams.cli['--support-email'] = jsonRequestBody.supportEmail;
        reqParams.boto3['SupportUrl'] = jsonRequestBody.supportUrl;
        reqParams.cli['--support-url'] = jsonRequestBody.supportUrl;
        reqParams.boto3['SupportDescription'] = jsonRequestBody.supportDescription;
        reqParams.cli['--support-description'] = jsonRequestBody.supportDescription;
        reqParams.boto3['ProvisioningArtifactParameters'] = jsonRequestBody.provisioningArtifactParameters;
        reqParams.cli['--provisioning-artifact-parameters'] = jsonRequestBody.provisioningArtifactParameters;
        reqParams.boto3['Name'] = jsonRequestBody.provisioningArtifactParameters.name;
        reqParams.cli['--name'] = jsonRequestBody.provisioningArtifactParameters.name;
        reqParams.boto3['Description'] = jsonRequestBody.provisioningArtifactParameters.description;
        reqParams.cli['--description'] = jsonRequestBody.provisioningArtifactParameters.description;
        reqParams.boto3['ProductType'] = jsonRequestBody.productType;
        reqParams.cli['--product-type'] = jsonRequestBody.productType;
        reqParams.boto3['IdempotencyToken'] = jsonRequestBody.idempotencyToken;
        reqParams.cli['--idempotency-token'] = jsonRequestBody.idempotencyToken;

        reqParams.cfn['Name'] = jsonRequestBody.name;
        reqParams.cfn['Description'] = jsonRequestBody.description;
        reqParams.cfn['Owner'] = jsonRequestBody.owner;
        reqParams.cfn['Distributor'] = jsonRequestBody.distributor;
        reqParams.cfn['SupportEmail'] = jsonRequestBody.supportEmail;
        reqParams.cfn['SupportUrl'] = jsonRequestBody.supportUrl;
        reqParams.cfn['SupportDescription'] = jsonRequestBody.supportDescription;
        if (jsonRequestBody.provisioningArtifactParameters) {
            reqParams.cfn['ProvisioningArtifactParameters'] = [{
                'Name': jsonRequestBody.provisioningArtifactParameters.name,
                'Description': jsonRequestBody.provisioningArtifactParameters.description,
                'Info': jsonRequestBody.provisioningArtifactParameters.info
            }];
        }
        reqParams.cfn['Name'] = jsonRequestBody.provisioningArtifactParameters.name;
        reqParams.cfn['Description'] = jsonRequestBody.provisioningArtifactParameters.description;

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'CreateProduct',
                'boto3': 'create_product',
                'cli': 'create-product'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (jsonRequestBody.productType == "CLOUD_FORMATION_TEMPLATE") {
            tracked_resources.push({
                'logicalId': getResourceName('servicecatalog', details.requestId),
                'region': region,
                'service': 'servicecatalog',
                'type': 'AWS::ServiceCatalog::CloudFormationProduct',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });
        }

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.ListPortfolios
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/portfolio\/list\?/g)) {
        reqParams.boto3['PageSize'] = getUrlValue(details.url, 'pageSize');
        reqParams.cli['--page-size'] = getUrlValue(details.url, 'pageSize');

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'ListPortfolios',
                'boto3': 'list_portfolios',
                'cli': 'list-portfolios'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.CreatePortfolio
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/portfolio\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['DisplayName'] = jsonRequestBody.displayName;
        reqParams.cli['--display-name'] = jsonRequestBody.displayName;
        reqParams.boto3['Description'] = jsonRequestBody.description;
        reqParams.cli['--description'] = jsonRequestBody.description;
        reqParams.boto3['ProviderName'] = jsonRequestBody.providerName;
        reqParams.cli['--provider-name'] = jsonRequestBody.providerName;
        reqParams.boto3['Tags'] = jsonRequestBody.tags;
        reqParams.cli['--tags'] = jsonRequestBody.tags;
        reqParams.boto3['IdempotencyToken'] = jsonRequestBody.idempotencyToken;
        reqParams.cli['--idempotency-token'] = jsonRequestBody.idempotencyToken;

        reqParams.cfn['DisplayName'] = jsonRequestBody.displayName;
        reqParams.cfn['Description'] = jsonRequestBody.description;
        reqParams.cfn['ProviderName'] = jsonRequestBody.providerName;
        reqParams.cfn['Tags'] = jsonRequestBody.tags;

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'CreatePortfolio',
                'boto3': 'create_portfolio',
                'cli': 'create-portfolio'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('servicecatalog', details.requestId),
            'region': region,
            'service': 'servicecatalog',
            'type': 'AWS::ServiceCatalog::Portfolio',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.AssociateProductWithPortfolio
    if (details.method == "PUT" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/product\/portfolio\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['PortfolioId'] = jsonRequestBody.portfolioId;
        reqParams.cli['--portfolio-id'] = jsonRequestBody.portfolioId;
        reqParams.boto3['ProductId'] = jsonRequestBody.productId;
        reqParams.cli['--product-id'] = jsonRequestBody.productId;
        reqParams.boto3['SourcePortfolioId'] = jsonRequestBody.sourcePortfolioId;
        reqParams.cli['--source-portfolio-id'] = jsonRequestBody.sourcePortfolioId;

        reqParams.cfn['PortfolioId'] = jsonRequestBody.portfolioId;
        reqParams.cfn['ProductId'] = jsonRequestBody.productId;
        reqParams.cfn['SourcePortfolioId'] = jsonRequestBody.sourcePortfolioId;

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'AssociateProductWithPortfolio',
                'boto3': 'associate_product_with_portfolio',
                'cli': 'associate-product-with-portfolio'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('servicecatalog', details.requestId),
            'region': region,
            'service': 'servicecatalog',
            'type': 'AWS::ServiceCatalog::PortfolioProductAssociation',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.CreatePortfolioShare
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/portfolio\/share\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['PortfolioId'] = jsonRequestBody.portfolioId;
        reqParams.cli['--portfolio-id'] = jsonRequestBody.portfolioId;
        reqParams.boto3['AccountId'] = jsonRequestBody.accountId;
        reqParams.cli['--account-id'] = jsonRequestBody.accountId;

        reqParams.cfn['PortfolioId'] = jsonRequestBody.portfolioId;
        reqParams.cfn['AccountId'] = jsonRequestBody.accountId;

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'CreatePortfolioShare',
                'boto3': 'create_portfolio_share',
                'cli': 'create-portfolio-share'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('servicecatalog', details.requestId),
            'region': region,
            'service': 'servicecatalog',
            'type': 'AWS::ServiceCatalog::PortfolioShare',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.ListTagOptions
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/tagOption\/list\?/g)) {
        reqParams.boto3['PageSize'] = getUrlValue(details.url, 'pageSize');
        reqParams.cli['--page-size'] = getUrlValue(details.url, 'pageSize');

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'ListTagOptions',
                'boto3': 'list_tag_options',
                'cli': 'list-tag-options'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.CreateTagOption
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/tagOption\/create\?/g)) {
        reqParams.boto3['Key'] = jsonRequestBody.key;
        reqParams.cli['--key'] = jsonRequestBody.key;
        reqParams.boto3['Value'] = jsonRequestBody.value;
        reqParams.cli['--value'] = jsonRequestBody.value;

        reqParams.cfn['Key'] = jsonRequestBody.key;
        reqParams.cfn['Value'] = jsonRequestBody.value;

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'CreateTagOption',
                'boto3': 'create_tag_option',
                'cli': 'create-tag-option'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('servicecatalog', details.requestId),
            'region': region,
            'service': 'servicecatalog',
            'type': 'AWS::ServiceCatalog::TagOption',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.DescribeTagOption
    if (details.method == "GET" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/tagOption\/describe\?/g)) {
        reqParams.boto3['Id'] = getUrlValue(details.url, 'id');
        reqParams.cli['--id'] = getUrlValue(details.url, 'id');

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'DescribeTagOption',
                'boto3': 'describe_tag_option',
                'cli': 'describe-tag-option'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.AssociateTagOptionWithResource
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/tagOption\/associate\?/g)) {
        reqParams.boto3['ResourceId'] = jsonRequestBody.resourceId;
        reqParams.cli['--resource-id'] = jsonRequestBody.resourceId;
        reqParams.boto3['TagOptionId'] = jsonRequestBody.tagOptionId;
        reqParams.cli['--tag-option-id'] = jsonRequestBody.tagOptionId;

        reqParams.cfn['ResourceId'] = jsonRequestBody.resourceId;
        reqParams.cfn['TagOptionId'] = jsonRequestBody.tagOptionId;

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'AssociateTagOptionWithResource',
                'boto3': 'associate_tag_option_with_resource',
                'cli': 'associate-tag-option-with-resource'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('servicecatalog', details.requestId),
            'region': region,
            'service': 'servicecatalog',
            'type': 'AWS::ServiceCatalog::TagOptionAssociation',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:servicecatalog:servicecatalog.AssociatePrincipalWithPortfolio
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/servicecatalog\/service\/portfolio\/principal\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['PortfolioId'] = jsonRequestBody.portfolioId;
        reqParams.cli['--portfolio-id'] = jsonRequestBody.portfolioId;
        reqParams.boto3['PrincipalARN'] = jsonRequestBody.principalARN;
        reqParams.cli['--principal-arn'] = jsonRequestBody.principalARN;
        reqParams.boto3['PrincipalType'] = jsonRequestBody.principalType;
        reqParams.cli['--principal-type'] = jsonRequestBody.principalType;

        reqParams.cfn['PortfolioId'] = jsonRequestBody.portfolioId;
        reqParams.cfn['PrincipalARN'] = jsonRequestBody.principalARN;
        reqParams.cfn['PrincipalType'] = jsonRequestBody.principalType;

        outputs.push({
            'region': region,
            'service': 'servicecatalog',
            'method': {
                'api': 'AssociatePrincipalWithPortfolio',
                'boto3': 'associate_principal_with_portfolio',
                'cli': 'associate-principal-with-portfolio'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('servicecatalog', details.requestId),
            'region': region,
            'service': 'servicecatalog',
            'type': 'AWS::ServiceCatalog::PortfolioPrincipalAssociation',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // manual:elasticache:ec2.DescribeSecurityGroups
    // manual:elasticache:elasticache.DescribeCacheClusters
    // manual:elasticache:elasticache.DescribeCacheEngineVersions
    // manual:elasticache:elasticache.DescribeCacheParameterGroups
    // manual:elasticache:elasticache.DescribeCacheSubnetGroups
    // manual:elasticache:ec2.DescribeVpcs
    // manual:elasticache:sns.ListTopics
    // manual:elasticache:ec2.DescribeSubnets
    // manual:elasticache:elasticache.CreateCacheSubnetGroup
    // manual:elasticache:elasticache.CreateCacheCluster
    // manual:elasticache:elasticache.DescribeReservedCacheNodes
    // manual:elasticache:elasticache.DescribeReplicationGroups
    // manual:elasticache:elasticache.DescribeSnapshots
    // manual:elasticache:elasticache.CreateCacheParameterGroup
    // manual:elasticache:ec2.DescribeAvailabilityZones
    // manual:elasticache:elasticache.CreateReplicationGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/elasticache\/rpc$/g)) {
        for (var i in jsonRequestBody.actions) {
            var action = jsonRequestBody.actions[i];
            if (action['action'] == "EC2.DescribeSecurityGroupsDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeSecurityGroups',
                        'boto3': 'describe_security_groups',
                        'cli': 'describe-security-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.CacheClusterContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'DescribeCacheClusters',
                        'boto3': 'describe_cache_clusters',
                        'cli': 'describe-cache-clusters'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.CacheEngineVersionContext.describeCacheEngineVersions") {
                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'DescribeCacheEngineVersions',
                        'boto3': 'describe_cache_engine_versions',
                        'cli': 'describe-cache-engine-versions'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.CacheParameterGroupContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'DescribeCacheParameterGroups',
                        'boto3': 'describe-cache-parameter_groups',
                        'cli': 'describe_cache_parameter_groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.CacheSubnetGroupContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'DescribeCacheSubnetGroups',
                        'boto3': 'describe_cache_subnet_groups',
                        'cli': 'describe-cache-engine-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.gwt.ec2.requestfactory.shared.Ec2Context.describeVpcs") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeVpcs',
                        'boto3': 'describe_vpcs',
                        'cli': 'describe-vpcs'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.gwt.sns.requestfactory.shared.SnsRequestContext.listTopicArnsWithLimitedRecords") {
                outputs.push({
                    'region': region,
                    'service': 'sns',
                    'method': {
                        'api': 'ListTopics',
                        'boto3': 'list_topics',
                        'cli': 'list-topics'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "EC2.DescribeSubnetsDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeSubnets',
                        'boto3': 'describe_subnets',
                        'cli': 'describe-subnets'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.CacheSubnetGroupContext.create") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['CacheSubnetGroupName'] = action['parameters'][0]['cacheSubnetGroupName'];
                reqParams.cli['--cache-subnet-group-name'] = action['parameters'][0]['cacheSubnetGroupName'];
                reqParams.boto3['CacheSubnetGroupDescription'] = action['parameters'][0]['cacheSubnetGroupDescription'];
                reqParams.cli['--cache-subnet-group-description'] = action['parameters'][0]['cacheSubnetGroupDescription'];
                reqParams.boto3['SubnetIds'] = action['parameters'][0]['subnetIds'];
                reqParams.cli['--subnet-ids'] = action['parameters'][0]['subnetIds'];

                reqParams.cfn['CacheSubnetGroupName'] = action['parameters'][0]['cacheSubnetGroupName'];
                reqParams.cfn['Description'] = action['parameters'][0]['cacheSubnetGroupDescription'];
                reqParams.cfn['SubnetIds'] = action['parameters'][0]['subnetIds'];

                reqParams.tf['name'] = action['parameters'][0]['cacheSubnetGroupName'];
                reqParams.tf['description'] = action['parameters'][0]['cacheSubnetGroupDescription'];
                reqParams.tf['subnet_ids'] = action['parameters'][0]['subnetIds'];

                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'CreateCacheSubnetGroup',
                        'boto3': 'create_cache_subnet_group',
                        'cli': 'create-cache-subnet-group'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('elasticache', details.requestId),
                    'region': region,
                    'service': 'elasticache',
                    'type': 'AWS::ElastiCache::SubnetGroup',
                    'terraformType': 'aws_elasticache_subnet_group',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "amazon.acs.acsconsole.shared.CacheClusterContext.create") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.iam['secondary'] = [
                    {
                        'Action': [
                            'ec2:CreateNetworkInterface',
                            'ec2:DeleteNetworkInterface',
                            'ec2:DescribeNetworkInterfaces',
                            'ec2:DescribeSubnets',
                            'ec2:DescribeVpcs'
                        ],
                        'Resource': [
                            '*'
                        ]
                    },
                    {
                        'Action': [
                            's3:GetObject'
                        ],
                        'Resource': [
                            'arn:aws:s3:::*/*'
                        ]
                    }
                ];
                
                reqParams.boto3['NumCacheNodes'] = action['parameters'][0]['numCacheNodes'];
                reqParams.cli['--num-cache-nodes'] = action['parameters'][0]['numCacheNodes'];
                reqParams.boto3['Port'] = action['parameters'][0]['port'];
                reqParams.cli['--port'] = action['parameters'][0]['port'];
                reqParams.boto3['CacheClusterId'] = action['parameters'][0]['cacheClusterId'];
                reqParams.cli['--cache-cluster-id'] = action['parameters'][0]['cacheClusterId'];
                reqParams.boto3['CacheNodeType'] = action['parameters'][0]['cacheNodeType'];
                reqParams.cli['--cache-node-type'] = action['parameters'][0]['cacheNodeType'];
                reqParams.boto3['CacheParameterGroupName'] = action['parameters'][0]['cacheParameterGroupName'];
                reqParams.cli['--cache-parameter-group-name'] = action['parameters'][0]['cacheParameterGroupName'];
                reqParams.boto3['CacheSubnetGroupName'] = action['parameters'][0]['cacheSubnetGroupName'];
                reqParams.cli['--cache-subnet-group-name'] = action['parameters'][0]['cacheSubnetGroupName'];
                reqParams.boto3['Engine'] = action['parameters'][0]['engine'];
                reqParams.cli['--engine'] = action['parameters'][0]['engine'];
                reqParams.boto3['EngineVersion'] = action['parameters'][0]['engineVersion'];
                reqParams.cli['--engine-version'] = action['parameters'][0]['engineVersion'];
                reqParams.boto3['NotificationTopicArn'] = action['parameters'][0]['notificationTopicArn'];
                reqParams.cli['--notification-topic-arn'] = action['parameters'][0]['notificationTopicArn'];
                reqParams.boto3['PreferredMaintenanceWindow'] = action['parameters'][0]['preferredMaintenanceWindow'];
                reqParams.cli['--preferred-maintenance-window'] = action['parameters'][0]['preferredMaintenanceWindow'];
                reqParams.boto3['PreferredAvailabilityZones'] = action['parameters'][0]['preferredAvailabilityZones'];
                reqParams.cli['--preferred-availability-zones'] = action['parameters'][0]['preferredAvailabilityZones'];
                reqParams.boto3['SecurityGroupIds'] = action['parameters'][0]['securityGroupIds'];
                reqParams.cli['--security-group-ids'] = action['parameters'][0]['securityGroupIds'];

                reqParams.cfn['NumCacheNodes'] = action['parameters'][0]['numCacheNodes'];
                reqParams.cfn['Port'] = action['parameters'][0]['port'];
                reqParams.cfn['ClusterName'] = action['parameters'][0]['cacheClusterId'];
                reqParams.cfn['CacheNodeType'] = action['parameters'][0]['cacheNodeType'];
                reqParams.cfn['CacheParameterGroupName'] = action['parameters'][0]['cacheParameterGroupName'];
                reqParams.cfn['CacheSubnetGroupName'] = action['parameters'][0]['cacheSubnetGroupName'];
                reqParams.cfn['Engine'] = action['parameters'][0]['engine'];
                reqParams.cfn['EngineVersion'] = action['parameters'][0]['engineVersion'];
                reqParams.cfn['NotificationTopicArn'] = action['parameters'][0]['notificationTopicArn'];
                reqParams.cfn['PreferredMaintenanceWindow'] = action['parameters'][0]['preferredMaintenanceWindow'];
                reqParams.cfn['PreferredAvailabilityZones'] = action['parameters'][0]['preferredAvailabilityZones'];
                reqParams.cfn['VpcSecurityGroupIds'] = action['parameters'][0]['securityGroupIds'];

                reqParams.tf['num_cache_nodes'] = action['parameters'][0]['numCacheNodes'];
                reqParams.tf['port'] = action['parameters'][0]['port'];
                reqParams.tf['cluster_id'] = action['parameters'][0]['cacheClusterId'];
                reqParams.tf['node_type'] = action['parameters'][0]['cacheNodeType'];
                reqParams.tf['parameter_group_name'] = action['parameters'][0]['cacheParameterGroupName'];
                reqParams.tf['subnet_group_name'] = action['parameters'][0]['cacheSubnetGroupName'];
                reqParams.tf['engine'] = action['parameters'][0]['engine'];
                reqParams.tf['engine_version'] = action['parameters'][0]['engineVersion'];
                reqParams.tf['notification_topic_arn'] = action['parameters'][0]['notificationTopicArn'];
                reqParams.tf['maintenance_window'] = action['parameters'][0]['preferredMaintenanceWindow'];
                reqParams.tf['preferred_availability_zones'] = action['parameters'][0]['preferredAvailabilityZones'];
                reqParams.tf['security_group_ids'] = action['parameters'][0]['securityGroupIds'];

                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'CreateCacheCluster',
                        'boto3': 'create_cache_cluster',
                        'cli': 'create-cache-cluster'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('elasticache', details.requestId),
                    'region': region,
                    'service': 'elasticache',
                    'type': 'AWS::ElastiCache::CacheCluster',
                    'terraformType': 'aws_elasticache_cluster',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "amazon.acs.acsconsole.shared.ReservedCacheNodeRequestContext.findAll") {
                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'DescribeReservedCacheNodes',
                        'boto3': 'describe_reserved_cache_nodes',
                        'cli': 'describe-reserved-cache-nodes'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.ReplicationGroupContext.paginatedList") {
                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'DescribeReplicationGroups',
                        'boto3': 'describe_replication_groups',
                        'cli': 'describe-replication-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.SnapshotContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'DescribeSnapshots',
                        'boto3': 'describe_snapshots',
                        'cli': 'describe-snapshots'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.CacheParameterGroupContext.create") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['CacheParameterGroupFamily'] = action['parameters'][0]['cacheParameterGroupFamily'];
                reqParams.cli['--cache-parameter-group-family'] = action['parameters'][0]['cacheParameterGroupFamily'];
                reqParams.boto3['CacheParameterGroupName'] = action['parameters'][0]['cacheParameterGroupName'];
                reqParams.cli['--cache-parameter-group-name'] = action['parameters'][0]['cacheParameterGroupName'];
                reqParams.boto3['Description'] = action['parameters'][0]['description'];
                reqParams.cli['--description'] = action['parameters'][0]['description'];

                reqParams.cfn['CacheParameterGroupFamily'] = action['parameters'][0]['cacheParameterGroupFamily'];
                reqParams.cfn['Description'] = action['parameters'][0]['description'];

                reqParams.tf['family'] = action['parameters'][0]['cacheParameterGroupFamily'];
                reqParams.tf['name'] = action['parameters'][0]['cacheParameterGroupName'];
                reqParams.tf['description'] = action['parameters'][0]['description'];

                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'CreateCacheParameterGroup',
                        'boto3': 'create_cache_parameter_group',
                        'cli': 'create-cache-parameter-group'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('elasticache', details.requestId),
                    'region': region,
                    'service': 'elasticache',
                    'type': 'AWS::ElastiCache::ParameterGroup',
                    'terraformType': 'aws_elasticache_parameter_group',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "EC2.DescribeAvailabilityZonesDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeAvailabilityZones',
                        'boto3': 'describe_availability_zones',
                        'cli': 'describe-availability-zones'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "amazon.acs.acsconsole.shared.ReplicationGroupContext.create") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.iam['secondary'] = [
                    {
                        'Action': [
                            'ec2:CreateNetworkInterface',
                            'ec2:DeleteNetworkInterface',
                            'ec2:DescribeNetworkInterfaces',
                            'ec2:DescribeSubnets',
                            'ec2:DescribeVpcs'
                        ],
                        'Resource': [
                            '*'
                        ]
                    },
                    {
                        'Action': [
                            's3:GetObject'
                        ],
                        'Resource': [
                            'arn:aws:s3:::*/*'
                        ]
                    }
                ];

                reqParams.boto3['PrimaryClusterId'] = action['parameters'][0]['primaryClusterId'];
                reqParams.cli['--primary-cluster-id'] = action['parameters'][0]['primaryClusterId'];
                reqParams.boto3['ReplicationGroupDescription'] = action['parameters'][0]['replicationGroupDescription'];
                reqParams.cli['--replication-group-description'] = action['parameters'][0]['replicationGroupDescription'];
                reqParams.boto3['ReplicationGroupId'] = action['parameters'][0]['replicationGroupId'];
                reqParams.cli['--replication-group-id'] = action['parameters'][0]['replicationGroupId'];

                reqParams.cfn['PrimaryClusterId'] = action['parameters'][0]['primaryClusterId'];
                reqParams.cfn['ReplicationGroupDescription'] = action['parameters'][0]['replicationGroupDescription'];
                reqParams.cfn['ReplicationGroupId'] = action['parameters'][0]['replicationGroupId'];

                reqParams.tf['replication_group_description'] = action['parameters'][0]['replicationGroupDescription'];
                reqParams.tf['replication_group_id'] = action['parameters'][0]['replicationGroupId'];

                outputs.push({
                    'region': region,
                    'service': 'elasticache',
                    'method': {
                        'api': 'CreateReplicationGroup',
                        'boto3': 'create_replication_group',
                        'cli': 'create-replication-group'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('elasticache', details.requestId),
                    'region': region,
                    'service': 'elasticache',
                    'type': 'AWS::ElastiCache::ReplicationGroup',
                    'terraformType': 'aws_elasticache_replication_group',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            }
        }
        
        return {};
    }

    // autogen:glue:glue.GetDatabases
    // autogen:glue:s3.ListBuckets
    // autogen:glue:glue.CreateTable
    // autogen:glue:glue.GetCatalogImportStatus
    // autogen:glue:glue.GetTables
    // autogen:glue:glue.GetConnections
    // autogen:glue:glue.GetConnection
    // autogen:glue:rds.DescribeDBInstances
    // autogen:glue:glue.GetConnection
    // autogen:glue:ec2.DescribeVpcs
    // autogen:glue:ec2.DescribeSubnets
    // autogen:glue:ec2.DescribeSecurityGroups
    // autogen:glue:glue.CreateConnection
    // autogen:glue:glue.GetClassifiers
    // autogen:glue:glue.CreateClassifier
    // autogen:glue:glue.PutDataCatalogEncryptionSettings
    // autogen:glue:glue.GetDataCatalogEncryptionSettings
    // autogen:glue:glue.GetJobs
    // autogen:glue:glue.GetTriggers
    // autogen:glue:glue.GetSecurityConfigurations
    // autogen:glue:glue.CreateSecurityConfiguration
    // autogen:glue:glue.DeleteSecurityConfiguration
    // autogen:glue:glue.PutDataCatalogEncryptionSettings
    // autogen:glue:glue.DeleteClassifier
    // autogen:glue:glue.BatchDeleteConnection
    // autogen:glue:glue.BatchDeleteTable
    // autogen:glue:glue.CreateCrawler
    // autogen:glue:glue.CreateDevEndpoint
    // autogen:glue:glue.CreateDatabase
    // autogen:glue:glue.GetJob
    // autogen:glue:s3.CreateBucket
    // autogen:glue:glue.GetTable
    // autogen:glue:glue.GetMapping
    // autogen:glue:glue.GetPlan
    // autogen:glue:glue.CreateJob
    // autogen:glue:glue.GetJobRuns
    // autogen:glue:glue.GetDataflowGraph
    // autogen:glue:glue.GetTrigger
    // autogen:glue:glue.CreateTrigger
    // autogen:glue:glue.DeleteDatabase
    // autogen:glue:glue.DeleteJob
    // autogen:glue:glue.DeleteTrigger
    // autogen:glue:glue.GetDevEndpoints
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/glue\/rpc$/g)) {
        for (var i in jsonRequestBody.actions) {
            var action = jsonRequestBody.actions[i];
            if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getDatabases") {
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetDatabases',
                        'boto3': 'get_databases',
                        'cli': 'get-databases'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AmazonS3Context.listBuckets") {
                outputs.push({
                    'region': region,
                    'service': 's3',
                    'method': {
                        'api': 'ListBuckets',
                        'boto3': 'list_buckets',
                        'cli': 'list-buckets'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createTable") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['TableInput'] = action['parameters'][0]['tableInput'];
                reqParams.cli['--table-input'] = action['parameters'][0]['tableInput'];
                reqParams.boto3['DatabaseName'] = action['parameters'][0]['databaseName'];
                reqParams.cli['--database-name'] = action['parameters'][0]['databaseName'];

                reqParams.cfn['TableInput'] = action['parameters'][0]['tableInput'];
                reqParams.cfn['DatabaseName'] = action['parameters'][0]['databaseName'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateTable',
                        'boto3': 'create_table',
                        'cli': 'create-table'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('glue', details.requestId),
                    'region': region,
                    'service': 'glue',
                    'type': 'AWS::Glue::Table',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getCatalogImportStatus") {
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetCatalogImportStatus',
                        'boto3': 'get_catalog_import_status',
                        'cli': 'get-catalog-import-status'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AmazonDataCatalogContext.findObjects" && action['parameters'][0]['entity'] == "TABLE") {
                reqParams.boto3['CatalogId'] = action['parameters'][0]['catalogId'];
                reqParams.cli['--catalog-id'] = action['parameters'][0]['catalogId'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetTables',
                        'boto3': 'get_tables',
                        'cli': 'get-tables'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getConnections") {
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetConnections',
                        'boto3': 'get_connections',
                        'cli': 'get-connections'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getConnection") {
                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetConnection',
                        'boto3': 'get_connection',
                        'cli': 'get-connection'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AmazonRDSContext.describeDBInstances") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBInstances',
                        'boto3': 'describe_db_instances',
                        'cli': 'describe-db-instances'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getConnection") {
                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetConnection',
                        'boto3': 'get_connection',
                        'cli': 'get-connection'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AmazonEC2Context.describeVpcs") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeVpcs',
                        'boto3': 'describe_vpcs',
                        'cli': 'describe-vpcs'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AmazonEC2Context.describeSubnets") {
                reqParams.boto3['Filters'] = action['parameters'][0]['filters'];
                reqParams.cli['--filters'] = action['parameters'][0]['filters'];

                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeSubnets',
                        'boto3': 'describe_subnets',
                        'cli': 'describe-subnets'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AmazonEC2Context.describeSecurityGroups") {
                reqParams.boto3['Filters'] = action['parameters'][0]['filters'];
                reqParams.cli['--filters'] = action['parameters'][0]['filters'];

                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeSecurityGroups',
                        'boto3': 'describe_security_groups',
                        'cli': 'describe-security-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createConnection") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['ConnectionInput'] = jsonRequestBody.actions[0].parameters[0].ConnectionInput;
                reqParams.cli['--connection-input'] = jsonRequestBody.actions[0].parameters[0].ConnectionInput;

                reqParams.cfn['ConnectionInput'] = jsonRequestBody.actions[0].parameters[0].ConnectionInput;

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateConnection',
                        'boto3': 'create_connection',
                        'cli': 'create-connection'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('glue', details.requestId),
                    'region': region,
                    'service': 'glue',
                    'type': 'AWS::Glue::Connection',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getClassifiers") {
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetClassifiers',
                        'boto3': 'get_classifiers',
                        'cli': 'get-classifiers'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createClassifier") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                if ('jsonClassifier' in action['parameters'][0]) {
                    reqParams.boto3['JsonClassifier'] = action['parameters'][0]['jsonClassifier'];
                    reqParams.cli['--json-classifier'] = action['parameters'][0]['jsonClassifier'];
                    reqParams.cfn['JsonClassifier'] = action['parameters'][0]['jsonClassifier'];
                }
                if ('grokClassifier' in action['parameters'][0]) {
                    reqParams.boto3['GrokClassifier'] = action['parameters'][0]['grokClassifier'];
                    reqParams.cli['--grok-classifier'] = action['parameters'][0]['grokClassifier'];
                    reqParams.cfn['GrokClassifier'] = action['parameters'][0]['grokClassifier'];
                }
                if ('xmlClassifier' in action['parameters'][0]) {
                    reqParams.boto3['XMLClassifier'] = action['parameters'][0]['xmlClassifier'];
                    reqParams.cli['--xml-classifier'] = action['parameters'][0]['xmlClassifier'];
                    reqParams.cfn['XMLClassifier'] = action['parameters'][0]['xmlClassifier'];
                }

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateClassifier',
                        'boto3': 'create_classifier',
                        'cli': 'create-classifier'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('glue', details.requestId),
                    'region': region,
                    'service': 'glue',
                    'type': 'AWS::Glue::Classifier',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getDataCatalogEncryptionSettings") {
                reqParams.boto3['CatalogId'] = action['parameters'][0]['catalogId'];
                reqParams.cli['--catalog-id'] = action['parameters'][0]['catalogId'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetDataCatalogEncryptionSettings',
                        'boto3': 'get_data_catalog_encryption_settings',
                        'cli': 'get-data-catalog-encryption-settings'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.putDataCatalogEncryptionSettings") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['DataCatalogEncryptionSettings'] = action['parameters'][0]['dataCatalogEncryptionSettings'];
                reqParams.cli['--data-catalog-encryption-settings'] = action['parameters'][0]['dataCatalogEncryptionSettings'];
                reqParams.boto3['CatalogId'] = action['parameters'][0]['catalogId'];
                reqParams.cli['--catalog-id'] = action['parameters'][0]['catalogId'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'PutDataCatalogEncryptionSettings',
                        'boto3': 'put_data_catalog_encryption_settings',
                        'cli': 'put-data-catalog-encryption-settings'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getJobs") {
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetJobs',
                        'boto3': 'get_jobs',
                        'cli': 'get-jobs'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getTriggers") {
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetTriggers',
                        'boto3': 'get_triggers',
                        'cli': 'get-triggers'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getSecurityConfigurations") {
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetSecurityConfigurations',
                        'boto3': 'get_security_configurations',
                        'cli': 'get-security-configurations'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createSecurityConfiguration") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['EncryptionConfiguration'] = action['parameters'][0]['encryptionConfiguration'];
                reqParams.cli['--encryption-configuration'] = action['parameters'][0]['encryptionConfiguration'];
                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateSecurityConfiguration',
                        'boto3': 'create_security_configuration',
                        'cli': 'create-security-configuration'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.deleteSecurityConfiguration") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'DeleteSecurityConfiguration',
                        'boto3': 'delete_security_configuration',
                        'cli': 'delete-security-configuration'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.putDataCatalogEncryptionSettings") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['DataCatalogEncryptionSettings'] = action['parameters'][0]['dataCatalogEncryptionSettings'];
                reqParams.cli['--data-catalog-encryption-settings'] = action['parameters'][0]['dataCatalogEncryptionSettings'];
                reqParams.boto3['CatalogId'] = action['parameters'][0]['catalogId'];
                reqParams.cli['--catalog-id'] = action['parameters'][0]['catalogId'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'PutDataCatalogEncryptionSettings',
                        'boto3': 'put_data_catalog_encryption_settings',
                        'cli': 'put-data-catalog-encryption-settings'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.deleteClassifier") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'DeleteClassifier',
                        'boto3': 'delete_classifier',
                        'cli': 'delete-classifier'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.batchDeleteConnection") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['ConnectionNameList'] = action['parameters'][0]['connectionNameList'];
                reqParams.cli['--connection-name-list'] = action['parameters'][0]['connectionNameList'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'BatchDeleteConnection',
                        'boto3': 'batch_delete_connection',
                        'cli': 'batch-delete-connection'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.batchDeleteTable") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['DatabaseName'] = action['parameters'][0]['databaseName'];
                reqParams.cli['--database-name'] = action['parameters'][0]['databaseName'];
                reqParams.boto3['TablesToDelete'] = action['parameters'][0]['tablesToDelete'];
                reqParams.cli['--tables-to-delete'] = action['parameters'][0]['tablesToDelete'];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'BatchDeleteTable',
                        'boto3': 'batch_delete_table',
                        'cli': 'batch-delete-table'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createCrawler") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];
                reqParams.boto3['Role'] = action['parameters'][0]['role'];
                reqParams.cli['--role'] = action['parameters'][0]['role'];
                reqParams.boto3['DatabaseName'] = action['parameters'][0]['databaseName'];
                reqParams.cli['--database-name'] = action['parameters'][0]['databaseName'];
                reqParams.boto3['Description'] = action['parameters'][0]['description'];
                reqParams.cli['--description'] = action['parameters'][0]['description'];
                reqParams.boto3['Classifiers'] = action['parameters'][0]['classifiers'];
                reqParams.cli['--classifiers'] = action['parameters'][0]['classifiers'];
                reqParams.boto3['Schedule'] = action['parameters'][0]['schedule'];
                reqParams.cli['--schedule'] = action['parameters'][0]['schedule'];
                reqParams.boto3['Configuration'] = action['parameters'][0]['configuration'];
                reqParams.cli['--configuration'] = action['parameters'][0]['configuration'];
                reqParams.boto3['TablePrefix'] = action['parameters'][0]['tablePrefix'];
                reqParams.cli['--table-prefix'] = action['parameters'][0]['tablePrefix'];
                reqParams.boto3['SchemaChangePolicy'] = {
                    'UpdateBehavior': action['parameters'][0]['schemaChangePolicy']['updateBehavior'],
                    'DeleteBehaviour': action['parameters'][0]['schemaChangePolicy']['deleteBehaviour']
                };
                reqParams.cli['--schema-change-policy'] = {
                    'UpdateBehavior': action['parameters'][0]['schemaChangePolicy']['updateBehavior'],
                    'DeleteBehaviour': action['parameters'][0]['schemaChangePolicy']['deleteBehaviour']
                };
                reqParams.boto3['CrawlerSecurityConfiguration'] = action['parameters'][0]['crawlerSecurityConfiguration'];
                reqParams.cli['--crawler-security-configuration'] = action['parameters'][0]['crawlerSecurityConfiguration'];

                var s3Targets = [];
                var jdbcTargets = [];
                var dynamoDbTargets = [];
                for (var j=0; j<action['parameters'][0]['targets']['s3Targets'].length; j++) {
                    s3Targets.push({
                        'Path': action['parameters'][0]['targets']['s3Targets'][j]['path'],
                        'Exclusions': action['parameters'][0]['targets']['s3Targets'][j]['exclusions']
                    });
                }
                for (var j=0; j<action['parameters'][0]['targets']['jdbcTargets'].length; j++) {
                    jdbcTargets.push({
                        'ConnectionName': action['parameters'][0]['targets']['jdbcTargets'][j]['connectionName'],
                        'Path': action['parameters'][0]['targets']['jdbcTargets'][j]['path'],
                        'Exclusions': action['parameters'][0]['targets']['jdbcTargets'][j]['exclusions']
                    });
                }
                for (var j=0; j<action['parameters'][0]['targets']['dynamoDBTargets'].length; j++) {
                    dynamoDbTargets.push({
                        'Path': action['parameters'][0]['targets']['dynamoDBTargets'][j]['path']
                    });
                }

                reqParams.boto3['Targets'] = {
                    'S3Targets': s3Targets,
                    'JdbcTargets': jdbcTargets,
                    'DynamoDBTargets': dynamoDbTargets
                };
                reqParams.cli['--targets'] = {
                    'S3Targets': s3Targets,
                    'JdbcTargets': jdbcTargets,
                    'DynamoDBTargets': dynamoDbTargets
                };

                reqParams.cfn['Name'] = action['parameters'][0]['name'];
                reqParams.cfn['Role'] = action['parameters'][0]['role'];
                reqParams.cfn['DatabaseName'] = action['parameters'][0]['databaseName'];
                reqParams.cfn['Description'] = action['parameters'][0]['description'];
                reqParams.cfn['Classifiers'] = action['parameters'][0]['classifiers'];
                reqParams.cfn['Schedule'] = action['parameters'][0]['schedule'];
                reqParams.cfn['Configuration'] = action['parameters'][0]['configuration'];
                reqParams.cfn['TablePrefix'] = action['parameters'][0]['tablePrefix'];
                reqParams.cfn['SchemaChangePolicy'] = {
                    'UpdateBehavior': action['parameters'][0]['schemaChangePolicy']['updateBehavior'],
                    'DeleteBehaviour': action['parameters'][0]['schemaChangePolicy']['deleteBehaviour']
                };
                reqParams.cfn['Targets'] = {
                    'S3Targets': s3Targets,
                    'JdbcTargets': jdbcTargets
                };

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateCrawler',
                        'boto3': 'create_crawler',
                        'cli': 'create-crawler'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('glue', details.requestId),
                    'region': region,
                    'service': 'glue',
                    'type': 'AWS::Glue::Crawler',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createDevEndpoint") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['RoleArn'] = action['parameters'][0]['roleArn'];
                reqParams.cli['--role-arn'] = action['parameters'][0]['roleArn'];
                reqParams.boto3['EndpointName'] = action['parameters'][0]['endpointName'];
                reqParams.cli['--endpoint-name'] = action['parameters'][0]['endpointName'];
                reqParams.boto3['NumberOfNodes'] = action['parameters'][0]['numberOfNodes'];
                reqParams.cli['--number-of-nodes'] = action['parameters'][0]['numberOfNodes'];
                reqParams.boto3['PublicKeys'] = action['parameters'][0]['publicKeys'];
                reqParams.cli['--public-keys'] = action['parameters'][0]['publicKeys'];

                reqParams.cfn['RoleArn'] = action['parameters'][0]['roleArn'];
                reqParams.cfn['EndpointName'] = action['parameters'][0]['endpointName'];
                reqParams.cfn['NumberOfNodes'] = action['parameters'][0]['numberOfNodes'];
                reqParams.cfn['PublicKey'] = action['parameters'][0]['publicKeys'][0];

                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateDevEndpoint',
                        'boto3': 'create_dev_endpoint',
                        'cli': 'create-dev-endpoint'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('glue', details.requestId),
                    'region': region,
                    'service': 'glue',
                    'type': 'AWS::Glue::DevEndpoint',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createDatabase") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['DatabaseInput'] = action['parameters'][0]['databaseInput'];
                reqParams.cli['--database-input'] = action['parameters'][0]['databaseInput'];

                reqParams.cfn['DatabaseInput'] = action['parameters'][0]['databaseInput'];
                reqParams.cfn['CatalogId'] = "!Ref \"AWS::AccountId\"";
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateDatabase',
                        'boto3': 'create_database',
                        'cli': 'create-database'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('glue', details.requestId),
                    'region': region,
                    'service': 'glue',
                    'type': 'AWS::Glue::Database',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getJob") {
                reqParams.boto3['JobName'] = action['parameters'][0]['jobName'];
                reqParams.cli['--job-name'] = action['parameters'][0]['jobName'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetJob',
                        'boto3': 'get_job',
                        'cli': 'get-job'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.shared.S3RequestContext.createBucket") {
                reqParams.iam['Resource'] = [
                    "arn:aws:s3:::" + action['parameters'][0]
                ];

                reqParams.boto3['Bucket'] = action['parameters'][0];
                reqParams.cli['--bucket'] = action['parameters'][0];

                reqParams.cfn['BucketName'] = action['parameters'][0];

                reqParams.tf['bucket'] = action['parameters'][0];
        
                outputs.push({
                    'region': region,
                    'service': 's3',
                    'method': {
                        'api': 'CreateBucket',
                        'boto3': 'create_bucket',
                        'cli': 'create-bucket'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('s3', details.requestId),
                    'region': region,
                    'service': 's3',
                    'type': 'AWS::S3::Bucket',
                    'terraformType': 'aws_s3_bucket',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getTable") {
                reqParams.boto3['DatabaseName'] = action['parameters'][0]['databaseName'];
                reqParams.cli['--database-name'] = action['parameters'][0]['databaseName'];
                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetTable',
                        'boto3': 'get_table',
                        'cli': 'get-table'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getMapping") {
                reqParams.boto3['Source'] = action['parameters'][0]['source'];
                reqParams.cli['--source'] = action['parameters'][0]['source'];
                reqParams.boto3['Sinks'] = action['parameters'][0]['sinks'];
                reqParams.cli['--sinks'] = action['parameters'][0]['sinks'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetMapping',
                        'boto3': 'get_mapping',
                        'cli': 'get-mapping'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getPlan") {
                reqParams.boto3['Source'] = action['parameters'][0]['source'];
                reqParams.cli['--source'] = action['parameters'][0]['source'];
                reqParams.boto3['Language'] = action['parameters'][0]['language'];
                reqParams.cli['--language'] = action['parameters'][0]['language'];
                reqParams.boto3['Sinks'] = action['parameters'][0]['sinks'];
                reqParams.cli['--sinks'] = action['parameters'][0]['sinks'];
                reqParams.boto3['Mapping'] = action['parameters'][0]['mapping'];
                reqParams.cli['--mapping'] = action['parameters'][0]['mapping'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetPlan',
                        'boto3': 'get_plan',
                        'cli': 'get-plan'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createJob") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['ExecutionProperty'] = action['parameters'][0]['executionProperty'];
                reqParams.cli['--execution-property'] = action['parameters'][0]['executionProperty'];
                reqParams.boto3['Command'] = action['parameters'][0]['command'];
                reqParams.cli['--command'] = action['parameters'][0]['command'];
                reqParams.boto3['AllocatedCapacity'] = action['parameters'][0]['allocatedCapacity'];
                reqParams.cli['--allocated-capacity'] = action['parameters'][0]['allocatedCapacity'];
                reqParams.boto3['MaxRetries'] = action['parameters'][0]['maxRetries'];
                reqParams.cli['--max-retries'] = action['parameters'][0]['maxRetries'];
                reqParams.boto3['Timeout'] = action['parameters'][0]['timeout'];
                reqParams.cli['--timeout'] = action['parameters'][0]['timeout'];
                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];
                reqParams.boto3['Role'] = action['parameters'][0]['role'];
                reqParams.cli['--role'] = action['parameters'][0]['role'];
                reqParams.boto3['DefaultArguments'] = action['parameters'][0]['defaultArguments'];
                reqParams.cli['--default-arguments'] = action['parameters'][0]['defaultArguments'];

                reqParams.cfn['ExecutionProperty'] = action['parameters'][0]['executionProperty'];
                reqParams.cfn['Command'] = action['parameters'][0]['command'];
                reqParams.cfn['AllocatedCapacity'] = action['parameters'][0]['allocatedCapacity'];
                reqParams.cfn['MaxRetries'] = action['parameters'][0]['maxRetries'];
                reqParams.cfn['Name'] = action['parameters'][0]['name'];
                reqParams.cfn['Role'] = action['parameters'][0]['role'];
                reqParams.cfn['DefaultArguments'] = action['parameters'][0]['defaultArguments'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateJob',
                        'boto3': 'create_job',
                        'cli': 'create-job'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('glue', details.requestId),
                    'region': region,
                    'service': 'glue',
                    'type': 'AWS::Glue::Job',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getJobRuns") {
                reqParams.boto3['JobName'] = action['parameters'][0]['jobName'];
                reqParams.cli['--job-name'] = action['parameters'][0]['jobName'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetJobRuns',
                        'boto3': 'get_job_runs',
                        'cli': 'get-job-runs'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getDataflowGraph") {
                reqParams.boto3['PythonScript'] = action['parameters'][0]['pythonScript'];
                reqParams.cli['--python-script'] = action['parameters'][0]['pythonScript'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetDataflowGraph',
                        'boto3': 'get_dataflow_graph',
                        'cli': 'get-dataflow-graph'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getTrigger") {
                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetTrigger',
                        'boto3': 'get_trigger',
                        'cli': 'get-trigger'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.createTrigger") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['StartOnCreation'] = action['parameters'][0]['startOnCreation'];
                reqParams.cli['--start-on-creation'] = action['parameters'][0]['startOnCreation'];
                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];
                reqParams.boto3['Schedule'] = action['parameters'][0]['schedule'];
                reqParams.cli['--schedule'] = action['parameters'][0]['schedule'];
                reqParams.boto3['Type'] = action['parameters'][0]['type'];
                reqParams.cli['--type'] = action['parameters'][0]['type'];
                reqParams.boto3['Actions'] = action['parameters'][0]['actions'];
                reqParams.cli['--actions'] = action['parameters'][0]['actions'];

                reqParams.cfn['Name'] = action['parameters'][0]['name'];
                reqParams.cfn['Schedule'] = action['parameters'][0]['schedule'];
                reqParams.cfn['Type'] = action['parameters'][0]['type'];
                reqParams.cfn['Actions'] = action['parameters'][0]['actions'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'CreateTrigger',
                        'boto3': 'create_trigger',
                        'cli': 'create-trigger'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('glue', details.requestId),
                    'region': region,
                    'service': 'glue',
                    'type': 'AWS::Glue::Trigger',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.deleteDatabase") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'DeleteDatabase',
                        'boto3': 'delete_database',
                        'cli': 'delete-database'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.deleteJob") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['JobName'] = action['parameters'][0]['jobName'];
                reqParams.cli['--job-name'] = action['parameters'][0]['jobName'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'DeleteJob',
                        'boto3': 'delete_job',
                        'cli': 'delete-job'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.deleteTrigger") {
                reqParams.iam['Resource'] = [
                    "*"
                ];

                reqParams.boto3['Name'] = action['parameters'][0]['name'];
                reqParams.cli['--name'] = action['parameters'][0]['name'];
        
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'DeleteTrigger',
                        'boto3': 'delete_trigger',
                        'cli': 'delete-trigger'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.glue.awssdk.shared.context.AWSGlueContext.getDevEndpoints") {
                outputs.push({
                    'region': region,
                    'service': 'glue',
                    'method': {
                        'api': 'GetDevEndpoints',
                        'boto3': 'get_dev_endpoints',
                        'cli': 'get-dev-endpoints'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            }
        }

        return {};
    }

    // autogen:rds:rds.DescribeDBSecurityGroups
    // autogen:rds:kms.DescribeKey
    // autogen:rds:ec2.DescribeSecurityGroups
    // autogen:rds:ec2.DescribeVpcs
    // autogen:rds:rds.DescribeDBParameterGroups
    // autogen:rds:rds.DescribeDBClusterParameterGroups
    // autogen:rds:rds.DescribeDBSubnetGroups
    // autogen:rds:ec2.DescribeSecurityGroups
    // autogen:rds:rds.CreateDBCluster
    // autogen:rds:rds.CreateDBInstance
    // autogen:rds:rds.DescribeEvents
    // autogen:rds:rds.DescribeDBLogFiles
    // autogen:rds:rds.DescribeDBClusters
    // autogen:rds:ec2.DescribeSecurityGroups
    // autogen:rds:rds.DescribeOptionGroups
    // autogen:rds:rds.DescribeDBSnapshots
    // autogen:rds:rds.DescribeDBSnapshots
    // autogen:rds:rds.DescribeDBClusterSnapshots
    // autogen:rds:rds.DescribeReservedDBInstances
    // autogen:rds:rds.DescribeDBSubnetGroups
    // autogen:rds:ec2.DescribeAvailabilityZones
    // autogen:rds:rds.CreateDBSubnetGroup
    // autogen:rds:rds.DescribeDBParameterGroups
    // autogen:rds:rds.CreateDBParameterGroup
    // autogen:rds:rds.CreateOptionGroup
    // autogen:rds:sns.ListTopics
    // autogen:rds:rds.CreateEventSubscription
    // autogen:rds:rds.DescribeEventSubscriptions
    // autogen:rds:rds.StopDBCluster
    // autogen:rds:rds.CreateDBClusterParameterGroup
    // autogen:rds:rds.StartDBCluster
    // autogen:rds:rds.DeleteDBInstance
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/rds\/rpc$/g)) {
        for (var i in jsonRequestBody.actions) {
            var action = jsonRequestBody.actions[i];
            if (action['action'] == "com.amazonaws.console.rds.shared.DbSecurityGroupContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBSecurityGroups',
                        'boto3': 'describe_db_security_groups',
                        'cli': 'describe-db-security-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.gwt.trent.requestfactory.shared.TrentRequestContext.describeKey") {
                reqParams.boto3['KeyId'] = action['parameters'][0]['keyId'];
                reqParams.cli['--key-id'] = action['parameters'][0]['keyId'];
        
                outputs.push({
                    'region': region,
                    'service': 'kms',
                    'method': {
                        'api': 'DescribeKey',
                        'boto3': 'describe_key',
                        'cli': 'describe-key'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "EC2.DescribeSecurityGroupsDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeSecurityGroups',
                        'boto3': 'describe_security_groups',
                        'cli': 'describe-security-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "EC2.DescribeVpcsDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeVpcs',
                        'boto3': 'describe_vpcs',
                        'cli': 'describe-vpcs'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbParamGroupContext.findDbParameterGroups") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBParameterGroups',
                        'boto3': 'describe_db_parameter_groups',
                        'cli': 'describe-db-parameter-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbParamGroupContext.listDbClusterParameterGroups") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBClusterParameterGroups',
                        'boto3': 'describe_db_cluster_parameter_groups',
                        'cli': 'describe-db-cluster-parameter-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DBSubnetGroupContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBSubnetGroups',
                        'boto3': 'describe_db_subnet_groups',
                        'cli': 'describe-db-subnet-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "EC2.DescribeSecurityGroupsDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeSecurityGroups',
                        'boto3': 'describe_security_groups',
                        'cli': 'describe-security-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbInstanceContext.create") {
                if (action['parameters'][0]['auroraReplicaCount']) {
                    reqParams.iam['Resource'] = [
                        "arn:aws:rds:*:*:cluster:" + action['parameters'][0]['dbClusterIdentifier'],
                        "arn:aws:rds:*:*:cluster-pg:" + action['parameters'][0]['DBClusterParameterGroupName'],
                        "arn:aws:rds:*:*:og:" + action['parameters'][0]['optionGroupName'],
                        "arn:aws:rds:*:*:subgrp:" + action['parameters'][0]['DBSubnetGroupName']
                    ];
                    
                    reqParams.boto3['BackupRetentionPeriod'] = action['parameters'][0]['backupRetentionPeriod'];
                    reqParams.cli['--backup-retention-period'] = action['parameters'][0]['backupRetentionPeriod'];
                    if (action['parameters'][0]['DBName'] != "") {
                        reqParams.boto3['DatabaseName'] = action['parameters'][0]['DBName'];
                        reqParams.cli['--database-name'] = action['parameters'][0]['DBName'];
                    }
                    reqParams.boto3['DBClusterIdentifier'] = action['parameters'][0]['dbClusterIdentifier'];
                    reqParams.cli['--db-cluster-identifier'] = action['parameters'][0]['dbClusterIdentifier'];
                    reqParams.boto3['DBClusterParameterGroupName'] = action['parameters'][0]['DBClusterParameterGroupName'];
                    reqParams.cli['--db-cluster-parameter-group-name'] = action['parameters'][0]['DBClusterParameterGroupName'];
                    reqParams.boto3['DBSubnetGroupName'] = action['parameters'][0]['DBSubnetGroupName'];
                    reqParams.cli['--db-subnet-group-name'] = action['parameters'][0]['DBSubnetGroupName'];
                    reqParams.boto3['DeletionProtection'] = action['parameters'][0]['deletionProtection'];
                    reqParams.cli['--deletion-protection'] = action['parameters'][0]['deletionProtection'];
                    reqParams.boto3['EnableCloudwatchLogsExports'] = action['parameters'][0]['enableCloudwatchLogsExports'];
                    reqParams.cli['--enable-cloudwatch-logs-exports'] = action['parameters'][0]['enableCloudwatchLogsExports'];
                    reqParams.boto3['Engine'] = action['parameters'][0]['engine'];
                    reqParams.cli['--engine'] = action['parameters'][0]['engine'];
                    reqParams.boto3['EngineMode'] = action['parameters'][0]['engineMode'];
                    reqParams.cli['--engine-mode'] = action['parameters'][0]['engineMode'];
                    reqParams.boto3['EngineVersion'] = action['parameters'][0]['engineVersion'];
                    reqParams.cli['--engine-version'] = action['parameters'][0]['engineVersion'];
                    reqParams.boto3['MasterUserPassword'] = action['parameters'][0]['masterUserPassword'];
                    reqParams.cli['--master-user-password'] = action['parameters'][0]['masterUserPassword'];
                    reqParams.boto3['MasterUsername'] = action['parameters'][0]['masterUsername'];
                    reqParams.cli['--master-username'] = action['parameters'][0]['masterUsername'];
                    reqParams.boto3['Port'] = action['parameters'][0]['port'];
                    reqParams.cli['--port'] = action['parameters'][0]['port'];
                    reqParams.boto3['PreferredMaintenanceWindow'] = action['parameters'][0]['preferredMaintenanceWindow'];
                    reqParams.cli['--preferred-maintenance-window'] = action['parameters'][0]['preferredMaintenanceWindow'];
                    if (action['parameters'][0]['vpcSecurityGroupIds'] && action['parameters'][0]['vpcSecurityGroupIds'][0] != "-create-rds-default-security-group") {
                        reqParams.boto3['VpcSecurityGroupIds'] = action['parameters'][0]['vpcSecurityGroupIds'];
                        reqParams.cli['--vpc-security-group-ids'] = action['parameters'][0]['vpcSecurityGroupIds'];
                    }

                    reqParams.cfn['BackupRetentionPeriod'] = action['parameters'][0]['backupRetentionPeriod'];
                    if (action['parameters'][0]['DBName'] != "") {
                        reqParams.cfn['DatabaseName'] = action['parameters'][0]['DBName'];
                    }
                    reqParams.cfn['DBClusterIdentifier'] = action['parameters'][0]['dbClusterIdentifier'];
                    reqParams.cfn['DBClusterParameterGroupName'] = action['parameters'][0]['DBClusterParameterGroupName'];
                    reqParams.cfn['DBSubnetGroupName'] = action['parameters'][0]['DBSubnetGroupName'];
                    reqParams.cfn['DeletionProtection'] = action['parameters'][0]['deletionProtection'];
                    reqParams.cfn['EnableCloudwatchLogsExports'] = action['parameters'][0]['enableCloudwatchLogsExports'];
                    reqParams.cfn['Engine'] = action['parameters'][0]['engine'];
                    reqParams.cfn['EngineMode'] = action['parameters'][0]['engineMode'];
                    reqParams.cfn['EngineVersion'] = action['parameters'][0]['engineVersion'];
                    reqParams.cfn['MasterUserPassword'] = action['parameters'][0]['masterUserPassword'];
                    reqParams.cfn['MasterUsername'] = action['parameters'][0]['masterUsername'];
                    reqParams.cfn['Port'] = action['parameters'][0]['port'];
                    reqParams.boto3['PreferredMaintenanceWindow'] = action['parameters'][0]['preferredMaintenanceWindow'];
                    if (action['parameters'][0]['vpcSecurityGroupIds'] && action['parameters'][0]['vpcSecurityGroupIds'][0] != "-create-rds-default-security-group") {
                        reqParams.cfn['VPCSecurityGroups'] = action['parameters'][0]['vpcSecurityGroupIds'];
                    }

                    reqParams.tf['backup_retention_period'] = action['parameters'][0]['backupRetentionPeriod'];
                    if (action['parameters'][0]['DBName'] != "") {
                        reqParams.tf['database_name'] = action['parameters'][0]['DBName'];
                    }
                    reqParams.tf['cluster_identifier'] = action['parameters'][0]['dbClusterIdentifier'];
                    reqParams.tf['db_cluster_parameter_group_name'] = action['parameters'][0]['DBClusterParameterGroupName'];
                    reqParams.tf['db_subnet_group_name'] = action['parameters'][0]['DBSubnetGroupName'];
                    reqParams.tf['deletion_protection'] = action['parameters'][0]['deletionProtection'];
                    reqParams.tf['enabled_cloudwatch_logs_exports'] = action['parameters'][0]['enableCloudwatchLogsExports'];
                    reqParams.tf['engine'] = action['parameters'][0]['engine'];
                    reqParams.tf['engine_mode'] = action['parameters'][0]['engineMode'];
                    reqParams.tf['engine_version'] = action['parameters'][0]['engineVersion'];
                    reqParams.tf['master_password'] = action['parameters'][0]['masterUserPassword'];
                    reqParams.tf['master_username'] = action['parameters'][0]['masterUsername'];
                    reqParams.tf['port'] = action['parameters'][0]['port'];
                    reqParams.tf['preferred_maintenance_window'] = action['parameters'][0]['preferredMaintenanceWindow'];
                    if (action['parameters'][0]['vpcSecurityGroupIds'] && action['parameters'][0]['vpcSecurityGroupIds'][0] != "-create-rds-default-security-group") {
                        reqParams.tf['vpc_security_group_ids'] = action['parameters'][0]['vpcSecurityGroupIds'];
                    }
        
                    outputs.push({
                        'region': region,
                        'service': 'rds',
                        'method': {
                            'api': 'CreateDBCluster',
                            'boto3': 'create_db_cluster',
                            'cli': 'create-db-cluster'
                        },
                        'options': reqParams,
                        'requestDetails': details
                    });

                    tracked_resources.push({
                        'logicalId': getResourceName('rds', details.requestId),
                        'region': region,
                        'service': 'rds',
                        'type': 'AWS::RDS::DBCluster',
                        'terraformType': 'aws_rds_cluster',
                        'options': reqParams,
                        'requestDetails': details,
                        'was_blocked': blocking
                    });
                }

                var reqParams = {
                    'boto3': {},
                    'go': {},
                    'cfn': {},
                    'cli': {},
                    'tf': {},
                    'iam': {}
                };

                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:db:" + action['parameters'][0]['DBInstanceIdentifier'],
                    "arn:aws:rds:*:*:pg:" + action['parameters'][0]['DBParameterGroupName'],
                    "arn:aws:rds:*:*:og:" + action['parameters'][0]['optionGroupName'],
                    "arn:aws:rds:*:*:subgrp:" + action['parameters'][0]['DBSubnetGroupName']
                ];

                reqParams.boto3['AutoMinorVersionUpgrade'] = action['parameters'][0]['autoMinorVersionUpgrade'];
                reqParams.cli['--auto-minor-version-upgrade'] = action['parameters'][0]['autoMinorVersionUpgrade'];
                reqParams.boto3['CopyTagsToSnapshot'] = action['parameters'][0]['copyTagsToSnapshot'];
                reqParams.cli['--copy-tags-to-snapshot'] = action['parameters'][0]['copyTagsToSnapshot'];
                reqParams.boto3['DeletionProtection'] = action['parameters'][0]['deletionProtection'];
                reqParams.cli['--deletion-protection'] = action['parameters'][0]['deletionProtection'];
                reqParams.boto3['MultiAZ'] = action['parameters'][0]['multiAZ'];
                reqParams.cli['--multi-az'] = action['parameters'][0]['multiAZ'];
                reqParams.boto3['PubliclyAccessible'] = action['parameters'][0]['publiclyAccessible'];
                reqParams.cli['--publicly-accessible'] = action['parameters'][0]['publiclyAccessible'];
                reqParams.boto3['StorageEncrypted'] = action['parameters'][0]['storageEncrypted'];
                reqParams.cli['--storage-encrypted'] = action['parameters'][0]['storageEncrypted'];
                reqParams.boto3['AllocatedStorage'] = action['parameters'][0]['allocatedStorage'];
                reqParams.cli['--allocated-storage'] = action['parameters'][0]['allocatedStorage'];
                reqParams.boto3['BackupRetentionPeriod'] = action['parameters'][0]['backupRetentionPeriod'];
                reqParams.cli['--backup-retention-period'] = action['parameters'][0]['backupRetentionPeriod'];
                reqParams.boto3['Iops'] = action['parameters'][0]['iops'];
                reqParams.cli['--iops'] = action['parameters'][0]['iops'];
                reqParams.boto3['MonitoringInterval'] = action['parameters'][0]['monitoringInterval'];
                reqParams.cli['--monitoring-interval'] = action['parameters'][0]['monitoringInterval'];
                reqParams.boto3['Port'] = action['parameters'][0]['port'];
                reqParams.cli['--port'] = action['parameters'][0]['port'];
                reqParams.boto3['PromotionTier'] = action['parameters'][0]['promotionTier'];
                reqParams.cli['--promotion-tier'] = action['parameters'][0]['promotionTier'];
                reqParams.boto3['AvailabilityZone'] = action['parameters'][0]['availabilityZone'];
                reqParams.cli['--availability-zone'] = action['parameters'][0]['availabilityZone'];
                reqParams.boto3['DBInstanceClass'] = action['parameters'][0]['DBInstanceClass'];
                reqParams.cli['--db-instance-class'] = action['parameters'][0]['DBInstanceClass'];
                reqParams.boto3['DBInstanceIdentifier'] = action['parameters'][0]['DBInstanceIdentifier'];
                reqParams.cli['--db-instance-identifier'] = action['parameters'][0]['DBInstanceIdentifier'];
                if (action['parameters'][0]['DBName'] != "") {
                    reqParams.boto3['DBName'] = action['parameters'][0]['DBName'];
                    reqParams.cli['--db-name'] = action['parameters'][0]['DBName'];
                }
                reqParams.boto3['DBParameterGroupName'] = action['parameters'][0]['DBParameterGroupName'];
                reqParams.cli['--db-parameter-group-name'] = action['parameters'][0]['DBParameterGroupName'];
                reqParams.boto3['DBSubnetGroupName'] = action['parameters'][0]['DBSubnetGroupName'];
                reqParams.cli['--db-subnet-group-name'] = action['parameters'][0]['DBSubnetGroupName'];
                reqParams.boto3['DBClusterIdentifier'] = action['parameters'][0]['dbClusterIdentifier'];
                reqParams.cli['--db-cluster-identifier'] = action['parameters'][0]['dbClusterIdentifier'];
                reqParams.boto3['Engine'] = action['parameters'][0]['engine'];
                reqParams.cli['--engine'] = action['parameters'][0]['engine'];
                reqParams.boto3['EngineVersion'] = action['parameters'][0]['engineVersion'];
                reqParams.cli['--engine-version'] = action['parameters'][0]['engineVersion'];
                reqParams.boto3['LicenseModel'] = action['parameters'][0]['licenseModel'];
                reqParams.cli['--license-model'] = action['parameters'][0]['licenseModel'];
                reqParams.boto3['MasterUserPassword'] = action['parameters'][0]['masterUserPassword'];
                reqParams.cli['--master-user-password'] = action['parameters'][0]['masterUserPassword'];
                reqParams.boto3['MasterUsername'] = action['parameters'][0]['masterUsername'];
                reqParams.cli['--master-username'] = action['parameters'][0]['masterUsername'];
                reqParams.boto3['MonitoringRoleArn'] = action['parameters'][0]['monitoringRoleArn'];
                reqParams.cli['--monitoring-role-arn'] = action['parameters'][0]['monitoringRoleArn'];
                reqParams.boto3['OptionGroupName'] = action['parameters'][0]['optionGroupName'];
                reqParams.cli['--option-group-name'] = action['parameters'][0]['optionGroupName'];
                reqParams.boto3['PreferredMaintenanceWindow'] = action['parameters'][0]['preferredMaintenanceWindow'];
                reqParams.cli['--preferred-maintenance-window'] = action['parameters'][0]['preferredMaintenanceWindow'];
                reqParams.boto3['StorageType'] = action['parameters'][0]['storageType'];
                reqParams.cli['--storage-type'] = action['parameters'][0]['storageType'];
                reqParams.boto3['EnableCloudwatchLogsExports'] = action['parameters'][0]['enableCloudwatchLogsExports'];
                reqParams.cli['--enable-cloudwatch-logs-exports'] = action['parameters'][0]['enableCloudwatchLogsExports'];

                if (action['parameters'][0]['vpcSecurityGroupIds'] && action['parameters'][0]['vpcSecurityGroupIds'][0] != "-create-rds-default-security-group") { // TODO: Handle default SG creation
                    reqParams.boto3['VpcSecurityGroupIds'] = action['parameters'][0]['vpcSecurityGroupIds'];
                    reqParams.cli['--vpc-security-group-ids'] = action['parameters'][0]['vpcSecurityGroupIds'];

                    for (var j=0; j<action['parameters'][0]['vpcSecurityGroupIds'].length; j++) {
                        reqParams.iam['Resource'].push("arn:aws:rds:*:*:secgrp:" + action['parameters'][0]['vpcSecurityGroupIds'][j]);
                    }
                }

                reqParams.cfn['AutoMinorVersionUpgrade'] = action['parameters'][0]['autoMinorVersionUpgrade'];
                reqParams.cfn['CopyTagsToSnapshot'] = action['parameters'][0]['copyTagsToSnapshot'];
                reqParams.cfn['MultiAZ'] = action['parameters'][0]['multiAZ'];
                reqParams.cfn['PubliclyAccessible'] = action['parameters'][0]['publiclyAccessible'];
                reqParams.cfn['StorageEncrypted'] = action['parameters'][0]['storageEncrypted'];
                reqParams.cfn['AllocatedStorage'] = action['parameters'][0]['allocatedStorage'];
                reqParams.cfn['BackupRetentionPeriod'] = action['parameters'][0]['backupRetentionPeriod'];
                reqParams.cfn['Iops'] = action['parameters'][0]['iops'];
                reqParams.cfn['MonitoringInterval'] = action['parameters'][0]['monitoringInterval'];
                reqParams.cfn['Port'] = action['parameters'][0]['port'];
                reqParams.cfn['AvailabilityZone'] = action['parameters'][0]['availabilityZone'];
                reqParams.cfn['DBInstanceClass'] = action['parameters'][0]['DBInstanceClass'];
                reqParams.cfn['DBInstanceIdentifier'] = action['parameters'][0]['DBInstanceIdentifier'];
                if (action['parameters'][0]['DBName'] != "") {
                    reqParams.cfn['DBName'] = action['parameters'][0]['DBName'];
                }
                reqParams.cfn['DBParameterGroupName'] = action['parameters'][0]['DBParameterGroupName'];
                reqParams.cfn['DBSubnetGroupName'] = action['parameters'][0]['DBSubnetGroupName'];
                reqParams.cfn['DBClusterIdentifier'] = action['parameters'][0]['dbClusterIdentifier'];
                reqParams.cfn['Engine'] = action['parameters'][0]['engine'];
                reqParams.cfn['EngineVersion'] = action['parameters'][0]['engineVersion'];
                reqParams.cfn['LicenseModel'] = action['parameters'][0]['licenseModel'];
                reqParams.cfn['MasterUserPassword'] = action['parameters'][0]['masterUserPassword'];
                reqParams.cfn['MasterUsername'] = action['parameters'][0]['masterUsername'];
                reqParams.cfn['MonitoringRoleArn'] = action['parameters'][0]['monitoringRoleArn'];
                reqParams.cfn['OptionGroupName'] = action['parameters'][0]['optionGroupName'];
                reqParams.cfn['PreferredMaintenanceWindow'] = action['parameters'][0]['preferredMaintenanceWindow'];
                reqParams.cfn['StorageType'] = action['parameters'][0]['storageType'];
                if (action['parameters'][0]['vpcSecurityGroupIds'] && action['parameters'][0]['vpcSecurityGroupIds'][0] != "-create-rds-default-security-group") {
                    reqParams.cfn['VPCSecurityGroups'] = action['parameters'][0]['vpcSecurityGroupIds'];
                }

                reqParams.tf['auto_minor_version_upgrade'] = action['parameters'][0]['autoMinorVersionUpgrade'];
                reqParams.tf['copy_tags_to_snapshot'] = action['parameters'][0]['copyTagsToSnapshot'];
                reqParams.tf['multi_az'] = action['parameters'][0]['multiAZ'];
                reqParams.tf['publicly_accessible'] = action['parameters'][0]['publiclyAccessible'];
                reqParams.tf['storage_encrypted'] = action['parameters'][0]['storageEncrypted'];
                reqParams.tf['allocated_storage'] = action['parameters'][0]['allocatedStorage'];
                reqParams.tf['backup_retention_period'] = action['parameters'][0]['backupRetentionPeriod'];
                reqParams.tf['iops'] = action['parameters'][0]['iops'];
                reqParams.tf['monitoring_interval'] = action['parameters'][0]['monitoringInterval'];
                reqParams.tf['port'] = action['parameters'][0]['port'];
                reqParams.tf['availability_zone'] = action['parameters'][0]['availabilityZone'];
                reqParams.tf['instance_class'] = action['parameters'][0]['DBInstanceClass'];
                reqParams.tf['identifier'] = action['parameters'][0]['DBInstanceIdentifier'];
                if (action['parameters'][0]['DBName'] != "") {
                    reqParams.tf['database_name'] = action['parameters'][0]['DBName'];
                }
                reqParams.tf['parameter_group_name'] = action['parameters'][0]['DBParameterGroupName'];
                reqParams.tf['db_subnet_group_name'] = action['parameters'][0]['DBSubnetGroupName'];
                reqParams.tf['cluster_identifier'] = action['parameters'][0]['dbClusterIdentifier'];
                reqParams.tf['engine'] = action['parameters'][0]['engine'];
                reqParams.tf['engine_version'] = action['parameters'][0]['engineVersion'];
                reqParams.tf['license_model'] = action['parameters'][0]['licenseModel'];
                reqParams.tf['master_password'] = action['parameters'][0]['masterUserPassword'];
                reqParams.tf['master_username'] = action['parameters'][0]['masterUsername'];
                reqParams.tf['monitoring_role_arn'] = action['parameters'][0]['monitoringRoleArn'];
                reqParams.tf['option_group_name'] = action['parameters'][0]['optionGroupName'];
                reqParams.tf['preferred_maintenance_window'] = action['parameters'][0]['preferredMaintenanceWindow'];
                reqParams.tf['storage_type'] = action['parameters'][0]['storageType'];
                if (action['parameters'][0]['vpcSecurityGroupIds'] && action['parameters'][0]['vpcSecurityGroupIds'][0] != "-create-rds-default-security-group") {
                    reqParams.tf['vpc_security_group_ids'] = action['parameters'][0]['vpcSecurityGroupIds'];
                }
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'CreateDBInstance',
                        'boto3': 'create_db_instance',
                        'cli': 'create-db-instance'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('rds', details.requestId),
                    'region': region,
                    'service': 'rds',
                    'type': 'AWS::RDS::DBInstance',
                    'terraformType': 'aws_db_instance',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.rds.shared.EventContext.findEvents") {
                reqParams.boto3['Duration'] = action['parameters'][0]['duration'];
                reqParams.cli['--duration'] = action['parameters'][0]['duration'];
                reqParams.boto3['MaxRecords'] = action['parameters'][0]['maxRecords'];
                reqParams.cli['--max-records'] = action['parameters'][0]['maxRecords'];
                reqParams.boto3['SourceIdentifier'] = action['parameters'][0]['sourceIdentifier'];
                reqParams.cli['--source-identifier'] = action['parameters'][0]['sourceIdentifier'];
                reqParams.boto3['SourceType'] = action['parameters'][0]['sourceType'];
                reqParams.cli['--source-type'] = action['parameters'][0]['sourceType'];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeEvents',
                        'boto3': 'describe_events',
                        'cli': 'describe-events'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DBLogFileContext.list") {
                reqParams.boto3['DBInstanceIdentifier'] = action['parameters'][0];
                reqParams.cli['--db-instance-identifier'] = action['parameters'][0];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBLogFiles',
                        'boto3': 'describe_db_log_files',
                        'cli': 'describe-db-log-files'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DBSnapshotContext.findByDbClusterIdentifier") {
                reqParams.boto3['DBClusterIdentifier'] = action['parameters'][0];
                reqParams.cli['--db-cluster-identifier'] = action['parameters'][0];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBClusters',
                        'boto3': 'describe_db_clusters',
                        'cli': 'describe-db-clusters'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.gwt.ec2.requestfactory.shared.Ec2Context.describeSecurityGroups") {
                reqParams.boto3['GroupIds'] = action['parameters'][0]['groupIds'];
                reqParams.cli['--group-ids'] = action['parameters'][0]['groupIds'];
        
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeSecurityGroups',
                        'boto3': 'describe_security_groups',
                        'cli': 'describe-security-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.OptionGroupContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeOptionGroups',
                        'boto3': 'describe_option_groups',
                        'cli': 'describe-option-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DBSnapshotContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBSnapshots',
                        'boto3': 'describe_db_snapshots',
                        'cli': 'describe-db-snapshots'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DBSnapshotContext.describeDBSnapshotsResult") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBSnapshots',
                        'boto3': 'describe_db_snapshots',
                        'cli': 'describe-db-snapshots'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DBSnapshotContext.describeDBClusterSnapshotsResult") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBClusterSnapshots',
                        'boto3': 'describe_db_cluster_snapshots',
                        'cli': 'describe-db-cluster-snapshots'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.ReservedDBInstanceContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeReservedDBInstances',
                        'boto3': 'describe_reserved_db_instances',
                        'cli': 'describe-reserved-db-instances'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DBSubnetGroupContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBSubnetGroups',
                        'boto3': 'describe_db_subnet_groups',
                        'cli': 'describe-db-subnet-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "EC2.DescribeAvailabilityZonesDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeAvailabilityZones',
                        'boto3': 'describe_availability_zones',
                        'cli': 'describe-availability-zones'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DBSubnetGroupContext.create") {
                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:subgrp:" + action['parameters'][0]['DBSubnetGroupName']
                ];

                reqParams.boto3['DBSubnetGroupDescription'] = action['parameters'][0]['DBSubnetGroupDescription'];
                reqParams.cli['--db-subnet-group-description'] = action['parameters'][0]['DBSubnetGroupDescription'];
                reqParams.boto3['DBSubnetGroupName'] = action['parameters'][0]['DBSubnetGroupName'];
                reqParams.cli['--db-subnet-group-name'] = action['parameters'][0]['DBSubnetGroupName'];
                reqParams.boto3['SubnetIds'] = action['parameters'][0]['subnetIds'];
                reqParams.cli['--subnet-ids'] = action['parameters'][0]['subnetIds'];

                reqParams.cfn['DBSubnetGroupDescription'] = action['parameters'][0]['DBSubnetGroupDescription'];
                reqParams.cfn['DBSubnetGroupName'] = action['parameters'][0]['DBSubnetGroupName'];
                reqParams.cfn['SubnetIds'] = action['parameters'][0]['subnetIds'];

                reqParams.tf['description'] = action['parameters'][0]['DBSubnetGroupDescription'];
                reqParams.tf['name'] = action['parameters'][0]['DBSubnetGroupName'];
                reqParams.tf['subnet_ids'] = action['parameters'][0]['subnetIds'];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'CreateDBSubnetGroup',
                        'boto3': 'create_db_subnet_group',
                        'cli': 'create-db-subnet-group'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('rds', details.requestId),
                    'region': region,
                    'service': 'rds',
                    'type': 'AWS::RDS::DBSubnetGroup',
                    'terraformType': 'aws_db_subnet_group',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbParamGroupContext.findDbParameterGroups") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeDBParameterGroups',
                        'boto3': 'describe_db_parameter_groups',
                        'cli': 'describe-db-parameter-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbParamGroupContext.createDbParameterGroup") {
                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:pg:" + action['parameters'][1]
                ];

                reqParams.boto3['DBParameterGroupFamily'] = action['parameters'][0];
                reqParams.cli['--db-parameter-group-family'] = action['parameters'][0];
                reqParams.boto3['DBParameterGroupName'] = action['parameters'][1];
                reqParams.cli['--db-parameter-group-name'] = action['parameters'][1];
                reqParams.boto3['Description'] = action['parameters'][2];
                reqParams.cli['--description'] = action['parameters'][2];

                reqParams.cfn['Family'] = action['parameters'][0];
                reqParams.cfn['Description'] = action['parameters'][2];

                reqParams.tf['family'] = action['parameters'][0];
                reqParams.tf['name'] = action['parameters'][1];
                reqParams.tf['description'] = action['parameters'][2];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'CreateDBParameterGroup',
                        'boto3': 'create_db_parameter_group',
                        'cli': 'create-db-parameter-group'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('rds', details.requestId),
                    'region': region,
                    'service': 'rds',
                    'type': 'AWS::RDS::DBParameterGroup',
                    'terraformType': 'aws_db_parameter_group',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.rds.shared.OptionGroupContext.create") {
                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:og:" + action['parameters'][0]['optionGroupName']
                ];
                
                reqParams.boto3['EngineName'] = action['parameters'][0]['engineName'];
                reqParams.cli['--engine-name'] = action['parameters'][0]['engineName'];
                reqParams.boto3['MajorEngineVersion'] = action['parameters'][0]['majorEngineVersion'];
                reqParams.cli['--major-engine-version'] = action['parameters'][0]['majorEngineVersion'];
                reqParams.boto3['OptionGroupDescription'] = action['parameters'][0]['optionGroupDescription'];
                reqParams.cli['--option-group-description'] = action['parameters'][0]['optionGroupDescription'];
                reqParams.boto3['OptionGroupName'] = action['parameters'][0]['optionGroupName'];
                reqParams.cli['--option-group-name'] = action['parameters'][0]['optionGroupName'];

                reqParams.cfn['EngineName'] = action['parameters'][0]['engineName'];
                reqParams.cfn['MajorEngineVersion'] = action['parameters'][0]['majorEngineVersion'];
                reqParams.cfn['OptionGroupDescription'] = action['parameters'][0]['optionGroupDescription'];

                reqParams.tf['engine_name'] = action['parameters'][0]['engineName'];
                reqParams.tf['major_engine_version'] = action['parameters'][0]['majorEngineVersion'];
                reqParams.tf['option_group_description'] = action['parameters'][0]['optionGroupDescription'];
                reqParams.tf['name'] = action['parameters'][0]['optionGroupName'];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'CreateOptionGroup',
                        'boto3': 'create_option_group',
                        'cli': 'create-option-group'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('rds', details.requestId),
                    'region': region,
                    'service': 'rds',
                    'type': 'AWS::RDS::OptionGroup',
                    'terraformType': 'aws_db_option_group',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.gwt.sns.requestfactory.shared.SnsRequestContext.listTopicArns") {
                outputs.push({
                    'region': region,
                    'service': 'sns',
                    'method': {
                        'api': 'ListTopics',
                        'boto3': 'list_topics',
                        'cli': 'list-topics'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.EventSubscriptionContext.create") {
                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:es:" + action['parameters'][0]['subscriptionName']
                ];

                reqParams.boto3['Enabled'] = action['parameters'][0]['enabled'];
                reqParams.cli['--enabled'] = action['parameters'][0]['enabled'];
                reqParams.boto3['SnsTopicArn'] = action['parameters'][0]['snsTopicArn'];
                reqParams.cli['--sns-topic-arn'] = action['parameters'][0]['snsTopicArn'];
                reqParams.boto3['SourceType'] = action['parameters'][0]['sourceType'];
                reqParams.cli['--source-type'] = action['parameters'][0]['sourceType'];
                reqParams.boto3['SubscriptionName'] = action['parameters'][0]['subscriptionName'];
                reqParams.cli['--subscription-name'] = action['parameters'][0]['subscriptionName'];
                reqParams.boto3['EventCategories'] = action['parameters'][0]['eventCategories'];
                reqParams.cli['--event-categories'] = action['parameters'][0]['eventCategories'];
                reqParams.boto3['SourceIds'] = action['parameters'][0]['sourceIds'];
                reqParams.cli['--source-ids'] = action['parameters'][0]['sourceIds'];

                reqParams.cfn['Enabled'] = action['parameters'][0]['enabled'];
                reqParams.cfn['SnsTopicArn'] = action['parameters'][0]['snsTopicArn'];
                reqParams.cfn['SourceType'] = action['parameters'][0]['sourceType'];
                reqParams.cfn['EventCategories'] = action['parameters'][0]['eventCategories'];
                reqParams.cfn['SourceIds'] = action['parameters'][0]['sourceIds'];

                reqParams.tf['enabled'] = action['parameters'][0]['enabled'];
                reqParams.tf['sns_topic'] = action['parameters'][0]['snsTopicArn'];
                reqParams.tf['source_type'] = action['parameters'][0]['sourceType'];
                reqParams.tf['name'] = action['parameters'][0]['subscriptionName'];
                reqParams.tf['event_categories'] = action['parameters'][0]['eventCategories'];
                reqParams.tf['source_ids'] = action['parameters'][0]['sourceIds'];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'CreateEventSubscription',
                        'boto3': 'create_event_subscription',
                        'cli': 'create-event-subscription'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('rds', details.requestId),
                    'region': region,
                    'service': 'rds',
                    'type': 'AWS::RDS::EventSubscription',
                    'terraformType': 'aws_db_event_subscription',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.rds.shared.EventSubscriptionContext.list") {
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DescribeEventSubscriptions',
                        'boto3': 'describe_event_subscriptions',
                        'cli': 'describe-event-subscriptions'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbCContext.stopDBCluster") {
                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:cluster:" + action['parameters'][0]
                ];

                reqParams.boto3['DBClusterIdentifier'] = action['parameters'][0];
                reqParams.cli['--db-cluster-identifier'] = action['parameters'][0];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'StopDBCluster',
                        'boto3': 'stop_db_cluster',
                        'cli': 'stop-db-cluster'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbParamGroupContext.createDbClusterParameterGroup") {
                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:cluster-pg:" + action['parameters'][1]
                ];

                reqParams.boto3['DBParameterGroupFamily'] = action['parameters'][0];
                reqParams.cli['--db-parameter-group-family'] = action['parameters'][0];
                reqParams.boto3['DBClusterParameterGroupName'] = action['parameters'][1];
                reqParams.cli['--db-cluster-parameter-group-name'] = action['parameters'][1];
                reqParams.boto3['Description'] = action['parameters'][2];
                reqParams.cli['--description'] = action['parameters'][2];

                reqParams.cfn['Family'] = action['parameters'][0];
                reqParams.cfn['Description'] = action['parameters'][2];

                reqParams.tf['family'] = action['parameters'][0];
                reqParams.tf['name'] = action['parameters'][1];
                reqParams.tf['description'] = action['parameters'][2];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'CreateDBClusterParameterGroup',
                        'boto3': 'create_db_cluster_parameter_group',
                        'cli': 'create-db-cluster-parameter-group'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('rds', details.requestId),
                    'region': region,
                    'service': 'rds',
                    'type': 'AWS::RDS::DBClusterParameterGroup',
                    'terraformType': 'aws_rds_cluster_parameter_group',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbCContext.startDBCluster") {
                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:cluster:" + action['parameters'][0]
                ];

                reqParams.boto3['DBClusterIdentifier'] = action['parameters'][0];
                reqParams.cli['--db-cluster-identifier'] = action['parameters'][0];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'StartDBCluster',
                        'boto3': 'start_db_cluster',
                        'cli': 'start-db-cluster'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            } else if (action['action'] == "com.amazonaws.console.rds.shared.DbInstanceContext.delete") {
                reqParams.iam['Resource'] = [
                    "arn:aws:rds:*:*:db:" + action['parameters'][0]['DBInstanceIdentifier']
                ];

                reqParams.boto3['SkipFinalSnapshot'] = action['parameters'][0]['skipFinalSnapshot'];
                reqParams.cli['--skip-final-snapshot'] = action['parameters'][0]['skipFinalSnapshot'];
                reqParams.boto3['DBInstanceIdentifier'] = action['parameters'][0]['DBInstanceIdentifier'];
                reqParams.cli['--db-instance-identifier'] = action['parameters'][0]['DBInstanceIdentifier'];
        
                outputs.push({
                    'region': region,
                    'service': 'rds',
                    'method': {
                        'api': 'DeleteDBInstance',
                        'boto3': 'delete_db_instance',
                        'cli': 'delete-db-instance'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                if (blocking) {
                    notifyBlocked();
                    return {cancel: true};
                }
            }                     
            
        }

        return {};
    }
       
    // autogen:lambda:lambda.ListFunctions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=listFunctions&/g)) {

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'ListFunctions',
                'boto3': 'list_functions',
                'cli': 'list-functions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:iam.ListRoles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=listRoles&/g)) {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListRoles',
                'boto3': 'list_roles',
                'cli': 'list-roles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:iam.ListRoles
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=listRoles&/g)) {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListRoles',
                'boto3': 'list_roles',
                'cli': 'list-roles'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=listVpcs&/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:lambda.GetFunctionConfiguration
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=getFunctionConfiguration&/g)) {
        reqParams.boto3['FunctionName'] = jsonRequestBody.functionName;
        reqParams.cli['--function-name'] = jsonRequestBody.functionName;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'GetFunctionConfiguration',
                'boto3': 'get_function_configuration',
                'cli': 'get-function-configuration'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:lambda.GetFunction
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=getFunctionCode&/g)) {
        reqParams.boto3['FunctionName'] = jsonRequestBody.functionName;
        reqParams.cli['--function-name'] = jsonRequestBody.functionName;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'GetFunction',
                'boto3': 'get_function',
                'cli': 'get-function'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:lambda.ListTags
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=listTags&/g)) {
        reqParams.boto3['Resource'] = jsonRequestBody.functionName;
        reqParams.cli['--resource'] = jsonRequestBody.functionName;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'ListTags',
                'boto3': 'list_tags',
                'cli': 'list-tags'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:iam.GetRole
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=getRole&/g)) {
        reqParams.boto3['RoleName'] = jsonRequestBody.roleName;
        reqParams.cli['--role-name'] = jsonRequestBody.roleName;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'GetRole',
                'boto3': 'get_role',
                'cli': 'get-role'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:kms.ListKeys
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=listKmsKeys&/g)) {

        outputs.push({
            'region': region,
            'service': 'kms',
            'method': {
                'api': 'ListKeys',
                'boto3': 'list_keys',
                'cli': 'list-keys'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:lambda.CreateAlias
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=createAlias&/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:lambda:*:*:function:" + jsonRequestBody.functionName
        ];

        reqParams.boto3['FunctionName'] = jsonRequestBody.functionName;
        reqParams.cli['--function-name'] = jsonRequestBody.functionName;
        reqParams.boto3['Name'] = jsonRequestBody.name;
        reqParams.cli['--name'] = jsonRequestBody.name;
        reqParams.boto3['Description'] = jsonRequestBody.description;
        reqParams.cli['--description'] = jsonRequestBody.description;
        reqParams.boto3['FunctionVersion'] = jsonRequestBody.functionVersion;
        reqParams.cli['--function-version'] = jsonRequestBody.functionVersion;

        reqParams.cfn['FunctionName'] = jsonRequestBody.functionName;
        reqParams.cfn['Name'] = jsonRequestBody.name;
        reqParams.cfn['Description'] = jsonRequestBody.description;
        reqParams.cfn['FunctionVersion'] = jsonRequestBody.functionVersion;

        reqParams.tf['function_name'] = jsonRequestBody.functionName;
        reqParams.tf['name'] = jsonRequestBody.name;
        reqParams.tf['description'] = jsonRequestBody.description;
        reqParams.tf['function_version'] = jsonRequestBody.functionVersion;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'CreateAlias',
                'boto3': 'create_alias',
                'cli': 'create-alias'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('lambda', details.requestId),
            'region': region,
            'service': 'lambda',
            'type': 'AWS::Lambda::Alias',
            'terraformType': 'aws_lambda_alias',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:lambda:lambda.GetAlias
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=getAlias&/g)) {
        reqParams.boto3['FunctionName'] = jsonRequestBody.functionName;
        reqParams.cli['--function-name'] = jsonRequestBody.functionName;
        reqParams.boto3['Name'] = jsonRequestBody.name;
        reqParams.cli['--name'] = jsonRequestBody.name;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'GetAlias',
                'boto3': 'get_alias',
                'cli': 'get-alias'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:lambda:lambda.DeleteFunction
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=deleteFunction&/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:lambda:*:*:function:" + jsonRequestBody.functionName
        ];

        reqParams.boto3['FunctionName'] = jsonRequestBody.functionName;
        reqParams.cli['--function-name'] = jsonRequestBody.functionName;
        reqParams.boto3['Qualifier'] = jsonRequestBody.qualifier;
        reqParams.cli['--qualifier'] = jsonRequestBody.qualifier;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'DeleteFunction',
                'boto3': 'delete_function',
                'cli': 'delete-function'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:lambda:lambda.PublishVersion
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/lambda\/services\/ajax\?operation=publishVersion&/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:lambda:*:*:function:" + jsonRequestBody.functionName
        ];

        reqParams.boto3['FunctionName'] = jsonRequestBody.payload.functionName;
        reqParams.cli['--function-name'] = jsonRequestBody.payload.functionName;
        reqParams.boto3['Description'] = jsonRequestBody.payload.description;
        reqParams.cli['--description'] = jsonRequestBody.payload.description;

        reqParams.cfn['FunctionName'] = jsonRequestBody.payload.functionName;
        reqParams.cfn['Description'] = jsonRequestBody.payload.description;

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'PublishVersion',
                'boto3': 'publish_version',
                'cli': 'publish-version'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('lambda', details.requestId),
            'region': region,
            'service': 'lambda',
            'type': 'AWS::Lambda::Version',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }
 
    // autogen:lambda:lambda.CreateFunction
    if (details.method == "POST" && details.url.match(/.+lambda\.[a-z0-9-]+\.amazonaws\.com\/2015\-03\-31\/functions$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:lambda:*:*:function:" + jsonRequestBody.functionName
        ];

        reqParams.boto3['Code'] = jsonRequestBody.Code;
        reqParams.cli['--code'] = jsonRequestBody.Code;
        reqParams.boto3['Description'] = jsonRequestBody.Description;
        reqParams.cli['--description'] = jsonRequestBody.Description;
        reqParams.boto3['FunctionName'] = jsonRequestBody.FunctionName;
        reqParams.cli['--function-name'] = jsonRequestBody.FunctionName;
        reqParams.boto3['Handler'] = jsonRequestBody.Handler;
        reqParams.cli['--handler'] = jsonRequestBody.Handler;
        reqParams.boto3['MemorySize'] = jsonRequestBody.MemorySize;
        reqParams.cli['--memory-size'] = jsonRequestBody.MemorySize;
        reqParams.boto3['Role'] = jsonRequestBody.Role;
        reqParams.cli['--role'] = jsonRequestBody.Role;
        reqParams.boto3['Runtime'] = jsonRequestBody.Runtime;
        reqParams.cli['--runtime'] = jsonRequestBody.Runtime;
        reqParams.boto3['Timeout'] = jsonRequestBody.Timeout;
        reqParams.cli['--timeout'] = jsonRequestBody.Timeout;
        reqParams.boto3['DeadLetterConfig'] = jsonRequestBody.DeadLetterConfig;
        reqParams.cli['--dead-letter-config'] = jsonRequestBody.DeadLetterConfig;
        reqParams.boto3['KMSKeyArn'] = jsonRequestBody.KMSKeyArn;
        reqParams.cli['--kms-key-arn'] = jsonRequestBody.KMSKeyArn;
        reqParams.boto3['TracingConfig'] = jsonRequestBody.TracingConfig;
        reqParams.cli['--tracing-config'] = jsonRequestBody.TracingConfig;

        reqParams.cfn['Code'] = jsonRequestBody.Code;
        reqParams.cfn['Description'] = jsonRequestBody.Description;
        reqParams.cfn['FunctionName'] = jsonRequestBody.FunctionName;
        reqParams.cfn['Handler'] = jsonRequestBody.Handler;
        reqParams.cfn['MemorySize'] = jsonRequestBody.MemorySize;
        reqParams.cfn['Role'] = jsonRequestBody.Role;
        reqParams.cfn['Runtime'] = jsonRequestBody.Runtime;
        reqParams.cfn['Timeout'] = jsonRequestBody.Timeout;
        reqParams.cfn['DeadLetterConfig'] = jsonRequestBody.DeadLetterConfig;
        reqParams.cfn['KmsKeyArn'] = jsonRequestBody.KMSKeyArn;
        reqParams.cfn['TracingConfig'] = jsonRequestBody.TracingConfig;

        reqParams.tf['filename'] = 'CHANGEME.zip';
        reqParams.tf['description'] = jsonRequestBody.Description;
        reqParams.tf['function_name'] = jsonRequestBody.FunctionName;
        reqParams.tf['handler'] = jsonRequestBody.Handler;
        reqParams.tf['memory_size'] = jsonRequestBody.MemorySize;
        reqParams.tf['role'] = jsonRequestBody.Role;
        reqParams.tf['runtime'] = jsonRequestBody.Runtime;
        reqParams.tf['timeout'] = jsonRequestBody.Timeout;
        reqParams.tf['dead_letter_config'] = {
            'target_arn': jsonRequestBody.DeadLetterConfig.TargetArn
        };
        reqParams.tf['kms_key_arn'] = jsonRequestBody.KMSKeyArn;
        reqParams.tf['tracing_config'] = {
            'mode': jsonRequestBody.TracingConfig.Mode
        };

        outputs.push({
            'region': region,
            'service': 'lambda',
            'method': {
                'api': 'CreateFunction',
                'boto3': 'create_function',
                'cli': 'create-function'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('lambda', details.requestId),
            'region': region,
            'service': 'lambda',
            'type': 'AWS::Lambda::Function',
            'terraformType': 'aws_lambda_function',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:es:es.ListDomainNames
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "ListDomainNames") {

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'ListDomainNames',
                'boto3': 'list_domain_names',
                'cli': 'list-domain-names'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:es.ListElasticsearchVersions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "ListElasticsearchVersions") {

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'ListElasticsearchVersions',
                'boto3': 'list_elasticsearch_versions',
                'cli': 'list-elasticsearch-versions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:es.ListElasticsearchInstanceTypes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "listElasticsearchInstanceTypes") {

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'ListElasticsearchInstanceTypes',
                'boto3': 'list_elasticsearch_instance_types',
                'cli': 'list-elasticsearch-instance-types'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:kms.DescribeKey
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/kms$/g) && jsonRequestBody.operation == "DescribeKey") {
        reqParams.boto3['KeyId'] = jsonRequestBody.contentString.KeyId;
        reqParams.cli['--key-id'] = jsonRequestBody.contentString.KeyId;

        outputs.push({
            'region': region,
            'service': 'kms',
            'method': {
                'api': 'DescribeKey',
                'boto3': 'describe_key',
                'cli': 'describe-key'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/ec2$/g) && jsonRequestBody.operation == "DescribeVpcs") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:iam.GetRole
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/iam$/g) && jsonRequestBody.operation == "GetRole") {
        reqParams.boto3['RoleName'] = jsonRequestBody.params.RoleName;
        reqParams.cli['--role-name'] = jsonRequestBody.params.RoleName;

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'GetRole',
                'boto3': 'get_role',
                'cli': 'get-role'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/ec2$/g) && jsonRequestBody.operation == "DescribeSubnets") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:ec2.DescribeSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/ec2$/g) && jsonRequestBody.operation == "DescribeSecurityGroups") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSecurityGroups',
                'boto3': 'describe_security_groups',
                'cli': 'describe-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:es.CreateElasticsearchDomain
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "CreateElasticsearchDomain") {
        reqParams.iam['Resource'] = [
            "arn:aws:es:*:*:domain/" + jsonRequestBody.contentString.DomainName
        ];

        reqParams.boto3['ElasticsearchClusterConfig'] = jsonRequestBody.contentString.ElasticsearchClusterConfig;
        reqParams.cli['--elasticsearch-cluster-config'] = jsonRequestBody.contentString.ElasticsearchClusterConfig;
        reqParams.boto3['EBSOptions'] = jsonRequestBody.contentString.EBSOptions;
        reqParams.cli['--ebs-options'] = jsonRequestBody.contentString.EBSOptions;
        reqParams.boto3['EncryptionAtRestOptions'] = jsonRequestBody.contentString.EncryptionAtRestOptions;
        reqParams.cli['--encryption-at-rest-options'] = jsonRequestBody.contentString.EncryptionAtRestOptions;
        reqParams.boto3['SnapshotOptions'] = jsonRequestBody.contentString.SnapshotOptions;
        reqParams.cli['--snapshot-options'] = jsonRequestBody.contentString.SnapshotOptions;
        reqParams.boto3['VPCOptions'] = {
            'SubnetIds': jsonRequestBody.contentString.VPCOptions.SubnetIds,
            'SecurityGroupIds': jsonRequestBody.contentString.VPCOptions.SecurityGroupIds
        };
        reqParams.cli['--vpc-options'] = {
            'SubnetIds': jsonRequestBody.contentString.VPCOptions.SubnetIds,
            'SecurityGroupIds': jsonRequestBody.contentString.VPCOptions.SecurityGroupIds
        };
        reqParams.boto3['AdvancedOptions'] = jsonRequestBody.contentString.AdvancedOptions;
        reqParams.cli['--advanced-options'] = jsonRequestBody.contentString.AdvancedOptions;
        reqParams.boto3['CognitoOptions'] = jsonRequestBody.contentString.CognitoOptions;
        reqParams.cli['--cognito-options'] = jsonRequestBody.contentString.CognitoOptions;
        reqParams.boto3['NodeToNodeEncryptionOptions'] = jsonRequestBody.contentString.NodeToNodeEncryptionOptions;
        reqParams.cli['--node-to-node-encryption-options'] = jsonRequestBody.contentString.NodeToNodeEncryptionOptions;
        reqParams.boto3['DomainName'] = jsonRequestBody.contentString.DomainName;
        reqParams.cli['--domain-name'] = jsonRequestBody.contentString.DomainName;
        reqParams.boto3['ElasticsearchVersion'] = jsonRequestBody.contentString.ElasticsearchVersion;
        reqParams.cli['--elasticsearch-version'] = jsonRequestBody.contentString.ElasticsearchVersion;
        reqParams.boto3['AccessPolicies'] = jsonRequestBody.contentString.AccessPolicies;
        reqParams.cli['--access-policies'] = jsonRequestBody.contentString.AccessPolicies;

        reqParams.cfn['ElasticsearchClusterConfig'] = jsonRequestBody.contentString.ElasticsearchClusterConfig;
        reqParams.cfn['EBSOptions'] = jsonRequestBody.contentString.EBSOptions;
        reqParams.cfn['EncryptionAtRestOptions'] = jsonRequestBody.contentString.EncryptionAtRestOptions;
        reqParams.cfn['SnapshotOptions'] = jsonRequestBody.contentString.SnapshotOptions;
        reqParams.cfn['VPCOptions'] = {
            'SubnetIds': jsonRequestBody.contentString.VPCOptions.SubnetIds,
            'SecurityGroupIds': jsonRequestBody.contentString.VPCOptions.SecurityGroupIds
        };
        reqParams.cfn['AdvancedOptions'] = jsonRequestBody.contentString.AdvancedOptions;
        reqParams.cfn['DomainName'] = jsonRequestBody.contentString.DomainName;
        reqParams.cfn['ElasticsearchVersion'] = jsonRequestBody.contentString.ElasticsearchVersion;
        reqParams.cfn['AccessPolicies'] = jsonRequestBody.contentString.AccessPolicies;

        reqParams.tf['cluster_config'] = {
            'instance_count': jsonRequestBody.contentString.ElasticsearchClusterConfig.InstanceCount,
            'instance_type': jsonRequestBody.contentString.ElasticsearchClusterConfig.InstanceType,
            'zone_awareness_enabled': jsonRequestBody.contentString.ElasticsearchClusterConfig.ZoneAwarenessEnabled,
            'dedicated_master_enabled': jsonRequestBody.contentString.ElasticsearchClusterConfig.DedicatedMasterEnabled,
            'dedicated_master_type': jsonRequestBody.contentString.ElasticsearchClusterConfig.DedicatedMasterType,
            'dedicated_master_count': jsonRequestBody.contentString.ElasticsearchClusterConfig.DedicatedMasterCount
        };
        reqParams.tf['ebs_options'] = {
            'ebs_enabled': jsonRequestBody.contentString.EBSOptions.EBSEnabled,
            'volume_type': jsonRequestBody.contentString.EBSOptions.VolumeType,
            'iops': jsonRequestBody.contentString.EBSOptions.Iops,
            'volume_size': jsonRequestBody.contentString.EBSOptions.VolumeSize
        };
        reqParams.tf['encrypt_at_rest'] = {
            'enabled': jsonRequestBody.contentString.EncryptionAtRestOptions.Enabled,
            'kms_key_id': jsonRequestBody.contentString.EncryptionAtRestOptions.KmsKeyId
        };
        reqParams.tf['node_to_node_encryption'] = {
            'enabled': jsonRequestBody.contentString.NodeToNodeEncryptionOptions.Enabled
        };
        reqParams.tf['snapshot_options'] = {
            'automated_snapshot_start_hour': jsonRequestBody.contentString.SnapshotOptions.AutomatedSnapshotStartHour
        };
        reqParams.tf['vpc_options'] = {
            'subnet_ids': jsonRequestBody.contentString.VPCOptions.SubnetIds,
            'security_group_ids': jsonRequestBody.contentString.VPCOptions.SecurityGroupIds
        };
        reqParams.tf['advanced_options'] = jsonRequestBody.contentString.AdvancedOptions;
        reqParams.tf['domain_name'] = jsonRequestBody.contentString.DomainName;
        reqParams.tf['elasticsearch_version'] = jsonRequestBody.contentString.ElasticsearchVersion;
        reqParams.tf['access_policies'] = jsonRequestBody.contentString.AccessPolicies;

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'CreateElasticsearchDomain',
                'boto3': 'create_elasticsearch_domain',
                'cli': 'create-elasticsearch-domain'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('es', details.requestId),
            'region': region,
            'service': 'es',
            'type': 'AWS::Elasticsearch::Domain',
            'terraformType': 'aws_elasticsearch_domain',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:es:es.DescribeElasticsearchDomain
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "DescribeElasticsearchDomain") {
        reqParams.boto3['DomainName'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--domain-name'] = jsonRequestBody.path.split("/")[4];

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'DescribeElasticsearchDomain',
                'boto3': 'describe_elasticsearch_domain',
                'cli': 'describe-elasticsearch-domain'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:es.GetUpgradeStatus
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "GetUpgradeStatus") {
        reqParams.boto3['DomainName'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--domain-name'] = jsonRequestBody.path.split("/")[4];

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'GetUpgradeStatus',
                'boto3': 'get_upgrade_status',
                'cli': 'get-upgrade-status'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:es.GetCompatibleElasticsearchVersions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "GetCompatibleElasticsearchVersions") {
        reqParams.boto3['DomainName'] = jsonRequestBody.params.domainName;
        reqParams.cli['--domain-name'] = jsonRequestBody.params.domainName;

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'GetCompatibleElasticsearchVersions',
                'boto3': 'get_compatible_elasticsearch_versions',
                'cli': 'get-compatible-elasticsearch-versions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:es.GetUpgradeHistory
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "GetUpgradeHistory") {
        reqParams.boto3['DomainName'] = jsonRequestBody.path.split("/")[3];
        reqParams.cli['--domain-name'] = jsonRequestBody.path.split("/")[3];

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'GetUpgradeHistory',
                'boto3': 'get_upgrade_history',
                'cli': 'get-upgrade-history'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:es.DeleteElasticsearchDomain
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "DeleteElasticsearchDomain") {
        reqParams.iam['Resource'] = [
            "arn:aws:es:*:*:domain/" + jsonRequestBody.contentString.DomainName
        ];
        
        reqParams.boto3['DomainName'] = jsonRequestBody.path.split("/")[4];
        reqParams.cli['--domain-name'] = jsonRequestBody.path.split("/")[4];

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'DeleteElasticsearchDomain',
                'boto3': 'delete_elasticsearch_domain',
                'cli': 'delete-elasticsearch-domain'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:es:es.DescribeReservedElasticsearchInstances
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "DescribeReservedElasticsearchInstances") {
        reqParams.boto3['MaxResults'] = jsonRequestBody.params.maxResults;
        reqParams.cli['--max-items'] = jsonRequestBody.params.maxResults;

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'DescribeReservedElasticsearchInstances',
                'boto3': 'describe_reserved_elasticsearch_instances',
                'cli': 'describe-reserved-elasticsearch-instances'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:es:es.DescribeElasticsearchDomains
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/es\/api\/es$/g) && jsonRequestBody.operation == "DescribeElasticsearchDomains") {
        reqParams.boto3['DomainNames'] = jsonRequestBody.contentString.DomainNames;
        reqParams.cli['--domain-names'] = jsonRequestBody.contentString.DomainNames;

        outputs.push({
            'region': region,
            'service': 'es',
            'method': {
                'api': 'DescribeElasticsearchDomains',
                'boto3': 'describe_elasticsearch_domains',
                'cli': 'describe-elasticsearch-domains'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:sns:sns.ListTopics
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sns\/v2\/ListTopics$/g)) {

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'ListTopics',
                'boto3': 'list_topics',
                'cli': 'list-topics'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:sns:sns.ListSubscriptions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sns\/v2\/ListSubscriptions$/g)) {

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'ListSubscriptions',
                'boto3': 'list_subscriptions',
                'cli': 'list-subscriptions'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:sns:sns.CreateTopic
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sns\/v2\/CreateTopic$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:sns:*:*:" + jsonRequestBody.topicName
        ];

        reqParams.boto3['Name'] = jsonRequestBody.topicName;
        reqParams.cli['--name'] = jsonRequestBody.topicName;

        reqParams.cfn['TopicName'] = jsonRequestBody.topicName;

        reqParams.tf['name'] = jsonRequestBody.topicName;

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'CreateTopic',
                'boto3': 'create_topic',
                'cli': 'create-topic'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('sns', details.requestId),
            'region': region,
            'service': 'sns',
            'type': 'AWS::SNS::Topic',
            'terraformType': 'aws_sns_topic',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:sns:sns.SetTopicAttributes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sns\/v2\/SetTopicAttributes$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:sns:*:*:" + jsonRequestBody.topicArn.split(":").pop()
        ];

        reqParams.boto3['TopicArn'] = jsonRequestBody.topicArn;
        reqParams.cli['--topic-arn'] = jsonRequestBody.topicArn;
        reqParams.boto3['AttributeName'] = jsonRequestBody.attributeName;
        reqParams.cli['--attribute-name'] = jsonRequestBody.attributeName;
        reqParams.boto3['AttributeValue'] = jsonRequestBody.attributeValue;
        reqParams.cli['--attribute-value'] = jsonRequestBody.attributeValue;

        if (jsonRequestBody.attributeName == "Policy") {
            reqParams.cfn['PolicyDocument'] = jsonRequestBody.attributeValue;
            reqParams.cfn['Topics'] = [jsonRequestBody.topicArn];
            reqParams.tf['policy'] = jsonRequestBody.attributeValue;
            reqParams.tf['arn'] = jsonRequestBody.topicArn;

            tracked_resources.push({
                'logicalId': getResourceName('sns', details.requestId),
                'region': region,
                'service': 'sns',
                'type': 'AWS::SNS::TopicPolicy',
                'terraformType': 'aws_sns_topic_policy',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });
        }

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'SetTopicAttributes',
                'boto3': 'set_topic_attributes',
                'cli': 'set-topic-attributes'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:sns:sns.DeleteTopic
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sns\/v2\/DeleteTopic$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:sns:*:*:" + jsonRequestBody.topicArn.split(":").pop()
        ];

        reqParams.boto3['TopicArn'] = jsonRequestBody.topicArn;
        reqParams.cli['--topic-arn'] = jsonRequestBody.topicArn;

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'DeleteTopic',
                'boto3': 'delete_topic',
                'cli': 'delete-topic'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:sns:sns.ListPlatformApplications
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sns\/v2\/ListPlatformApplications$/g)) {
        reqParams.boto3['NextToken'] = jsonRequestBody.nextToken;
        reqParams.cli['--next-token'] = jsonRequestBody.nextToken;

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'ListPlatformApplications',
                'boto3': 'list_platform_applications',
                'cli': 'list-platform-applications'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:sns:sns.Subscribe
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sns\/v2\/Subscribe$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:sns:*:*:" + jsonRequestBody.topicArn.split(":").pop()
        ];

        reqParams.boto3['TopicArn'] = jsonRequestBody.topicArn;
        reqParams.cli['--topic-arn'] = jsonRequestBody.topicArn;
        reqParams.boto3['Endpoint'] = jsonRequestBody.endpoint;
        reqParams.cli['--endpoint'] = jsonRequestBody.endpoint;
        reqParams.boto3['Protocol'] = jsonRequestBody.protocol;
        reqParams.cli['--protocol'] = jsonRequestBody.protocol;

        reqParams.cfn['TopicArn'] = jsonRequestBody.topicArn;
        reqParams.cfn['Endpoint'] = jsonRequestBody.endpoint;
        reqParams.cfn['Protocol'] = jsonRequestBody.protocol;

        reqParams.tf['topic_arn'] = jsonRequestBody.topicArn;
        reqParams.tf['endpoint'] = jsonRequestBody.endpoint;
        reqParams.tf['protocol'] = jsonRequestBody.protocol;

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'Subscribe',
                'boto3': 'subscribe',
                'cli': 'subscribe'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('sns', details.requestId),
            'region': region,
            'service': 'sns',
            'type': 'AWS::SNS::Subscription',
            'terraformType': 'aws_sns_topic_subscription',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:sns:sns.GetTopicAttributes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sns\/v2\/GetTopicAttributes$/g)) {
        reqParams.boto3['TopicArn'] = jsonRequestBody.topicArn;
        reqParams.cli['--topic-arn'] = jsonRequestBody.topicArn;

        outputs.push({
            'region': region,
            'service': 'sns',
            'method': {
                'api': 'GetTopicAttributes',
                'boto3': 'get_topic_attributes',
                'cli': 'get-topic-attributes'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ds:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/directoryservicev2\/api\/ec2$/g) && jsonRequestBody.operation == "describeVpcs") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ds:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/directoryservicev2\/api\/ec2$/g) && jsonRequestBody.operation == "describeSubnets") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ds:ds.CreateDirectory
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/directoryservicev2\/api\/galaxy$/g) && jsonRequestBody.operation == "CreateDirectory") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.iam['secondary'] = [
            {
                'Action': [
                    'ec2:CreateSecurityGroup',
                    'ec2:CreateNetworkInterface',
                    'ec2:DescribeNetworkInterfaces',
                    'ec2:DescribeSubnets',
                    'ec2:DescribeVpcs'
                ],
                'Resource': [
                    '*'
                ]
            },
            {
                'Action': [
                    'ec2:AuthorizeSecurityGroupIngress',
                    'ec2:AuthorizeSecurityGroupEgress'
                ],
                'Resource': [
                    'arn:aws:ec2:*:*:security-group/*'
                ]
            }
        ];

        reqParams.boto3['Name'] = jsonRequestBody.contentString.Name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.Name;
        reqParams.boto3['Password'] = jsonRequestBody.contentString.Password;
        reqParams.cli['--password'] = jsonRequestBody.contentString.Password;
        reqParams.boto3['ShortName'] = jsonRequestBody.contentString.ShortName;
        reqParams.cli['--short-name'] = jsonRequestBody.contentString.ShortName;
        reqParams.boto3['Size'] = jsonRequestBody.contentString.Type;
        reqParams.cli['--size'] = jsonRequestBody.contentString.Type;
        reqParams.boto3['VpcSettings'] = jsonRequestBody.contentString.VpcSettings;
        reqParams.cli['--vpc-settings'] = jsonRequestBody.contentString.VpcSettings;

        reqParams.cfn['Name'] = jsonRequestBody.contentString.Name;
        reqParams.cfn['Password'] = jsonRequestBody.contentString.Password;
        reqParams.cfn['ShortName'] = jsonRequestBody.contentString.ShortName;
        reqParams.cfn['Size'] = jsonRequestBody.contentString.Type;
        reqParams.cfn['VpcSettings'] = jsonRequestBody.contentString.VpcSettings;

        outputs.push({
            'region': region,
            'service': 'ds',
            'method': {
                'api': 'CreateDirectory',
                'boto3': 'create_directory',
                'cli': 'create-directory'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ds', details.requestId),
            'region': region,
            'service': 'ds',
            'type': 'AWS::DirectoryService::SimpleAD',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ds:ds.DescribeDirectories
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/directoryservicev2\/api\/galaxy$/g) && jsonRequestBody.operation == "DescribeDirectories") {
        reqParams.boto3['DirectoryIds'] = jsonRequestBody.contentString.DirectoryIds;
        reqParams.cli['--directory-ids'] = jsonRequestBody.contentString.DirectoryIds;

        outputs.push({
            'region': region,
            'service': 'ds',
            'method': {
                'api': 'DescribeDirectories',
                'boto3': 'describe_directories',
                'cli': 'describe-directories'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ds:ds.DeleteDirectory
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/directoryservicev2\/api\/galaxy$/g) && jsonRequestBody.operation == "DeleteDirectory") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.iam['secondary'] = [
            {
                'Action': [
                    'ec2:DeleteNetworkInterface',
                    'ec2:DescribeNetworkInterfaces'
                ],
                'Resource': [
                    '*'
                ]
            },
            {
                'Action': [
                    'ec2:DeleteSecurityGroup',
                    'ec2:RevokeSecurityGroupEgress',
                    'ec2:RevokeSecurityGroupIngress'
                ],
                'Resource': [
                    'arn:aws:ec2:*:*:security-group/*'
                ]
            }
        ];

        reqParams.boto3['DirectoryId'] = jsonRequestBody.contentString.DirectoryId;
        reqParams.cli['--directory-id'] = jsonRequestBody.contentString.DirectoryId;

        outputs.push({
            'region': region,
            'service': 'ds',
            'method': {
                'api': 'DeleteDirectory',
                'boto3': 'delete_directory',
                'cli': 'delete-directory'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ds:ds.CreateMicrosoftAD
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/directoryservicev2\/api\/galaxy$/g) && jsonRequestBody.operation == "CreateMicrosoftAD") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.iam['secondary'] = [
            {
                'Action': [
                    'ec2:CreateSecurityGroup',
                    'ec2:CreateNetworkInterface',
                    'ec2:DescribeNetworkInterfaces',
                    'ec2:DescribeSubnets',
                    'ec2:DescribeVpcs'
                ],
                'Resource': [
                    '*'
                ]
            },
            {
                'Action': [
                    'ec2:AuthorizeSecurityGroupIngress',
                    'ec2:AuthorizeSecurityGroupEgress'
                ],
                'Resource': [
                    'arn:aws:ec2:*:*:security-group/*'
                ]
            }
        ];

        reqParams.boto3['Name'] = jsonRequestBody.contentString.Name;
        reqParams.cli['--name'] = jsonRequestBody.contentString.Name;
        reqParams.boto3['Password'] = jsonRequestBody.contentString.Password;
        reqParams.cli['--password'] = jsonRequestBody.contentString.Password;
        reqParams.boto3['ShortName'] = jsonRequestBody.contentString.ShortName;
        reqParams.cli['--short-name'] = jsonRequestBody.contentString.ShortName;
        reqParams.boto3['Edition'] = jsonRequestBody.contentString.Edition;
        reqParams.cli['--edition'] = jsonRequestBody.contentString.Edition;
        reqParams.boto3['VpcSettings'] = jsonRequestBody.contentString.VpcSettings;
        reqParams.cli['--vpc-settings'] = jsonRequestBody.contentString.VpcSettings;

        reqParams.cfn['Name'] = jsonRequestBody.contentString.Name;
        reqParams.cfn['Password'] = jsonRequestBody.contentString.Password;
        reqParams.cfn['ShortName'] = jsonRequestBody.contentString.ShortName;
        reqParams.cfn['Edition'] = jsonRequestBody.contentString.Edition;
        reqParams.cfn['VpcSettings'] = jsonRequestBody.contentString.VpcSettings;

        outputs.push({
            'region': region,
            'service': 'ds',
            'method': {
                'api': 'CreateMicrosoftAD',
                'boto3': 'create_microsoft_ad',
                'cli': 'create-microsoft-ad'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ds', details.requestId),
            'region': region,
            'service': 'ds',
            'type': 'AWS::DirectoryService::MicrosoftAD',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcClassicLinkDnsSupport
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=callSdk_com\.amazonaws\.services\.ec2\.AmazonEC2Client_describeVpcClassicLinkDnsSupport\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcClassicLinkDnsSupport',
                'boto3': 'describe_vpc_classic_link_dns_support',
                'cli': 'describe-vpc-classic-link-dns-support'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2ux\.elasticconsole\.generated\.ElasticConsoleBackendGenerated\.MergedDescribeSubnets\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeVpcs\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeAvailabilityZones
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeAvailabilityZones\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeAvailabilityZones',
                'boto3': 'describe_availability_zones',
                'cli': 'describe-availability-zones'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.CreateSubnet
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.CreateSubnet\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = jsonRequestBody.VpcId;
        reqParams.cli['--vpc-id'] = jsonRequestBody.VpcId;
        reqParams.boto3['CidrBlock'] = jsonRequestBody.CidrBlock;
        reqParams.cli['--cidr-block'] = jsonRequestBody.CidrBlock;
        reqParams.boto3['AvailabilityZone'] = jsonRequestBody.AvailabilityZone;
        reqParams.cli['--availability-zone'] = jsonRequestBody.AvailabilityZone;
        reqParams.boto3['Ipv6CidrBlock'] = jsonRequestBody.Ipv6CidrBlock;
        reqParams.cli['--ipv6-cidr-block'] = jsonRequestBody.Ipv6CidrBlock;

        reqParams.cfn['VpcId'] = jsonRequestBody.VpcId;
        reqParams.cfn['CidrBlock'] = jsonRequestBody.CidrBlock;
        reqParams.cfn['AvailabilityZone'] = jsonRequestBody.AvailabilityZone;
        reqParams.cfn['Ipv6CidrBlock'] = jsonRequestBody.Ipv6CidrBlock;

        reqParams.tf['vpc_id'] = jsonRequestBody.VpcId;
        reqParams.tf['cidr_block'] = jsonRequestBody.CidrBlock;
        reqParams.tf['availability_zone'] = jsonRequestBody.AvailabilityZone;
        reqParams.tf['ipv6_cidr_block'] = jsonRequestBody.Ipv6CidrBlock;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateSubnet',
                'boto3': 'create_subnet',
                'cli': 'create-subnet'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::Subnet',
            'terraformType': 'aws_subnet',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeNatGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=getNatGatewayUnsupportedZones\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeNatGateways',
                'boto3': 'describe_nat_gateways',
                'cli': 'describe-nat-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeInstances
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeInstances\?/g)) {
        reqParams.boto3['Filters'] = jsonRequestBody.filters;
        reqParams.cli['--filters'] = jsonRequestBody.filters;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeInstances',
                'boto3': 'describe_instances',
                'cli': 'describe-instances'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeNetworkInterfaces
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeNetworkInterfaces\?/g)) {
        reqParams.boto3['Filters'] = jsonRequestBody.filters;
        reqParams.cli['--filters'] = jsonRequestBody.filters;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeNetworkInterfaces',
                'boto3': 'describe_network_interfaces',
                'cli': 'describe-network-interfaces'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcEndpoints
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=callSdk_com\.amazonaws\.services\.ec2\.AmazonEC2Client_describeVpcEndpoints\?/g)) {
        reqParams.boto3['Filters'] = jsonRequestBody.request.filters;
        reqParams.cli['--filters'] = jsonRequestBody.request.filters;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcEndpoints',
                'boto3': 'describe_vpc_endpoints',
                'cli': 'describe-vpc-endpoints'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeEgressOnlyInternetGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=callSdk_com\.amazonaws\.services\.ec2\.AmazonEC2Client_describeEgressOnlyInternetGateways\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeEgressOnlyInternetGateways',
                'boto3': 'describe_egress_only_internet_gateways',
                'cli': 'describe-egress-only-internet-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DeleteNatGateway
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\?call=callSdk_com\.amazonaws\.services\.ec2\.AmazonEC2Client_deleteNatGateway\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['NatGatewayId'] = jsonRequestBody.request.natGatewayId;
        reqParams.cli['--nat-gateway-id'] = jsonRequestBody.request.natGatewayId;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteNatGateway',
                'boto3': 'delete_nat_gateway',
                'cli': 'delete-nat-gateway'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.CreateVpc
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "createVpc") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['CidrBlock'] = getPipeSplitField(requestBody, 18);
        reqParams.cli['--cidr-block'] = getPipeSplitField(requestBody, 18);
        reqParams.boto3['InstanceTenancy'] = getPipeSplitField(requestBody, 19);
        reqParams.cli['--instance-tenancy'] = getPipeSplitField(requestBody, 19);

        reqParams.cfn['CidrBlock'] = getPipeSplitField(requestBody, 18);
        reqParams.cfn['InstanceTenancy'] = getPipeSplitField(requestBody, 19);

        reqParams.tf['cidr_block'] = getPipeSplitField(requestBody, 18);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateVpc',
                'boto3': 'create_vpc',
                'cli': 'create-vpc'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::VPC',
            'terraformType': 'aws_vpc',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getVpcs") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeDhcpOptions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getDHCPOptions") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeDhcpOptions',
                'boto3': 'describe_dhcp_options',
                'cli': 'describe-dhcp-options'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeVpcAttribute
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getVpcAttributes") {
        reqParams.boto3['VpcId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--vpc-id'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcAttribute',
                'boto3': 'describe_vpc_attribute',
                'cli': 'describe-vpc-attribute'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeRouteTables
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getRouteTables") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeRouteTables',
                'boto3': 'describe_route_tables',
                'cli': 'describe-route-tables'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeNetworkAcls
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "createDHCPOption" && gwtRequest['method'] == "getNetworkACLs") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeNetworkAcls',
                'boto3': 'describe_network_acls',
                'cli': 'describe-network-acls'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.CreateNetworkAcl
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "createNetworkACL") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--vpc-id'] = getPipeSplitField(requestBody, 17);

        reqParams.cfn['VpcId'] = getPipeSplitField(requestBody, 17);

        reqParams.tf['VpcId'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'CreateNetworkAcl',
                'boto3': 'create_network_acl',
                'cli': 'create-network-acl'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::NetworkAcl',
            'terraformType': 'aws_network_acl',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteNetworkAcl
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "modifyIngressRulesForNetworkACL" && gwtRequest['method'] == "deleteNetworkACL") {
        reqParams.iam['Resource'] = [
            "arn:aws:ec2:*:*:network-acl/" + getPipeSplitField(requestBody, 17)
        ];

        reqParams.boto3['NetworkAclId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--network-acl-id'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteNetworkAcl',
                'boto3': 'delete_network_acl',
                'cli': 'delete-network-acl'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DeleteRouteTable
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "deleteRouteTable") {
        reqParams.iam['Resource'] = [
            "arn:aws:ec2:*:*:route-table/" + getPipeSplitField(requestBody, 17)
        ];

        reqParams.boto3['RouteTableId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--route-table-id'] = getPipeSplitField(requestBody, 17);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DeleteRouteTable',
                'boto3': 'delete_route_table',
                'cli': 'delete-route-table'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.DescribeSubnets\?/g)) {
        reqParams.boto3['Filters'] = jsonRequestBody.Filters;
        reqParams.cli['--filters'] = jsonRequestBody.Filters;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getSubnets") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // manual:ec2:ec2.CreateNetworkAclEntry
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && (gwtRequest['method'] == "modifyIngressRulesForNetworkACL" || gwtRequest['method'] == "modifyEgressRulesForNetworkACL")) {
        for (var i=0; i<gwtRequest.args[2].value.value.length; i++) {
            var reqParams = {
                'boto3': {},
                'go': {},
                'cfn': {},
                'cli': {},
                'tf': {},
                'iam': {}
            };

            reqParams.iam['Resource'] = [
                "*"
            ];
            
            if (gwtRequest['method'] == "modifyIngressRulesForNetworkACL") {
                reqParams.boto3['Egress'] = false;
                reqParams.cli['--ingress'] = null;
                reqParams.cfn['Egress'] = false;
                reqParams.tf['egress'] = false;
            } else {
                reqParams.boto3['Egress'] = true;
                reqParams.cli['--egress'] = null;
                reqParams.cfn['Egress'] = true;
                reqParams.tf['egress'] = true;
            }
            
            reqParams.boto3['NetworkAclId'] = gwtRequest.args[1].value;
            reqParams.cli['--network-acl-id'] = gwtRequest.args[1].value;
            reqParams.cfn['NetworkAclId'] = gwtRequest.args[1].value;
            reqParams.tf['network_acl_id'] = gwtRequest.args[1].value;
            
            reqParams.boto3['RuleNumber'] = gwtRequest.args[2].value.value[i].ruleId;
            reqParams.cli['--rule-number'] = gwtRequest.args[2].value.value[i].ruleId;
            reqParams.cfn['RuleNumber'] = gwtRequest.args[2].value.value[i].ruleId;
            reqParams.tf['rule_number'] = gwtRequest.args[2].value.value[i].ruleId;
            
            reqParams.boto3['Protocol'] = gwtRequest.args[2].value.value[i].protocol;
            reqParams.cli['--protocol'] = gwtRequest.args[2].value.value[i].protocol;
            reqParams.cfn['Protocol'] = gwtRequest.args[2].value.value[i].protocol;
            reqParams.tf['protocol'] = gwtRequest.args[2].value.value[i].protocol;
            
            if (gwtRequest.args[2].value.value[i].portStart > 0) { // don't set ICMP PortRange
                reqParams.boto3['PortRange'] = {
                    'From': gwtRequest.args[2].value.value[i].portStart,
                    'To': gwtRequest.args[2].value.value[i].portEnd
                };
                reqParams.cli['--port-range'] = {
                    'From': gwtRequest.args[2].value.value[i].portStart,
                    'To': gwtRequest.args[2].value.value[i].portEnd
                };
                reqParams.cfn['PortRange'] = {
                    'From': gwtRequest.args[2].value.value[i].portStart,
                    'To': gwtRequest.args[2].value.value[i].portEnd
                };
                reqParams.tf['from_port'] = gwtRequest.args[2].value.value[i].portStart;
                reqParams.tf['to_port'] = gwtRequest.args[2].value.value[i].portEnd;
            }
            
            reqParams.boto3['CidrBlock'] = gwtRequest.args[2].value.value[i].cidr.value[0].value;
            reqParams.cli['--cidr-block'] = gwtRequest.args[2].value.value[i].cidr.value[0].value;
            reqParams.cfn['CidrBlock'] = gwtRequest.args[2].value.value[i].cidr.value[0].value;
            reqParams.tf['cidr_block'] = gwtRequest.args[2].value.value[i].cidr.value[0].value;

            reqParams.boto3['RuleAction'] = gwtRequest.args[2].value.value[i].action;
            reqParams.cli['--rule-action'] = gwtRequest.args[2].value.value[i].action;
            reqParams.cfn['RuleAction'] = gwtRequest.args[2].value.value[i].action;
            reqParams.tf['rule_action'] = gwtRequest.args[2].value.value[i].action.toLowerCase();

            if (reqParams.boto3['RuleNumber'] != 32767) { // ignore default rule
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'CreateNetworkAclEntry',
                        'boto3': 'create_network_acl_entry',
                        'cli': 'create-network-acl-entry'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });

                tracked_resources.push({
                    'logicalId': getResourceName('ec2', details.requestId),
                    'region': region,
                    'service': 'ec2',
                    'type': 'AWS::EC2::NetworkAclEntry',
                    'terraformType': 'aws_network_acl_rule',
                    'options': reqParams,
                    'requestDetails': details,
                    'was_blocked': blocking
                });
            }
        }

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.AssociateDhcpOptions
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "modifyDHCPOptions") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = getPipeSplitField(requestBody, 17);
        reqParams.cli['--vpc-id'] = getPipeSplitField(requestBody, 17);
        reqParams.boto3['DhcpOptionsId'] = getPipeSplitField(requestBody, 18);
        reqParams.cli['--dhcp-options-id'] = getPipeSplitField(requestBody, 18);

        reqParams.cfn['VpcId'] = getPipeSplitField(requestBody, 17);
        reqParams.cfn['DhcpOptionsId'] = getPipeSplitField(requestBody, 18);

        reqParams.tf['vpc_id'] = getPipeSplitField(requestBody, 17);
        reqParams.tf['dhcp_options_id'] = getPipeSplitField(requestBody, 18);

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'AssociateDhcpOptions',
                'boto3': 'associate_dhcp_options',
                'cli': 'associate-dhcp-options'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::VPCDHCPOptionsAssociation',
            'terraformType': 'aws_vpc_dhcp_options_association',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:ec2.DescribeNatGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vpc\/VpcConsoleService$/g) && gwtRequest['method'] == "getNatGateways") {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeNatGateways',
                'boto3': 'describe_nat_gateways',
                'cli': 'describe-nat-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.AssociateVpcCidrBlock
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/vpc\/vcb\/elastic\/\?call=com\.amazonaws\.ec2\.AmazonEC2\.AssociateVpcCidrBlock\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['VpcId'] = jsonRequestBody.vpcId;
        reqParams.cli['--vpc-id'] = jsonRequestBody.vpcId;
        reqParams.boto3['CidrBlock'] = jsonRequestBody.cidrBlock;
        reqParams.cli['--cidr-block'] = jsonRequestBody.cidrBlock;
        reqParams.boto3['AmazonProvidedIpv6CidrBlock'] = jsonRequestBody.amazonProvidedIpv6CidrBlock;
        reqParams.cli['--amazon-provided-ipv6-cidr-block'] = jsonRequestBody.amazonProvidedIpv6CidrBlock;

        reqParams.cfn['VpcId'] = jsonRequestBody.vpcId;
        reqParams.cfn['CidrBlock'] = jsonRequestBody.cidrBlock;
        reqParams.cfn['AmazonProvidedIpv6CidrBlock'] = jsonRequestBody.amazonProvidedIpv6CidrBlock;

        reqParams.tf['vpc_id'] = jsonRequestBody.vpcId;
        reqParams.tf['cidr_block'] = jsonRequestBody.cidrBlock;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'AssociateVpcCidrBlock',
                'boto3': 'associate_vpc_cidr_block',
                'cli': 'associate-vpc-cidr-block'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::EC2::VPCCidrBlock',
            'terraformType': 'aws_vpc_ipv4_cidr_block_association',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elbv2.DescribeLoadBalancers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2GetLoadBalancers\?/g)) {

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeLoadBalancers',
                'boto3': 'describe_load_balancers',
                'cli': 'describe-load-balancers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeInternetGateways
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getInternetGateways\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeInternetGateways',
                'boto3': 'describe_internet_gateways',
                'cli': 'describe-internet-gateways'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeRouteTables
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getRouteTables\?/g)) {
        reqParams.boto3['Filters'] = jsonRequestBody.filters;
        reqParams.cli['--filters'] = jsonRequestBody.filters;

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeRouteTables',
                'boto3': 'describe_route_tables',
                'cli': 'describe-route-tables'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:acm.ListCertificates
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=listAcmCertificates\?/g)) {
        reqParams.boto3['CertificateStatuses'] = jsonRequestBody.CertificateStatusList;
        reqParams.cli['--certificate-statuses'] = jsonRequestBody.CertificateStatusList;

        outputs.push({
            'region': region,
            'service': 'acm',
            'method': {
                'api': 'ListCertificates',
                'boto3': 'list_certificates',
                'cli': 'list-certificates'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:iam.ListServerCertificates
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=listServerCertificates\?/g)) {

        outputs.push({
            'region': region,
            'service': 'iam',
            'method': {
                'api': 'ListServerCertificates',
                'boto3': 'list_server_certificates',
                'cli': 'list-server-certificates'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:elbv2.DescribeSSLPolicies
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DescribeSSLPolicies\?/g)) {

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeSSLPolicies',
                'boto3': 'describe_ssl_policies',
                'cli': 'describe-ssl-policies'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:elbv2.DescribeAccountLimits
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getAccountLimits\?/g)) {

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeAccountLimits',
                'boto3': 'describe_account_limits',
                'cli': 'describe-account-limits'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeInstances
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getMergedInstanceListAutoUpdate\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeInstances',
                'boto3': 'describe_instances',
                'cli': 'describe-instances'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:ec2.DescribeSecurityGroups
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getSecurityGroupsAutoUpdate\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSecurityGroups',
                'boto3': 'describe_security_groups',
                'cli': 'describe-security-groups'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:elbv2.CreateLoadBalancer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2CreateLoadBalancer\?/g)) {
        if (jsonRequestBody.type == "application") {
            reqParams.iam['Resource'] = [
                "arn:aws:elasticloadbalancing:*:*:loadbalancer/app/" + jsonRequestBody.name + "/*"
            ];
        } else if (jsonRequestBody.type == "network") {
            reqParams.iam['Resource'] = [
                "arn:aws:elasticloadbalancing:*:*:loadbalancer/net/" + jsonRequestBody.name + "/*"
            ];
        }

        reqParams.boto3['Name'] = jsonRequestBody.name;
        reqParams.cli['--name'] = jsonRequestBody.name;
        reqParams.boto3['Scheme'] = jsonRequestBody.scheme;
        reqParams.cli['--scheme'] = jsonRequestBody.scheme;
        reqParams.boto3['SecurityGroups'] = jsonRequestBody.securityGroups;
        reqParams.cli['--security-groups'] = jsonRequestBody.securityGroups;
        reqParams.boto3['Subnets'] = jsonRequestBody.subnets;
        reqParams.cli['--subnets'] = jsonRequestBody.subnets;
        reqParams.boto3['Tags'] = jsonRequestBody.tags;
        reqParams.cli['--tags'] = jsonRequestBody.tags;
        reqParams.boto3['IpAddressType'] = jsonRequestBody.ipAddressType;
        reqParams.cli['--ip-address-type'] = jsonRequestBody.ipAddressType;
        reqParams.boto3['Type'] = jsonRequestBody.type;
        reqParams.cli['--type'] = jsonRequestBody.type;

        reqParams.cfn['Name'] = jsonRequestBody.name;
        reqParams.cfn['Scheme'] = jsonRequestBody.scheme;
        reqParams.cfn['SecurityGroups'] = jsonRequestBody.securityGroups;
        reqParams.cfn['Subnets'] = jsonRequestBody.subnets;
        reqParams.cfn['Tags'] = jsonRequestBody.tags;
        reqParams.cfn['IpAddressType'] = jsonRequestBody.ipAddressType;
        reqParams.cfn['Type'] = jsonRequestBody.type;

        reqParams.tf['name'] = jsonRequestBody.name;
        reqParams.tf['internal'] = (jsonRequestBody.scheme == "internal");
        reqParams.tf['security_groups'] = jsonRequestBody.securityGroups;
        reqParams.tf['subnets'] = jsonRequestBody.subnets;
        reqParams.tf['tags'] = jsonRequestBody.tags;
        reqParams.tf['ip_address_type'] = jsonRequestBody.ipAddressType;
        reqParams.tf['load_balancer_type'] = jsonRequestBody.type;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'CreateLoadBalancer',
                'boto3': 'create_load_balancer',
                'cli': 'create-load-balancer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::ElasticLoadBalancingV2::LoadBalancer',
            'terraformType': 'aws_lb',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elbv2.CreateTargetGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2CreateTargetGroup\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticloadbalancing:*:*:targetgroup/" + jsonRequestBody.Name + "/*"
        ];

        reqParams.boto3['HealthCheckIntervalSeconds'] = jsonRequestBody.HealthCheckIntervalSeconds;
        reqParams.cli['--health-check-interval-seconds'] = jsonRequestBody.HealthCheckIntervalSeconds;
        reqParams.boto3['HealthCheckPath'] = jsonRequestBody.HealthCheckPath;
        reqParams.cli['--health-check-path'] = jsonRequestBody.HealthCheckPath;
        reqParams.boto3['HealthCheckProtocol'] = jsonRequestBody.HealthCheckProtocol;
        reqParams.cli['--health-check-protocol'] = jsonRequestBody.HealthCheckProtocol;
        reqParams.boto3['HealthCheckTimeoutSeconds'] = jsonRequestBody.HealthCheckTimeoutSeconds;
        reqParams.cli['--health-check-timeout-seconds'] = jsonRequestBody.HealthCheckTimeoutSeconds;
        reqParams.boto3['HealthyThresholdCount'] = jsonRequestBody.HealthyThresholdCount;
        reqParams.cli['--healthy-threshold-count'] = jsonRequestBody.HealthyThresholdCount;
        reqParams.boto3['Matcher'] = jsonRequestBody.Matcher;
        reqParams.cli['--matcher'] = jsonRequestBody.Matcher;
        reqParams.boto3['Name'] = jsonRequestBody.Name;
        reqParams.cli['--name'] = jsonRequestBody.Name;
        reqParams.boto3['Port'] = jsonRequestBody.Port;
        reqParams.cli['--port'] = jsonRequestBody.Port;
        reqParams.boto3['Protocol'] = jsonRequestBody.Protocol;
        reqParams.cli['--protocol'] = jsonRequestBody.Protocol;
        reqParams.boto3['TargetType'] = jsonRequestBody.targetType;
        reqParams.cli['--target-type'] = jsonRequestBody.targetType;
        reqParams.boto3['UnhealthyThresholdCount'] = jsonRequestBody.UnhealthyThresholdCount;
        reqParams.cli['--unhealthy-threshold-count'] = jsonRequestBody.UnhealthyThresholdCount;
        reqParams.boto3['VpcId'] = jsonRequestBody.VpcId;
        reqParams.cli['--vpc-id'] = jsonRequestBody.VpcId;

        reqParams.cfn['HealthCheckIntervalSeconds'] = jsonRequestBody.HealthCheckIntervalSeconds;
        reqParams.cfn['HealthCheckPath'] = jsonRequestBody.HealthCheckPath;
        reqParams.cfn['HealthCheckProtocol'] = jsonRequestBody.HealthCheckProtocol;
        reqParams.cfn['HealthCheckTimeoutSeconds'] = jsonRequestBody.HealthCheckTimeoutSeconds;
        reqParams.cfn['HealthyThresholdCount'] = jsonRequestBody.HealthyThresholdCount;
        reqParams.cfn['Matcher'] = jsonRequestBody.Matcher;
        reqParams.cfn['Name'] = jsonRequestBody.Name;
        reqParams.cfn['Port'] = jsonRequestBody.Port;
        reqParams.cfn['Protocol'] = jsonRequestBody.Protocol;
        reqParams.cfn['TargetType'] = jsonRequestBody.targetType;
        reqParams.cfn['UnhealthyThresholdCount'] = jsonRequestBody.UnhealthyThresholdCount;
        reqParams.cfn['VpcId'] = jsonRequestBody.VpcId;

        reqParams.tf['health_check'] = {
            'interval': jsonRequestBody.HealthCheckIntervalSeconds,
            'path': jsonRequestBody.HealthCheckPath,
            'protocol': jsonRequestBody.HealthCheckProtocol,
            'timeout': jsonRequestBody.HealthCheckTimeoutSeconds,
            'healthy_threshold': jsonRequestBody.HealthyThresholdCount,
            'unhealthy_threshold': jsonRequestBody.UnhealthyThresholdCount,
            'matcher': jsonRequestBody.Matcher
        };
        reqParams.tf['name'] = jsonRequestBody.Name;
        reqParams.tf['port'] = jsonRequestBody.Port;
        reqParams.tf['protocol'] = jsonRequestBody.Protocol;
        reqParams.tf['target_type'] = jsonRequestBody.targetType;
        reqParams.tf['vpc_id'] = jsonRequestBody.VpcId;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'CreateTargetGroup',
                'boto3': 'create_target_group',
                'cli': 'create-target-group'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::ElasticLoadBalancingV2::TargetGroup',
            'terraformType': 'aws_lb_target_group',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elbv2.CreateListener
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2CreateListener\?/g)) {
        reqParams.iam['Resource'] = [
            jsonRequestBody.loadBalancerArn
        ];

        reqParams.boto3['Port'] = jsonRequestBody.port;
        reqParams.cli['--port'] = jsonRequestBody.port;
        reqParams.boto3['Protocol'] = jsonRequestBody.protocol;
        reqParams.cli['--protocol'] = jsonRequestBody.protocol;
        reqParams.boto3['LoadBalancerArn'] = jsonRequestBody.loadBalancerArn;
        reqParams.cli['--load-balancer-arn'] = jsonRequestBody.loadBalancerArn;
        reqParams.boto3['DefaultActions'] = jsonRequestBody.defaultActions;
        reqParams.cli['--default-actions'] = jsonRequestBody.defaultActions;

        reqParams.cfn['Port'] = jsonRequestBody.port;
        reqParams.cfn['Protocol'] = jsonRequestBody.protocol;
        reqParams.cfn['LoadBalancerArn'] = jsonRequestBody.loadBalancerArn;

        reqParams.tf['port'] = jsonRequestBody.port;
        reqParams.tf['protocol'] = jsonRequestBody.protocol;
        reqParams.tf['load_balancer_arn'] = jsonRequestBody.loadBalancerArn;
        reqParams.tf['DefaultActions'] = [];
        for (var i=0; i<jsonRequestBody.defaultActions.length; i++) {
            reqParams.cfn['DefaultActions'].push({
                'TargetGroupArn': jsonRequestBody.defaultActions[i].targetGroupArn,
                'Type': jsonRequestBody.defaultActions[i].type
            });
            reqParams.tf['default_action'].push({
                'target_group_arn': jsonRequestBody.defaultActions[i].targetGroupArn,
                'type': jsonRequestBody.defaultActions[i].type
            });
        }

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'CreateListener',
                'boto3': 'create_listener',
                'cli': 'create-listener'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::ElasticLoadBalancingV2::Listener',
            'terraformType': 'aws_lb_listener',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elbv2.DescribeLoadBalancers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2GetLoadBalancers\?/g)) {

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeLoadBalancers',
                'boto3': 'describe_load_balancers',
                'cli': 'describe-load-balancers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:elbv2.DescribeLoadBalancerAttributes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DescribeLoadBalancerAttributes\?/g)) {
        reqParams.boto3['LoadBalancerArn'] = jsonRequestBody.loadBalancerArn;
        reqParams.cli['--load-balancer-arn'] = jsonRequestBody.loadBalancerArn;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeLoadBalancerAttributes',
                'boto3': 'describe_load_balancer_attributes',
                'cli': 'describe-load-balancer-attributes'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:config.DescribeConfigurationRecorders
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=describeConfigurationRecorders\?/g)) {

        outputs.push({
            'region': region,
            'service': 'config',
            'method': {
                'api': 'DescribeConfigurationRecorders',
                'boto3': 'describe_configuration_recorders',
                'cli': 'describe-configuration-recorders'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:waf-regional.GetWebACLForResource
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=getWebACLForResource\?/g)) {
        reqParams.boto3['ResourceArn'] = jsonRequestBody.resourceArn;
        reqParams.cli['--resource-arn'] = jsonRequestBody.resourceArn;

        outputs.push({
            'region': region,
            'service': 'waf-regional',
            'method': {
                'api': 'GetWebACLForResource',
                'boto3': 'get_web_acl_for_resource',
                'cli': 'get-web-acl-for-resource'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:elbv2.DescribeRules
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DescribeRules\?/g)) {
        reqParams.boto3['ListenerArn'] = jsonRequestBody.listenerArn;
        reqParams.cli['--listener-arn'] = jsonRequestBody.listenerArn;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeRules',
                'boto3': 'describe_rules',
                'cli': 'describe-rules'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:elbv2.DescribeListeners
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DescribeListeners\?/g)) {
        reqParams.boto3['LoadBalancerArn'] = jsonRequestBody.loadBalancerArn;
        reqParams.cli['--load-balancer-arn'] = jsonRequestBody.loadBalancerArn;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DescribeListeners',
                'boto3': 'describe_listeners',
                'cli': 'describe-listeners'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:ec2:elbv2.CreateRule
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2CreateRule\?/g)) {
        reqParams.iam['Resource'] = [
            jsonRequestBody.listenerArn
        ];

        reqParams.boto3['ListenerArn'] = jsonRequestBody.listenerArn;
        reqParams.cli['--listener-arn'] = jsonRequestBody.listenerArn;
        reqParams.boto3['Conditions'] = jsonRequestBody.conditions;
        reqParams.cli['--conditions'] = jsonRequestBody.conditions;
        reqParams.boto3['Actions'] = jsonRequestBody.actions;
        reqParams.cli['--actions'] = jsonRequestBody.actions;

        reqParams.cfn['ListenerArn'] = jsonRequestBody.listenerArn;
        reqParams.cfn['Conditions'] = jsonRequestBody.conditions;
        reqParams.cfn['Actions'] = jsonRequestBody.actions;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'CreateRule',
                'boto3': 'create_rule',
                'cli': 'create-rule'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::ElasticLoadBalancingV2::ListenerRule',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elbv2.DeleteRule
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DeleteRule\?/g)) {
        reqParams.iam['Resource'] = [
            jsonRequestBody.ruleArn
        ];

        reqParams.boto3['RuleArn'] = jsonRequestBody.ruleArn;
        reqParams.cli['--rule-arn'] = jsonRequestBody.ruleArn;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DeleteRule',
                'boto3': 'delete_rule',
                'cli': 'delete-rule'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elbv2.DeleteListener
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DeleteListener\?/g)) {
        reqParams.iam['Resource'] = [
            jsonRequestBody.listenerArn
        ];

        reqParams.boto3['ListenerArn'] = jsonRequestBody.listenerArn;
        reqParams.cli['--listener-arn'] = jsonRequestBody.listenerArn;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DeleteListener',
                'boto3': 'delete_listener',
                'cli': 'delete-listener'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elbv2.DeleteLoadBalancer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DeleteLoadBalancer\?/g)) {
        reqParams.iam['Resource'] = [
            jsonRequestBody.loadBalancerArn
        ];

        reqParams.boto3['LoadBalancerArn'] = jsonRequestBody.loadBalancerArn;
        reqParams.cli['--load-balancer-arn'] = jsonRequestBody.loadBalancerArn;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DeleteLoadBalancer',
                'boto3': 'delete_load_balancer',
                'cli': 'delete-load-balancer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elbv2.DeleteTargetGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=elbV2DeleteTargetGroup\?/g)) {
        reqParams.iam['Resource'] = [
            jsonRequestBody.targetGroupArn
        ];

        reqParams.boto3['TargetGroupArn'] = jsonRequestBody.targetGroupArn;
        reqParams.cli['--target-group-arn'] = jsonRequestBody.targetGroupArn;

        outputs.push({
            'region': region,
            'service': 'elbv2',
            'method': {
                'api': 'DeleteTargetGroup',
                'boto3': 'delete_target_group',
                'cli': 'delete-target-group'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elb.CreateLoadBalancer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=createLoadBalancer\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticloadbalancing:*:*:loadbalancer/" + jsonRequestBody.loadBalancerName
        ];

        reqParams.boto3['LoadBalancerName'] = jsonRequestBody.loadBalancerName;
        reqParams.cli['--load-balancer-name'] = jsonRequestBody.loadBalancerName;
        reqParams.boto3['Scheme'] = jsonRequestBody.scheme;
        reqParams.cli['--scheme'] = jsonRequestBody.scheme;
        reqParams.boto3['Tags'] = jsonRequestBody.tags;
        reqParams.cli['--tags'] = jsonRequestBody.tags;
        reqParams.boto3['Listeners'] = jsonRequestBody.listeners;
        reqParams.cli['--listeners'] = jsonRequestBody.listeners;
        reqParams.boto3['SecurityGroups'] = jsonRequestBody.securityGroups;
        reqParams.cli['--security-groups'] = jsonRequestBody.securityGroups;
        reqParams.boto3['Subnets'] = jsonRequestBody.subnets;
        reqParams.cli['--subnets'] = jsonRequestBody.subnets;

        reqParams.cfn['LoadBalancerName'] = jsonRequestBody.loadBalancerName;
        reqParams.cfn['Scheme'] = jsonRequestBody.scheme;
        reqParams.cfn['Tags'] = jsonRequestBody.tags;
        reqParams.cfn['Listeners'] = jsonRequestBody.listeners;
        reqParams.cfn['SecurityGroups'] = jsonRequestBody.securityGroups;
        reqParams.cfn['Subnets'] = jsonRequestBody.subnets;

        outputs.push({
            'region': region,
            'service': 'elb',
            'method': {
                'api': 'CreateLoadBalancer',
                'boto3': 'create_load_balancer',
                'cli': 'create-load-balancer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('ec2', details.requestId),
            'region': region,
            'service': 'ec2',
            'type': 'AWS::ElasticLoadBalancing::LoadBalancer',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elb.ConfigureHealthCheck
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=configureHealthCheck\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticloadbalancing:*:*:loadbalancer/" + jsonRequestBody.loadBalancerName
        ];

        reqParams.boto3['HealthCheck'] = jsonRequestBody.healthCheck;
        reqParams.cli['--health-check'] = jsonRequestBody.healthCheck;
        reqParams.boto3['LoadBalancerName'] = jsonRequestBody.loadBalancerName;
        reqParams.cli['--load-balancer-name'] = jsonRequestBody.loadBalancerName;

        outputs.push({
            'region': region,
            'service': 'elb',
            'method': {
                'api': 'ConfigureHealthCheck',
                'boto3': 'configure_health_check',
                'cli': 'configure-health-check'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elb.ModifyLoadBalancerAttributes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=modifyLoadBalancerAttributes\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticloadbalancing:*:*:loadbalancer/" + jsonRequestBody.loadBalancerName
        ];

        reqParams.boto3['LoadBalancerName'] = jsonRequestBody.loadBalancerName;
        reqParams.cli['--load-balancer-name'] = jsonRequestBody.loadBalancerName;
        var attributes = {};
        if (jsonRequestBody.crossZone) {
            attributes['CrossZoneLoadBalancing'] = {
                'Enabled': jsonRequestBody.crossZone
            };
        }
        if (jsonRequestBody.connectionDraining) {
            attributes['ConnectionDraining'] = {
                'Enabled': jsonRequestBody.connectionDraining.enabled,
                'Timeout': jsonRequestBody.connectionDraining.timeout
            }
        }
        
        reqParams.boto3['LoadBalancerAttributes'] = attributes;
        reqParams.cli['--load-balancer-attributes'] = attributes;

        outputs.push({
            'region': region,
            'service': 'elb',
            'method': {
                'api': 'ModifyLoadBalancerAttributes',
                'boto3': 'modify_load_balancer_attributes',
                'cli': 'modify-load-balancer-attributes'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // manual:cloudwatch:logs.CreateLogGroup
    // manual:cloudwatch:logs.CreateLogStream
    // manual:cloudwatch:logs.PutMetricFilter
    // manual:cloudwatch:logs.PutSubscriptionFilter
    // manual:cloudwatch:cloudwatch.PutMetricAlarm
    // manual:cloudwatch:cloudwatch.DeleteAlarms
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/cloudwatch\/CloudWatch\//g)) {
        if (jsonRequestBody.I && jsonRequestBody.I[0] && jsonRequestBody.I[0]["O"] && jsonRequestBody.I[0]["O"] == "wuLyBG8jCdQ61w9bK2g4kaSdI4Q") {
            reqParams.iam['Resource'] = [
                "*"
            ];

            reqParams.boto3['logGroupName'] = jsonRequestBody.I[0]["P"][0];
            reqParams.cli['--log-group-name'] = jsonRequestBody.I[0]["P"][0];

            reqParams.cfn['LogGroupName'] = jsonRequestBody.I[0]["P"][0];

            reqParams.tf['name'] = jsonRequestBody.I[0]["P"][0];

            outputs.push({
                'region': region,
                'service': 'logs',
                'method': {
                    'api': 'CreateLogGroup',
                    'boto3': 'create_log_group',
                    'cli': 'create-log-group'
                },
                'options': reqParams,
                'requestDetails': details
            });

            tracked_resources.push({
                'logicalId': getResourceName('logs', details.requestId),
                'region': region,
                'service': 'logs',
                'type': 'AWS::Logs::LogGroup',
                'terraformType': 'aws_cloudwatch_log_group',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });

            if (blocking) {
                notifyBlocked();
                return {cancel: true};
            }
        } else if (jsonRequestBody.I && jsonRequestBody.I[0] && jsonRequestBody.I[0]["O"] && jsonRequestBody.I[0]["O"] == "bDg0Lbt_pKcqOJ8vSNZWGQW7Rfk=") {
            reqParams.iam['Resource'] = [
                "arn:aws:logs:*:*:log-group:" + jsonRequestBody.I[0]["P"][0]
            ];

            reqParams.boto3['logGroupName'] = jsonRequestBody.I[0]["P"][0];
            reqParams.cli['--log-group-name'] = jsonRequestBody.I[0]["P"][0];
            reqParams.boto3['logStreamName'] = jsonRequestBody.I[0]["P"][1];
            reqParams.cli['--log-stream-name'] = jsonRequestBody.I[0]["P"][1];

            reqParams.cfn['LogGroupName'] = jsonRequestBody.I[0]["P"][0];
            reqParams.cfn['LogStreamName'] = jsonRequestBody.I[0]["P"][1];

            reqParams.tf['log_group_name'] = jsonRequestBody.I[0]["P"][0];
            reqParams.tf['name'] = jsonRequestBody.I[0]["P"][1];
    
            outputs.push({
                'region': region,
                'service': 'logs',
                'method': {
                    'api': 'CreateLogStream',
                    'boto3': 'create_log_stream',
                    'cli': 'create-log-stream'
                },
                'options': reqParams,
                'requestDetails': details
            });

            tracked_resources.push({
                'logicalId': getResourceName('logs', details.requestId),
                'region': region,
                'service': 'logs',
                'type': 'AWS::Logs::LogStream',
                'terraformType': 'aws_cloudwatch_log_stream',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });

            if (blocking) {
                notifyBlocked();
                return {cancel: true};
            }
        } else if (jsonRequestBody.I && jsonRequestBody.I[0] && jsonRequestBody.I[0]["O"] && jsonRequestBody.I[0]["O"] == "w3zy8wcdTk4$qD2iBc81AziNanc=") {
            reqParams.iam['Resource'] = [
                "arn:aws:logs:*:*:log-group:" + jsonRequestBody.I[0]["P"][0]
            ];

            reqParams.boto3['logGroupName'] = jsonRequestBody.I[0]["P"][0];
            reqParams.cli['--log-group-name'] = jsonRequestBody.I[0]["P"][0];
            reqParams.boto3['filterName'] = jsonRequestBody.I[0]["P"][1];
            reqParams.cli['--filter-name'] = jsonRequestBody.I[0]["P"][1];
            reqParams.boto3['filterPattern'] = jsonRequestBody.I[0]["P"][2];
            reqParams.cli['--filter-pattern'] = jsonRequestBody.I[0]["P"][2];
            reqParams.boto3['metricTransformations'] = jsonRequestBody.O[0]["P"];
            reqParams.cli['--metric-transformations'] = jsonRequestBody.O[0]["P"];

            reqParams.cfn['LogGroupName'] = jsonRequestBody.I[0]["P"][0];
            reqParams.cfn['FilterPattern'] = jsonRequestBody.I[0]["P"][2];
            reqParams.cfn['MetricTransformations'] = jsonRequestBody.O[0]["P"];
    
            outputs.push({
                'region': region,
                'service': 'logs',
                'method': {
                    'api': 'PutMetricFilter',
                    'boto3': 'put_metric_filter',
                    'cli': 'put-metric-filter'
                },
                'options': reqParams,
                'requestDetails': details
            });

            tracked_resources.push({
                'logicalId': getResourceName('logs', details.requestId),
                'region': region,
                'service': 'logs',
                'type': 'AWS::Logs::MetricFilter',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });

            if (blocking) {
                notifyBlocked();
                return {cancel: true};
            }
        } else if (jsonRequestBody.I && jsonRequestBody.I[0] && jsonRequestBody.I[0]["O"] && jsonRequestBody.I[0]["O"] == "lRd9M18y9YlzeZbi97CtbWseYDE=") {
            reqParams.iam['Resource'] = [
                "arn:aws:logs:*:*:log-group:" + jsonRequestBody.I[0]["P"][0]
            ];

            reqParams.boto3['destinationArn'] = jsonRequestBody.O[0]["P"]["destinationArn"];
            reqParams.cli['--destination-arn'] = jsonRequestBody.O[0]["P"]["destinationArn"];
            reqParams.boto3['filterName'] = jsonRequestBody.O[0]["P"]["filterName"];
            reqParams.cli['--filter-name'] = jsonRequestBody.O[0]["P"]["filterName"];
            reqParams.boto3['filterPattern'] = jsonRequestBody.O[0]["P"]["filterPattern"];
            reqParams.cli['--filter-pattern'] = jsonRequestBody.O[0]["P"]["filterPattern"];
            reqParams.boto3['logGroupName'] = jsonRequestBody.O[0]["P"]["logGroupName"];
            reqParams.cli['--log-group-name'] = jsonRequestBody.O[0]["P"]["logGroupName"];
            reqParams.boto3['roleArn'] = jsonRequestBody.O[0]["P"]["roleArn"];
            reqParams.cli['--role-arn'] = jsonRequestBody.O[0]["P"]["roleArn"];

            reqParams.cfn['DestinationArn'] = jsonRequestBody.O[0]["P"]["destinationArn"];
            reqParams.cfn['FilterPattern'] = jsonRequestBody.O[0]["P"]["filterPattern"];
            reqParams.cfn['LogGroupName'] = jsonRequestBody.O[0]["P"]["logGroupName"];
            reqParams.cfn['RoleArn'] = jsonRequestBody.O[0]["P"]["roleArn"];

            reqParams.tf['destination_arn'] = jsonRequestBody.O[0]["P"]["destinationArn"];
            reqParams.tf['name'] = jsonRequestBody.O[0]["P"]["filterName"];
            reqParams.tf['filter_pattern'] = jsonRequestBody.O[0]["P"]["filterPattern"];
            reqParams.tf['log_group_name'] = jsonRequestBody.O[0]["P"]["logGroupName"];
            reqParams.tf['role_arn'] = jsonRequestBody.O[0]["P"]["roleArn"];
    
            outputs.push({
                'region': region,
                'service': 'logs',
                'method': {
                    'api': 'PutSubscriptionFilter',
                    'boto3': 'put_subscription_filter',
                    'cli': 'put-subscription-filter'
                },
                'options': reqParams,
                'requestDetails': details
            });

            tracked_resources.push({
                'logicalId': getResourceName('logs', details.requestId),
                'region': region,
                'service': 'logs',
                'type': 'AWS::Logs::SubscriptionFilter',
                'terraformType': 'aws_cloudwatch_log_subscription_filter',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });

            if (blocking) {
                notifyBlocked();
                return {cancel: true};
            }
        } else if (jsonRequestBody.I && jsonRequestBody.I[0] && jsonRequestBody.I[0]["O"] && jsonRequestBody.I[0]["O"] == "iSih$I64mhIIcyhlGUibH6SRuW0=") {
            reqParams.iam['Resource'] = [
                "*"
            ];

            var valmap = {};
            for (var i=0; i<jsonRequestBody['O'].length; i++) {
                valmap[jsonRequestBody['O'][i]['C']] = jsonRequestBody['O'][i]['P'];
            }
            var rootindex = jsonRequestBody['I'][0]['P'][0]['C'];

            reqParams.boto3['OKActions'] = valmap[rootindex]['OKActions'];
            reqParams.cli['--ok-actions'] = valmap[rootindex]['OKActions'];
            reqParams.boto3['ActionsEnabled'] = valmap[rootindex]['actionsEnabled'];
            reqParams.cli['--actions-enabled'] = valmap[rootindex]['actionsEnabled'];
            reqParams.boto3['AlarmActions'] = valmap[rootindex]['alarmActions'];
            reqParams.cli['--alarm-actions'] = valmap[rootindex]['alarmActions'];
            reqParams.boto3['AlarmDescription'] = valmap[rootindex]['alarmDescription'];
            reqParams.cli['--alarm-description'] = valmap[rootindex]['alarmDescription'];
            reqParams.boto3['AlarmName'] = valmap[rootindex]['alarmName'];
            reqParams.cli['--alarm-name'] = valmap[rootindex]['alarmName'];
            reqParams.boto3['ComparisonOperator'] = valmap[rootindex]['comparisonOperator'];
            reqParams.cli['--comparison-operator'] = valmap[rootindex]['comparisonOperator'];
            reqParams.boto3['DatapointsToAlarm'] = valmap[rootindex]['datapointsToAlarm'];
            reqParams.cli['--datapoints-to-alarm'] = valmap[rootindex]['datapointsToAlarm'];
            reqParams.boto3['EvaluateLowSampleCountPercentile'] = valmap[rootindex]['evaluateLowSampleCountPercentile'];
            reqParams.cli['--evaluate-low-sample-count-percentile'] = valmap[rootindex]['evaluateLowSampleCountPercentile'];
            reqParams.boto3['EvaluationPeriods'] = valmap[rootindex]['evaluationPeriods'];
            reqParams.cli['--evaluation-periods'] = valmap[rootindex]['evaluationPeriods'];
            reqParams.boto3['InsufficientDataActions'] = valmap[rootindex]['insufficientDataActions'];
            reqParams.cli['--insufficient-data-actions'] = valmap[rootindex]['insufficientDataActions'];
            reqParams.boto3['MetricName'] = valmap[rootindex]['metricName'];
            reqParams.cli['--metric-name'] = valmap[rootindex]['metricName'];
            reqParams.boto3['Namespace'] = valmap[rootindex]['namespace'];
            reqParams.cli['--namespace'] = valmap[rootindex]['namespace'];
            reqParams.boto3['Period'] = valmap[rootindex]['period'];
            reqParams.cli['--period'] = valmap[rootindex]['period'];
            reqParams.boto3['Statistic'] = valmap[rootindex]['statistic'];
            reqParams.cli['--statistic'] = valmap[rootindex]['statistic'];
            reqParams.boto3['Threshold'] = valmap[rootindex]['threshold'];
            reqParams.cli['--threshold'] = valmap[rootindex]['threshold'];
            reqParams.boto3['TreatMissingData'] = valmap[rootindex]['treatMissingData'];
            reqParams.cli['--treat-missing-data'] = valmap[rootindex]['treatMissingData'];
            reqParams.boto3['Unit'] = valmap[rootindex]['unit'];
            reqParams.cli['--unit'] = valmap[rootindex]['unit'];

            if (valmap[rootindex]['metrics'] && valmap[rootindex]['metrics'].length) {
                var metrics = [];

                for (var i=0; i<valmap[rootindex]['metrics'].length; i++) {
                    var metricindex = valmap[rootindex]['metrics'][i]['C'];

                    var metricstat = null;
                    if (valmap[metricindex]['stat']) {
                        var dimensions = null;
                        if (valmap[metricindex]['dimensions'] && valmap[metricindex]['dimensions'].length) {
                            dimensions = [];

                            for (var j=0; j<valmap[metricindex]['dimensions'].length; j++) {
                                var dimensionindex = valmap[metricindex]['dimensions'][j]['C'];
                                
                                dimensions.push({
                                    'Name': valmap[dimensionindex]['name'],
                                    'Value': valmap[dimensionindex]['value']
                                });
                            }
                        }

                        metricstat = {
                            'Metric': {
                                'Namespace': valmap[metricindex]['namespace'],
                                'MetricName': valmap[metricindex]['metricName'],
                                'Dimensions': dimensions
                            },
                            'Period': valmap[metricindex]['period'],
                            'Stat': valmap[metricindex]['stat'],
                            'Unit': valmap[metricindex]['unit']
                        };
                    }
                    
                    metrics.push({
                        'Id': valmap[metricindex]['alias'],
                        'MetricStat': metricstat,
                        'Expression': valmap[metricindex]['expression'],
                        'Label': valmap[metricindex]['label'],
                        'ReturnData': valmap[metricindex]['returnData']
                    });
                }

                reqParams.boto3['Metrics'] = metrics;
                reqParams.cli['--metrics'] = metrics;
                reqParams.cfn['Metrics'] = metrics;
            }

            if (valmap[rootindex]['dimensions'] && valmap[rootindex]['dimensions'].length) {
                var dimensions = [];
                var tf_dimensions = {};

                for (var i=0; i<valmap[rootindex]['dimensions'].length; i++) {
                    var dimensionindex = valmap[rootindex]['dimensions'][i]['C'];
                    
                    dimensions.push({
                        'Name': valmap[dimensionindex]['name'],
                        'Value': valmap[dimensionindex]['value']
                    });

                    tf_dimensions[valmap[dimensionindex]['name']] = valmap[dimensionindex]['value'];
                }

                reqParams.boto3['Dimensions'] = dimensions;
                reqParams.cli['--dimensions'] = dimensions;
                reqParams.cfn['Dimensions'] = dimensions;
                reqParams.tf['dimensions'] = tf_dimensions;
            }

            reqParams.cfn['OKActions'] = valmap[rootindex]['OKActions'];
            reqParams.cfn['ActionsEnabled'] = valmap[rootindex]['actionsEnabled'];
            reqParams.cfn['AlarmActions'] = valmap[rootindex]['alarmActions'];
            reqParams.cfn['AlarmDescription'] = valmap[rootindex]['alarmDescription'];
            reqParams.cfn['AlarmName'] = valmap[rootindex]['alarmName'];
            reqParams.cfn['ComparisonOperator'] = valmap[rootindex]['comparisonOperator'];
            reqParams.cfn['DatapointsToAlarm'] = valmap[rootindex]['datapointsToAlarm'];
            reqParams.cfn['EvaluateLowSampleCountPercentile'] = valmap[rootindex]['evaluateLowSampleCountPercentile'];
            reqParams.cfn['EvaluationPeriods'] = valmap[rootindex]['evaluationPeriods'];
            reqParams.cfn['InsufficientDataActions'] = valmap[rootindex]['insufficientDataActions'];
            reqParams.cfn['MetricName'] = valmap[rootindex]['metricName'];
            reqParams.cfn['Namespace'] = valmap[rootindex]['namespace'];
            reqParams.cfn['Period'] = valmap[rootindex]['period'];
            reqParams.cfn['Statistic'] = valmap[rootindex]['statistic'];
            reqParams.cfn['Threshold'] = valmap[rootindex]['threshold'];
            reqParams.cfn['TreatMissingData'] = valmap[rootindex]['treatMissingData'];
            reqParams.cfn['Unit'] = valmap[rootindex]['unit'];

            reqParams.tf['ok_actions'] = valmap[rootindex]['OKActions'];
            reqParams.tf['actions_enabled'] = valmap[rootindex]['actionsEnabled'];
            reqParams.tf['alarm_actions'] = valmap[rootindex]['alarmActions'];
            reqParams.tf['alarm_description'] = valmap[rootindex]['alarmDescription'];
            reqParams.tf['alarm_name'] = valmap[rootindex]['alarmName'];
            reqParams.tf['comparison_operator'] = valmap[rootindex]['comparisonOperator'];
            reqParams.tf['datapoints_to_alarm'] = valmap[rootindex]['datapointsToAlarm'];
            reqParams.tf['evaluate_low_sample_count_percentiles'] = valmap[rootindex]['evaluateLowSampleCountPercentile'];
            reqParams.tf['evaluation_periods'] = valmap[rootindex]['evaluationPeriods'];
            reqParams.tf['insufficient_data_actions'] = valmap[rootindex]['insufficientDataActions'];
            reqParams.tf['metric_name'] = valmap[rootindex]['metricName'];
            reqParams.tf['namespace'] = valmap[rootindex]['namespace'];
            reqParams.tf['period'] = valmap[rootindex]['period'];
            reqParams.tf['statistic'] = valmap[rootindex]['statistic'];
            reqParams.tf['threshold'] = valmap[rootindex]['threshold'];
            reqParams.tf['treat_missing_data'] = valmap[rootindex]['treatMissingData'];
            reqParams.tf['unit'] = valmap[rootindex]['unit'];

            outputs.push({
                'region': region,
                'service': 'cloudwatch',
                'method': {
                    'api': 'PutMetricAlarm',
                    'boto3': 'put_metric_alarm',
                    'cli': 'put-metric-alarm'
                },
                'options': reqParams,
                'requestDetails': details
            });

            tracked_resources.push({
                'logicalId': getResourceName('cloudwatch', details.requestId),
                'region': region,
                'service': 'cloudwatch',
                'type': 'AWS::CloudWatch::Alarm',
                'terraformType': 'aws_cloudwatch_metric_alarm',
                'options': reqParams,
                'requestDetails': details,
                'was_blocked': blocking
            });

            if (blocking) {
                notifyBlocked();
                return {cancel: true};
            }
        } else if (jsonRequestBody.I && jsonRequestBody.I[0] && jsonRequestBody.I[0]["O"] && jsonRequestBody.I[0]["O"] == "zRQgdkyFzweXA2nKjontGSE28Mw=") {
            reqParams.iam['Resource'] = [
                "*"
            ];

            reqParams.boto3['AlarmNames'] = jsonRequestBody['I'][0]['P'][0];
            reqParams.cli['--alarm-names'] = jsonRequestBody['I'][0]['P'][0];

            outputs.push({
                'region': region,
                'service': 'cloudwatch',
                'method': {
                    'api': 'DeleteAlarms',
                    'boto3': 'delete_alarms',
                    'cli': 'delete-alarms'
                },
                'options': reqParams,
                'requestDetails': details
            });
        }
        
        return {};
    }

    // autogen:sqs:sqs.CreateQueue
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sqs\/sqsconsole\/AmazonSQS$/g) && gwtRequest['method'] == "createQueue") {
        reqParams.iam['Resource'] = [
            "arn:aws:sqs:*:*:" + gwtRequest.args[0].value
        ];

        reqParams.boto3['QueueName'] = gwtRequest.args[0].value;
        reqParams.cli['--queue-name'] = gwtRequest.args[0].value;

        reqParams.cfn['QueueName'] = gwtRequest.args[0].value;

        reqParams.tf['name'] = gwtRequest.args[0].value;

        outputs.push({
            'region': region,
            'service': 'sqs',
            'method': {
                'api': 'CreateQueue',
                'boto3': 'create_queue',
                'cli': 'create-queue'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('sqs', details.requestId),
            'region': region,
            'service': 'sqs',
            'type': 'AWS::SQS::Queue',
            'terraformType': 'aws_sqs_queue',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:sqs:sqs.GetQueueAttributes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sqs\/sqsconsole\/AmazonSQS$/g) && gwtRequest['method'] == "getQueueAttributes") {
        reqParams.boto3['QueueUrl'] = getPipeSplitField(requestBody, 11);
        reqParams.cli['--queue-url'] = getPipeSplitField(requestBody, 11);
        reqParams.boto3['AttributeNames'] = getPipeSplitField(requestBody, 14);
        reqParams.cli['--attribute-names'] = getPipeSplitField(requestBody, 14);

        outputs.push({
            'region': region,
            'service': 'sqs',
            'method': {
                'api': 'GetQueueAttributes',
                'boto3': 'get_queue_attributes',
                'cli': 'get-queue-attributes'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:sqs:sqs.SetQueueAttributes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sqs\/sqsconsole\/AmazonSQS$/g) && gwtRequest['method'] == "setQueueAttributes" && getPipeSplitField(requestBody, 13) == "Policy") {
        reqParams.iam['Resource'] = [
            "arn:aws:sqs:*:*:" + getPipeSplitField(requestBody, 11).split("/").pop()
        ];

        reqParams.boto3['QueueUrl'] = getPipeSplitField(requestBody, 11);
        reqParams.cli['--queue-url'] = getPipeSplitField(requestBody, 11);
        reqParams.boto3['Attributes'] = {
            'Policy': getPipeSplitField(requestBody, 14)
        };
        reqParams.cli['--attributes'] = {
            'Policy': getPipeSplitField(requestBody, 14)
        };

        reqParams.cfn['Queues'] = [getPipeSplitField(requestBody, 11)];
        reqParams.cfn['PolicyDocument'] = getPipeSplitField(requestBody, 14);

        reqParams.tf['queue_url'] = getPipeSplitField(requestBody, 11);
        reqParams.tf['policy'] = getPipeSplitField(requestBody, 14);

        outputs.push({
            'region': region,
            'service': 'sqs',
            'method': {
                'api': 'SetQueueAttributes',
                'boto3': 'set_queue_attributes',
                'cli': 'set-queue-attributes'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('sqs', details.requestId),
            'region': region,
            'service': 'sqs',
            'type': 'AWS::SQS::QueuePolicy',
            'terraformType': 'aws_sqs_queue_policy',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:sqs:sqs.DeleteQueue
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/sqs\/sqsconsole\/AmazonSQS$/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:sqs:*:*:" + getPipeSplitField(requestBody, 10).split("/").pop()
        ];

        reqParams.boto3['QueueUrl'] = getPipeSplitField(requestBody, 10);
        reqParams.cli['--queue-url'] = getPipeSplitField(requestBody, 10);

        outputs.push({
            'region': region,
            'service': 'sqs',
            'method': {
                'api': 'DeleteQueue',
                'boto3': 'delete_queue',
                'cli': 'delete-queue'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:route53:route53.GetHostedZoneCount
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/route53\/route53console\/route53$/g) && gwtRequest['method'] == "getHostedZoneCount") {

        outputs.push({
            'region': region,
            'service': 'route53',
            'method': {
                'api': 'GetHostedZoneCount',
                'boto3': 'get_hosted_zone_count',
                'cli': 'get-hosted-zone-count'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:route53:route53.ListHostedZones
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/route53\/route53console\/route53$/g) && gwtRequest['method'] == "listHostedZones") {
        reqParams.boto3['MaxItems'] = getPipeSplitField(requestBody, 10);
        reqParams.cli['--max-items'] = getPipeSplitField(requestBody, 10);

        outputs.push({
            'region': region,
            'service': 'route53',
            'method': {
                'api': 'ListHostedZones',
                'boto3': 'list_hosted_zones',
                'cli': 'list-hosted-zones'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:route53:route53.CreateHostedZone
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/route53\/route53console\/route53$/g) && gwtRequest['method'] == "createPrivateHostedZone") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Name'] = getPipeSplitField(requestBody, 11);
        reqParams.cli['--name'] = getPipeSplitField(requestBody, 11);
        reqParams.boto3['HostedZoneConfig'] = {
            'Comment': getPipeSplitField(requestBody, 12)
        };
        reqParams.cli['--hosted-zone-config'] = {
            'Comment': getPipeSplitField(requestBody, 12)
        };
        if (getPipeSplitField(requestBody, 15)) {
            reqParams.boto3['VPC'] = getPipeSplitField(requestBody, 15);
            reqParams.cli['--vpc'] = getPipeSplitField(requestBody, 15);
        }
        reqParams.boto3['CallerReference'] = getPipeSplitField(requestBody, 16);
        reqParams.cli['--caller-reference'] = getPipeSplitField(requestBody, 16);

        reqParams.cfn['Name'] = getPipeSplitField(requestBody, 11);
        reqParams.cfn['HostedZoneConfig'] = {
            'Comment': getPipeSplitField(requestBody, 12)
        };
        if (getPipeSplitField(requestBody, 15)) {
            reqParams.cfn['VPCs'] = [{
                'VPCId': getPipeSplitField(requestBody, 15),
                'VPCRegion': getPipeSplitField(requestBody, 17)
            }];
        }

        reqParams.tf['name'] = getPipeSplitField(requestBody, 11);
        reqParams.tf['comment'] = getPipeSplitField(requestBody, 12);
        if (getPipeSplitField(requestBody, 15)) {
            reqParams.tf['vpc'] = {
                'vpc_id': getPipeSplitField(requestBody, 15),
                'vpc_region': getPipeSplitField(requestBody, 17)
            };
        }

        outputs.push({
            'region': region,
            'service': 'route53',
            'method': {
                'api': 'CreateHostedZone',
                'boto3': 'create_hosted_zone',
                'cli': 'create-hosted-zone'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('route53', details.requestId),
            'region': region,
            'service': 'route53',
            'type': 'AWS::Route53::HostedZone',
            'terraformType': 'aws_route53_zone',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:route53:route53.CreateHostedZone
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/route53\/route53console\/route53$/g) && gwtRequest['method'] == "createPublicHostedZone") {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Name'] = getPipeSplitField(requestBody, 10);
        reqParams.cli['--name'] = getPipeSplitField(requestBody, 10);
        reqParams.boto3['HostedZoneConfig'] = {
            'Comment': getPipeSplitField(requestBody, 11)
        };
        reqParams.cli['--hosted-zone-config'] = {
            'Comment': getPipeSplitField(requestBody, 11)
        };
        reqParams.boto3['CallerReference'] = getPipeSplitField(requestBody, 12);
        reqParams.cli['--caller-reference'] = getPipeSplitField(requestBody, 12);

        reqParams.cfn['Name'] = getPipeSplitField(requestBody, 10);
        reqParams.cfn['HostedZoneConfig'] = {
            'Comment': getPipeSplitField(requestBody, 11)
        };

        reqParams.tf['name'] = getPipeSplitField(requestBody, 10);
        reqParams.tf['comment'] = getPipeSplitField(requestBody, 11);

        outputs.push({
            'region': region,
            'service': 'route53',
            'method': {
                'api': 'CreateHostedZone',
                'boto3': 'create_hosted_zone',
                'cli': 'create-hosted-zone'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('route53', details.requestId),
            'region': region,
            'service': 'route53',
            'type': 'AWS::Route53::HostedZone',
            'terraformType': 'aws_route53_zone',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }


    // autogen:route53:route53.ListGeoLocations
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/route53\/route53console\/route53$/g) && gwtRequest['method'] == "listGeoLocationDetails") {

        outputs.push({
            'region': region,
            'service': 'route53',
            'method': {
                'api': 'ListGeoLocations',
                'boto3': 'list_geo_locations',
                'cli': 'list-geo-locations'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:route53:route53.ListHealthChecks
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/route53\/route53console\/route53$/g) && gwtRequest['method'] == "listHealthChecks") {

        outputs.push({
            'region': region,
            'service': 'route53',
            'method': {
                'api': 'ListHealthChecks',
                'boto3': 'list_health_checks',
                'cli': 'list-health-checks'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:route53:route53.DeleteHostedZone
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/route53\/route53console\/route53$/g) && gwtRequest['method'] == "deleteHostedZone") {
        reqParams.iam['Resource'] = [
            "arn:aws:route53:::hostedzone/" + getPipeSplitField(requestBody, 10)
        ];

        reqParams.boto3['Id'] = getPipeSplitField(requestBody, 10);
        reqParams.cli['--id'] = getPipeSplitField(requestBody, 10);

        outputs.push({
            'region': region,
            'service': 'route53',
            'method': {
                'api': 'DeleteHostedZone',
                'boto3': 'delete_hosted_zone',
                'cli': 'delete-hosted-zone'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:ec2.DescribeAvailabilityZones
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/list\-availability\-zones\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeAvailabilityZones',
                'boto3': 'describe_availability_zones',
                'cli': 'describe-availability-zones'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:opsworks:ec2.DescribeVpcs
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/list\-vpcs\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeVpcs',
                'boto3': 'describe_vpcs',
                'cli': 'describe-vpcs'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:opsworks:ec2.DescribeSubnets
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/list\-subnets\?/g)) {

        outputs.push({
            'region': region,
            'service': 'ec2',
            'method': {
                'api': 'DescribeSubnets',
                'boto3': 'describe_subnets',
                'cli': 'describe-subnets'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:opsworks:opsworks.CreateStack
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/create\-stack\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['Name'] = jsonRequestBody.Name;
        reqParams.cli['--name'] = jsonRequestBody.Name;
        reqParams.boto3['DefaultOs'] = jsonRequestBody.DefaultOs;
        reqParams.cli['--default-os'] = jsonRequestBody.DefaultOs;
        reqParams.boto3['DefaultRootDeviceType'] = jsonRequestBody.DefaultRootDeviceType;
        reqParams.cli['--default-root-device-type'] = jsonRequestBody.DefaultRootDeviceType;
        reqParams.boto3['HostnameTheme'] = jsonRequestBody.HostnameTheme;
        reqParams.cli['--hostname-theme'] = jsonRequestBody.HostnameTheme;
        reqParams.boto3['UseCustomCookbooks'] = jsonRequestBody.UseCustomCookbooks;
        reqParams.cli['--use-custom-cookbooks'] = jsonRequestBody.UseCustomCookbooks;
        reqParams.boto3['CustomJson'] = jsonRequestBody.CustomJson;
        reqParams.cli['--custom-json'] = jsonRequestBody.CustomJson;
        reqParams.boto3['UseOpsworksSecurityGroups'] = jsonRequestBody.UseOpsworksSecurityGroups;
        reqParams.cli['--use-opsworks-security-groups'] = jsonRequestBody.UseOpsworksSecurityGroups;
        reqParams.boto3['ConfigurationManager'] = jsonRequestBody.ConfigurationManager;
        reqParams.cli['--configuration-manager'] = jsonRequestBody.ConfigurationManager;
        reqParams.boto3['Name'] = jsonRequestBody.ConfigurationManager.Name;
        reqParams.cli['--name'] = jsonRequestBody.ConfigurationManager.Name;
        reqParams.boto3['Attributes'] = jsonRequestBody.Attributes;
        reqParams.cli['--attributes'] = jsonRequestBody.Attributes;
        reqParams.boto3['Region'] = jsonRequestBody.Region;
        reqParams.cli['--region'] = jsonRequestBody.Region;
        reqParams.boto3['CustomCookbooksSource'] = jsonRequestBody.CustomCookbooksSource;
        reqParams.cli['--custom-cookbooks-source'] = jsonRequestBody.CustomCookbooksSource;
        reqParams.boto3['VpcId'] = jsonRequestBody.VpcId;
        reqParams.cli['--vpc-id'] = jsonRequestBody.VpcId;
        reqParams.boto3['DefaultSshKeyName'] = jsonRequestBody.DefaultSshKeyName;
        reqParams.cli['--default-ssh-key-name'] = jsonRequestBody.DefaultSshKeyName;
        reqParams.boto3['DefaultSubnetId'] = jsonRequestBody.DefaultSubnetId;
        reqParams.cli['--default-subnet-id'] = jsonRequestBody.DefaultSubnetId;
        reqParams.boto3['ServiceRoleArn'] = jsonRequestBody.ServiceRoleArn;
        reqParams.cli['--service-role-arn'] = jsonRequestBody.ServiceRoleArn;
        reqParams.boto3['DefaultInstanceProfileArn'] = jsonRequestBody.DefaultInstanceProfileArn;
        reqParams.cli['--default-instance-profile-arn'] = jsonRequestBody.DefaultInstanceProfileArn;
        reqParams.boto3['AgentVersion'] = jsonRequestBody.AgentVersion;
        reqParams.cli['--agent-version'] = jsonRequestBody.AgentVersion;

        reqParams.cfn['Name'] = jsonRequestBody.Name;
        reqParams.cfn['DefaultOs'] = jsonRequestBody.DefaultOs;
        reqParams.cfn['DefaultRootDeviceType'] = jsonRequestBody.DefaultRootDeviceType;
        reqParams.cfn['HostnameTheme'] = jsonRequestBody.HostnameTheme;
        reqParams.cfn['UseCustomCookbooks'] = jsonRequestBody.UseCustomCookbooks;
        reqParams.cfn['CustomJson'] = jsonRequestBody.CustomJson;
        reqParams.cfn['UseOpsworksSecurityGroups'] = jsonRequestBody.UseOpsworksSecurityGroups;
        reqParams.cfn['ConfigurationManager'] = jsonRequestBody.ConfigurationManager;
        reqParams.cfn['Name'] = jsonRequestBody.ConfigurationManager.Name;
        reqParams.cfn['Attributes'] = jsonRequestBody.Attributes;
        reqParams.cfn['CustomCookbooksSource'] = jsonRequestBody.CustomCookbooksSource;
        reqParams.cfn['VpcId'] = jsonRequestBody.VpcId;
        reqParams.cfn['DefaultSshKeyName'] = jsonRequestBody.DefaultSshKeyName;
        reqParams.cfn['DefaultSubnetId'] = jsonRequestBody.DefaultSubnetId;
        reqParams.cfn['ServiceRoleArn'] = jsonRequestBody.ServiceRoleArn;
        reqParams.cfn['DefaultInstanceProfileArn'] = jsonRequestBody.DefaultInstanceProfileArn;
        reqParams.cfn['AgentVersion'] = jsonRequestBody.AgentVersion;

        reqParams.tf['name'] = jsonRequestBody.Name;
        reqParams.tf['default_os'] = jsonRequestBody.DefaultOs;
        reqParams.tf['default_root_device_type'] = jsonRequestBody.DefaultRootDeviceType;
        reqParams.tf['hostname_theme'] = jsonRequestBody.HostnameTheme;
        reqParams.tf['use_custom_cookbooks'] = jsonRequestBody.UseCustomCookbooks;
        reqParams.tf['custom_json'] = jsonRequestBody.CustomJson;
        reqParams.tf['use_opsworks_security_groups'] = jsonRequestBody.UseOpsworksSecurityGroups;
        reqParams.tf['configuration_manager_name'] = jsonRequestBody.ConfigurationManager.Name;
        reqParams.tf['configuration_manager_version'] = jsonRequestBody.ConfigurationManager.Version;
        reqParams.tf['name'] = jsonRequestBody.ConfigurationManager.Name;
        reqParams.tf['color'] = jsonRequestBody.Attributes.Color;
        reqParams.tf['custom_cookbooks_source'] = {
            'type': jsonRequestBody.CustomCookbooksSource.Type,
            'url': jsonRequestBody.CustomCookbooksSource.Url
        };
        reqParams.tf['vpc_id'] = jsonRequestBody.VpcId;
        reqParams.tf['default_ssh_key_name'] = jsonRequestBody.DefaultSshKeyName;
        reqParams.tf['default_subnet_id'] = jsonRequestBody.DefaultSubnetId;
        reqParams.tf['service_role_arn'] = jsonRequestBody.ServiceRoleArn;
        reqParams.tf['default_instance_profile_arn'] = jsonRequestBody.DefaultInstanceProfileArn;
        reqParams.tf['agent_version'] = jsonRequestBody.AgentVersion;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'CreateStack',
                'boto3': 'create_stack',
                'cli': 'create-stack'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('opsworks', details.requestId),
            'region': region,
            'service': 'opsworks',
            'type': 'AWS::OpsWorks::Stack',
            'terraformType': 'aws_opsworks_stack',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.CreateApp
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/create\-app\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/" + jsonRequestBody.StackId + "/"
        ];

        reqParams.boto3['StackId'] = jsonRequestBody.StackId;
        reqParams.cli['--stack-id'] = jsonRequestBody.StackId;
        reqParams.boto3['Name'] = jsonRequestBody.Name;
        reqParams.cli['--name'] = jsonRequestBody.Name;
        reqParams.boto3['Type'] = jsonRequestBody.Type;
        reqParams.cli['--type'] = jsonRequestBody.Type;
        reqParams.boto3['AppSource'] = jsonRequestBody.AppSource;
        reqParams.cli['--app-source'] = jsonRequestBody.AppSource;
        reqParams.boto3['EnableSsl'] = jsonRequestBody.EnableSsl;
        reqParams.cli['--enable-ssl'] = jsonRequestBody.EnableSsl;
        reqParams.boto3['Attributes'] = jsonRequestBody.Attributes;
        reqParams.cli['--attributes'] = jsonRequestBody.Attributes;
        reqParams.boto3['Domains'] = jsonRequestBody.Domains;
        reqParams.cli['--domains'] = jsonRequestBody.Domains;
        reqParams.boto3['Environment'] = jsonRequestBody.Environment;
        reqParams.cli['--environment'] = jsonRequestBody.Environment;
        reqParams.boto3['DataSources'] = jsonRequestBody.DataSources;
        reqParams.cli['--data-sources'] = jsonRequestBody.DataSources;

        reqParams.cfn['StackId'] = jsonRequestBody.StackId;
        reqParams.cfn['Name'] = jsonRequestBody.Name;
        reqParams.cfn['Type'] = jsonRequestBody.Type;
        reqParams.cfn['AppSource'] = jsonRequestBody.AppSource;
        reqParams.cfn['EnableSsl'] = jsonRequestBody.EnableSsl;
        reqParams.cfn['Attributes'] = jsonRequestBody.Attributes;
        reqParams.cfn['Domains'] = jsonRequestBody.Domains;
        reqParams.cfn['Environment'] = jsonRequestBody.Environment;
        reqParams.cfn['DataSources'] = jsonRequestBody.DataSources;

        reqParams.tf['stack_id'] = jsonRequestBody.StackId;
        reqParams.tf['name'] = jsonRequestBody.Name;
        reqParams.tf['type'] = jsonRequestBody.Type;
        reqParams.tf['app_source'] = {
            'type': jsonRequestBody.AppSource.Type,
            'url': jsonRequestBody.AppSource.Url,
            'ssh_key': (jsonRequestBody.AppSource.SshKey == "" ? undefined : jsonRequestBody.AppSource.SshKey),
            'revision': (jsonRequestBody.AppSource.Revision == "" ? undefined : jsonRequestBody.AppSource.Revision),
            'username': (jsonRequestBody.AppSource.Username == "" ? undefined : jsonRequestBody.AppSource.Username),
            'password': (jsonRequestBody.AppSource.Password == "" ? undefined : jsonRequestBody.AppSource.Password)
        };
        reqParams.tf['enable_ssl'] = jsonRequestBody.EnableSsl;
        reqParams.tf['domains'] = jsonRequestBody.Domains;
        if (jsonRequestBody.Environment && jsonRequestBody.Environment.length) {
            reqParams.tf['environments'] = [];
            for (var i=0; i<jsonRequestBody.Environment.length; i++) {
                reqParams.tf['environments'].push({
                    'value': jsonRequestBody.Environment[i].Value,
                    'secure': jsonRequestBody.Environment[i].Secure,
                    'key': jsonRequestBody.Environment[i].Key
                });
            }
        }

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'CreateApp',
                'boto3': 'create_app',
                'cli': 'create-app'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('opsworks', details.requestId),
            'region': region,
            'service': 'opsworks',
            'type': 'AWS::OpsWorks::App',
            'terraformType': 'aws_opsworks_application',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.CreateLayer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/create\-layer\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/" + jsonRequestBody.StackId + "/"
        ];

        reqParams.boto3['StackId'] = jsonRequestBody.StackId;
        reqParams.cli['--stack-id'] = jsonRequestBody.StackId;
        reqParams.boto3['Type'] = jsonRequestBody.Type;
        reqParams.cli['--type'] = jsonRequestBody.Type;
        reqParams.boto3['Name'] = jsonRequestBody.Name;
        reqParams.cli['--name'] = jsonRequestBody.Name;
        reqParams.boto3['Shortname'] = jsonRequestBody.Shortname;
        reqParams.cli['--shortname'] = jsonRequestBody.Shortname;
        reqParams.boto3['AutoAssignPublicIps'] = jsonRequestBody.AutoAssignPublicIps;
        reqParams.cli['--auto-assign-public-ips'] = jsonRequestBody.AutoAssignPublicIps;
        reqParams.boto3['Attributes'] = jsonRequestBody.Attributes;
        reqParams.cli['--attributes'] = jsonRequestBody.Attributes;
        reqParams.boto3['UseEbsOptimizedInstances'] = jsonRequestBody.UseEbsOptimizedInstances;
        reqParams.cli['--use-ebs-optimized-instances'] = jsonRequestBody.UseEbsOptimizedInstances;
        reqParams.boto3['AutoAssignElasticIps'] = jsonRequestBody.AutoAssignElasticIps;
        reqParams.cli['--auto-assign-elastic-ips'] = jsonRequestBody.AutoAssignElasticIps;
        reqParams.boto3['CustomRecipes'] = jsonRequestBody.CustomRecipes;
        reqParams.cli['--custom-recipes'] = jsonRequestBody.CustomRecipes;
        reqParams.boto3['EnableAutoHealing'] = jsonRequestBody.EnableAutoHealing;
        reqParams.cli['--enable-auto-healing'] = jsonRequestBody.EnableAutoHealing;

        reqParams.cfn['StackId'] = jsonRequestBody.StackId;
        reqParams.cfn['Type'] = jsonRequestBody.Type;
        reqParams.cfn['Name'] = jsonRequestBody.Name;
        reqParams.cfn['Shortname'] = jsonRequestBody.Shortname;
        reqParams.cfn['AutoAssignPublicIps'] = jsonRequestBody.AutoAssignPublicIps;
        reqParams.cfn['Attributes'] = jsonRequestBody.Attributes;
        reqParams.cfn['AutoAssignElasticIps'] = jsonRequestBody.AutoAssignElasticIps;
        reqParams.cfn['CustomRecipes'] = jsonRequestBody.CustomRecipes;
        reqParams.cfn['EnableAutoHealing'] = jsonRequestBody.EnableAutoHealing;

        var terraformType = null;

        if (jsonRequestBody.Type == "custom") {
            terraformType = "aws_opsworks_custom_layer";
        } else if (jsonRequestBody.Type == "monitoring-master") {
            terraformType = "aws_opsworks_ganglia_layer";
            
            reqParams.tf['drain_elb_on_shutdown'] = jsonRequestBody.Attributes.LifecycleEventConfiguration.Shutdown.DelayUntilElbConnectionsDrained;
            reqParams.tf['password'] = jsonRequestBody.Attributes.GangliaPassword;
            reqParams.tf['url'] = jsonRequestBody.Attributes.GangliaUrl;
            reqParams.tf['username'] = jsonRequestBody.Attributes.GangliaUser;
        } else if (jsonRequestBody.Type == "lb") {
            terraformType = "aws_opsworks_haproxy_layer";

            reqParams.tf['stats_enabled'] = jsonRequestBody.Attributes.EnableHaproxyStats;
            reqParams.tf['healthcheck_method'] = jsonRequestBody.Attributes.HaproxyHealthCheckMethod;
            reqParams.tf['healthcheck_url'] = jsonRequestBody.Attributes.HaproxyHealthCheckUrl;
            reqParams.tf['stats_password'] = jsonRequestBody.Attributes.HaproxyStatsPassword;
            reqParams.tf['stats_url'] = jsonRequestBody.Attributes.HaproxyStatsUrl;
            reqParams.tf['stats_user'] = jsonRequestBody.Attributes.HaproxyStatsUser;
        } else if (jsonRequestBody.Type == "java-app") {
            terraformType = "aws_opsworks_java_app_layer";

            reqParams.tf['app_server'] = jsonRequestBody.Attributes.JavaAppServer;
            reqParams.tf['app_server_version'] = jsonRequestBody.Attributes.JavaAppServerVersion;
            reqParams.tf['jvm_type'] = jsonRequestBody.Attributes.Jvm;
            reqParams.tf['jvm_options'] = jsonRequestBody.Attributes.JvmOptions;
            reqParams.tf['jvm_version'] = jsonRequestBody.Attributes.JvmVersion;
        } else if (jsonRequestBody.Type == "memcached") {
            terraformType = "aws_opsworks_memcached_layer";

            reqParams.tf['allocated_memory'] = jsonRequestBody.Attributes.MemcachedMemory;
        } else if (jsonRequestBody.Type == "db-master") {
            terraformType = "aws_opsworks_mysql_layer";

            reqParams.tf['root_password'] = jsonRequestBody.Attributes.MysqlRootPassword;
            reqParams.tf['root_password_on_all_instances'] = jsonRequestBody.Attributes.MysqlRootPasswordUbiquitous;
        } else if (jsonRequestBody.Type == "nodejs-app") {
            terraformType = "aws_opsworks_nodejs_app_layer";
            
            reqParams.tf['drain_elb_on_shutdown'] = jsonRequestBody.Attributes.LifecycleEventConfiguration.Shutdown.DelayUntilElbConnectionsDrained;
            reqParams.tf['nodejs_version'] = jsonRequestBody.Attributes.NodejsVersion;
        } else if (jsonRequestBody.Type == "php-app") {
            terraformType = "aws_opsworks_php_app_layer";
            
            reqParams.tf['drain_elb_on_shutdown'] = jsonRequestBody.Attributes.LifecycleEventConfiguration.Shutdown.DelayUntilElbConnectionsDrained;
        } else if (jsonRequestBody.Type == "rails-app") {
            terraformType = "aws_opsworks_rails_app_layer";

            reqParams.tf['bundler_version'] = jsonRequestBody.Attributes.BundlerVersion;
            reqParams.tf['manage_bundler'] = jsonRequestBody.Attributes.ManageBundler;
            reqParams.tf['passenger_version'] = jsonRequestBody.Attributes.PassengerVersion;
            reqParams.tf['app_server'] = jsonRequestBody.Attributes.RailsStack;
            reqParams.tf['ruby_version'] = jsonRequestBody.Attributes.RubyVersion;
            reqParams.tf['rubygems_version'] = jsonRequestBody.Attributes.RubygemsVersion;
        } else if (jsonRequestBody.Type == "web") {
            terraformType = "aws_opsworks_static_web_layer";
            
            reqParams.tf['drain_elb_on_shutdown'] = jsonRequestBody.Attributes.LifecycleEventConfiguration.Shutdown.DelayUntilElbConnectionsDrained;
        }

        reqParams.tf['stack_id'] = jsonRequestBody.StackId;
        reqParams.tf['name'] = jsonRequestBody.Name;
        reqParams.tf['short_name'] = jsonRequestBody.Shortname;
        reqParams.tf['auto_assign_public_ips'] = jsonRequestBody.AutoAssignPublicIps;
        reqParams.tf['use_ebs_optimized_instances'] = jsonRequestBody.UseEbsOptimizedInstances;
        reqParams.tf['auto_assign_elastic_ips'] = jsonRequestBody.AutoAssignElasticIps;
        if (jsonRequestBody.CustomRecipes) {
            if (jsonRequestBody.CustomRecipes.Configure.length) {
                reqParams.tf['custom_configure_recipes'] = jsonRequestBody.CustomRecipes.Configure;
            }
            if (jsonRequestBody.CustomRecipes.Deploy.length) {
                reqParams.tf['custom_deploy_recipes'] = jsonRequestBody.CustomRecipes.Deploy;
            }
            if (jsonRequestBody.CustomRecipes.Setup.length) {
                reqParams.tf['custom_setup_recipes'] = jsonRequestBody.CustomRecipes.Setup;
            }
            if (jsonRequestBody.CustomRecipes.Shutdown.length) {
                reqParams.tf['custom_shutdown_recipes'] = jsonRequestBody.CustomRecipes.Shutdown;
            }
            if (jsonRequestBody.CustomRecipes.Undeploy.length) {
                reqParams.tf['custom_undeploy_recipes'] = jsonRequestBody.CustomRecipes.Undeploy;
            }
        }
        reqParams.tf['auto_healing'] = jsonRequestBody.EnableAutoHealing;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'CreateLayer',
                'boto3': 'create_layer',
                'cli': 'create-layer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('opsworks', details.requestId),
            'region': region,
            'service': 'opsworks',
            'type': 'AWS::OpsWorks::Layer',
            'terraformType': terraformType,
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.CreateInstance
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/create\-instance\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/" + jsonRequestBody.StackId + "/"
        ];

        reqParams.boto3['StackId'] = jsonRequestBody.StackId;
        reqParams.cli['--stack-id'] = jsonRequestBody.StackId;
        reqParams.boto3['LayerIds'] = jsonRequestBody.LayerIds;
        reqParams.cli['--layer-ids'] = jsonRequestBody.LayerIds;
        reqParams.boto3['Hostname'] = jsonRequestBody.Hostname;
        reqParams.cli['--hostname'] = jsonRequestBody.Hostname;
        reqParams.boto3['Os'] = jsonRequestBody.Os;
        reqParams.cli['--os'] = jsonRequestBody.Os;
        reqParams.boto3['SshKeyName'] = jsonRequestBody.SshKeyName;
        reqParams.cli['--ssh-key-name'] = jsonRequestBody.SshKeyName;
        reqParams.boto3['RootDeviceType'] = jsonRequestBody.RootDeviceType;
        reqParams.cli['--root-device-type'] = jsonRequestBody.RootDeviceType;
        reqParams.boto3['Architecture'] = jsonRequestBody.Architecture;
        reqParams.cli['--architecture'] = jsonRequestBody.Architecture;
        reqParams.boto3['BlockDeviceMappings'] = jsonRequestBody.BlockDeviceMappings;
        reqParams.cli['--block-device-mappings'] = jsonRequestBody.BlockDeviceMappings;
        reqParams.boto3['InstanceType'] = jsonRequestBody.InstanceType;
        reqParams.cli['--instance-type'] = jsonRequestBody.InstanceType;

        reqParams.cfn['StackId'] = jsonRequestBody.StackId;
        reqParams.cfn['LayerIds'] = jsonRequestBody.LayerIds;
        reqParams.cfn['Hostname'] = jsonRequestBody.Hostname;
        reqParams.cfn['Os'] = jsonRequestBody.Os;
        reqParams.cfn['SshKeyName'] = jsonRequestBody.SshKeyName;
        reqParams.cfn['RootDeviceType'] = jsonRequestBody.RootDeviceType;
        reqParams.cfn['Architecture'] = jsonRequestBody.Architecture;
        reqParams.cfn['BlockDeviceMappings'] = jsonRequestBody.BlockDeviceMappings;
        reqParams.cfn['InstanceType'] = jsonRequestBody.InstanceType;

        reqParams.tf['stack_id'] = jsonRequestBody.StackId;
        reqParams.tf['layer_ids'] = jsonRequestBody.LayerIds;
        reqParams.tf['hostname'] = jsonRequestBody.Hostname;
        reqParams.tf['os'] = jsonRequestBody.Os;
        reqParams.tf['ssh_key_name'] = jsonRequestBody.SshKeyName;
        reqParams.tf['root_device_type'] = jsonRequestBody.RootDeviceType;
        reqParams.tf['architecture'] = jsonRequestBody.Architecture;
        if (jsonRequestBody.BlockDeviceMappings) {
            for (var i=0; i<jsonRequestBody.BlockDeviceMappings.length; i++) {
                if (jsonRequestBody.BlockDeviceMappings[i].DeviceName == "/dev/sda1" || jsonRequestBody.BlockDeviceMappings[i].DeviceName == "/dev/xvda") {
                    if (jsonRequestBody.BlockDeviceMappings[i].Ebs) {
                        reqParams.tf['root_block_device'] = {
                            'volume_type': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeType,
                            'volume_size': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeSize,
                            'delete_on_termination': jsonRequestBody.BlockDeviceMappings[i].Ebs.DeleteOnTermination,
                            'iops': jsonRequestBody.BlockDeviceMappings[i].Ebs.Iops
                        };
                    }
                } else if (jsonRequestBody.BlockDeviceMappings[i].Ebs) {
                    reqParams.tf['ebs_block_device'] = {
                        'device_name': jsonRequestBody.BlockDeviceMappings[i].DeviceName,
                        'volume_type': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeType,
                        'volume_size': jsonRequestBody.BlockDeviceMappings[i].Ebs.VolumeSize,
                        'delete_on_termination': jsonRequestBody.BlockDeviceMappings[i].Ebs.DeleteOnTermination,
                        'iops': jsonRequestBody.BlockDeviceMappings[i].Ebs.Iops,
                        'snapshot_id': jsonRequestBody.BlockDeviceMappings[i].Ebs.SnapshotId
                    };
                }
            }
        }
        reqParams.tf['instance_type'] = jsonRequestBody.InstanceType;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'CreateInstance',
                'boto3': 'create_instance',
                'cli': 'create-instance'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('opsworks', details.requestId),
            'region': region,
            'service': 'opsworks',
            'type': 'AWS::OpsWorks::Instance',
            'terraformType': 'aws_opsworks_instance',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.DescribeLayers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/describe\-layers\?region=ap\-southeast\-2$/g)) {
        reqParams.boto3['StackId'] = jsonRequestBody.StackId;
        reqParams.cli['--stack-id'] = jsonRequestBody.StackId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'DescribeLayers',
                'boto3': 'describe_layers',
                'cli': 'describe-layers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:opsworks:opsworks.UpdateLayer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/update\-layer\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/" + jsonRequestBody.StackId + "/"
        ];

        reqParams.boto3['Name'] = jsonRequestBody.Name;
        reqParams.cli['--name'] = jsonRequestBody.Name;
        reqParams.boto3['Shortname'] = jsonRequestBody.Shortname;
        reqParams.cli['--shortname'] = jsonRequestBody.Shortname;
        reqParams.boto3['AutoAssignPublicIps'] = jsonRequestBody.AutoAssignPublicIps;
        reqParams.cli['--auto-assign-public-ips'] = jsonRequestBody.AutoAssignPublicIps;
        reqParams.boto3['Attributes'] = jsonRequestBody.Attributes;
        reqParams.cli['--attributes'] = jsonRequestBody.Attributes;
        reqParams.boto3['UseEbsOptimizedInstances'] = jsonRequestBody.UseEbsOptimizedInstances;
        reqParams.cli['--use-ebs-optimized-instances'] = jsonRequestBody.UseEbsOptimizedInstances;
        reqParams.boto3['CustomInstanceProfileArn'] = jsonRequestBody.CustomInstanceProfileArn;
        reqParams.cli['--custom-instance-profile-arn'] = jsonRequestBody.CustomInstanceProfileArn;
        reqParams.boto3['AutoAssignElasticIps'] = jsonRequestBody.AutoAssignElasticIps;
        reqParams.cli['--auto-assign-elastic-ips'] = jsonRequestBody.AutoAssignElasticIps;
        reqParams.boto3['CloudWatchLogsConfiguration'] = jsonRequestBody.CloudWatchLogsConfiguration;
        reqParams.cli['--cloud-watch-logs-configuration'] = jsonRequestBody.CloudWatchLogsConfiguration;
        reqParams.boto3['CustomRecipes'] = jsonRequestBody.CustomRecipes;
        reqParams.cli['--custom-recipes'] = jsonRequestBody.CustomRecipes;
        reqParams.boto3['CustomSecurityGroupIds'] = jsonRequestBody.CustomSecurityGroupIds;
        reqParams.cli['--custom-security-group-ids'] = jsonRequestBody.CustomSecurityGroupIds;
        reqParams.boto3['EnableAutoHealing'] = jsonRequestBody.EnableAutoHealing;
        reqParams.cli['--enable-auto-healing'] = jsonRequestBody.EnableAutoHealing;
        reqParams.boto3['LayerId'] = jsonRequestBody.LayerId;
        reqParams.cli['--layer-id'] = jsonRequestBody.LayerId;
        reqParams.boto3['LifecycleEventConfiguration'] = jsonRequestBody.LifecycleEventConfiguration;
        reqParams.cli['--lifecycle-event-configuration'] = jsonRequestBody.LifecycleEventConfiguration;
        reqParams.boto3['Packages'] = jsonRequestBody.Packages;
        reqParams.cli['--packages'] = jsonRequestBody.Packages;
        reqParams.boto3['VolumeConfigurations'] = jsonRequestBody.VolumeConfigurations;
        reqParams.cli['--volume-configurations'] = jsonRequestBody.VolumeConfigurations;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'UpdateLayer',
                'boto3': 'update_layer',
                'cli': 'update-layer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.RegisterVolume
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/register\-volume\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/" + jsonRequestBody.StackId + "/"
        ];

        reqParams.boto3['Ec2VolumeId'] = jsonRequestBody.Ec2VolumeId;
        reqParams.cli['--ec-2-volume-id'] = jsonRequestBody.Ec2VolumeId;
        reqParams.boto3['StackId'] = jsonRequestBody.StackId;
        reqParams.cli['--stack-id'] = jsonRequestBody.StackId;

        reqParams.cfn['Ec2VolumeId'] = jsonRequestBody.Ec2VolumeId;
        reqParams.cfn['StackId'] = jsonRequestBody.StackId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'RegisterVolume',
                'boto3': 'register_volume',
                'cli': 'register-volume'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('opsworks', details.requestId),
            'region': region,
            'service': 'opsworks',
            'type': 'AWS::OpsWorks::Volume',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.DescribeVolumes
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/describe\-volumes\?/g)) {
        reqParams.boto3['StackId'] = jsonRequestBody.StackId;
        reqParams.cli['--stack-id'] = jsonRequestBody.StackId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'DescribeVolumes',
                'boto3': 'describe_volumes',
                'cli': 'describe-volumes'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:opsworks:opsworks.CreateUserProfile
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/create\-user\-profile\?/g)) {
        reqParams.iam['Resource'] = [
            "*"
        ];

        reqParams.boto3['IamUserArn'] = jsonRequestBody.IamUserArn;
        reqParams.cli['--iam-user-arn'] = jsonRequestBody.IamUserArn;
        reqParams.boto3['SshPublicKey'] = jsonRequestBody.SshPublicKey;
        reqParams.cli['--ssh-public-key'] = jsonRequestBody.SshPublicKey;
        reqParams.boto3['AllowSelfManagement'] = jsonRequestBody.AllowSelfManagement;
        reqParams.cli['--allow-self-management'] = jsonRequestBody.AllowSelfManagement;

        reqParams.cfn['IamUserArn'] = jsonRequestBody.IamUserArn;
        reqParams.cfn['SshPublicKey'] = jsonRequestBody.SshPublicKey;
        reqParams.cfn['AllowSelfManagement'] = jsonRequestBody.AllowSelfManagement;

        reqParams.tf['user_arn'] = jsonRequestBody.IamUserArn;
        reqParams.tf['ssh_username'] = jsonRequestBody.IamUserArn.split("/").pop();
        reqParams.tf['ssh_public_key'] = jsonRequestBody.SshPublicKey;
        reqParams.tf['allow_self_management'] = jsonRequestBody.AllowSelfManagement;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'CreateUserProfile',
                'boto3': 'create_user_profile',
                'cli': 'create-user-profile'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('opsworks', details.requestId),
            'region': region,
            'service': 'opsworks',
            'type': 'AWS::OpsWorks::UserProfile',
            'terraformType': 'aws_opsworks_user_profile',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.DescribeElasticLoadBalancers
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/list\-elastic\-load\-balancers\?/g)) {
        reqParams.boto3['StackId'] = jsonRequestBody.StackId;
        reqParams.cli['--stack-id'] = jsonRequestBody.StackId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'DescribeElasticLoadBalancers',
                'boto3': 'describe_elastic_load_balancers',
                'cli': 'describe-elastic-load-balancers'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:opsworks:opsworks.AttachElasticLoadBalancer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/attach\-elastic\-load\-balancer\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/*/"
        ];

        reqParams.boto3['ElasticLoadBalancerName'] = jsonRequestBody.ElasticLoadBalancerName;
        reqParams.cli['--elastic-load-balancer-name'] = jsonRequestBody.ElasticLoadBalancerName;
        reqParams.boto3['LayerId'] = jsonRequestBody.LayerId;
        reqParams.cli['--layer-id'] = jsonRequestBody.LayerId;

        reqParams.cfn['ElasticLoadBalancerName'] = jsonRequestBody.ElasticLoadBalancerName;
        reqParams.cfn['LayerId'] = jsonRequestBody.LayerId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'AttachElasticLoadBalancer',
                'boto3': 'attach_elastic_load_balancer',
                'cli': 'attach-elastic-load-balancer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        tracked_resources.push({
            'logicalId': getResourceName('opsworks', details.requestId),
            'region': region,
            'service': 'opsworks',
            'type': 'AWS::OpsWorks::ElasticLoadBalancerAttachment',
            'options': reqParams,
            'requestDetails': details,
            'was_blocked': blocking
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.DeleteInstance
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/delete\-instance\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/*/"
        ];

        reqParams.boto3['InstanceId'] = jsonRequestBody.InstanceId;
        reqParams.cli['--instance-id'] = jsonRequestBody.InstanceId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'DeleteInstance',
                'boto3': 'delete_instance',
                'cli': 'delete-instance'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:ec2:elb.DeleteLoadBalancer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/ec2\/ecb\?call=deleteLoadBalancer\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:elasticloadbalancing:*:*:loadbalancer/" + jsonRequestBody.loadBalancerName
        ];

        reqParams.boto3['LoadBalancerName'] = jsonRequestBody.loadBalancerName;
        reqParams.cli['--load-balancer-name'] = jsonRequestBody.loadBalancerName;

        outputs.push({
            'region': region,
            'service': 'elb',
            'method': {
                'api': 'DeleteLoadBalancer',
                'boto3': 'delete_load_balancer',
                'cli': 'delete-load-balancer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.DetachElasticLoadBalancer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/detach\-elastic\-load\-balancer\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/*/"
        ];

        reqParams.boto3['ElasticLoadBalancerName'] = jsonRequestBody.ElasticLoadBalancerName;
        reqParams.cli['--elastic-load-balancer-name'] = jsonRequestBody.ElasticLoadBalancerName;
        reqParams.boto3['LayerId'] = jsonRequestBody.LayerId;
        reqParams.cli['--layer-id'] = jsonRequestBody.LayerId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'DetachElasticLoadBalancer',
                'boto3': 'detach_elastic_load_balancer',
                'cli': 'detach-elastic-load-balancer'
            },
            'options': reqParams,
            'requestDetails': details
        });
        
        return {};
    }

    // autogen:opsworks:opsworks.DeleteLayer
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/delete\-layer\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/*/"
        ];

        reqParams.boto3['LayerId'] = jsonRequestBody.LayerId;
        reqParams.cli['--layer-id'] = jsonRequestBody.LayerId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'DeleteLayer',
                'boto3': 'delete_layer',
                'cli': 'delete-layer'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.DeleteApp
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/delete\-app\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/*/"
        ];

        reqParams.boto3['AppId'] = jsonRequestBody.AppId;
        reqParams.cli['--app-id'] = jsonRequestBody.AppId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'DeleteApp',
                'boto3': 'delete_app',
                'cli': 'delete-app'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:opsworks:opsworks.DeleteStack
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/opsworks\/s\/delete\-stack\?/g)) {
        reqParams.iam['Resource'] = [
            "arn:aws:opsworks:*:*:stack/" + jsonRequestBody.StackId + "/"
        ];

        reqParams.boto3['StackId'] = jsonRequestBody.StackId;
        reqParams.cli['--stack-id'] = jsonRequestBody.StackId;

        outputs.push({
            'region': region,
            'service': 'opsworks',
            'method': {
                'api': 'DeleteStack',
                'boto3': 'delete_stack',
                'cli': 'delete-stack'
            },
            'options': reqParams,
            'requestDetails': details
        });

        if (blocking) {
            notifyBlocked();
            return {cancel: true};
        }
        
        return {};
    }

    // autogen:redshift:ec2.DescribeSecurityGroups
    // autogen:redshift:ec2.DescribeAddresses
    // autogen:redshift:redshift.DescribeClusterParameterGroups
    // autogen:redshift:redshift.DescribeClusterSubnetGroups
    // autogen:redshift:ec2.DescribeVpcs
    // autogen:redshift:sns.ListTopics
    // autogen:redshift:redshift.CreateCluster
    // autogen:redshift:redshift.CreateClusterParameterGroup
    // autogen:redshift:redshift.CreateClusterSubnetGroup
    if (details.method == "POST" && details.url.match(/.+console\.(?:aws\.amazon|amazonaws-us-gov)\.com\/redshift\/rpc$/g)) {
        for (var i in jsonRequestBody.actions) {
            var action = jsonRequestBody.actions[i];
            if (action['action'] == "EC2.DescribeSecurityGroupsDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeSecurityGroups',
                        'boto3': 'describe_security_groups',
                        'cli': 'describe-security-groups'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "EC2.DescribeAddressesDefault") {
                outputs.push({
                    'region': region,
                    'service': 'ec2',
                    'method': {
                        'api': 'DescribeAddresses',
                        'boto3': 'describe_addresses',
                        'cli': 'describe-addresses'
                    },
                    'options': reqParams,
                    'requestDetails': details
                });
            } else if (action['action'] == "com.amazonaws.console.cookiemonster.shared.ParamGroupC