<?php

namespace Drupal\phpmailer_gmail_oauth2\Service;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Url;
use Symfony\Component\HttpFoundation\RequestStack;
use PHPMailer\PHPMailer\OAuth;
use League\OAuth2\Client\Provider\Google;

/**
 * Helper to generate a new Google Gmail provider
 */
class GmailProviderService {

    /**
     * Config factory
     *
     * @var \Drupal\Core\Config\ConfigFactoryInterface
     */
    protected $configFactory;

    /**
     * The constructor
     *
     * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
     *   The config factory.
     */
    public function __construct(ConfigFactoryInterface $config_factory) {

        $this->configFactory = $config_factory;
    }

    /**
     * Create a new Google provider for SMTP Auth
     *
     * @return object
     *   The Google provider
     */
    public function getProvider() {

        $config = $this->configFactory->get('phpmailer_gmail_oauth2.gmail_settings');

        $params = [
            'clientId'     => $config->get('gm_client_id'),
            'clientSecret' => $config->get('gm_client_secret'),
            'redirectUri'  => $config->get('gm_provider_url'),
            'accessType'   => 'offline',
            'prompt'       => 'consent',
        ];

        return new Google($params);
    }

    /**
     * Get provider options array
     *
     * @return array
     *   Array of Google provider options
     */
    public function getOptions() {

        return [
            'scope' => [
                'https://mail.google.com/'
            ],
        ];
    }

    /**
     * Get OAuth options
     *
     * @return array
     *   PHPMailer auth options
     */
    public function getAuthOptions() {

        $config = $this->configFactory->get('phpmailer_gmail_oauth2.gmail_settings');
        return [
            'provider'     => $this->getProvider(),
            'userName'     => $config->get('gm_email_address'),
            'clientSecret' => $config->get('gm_client_secret'),
            'clientId'     => $config->get('gm_client_id'),
            'refreshToken' => $config->get('gm_refresh_access_token'),
        ];
    }
}
