/**
   USE OF THIS SOFTWARE IS GOVERNED BY THE TERMS AND CONDITIONS
   OF THE LICENSE STATEMENT AND LIMITED WARRANTY FURNISHED WITH
   THE PRODUCT.
   <p/>
   IN PARTICULAR, YOU WILL INDEMNIFY AND HOLD B2N LTD., ITS
   RELATED COMPANIES AND ITS SUPPLIERS, HARMLESS FROM AND AGAINST ANY
   CLAIMS OR LIABILITIES ARISING OUT OF THE USE, REPRODUCTION, OR
   DISTRIBUTION OF YOUR PROGRAMS, INCLUDING ANY CLAIMS OR LIABILITIES
   ARISING OUT OF OR RESULTING FROM THE USE, MODIFICATION, OR
   DISTRIBUTION OF PROGRAMS OR FILES CREATED FROM, BASED ON, AND/OR
   DERIVED FROM THIS SOURCE CODE FILE.
*/

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Door Lock


#define DOOR_LOCK_PIN 9

//10sec
#define DOOR_LOCK_TIMEOUT 1000
uint32_t DOOR_LOCK_EXECUTE;
bool DOOR_LOCK_IS_OPEN;

void DOOR_LOCK_INIT()
{
  DOOR_LOCK_IS_OPEN = false;
  pinMode(DOOR_LOCK_PIN, OUTPUT);
}

void DOOR_LOCK_OPEN()
{
  DOOR_LOCK_EXECUTE = millis();
  DOOR_LOCK_IS_OPEN = true;
  digitalWrite(DOOR_LOCK_PIN, HIGH);
}

void DOOR_LOCK_WORK()
{
  if (DOOR_LOCK_IS_OPEN && (((uint32_t)(((uint32_t)millis()) - DOOR_LOCK_EXECUTE)) >= DOOR_LOCK_TIMEOUT))
  {
    DOOR_LOCK_IS_OPEN = false;
    digitalWrite(DOOR_LOCK_PIN, LOW);
  } 
}




