// text_category_map.hpp
/*
  neogfx C++ App/Game Engine
  Copyright (c) 2015, 2020 Leigh Johnston.  All Rights Reserved.
  
  This program is free software: you can redistribute it and / or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#pragma once

#include <neogfx/neogfx.hpp>

#include <neogfx/gfx/text/glyph_text.hpp>
#include "i_emoji_atlas.hpp"

namespace neogfx
{
    namespace detail
    {
        typedef std::pair<std::uint32_t, text_category> text_category_MAP_VALUE_TYPE;
        const text_category_MAP_VALUE_TYPE text_category_MAP[] =
        {
			{ 0x00000, text_category::Whitespace },
			{ 0x00021, text_category::None },
			{ 0x00030, text_category::Digit },
			{ 0x0003A, text_category::None },
			{ 0x00041, text_category::LTR },
			{ 0x0005B, text_category::None },
			{ 0x00061, text_category::LTR },
			{ 0x0007B, text_category::None },
			{ 0x0007F, text_category::Whitespace },
			{ 0x000A0, text_category::None },
			{ 0x000AA, text_category::LTR },
			{ 0x000AB, text_category::None },
			{ 0x000AD, text_category::Whitespace },
			{ 0x000AE, text_category::None },
			{ 0x000B2, text_category::Digit },
			{ 0x000B4, text_category::None },
			{ 0x000B5, text_category::LTR },
			{ 0x000B6, text_category::None },
			{ 0x000B9, text_category::Digit },
			{ 0x000BA, text_category::LTR },
			{ 0x000BB, text_category::None },
			{ 0x000C0, text_category::LTR },
			{ 0x000D7, text_category::None },
			{ 0x000D8, text_category::LTR },
			{ 0x000F7, text_category::None },
			{ 0x000F8, text_category::LTR },
			{ 0x002B9, text_category::None },
			{ 0x002BB, text_category::LTR },
			{ 0x002C2, text_category::None },
			{ 0x002D0, text_category::LTR },
			{ 0x002D2, text_category::None },
			{ 0x002E0, text_category::LTR },
			{ 0x002E5, text_category::None },
			{ 0x002EE, text_category::LTR },
			{ 0x002EF, text_category::None },
			{ 0x00300, text_category::Mark },
			{ 0x00370, text_category::LTR },
			{ 0x00374, text_category::None },
			{ 0x00376, text_category::LTR },
			{ 0x00378, text_category::Unknown },
			{ 0x0037A, text_category::LTR },
			{ 0x0037E, text_category::None },
			{ 0x0037F, text_category::LTR },
			{ 0x00380, text_category::Unknown },
			{ 0x00384, text_category::None },
			{ 0x00386, text_category::LTR },
			{ 0x00387, text_category::None },
			{ 0x00388, text_category::LTR },
			{ 0x0038B, text_category::Unknown },
			{ 0x0038C, text_category::LTR },
			{ 0x0038D, text_category::Unknown },
			{ 0x0038E, text_category::LTR },
			{ 0x003A2, text_category::Unknown },
			{ 0x003A3, text_category::LTR },
			{ 0x003F6, text_category::None },
			{ 0x003F7, text_category::LTR },
			{ 0x00483, text_category::Mark },
			{ 0x0048A, text_category::LTR },
			{ 0x00530, text_category::Unknown },
			{ 0x00531, text_category::LTR },
			{ 0x00557, text_category::Unknown },
			{ 0x00559, text_category::LTR },
			{ 0x0058A, text_category::None },
			{ 0x0058B, text_category::Unknown },
			{ 0x0058D, text_category::None },
			{ 0x00590, text_category::Unknown },
			{ 0x00591, text_category::Mark },
			{ 0x005BE, text_category::RTL },
			{ 0x005BF, text_category::Mark },
			{ 0x005C0, text_category::RTL },
			{ 0x005C1, text_category::Mark },
			{ 0x005C3, text_category::RTL },
			{ 0x005C4, text_category::Mark },
			{ 0x005C6, text_category::RTL },
			{ 0x005C7, text_category::Mark },
			{ 0x005C8, text_category::Unknown },
			{ 0x005D0, text_category::RTL },
			{ 0x005EB, text_category::Unknown },
			{ 0x005EF, text_category::RTL },
			{ 0x005F5, text_category::Unknown },
			{ 0x00600, text_category::None },
			{ 0x00608, text_category::RTL },
			{ 0x00609, text_category::None },
			{ 0x0060B, text_category::RTL },
			{ 0x0060C, text_category::None },
			{ 0x0060D, text_category::RTL },
			{ 0x0060E, text_category::None },
			{ 0x00610, text_category::Mark },
			{ 0x0061B, text_category::RTL },
			{ 0x0064B, text_category::Mark },
			{ 0x00660, text_category::None },
			{ 0x0066D, text_category::RTL },
			{ 0x00670, text_category::Mark },
			{ 0x00671, text_category::RTL },
			{ 0x006D6, text_category::Mark },
			{ 0x006DD, text_category::None },
			{ 0x006DF, text_category::Mark },
			{ 0x006E5, text_category::RTL },
			{ 0x006E7, text_category::Mark },
			{ 0x006E9, text_category::None },
			{ 0x006EA, text_category::Mark },
			{ 0x006EE, text_category::RTL },
			{ 0x006F0, text_category::Digit },
			{ 0x006FA, text_category::RTL },
			{ 0x0070E, text_category::Unknown },
			{ 0x0070F, text_category::RTL },
			{ 0x00711, text_category::Mark },
			{ 0x00712, text_category::RTL },
			{ 0x00730, text_category::Mark },
			{ 0x0074B, text_category::Unknown },
			{ 0x0074D, text_category::RTL },
			{ 0x007A6, text_category::Mark },
			{ 0x007B1, text_category::RTL },
			{ 0x007B2, text_category::Unknown },
			{ 0x007C0, text_category::RTL },
			{ 0x007EB, text_category::Mark },
			{ 0x007F4, text_category::RTL },
			{ 0x007F6, text_category::None },
			{ 0x007FA, text_category::RTL },
			{ 0x007FB, text_category::Unknown },
			{ 0x007FD, text_category::Mark },
			{ 0x007FE, text_category::RTL },
			{ 0x00816, text_category::Mark },
			{ 0x0081A, text_category::RTL },
			{ 0x0081B, text_category::Mark },
			{ 0x00824, text_category::RTL },
			{ 0x00825, text_category::Mark },
			{ 0x00828, text_category::RTL },
			{ 0x00829, text_category::Mark },
			{ 0x0082E, text_category::Unknown },
			{ 0x00830, text_category::RTL },
			{ 0x0083F, text_category::Unknown },
			{ 0x00840, text_category::RTL },
			{ 0x00859, text_category::Mark },
			{ 0x0085C, text_category::Unknown },
			{ 0x0085E, text_category::RTL },
			{ 0x0085F, text_category::Unknown },
			{ 0x00860, text_category::RTL },
			{ 0x0086B, text_category::Unknown },
			{ 0x00870, text_category::RTL },
			{ 0x0088F, text_category::Unknown },
			{ 0x00890, text_category::None },
			{ 0x00892, text_category::Unknown },
			{ 0x00898, text_category::Mark },
			{ 0x008A0, text_category::RTL },
			{ 0x008CA, text_category::Mark },
			{ 0x008E2, text_category::None },
			{ 0x008E3, text_category::Mark },
			{ 0x00903, text_category::LTR },
			{ 0x0093A, text_category::Mark },
			{ 0x0093B, text_category::LTR },
			{ 0x0093C, text_category::Mark },
			{ 0x0093D, text_category::LTR },
			{ 0x00941, text_category::Mark },
			{ 0x00949, text_category::LTR },
			{ 0x0094D, text_category::Mark },
			{ 0x0094E, text_category::LTR },
			{ 0x00951, text_category::Mark },
			{ 0x00958, text_category::LTR },
			{ 0x00962, text_category::Mark },
			{ 0x00964, text_category::LTR },
			{ 0x00981, text_category::Mark },
			{ 0x00982, text_category::LTR },
			{ 0x00984, text_category::Unknown },
			{ 0x00985, text_category::LTR },
			{ 0x0098D, text_category::Unknown },
			{ 0x0098F, text_category::LTR },
			{ 0x00991, text_category::Unknown },
			{ 0x00993, text_category::LTR },
			{ 0x009A9, text_category::Unknown },
			{ 0x009AA, text_category::LTR },
			{ 0x009B1, text_category::Unknown },
			{ 0x009B2, text_category::LTR },
			{ 0x009B3, text_category::Unknown },
			{ 0x009B6, text_category::LTR },
			{ 0x009BA, text_category::Unknown },
			{ 0x009BC, text_category::Mark },
			{ 0x009BD, text_category::LTR },
			{ 0x009C1, text_category::Mark },
			{ 0x009C5, text_category::Unknown },
			{ 0x009C7, text_category::LTR },
			{ 0x009C9, text_category::Unknown },
			{ 0x009CB, text_category::LTR },
			{ 0x009CD, text_category::Mark },
			{ 0x009CE, text_category::LTR },
			{ 0x009CF, text_category::Unknown },
			{ 0x009D7, text_category::LTR },
			{ 0x009D8, text_category::Unknown },
			{ 0x009DC, text_category::LTR },
			{ 0x009DE, text_category::Unknown },
			{ 0x009DF, text_category::LTR },
			{ 0x009E2, text_category::Mark },
			{ 0x009E4, text_category::Unknown },
			{ 0x009E6, text_category::LTR },
			{ 0x009F2, text_category::None },
			{ 0x009F4, text_category::LTR },
			{ 0x009FB, text_category::None },
			{ 0x009FC, text_category::LTR },
			{ 0x009FE, text_category::Mark },
			{ 0x009FF, text_category::Unknown },
			{ 0x00A01, text_category::Mark },
			{ 0x00A03, text_category::LTR },
			{ 0x00A04, text_category::Unknown },
			{ 0x00A05, text_category::LTR },
			{ 0x00A0B, text_category::Unknown },
			{ 0x00A0F, text_category::LTR },
			{ 0x00A11, text_category::Unknown },
			{ 0x00A13, text_category::LTR },
			{ 0x00A29, text_category::Unknown },
			{ 0x00A2A, text_category::LTR },
			{ 0x00A31, text_category::Unknown },
			{ 0x00A32, text_category::LTR },
			{ 0x00A34, text_category::Unknown },
			{ 0x00A35, text_category::LTR },
			{ 0x00A37, text_category::Unknown },
			{ 0x00A38, text_category::LTR },
			{ 0x00A3A, text_category::Unknown },
			{ 0x00A3C, text_category::Mark },
			{ 0x00A3D, text_category::Unknown },
			{ 0x00A3E, text_category::LTR },
			{ 0x00A41, text_category::Mark },
			{ 0x00A43, text_category::Unknown },
			{ 0x00A47, text_category::Mark },
			{ 0x00A49, text_category::Unknown },
			{ 0x00A4B, text_category::Mark },
			{ 0x00A4E, text_category::Unknown },
			{ 0x00A51, text_category::Mark },
			{ 0x00A52, text_category::Unknown },
			{ 0x00A59, text_category::LTR },
			{ 0x00A5D, text_category::Unknown },
			{ 0x00A5E, text_category::LTR },
			{ 0x00A5F, text_category::Unknown },
			{ 0x00A66, text_category::LTR },
			{ 0x00A70, text_category::Mark },
			{ 0x00A72, text_category::LTR },
			{ 0x00A75, text_category::Mark },
			{ 0x00A76, text_category::LTR },
			{ 0x00A77, text_category::Unknown },
			{ 0x00A81, text_category::Mark },
			{ 0x00A83, text_category::LTR },
			{ 0x00A84, text_category::Unknown },
			{ 0x00A85, text_category::LTR },
			{ 0x00A8E, text_category::Unknown },
			{ 0x00A8F, text_category::LTR },
			{ 0x00A92, text_category::Unknown },
			{ 0x00A93, text_category::LTR },
			{ 0x00AA9, text_category::Unknown },
			{ 0x00AAA, text_category::LTR },
			{ 0x00AB1, text_category::Unknown },
			{ 0x00AB2, text_category::LTR },
			{ 0x00AB4, text_category::Unknown },
			{ 0x00AB5, text_category::LTR },
			{ 0x00ABA, text_category::Unknown },
			{ 0x00ABC, text_category::Mark },
			{ 0x00ABD, text_category::LTR },
			{ 0x00AC1, text_category::Mark },
			{ 0x00AC6, text_category::Unknown },
			{ 0x00AC7, text_category::Mark },
			{ 0x00AC9, text_category::LTR },
			{ 0x00ACA, text_category::Unknown },
			{ 0x00ACB, text_category::LTR },
			{ 0x00ACD, text_category::Mark },
			{ 0x00ACE, text_category::Unknown },
			{ 0x00AD0, text_category::LTR },
			{ 0x00AD1, text_category::Unknown },
			{ 0x00AE0, text_category::LTR },
			{ 0x00AE2, text_category::Mark },
			{ 0x00AE4, text_category::Unknown },
			{ 0x00AE6, text_category::LTR },
			{ 0x00AF1, text_category::None },
			{ 0x00AF2, text_category::Unknown },
			{ 0x00AF9, text_category::LTR },
			{ 0x00AFA, text_category::Mark },
			{ 0x00B00, text_category::Unknown },
			{ 0x00B01, text_category::Mark },
			{ 0x00B02, text_category::LTR },
			{ 0x00B04, text_category::Unknown },
			{ 0x00B05, text_category::LTR },
			{ 0x00B0D, text_category::Unknown },
			{ 0x00B0F, text_category::LTR },
			{ 0x00B11, text_category::Unknown },
			{ 0x00B13, text_category::LTR },
			{ 0x00B29, text_category::Unknown },
			{ 0x00B2A, text_category::LTR },
			{ 0x00B31, text_category::Unknown },
			{ 0x00B32, text_category::LTR },
			{ 0x00B34, text_category::Unknown },
			{ 0x00B35, text_category::LTR },
			{ 0x00B3A, text_category::Unknown },
			{ 0x00B3C, text_category::Mark },
			{ 0x00B3D, text_category::LTR },
			{ 0x00B3F, text_category::Mark },
			{ 0x00B40, text_category::LTR },
			{ 0x00B41, text_category::Mark },
			{ 0x00B45, text_category::Unknown },
			{ 0x00B47, text_category::LTR },
			{ 0x00B49, text_category::Unknown },
			{ 0x00B4B, text_category::LTR },
			{ 0x00B4D, text_category::Mark },
			{ 0x00B4E, text_category::Unknown },
			{ 0x00B55, text_category::Mark },
			{ 0x00B57, text_category::LTR },
			{ 0x00B58, text_category::Unknown },
			{ 0x00B5C, text_category::LTR },
			{ 0x00B5E, text_category::Unknown },
			{ 0x00B5F, text_category::LTR },
			{ 0x00B62, text_category::Mark },
			{ 0x00B64, text_category::Unknown },
			{ 0x00B66, text_category::LTR },
			{ 0x00B78, text_category::Unknown },
			{ 0x00B82, text_category::Mark },
			{ 0x00B83, text_category::LTR },
			{ 0x00B84, text_category::Unknown },
			{ 0x00B85, text_category::LTR },
			{ 0x00B8B, text_category::Unknown },
			{ 0x00B8E, text_category::LTR },
			{ 0x00B91, text_category::Unknown },
			{ 0x00B92, text_category::LTR },
			{ 0x00B96, text_category::Unknown },
			{ 0x00B99, text_category::LTR },
			{ 0x00B9B, text_category::Unknown },
			{ 0x00B9C, text_category::LTR },
			{ 0x00B9D, text_category::Unknown },
			{ 0x00B9E, text_category::LTR },
			{ 0x00BA0, text_category::Unknown },
			{ 0x00BA3, text_category::LTR },
			{ 0x00BA5, text_category::Unknown },
			{ 0x00BA8, text_category::LTR },
			{ 0x00BAB, text_category::Unknown },
			{ 0x00BAE, text_category::LTR },
			{ 0x00BBA, text_category::Unknown },
			{ 0x00BBE, text_category::LTR },
			{ 0x00BC0, text_category::Mark },
			{ 0x00BC1, text_category::LTR },
			{ 0x00BC3, text_category::Unknown },
			{ 0x00BC6, text_category::LTR },
			{ 0x00BC9, text_category::Unknown },
			{ 0x00BCA, text_category::LTR },
			{ 0x00BCD, text_category::Mark },
			{ 0x00BCE, text_category::Unknown },
			{ 0x00BD0, text_category::LTR },
			{ 0x00BD1, text_category::Unknown },
			{ 0x00BD7, text_category::LTR },
			{ 0x00BD8, text_category::Unknown },
			{ 0x00BE6, text_category::LTR },
			{ 0x00BF3, text_category::None },
			{ 0x00BFB, text_category::Unknown },
			{ 0x00C00, text_category::Mark },
			{ 0x00C01, text_category::LTR },
			{ 0x00C04, text_category::Mark },
			{ 0x00C05, text_category::LTR },
			{ 0x00C0D, text_category::Unknown },
			{ 0x00C0E, text_category::LTR },
			{ 0x00C11, text_category::Unknown },
			{ 0x00C12, text_category::LTR },
			{ 0x00C29, text_category::Unknown },
			{ 0x00C2A, text_category::LTR },
			{ 0x00C3A, text_category::Unknown },
			{ 0x00C3C, text_category::Mark },
			{ 0x00C3D, text_category::LTR },
			{ 0x00C3E, text_category::Mark },
			{ 0x00C41, text_category::LTR },
			{ 0x00C45, text_category::Unknown },
			{ 0x00C46, text_category::Mark },
			{ 0x00C49, text_category::Unknown },
			{ 0x00C4A, text_category::Mark },
			{ 0x00C4E, text_category::Unknown },
			{ 0x00C55, text_category::Mark },
			{ 0x00C57, text_category::Unknown },
			{ 0x00C58, text_category::LTR },
			{ 0x00C5B, text_category::Unknown },
			{ 0x00C5D, text_category::LTR },
			{ 0x00C5E, text_category::Unknown },
			{ 0x00C60, text_category::LTR },
			{ 0x00C62, text_category::Mark },
			{ 0x00C64, text_category::Unknown },
			{ 0x00C66, text_category::LTR },
			{ 0x00C70, text_category::Unknown },
			{ 0x00C77, text_category::LTR },
			{ 0x00C78, text_category::None },
			{ 0x00C7F, text_category::LTR },
			{ 0x00C81, text_category::Mark },
			{ 0x00C82, text_category::LTR },
			{ 0x00C8D, text_category::Unknown },
			{ 0x00C8E, text_category::LTR },
			{ 0x00C91, text_category::Unknown },
			{ 0x00C92, text_category::LTR },
			{ 0x00CA9, text_category::Unknown },
			{ 0x00CAA, text_category::LTR },
			{ 0x00CB4, text_category::Unknown },
			{ 0x00CB5, text_category::LTR },
			{ 0x00CBA, text_category::Unknown },
			{ 0x00CBC, text_category::Mark },
			{ 0x00CBD, text_category::LTR },
			{ 0x00CC5, text_category::Unknown },
			{ 0x00CC6, text_category::LTR },
			{ 0x00CC9, text_category::Unknown },
			{ 0x00CCA, text_category::LTR },
			{ 0x00CCC, text_category::Mark },
			{ 0x00CCE, text_category::Unknown },
			{ 0x00CD5, text_category::LTR },
			{ 0x00CD7, text_category::Unknown },
			{ 0x00CDD, text_category::LTR },
			{ 0x00CDF, text_category::Unknown },
			{ 0x00CE0, text_category::LTR },
			{ 0x00CE2, text_category::Mark },
			{ 0x00CE4, text_category::Unknown },
			{ 0x00CE6, text_category::LTR },
			{ 0x00CF0, text_category::Unknown },
			{ 0x00CF1, text_category::LTR },
			{ 0x00CF4, text_category::Unknown },
			{ 0x00D00, text_category::Mark },
			{ 0x00D02, text_category::LTR },
			{ 0x00D0D, text_category::Unknown },
			{ 0x00D0E, text_category::LTR },
			{ 0x00D11, text_category::Unknown },
			{ 0x00D12, text_category::LTR },
			{ 0x00D3B, text_category::Mark },
			{ 0x00D3D, text_category::LTR },
			{ 0x00D41, text_category::Mark },
			{ 0x00D45, text_category::Unknown },
			{ 0x00D46, text_category::LTR },
			{ 0x00D49, text_category::Unknown },
			{ 0x00D4A, text_category::LTR },
			{ 0x00D4D, text_category::Mark },
			{ 0x00D4E, text_category::LTR },
			{ 0x00D50, text_category::Unknown },
			{ 0x00D54, text_category::LTR },
			{ 0x00D62, text_category::Mark },
			{ 0x00D64, text_category::Unknown },
			{ 0x00D66, text_category::LTR },
			{ 0x00D80, text_category::Unknown },
			{ 0x00D81, text_category::Mark },
			{ 0x00D82, text_category::LTR },
			{ 0x00D84, text_category::Unknown },
			{ 0x00D85, text_category::LTR },
			{ 0x00D97, text_category::Unknown },
			{ 0x00D9A, text_category::LTR },
			{ 0x00DB2, text_category::Unknown },
			{ 0x00DB3, text_category::LTR },
			{ 0x00DBC, text_category::Unknown },
			{ 0x00DBD, text_category::LTR },
			{ 0x00DBE, text_category::Unknown },
			{ 0x00DC0, text_category::LTR },
			{ 0x00DC7, text_category::Unknown },
			{ 0x00DCA, text_category::Mark },
			{ 0x00DCB, text_category::Unknown },
			{ 0x00DCF, text_category::LTR },
			{ 0x00DD2, text_category::Mark },
			{ 0x00DD5, text_category::Unknown },
			{ 0x00DD6, text_category::Mark },
			{ 0x00DD7, text_category::Unknown },
			{ 0x00DD8, text_category::LTR },
			{ 0x00DE0, text_category::Unknown },
			{ 0x00DE6, text_category::LTR },
			{ 0x00DF0, text_category::Unknown },
			{ 0x00DF2, text_category::LTR },
			{ 0x00DF5, text_category::Unknown },
			{ 0x00E01, text_category::LTR },
			{ 0x00E31, text_category::Mark },
			{ 0x00E32, text_category::LTR },
			{ 0x00E34, text_category::Mark },
			{ 0x00E3B, text_category::Unknown },
			{ 0x00E3F, text_category::None },
			{ 0x00E40, text_category::LTR },
			{ 0x00E47, text_category::Mark },
			{ 0x00E4F, text_category::LTR },
			{ 0x00E5C, text_category::Unknown },
			{ 0x00E81, text_category::LTR },
			{ 0x00E83, text_category::Unknown },
			{ 0x00E84, text_category::LTR },
			{ 0x00E85, text_category::Unknown },
			{ 0x00E86, text_category::LTR },
			{ 0x00E8B, text_category::Unknown },
			{ 0x00E8C, text_category::LTR },
			{ 0x00EA4, text_category::Unknown },
			{ 0x00EA5, text_category::LTR },
			{ 0x00EA6, text_category::Unknown },
			{ 0x00EA7, text_category::LTR },
			{ 0x00EB1, text_category::Mark },
			{ 0x00EB2, text_category::LTR },
			{ 0x00EB4, text_category::Mark },
			{ 0x00EBD, text_category::LTR },
			{ 0x00EBE, text_category::Unknown },
			{ 0x00EC0, text_category::LTR },
			{ 0x00EC5, text_category::Unknown },
			{ 0x00EC6, text_category::LTR },
			{ 0x00EC7, text_category::Unknown },
			{ 0x00EC8, text_category::Mark },
			{ 0x00ECF, text_category::Unknown },
			{ 0x00ED0, text_category::LTR },
			{ 0x00EDA, text_category::Unknown },
			{ 0x00EDC, text_category::LTR },
			{ 0x00EE0, text_category::Unknown },
			{ 0x00F00, text_category::LTR },
			{ 0x00F18, text_category::Mark },
			{ 0x00F1A, text_category::LTR },
			{ 0x00F35, text_category::Mark },
			{ 0x00F36, text_category::LTR },
			{ 0x00F37, text_category::Mark },
			{ 0x00F38, text_category::LTR },
			{ 0x00F39, text_category::Mark },
			{ 0x00F3A, text_category::None },
			{ 0x00F3E, text_category::LTR },
			{ 0x00F48, text_category::Unknown },
			{ 0x00F49, text_category::LTR },
			{ 0x00F6D, text_category::Unknown },
			{ 0x00F71, text_category::Mark },
			{ 0x00F7F, text_category::LTR },
			{ 0x00F80, text_category::Mark },
			{ 0x00F85, text_category::LTR },
			{ 0x00F86, text_category::Mark },
			{ 0x00F88, text_category::LTR },
			{ 0x00F8D, text_category::Mark },
			{ 0x00F98, text_category::Unknown },
			{ 0x00F99, text_category::Mark },
			{ 0x00FBD, text_category::Unknown },
			{ 0x00FBE, text_category::LTR },
			{ 0x00FC6, text_category::Mark },
			{ 0x00FC7, text_category::LTR },
			{ 0x00FCD, text_category::Unknown },
			{ 0x00FCE, text_category::LTR },
			{ 0x00FDB, text_category::Unknown },
			{ 0x01000, text_category::LTR },
			{ 0x0102D, text_category::Mark },
			{ 0x01031, text_category::LTR },
			{ 0x01032, text_category::Mark },
			{ 0x01038, text_category::LTR },
			{ 0x01039, text_category::Mark },
			{ 0x0103B, text_category::LTR },
			{ 0x0103D, text_category::Mark },
			{ 0x0103F, text_category::LTR },
			{ 0x01058, text_category::Mark },
			{ 0x0105A, text_category::LTR },
			{ 0x0105E, text_category::Mark },
			{ 0x01061, text_category::LTR },
			{ 0x01071, text_category::Mark },
			{ 0x01075, text_category::LTR },
			{ 0x01082, text_category::Mark },
			{ 0x01083, text_category::LTR },
			{ 0x01085, text_category::Mark },
			{ 0x01087, text_category::LTR },
			{ 0x0108D, text_category::Mark },
			{ 0x0108E, text_category::LTR },
			{ 0x0109D, text_category::Mark },
			{ 0x0109E, text_category::LTR },
			{ 0x010C6, text_category::Unknown },
			{ 0x010C7, text_category::LTR },
			{ 0x010C8, text_category::Unknown },
			{ 0x010CD, text_category::LTR },
			{ 0x010CE, text_category::Unknown },
			{ 0x010D0, text_category::LTR },
			{ 0x01249, text_category::Unknown },
			{ 0x0124A, text_category::LTR },
			{ 0x0124E, text_category::Unknown },
			{ 0x01250, text_category::LTR },
			{ 0x01257, text_category::Unknown },
			{ 0x01258, text_category::LTR },
			{ 0x01259, text_category::Unknown },
			{ 0x0125A, text_category::LTR },
			{ 0x0125E, text_category::Unknown },
			{ 0x01260, text_category::LTR },
			{ 0x01289, text_category::Unknown },
			{ 0x0128A, text_category::LTR },
			{ 0x0128E, text_category::Unknown },
			{ 0x01290, text_category::LTR },
			{ 0x012B1, text_category::Unknown },
			{ 0x012B2, text_category::LTR },
			{ 0x012B6, text_category::Unknown },
			{ 0x012B8, text_category::LTR },
			{ 0x012BF, text_category::Unknown },
			{ 0x012C0, text_category::LTR },
			{ 0x012C1, text_category::Unknown },
			{ 0x012C2, text_category::LTR },
			{ 0x012C6, text_category::Unknown },
			{ 0x012C8, text_category::LTR },
			{ 0x012D7, text_category::Unknown },
			{ 0x012D8, text_category::LTR },
			{ 0x01311, text_category::Unknown },
			{ 0x01312, text_category::LTR },
			{ 0x01316, text_category::Unknown },
			{ 0x01318, text_category::LTR },
			{ 0x0135B, text_category::Unknown },
			{ 0x0135D, text_category::Mark },
			{ 0x01360, text_category::LTR },
			{ 0x0137D, text_category::Unknown },
			{ 0x01380, text_category::LTR },
			{ 0x01390, text_category::None },
			{ 0x0139A, text_category::Unknown },
			{ 0x013A0, text_category::LTR },
			{ 0x013F6, text_category::Unknown },
			{ 0x013F8, text_category::LTR },
			{ 0x013FE, text_category::Unknown },
			{ 0x01400, text_category::None },
			{ 0x01401, text_category::LTR },
			{ 0x01680, text_category::Whitespace },
			{ 0x01681, text_category::LTR },
			{ 0x0169B, text_category::None },
			{ 0x0169D, text_category::Unknown },
			{ 0x016A0, text_category::LTR },
			{ 0x016F9, text_category::Unknown },
			{ 0x01700, text_category::LTR },
			{ 0x01712, text_category::Mark },
			{ 0x01715, text_category::LTR },
			{ 0x01716, text_category::Unknown },
			{ 0x0171F, text_category::LTR },
			{ 0x01732, text_category::Mark },
			{ 0x01734, text_category::LTR },
			{ 0x01737, text_category::Unknown },
			{ 0x01740, text_category::LTR },
			{ 0x01752, text_category::Mark },
			{ 0x01754, text_category::Unknown },
			{ 0x01760, text_category::LTR },
			{ 0x0176D, text_category::Unknown },
			{ 0x0176E, text_category::LTR },
			{ 0x01771, text_category::Unknown },
			{ 0x01772, text_category::Mark },
			{ 0x01774, text_category::Unknown },
			{ 0x01780, text_category::LTR },
			{ 0x017B4, text_category::Mark },
			{ 0x017B6, text_category::LTR },
			{ 0x017B7, text_category::Mark },
			{ 0x017BE, text_category::LTR },
			{ 0x017C6, text_category::Mark },
			{ 0x017C7, text_category::LTR },
			{ 0x017C9, text_category::Mark },
			{ 0x017D4, text_category::LTR },
			{ 0x017DB, text_category::None },
			{ 0x017DC, text_category::LTR },
			{ 0x017DD, text_category::Mark },
			{ 0x017DE, text_category::Unknown },
			{ 0x017E0, text_category::LTR },
			{ 0x017EA, text_category::Unknown },
			{ 0x017F0, text_category::None },
			{ 0x017FA, text_category::Unknown },
			{ 0x01800, text_category::None },
			{ 0x0180B, text_category::Mark },
			{ 0x0180E, text_category::Whitespace },
			{ 0x0180F, text_category::Mark },
			{ 0x01810, text_category::LTR },
			{ 0x0181A, text_category::Unknown },
			{ 0x01820, text_category::LTR },
			{ 0x01879, text_category::Unknown },
			{ 0x01880, text_category::LTR },
			{ 0x01885, text_category::Mark },
			{ 0x01887, text_category::LTR },
			{ 0x018A9, text_category::Mark },
			{ 0x018AA, text_category::LTR },
			{ 0x018AB, text_category::Unknown },
			{ 0x018B0, text_category::LTR },
			{ 0x018F6, text_category::Unknown },
			{ 0x01900, text_category::LTR },
			{ 0x0191F, text_category::Unknown },
			{ 0x01920, text_category::Mark },
			{ 0x01923, text_category::LTR },
			{ 0x01927, text_category::Mark },
			{ 0x01929, text_category::LTR },
			{ 0x0192C, text_category::Unknown },
			{ 0x01930, text_category::LTR },
			{ 0x01932, text_category::Mark },
			{ 0x01933, text_category::LTR },
			{ 0x01939, text_category::Mark },
			{ 0x0193C, text_category::Unknown },
			{ 0x01940, text_category::None },
			{ 0x01941, text_category::Unknown },
			{ 0x01944, text_category::None },
			{ 0x01946, text_category::LTR },
			{ 0x0196E, text_category::Unknown },
			{ 0x01970, text_category::LTR },
			{ 0x01975, text_category::Unknown },
			{ 0x01980, text_category::LTR },
			{ 0x019AC, text_category::Unknown },
			{ 0x019B0, text_category::LTR },
			{ 0x019CA, text_category::Unknown },
			{ 0x019D0, text_category::LTR },
			{ 0x019DB, text_category::Unknown },
			{ 0x019DE, text_category::None },
			{ 0x01A00, text_category::LTR },
			{ 0x01A17, text_category::Mark },
			{ 0x01A19, text_category::LTR },
			{ 0x01A1B, text_category::Mark },
			{ 0x01A1C, text_category::Unknown },
			{ 0x01A1E, text_category::LTR },
			{ 0x01A56, text_category::Mark },
			{ 0x01A57, text_category::LTR },
			{ 0x01A58, text_category::Mark },
			{ 0x01A5F, text_category::Unknown },
			{ 0x01A60, text_category::Mark },
			{ 0x01A61, text_category::LTR },
			{ 0x01A62, text_category::Mark },
			{ 0x01A63, text_category::LTR },
			{ 0x01A65, text_category::Mark },
			{ 0x01A6D, text_category::LTR },
			{ 0x01A73, text_category::Mark },
			{ 0x01A7D, text_category::Unknown },
			{ 0x01A7F, text_category::Mark },
			{ 0x01A80, text_category::LTR },
			{ 0x01A8A, text_category::Unknown },
			{ 0x01A90, text_category::LTR },
			{ 0x01A9A, text_category::Unknown },
			{ 0x01AA0, text_category::LTR },
			{ 0x01AAE, text_category::Unknown },
			{ 0x01AB0, text_category::Mark },
			{ 0x01ACF, text_category::Unknown },
			{ 0x01B00, text_category::Mark },
			{ 0x01B04, text_category::LTR },
			{ 0x01B34, text_category::Mark },
			{ 0x01B35, text_category::LTR },
			{ 0x01B36, text_category::Mark },
			{ 0x01B3B, text_category::LTR },
			{ 0x01B3C, text_category::Mark },
			{ 0x01B3D, text_category::LTR },
			{ 0x01B42, text_category::Mark },
			{ 0x01B43, text_category::LTR },
			{ 0x01B4D, text_category::Unknown },
			{ 0x01B50, text_category::LTR },
			{ 0x01B6B, text_category::Mark },
			{ 0x01B74, text_category::LTR },
			{ 0x01B7F, text_category::Unknown },
			{ 0x01B80, text_category::Mark },
			{ 0x01B82, text_category::LTR },
			{ 0x01BA2, text_category::Mark },
			{ 0x01BA6, text_category::LTR },
			{ 0x01BA8, text_category::Mark },
			{ 0x01BAA, text_category::LTR },
			{ 0x01BAB, text_category::Mark },
			{ 0x01BAE, text_category::LTR },
			{ 0x01BE6, text_category::Mark },
			{ 0x01BE7, text_category::LTR },
			{ 0x01BE8, text_category::Mark },
			{ 0x01BEA, text_category::LTR },
			{ 0x01BED, text_category::Mark },
			{ 0x01BEE, text_category::LTR },
			{ 0x01BEF, text_category::Mark },
			{ 0x01BF2, text_category::LTR },
			{ 0x01BF4, text_category::Unknown },
			{ 0x01BFC, text_category::LTR },
			{ 0x01C2C, text_category::Mark },
			{ 0x01C34, text_category::LTR },
			{ 0x01C36, text_category::Mark },
			{ 0x01C38, text_category::Unknown },
			{ 0x01C3B, text_category::LTR },
			{ 0x01C4A, text_category::Unknown },
			{ 0x01C4D, text_category::LTR },
			{ 0x01C89, text_category::Unknown },
			{ 0x01C90, text_category::LTR },
			{ 0x01CBB, text_category::Unknown },
			{ 0x01CBD, text_category::LTR },
			{ 0x01CC8, text_category::Unknown },
			{ 0x01CD0, text_category::Mark },
			{ 0x01CD3, text_category::LTR },
			{ 0x01CD4, text_category::Mark },
			{ 0x01CE1, text_category::LTR },
			{ 0x01CE2, text_category::Mark },
			{ 0x01CE9, text_category::LTR },
			{ 0x01CED, text_category::Mark },
			{ 0x01CEE, text_category::LTR },
			{ 0x01CF4, text_category::Mark },
			{ 0x01CF5, text_category::LTR },
			{ 0x01CF8, text_category::Mark },
			{ 0x01CFA, text_category::LTR },
			{ 0x01CFB, text_category::Unknown },
			{ 0x01D00, text_category::LTR },
			{ 0x01DC0, text_category::Mark },
			{ 0x01E00, text_category::LTR },
			{ 0x01F16, text_category::Unknown },
			{ 0x01F18, text_category::LTR },
			{ 0x01F1E, text_category::Unknown },
			{ 0x01F20, text_category::LTR },
			{ 0x01F46, text_category::Unknown },
			{ 0x01F48, text_category::LTR },
			{ 0x01F4E, text_category::Unknown },
			{ 0x01F50, text_category::LTR },
			{ 0x01F58, text_category::Unknown },
			{ 0x01F59, text_category::LTR },
			{ 0x01F5A, text_category::Unknown },
			{ 0x01F5B, text_category::LTR },
			{ 0x01F5C, text_category::Unknown },
			{ 0x01F5D, text_category::LTR },
			{ 0x01F5E, text_category::Unknown },
			{ 0x01F5F, text_category::LTR },
			{ 0x01F7E, text_category::Unknown },
			{ 0x01F80, text_category::LTR },
			{ 0x01FB5, text_category::Unknown },
			{ 0x01FB6, text_category::LTR },
			{ 0x01FBD, text_category::None },
			{ 0x01FBE, text_category::LTR },
			{ 0x01FBF, text_category::None },
			{ 0x01FC2, text_category::LTR },
			{ 0x01FC5, text_category::Unknown },
			{ 0x01FC6, text_category::LTR },
			{ 0x01FCD, text_category::None },
			{ 0x01FD0, text_category::LTR },
			{ 0x01FD4, text_category::Unknown },
			{ 0x01FD6, text_category::LTR },
			{ 0x01FDC, text_category::Unknown },
			{ 0x01FDD, text_category::None },
			{ 0x01FE0, text_category::LTR },
			{ 0x01FED, text_category::None },
			{ 0x01FF0, text_category::Unknown },
			{ 0x01FF2, text_category::LTR },
			{ 0x01FF5, text_category::Unknown },
			{ 0x01FF6, text_category::LTR },
			{ 0x01FFD, text_category::None },
			{ 0x01FFF, text_category::Unknown },
			{ 0x02000, text_category::Whitespace },
			{ 0x0200E, text_category::LTR },
			{ 0x0200F, text_category::RTL },
			{ 0x02010, text_category::None },
			{ 0x02028, text_category::Whitespace },
			{ 0x0202A, text_category::None },
			{ 0x0205F, text_category::Whitespace },
			{ 0x02065, text_category::Unknown },
			{ 0x02066, text_category::None },
			{ 0x0206A, text_category::Whitespace },
			{ 0x02070, text_category::Digit },
			{ 0x02071, text_category::LTR },
			{ 0x02072, text_category::Unknown },
			{ 0x02074, text_category::Digit },
			{ 0x0207A, text_category::None },
			{ 0x0207F, text_category::LTR },
			{ 0x02080, text_category::Digit },
			{ 0x0208A, text_category::None },
			{ 0x0208F, text_category::Unknown },
			{ 0x02090, text_category::LTR },
			{ 0x0209D, text_category::Unknown },
			{ 0x020A0, text_category::None },
			{ 0x020C1, text_category::Unknown },
			{ 0x020D0, text_category::Mark },
			{ 0x020F1, text_category::Unknown },
			{ 0x02100, text_category::None },
			{ 0x02102, text_category::LTR },
			{ 0x02103, text_category::None },
			{ 0x02107, text_category::LTR },
			{ 0x02108, text_category::None },
			{ 0x0210A, text_category::LTR },
			{ 0x02114, text_category::None },
			{ 0x02115, text_category::LTR },
			{ 0x02116, text_category::None },
			{ 0x02119, text_category::LTR },
			{ 0x0211E, text_category::None },
			{ 0x02124, text_category::LTR },
			{ 0x02125, text_category::None },
			{ 0x02126, text_category::LTR },
			{ 0x02127, text_category::None },
			{ 0x02128, text_category::LTR },
			{ 0x02129, text_category::None },
			{ 0x0212A, text_category::LTR },
			{ 0x0212E, text_category::None },
			{ 0x0212F, text_category::LTR },
			{ 0x0213A, text_category::None },
			{ 0x0213C, text_category::LTR },
			{ 0x02140, text_category::None },
			{ 0x02145, text_category::LTR },
			{ 0x0214A, text_category::None },
			{ 0x0214E, text_category::LTR },
			{ 0x02150, text_category::None },
			{ 0x02160, text_category::LTR },
			{ 0x02189, text_category::None },
			{ 0x0218C, text_category::Unknown },
			{ 0x02190, text_category::None },
			{ 0x02336, text_category::LTR },
			{ 0x0237B, text_category::None },
			{ 0x02395, text_category::LTR },
			{ 0x02396, text_category::None },
			{ 0x02427, text_category::Unknown },
			{ 0x02440, text_category::None },
			{ 0x0244B, text_category::Unknown },
			{ 0x02460, text_category::None },
			{ 0x02488, text_category::Digit },
			{ 0x0249C, text_category::LTR },
			{ 0x024EA, text_category::None },
			{ 0x026AC, text_category::LTR },
			{ 0x026AD, text_category::None },
			{ 0x02800, text_category::LTR },
			{ 0x02900, text_category::None },
			{ 0x02B74, text_category::Unknown },
			{ 0x02B76, text_category::None },
			{ 0x02B96, text_category::Unknown },
			{ 0x02B97, text_category::None },
			{ 0x02C00, text_category::LTR },
			{ 0x02CE5, text_category::None },
			{ 0x02CEB, text_category::LTR },
			{ 0x02CEF, text_category::Mark },
			{ 0x02CF2, text_category::LTR },
			{ 0x02CF4, text_category::Unknown },
			{ 0x02CF9, text_category::None },
			{ 0x02D00, text_category::LTR },
			{ 0x02D26, text_category::Unknown },
			{ 0x02D27, text_category::LTR },
			{ 0x02D28, text_category::Unknown },
			{ 0x02D2D, text_category::LTR },
			{ 0x02D2E, text_category::Unknown },
			{ 0x02D30, text_category::LTR },
			{ 0x02D68, text_category::Unknown },
			{ 0x02D6F, text_category::LTR },
			{ 0x02D71, text_category::Unknown },
			{ 0x02D7F, text_category::Mark },
			{ 0x02D80, text_category::LTR },
			{ 0x02D97, text_category::Unknown },
			{ 0x02DA0, text_category::LTR },
			{ 0x02DA7, text_category::Unknown },
			{ 0x02DA8, text_category::LTR },
			{ 0x02DAF, text_category::Unknown },
			{ 0x02DB0, text_category::LTR },
			{ 0x02DB7, text_category::Unknown },
			{ 0x02DB8, text_category::LTR },
			{ 0x02DBF, text_category::Unknown },
			{ 0x02DC0, text_category::LTR },
			{ 0x02DC7, text_category::Unknown },
			{ 0x02DC8, text_category::LTR },
			{ 0x02DCF, text_category::Unknown },
			{ 0x02DD0, text_category::LTR },
			{ 0x02DD7, text_category::Unknown },
			{ 0x02DD8, text_category::LTR },
			{ 0x02DDF, text_category::Unknown },
			{ 0x02DE0, text_category::Mark },
			{ 0x02E00, text_category::None },
			{ 0x02E5E, text_category::Unknown },
			{ 0x02E80, text_category::None },
			{ 0x02E9A, text_category::Unknown },
			{ 0x02E9B, text_category::None },
			{ 0x02EF4, text_category::Unknown },
			{ 0x02F00, text_category::None },
			{ 0x02FD6, text_category::Unknown },
			{ 0x02FF0, text_category::None },
			{ 0x03000, text_category::Whitespace },
			{ 0x03001, text_category::None },
			{ 0x03005, text_category::LTR },
			{ 0x03008, text_category::None },
			{ 0x03021, text_category::LTR },
			{ 0x0302A, text_category::Mark },
			{ 0x0302E, text_category::LTR },
			{ 0x03030, text_category::None },
			{ 0x03031, text_category::LTR },
			{ 0x03036, text_category::None },
			{ 0x03038, text_category::LTR },
			{ 0x0303D, text_category::None },
			{ 0x03040, text_category::Unknown },
			{ 0x03041, text_category::LTR },
			{ 0x03097, text_category::Unknown },
			{ 0x03099, text_category::Mark },
			{ 0x0309B, text_category::None },
			{ 0x0309D, text_category::LTR },
			{ 0x030A0, text_category::None },
			{ 0x030A1, text_category::LTR },
			{ 0x030FB, text_category::None },
			{ 0x030FC, text_category::LTR },
			{ 0x03100, text_category::Unknown },
			{ 0x03105, text_category::LTR },
			{ 0x03130, text_category::Unknown },
			{ 0x03131, text_category::LTR },
			{ 0x0318F, text_category::Unknown },
			{ 0x03190, text_category::LTR },
			{ 0x031C0, text_category::None },
			{ 0x031E4, text_category::Unknown },
			{ 0x031EF, text_category::None },
			{ 0x031F0, text_category::LTR },
			{ 0x0321D, text_category::None },
			{ 0x0321F, text_category::Unknown },
			{ 0x03220, text_category::LTR },
			{ 0x03250, text_category::None },
			{ 0x03260, text_category::LTR },
			{ 0x0327C, text_category::None },
			{ 0x0327F, text_category::LTR },
			{ 0x032B1, text_category::None },
			{ 0x032C0, text_category::LTR },
			{ 0x032CC, text_category::None },
			{ 0x032D0, text_category::LTR },
			{ 0x03377, text_category::None },
			{ 0x0337B, text_category::LTR },
			{ 0x033DE, text_category::None },
			{ 0x033E0, text_category::LTR },
			{ 0x033FF, text_category::None },
			{ 0x03400, text_category::LTR },
			{ 0x04DC0, text_category::None },
			{ 0x04E00, text_category::LTR },
			{ 0x0A490, text_category::None },
			{ 0x0A4C7, text_category::Unknown },
			{ 0x0A4D0, text_category::LTR },
			{ 0x0A60D, text_category::None },
			{ 0x0A610, text_category::LTR },
			{ 0x0A62C, text_category::Unknown },
			{ 0x0A640, text_category::LTR },
			{ 0x0A66F, text_category::Mark },
			{ 0x0A673, text_category::None },
			{ 0x0A674, text_category::Mark },
			{ 0x0A67E, text_category::None },
			{ 0x0A680, text_category::LTR },
			{ 0x0A69E, text_category::Mark },
			{ 0x0A6A0, text_category::LTR },
			{ 0x0A6F0, text_category::Mark },
			{ 0x0A6F2, text_category::LTR },
			{ 0x0A6F8, text_category::Unknown },
			{ 0x0A700, text_category::None },
			{ 0x0A722, text_category::LTR },
			{ 0x0A788, text_category::None },
			{ 0x0A789, text_category::LTR },
			{ 0x0A7CB, text_category::Unknown },
			{ 0x0A7D0, text_category::LTR },
			{ 0x0A7D2, text_category::Unknown },
			{ 0x0A7D3, text_category::LTR },
			{ 0x0A7D4, text_category::Unknown },
			{ 0x0A7D5, text_category::LTR },
			{ 0x0A7DA, text_category::Unknown },
			{ 0x0A7F2, text_category::LTR },
			{ 0x0A802, text_category::Mark },
			{ 0x0A803, text_category::LTR },
			{ 0x0A806, text_category::Mark },
			{ 0x0A807, text_category::LTR },
			{ 0x0A80B, text_category::Mark },
			{ 0x0A80C, text_category::LTR },
			{ 0x0A825, text_category::Mark },
			{ 0x0A827, text_category::LTR },
			{ 0x0A828, text_category::None },
			{ 0x0A82C, text_category::Mark },
			{ 0x0A82D, text_category::Unknown },
			{ 0x0A830, text_category::LTR },
			{ 0x0A838, text_category::None },
			{ 0x0A83A, text_category::Unknown },
			{ 0x0A840, text_category::LTR },
			{ 0x0A874, text_category::None },
			{ 0x0A878, text_category::Unknown },
			{ 0x0A880, text_category::LTR },
			{ 0x0A8C4, text_category::Mark },
			{ 0x0A8C6, text_category::Unknown },
			{ 0x0A8CE, text_category::LTR },
			{ 0x0A8DA, text_category::Unknown },
			{ 0x0A8E0, text_category::Mark },
			{ 0x0A8F2, text_category::LTR },
			{ 0x0A8FF, text_category::Mark },
			{ 0x0A900, text_category::LTR },
			{ 0x0A926, text_category::Mark },
			{ 0x0A92E, text_category::LTR },
			{ 0x0A947, text_category::Mark },
			{ 0x0A952, text_category::LTR },
			{ 0x0A954, text_category::Unknown },
			{ 0x0A95F, text_category::LTR },
			{ 0x0A97D, text_category::Unknown },
			{ 0x0A980, text_category::Mark },
			{ 0x0A983, text_category::LTR },
			{ 0x0A9B3, text_category::Mark },
			{ 0x0A9B4, text_category::LTR },
			{ 0x0A9B6, text_category::Mark },
			{ 0x0A9BA, text_category::LTR },
			{ 0x0A9BC, text_category::Mark },
			{ 0x0A9BE, text_category::LTR },
			{ 0x0A9CE, text_category::Unknown },
			{ 0x0A9CF, text_category::LTR },
			{ 0x0A9DA, text_category::Unknown },
			{ 0x0A9DE, text_category::LTR },
			{ 0x0A9E5, text_category::Mark },
			{ 0x0A9E6, text_category::LTR },
			{ 0x0A9FF, text_category::Unknown },
			{ 0x0AA00, text_category::LTR },
			{ 0x0AA29, text_category::Mark },
			{ 0x0AA2F, text_category::LTR },
			{ 0x0AA31, text_category::Mark },
			{ 0x0AA33, text_category::LTR },
			{ 0x0AA35, text_category::Mark },
			{ 0x0AA37, text_category::Unknown },
			{ 0x0AA40, text_category::LTR },
			{ 0x0AA43, text_category::Mark },
			{ 0x0AA44, text_category::LTR },
			{ 0x0AA4C, text_category::Mark },
			{ 0x0AA4D, text_category::LTR },
			{ 0x0AA4E, text_category::Unknown },
			{ 0x0AA50, text_category::LTR },
			{ 0x0AA5A, text_category::Unknown },
			{ 0x0AA5C, text_category::LTR },
			{ 0x0AA7C, text_category::Mark },
			{ 0x0AA7D, text_category::LTR },
			{ 0x0AAB0, text_category::Mark },
			{ 0x0AAB1, text_category::LTR },
			{ 0x0AAB2, text_category::Mark },
			{ 0x0AAB5, text_category::LTR },
			{ 0x0AAB7, text_category::Mark },
			{ 0x0AAB9, text_category::LTR },
			{ 0x0AABE, text_category::Mark },
			{ 0x0AAC0, text_category::LTR },
			{ 0x0AAC1, text_category::Mark },
			{ 0x0AAC2, text_category::LTR },
			{ 0x0AAC3, text_category::Unknown },
			{ 0x0AADB, text_category::LTR },
			{ 0x0AAEC, text_category::Mark },
			{ 0x0AAEE, text_category::LTR },
			{ 0x0AAF6, text_category::Mark },
			{ 0x0AAF7, text_category::Unknown },
			{ 0x0AB01, text_category::LTR },
			{ 0x0AB07, text_category::Unknown },
			{ 0x0AB09, text_category::LTR },
			{ 0x0AB0F, text_category::Unknown },
			{ 0x0AB11, text_category::LTR },
			{ 0x0AB17, text_category::Unknown },
			{ 0x0AB20, text_category::LTR },
			{ 0x0AB27, text_category::Unknown },
			{ 0x0AB28, text_category::LTR },
			{ 0x0AB2F, text_category::Unknown },
			{ 0x0AB30, text_category::LTR },
			{ 0x0AB6A, text_category::None },
			{ 0x0AB6C, text_category::Unknown },
			{ 0x0AB70, text_category::LTR },
			{ 0x0ABE5, text_category::Mark },
			{ 0x0ABE6, text_category::LTR },
			{ 0x0ABE8, text_category::Mark },
			{ 0x0ABE9, text_category::LTR },
			{ 0x0ABED, text_category::Mark },
			{ 0x0ABEE, text_category::Unknown },
			{ 0x0ABF0, text_category::LTR },
			{ 0x0ABFA, text_category::Unknown },
			{ 0x0AC00, text_category::LTR },
			{ 0x0FB1D, text_category::RTL },
			{ 0x0FB1E, text_category::Mark },
			{ 0x0FB1F, text_category::RTL },
			{ 0x0FB29, text_category::None },
			{ 0x0FB2A, text_category::RTL },
			{ 0x0FB37, text_category::Unknown },
			{ 0x0FB38, text_category::RTL },
			{ 0x0FB3D, text_category::Unknown },
			{ 0x0FB3E, text_category::RTL },
			{ 0x0FB3F, text_category::Unknown },
			{ 0x0FB40, text_category::RTL },
			{ 0x0FB42, text_category::Unknown },
			{ 0x0FB43, text_category::RTL },
			{ 0x0FB45, text_category::Unknown },
			{ 0x0FB46, text_category::RTL },
			{ 0x0FBC3, text_category::Unknown },
			{ 0x0FBD3, text_category::RTL },
			{ 0x0FD3E, text_category::None },
			{ 0x0FD50, text_category::RTL },
			{ 0x0FD90, text_category::Unknown },
			{ 0x0FD92, text_category::RTL },
			{ 0x0FDC8, text_category::Unknown },
			{ 0x0FDCF, text_category::None },
			{ 0x0FDD0, text_category::Unknown },
			{ 0x0FDF0, text_category::RTL },
			{ 0x0FDFD, text_category::None },
			{ 0x0FE00, text_category::Mark },
			{ 0x0FE10, text_category::None },
			{ 0x0FE1A, text_category::Unknown },
			{ 0x0FE20, text_category::Mark },
			{ 0x0FE30, text_category::None },
			{ 0x0FE53, text_category::Unknown },
			{ 0x0FE54, text_category::None },
			{ 0x0FE67, text_category::Unknown },
			{ 0x0FE68, text_category::None },
			{ 0x0FE6C, text_category::Unknown },
			{ 0x0FE70, text_category::RTL },
			{ 0x0FE75, text_category::Unknown },
			{ 0x0FE76, text_category::RTL },
			{ 0x0FEFD, text_category::Unknown },
			{ 0x0FEFF, text_category::Whitespace },
			{ 0x0FF00, text_category::Unknown },
			{ 0x0FF01, text_category::None },
			{ 0x0FF10, text_category::Digit },
			{ 0x0FF1A, text_category::None },
			{ 0x0FF21, text_category::LTR },
			{ 0x0FF3B, text_category::None },
			{ 0x0FF41, text_category::LTR },
			{ 0x0FF5B, text_category::None },
			{ 0x0FF66, text_category::LTR },
			{ 0x0FFBF, text_category::Unknown },
			{ 0x0FFC2, text_category::LTR },
			{ 0x0FFC8, text_category::Unknown },
			{ 0x0FFCA, text_category::LTR },
			{ 0x0FFD0, text_category::Unknown },
			{ 0x0FFD2, text_category::LTR },
			{ 0x0FFD8, text_category::Unknown },
			{ 0x0FFDA, text_category::LTR },
			{ 0x0FFDD, text_category::Unknown },
			{ 0x0FFE0, text_category::None },
			{ 0x0FFE7, text_category::Unknown },
			{ 0x0FFE8, text_category::None },
			{ 0x0FFEF, text_category::Unknown },
			{ 0x0FFF9, text_category::None },
			{ 0x0FFFE, text_category::Unknown },
			{ 0x10000, text_category::LTR },
			{ 0x1000C, text_category::Unknown },
			{ 0x1000D, text_category::LTR },
			{ 0x10027, text_category::Unknown },
			{ 0x10028, text_category::LTR },
			{ 0x1003B, text_category::Unknown },
			{ 0x1003C, text_category::LTR },
			{ 0x1003E, text_category::Unknown },
			{ 0x1003F, text_category::LTR },
			{ 0x1004E, text_category::Unknown },
			{ 0x10050, text_category::LTR },
			{ 0x1005E, text_category::Unknown },
			{ 0x10080, text_category::LTR },
			{ 0x100FB, text_category::Unknown },
			{ 0x10100, text_category::LTR },
			{ 0x10101, text_category::None },
			{ 0x10102, text_category::LTR },
			{ 0x10103, text_category::Unknown },
			{ 0x10107, text_category::LTR },
			{ 0x10134, text_category::Unknown },
			{ 0x10137, text_category::LTR },
			{ 0x10140, text_category::None },
			{ 0x1018D, text_category::LTR },
			{ 0x1018F, text_category::Unknown },
			{ 0x10190, text_category::None },
			{ 0x1019D, text_category::Unknown },
			{ 0x101A0, text_category::None },
			{ 0x101A1, text_category::Unknown },
			{ 0x101D0, text_category::LTR },
			{ 0x101FD, text_category::Mark },
			{ 0x101FE, text_category::Unknown },
			{ 0x10280, text_category::LTR },
			{ 0x1029D, text_category::Unknown },
			{ 0x102A0, text_category::LTR },
			{ 0x102D1, text_category::Unknown },
			{ 0x102E0, text_category::Mark },
			{ 0x102E1, text_category::Digit },
			{ 0x102FC, text_category::Unknown },
			{ 0x10300, text_category::LTR },
			{ 0x10324, text_category::Unknown },
			{ 0x1032D, text_category::LTR },
			{ 0x1034B, text_category::Unknown },
			{ 0x10350, text_category::LTR },
			{ 0x10376, text_category::Mark },
			{ 0x1037B, text_category::Unknown },
			{ 0x10380, text_category::LTR },
			{ 0x1039E, text_category::Unknown },
			{ 0x1039F, text_category::LTR },
			{ 0x103C4, text_category::Unknown },
			{ 0x103C8, text_category::LTR },
			{ 0x103D6, text_category::Unknown },
			{ 0x10400, text_category::LTR },
			{ 0x1049E, text_category::Unknown },
			{ 0x104A0, text_category::LTR },
			{ 0x104AA, text_category::Unknown },
			{ 0x104B0, text_category::LTR },
			{ 0x104D4, text_category::Unknown },
			{ 0x104D8, text_category::LTR },
			{ 0x104FC, text_category::Unknown },
			{ 0x10500, text_category::LTR },
			{ 0x10528, text_category::Unknown },
			{ 0x10530, text_category::LTR },
			{ 0x10564, text_category::Unknown },
			{ 0x1056F, text_category::LTR },
			{ 0x1057B, text_category::Unknown },
			{ 0x1057C, text_category::LTR },
			{ 0x1058B, text_category::Unknown },
			{ 0x1058C, text_category::LTR },
			{ 0x10593, text_category::Unknown },
			{ 0x10594, text_category::LTR },
			{ 0x10596, text_category::Unknown },
			{ 0x10597, text_category::LTR },
			{ 0x105A2, text_category::Unknown },
			{ 0x105A3, text_category::LTR },
			{ 0x105B2, text_category::Unknown },
			{ 0x105B3, text_category::LTR },
			{ 0x105BA, text_category::Unknown },
			{ 0x105BB, text_category::LTR },
			{ 0x105BD, text_category::Unknown },
			{ 0x10600, text_category::LTR },
			{ 0x10737, text_category::Unknown },
			{ 0x10740, text_category::LTR },
			{ 0x10756, text_category::Unknown },
			{ 0x10760, text_category::LTR },
			{ 0x10768, text_category::Unknown },
			{ 0x10780, text_category::LTR },
			{ 0x10786, text_category::Unknown },
			{ 0x10787, text_category::LTR },
			{ 0x107B1, text_category::Unknown },
			{ 0x107B2, text_category::LTR },
			{ 0x107BB, text_category::Unknown },
			{ 0x10800, text_category::RTL },
			{ 0x10806, text_category::Unknown },
			{ 0x10808, text_category::RTL },
			{ 0x10809, text_category::Unknown },
			{ 0x1080A, text_category::RTL },
			{ 0x10836, text_category::Unknown },
			{ 0x10837, text_category::RTL },
			{ 0x10839, text_category::Unknown },
			{ 0x1083C, text_category::RTL },
			{ 0x1083D, text_category::Unknown },
			{ 0x1083F, text_category::RTL },
			{ 0x10856, text_category::Unknown },
			{ 0x10857, text_category::RTL },
			{ 0x1089F, text_category::Unknown },
			{ 0x108A7, text_category::RTL },
			{ 0x108B0, text_category::Unknown },
			{ 0x108E0, text_category::RTL },
			{ 0x108F3, text_category::Unknown },
			{ 0x108F4, text_category::RTL },
			{ 0x108F6, text_category::Unknown },
			{ 0x108FB, text_category::RTL },
			{ 0x1091C, text_category::Unknown },
			{ 0x1091F, text_category::None },
			{ 0x10920, text_category::RTL },
			{ 0x1093A, text_category::Unknown },
			{ 0x1093F, text_category::RTL },
			{ 0x10940, text_category::Unknown },
			{ 0x10980, text_category::RTL },
			{ 0x109B8, text_category::Unknown },
			{ 0x109BC, text_category::RTL },
			{ 0x109D0, text_category::Unknown },
			{ 0x109D2, text_category::RTL },
			{ 0x10A01, text_category::Mark },
			{ 0x10A04, text_category::Unknown },
			{ 0x10A05, text_category::Mark },
			{ 0x10A07, text_category::Unknown },
			{ 0x10A0C, text_category::Mark },
			{ 0x10A10, text_category::RTL },
			{ 0x10A14, text_category::Unknown },
			{ 0x10A15, text_category::RTL },
			{ 0x10A18, text_category::Unknown },
			{ 0x10A19, text_category::RTL },
			{ 0x10A36, text_category::Unknown },
			{ 0x10A38, text_category::Mark },
			{ 0x10A3B, text_category::Unknown },
			{ 0x10A3F, text_category::Mark },
			{ 0x10A40, text_category::RTL },
			{ 0x10A49, text_category::Unknown },
			{ 0x10A50, text_category::RTL },
			{ 0x10A59, text_category::Unknown },
			{ 0x10A60, text_category::RTL },
			{ 0x10AA0, text_category::Unknown },
			{ 0x10AC0, text_category::RTL },
			{ 0x10AE5, text_category::Mark },
			{ 0x10AE7, text_category::Unknown },
			{ 0x10AEB, text_category::RTL },
			{ 0x10AF7, text_category::Unknown },
			{ 0x10B00, text_category::RTL },
			{ 0x10B36, text_category::Unknown },
			{ 0x10B39, text_category::None },
			{ 0x10B40, text_category::RTL },
			{ 0x10B56, text_category::Unknown },
			{ 0x10B58, text_category::RTL },
			{ 0x10B73, text_category::Unknown },
			{ 0x10B78, text_category::RTL },
			{ 0x10B92, text_category::Unknown },
			{ 0x10B99, text_category::RTL },
			{ 0x10B9D, text_category::Unknown },
			{ 0x10BA9, text_category::RTL },
			{ 0x10BB0, text_category::Unknown },
			{ 0x10C00, text_category::RTL },
			{ 0x10C49, text_category::Unknown },
			{ 0x10C80, text_category::RTL },
			{ 0x10CB3, text_category::Unknown },
			{ 0x10CC0, text_category::RTL },
			{ 0x10CF3, text_category::Unknown },
			{ 0x10CFA, text_category::RTL },
			{ 0x10D24, text_category::Mark },
			{ 0x10D28, text_category::Unknown },
			{ 0x10D30, text_category::None },
			{ 0x10D3A, text_category::Unknown },
			{ 0x10E60, text_category::None },
			{ 0x10E7F, text_category::Unknown },
			{ 0x10E80, text_category::RTL },
			{ 0x10EAA, text_category::Unknown },
			{ 0x10EAB, text_category::Mark },
			{ 0x10EAD, text_category::RTL },
			{ 0x10EAE, text_category::Unknown },
			{ 0x10EB0, text_category::RTL },
			{ 0x10EB2, text_category::Unknown },
			{ 0x10EFD, text_category::Mark },
			{ 0x10F00, text_category::RTL },
			{ 0x10F28, text_category::Unknown },
			{ 0x10F30, text_category::RTL },
			{ 0x10F46, text_category::Mark },
			{ 0x10F51, text_category::RTL },
			{ 0x10F5A, text_category::Unknown },
			{ 0x10F70, text_category::RTL },
			{ 0x10F82, text_category::Mark },
			{ 0x10F86, text_category::RTL },
			{ 0x10F8A, text_category::Unknown },
			{ 0x10FB0, text_category::RTL },
			{ 0x10FCC, text_category::Unknown },
			{ 0x10FE0, text_category::RTL },
			{ 0x10FF7, text_category::Unknown },
			{ 0x11000, text_category::LTR },
			{ 0x11001, text_category::Mark },
			{ 0x11002, text_category::LTR },
			{ 0x11038, text_category::Mark },
			{ 0x11047, text_category::LTR },
			{ 0x1104E, text_category::Unknown },
			{ 0x11052, text_category::None },
			{ 0x11066, text_category::LTR },
			{ 0x11070, text_category::Mark },
			{ 0x11071, text_category::LTR },
			{ 0x11073, text_category::Mark },
			{ 0x11075, text_category::LTR },
			{ 0x11076, text_category::Unknown },
			{ 0x1107F, text_category::Mark },
			{ 0x11082, text_category::LTR },
			{ 0x110B3, text_category::Mark },
			{ 0x110B7, text_category::LTR },
			{ 0x110B9, text_category::Mark },
			{ 0x110BB, text_category::LTR },
			{ 0x110C2, text_category::Mark },
			{ 0x110C3, text_category::Unknown },
			{ 0x110CD, text_category::LTR },
			{ 0x110CE, text_category::Unknown },
			{ 0x110D0, text_category::LTR },
			{ 0x110E9, text_category::Unknown },
			{ 0x110F0, text_category::LTR },
			{ 0x110FA, text_category::Unknown },
			{ 0x11100, text_category::Mark },
			{ 0x11103, text_category::LTR },
			{ 0x11127, text_category::Mark },
			{ 0x1112C, text_category::LTR },
			{ 0x1112D, text_category::Mark },
			{ 0x11135, text_category::Unknown },
			{ 0x11136, text_category::LTR },
			{ 0x11148, text_category::Unknown },
			{ 0x11150, text_category::LTR },
			{ 0x11173, text_category::Mark },
			{ 0x11174, text_category::LTR },
			{ 0x11177, text_category::Unknown },
			{ 0x11180, text_category::Mark },
			{ 0x11182, text_category::LTR },
			{ 0x111B6, text_category::Mark },
			{ 0x111BF, text_category::LTR },
			{ 0x111C9, text_category::Mark },
			{ 0x111CD, text_category::LTR },
			{ 0x111CF, text_category::Mark },
			{ 0x111D0, text_category::LTR },
			{ 0x111E0, text_category::Unknown },
			{ 0x111E1, text_category::LTR },
			{ 0x111F5, text_category::Unknown },
			{ 0x11200, text_category::LTR },
			{ 0x11212, text_category::Unknown },
			{ 0x11213, text_category::LTR },
			{ 0x1122F, text_category::Mark },
			{ 0x11232, text_category::LTR },
			{ 0x11234, text_category::Mark },
			{ 0x11235, text_category::LTR },
			{ 0x11236, text_category::Mark },
			{ 0x11238, text_category::LTR },
			{ 0x1123E, text_category::Mark },
			{ 0x1123F, text_category::LTR },
			{ 0x11241, text_category::Mark },
			{ 0x11242, text_category::Unknown },
			{ 0x11280, text_category::LTR },
			{ 0x11287, text_category::Unknown },
			{ 0x11288, text_category::LTR },
			{ 0x11289, text_category::Unknown },
			{ 0x1128A, text_category::LTR },
			{ 0x1128E, text_category::Unknown },
			{ 0x1128F, text_category::LTR },
			{ 0x1129E, text_category::Unknown },
			{ 0x1129F, text_category::LTR },
			{ 0x112AA, text_category::Unknown },
			{ 0x112B0, text_category::LTR },
			{ 0x112DF, text_category::Mark },
			{ 0x112E0, text_category::LTR },
			{ 0x112E3, text_category::Mark },
			{ 0x112EB, text_category::Unknown },
			{ 0x112F0, text_category::LTR },
			{ 0x112FA, text_category::Unknown },
			{ 0x11300, text_category::Mark },
			{ 0x11302, text_category::LTR },
			{ 0x11304, text_category::Unknown },
			{ 0x11305, text_category::LTR },
			{ 0x1130D, text_category::Unknown },
			{ 0x1130F, text_category::LTR },
			{ 0x11311, text_category::Unknown },
			{ 0x11313, text_category::LTR },
			{ 0x11329, text_category::Unknown },
			{ 0x1132A, text_category::LTR },
			{ 0x11331, text_category::Unknown },
			{ 0x11332, text_category::LTR },
			{ 0x11334, text_category::Unknown },
			{ 0x11335, text_category::LTR },
			{ 0x1133A, text_category::Unknown },
			{ 0x1133B, text_category::Mark },
			{ 0x1133D, text_category::LTR },
			{ 0x11340, text_category::Mark },
			{ 0x11341, text_category::LTR },
			{ 0x11345, text_category::Unknown },
			{ 0x11347, text_category::LTR },
			{ 0x11349, text_category::Unknown },
			{ 0x1134B, text_category::LTR },
			{ 0x1134E, text_category::Unknown },
			{ 0x11350, text_category::LTR },
			{ 0x11351, text_category::Unknown },
			{ 0x11357, text_category::LTR },
			{ 0x11358, text_category::Unknown },
			{ 0x1135D, text_category::LTR },
			{ 0x11364, text_category::Unknown },
			{ 0x11366, text_category::Mark },
			{ 0x1136D, text_category::Unknown },
			{ 0x11370, text_category::Mark },
			{ 0x11375, text_category::Unknown },
			{ 0x11400, text_category::LTR },
			{ 0x11438, text_category::Mark },
			{ 0x11440, text_category::LTR },
			{ 0x11442, text_category::Mark },
			{ 0x11445, text_category::LTR },
			{ 0x11446, text_category::Mark },
			{ 0x11447, text_category::LTR },
			{ 0x1145C, text_category::Unknown },
			{ 0x1145D, text_category::LTR },
			{ 0x1145E, text_category::Mark },
			{ 0x1145F, text_category::LTR },
			{ 0x11462, text_category::Unknown },
			{ 0x11480, text_category::LTR },
			{ 0x114B3, text_category::Mark },
			{ 0x114B9, text_category::LTR },
			{ 0x114BA, text_category::Mark },
			{ 0x114BB, text_category::LTR },
			{ 0x114BF, text_category::Mark },
			{ 0x114C1, text_category::LTR },
			{ 0x114C2, text_category::Mark },
			{ 0x114C4, text_category::LTR },
			{ 0x114C8, text_category::Unknown },
			{ 0x114D0, text_category::LTR },
			{ 0x114DA, text_category::Unknown },
			{ 0x11580, text_category::LTR },
			{ 0x115B2, text_category::Mark },
			{ 0x115B6, text_category::Unknown },
			{ 0x115B8, text_category::LTR },
			{ 0x115BC, text_category::Mark },
			{ 0x115BE, text_category::LTR },
			{ 0x115BF, text_category::Mark },
			{ 0x115C1, text_category::LTR },
			{ 0x115DC, text_category::Mark },
			{ 0x115DE, text_category::Unknown },
			{ 0x11600, text_category::LTR },
			{ 0x11633, text_category::Mark },
			{ 0x1163B, text_category::LTR },
			{ 0x1163D, text_category::Mark },
			{ 0x1163E, text_category::LTR },
			{ 0x1163F, text_category::Mark },
			{ 0x11641, text_category::LTR },
			{ 0x11645, text_category::Unknown },
			{ 0x11650, text_category::LTR },
			{ 0x1165A, text_category::Unknown },
			{ 0x11660, text_category::None },
			{ 0x1166D, text_category::Unknown },
			{ 0x11680, text_category::LTR },
			{ 0x116AB, text_category::Mark },
			{ 0x116AC, text_category::LTR },
			{ 0x116AD, text_category::Mark },
			{ 0x116AE, text_category::LTR },
			{ 0x116B0, text_category::Mark },
			{ 0x116B6, text_category::LTR },
			{ 0x116B7, text_category::Mark },
			{ 0x116B8, text_category::LTR },
			{ 0x116BA, text_category::Unknown },
			{ 0x116C0, text_category::LTR },
			{ 0x116CA, text_category::Unknown },
			{ 0x11700, text_category::LTR },
			{ 0x1171B, text_category::Unknown },
			{ 0x1171D, text_category::Mark },
			{ 0x11720, text_category::LTR },
			{ 0x11722, text_category::Mark },
			{ 0x11726, text_category::LTR },
			{ 0x11727, text_category::Mark },
			{ 0x1172C, text_category::Unknown },
			{ 0x11730, text_category::LTR },
			{ 0x11747, text_category::Unknown },
			{ 0x11800, text_category::LTR },
			{ 0x1182F, text_category::Mark },
			{ 0x11838, text_category::LTR },
			{ 0x11839, text_category::Mark },
			{ 0x1183B, text_category::LTR },
			{ 0x1183C, text_category::Unknown },
			{ 0x118A0, text_category::LTR },
			{ 0x118F3, text_category::Unknown },
			{ 0x118FF, text_category::LTR },
			{ 0x11907, text_category::Unknown },
			{ 0x11909, text_category::LTR },
			{ 0x1190A, text_category::Unknown },
			{ 0x1190C, text_category::LTR },
			{ 0x11914, text_category::Unknown },
			{ 0x11915, text_category::LTR },
			{ 0x11917, text_category::Unknown },
			{ 0x11918, text_category::LTR },
			{ 0x11936, text_category::Unknown },
			{ 0x11937, text_category::LTR },
			{ 0x11939, text_category::Unknown },
			{ 0x1193B, text_category::Mark },
			{ 0x1193D, text_category::LTR },
			{ 0x1193E, text_category::Mark },
			{ 0x1193F, text_category::LTR },
			{ 0x11943, text_category::Mark },
			{ 0x11944, text_category::LTR },
			{ 0x11947, text_category::Unknown },
			{ 0x11950, text_category::LTR },
			{ 0x1195A, text_category::Unknown },
			{ 0x119A0, text_category::LTR },
			{ 0x119A8, text_category::Unknown },
			{ 0x119AA, text_category::LTR },
			{ 0x119D4, text_category::Mark },
			{ 0x119D8, text_category::Unknown },
			{ 0x119DA, text_category::Mark },
			{ 0x119DC, text_category::LTR },
			{ 0x119E0, text_category::Mark },
			{ 0x119E1, text_category::LTR },
			{ 0x119E5, text_category::Unknown },
			{ 0x11A00, text_category::LTR },
			{ 0x11A01, text_category::Mark },
			{ 0x11A07, text_category::LTR },
			{ 0x11A09, text_category::Mark },
			{ 0x11A0B, text_category::LTR },
			{ 0x11A33, text_category::Mark },
			{ 0x11A39, text_category::LTR },
			{ 0x11A3B, text_category::Mark },
			{ 0x11A3F, text_category::LTR },
			{ 0x11A47, text_category::Mark },
			{ 0x11A48, text_category::Unknown },
			{ 0x11A50, text_category::LTR },
			{ 0x11A51, text_category::Mark },
			{ 0x11A57, text_category::LTR },
			{ 0x11A59, text_category::Mark },
			{ 0x11A5C, text_category::LTR },
			{ 0x11A8A, text_category::Mark },
			{ 0x11A97, text_category::LTR },
			{ 0x11A98, text_category::Mark },
			{ 0x11A9A, text_category::LTR },
			{ 0x11AA3, text_category::Unknown },
			{ 0x11AB0, text_category::LTR },
			{ 0x11AF9, text_category::Unknown },
			{ 0x11B00, text_category::LTR },
			{ 0x11B0A, text_category::Unknown },
			{ 0x11C00, text_category::LTR },
			{ 0x11C09, text_category::Unknown },
			{ 0x11C0A, text_category::LTR },
			{ 0x11C30, text_category::Mark },
			{ 0x11C37, text_category::Unknown },
			{ 0x11C38, text_category::Mark },
			{ 0x11C3E, text_category::LTR },
			{ 0x11C46, text_category::Unknown },
			{ 0x11C50, text_category::LTR },
			{ 0x11C6D, text_category::Unknown },
			{ 0x11C70, text_category::LTR },
			{ 0x11C90, text_category::Unknown },
			{ 0x11C92, text_category::Mark },
			{ 0x11CA8, text_category::Unknown },
			{ 0x11CA9, text_category::LTR },
			{ 0x11CAA, text_category::Mark },
			{ 0x11CB1, text_category::LTR },
			{ 0x11CB2, text_category::Mark },
			{ 0x11CB4, text_category::LTR },
			{ 0x11CB5, text_category::Mark },
			{ 0x11CB7, text_category::Unknown },
			{ 0x11D00, text_category::LTR },
			{ 0x11D07, text_category::Unknown },
			{ 0x11D08, text_category::LTR },
			{ 0x11D0A, text_category::Unknown },
			{ 0x11D0B, text_category::LTR },
			{ 0x11D31, text_category::Mark },
			{ 0x11D37, text_category::Unknown },
			{ 0x11D3A, text_category::Mark },
			{ 0x11D3B, text_category::Unknown },
			{ 0x11D3C, text_category::Mark },
			{ 0x11D3E, text_category::Unknown },
			{ 0x11D3F, text_category::Mark },
			{ 0x11D46, text_category::LTR },
			{ 0x11D47, text_category::Mark },
			{ 0x11D48, text_category::Unknown },
			{ 0x11D50, text_category::LTR },
			{ 0x11D5A, text_category::Unknown },
			{ 0x11D60, text_category::LTR },
			{ 0x11D66, text_category::Unknown },
			{ 0x11D67, text_category::LTR },
			{ 0x11D69, text_category::Unknown },
			{ 0x11D6A, text_category::LTR },
			{ 0x11D8F, text_category::Unknown },
			{ 0x11D90, text_category::Mark },
			{ 0x11D92, text_category::Unknown },
			{ 0x11D93, text_category::LTR },
			{ 0x11D95, text_category::Mark },
			{ 0x11D96, text_category::LTR },
			{ 0x11D97, text_category::Mark },
			{ 0x11D98, text_category::LTR },
			{ 0x11D99, text_category::Unknown },
			{ 0x11DA0, text_category::LTR },
			{ 0x11DAA, text_category::Unknown },
			{ 0x11EE0, text_category::LTR },
			{ 0x11EF3, text_category::Mark },
			{ 0x11EF5, text_category::LTR },
			{ 0x11EF9, text_category::Unknown },
			{ 0x11F00, text_category::Mark },
			{ 0x11F02, text_category::LTR },
			{ 0x11F11, text_category::Unknown },
			{ 0x11F12, text_category::LTR },
			{ 0x11F36, text_category::Mark },
			{ 0x11F3B, text_category::Unknown },
			{ 0x11F3E, text_category::LTR },
			{ 0x11F40, text_category::Mark },
			{ 0x11F41, text_category::LTR },
			{ 0x11F42, text_category::Mark },
			{ 0x11F43, text_category::LTR },
			{ 0x11F5A, text_category::Unknown },
			{ 0x11FB0, text_category::LTR },
			{ 0x11FB1, text_category::Unknown },
			{ 0x11FC0, text_category::LTR },
			{ 0x11FD5, text_category::None },
			{ 0x11FF2, text_category::Unknown },
			{ 0x11FFF, text_category::LTR },
			{ 0x1239A, text_category::Unknown },
			{ 0x12400, text_category::LTR },
			{ 0x1246F, text_category::Unknown },
			{ 0x12470, text_category::LTR },
			{ 0x12475, text_category::Unknown },
			{ 0x12480, text_category::LTR },
			{ 0x12544, text_category::Unknown },
			{ 0x12F90, text_category::LTR },
			{ 0x12FF3, text_category::Unknown },
			{ 0x13000, text_category::LTR },
			{ 0x13440, text_category::Mark },
			{ 0x13441, text_category::LTR },
			{ 0x13447, text_category::Mark },
			{ 0x13456, text_category::Unknown },
			{ 0x14400, text_category::LTR },
			{ 0x14647, text_category::Unknown },
			{ 0x16800, text_category::LTR },
			{ 0x16A39, text_category::Unknown },
			{ 0x16A40, text_category::LTR },
			{ 0x16A5F, text_category::Unknown },
			{ 0x16A60, text_category::LTR },
			{ 0x16A6A, text_category::Unknown },
			{ 0x16A6E, text_category::LTR },
			{ 0x16ABF, text_category::Unknown },
			{ 0x16AC0, text_category::LTR },
			{ 0x16ACA, text_category::Unknown },
			{ 0x16AD0, text_category::LTR },
			{ 0x16AEE, text_category::Unknown },
			{ 0x16AF0, text_category::Mark },
			{ 0x16AF5, text_category::LTR },
			{ 0x16AF6, text_category::Unknown },
			{ 0x16B00, text_category::LTR },
			{ 0x16B30, text_category::Mark },
			{ 0x16B37, text_category::LTR },
			{ 0x16B46, text_category::Unknown },
			{ 0x16B50, text_category::LTR },
			{ 0x16B5A, text_category::Unknown },
			{ 0x16B5B, text_category::LTR },
			{ 0x16B62, text_category::Unknown },
			{ 0x16B63, text_category::LTR },
			{ 0x16B78, text_category::Unknown },
			{ 0x16B7D, text_category::LTR },
			{ 0x16B90, text_category::Unknown },
			{ 0x16E40, text_category::LTR },
			{ 0x16E9B, text_category::Unknown },
			{ 0x16F00, text_category::LTR },
			{ 0x16F4B, text_category::Unknown },
			{ 0x16F4F, text_category::Mark },
			{ 0x16F50, text_category::LTR },
			{ 0x16F88, text_category::Unknown },
			{ 0x16F8F, text_category::Mark },
			{ 0x16F93, text_category::LTR },
			{ 0x16FA0, text_category::Unknown },
			{ 0x16FE0, text_category::LTR },
			{ 0x16FE2, text_category::None },
			{ 0x16FE3, text_category::LTR },
			{ 0x16FE4, text_category::Mark },
			{ 0x16FE5, text_category::Unknown },
			{ 0x16FF0, text_category::LTR },
			{ 0x16FF2, text_category::Unknown },
			{ 0x17000, text_category::LTR },
			{ 0x17001, text_category::Unknown },
			{ 0x187F7, text_category::LTR },
			{ 0x187F8, text_category::Unknown },
			{ 0x18800, text_category::LTR },
			{ 0x18CD6, text_category::Unknown },
			{ 0x18D00, text_category::LTR },
			{ 0x18D01, text_category::Unknown },
			{ 0x18D08, text_category::LTR },
			{ 0x18D09, text_category::Unknown },
			{ 0x1AFF0, text_category::LTR },
			{ 0x1AFF4, text_category::Unknown },
			{ 0x1AFF5, text_category::LTR },
			{ 0x1AFFC, text_category::Unknown },
			{ 0x1AFFD, text_category::LTR },
			{ 0x1AFFF, text_category::Unknown },
			{ 0x1B000, text_category::LTR },
			{ 0x1B123, text_category::Unknown },
			{ 0x1B132, text_category::LTR },
			{ 0x1B133, text_category::Unknown },
			{ 0x1B150, text_category::LTR },
			{ 0x1B153, text_category::Unknown },
			{ 0x1B155, text_category::LTR },
			{ 0x1B156, text_category::Unknown },
			{ 0x1B164, text_category::LTR },
			{ 0x1B168, text_category::Unknown },
			{ 0x1B170, text_category::LTR },
			{ 0x1B2FC, text_category::Unknown },
			{ 0x1BC00, text_category::LTR },
			{ 0x1BC6B, text_category::Unknown },
			{ 0x1BC70, text_category::LTR },
			{ 0x1BC7D, text_category::Unknown },
			{ 0x1BC80, text_category::LTR },
			{ 0x1BC89, text_category::Unknown },
			{ 0x1BC90, text_category::LTR },
			{ 0x1BC9A, text_category::Unknown },
			{ 0x1BC9C, text_category::LTR },
			{ 0x1BC9D, text_category::Mark },
			{ 0x1BC9F, text_category::LTR },
			{ 0x1BCA0, text_category::Whitespace },
			{ 0x1BCA4, text_category::Unknown },
			{ 0x1CF00, text_category::Mark },
			{ 0x1CF2E, text_category::Unknown },
			{ 0x1CF30, text_category::Mark },
			{ 0x1CF47, text_category::Unknown },
			{ 0x1CF50, text_category::LTR },
			{ 0x1CFC4, text_category::Unknown },
			{ 0x1D000, text_category::LTR },
			{ 0x1D0F6, text_category::Unknown },
			{ 0x1D100, text_category::LTR },
			{ 0x1D127, text_category::Unknown },
			{ 0x1D129, text_category::LTR },
			{ 0x1D167, text_category::Mark },
			{ 0x1D16A, text_category::LTR },
			{ 0x1D173, text_category::Whitespace },
			{ 0x1D17B, text_category::Mark },
			{ 0x1D183, text_category::LTR },
			{ 0x1D185, text_category::Mark },
			{ 0x1D18C, text_category::LTR },
			{ 0x1D1AA, text_category::Mark },
			{ 0x1D1AE, text_category::LTR },
			{ 0x1D1E9, text_category::None },
			{ 0x1D1EB, text_category::Unknown },
			{ 0x1D200, text_category::None },
			{ 0x1D242, text_category::Mark },
			{ 0x1D245, text_category::None },
			{ 0x1D246, text_category::Unknown },
			{ 0x1D2C0, text_category::LTR },
			{ 0x1D2D4, text_category::Unknown },
			{ 0x1D2E0, text_category::LTR },
			{ 0x1D2F4, text_category::Unknown },
			{ 0x1D300, text_category::None },
			{ 0x1D357, text_category::Unknown },
			{ 0x1D360, text_category::LTR },
			{ 0x1D379, text_category::Unknown },
			{ 0x1D400, text_category::LTR },
			{ 0x1D455, text_category::Unknown },
			{ 0x1D456, text_category::LTR },
			{ 0x1D49D, text_category::Unknown },
			{ 0x1D49E, text_category::LTR },
			{ 0x1D4A0, text_category::Unknown },
			{ 0x1D4A2, text_category::LTR },
			{ 0x1D4A3, text_category::Unknown },
			{ 0x1D4A5, text_category::LTR },
			{ 0x1D4A7, text_category::Unknown },
			{ 0x1D4A9, text_category::LTR },
			{ 0x1D4AD, text_category::Unknown },
			{ 0x1D4AE, text_category::LTR },
			{ 0x1D4BA, text_category::Unknown },
			{ 0x1D4BB, text_category::LTR },
			{ 0x1D4BC, text_category::Unknown },
			{ 0x1D4BD, text_category::LTR },
			{ 0x1D4C4, text_category::Unknown },
			{ 0x1D4C5, text_category::LTR },
			{ 0x1D506, text_category::Unknown },
			{ 0x1D507, text_category::LTR },
			{ 0x1D50B, text_category::Unknown },
			{ 0x1D50D, text_category::LTR },
			{ 0x1D515, text_category::Unknown },
			{ 0x1D516, text_category::LTR },
			{ 0x1D51D, text_category::Unknown },
			{ 0x1D51E, text_category::LTR },
			{ 0x1D53A, text_category::Unknown },
			{ 0x1D53B, text_category::LTR },
			{ 0x1D53F, text_category::Unknown },
			{ 0x1D540, text_category::LTR },
			{ 0x1D545, text_category::Unknown },
			{ 0x1D546, text_category::LTR },
			{ 0x1D547, text_category::Unknown },
			{ 0x1D54A, text_category::LTR },
			{ 0x1D551, text_category::Unknown },
			{ 0x1D552, text_category::LTR },
			{ 0x1D6A6, text_category::Unknown },
			{ 0x1D6A8, text_category::LTR },
			{ 0x1D6DB, text_category::None },
			{ 0x1D6DC, text_category::LTR },
			{ 0x1D715, text_category::None },
			{ 0x1D716, text_category::LTR },
			{ 0x1D74F, text_category::None },
			{ 0x1D750, text_category::LTR },
			{ 0x1D789, text_category::None },
			{ 0x1D78A, text_category::LTR },
			{ 0x1D7C3, text_category::None },
			{ 0x1D7C4, text_category::LTR },
			{ 0x1D7CC, text_category::Unknown },
			{ 0x1D7CE, text_category::Digit },
			{ 0x1D800, text_category::LTR },
			{ 0x1DA00, text_category::Mark },
			{ 0x1DA37, text_category::LTR },
			{ 0x1DA3B, text_category::Mark },
			{ 0x1DA6D, text_category::LTR },
			{ 0x1DA75, text_category::Mark },
			{ 0x1DA76, text_category::LTR },
			{ 0x1DA84, text_category::Mark },
			{ 0x1DA85, text_category::LTR },
			{ 0x1DA8C, text_category::Unknown },
			{ 0x1DA9B, text_category::Mark },
			{ 0x1DAA0, text_category::Unknown },
			{ 0x1DAA1, text_category::Mark },
			{ 0x1DAB0, text_category::Unknown },
			{ 0x1DF00, text_category::LTR },
			{ 0x1DF1F, text_category::Unknown },
			{ 0x1DF25, text_category::LTR },
			{ 0x1DF2B, text_category::Unknown },
			{ 0x1E000, text_category::Mark },
			{ 0x1E007, text_category::Unknown },
			{ 0x1E008, text_category::Mark },
			{ 0x1E019, text_category::Unknown },
			{ 0x1E01B, text_category::Mark },
			{ 0x1E022, text_category::Unknown },
			{ 0x1E023, text_category::Mark },
			{ 0x1E025, text_category::Unknown },
			{ 0x1E026, text_category::Mark },
			{ 0x1E02B, text_category::Unknown },
			{ 0x1E030, text_category::LTR },
			{ 0x1E06E, text_category::Unknown },
			{ 0x1E08F, text_category::Mark },
			{ 0x1E090, text_category::Unknown },
			{ 0x1E100, text_category::LTR },
			{ 0x1E12D, text_category::Unknown },
			{ 0x1E130, text_category::Mark },
			{ 0x1E137, text_category::LTR },
			{ 0x1E13E, text_category::Unknown },
			{ 0x1E140, text_category::LTR },
			{ 0x1E14A, text_category::Unknown },
			{ 0x1E14E, text_category::LTR },
			{ 0x1E150, text_category::Unknown },
			{ 0x1E290, text_category::LTR },
			{ 0x1E2AE, text_category::Mark },
			{ 0x1E2AF, text_category::Unknown },
			{ 0x1E2C0, text_category::LTR },
			{ 0x1E2EC, text_category::Mark },
			{ 0x1E2F0, text_category::LTR },
			{ 0x1E2FA, text_category::Unknown },
			{ 0x1E2FF, text_category::None },
			{ 0x1E300, text_category::Unknown },
			{ 0x1E4D0, text_category::LTR },
			{ 0x1E4EC, text_category::Mark },
			{ 0x1E4F0, text_category::LTR },
			{ 0x1E4FA, text_category::Unknown },
			{ 0x1E7E0, text_category::LTR },
			{ 0x1E7E7, text_category::Unknown },
			{ 0x1E7E8, text_category::LTR },
			{ 0x1E7EC, text_category::Unknown },
			{ 0x1E7ED, text_category::LTR },
			{ 0x1E7EF, text_category::Unknown },
			{ 0x1E7F0, text_category::LTR },
			{ 0x1E7FF, text_category::Unknown },
			{ 0x1E800, text_category::RTL },
			{ 0x1E8C5, text_category::Unknown },
			{ 0x1E8C7, text_category::RTL },
			{ 0x1E8D0, text_category::Mark },
			{ 0x1E8D7, text_category::Unknown },
			{ 0x1E900, text_category::RTL },
			{ 0x1E944, text_category::Mark },
			{ 0x1E94B, text_category::RTL },
			{ 0x1E94C, text_category::Unknown },
			{ 0x1E950, text_category::RTL },
			{ 0x1E95A, text_category::Unknown },
			{ 0x1E95E, text_category::RTL },
			{ 0x1E960, text_category::Unknown },
			{ 0x1EC71, text_category::RTL },
			{ 0x1ECB5, text_category::Unknown },
			{ 0x1ED01, text_category::RTL },
			{ 0x1ED3E, text_category::Unknown },
			{ 0x1EE00, text_category::RTL },
			{ 0x1EE04, text_category::Unknown },
			{ 0x1EE05, text_category::RTL },
			{ 0x1EE20, text_category::Unknown },
			{ 0x1EE21, text_category::RTL },
			{ 0x1EE23, text_category::Unknown },
			{ 0x1EE24, text_category::RTL },
			{ 0x1EE25, text_category::Unknown },
			{ 0x1EE27, text_category::RTL },
			{ 0x1EE28, text_category::Unknown },
			{ 0x1EE29, text_category::RTL },
			{ 0x1EE33, text_category::Unknown },
			{ 0x1EE34, text_category::RTL },
			{ 0x1EE38, text_category::Unknown },
			{ 0x1EE39, text_category::RTL },
			{ 0x1EE3A, text_category::Unknown },
			{ 0x1EE3B, text_category::RTL },
			{ 0x1EE3C, text_category::Unknown },
			{ 0x1EE42, text_category::RTL },
			{ 0x1EE43, text_category::Unknown },
			{ 0x1EE47, text_category::RTL },
			{ 0x1EE48, text_category::Unknown },
			{ 0x1EE49, text_category::RTL },
			{ 0x1EE4A, text_category::Unknown },
			{ 0x1EE4B, text_category::RTL },
			{ 0x1EE4C, text_category::Unknown },
			{ 0x1EE4D, text_category::RTL },
			{ 0x1EE50, text_category::Unknown },
			{ 0x1EE51, text_category::RTL },
			{ 0x1EE53, text_category::Unknown },
			{ 0x1EE54, text_category::RTL },
			{ 0x1EE55, text_category::Unknown },
			{ 0x1EE57, text_category::RTL },
			{ 0x1EE58, text_category::Unknown },
			{ 0x1EE59, text_category::RTL },
			{ 0x1EE5A, text_category::Unknown },
			{ 0x1EE5B, text_category::RTL },
			{ 0x1EE5C, text_category::Unknown },
			{ 0x1EE5D, text_category::RTL },
			{ 0x1EE5E, text_category::Unknown },
			{ 0x1EE5F, text_category::RTL },
			{ 0x1EE60, text_category::Unknown },
			{ 0x1EE61, text_category::RTL },
			{ 0x1EE63, text_category::Unknown },
			{ 0x1EE64, text_category::RTL },
			{ 0x1EE65, text_category::Unknown },
			{ 0x1EE67, text_category::RTL },
			{ 0x1EE6B, text_category::Unknown },
			{ 0x1EE6C, text_category::RTL },
			{ 0x1EE73, text_category::Unknown },
			{ 0x1EE74, text_category::RTL },
			{ 0x1EE78, text_category::Unknown },
			{ 0x1EE79, text_category::RTL },
			{ 0x1EE7D, text_category::Unknown },
			{ 0x1EE7E, text_category::RTL },
			{ 0x1EE7F, text_category::Unknown },
			{ 0x1EE80, text_category::RTL },
			{ 0x1EE8A, text_category::Unknown },
			{ 0x1EE8B, text_category::RTL },
			{ 0x1EE9C, text_category::Unknown },
			{ 0x1EEA1, text_category::RTL },
			{ 0x1EEA4, text_category::Unknown },
			{ 0x1EEA5, text_category::RTL },
			{ 0x1EEAA, text_category::Unknown },
			{ 0x1EEAB, text_category::RTL },
			{ 0x1EEBC, text_category::Unknown },
			{ 0x1EEF0, text_category::None },
			{ 0x1EEF2, text_category::Unknown },
			{ 0x1F000, text_category::None },
			{ 0x1F02C, text_category::Unknown },
			{ 0x1F030, text_category::None },
			{ 0x1F094, text_category::Unknown },
			{ 0x1F0A0, text_category::None },
			{ 0x1F0AF, text_category::Unknown },
			{ 0x1F0B1, text_category::None },
			{ 0x1F0C0, text_category::Unknown },
			{ 0x1F0C1, text_category::None },
			{ 0x1F0D0, text_category::Unknown },
			{ 0x1F0D1, text_category::None },
			{ 0x1F0F6, text_category::Unknown },
			{ 0x1F100, text_category::Digit },
			{ 0x1F10B, text_category::None },
			{ 0x1F110, text_category::LTR },
			{ 0x1F12F, text_category::None },
			{ 0x1F130, text_category::LTR },
			{ 0x1F16A, text_category::None },
			{ 0x1F170, text_category::LTR },
			{ 0x1F1AD, text_category::None },
			{ 0x1F1AE, text_category::Unknown },
			{ 0x1F1E6, text_category::LTR },
			{ 0x1F203, text_category::Unknown },
			{ 0x1F210, text_category::LTR },
			{ 0x1F23C, text_category::Unknown },
			{ 0x1F240, text_category::LTR },
			{ 0x1F249, text_category::Unknown },
			{ 0x1F250, text_category::LTR },
			{ 0x1F252, text_category::Unknown },
			{ 0x1F260, text_category::None },
			{ 0x1F266, text_category::Unknown },
			{ 0x1F300, text_category::None },
			{ 0x1F6D8, text_category::Unknown },
			{ 0x1F6DC, text_category::None },
			{ 0x1F6ED, text_category::Unknown },
			{ 0x1F6F0, text_category::None },
			{ 0x1F6FD, text_category::Unknown },
			{ 0x1F700, text_category::None },
			{ 0x1F777, text_category::Unknown },
			{ 0x1F77B, text_category::None },
			{ 0x1F7DA, text_category::Unknown },
			{ 0x1F7E0, text_category::None },
			{ 0x1F7EC, text_category::Unknown },
			{ 0x1F7F0, text_category::None },
			{ 0x1F7F1, text_category::Unknown },
			{ 0x1F800, text_category::None },
			{ 0x1F80C, text_category::Unknown },
			{ 0x1F810, text_category::None },
			{ 0x1F848, text_category::Unknown },
			{ 0x1F850, text_category::None },
			{ 0x1F85A, text_category::Unknown },
			{ 0x1F860, text_category::None },
			{ 0x1F888, text_category::Unknown },
			{ 0x1F890, text_category::None },
			{ 0x1F8AE, text_category::Unknown },
			{ 0x1F8B0, text_category::None },
			{ 0x1F8B2, text_category::Unknown },
			{ 0x1F900, text_category::None },
			{ 0x1FA54, text_category::Unknown },
			{ 0x1FA60, text_category::None },
			{ 0x1FA6E, text_category::Unknown },
			{ 0x1FA70, text_category::None },
			{ 0x1FA7D, text_category::Unknown },
			{ 0x1FA80, text_category::None },
			{ 0x1FA89, text_category::Unknown },
			{ 0x1FA90, text_category::None },
			{ 0x1FABE, text_category::Unknown },
			{ 0x1FABF, text_category::None },
			{ 0x1FAC6, text_category::Unknown },
			{ 0x1FACE, text_category::None },
			{ 0x1FADC, text_category::Unknown },
			{ 0x1FAE0, text_category::None },
			{ 0x1FAE9, text_category::Unknown },
			{ 0x1FAF0, text_category::None },
			{ 0x1FAF9, text_category::Unknown },
			{ 0x1FB00, text_category::None },
			{ 0x1FB93, text_category::Unknown },
			{ 0x1FB94, text_category::None },
			{ 0x1FBCB, text_category::Unknown },
			{ 0x1FBF0, text_category::Digit },
			{ 0x1FBFA, text_category::Unknown },
			{ 0x20000, text_category::LTR },
			{ 0x20001, text_category::Unknown },
			{ 0x2A6DF, text_category::LTR },
			{ 0x2A6E0, text_category::Unknown },
			{ 0x2A700, text_category::LTR },
			{ 0x2A701, text_category::Unknown },
			{ 0x2B739, text_category::LTR },
			{ 0x2B73A, text_category::Unknown },
			{ 0x2B740, text_category::LTR },
			{ 0x2B741, text_category::Unknown },
			{ 0x2B81D, text_category::LTR },
			{ 0x2B81E, text_category::Unknown },
			{ 0x2B820, text_category::LTR },
			{ 0x2B821, text_category::Unknown },
			{ 0x2CEA1, text_category::LTR },
			{ 0x2CEA2, text_category::Unknown },
			{ 0x2CEB0, text_category::LTR },
			{ 0x2CEB1, text_category::Unknown },
			{ 0x2EBE0, text_category::LTR },
			{ 0x2EBE1, text_category::Unknown },
			{ 0x2EBF0, text_category::LTR },
			{ 0x2EBF1, text_category::Unknown },
			{ 0x2EE5D, text_category::LTR },
			{ 0x2EE5E, text_category::Unknown },
			{ 0x2F800, text_category::LTR },
			{ 0x2FA1E, text_category::Unknown },
			{ 0x30000, text_category::LTR },
			{ 0x30001, text_category::Unknown },
			{ 0x3134A, text_category::LTR },
			{ 0x3134B, text_category::Unknown },
			{ 0x31350, text_category::LTR },
			{ 0x31351, text_category::Unknown },
			{ 0x323AF, text_category::LTR },
			{ 0x323B0, text_category::Unknown },
			{ 0xE0001, text_category::Whitespace },
			{ 0xE0002, text_category::Unknown },
			{ 0xE0020, text_category::Whitespace },
			{ 0xE0080, text_category::Unknown },
			{ 0xE0100, text_category::Mark },
			{ 0xE01F0, text_category::Unknown },
			{ 0xF0000, text_category::LTR },
			{ 0xF0001, text_category::Unknown },
			{ 0xFFFFD, text_category::LTR },
			{ 0xFFFFE, text_category::Unknown },
			{ 0x100000, text_category::LTR },
			{ 0x100001, text_category::Unknown },
			{ 0x10FFFD, text_category::LTR }, 
		};
    }

    inline text_category get_text_category(const i_emoji_atlas& aEmojiAtlas, const char32_t* aCodePoint, const char32_t* aCodePointEnd)
    {
        char32_t ch = aCodePoint[0];
        if (aEmojiAtlas.is_emoji(ch))
            return text_category::Emoji;
        else if (ch == 0xFE0F || ch == 0xFE0E)
            return text_category::Control;
        const detail::text_category_MAP_VALUE_TYPE* rangeStart = std::lower_bound(
            &detail::text_category_MAP[0], 
            &detail::text_category_MAP[0] + sizeof(detail::text_category_MAP) / sizeof(detail::text_category_MAP[0]),
            detail::text_category_MAP_VALUE_TYPE(ch, text_category::Unknown),
            [](const detail::text_category_MAP_VALUE_TYPE& lhs, const detail::text_category_MAP_VALUE_TYPE& rhs) -> bool
        {
            return lhs.first < rhs.first;
        });
        if (rangeStart != &detail::text_category_MAP[0] && ch < rangeStart->first)
            --rangeStart;
        return rangeStart->second;
    }

    inline text_category get_text_category(const i_emoji_atlas& aEmojiAtlas, char32_t aCodePoint)
    {
        return get_text_category(aEmojiAtlas, &aCodePoint, &aCodePoint + 1);
    }

    inline text_direction get_text_direction(const i_emoji_atlas& aEmojiAtlas, const char32_t* aCodePoint, const char32_t* aCodePointEnd, std::optional<text_direction> aLineDirection = std::nullopt, std::optional<text_direction> aCurrentDirection = std::nullopt)
    {
        if (aCodePoint != aCodePointEnd)
        {
            if (*aCodePoint != U'\r' && *aCodePoint != U'\n' && aLineDirection && aLineDirection.value() == text_direction::RTL)
            {
                if (get_text_category(aEmojiAtlas, aCodePoint, aCodePointEnd) != text_category::LTR)
                    return text_direction::RTL;
            }
            auto nextCodePoint = aCodePoint;
            while (nextCodePoint != aCodePointEnd)
            {
                switch (get_text_category(aEmojiAtlas, nextCodePoint, aCodePointEnd))
                {
                case text_category::LTR:
                    return text_direction::LTR;
                case text_category::RTL:
                    return text_direction::RTL;
                case text_category::Mark:
                    if (aCurrentDirection)
                        return aCurrentDirection.value();
                    break;
                case text_category::Whitespace:
                case text_category::None:
                    if (aCurrentDirection && aCurrentDirection.value() == text_direction::LTR)
                        return text_direction::LTR;
                    break;
                default:
                    break;
                }
                ++nextCodePoint;
            }
        }
        return aCurrentDirection ? aCurrentDirection.value() : aLineDirection ? aLineDirection.value() : text_direction::LTR;
    }

    inline text_direction get_text_direction(const i_emoji_atlas& aEmojiAtlas, char32_t aCodePoint, std::optional<text_direction> aLineDirection = std::nullopt, std::optional<text_direction> aCurrentDirection = std::nullopt)
    {
        return get_text_direction(aEmojiAtlas, &aCodePoint, &aCodePoint + 1, aLineDirection, aCurrentDirection);
    }
}