#include "base_test.hpp"
#include "logical_query_plan/insert_node.hpp"
#include "logical_query_plan/lqp_utils.hpp"

namespace hyrise {

class InsertNodeTest : public BaseTest {
 protected:
  void SetUp() override {
    _insert_node = InsertNode::make("table_a");
  }

  std::shared_ptr<InsertNode> _insert_node;
};

TEST_F(InsertNodeTest, Description) {
  EXPECT_EQ(_insert_node->description(), "[Insert] Into table 'table_a'");
}

TEST_F(InsertNodeTest, TableName) {
  EXPECT_EQ(_insert_node->table_name, "table_a");
}

TEST_F(InsertNodeTest, HashingAndEqualityCheck) {
  EXPECT_EQ(*_insert_node, *_insert_node);
  EXPECT_EQ(*_insert_node, *InsertNode::make("table_a"));
  EXPECT_NE(*_insert_node, *InsertNode::make("table_b"));

  EXPECT_EQ(_insert_node->hash(), InsertNode::make("table_a")->hash());
  EXPECT_NE(_insert_node->hash(), InsertNode::make("table_b")->hash());
}

TEST_F(InsertNodeTest, NodeExpressions) {
  EXPECT_TRUE(_insert_node->node_expressions.empty());
}

TEST_F(InsertNodeTest, ColumnExpressions) {
  EXPECT_TRUE(_insert_node->output_expressions().empty());
}

TEST_F(InsertNodeTest, NoUniqueColumnCombinations) {
  EXPECT_THROW(_insert_node->unique_column_combinations(), std::logic_error);
}

TEST_F(InsertNodeTest, NoOrderDependencies) {
  EXPECT_THROW(_insert_node->order_dependencies(), std::logic_error);
}

}  // namespace hyrise
