#include "drop_view_node.hpp"

#include <cstddef>
#include <memory>
#include <string>

#include <boost/container_hash/hash.hpp>

#include "logical_query_plan/abstract_lqp_node.hpp"
#include "logical_query_plan/abstract_non_query_node.hpp"

namespace hyrise {

DropViewNode::DropViewNode(const std::string& init_view_name, const bool init_if_exists)
    : AbstractNonQueryNode(LQPNodeType::DropView), view_name(init_view_name), if_exists(init_if_exists) {}

std::string DropViewNode::description(const DescriptionMode /*mode*/) const {
  return std::string{"[Drop] View: '"} + view_name + "'";
}

size_t DropViewNode::_on_shallow_hash() const {
  auto hash = size_t{0};
  boost::hash_combine(hash, view_name);
  boost::hash_combine(hash, if_exists);
  return hash;
}

std::shared_ptr<AbstractLQPNode> DropViewNode::_on_shallow_copy(LQPNodeMapping& /*node_mapping*/) const {
  return DropViewNode::make(view_name, if_exists);
}

bool DropViewNode::_on_shallow_equals(const AbstractLQPNode& rhs, const LQPNodeMapping& /*node_mapping*/) const {
  const auto& drop_view_node = static_cast<const DropViewNode&>(rhs);
  return view_name == drop_view_node.view_name && if_exists == drop_view_node.if_exists;
}

}  // namespace hyrise
