#pragma once

#include <sstream>
#include <string>
#include <vector>

namespace hyrise {

/*
 * Class to display a given stringstream input using pagination in style of the UNIX 'less' command.
 */
class Pagination {
 public:
  explicit Pagination(std::stringstream& input);

  /*
   * Opens an ncurses environment in which the content is printed.
   * User can navigate through the table with the keyboard (ARROW KEYS, PAGE UP/DOWN, etc.),
   * and quit by pressing 'q'.
   */
  void display();

  /*
   * This calls ungetch() to push the character for CTRL_C into the input queue.
   */
  static void push_ctrl_c();

 protected:
  /*
   * Prints a number of lines to fill the current terminal screen.
   *
   * @param first_line Line which should be started from, i.e. which will be the first line on the screen.
   * @param first_column column which should be started from, i.e. which will be the first column on the screen.
   */
  void _print_page(size_t first_line, size_t first_column);

  /*
   * Prints the help screen, which shows all available commands.
   * The help screen is displayed on a separate ncurses window. When the help screen is closed (by pressing 'q'),
   * the separate window gets destroyed, and the previous contend is restored, showing the table as before.
   */
  static void _print_help_screen();

  std::vector<std::string> _lines;
  size_t _size_x{0};
  size_t _size_y{0};
  size_t _max_width{0};
  size_t _step_size_x{5};
};

}  // namespace hyrise
